/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerWriteInteger;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.admin.Permission;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CarteItemInfo;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ItemIngredientInfo;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductPriceInfo;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.ScreenProduct;
import com.openbravo.pos.ticket.ScreenSupplementInfo;
import com.openbravo.pos.ticket.ScreenSupplementItem;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementPriceInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.ZoneInfo;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.service.ItemService;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.StaticSentence;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import fr.protactile.procaisse.dao.entities.NutrientData;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.services.AllergeneSupplementServices;
import fr.protactile.procaisse.services.LanguageService;
import fr.protactile.procaisse.services.LocalScreenService;
import fr.protactile.procaisse.services.MultiLanguageCarteService;
import fr.protactile.procaisse.services.MultiLanguageCategoryService;
import fr.protactile.procaisse.services.MultiLanguageGSSService;
import fr.protactile.procaisse.services.MultiLanguagePromotionService;
import fr.protactile.procaisse.services.MultiLanguageSupplementItemService;
import fr.protactile.procaisse.services.MultiLanguageSupplementService;
import fr.protactile.procaisse.services.NutrientDataService;
import fr.protactile.procaisse.services.TagsService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class DataLogicSynchronisation
extends BeanFactoryDataSingle {
    protected Session s;
    protected PreparedStatement pstmt;
    private double rate_tax = 0.055;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private DataLogicSales m_dlSales = null;
    private DataLogicItems m_dlItems = null;
    private DataLogicProduct dlProduct = null;
    private List<CategoryInfo> all_categories;
    private List<CategoryInfo> categories_menu;
    private DataLogicAdmin dlUser;
    private List<String> ids_user;
    private List<ProductInfoExt> products;
    private List<SupplementItemInfo> supplements;
    private boolean remote_synchro;
    private HashMap<String, Integer> ids_produts;
    private boolean synchronize_printers;
    private HashMap<Integer, PrinterInfo> printers;
    private boolean synchronize_screens;
    private LocalScreenService mLocalScreenService;
    private List<Integer> tariffs;
    private TagsService mTagsService;
    private HashMap<String, Integer> ids_groupeOptions;
    private HashMap<String, Integer> ids_groupeSubOptions;
    private HashMap<String, Integer> ids_options;
    private HashMap<String, Integer> ids_promotions;
    private HashMap<String, Integer> ids_cartes;
    private boolean merge;
    private ItemService mItemService;
    private MultiLanguageCarteService multiLanguageCarteService;
    private MultiLanguageCategoryService multiLanguageCategoryService;
    private MultiLanguageSupplementService multiLanguageSupplementService;
    private MultiLanguageSupplementItemService multiLanguageSupplementItemService;
    private MultiLanguageGSSService multiLanguageGSSService;
    private MultiLanguagePromotionService multiLanguagePromotionService;
    private LanguageService languageService;
    private AllergeneSupplementServices mAllergeneSupplementServices;

    public DataLogicSynchronisation() throws SQLException {
        this.initializer();
        this.m_dlSales = new DataLogicSales();
        this.dlProduct = new DataLogicProduct();
        this.m_dlItems = new DataLogicItems();
        this.all_categories = new ArrayList<CategoryInfo>();
        this.categories_menu = new ArrayList<CategoryInfo>();
        this.products = new ArrayList<ProductInfoExt>();
        this.ids_produts = new HashMap();
        this.ids_groupeOptions = new HashMap();
        this.ids_groupeSubOptions = new HashMap();
        this.ids_options = new HashMap();
        this.ids_promotions = new HashMap();
        this.ids_cartes = new HashMap();
        this.dlUser = new DataLogicAdmin();
        this.ids_user = new ArrayList<String>();
        this.ids_user.add("0");
        this.ids_user.add("1");
        this.ids_user.add("2");
        this.supplements = new ArrayList<SupplementItemInfo>();
        this.mLocalScreenService = LocalScreenService.getInstance();
        this.mTagsService = TagsService.getInstance();
        this.tariffs = new ArrayList<Integer>();
        this.tariffs.add(1);
        this.tariffs.add(2);
        this.tariffs.add(3);
    }

    public DataLogicSynchronisation(String db_url, String db_user, String db_password) throws SQLException {
        this.initConnection(db_url, db_user, db_password);
    }

    private void initConnection(String db_url, String db_user, String db_password) throws SQLException {
    }

    private void initializer() throws SQLException {
        String db_url = AppLocal.db_url;
        this.initConnection(db_url, "APP", "protactilepa42");
    }

    @Override
    public void init(Session s) {
        this.s = s;
        if (this.m_dlSales != null) {
            this.m_dlSales.init(s);
        }
        if (this.dlProduct != null) {
            this.dlProduct.init(s);
        }
        if (this.dlUser != null) {
            this.dlUser.init(s);
        }
        if (this.m_dlItems != null) {
            this.m_dlItems.init(s);
        }
        this.multiLanguageCarteService = MultiLanguageCarteService.getInstance();
        this.multiLanguageCategoryService = MultiLanguageCategoryService.getInstance();
        this.multiLanguageSupplementService = MultiLanguageSupplementService.getInstance();
        this.multiLanguageSupplementItemService = MultiLanguageSupplementItemService.getInstance();
        this.multiLanguageGSSService = MultiLanguageGSSService.getInstance();
        this.multiLanguagePromotionService = MultiLanguagePromotionService.getInstance();
        this.mAllergeneSupplementServices = AllergeneSupplementServices.getInstance();
    }

    public final int getCategory(CategoryInfo categoryInfo) throws BasicException {
        String idSynchro = this.getIdSynchCategory(categoryInfo);
        String DB_COLUMN_TO_CKECK = categoryInfo.getId_global() != null && !categoryInfo.getId_global().isEmpty() ? "ID_GLOBAL" : "REF_WEB";
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM CATEGORIES WHERE " + DB_COLUMN_TO_CKECK + " = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idSynchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final int getPrinter(PrinterInfo printer) throws BasicException {
        if (printer != null) {
            if (this.remote_synchro) {
                Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM PRINTER WHERE NUMBER_PRINTER = ? ", SerializerWriteInteger.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)printer.getId());
                return iD != null ? (Integer)iD[0] : -1;
            }
            String request = this.synchronize_printers ? "SELECT ID FROM PRINTER WHERE REF_WEB = ? " : "SELECT ID FROM PRINTER WHERE NAME = ? ";
            String param = this.synchronize_printers ? printer.getRef_synchro() : printer.getName();
            Object[] iD = (Object[])new StaticSentence(this.s, request, SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)param);
            return iD != null ? (Integer)iD[0] : -1;
        }
        return -1;
    }

    public final int getGOption(SupplementInfo groupOption) throws BasicException {
        String DB_COLUMN_TO_CHECK;
        String idSynchro = this.getIdSynchGroupOption(groupOption);
        String string = DB_COLUMN_TO_CHECK = groupOption.getId_global() != null && !groupOption.getId_global().isEmpty() ? "ID_GLOBAL" : "REF_WEB";
        if (this.merge) {
            Integer idGOption = this.ids_groupeOptions.get(idSynchro);
            return idGOption != null ? idGOption : -1;
        }
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT id FROM supplement WHERE " + DB_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idSynchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final int getOption(SupplementItemInfo option) throws BasicException {
        String DB_COLUMN_TO_CHECK;
        String idSynchro = this.getIdSynchOption(option);
        String string = DB_COLUMN_TO_CHECK = option.getId_global() != null && !option.getId_global().isEmpty() ? "ITEM_PLU" : "REF_WEB";
        if (this.merge) {
            Integer idOption = this.ids_options.get(idSynchro);
            return idOption != null ? idOption : -1;
        }
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT id FROM supplement_item WHERE  " + DB_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idSynchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final int getCarte(CarteInfo carteInfo) throws BasicException {
        String DB_COLUMN_TO_CHECK;
        String idSynchro = this.getIdSynchCarte(carteInfo);
        String string = DB_COLUMN_TO_CHECK = carteInfo.getId_global() != null && !carteInfo.getId_global().isEmpty() ? "ID_GLOBAL" : "REF_WEB";
        if (this.merge) {
            Integer idCarte = this.ids_cartes.get(idSynchro);
            return idCarte != null ? idCarte : -1;
        }
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT id FROM carte WHERE " + DB_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idSynchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final String getRefGOption(int idGOption) throws BasicException {
        Object[] ref = (Object[])new StaticSentence(this.s, "SELECT REF_WEB  FROM supplement WHERE id = ? ", SerializerWriteInteger.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)idGOption);
        return ref == null ? null : (String)ref[0];
    }

    public void addGroupeOption(SupplementInfo groupeOption) throws BasicException, SQLException {
        int idPrinter = groupeOption.getPrinter();
        if (idPrinter != -1) {
            idPrinter = this.getPrinter(this.printers.get(idPrinter));
        }
        groupeOption.setRef_web(String.valueOf(groupeOption.getiD()));
        groupeOption = this.m_dlSales.addGroupeOption(groupeOption, false);
        if (this.merge) {
            this.ids_groupeOptions.put(this.getIdSynchGroupOption(groupeOption), groupeOption.getiD());
        }
        this.addGroupeOptionSync(idPrinter, groupeOption);
        if (groupeOption.getScreens() != null && groupeOption.getScreens().size() > 0) {
            for (ScreenSupplementInfo screenOption : groupeOption.getScreens()) {
                screenOption.setId_supplement(groupeOption.getiD());
                this.addScreenGroupeSupplement(screenOption);
            }
        }
        for (SupplementItemInfo item : groupeOption.getItems()) {
            item.setId_supplement(groupeOption.getiD());
            item.setRef_web(String.valueOf(item.getiD()));
            if (item.isRemoved()) continue;
            this.addOption(item);
        }
        this.multiLanguageSupplementService.setMultiLanguagesSupplement(groupeOption.getMultiLanguageTexts(), groupeOption.getiD());
    }

    public int addCategory(CategoryInfo category) throws BasicException, SQLException {
        if (!this.merge) {
            category.setRef_web(String.valueOf(category.getID()));
        }
        if ((category = this.m_dlItems.addCategory(category, true)).getTags() != null && category.getTags().size() > 0) {
            for (TagInfo tag : category.getTags()) {
                TagInfo tagInfo = this.mTagsService.findByNumber(tag.getNumber());
                if (tagInfo == null) continue;
                tag.setId(tagInfo.getId());
                tag.setName(tagInfo.getName());
                this.m_dlItems.addTagCategory(tag, category.getID());
            }
        }
        for (ProductInfoExt product : category.getProducts()) {
            product.setCategoryid(category.getID());
            if (product.isRemoved()) continue;
            this.persistProduct(product, category);
        }
        this.m_dlItems.persistCategoryDaysOn(category);
        this.m_dlItems.persistShiftCategories(category);
        this.multiLanguageCategoryService.setMultiLanguagesCategory(category.getMultiLanguageTexts(), category.getID());
        return category.getID();
    }

    public final void addProduct(ProductInfoExt product) throws BasicException, SQLException {
        ZoneInfo mZinfos;
        if (this.remote_synchro) {
            product.setSold_out(false);
        }
        if (product.getZoneId() != null && (mZinfos = this.m_dlSales.getZoneInfoByref_id(product.getZoneId())) != null) {
            product.setZoneId(mZinfos.getId());
        }
        int id_Product = this.m_dlItems.addItemProduct(product);
        product.setID(id_Product);
        this.ids_produts.put(this.getIdSynchProduct(product), product.getID());
        this.products.add((ProductInfoExt)product.clone());
        this.addProcudtSync(product);
        if (product.getPrinterID() != -1) {
            this.addPrinterProduct(product);
        }
        if (product.getPrinterLabel() != -1) {
            this.addPrinterLabel(product);
        }
        if (product.getDisplayKitchen() != -1) {
            this.addDisplayKitchen(product);
        }
        if (product.getListSizes() != null && product.getListSizes().size() > 0) {
            for (ProductSizeInfo productSize : product.getListSizes()) {
                productSize.setIdProduct(id_Product);
                if (!this.merge) {
                    productSize.setRef_synchro(String.valueOf(productSize.getID()));
                }
                this.m_dlItems.addProduct_Size(productSize);
            }
        }
        if (product.getItemIngredients() != null && product.getItemIngredients().size() > 0) {
            for (ItemIngredientInfo ingredient : product.getItemIngredients()) {
                ingredient.setId_item(id_Product);
                this.addIngredientProduct(ingredient);
            }
        }
        if (product.getSupplements() != null && product.getSupplements().size() > 0) {
            for (SupplementProduct supplement : product.getSupplements()) {
                this.addSupplementProduct(supplement, id_Product);
            }
        }
        if (this.synchronize_screens && product.getScreens() != null && product.getScreens().size() > 0) {
            for (ScreenProduct screenProduct : product.getScreens()) {
                screenProduct.setId_product(id_Product);
                LocalScreen localScreen = this.mLocalScreenService.findByNumber(screenProduct.getNumber_screen());
                if (localScreen == null) continue;
                screenProduct.setId_screen(localScreen.getId());
                screenProduct.setName_screen(localScreen.getName());
                this.m_dlItems.addScreenProduct(screenProduct);
            }
        }
        if (product.getPromotions() != null && product.getPromotions().size() > 0) {
            for (PromotionInfo promotion : product.getPromotions()) {
                this.addPromotionProduct(promotion, id_Product);
            }
        }
        if (product.getPrices() != null && product.getPrices().size() > 0) {
            for (ProductPriceInfo productPrice : product.getPrices()) {
                productPrice.setIdProduct(id_Product);
                this.m_dlItems.addProductPrice(productPrice);
            }
        }
        this.m_dlItems.addProductDaysOn(product);
        this.m_dlItems.persistShiftProducts(product);
        this.m_dlItems.updateImagesProduct(product);
        this.m_dlItems.updateMultiLanguagesProduct(product);
        this.m_dlItems.updateNutritional(product);
        this.m_dlItems.updateAllergenes(product);
    }

    private void updateSupplementProduct(SupplementProduct option, int idProduct) throws BasicException {
        int idGOption = this.getGOption(option);
        if (idGOption != -1) {
            option.setiD(idGOption);
            this.m_dlSales.updateItemSupplement(option, idProduct);
        }
    }

    private void addSupplementProduct(SupplementProduct option, int idProduct) throws BasicException {
        int idGOption = this.getGOption(option);
        if (idGOption != -1) {
            option.setiD(idGOption);
            this.m_dlSales.addItemSupplement(option, idProduct);
        }
    }

    private void addIngredientProduct(final ItemIngredientInfo itemIngredient) throws BasicException {
        final int idOption = this.getItemIngredient(itemIngredient);
        if (idOption != -1) {
            new PreparedSentence(this.s, "INSERT INTO ITEM_INGREDIENTS (id_supplement_item, id_item, quantity) VALUES (?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, idOption);
                    this.setInt(2, itemIngredient.getId_item());
                    this.setInt(3, itemIngredient.getQuantity());
                }
            });
        }
    }

    private void addCarteMenu(CarteOrderInfo carte, int idProduct) throws BasicException {
        int idCarte = this.getCarte(carte);
        if (idCarte != -1) {
            carte.setId(idCarte);
            this.m_dlSales.addCarteMenu(carte, idProduct);
        }
    }

    private void updateCarteMenu(final CarteOrderInfo carte, final int idProduct) throws BasicException {
        final int idCarte = this.getCarte(carte);
        if (idCarte != -1) {
            new PreparedSentence(this.s, "UPDATE CARTE_MENU SET carteOrder = ?, number_carte = ? WHERE id_carte = ? AND id_item = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, carte.getOrderCarte());
                    this.setInt(2, carte.getNumber_carte());
                    this.setInt(3, idCarte);
                    this.setInt(4, idProduct);
                }
            });
        }
    }

    public final void addCarte(CarteInfo carte) throws BasicException, SQLException {
        String ref_web = String.valueOf(carte.getId());
        String SQL = "INSERT INTO CARTE (name, sizeCarte, removed, REF_WEB, ID_GLOBAL) VALUES (?,?,?,?,?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, carte.getName());
        this.pstmt.setString(2, carte.getSizeCarte());
        this.pstmt.setBoolean(3, carte.isRemoved());
        this.pstmt.setString(4, String.valueOf(carte.getId()));
        this.pstmt.setString(5, carte.getId_global());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idCarte = -1;
        if (rs.next()) {
            int last_inserted_id;
            idCarte = last_inserted_id = rs.getInt(1);
        }
        carte.setId(idCarte);
        if (!this.merge) {
            this.ids_cartes.put(ref_web, idCarte);
        }
        this.m_dlSales.setIdGlobalItem(idCarte, "CARTE", "ID_GLOBAL", carte.getId_global());
        for (CarteItemInfo carteItem : carte.getCarteItems()) {
            carteItem.setId_carte(idCarte);
            this.addCarteItem(carteItem);
        }
        this.multiLanguageCarteService.setMultiLanguagesCarte(carte.getMultiLanguageTexts(), carte.getId());
    }

    private void addCarteItem(final CarteItemInfo item) throws BasicException {
        final int idItem = this.getProductID(item);
        if (idItem != -1) {
            new PreparedSentence(this.s, "INSERT INTO CARTE_ITEM (id_carte, id_item, price, order_item) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, item.getId_carte());
                    this.setInt(2, idItem);
                    this.setDouble(3, item.getPrice());
                    this.setInt(4, item.getOrder_item());
                }
            });
        }
    }

    private void updateOption(final SupplementItemInfo option) throws BasicException, SQLException {
        this.m_dlItems.updateOption(option, true);
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT_ITEM SET removed = ?, order_item = ?, REMOVED_BY_ADMIN = ?, HIDDEN = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, option.isRemoved());
                this.setInt(2, option.getOrderItem());
                this.setBoolean(3, option.isRemoved_by_admin());
                this.setBoolean(4, option.isHidden());
                this.setInt(5, option.getiD());
            }
        });
        this.m_dlSales.setIdGlobalItem(option.getiD(), "SUPPLEMENT_ITEM", "ITEM_PLU", option.getId_global());
        this.changeScreenSupplement(option);
        this.persistSupplementPrice(option);
        this.persistSupplementGroup(option);
        this.multiLanguageSupplementItemService.setMultiLanguagesSupplementItem(option.getMultiLanguageTexts(), option.getiD());
        this.mAllergeneSupplementServices.setAllergeneSupplements(option.getAllergenes(), option.getiD());
    }

    public final void updateGroupeOption(final SupplementInfo groupeOption) throws BasicException, SQLException {
        final int idPrinter = groupeOption.getPrinter() != -1 ? this.getPrinter(this.printers.get(groupeOption.getPrinter())) : groupeOption.getPrinter();
        this.m_dlItems.updateGroupeOption(groupeOption, false);
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT SET order_supplement = ?, removed = ?, printer = ?, REMOVED_BY_ADMIN = ?, is_ingredient = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, groupeOption.getOrderSupplement());
                this.setBoolean(2, groupeOption.isRemoved());
                this.setInt(3, idPrinter);
                this.setBoolean(4, groupeOption.isRemoved_by_admin());
                this.setBoolean(5, groupeOption.getIs_ingredient());
                this.setInt(6, groupeOption.getiD());
            }
        });
        this.m_dlSales.setIdGlobalItem(groupeOption.getiD(), "SUPPLEMENT", "ID_GLOBAL", groupeOption.getId_global());
        for (SupplementItemInfo item : groupeOption.getItems()) {
            item.setId_supplement(groupeOption.getiD());
            this.persistOption(item);
        }
        this.changeScreenGSupplement(groupeOption);
        this.multiLanguageSupplementService.setMultiLanguagesSupplement(groupeOption.getMultiLanguageTexts(), groupeOption.getiD());
    }

    private void persistOption(SupplementItemInfo item) throws BasicException, SQLException {
        String nameByLanguage;
        if (!(AppLocal.APP_LANGUAGE == null || AppLocal.APP_LANGUAGE.isEmpty() || (nameByLanguage = item.getNameByLanguage(AppLocal.APP_LANGUAGE)) == null || nameByLanguage.isEmpty() || item.getName() != null && nameByLanguage.equalsIgnoreCase(item.getName()))) {
            item.setName(nameByLanguage);
        }
        item.setRef_web(String.valueOf(item.getiD()));
        SupplementItemInfo oldOption = this.m_dlItems.getOption(item);
        int idItem = this.getOption(item);
        if (idItem != -1) {
            item.setiD(idItem);
            if (this.remote_synchro && oldOption != null) {
                item.setSold_out(oldOption.isSold_out());
            }
            this.supplements.add((SupplementItemInfo)item.clone());
            this.updateOption(item);
        } else if (!item.isRemoved_by_admin()) {
            this.addOption(item);
        }
    }

    private void persistProduct(ProductInfoExt product, CategoryInfo category) throws BasicException, SQLException {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            String nameByLanguage = product.getNameByLanguage(AppLocal.APP_LANGUAGE);
            String descriptionByLanguage = product.getDescriptionByLanguage(AppLocal.APP_LANGUAGE);
            String descriptionPlatformByLanguage = product.getDescriptionPlatformByLanguage(AppLocal.APP_LANGUAGE);
            if (!(nameByLanguage == null || nameByLanguage.isEmpty() || product.getName() != null && nameByLanguage.equalsIgnoreCase(product.getName()))) {
                product.setName(nameByLanguage);
            }
            if (!(descriptionByLanguage == null || descriptionByLanguage.isEmpty() || product.getDescription() != null && descriptionByLanguage.equalsIgnoreCase(product.getDescription()))) {
                product.setDescription(descriptionByLanguage);
            }
            if (!(descriptionPlatformByLanguage == null || descriptionPlatformByLanguage.isEmpty() || product.getDescription_uberEat() != null && descriptionPlatformByLanguage.equalsIgnoreCase(product.getDescription_uberEat()))) {
                product.setDescription_uberEat(descriptionPlatformByLanguage);
            }
        }
        if (this.merge) {
            if (!product.isRemoved_by_admin()) {
                this.addProduct(product);
            }
        } else {
            int idProduct;
            ProductInfoExt oldProduct = this.m_dlItems.getProduct(product);
            int n = idProduct = oldProduct != null ? oldProduct.getID() : -1;
            if (idProduct != -1) {
                if (this.remote_synchro) {
                    product.setSold_out(oldProduct.isSold_out());
                }
                if (!AppLocal.DOWNLOAD_TVA_ITEMS) {
                    product.setTaxCategoryID(oldProduct.getTaxCategoryID());
                    product.setTaxemp(oldProduct.getTaxemp());
                    product.setTaxlv(oldProduct.getTaxlv());
                }
                product.setID(idProduct);
                this.ids_produts.put(this.getIdSynchProduct(product), product.getID());
                this.products.add((ProductInfoExt)product.clone());
                this.updateProduct(product);
            } else if (!product.isRemoved_by_admin()) {
                this.addProduct(product);
            }
        }
        if (!this.remote_synchro) {
            this.updatePromoBasket(product);
        }
    }

    public final void updateProduct(final ProductInfoExt product) throws BasicException, SQLException {
        ZoneInfo mZinfos;
        if (product.getZoneId() != null && (mZinfos = this.m_dlSales.getZoneInfoByref_id(product.getZoneId())) != null) {
            product.setZoneId(mZinfos.getId());
        }
        this.m_dlItems.updateItemProduct(product);
        this.updateProcudtSync(product);
        if (product.getPrinterID() != -1) {
            this.addPrinterProduct(product);
        } else {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printer = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, null);
                    this.setInt(2, product.getID());
                }
            });
        }
        if (product.getPrinterLabel() != -1) {
            this.addPrinterLabel(product);
        } else {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printerLabel = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, null);
                    this.setInt(2, product.getID());
                }
            });
        }
        if (product.getDisplayKitchen() != -1) {
            this.addDisplayKitchen(product);
        } else {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET display_kitchen = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, null);
                    this.setInt(2, product.getID());
                }
            });
        }
        this.m_dlSales.setIdGlobalItem(product.getID(), "PRODUCTS", "PRODUCT_PLU", product.getId_global());
        this.changeSizeOfProduct(product);
        this.changeIngredientOfProduct(product);
        this.changeOptionsOfProduct(product);
        if (this.synchronize_screens) {
            this.changeScreenProduct(product);
        }
        this.persistPromotionsProduct(product);
        this.m_dlItems.persistProductDaysOn(product);
        this.m_dlItems.persistShiftProducts(product);
        this.changePricesOfProduct(product);
        this.m_dlItems.updateImagesProduct(product);
        this.m_dlItems.updateMultiLanguagesProduct(product);
        this.m_dlItems.updateNutritional(product);
        this.m_dlItems.updateAllergenes(product);
    }

    private void addProcudtSync(final ProductInfoExt product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET color = ?, hidden = ?, removed = ?, REF_WEB = ?, APPLY_DISCOUNT = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, product.getColor());
                this.setBoolean(2, product.isHidden());
                this.setBoolean(3, product.isRemoved());
                this.setString(4, product.getRef_web());
                this.setBoolean(5, product.isApply_discount());
                this.setInt(6, product.getID());
            }
        });
    }

    private void updateProcudtSync(final ProductInfoExt product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET color = ?, hidden = ?, removed = ?, order_item = ?, APPLY_DISCOUNT = ?, REMOVED_BY_ADMIN = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, product.getColor());
                this.setBoolean(2, product.isHidden());
                this.setBoolean(3, product.isRemoved());
                this.setInt(4, product.getOrder_item());
                this.setBoolean(5, product.isApply_discount());
                this.setBoolean(6, product.isRemoved_by_admin());
                this.setInt(7, product.getID());
            }
        });
    }

    private void changeOptionsOfProduct(ProductInfoExt product) throws BasicException {
        int found;
        List<SupplementProduct> itemsOptions = this.m_dlItems.getAllSupplementsByProduct(product.getID());
        for (SupplementProduct itemOption : itemsOptions) {
            found = -1;
            for (SupplementProduct option : product.getSupplements()) {
                if (this.getGOption(option) != itemOption.getiD()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteOptionOfProduct(itemOption.getiD(), product.getID());
        }
        for (SupplementProduct option : product.getSupplements()) {
            found = -1;
            for (SupplementProduct itemOption : itemsOptions) {
                if (this.getGOption(option) != itemOption.getiD()) continue;
                found = 1;
            }
            if (found == -1) {
                this.addSupplementProduct(option, product.getID());
                continue;
            }
            this.updateSupplementProduct(option, product.getID());
        }
    }

    private void deleteOptionOfProduct(final int idGOption, final int idProduct) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM  ITEM_SUPPLEMENTS WHERE id_supplement = ? AND id_item = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idGOption);
                this.setInt(2, idProduct);
            }
        });
    }

    private void changeItemOfProduct(ProductInfoExt product) throws BasicException {
        int idCarte;
        int found;
        List<CarteOrderInfo> itemCartes = this.m_dlItems.getAllCartesByItem(product.getID());
        for (CarteOrderInfo itemCarte : itemCartes) {
            found = -1;
            for (CarteOrderInfo carte : product.getCartes()) {
                idCarte = this.getCarte(carte);
                if (idCarte != itemCarte.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteCarteMenu(itemCarte.getId(), product.getID());
        }
        for (CarteOrderInfo carte : product.getCartes()) {
            found = -1;
            for (CarteOrderInfo itemCarte : itemCartes) {
                idCarte = this.getCarte(carte);
                if (idCarte != itemCarte.getId()) continue;
                found = 1;
            }
            if (found == -1) {
                this.addCarteMenu(carte, product.getID());
                continue;
            }
            this.updateCarteMenu(carte, product.getID());
        }
    }

    private void deleteCarteMenu(final int idCarte, final int idProduct) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM  CARTE_MENU WHERE id_carte = ? AND id_item = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idCarte);
                this.setInt(2, idProduct);
            }
        });
    }

    public void updateCategory(final CategoryInfo category) throws BasicException, SQLException {
        this.m_dlItems.updateCategory(category, true);
        new PreparedSentence(this.s, "UPDATE  CATEGORIES SET  PARENTID = ?, order_category = ?, removed = ?, hidden = ?, APPLY_DISCOUNT = ?,  REMOVED_BY_ADMIN = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category.getParent_id());
                this.setInt(2, category.getOrdercategory());
                this.setBoolean(3, category.isRemoved());
                this.setBoolean(4, category.isHidden());
                this.setBoolean(5, category.isApply_discount());
                this.setBoolean(6, category.isRemoved_by_admin());
                this.setInt(7, category.getID());
            }
        });
        this.m_dlSales.setIdGlobalItem(category.getID(), "CATEGORIES", "ID_GLOBAL", category.getId_global());
        this.persistTagCatgory(category);
        this.multiLanguageCategoryService.setMultiLanguagesCategory(category.getMultiLanguageTexts(), category.getID());
        for (ProductInfoExt product : category.getProducts()) {
            product.setCategoryid(category.getID());
            this.persistProduct(product, category);
        }
    }

    private void updateCarteItem(final CarteItemInfo item) throws BasicException {
        final int idItem = this.getProductID(item);
        if (idItem != -1) {
            new PreparedSentence(this.s, "UPDATE CARTE_ITEM SET price = ?, order_item = ? WHERE id_carte = ? AND id_item = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setDouble(1, NumericUtils.round(item.getPrice()));
                    this.setInt(2, item.getOrder_item());
                    this.setInt(3, item.getId_carte());
                    this.setInt(4, idItem);
                }
            });
        }
    }

    private void deleteCarteItem(final int idCarte, final int idItem) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM CARTE_ITEM WHERE id_carte = ? AND id_item = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idCarte);
                this.setInt(2, idItem);
            }
        });
    }

    public final void updateCarte(final CarteInfo carte) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  CARTE SET  name = ?, sizeCarte = ?, removed = ?, REMOVED_BY_ADMIN = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, carte.getName());
                this.setString(2, carte.getSizeCarte());
                this.setBoolean(3, carte.isRemoved());
                this.setBoolean(4, carte.isRemoved_by_admin());
                this.setInt(5, carte.getId());
            }
        });
        this.m_dlSales.setIdGlobalItem(carte.getId(), "CARTE", "ID_GLOBAL", carte.getId_global());
        for (CarteItemInfo carteItem : carte.getCarteItems()) {
            carteItem.setId_carte(carte.getId());
        }
        List<CarteItemInfo> carteItems = this.m_dlSales.getCarteItems(carte.getId(), false);
        for (CarteItemInfo carteItem : carteItems) {
            int found = -1;
            for (CarteItemInfo item : carte.getCarteItems()) {
                int idItem = this.getProductID(item);
                if (idItem != carteItem.getId_item()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteCarteItem(carteItem.getId_carte(), carteItem.getId_item());
        }
        for (CarteItemInfo item : carte.getCarteItems()) {
            int idItem = this.getProductID(item);
            int found = -1;
            for (CarteItemInfo carteItem : carteItems) {
                if (idItem != carteItem.getId_item()) continue;
                found = 1;
            }
            if (found == -1) {
                this.addCarteItem(item);
                continue;
            }
            this.updateCarteItem(item);
        }
        this.multiLanguageCarteService.setMultiLanguagesCarte(carte.getMultiLanguageTexts(), carte.getId());
    }

    private void persistGOption(SupplementInfo option) throws BasicException, SQLException {
        String nameByLanguage;
        if (!(AppLocal.APP_LANGUAGE == null || AppLocal.APP_LANGUAGE.isEmpty() || (nameByLanguage = option.getNameByLanguage(AppLocal.APP_LANGUAGE)) == null || nameByLanguage.isEmpty() || option.getName() != null && nameByLanguage.equalsIgnoreCase(option.getName()))) {
            option.setName(nameByLanguage);
        }
        if (this.merge) {
            if (!option.isRemoved_by_admin()) {
                this.addGroupeOption(option);
            }
        } else {
            option.setRef_web(String.valueOf(option.getiD()));
            int idGOption = this.getGOption(option);
            if (idGOption != -1) {
                option.setiD(idGOption);
                this.updateGroupeOption(option);
            } else if (!option.isRemoved_by_admin()) {
                this.addGroupeOption(option);
            }
        }
    }

    private void persistCarte(CarteInfo carte) throws BasicException, SQLException {
        String nameByLanguage;
        if (!(AppLocal.APP_LANGUAGE == null || AppLocal.APP_LANGUAGE.isEmpty() || (nameByLanguage = carte.getNameByLanguage(AppLocal.APP_LANGUAGE)) == null || nameByLanguage.isEmpty() || carte.getName() != null && nameByLanguage.equalsIgnoreCase(carte.getName()))) {
            carte.setName(nameByLanguage);
        }
        if (this.merge) {
            if (!carte.isRemoved_by_admin()) {
                this.addCarte(carte);
            }
        } else {
            carte.setRef_web(String.valueOf(carte.getId()));
            int idCarte = this.getCarte(carte);
            if (idCarte != -1) {
                carte.setId(idCarte);
                this.updateCarte(carte);
            } else if (!carte.isRemoved_by_admin()) {
                this.addCarte(carte);
            }
        }
    }

    private void persistCategory(CategoryInfo category) throws BasicException, SQLException {
        String nameByLanguage;
        int old_id = category.getID();
        category.setRef_web(String.valueOf(category.getID()));
        int idCategory = -1;
        if (!(AppLocal.APP_LANGUAGE == null || AppLocal.APP_LANGUAGE.isEmpty() || (nameByLanguage = category.getNameByLanguage(AppLocal.APP_LANGUAGE)) == null || nameByLanguage.isEmpty() || category.getName() != null && nameByLanguage.equalsIgnoreCase(category.getName()))) {
            category.setName(nameByLanguage);
        }
        if (this.merge) {
            if (!category.isRemoved_by_admin()) {
                idCategory = this.addCategory(category);
            }
        } else {
            idCategory = this.getCategory(category);
            if (idCategory != -1) {
                category.setID(idCategory);
                this.updateCategory(category);
            } else if (!category.isRemoved_by_admin()) {
                idCategory = this.addCategory(category);
            }
        }
        if (idCategory != -1 && category.getParent_id() == -1) {
            for (CategoryInfo sub_category : this.all_categories) {
                boolean checkSubCategory = false;
                if (category.getId_global() != null && !category.getId_global().isEmpty() && sub_category.getParent_id_global() != null && !sub_category.getParent_id_global().isEmpty()) {
                    checkSubCategory = category.getId_global().equalsIgnoreCase(sub_category.getParent_id_global());
                } else {
                    boolean bl = checkSubCategory = old_id == sub_category.getParent_id();
                }
                if (!checkSubCategory || sub_category.isSynchronized_category()) continue;
                sub_category.setParent_id(idCategory);
                sub_category.setSynchronized_category(true);
                this.persistCategory(sub_category);
            }
        }
    }

    private List<CategoryInfo> getOldCategories() throws BasicException {
        return new PreparedSentence(this.s, this.m_dlSales.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 ", null, CategoryInfo.getSerializerRead()).list();
    }

    private List<ProductInfoExt> getOldProducts(int idCatgory) throws BasicException {
        return new PreparedSentence(this.s, this.m_dlSales.requestProducts + "WHERE P.CATEGORY = ? AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)idCatgory);
    }

    public void persistGlobal(Object[] infos, boolean remote_synchro, boolean merge) throws BasicException, SQLException {
        this.products.clear();
        this.ids_produts.clear();
        this.ids_groupeOptions.clear();
        this.ids_groupeSubOptions.clear();
        this.ids_options.clear();
        this.ids_promotions.clear();
        this.supplements.clear();
        this.ids_cartes.clear();
        this.remote_synchro = remote_synchro;
        this.merge = merge;
        HashMap categories = (HashMap)infos[0];
        this.all_categories.addAll(categories.values());
        List options = (List)infos[1];
        List cartes = (List)infos[2];
        this.printers = (HashMap)infos[3];
        List groupsSubOptions = infos[4] != null ? (List)infos[4] : null;
        List promotions = infos[5] != null ? (List)infos[5] : null;
        this.refreshCategories();
        this.refreshSupplements(options);
        this.refreshFamillesProducts(cartes);
        this.assignTaxToProduct(categories);
        this.assignTaxesToOptions(options);
        List<PrinterInfo> oldPrinters = this.m_dlSales.getPrinters();
        List screens = infos[6] != null ? (List)infos[6] : null;
        List tags = infos[7] != null ? (List)infos[7] : null;
        List zones = infos[8] != null ? (List)infos[8] : null;
        List nutrientDatas = infos[9] != null ? (List)infos[9] : null;
        this.synchronize_printers = !merge;
        this.synchronize_screens = !remote_synchro || screens != null;
        this.remote_synchro = remote_synchro;
        if (this.synchronize_screens && screens != null) {
            for (LocalScreen screen : screens) {
                this.persistScreen(screen);
            }
        }
        if (tags != null) {
            for (TagInfo tag : tags) {
                this.persistTag(tag);
            }
        }
        if (zones != null && !zones.isEmpty()) {
            for (ZoneInfo zone : zones) {
                this.persistZone(zone);
            }
        }
        if (nutrientDatas != null && !nutrientDatas.isEmpty()) {
            for (NutrientData mNutrientData : nutrientDatas) {
                this.persistNutri(mNutrientData);
            }
        }
        if (this.synchronize_printers) {
            for (PrinterInfo printer : this.printers.values()) {
                this.persistPrinter(printer, remote_synchro);
            }
        }
        if (groupsSubOptions != null) {
            for (GroupSubSupplementInfo groupSubOption : groupsSubOptions) {
                this.persistGroupSubOption(groupSubOption);
            }
        }
        for (SupplementInfo option : options) {
            this.persistGOption(option);
        }
        if (promotions != null) {
            for (PromotionInfo promotion : promotions) {
                this.persistPromotion(promotion);
            }
        }
        for (CategoryInfo category : categories.values()) {
            if (category.getParent_id() != -1) continue;
            this.persistCategory(category);
        }
        for (CarteInfo carte : cartes) {
            this.persistCarte(carte);
        }
        if (groupsSubOptions != null) {
            for (GroupSubSupplementInfo groupSubOption : groupsSubOptions) {
                if (groupSubOption.isRemoved()) continue;
                this.persistSubSupplement(groupSubOption);
            }
        }
        for (ProductInfoExt product : this.products) {
            Iterator<ProductInfoExt> iterator = product.getAdditional_sales().iterator();
            while (iterator.hasNext()) {
                ProductInfoExt additional_sale;
                Integer id_additional_sale = this.ids_produts.get(this.getIdSynchProduct(additional_sale = iterator.next()));
                additional_sale.setID(id_additional_sale != null ? id_additional_sale : -1);
            }
            iterator = product.getSub_products().iterator();
            while (iterator.hasNext()) {
                ProductInfoExt sub_product;
                Integer id_sub_product = this.ids_produts.get(this.getIdSynchProduct(sub_product = iterator.next()));
                sub_product.setID(id_sub_product != null ? id_sub_product : -1);
            }
            this.m_dlItems.persistAdditionalSales(product);
            this.m_dlItems.persistSubProducts(product);
            this.changeItemOfProduct(product);
        }
        for (SupplementItemInfo supplement : this.supplements) {
            String idSynchroProduct = supplement.getId_product_global() != null && !supplement.getId_product_global().isEmpty() ? supplement.getId_product_global() : String.valueOf(supplement.getId_product());
            int id_product = this.ids_produts.get(idSynchroProduct) != null ? this.ids_produts.get(idSynchroProduct) : 0;
            supplement.setId_product(id_product);
            this.m_dlItems.updateProductSupplement(supplement);
        }
        System.out.println("+++++++++++++++ end synchronisation");
    }

    private void refreshCategories() throws BasicException {
        for (CategoryInfo oldCategory : this.getOldCategories()) {
            int found = -1;
            if (oldCategory.getId_global() != null && !oldCategory.getId_global().isEmpty()) {
                for (CategoryInfo category : this.all_categories) {
                    if (category.getId_global() == null || !String.valueOf(category.getId_global()).equals(oldCategory.getId_global())) continue;
                    found = 1;
                }
            }
            if (found == -1) {
                this.m_dlSales.deleteCategory(oldCategory.getID(), true);
                continue;
            }
            block2: for (ProductInfoExt oldProduct : this.getOldProducts(oldCategory.getID())) {
                found = -1;
                if (oldProduct.getId_global() != null && !oldProduct.getId_global().isEmpty()) {
                    for (CategoryInfo category : this.all_categories) {
                        if (oldCategory.getId_global() == null || category.getId_global() == null || !category.getId_global().equals(oldCategory.getId_global())) continue;
                        for (ProductInfoExt product : category.getProducts()) {
                            if (product.getId_global() == null || !String.valueOf(product.getId_global()).equals(oldProduct.getId_global())) continue;
                            found = 1;
                            break;
                        }
                        if (found != -1) continue block2;
                        this.m_dlSales.deleteProduct(oldProduct.getID(), true);
                        continue block2;
                    }
                    continue;
                }
                this.m_dlSales.deleteProduct(oldProduct.getID(), true);
            }
        }
    }

    private void changeIngredientOfProduct(ProductInfoExt product) throws BasicException {
        List<ItemIngredientInfo> itemsIngredients = this.m_dlSales.getItemsIngredients(product.getID());
        for (ItemIngredientInfo itemIngredient : itemsIngredients) {
            int found = -1;
            for (ItemIngredientInfo ingredient : product.getItemIngredients()) {
                if (this.getItemIngredient(ingredient) != itemIngredient.getId_supplement_item()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteIngredientOfProduct(itemIngredient.getId_supplement_item(), product.getID());
        }
        for (ItemIngredientInfo ingredient : product.getItemIngredients()) {
            ItemIngredientInfo itemIngredient = null;
            for (ItemIngredientInfo _itemIngredient : itemsIngredients) {
                if (this.getItemIngredient(ingredient) != _itemIngredient.getId_supplement_item()) continue;
                itemIngredient = _itemIngredient;
            }
            ingredient.setId_item(product.getID());
            if (itemIngredient == null) {
                this.addIngredientProduct(ingredient);
                continue;
            }
            this.updateIngredientProduct(ingredient);
        }
    }

    private void deleteIngredientOfProduct(final int id_supplement_item, final int idProduct) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM ITEM_INGREDIENTS WHERE id_supplement_item = ? AND id_item = ?  ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_supplement_item);
                this.setInt(2, idProduct);
            }
        });
    }

    private void persistPrinter(PrinterInfo printerJson, boolean remote_synchro) throws BasicException {
        PrinterInfo printer = (PrinterInfo)printerJson.clone();
        if (printer.getId() != 1) {
            if (this.merge) {
                this.addPrinter(printer);
            } else {
                int idPrinter = this.getPrinter(printer);
                if (idPrinter != 1) {
                    if (idPrinter != -1) {
                        printer.setId(idPrinter);
                        if (remote_synchro) {
                            this.updatePrinterOnline(printer);
                        } else {
                            this.updatePrinterLocal(printer);
                        }
                    } else if (remote_synchro) {
                        this.addPrinterOnline(printer);
                    } else {
                        this.addPrinter(printer);
                    }
                }
            }
        }
    }

    private void updatePrinterOnline(final PrinterInfo printer) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRINTER SET NAME = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, printer.getName());
                this.setInt(2, printer.getId());
            }
        });
    }

    private void addPrinter(final PrinterInfo printer) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PRINTER(NAME, TYPE, IP, WITH_TICKET, NUMBER_TICKET, typePrinter, MODEL ,  REF_WEB) VALUES(?,?,?,?,?,?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, printer.getName());
                this.setString(2, printer.getType());
                this.setString(3, printer.getIp());
                this.setInt(4, printer.getWith());
                this.setInt(5, printer.getNumber());
                this.setString(6, printer.getTypePrinter());
                this.setString(7, printer.getModel());
                this.setString(8, String.valueOf(printer.getId()));
            }
        });
    }

    private void changeSizeOfProduct(ProductInfoExt product) throws BasicException, SQLException {
        if (product.getListSizes() != null) {
            for (ProductSizeInfo productSize : product.getListSizes()) {
                String ref_synchro = String.valueOf(productSize.getID());
                int idProductSize = this.getProductSizeByName(productSize.getName(), productSize.getTariff(), product.getID());
                productSize.setID(idProductSize);
                productSize.setRef_synchro(ref_synchro);
            }
            this.m_dlItems.persistSizesProduct(product, true);
        }
    }

    private void addPrinterProduct(final ProductInfoExt product) throws BasicException {
        final int idPrinter = this.getPrinter(this.printers.get(product.getPrinterID()));
        if (idPrinter != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printer = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, idPrinter);
                    this.setInt(2, product.getID());
                }
            });
        }
    }

    private void addPrinterLabel(final ProductInfoExt product) throws BasicException {
        final int idPrinter = this.getPrinter(this.printers.get(product.getPrinterLabel()));
        if (idPrinter != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printerLabel = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, idPrinter);
                    this.setInt(2, product.getID());
                }
            });
        }
    }

    private void addDisplayKitchen(final ProductInfoExt product) throws BasicException {
        final int idPrinter = this.getPrinter(this.printers.get(product.getDisplayKitchen()));
        if (idPrinter != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET display_kitchen = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, idPrinter);
                    this.setInt(2, product.getID());
                }
            });
        }
    }

    private void assignTaxToProduct(HashMap<Integer, CategoryInfo> categories) throws BasicException {
        this.assignTax(categories);
    }

    private void assignTax(HashMap<Integer, CategoryInfo> categories) throws BasicException {
        for (CategoryInfo category : categories.values()) {
            for (ProductInfoExt product : category.getProducts()) {
                TaxInfo tax_lv;
                TaxInfo tax_emp;
                TaxInfo tax = this.m_dlSales.getTaxByRate(product.getRate_tax());
                if (tax == null) {
                    tax = this.m_dlSales.getTaxByRate(this.rate_tax);
                }
                if (tax != null) {
                    product.setTaxCategoryID(tax.getId());
                }
                if ((tax_emp = this.m_dlSales.getTaxByRate(product.getRate_tax_emp())) == null) {
                    tax_emp = this.m_dlSales.getTaxByRate(this.rate_tax);
                }
                if (tax_emp != null) {
                    product.setTaxemp(tax_emp.getId());
                }
                if ((tax_lv = this.m_dlSales.getTaxByRate(product.getRate_tax_lv())) == null) {
                    tax_lv = this.m_dlSales.getTaxByRate(this.rate_tax);
                }
                if (tax == null) continue;
                product.setTaxlv(tax_lv.getId());
            }
        }
    }

    public final void addOption(SupplementItemInfo option) throws BasicException, SQLException {
        option = this.m_dlSales.addOption(option, true);
        if (!this.merge) {
            this.ids_options.put(this.getIdSynchOption(option), option.getiD());
        }
        this.supplements.add((SupplementItemInfo)option.clone());
        if (option.getScreen() != null && option.getScreen().size() > 0) {
            for (ScreenSupplementItem screenOption : option.getScreen()) {
                screenOption.setId_supplement(option.getiD());
                this.addScreenIngredient(screenOption);
            }
        }
        if (option.getSupplementPrices() != null && option.getSupplementPrices().size() > 0) {
            for (SupplementPriceInfo supplementPrice : option.getSupplementPrices()) {
                supplementPrice.setId_supplement(option.getiD());
                supplementPrice.setRef_synchro(String.valueOf(supplementPrice.getId()));
                this.m_dlItems.addSupplementPrices(supplementPrice);
            }
        }
        if (option.getGroupsSubSupplement() != null && !option.getGroupsSubSupplement().isEmpty()) {
            for (GroupSubSupplementInfo groupSubSupplementInfo : option.getGroupsSubSupplement()) {
                this.addGroupSubOption(groupSubSupplementInfo, option);
            }
        }
        this.multiLanguageSupplementItemService.setMultiLanguagesSupplementItem(option.getMultiLanguageTexts(), option.getiD());
        this.mAllergeneSupplementServices.setAllergeneSupplements(option.getAllergenes(), option.getiD());
    }

    private void addScreenIngredient(final ScreenSupplementItem screen) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SCREENS_SUPPLEMENT(ID_SUPPLEMENT, ID_SCREEN, NAME_SCREEN, REF_WEB) VALUES(?,?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, screen.getId_supplement());
                this.setInt(2, screen.getId_screen());
                this.setString(3, screen.getName_screen());
                this.setString(4, String.valueOf(screen.getId()));
            }
        });
    }

    private void addScreenGroupeSupplement(final ScreenSupplementInfo screen) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SCREENS_GROUP_SUPPLEMENT(ID_GROUP_SUPPLEMENT, ID_SCREEN, NAME_SCREEN, REF_WEB) VALUES(?,?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, screen.getId_supplement());
                this.setInt(2, screen.getId_screen());
                this.setString(3, screen.getName_screen());
                this.setString(4, String.valueOf(screen.getId()));
            }
        });
    }

    private void changeScreenProduct(ProductInfoExt product) throws BasicException {
        int found;
        List<ScreenProduct> screensProduct = this.m_dlItems.getScreenByProduct(product.getID());
        for (ScreenProduct oldScreen : screensProduct) {
            found = -1;
            for (ScreenProduct screen : product.getScreens()) {
                if (screen.getNumber_screen() != oldScreen.getNumber_screen()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.m_dlItems.deleteScreenProduct(oldScreen.getId_product(), oldScreen.getId_screen());
        }
        for (ScreenProduct screen : product.getScreens()) {
            found = -1;
            for (ScreenProduct oldScreen : screensProduct) {
                if (screen.getNumber_screen() != oldScreen.getNumber_screen()) continue;
                found = 1;
            }
            if (found != -1) continue;
            screen.setId_product(product.getID());
            LocalScreen localScreen = this.mLocalScreenService.findByNumber(screen.getNumber_screen());
            if (localScreen == null) continue;
            screen.setId_screen(localScreen.getId());
            screen.setName_screen(localScreen.getName());
            this.m_dlItems.addScreenProduct(screen);
        }
    }

    private void changeScreenSupplement(SupplementItemInfo supplement) throws BasicException {
        int found;
        List<ScreenSupplementItem> screensSupplement = this.dlProduct.getScreenByIngredient(supplement.getiD());
        for (ScreenSupplementItem oldScreen : screensSupplement) {
            found = -1;
            for (ScreenSupplementItem screen : supplement.getScreen()) {
                if (this.getScreenSupplementItem(String.valueOf(screen.getId())) != oldScreen.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.dlProduct.deleteIngredientScreen(oldScreen);
        }
        for (ScreenSupplementItem screen : supplement.getScreen()) {
            found = -1;
            for (ScreenSupplementItem oldScreen : screensSupplement) {
                if (this.getScreenSupplementItem(String.valueOf(screen.getId())) != oldScreen.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            screen.setId_supplement(supplement.getiD());
            this.addScreenIngredient(screen);
        }
    }

    private void changeScreenGSupplement(SupplementInfo supplement) throws BasicException {
        int found;
        List<ScreenSupplementInfo> screensSupplement = this.dlProduct.getScreenByGoption(supplement.getiD());
        for (ScreenSupplementInfo oldScreen : screensSupplement) {
            found = -1;
            for (ScreenSupplementInfo screen : supplement.getScreens()) {
                if (this.getScreenSupplement(String.valueOf(screen.getId())) != oldScreen.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.dlProduct.deleteSupplementScreen(oldScreen);
        }
        for (ScreenSupplementInfo screen : supplement.getScreens()) {
            found = -1;
            for (ScreenSupplementInfo oldScreen : screensSupplement) {
                if (this.getScreenSupplement(String.valueOf(screen.getId())) != oldScreen.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            screen.setId_supplement(supplement.getiD());
            this.addScreenGroupeSupplement(screen);
        }
    }

    public final int getScreenProduct(String ref_web) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM SCREENS_PRODUCT WHERE REF_WEB = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)ref_web);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final int getScreenSupplementItem(String ref_web) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM SCREENS_SUPPLEMENT WHERE REF_WEB = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)ref_web);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final int getScreenSupplement(String ref_web) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM SCREENS_GROUP_SUPPLEMENT WHERE REF_WEB = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)ref_web);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final String getUser(String ref_web) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM PEOPLE WHERE REF_SYNCHRO = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)ref_web);
        return iD != null ? (String)iD[0] : "";
    }

    private boolean existUser(String idUser) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM PEOPLE WHERE ID = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)idUser);
        return iD != null;
    }

    private void persistUser(User user) throws BasicException {
        if (!this.ids_user.contains(user.getId())) {
            String idUser = this.getUser(user.getId());
            if (!idUser.isEmpty()) {
                user.setId(idUser);
                this.updateUser(user);
            } else if (!user.isRemoved()) {
                user.setRef_synchro(user.getId());
                this.addUser(user);
            }
        } else {
            System.out.println("exist");
            if (this.existUser(user.getId())) {
                this.updateUser(user);
            }
        }
    }

    private void persistPermission(User user) throws BasicException {
        this.dlUser.persistPermission(user, user.getPermissions());
    }

    private void updateUser(final User user) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  PEOPLE SET NAME = ?, APPPASSWORD = ?, ROLE = ?, removed = ?, fingerprint = ?, EMAIL = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user.getName());
                this.setString(2, user.getPassword());
                this.setString(3, user.getRole());
                this.setBoolean(4, user.isRemoved());
                this.setString(5, user.getFingerprint());
                this.setString(6, user.getEmail());
                this.setString(7, user.getId());
            }
        });
        this.persistPermission(user);
    }

    private void addUser(final User user) throws BasicException {
        user.setId(UUID.randomUUID().toString());
        this.dlUser.addUser(user);
        for (Permission permission : user.getPermissions()) {
            this.dlUser.addPermissionUser(permission, user);
        }
        new PreparedSentence(this.s, "UPDATE PEOPLE SET REF_SYNCHRO = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user.getRef_synchro());
                this.setString(2, user.getId());
            }
        });
    }

    public void persistUsers(List<User> users) throws BasicException {
        for (User user : users) {
            this.persistUser(user);
        }
        List<User> oldUsers = this.dlUser.getUsers();
        for (User oldUser : oldUsers) {
            if (this.ids_user.contains(oldUser.getId()) || oldUser.getRef_synchro() != null && !oldUser.getRef_synchro().isEmpty()) continue;
            this.dlUser.deleteUser(oldUser.getId());
        }
    }

    public void persistPhoto(Object[] infos) throws BasicException, SQLException {
        List photosPub = (List)infos[0];
        List photosHome = (List)infos[1];
        List photosDualScreen = (List)infos[2];
        this.deleteOldPhoto(photosHome, photosPub, photosDualScreen);
        for (PhotoDispaly photoPub : photosPub) {
            this.persistPhoto(photoPub, "PHOTO_PUB_BORNE");
        }
        for (PhotoDispaly photoHome : photosHome) {
            this.persistPhoto(photoHome, "PHOTO_HOME_BORNE");
        }
        for (PhotoDispaly photoDualScreen : photosDualScreen) {
            this.persistPhoto(photoDualScreen, "PHOTO_DISPLAY");
        }
    }

    private int getPhoto(String ref_web, String table_name) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM " + table_name + " WHERE REF_SYNCH = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)ref_web);
        return iD != null ? (Integer)iD[0] : -1;
    }

    private void persistPhoto(PhotoDispaly photoPub, String name_table) throws BasicException {
        int idPhoto = this.getPhoto(String.valueOf(photoPub.getId()), name_table);
        if (idPhoto == -1) {
            this.addPhoto(photoPub, name_table);
        }
    }

    private void addPhoto(final PhotoDispaly photo, String table_name) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO " + table_name + "(path, REF_SYNCH) VALUES(?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, photo.getPath());
                this.setString(2, String.valueOf(photo.getId()));
            }
        });
    }

    private void deleteOldPhoto(List<PhotoDispaly> photosHome, List<PhotoDispaly> photosPub, List<PhotoDispaly> photosDualScreen) throws BasicException {
        int found;
        for (PhotoDispaly oldPhoto : this.getOldPhoto("PHOTO_HOME_BORNE")) {
            found = -1;
            for (PhotoDispaly photo : photosHome) {
                if (!String.valueOf(photo.getId()).equals(oldPhoto.getRef_synch())) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.m_dlSales.deleteHomeBornePhoto(oldPhoto.getId());
        }
        for (PhotoDispaly oldPhoto : this.getOldPhoto("PHOTO_PUB_BORNE")) {
            found = -1;
            for (PhotoDispaly photo : photosPub) {
                if (!String.valueOf(photo.getId()).equals(oldPhoto.getRef_synch())) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.m_dlSales.deletePubPhoto(oldPhoto.getId());
        }
        for (PhotoDispaly oldPhoto : this.getOldPhoto("PHOTO_DISPLAY")) {
            found = -1;
            for (PhotoDispaly photo : photosDualScreen) {
                if (!String.valueOf(photo.getId()).equals(oldPhoto.getRef_synch())) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.m_dlSales.deletePhoto(oldPhoto.getId());
        }
    }

    public final List<PhotoDispaly> getOldPhoto(String table_name) throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, path, REF_SYNCH FROM " + table_name + " WHERE REF_SYNCH IS NOT NULL ", null, PhotoDispaly.getSerializerRead()).list();
    }

    public final int getSupplementPrice(String ref_synchro) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM SUPPLEMENT_ITEM_PRICES WHERE REF_SYNCHRO = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)ref_synchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public void deleteOldSupplementPricesT(final String type_order, final String ref_synchro) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SUPPLEMENT_ITEM_PRICES  WHERE TYPE_ORDER = ? and REF_SYNCHRO <> ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_order);
                this.setString(2, ref_synchro);
            }
        });
    }

    private void persistSupplementPrice(SupplementItemInfo item) throws BasicException, SQLException {
        if (item.getSupplementPrices() != null && item.getSupplementPrices().size() > 0) {
            for (SupplementPriceInfo supplementPrice : item.getSupplementPrices()) {
                int idSupplementPrice = this.getOptionPriceByTypeOrder(supplementPrice.getType_order(), item.getiD());
                supplementPrice.setId(idSupplementPrice);
            }
            List<SupplementPriceInfo> oldPrices = this.m_dlItems.getSupplementPrices(item.getiD());
            for (SupplementPriceInfo oldPrice : oldPrices) {
                int found = -1;
                for (SupplementPriceInfo supplementPrice : item.getSupplementPrices()) {
                    if (supplementPrice.getId() != oldPrice.getId()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                this.m_dlItems.deleteOptionPrice(oldPrice.getId());
            }
            for (SupplementPriceInfo supplementPrice : item.getSupplementPrices()) {
                if (supplementPrice.getId() == -1 || supplementPrice.getId() == 0) {
                    supplementPrice.setId_supplement(item.getiD());
                    this.m_dlItems.addSupplementPrices(supplementPrice);
                    continue;
                }
                this.m_dlItems.updateSupplementPrices(supplementPrice);
                this.m_dlSales.setIdGlobalItem(supplementPrice.getId(), "SUPPLEMENT_ITEM_PRICES", "ID_GLOBAL", supplementPrice.getId_global());
            }
        }
    }

    public final int getGroupSubOption(GroupSubSupplementInfo groupSubOption) throws BasicException {
        String DB_COLUMN_TO_CHECK;
        String idSynchro = this.getIdSynchGroupSubOption(groupSubOption);
        if (idSynchro == null) {
            return -1;
        }
        String string = DB_COLUMN_TO_CHECK = groupSubOption.getId_global() != null && !groupSubOption.getId_global().isEmpty() ? "ID_GLOBAL" : "REF_SYNCHRO";
        if (this.merge) {
            Integer idGroupSubOption = this.ids_groupeSubOptions.get(idSynchro);
            return idGroupSubOption != null ? idGroupSubOption : -1;
        }
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM GROUPE_SUB_SUPPLEMENTS WHERE " + DB_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idSynchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    private void persistGroupSubOption(GroupSubSupplementInfo groupSubOption) throws BasicException, SQLException {
        groupSubOption.setRef_synchro(String.valueOf(groupSubOption.getId()));
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            String nameByLanguage = groupSubOption.getNameByLanguage(AppLocal.APP_LANGUAGE);
            String titleByLanguage = groupSubOption.getTitleByLanguage(AppLocal.APP_LANGUAGE);
            if (!(nameByLanguage == null || nameByLanguage.isEmpty() || groupSubOption.getName_group() != null && nameByLanguage.equalsIgnoreCase(groupSubOption.getName_group()))) {
                groupSubOption.setName_group(nameByLanguage);
            }
            if (!(titleByLanguage == null || titleByLanguage.isEmpty() || groupSubOption.getTitle_group() != null && titleByLanguage.equalsIgnoreCase(groupSubOption.getTitle_group()))) {
                groupSubOption.setTitle_group(titleByLanguage);
            }
        }
        if (this.merge) {
            if (!groupSubOption.isRemoved()) {
                this.m_dlItems.addGroupSubSupplement(groupSubOption, false);
                this.ids_groupeSubOptions.put(this.getIdSynchGroupSubOption(groupSubOption), groupSubOption.getId());
            }
        } else {
            int id = this.getGroupSubOption(groupSubOption);
            if (id != -1) {
                groupSubOption.setId(id);
                this.m_dlItems.updateGroupSubSupplement(groupSubOption, false);
                this.multiLanguageGSSService.setMultiLanguagesGSS(groupSubOption.getMultiLanguageTexts(), groupSubOption.getId());
            } else if (!groupSubOption.isRemoved()) {
                this.m_dlItems.addGroupSubSupplement(groupSubOption, false);
                this.multiLanguageGSSService.setMultiLanguagesGSS(groupSubOption.getMultiLanguageTexts(), groupSubOption.getId());
            }
        }
    }

    private void addGroupSubOption(GroupSubSupplementInfo groupSubSupplement, SupplementItemInfo supplement) throws BasicException {
        int idGroupSubOption = this.getGroupSubOption(groupSubSupplement);
        if (idGroupSubOption != -1) {
            groupSubSupplement.setId(idGroupSubOption);
            this.m_dlItems.addSupplementGroup(groupSubSupplement, supplement);
        }
    }

    private void persistSupplementGroup(SupplementItemInfo option) throws BasicException {
        ArrayList<GroupSubSupplementInfo> groupsSubOption = new ArrayList<GroupSubSupplementInfo>();
        if (option.getGroupsSubSupplement() != null) {
            for (GroupSubSupplementInfo groupSubSupplement : option.getGroupsSubSupplement()) {
                int idGroupSubOption = this.getGroupSubOption(groupSubSupplement);
                if (idGroupSubOption == -1) continue;
                groupSubSupplement.setId(idGroupSubOption);
                groupsSubOption.add(groupSubSupplement);
            }
            option.setGroupsSubSupplement(groupsSubOption);
            this.m_dlItems.persistSupplementGroup(option);
        }
    }

    private void persistSubSupplement(GroupSubSupplementInfo groupSubSupplement) throws BasicException {
        ArrayList<SupplementItemInfo> sub_supplemets = new ArrayList<SupplementItemInfo>();
        for (SupplementItemInfo supplement : groupSubSupplement.getSupplements()) {
            int idSupplement = this.getOption(supplement);
            if (idSupplement == -1) continue;
            supplement.setiD(idSupplement);
            sub_supplemets.add(supplement);
        }
        groupSubSupplement.setSupplements(sub_supplemets);
        this.m_dlItems.persistSubSupplement(groupSubSupplement);
    }

    public final int getProductID(ProductInfoExt product) throws BasicException {
        String DB_COLUMN_TO_CHECK;
        String idSynchro = this.getIdSynchProduct(product);
        String string = DB_COLUMN_TO_CHECK = product.getId_global() != null && !product.getId_global().isEmpty() ? "PRODUCT_PLU" : "REF_WEB";
        if (this.merge) {
            Integer idItem = this.ids_produts.get(idSynchro);
            return idItem != null ? idItem : -1;
        }
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM PRODUCTS WHERE  " + DB_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idSynchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    private void updatePromoBasket(ProductInfoExt product) throws BasicException {
        this.m_dlItems.updatePromoBasket(product);
    }

    private void persistPromotion(PromotionInfo promotion) throws BasicException, SQLException {
        if (AppLocal.APP_LANGUAGE != null && !AppLocal.APP_LANGUAGE.isEmpty()) {
            String nameByLanguage = promotion.getNameByLanguage(AppLocal.APP_LANGUAGE);
            String descriptionByLanguage = promotion.getDescriptionByLanguage(AppLocal.APP_LANGUAGE);
            String textByLanguage = promotion.getTextPromoByLanguage(AppLocal.APP_LANGUAGE);
            if (!(nameByLanguage == null || nameByLanguage.isEmpty() || promotion.getName_promotion() != null && nameByLanguage.equalsIgnoreCase(promotion.getName_promotion()))) {
                promotion.setName_promotion(nameByLanguage);
            }
            if (!(descriptionByLanguage == null || descriptionByLanguage.isEmpty() || promotion.getDescription() != null && descriptionByLanguage.equalsIgnoreCase(promotion.getDescription()))) {
                promotion.setDescription(descriptionByLanguage);
            }
            if (!(descriptionByLanguage == null || descriptionByLanguage.isEmpty() || promotion.getDescription() != null && descriptionByLanguage.equalsIgnoreCase(promotion.getDescription()))) {
                promotion.setText_promo(descriptionByLanguage);
            }
        }
        promotion.setRef_synchro(String.valueOf(promotion.getId()));
        if (this.merge) {
            if (!promotion.isRemoved()) {
                this.m_dlItems.addPromotion(promotion);
                this.ids_promotions.put(this.getIdSynchPromotion(promotion), promotion.getId());
            }
        } else {
            int id = this.getPromotion(promotion);
            if (id != -1) {
                promotion.setId(id);
                this.m_dlItems.updatePromotion(promotion);
                this.m_dlSales.setIdGlobalItem(promotion.getId(), "PROMOTIONS", "ID_GLOBAL", promotion.getId_global());
                this.multiLanguagePromotionService.setMultiLanguagesPromotion(promotion.getMultiLanguageTexts(), promotion.getId());
            } else if (!promotion.isRemoved()) {
                this.m_dlItems.addPromotion(promotion);
                this.multiLanguagePromotionService.setMultiLanguagesPromotion(promotion.getMultiLanguageTexts(), promotion.getId());
            }
        }
    }

    public final int getPromotion(PromotionInfo promotionInfo) throws BasicException {
        String BD_COLUMN_TO_CHECK;
        String idSynchro = this.getIdSynchPromotion(promotionInfo);
        String string = BD_COLUMN_TO_CHECK = promotionInfo.getId_global() != null && !promotionInfo.getId_global().isEmpty() ? "ID_GLOBAL" : "REF_SYNCHRO";
        if (this.merge) {
            Integer idPromotion = this.ids_promotions.get(idSynchro);
            return idPromotion != null ? idPromotion : -1;
        }
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM PROMOTIONS WHERE " + BD_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idSynchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    private void addPromotionProduct(PromotionInfo promotion, int idProduct) throws BasicException {
        int idPromotion = this.getPromotion(promotion);
        if (idPromotion != -1) {
            promotion.setId(idPromotion);
            this.m_dlItems.addPromotionProduct(idProduct, promotion);
        }
    }

    private void persistPromotionsProduct(ProductInfoExt product) throws BasicException {
        ArrayList<PromotionInfo> promotions = new ArrayList<PromotionInfo>();
        for (PromotionInfo promotion : product.getPromotions()) {
            int idPromotion = this.getPromotion(promotion);
            if (idPromotion == -1) continue;
            promotion.setId(idPromotion);
            promotions.add(promotion);
        }
        product.setPromotions(promotions);
        this.m_dlItems.persistPromotionsProduct(product);
    }

    private void addGroupeOptionSync(final int idPrinter, final SupplementInfo groupeOption) throws BasicException {
        new PreparedSentence(this.s, "UPDATE SUPPLEMENT SET removed = ?, REF_WEB = ?,  printer = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, groupeOption.isRemoved());
                this.setString(2, groupeOption.getRef_web());
                this.setInt(3, idPrinter);
                this.setInt(4, groupeOption.getiD());
            }
        });
    }

    private void persistScreen(LocalScreen screen) {
        LocalScreen localScreen = this.mLocalScreenService.findByNumber(screen.getNumber());
        if (localScreen != null) {
            this.mLocalScreenService.updateScreen(screen.getName(), screen.isDeleted(), screen.getNumber());
        } else if (!screen.isDeleted()) {
            this.mLocalScreenService.addScreen(screen.getName(), screen.getNumber());
        }
    }

    public final int getProductSizeByName(final String name_size, final int tariff, final int id_product) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM PRODUCTS_SIZE WHERE name_size = ? and TARIFF = ? AND product = ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, name_size);
                this.setInt(2, tariff);
                this.setInt(3, id_product);
            }
        });
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final int getProductPriceByTypeOrder(final String type_order, final int tariff, final int id_product) throws BasicException {
        String request_type_order = type_order == null ? " TYPE_ORDER is null " : " TYPE_ORDER = ? ";
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM PRODUCTS_PRICES WHERE PRODUCT = ? AND TARIFF = ? AND " + request_type_order, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_product);
                this.setInt(2, tariff);
                if (type_order != null) {
                    this.setString(3, type_order);
                }
            }
        });
        return iD != null ? (Integer)iD[0] : -1;
    }

    private void changePricesOfProduct(ProductInfoExt product) throws BasicException {
        if (product.getPrices() != null) {
            for (ProductPriceInfo productPrice : product.getPrices()) {
                int idProductPrice = this.getProductPriceByTypeOrder(productPrice.getType_order(), productPrice.getTariff(), product.getID());
                productPrice.setId(idProductPrice);
            }
            this.m_dlItems.persistPricesProduct(product);
        }
    }

    private void persistTag(TagInfo tag) {
        TagInfo mTagInfo = this.mTagsService.findByNumber(tag.getNumber());
        if (mTagInfo != null) {
            mTagInfo.setDeleted(tag.isDeleted());
            mTagInfo.setBackground_catalog(tag.getBackground_catalog());
            mTagInfo.setLogo_tag(tag.getLogo_tag());
            mTagInfo.setName(tag.getName());
            mTagInfo.setEnabled(tag.isEnabled());
            mTagInfo.setClosed(tag.isClosed());
            this.mTagsService.updateTag(mTagInfo);
        } else if (!tag.isDeleted()) {
            this.mTagsService.addTagSynchro(tag);
        }
    }

    private void persistTagCatgory(CategoryInfo category) throws BasicException {
        int found;
        List<TagInfo> oldTags = this.m_dlItems.getTagsByCategory(category.getID());
        for (TagInfo oldTag : oldTags) {
            found = -1;
            for (TagInfo newTag : category.getTags()) {
                if (newTag.getNumber() != oldTag.getNumber()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.m_dlItems.deleteTagCategory(category.getID(), oldTag.getId());
        }
        for (TagInfo newTag : category.getTags()) {
            TagInfo tagInfo;
            found = -1;
            for (TagInfo oldTag : oldTags) {
                if (newTag.getNumber() != oldTag.getNumber()) continue;
                found = 1;
            }
            if (found != -1 || (tagInfo = this.mTagsService.findByNumber(newTag.getNumber())) == null) continue;
            newTag.setId(tagInfo.getId());
            newTag.setName(tagInfo.getName());
            this.m_dlItems.addTagCategory(newTag, category.getID());
        }
    }

    public boolean persistGlobal(Object[] infos, boolean remote_synchro) {
        if (!AppLocal.SYNCHRONISATION_IN_PROGRESS) {
            try {
                AppLocal.SYNCHRONISATION_IN_PROGRESS = true;
                this.persistGlobal(infos, remote_synchro, false);
                AppLocal.SYNCHRONISATION_IN_PROGRESS = false;
            }
            catch (BasicException | SQLException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                AppLocal.SYNCHRONISATION_IN_PROGRESS = false;
                return false;
            }
        }
        return true;
    }

    private String getIdSynchGroupSubOption(GroupSubSupplementInfo groupSubOption) {
        return groupSubOption.getId_global() != null && !groupSubOption.getId_global().isEmpty() ? groupSubOption.getId_global() : groupSubOption.getRef_synchro();
    }

    private String getIdSynchGroupOption(SupplementInfo groupOption) {
        return groupOption.getId_global() != null && !groupOption.getId_global().isEmpty() ? groupOption.getId_global() : groupOption.getRef_web();
    }

    private String getIdSynchOption(SupplementItemInfo option) {
        return option.getId_global() != null && !option.getId_global().isEmpty() ? option.getId_global() : option.getRef_web();
    }

    public final int getGOption(SupplementProduct supplementProduct) throws BasicException {
        SupplementInfo groupOption = new SupplementInfo();
        groupOption.setiD(supplementProduct.getiD());
        groupOption.setId_global(supplementProduct.getId_global());
        groupOption.setRef_web(supplementProduct.getiD() != 0 ? String.valueOf(supplementProduct.getiD()) : null);
        return this.getGOption(groupOption);
    }

    private String getIdSynchPromotion(PromotionInfo promotionInfo) {
        return promotionInfo.getId_global() != null && !promotionInfo.getId_global().isEmpty() ? promotionInfo.getId_global() : promotionInfo.getRef_synchro();
    }

    private String getIdSynchCategory(CategoryInfo categoryInfo) {
        return categoryInfo.getId_global() != null && !categoryInfo.getId_global().isEmpty() ? categoryInfo.getId_global() : categoryInfo.getRef_web();
    }

    private String getIdSynchProduct(ProductInfoExt product) {
        return product.getId_global() != null && !product.getId_global().isEmpty() ? product.getId_global() : product.getRef_web();
    }

    private int getProductID(CarteItemInfo item) throws BasicException {
        ProductInfoExt product = new ProductInfoExt();
        product.setRef_web(item.getId_item() != 0 ? String.valueOf(item.getId_item()) : null);
        product.setId_global(item.getId_global_item());
        return this.getProductID(product);
    }

    private String getIdSynchCarte(CarteInfo caretInfo) {
        return caretInfo.getId_global() != null && !caretInfo.getId_global().isEmpty() ? caretInfo.getId_global() : caretInfo.getRef_web();
    }

    private int getCarte(CarteOrderInfo carteOrderInfo) throws BasicException {
        CarteInfo carteInfo = new CarteInfo();
        carteInfo.setRef_web(carteOrderInfo.getId() != 0 ? String.valueOf(carteOrderInfo.getId()) : null);
        carteInfo.setId_global(carteOrderInfo.getId_global());
        return this.getCarte(carteInfo);
    }

    public final int getOption(String ref_web) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT id FROM supplement_item WHERE  REF_WEB = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)ref_web);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public final int getCarte(String ref_web) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT id FROM carte WHERE REF_WEB = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)ref_web);
        return iD != null ? (Integer)iD[0] : -1;
    }

    private void assignTaxesToOptions(List<SupplementInfo> options) throws BasicException {
        for (SupplementInfo option : options) {
            for (SupplementItemInfo item : option.getItems()) {
                TaxInfo tax = this.m_dlSales.getTaxByRate(item.getRateTaxe());
                if (tax == null) continue;
                item.setTaxId(tax.getId());
            }
        }
    }

    private List<SupplementInfo> getOldSupplements() throws BasicException {
        return new PreparedSentence(this.s, this.m_dlSales.requestSupplement + "WHERE S.REMOVED_BY_ADMIN = 0 AND S.removed = 0 ", null, SupplementInfo.getSerializerRead()).list();
    }

    private void refreshSupplements(List<SupplementInfo> options) throws BasicException {
        for (SupplementInfo oldSupplement : this.getOldSupplements()) {
            int found = -1;
            if (oldSupplement.getId_global() != null && !oldSupplement.getId_global().isEmpty()) {
                for (SupplementInfo supplement : options) {
                    if (supplement.getId_global() == null || !String.valueOf(supplement.getId_global()).equals(oldSupplement.getId_global())) continue;
                    found = 1;
                }
            }
            if (found == -1) {
                this.m_dlSales.deleteSupplement(oldSupplement.getiD(), true);
                continue;
            }
            block2: for (SupplementItemInfo oldSupplementItem : this.getOldSupplementItems(oldSupplement.getiD())) {
                found = -1;
                if (oldSupplementItem.getId_global() != null && !oldSupplementItem.getId_global().isEmpty()) {
                    for (SupplementInfo supplement : options) {
                        if (oldSupplement.getId_global() == null || supplement.getId_global() == null || !supplement.getId_global().equals(oldSupplement.getId_global())) continue;
                        for (SupplementItemInfo supplementItem : supplement.getItems()) {
                            if (supplementItem.getId_global() == null || !String.valueOf(supplementItem.getId_global()).equals(oldSupplementItem.getId_global())) continue;
                            found = 1;
                            break;
                        }
                        if (found != -1) continue block2;
                        this.m_dlSales.deleteSupplementItem(oldSupplementItem.getiD(), true);
                        continue block2;
                    }
                    continue;
                }
                this.m_dlSales.deleteSupplementItem(oldSupplementItem.getiD(), true);
            }
        }
    }

    private void updatePrinterLocal(final PrinterInfo printer) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRINTER SET NAME = ?, TYPE = ?, IP = ?, WITH_TICKET = ?, NUMBER_TICKET = ?, typePrinter = ?, MODEL = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, printer.getName());
                this.setString(2, printer.getType());
                this.setString(3, printer.getIp());
                this.setInt(4, printer.getWith());
                this.setInt(5, printer.getNumber());
                this.setString(6, printer.getTypePrinter());
                this.setString(7, printer.getModel());
                this.setInt(8, printer.getId());
            }
        });
    }

    private void addPrinterOnline(final PrinterInfo printer) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PRINTER(NAME, TYPE, IP, WITH_TICKET, NUMBER_TICKET, typePrinter, MODEL ,  REF_WEB, NUMBER_PRINTER) VALUES(?, ?,?,?,?,?,?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, printer.getName());
                this.setString(2, printer.getType());
                this.setString(3, printer.getIp());
                this.setInt(4, printer.getWith());
                this.setInt(5, printer.getNumber());
                this.setString(6, printer.getTypePrinter());
                this.setString(7, printer.getModel());
                this.setString(8, String.valueOf(printer.getId()));
                this.setInt(9, printer.getId());
            }
        });
    }

    private List<CarteInfo> getOldFamilleProdcuts() throws BasicException {
        return new PreparedSentence(this.s, this.m_dlSales.requestCarte + "WHERE REMOVED_BY_ADMIN = 0 AND removed = 0 ", null, CarteInfo.getSerializerRead()).list();
    }

    private void refreshFamillesProducts(List<CarteInfo> cartes) throws BasicException {
        for (CarteInfo oldCarte : this.getOldFamilleProdcuts()) {
            int found = -1;
            if (oldCarte.getId_global() != null && !oldCarte.getId_global().isEmpty()) {
                for (CarteInfo carte : cartes) {
                    if (carte.getId_global() == null || !String.valueOf(carte.getId_global()).equals(oldCarte.getId_global())) continue;
                    found = 1;
                }
            }
            if (found != -1) continue;
            this.m_dlSales.deleteCarte(oldCarte.getId(), true);
        }
    }

    private List<SupplementItemInfo> getOldSupplementItems(int idSupplement) throws BasicException {
        return new PreparedSentence(this.s, this.m_dlSales.requestSuppItem + "WHERE S.id_supplement = ? AND S.REMOVED_BY_ADMIN = 0 AND S.removed = 0 ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).list((Object)idSupplement);
    }

    public final int getOptionPriceByTypeOrder(final String type_order, final int idOption) throws BasicException {
        String request_type_order = type_order == null ? " TYPE_ORDER is null " : " TYPE_ORDER = ? ";
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT ID FROM SUPPLEMENT_ITEM_PRICES WHERE SUPPLEMENT_ID = ? AND " + request_type_order, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idOption);
                if (type_order != null) {
                    this.setString(2, type_order);
                }
            }
        });
        return iD != null ? (Integer)iD[0] : -1;
    }

    private void updateIngredientProduct(final ItemIngredientInfo itemIngredient) throws BasicException {
        final int idOption = this.getItemIngredient(itemIngredient);
        if (idOption != -1) {
            new PreparedSentence(this.s, "UPDATE ITEM_INGREDIENTS SET quantity = ? WHERE id_supplement_item = ? AND id_item = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, itemIngredient.getQuantity());
                    this.setInt(2, idOption);
                    this.setInt(3, itemIngredient.getId_item());
                }
            });
        }
    }

    private String getIdSynchItemIngredient(ItemIngredientInfo ingredient) {
        return ingredient.getId_global() != null && !ingredient.getId_global().isEmpty() ? ingredient.getId_global() : String.valueOf(ingredient.getId_supplement_item());
    }

    public final int getItemIngredient(ItemIngredientInfo ingredient) throws BasicException {
        String DB_COLUMN_TO_CHECK;
        String idSynchro = this.getIdSynchItemIngredient(ingredient);
        String string = DB_COLUMN_TO_CHECK = ingredient.getId_global() != null && !ingredient.getId_global().isEmpty() ? "ITEM_PLU" : "REF_WEB";
        if (this.merge) {
            Integer idOption = this.ids_options.get(idSynchro);
            return idOption != null ? idOption : -1;
        }
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT id FROM supplement_item WHERE  " + DB_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idSynchro);
        return iD != null ? (Integer)iD[0] : -1;
    }

    private void persistZone(ZoneInfo mZoneInfo) throws BasicException {
        ZoneInfo zone = this.m_dlSales.getZoneInfoByref_id(mZoneInfo.getId());
        if (zone == null) {
            zone = new ZoneInfo();
        }
        zone.setName(mZoneInfo.getName());
        zone.setPosition(mZoneInfo.getPosition());
        zone.setColor(mZoneInfo.getColor());
        zone.setRef_id(mZoneInfo.getId());
        this.m_dlSales.upsertZone(zone);
    }

    private void persistNutri(NutrientData mNutrientData) throws BasicException {
        NutrientDataService mNutrientDataService = NutrientDataService.getInstance();
        mNutrientDataService.update(mNutrientData);
    }
}

