/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.format.Formats;
import com.openbravo.models.ProfitMargin;
import com.openbravo.models.RankCategory;
import com.openbravo.models.RankProduct;
import com.openbravo.models.RankProductDiver;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.models.RankUser;
import com.openbravo.models.TopCategory;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.openbravo.pos.ticket.DayDateInfo;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.HourInfo;
import com.openbravo.pos.ticket.IntegerDateInfo;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.ResumeTotalTax;
import com.openbravo.pos.ticket.TaxLineTicket;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.StaticSentence;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataLogicStats
extends BeanFactoryDataSingle {
    protected Session s;
    protected PreparedStatement pstmt;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    String requestFacture = "SELECT F.id, F.company, F.name_contact,F.address, F.zip_code, F.city, F.country, F.siret, F.code_NAF, F.num_tva, F.ticket, F.physical_person, F.cancel, F.nb_print, F.signature, F.date_created, F.num_doc, T.total FROM FACTURE F JOIN TICKETS T ON F.ticket = T.ID ";

    public DataLogicStats() throws SQLException {
        String db_url = AppLocal.db_url;
    }

    @Override
    public void init(Session s) {
        this.s = s;
    }

    public Integer getCountOrderByDate(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(T.ID) FROM TICKETS T WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales != null) {
            return new Integer((Integer)recsales[0]);
        }
        return 0;
    }

    public BigDecimal getTurnoverByDate(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM  TICKETS T WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales != null) {
            return new BigDecimal((Double)recsales[0]);
        }
        return new BigDecimal(0);
    }

    public ProfitMargin geProfitMarginByDate(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.TOTAL) AS CA_TOTAL, SUM(TL.UNITS * TL.PRICE) AS CA_ITEM, SUM(TL.UNITS * P.PRICEBUY) as PRICE_BUYED FROM PRODUCTS P LEFT JOIN TICKETLINES TL ON P.ID = TL.PRODUCT LEFT JOIN TICKETS T ON T.ID = TL.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales != null) {
            return new ProfitMargin((Double)recsales[0], (Double)recsales[1], (Double)recsales[2]);
        }
        return new ProfitMargin();
    }

    public BigDecimal getTurnoverByDatePaymentType(final Date dateStart, final Date dateEnd, final String paymentType) throws BasicException {
        Object q = "SELECT SUM(P.TOTAL) FROM PAYMENTS P LEFT JOIN TICKETS T ON P.RECEIPT  = T.ID WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? ";
        q = paymentType.equals("cash") ? (String)q + " AND (P.PAYMENT = ? OR P.PAYMENT = 'Espece') " : (String)q + " AND P.PAYMENT = ? ";
        Object[] recsales = (Object[])new StaticSentence(this.s, (String)q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
                this.setString(3, paymentType);
            }
        });
        if (recsales != null) {
            return new BigDecimal((Double)recsales[0]);
        }
        return new BigDecimal(0);
    }

    public Map<String, Double> getTopFiveItem(final Date dateStart, final Date dateEnd) throws BasicException {
        String q = "SELECT P.NAME,SUM(TL.UNITS) AS QUANTITY FROM PRODUCTS P LEFT JOIN TICKETLINES TL ON P.ID = TL.PRODUCT LEFT JOIN TICKETS T ON T.ID = TL.TICKET WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY P.NAME ORDER BY QUANTITY DESC FETCH FIRST 5 rows only";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.DOUBLE})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        HashMap<String, Double> m_values = new HashMap<String, Double>();
        for (Object[] next : recQuery) {
            m_values.put((String)next[0], (Double)next[1]);
        }
        return m_values;
    }

    public List<RankProduct> getRankItems(final Date dateStart, final Date dateEnd, String categoryName) throws BasicException {
        Object qCondition = "";
        if (categoryName != null && !categoryName.equals("")) {
            qCondition = " AND CT.NAME LIKE '" + categoryName + "' ";
        }
        String q = "SELECT P.NAME, CT.NAME AS CATEGORY_NAME, SUM(TL.UNITS) AS QUANTITY, SUM (TL.HTAMOUNT + TL.TAXAMOUNT) AS AMOUNT, SUM (CASE WHEN T.TYPE = 'Sur Place' THEN 1 ELSE 0 END) AS AT_SPOT, SUM (CASE WHEN T.TYPE = 'A Emporter' THEN 1 ELSE 0 END) AS TAKE_AWAY, SUM (CASE WHEN T.TYPE = 'En Livraison' THEN 1 ELSE 0 END) AS DELIVERY, SUM (CASE WHEN T.TYPE = 'Uber Eats' THEN 1 ELSE 0 END) AS UBER, SUM (CASE WHEN T.TYPE = 'Delivero' THEN 1 ELSE 0 END) AS Delivero, SUM (CASE WHEN T.TYPE = 'Just Eat' THEN 1 ELSE 0 END) AS JustEat, SUM (CASE WHEN T.TYPE = 'Drive' THEN 1 ELSE 0 END) AS Drive, SUM (CASE WHEN T.TYPE = 'Smood' THEN 1 ELSE 0 END) AS Smood, COUNT(T.TYPE) as COUNT_ALL_ORDERS FROM PRODUCTS P LEFT JOIN TICKETLINES TL ON P.ID = TL.PRODUCT LEFT JOIN TICKETS T ON T.ID = TL.TICKET LEFT JOIN CATEGORIES CT ON P.CATEGORY = CT.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? " + (String)qCondition + "GROUP BY P.NAME, CT.NAME ORDER BY QUANTITY DESC";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankProduct> rows = new ArrayList<RankProduct>();
        for (Object[] next : recQuery) {
            Integer countOrders = (Integer)next[12];
            rows.add(new RankProduct((String)next[0], (String)next[1], ((Double)next[2]).intValue(), Formats.CURRENCY.formatValue((Double)next[3]), NumericUtils.getPercent(countOrders, (Integer)next[4]), NumericUtils.getPercent(countOrders, (Integer)next[5]), NumericUtils.getPercent(countOrders, (Integer)next[6]), NumericUtils.getPercent(countOrders, (Integer)next[7]), NumericUtils.getPercent(countOrders, (Integer)next[8]), NumericUtils.getPercent(countOrders, (Integer)next[9]), NumericUtils.getPercent(countOrders, (Integer)next[10]), NumericUtils.getPercent(countOrders, (Integer)next[11])));
        }
        return rows;
    }

    public final List<RankProductDiver> getRankItemDivers(final Date dateStart, final Date dateEnd) throws BasicException {
        List items = new StaticSentence(this.s, "SELECT P.PRODUCT, P.UNITS, (P.PRICE * P.UNITS) as PRICE FROM PRODUCT_DIVERS P LEFT JOIN TICKETS T ON T.ID = P.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? ", SerializerWriteParams.INSTANCE, RankProductDiver.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return items;
    }

    public List<RankProduct> getRankItems(final Date dateStart, final Date dateEnd, int idCategory) throws BasicException {
        Object qCondition = "";
        if (idCategory != 0) {
            qCondition = " AND CT.ID =" + idCategory + " ";
        }
        String q2 = "SELECT P.NAME, CT.NAME AS CATEGORY_NAME, SUM(L.QUANTITE) AS QUANTITY, SUM (L.TOTAL_TTC) AS AMOUNT, SUM (CASE WHEN T.TYPE = 'Sur Place' THEN 1 ELSE 0 END) AS AT_SPOT, SUM (CASE WHEN T.TYPE = 'A Emporter' THEN 1 ELSE 0 END) AS TAKE_AWAY, SUM (CASE WHEN T.TYPE = 'En Livraison' THEN 1 ELSE 0 END) AS DELIVERY, SUM (CASE WHEN T.TYPE = 'Uber Eats' THEN 1 ELSE 0 END) AS UBER, SUM (CASE WHEN T.TYPE = 'Delivero' THEN 1 ELSE 0 END) AS Delivero, SUM (CASE WHEN T.TYPE = 'Just Eat' THEN 1 ELSE 0 END) AS JustEat, SUM (CASE WHEN T.TYPE = 'Drive' THEN 1 ELSE 0 END) AS Drive, SUM (CASE WHEN T.TYPE = 'Smood' THEN 1 ELSE 0 END) AS Smood, COUNT(T.TYPE) as COUNT_ALL_ORDERS FROM PRODUCTS P LEFT JOIN LINES L ON P.ID = cast(L.CODE_PRODUCT as Integer) LEFT JOIN TICKETS T ON T.ID = L.TICKET LEFT JOIN CATEGORIES CT ON P.CATEGORY = CT.ID WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND L.TIMESTAMPGDH >= ? AND L.TIMESTAMPGDH <= ? " + (String)qCondition + "GROUP BY P.NAME, CT.NAME ORDER BY QUANTITY DESC";
        List recQuery = new StaticSentence(this.s, q2, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankProduct> rows = new ArrayList<RankProduct>();
        for (Object[] next : recQuery) {
            Integer countOrders = (Integer)next[12];
            rows.add(new RankProduct((String)next[0], (String)next[1], ((Double)next[2]).intValue(), Formats.CURRENCY.formatValue((Double)next[3]), NumericUtils.getPercent(countOrders, (Integer)next[4]), NumericUtils.getPercent(countOrders, (Integer)next[5]), NumericUtils.getPercent(countOrders, (Integer)next[6]), NumericUtils.getPercent(countOrders, (Integer)next[7]), NumericUtils.getPercent(countOrders, (Integer)next[8]), NumericUtils.getPercent(countOrders, (Integer)next[9]), NumericUtils.getPercent(countOrders, (Integer)next[10]), NumericUtils.getPercent(countOrders, (Integer)next[11])));
        }
        return rows;
    }

    public List<TopCategory> getTopFiveCategorie(final Date dateStart, final Date dateEnd) throws BasicException {
        String q = "SELECT CT.NAME, SUM(TL.UNITS) AS QUANTITY, SUM(TL.HTAMOUNT + TL.TAXAMOUNT) AS AMOUNTFROM CATEGORIES CT LEFT JOIN PRODUCTS P ON P.CATEGORY = CT.ID LEFT JOIN TICKETLINES TL ON P.ID = TL.PRODUCT LEFT JOIN TICKETS T ON T.ID = TL.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY CT.NAME ORDER BY QUANTITY DESC FETCH FIRST 5 rows only";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.DOUBLE, Datas.DOUBLE})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<TopCategory> m_values = new ArrayList<TopCategory>();
        for (Object[] next : recQuery) {
            Double qte = (Double)next[1];
            m_values.add(new TopCategory((String)next[0], qte.intValue(), (Double)next[2]));
        }
        return m_values;
    }

    public List<RankCategory> getRankCategories(final Date dateStart, final Date dateEnd, boolean useTimePaid) throws BasicException {
        String q = "";
        q = useTimePaid ? "SELECT CT.ID, CT.NAME, SUM(L.QUANTITE) AS QUANTITY, SUM(L.TOTAL_TTC) AS AMOUNT, SUM (CASE WHEN T.TYPE = 'Sur Place' THEN 1 ELSE 0 END) AS AT_SPOT, SUM (CASE WHEN T.TYPE = 'A Emporter' THEN 1 ELSE 0 END) AS TAKE_AWAY, SUM (CASE WHEN T.TYPE = 'En Livraison' THEN 1 ELSE 0 END) AS DELIVERY, SUM (CASE WHEN T.TYPE = 'Uber Eats' THEN 1 ELSE 0 END) AS UBER, SUM (CASE WHEN T.TYPE = 'Delivero' THEN 1 ELSE 0 END) AS Delivero, SUM (CASE WHEN T.TYPE = 'Just Eat' THEN 1 ELSE 0 END) AS JustEat, SUM (CASE WHEN T.TYPE = 'Drive' THEN 1 ELSE 0 END) AS Drive, SUM (CASE WHEN T.TYPE = 'Smood' THEN 1 ELSE 0 END) AS Smood, COUNT(T.TYPE) as COUNT_ALL_ORDERS FROM PRODUCTS P LEFT JOIN CATEGORIES CT ON P.CATEGORY = CT.ID LEFT JOIN LINES L ON P.ID = cast(L.CODE_PRODUCT as Integer) LEFT JOIN TICKETS T ON   L.TICKET= T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND L.TIMESTAMPGDH >= ? AND L.TIMESTAMPGDH < ? GROUP BY CT.ID, CT.NAME ORDER BY QUANTITY DESC" : "SELECT CT.ID, CT.NAME, SUM(TL.UNITS) AS QUANTITY, SUM(TL.HTAMOUNT + TL.TAXAMOUNT) AS AMOUNT, SUM (CASE WHEN T.TYPE = 'Sur Place' THEN 1 ELSE 0 END) AS AT_SPOT, SUM (CASE WHEN T.TYPE = 'A Emporter' THEN 1 ELSE 0 END) AS TAKE_AWAY, SUM (CASE WHEN T.TYPE = 'En Livraison' THEN 1 ELSE 0 END) AS DELIVERY, SUM (CASE WHEN T.TYPE = 'Uber Eats' THEN 1 ELSE 0 END) AS UBER, SUM (CASE WHEN T.TYPE = 'Delivero' THEN 1 ELSE 0 END) AS Delivero, SUM (CASE WHEN T.TYPE = 'Just Eat' THEN 1 ELSE 0 END) AS JustEat, SUM (CASE WHEN T.TYPE = 'Drive' THEN 1 ELSE 0 END) AS Drive, SUM (CASE WHEN T.TYPE = 'Smood' THEN 1 ELSE 0 END) AS Smood, COUNT(T.TYPE) as COUNT_ALL_ORDERS FROM CATEGORIES CT LEFT JOIN PRODUCTS P ON P.CATEGORY = CT.ID LEFT JOIN TICKETLINES TL ON P.ID = TL.PRODUCT LEFT JOIN TICKETS T ON T.ID = TL.TICKET WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY CT.ID, CT.NAME ORDER BY QUANTITY DESC";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankCategory> m_values = new ArrayList<RankCategory>();
        for (Object[] next : recQuery) {
            Double qte = (Double)next[2];
            Integer countOrders = (Integer)next[12];
            m_values.add(new RankCategory((Integer)next[0], (String)next[1], qte.intValue(), Formats.CURRENCY.formatValue((Double)next[3]), NumericUtils.getPercent(countOrders, (Integer)next[4]), NumericUtils.getPercent(countOrders, (Integer)next[5]), NumericUtils.getPercent(countOrders, (Integer)next[6]), NumericUtils.getPercent(countOrders, (Integer)next[7]), NumericUtils.getPercent(countOrders, (Integer)next[8]), NumericUtils.getPercent(countOrders, (Integer)next[9]), NumericUtils.getPercent(countOrders, (Integer)next[10]), NumericUtils.getPercent(countOrders, (Integer)next[11])));
        }
        return m_values;
    }

    public List<RankCategory> getRankCategories(Date dateStart, Date dateEnd) throws BasicException {
        return this.getRankCategories(dateStart, dateEnd, true);
    }

    public final List<HourInfo> loadSatisticByHour(final Date dateStart, final Date dateEnd, boolean useTimePaid) throws BasicException {
        String query = "";
        query = useTimePaid ? "SELECT SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS orders, SUM(T.total) as turnover, HOUR(G.TIMESTAMPGDH ) , min(G.TIMESTAMPGDH ) as jour FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?  GROUP BY HOUR(G.TIMESTAMPGDH ) order by jour " : "SELECT SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS orders, SUM(T.total) as turnover, HOUR(T.CREATED) , min(T.CREATED) as jour FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE  T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND T.CREATED >= ? AND T.CREATED < ?  GROUP BY HOUR(T.CREATED) order by jour ";
        List infos = new PreparedSentence(this.s, query, SerializerWriteParams.INSTANCE, HourInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return infos;
    }

    public final List<HourInfo> loadSatisticByHour(Date dateStart, Date dateEnd) throws BasicException {
        return this.loadSatisticByHour(dateStart, dateEnd, true);
    }

    public final List<DayDateInfo> loadSatisticByWeek(final Date dateStart, final Date dateEnd, boolean useTimePaid) throws BasicException {
        String query = "";
        query = useTimePaid ? "SELECT SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS orders, SUM(T.total) as turnover, DATE(G.TIMESTAMPGDH) FROM GRAND_TOTAL G JOIN TICKETS T ON G.TICKET = T.ID WHERE T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH <= ? GROUP BY DATE(G.TIMESTAMPGDH)" : "SELECT SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS orders, SUM(T.total) as turnover, DATE(T.CREATED) FROM GRAND_TOTAL G JOIN TICKETS T ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY DATE(T.CREATED)";
        List infos = new PreparedSentence(this.s, query, SerializerWriteParams.INSTANCE, DayDateInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return infos;
    }

    public final List<DayDateInfo> loadSatisticByWeek(Date dateStart, Date dateEnd) throws BasicException {
        return this.loadSatisticByWeek(dateStart, dateEnd, true);
    }

    public final List<IntegerDateInfo> loadSatisticByMonth(final Date dateStart, final Date dateEnd, boolean useTimePaid) throws BasicException {
        String query = "";
        query = useTimePaid ? "SELECT SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS orders, SUM(T.total) as turnover, DAY(G.TIMESTAMPGDH) FROM GRAND_TOTAL G JOIN TICKETS T ON G.TICKET = T.ID WHERE T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH <= ? GROUP BY DAY(G.TIMESTAMPGDH)  order by DAY(G.TIMESTAMPGDH)" : "SELECT SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS orders, SUM(T.total) as turnover, DAY(T.CREATED) FROM GRAND_TOTAL G JOIN TICKETS T ON G.TICKET = T.ID WHERE T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY DAY(T.CREATED)  order by DAY(T.CREATED)";
        List infos = new PreparedSentence(this.s, query, SerializerWriteParams.INSTANCE, IntegerDateInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return infos;
    }

    public final List<IntegerDateInfo> loadSatisticByMonth(Date dateStart, Date dateEnd) throws BasicException {
        return this.loadSatisticByMonth(dateStart, dateEnd, true);
    }

    public final List<IntegerDateInfo> loadSatisticByYear(final Date dateStart, final Date dateEnd, boolean useTimePaid) throws BasicException {
        String query = "";
        query = useTimePaid ? "SELECT SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS orders, SUM(T.total) as turnover, MONTH(G.TIMESTAMPGDH) FROM GRAND_TOTAL G JOIN TICKETS T ON G.ticket = T.ID WHERE T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH <= ? GROUP BY MONTH(G.TIMESTAMPGDH)" : "SELECT SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS orders, SUM(T.total) as turnover, MONTH(T.CREATED) FROM GRAND_TOTAL G JOIN TICKETS T ON G.ticket = T.ID WHERE T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY MONTH(T.CREATED)";
        List infos = new PreparedSentence(this.s, query, SerializerWriteParams.INSTANCE, IntegerDateInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return infos;
    }

    public final List<IntegerDateInfo> loadSatisticByYear(Date dateStart, Date dateEnd) throws BasicException {
        return this.loadSatisticByYear(dateStart, dateEnd, true);
    }

    public final List<RankTypeOrder> loadSatisticOrderByType(final Date dateStart, final Date dateEnd, boolean useTimePaid) throws BasicException {
        String q = "";
        q = useTimePaid ? "SELECT t.type, COUNT(t.ID) as COUNTER, SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS COUNTER_PAID, SUM(t.TOTAL) as CA FROM TICKETS as t LEFT JOIN GRAND_TOTAL as G on t.ID = G.TICKET WHERE t.paid = 1 AND t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH <= ? GROUP BY t.type" : "SELECT t.type, COUNT(t.ID) as COUNTER, SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS COUNTER_PAID, SUM(t.TOTAL) as CA FROM TICKETS as t LEFT JOIN GRAND_TOTAL as G on t.ID = G.TICKET WHERE  t.paid = 1 AND t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY t.type";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankTypeOrder> types = new ArrayList<RankTypeOrder>();
        double caTotal = 0.0;
        double countOrders = 0.0;
        for (Object[] objectArray : recQuery) {
            Double count = (Double)objectArray[2];
            Double ca = (Double)objectArray[3];
            caTotal += ca.doubleValue();
            countOrders += count.doubleValue();
            types.add(new RankTypeOrder((String)objectArray[0], ca, count));
        }
        for (RankTypeOrder rankTypeOrder : types) {
            rankTypeOrder.setCa_percent(NumericUtils.getPercent(caTotal, rankTypeOrder.getCa()));
            rankTypeOrder.setCount_percent(NumericUtils.getPercent((int)countOrders, (int)rankTypeOrder.getCount()));
            rankTypeOrder.setTotal((int)countOrders);
        }
        return types;
    }

    public final List<RankTypeOrder> loadSatisticOrderByType(Date dateStart, Date dateEnd) throws BasicException {
        return this.loadSatisticOrderByType(dateStart, dateEnd, true);
    }

    public List<RankCategory> getRankCategoriesOption(final Date dateStart, final Date dateEnd) throws BasicException {
        String q = "SELECT S.NAME, SUM(OT.NUMBEROPTION) AS QUANTITY, SUM(OT.NUMBEROPTION * OT.PRICE) AS AMOUNT, SUM (CASE WHEN T.TYPE = 'Sur Place' THEN 1 ELSE 0 END) AS AT_SPOT, SUM (CASE WHEN T.TYPE = 'A Emporter' THEN 1 ELSE 0 END) AS TAKE_AWAY, SUM (CASE WHEN T.TYPE = 'En Livraison' THEN 1 ELSE 0 END) AS DELIVERY, SUM (CASE WHEN T.TYPE = 'Uber Eats' THEN 1 ELSE 0 END) AS UBER, SUM (CASE WHEN T.TYPE = 'Delivero' THEN 1 ELSE 0 END) AS Delivero, SUM (CASE WHEN T.TYPE = 'Just Eat' THEN 1 ELSE 0 END) AS JustEat, SUM (CASE WHEN T.TYPE = 'Drive' THEN 1 ELSE 0 END) AS Drive, SUM (CASE WHEN T.TYPE = 'Smood' THEN 1 ELSE 0 END) AS Smood, COUNT(T.TYPE) as COUNT_ALL_ORDERS FROM SUPPLEMENT S LEFT JOIN SUPPLEMENT_ITEM SI ON SI.ID_SUPPLEMENT = S.ID LEFT JOIN OPTION_TICKET OT ON OT.IDOPTION =  SI.ID LEFT JOIN TICKETLINES TL ON OT.IDTICKETLINE = TL.ID LEFT JOIN TICKETS T ON T.ID = TL.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY S.NAME ORDER BY QUANTITY DESC";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankCategory> m_values = new ArrayList<RankCategory>();
        for (Object[] next : recQuery) {
            Double qte = (Double)next[1];
            Integer countOrders = (Integer)next[11];
            m_values.add(new RankCategory((String)next[0], qte.intValue(), Formats.CURRENCY.formatValue((Double)next[2]), NumericUtils.getPercent(countOrders, (Integer)next[3]), NumericUtils.getPercent(countOrders, (Integer)next[4]), NumericUtils.getPercent(countOrders, (Integer)next[5]), NumericUtils.getPercent(countOrders, (Integer)next[6]), NumericUtils.getPercent(countOrders, (Integer)next[7]), NumericUtils.getPercent(countOrders, (Integer)next[8]), NumericUtils.getPercent(countOrders, (Integer)next[9]), NumericUtils.getPercent(countOrders, (Integer)next[10])));
        }
        return m_values;
    }

    public List<RankProduct> getRankOptions(final Date dateStart, final Date dateEnd, String categoryName) throws BasicException {
        Object qCondition = "";
        if (categoryName != null && !categoryName.equals("")) {
            qCondition = " AND S.NAME LIKE '" + categoryName + "' ";
        }
        String q = "SELECT OT.NAMEOPTION, S.NAME, SUM(OT.NUMBEROPTION) AS QUANTITY, SUM(OT.NUMBEROPTION * OT.PRICE) AS AMOUNT, SUM (CASE WHEN T.TYPE = 'Sur Place' THEN 1 ELSE 0 END) AS AT_SPOT, SUM (CASE WHEN T.TYPE = 'A Emporter' THEN 1 ELSE 0 END) AS TAKE_AWAY, SUM (CASE WHEN T.TYPE = 'En Livraison' THEN 1 ELSE 0 END) AS DELIVERY, SUM (CASE WHEN T.TYPE = 'Uber Eats' THEN 1 ELSE 0 END) AS UBER, SUM (CASE WHEN T.TYPE = 'Delivero' THEN 1 ELSE 0 END) AS Delivero, SUM (CASE WHEN T.TYPE = 'Just Eat' THEN 1 ELSE 0 END) AS JustEat, SUM (CASE WHEN T.TYPE = 'Drive' THEN 1 ELSE 0 END) AS Drive, SUM (CASE WHEN T.TYPE = 'Smood' THEN 1 ELSE 0 END) AS Smood, COUNT(T.TYPE) as COUNT_ALL_ORDERS FROM SUPPLEMENT S LEFT JOIN SUPPLEMENT_ITEM SI ON SI.ID_SUPPLEMENT = S.ID LEFT JOIN OPTION_TICKET OT ON OT.IDOPTION =  SI.ID LEFT JOIN TICKETLINES TL ON OT.IDTICKETLINE = TL.ID LEFT JOIN TICKETS T ON T.ID = TL.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? " + (String)qCondition + "GROUP BY OT.NAMEOPTION, S.NAME ORDER BY QUANTITY DESC";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankProduct> rows = new ArrayList<RankProduct>();
        for (Object[] next : recQuery) {
            Integer countOrders = (Integer)next[12];
            rows.add(new RankProduct((String)next[0], (String)next[1], ((Double)next[2]).intValue(), Formats.CURRENCY.formatValue((Double)next[3]), NumericUtils.getPercent(countOrders, (Integer)next[4]), NumericUtils.getPercent(countOrders, (Integer)next[5]), NumericUtils.getPercent(countOrders, (Integer)next[6]), NumericUtils.getPercent(countOrders, (Integer)next[7]), NumericUtils.getPercent(countOrders, (Integer)next[8]), NumericUtils.getPercent(countOrders, (Integer)next[9]), NumericUtils.getPercent(countOrders, (Integer)next[10]), NumericUtils.getPercent(countOrders, (Integer)next[11])));
        }
        return rows;
    }

    public List<RankUser> getRankUsers(final Date dateStart, final Date dateEnd) throws BasicException {
        String q = "SELECT P.NAME, SUM(T.TOTAL) AS AMOUNT, SUM (CASE WHEN T.TYPE = 'Sur Place' THEN 1 ELSE 0 END) AS AT_SPOT, SUM (CASE WHEN T.TYPE = 'A Emporter' THEN 1 ELSE 0 END) AS TAKE_AWAY, SUM (CASE WHEN T.TYPE = 'En Livraison' THEN 1 ELSE 0 END) AS DELIVERY, SUM (CASE WHEN T.TYPE = 'Uber Eats' THEN 1 ELSE 0 END) AS UBER, SUM (CASE WHEN T.TYPE = 'Delivero' THEN 1 ELSE 0 END) AS Delivero, SUM (CASE WHEN T.TYPE = 'Just Eat' THEN 1 ELSE 0 END) AS JustEat, SUM (CASE WHEN T.TYPE = 'Drive' THEN 1 ELSE 0 END) AS Drive, SUM (CASE WHEN T.TYPE = 'Smood' THEN 1 ELSE 0 END) AS Smood, COUNT(T.TYPE) as COUNT_ALL_ORDERS FROM PEOPLE P LEFT JOIN TICKETS T ON T.PERSON = P.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY P.NAME ORDER BY AMOUNT DESC";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.DOUBLE, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.INT})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankUser> m_values = new ArrayList<RankUser>();
        for (Object[] next : recQuery) {
            Double qte = (Double)next[1];
            Integer countOrders = (Integer)next[10];
            m_values.add(new RankUser((String)next[0], NumericUtils.formatToString((Double)next[1]), NumericUtils.getPercent(countOrders, (Integer)next[2]), NumericUtils.getPercent(countOrders, (Integer)next[3]), NumericUtils.getPercent(countOrders, (Integer)next[4]), NumericUtils.getPercent(countOrders, (Integer)next[5]), NumericUtils.getPercent(countOrders, (Integer)next[6]), NumericUtils.getPercent(countOrders, (Integer)next[7]), NumericUtils.getPercent(countOrders, (Integer)next[8]), NumericUtils.getPercent(countOrders, (Integer)next[9])));
        }
        return m_values;
    }

    public ResumeTotalTax getResumeBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        return (ResumeTotalTax)new PreparedSentence(this.s, "SELECT sum(total_tax) , sum (Total_ht) , sum (Total_ttc) from TOTAL_TAX where timestampGDH >= ? and timestampGDH <= ? ", SerializerWriteParams.INSTANCE, ResumeTotalTax.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public Integer getCountModePaymentByDate(final Date dateStart, final Date dateEnd, final String mode_payment) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT  COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID LEFT OUTER JOIN caisse C ON T.caisse = C.ID  WHERE T.CREATED > ? and T.CREATED < ? AND P.PAYMENT=?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
                this.setString(3, mode_payment);
            }
        });
        if (recsales != null) {
            return (Integer)recsales[0];
        }
        return 0;
    }

    public final Double getTotalDiscountOrderOfType(final Date dateStart, final Date dateEnd, final String typeDiscount) throws BasicException {
        String query = typeDiscount.equalsIgnoreCase("pourcentage") ? "select sum ( CASE WHEN discount=100 THEN (select sum(l.quantite * l.price_TTC) from lines l where l.TICKET = T.id) ELSE discount*total/(100-discount) END) from tickets T where " : "select sum (discount) from tickets T where ";
        Object[] recsales = (Object[])new StaticSentence(this.s, query + "   T.paid = 1   AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED > ? AND T.CREATED < ? AND TYPEDISCOUNT = ?  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
                this.setString(3, typeDiscount);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getTotalDiscountOnTicketLines(final Date dateStart, final Date dateEnd) throws BasicException {
        String query = "select sum (li.units * (li.discount*li.price/100)) from ticketlines li ,tickets ti where ti.ID=li.TICKET ";
        Object[] recsales = (Object[])new StaticSentence(this.s, query + " AND ti.paid = 1 AND ti.STATUS <> 'cancel' AND ti.STATUS <> 'Refund' AND ti.CREATED > ? AND ti.CREATED < ?   ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final BigDecimal getTotalPaymentBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(P.TOTAL) as TOTAL FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1  AND T.CREATED >= ? AND T.CREATED <= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales != null) {
            return new BigDecimal((Double)recsales[0]);
        }
        return new BigDecimal(0);
    }

    public final List<PaymentLine> loadPaymentBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return payments;
    }

    public final Integer getNbOrderBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T WHERE T.paid = 1 AND t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ?  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Double getCACanceledByCaisseId(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE  T.paid = 1 AND T.STATUS = 'cancel' AND T.closed = 1 AND T.CREATED BETWEEN ? AND ?   ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public Double getNbProduitBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(L.UNITS) FROM TICKETS T LEFT OUTER JOIN TICKETLINES L ON T.ID = L.TICKET  WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND L.nextElement = 0 AND T.closed = 1 AND T.CREATED BETWEEN ? AND ?  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitDiversBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(P.UNITS) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.closed = 1 AND T.CREATED BETWEEN ? AND ?  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final List<TaxeLine> getTaxeByDateBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE,   SUM(L.TOTAL_TTC), SUM(L.TOTAL_TTC) / (1 + L.RATE_TAX), sum(L.TOTAL_TTC) - (sum(L.TOTAL_TTC) / (1 + L.RATE_TAX))  FROM TICKETS T LEFT OUTER JOIN LINES L ON T.ID = L.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON L.CODE_TAX = X.ID  WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND T.closed = 1 AND T.CREATED BETWEEN ? AND ?  GROUP BY X.NAME, X.ID, X.RATE, L.RATE_TAX", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return asales;
    }

    public final List<TaxeLine> getTaxeDiversByDateBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(P.PRICE*P.UNITS), SUM(P.htAmount), SUM(P.taxAmount) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON P.TAXID = X.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY X.NAME, X.ID, X.RATE", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return asales;
    }

    public final Double getCACanceled(final Date dateOpen, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE  T.paid = 1 AND T.STATUS = 'cancel' AND T.CREATED >= ? AND T.CREATED <= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final List<PaymentLine> loadPaymentXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?   AND (P.PAYMENT<>'Avoir' OR (P.PAYMENT='Avoir' AND P.TOTAL > 0 ) ) GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        List paymentsAvoir = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?    AND  P.PAYMENT='Avoir' AND P.TOTAL<0  GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        payments.addAll(paymentsAvoir);
        return payments;
    }

    public final List<PaymentLine> loadPaymentAvoirTRXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?    AND  P.PAYMENT='Avoir' AND P.TOTAL<0 AND avoir_origin like '%Ticket Resto%' GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public final Double getCACanceledXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS = 'cancel' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        System.out.println("+++++++++ recsales : " + recsales);
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getNbProduitXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(L.UNITS) FROM TICKETS T LEFT OUTER JOIN TICKETLINES L ON T.ID = L.TICKET LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND L.nextElement = 0 AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitDiversXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(P.UNITS) FROM  TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final List<TaxeLine> getTaxeXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE,  SUM(L.TOTAL_TTC), SUM(L.TOTAL_TTC) / (1 + L.RATE_TAX), sum(L.TOTAL_TTC) - (sum(L.TOTAL_TTC) / (1 + L.RATE_TAX)) FROM TICKETS T LEFT OUTER JOIN LINES L ON T.ID = L.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON L.CODE_TAX = X.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ? GROUP BY X.NAME, X.ID, X.RATE, L.RATE_TAX", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return asales;
    }

    public final List<TaxLineTicket> getTaxeXDayTicket(final Date dateStart, final Date dateEnd) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT SUM(TT.TOTAL_TTC),  SUM(TT.TOTAL_TAX), SUM(TT.TOTAL_HT), TT.RATE_TAX FROM TOTAL_TAX TT LEFT OUTER JOIN TICKETS T ON TT.TICKET = T.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ? GROUP BY TT.RATE_TAX", SerializerWriteParams.INSTANCE, TaxLineTicket.getSerializerReadTikcet()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return asales;
    }

    public final List<TaxeLine> getTaxeDiversXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(P.PRICE*P.UNITS), SUM(P.htAmount), SUM(P.taxAmount) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON P.TAXID = X.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?  GROUP BY X.NAME, X.ID, X.RATE", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return asales;
    }

    public final List<UserCaisseInfo> getCAbyUserXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        List users = new StaticSentence(this.s, "SELECT P.ID, P.NAME, SUM(T.total) FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?  GROUP BY P.ID, P.NAME", SerializerWriteParams.INSTANCE, UserCaisseInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return users;
    }

    public final Integer getNbOrderXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public Map<String, Double> loadSatisticShiftByDay(Date date_start, Date date_end) throws BasicException {
        LinkedHashMap<String, Double> mValues = new LinkedHashMap<String, Double>();
        String query = "SELECT SUM(T.total) as turnover FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND T.CREATED >= ? AND T.CREATED < ? ";
        final Date dateStart = (Date)date_start.clone();
        final Date dateEnd = (Date)date_start.clone();
        dateEnd.setMinutes(59);
        dateEnd.setSeconds(59);
        String[] mKeys = new String[]{"06h-14h", "14h-19h", "19h-00h", "00h-06h"};
        Integer[] mStart = new Integer[]{0, 8, 5, 5};
        Integer[] mEnd = new Integer[]{7, 5, 5, 6};
        for (int i = 0; i < 4; ++i) {
            dateStart.setHours(dateStart.getHours() + mStart[i]);
            dateEnd.setHours(dateEnd.getHours() + mEnd[i]);
            Object[] recsales = (Object[])new PreparedSentence(this.s, query, SerializerWriteParams.INSTANCE, new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setTimestamp(1, dateStart);
                    this.setTimestamp(2, dateEnd);
                }
            });
            if (recsales == null) {
                mValues.put(mKeys[i], 0.0);
                continue;
            }
            mValues.put(mKeys[i], (Double)recsales[0]);
        }
        return mValues;
    }

    public final Double loadSatisticByHour(final Date dateStart, final Date dateEnd, final int hour) throws BasicException {
        String query = "SELECT SUM(T.total) as turnover FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND T.CREATED >= ? AND T.CREATED < ? AND HOUR(T.CREATED) = ? ";
        Object[] infos = (Object[])new PreparedSentence(this.s, query, SerializerWriteParams.INSTANCE, new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
                this.setInt(3, hour);
            }
        });
        if (infos == null) {
            return null;
        }
        return (Double)infos[0];
    }

    public final Double getTurnoverPlatformXDay(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T  WHERE T.STATUS <> 'cancel' AND T.CREATED >= ? AND T.CREATED < ? and T.PLATFORM_ORDER = 1 ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final PaymentLine loadPaymentXDay(final Date dateStart, final Date dateEnd, final String type) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ?   AND P.PAYMENT = ? GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
                this.setString(3, type);
            }
        });
        return payments != null && !payments.isEmpty() ? (PaymentLine)payments.get(0) : null;
    }

    public final Double getTurnoverPlatformXDay(final Date dateStart, final Date dateEnd, final String type_order) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE T.paid = 0 AND T.type  = ? AND T.CREATED >= ? AND T.CREATED < ? and T.PLATFORM_ORDER = 1 ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_order);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final List<TaxeLine> getTaxeMEVTEST(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] cumul = (Object[])new StaticSentence(this.s, "SELECT sum(T.TPS), sum(T.TVQ)FROM TICKETS T LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<TaxeLine> taxes = new ArrayList<TaxeLine>();
        taxes.add(new TaxeLine("", "TPS", 0.0, (Double)cumul[0], 0.0, 0.0));
        taxes.add(new TaxeLine("", "TVQ", 0.0, (Double)cumul[0], 0.0, 0.0));
        return taxes;
    }

    public final List<TaxLineTicket> getTaxeUber(final Date dateStart, final Date dateEnd) throws BasicException {
        System.out.println("date start : " + dateStart);
        System.out.println("date end : " + dateEnd);
        List asales = new StaticSentence(this.s, "SELECT SUM(TT.TOTAL_TTC),  SUM(TT.TOTAL_TAX), SUM(TT.TOTAL_HT), TT.RATE_TAX FROM TOTAL_TAX TT LEFT OUTER JOIN TICKETS T ON TT.TICKET = T.ID LEFT OUTER JOIN GRAND_TOTAL G ON G.TICKET = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' and T.type = 'Uber Eats'  AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH < ? GROUP BY TT.RATE_TAX", SerializerWriteParams.INSTANCE, TaxLineTicket.getSerializerReadTikcet()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return asales;
    }

    public final List<GroupedTax> getGlobalTaxes(final Date dateStart, final Date dateEnd) throws BasicException {
        List taxes = new PreparedSentence(this.s, "SELECT TT.CODE_TAX, TC.NAME, TC.RATE, TT.TAXE_GLOBAL, SUM(TT.total_tax), SUM(TT.TOTAL_HT), SUM(TT.TOTAL_TTC) FROM TOTAL_TAX TT JOIN TAXCATEGORIES TC ON TC.ID = TT.CODE_TAX JOIN TICKETS T ON T.ID = TT.TICKET WHERE TT.TAXE_GLOBAL = 1 AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND  T.date_paid >= ? AND T.date_paid < ? GROUP BY TT.CODE_TAX, TC.NAME, TC.RATE, TT.TAXE_GLOBAL ", SerializerWriteParams.INSTANCE, GroupedTax.getSerializerReadGrouped()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return taxes;
    }

    public final TotaleEncaissement getTotalEncaissement(final Date dateStart, final Date dateEnd) throws BasicException {
        TotaleEncaissement totalEncaissement = (TotaleEncaissement)new PreparedSentence(this.s, "SELECT SUM(TE.TOTAL_HT_TAXABLE), SUM(TE.TOTAL_HT_NO_TAXABLE) FROM TOTAL_ENCAISSEMENT TE JOIN TICKETS T ON T.ID = TE.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND  T.date_paid >= ? AND T.date_paid < ? ", SerializerWriteParams.INSTANCE, TotaleEncaissement.getSerializerReadInfoHT()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return totalEncaissement;
    }

    public final List<RankTypeOrder> loadPlatformOrdersByType(final Date dateStart, final Date dateEnd) throws BasicException {
        String q = "";
        q = "SELECT t.type, COUNT(t.ID) as COUNTER, SUM(CASE WHEN t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' THEN 1 ELSE 0 END) AS COUNTER_PAID, SUM(t.TOTAL) as CA FROM TICKETS as t WHERE  t.paid = 0 AND t.platform_order = 1 and sent_from <> 'Dishop' AND t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY t.type";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankTypeOrder> types = new ArrayList<RankTypeOrder>();
        double caTotal = 0.0;
        double countOrders = 0.0;
        for (Object[] objectArray : recQuery) {
            Double count = (Double)objectArray[2];
            Double ca = (Double)objectArray[3];
            caTotal += ca.doubleValue();
            countOrders += count.doubleValue();
            types.add(new RankTypeOrder((String)objectArray[0], ca, count));
        }
        for (RankTypeOrder rankTypeOrder : types) {
            rankTypeOrder.setCa_percent(NumericUtils.getPercent(caTotal, rankTypeOrder.getCa()));
            rankTypeOrder.setCount_percent(NumericUtils.getPercent((int)countOrders, (int)rankTypeOrder.getCount()));
            rankTypeOrder.setTotal((int)countOrders);
        }
        return types;
    }

    public final List<RankTypeOrder> loadHtTotalOrderByType(final Date dateStart, final Date dateEnd) throws BasicException {
        String q = "";
        q = "SELECT t.type, SUM(E.total_ht) as CA FROM TICKETS as t JOIN TOTAL_ENCAISSEMENT as E on t.ID = E.TICKET JOIN GRAND_TOTAL as G on t.ID = G.TICKET WHERE t.paid = 1 AND t.STATUS <> 'cancel' AND t.STATUS <> 'Refund' AND G.TIMESTAMPGDH >= ? AND G.TIMESTAMPGDH <= ? GROUP BY t.type";
        List recQuery = new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.DOUBLE})).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        ArrayList<RankTypeOrder> types = new ArrayList<RankTypeOrder>();
        for (Object[] next : recQuery) {
            Double ca = (Double)next[1];
            types.add(new RankTypeOrder((String)next[0], ca));
        }
        return types;
    }
}

