/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.Hashcypher;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.SignatureGenerator;
import com.openbravo.service.DeletionDetecter;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.DuplicataJustificatifPayment;
import fr.protactile.norm.beans.Facture;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.JustificatifPayment;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.UUID;

public class DataLogicSalesHelper {
    private DeletionDetecter detecter;
    private String FACTURE = "Facture";

    public DataLogicSalesHelper(DeletionDetecter detecter) {
        this.detecter = detecter;
    }

    public int multiplyPositif(TicketInfo ticket) {
        if (ticket.getTicketType() == 1) {
            return -1;
        }
        return 1;
    }

    public GrandTotalTicket createGrandTotal(GrandTotalTicket grandTotalTicket, TicketInfo ticket, int idEntete, StringBuilder ticketEmprinte, double totalTVA5, double totalTVA10, double totalTVA20, double totalTVA0, double totalTVA_7_7, double totalTVA_2_5, double totalTVA_2_1, double totalTVA_8_5, double totalTVA_6, double totalTVA_12, double totalTVA_21, double totalTVA_8_1, double totalTVA_2_6) {
        double cumulPerpetualTicket = 0.0;
        double cumulPerpetualReelTicket = 0.0;
        if (grandTotalTicket != null && !grandTotalTicket.isBefore_perpetual_reset()) {
            cumulPerpetualTicket = grandTotalTicket.getCumulPerpetual() + Math.abs(ticket.getTotalOrder());
            cumulPerpetualReelTicket = grandTotalTicket.getCumulPerpetualReel() + ticket.getTotalOrder();
        } else {
            cumulPerpetualTicket = Math.abs(ticket.getTotalOrder());
            cumulPerpetualReelTicket = ticket.getTotalOrder();
        }
        String id = UUID.randomUUID().toString();
        StringBuilder grandTotalEmprinte = new StringBuilder("");
        grandTotalEmprinte.append((CharSequence)ticketEmprinte);
        Date date = ticket.getLastUpdate();
        if (grandTotalTicket != null) {
            grandTotalEmprinte.append(",").append((long)((double)this.multiplyPositif(ticket) * NumericUtils.round(NumericUtils.round(Math.abs(ticket.getTotalOrder())) * 100.0))).append(",").append((long)NumericUtils.round(NumericUtils.round(cumulPerpetualReelTicket) * 100.0)).append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(date)).append(",").append(String.valueOf(idEntete)).append(",O,").append(grandTotalTicket.getSignature());
        } else {
            grandTotalEmprinte.append(",").append((long)((double)this.multiplyPositif(ticket) * NumericUtils.round(NumericUtils.round(Math.abs(ticket.getTotalOrder())) * 100.0))).append(",").append((long)NumericUtils.round(NumericUtils.round(cumulPerpetualReelTicket) * 100.0)).append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(date)).append(",").append(String.valueOf(idEntete)).append(",N,");
        }
        GrandTotalTicket mGrandGrandTotalTicket = new GrandTotalTicket();
        mGrandGrandTotalTicket.setId(id);
        mGrandGrandTotalTicket.setTimestampGDH(date);
        mGrandGrandTotalTicket.setAdd_perpetual_in_signature(true);
        mGrandGrandTotalTicket.setCumul(ticket.getTotalOrder());
        mGrandGrandTotalTicket.setCumulPerpetual(cumulPerpetualTicket);
        mGrandGrandTotalTicket.setCumulPerpetualReel(cumulPerpetualReelTicket);
        mGrandGrandTotalTicket.setTva5(totalTVA5);
        mGrandGrandTotalTicket.setTva10(totalTVA10);
        mGrandGrandTotalTicket.setTva20(totalTVA20);
        mGrandGrandTotalTicket.setTva_7_7(totalTVA_7_7);
        mGrandGrandTotalTicket.setTva_2_5(totalTVA_2_5);
        mGrandGrandTotalTicket.setTva_2_1(totalTVA_2_1);
        mGrandGrandTotalTicket.setTva_8_5(totalTVA_8_5);
        mGrandGrandTotalTicket.setTva0(totalTVA0);
        mGrandGrandTotalTicket.setTva_6(totalTVA_6);
        mGrandGrandTotalTicket.setTva_12(totalTVA_12);
        mGrandGrandTotalTicket.setTva_21(totalTVA_21);
        mGrandGrandTotalTicket.setTva_8_1(totalTVA_8_1);
        mGrandGrandTotalTicket.setTva_2_6(totalTVA_2_6);
        if (grandTotalEmprinte != null) {
            String[] tab = grandTotalEmprinte.toString().split(",");
            if (this.detecter != null) {
                if (tab[tab.length - 1].equals("N")) {
                    this.detecter.detectDeletion("gttckt", "");
                } else {
                    this.detecter.detectDeletion("gttckt", tab[tab.length - 1]);
                }
            }
        }
        String mStringGrandTotalEmprinte = null;
        if (grandTotalEmprinte != null) {
            mStringGrandTotalEmprinte = grandTotalEmprinte.toString();
        }
        System.out.println("mStringGrandTotalEmprinte : " + mStringGrandTotalEmprinte);
        String signature = this.signer(mStringGrandTotalEmprinte);
        mGrandGrandTotalTicket.setSignature(signature);
        return mGrandGrandTotalTicket;
    }

    public String buildFactureSignature(int multiply, double total, StringBuilder ticketEmprinte, Facture facture, Facture lastFacture, String type_opration) {
        ticketEmprinte.append(",").append((long)((double)multiply * NumericUtils.round(NumericUtils.round(total) * 100.0)));
        ticketEmprinte.append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(facture.getDateFacture()));
        ticketEmprinte.append(",").append(facture.getId());
        ticketEmprinte.append(",").append(type_opration.replace(",", "<"));
        if (facture.isPhysical_person()) {
            ticketEmprinte.append(",P_").append(facture.getName_contact().replace(',', '<'));
            ticketEmprinte.append(",").append(facture.getZip_code().replace(",", "<"));
            ticketEmprinte.append(",");
        } else {
            ticketEmprinte.append(",M_").append(facture.getCompany().replace(',', '<'));
            ticketEmprinte.append(",").append(facture.getZip_code().replace(",", "<"));
            ticketEmprinte.append(",").append(facture.getNum_tva().replace(',', '<'));
        }
        if (lastFacture == null) {
            ticketEmprinte.append(",N,");
        } else {
            ticketEmprinte.append(",O,");
            ticketEmprinte.append(lastFacture.getSignature());
        }
        return ticketEmprinte.toString();
    }

    public String buildDuplicataJustificatifPaymentSignature(DuplicataJustificatifPayment thisDuplicata, DuplicataJustificatifPayment lastDuplicata) {
        StringBuilder justificatifPaymentEmprinte = new StringBuilder();
        justificatifPaymentEmprinte.append(thisDuplicata.getId());
        justificatifPaymentEmprinte.append(",").append(thisDuplicata.getType_doc().replace(',', '<').replace(' ', '_'));
        justificatifPaymentEmprinte.append(",").append(thisDuplicata.getImpression_number());
        justificatifPaymentEmprinte.append(",").append(thisDuplicata.getCode_user());
        justificatifPaymentEmprinte.append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(thisDuplicata.getDate_impression()));
        justificatifPaymentEmprinte.append(",").append(thisDuplicata.getNum_justificatif_payment());
        justificatifPaymentEmprinte.append(",").append(thisDuplicata.getMotif_impression().replace(',', '<').replace(' ', '_'));
        if (lastDuplicata == null) {
            justificatifPaymentEmprinte.append(",N,");
        } else {
            justificatifPaymentEmprinte.append(",O,");
            justificatifPaymentEmprinte.append(lastDuplicata.getSignature());
        }
        return justificatifPaymentEmprinte.toString();
    }

    public String buildSignatureJustificatifPayment(TicketInfo ticket, JustificatifPayment thisJustificatifPayment, JustificatifPayment lastJustificatifPayment) {
        StringBuilder justificatifPaymentEmprinte = new StringBuilder();
        justificatifPaymentEmprinte.append(thisJustificatifPayment.getId());
        justificatifPaymentEmprinte.append(",").append((long)((double)this.multiplyPositif(ticket) * NumericUtils.round(NumericUtils.round(ticket.getTotalOrder()) * 100.0)));
        justificatifPaymentEmprinte.append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(thisJustificatifPayment.getTimestampGDH()));
        justificatifPaymentEmprinte.append(",").append(thisJustificatifPayment.getRef_ticket());
        if (lastJustificatifPayment == null) {
            justificatifPaymentEmprinte.append(",N,");
        } else {
            justificatifPaymentEmprinte.append(",O,");
            justificatifPaymentEmprinte.append(lastJustificatifPayment.getSignature());
        }
        return justificatifPaymentEmprinte.toString();
    }

    public String buildDuplicataSignature(Duplicata thisDuplicata, Duplicata lastDuplicata) {
        return this.buildDuplicataSignature(thisDuplicata, lastDuplicata, thisDuplicata.getRef_facture(), thisDuplicata.getRef_ticket());
    }

    public String buildDuplicataSignature(Duplicata thisDuplicata, Duplicata lastDuplicata, int ref_facture, int ref_ticket) {
        StringBuilder duplicataEmprinte = new StringBuilder();
        duplicataEmprinte.append(thisDuplicata.getId());
        duplicataEmprinte.append(",").append(thisDuplicata.getType_doc().replace(',', '<').replace(' ', '_'));
        duplicataEmprinte.append(",").append(thisDuplicata.getImpression_Number());
        duplicataEmprinte.append(",").append(thisDuplicata.getUser_operator());
        duplicataEmprinte.append(",").append(DateUtils.SDF_DATE_SIGNATURE.format(thisDuplicata.getDate_impression()));
        if (thisDuplicata.getType_doc() != null && thisDuplicata.getType_doc().equalsIgnoreCase(this.FACTURE)) {
            duplicataEmprinte.append(",").append(ref_facture);
        } else {
            duplicataEmprinte.append(",").append(ref_ticket);
        }
        if (lastDuplicata == null) {
            duplicataEmprinte.append(",N,");
        } else {
            duplicataEmprinte.append(",O,");
            duplicataEmprinte.append(lastDuplicata.getPrevious_sign());
        }
        return duplicataEmprinte.toString();
    }

    public String signer(String ticketEmprinte) {
        if (ticketEmprinte != null) {
            String result = ticketEmprinte.replace(' ', '_');
            try {
                SignatureGenerator generator = SignatureGenerator.getGenerator();
                String data = new String(result.getBytes("UTF-8"));
                String signature = generator.digitalSign(data);
                return signature;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return null;
    }

    public String get4lastCharsOfKeenio(String key) {
        try {
            String cleanedKeenIo = key.replaceAll("[^0-9]", "");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md5.digest(cleanedKeenIo.getBytes(StandardCharsets.UTF_8));
            String code = Hashcypher.bytesToHex(hashBytes).substring(Hashcypher.bytesToHex(hashBytes).length() - 4);
            return code;
        }
        catch (NoSuchAlgorithmException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }
}

