/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.beans.CarteMenu;
import com.openbravo.beans.ProductSupplementsRelation;
import com.openbravo.beans.ProdustIngredientRelation;
import com.openbravo.dao.DAOConstants;
import com.openbravo.dao.DataLogicEmployees;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSalesHelper;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerReadClass;
import com.openbravo.data.loader.SerializerReadString;
import com.openbravo.data.loader.SerializerWriteBasicExt;
import com.openbravo.data.loader.SerializerWriteInteger;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.inventory.LocationInfo;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.CaisseZ;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CarteItemInfo;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.CategoryStatisticInfo;
import com.openbravo.pos.ticket.DayInfo;
import com.openbravo.pos.ticket.Document;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.HourInfo;
import com.openbravo.pos.ticket.ItemIngredientInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.LivreurInfo;
import com.openbravo.pos.ticket.LogPanier;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.OrderDetailsInfo;
import com.openbravo.pos.ticket.OrderInfo;
import com.openbravo.pos.ticket.OrderStatisticInfo;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.ProduitStatistic;
import com.openbravo.pos.ticket.ResumeTotalTax;
import com.openbravo.pos.ticket.SALLEINFO;
import com.openbravo.pos.ticket.StockHistoryInfo;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TableInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TaxLineTicket;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TicketResto;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.ticket.ZoneInfo;
import com.openbravo.pos.ticket.journalInfo;
import com.openbravo.pos.ticket.orderPaymentInfo;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.pos.util.SignatureGenerator;
import com.openbravo.pos.util.SignatureUtils;
import com.openbravo.service.ClotureService;
import com.openbravo.service.DeletionDetecter;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.metadata.TableDefinition;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.SentenceExec;
import com.procaisse.db.sql.SentenceExecTransaction;
import com.procaisse.db.sql.SentenceList;
import com.procaisse.db.sql.StaticSentence;
import fr.protactile.norm.beans.ArchivPeriode;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.DuplicataJustificatifPayment;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.Facture;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.JustificatifPayment;
import fr.protactile.norm.beans.LineFacture;
import fr.protactile.norm.beans.MaintenanceOperation;
import fr.protactile.norm.beans.RecapGeneralFacture;
import fr.protactile.norm.beans.RecapTaxFacture;
import fr.protactile.norm.beans.RecapTaxNote;
import fr.protactile.procaisse.dao.entities.Allergene;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import fr.protactile.procaisse.dao.entities.MultiLanguageCategory;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import fr.protactile.procaisse.dao.entities.NutritionalInfoProduct;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.services.AllergeneService;
import fr.protactile.procaisse.services.AllergeneSupplementServices;
import fr.protactile.procaisse.services.CaisseService;
import fr.protactile.procaisse.services.CustomerService;
import fr.protactile.procaisse.services.DebitCustomerService;
import fr.protactile.procaisse.services.ImageProductService;
import fr.protactile.procaisse.services.LoyaltyCardService;
import fr.protactile.procaisse.services.MultiLanguageCarteService;
import fr.protactile.procaisse.services.MultiLanguageCategoryService;
import fr.protactile.procaisse.services.MultiLanguageGSSService;
import fr.protactile.procaisse.services.MultiLanguageProductService;
import fr.protactile.procaisse.services.MultiLanguagePromotionService;
import fr.protactile.procaisse.services.MultiLanguageSupplementItemService;
import fr.protactile.procaisse.services.MultiLanguageSupplementService;
import fr.protactile.procaisse.services.NutritionalService;
import fr.protactile.procaisse.services.TransactionMevService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.time.DateUtils;

public class DataLogicSales
extends BeanFactoryDataSingle {
    private DeletionDetecter detecter;
    protected Session s;
    protected Datas[] stockdiaryDatas;
    protected Datas[] paymenttabledatas;
    protected int idProduct;
    protected int idSalle;
    protected int quantity;
    protected double price;
    protected PreparedStatement pstmt;
    protected double total;
    protected int idOrder;
    protected int idCarte;
    protected int id_Product;
    protected int numLine;
    private double totalHT;
    protected Timestamp sqlDate;
    private double cumulPerpetualTicket;
    private double cumulPerpetualReelTicket;
    String type_regulation;
    private int idDocument;
    public static final String DEBT = "debt";
    protected static final String PREPAY = "prepay";
    private int idTicketLine;
    private double totalTVA5;
    private double totalTVA10;
    private double totalTVA20;
    private double cumulCaisse;
    private Date currenDate;
    private int currentDay;
    private int currentMonth;
    private int currentYear;
    SimpleDateFormat dateFormatterId;
    final String ANNUEL_PERIODE = "a";
    final String JOURNALIERE_PERIODE = "j";
    final String MENSUEL_PERIODE = "m";
    private Calendar calendar = Calendar.getInstance();
    private int numeroLine;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private Double restReduction;
    private DataLogicStats dlStats;
    private DataLogicItems dlItems;
    protected String requestTicket;
    protected String requestProducts;
    protected String requestCategory;
    protected String requestFacture;
    protected String requestFactureWithTVA;
    protected String requestDuplicata = "SELECT  id, id_Doc, impression_Number, type_doc, user_operator, date_impression, signature, num_doc, version_soft, MOTIF_IMPRESSION, REF_FACTURE, REF_TICKET, CHECK_TYPE_DOC FROM DUPLICATA ";
    protected String requestSuppItem;
    protected String requestEnteteNote = "SELECT  E.id, E.num_doc, E.version_soft, E.nb_print, E.company, E.address, E.zip_code, E.city, E.country, E.siret, E.code_NAF, E.num_tva, E.timestampGDH, E.type_operation, E.nb_lines, E.ticket, E.header_Supplementaire, E.footer_Supplementaire, E.ticket_status, E.signature_Ticket, E.code_caisse, E.NAME_SOFT, E.code_operator, E.USE_ID_IN_SIGNATURE, E.ROUND_AMOUNT,'impression papier', 0, E.name_operator FROM ENTETE_NOTE E ";
    protected String requestSupplement;
    protected String requestProductSize = "SELECT P.ID, P.name_size, P.label_size, P.price, P.price_sp, P.price_emp, P.price_lv, P.price_bar, P.price_terasse, P.price_happy_hour, P.product, P.PRICE_UBER, P.PRICE_DELIVERO, P.PRICE_PLATFORM,P.SIZE_ENABLED, P.PRICE_DRIVE, P.TARIFF, P.ID_GLOBAL FROM PRODUCTS_SIZE P ";
    protected String requestCustomer;
    protected String requestSuplementLine;
    protected String requestPrinter = "SELECT P.ID, P.NAME, P.TYPE, P.NAME_PRINTER, P.IP, P.WITH_TICKET, P.NUMBER_TICKET, P.typePrinter, P.PORT, P.band_rate, P.MODEL, P.SUMMARY_KITCHEN, P.REF_WEB FROM PRINTER P ";
    protected String requestZone = "SELECT Z.id, Z.name, Z.position, Z.color FROM ZONES Z ";
    private String requestLine;
    private boolean STOCK_ENABLED;
    private int lastCloturedday;
    private DebitCustomerService mDebitCustomerService = DebitCustomerService.getInstance();
    private CaisseService mCaisseService = CaisseService.getInstance();
    private DataLogicEmployees dlEmployees;
    private CustomerService mCustomerService = CustomerService.getInstance();
    private LoyaltyCardService mLoyaltyCardService = LoyaltyCardService.getInstance();
    protected String requestGTP;
    protected String requestProductPlat;
    private ClotureService mClotureService;
    private String requestIngredientLine = "SELECT I.id, I.idCarte, I.nameCarte, I.idProduct, I.nameProduct, I.idIngredient, I.nameIngredient, I.index_carte, S.path, I.ID_INGREDIENT_KITCHEN, S.ALIAS_KITCHEN, S.COOKABLE FROM ingredient_ticket I JOIN SUPPLEMENT_ITEM S ON I.idIngredient = S.id WHERE I.idTicketLine = ? ";
    protected String requestSubProducts;
    private double totalTVA0;
    protected String requestGrandToTalTicket;
    private String requestArchivPeriode = "SELECT  id, grand_total, grand_total_Perpetual,TVA_5_5, TVA_10, TVA_20, signature, type_PERIODE, timestampGDH, chemin, TVA_0, TVA_7_7, TVA_2_5, TVA_2_1, TVA_8_5, ROUND_AMOUNT, TVA_6, TVA_12, TVA_21, TVA_8_1, TVA_2_6 ";
    protected String requestProductDaysOn = "SELECT ID, DAY_OF_WEEK, ID_PRODUCT FROM PRODUCT_DAYS_ON ";
    private double totalTVA_7_7;
    private double totalTVA_2_5;
    private double totalTVA_2_1;
    private double totalTVA_8_5;
    private String requestProductTicket;
    private String requestDuplicataJustificatifPayment = "SELECT ID, TYPE_DOCUMENT, IMPRESSION_NUMBER, CODE_USER, DATE_IMPRESSION, NUM_JUSTIFICATIF_PAIEMENT, MOTIF_IMPRESSION, SIGNATURE, VERSION_SOFT FROM DUPLICATA_JUSTIFICATIF_PAIEMENT ";
    private String requestJustificatifPayment = "SELECT ID, NUM_DOC, TICKET, TIMESTAMPGDH, TOTAL, SIGNATURE, REF_TICKET, ROUND_AMOUNT FROM JUSTIFICATIF_PAIEMENT ";
    private String requestCaisseZ = "SELECT H.ID, H.dateOpen, H.dateClose, H.caisse, H.user_open, H.user_close, H.htAmount, H.taxAmount, H.ttcAmount, H.cumul_Total, H.fund_open, H.fund_close FROM HISTORIQUE_CAISSE H";
    private String requestEntete = "SELECT  E.id, E.num_doc, E.version_soft, E.nb_print, E.company, E.address, E.zip_code, E.city, E.country, E.siret, E.code_NAF, E.num_tva, E.timestampGDH, E.type_operation, E.nb_lines, E.ticket, E.header_Supplementaire, E.footer_Supplementaire, E.ticket_status, E.signature_Ticket, E.code_caisse, E.NAME_SOFT, E.code_operator, E.USE_ID_IN_SIGNATURE, E.ROUND_AMOUNT, E.RESTITUTION_TYPE, E.NB_SEND_E_TICKET, E.name_operator FROM ENTETE E ";
    private String requestTotalEncaissement;
    private String TICKET = "Ticket";
    private String FACTURE = "Facture";
    protected String requestProductPrice = "SELECT P.ID, P.PRICE, P.TYPE_ORDER, P.TARIFF, P.PRODUCT from PRODUCTS_PRICES P ";
    private TransactionMevService mTransactionMevService;
    private SignatureUtils signatureUtils;
    private DataLogicSalesHelper mDataLogicSalesHelper;
    private String requestLinePlatform;
    protected String requestSuplementLinePlatform;
    private double totalTVA_6;
    private double totalTVA_12;
    private double totalTVA_21;
    protected String requestRecapTaxNote = "SELECT ID, TOTAL_HT, CODE_TAX, RATE_TAX, TOTAL_TAX, TOTAL_TTC, REF_NOTE FROM RECAP_TAX_NOTE ";
    protected String requestRecapGeneralNote = "SELECT ID, TOTAL_HT, TOTAL_TTC, REF_NOTE, TOTAL_DISCOUNT FROM RECAP_GENERAL_NOTE ";
    protected String requestLineFacture = "SELECT ID, NUM_LINE, CODE_PRODUCT, ORIGIN_DATA, LABEL_PRODUCT, QUANTITY, PRICE_HT, TAUX_DISCOUNT, TOTAL_HT_DISCOUNTED, TOTAL_HT, CODE_TAX, RATE_TAX, PRICE_TTC, TOTAL_TAX, TOTAL_TTC, timestampGDH, horodatage, REF_FACTURE FROM LINES_FACTURE ";
    protected String requestRecapTaxFacture = "SELECT ID, TOTAL_HT, TOTAL_TAX, CODE_TAX, RATE_TAX, TOTAL_TTC, REF_FACTURE FROM RECAP_TAX_FACTURE ";
    protected String requestRecapGeneralFacture = "SELECT ID, TOTAL_HT, TOTAL_TTC, TOTAL_TAX, TOTAL_DISCOUNT, REF_FACTURE FROM RECAP_GENERAL_FACTURE ";
    protected String requestCarte = "SELECT id, name, sizeCarte, removed, REF_WEB, REMOVED_BY_ADMIN, ID_GLOBAL FROM CARTE ";
    protected String requestOrderCarte = "SELECT C.id, C.name, C.sizeCarte, M.carteOrder, M.number_carte, C.REF_WEB, C.ID_GLOBAL FROM CARTE C, CARTE_MENU M ";
    private double totalTVA_8_1;
    private double totalTVA_2_6;
    protected String request_campaign_supplement_item = " AND ( (cast(S.DATE_START_DISPLAY as date) <= cast(CURRENT_TIMESTAMP as date) AND cast(CURRENT_TIMESTAMP as date) <= cast(S.DATE_END_DISPLAY as date)) OR (S.DATE_END_DISPLAY IS NULL OR S.DATE_START_DISPLAY IS NULL) ) ";
    protected String request_campaign_supplement = " AND ( (cast(S.DATE_START_DISPLAY as date) <= cast(CURRENT_TIMESTAMP as date) AND cast(CURRENT_TIMESTAMP as date) <= cast(S.DATE_END_DISPLAY as date)) OR (S.DATE_END_DISPLAY IS NULL OR S.DATE_START_DISPLAY IS NULL) ) ";
    protected String request_campaign_product = " AND ( (cast(P.DATE_START_DISPLAY as date) <= cast(CURRENT_TIMESTAMP as date) AND cast(CURRENT_TIMESTAMP as date) <= cast(P.DATE_END_DISPLAY as date)) OR (P.DATE_END_DISPLAY IS NULL OR P.DATE_START_DISPLAY IS NULL) ) ";
    protected String request_campaign_category = " AND ( (cast(C.DATE_START_DISPLAY as date) <= cast(CURRENT_TIMESTAMP as date) AND cast(CURRENT_TIMESTAMP as date) <= cast(C.DATE_END_DISPLAY as date)) OR (C.DATE_END_DISPLAY IS NULL OR C.DATE_START_DISPLAY IS NULL) )";
    protected ImageProductService imageProductService;
    protected MultiLanguageProductService multiLanguageProductService;
    protected MultiLanguageCategoryService multiLanguageCategoryService;
    protected MultiLanguageSupplementService multiLanguageSupplementService;
    protected MultiLanguageSupplementItemService multiLanguageSupplementItemService;
    protected AllergeneSupplementServices mAllergeneSupplementService;
    protected MultiLanguageGSSService multiLanguageGSSService;
    protected MultiLanguagePromotionService multiLanguagePromotionService;
    protected MultiLanguageCarteService multiLanguageCarteService;
    protected String requestSuppItem_Product;
    private String requestProductTicketPlatform;
    protected NutritionalService mNutritionalService;
    protected AllergeneService mAllergeneService;

    public DataLogicSales() throws SQLException {
        this.detecter = new DeletionDetecter();
        this.STOCK_ENABLED = AppLocal.gestion_stock == null || AppLocal.gestion_stock.equals("yes");
        this.currenDate = new Date();
        this.currentDay = this.currenDate.getDate();
        this.currentMonth = this.currenDate.getMonth() + 1;
        this.currentYear = this.currenDate.getYear() + 1900;
        this.stockdiaryDatas = new Datas[]{Datas.STRING, Datas.TIMESTAMP, Datas.INT, Datas.STRING, Datas.INT, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.STRING};
        this.paymenttabledatas = new Datas[]{Datas.STRING, Datas.STRING, Datas.TIMESTAMP, Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.STRING};
        this.requestProducts = "SELECT P.ID, P.CODE, P.NAME, P.PRICEBUY, P.PRICESELL, P.CATEGORY, P.TAXCAT, P.path, P.order_item, P.price_type, P.sp, P.emp, P.lv, P.price_sp, P.price_emp, P.price_lv, P.price_junior, P.price_senior, P.price_mega, P.price_sp_junior, P.price_sp_senior, P.price_sp_mega, P.price_emp_junior, P.price_emp_senior, P.price_emp_mega, P.price_lv_junior, P.price_lv_senior, P.price_lv_mega, P.menu, P.ATTRIBUTES, P.prepared, " + DAOConstants.SQLFunction + "(P.printer, -1) as printer, P.many_size, P.different_price, P.color, " + DAOConstants.SQLFunction + "(P.TAXEMP, '001') as TAXEMP, " + DAOConstants.SQLFunction + "(P.TAXLV, '001') as TAXLV, P.label, " + DAOConstants.SQLFunction + "(P.printerLabel, -1) as printerLabel, P.bar, P.terasse, P.happy_hour, P.price_bar, P.price_terasse, P.price_happy, P.price_bar_junior, P.price_bar_senior, P.price_bar_mega, P.price_terasse_junior, P.price_terasse_senior, P.price_terasse_mega, P.price_happy_junior, P.price_happy_senior, P.price_happy_mega, P.option_free, P.special_option, P.number_line, P.number_column, P.max_line, P.additional_sale, P.moment_product, P.quantity, P.REF_WEB, P.removed, P.hidden, P.unit, P.weight, P.extra_unit, " + DAOConstants.SQLFunction + "(P.display_kitchen, -1) as display_kitchen, P.APPLY_DISCOUNT, P.PRINTER_KITCHEN, P.HIDDEN_BORNE, P.SOLD_OUT, P.FREE_PRICE, P.ALIAS_KITCHEN, P.SEND_COLOR, P.HAS_DISPLAY_TIME, P.FIRST_PERIOD, P.END_PERIOD, P.DESCRIPTION, P.REMOVED_BY_ADMIN, P.STORABLE, P.MIN_STORE, P.ADDITIONAL_SALE_AT_SPOT, P.ADDITIONAL_SALE_TAKE_AWAY, P.PRICE_UBER, P.PRICE_DELIVERO, P.PRICE_UBER_JUNIOR, P.PRICE_UBER_SENIOR, P.PRICE_UBER_MEGA, P.PRICE_DELIVERO_JUNIOR, P.PRICE_DELIVERO_SENIOR, P.PRICE_DELIVERO_MEGA, P.LATER, P.PRINT_INGREDIENTS, P.OPTIONS_FREE_GROUPED, P.PRICE_PLATFORM, P.PRICE_PLATFORM_JUNIOR, P.PRICE_PLATFORM_SENIOR, P.PRICE_PLATFORM_MEGA, P.AVAILABLE_CAISSE, P.SIZE_JUNIOR_ENABLED, P.SIZE_SENIOR_ENABLED, P.SIZE_MEGA_ENABLED, P.LABELED, P.BEST_SALE, P.PROMO_BASKET, P.DISPLAY_IMAGE_IN_KITCHEN, P.DAILY_STOCK, P.HAS_BAR_CODE, P.TOP_PRODUCT, P.HIDDEN_UBEREAT, P.DESCRIPTION_UBEREAT, P.HIDE_NAME_IN_BORNE, P.HIDE_PRICE_IN_BORNE, P.HAS_TIMETABLE, P.UNAVAILABLE_ONLINE, P.HIDDEN_ONLINE, P.PRODUCT_UBEREAT, P.MIXED_PRODUCT, P.PRICE_DRIVE, P.PRICE_DRIVE_JUNIOR, P.PRICE_DRIVE_SENIOR, P.PRICE_DRIVE_MEGA, P.PRODUCT_LOYALTY, P.PRICE_POINT, P.HIDDEN_ONLINE_TEMPORARY, P.HIDDEN_UBEREAT_TEMPORARY, P.HIDDEN_BORNE_TEMPORARY, P.SOLD_OUT_TEMPORARY, P.ENABLE_IN_OPENING, P.PRICE_OPENING, P.HIDDEN_CAISSE, P.PATH_2, P.ISVALID_CAISSE, P.PRODUCT_PLU, P.marque, P.PATH_PRODUCT_MOMENT, P.type_image_product_moment, P.DATE_START_DISPLAY, P.DATE_END_DISPLAY, P.ZONE_ID, P.TVA_GLOBAL_NO_APPLICABLE FROM PRODUCTS P ";
        this.requestTicket = "SELECT T.ID, T.TICKETTYPE, T.TICKETID, T.type, T.modePayment, T.tempsLv, T.CREATED, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, " + DAOConstants.SQLFunction + "(T.CUSTOMER, -1) as CUSTOMER, T.STATUS, T.total, " + DAOConstants.SQLFunction + "(T.address, -1) as address, T.numero_order, " + DAOConstants.SQLFunction + "(T.idTable, -1) as idTable, T.discount, T.typediscount, T.bipper, T.transferred, T.reason_cancel, " + DAOConstants.SQLFunction + "(T.invoice , 0) as invoice , PL.ID as ID_LIVREUR, PL.NAME as NAME_LIVREUR, " + DAOConstants.SQLFunction + "(T.canceled_ticket_id_Int,0) as OrigineTicket,T.accepted, T.paid ,T.last_update, T.couverts, T.SOURCE_ORDER, T.NAME_CUSTOMER, T.date_paid, T.closed, T.canceled_ticket_id, " + DAOConstants.SQLFunction + "(T.num_order_kitchen, -1) as num_order_kitchen, CU.ID, T.ORDERED_FROM, T.ID_ORDER_KITCHEN, T.SENT_FROM, T.NUMERO_ONLINE_ORDER, T.PRINT_AFTER_UPDATE, T.NUM_TABLE, T.NUM_PLATFORM_ORDER, T.LABEL_DISCOUNT, T.ID_SHARED_ORDER, T.DELIVERED_AT, T.LICENCE_ID_MACHINE, T.CUSTOMER_LOYALTY_VERIFIED, T.EASEL_NUMBER, T.PLATFORM_ORDER, T.SHARED_ORDER, T.ORDER_ID_BASE, T.KEENIO_BASE_ORDER, T.TAKE_AWAY_PHONE, T.TPS, T.TVQ, T.session_id,T.tag_erc_stan,  T.eft_stan,  T.last_digit,  T.EcrDateTime, T.holder FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID LEFT OUTER JOIN PEOPLE PL ON T.livreur = PL.ID LEFT JOIN COUNTER_USER CU ON P.ID = CU.ID_USER ";
        this.requestCategory = "SELECT DISTINCT C.ID, C.NAME, C.path, C.TEXTTIP, C.CATSHOWNAME, C.color, " + DAOConstants.SQLFunction + "(C.order_category, 0) as order_category, C.REF_WEB, C.removed, C.hidden, C.TAXEMP, C.TAXLV, C.TAXSP, C.APPLY_DISCOUNT, C.HIDDEN_BORNE, C.HIDDEN_CAISSE, " + DAOConstants.SQLFunction + "(C.PARENTID, -1) as parent_id, C.MOMENT_CATEGORY, C.REMOVED_BY_ADMIN, C.RAW_MATERIAL, C.PRINTER, C.PRINTER_LABEL, C.SOLD_OUT, C.PRODUCTS_FIRST, C.NEXT_AVAILABLE, C.HAS_DISPLAY_TIME, C.FIRST_PERIOD, C.END_PERIOD, C.AVAILABLE_CAISSE, C.HIDDEN_UBEREAT, C.HIDE_NAME_IN_BORNE, C.HIDDEN_ONLINE, C.CATEGORY_UBEREAT, C.OFFSET_PRINT_KITCEHN, C.PATH_CATEGORY_MOMENT, C.type_image_category_moment, C.ID_GLOBAL, C.HAS_TIMETABLE, C.DATE_START_DISPLAY, C.DATE_END_DISPLAY, C.IMAGE_URL FROM CATEGORIES C ";
        this.requestFacture = "SELECT F.id, F.company, F.name_contact,F.address, F.zip_code, F.city, F.country, F.siret, F.code_NAF, F.num_tva, F.ticket, F.physical_person, F.cancel, F.nb_print, F.signature, F.date_created, F.num_doc, T.total, G.TVA_5_5, G.TVA_10, G.TVA_20, G.TVA_0, G.TVA_7_7, G.TVA_2_5, G.TVA_2_1, G.TVA_8_5, F.TYPE_OPERATION, F.VERSION_SOFT, F.NAME_SOFT, " + DAOConstants.SQLFunction + "(F.ID_CUSTOMER, 0) as ID_CUSTOMER, F.COMPANY_SENDER, F.ADDRESS_SENDER, F.ZIP_CODE_SENDER, F.CITY_SENDER, F.COUNTREY_SENDER, F.SIRET_SENDER, F.CODE_NAF_SENDER, F.NUM_TVA_SENDER, F.FORME_JURIDIQUE_SENDER, F.CAPITAL_SOCIAL_SENDER, F.RCS_SENDER, F.GREFFE_SENDER, F.METIER_SENDER, F.code_operator, F.name_operator, F.code_caisse, " + DAOConstants.SQLFunction + "(F.REF_TICKET, 0) as REF_TICKET, F.INFO_SENDER_INCLUDED, F.USE_TYPE_IN_SIGNATURE, F.ROUND_AMOUNT, G.TVA_6, G.TVA_12, G.TVA_21, G.TVA_8_1, G.TVA_2_6, F.FACTURE_TYPE, F.REGLEMENT_TVA_SENDER, F.CANCELED_FACTURE_ID FROM FACTURE F JOIN TICKETS T ON F.ticket = T.ID ";
        this.requestSuppItem = "SELECT S.id, S.name, S.price, S.price2, S.price3, S.price_junior, S.price_senior, S.price_mega, S.id_supplement, S.many_size, S.path, S.price_size1, S.price_size2, S.price_size3, S.REF_WEB, S.removed, S.order_item, S.HIDDEN_BORNE, S.color, S.ALIAS_KITCHEN, S.SEND_COLOR, S.FLAME_ENABLED, S.NUMBER_FLAME, S.REMOVED_BY_ADMIN, S.MANY_TYPE, S.HIDDEN, S.HIDDEN_UBEREAT, S.HIDDEN_ONLINE, S.PRICE_SIZE4, S.PRICE_SIZE5, S.PRICE_SIZE6, S.PRICE_SIZE7, S.SUPPLEMENT_ITEM_UBEREAT, " + DAOConstants.SQLFunction + "(S.ID_PRODUCT, 0) as ID_PRODUCT, S.SOLD_OUT, S.HIDDEN_IN_KITCHEN, S.ITEM_PLU, S.COOKABLE, S.TAX_ID, S.PRICE_ALREADY_INCLUDED, S.DATE_START_DISPLAY, S.DATE_END_DISPLAY, S.IMAGE_URL FROM SUPPLEMENT_ITEM S ";
        this.requestSupplement = "SELECT S.id, S.name, S.has_options, " + DAOConstants.SQLFunction + "(S.min_options, 0) as min_options, " + DAOConstants.SQLFunction + "(S.max_options, 0) as max_options, S.is_ingredient, S.is_bold, S.color, S.number_click, S.path, S.order_name, S.multiple_category, S.removed, S.order_supplement,S.display_free, S.prepared, " + DAOConstants.SQLFunction + "(S.printer, -1) as printer, S.shift_option, S.display_screen_sorti, S.HIDDEN_BORNE, S.REF_WEB, S.REMOVED_BY_ADMIN,S.NO_PRINTABLE, S.HIDDEN_UBEREAT, S.HIDDEN_ONLINE, S.SUPPLEMENT_UBEREAT, S.PRINT_BLACK_BACKGROUND, S.ID_GLOBAL, S.DATE_START_DISPLAY, S.DATE_END_DISPLAY FROM SUPPLEMENT S ";
        this.requestCustomer = "SELECT ID, NAME, CARD, NOTES, MAXDEBT, VISIBLE, CURDATE, CURDEBT, PHONE , PHONE2, EMAIL, " + DAOConstants.SQLFunction + "(COMPANY, -1) as COMPANY, DISCOUNT, RESPONSIBLE, INTERLOCUTOR, FUNCTION_INT, RANGECOMPANY, TYPE, PREFIX_PHONE, SIRET, CODE_NAF, NUM_TVA, ISSYNCHROCLIENT FROM CUSTOMERS ";
        this.requestLine = "SELECT L.ID, L.TICKET," + DAOConstants.SQLFunction + "(L.PRODUCT, -1) as PRODUCT, L.UNITS, L.PRICE, L.menu, L.htAmount, L.taxAmount, L.nextElement, L.note, L.discount, L.sizeproduct, L.name_sizeproduct, L.label_discount, T.ID, T.NAME, T.RATE, P.NAME, L.paid, L.units_paid,L.place_served, L.time_served, " + DAOConstants.SQLFunction + "(L.numero_line, 0) as numero_line, L.label, L.PRINTER_KITCHEN, L.PROMO_BASKET, L.TYPE_DISCOUNT, L.PROMO_PRODUCT, P.path, L.ID_LINE_KITCHEN, L.POINTS_LOYALTY, P.ALIAS_KITCHEN, L.ALIAS_SIZE, L.PRODUCT_PROMOTION_APPLIED, L.TVA_GLOBAL_NO_APPLICABLE, " + DAOConstants.SQLFunction + "(ZONE_ID, 0) as ZONE_ID FROM TICKETLINES L LEFT OUTER JOIN TAXCATEGORIES T ON L.TAXID = T.ID LEFT OUTER JOIN PRODUCTS P ON L.PRODUCT = P.ID ";
        this.requestSuplementLine = "SELECT O.id, O.idCarte, O.nameCarte, O.idProduct, O.nameProduct, O.idOption, O.nameOption, O.numberoption ,O.is_bold, O.price, O.index_carte, O.number_free, O.separate, O.multiple, O.weight, O.display_free, SI.id_supplement, O.force_free, " + DAOConstants.SQLFunction + "(O.printer, -1) as printer, O.shift_option, O.NO_PRINTABLE, O.parent_supplement_id, SI.path, S.display_screen_sorti, S.name, O.ID_SUPPLEMENT_KITCHEN," + DAOConstants.SQLFunction + "(SI.ID_PRODUCT, 0) as id_product, SI.ALIAS_KITCHEN, SI.HIDDEN_IN_KITCHEN, S.PRINT_BLACK_BACKGROUND, O.order_option, SI.COOKABLE, O.TAX_ID, O.HT_AMOUNT, O.TAX_AMOUNT, SI.PRICE_ALREADY_INCLUDED, O.FULL_PRICE, SI.color, SI.ITEM_PLU FROM Option_ticket O JOIN SUPPLEMENT_ITEM SI ON O.idOption = SI.id JOIN SUPPLEMENT S ON SI.id_supplement = S.id  WHERE O.idTicketLine = ? and O.idOption <> 0 Order By O.order_option";
        this.requestGTP = "SELECT  id, grand_total, grand_total_Perpetual, " + DAOConstants.SQLFunction + "(TVA_5_5 ,0.0) as Tva_5_5, " + DAOConstants.SQLFunction + "(TVA_10 ,0.0) as TVA_10, " + DAOConstants.SQLFunction + "(TVA_20 ,0.0) as TVA_20, signature, type_PERIODE, timestampGDH, grand_total_Perpetual_reel,CASH_TOTAL, CB_TOTAL, TR_TOTAL, DEBIT_TOTAL, CREDIT_EMPLOYEE_TOTAL, LOYALTY_CARD, CASHDRO_TOTAL, CACH_GLORY_TOTAL, VIRMENT_TOTAL, CHEQUE_TOTAL, AVOIR_DECAISSE_TOTAL, AVOIR_ENCAISSE_TOTAL, TVA_5_5_HT, TVA_10_HT, TVA_20_HT, NUMBER_ORDERS, NUMBER_PRODUCTS_SOLD, TURNOVER_CANCELED, TOTAL_ORDERS_AT_SPOT, TOTAL_ORDERS_TAKE_AWAY, TOTAL_ORDERS_DELIVERY, TOTAL_ORDERS_UBER, TOTAL_ORDERS_DELIVERO, NUMBER_CB, NUMBER_TR, TOTAL_DISCOUNT, TOTAL_DISCOUNT_LINES, INSERT_FINANCIAL_INFOS, TOTAL_ORDERS_JUST_EAT, " + DAOConstants.SQLFunction + "(TVA_0 ,0.0) as TVA_0, TVA_0_HT, TOTAL_ORDERS_DRIVE, " + DAOConstants.SQLFunction + "(TVA_7_7 ,0.0) as TVA_7_7, " + DAOConstants.SQLFunction + "(TVA_2_5 ,0.0) as TVA_2_5, " + DAOConstants.SQLFunction + "(TVA_2_1 ,0.0) as TVA_2_1, " + DAOConstants.SQLFunction + "(TVA_8_5 ,0.0) as TVA_8_5, TVA_7_7_HT, TVA_2_5_HT, TVA_2_1_HT, TVA_8_5_HT, TWINT_TOTAL, TOTAL_ORDERS_SMOOD, CHEQUE_VACANCES_TOTAL, BEFORE_PERPETUAL_RESET, ISSYNCHRONIZED, ROUND_AMOUNT, TURNOVER_PLATFORM, NUMBER_ORDERS_PLATFORM, TOTAL_ORDERS_DELIVEROO, " + DAOConstants.SQLFunction + "(TVA_6 ,0.0) as TVA_6, " + DAOConstants.SQLFunction + "(TVA_12 ,0.0) as TVA_12, " + DAOConstants.SQLFunction + "(TVA_21 ,0.0) as TVA_21, TVA_6_HT, TVA_12_HT, TVA_21_HT, TURNOVER_UBEREAT, TOTAL_ORDERS_DISHOP, STRIPE_TOTAL, CASH_LOGY_TOTAL, " + DAOConstants.SQLFunction + "(TVA_8_1 ,0.0) as TVA_8_1, " + DAOConstants.SQLFunction + "(TVA_2_6 ,0.0) as TVA_2_6, TVA_8_1_HT, TVA_2_6_HT, TPS, TVQ, CREDIT_CARD_TOTAL, DEBIT_CARD_TOTAL, TOTAL_HT_TAXABLE, TOTAL_HT_NO_TAXABLE, TOTAL_HT_ORDERS_AT_SPOT, TOTAL_HT_ORDERS_TAKE_AWAY, TOTAL_HT_ORDERS_DELIVERY, TOTAL_HT_ORDERS_DRIVE, NUMBER_ORDERS_AT_SPOT, NUMBER_ORDERS_TAKE_AWAY, NUMBER_ORDERS_DELIVERY, NUMBER_ORDERS_DRIVE, CARTE_TR_TOTAL, BANK_TRANSFER_TOTAL, NUMBER_CARTE_TR FROM GRAND_TOTAL_PERIODE ";
        this.requestProductPlat = "SELECT P.ID, P.CODE, P.NAME, P.PRICEBUY, C.price, P.CATEGORY, P.TAXCAT, P.path, C.order_item, P.price_type, P.sp, P.emp, P.lv, P.price_sp, P.price_emp, P.price_lv, P.price_junior, P.price_senior, P.price_mega, P.price_sp_junior, P.price_sp_senior, P.price_sp_mega, P.price_emp_junior, P.price_emp_senior, P.price_emp_mega, P.price_lv_junior, P.price_lv_senior, P.price_lv_mega, P.menu, P.ATTRIBUTES, P.prepared, " + DAOConstants.SQLFunction + "(P.printer, -1) as printer, P.many_size, P.different_price, P.color, " + DAOConstants.SQLFunction + "(P.TAXEMP, '001') as TAXEMP, " + DAOConstants.SQLFunction + "(P.TAXLV, '001') as TAXLV, P.label, " + DAOConstants.SQLFunction + "(P.printerLabel, -1) as printerLabel, P.bar, P.terasse, P.happy_hour, P.price_bar, P.price_terasse, P.price_happy, P.price_bar_junior, P.price_bar_senior, P.price_bar_mega, P.price_terasse_junior, P.price_terasse_senior, P.price_terasse_mega, P.price_happy_junior, P.price_happy_senior, P.price_happy_mega, P.option_free, P.special_option, P.number_line, P.number_column, P.max_line, P.additional_sale, P.moment_product, P.quantity, P.REF_WEB, P.removed, P.hidden, P.unit, P.weight, P.extra_unit, " + DAOConstants.SQLFunction + "(P.display_kitchen, -1) as display_kitchen, P.APPLY_DISCOUNT, P.PRINTER_KITCHEN, P.HIDDEN_BORNE, P.SOLD_OUT, P.FREE_PRICE, P.ALIAS_KITCHEN, P.SEND_COLOR, P.HAS_DISPLAY_TIME, P.FIRST_PERIOD, P.END_PERIOD, P.DESCRIPTION, P.REMOVED_BY_ADMIN, P.STORABLE, P.MIN_STORE, P.ADDITIONAL_SALE_AT_SPOT, P.ADDITIONAL_SALE_TAKE_AWAY, P.PRICE_UBER, P.PRICE_DELIVERO, P.PRICE_UBER_JUNIOR, P.PRICE_UBER_SENIOR, P.PRICE_UBER_MEGA, P.PRICE_DELIVERO_JUNIOR, P.PRICE_DELIVERO_SENIOR, P.PRICE_DELIVERO_MEGA, P.LATER, P.PRINT_INGREDIENTS, P.OPTIONS_FREE_GROUPED, P.PRICE_PLATFORM, P.PRICE_PLATFORM_JUNIOR, P.PRICE_PLATFORM_SENIOR, P.PRICE_PLATFORM_MEGA, P.AVAILABLE_CAISSE, P.SIZE_JUNIOR_ENABLED, P.SIZE_SENIOR_ENABLED, P.SIZE_MEGA_ENABLED, P.LABELED, P.BEST_SALE, P.PROMO_BASKET, P.DISPLAY_IMAGE_IN_KITCHEN, P.DAILY_STOCK, P.HAS_BAR_CODE, P.TOP_PRODUCT, P.HIDDEN_UBEREAT, P.DESCRIPTION_UBEREAT, P.HIDE_NAME_IN_BORNE, P.HIDE_PRICE_IN_BORNE, P.HAS_TIMETABLE, P.UNAVAILABLE_ONLINE, P.HIDDEN_ONLINE, P.PRODUCT_UBEREAT, P.MIXED_PRODUCT, P.PRICE_DRIVE, P.PRICE_DRIVE_JUNIOR, P.PRICE_DRIVE_SENIOR, P.PRICE_DRIVE_MEGA, P.PRODUCT_LOYALTY, P.PRICE_POINT, P.HIDDEN_ONLINE_TEMPORARY, P.HIDDEN_UBEREAT_TEMPORARY, P.HIDDEN_BORNE_TEMPORARY, P.SOLD_OUT_TEMPORARY, P.ENABLE_IN_OPENING, P.PRICE_OPENING, P.HIDDEN_CAISSE, P.PATH_2, P.ISVALID_CAISSE, P.PRODUCT_PLU, P.marque, P.PATH_PRODUCT_MOMENT, P.type_image_product_moment, P.DATE_START_DISPLAY, P.DATE_END_DISPLAY, P.ZONE_ID, P.TVA_GLOBAL_NO_APPLICABLE FROM PRODUCTS P JOIN CARTE_ITEM C ON  P.ID = C.id_item ";
        this.requestSubProducts = "SELECT P.ID, P.NAME, P.CATEGORY, P.path, P.order_item, P.prepared, " + DAOConstants.SQLFunction + "(P.printer, -1) as printer, P.label, " + DAOConstants.SQLFunction + "(P.printerLabel, -1) as printerLabel, P.REF_WEB, " + DAOConstants.SQLFunction + "(P.display_kitchen, -1) as display_kitchen, P.PRINTER_KITCHEN, P.ALIAS_KITCHEN, P.SEND_COLOR, P.PRINT_INGREDIENTS, P.DAILY_STOCK, SP.NUMBER_EXEMPLARY, P.PRODUCT_PLU FROM PRODUCTS P ";
        this.requestGrandToTalTicket = "SELECT  id, num_doc, timestampGDH, grand_total, grand_total_Perpetual,ticket, TVA_5_5, TVA_10, TVA_20, signature, grand_total_Perpetual_reel, TVA_0, TVA_7_7, TVA_2_5, TVA_2_1, TVA_8_5, " + DAOConstants.SQLFunction + "(BEFORE_PERPETUAL_RESET, 0) as BEFORE_PERPETUAL_RESET, " + DAOConstants.SQLFunction + "(REF_ORIGINE, 0) as REF_ORIGINE, " + DAOConstants.SQLFunction + "(ADD_PERPETUAL_IN_SIGNATURE, 0) as ADD_PERPETUAL_IN_SIGNATURE , " + DAOConstants.SQLFunction + "(ROUND_AMOUNT, 0) as ROUND_AMOUNT, TVA_6, TVA_12, TVA_21,TVA_8_1, TVA_2_6 ";
        this.requestProductTicket = "SELECT PO.id, PO.idCarte, PO.nameCarte, PO.idProduct, PO.nameProduct, PO.numberoproduct, PO.price, " + DAOConstants.SQLFunction + "(P.printer, -1) as printer, PO.index_carte, " + DAOConstants.SQLFunction + "(P.printerlabel, -1) as printerlabel, PO.ID_ITEM_KITCHEN, PO.sizeproduct, PO.comment, " + DAOConstants.SQLFunction + "(P.ZONE_ID, 0) as ZONE_ID FROM Product_ticket PO JOIN PRODUCTS P ON PO.idProduct = P.ID WHERE PO.idTicketLine = ? ";
        this.requestTotalEncaissement = "SELECT  E.id, E.num_doc, E.total_ht, E.total_ttc, E.ticket, E.total_tax, " + DAOConstants.SQLFunction + "(E.REF_ORIGINE, 0) as REF_ORIGINE, E.TOTAL_DISCOUNT, E.TOTAL_HT_TAXABLE, E.TOTAL_HT_NO_TAXABLE FROM TOTAL_ENCAISSEMENT as E ";
        this.mTransactionMevService = TransactionMevService.getInstance();
        this.signatureUtils = new SignatureUtils();
        this.mDataLogicSalesHelper = new DataLogicSalesHelper(this.detecter);
        this.requestLinePlatform = "SELECT L.ID, L.TICKET,L.UNITS, L.PRICE, L.menu, L.htAmount, L.taxAmount, L.nextElement, L.note, L.discount, L.sizeproduct, L.name_sizeproduct, L.label_discount, L.NAME_PRODUCT, L.paid, L.units_paid,L.place_served, L.time_served, " + DAOConstants.SQLFunction + "(L.numero_line, 0) as numero_line, L.label, L.PRINTER_KITCHEN, L.PROMO_BASKET, L.TYPE_DISCOUNT, L.PROMO_PRODUCT, L.ID_LINE_KITCHEN, L.POINTS_LOYALTY, T.ID, T.NAME, T.RATE FROM TICKETLINES L LEFT OUTER JOIN TAXCATEGORIES T ON L.TAXID = T.ID ";
        this.requestSuplementLinePlatform = "SELECT O.id, O.idCarte, O.nameCarte, O.idProduct, O.nameProduct, O.idOption, O.nameOption, O.numberoption ,O.is_bold, O.price, O.index_carte, O.number_free, O.separate, O.multiple, O.weight, O.display_free, 0, O.force_free, " + DAOConstants.SQLFunction + "(O.printer, -1) as printer, O.shift_option, O.NO_PRINTABLE, O.parent_supplement_id, '', false, '', O.ID_SUPPLEMENT_KITCHEN,0, '', false, false, O.order_option, false, '', 0, 0, 0, O.FULL_PRICE, '', '' FROM Option_ticket O  WHERE O.idTicketLine = ? AND O.idOption = 0  Order By O.order_option";
        this.requestSuppItem_Product = "SELECT S.id, S.name, S.price, S.price2, S.price3, S.price_junior, S.price_senior, S.price_mega, S.id_supplement, S.many_size, S.path, S.price_size1, S.price_size2, S.price_size3, S.REF_WEB, S.removed, S.order_item, S.HIDDEN_BORNE, S.color, S.ALIAS_KITCHEN, S.SEND_COLOR, S.FLAME_ENABLED, S.NUMBER_FLAME, S.REMOVED_BY_ADMIN, S.MANY_TYPE, S.HIDDEN, S.HIDDEN_UBEREAT, S.HIDDEN_ONLINE, S.PRICE_SIZE4, S.PRICE_SIZE5, S.PRICE_SIZE6, S.PRICE_SIZE7, S.SUPPLEMENT_ITEM_UBEREAT, " + DAOConstants.SQLFunction + "(S.ID_PRODUCT, 0) as ID_PRODUCT, S.SOLD_OUT, S.HIDDEN_IN_KITCHEN, S.ITEM_PLU, S.COOKABLE, S.TAX_ID, S.PRICE_ALREADY_INCLUDED, S.DATE_START_DISPLAY, S.DATE_END_DISPLAY, S.IMAGE_URL, P.PRODUCT_PLU FROM SUPPLEMENT_ITEM S ";
        this.imageProductService = ImageProductService.getInstance();
        this.multiLanguageProductService = MultiLanguageProductService.getInstance();
        this.multiLanguageCategoryService = MultiLanguageCategoryService.getInstance();
        this.multiLanguageSupplementService = MultiLanguageSupplementService.getInstance();
        this.multiLanguageSupplementItemService = MultiLanguageSupplementItemService.getInstance();
        this.mAllergeneSupplementService = AllergeneSupplementServices.getInstance();
        this.multiLanguageGSSService = MultiLanguageGSSService.getInstance();
        this.multiLanguagePromotionService = MultiLanguagePromotionService.getInstance();
        this.multiLanguageCarteService = MultiLanguageCarteService.getInstance();
        this.requestProductTicketPlatform = "SELECT PO.id, PO.idCarte, PO.nameCarte, PO.idProduct, PO.nameProduct, PO.numberoproduct, PO.price, " + DAOConstants.SQLFunction + "(PO.printer, -1) as printer, PO.index_carte, " + DAOConstants.SQLFunction + "(PO.printerlabel, -1) as printerlabel, PO.ID_ITEM_KITCHEN, PO.sizeproduct, PO.comment, " + DAOConstants.SQLFunction + "(PO.ZONE_ID, 0) as ZONE_ID FROM Product_ticket PO  WHERE PO.idTicketLine = ? ";
        this.mNutritionalService = NutritionalService.getInstance();
        this.mAllergeneService = AllergeneService.getInstance();
    }

    @Override
    public void init(Session s) {
        this.s = s;
    }

    public final ProductInfoExt getProductInfoById(int id, boolean catalog_borne, boolean check_product) throws BasicException {
        String request_check_product = check_product ? " P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND" : "";
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE" + request_check_product + " P.ID = ? ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)id);
        if (product != null) {
            product.setSub_products(this.getSubProducts(product.getID(), catalog_borne));
            if (this.getDlItems() != null) {
                product.setListSizes(this.getDlItems().getProductSizes(product.getID(), true));
                product.setPromotions(this.getDlItems().getPromotionsByPproduct(product.getID(), true));
                product.setPrices(this.getDlItems().getProductPrices(product.getID(), true));
                List<ImageProduct> images = this.imageProductService.getImages(product.getID());
                product.setImages(images);
                List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
                product.setMultiLanguageTexts(multiLanguageTexts);
                NutritionalInfoProduct mNutritionals = this.getProductNutriValuesById(product.getID());
                product.setNutriValues(mNutritionals);
                List<Allergene> allergens = this.getProductAllergenesById(product.getID());
                product.setAllergenes(allergens);
            }
            if (product.getZoneId() != null) {
                product.setZoneInfo(this.getZoneInfoById(product.getZoneId()));
            }
        }
        return product;
    }

    public final List<Allergene> getProductAllergenesById(int id) {
        return this.mAllergeneService.getAllergenesForProduct(id);
    }

    public final NutritionalInfoProduct getProductNutriValuesById(int id) {
        return this.mNutritionalService.getNutriByProduct(id);
    }

    public final ProductInfoExt getProductInfoByCode(String code) throws BasicException {
        return (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.CODE = ? ", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)code);
    }

    public final List<CategoryInfo> getParentCategories(boolean borne, boolean all, boolean catalog, TagInfo mTagInfo) throws BasicException {
        String request_product_category_hidden_borne;
        int dayOfWeek = com.openbravo.pos.util.DateUtils.getDayOfWeek();
        System.out.println("++++++++++++++++++++dayOfWeek" + dayOfWeek);
        Object request = "";
        String request_product_menu_2 = "AND ( PS.menu = 0 OR (PS.menu = 1 AND NOT EXISTS ( SELECT 1 FROM carte_menu cm WHERE cm.id_item = PS1.id AND NOT EXISTS (SELECT 1 FROM carte_item ci JOIN products pi ON ci.id_item = pi.id WHERE ci.id_carte = cm.id_carte AND pi.sold_out = 0))) )";
        String request_product_menu_1 = "AND ( P1.menu = 0 OR (P1.menu = 1 AND NOT EXISTS ( SELECT 1 FROM carte_menu cm WHERE cm.id_item = P1.id AND NOT EXISTS (SELECT 1 FROM carte_item ci JOIN products pi ON ci.id_item = pi.id WHERE ci.id_carte = cm.id_carte AND pi.sold_out = 0))) )";
        String request_product_sub_category_opening_mode = AppLocal.OPENING_MODE ? "AND PS.ENABLE_IN_OPENING = 1 " : "";
        String request_product_category_opening_mode = AppLocal.OPENING_MODE ? "AND P.ENABLE_IN_OPENING = 1 " : "";
        String request_product_sub_category_hidden_borne = borne ? "AND PS.HIDDEN_BORNE = 0 " : "";
        String string = request_product_category_hidden_borne = borne ? "AND P.HIDDEN_BORNE = 0 " : "";
        String request_hidden = borne ? "AND C.HIDDEN_BORNE = 0 " : (catalog ? "AND C.HIDDEN_CAISSE = 0 " : "");
        String request_product_category = "(P.ID IS NOT NULL AND P.REMOVED = 0 AND P.REMOVED_BY_ADMIN = 0 " + request_product_category_hidden_borne + request_product_category_opening_mode + " AND (P.MENU = 0 OR P.ID NOT IN (  SELECT CM.ID_ITEM  FROM CARTE_MENU CM  WHERE NOT EXISTS (  SELECT 1  FROM CARTE_ITEM CI  JOIN PRODUCTS PI ON CI.ID_ITEM = PI.ID  WHERE CI.ID_CARTE = CM.ID_CARTE  AND PI.SOLD_OUT = 0   )   )))";
        String request_product_sub_category = "(PS.ID IS NOT NULL AND PS.REMOVED = 0 AND PS.REMOVED_BY_ADMIN = 0 " + request_product_sub_category_hidden_borne + request_product_sub_category_opening_mode + " AND (PS.MENU = 0 OR PS.ID NOT IN (  SELECT CM2.ID_ITEM  FROM CARTE_MENU CM2  WHERE NOT EXISTS (  SELECT 1  FROM CARTE_ITEM CI2  JOIN PRODUCTS PI2 ON CI2.ID_ITEM = PI2.ID  WHERE CI2.ID_CARTE = CM2.ID_CARTE   AND PI2.SOLD_OUT = 0   )  )))";
        if (catalog) {
            request = (String)request + " AND C.CATEGORY_UBEREAT = 0 ";
            request = (String)request + " AND ( " + request_product_category + " OR " + request_product_sub_category + " ) ";
            String request_date = " AND (C.HAS_TIMETABLE = 0 OR C.ID IN (SELECT CD.ID_CATEGORY FROM CATEGORY_DAYS_ON CD WHERE CD.DAY_OF_WEEK = " + dayOfWeek + ")) ";
            request = (String)request + request_date;
        }
        request = (String)request + this.request_campaign_category;
        String request_removed = all ? "" : "AND C.removed = 0 ";
        Object requestSql = this.requestCategory;
        if (catalog) {
            requestSql = (String)requestSql + " LEFT JOIN CATEGORIES CS1 ON CS1.PARENTID = C.ID LEFT JOIN PRODUCTS P ON P.CATEGORY = C.ID LEFT JOIN PRODUCTS PS ON PS.CATEGORY = CS1.ID ";
        }
        requestSql = (String)requestSql + "WHERE C.REMOVED_BY_ADMIN = 0 AND (C.PARENTID is null or  C.PARENTID = -1)" + request_removed + request_hidden + (String)request;
        if (catalog) {
            System.out.println("mTagInfo 2 : " + mTagInfo);
            if (mTagInfo != null) {
                requestSql = (String)requestSql + " AND C.ID IN (select TC.ID_CATEGORY from TAGS_CATEGORIES TC JOIN TAGS T ON TC.ID_TAG = T.ID WHERE TC.ID_TAG = " + mTagInfo.getId() + ") ";
            } else {
                String requestTag = this.getRequestTags();
                if (requestTag != null && !requestTag.isEmpty()) {
                    requestSql = (String)requestSql + " AND (C.ID NOT IN (select ID_CATEGORY from TAGS_CATEGORIES) ";
                    requestSql = (String)requestSql + " OR C.ID IN (select TC.ID_CATEGORY from TAGS_CATEGORIES TC JOIN TAGS T ON TC.ID_TAG = T.ID WHERE " + requestTag + ")) ";
                }
            }
        }
        requestSql = (String)requestSql + "ORDER BY order_category ";
        System.out.println("requestSql : " + (String)requestSql);
        List categories = new PreparedSentence(this.s, (String)requestSql, null, CategoryInfo.getSerializerRead()).list();
        for (CategoryInfo category : categories) {
            System.out.println("category : " + category);
            category.setSub_categories(this.getSubCategories(category.getID(), borne, all, catalog));
            if (this.dlItems != null) {
                category.setTags(this.dlItems.getTagsByCategory(category.getID()));
                for (CategoryInfo sub_category : category.getSub_categories()) {
                    sub_category.setTags(this.dlItems.getTagsByCategory(sub_category.getID()));
                    List<MultiLanguageCategory> multiLanguageTexts = this.multiLanguageCategoryService.getMultiLanguageTexts(sub_category.getID());
                    sub_category.setMultiLanguageTexts(multiLanguageTexts);
                }
            }
            List<MultiLanguageCategory> multiLanguageTexts = this.multiLanguageCategoryService.getMultiLanguageTexts(category.getID());
            category.setMultiLanguageTexts(multiLanguageTexts);
        }
        return categories;
    }

    public final List<CategoryInfo> getSubCategories(int parentCategory, boolean borne, boolean all, boolean catalog) throws BasicException {
        int dayOfWeek = com.openbravo.pos.util.DateUtils.getDayOfWeek();
        Object request = "";
        if (borne) {
            request = "AND C.HIDDEN_BORNE = 0 ";
        } else if (catalog) {
            request = "AND C.HIDDEN_CAISSE = 0 ";
        }
        if (borne || catalog) {
            request = (String)request + " AND C.ID IN (select P.CATEGORY from PRODUCTS P WHERE P.removed = 0 AND P.REMOVED_BY_ADMIN = 0 ";
            if (borne) {
                request = (String)request + " AND P.HIDDEN_BORNE = 0 ";
            }
            request = AppLocal.OPENING_MODE ? (String)request + " AND P.ENABLE_IN_OPENING = 1) " : (String)request + " )";
            String request_date = " AND (C.HAS_TIMETABLE = 0 OR C.ID IN (SELECT CD.ID_CATEGORY from CATEGORY_DAYS_ON CD where CD.DAY_OF_WEEK = " + dayOfWeek + ")) ";
            request = (String)request + request_date;
        }
        if (catalog) {
            request = (String)request + " AND C.CATEGORY_UBEREAT = 0 ";
        }
        request = (String)request + this.request_campaign_category;
        String request_removed = all ? "" : "AND C.removed = 0 ";
        return new PreparedSentence(this.s, this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.PARENTID = ? " + request_removed + (String)request + "ORDER BY order_category ", SerializerWriteInteger.INSTANCE, CategoryInfo.getSerializerRead()).list((Object)parentCategory);
    }

    public final List<CategoryInfo> getMomentCategories(TagInfo mTagInfo) throws BasicException {
        String requestSql = this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 AND C.HIDDEN_BORNE = 0 AND C.RAW_MATERIAL = 0 AND C.MOMENT_CATEGORY = 1 AND C.CATEGORY_UBEREAT = 0 " + this.request_campaign_category;
        if (mTagInfo != null) {
            requestSql = requestSql + " AND C.ID IN (select TC.ID_CATEGORY from TAGS_CATEGORIES TC JOIN TAGS T ON TC.ID_TAG = T.ID WHERE TC.ID_TAG = " + mTagInfo.getId() + ") ";
        }
        requestSql = requestSql + "ORDER BY order_category ";
        return new PreparedSentence(this.s, requestSql, null, CategoryInfo.getSerializerRead()).list();
    }

    public final List<CategoryInfo> getRootCategories() throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 AND C.RAW_MATERIAL = 0 " + this.request_campaign_category + "ORDER BY order_category ", null, CategoryInfo.getSerializerRead()).list();
    }

    public final List<CategoryInfo> getCategoriesCaisse(boolean catalog) throws BasicException {
        int dayOfWeek = com.openbravo.pos.util.DateUtils.getDayOfWeek();
        String request_opening_mode = AppLocal.OPENING_MODE ? "AND P.ENABLE_IN_OPENING = 1 " : "";
        String request_product_menu = "AND ( P.menu = 0 OR (P.menu = 1 AND NOT EXISTS ( SELECT 1 FROM carte_menu cm WHERE cm.id_item = P.id AND NOT EXISTS (SELECT 1 FROM carte_item ci JOIN products pi ON ci.id_item = pi.id WHERE ci.id_carte = cm.id_carte AND pi.sold_out = 0))) )";
        Object request = "";
        System.out.println("catalog : " + catalog);
        if (catalog) {
            request = " AND C.CATEGORY_UBEREAT = 0  AND C.HIDDEN_CAISSE = 0";
            request = (String)request + " AND (C.HAS_TIMETABLE = 0 OR C.ID IN (SELECT CD.ID_CATEGORY FROM CATEGORY_DAYS_ON CD WHERE CD.DAY_OF_WEEK = " + dayOfWeek + ")) ";
            String requestTag = this.getRequestTags();
            System.out.println("requestTag : " + requestTag);
            if (requestTag != null && !requestTag.isEmpty()) {
                request = (String)request + " AND C.ID IN (select TC.ID_CATEGORY from TAGS_CATEGORIES TC JOIN TAGS T ON TC.ID_TAG = T.ID WHERE " + requestTag + ")";
            }
        }
        request = (String)request + this.request_campaign_category;
        String requestSQL = this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 AND C.RAW_MATERIAL = 0 " + (String)request + "AND " + DAOConstants.SQLFunction + "(C.PARENTID, -1) NOT IN (select ID FROM CATEGORIES WHERE REMOVED_BY_ADMIN = 1 OR removed = 1) AND C.ID IN (select P.CATEGORY from PRODUCTS P WHERE P.removed = 0 AND P.REMOVED_BY_ADMIN = 0" + request_product_menu + request_opening_mode + ") ORDER BY order_category ";
        System.out.println("requestSQL : " + requestSQL);
        return new PreparedSentence(this.s, requestSQL, null, CategoryInfo.getSerializerRead()).list();
    }

    public final List<CategoryInfo> getStorableCategories() throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 ORDER BY order_category ", null, CategoryInfo.getSerializerRead()).list();
    }

    public final List<CategoryInfo> getStorableCategoriesByProduct() throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory + " JOIN PRODUCTS P ON C.ID = P.CATEGORY WHERE (P.STORABLE = 1 OR C.RAW_MATERIAL = 1) AND C.REMOVED_BY_ADMIN = 0 AND C.removed = 0  AND (C.PARENTID IS NULL or C.PARENTID =-1) AND C.CATSHOWNAME = " + this.s.DB.TRUE() + " ORDER BY order_category", null, CategoryInfo.getSerializerRead()).list();
    }

    public List<ProductInfoExt> getStorableProducts(int category) throws BasicException {
        List products = new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.CATEGORY = ? AND P.removed = 0 AND P.hidden = 0 AND P.STORABLE = 1 ORDER BY  P.order_item ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)category);
        for (ProductInfoExt product : products) {
            product.setListSizes(this.getDlItems().getProductSizes(product.getID(), true));
            product.setPrices(this.getDlItems().getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
        }
        return products;
    }

    public final List<SupplementInfo> getIngredients() throws BasicException {
        return new PreparedSentence(this.s, this.requestSupplement + "WHERE S.is_ingredient = 1 AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + this.request_campaign_supplement + "ORDER BY S.order_supplement", null, SupplementInfo.getSerializerRead()).list();
    }

    public final SupplementInfo getSupplementById(int id) throws BasicException {
        return (SupplementInfo)new PreparedSentence(this.s, this.requestSupplement + "WHERE S.id =  ? ", null, SupplementInfo.getSerializerRead()).find((Object)id);
    }

    public List<SupplementItemInfo> getIngredientsItem(int ingredient) throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.id_supplement = ? AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + this.request_campaign_supplement_item + "ORDER BY  S.order_item ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).list((Object)ingredient);
    }

    public List<SupplementItemInfo> getAllIngredientsItem() throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + " JOIN SUPPLEMENT I ON S.id_supplement = I.id  WHERE S.removed = 0 AND S.REMOVED_BY_ADMIN = 0 AND I.is_ingredient = 1 AND I.removed =0 AND I.REMOVED_BY_ADMIN = 0 " + this.request_campaign_supplement_item + "ORDER BY  S.order_item ", null, SupplementItemInfo.getSerializerRead()).list();
    }

    public List<SupplementInfo> getSupplements() throws BasicException {
        return new PreparedSentence(this.s, this.requestSupplement + "WHERE S.is_ingredient = 0 AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + this.request_campaign_supplement + "ORDER BY S.order_supplement", null, SupplementInfo.getSerializerRead()).list();
    }

    public List<SupplementItemInfo> getSuppelementsItem(int supplement, boolean catalog, boolean only_available) throws BasicException {
        Object request = catalog ? "AND S.SUPPLEMENT_ITEM_UBEREAT = 0 " : "";
        request = (String)request + (only_available ? " AND S.SOLD_OUT = 0 " : "");
        return new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.id_supplement = ? AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + (String)request + this.request_campaign_supplement_item + "ORDER BY  S.order_item ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).list((Object)supplement);
    }

    public List<SupplementItemInfo> getSuppelementsItemBorne(int supplement, boolean order_name) throws BasicException {
        String request_order = order_name ? "S.name " : "S.order_item ";
        return new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.id_supplement = ? AND S.REMOVED_BY_ADMIN =0 AND S.removed =0 AND S.HIDDEN_BORNE = 0 AND S.SUPPLEMENT_ITEM_UBEREAT = 0 AND S.SOLD_OUT = 0 " + this.request_campaign_supplement_item + "ORDER BY  " + request_order, SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).list((Object)supplement);
    }

    public List<SupplementItemInfo> getSuppelementsItemOrderAlpha(int supplement) throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.id_supplement = ? AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0 AND S.SUPPLEMENT_ITEM_UBEREAT = 0 AND S.SOLD_OUT = 0 " + this.request_campaign_supplement_item + "ORDER BY  S.name ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).list((Object)supplement);
    }

    public SupplementItemInfo getSuppelementById(int id) throws BasicException {
        return (SupplementItemInfo)new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.id = ? ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).find((Object)id);
    }

    public final SupplementItemInfo getIngredientItemInfo(int id) throws BasicException {
        return (SupplementItemInfo)new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.id = ? ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).find((Object)id);
    }

    public final CategoryInfo getCategoryInfo(String id) throws BasicException {
        return (CategoryInfo)new PreparedSentence(this.s, this.requestCategory + "WHERE C.ID = ?", SerializerWriteString.INSTANCE, CategoryInfo.getSerializerRead()).find((Object)id);
    }

    public final SentenceList getLocationsList() {
        return new StaticSentence(this.s, "SELECT ID, NAME, ADDRESS FROM LOCATIONS ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(LocationInfo.class));
    }

    public CustomerInfo loadCustomerExt(int id) throws BasicException {
        return (CustomerInfo)new PreparedSentence(this.s, this.requestCustomer + " WHERE ID = ?", SerializerWriteInteger.INSTANCE, CustomerInfo.getSerializerRead()).find((Object)id);
    }

    public final boolean isCashActive(String id) throws BasicException {
        return new PreparedSentence(this.s, "SELECT MONEY FROM CLOSEDCASH WHERE DATEEND IS NULL AND MONEY = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE).find((Object)id) != null;
    }

    public List<PaymentInfo> findPaymetsByIdTicket(String id) throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, PAYMENT, TOTAL, TRANSID, TENDERED, CARDNAME, avoir_origin, ID_PAYMENT_EXTERNE FROM PAYMENTS WHERE RECEIPT = ? order by TOTAL desc", SerializerWriteString.INSTANCE, PaymentInfo.getSerializerRead()).list((Object)id);
    }

    public final List<TicketInfo> loadPendingOrdersByUser(final String user, final String id_Ticket) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE  T.paid = 0 AND P.ID = ? AND T.ID <> ? AND T.STATUS <> 'cancel' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setString(2, id_Ticket);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadPendingOrders(String id_Ticket) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE  T.paid = 0 AND T.ID <> ? AND T.STATUS <> 'cancel' ORDER BY R.DATENEW desc ", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)id_Ticket);
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketAttente() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE paid = 0 AND type <> 'En Livraison' AND STATUS <> 'cancel' ORDER BY R.DATENEW desc ", null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketAttenteEMP(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE paid = 0 AND type in ('Sur Place', 'A Emporter') AND T.idTable is NULL AND STATUS <> 'cancel' AND STATUS <> 'livre' AND (SENT_FROM is null OR (SENT_FROM is not null AND SENT_FROM not in ('web', 'borne', 'Dishop'))) AND PLATFORM_ORDER = 0 AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketAttenteTable() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE paid = 0 AND type <> 'En Livraison' AND STATUS <> 'cancel' AND STATUS <> 'livre' AND idTable is not null ORDER BY R.DATENEW desc ", null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketsByType(final String type_order, final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE paid = 0 AND type = ? AND STATUS <> 'cancel' AND STATUS <> 'livre' AND (SENT_FROM is null OR (SENT_FROM is not null AND SENT_FROM not in ('web', 'borne', 'Dishop'))) AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_order);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketAttenteEMPTable(final Date dateStart, final Date dateEnd, final String type_order) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE paid = 0 AND type = ?  AND STATUS <> 'cancel' AND STATUS <> 'livre' AND (SENT_FROM is null OR (SENT_FROM is not null AND SENT_FROM not in ('web', 'Dishop', 'borne'))) AND PLATFORM_ORDER = 0 AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_order);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketAttenteUser(final String user) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND paid = 0 AND type <> 'En Livraison' AND STATUS <> 'cancel' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketAttenteUserEMP(final String user, final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND paid = 0 AND type in ('Sur Place', 'A Emporter') AND T.idTable is NULL  AND STATUS <> 'cancel' AND STATUS <> 'livre' AND (SENT_FROM is null OR (SENT_FROM is not null AND SENT_FROM not in ('web', 'Dishop', 'borne'))) AND PLATFORM_ORDER = 0 AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketAttenteUserTable(final String user, final Date dateStart, final Date dateEnd, final String type_order) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND paid = 0 AND type = ? AND STATUS <> 'cancel' AND STATUS <> 'livre' AND (SENT_FROM is null OR (SENT_FROM is not null AND SENT_FROM not in ('web', 'borne', 'Dishop'))) AND PLATFORM_ORDER = 0 AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setString(2, type_order);
                this.setTimestamp(3, dateStart);
                this.setTimestamp(4, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketByTypeAndUser(final String user, final String type_order, final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND paid = 0 AND type = ? AND STATUS <> 'cancel' AND STATUS <> 'livre' AND (SENT_FROM is null OR (SENT_FROM is not null AND SENT_FROM not in ('web', 'borne', 'Dishop'))) AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setString(2, type_order);
                this.setTimestamp(3, dateStart);
                this.setTimestamp(4, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    private void loadOrderInfo(TicketInfo ticket) throws BasicException {
        int idTable = ticket.getIdTable();
        ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        int idCustomer = ticket.getCustomerId();
        ticket.setCustomer(idCustomer == -1 ? null : this.loadCustomerExt(idCustomer));
    }

    public final List<TicketInfo> loadTicketLvAttente(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE type ='En Livraison' AND STATUS <> 'cancel' AND STATUS <> 'Refund' AND STATUS <> 'livre' AND DELIVERED = 0 AND (SENT_FROM is null OR (SENT_FROM is not null AND SENT_FROM not in ('web', 'borne', 'Dishop'))) AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketLivreAttente() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE STATUS <> 'cancel' AND STATUS <> 'Refund' AND type ='En Livraison' AND ((paid = 0 AND STATUS ='livre') or (DELIVERED = 1 AND DISBURSED = 0 ))  ORDER BY R.DATENEW desc ", null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketLivreAttenteLivreur(final String livreur) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE PL.ID = ? AND STATUS <> 'cancel' AND STATUS <> 'Refund' AND ((paid = 0 AND STATUS ='livre') or (DELIVERED = 1 AND DISBURSED = 0 AND type ='En Livraison')) ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, livreur);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketLvAttente(final String livreurId) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE PL.ID = ? AND paid = 0 AND type ='En Livraison' AND STATUS <> 'cancel' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, livreurId);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketLvAttenteUser(final String user, final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND type ='En Livraison' AND STATUS <> 'cancel' AND STATUS <> 'Refund' AND STATUS <> 'livre' AND  DELIVERED = 0  AND (SENT_FROM is null OR (SENT_FROM is not null AND SENT_FROM not in ('web', 'borne', 'Dishop'))) AND R.DATENEW BETWEEN ? AND ?  ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketLivre(final Date dateStart, final Date dateEnd, final String user, final String delivery_user) throws BasicException {
        String request = this.requestTicket + "WHERE STATUS <> 'cancel' AND STATUS <> 'Refund' AND ((paid = 0 AND STATUS ='livre') or (DELIVERED = 1 AND DISBURSED = 0 AND type ='En Livraison')) AND R.DATENEW BETWEEN ? AND ? ";
        if (delivery_user != null) {
            request = request + " AND PL.ID = ? ";
        }
        if (user != null) {
            request = request + " AND P.ID = ? ";
        }
        request = request + "ORDER BY R.DATENEW desc ";
        List tickets = new PreparedSentence(this.s, request, SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
                if (delivery_user != null) {
                    this.setString(3, delivery_user);
                }
                if (user != null) {
                    if (delivery_user != null) {
                        this.setString(4, user);
                    } else {
                        this.setString(3, user);
                    }
                }
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketLivreUserLivreur(final String user, final String livreur) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND PL.ID = ? AND STATUS <> 'cancel' AND STATUS <> 'Refund' AND ((paid = 0 AND STATUS ='livre') or (DELIVERED = 1 AND DISBURSED = 0 AND type ='En Livraison'))  ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setString(2, livreur);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketLvAttenteUser(final String user, final String livreurId) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND PL.ID = ? AND paid = 0 AND type ='En Livraison' AND STATUS <> 'cancel' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setString(2, livreurId);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadAllTicket(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE  R.DATENEW >= ? AND R.DATENEW <= ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketToPrint(final Date dateStart, final Date dateEnd) throws BasicException {
        String request_hidden_orders = AppLocal.HIDE_ORDERS ? " AND T.PAID_IN_OTHER_CAISSE = 0 " : "";
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE R.DATENEW >= ? AND R.DATENEW <= ? " + request_hidden_orders + "ORDER BY T.TICKETID desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            ticket.setPayments(this.findPaymetsByIdTicket(ticket.getId()));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketInvoice(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE ( T.STATUS = 'paid' or T.STATUS = 'livre')  AND T.total > 0  AND R.DATENEW >= ? AND R.DATENEW <= ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadAllTicketByuser(final Date dateStart, final Date dateEnd, final String user) throws BasicException {
        String request_hidden_orders = AppLocal.HIDE_ORDERS ? " AND T.PAID_IN_OTHER_CAISSE = 0 " : "";
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ?   AND R.DATENEW >= ? AND R.DATENEW <= ? " + request_hidden_orders + "ORDER BY T.TICKETID desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketInvoiceByuser(final Date dateStart, final Date dateEnd, final String user) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND ( T.STATUS = 'paid' or T.STATUS = 'livre') AND T.total > 0  AND R.DATENEW >= ? AND R.DATENEW <= ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadPrintTicket(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE R.DATENEW >= ? AND R.DATENEW <= ? AND T.STATUS <> 'cancel' ORDER BY TICKETID ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final TicketInfo loadTicketByTableUser(final int id, final String user) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE T.idTable = ? AND P.ID = ? AND T.paid = 0 AND T.STATUS <> 'cancel' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
                this.setString(2, user);
            }
        });
        if (ticket != null) {
            this.loadOrderInfo(ticket);
        }
        return ticket;
    }

    public final TicketInfo checktable(final int id) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE T.idTable = ?  AND T.paid = 0 AND T.STATUS <> 'cancel' ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
        return ticket;
    }

    public final TicketInfo loadTicketByTable(final int id) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE  T.idTable = ? AND T.paid = 0 AND T.STATUS <> 'cancel' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
        if (ticket != null) {
            this.loadOrderInfo(ticket);
        }
        return ticket;
    }

    public List<TicketLineInfo> loadLines(String ticket) throws BasicException {
        List ticketsLines = new PreparedSentence(this.s, this.requestLine + " WHERE L.TICKET = ? ORDER BY L.ID ", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket);
        for (TicketLineInfo ticketsLine : ticketsLines) {
            ticketsLine.setListIngredients(new PreparedSentence(this.s, this.requestIngredientLine, SerializerWriteInteger.INSTANCE, ItemOrderInfo.getSerializerRead()).list((Object)ticketsLine.getID()));
            List options = new PreparedSentence(this.s, this.requestSuplementLine, SerializerWriteInteger.INSTANCE, OptionItemOrder.getSerializerRead()).list((Object)ticketsLine.getID());
            for (OptionItemOrder option : options) {
                if (option.getTaxId() == null || option.getTaxId().isEmpty()) continue;
                TaxInfo tax = this.getTaxById(option.getTaxId());
                option.setTax(tax);
            }
            ticketsLine.setListSupplements(options);
            ticketsLine.setListProducts(new PreparedSentence(this.s, this.requestProductTicket, SerializerWriteInteger.INSTANCE, ProductTicket.getSerializerRead()).list((Object)ticketsLine.getID()));
        }
        return ticketsLines;
    }

    public final TicketInfo getTicketById(String idTicket, boolean detail) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE T.ID = ? ", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)idTicket);
        if (ticket != null && detail) {
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return ticket;
    }

    public final boolean saveTicket(TicketInfo ticket, String ticketOrigineId, int ticketOriginIdInt, boolean serveur, boolean oldOrder, HashMap<Integer, TicketResto> ticketsRestau) throws BasicException, SQLException {
        if (this.isValidPeriod()) {
            String statut = this.getTicketStatus(ticket);
            ticket.setNowAsDate();
            ticket.setDatePaid(new Date());
            this.addRECEIPTS(ticket);
            System.out.println("++++++++++++AppLocal.token " + AppLocal.token);
            System.err.println("***********holder :" + ticket.getHolder());
            CaisseInfo caisse = this.getCaisse(AppLocal.token);
            ticket.setAddress(ticket.getAddress() != 0 ? ticket.getAddress() : -1);
            this.addTicket(ticket, true, caisse, ticketOrigineId, ticketOriginIdInt, serveur);
            this.idDocument = this.addDocument(ticket);
            String typeOperation = ticket.getTicketType() == 1 ? "Annulation" : "Vente";
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this);
            if (marqueNF == null) {
                marqueNF = new MarqueNFC("", "", "", "", "", "", "", "", "");
            }
            StringBuilder ticketEmprinte = new StringBuilder();
            this.calculAndAddTvaToSignature(ticketEmprinte, ticket);
            String ttcVentille = "" + ticketEmprinte;
            this.addEntete(marqueNF, ticket, statut, ticketEmprinte);
            this.numLine = 0;
            if (oldOrder) {
                for (TicketLineInfo l : ticket.getLines()) {
                    if (l.isNext()) {
                        if (l.getID() != -1) {
                            this.changeTicketLine(l, ticket);
                            continue;
                        }
                        this.addNextLine(ticket);
                        continue;
                    }
                    if (l.getProductID() != -1 && l.isDiver()) {
                        this.changeTicketDivers(l, ticket);
                    }
                    if (l.getProductID() == -1 && l.isDiver()) {
                        this.addProductDivers(ticket, l);
                    }
                    if (l.getID() != -1 && !l.isDiver()) {
                        this.changeTicketLine(l, ticket);
                    }
                    if (l.getID() == -1 && !l.isDiver()) {
                        this.addTicketLine(ticket, l);
                    }
                    l.setNumLine(this.numLine);
                    ++this.numLine;
                }
            } else {
                for (TicketLineInfo l : ticket.getLines()) {
                    if (l.isNext()) {
                        this.addNextLine(ticket);
                        continue;
                    }
                    if (l.getProductID() != -1) {
                        this.addTicketLine(ticket, l);
                    } else {
                        this.addProductDivers(ticket, l);
                    }
                    l.setNumLine(this.numLine);
                    ++this.numLine;
                }
            }
            Collections.sort(ticket.getLines(), TicketInfo.infoComparator);
            EnteteInfo entete = this.getEnteteByTicket(ticket.getId(), true);
            this.restReduction = ticket.getTypeDiscount().equals("pourcentage") ? ticket.getDiscount() * ticket.getRealTotal() / 100.0 : ticket.getDiscount();
            this.numLine = 0;
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.isNext()) continue;
                line.setNumLine(this.numLine);
                this.addLine(line, ticket, this.idDocument, Integer.parseInt(entete.getId()), entete.getCode_caisse());
                ++this.numLine;
                if (!AppLocal.MODULE_MULTI_TVA) continue;
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (!supplement.addTaxeToOption() || supplement.getTax() == null) continue;
                    supplement.setNumLine(this.numLine);
                    this.addLine(line, supplement, ticket, this.idDocument, Integer.parseInt(entete.getId()), entete.getCode_caisse());
                    ++this.numLine;
                }
            }
            this.numeroLine = 0;
            this.totalHT = 0.0;
            for (TaxLineInfo taxe : ticket.getTaxes()) {
                System.out.println("taxe : " + taxe);
                this.totalHT += Math.abs(NumericUtils.round(taxe.getSumHT()));
                this.addTotalTax(taxe, ticket, Integer.parseInt(entete.getId()));
            }
            this.addTotalEncaissement(ticket, Integer.parseInt(entete.getId()));
            StringBuilder grandTotalEmprinte = new StringBuilder();
            grandTotalEmprinte.append(ttcVentille);
            this.addGrandTotalTicket(ticket, grandTotalEmprinte, Integer.parseInt(entete.getId()));
            for (PaymentInfo p : ticket.getPayments()) {
                this.addTICKET_PAYMENT(ticket, p, Integer.parseInt(entete.getId()), entete.getCode_caisse());
                this.addPayment(ticket, p);
            }
            if (ticketsRestau != null) {
                for (TicketResto value : ticketsRestau.values()) {
                    this.addTicketResto(value);
                }
            }
            if (ticket.getCustomerId() != -1) {
                if (ticket.getTicketType() != 1) {
                    this.mCustomerService.increaseTurnover(ticket.getTotal(), ticket.getCustomerId());
                    this.mCustomerService.increaseNBOrders(ticket.getCustomerId());
                } else {
                    this.mCustomerService.decreaseTurnover(ticket.getTotal(), ticket.getCustomerId());
                    this.mCustomerService.decreaseNBOrders(ticket.getCustomerId());
                }
            }
            return true;
        }
        return false;
    }

    public void addTotalTax(TaxLineInfo taxe, TicketInfo ticket, int idEntete) throws BasicException {
        this.addTotalTax(taxe, ticket, ++this.numeroLine, this.idDocument, idEntete);
    }

    public void addTotalTax(TaxLineInfo taxe, TicketInfo ticket, int numeroLine, int idDocument, int idEntete) throws BasicException {
        this.addTotalTax(taxe, ticket, numeroLine, idDocument, new Date(), idEntete);
    }

    public void addTotalTax(final TaxLineInfo taxe, final TicketInfo ticket, final int numeroLine, final int idDocument, final Date mDate, final int idEntete) throws BasicException {
        final double rateTaxe = AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL ? taxe.getRate() : NumericUtils.round(taxe.getRate(), 3);
        new PreparedSentence(this.s, "INSERT INTO TOTAL_TAX ( num_line, total_ht, code_tax, rate_tax, total_tax, total_ttc, ticket, num_doc , timestampGDH, REF_ORIGINE, TAXE_GLOBAL) VALUES(?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, numeroLine);
                if (ticket.getTicketType() == 1) {
                    this.setDouble(2, -1.0 * NumericUtils.round(taxe.getSumHT()));
                    this.setDouble(5, -1.0 * NumericUtils.round(taxe.getAmount()));
                    this.setDouble(6, -1.0 * NumericUtils.round(taxe.getSumTTC()));
                } else {
                    this.setDouble(2, NumericUtils.round(taxe.getSumHT()));
                    this.setDouble(5, NumericUtils.round(taxe.getAmount()));
                    this.setDouble(6, NumericUtils.round(taxe.getSumTTC()));
                }
                this.setString(3, taxe.getId());
                this.setDouble(4, rateTaxe);
                this.setString(7, ticket.getId());
                this.setString(8, String.valueOf(idDocument));
                this.setTimestamp(9, mDate);
                this.setInt(10, idEntete);
                this.setBoolean(11, taxe.isTaxe_global());
            }
        });
    }

    public void addLine(final TicketLineInfo l, final TicketInfo ticket, final int documentId, final int idEntete, final String code_caisse) throws BasicException {
        double discountFromTicket;
        double ttcWithDiscount;
        final double discount = l.getDiscountPriceWithoutTaxedOptions();
        double ttc = NumericUtils.round(l.getHtAmount() + l.getTaxAmount());
        if (ttc - this.restReduction >= 0.0) {
            ttcWithDiscount = ttc - this.restReduction;
            discountFromTicket = this.restReduction;
            this.restReduction = 0.0;
        } else {
            ttcWithDiscount = 0.0;
            discountFromTicket = ttc;
            this.restReduction = this.restReduction - ttc;
        }
        final double rate_tax = l.getTaxInfo() != null ? l.getTaxInfo().getRate() : 0.0;
        final boolean isRefund = ticket.getTicketType() == 1;
        final double total_tax = NumericUtils.round(ttcWithDiscount) - Math.abs(NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax)));
        new PreparedSentence(this.s, "INSERT INTO LINES ( num_doc, num_line, code_product, origin_data, descriptive_product, code_tax, rate_tax, price_HT, price_TTC, total_ht, total_ttc, code_user, timestampGDH, centre_profit, ticket ,quantite ,code_operator ,discount ,taux_discount,horodatage, TYPE_OPERATION , code_Caisse , REF_ORIGINE, TOTAL_TAX) VALUES(?,?,?,?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, String.valueOf(documentId));
                this.setInt(2, l.getNumLine() + 1);
                this.setString(3, String.valueOf(l.getProductID()));
                this.setString(4, "IN");
                this.setString(5, l.getProductName());
                this.setString(6, l.getTaxInfo() != null ? l.getTaxInfo().getId() : "000");
                this.setDouble(7, NumericUtils.round(rate_tax, 3));
                this.setDouble(8, NumericUtils.round(l.getPriceWithoutTaxedOptions() / (1.0 + rate_tax)));
                this.setDouble(9, NumericUtils.round(l.getPriceWithoutTaxedOptions()));
                this.setString(12, ticket.getUser().getId());
                this.setTimestamp(13, ticket.getLastUpdate());
                this.setString(14, "N/A");
                this.setString(15, ticket.getId());
                if (isRefund) {
                    this.setDouble(16, -1.0 * Math.abs(NumericUtils.round(l.getMultiply())));
                    this.setDouble(10, -1.0 * Math.abs(NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax))));
                    this.setDouble(11, -1.0 * Math.abs(NumericUtils.round(ttcWithDiscount)));
                    this.setString(21, "Annulation");
                    this.setDouble(18, -1.0 * Math.abs(NumericUtils.round((discount + discountFromTicket) / l.getMultiply())));
                    this.setDouble(19, -1.0 * Math.abs(NumericUtils.round(100.0 * NumericUtils.round(discount + discountFromTicket) / NumericUtils.round(l.getMultiply() * l.getPriceWithoutTaxedOptions()))));
                    this.setDouble(24, -1.0 * Math.abs(NumericUtils.round(total_tax)));
                } else {
                    this.setDouble(10, NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax)));
                    this.setDouble(11, NumericUtils.round(ttcWithDiscount));
                    this.setDouble(16, Math.abs(NumericUtils.round(l.getMultiply())));
                    this.setString(21, "Vente");
                    this.setDouble(18, NumericUtils.round((discount + discountFromTicket) / l.getMultiply()));
                    this.setDouble(19, NumericUtils.round(100.0 * NumericUtils.round(discount + discountFromTicket) / NumericUtils.round(l.getMultiply() * l.getPriceWithoutTaxedOptions())));
                    this.setDouble(24, Math.abs(NumericUtils.round(total_tax)));
                }
                this.setString(17, ticket.getUser().getId());
                if (ticket.getLastUpdate() != null) {
                    this.setString(20, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getLastUpdate()));
                } else if (ticket.getDate() != null) {
                    this.setString(20, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getDate()));
                } else {
                    this.setString(20, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(new Date()));
                }
                this.setString(22, code_caisse);
                this.setInt(23, idEntete);
            }
        });
    }

    public final boolean saveTicketAttente(final TicketInfo ticket, String location, boolean serveur) throws BasicException, SQLException {
        if (this.isValidPeriod()) {
            ticket.setTicketId(this.getTicketId(ticket));
            if (ticket.getSent_from() == null || !ticket.getSent_from().equals("Dishop") || !ticket.isPlatform_order()) {
                ticket.setNowAsDate();
            }
            this.addRECEIPTS(ticket);
            CaisseInfo caisse = this.getCaisse(AppLocal.token);
            ticket.setStatus("pending");
            this.addTicket(ticket, false, caisse, null, -1, serveur);
            if (ticket.getTable() != null) {
                new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setBoolean(1, false);
                        this.setInt(2, ticket.getTable().getId());
                    }
                });
            }
            this.idDocument = this.addDocument(ticket);
            this.numLine = 0;
            for (TicketLineInfo l : ticket.getLines()) {
                if (l.isNext()) {
                    this.addNextLine(ticket);
                    continue;
                }
                if (l.getProductID() != -1) {
                    this.addTicketLine(ticket, l);
                } else if (l.isProduct_platform()) {
                    this.addTicketLineDivers(ticket, l);
                } else {
                    this.addProductDivers(ticket, l);
                }
                l.setNumLine(this.numLine);
                ++this.numLine;
            }
            return true;
        }
        return false;
    }

    public void addTotalEncaissement(final TicketInfo ticket, final int documentId, final int idEntete) throws BasicException {
        final TotaleEncaissement totalEncaissment = ticket.getTolalEncaissment();
        new PreparedSentence(this.s, "INSERT INTO TOTAL_ENCAISSEMENT ( num_doc, total_ht, total_ttc, ticket, num_line, total_tax, REF_ORIGINE, TOTAL_DISCOUNT, TOTAL_HT_TAXABLE, TOTAL_HT_NO_TAXABLE) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, String.valueOf(documentId));
                if (ticket.getTicketType() == 1) {
                    this.setDouble(2, -1.0 * NumericUtils.round(totalEncaissment.getTotal_ht()));
                    this.setDouble(3, -1.0 * NumericUtils.round(totalEncaissment.getTotal_ttc()));
                    this.setInt(5, -1 * ticket.getNbrArticles());
                    this.setDouble(6, -1.0 * NumericUtils.round(totalEncaissment.getTotal_tax()));
                    this.setDouble(8, -1.0 * NumericUtils.round(ticket.getGlobalDiscountLinesAndOrder()));
                    this.setDouble(9, -1.0 * NumericUtils.round(totalEncaissment.getTotal_ht_taxable()));
                    this.setDouble(10, -1.0 * NumericUtils.round(totalEncaissment.getTotal_ht_no_taxable()));
                } else {
                    this.setDouble(2, NumericUtils.round(totalEncaissment.getTotal_ht()));
                    this.setDouble(3, NumericUtils.round(totalEncaissment.getTotal_ttc()));
                    this.setInt(5, ticket.getNbrArticles());
                    this.setDouble(6, NumericUtils.round(totalEncaissment.getTotal_tax()));
                    this.setDouble(8, NumericUtils.round(ticket.getGlobalDiscountLinesAndOrder()));
                    this.setDouble(9, NumericUtils.round(totalEncaissment.getTotal_ht_taxable()));
                    this.setDouble(10, NumericUtils.round(totalEncaissment.getTotal_ht_no_taxable()));
                }
                this.setString(4, ticket.getId());
                this.setInt(7, idEntete);
            }
        });
    }

    public void addTotalEncaissement(TicketInfo ticket, int idEntete) throws BasicException {
        this.addTotalEncaissement(ticket, this.idDocument, idEntete);
    }

    public final boolean paidTicketAttente(TicketInfo ticket, String location, String userId) throws BasicException {
        return this.paidTicketAttente(ticket, location, userId, "paid");
    }

    public final boolean paidTicketAttente(final TicketInfo ticket, String location, String userId, final String status) throws BasicException {
        if (this.isValidPeriod()) {
            ticket.setPaid(true);
            ticket.setStatus(status);
            final Date d = new Date();
            ticket.setLastUpdate(d);
            ticket.setDatePaid(d);
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this);
            ticket.setTotal(ticket.getTotal());
            System.out.println("NumericUtils.round(ticket.getDiscount(), 2) : " + NumericUtils.round(ticket.getDiscount(), 2));
            new PreparedSentence(this.s, "UPDATE  TICKETS SET paid = ?, STATUS = ? , LAST_UPDATE = ? , date_paid =?,  discount = ? , typediscount = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setString(2, status);
                    this.setTimestamp(3, d);
                    this.setTimestamp(4, d);
                    this.setDouble(5, NumericUtils.round(ticket.getDiscount(), 2));
                    this.setString(6, ticket.getTypeDiscount());
                    this.setString(7, ticket.getId());
                }
            });
            if (ticket.getTable() != null) {
                new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setBoolean(1, true);
                        this.setInt(2, ticket.getTable().getId());
                    }
                });
            }
            this.numeroLine = 0;
            GrandTotalTicket grandTotalTicket = this.getLastGrandTotalTicket();
            if (grandTotalTicket != null && !grandTotalTicket.isBefore_perpetual_reset()) {
                this.cumulPerpetualTicket = grandTotalTicket.getCumulPerpetual() + Math.abs(ticket.getTotalOrder());
                this.cumulPerpetualReelTicket = grandTotalTicket.getCumulPerpetualReel() + ticket.getTotalOrder();
            } else {
                this.cumulPerpetualTicket = Math.abs(ticket.getTotalOrder());
                this.cumulPerpetualReelTicket = ticket.getTotalOrder();
            }
            Document document = this.getDocumentTicket(ticket.getId());
            this.idDocument = document != null ? document.getId() : 0;
            String idTva = UUID.randomUUID().toString();
            StringBuilder grandTotalEmprinte = new StringBuilder();
            this.calculAndAddTvaToSignature(grandTotalEmprinte, ticket);
            StringBuilder ticketEmprinte = new StringBuilder();
            this.addTvaToSignature(ticketEmprinte, this.totalTVA5, this.totalTVA10, this.totalTVA20, this.totalTVA0, this.totalTVA_7_7, this.totalTVA_2_5, this.totalTVA_2_1, this.totalTVA_8_5, this.totalTVA_6, this.totalTVA_12, this.totalTVA_21, this.totalTVA_8_1, this.totalTVA_2_6);
            if (marqueNF == null) {
                marqueNF = new MarqueNFC("", "", "", "", "", "", "", "", "");
            }
            this.addEntete(marqueNF, ticket, "paid", ticketEmprinte);
            EnteteInfo entete = this.getEnteteByTicket(ticket.getId(), true);
            if (grandTotalTicket != null) {
                grandTotalEmprinte.append(",").append((long)((double)this.multiplyPositif(ticket) * NumericUtils.round(NumericUtils.round(ticket.getTotal()) * 100.0))).append(",").append((long)NumericUtils.round(NumericUtils.round(this.cumulPerpetualReelTicket) * 100.0)).append(",").append(com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(d)).append(",").append(entete.getId()).append(",O,").append(grandTotalTicket.getSignature());
            } else {
                grandTotalEmprinte.append(",").append((long)((double)this.multiplyPositif(ticket) * NumericUtils.round(NumericUtils.round(ticket.getTotal()) * 100.0))).append(",").append((long)NumericUtils.round(NumericUtils.round(this.cumulPerpetualReelTicket) * 100.0)).append(",").append(com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(d)).append(",").append(entete.getId()).append(",N,");
            }
            this.addGrandTotalTicket(ticket, grandTotalEmprinte, Integer.parseInt(entete.getId()));
            Collections.sort(ticket.getLines(), TicketInfo.infoComparator);
            this.restReduction = ticket.getTypeDiscount().equals("pourcentage") ? ticket.getDiscount() * ticket.getRealTotal() / 100.0 : ticket.getDiscount();
            this.numLine = 0;
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.isNext()) continue;
                line.setNumLine(this.numLine);
                ++this.numLine;
                this.addLine(line, ticket, this.idDocument, Integer.parseInt(entete.getId()), entete.getCode_caisse());
                if (!AppLocal.MODULE_MULTI_TVA) continue;
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (!supplement.addTaxeToOption() || supplement.getTax() == null) continue;
                    supplement.setNumLine(this.numLine);
                    this.addLine(line, supplement, ticket, this.idDocument, Integer.parseInt(entete.getId()), entete.getCode_caisse());
                    ++this.numLine;
                }
            }
            this.totalHT = 0.0;
            for (TaxLineInfo taxe : ticket.getTaxes()) {
                this.totalHT += Math.abs(taxe.getSumHT());
                this.addTotalTax(taxe, ticket, Integer.parseInt(entete.getId()));
            }
            this.addTotalEncaissement(ticket, Integer.parseInt(entete.getId()));
            for (PaymentInfo p : this.findPaymetsByIdTicket(ticket.getId())) {
                this.addTICKET_PAYMENT(ticket, p, Integer.parseInt(entete.getId()), entete.getCode_caisse());
            }
            if (ticket.getCustomerId() != -1) {
                this.mCustomerService.increaseTurnover(ticket.getTotalOrder(), ticket.getCustomerId());
                this.mCustomerService.increaseNBOrders(ticket.getCustomerId());
            }
            return true;
        }
        return false;
    }

    public List<TicketLineInfo> getTicketLine(String idTicket) throws BasicException {
        List ticketsLines = new PreparedSentence(this.s, this.requestLine + " WHERE L.TICKET = ? ORDER BY L.ID ", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)idTicket);
        return ticketsLines;
    }

    public List<TicketLineInfo> getTicketLineExterne(String idTicket) throws BasicException {
        List ticketsLines = new PreparedSentence(this.s, "SELECT P.ID, P.TICKET, P.PRICE, P.htAmount, P.taxAmount, P.UNITS, T.ID, T.NAME, T.RATE, P.PRODUCT, P.paid, P.units_paid, P.place_served, P.time_served FROM PRODUCT_DIVERS P LEFT OUTER JOIN TAXCATEGORIES T ON P.TAXID = T.ID WHERE P.TICKET = ? ORDER BY P.ID ", SerializerWriteString.INSTANCE, TicketLineInfo.getSerializerRead()).list((Object)idTicket);
        for (TicketLineInfo line : ticketsLines) {
            line.setListIngredients(new ArrayList<ItemOrderInfo>());
            line.setListSupplements(new ArrayList<OptionItemOrder>());
            line.setListProducts(new ArrayList<ProductTicket>());
        }
        return ticketsLines;
    }

    public TicketLineInfo getTicketLineById(int id) throws BasicException {
        return (TicketLineInfo)new PreparedSentence(this.s, this.requestLine + " WHERE L.ID = ? ", SerializerWriteInteger.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).find((Object)id);
    }

    public void deleteTicketLine(TicketLineInfo line) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM Option_ticket WHERE idTicketLine = ?", SerializerWriteInteger.INSTANCE).exec((Object)line.getID());
        new StaticSentence(this.s, "DELETE FROM ingredient_ticket WHERE idTicketLine = ?", SerializerWriteInteger.INSTANCE).exec((Object)line.getID());
        new StaticSentence(this.s, "DELETE FROM Product_ticket WHERE idTicketLine = ?", SerializerWriteInteger.INSTANCE).exec((Object)line.getID());
        new StaticSentence(this.s, "DELETE FROM TICKETLINES WHERE ID = ?", SerializerWriteInteger.INSTANCE).exec((Object)line.getID());
        if (this.STOCK_ENABLED) {
            this.changeStockProduct(line, line.getMultiply());
        }
        try {
            Journal.writeToJET(new Event(323, "Annulation d'une ligne d'article", AppLocal.user.getId(), "", new Date().getTime(), ""));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void deleteTicketLineExterne(int ID) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM PRODUCT_DIVERS WHERE ID = ?", SerializerWriteInteger.INSTANCE).exec((Object)ID);
    }

    public void updateOptionTicket(final OptionItemOrder supplement) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  Option_ticket set numberoption = ?, order_option = ?, number_free = ?, price = ?, FULL_PRICE = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, supplement.getNumberOption());
                this.setInt(2, supplement.getOrder_option());
                this.setInt(3, supplement.getNumber_free());
                this.setDouble(4, supplement.getPrice());
                this.setDouble(5, supplement.getFull_price());
                this.setInt(6, supplement.getId());
            }
        });
    }

    public void deleteOptionTicket(final int id) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM Option_ticket WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    public void deleteIngredientTicket(final int id) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM ingredient_ticket WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    public List<ItemOrderInfo> getIngredientsTicket(int idTicketLine) throws BasicException {
        return new PreparedSentence(this.s, this.requestIngredientLine, SerializerWriteInteger.INSTANCE, ItemOrderInfo.getSerializerRead()).list((Object)idTicketLine);
    }

    public List<ProductTicket> getProductsTicket(int idTicketLine) throws BasicException {
        return new PreparedSentence(this.s, this.requestProductTicket, SerializerWriteInteger.INSTANCE, ProductTicket.getSerializerRead()).list((Object)idTicketLine);
    }

    public List<OptionItemOrder> getOptionTicket(int idTicketLine) throws BasicException {
        List options = new PreparedSentence(this.s, this.requestSuplementLine, SerializerWriteInteger.INSTANCE, OptionItemOrder.getSerializerRead()).list((Object)idTicketLine);
        for (OptionItemOrder option : options) {
            if (option.getTaxId() == null || option.getTaxId().isEmpty()) continue;
            TaxInfo tax = this.getTaxById(option.getTaxId());
            option.setTax(tax);
        }
        return options;
    }

    public void updateDiscountOrder(final TicketInfo ticket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TICKETS SET  total = ?, discount = ?, typediscount = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(ticket.getTotal()));
                this.setDouble(2, NumericUtils.round(ticket.getDiscount()));
                this.setString(3, ticket.getTypeDiscount());
                this.setString(4, ticket.getId());
            }
        });
    }

    public final void updateTicket(final TicketInfo ticket, String location, AppUser user, boolean add_log) throws BasicException, SQLException {
        int found;
        new PreparedSentence(this.s, "UPDATE  TICKETS SET  total = ?, tempsLv = ?, modePayment = ?, discount = ?, typediscount = ?, bipper = ?, last_update = ?, couverts = ?, type = ?, PRINT_AFTER_UPDATE = 0 WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(ticket.getTotal()));
                this.setString(2, ticket.getTempsLv());
                this.setString(3, ticket.getModePayment());
                this.setDouble(4, NumericUtils.round(ticket.getDiscount()));
                this.setString(5, ticket.getTypeDiscount());
                this.setInt(6, ticket.getBipper());
                this.setTimestamp(7, ticket.getLastUpdate());
                this.setInt(8, ticket.getCouverts());
                this.setString(9, ticket.getType());
                this.setString(10, ticket.getId());
            }
        });
        if (ticket.getTable() != null) {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET idTable = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, ticket.getTable().getId());
                    this.setString(2, ticket.getId());
                }
            });
            new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setInt(2, ticket.getOldTable());
                }
            });
            new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, false);
                    this.setInt(2, ticket.getTable().getId());
                }
            });
        }
        if (ticket.getLivreur() != null) {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET livreur = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, ticket.getLivreur().getId());
                    this.setString(2, ticket.getId());
                }
            });
        }
        if (ticket.getCustomerId() != -1) {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET CUSTOMER = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, ticket.getCustomerId());
                    this.setString(2, ticket.getId());
                }
            });
        }
        for (TicketLineInfo ticketLineInfo : this.getTicketLine(ticket.getId())) {
            Object productTmp;
            found = -1;
            for (TicketLineInfo l : ticket.getLines()) {
                if (ticketLineInfo.getID() != l.getID()) continue;
                found = 1;
            }
            if (found != -1) continue;
            if (!ticketLineInfo.isNext() && add_log && (productTmp = this.getProductInfoById(ticketLineInfo.getProductID())) != null) {
                LogPanier panier = new LogPanier(user.getId(), ticket.getNumero_order(), ticketLineInfo.getMultiply(), ticketLineInfo.getPrice(), ((ProductInfoExt)productTmp).getName(), ticketLineInfo.getValueDiscount(), ticketLineInfo.getLabelDiscount(), true);
                this.addLog(panier);
                this.mTransactionMevService.saveLines(ticket.getId(), ((ProductInfoExt)productTmp).getName(), ((ProductInfoExt)productTmp).getID(), ticketLineInfo.getMultiply(), ticketLineInfo.getPrice(), ticketLineInfo.getValueDiscount(), ticketLineInfo.getLabelDiscount(), ticketLineInfo.getSizeProduct());
            }
            this.deleteTicketLine(ticketLineInfo);
        }
        for (TicketLineInfo ticketLineInfo : this.getTicketLineExterne(ticket.getId())) {
            found = -1;
            for (TicketLineInfo l : ticket.getLines()) {
                if (!l.isDiver() || ticketLineInfo.getProductID() != l.getProductID()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteTicketLineExterne(ticketLineInfo.getProductID());
        }
        for (final TicketLineInfo l : ticket.getLines()) {
            if (l.getProductID() != -1 && !l.isNext() && l.isDiver()) {
                this.updateProductDivers(l);
            }
            if (l.getID() == -1 || l.isNext() || l.isDiver()) continue;
            boolean addEventUpdateLine = false;
            new PreparedSentence(this.s, "UPDATE  TICKETLINES SET UNITS = ?, PRICE = ?,  htAmount = ?, taxAmount = ?, note = ?, discount = ?, label_discount = ?, place_served = ?, time_served = ?, numero_line = ?, label = ?, TYPE_DISCOUNT = ?, PROMO_PRODUCT = ?, PRODUCT_PROMOTION_APPLIED = ?, TVA_GLOBAL_NO_APPLICABLE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setDouble(1, NumericUtils.round(l.getMultiply()));
                    this.setDouble(2, NumericUtils.round(l.getPrice()));
                    this.setDouble(3, NumericUtils.round(l.getHtAmount()));
                    this.setDouble(4, NumericUtils.round(l.getTaxAmount()));
                    this.setString(5, l.getNote());
                    this.setDouble(6, NumericUtils.round(l.getValueDiscount()));
                    this.setString(7, l.getLabelDiscount());
                    this.setString(8, l.getPlace_served());
                    this.setString(9, l.getTime_served());
                    this.setInt(10, l.getNumero_line());
                    this.setBoolean(11, l.isLabel());
                    this.setString(12, l.getType_discount());
                    this.setBoolean(13, l.isPromo_product());
                    this.setBoolean(14, l.isProduct_promotion_applied());
                    this.setBoolean(15, l.isTva_global_no_applicable());
                    this.setInt(16, l.getID());
                }
            });
            double diff = l.getOldMultiply() - l.getMultiply();
            if (this.STOCK_ENABLED) {
                this.changeStockProduct(l, diff);
            }
            if (l.getOldMultiply() > l.getMultiply()) {
                Iterator<Cloneable> line = new TicketLineInfo(l);
                ((TicketLineInfo)((Object)line)).setMultiply(l.getOldMultiply() - l.getMultiply());
                ((TicketLineInfo)((Object)line)).setPrice(l.getOldPrice());
                ((TicketLineInfo)((Object)line)).setDiscount(l.getOldDiscount());
                ((TicketLineInfo)((Object)line)).setLabelDiscount(l.getOldLabelDiscount());
                if (add_log) {
                    ProductInfoExt productInfoExt = this.getProductInfoById(((TicketLineInfo)((Object)line)).getProductID());
                    LogPanier panier = new LogPanier(user.getId(), ticket.getNumero_order(), ((TicketLineInfo)((Object)line)).getMultiply(), ((TicketLineInfo)((Object)line)).getPrice(), productInfoExt.getName(), ((TicketLineInfo)((Object)line)).getValueDiscount(), ((TicketLineInfo)((Object)line)).getLabelDiscount(), true);
                    this.addLog(panier);
                }
            }
            if (l.getOldDiscount() != l.getValueDiscount() || l.getOldPrice() != l.getPrice()) {
                addEventUpdateLine = true;
            }
            for (ItemOrderInfo itemOrderInfo : l.getListIngredients()) {
                int found2 = -1;
                for (ItemOrderInfo itemOrderInfo2 : this.getIngredientsTicket(l.getID())) {
                    if (itemOrderInfo.getIdCarte() != itemOrderInfo2.getIdCarte() || itemOrderInfo.getIdProduct() != itemOrderInfo2.getIdProduct() || itemOrderInfo.getSupplement() != itemOrderInfo2.getSupplement() || itemOrderInfo.getIndex_carte() != itemOrderInfo2.getIndex_carte()) continue;
                    found2 = 1;
                }
                if (found2 != -1) continue;
                addEventUpdateLine = true;
                this.addIngredientLine(itemOrderInfo, l.getID());
            }
            for (ItemOrderInfo itemOrderInfo : this.getIngredientsTicket(l.getID())) {
                int found3 = -1;
                for (ItemOrderInfo itemOrderInfo3 : l.getListIngredients()) {
                    if (itemOrderInfo3.getIdCarte() != itemOrderInfo.getIdCarte() || itemOrderInfo3.getIdProduct() != itemOrderInfo.getIdProduct() || itemOrderInfo3.getSupplement() != itemOrderInfo.getSupplement() || itemOrderInfo3.getIndex_carte() != itemOrderInfo.getIndex_carte()) continue;
                    found3 = 1;
                }
                if (found3 != -1) continue;
                addEventUpdateLine = true;
                this.deleteIngredientTicket(itemOrderInfo.getId());
            }
            for (OptionItemOrder optionItemOrder : l.getListSupplements()) {
                int found4 = -1;
                for (OptionItemOrder optionItemOrder2 : this.getOptionTicket(l.getID())) {
                    if (optionItemOrder.getIdCarte() != optionItemOrder2.getIdCarte() || optionItemOrder.getIdProduct() != optionItemOrder2.getIdProduct() || optionItemOrder.getSupplement() != optionItemOrder2.getSupplement() || optionItemOrder.getIndex_carte() != optionItemOrder2.getIndex_carte()) continue;
                    found4 = 1;
                }
                if (found4 == -1) {
                    addEventUpdateLine = true;
                    this.addOptionLine(optionItemOrder, l.getID());
                    continue;
                }
                this.updateOptionTicket(optionItemOrder);
            }
            for (OptionItemOrder optionItemOrder : this.getOptionTicket(l.getID())) {
                int found5 = -1;
                for (OptionItemOrder optionItemOrder3 : l.getListSupplements()) {
                    if (optionItemOrder3.getIdCarte() != optionItemOrder.getIdCarte() || optionItemOrder3.getIdProduct() != optionItemOrder.getIdProduct() || optionItemOrder3.getSupplement() != optionItemOrder.getSupplement() || optionItemOrder3.getIndex_carte() != optionItemOrder.getIndex_carte()) continue;
                    found5 = 1;
                }
                if (found5 != -1) continue;
                addEventUpdateLine = true;
                this.deleteOptionTicket(optionItemOrder.getId());
            }
            for (ProductTicket productTicket : l.getListProducts()) {
                int found6 = -1;
                for (ProductTicket productTicket2 : this.getProductsTicket(l.getID())) {
                    if (productTicket.getIdProduct() != productTicket2.getIdProduct() || productTicket.getIdCarte() != productTicket2.getIdCarte() || productTicket.getIndex_carte() != productTicket2.getIndex_carte()) continue;
                    found6 = 1;
                }
                if (found6 != -1) continue;
                addEventUpdateLine = true;
                this.addProductLine(productTicket, this.idTicketLine);
            }
            for (final ProductTicket productTicket : this.getProductsTicket(l.getID())) {
                int found7 = -1;
                for (ProductTicket productTicket3 : l.getListProducts()) {
                    if (productTicket3.getIdProduct() != productTicket.getIdProduct() || productTicket3.getIdCarte() != productTicket.getIdCarte() || productTicket3.getIndex_carte() != productTicket.getIndex_carte()) continue;
                    found7 = 1;
                }
                if (found7 != -1) continue;
                addEventUpdateLine = true;
                new PreparedSentence(this.s, "DELETE FROM Product_ticket WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, productTicket.getId());
                    }
                });
            }
            if (!addEventUpdateLine) continue;
            try {
                Journal.writeToJET(new Event(323, "Modification d'une ligne d'article", AppLocal.user.getId(), "", new Date().getTime(), ""));
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        for (final TicketLineInfo l : ticket.getLines()) {
            if (l.getID() == -1 && l.isNext()) {
                this.addNextLine(ticket);
            }
            if (l.getID() == -1 && !l.isNext() && !l.isDiver()) {
                this.addTicketLine(ticket, l);
            }
            if (l.getProductID() != -1 || l.isNext() || !l.isDiver()) continue;
            this.addProductDivers(ticket, l);
        }
        if (ticket.getTable() == null && ticket.getOldTable() != 0 && ticket.getOldTable() != -1 || ticket.getTable() != null && ticket.getTable().getId() != ticket.getOldTable()) {
            try {
                int numeroDocument = this.getDocumentTicket(ticket.getId()).getId();
                Journal.writeToJET(new Event(430, "Modification note", AppLocal.user.getId(), "Affection d'une note \u00e0 une table ", new Date().getTime(), String.valueOf(numeroDocument)));
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public final Integer getNextPickupIndex() throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "PICKUP_NUMBER").find();
    }

    public final Integer getNextTicketIndex() throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM").find();
    }

    public final Integer getNextTicketRefundIndex() throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM_REFUND").find();
    }

    public final Integer getNextTicketPaymentIndex() throws BasicException {
        return (Integer)this.s.DB.getSequenceSentence(this.s, "TICKETSNUM_PAYMENT").find();
    }

    public final SentenceExec getPaymentMovementInsert() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                new PreparedSentence(DataLogicSales.this.s, "INSERT INTO RECEIPTS (ID, MONEY, DATENEW) VALUES (?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.paymenttabledatas, new int[]{0, 1, 2})).exec(params);
                return new PreparedSentence(DataLogicSales.this.s, "INSERT INTO PAYMENTS (ID, RECEIPT, PAYMENT, TOTAL, NOTES) VALUES (?, ?, ?, ?, ?)", new SerializerWriteBasicExt(DataLogicSales.this.paymenttabledatas, new int[]{3, 0, 4, 5, 6})).exec(params);
            }
        };
    }

    public final SentenceExec getPaymentMovementDelete() {
        return new SentenceExecTransaction(this.s){

            @Override
            public int execInTransaction(Object params) throws BasicException {
                new PreparedSentence(DataLogicSales.this.s, "DELETE FROM PAYMENTS WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.paymenttabledatas, new int[]{3})).exec(params);
                return new PreparedSentence(DataLogicSales.this.s, "DELETE FROM RECEIPTS WHERE ID = ?", new SerializerWriteBasicExt(DataLogicSales.this.paymenttabledatas, new int[]{0})).exec(params);
            }
        };
    }

    public final TableDefinition getTableLocations() {
        return new TableDefinition(this.s, "LOCATIONS", new String[]{"ID", "NAME", "ADDRESS"}, new String[]{"ID", AppLocal.getIntString("label.locationname"), AppLocal.getIntString("label.locationaddress")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING}, new int[]{0});
    }

    public GrandTotalTicket getFirstTotalTicket() throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGrandToTalTicket + "FROM GRAND_TOTAL ORDER BY timestampGDH FETCH FIRST 1 rows only ", null, GrandTotalTicket.getSerializerRead()).list();
        if (listTotaux.size() > 0) {
            return (GrandTotalTicket)listTotaux.get(0);
        }
        return null;
    }

    private void addProductLine(ProductTicket product, int idLine) throws SQLException {
        String SQL = "INSERT INTO Product_ticket (idCarte, nameCarte, idProduct, nameProduct, idTicketLine, numberoproduct, price, index_carte, sizeproduct, comment, printer, printerLabel) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setInt(1, product.getIdCarte());
        this.pstmt.setString(2, product.getNameCarte());
        this.pstmt.setInt(3, product.getIdProduct());
        this.pstmt.setString(4, product.getNameProduct());
        this.pstmt.setInt(5, idLine);
        this.pstmt.setInt(6, product.getNumberProduct());
        this.pstmt.setDouble(7, product.getPriceProduct());
        this.pstmt.setInt(8, product.getIndex_carte());
        this.pstmt.setString(9, product.getSizeProduct());
        this.pstmt.setString(10, product.getComment());
        this.pstmt.setInt(11, product.getPrinterID());
        this.pstmt.setInt(12, product.getPrinterLabel());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int id_item = 0;
        if (rs.next()) {
            int last_inserted_id;
            id_item = last_inserted_id = rs.getInt(1);
        }
        product.setId(id_item);
    }

    private String getTicketStatus(TicketInfo ticket) throws BasicException {
        String statut;
        block7: {
            block6: {
                statut = "";
                if (ticket.getTicketId() != 0) break block6;
                switch (ticket.getTicketType()) {
                    case 0: {
                        ticket.setTicketId(this.getNextTicketIndex());
                        statut = "paid";
                        break block7;
                    }
                    case 1: {
                        ticket.setTicketId(this.getNextTicketIndex());
                        statut = "Refund";
                        break block7;
                    }
                    case 2: {
                        ticket.setTicketId(this.getNextTicketPaymentIndex());
                        statut = "paid";
                        break block7;
                    }
                    case 3: {
                        statut = "paid";
                        ticket.setTicketId(this.getNextTicketPaymentIndex());
                        break block7;
                    }
                    default: {
                        statut = "paid";
                        throw new BasicException();
                    }
                }
            }
            statut = "paid";
        }
        return statut;
    }

    private Date getscheduledDate(Date orderTime, String tempsLv) {
        int min = 0;
        if (tempsLv != null) {
            min = Integer.parseInt(tempsLv.replaceAll("[^0-9]", ""));
        }
        orderTime = DateUtils.addMinutes((Date)orderTime, (int)min);
        return orderTime;
    }

    private void addTicket(final TicketInfo ticket, final boolean paid, final CaisseInfo caisse, final String ticketOrigineId, final int ticketOriginIdInt, boolean serveur) throws BasicException {
        try {
            int numberOrder = this.getumberOrder();
            ticket.setNumero_order(numberOrder);
            final boolean is_agent_callcenter = !serveur;
            final Date dateCreated = new Date();
            ticket.setLastUpdate(dateCreated);
            if (ticket.getDelivered() == null && ticket.getTempsLv() != null && !ticket.getTempsLv().isEmpty()) {
                ticket.setDelivered(this.getscheduledDate(dateCreated, ticket.getTempsLv()));
            }
            if (ticket.getTicketType() != 1) {
                ticket.setTotal(NumericUtils.round(ticket.getTotal()));
            } else {
                ticket.setTotal(-1.0 * Math.abs(NumericUtils.round(ticket.getTotal())));
            }
            new PreparedSentence(this.s, "INSERT INTO TICKETS (ID, TICKETTYPE, TICKETID, PERSON, STATUS, total, type, paid, tempsLv, modePayment, caisse, numero_order, discount, typediscount, bipper, is_agent_callcenter, last_update, couverts, SOURCE_ORDER, NAME_CUSTOMER,date_paid, num_order_kitchen, ORDERED_FROM, SENT_FROM, NUMERO_ONLINE_ORDER, NUM_PLATFORM_ORDER, NUM_TABLE, LABEL_DISCOUNT, DELIVERED_AT, LICENCE_ID_MACHINE, CUSTOMER_LOYALTY_VERIFIED, EASEL_NUMBER, PLATFORM_ORDER, created, ID_ONLINE_ORDER, TAKE_AWAY_PHONE, ORDER_ID_BASE, KEENIO_BASE_ORDER,session_id , tag_erc_stan ,eft_stan ,last_digit ,EcrDateTime ,holder ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, ticket.getId());
                    this.setInt(2, ticket.getTicketType());
                    this.setInt(3, ticket.getTicketId());
                    this.setString(4, ticket.getUser().getId());
                    this.setString(5, ticket.getStatus());
                    this.setDouble(6, ticket.getTotalOrder());
                    this.setString(7, ticket.getType());
                    this.setBoolean(8, paid);
                    this.setString(9, ticket.getTempsLv());
                    this.setString(10, ticket.getModePayment());
                    System.out.println("++++++++++++++ caisse.getId()" + caisse.getId());
                    this.setInt(11, caisse.getId());
                    this.setInt(12, ticket.getNumero_order());
                    this.setDouble(13, NumericUtils.round(ticket.getDiscount(), 2));
                    this.setString(14, ticket.getTypeDiscount());
                    this.setInt(15, ticket.getBipper());
                    this.setBoolean(16, is_agent_callcenter);
                    this.setTimestamp(17, dateCreated);
                    this.setInt(18, ticket.getCouverts());
                    this.setString(19, ticket.getSource_order());
                    this.setString(20, ticket.getName_customer());
                    if (paid) {
                        this.setTimestamp(21, dateCreated);
                    } else {
                        this.setTimestamp(21, null);
                    }
                    this.setInt(22, ticket.getNum_order_kitchen());
                    this.setString(23, ticket.getOrdered_from());
                    this.setString(24, ticket.getSent_from());
                    this.setString(25, ticket.getNumero_online_order());
                    this.setString(26, ticket.getNumero_platform_order());
                    this.setInt(27, ticket.getNum_table());
                    this.setString(28, ticket.getLabel_discount());
                    this.setTimestamp(29, ticket.getDelivered());
                    this.setString(30, ticket.getCustomer_loyalty_id());
                    this.setBoolean(31, ticket.isCustomer_loyalty_verified());
                    this.setInt(32, ticket.getEasel_number());
                    this.setBoolean(33, ticket.isPlatform_order());
                    this.setTimestamp(34, ticket.getDate());
                    this.setString(35, ticket.getId_online_order());
                    this.setBoolean(36, ticket.isTake_away_phone());
                    this.setString(37, ticket.getOrder_id_base());
                    this.setString(38, ticket.getKeenio_base());
                    this.setString(39, ticket.getSession_id());
                    this.setString(40, ticket.getTag_erc_stan());
                    this.setString(41, ticket.getEft_stan());
                    this.setString(42, ticket.getLast_digit());
                    this.setString(43, ticket.getEcrDateTime());
                    this.setString(44, ticket.getHolder());
                }
            });
            if (ticket.getAddress() != -1 && ticket.getAddress() != 0) {
                new PreparedSentence(this.s, "UPDATE  TICKETS SET address = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, ticket.getAddress());
                        this.setString(2, ticket.getId());
                    }
                });
            }
            if (ticket.getLivreur() != null) {
                new PreparedSentence(this.s, "UPDATE  TICKETS SET livreur = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, ticket.getLivreur().getId());
                        this.setString(2, ticket.getId());
                    }
                });
            }
            if (ticketOriginIdInt != -1) {
                new PreparedSentence(this.s, "UPDATE  TICKETS SET canceled_ticket_id = ?, canceled_ticket_id_Int = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, ticketOrigineId);
                        this.setInt(2, ticketOriginIdInt);
                        this.setString(3, ticket.getId());
                    }
                });
            }
            if (ticket.getCustomerId() != -1 && ticket.getCustomerId() != 0) {
                new PreparedSentence(this.s, "UPDATE  TICKETS SET CUSTOMER = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, ticket.getCustomerId());
                        this.setString(2, ticket.getId());
                    }
                });
            }
            if (ticket.getTable() != null && ticket.getTicketType() != 1) {
                new PreparedSentence(this.s, "UPDATE  TICKETS SET idTable = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, ticket.getTable().getId());
                        this.setString(2, ticket.getId());
                    }
                });
            }
            this.incrementNumber(ticket.getNumero_order() + 1);
            if (ticket.getCustomerId() != -1 && ticket.getCustomerId() != 0 && ticket.getTicketType() != 1) {
                this.mCustomerService.changeLastOrder(ticket.getCustomerId(), ticket.getDate());
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    protected int addDocument(TicketInfo ticket) throws SQLException {
        String SQLDOC = "INSERT INTO DOCUMENT (ticket) VALUES (?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQLDOC, 1);
        this.pstmt.setString(1, ticket.getId());
        this.pstmt.executeUpdate();
        ResultSet rsDoc = this.pstmt.getGeneratedKeys();
        if (rsDoc.next()) {
            int last_inserted_id;
            this.idDocument = last_inserted_id = rsDoc.getInt(1);
        }
        return this.idDocument;
    }

    private void addNextLine(final TicketInfo ticket) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO TICKETLINES (TICKET, nextElement) VALUES(?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticket.getId());
                this.setBoolean(2, true);
            }
        });
    }

    private void addTicketLine(TicketInfo ticket, TicketLineInfo l) throws BasicException, SQLException {
        try {
            String SQL = "INSERT INTO TICKETLINES (TICKET, PRODUCT, UNITS, PRICE, TAXID, menu, htAmount, taxAmount, nextElement, note, discount, sizeproduct, label_discount, paid, name_sizeproduct, units_paid, place_served, time_served, numero_line, label, PRINTER_KITCHEN, PROMO_BASKET, TYPE_DISCOUNT, PROMO_PRODUCT, POINTS_LOYALTY, ALIAS_SIZE, PRODUCT_PROMOTION_APPLIED, TVA_GLOBAL_NO_APPLICABLE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
            this.pstmt.setString(1, ticket.getId());
            this.pstmt.setInt(2, l.getProductID());
            if (ticket.getTicketType() != 1) {
                this.pstmt.setDouble(3, NumericUtils.round(l.getMultiply()));
            } else {
                this.pstmt.setDouble(3, -1.0 * Math.abs(NumericUtils.round(l.getMultiply())));
            }
            this.pstmt.setDouble(4, NumericUtils.round(l.getPrice(), 2));
            this.pstmt.setString(5, l.getTaxInfo().getId());
            this.pstmt.setBoolean(6, l.isMenu());
            this.pstmt.setDouble(7, NumericUtils.round(l.getHtAmount(), 2));
            this.pstmt.setDouble(8, NumericUtils.round(l.getTaxAmount(), 2));
            this.pstmt.setBoolean(9, false);
            this.pstmt.setString(10, l.getNote());
            this.pstmt.setDouble(11, NumericUtils.round(l.getValueDiscount(), 2));
            this.pstmt.setString(12, l.getSizeProduct());
            this.pstmt.setString(13, l.getLabelDiscount());
            this.pstmt.setBoolean(14, l.isPaid());
            this.pstmt.setString(15, l.getName_sizeProduct());
            this.pstmt.setDouble(16, NumericUtils.round(l.getUnits_paid()));
            this.pstmt.setString(17, l.getPlace_served());
            this.pstmt.setString(18, l.getTime_served());
            this.pstmt.setInt(19, l.getNumero_line());
            this.pstmt.setBoolean(20, l.isLabel());
            this.pstmt.setString(21, l.getPrinter_kitchen());
            this.pstmt.setBoolean(22, l.isPromo_basket());
            this.pstmt.setString(23, l.getType_discount());
            this.pstmt.setBoolean(24, l.isPromo_product());
            this.pstmt.setDouble(25, NumericUtils.round(l.getPoints_loyalty()));
            this.pstmt.setString(26, l.getAlias_size());
            this.pstmt.setBoolean(27, l.isProduct_promotion_applied());
            this.pstmt.setBoolean(28, l.isTva_global_no_applicable());
            this.pstmt.executeUpdate();
            ResultSet rs = this.pstmt.getGeneratedKeys();
            if (rs.next()) {
                int last_inserted_id;
                this.idTicketLine = last_inserted_id = rs.getInt(1);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (this.STOCK_ENABLED && !ticket.getStatus().equals("Refund")) {
            ProductInfoExt productTMP = this.getProductInfoById(l.getProductID());
            if ("venteDetail".equals(AppLocal.licence) || !"venteDetail".equals(AppLocal.licence) && productTMP != null && productTMP.isStorable()) {
                this.decreaseStock(l.getProductID(), l.getMultiply(), "commande", new Date(), ticket.getUser().getId());
            }
        }
        for (ProductTicket product : l.getListProducts()) {
            this.addProductLine(product, this.idTicketLine);
        }
        for (ItemOrderInfo ingredient : l.getListIngredients()) {
            this.addIngredientLine(ingredient, this.idTicketLine);
        }
        for (OptionItemOrder supplement : l.getListSupplements()) {
            System.out.println("supplement save : " + supplement.getNameSupplement() + " order " + supplement.getOrder_option());
            this.addOptionLine(supplement, this.idTicketLine);
        }
        l.setID(this.idTicketLine);
    }

    private void addProductDivers(final TicketInfo ticket, final TicketLineInfo l) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PRODUCT_DIVERS (PRODUCT, PRICE, TAXID, TICKET, htAmount, taxAmount, UNITS, paid, units_paid, place_served, time_served) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, l.getNameProduct());
                this.setString(3, l.getTaxInfo() != null ? l.getTaxInfo().getId() : null);
                this.setString(4, ticket.getId());
                if (ticket.getTicketType() == 1) {
                    this.setDouble(7, -1.0 * NumericUtils.round(l.getMultiply()));
                } else {
                    this.setDouble(7, NumericUtils.round(l.getMultiply()));
                }
                this.setDouble(2, NumericUtils.round(l.getPrice(), 2));
                this.setDouble(5, NumericUtils.round(l.getHtAmount() / l.getMultiply()));
                this.setDouble(6, NumericUtils.round(l.getTaxAmount()));
                this.setBoolean(8, l.isPaid());
                this.setDouble(9, NumericUtils.round(l.getUnits_paid()));
                this.setString(10, l.getPlace_served());
                this.setString(11, l.getTime_served());
            }
        });
    }

    private void updateProductDivers(final TicketLineInfo l) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCT_DIVERS SET  PRICE = ?,  htAmount = ?, taxAmount = ?, UNITS = ?, place_served = ?, time_served = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(l.getPrice(), 2));
                this.setDouble(2, NumericUtils.round(l.getHtAmount(), 2));
                this.setDouble(3, NumericUtils.round(l.getTaxAmount()));
                this.setDouble(4, NumericUtils.round(l.getMultiply()));
                this.setString(5, l.getPlace_served());
                this.setString(6, l.getTime_served());
                this.setInt(7, l.getProductID());
            }
        });
    }

    public void addGrandTotalTicket(final TicketInfo ticket, final Date date, final int documentId, final int idEntete, final GrandTotalTicket mGrandGrandTotalTicket) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO GRAND_TOTAL (id, num_doc, timestampGDH, grand_total, grand_total_Perpetual, ticket, TVA_5_5, TVA_10, TVA_20, signature,horodatage, grand_total_Perpetual_reel, TVA_0, TVA_7_7, TVA_2_5, TVA_2_1, TVA_8_5, REF_ORIGINE, ADD_PERPETUAL_IN_SIGNATURE, ROUND_AMOUNT, TVA_6, TVA_12, TVA_21, TVA_8_1, TVA_2_6) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, mGrandGrandTotalTicket.getId());
                this.setString(2, String.valueOf(documentId));
                this.setString(6, ticket.getId());
                this.setTimestamp(3, date);
                if (ticket.getTicketType() == 1) {
                    this.setDouble(4, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getCumul())));
                    this.setDouble(5, NumericUtils.round(mGrandGrandTotalTicket.getCumulPerpetual()));
                    this.setDouble(12, NumericUtils.round(mGrandGrandTotalTicket.getCumulPerpetualReel()));
                    this.setDouble(7, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva5())));
                    this.setDouble(8, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva10())));
                    this.setDouble(9, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva20())));
                    this.setDouble(13, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva0())));
                    this.setDouble(14, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_7_7())));
                    this.setDouble(15, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_2_5())));
                    this.setDouble(16, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_2_1())));
                    this.setDouble(17, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_8_5())));
                    this.setDouble(21, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_6())));
                    this.setDouble(22, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_12())));
                    this.setDouble(23, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_21())));
                    this.setDouble(24, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_8_1())));
                    this.setDouble(25, -1.0 * Math.abs(NumericUtils.round(mGrandGrandTotalTicket.getTva_2_6())));
                } else {
                    this.setDouble(4, NumericUtils.round(mGrandGrandTotalTicket.getCumul()));
                    this.setDouble(5, NumericUtils.round(mGrandGrandTotalTicket.getCumulPerpetual()));
                    this.setDouble(12, NumericUtils.round(mGrandGrandTotalTicket.getCumulPerpetualReel()));
                    this.setDouble(7, NumericUtils.round(mGrandGrandTotalTicket.getTva5()));
                    this.setDouble(8, NumericUtils.round(mGrandGrandTotalTicket.getTva10()));
                    this.setDouble(9, NumericUtils.round(mGrandGrandTotalTicket.getTva20()));
                    this.setDouble(13, NumericUtils.round(mGrandGrandTotalTicket.getTva0()));
                    this.setDouble(14, NumericUtils.round(mGrandGrandTotalTicket.getTva_7_7()));
                    this.setDouble(15, NumericUtils.round(mGrandGrandTotalTicket.getTva_2_5()));
                    this.setDouble(16, NumericUtils.round(mGrandGrandTotalTicket.getTva_2_1()));
                    this.setDouble(17, NumericUtils.round(mGrandGrandTotalTicket.getTva_8_5()));
                    this.setDouble(21, NumericUtils.round(mGrandGrandTotalTicket.getTva_6()));
                    this.setDouble(22, NumericUtils.round(mGrandGrandTotalTicket.getTva_12()));
                    this.setDouble(23, NumericUtils.round(mGrandGrandTotalTicket.getTva_21()));
                    this.setDouble(24, NumericUtils.round(mGrandGrandTotalTicket.getTva_8_1()));
                    this.setDouble(25, NumericUtils.round(mGrandGrandTotalTicket.getTva_2_6()));
                }
                this.setString(10, mGrandGrandTotalTicket.getSignature());
                this.setString(11, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(date));
                this.setInt(18, idEntete);
                this.setBoolean(19, true);
                this.setBoolean(20, true);
            }
        });
        if (this.detecter != null) {
            this.detecter.pushToRegistre("gttckt", mGrandGrandTotalTicket.getSignature());
        }
        this.checkCumulPerpetualReset(ticket.getUser().getId(), true);
    }

    private void addGrandTotalTicket(TicketInfo ticket, StringBuilder ticketEmprinte, int idEntete) throws BasicException {
        GrandTotalTicket grandTotalTicket = this.getLastGrandTotalTicket();
        GrandTotalTicket mGrandGrandTotalTicket = this.mDataLogicSalesHelper.createGrandTotal(grandTotalTicket, ticket, idEntete, ticketEmprinte, this.totalTVA5, this.totalTVA10, this.totalTVA20, this.totalTVA0, this.totalTVA_7_7, this.totalTVA_2_5, this.totalTVA_2_1, this.totalTVA_8_5, this.totalTVA_6, this.totalTVA_12, this.totalTVA_21, this.totalTVA_8_1, this.totalTVA_2_6);
        this.addGrandTotalTicket(ticket, ticket.getLastUpdate(), this.idDocument, idEntete, mGrandGrandTotalTicket);
    }

    private void addRECEIPTS(final TicketInfo ticket) throws BasicException {
        TicketInfo tmp = this.getTicketById(ticket.getId());
        if (tmp != null) {
            ticket.setId();
        }
        new PreparedSentence(this.s, "INSERT INTO RECEIPTS (ID, MONEY, DATENEW, ATTRIBUTES, PERSON) VALUES (?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticket.getId());
                this.setString(2, ticket.getActiveCash());
                this.setTimestamp(3, new Date());
                try {
                    ByteArrayOutputStream o = new ByteArrayOutputStream();
                    ticket.getProperties().storeToXML((OutputStream)o, "Procaisse", "UTF-8");
                    this.setBytes(4, o.toByteArray());
                }
                catch (IOException e) {
                    this.setBytes(4, null);
                }
                this.setString(5, ticket.getUser().getId());
            }
        });
    }

    private void addTICKET_PAYMENT(TicketInfo ticket, PaymentInfo paymentInfo, int idEntete, String code_caisse) throws BasicException {
        this.addTICKET_PAYMENT(ticket, paymentInfo, this.idDocument, idEntete, code_caisse);
    }

    public void addTICKET_PAYMENT(final TicketInfo ticket, final PaymentInfo paymentInfo, final int idDocument, final int idEntete, final String code_caisse) throws BasicException {
        this.type_regulation = "";
        switch (paymentInfo.getName()) {
            case "cash": {
                this.type_regulation = "ESPECE";
                break;
            }
            case "Ticket Resto": {
                this.type_regulation = "TICKET RESTAURANT";
                break;
            }
            case "Avoir": {
                this.type_regulation = "AVOIR";
                break;
            }
            case "cheque": {
                this.type_regulation = "CHEQUE";
                break;
            }
            case "CB": {
                this.type_regulation = "CARTE BANCAIRE";
                break;
            }
            case "cashdro": {
                this.type_regulation = "ESPECE";
                break;
            }
            default: {
                this.type_regulation = paymentInfo.getName();
            }
        }
        new PreparedSentence(this.s, "INSERT INTO TICKET_PAYMENT ( num_doc, type_regulation, total, code_user, timestampGDH, centre_profit, ticket, type_operation,horodatage, code_operator, code_caisse, REF_ORIGINE) VALUES(?, ?,?,?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, String.valueOf(idDocument));
                this.setString(2, DataLogicSales.this.type_regulation);
                this.setString(4, ticket.getUser().getId());
                this.setTimestamp(5, ticket.getLastUpdate());
                this.setString(6, "N/A");
                this.setString(7, ticket.getId());
                if (ticket.getTicketType() == 1) {
                    this.setDouble(3, NumericUtils.round(paymentInfo.getTotal(), 2));
                    this.setString(8, "Remboursement");
                } else {
                    this.setDouble(3, NumericUtils.round(paymentInfo.getTotal(), 2));
                    this.setString(8, "Encaissement");
                }
                this.setString(9, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getLastUpdate()));
                this.setString(10, ticket.getUser().getId());
                this.setString(11, code_caisse);
                this.setInt(12, idEntete);
            }
        });
    }

    private void addPayment(final TicketInfo ticket, final PaymentInfo paymentInfo) throws BasicException {
        paymentInfo.setM_dTendered(NumericUtils.round(paymentInfo.getPaid()));
        paymentInfo.setId(UUID.randomUUID().toString());
        new PreparedSentence(this.s, "INSERT INTO PAYMENTS (ID, RECEIPT, PAYMENT, TOTAL, TRANSID, RETURNMSG, TENDERED, CARDNAME, avoir_origin, ID_PAYMENT_EXTERNE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, paymentInfo.getId());
                this.setString(2, ticket.getId());
                this.setString(3, paymentInfo.getName());
                this.setDouble(4, NumericUtils.round(paymentInfo.getTotal()));
                this.setString(5, ticket.getTransactionID());
                this.setBytes(6, (byte[])Formats.BYTEA.parseValue(ticket.getReturnMessage()));
                this.setDouble(7, NumericUtils.round(paymentInfo.getPaid()));
                this.setString(8, paymentInfo.getCardName());
                this.setString(9, paymentInfo.getOrigin());
                this.setString(10, paymentInfo.getIdPaymentExterne());
            }
        });
        if (paymentInfo.getName().equals("Debit")) {
            this.mDebitCustomerService.addFromTicketAndPayment(paymentInfo, ticket);
        }
        if (paymentInfo.getName().equals("Cr\u00e9dit Employ\u00e9")) {
            this.dlEmployees.addTransactionEmployee(paymentInfo, ticket);
        }
        if (paymentInfo.getName().equals("Carte Fid\u00e9lit\u00e9")) {
            this.mLoyaltyCardService.decreaseCredit(paymentInfo.getPaid(), paymentInfo.getIdLoyaltyCard());
        }
    }

    private int getTicketId(TicketInfo ticket) throws BasicException {
        int ticketID = -1;
        if (ticket.getTicketId() == 0) {
            switch (ticket.getTicketType()) {
                case 0: {
                    ticketID = this.getNextTicketIndex();
                    break;
                }
                case 1: {
                    ticketID = this.getNextTicketRefundIndex();
                    break;
                }
                case 2: {
                    ticketID = this.getNextTicketPaymentIndex();
                    break;
                }
                case 3: {
                    ticketID = this.getNextTicketPaymentIndex();
                    break;
                }
                default: {
                    throw new BasicException();
                }
            }
        }
        return ticketID;
    }

    public final SupplementItemInfo addIngredient(SupplementItemInfo ingredient) throws SQLException, BasicException {
        String SQL = "INSERT INTO SUPPLEMENT_ITEM (name, id_supplement, order_item, ALIAS_KITCHEN, path, HIDDEN, COOKABLE, SOLD_OUT) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, ingredient.getName());
        this.pstmt.setInt(2, ingredient.getId_supplement());
        this.pstmt.setInt(3, ingredient.getOrderItem());
        this.pstmt.setString(4, ingredient.getAlias_kitchen());
        this.pstmt.setString(5, ingredient.getPath());
        this.pstmt.setBoolean(6, ingredient.isHidden());
        this.pstmt.setBoolean(7, ingredient.isCookable());
        this.pstmt.setBoolean(8, ingredient.isSold_out());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idIngredient = -1;
        if (rs.next()) {
            idIngredient = rs.getInt(1);
        }
        ingredient.setiD(idIngredient);
        this.setIdGlobalItem(idIngredient, "SUPPLEMENT_ITEM", "ITEM_PLU", ingredient.getId_global());
        return ingredient;
    }

    public final SupplementInfo addGroupeIngredient(SupplementInfo groupeIngredient) throws SQLException, BasicException {
        String SQL = "INSERT INTO SUPPLEMENT(name, is_ingredient, order_supplement) VALUES (?,?,?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, groupeIngredient.getName());
        this.pstmt.setBoolean(2, true);
        this.pstmt.setInt(3, groupeIngredient.getOrderSupplement());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idGIngredient = -1;
        if (rs.next()) {
            idGIngredient = rs.getInt(1);
        }
        groupeIngredient.setiD(idGIngredient);
        this.setIdGlobalItem(idGIngredient, "SUPPLEMENT", "ID_GLOBAL", groupeIngredient.getId_global());
        return groupeIngredient;
    }

    public final void updateGroupeIngredient(final String name, final int ID) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT SET name = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, name);
                this.setInt(2, ID);
            }
        });
    }

    public final void updateIngredient(final SupplementItemInfo ingredient) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT_ITEM SET name = ?, ALIAS_KITCHEN = ?, path = ?, HIDDEN = ?, COOKABLE = ?, SOLD_OUT = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ingredient.getName());
                this.setString(2, ingredient.getAlias_kitchen());
                this.setString(3, ingredient.getPath());
                this.setBoolean(4, ingredient.isHidden());
                this.setBoolean(5, ingredient.isCookable());
                this.setBoolean(6, ingredient.isSold_out());
                this.setInt(7, ingredient.getiD());
            }
        });
    }

    public final void deleteIngredient(final int ID) throws BasicException {
        String request_removed = AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "DELETE FROM ITEM_INGREDIENTS WHERE id_supplement_item = ?", SerializerWriteInteger.INSTANCE).exec((Object)ID);
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT_ITEM SET " + request_removed + " WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, ID);
            }
        });
    }

    public final void deleteGroupeIngredient(final int ID) throws BasicException {
        String request_removed = AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "DELETE FROM ITEM_SUPPLEMENTS WHERE id_supplement = ?", SerializerWriteInteger.INSTANCE).exec((Object)ID);
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT SET " + request_removed + " WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, ID);
            }
        });
    }

    public final void addSupplement(final String name, final int groupeIngredient) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SUPPLEMENT_ITEM (name, id_supplement) VALUES (?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, name);
                this.setInt(2, groupeIngredient);
            }
        });
    }

    public SupplementItemInfo addOption(final SupplementItemInfo option, boolean synchronisation) throws BasicException, SQLException {
        String SQL = "INSERT INTO SUPPLEMENT_ITEM (name, price, price_junior, price_senior, price_mega, id_supplement, order_item, many_size, path, price_size1, price_size2, price_size3, REF_WEB, removed, HIDDEN_BORNE, color, ALIAS_KITCHEN, SEND_COLOR, FLAME_ENABLED, NUMBER_FLAME, MANY_TYPE, HIDDEN_UBEREAT, HIDDEN_ONLINE, PRICE_SIZE4, PRICE_SIZE5, PRICE_SIZE6, PRICE_SIZE7, SUPPLEMENT_ITEM_UBEREAT, SOLD_OUT, HIDDEN_IN_KITCHEN, COOKABLE, TAX_ID, PRICE_ALREADY_INCLUDED, ITEM_PLU, DATE_START_DISPLAY , DATE_END_DISPLAY, IMAGE_URL) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, option.getName());
        this.pstmt.setDouble(2, option.getPrice());
        this.pstmt.setDouble(3, option.getPrice_junior());
        this.pstmt.setDouble(4, option.getPrice_senior());
        this.pstmt.setDouble(5, option.getPrice_mega());
        this.pstmt.setInt(6, option.getId_supplement());
        this.pstmt.setInt(7, option.getOrderItem());
        this.pstmt.setBoolean(8, option.isMany_size());
        this.pstmt.setString(9, option.getPath());
        this.pstmt.setDouble(10, option.getPrice_size1());
        this.pstmt.setDouble(11, option.getPrice_size2());
        this.pstmt.setDouble(12, option.getPrice_size3());
        this.pstmt.setString(13, option.getRef_web());
        this.pstmt.setBoolean(14, option.isRemoved());
        this.pstmt.setBoolean(15, option.isHidden_borne());
        this.pstmt.setString(16, option.getColor());
        this.pstmt.setString(17, option.getAlias_kitchen());
        this.pstmt.setBoolean(18, option.isSend_color());
        this.pstmt.setBoolean(19, option.isFlame_enabled());
        this.pstmt.setInt(20, option.getNumber_flame());
        this.pstmt.setBoolean(21, option.isMany_type());
        this.pstmt.setBoolean(22, option.isHidden_ubereat());
        this.pstmt.setBoolean(23, option.isHidden_online());
        this.pstmt.setDouble(24, option.getPrice_size4());
        this.pstmt.setDouble(25, option.getPrice_size5());
        this.pstmt.setDouble(26, option.getPrice_size6());
        this.pstmt.setDouble(27, option.getPrice_size7());
        this.pstmt.setBoolean(28, option.isSupplement_item_ubereat());
        this.pstmt.setBoolean(29, option.isSold_out());
        this.pstmt.setBoolean(30, option.isHidden_in_kitchen());
        this.pstmt.setBoolean(31, option.isCookable());
        this.pstmt.setString(32, option.getTaxId());
        this.pstmt.setDouble(33, option.getPrice_already_included());
        this.pstmt.setString(34, option.getId_global());
        Date startDisplay = option.getDateStartDisplay();
        Date endDisplay = option.getDateEndDisplay();
        if (startDisplay != null) {
            this.pstmt.setTimestamp(35, new Timestamp(startDisplay.getTime()));
        } else {
            this.pstmt.setTimestamp(35, null);
        }
        if (endDisplay != null) {
            this.pstmt.setTimestamp(36, new Timestamp(endDisplay.getTime()));
        } else {
            this.pstmt.setTimestamp(36, null);
        }
        this.pstmt.setString(37, option.getImageUrl());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idResult = -1;
        if (rs.next()) {
            int last_inserted_id;
            idResult = last_inserted_id = rs.getInt(1);
        }
        option.setiD(idResult);
        this.setIdGlobalItem(option.getiD(), "SUPPLEMENT_ITEM", "ITEM_PLU", option.getId_global());
        if (!synchronisation && option.getId_product() != 0) {
            new PreparedSentence(this.s, "UPDATE SUPPLEMENT_ITEM SET ID_PRODUCT = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, option.getId_product());
                    this.setInt(2, option.getiD());
                }
            });
        }
        return option;
    }

    public SupplementInfo addGroupeOption(final SupplementInfo groupeOption, boolean add_printer) throws BasicException, SQLException {
        String SQL = "INSERT INTO SUPPLEMENT(name, is_ingredient, order_supplement, is_bold, color, number_click, path, order_name, multiple_category, display_free, prepared, shift_option, display_screen_sorti, HIDDEN_BORNE, NO_PRINTABLE, HIDDEN_UBEREAT, has_options, min_options, max_options, HIDDEN_ONLINE, SUPPLEMENT_UBEREAT, PRINT_BLACK_BACKGROUND, ID_GLOBAL, DATE_START_DISPLAY ,DATE_END_DISPLAY) VALUES (?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, groupeOption.getName());
        this.pstmt.setBoolean(2, groupeOption.getIs_ingredient());
        this.pstmt.setInt(3, groupeOption.getOrderSupplement());
        this.pstmt.setBoolean(4, groupeOption.getIsBold());
        this.pstmt.setString(5, groupeOption.getColor());
        this.pstmt.setInt(6, groupeOption.getNumber_click());
        this.pstmt.setString(7, groupeOption.getPath());
        this.pstmt.setBoolean(8, groupeOption.isOrder_name());
        this.pstmt.setBoolean(9, groupeOption.isMultiple_category());
        this.pstmt.setBoolean(10, groupeOption.isDisplay_free());
        this.pstmt.setBoolean(11, groupeOption.isPrepared());
        this.pstmt.setInt(12, groupeOption.getShift_option());
        this.pstmt.setBoolean(13, groupeOption.isDisplay_screen_sorti());
        this.pstmt.setBoolean(14, groupeOption.isHidden_borne());
        this.pstmt.setBoolean(15, groupeOption.isNo_printable());
        this.pstmt.setBoolean(16, groupeOption.isHidden_ubereat());
        this.pstmt.setBoolean(17, groupeOption.getHas_options());
        this.pstmt.setInt(18, groupeOption.getMin_options());
        this.pstmt.setInt(19, groupeOption.getMax_options());
        this.pstmt.setBoolean(20, groupeOption.isHidden_online());
        this.pstmt.setBoolean(21, groupeOption.isSupplement_ubereat());
        this.pstmt.setBoolean(22, groupeOption.isPrint_black_background());
        this.pstmt.setString(23, groupeOption.getId_global());
        Date startDisplay = groupeOption.getDateStartDisplay();
        Date endDisplay = groupeOption.getDateEndDisplay();
        if (startDisplay != null) {
            this.pstmt.setTimestamp(24, new Timestamp(startDisplay.getTime()));
        } else {
            this.pstmt.setTimestamp(24, null);
        }
        if (endDisplay != null) {
            this.pstmt.setTimestamp(25, new Timestamp(endDisplay.getTime()));
        } else {
            this.pstmt.setTimestamp(25, null);
        }
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idGIngredient = -1;
        if (rs.next()) {
            idGIngredient = rs.getInt(1);
        }
        groupeOption.setiD(idGIngredient);
        this.setIdGlobalItem(groupeOption.getiD(), "SUPPLEMENT", "ID_GLOBAL", groupeOption.getId_global());
        if (add_printer && groupeOption.getPrinter() != -1) {
            new PreparedSentence(this.s, "UPDATE SUPPLEMENT SET printer = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, groupeOption.getPrinter());
                    this.setInt(2, groupeOption.getiD());
                }
            });
        }
        return groupeOption;
    }

    public void updateOption(final SupplementItemInfo option, boolean synchronization) throws BasicException, SQLException {
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT_ITEM SET name = ?, price = ?, price_junior = ?, price_senior = ?, price_mega = ?, id_supplement = ?, many_size = ?, path = ?, price_size1 = ?, price_size2 = ?, price_size3 = ?, HIDDEN_BORNE = ?, color = ?, ALIAS_KITCHEN = ?, SEND_COLOR = ?, FLAME_ENABLED = ?, NUMBER_FLAME = ?, MANY_TYPE = ?, HIDDEN_UBEREAT = ?, HIDDEN_ONLINE = ?, PRICE_SIZE4 = ?, PRICE_SIZE5 = ?, PRICE_SIZE6 = ?, PRICE_SIZE7 = ?, SUPPLEMENT_ITEM_UBEREAT = ?, SOLD_OUT = ?, HIDDEN_IN_KITCHEN = ?, COOKABLE = ?, TAX_ID = ?, PRICE_ALREADY_INCLUDED = ?, DATE_START_DISPLAY = ? ,DATE_END_DISPLAY = ?, IMAGE_URL = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, option.getName());
                this.setDouble(2, option.getPrice());
                this.setDouble(3, option.getPrice_junior());
                this.setDouble(4, option.getPrice_senior());
                this.setDouble(5, option.getPrice_mega());
                this.setInt(6, option.getId_supplement());
                this.setBoolean(7, option.isMany_size());
                this.setString(8, option.getPath());
                this.setDouble(9, option.getPrice_size1());
                this.setDouble(10, option.getPrice_size2());
                this.setDouble(11, option.getPrice_size3());
                this.setBoolean(12, option.isHidden_borne());
                this.setString(13, option.getColor());
                this.setString(14, option.getAlias_kitchen());
                this.setBoolean(15, option.isSend_color());
                this.setBoolean(16, option.isFlame_enabled());
                this.setInt(17, option.getNumber_flame());
                this.setBoolean(18, option.isMany_type());
                this.setBoolean(19, option.isHidden_ubereat());
                this.setBoolean(20, option.isHidden_online());
                this.setDouble(21, option.getPrice_size4());
                this.setDouble(22, option.getPrice_size5());
                this.setDouble(23, option.getPrice_size6());
                this.setDouble(24, option.getPrice_size7());
                this.setBoolean(25, option.isSupplement_item_ubereat());
                this.setBoolean(26, option.isSold_out());
                this.setBoolean(27, option.isHidden_in_kitchen());
                this.setBoolean(28, option.isCookable());
                this.setString(29, option.getTaxId());
                this.setDouble(30, option.getPrice_already_included());
                this.setTimestamp(31, option.getDateStartDisplay());
                this.setTimestamp(32, option.getDateEndDisplay());
                this.setString(33, option.getImageUrl());
                this.setInt(34, option.getiD());
            }
        });
        if (!synchronization) {
            this.updateProductSupplement(option);
        }
    }

    public void updateProductSupplement(final SupplementItemInfo option) throws BasicException {
        if (option.getId_product() != 0) {
            new PreparedSentence(this.s, "UPDATE SUPPLEMENT_ITEM SET ID_PRODUCT = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, option.getId_product());
                    this.setInt(2, option.getiD());
                }
            });
        } else {
            new PreparedSentence(this.s, "UPDATE SUPPLEMENT_ITEM SET ID_PRODUCT = null WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, option.getiD());
                }
            });
        }
    }

    public final void updateGroupeOption(final SupplementInfo groupeOption, boolean add_printer) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT SET name = ?, is_bold= ?, color = ?, number_click = ?, path = ?, order_name = ?, multiple_category = ?, display_free = ?, prepared = ?, shift_option = ?, display_screen_sorti = ?, HIDDEN_BORNE = ?, NO_PRINTABLE = ?, HIDDEN_UBEREAT = ?, has_options = ?, min_options = ?, max_options = ?, HIDDEN_ONLINE = ?, SUPPLEMENT_UBEREAT = ?, PRINT_BLACK_BACKGROUND = ? , DATE_START_DISPLAY = ? , DATE_END_DISPLAY = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, groupeOption.getName());
                this.setBoolean(2, groupeOption.getIsBold());
                this.setString(3, groupeOption.getColor());
                this.setInt(4, groupeOption.getNumber_click());
                this.setString(5, groupeOption.getPath());
                this.setBoolean(6, groupeOption.isOrder_name());
                this.setBoolean(7, groupeOption.isMultiple_category());
                this.setBoolean(8, groupeOption.isDisplay_free());
                this.setBoolean(9, groupeOption.isPrepared());
                this.setInt(10, groupeOption.getShift_option());
                this.setBoolean(11, groupeOption.isDisplay_screen_sorti());
                this.setBoolean(12, groupeOption.isHidden_borne());
                this.setBoolean(13, groupeOption.isNo_printable());
                this.setBoolean(14, groupeOption.isHidden_ubereat());
                this.setBoolean(15, groupeOption.getHas_options());
                this.setInt(16, groupeOption.getMin_options());
                this.setInt(17, groupeOption.getMax_options());
                this.setBoolean(18, groupeOption.isHidden_online());
                this.setBoolean(19, groupeOption.isSupplement_ubereat());
                this.setBoolean(20, groupeOption.isPrint_black_background());
                this.setTimestamp(21, groupeOption.getDateStartDisplay());
                this.setTimestamp(22, groupeOption.getDateEndDisplay());
                this.setInt(23, groupeOption.getiD());
            }
        });
        if (add_printer) {
            if (groupeOption.getPrinter() != -1) {
                new PreparedSentence(this.s, "UPDATE SUPPLEMENT SET printer = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, groupeOption.getPrinter());
                        this.setInt(2, groupeOption.getiD());
                    }
                });
            } else {
                new PreparedSentence(this.s, "UPDATE SUPPLEMENT SET printer = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, null);
                        this.setInt(2, groupeOption.getiD());
                    }
                });
            }
        }
    }

    public final void deleteOption(final int ID) throws BasicException {
        String request_removed = AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "DELETE FROM ITEM_INGREDIENTS WHERE id_supplement_item = ?", SerializerWriteInteger.INSTANCE).exec((Object)ID);
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT_ITEM SET " + request_removed + " WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, ID);
            }
        });
    }

    public final void deleteGroupeOption(final int ID) throws BasicException {
        String request_removed = AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "DELETE FROM ITEM_SUPPLEMENTS WHERE id_supplement = ?", SerializerWriteInteger.INSTANCE).exec((Object)ID);
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT SET " + request_removed + " WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, ID);
            }
        });
    }

    public List<CarteInfo> getCartes() throws BasicException {
        return new PreparedSentence(this.s, this.requestCarte + "WHERE removed = 0 AND REMOVED_BY_ADMIN = 0 ORDER BY  name ", null, CarteInfo.getSerializerRead()).list();
    }

    public List<CarteInfo> getCartesWithoutConstraints() throws BasicException {
        return new PreparedSentence(this.s, this.requestCarte + "FROM CARTE WHERE removed = 0 AND REMOVED_BY_ADMIN = 0 ORDER BY  name ", null, CarteInfo.getSerializerRead()).list();
    }

    public final void addCarte(String name, String sizeCarte, List<ProductInfoExt> products, String id_global) throws BasicException {
        try {
            String SQL = "INSERT INTO CARTE (name, sizeCarte) VALUES (?,?)";
            this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
            this.pstmt.setString(1, name);
            this.pstmt.setString(2, sizeCarte);
            this.pstmt.executeUpdate();
            ResultSet rs = this.pstmt.getGeneratedKeys();
            if (rs.next()) {
                int last_inserted_id;
                this.idCarte = last_inserted_id = rs.getInt(1);
            }
            PreparedSentence carteItemInsert = new PreparedSentence(this.s, "INSERT INTO CARTE_ITEM (id_carte, id_item, price, order_item) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
            for (final ProductInfoExt item : products) {
                carteItemInsert.exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, DataLogicSales.this.idCarte);
                        this.setInt(2, item.getID());
                        this.setDouble(3, NumericUtils.round(item.getPriceSell()));
                        this.setInt(4, item.getOrder_item());
                    }
                });
            }
            this.setIdGlobalItem(this.idCarte, "CARTE", "ID_GLOBAL", id_global);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public final void addMenu(final String code, final String name, final double price, final int category, final String tax) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PRODUCTS (CODE, NAME, PRICESELL, CATEGORY, TAXCAT, menu) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, code);
                this.setString(2, name);
                this.setDouble(3, NumericUtils.round(price));
                this.setInt(4, category);
                this.setString(5, tax);
                this.setBoolean(6, true);
            }
        });
    }

    public final List<TaxInfo> getAllTax() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, RATE, ENABLED, TAXE_GLOBAL FROM TAXCATEGORIES where REMOVED = 0 ORDER BY RATE ", null, TaxInfo.getSerializerRead()).list();
    }

    public final List<TaxInfo> getTax() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, RATE, ENABLED, TAXE_GLOBAL FROM TAXCATEGORIES where REMOVED = 0 and TAXE_GLOBAL = 0 ORDER BY RATE ", null, TaxInfo.getSerializerRead()).list();
    }

    public TaxInfo getTaxById(String taxID) throws BasicException {
        return (TaxInfo)new PreparedSentence(this.s, "SELECT ID, NAME, RATE, ENABLED, TAXE_GLOBAL FROM TAXCATEGORIES WHERE ID = ?", SerializerWriteString.INSTANCE, TaxInfo.getSerializerRead()).find((Object)taxID);
    }

    public TaxInfo getTaxByRate(final double taxID) throws BasicException {
        return (TaxInfo)new PreparedSentence(this.s, "SELECT ID, NAME, RATE, ENABLED, TAXE_GLOBAL FROM TAXCATEGORIES WHERE RATE = ?", SerializerWriteParams.INSTANCE, TaxInfo.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, taxID);
            }
        });
    }

    public void addTax(final TaxInfo tax) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO TAXCATEGORIES (ID, NAME, RATE) VALUES(?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, tax.getId());
                this.setString(2, tax.getName());
                this.setDouble(3, tax.getRate());
            }
        });
    }

    public List<ProductInfoExt> getProductsByPlat(int plat, boolean catalog) throws BasicException {
        String request_uber = catalog ? " AND P.PRODUCT_UBEREAT = 0 " : "";
        List products = new PreparedSentence(this.s, this.requestProductPlat + "WHERE P.REMOVED_BY_ADMIN = 0  AND C.id_carte = ? AND P.hidden = 0 AND P.removed = 0 AND P.menu = 0 AND P.SOLD_OUT = 0 " + request_uber + this.request_campaign_product + " order by C.order_item ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)plat);
        for (ProductInfoExt product : products) {
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
        }
        return products;
    }

    public final void updateMenu(final ProductInfoExt menu) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  PRODUCTS SET CODE = ?, NAME = ?, PRICESELL = ?, CATEGORY = ?, TAXCAT = ?   WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, menu.getCode());
                this.setString(2, menu.getName());
                this.setDouble(3, NumericUtils.round(menu.getPriceSell()));
                this.setInt(4, menu.getCategoryid());
                this.setString(5, menu.getTaxcategoryid());
                this.setInt(6, menu.getID());
            }
        });
    }

    public List<CarteItemInfo> getCarteItems(int plat, boolean check_if_removed) throws BasicException {
        String requestRemoved = check_if_removed ? " AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.PRODUCT_UBEREAT = 0 " : "";
        return new PreparedSentence(this.s, "SELECT C.id_carte, C.id_item, C.price, P.PRODUCT_PLU, C.order_item FROM CARTE_ITEM C JOIN PRODUCTS P ON C.id_item = P.ID  WHERE  P.menu = 0 AND C.id_carte = ? " + requestRemoved, SerializerWriteInteger.INSTANCE, CarteItemInfo.getSerializerRead()).list((Object)plat);
    }

    public final void updatePlat(final CarteInfo carte, List<ProductInfoExt> products) throws BasicException {
        int found;
        new PreparedSentence(this.s, "UPDATE  CARTE SET  name = ?, sizeCarte = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, carte.getName());
                this.setString(2, carte.getSizeCarte());
                this.setInt(3, carte.getId());
            }
        });
        List<CarteItemInfo> carteItems = this.getCarteItems(carte.getId(), false);
        PreparedSentence carteIteminsert = new PreparedSentence(this.s, "INSERT INTO CARTE_ITEM (id_carte, id_item, price, order_item) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
        PreparedSentence carteItemupdate = new PreparedSentence(this.s, "UPDATE CARTE_ITEM SET price = ?, order_item = ? WHERE id_carte = ? AND id_item = ? ", SerializerWriteParams.INSTANCE);
        PreparedSentence carteItemdelete = new PreparedSentence(this.s, "DELETE FROM CARTE_ITEM WHERE id_carte = ? AND id_item = ? ", SerializerWriteParams.INSTANCE);
        for (final CarteItemInfo carteItem : carteItems) {
            found = -1;
            for (ProductInfoExt item : products) {
                if (item.getID() != carteItem.getId_item()) continue;
                found = 1;
            }
            if (found != -1) continue;
            carteItemdelete.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, carteItem.getId_carte());
                    this.setInt(2, carteItem.getId_item());
                }
            });
        }
        for (final ProductInfoExt item : products) {
            found = -1;
            for (CarteItemInfo carteItem : carteItems) {
                if (item.getID() != carteItem.getId_item()) continue;
                found = 1;
            }
            if (found == -1) {
                carteIteminsert.exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, carte.getId());
                        this.setInt(2, item.getID());
                        this.setDouble(3, NumericUtils.round(item.getPriceSell()));
                        this.setInt(4, item.getOrder_item());
                    }
                });
                continue;
            }
            carteItemupdate.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setDouble(1, NumericUtils.round(item.getPriceSell()));
                    this.setInt(2, item.getOrder_item());
                    this.setInt(3, carte.getId());
                    this.setInt(4, item.getID());
                }
            });
        }
    }

    public final void deleteCarte(final int ID, boolean removed_definitely) throws BasicException {
        String request_removed = removed_definitely || AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "DELETE FROM CARTE_ITEM WHERE id_carte = ?", SerializerWriteInteger.INSTANCE).exec((Object)ID);
        new PreparedSentence(this.s, "UPDATE  CARTE SET " + request_removed + " WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, ID);
            }
        });
    }

    public final void deleteMenu(final int ID) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  PRODUCTS SET removed = 1 WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, ID);
            }
        });
    }

    public List<ItemIngredientInfo> getItemsIngredients(int productID) throws BasicException {
        return new PreparedSentence(this.s, "SELECT id_supplement_item, id_item, quantity FROM ITEM_INGREDIENTS  WHERE id_item = ?", SerializerWriteInteger.INSTANCE, ItemIngredientInfo.getSerializerRead()).list((Object)productID);
    }

    public void addItemSupplements(List<SupplementProduct> options, int id_product) throws BasicException {
        for (SupplementProduct option : options) {
            this.addItemSupplement(option, id_product);
        }
    }

    public void addItemIngredient(List<SupplementItemInfo> ingredients, final Map<Integer, Integer> ingredientsQuantities) throws BasicException {
        PreparedSentence itemIngredientinsert = new PreparedSentence(this.s, "INSERT INTO ITEM_INGREDIENTS (id_supplement_item, id_item, quantity) VALUES (?, ?, ?)", SerializerWriteParams.INSTANCE);
        for (final SupplementItemInfo ingredient : ingredients) {
            itemIngredientinsert.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, ingredient.getiD());
                    this.setInt(2, DataLogicSales.this.id_Product);
                    this.setInt(3, ingredientsQuantities.getOrDefault(ingredient.getiD(), 1));
                }
            });
        }
    }

    public void addCarteMenu(List<CarteOrderInfo> cartes, int id_item) throws BasicException {
        for (CarteOrderInfo carte : cartes) {
            this.addCarteMenu(carte, id_item);
        }
    }

    public void addCarteMenu(final CarteOrderInfo carte, final int id_item) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO CARTE_MENU (id_carte, id_item, carteOrder, number_carte) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, carte.getId());
                this.setInt(2, id_item);
                this.setInt(3, carte.getOrderCarte());
                this.setInt(4, carte.getNumber_carte());
            }
        });
    }

    public List<SupplementItemInfo> getIngredientsByProducts(int productID, boolean show_hiddens, boolean show_sold_out) throws BasicException {
        String request_hidden = !show_hiddens ? "AND S.HIDDEN = 0 " : "";
        String request_sold_out = !show_sold_out ? "AND SOLD_OUT = 0 " : "";
        return new PreparedSentence(this.s, this.requestSuppItem + ", ITEM_INGREDIENTS I WHERE S.id = I.id_supplement_item  AND I.id_item = ? AND S.REMOVED_BY_ADMIN = 0 AND S.removed = 0 " + request_hidden + request_sold_out + this.request_campaign_supplement_item + "ORDER BY  S.order_item ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).list((Object)productID);
    }

    public List<SupplementItemInfo> getIngredientsByProductsPop(int productID) throws BasicException {
        List ingredients = new PreparedSentence(this.s, this.requestSuppItem + ", ITEM_INGREDIENTS I WHERE S.id = I.id_supplement_item  AND I.id_item = ? AND S.REMOVED_BY_ADMIN = 0 AND S.removed = 0 AND S.HIDDEN = 0 AND SOLD_OUT = 0 " + this.request_campaign_supplement_item + "ORDER BY  S.name ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).list((Object)productID);
        for (SupplementItemInfo ingredient : ingredients) {
            ingredient.setMultiLanguageTexts(this.multiLanguageSupplementItemService.getMultiLanguageTexts(ingredient.getiD()));
            ingredient.setAllergenes(this.mAllergeneSupplementService.getAllergenesForSupplement(ingredient.getiD()));
        }
        return ingredients;
    }

    public void deployCategory(final CategoryInfo category) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  CATEGORIES SET TAXEMP = ?, TAXLV = ?, TAXSP = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, category.getTaxEMP());
                this.setString(2, category.getTaxLV());
                this.setString(3, category.getTaxSP());
                this.setInt(4, category.getID());
            }
        });
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET TAXCAT = ?, TAXEMP = ?, TAXLV = ? WHERE CATEGORY = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, category.getTaxSP());
                this.setString(2, category.getTaxEMP());
                this.setString(3, category.getTaxLV());
                this.setInt(4, category.getID());
            }
        });
    }

    public List<CarteOrderInfo> getCartesByItem(int idItem) throws BasicException {
        List cartes = new PreparedSentence(this.s, this.requestOrderCarte + "WHERE C.id = M.id_carte AND  C.removed = 0 AND M.id_item = ? ORDER BY  M.carteOrder ", SerializerWriteInteger.INSTANCE, CarteOrderInfo.getSerializerRead()).list((Object)idItem);
        for (CarteOrderInfo plat : cartes) {
            plat.setMultiLanguageTexts(this.multiLanguageCarteService.getMultiLanguageTexts(plat.getId()));
        }
        return cartes;
    }

    public void deleteCategory(int idCategory, boolean removed_definitely) throws BasicException {
        String request_removed = removed_definitely || AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "UPDATE CATEGORIES SET " + request_removed + " WHERE ID = ?", SerializerWriteInteger.INSTANCE).exec((Object)idCategory);
        new StaticSentence(this.s, "UPDATE PRODUCTS SET " + request_removed + " WHERE CATEGORY = ?", SerializerWriteInteger.INSTANCE).exec((Object)idCategory);
        new StaticSentence(this.s, "UPDATE CATEGORIES SET " + request_removed + " WHERE PARENTID = ?", SerializerWriteInteger.INSTANCE).exec((Object)idCategory);
    }

    public void enableCategory(int idCategory) throws BasicException {
        new StaticSentence(this.s, "UPDATE CATEGORIES SET removed = 0 WHERE ID = ?", SerializerWriteInteger.INSTANCE).exec((Object)idCategory);
        new StaticSentence(this.s, "UPDATE PRODUCTS SET removed = 0 WHERE CATEGORY = ?", SerializerWriteInteger.INSTANCE).exec((Object)idCategory);
        new StaticSentence(this.s, "UPDATE CATEGORIES SET removed = 0 WHERE PARENTID = ?", SerializerWriteInteger.INSTANCE).exec((Object)idCategory);
    }

    public void deleteProduct(int idProduct, boolean removed_definitely) throws BasicException {
        String request_removed = AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "UPDATE PRODUCTS SET " + request_removed + " WHERE ID = ?", SerializerWriteInteger.INSTANCE).exec((Object)idProduct);
    }

    public final List<SupplementInfo> getSupplementsByProductID(int productID) throws BasicException {
        return new PreparedSentence(this.s, this.requestSupplement + ", ITEM_SUPPLEMENTS I WHERE S.id = I.id_supplement AND  S.is_ingredient = 0 AND S.REMOVED_BY_ADMIN = 0 AND S.removed =0 AND I.id_item = ? " + this.request_campaign_supplement + "ORDER BY S.order_supplement", SerializerWriteInteger.INSTANCE, SupplementInfo.getSerializerRead()).list((Object)productID);
    }

    public final int countOrderEnattente() throws SQLException {
        int number = 0;
        String SQL = "SELECT COUNT(*) as number_order from TICKETS, caisse  where TICKETS.caisse= caisse.ID AND caisse.token = ? AND paid = 0 And type <> 'En Livraison' AND STATUS <> 'cancel' ";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        this.pstmt.setString(1, AppLocal.token);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("number_order");
        }
        return number;
    }

    public final int countEntete() throws SQLException {
        int number = 0;
        String SQL = "SELECT COUNT(*) as number from ENTETE";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("number");
        }
        return number;
    }

    public final int getCountTicket() throws SQLException {
        int number = 0;
        String SQL = "SELECT COUNT(*) as number from TICKETS";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("number");
        }
        return number;
    }

    public final int countOrderLivraison() throws SQLException {
        int number = 0;
        String SQL = "SELECT COUNT(*) as number_order from TICKETS, caisse  where TICKETS.caisse= caisse.ID AND caisse.token = ? AND paid = 0 AND type ='En Livraison' AND STATUS <> 'cancel' ";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        this.pstmt.setString(1, AppLocal.token);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("number_order");
        }
        return number;
    }

    public final int countOrderEnattenteUser(String user) throws SQLException {
        int number = 0;
        String SQL = "SELECT COUNT(*) as number_order from TICKETS, caisse  where TICKETS.caisse= caisse.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND paid = 0 And type <> 'En Livraison' AND STATUS <> 'cancel' ";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        this.pstmt.setString(1, AppLocal.token);
        this.pstmt.setString(2, user);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("number_order");
        }
        return number;
    }

    public final int countOrderLivraisonUser(String user) throws SQLException {
        int number = 0;
        String SQL = "SELECT COUNT(*) as number_order from TICKETS, caisse  where TICKETS.caisse= caisse.ID AND caisse.token = ? AND TICKETS.PERSON = ? AND  paid = 0 AND type ='En Livraison' AND STATUS <> 'cancel' ";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        this.pstmt.setString(1, AppLocal.token);
        this.pstmt.setString(2, user);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("number_order");
        }
        return number;
    }

    public final List<OrderInfo> getOrderAttente() throws BasicException {
        return new PreparedSentence(this.s, "SELECT id, type, total FROM ORDERS  WHERE paid =0 ORDER BY created ", null, OrderInfo.getSerializerRead()).list();
    }

    public final List<OrderDetailsInfo> getDetailsOrder(int order) throws BasicException {
        return new PreparedSentence(this.s, "SELECT O.id, P.name, O.price, O.id_order, O.quantity FROM ORDER_PRODUCT O , PRODUCTS P WHERE O.id_product = P.id AND O.id_order = ?", SerializerWriteInteger.INSTANCE, OrderDetailsInfo.getSerializerRead()).list((Object)order);
    }

    public final List<LivreurInfo> getLivreurs() throws BasicException {
        return new PreparedSentence(this.s, "SELECT  ID, NAME, APPPASSWORD FROM PEOPLE WHERE hidden = 0 AND ROLE = '3' AND removed = 0 ORDER BY NAME", null, LivreurInfo.getSerializerRead()).list();
    }

    public TicketInfo cancelOrder(TicketInfo ticket, String reason, String idUser) throws BasicException {
        return this.cancelOrder(ticket, reason, idUser, "Espece");
    }

    public TicketInfo cancelOrder(final TicketInfo ticket, final String reason, String idUser, String modeRefund) throws BasicException {
        TicketInfo last_order;
        if (this.STOCK_ENABLED) {
            this.changeStock(ticket);
        }
        int numberOrder = 0;
        try {
            numberOrder = this.getumberOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        ticket.setNumero_order(numberOrder);
        Date d = new Date();
        UserInfo user = this.getUserInfo(idUser);
        ticket.setUser(user);
        ticket.setDate(d);
        ticket.setLastUpdate(d);
        final String ancienTicket = ticket.getId();
        EnteteInfo oldEntete = this.getEnteteByTicket(ticket.getId(), true);
        int anciennumberOrder = Integer.parseInt(oldEntete.getId());
        ticket.setId();
        ticket.setDiscount(ticket.getDiscount());
        ticket.setModePayment("Remboursement");
        ticket.setStatus("Refund");
        ticket.setTicketType(1);
        ticket.setUser(user);
        try {
            ticket.setTicketId(0);
            this.saveTicket(ticket, ancienTicket, anciennumberOrder, true, false, null);
            this.incrementNumber(ticket.getNumero_order() + 1);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        new PreparedSentence(this.s, "UPDATE  TICKETS SET STATUS = 'cancel', reason_cancel = ?, detach_sync_keenio = 1 WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, reason);
                this.setString(2, ancienTicket);
            }
        });
        if (ticket.getTable() != null) {
            new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setInt(2, ticket.getTable().getId());
                }
            });
        }
        if (ticket.getCustomerId() != -1 && (last_order = this.loadTicketCustomer(ticket.getCustomerId())) != null) {
            this.mCustomerService.changeLastOrder(ticket.getCustomerId(), last_order.getDate());
        }
        try {
            String idTicketJet = oldEntete != null ? oldEntete.getId() : ancienTicket;
            Journal.writeToJET(new Event(190, "Annulation comptable de ticket", idUser, "Identifiant de ticket / raison d'annulation", new Date().getTime(), "Annulation de Ticket '" + idTicketJet + "' / " + reason.replace("\n", " . ").replace(",", "<")));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        TicketInfo ticket_canceled = this.getTicketById(ticket.getId());
        ticket_canceled.setReason_cancel(reason);
        if (ticket.getInvoice() > 0) {
            Facture f = this.getFactureById(ticket.getInvoice());
            this.cancelFacture(f, idUser, reason, ticket_canceled.getId());
        }
        return ticket_canceled;
    }

    public final List<orderPaymentInfo> getPaymentOrders(Date dateOrder) throws BasicException {
        final int year = dateOrder.getYear() + 1900;
        final int month = dateOrder.getMonth() + 1;
        final int day = dateOrder.getDate();
        return new PreparedSentence(this.s, "SELECT  SUM(P.total), P.PAYMENT FROM PAYMENTS P, TICKETS T WHERE P.RECEIPT = T.ID AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ? GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, orderPaymentInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
    }

    public final List<orderPaymentInfo> getPaymentOrdersByMonth(final int year, final int month) throws BasicException {
        return new PreparedSentence(this.s, "SELECT  SUM(P.total), P.PAYMENT FROM PAYMENTS P, TICKETS T WHERE P.RECEIPT = T.ID AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, orderPaymentInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
            }
        });
    }

    public final int getNumberOrdersByMonth(int year, int month) throws SQLException {
        int number = 0;
        String SQL = "SELECT COUNT(T.ID) as number_order from  TICKETS T where  YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? ";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        this.pstmt.setInt(1, year);
        this.pstmt.setInt(2, month);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("number_order");
        }
        return number;
    }

    public final List<PrinterInfo> getPrinters() throws BasicException {
        return new PreparedSentence(this.s, this.requestPrinter + "ORDER BY P.ID", null, PrinterInfo.getSerializerRead()).list();
    }

    public final List<PrinterInfo> getPrintersWithoutPrincipal() throws BasicException {
        return new PreparedSentence(this.s, this.requestPrinter + " where P.ID <> 1 ORDER BY P.ID", null, PrinterInfo.getSerializerRead()).list();
    }

    public final PrinterInfo getPrinterByID(int id) throws BasicException {
        return (PrinterInfo)new PreparedSentence(this.s, this.requestPrinter + "WHERE P.ID = ? ", SerializerWriteInteger.INSTANCE, PrinterInfo.getSerializerRead()).find((Object)id);
    }

    public final PrinterInfo getPrinterSummaryKitchen() throws BasicException {
        PrinterInfo printer = (PrinterInfo)new PreparedSentence(this.s, this.requestPrinter + "WHERE P.SUMMARY_KITCHEN = 1 ", null, PrinterInfo.getSerializerRead()).find();
        if (printer != null) {
            return printer;
        }
        return this.getPrinterByID(1);
    }

    public void setPrinterSummaryKitchen(int idPrinter) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  PRINTER SET SUMMARY_KITCHEN = 0  WHERE ID <> ?", SerializerWriteInteger.INSTANCE).exec((Object)idPrinter);
        new PreparedSentence(this.s, "UPDATE  PRINTER SET SUMMARY_KITCHEN = 1  WHERE ID = ?", SerializerWriteInteger.INSTANCE).exec((Object)idPrinter);
    }

    public final PrinterInfo getPrinterByType(String type) throws BasicException {
        return (PrinterInfo)new PreparedSentence(this.s, this.requestPrinter + "WHERE P.typePrinter = ? ", SerializerWriteString.INSTANCE, PrinterInfo.getSerializerRead()).find((Object)type);
    }

    public final PrinterInfo getPrinterByProduct(int id) throws BasicException {
        return (PrinterInfo)new PreparedSentence(this.s, this.requestPrinter + ", PRODUCT T WHERE P.ID = T.printer AND T.ID = ? ", SerializerWriteInteger.INSTANCE, PrinterInfo.getSerializerRead()).find((Object)id);
    }

    public final List<PrinterInfo> getPrintersKitchen() throws BasicException {
        return new PreparedSentence(this.s, this.requestPrinter + "WHERE P.typePrinter = 'kitchen' OR P.typePrinter = 'caisse' ORDER BY P.ID", null, PrinterInfo.getSerializerRead()).list();
    }

    public final List<PrinterInfo> getPrintersSummaryKitchen() throws BasicException {
        return new PreparedSentence(this.s, this.requestPrinter + "WHERE P.typePrinter <> 'label' AND P.typePrinter <> 'ecranSuivi' ORDER BY P.ID", null, PrinterInfo.getSerializerRead()).list();
    }

    public final List<PrinterInfo> getPrintersLabel() throws BasicException {
        return new PreparedSentence(this.s, this.requestPrinter + "WHERE P.typePrinter = 'label' ORDER BY P.ID", null, PrinterInfo.getSerializerRead()).list();
    }

    public final List<PrinterInfo> getDisplayKitchens() throws BasicException {
        return new PreparedSentence(this.s, this.requestPrinter + "WHERE P.typePrinter = 'ecranSuivi' ORDER BY P.ID", null, PrinterInfo.getSerializerRead()).list();
    }

    public void setPrinters(List<PrinterInfo> printers) throws BasicException {
        for (final PrinterInfo printer : printers) {
            if (printer.getId() == -1) {
                new PreparedSentence(this.s, "INSERT INTO PRINTER(NAME, NAME_PRINTER, TYPE, IP, WITH_TICKET, NUMBER_TICKET, typePrinter, PORT, band_rate, MODEL ) VALUES(?,?,?,?,?,?,?,?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setString(1, printer.getName());
                        this.setString(2, printer.getNamePrinter());
                        this.setString(3, printer.getType());
                        this.setString(4, printer.getIp());
                        this.setInt(5, printer.getWith());
                        this.setInt(6, printer.getNumber());
                        this.setString(7, printer.getTypePrinter());
                        this.setString(8, printer.getPort());
                        this.setString(9, printer.getBand_rate());
                        this.setString(10, printer.getModel());
                    }
                });
                continue;
            }
            new PreparedSentence(this.s, "UPDATE  PRINTER SET NAME = ?, NAME_PRINTER = ?, TYPE = ?, IP = ?, WITH_TICKET = ?, NUMBER_TICKET = ?, typePrinter = ?, PORT = ?, band_rate = ? , MODEL = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, printer.getName());
                    this.setString(2, printer.getNamePrinter());
                    this.setString(3, printer.getType());
                    this.setString(4, printer.getIp());
                    this.setInt(5, printer.getWith());
                    this.setInt(6, printer.getNumber());
                    this.setString(7, printer.getTypePrinter());
                    this.setString(8, printer.getPort());
                    this.setString(9, printer.getBand_rate());
                    this.setString(10, printer.getModel());
                    this.setInt(11, printer.getId());
                }
            });
        }
    }

    public void deletePrinter(final int id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET prepared = 0 WHERE printer = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
        new PreparedSentence(this.s, "DELETE FROM PRINTER WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    public final UserInfo getUserInfo(String ID) throws BasicException {
        UserInfo user = (UserInfo)new PreparedSentence(this.s, "SELECT P.ID, P.NAME,C.ID FROM PEOPLE P LEFT JOIN COUNTER_USER C ON P.ID = C.ID_USER WHERE P.ID = ? ", SerializerWriteString.INSTANCE, UserInfo.getSerializerRead()).find((Object)ID);
        return user;
    }

    public final CaisseInfo getCaisse(String token) throws BasicException {
        CaisseInfo caisse = this.mCaisseService.findByToken(token);
        if (caisse != null) {
            if (caisse.getUser_open_id() != null) {
                caisse.setUser_open(UserInfo.fetchOrStore(caisse.getUser_open_id(), this));
            } else {
                caisse.setUser_open(null);
            }
            if (caisse.getUser_close_id() != null) {
                caisse.setUser_close(UserInfo.fetchOrStore(caisse.getUser_close_id(), this));
            } else {
                caisse.setUser_close(null);
            }
        }
        return caisse;
    }

    public final CaisseInfo getCaisseById(int id) throws BasicException {
        CaisseInfo caisse = this.mCaisseService.findById(id);
        if (caisse != null) {
            if (caisse.getUser_open_id() != null) {
                caisse.setUser_open(UserInfo.fetchOrStore(caisse.getUser_open_id(), this));
            } else {
                caisse.setUser_open(null);
            }
            if (caisse.getUser_close_id() != null) {
                caisse.setUser_close(UserInfo.fetchOrStore(caisse.getUser_close_id(), this));
            } else {
                caisse.setUser_close(null);
            }
        }
        return caisse;
    }

    public void openCaisse(CaisseInfo caisse) throws BasicException {
        if (!this.mCaisseService.openCaisse(caisse)) {
            throw new BasicException();
        }
    }

    public void closeCaisse(CaisseInfo caisse, CaisseZ caisseZ, String typePeriode, List<TaxeLine> taxes, String idUser, Date dateFinPeriode) throws BasicException, SQLException {
        this.cancelOldOrders(idUser);
        CaisseInfo caisseActuel = this.getCaisse(AppLocal.token);
        if (caisseActuel.isOuverte().booleanValue() && typePeriode != null && typePeriode.equals("j")) {
            this.closeCaisseWithoutCloture(caisse, caisseZ, typePeriode, taxes, idUser);
        }
        switch (typePeriode) {
            case "j": {
                this.insertGrandTotalPeriode(typePeriode, dateFinPeriode, idUser);
                break;
            }
            case "m": {
                this.insertGrandTotalPeriode("j", dateFinPeriode, idUser);
                this.insertGrandTotalPeriode(typePeriode, dateFinPeriode, idUser);
                break;
            }
            case "a": {
                this.insertGrandTotalPeriode("j", dateFinPeriode, idUser);
                this.insertGrandTotalPeriode("m", dateFinPeriode, idUser);
                this.insertGrandTotalPeriode(typePeriode, dateFinPeriode, idUser);
            }
        }
    }

    public void closeCaisseWithoutCloture(final CaisseInfo caisse, final CaisseZ caisseZ, String typePeriode, List<TaxeLine> taxes, String idUser) throws BasicException {
        System.out.println("closeCaisseWithoutCloture****");
        if (!this.mCaisseService.closeCaisse(caisse)) {
            throw new BasicException();
        }
        CaisseZ lastCaisse = this.getLastCaisseZ();
        this.cumulCaisse = lastCaisse != null ? lastCaisse.getCumul() + caisseZ.getTtcAmount() : caisseZ.getTtcAmount();
        final ResumeTotalTax resumeTotalTax = this.getDlStats().getResumeBetween(caisseZ.getDateOpen(), caisseZ.getDateClose());
        new PreparedSentence(this.s, "INSERT INTO HISTORIQUE_CAISSE(dateOpen, dateClose, caisse, user_open, user_close, htAmount, taxAmount, ttcAmount, cumul_Total, FUND_OPEN, FUND_CLOSE) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, caisseZ.getDateOpen());
                this.setTimestamp(2, caisseZ.getDateClose());
                this.setInt(3, caisseZ.getCaisse());
                this.setString(4, caisse.getUser_open_id());
                this.setString(5, caisse.getUser_close().getId());
                this.setDouble(6, NumericUtils.round(resumeTotalTax.getSumHT()));
                this.setDouble(7, NumericUtils.round(resumeTotalTax.getSumTax()));
                this.setDouble(8, NumericUtils.round(resumeTotalTax.getSumTTC()));
                this.setDouble(9, NumericUtils.round(DataLogicSales.this.cumulCaisse));
                this.setDouble(10, NumericUtils.round(caisse.getFondCaisse()));
                this.setDouble(11, NumericUtils.round(caisse.getFondClose()));
            }
        });
        new PreparedSentence(this.s, "UPDATE TICKETS SET closed = 1 where paid= 1 or ( paid= 0 and status='cancel' ) ", null).exec();
        new PreparedSentence(this.s, "UPDATE COURSES SET CLOSED = 1 where VALID= 1", null).exec();
    }

    public GrandTotalPeriode getGrandTotal() throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGTP, null, GrandTotalPeriode.getSerializerRead()).list();
        if (listTotaux.size() > 0) {
            return (GrandTotalPeriode)listTotaux.get(listTotaux.size() - 1);
        }
        return null;
    }

    public GrandTotalPeriode getLastGrandTotalPeriode(String typePeriode) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGTP + " where type_PERIODE = ? order by CAST (id AS Integer)  desc FETCH FIRST 1 rows only  ", SerializerWriteString.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)typePeriode);
        if (listTotaux.size() > 0) {
            return (GrandTotalPeriode)listTotaux.get(0);
        }
        return null;
    }

    public GrandTotalPeriode getFirstGrandTotalPeriode(String typePeriode) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGTP + " where type_PERIODE = ? order by CAST (id AS Integer)  asc FETCH FIRST 1 rows only  ", SerializerWriteString.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)typePeriode);
        if (listTotaux.size() > 0) {
            return (GrandTotalPeriode)listTotaux.get(0);
        }
        return null;
    }

    public GrandTotalPeriode getFirstNotUpdatedGrandTotalPeriode(String typePeriode) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGTP + " where type_PERIODE = ? AND TVA_UBER_UPDATED = 0 order by CAST (id AS Integer) asc FETCH FIRST 1 row only", SerializerWriteString.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)typePeriode);
        if (listTotaux.size() > 0) {
            System.out.println("+++++++++++++++listTotaux :" + listTotaux);
            return (GrandTotalPeriode)listTotaux.get(0);
        }
        return null;
    }

    public final GrandTotalTicket getLastGrandTotalTicket() throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGrandToTalTicket + "FROM GRAND_TOTAL order by  timestampGDH desc FETCH FIRST 1 rows only  ", null, GrandTotalTicket.getSerializerRead()).list();
        if (listTotaux.size() > 0) {
            return (GrandTotalTicket)listTotaux.get(0);
        }
        return null;
    }

    public Document getDocumentTicket(String idTicket) throws BasicException {
        List docs = new PreparedSentence(this.s, "SELECT  id, ticket FROM DOCUMENT WHERE ticket = ? ", SerializerWriteString.INSTANCE, Document.getSerializerRead()).list((Object)idTicket);
        if (docs.size() > 0) {
            return (Document)docs.get(0);
        }
        return null;
    }

    public List<SALLEINFO> getSalles() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME FROM SALLES ORDER BY NAME", null, SALLEINFO.getSerializerRead()).list();
    }

    public List<TableInfo> getTablesBySalle(int ID) throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, available, salle FROM TABLES WHERE salle = ? ", SerializerWriteInteger.INSTANCE, TableInfo.getSerializerRead()).list((Object)ID);
    }

    public List<TableInfo> getTables() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, available, salle FROM TABLES ORDER BY NUMBER ", null, TableInfo.getSerializerRead()).list();
    }

    public List<TableInfo> getunavailableTables() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, available, salle FROM TABLES WHERE available = 0 ORDER BY NUMBER ", null, TableInfo.getSerializerRead()).list();
    }

    public TableInfo loadTable(int ID) throws BasicException {
        return (TableInfo)new PreparedSentence(this.s, "SELECT ID, NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, available, salle FROM TABLES WHERE ID = ? ", SerializerWriteInteger.INSTANCE, TableInfo.getSerializerRead()).find((Object)ID);
    }

    public TableInfo getTableByNum(int ID) throws BasicException {
        return (TableInfo)new PreparedSentence(this.s, "SELECT ID, NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, available, salle FROM TABLES WHERE NUMBER = ? ", SerializerWriteInteger.INSTANCE, TableInfo.getSerializerRead()).find((Object)ID);
    }

    public TableInfo addTablle(TableInfo table) throws BasicException, SQLException {
        ResultSet rs;
        int idTable = -1;
        List<SALLEINFO> salles = this.getSalles();
        if (salles.size() > 0) {
            this.idSalle = salles.get(0).getId();
        } else {
            String SQL = "INSERT INTO SALLES (NAME) VALUES (?)";
            this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
            this.pstmt.setString(1, "salle");
            this.pstmt.executeUpdate();
            rs = this.pstmt.getGeneratedKeys();
            if (rs.next()) {
                this.idSalle = rs.getInt(1);
            }
        }
        String SQL1 = "INSERT INTO TABLES (NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, salle) VALUES (?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL1, 1);
        this.pstmt.setInt(1, table.getNumber());
        this.pstmt.setString(2, table.getType());
        this.pstmt.setInt(3, table.getNumber_person());
        this.pstmt.setInt(4, table.getX());
        this.pstmt.setInt(5, table.getY());
        this.pstmt.setInt(6, this.idSalle);
        this.pstmt.executeUpdate();
        rs = this.pstmt.getGeneratedKeys();
        if (rs.next()) {
            idTable = rs.getInt(1);
        }
        if (idTable != -1) {
            return this.loadTable(idTable);
        }
        return null;
    }

    public final void addSalle(SALLEINFO salle, List<TableInfo> tables) throws BasicException, SQLException {
        String SQL = "INSERT INTO SALLES (NAME) VALUES (?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, salle.getName());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        if (rs.next()) {
            this.idSalle = rs.getInt(1);
        }
        for (final TableInfo table : tables) {
            new PreparedSentence(this.s, "INSERT INTO TABLES (NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, salle) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, table.getNumber());
                    this.setString(2, table.getType());
                    this.setInt(3, table.getNumber_person());
                    this.setInt(4, table.getX());
                    this.setInt(5, table.getY());
                    this.setInt(6, DataLogicSales.this.idSalle);
                }
            });
        }
    }

    public final void updateSalle(final SALLEINFO salle, List<TableInfo> tables) throws BasicException, SQLException {
        new PreparedSentence(this.s, "UPDATE SALLES SET NAME = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, salle.getName());
                this.setInt(2, salle.getId());
            }
        });
        List<TableInfo> tablesDB = this.getTablesBySalle(salle.getId());
        for (final TableInfo tableDB : tablesDB) {
            int found = -1;
            for (TableInfo table : tables) {
                if (tableDB.getId() != table.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            new PreparedSentence(this.s, "DELETE FROM TABLES WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, tableDB.getId());
                }
            });
        }
        for (final TableInfo table : tables) {
            if (table.getId() == -1) {
                new PreparedSentence(this.s, "INSERT INTO TABLES (NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, salle) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, table.getNumber());
                        this.setString(2, table.getType());
                        this.setInt(3, table.getNumber_person());
                        this.setInt(4, table.getX());
                        this.setInt(5, table.getY());
                        this.setInt(6, salle.getId());
                    }
                });
                continue;
            }
            new PreparedSentence(this.s, "UPDATE TABLES SET NUMBER = ?, TYPE = ?, PERSONS = ?, POSITIONX = ?, POSITIONY = ?, salle = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, table.getNumber());
                    this.setString(2, table.getType());
                    this.setInt(3, table.getNumber_person());
                    this.setInt(4, table.getX());
                    this.setInt(5, table.getY());
                    this.setInt(6, salle.getId());
                    this.setInt(7, table.getId());
                }
            });
        }
    }

    public void removeSalle(final SALLEINFO salle) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SALLES WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, salle.getId());
            }
        });
    }

    public final void deleteTable(final int id) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM TABLES WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    public final List<HourInfo> loadSatisticByHour(final Date dateStart, final Date dateEnd) throws BasicException {
        List infos = new PreparedSentence(this.s, "SELECT COUNT(T.ID) as orders, SUM(T.total) as turnover, HOUR(T.CREATED) FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY HOUR(T.CREATED) ", SerializerWriteParams.INSTANCE, HourInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return infos;
    }

    public final List<HourInfo> loadSatisticByMonth(final Date dateStart, final Date dateEnd) throws BasicException {
        List infos = new PreparedSentence(this.s, "SELECT COUNT(T.ID) as orders, SUM(T.total) as turnover, DAY(T.CREATED) FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY DAY(T.CREATED) ", SerializerWriteParams.INSTANCE, HourInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return infos;
    }

    public final List<DayInfo> loadSatisticByWeek(final Date dateStart, final Date dateEnd) throws BasicException {
        List infos = new PreparedSentence(this.s, "SELECT COUNT(T.ID) as orders, SUM(T.total) as turnover, DATE(T.CREATED) JOIN TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY DATE(T.CREATED) ", SerializerWriteParams.INSTANCE, DayInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return infos;
    }

    public final List<CategoryStatisticInfo> loadSatisticCategory(final Date dateStart, final Date dateEnd) throws BasicException {
        List categories = new PreparedSentence(this.s, "SELECT a.NAME, sum(c.UNITS) FROM CATEGORIES as a LEFT JOIN PRODUCTS as b on a.id = b.CATEGORY LEFT JOIN TICKETLINES as c on b.id = c.PRODUCT LEFT JOIN TICKETS as t on c.TICKET = t.ID WHERE t.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND t.CREATED >= ? AND t.CREATED <= ? GROUP BY a.NAME", SerializerWriteParams.INSTANCE, CategoryStatisticInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return categories;
    }

    public final List<OrderStatisticInfo> loadSatisticOrder(final Date dateStart, final Date dateEnd) throws BasicException {
        List types = new PreparedSentence(this.s, "SELECT t.type, COUNT(t.ID) FROM TICKETS as t WHERE t.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND t.CREATED >= ? AND t.CREATED <= ? GROUP BY t.type", SerializerWriteParams.INSTANCE, OrderStatisticInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return types;
    }

    public final Double getTurnover(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] turnover = (Object[])new PreparedSentence(this.s, "SELECT SUM(T.total) as turnover FROM TICKETS T WHERE  T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? ", SerializerWriteParams.INSTANCE, new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return (Double)turnover[0];
    }

    public final List<ProduitStatistic> loadSatisticProducts(final Date dateStart, final Date dateEnd) throws BasicException {
        List products = new PreparedSentence(this.s, "SELECT PRODUCTS.NAME, SUM(TICKETLINES.UNITS), TICKETLINES.PRICE FROM TICKETLINES, TICKETS, PRODUCTS, TAXCATEGORIES WHERE TICKETLINES.PRODUCT = PRODUCTS.ID AND TICKETLINES.TICKET = TICKETS.ID AND TICKETLINES.TAXID = TAXCATEGORIES.ID AND  TICKETS.paid = 1 AND TICKETS.STATUS <> 'cancel' AND TICKETS.STATUS <> 'Refund' AND TICKETS.CREATED >= ? AND TICKETS.CREATED <= ? GROUP BY PRODUCTS.NAME, TICKETLINES.PRICE, TAXCATEGORIES.RATE", SerializerWriteParams.INSTANCE, ProduitStatistic.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return products;
    }

    public final int getumberOrder() throws SQLException {
        int number = 0;
        String SQL = "SELECT ordernumber from ORDER_NUMBER WHERE id = ? ";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        this.pstmt.setInt(1, 1);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("ordernumber");
        }
        rs.close();
        this.pstmt.close();
        return number;
    }

    public void incrementNumber(final int number) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ORDER_NUMBER SET ordernumber = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, number);
                this.setInt(2, 1);
            }
        });
    }

    public void resetNumber() throws BasicException {
        new PreparedSentence(this.s, "UPDATE  ORDER_NUMBER SET ordernumber = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, 1);
                this.setInt(2, 1);
            }
        });
    }

    public void resetCaisse() throws BasicException {
        this.deleteAllLines("ARCHIV_PERIODE");
        this.deleteAllLines("GRAND_TOTAL_PERIODE");
        this.deleteAllLines("GRAND_TOTAL");
        this.deleteAllLines("FACTURE");
        this.deleteAllLines("DOCUMENT");
        this.deleteAllLines("ENTETE");
        this.deleteAllLines("ENTETE_NOTE");
        this.deleteAllLines("LINES");
        this.deleteAllLines("TOTAL_TAX");
        this.deleteAllLines("TOTAL_ENCAISSEMENT");
        this.deleteAllLines("TICKET_PAYMENT");
        this.deleteAllLines("DEBIT_CUSTOMER");
        this.deleteAllLines("CREDIT_EMPLOYEE");
        this.deleteAllLines("Option_ticket");
        this.deleteAllLines("ingredient_ticket");
        this.deleteAllLines("Product_ticket");
        this.deleteAllLines("PRODUCT_ORDER");
        this.deleteAllLines("LOG_PANIER");
        this.deleteAllLines("TICKETLINES");
        this.deleteAllLines("PRODUCT_DIVERS");
        this.deleteAllLines("Duplicata");
        this.deleteAllLines("TICKET_AVOIR");
        this.deleteAllLines("TICKETS");
        this.deleteAllLines("PAYMENTS");
        this.deleteAllLines("RECEIPTS");
        this.deleteAllLines("HISTORIQUE_CAISSE");
        this.deleteAllLines("DRAWEROPENED");
        new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, true);
            }
        });
        try {
            Journal.writeToJET(new Event(260, "Initialisation des donn\u00e9es", AppLocal.user.getId(), "Cr\u00e9ation de la base de donn\u00e9es ", new Date().getTime(), "3.94.47"));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void updatePositionProduct(List<ProductInfoExt> products) throws BasicException {
        for (final ProductInfoExt product : products) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET order_item = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, product.getOrder_item());
                    this.setInt(2, product.getID());
                }
            });
        }
    }

    public void updatePositionCategory(List<CategoryInfo> categories) throws BasicException {
        for (CategoryInfo category : categories) {
            this.updatePositionCategory(category);
            for (CategoryInfo sub_category : category.getSub_categories()) {
                this.updatePositionCategory(sub_category);
            }
        }
    }

    public void updatePositionSupplement(List<SupplementInfo> supplements) throws BasicException {
        for (final SupplementInfo supplement : supplements) {
            new PreparedSentence(this.s, "UPDATE supplement SET order_supplement = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, supplement.getOrderSupplement());
                    this.setInt(2, supplement.getiD());
                }
            });
        }
    }

    public void updatePositionSuppItem(List<SupplementItemInfo> items) throws BasicException {
        for (final SupplementItemInfo item : items) {
            new PreparedSentence(this.s, "UPDATE supplement_item SET order_item = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, item.getOrderItem());
                    this.setInt(2, item.getiD());
                }
            });
        }
    }

    public void updateColorGOption(final SupplementInfo option) throws BasicException {
        new PreparedSentence(this.s, "UPDATE SUPPLEMENT SET color = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, option.getColor());
                this.setInt(2, option.getiD());
            }
        });
    }

    public void updateColorProduct(final ProductInfoExt product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET color = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, product.getColor());
                this.setInt(2, product.getID());
            }
        });
    }

    public void updateColorCatgory(final CategoryInfo category) throws BasicException {
        new PreparedSentence(this.s, "UPDATE CATEGORIES SET color = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, category.getColor());
                this.setInt(2, category.getID());
            }
        });
    }

    public void addPhoto(final PhotoDispaly photo) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PHOTO_DISPLAY(path) VALUES(?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, photo.getPath());
            }
        });
    }

    public void deletePhoto(final int id) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PHOTO_DISPLAY WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    public void deletePhotoByName(final String name) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PHOTO_DISPLAY WHERE PATH LIKE ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, name + "%");
            }
        });
    }

    public final List<PhotoDispaly> getAllPhoto() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, path, REF_SYNCH FROM PHOTO_DISPLAY ORDER BY ID ", null, PhotoDispaly.getSerializerRead()).list();
    }

    public final void deletePhotos() throws BasicException {
        new StaticSentence(this.s, "DELETE FROM PHOTO_DISPLAY", null).exec();
    }

    public void transfertOrder(final TicketInfo ticket, final String user, final String operationUser) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS SET PERSON = ?, transferred = ?, transferred_date = ?, olduser = ?, operation_user = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setBoolean(2, true);
                this.setTimestamp(3, new Date());
                this.setString(4, ticket.getUser().getId());
                this.setString(5, operationUser);
                this.setString(6, ticket.getId());
            }
        });
    }

    public final List<PaymentLine> loadPayment(final Date dateOpen) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE  T.STATUS <> 'cancel' AND T.CREATED >= ? GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        return payments;
    }

    public final Integer getNbOrder(final Date dateOpen) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Integer getNbProduit(final Date dateOpen) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(L.ID) FROM TICKETS T LEFT OUTER JOIN TICKETLINES L ON T.ID = L.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND L.nextElement = 0 AND T.CREATED >= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Integer getNbProduitDivers(final Date dateOpen) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(P.ID) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final List<TaxeLine> getTaxeByDate(final Date dateOpen) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(L.PRICE), SUM(L.htAmount), SUM(L.taxAmount) FROM TICKETS T LEFT OUTER JOIN TICKETLINES L ON T.ID = L.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON L.TAXID = X.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND L.nextElement = 0 AND T.CREATED >= ? GROUP BY X.NAME, X.ID , X.RATE", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        return asales;
    }

    public final List<TaxeLine> getTaxeDiversByDate(final Date dateOpen) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(P.PRICE*P.UNITS), SUM(P.htAmount), SUM(P.taxAmount) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON P.TAXID = X.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND T.CREATED >= ? GROUP BY X.NAME, X.ID, X.RATE", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        return asales;
    }

    public final List<UserCaisseInfo> getCAbyUser(final Date dateOpen, final Date dateClose) throws BasicException {
        System.out.println("+++++ dateOpen getCAbyUser : " + dateOpen);
        System.out.println("+++++ dateClose getCAbyUser : " + dateClose);
        List users = new StaticSentence(this.s, "SELECT P.ID, P.NAME, SUM(T.total) FROM  TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY P.ID, P.NAME", SerializerWriteParams.INSTANCE, UserCaisseInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
                this.setTimestamp(2, dateClose);
            }
        });
        return users;
    }

    public final List<UserCaisseInfo> getCAbyUser(Date dateOpen) throws BasicException {
        return this.getCAbyUser(dateOpen, new Date());
    }

    public void cancelOrderPending(final TicketInfo ticket, final String raison, String idUser, final boolean paid_in_other_caisse) throws BasicException, SQLException {
        EnteteInfo enteteNote;
        TicketInfo last_order;
        new PreparedSentence(this.s, "UPDATE  TICKETS SET STATUS = 'cancel',  reason_cancel = ? , PAID_IN_OTHER_CAISSE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, raison);
                this.setBoolean(2, paid_in_other_caisse);
                this.setString(3, ticket.getId());
            }
        });
        if (ticket.getTable() != null) {
            new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setInt(2, ticket.getTable().getId());
                }
            });
        }
        if (this.STOCK_ENABLED) {
            this.changeStock(ticket);
        }
        if (ticket.getCustomerId() != -1 && (last_order = this.loadTicketCustomer(ticket.getCustomerId())) != null) {
            this.mCustomerService.changeLastOrder(ticket.getCustomerId(), last_order.getDate());
        }
        if ((enteteNote = this.getEnteteNote(ticket.getId())) != null) {
            try {
                Journal.writeToJET(new Event(324, "Annulation d'une note", idUser, "Identifiant de note / raison d'annulation", new Date().getTime(), "Annulation de note '" + enteteNote.getId() + "' / " + raison.replace("\n", " . ").replace(",", "<")));
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            try {
                Journal.writeToJET(new Event(320, "Abandon d'une op\u00e9ration de vente commerciale non encore enregistr\u00e9e", idUser, "raison d'annulation", new Date().getTime(), raison.replace("\n", " . ").replace(",", "<")));
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public final Double getCACanceled(final Date dateOpen) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T  WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final List<TicketInfo> loadBydateOpen(final Date dateOpen) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE  C.OUVERTE = 1 AND T.paid = 1 AND R.DATENEW >= ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> getTicketsOpenedAfter(final Date dateOpen) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE C.OUVERTE = 1  AND R.DATENEW >= ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final Integer getNbOrderPending(final Date dateOpen) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T WHERE T.paid = 0 AND STATUS <> 'cancel' AND PLATFORM_ORDER = 0 AND T.CREATED >= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public void deleteOrderPending(String id) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM ENTETE WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)id);
        new StaticSentence(this.s, "DELETE FROM LINES WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)id);
        new StaticSentence(this.s, "DELETE FROM TOTAL_TAX WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)id);
        new StaticSentence(this.s, "DELETE FROM TOTAL_ENCAISSEMENT WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)id);
        new StaticSentence(this.s, "DELETE FROM TICKET_PAYMENT WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)id);
        new StaticSentence(this.s, "DELETE FROM TICKETS WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)id);
    }

    public final List<CaisseZ> getCaisseZ(final int year, final int month) throws BasicException {
        List caissez = new PreparedSentence(this.s, this.requestCaisseZ + " WHERE  YEAR(H.dateClose) = ? AND MONTH(H.dateClose) = ?  ORDER BY H.ID DESC ", SerializerWriteParams.INSTANCE, CaisseZ.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
            }
        });
        for (CaisseZ caisse : caissez) {
            if (caisse.getUser_open_id() != null) {
                caisse.setUser_open(UserInfo.fetchOrStore(caisse.getUser_open_id(), this));
            } else {
                caisse.setUser_open(null);
            }
            if (caisse.getUser_close_id() != null) {
                caisse.setUser_close(UserInfo.fetchOrStore(caisse.getUser_close_id(), this));
                continue;
            }
            caisse.setUser_close(null);
        }
        return caissez;
    }

    public final Double getCA(final Date dateOpen) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T  WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND  T.closed = 0 AND T.CREATED >= ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public MarqueNFC getMarqueNF() throws BasicException {
        List marque = new PreparedSentence(this.s, "SELECT  ID, SIRET, TVAINTRA, CODENAF, COMPANY, ADDRESS1, ADDRESS2, ZIPCODE, CITY, COUNTRY, NEW_SIRET, UPDATE_SIRET_AT, OLD_SIRET, FORME_JURIDIQUE, CAPITAL_SOCIAL, RCS, GREFFE, METIER, FIRST_CONNEXION FROM MARUQENF525 ORDER BY ID desc", null, MarqueNFC.getSerializerRead()).list();
        if (marque.size() > 0) {
            return (MarqueNFC)marque.get(0);
        }
        return null;
    }

    public EnteteInfo getLastEntete() throws BasicException {
        List entete = new PreparedSentence(this.s, this.requestEntete + " ORDER BY E.id desc FETCH FIRST 1 rows only ", null, EnteteInfo.getSerializerRead()).list();
        if (entete.size() > 0) {
            return (EnteteInfo)entete.get(0);
        }
        return null;
    }

    public EnteteInfo getEnteteByTicket(String ticket, boolean paid) throws BasicException {
        List entete;
        String request = this.requestEnteteNote;
        if (paid) {
            request = this.requestEntete;
        }
        if ((entete = new PreparedSentence(this.s, request + "WHERE E.ticket = ? order by E.id desc ", SerializerWriteString.INSTANCE, EnteteInfo.getSerializerRead()).list((Object)ticket)).size() > 0) {
            return (EnteteInfo)entete.get(0);
        }
        MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this);
        if (marqueNF == null) {
            marqueNF = new MarqueNFC("", "", "", "", "", "", "", "", "");
        }
        return new EnteteInfo("", "0", "10.0.1.27", 0, marqueNF.getCompany(), marqueNF.getAdresse1(), marqueNF.getZipCode(), marqueNF.getCity(), marqueNF.getCountry(), marqueNF.getSiret(), marqueNF.getCodeNAF(), marqueNF.getIntraTVA(), new Date(), "Commande", 0, ticket, AppLocal.header, AppLocal.footer, "pending", "", "1", "BIBORNE", AppLocal.user.getId(), true, true, "impression papier", 0, AppLocal.user.getName());
    }

    public void deleteMarqueNFC525() throws BasicException {
        new StaticSentence(this.s, "DELETE FROM MARUQENF525 ", null).exec();
    }

    public TicketResto getTicketResto(String num) throws BasicException {
        List ticketResto = new PreparedSentence(this.s, "SELECT  id, num, type, amount, validity_year, date_created FROM TicketResto WHERE num = ? ", SerializerWriteString.INSTANCE, TicketResto.getSerializerRead()).list((Object)num);
        if (ticketResto.size() > 0) {
            return (TicketResto)ticketResto.get(0);
        }
        return null;
    }

    public void addTicketResto(final TicketResto ticketResto) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO TicketResto (num, type, amount, validity_year,date_created) VALUES (?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticketResto.getNum());
                this.setInt(2, ticketResto.getType());
                this.setDouble(3, NumericUtils.round(ticketResto.getAmount()));
                this.setInt(4, ticketResto.getValidityYear());
                this.setTimestamp(5, new Date());
            }
        });
    }

    public List<TaxLineTicket> getTaxByTicket(String ticket) throws BasicException {
        return new PreparedSentence(this.s, "SELECT  T.id, X.NAME, T.total_ht, T.rate_tax, T.total_tax, T.total_ttc FROM TOTAL_TAX T JOIN TAXCATEGORIES X ON T.code_tax = X.ID WHERE ticket = ? ", SerializerWriteString.INSTANCE, TaxLineTicket.getSerializerRead()).list((Object)ticket);
    }

    public void addEvent(final journalInfo journal) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO Journal (code_event, descriptif, date_created) VALUES (?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, journal.getCode());
                this.setString(2, journal.getDescriptif());
                this.setTimestamp(3, journal.getDate_created());
            }
        });
    }

    public void setInfosRestitutionTicket(final String idTicket, final String restitution_ticket_type, final int nb_print, final int nb_send_e_ticket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ENTETE SET RESTITUTION_TYPE = ?, nb_print = ?, NB_SEND_E_TICKET = ? WHERE ticket = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, restitution_ticket_type);
                this.setInt(2, nb_print);
                this.setInt(3, nb_send_e_ticket);
                this.setString(4, idTicket);
            }
        });
    }

    public void decrementPrinter(String idTicket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ENTETE SET nb_print = nb_print-1 WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)idTicket);
    }

    public final List<PaymentLine> loadPayment(final Date dateStart, final Date dateEnd) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1  AND (P.PAYMENT<>'Avoir' OR (P.PAYMENT='Avoir' AND P.TOTAL > 0 ) ) AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        List paymentsAvoir = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1   AND  P.PAYMENT='Avoir' AND P.TOTAL<0   AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        payments.addAll(paymentsAvoir);
        return payments;
    }

    public final List<PaymentLine> loadPaymentAvoirTicketRestoByIDCaisse(int idCaisse) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P  LEFT OUTER JOIN TICKETS T ON P.RECEIPT  = T.ID LEFT OUTER JOIN caisse C ON T.caisse = C.ID  , HISTORIQUE_CAISSE H WHERE H.ID = ?  AND T.closed = 1 AND T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED BETWEEN H.DATEOPEN AND H.DATECLOSE    AND  P.PAYMENT='Avoir' AND P.TOTAL<0 AND avoir_origin like '%Ticket Resto%' GROUP BY P.PAYMENT", SerializerWriteInteger.INSTANCE, PaymentLine.getSerializerRead()).list((Object)idCaisse);
        return payments;
    }

    public final List<PaymentLine> loadPaymentAvoirTicketResto() throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND T.closed = 0   AND  P.PAYMENT='Avoir' AND P.TOTAL<0 AND avoir_origin like '%Ticket Resto%' GROUP BY P.PAYMENT", null, PaymentLine.getSerializerRead()).list();
        return payments;
    }

    public final List<PaymentLine> loadPaymentByYearAndOrMonth(final int year, final int month) throws BasicException {
        String wQ = "";
        if (month > 0) {
            wQ = "AND MONTH(T.CREATED) = ? ";
        }
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND YEAR(T.CREATED) = ? " + wQ + "  AND (P.PAYMENT<>'Avoir' OR (P.PAYMENT='Avoir' AND P.TOTAL > 0 ) ) GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        });
        List paymentsAvoir = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND YEAR(T.CREATED) = ? " + wQ + "  AND  P.PAYMENT='Avoir' AND P.TOTAL<0  GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        });
        payments.addAll(paymentsAvoir);
        return payments;
    }

    public final List<PaymentLine> loadPaymentAvoirTRXDay(final int year, final int month, final int day) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ?  AND  P.PAYMENT='Avoir' AND P.TOTAL<0 AND avoir_origin like '%Ticket Resto%' GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
    }

    public final List<PaymentLine> loadPaymentXDay(final int year, final int month, final int day) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ?  AND (P.PAYMENT<>'Avoir' OR (P.PAYMENT='Avoir' AND P.TOTAL > 0 ) ) GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        List paymentsAvoir = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ?   AND  P.PAYMENT='Avoir' AND P.TOTAL<0  GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        payments.addAll(paymentsAvoir);
        return payments;
    }

    public final List<PaymentLine> loadPaymentByCaisseId(int idCaisse) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P  LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID LEFT OUTER JOIN caisse C ON T.caisse = C.ID  , HISTORIQUE_CAISSE H WHERE H.ID = ?  AND T.closed = 1 AND T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED BETWEEN H.DATEOPEN AND H.DATECLOSE   AND (P.PAYMENT<>'Avoir' OR (P.PAYMENT='Avoir' AND P.TOTAL > 0 ) ) GROUP BY P.PAYMENT", SerializerWriteInteger.INSTANCE, PaymentLine.getSerializerRead()).list((Object)idCaisse);
        List paymentsAvoir = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P  LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID LEFT OUTER JOIN caisse C ON T.caisse = C.ID  , HISTORIQUE_CAISSE H WHERE H.ID = ?  AND T.closed = 1 AND T.paid =1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED BETWEEN H.DATEOPEN AND H.DATECLOSE    AND  P.PAYMENT='Avoir' AND P.TOTAL<0  GROUP BY P.PAYMENT", SerializerWriteInteger.INSTANCE, PaymentLine.getSerializerRead()).list((Object)idCaisse);
        payments.addAll(paymentsAvoir);
        return payments;
    }

    public final List<PaymentLine> loadPaymentByTicket(String idTicket) throws BasicException {
        List payments = new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.ID = ? GROUP BY P.PAYMENT", SerializerWriteString.INSTANCE, PaymentLine.getSerializerRead()).list((Object)idTicket);
        return payments;
    }

    public final Integer getNbOrder() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM  TICKETS T WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.closed = 0 ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find();
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Integer getNbOrderByYearAndOrMonth(final int year, final int month) throws BasicException {
        Object[] recsales;
        String wQ = "";
        if (month > 0) {
            wQ = "AND MONTH(T.CREATED) = ? ";
        }
        if ((recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? " + wQ, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        })) == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Integer getNbOrderXDay(final int year, final int month, final int day) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Integer getNbOrderByIdCaisse(final int idCaisse) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T LEFT OUTER JOIN caisse C ON T.caisse = C.ID ,HISTORIQUE_CAISSE H WHERE H.ID = ? AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.closed = 1 AND T.CREATED BETWEEN H.DATEOPEN AND H.DATECLOSE   ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idCaisse);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Double getNbProduit() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(L.UNITS) FROM TICKETS T LEFT OUTER JOIN TICKETLINES L ON T.ID = L.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND L.nextElement = 0 AND T.closed = 0 ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find();
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitByYearAndOrMonth(final int year, final int month) throws BasicException {
        Object[] recsales;
        String wQ = "";
        if (month > 0) {
            wQ = "AND MONTH(T.CREATED) = ? ";
        }
        if ((recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(L.UNITS) FROM TICKETS T LEFT OUTER JOIN TICKETLINES L ON T.ID = L.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND L.nextElement = 0 AND YEAR(T.CREATED) = ? " + wQ, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        })) == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitXDay(final int year, final int month, final int day) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(L.UNITS) FROM TICKETS T LEFT OUTER JOIN TICKETLINES L ON T.ID = L.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND L.nextElement = 0 AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitByCaisseId(final int idCaisse) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(L.UNITS) FROM TICKETS T LEFT OUTER JOIN caisse C ON T.caisse = C.ID LEFT OUTER JOIN TICKETLINES L ON T.ID = L.TICKET , HISTORIQUE_CAISSE H WHERE H.ID = ? AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND L.nextElement = 0 AND T.closed = 1 AND T.CREATED BETWEEN H.DATEOPEN AND H.DATECLOSE  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idCaisse);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitDivers() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(P.UNITS) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.closed = 0 ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find();
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitDiversByYearAndOrMonth(final int year, final int month) throws BasicException {
        Object[] recsales;
        String wQ = "";
        if (month > 0) {
            wQ = "AND MONTH(T.CREATED) = ? ";
        }
        if ((recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(P.UNITS) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? " + wQ, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        })) == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitDiversXDay(final int year, final int month, final int day) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(P.UNITS) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final Double getNbProduitDiversByCaisseId(final int idCaisse) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(P.UNITS) FROM TICKETS T LEFT OUTER JOIN caisse C ON T.caisse = C.ID LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET , HISTORIQUE_CAISSE H WHERE H.ID = ? AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.closed = 1 AND T.CREATED BETWEEN H.DATEOPEN AND H.DATECLOSE  ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idCaisse);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (double)((Double)recsales[0]);
    }

    public final List<TaxeLine> getTaxeByDate() throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE,   SUM(L.TOTAL_TTC), SUM(L.TOTAL_TTC) / (1 + L.RATE_TAX), sum(L.TOTAL_TTC) - (sum(L.TOTAL_TTC) / (1 + L.RATE_TAX)) FROM TICKETS T LEFT OUTER JOIN LINES L ON T.ID = L.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON L.CODE_TAX = X.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'   AND T.closed = 0 GROUP BY X.NAME, X.ID, X.RATE, L.RATE_TAX", null, TaxeLine.getSerializerRead()).list();
        return asales;
    }

    public final List<TaxeLine> getTaxesByYearAndOrMonth(final int year, final int month) throws BasicException {
        String wQ = "";
        if (month > 0) {
            wQ = "AND MONTH(T.CREATED) = ? ";
        }
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(L.TOTAL_TTC), SUM(L.TOTAL_TTC) / (1 + L.RATE_TAX), sum(L.TOTAL_TTC) - (sum(L.TOTAL_TTC) / (1 + L.RATE_TAX)) FROM TICKETS T LEFT OUTER JOIN LINES L ON T.ID = L.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON L.CODE_TAX = X.ID WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND YEAR(T.CREATED) = ? " + wQ + "GROUP BY X.NAME, X.ID, X.RATE, L.RATE_TAX", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        });
        return asales;
    }

    public final List<TaxeLine> getTaxesBetwen(final Date dateStart, final Date dateEnd) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE,  SUM(L.TOTAL_TTC), SUM(L.TOTAL_TTC) / (1 + L.RATE_TAX), sum(L.TOTAL_TTC) - (sum(L.TOTAL_TTC) / (1 + L.RATE_TAX)) FROM TICKETS T LEFT OUTER JOIN LINES L ON T.ID = L.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON L.CODE_TAX = X.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED >= ? AND T.CREATED <= ? GROUP BY X.NAME, X.ID, X.RATE, L.RATE_TAX", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return asales;
    }

    public final List<TaxeLine> getTaxeXDay(final int year, final int month, final int day) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE,  SUM(L.TOTAL_TTC), SUM(L.TOTAL_TTC) / (1 + L.RATE_TAX), sum(L.TOTAL_TTC) - (sum(L.TOTAL_TTC) / (1 + L.RATE_TAX)) FROM TICKETS T LEFT OUTER JOIN LINES L ON T.ID = L.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON L.CODE_TAX = X.ID WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ? GROUP BY X.NAME, X.ID, X.RATE, L.RATE_TAX", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        return asales;
    }

    public final List<TaxeLine> getTaxeByDateByIdCaisse(int idCaisse) throws BasicException {
        System.out.println("++++++++++ getTaxeByDateByIdCaisse : " + idCaisse);
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(L.TOTAL_TTC), SUM(L.TOTAL_TTC) / (1 + L.RATE_TAX), sum(L.TOTAL_TTC) - (sum(L.TOTAL_TTC) / (1 + L.RATE_TAX)) FROM TICKETS T LEFT OUTER JOIN caisse C ON T.caisse = C.ID LEFT OUTER JOIN LINES L ON T.ID = L.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON L.CODE_TAX = X.ID , HISTORIQUE_CAISSE H WHERE H.ID = ? AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND T.closed = 1 AND T.CREATED BETWEEN H.DATEOPEN AND H.DATECLOSE  GROUP BY X.NAME, X.ID, X.RATE, L.RATE_TAX", SerializerWriteInteger.INSTANCE, TaxeLine.getSerializerRead()).list((Object)idCaisse);
        return asales;
    }

    public final List<TaxeLine> getTaxeDiversByDate() throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(P.PRICE*P.UNITS), SUM(P.htAmount), SUM(P.taxAmount) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON P.TAXID = X.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.closed = 0 GROUP BY X.NAME, X.ID, X.RATE", null, TaxeLine.getSerializerRead()).list();
        return asales;
    }

    public final List<TaxeLine> getTaxeDiversByYearAndOrMonth(final int year, final int month) throws BasicException {
        String wQ = "";
        if (month > 0) {
            wQ = "AND MONTH(T.CREATED) = ? ";
        }
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(P.PRICE*P.UNITS), SUM(P.htAmount), SUM(P.taxAmount) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON P.TAXID = X.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? " + wQ + "GROUP BY X.NAME, X.ID, X.RATE", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        });
        return asales;
    }

    public final List<TaxeLine> getTaxeDiversXDay(final int year, final int month, final int day) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(P.PRICE*P.UNITS), SUM(P.htAmount), SUM(P.taxAmount) FROM TICKETS T LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON P.TAXID = X.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ? GROUP BY X.NAME, X.ID, X.RATE", SerializerWriteParams.INSTANCE, TaxeLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        return asales;
    }

    public final List<TaxeLine> getTaxeDiversByDateByIDCaisse(int idCaisse) throws BasicException {
        List asales = new StaticSentence(this.s, "SELECT X.ID, X.NAME, X.RATE, SUM(P.PRICE*P.UNITS), SUM(P.htAmount), SUM(P.taxAmount) FROM TICKETS T LEFT OUTER JOIN caisse C ON T.caisse = C.ID LEFT OUTER JOIN PRODUCT_DIVERS P ON T.ID = P.TICKET LEFT OUTER JOIN TAXCATEGORIES X ON P.TAXID = X.ID WHERE C.ID = ? AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.closed = 0 GROUP BY X.NAME, X.ID, X.RATE", SerializerWriteInteger.INSTANCE, TaxeLine.getSerializerRead()).list((Object)idCaisse);
        return asales;
    }

    public final List<UserCaisseInfo> getCAbyUser() throws BasicException {
        List users = new StaticSentence(this.s, "SELECT P.ID, P.NAME, SUM(T.total) FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.closed = 0 GROUP BY P.ID, P.NAME", null, UserCaisseInfo.getSerializerRead()).list();
        return users;
    }

    public final List<UserCaisseInfo> getCAbyUserByYearAndOrMonth(final int year, final int month) throws BasicException {
        String wQ = "";
        if (month > 0) {
            wQ = "AND MONTH(T.CREATED) = ? ";
        }
        List users = new StaticSentence(this.s, "SELECT P.ID, P.NAME, SUM(T.total) FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.CREATED) = ? " + wQ + "GROUP BY P.ID, P.NAME", SerializerWriteParams.INSTANCE, UserCaisseInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        });
        return users;
    }

    public final List<UserCaisseInfo> getCAbyUserXDay(final int year, final int month, final int day) throws BasicException {
        List users = new StaticSentence(this.s, "SELECT P.ID, P.NAME, SUM(T.total) FROM TICKETS T LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(T.LAST_UPDATE) = ? AND MONTH(T.LAST_UPDATE) = ? AND DAY(T.LAST_UPDATE) = ? GROUP BY P.ID, P.NAME", SerializerWriteParams.INSTANCE, UserCaisseInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        return users;
    }

    public final Double getCACanceled() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE  T.paid = 1 AND T.STATUS = 'cancel' AND T.closed = 0 ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find();
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getCACanceledByYearAndOrMonth(final int year, final int month) throws BasicException {
        Object[] recsales;
        String wQ = "";
        if (month > 0) {
            wQ = "AND MONTH(T.CREATED) = ? ";
        }
        if ((recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE T.paid = 1 AND T.STATUS = 'cancel' AND YEAR(T.CREATED) = ? " + wQ, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                if (month > 0) {
                    this.setInt(2, month);
                }
            }
        })) == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getCACanceledXDay(final int year, final int month, final int day) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE T.paid = 1 AND T.STATUS = 'cancel' AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getCACanceledByCaisseId(int idCaisse) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T LEFT OUTER JOIN caisse C ON T.caisse = C.ID , HISTORIQUE_CAISSE H WHERE H.ID = ? AND T.paid = 1 AND T.STATUS = 'cancel' AND T.closed = 1 AND T.CREATED BETWEEN H.DATEOPEN AND H.DATECLOSE   ", SerializerWriteInteger.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)idCaisse);
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final List<TicketInfo> loadBydateOpen() throws BasicException {
        String request_hidden_orders = AppLocal.HIDE_ORDERS ? " AND T.PAID_IN_OTHER_CAISSE = 0 " : "";
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE T.closed = 0  " + request_hidden_orders + "ORDER BY T.TICKETID desc ", null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            ticket.setPayments(this.findPaymetsByIdTicket(ticket.getId()));
        }
        return tickets;
    }

    public final Integer getNbOrderPending() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T WHERE T.paid = 0 AND T.closed = 0 AND STATUS <> 'cancel' ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find();
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Double getSumCourses() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(C.PRICE * C.UNITS) FROM COURSES C WHERE C.VALID = 1 AND C.CLOSED = 0 AND C.REMOVED = 0 ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find();
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getCACaisse() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find();
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getCA() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T  WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND  T.closed = 0 ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find();
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getTotalCourses() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(C.PRICE) FROM COURSES C WHERE C.VALID = 1 AND C.CLOSED = 0 AND C.REMOVED = 0  ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find();
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public Facture addFacture(Facture facture, String codeOperator) throws BasicException {
        return this.addFacture(facture, codeOperator, "FACTURE", 0);
    }

    public TicketInfo cancelFacture(long idFacture, String idUsert, String raison) throws BasicException {
        if (raison == null) {
            raison = "";
        }
        Facture f = this.getFactureById(idFacture);
        TicketInfo ticket = this.getTicketById(f.getTicket());
        this.addFacture(f, idUsert, "ANNULATION", (int)f.getId());
        List<TicketLineInfo> lines = this.loadLines(ticket.getId());
        List<TicketLineInfo> linesExterne = this.getTicketLineExterne(ticket.getId());
        lines.addAll(linesExterne);
        ticket.setLines(lines);
        ticket.setPayments(this.findPaymetsByIdTicket(ticket.getId()));
        TicketInfo ticketCanceled = this.cancelOrder(ticket, raison, idUsert);
        new PreparedSentence(this.s, "UPDATE FACTURE SET cancel = 1 WHERE id = ? ", SerializerWriteInteger.INSTANCE).exec((Object)((int)idFacture));
        try {
            Journal.writeToJET(new Event(190, "Annulation comptable de Facture", idUsert, "Id de Facture", new Date().getTime(), "Facture :" + idFacture));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return ticketCanceled;
    }

    public final List<Facture> getFactures(final Date dateStart, final Date dateEnd) throws BasicException {
        List factures = new PreparedSentence(this.s, this.requestFacture + "JOIN GRAND_TOTAL G ON F.ticket = G.ticket WHERE F.date_created >= ? AND F.date_created <= ? ORDER BY F.id ", SerializerWriteParams.INSTANCE, Facture.getSerializerReadWtithTvas()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (Facture facture : factures) {
            this.setInfoFacture(facture);
        }
        return factures;
    }

    public final CaisseZ getLastCaisseZ() throws BasicException {
        List caissez = new PreparedSentence(this.s, this.requestCaisseZ + " LEFT OUTER JOIN caisse C ON H.caisse = C.ID  WHERE C.token = ? ", SerializerWriteString.INSTANCE, CaisseZ.getSerializerRead()).list((Object)AppLocal.token);
        for (CaisseZ caisse : caissez) {
            if (caisse.getUser_open_id() != null) {
                caisse.setUser_open(UserInfo.fetchOrStore(caisse.getUser_open_id(), this));
            } else {
                caisse.setUser_open(null);
            }
            if (caisse.getUser_close_id() != null) {
                caisse.setUser_close(UserInfo.fetchOrStore(caisse.getUser_close_id(), this));
                continue;
            }
            caisse.setUser_close(null);
        }
        if (caissez.size() > 0) {
            return (CaisseZ)caissez.get(caissez.size() - 1);
        }
        return null;
    }

    public final void addMarqueNF(final MarqueNFC marqueNFC) throws BasicException {
        if (marqueNFC.getId() != 0) {
            new PreparedSentence(this.s, "UPDATE  MARUQENF525 SET  SIRET = ? , TVAINTRA = ? , CODENAF = ? ,COMPANY =? , ADDRESS1 = ? , ADDRESS2 = ? , ZIPCODE = ? , CITY =? , COUNTRY = ?, FORME_JURIDIQUE = ?, CAPITAL_SOCIAL = ?, RCS = ?, GREFFE = ?, METIER = ?, FIRST_CONNEXION = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, marqueNFC.getSiret());
                    this.setString(2, marqueNFC.getIntraTVA());
                    this.setString(3, marqueNFC.getCodeNAF());
                    this.setString(4, marqueNFC.getCompany());
                    this.setString(5, marqueNFC.getAdresse1());
                    this.setString(6, marqueNFC.getEmail());
                    this.setString(7, marqueNFC.getZipCode());
                    this.setString(8, marqueNFC.getCity());
                    this.setString(9, marqueNFC.getCountry());
                    this.setString(10, marqueNFC.getForme_juridique());
                    this.setString(11, marqueNFC.getCapital_social());
                    this.setString(12, marqueNFC.getRcs());
                    this.setString(13, marqueNFC.getGreffe());
                    this.setString(14, marqueNFC.getMetier());
                    this.setTimestamp(15, marqueNFC.getDateFirstConnexion());
                    this.setInt(16, marqueNFC.getId());
                }
            });
            if (marqueNFC.isNew_siret()) {
                this.setNewSiretAndResetPerpetual(marqueNFC);
            }
        } else {
            new PreparedSentence(this.s, "INSERT INTO MARUQENF525 ( SIRET , TVAINTRA , CODENAF ,COMPANY ,ADDRESS1 ,ADDRESS2 ,ZIPCODE , CITY ,COUNTRY , FORME_JURIDIQUE, CAPITAL_SOCIAL, RCS, GREFFE, METIER, FIRST_CONNEXION) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, marqueNFC.getSiret());
                    this.setString(2, marqueNFC.getIntraTVA());
                    this.setString(3, marqueNFC.getCodeNAF());
                    this.setString(4, marqueNFC.getCompany());
                    this.setString(5, marqueNFC.getAdresse1());
                    this.setString(6, marqueNFC.getEmail());
                    this.setString(7, marqueNFC.getZipCode());
                    this.setString(8, marqueNFC.getCity());
                    this.setString(9, marqueNFC.getCountry());
                    this.setString(10, marqueNFC.getForme_juridique());
                    this.setString(11, marqueNFC.getCapital_social());
                    this.setString(12, marqueNFC.getRcs());
                    this.setString(13, marqueNFC.getGreffe());
                    this.setString(14, marqueNFC.getMetier());
                    this.setTimestamp(15, marqueNFC.getDateFirstConnexion());
                }
            });
        }
    }

    public void updateLivreurOnTicket(final String ticketId, final String livreurId) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TICKETS SET livreur = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, livreurId);
                this.setString(2, ticketId);
            }
        });
    }

    public void cancelDisbursement(String ticketId) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TICKETS SET DELIVERED = 0, STATUS = 'pending' WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)ticketId);
    }

    public List<ProductInfoExt> getAllProducts() throws BasicException {
        return new PreparedSentence(this.s, this.requestProducts + "WHERE P.removed = 0 AND P.hidden = 0 and REMOVED_BY_ADMIN = 0 " + this.request_campaign_product + "ORDER BY  P.order_item ", null, ProductInfoExt.getSerializerRead()).list();
    }

    public final List<ProductSupplementsRelation> getProductsSupplementRelations() throws BasicException {
        return new PreparedSentence(this.s, "SELECT id_item, id_supplement, free_able , separate FROM item_supplements ", null, ProductSupplementsRelation.getSerializerRead()).list();
    }

    public final List<ProdustIngredientRelation> getProductsIngredientRelations() throws BasicException {
        return new PreparedSentence(this.s, "SELECT id_item, ID_SUPPLEMENT_ITEM, quantity FROM ITEM_INGREDIENTS ", null, ProdustIngredientRelation.getSerializerRead()).list();
    }

    public List<SupplementItemInfo> getSupplementItems() throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + this.request_campaign_supplement_item, null, SupplementItemInfo.getSerializerRead()).list();
    }

    public final List<CarteItemInfo> getCarteItems() throws BasicException {
        return new PreparedSentence(this.s, "SELECT id_carte, id_item, price FROM CARTE_ITEM ", null, CarteItemInfo.getSerializerRead()).list();
    }

    public final List<CarteMenu> getCarteMenus() throws BasicException {
        return new PreparedSentence(this.s, "SELECT id_carte , id_item , carteorder,number_carte FROM CARTE_MENU ", null, CarteMenu.getSerializerRead()).list();
    }

    public final AppUser getUserByPassword(String password) throws BasicException {
        System.out.println("+++++++password new :" + password);
        AppUser appUser = (AppUser)new PreparedSentence(this.s, "SELECT P.ID, P.NAME, P.APPPASSWORD, P.ROLE, C.ID as code FROM PEOPLE P  LEFT JOIN COUNTER_USER C ON P.ID = C.ID_USER WHERE P.APPPASSWORD = ? AND P.removed = 0 ", SerializerWriteString.INSTANCE, AppUser.getSerializerRead()).find((Object)password);
        return appUser;
    }

    public final AppUser getUserByFingerPrint(String fingerPrint) throws BasicException {
        return (AppUser)new PreparedSentence(this.s, "SELECT P.ID, P.NAME, P.APPPASSWORD, P.ROLE, C.ID as code FROM PEOPLE P  LEFT JOIN COUNTER_USER C ON P.ID = C.ID_USER WHERE P.fingerprint = ? AND P.removed = 0 ", SerializerWriteString.INSTANCE, AppUser.getSerializerRead()).find((Object)fingerPrint);
    }

    public void setAvailableTable(final int id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, true);
                this.setInt(2, id);
            }
        });
    }

    public final TicketInfo loadTicketCustomer(final int customerID) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE T.CUSTOMER = ? AND STATUS <> 'cancel' AND STATUS <> 'Refund' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, customerID);
            }
        });
        if (tickets.size() > 0) {
            return (TicketInfo)tickets.get(0);
        }
        return null;
    }

    public Duplicata addDuplicataAndReturnNumberPrint(final Duplicata duplicata) throws BasicException {
        Duplicata previousDuplicata = this.getDuplicataByIdDoc(duplicata.getId_Doc(), duplicata.getType_doc());
        long nbPrint = 1L;
        if (previousDuplicata != null) {
            nbPrint = previousDuplicata.getImpression_Number() + 1L;
        }
        final long impression_number = nbPrint;
        Duplicata lastDuplicata = this.getLastDuplicata(duplicata.getType_doc());
        new PreparedSentence(this.s, "INSERT INTO DUPLICATA ( id_doc, impression_Number, type_doc, user_operator, date_impression, Signature, num_Doc,horodatage, CHECK_TYPE_DOC, VERSION_SOFT, MOTIF_IMPRESSION, REF_FACTURE, REF_TICKET) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, duplicata.getId_Doc());
                this.setInt(2, (int)impression_number);
                this.setString(3, duplicata.getType_doc());
                this.setString(4, duplicata.getUser_operator());
                this.setTimestamp(5, duplicata.getDate_impression());
                this.setString(6, null);
                this.setInt(7, duplicata.getNumDoc());
                this.setString(8, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(duplicata.getDate_impression()));
                this.setBoolean(9, true);
                this.setString(10, "10.0.1.27");
                this.setString(11, duplicata.getMotif_impression());
                this.setInt(12, duplicata.getRef_facture());
                this.setInt(13, duplicata.getRef_ticket());
            }
        });
        final Duplicata thisDuplicata = this.getLastDuplicata();
        String duplicataEmprinte = this.mDataLogicSalesHelper.buildDuplicataSignature(thisDuplicata, lastDuplicata);
        final String signature = DataLogicSales.signer(duplicataEmprinte);
        new PreparedSentence(this.s, "UPDATE  DUPLICATA SET signature = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, signature);
                this.setInt(2, (int)thisDuplicata.getId());
            }
        });
        thisDuplicata.setSignature(signature);
        return thisDuplicata;
    }

    public final List<Facture> allFactures() throws BasicException {
        List factures = new PreparedSentence(this.s, this.requestFacture + " JOIN GRAND_TOTAL G ON F.ticket = G.ticket ORDER BY F.id ", null, Facture.getSerializerReadWtithTvas()).list();
        for (Facture facture : factures) {
            this.setInfoFacture(facture);
        }
        return factures;
    }

    public final List<Facture> getFacturesAfter(final Date dateOpened) throws BasicException {
        List factures = new PreparedSentence(this.s, this.requestFacture + "JOIN GRAND_TOTAL G ON F.ticket = G.ticket WHERE  F.date_created >= ?  ORDER BY F.id ", SerializerWriteParams.INSTANCE, Facture.getSerializerReadWtithTvas()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpened);
            }
        });
        for (Facture facture : factures) {
            this.setInfoFacture(facture);
        }
        return factures;
    }

    public final List<Facture> allFacturesDay() throws BasicException {
        List factures = new PreparedSentence(this.s, this.requestFacture + "JOIN GRAND_TOTAL G ON F.ticket = G.ticket WHERE YEAR(F.date_created) = ? AND MONTH(F.date_created) = ? AND DAY(F.date_created) = ?  ORDER BY F.id ", SerializerWriteParams.INSTANCE, Facture.getSerializerReadWtithTvas()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, DataLogicSales.this.currentYear);
                this.setInt(2, DataLogicSales.this.currentMonth);
                this.setInt(3, DataLogicSales.this.currentDay);
            }
        });
        for (Facture facture : factures) {
            this.setInfoFacture(facture);
        }
        return factures;
    }

    public final List<Facture> allFacturesMonth() throws BasicException {
        List factures = new PreparedSentence(this.s, this.requestFacture + "JOIN GRAND_TOTAL G ON F.ticket = G.ticket WHERE  YEAR(F.date_created) = ? AND MONTH(F.date_created) = ? ORDER BY F.id ", SerializerWriteParams.INSTANCE, Facture.getSerializerReadWtithTvas()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, DataLogicSales.this.currentYear);
                this.setInt(2, DataLogicSales.this.currentMonth);
            }
        });
        for (Facture facture : factures) {
            this.setInfoFacture(facture);
        }
        return factures;
    }

    public final List<Facture> allFacturesYear() throws BasicException {
        List factures = new PreparedSentence(this.s, this.requestFacture + "JOIN GRAND_TOTAL G ON F.ticket = G.ticket WHERE YEAR(F.date_created) = ? ORDER BY F.id ", SerializerWriteParams.INSTANCE, Facture.getSerializerReadWtithTvas()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, DataLogicSales.this.currentYear);
            }
        });
        for (Facture facture : factures) {
            this.setInfoFacture(facture);
        }
        return factures;
    }

    public final List<TicketInfo> allTicket() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + " ORDER BY R.DATENEW desc ", null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public List<TotaleEncaissement> allTotal() throws BasicException {
        return new PreparedSentence(this.s, this.requestTotalEncaissement + "JOIN TICKETS as T ON E.ticket = T.ID ", null, TotaleEncaissement.getSerializerRead()).list();
    }

    public List<TotaleEncaissement> allTotalDay() throws BasicException {
        return new PreparedSentence(this.s, this.requestTotalEncaissement + "LEFT JOIN TICKETS as T ON E.ticket = T.ID WHERE YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? AND DAY(T.CREATED) = ? ", SerializerWriteParams.INSTANCE, TotaleEncaissement.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, DataLogicSales.this.currentYear);
                this.setInt(2, DataLogicSales.this.currentMonth);
                this.setInt(3, DataLogicSales.this.currentDay);
            }
        });
    }

    public List<TotaleEncaissement> getTotalAfter(final Date dateOpened) throws BasicException {
        return new PreparedSentence(this.s, this.requestTotalEncaissement + "LEFT JOIN TICKETS as T ON E.ticket = T.ID WHERE T.CREATED > ?  ", SerializerWriteParams.INSTANCE, TotaleEncaissement.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpened);
            }
        });
    }

    public List<TotaleEncaissement> allTotalMonth() throws BasicException {
        return new PreparedSentence(this.s, this.requestTotalEncaissement + "LEFT JOIN TICKETS as T ON E.ticket = T.ID WHERE  YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ? ", SerializerWriteParams.INSTANCE, TotaleEncaissement.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, DataLogicSales.this.currentYear);
                this.setInt(2, DataLogicSales.this.currentMonth);
            }
        });
    }

    public List<TotaleEncaissement> allTotalYear() throws BasicException {
        return new PreparedSentence(this.s, this.requestTotalEncaissement + "LEFT JOIN TICKETS as T ON E.ticket = T.ID WHERE YEAR(T.CREATED) = ? ", SerializerWriteParams.INSTANCE, TotaleEncaissement.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, DataLogicSales.this.currentYear);
            }
        });
    }

    public final List<CaisseZ> allCaisse() throws BasicException {
        List caissez = new PreparedSentence(this.s, this.requestCaisseZ + " LEFT OUTER JOIN caisse C ON H.caisse = C.ID  WHERE C.token = ? ", SerializerWriteString.INSTANCE, CaisseZ.getSerializerRead()).list((Object)AppLocal.token);
        for (CaisseZ caisse : caissez) {
            if (caisse.getUser_open_id() != null) {
                caisse.setUser_open(UserInfo.fetchOrStore(caisse.getUser_open_id(), this));
            } else {
                caisse.setUser_open(null);
            }
            if (caisse.getUser_close_id() != null) {
                caisse.setUser_close(UserInfo.fetchOrStore(caisse.getUser_close_id(), this));
                continue;
            }
            caisse.setUser_close(null);
        }
        return caissez;
    }

    public List<GrandTotalTicket> allGrandTotalTicket() throws BasicException {
        return new PreparedSentence(this.s, this.requestGrandToTalTicket + "FROM GRAND_TOTAL ", null, GrandTotalTicket.getSerializerRead()).list();
    }

    public List<GrandTotalPeriode> allGrandTotal() throws BasicException {
        return new PreparedSentence(this.s, this.requestGTP, null, GrandTotalPeriode.getSerializerRead()).list();
    }

    public static String signer(String ticketEmprinte) {
        if (ticketEmprinte != null) {
            String result = ticketEmprinte.replace(' ', '_');
            try {
                SignatureGenerator generator = SignatureGenerator.getGenerator();
                String data = new String(result.getBytes("UTF-8"));
                String signature = generator.digitalSign(data);
                return signature;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return null;
    }

    public Duplicata getLastDuplicata() throws BasicException {
        List duplicatas = new PreparedSentence(this.s, this.requestDuplicata + " ORDER BY id desc", null, Duplicata.getSerializerRead()).list();
        if (duplicatas.size() > 0) {
            return (Duplicata)duplicatas.get(0);
        }
        return null;
    }

    public Facture getLastFacture() throws BasicException {
        List factures = new PreparedSentence(this.s, this.requestFacture + "JOIN caisse C ON T.caisse = C.ID JOIN GRAND_TOTAL G ON F.ticket = G.ticket ORDER BY F.id desc ", null, Facture.getSerializerReadWtithTvas()).list();
        if (factures.size() > 0) {
            this.setInfoFacture((Facture)factures.get(0));
            return (Facture)factures.get(0);
        }
        return null;
    }

    public final Double getSumTotauxPeriode(final Date ancienDate, final Date newDate) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM ( t.grand_total) FROM grand_total t WHERE  t.timestampGDH > ? and t.timestampGDH < ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, ancienDate);
                this.setTimestamp(2, newDate);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getCumulPerpetuelPeriode(final Date ancienDate, final Date newDate) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM ( ABS(t.grand_total)) FROM grand_total t WHERE  t.timestampGDH > ? and t.timestampGDH < ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, ancienDate);
                this.setTimestamp(2, newDate);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getSumTotauxPeriodeTVA5(final Date ancienDate, final Date newDate) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM ( t.TVA_5_5) FROM grand_total t WHERE  t.timestampGDH > ? and t.timestampGDH < ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, ancienDate);
                this.setTimestamp(2, newDate);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getSumTotauxPeriodeTVA10(final Date ancienDate, final Date newDate) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM ( t.TVA_10) FROM grand_total t WHERE  t.timestampGDH > ? and t.timestampGDH < ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, ancienDate);
                this.setTimestamp(2, newDate);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Double getSumTotauxPeriodeTVA20(final Date ancienDate, final Date newDate) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM ( t.TVA_20) FROM grand_total t WHERE  t.timestampGDH > ? and t.timestampGDH < ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, ancienDate);
                this.setTimestamp(2, newDate);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public void deleteLigneById(String tableName, final String id) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM " + tableName + " WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
    }

    public void deleteAllLines(String tableName) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM " + tableName + " ", null).exec();
    }

    private String signer(StringBuilder ticketEmprinte) {
        return DataLogicSales.signer(ticketEmprinte.toString());
    }

    private void insertGrandTotalPeriode(String typePeriode, Date dateFinPeriode, String idUser) throws BasicException, BasicException {
        String idGRAND;
        GrandTotalPeriode grandTotalPeriode = this.getLastGrandTotalPeriode(typePeriode);
        int PERIODE_INCREMENT = switch (typePeriode) {
            case "a" -> {
                idGRAND = com.openbravo.pos.util.DateUtils.SDF_ID_YEAR_PERIOD.format(dateFinPeriode);
                this.dateFormatterId = com.openbravo.pos.util.DateUtils.SDF_ID_YEAR_PERIOD;
                yield 1;
            }
            case "j" -> {
                idGRAND = com.openbravo.pos.util.DateUtils.SDF_ID_DAY_PERIOD.format(dateFinPeriode);
                this.dateFormatterId = com.openbravo.pos.util.DateUtils.SDF_ID_DAY_PERIOD;
                yield 5;
            }
            case "m" -> {
                idGRAND = com.openbravo.pos.util.DateUtils.SDF_ID_MONTH_PERIOD.format(dateFinPeriode);
                this.dateFormatterId = com.openbravo.pos.util.DateUtils.SDF_ID_MONTH_PERIOD;
                yield 2;
            }
            default -> {
                idGRAND = com.openbravo.pos.util.DateUtils.SDF_ID_DAY_PERIOD.format(dateFinPeriode);
                this.dateFormatterId = com.openbravo.pos.util.DateUtils.SDF_ID_DAY_PERIOD;
                yield 5;
            }
        };
        GrandTotalTicket firstGrandTotalTicket = this.getFirstTotalTicket();
        if (firstGrandTotalTicket != null || grandTotalPeriode != null) {
            Date today = new Date();
            Date datestartPeriode = null;
            if (firstGrandTotalTicket != null) {
                datestartPeriode = new Date(firstGrandTotalTicket.getTimestampGDH().getTime() - 1L);
            }
            if (grandTotalPeriode != null) {
                boolean isNotoday;
                if (grandTotalPeriode.getTimestampGDH() != null) {
                    datestartPeriode = com.openbravo.pos.util.DateUtils.getDateFromString(grandTotalPeriode.getId());
                }
                this.calendar.setTime(datestartPeriode);
                GrandTotalPeriode lastOne = grandTotalPeriode;
                long diff = today.getTime() - datestartPeriode.getTime();
                long HoursDiff = TimeUnit.HOURS.convert(diff, TimeUnit.MILLISECONDS);
                boolean bl = !typePeriode.equals("j") ? true : (isNotoday = HoursDiff >= 30L);
                while (datestartPeriode.before(dateFinPeriode) && !com.openbravo.pos.util.DateUtils.isToday(datestartPeriode) && isNotoday) {
                    if (!lastOne.getId().equals(this.dateFormatterId.format(datestartPeriode)) && !com.openbravo.pos.util.DateUtils.isToday(datestartPeriode)) {
                        this.insertCloturePeriode(typePeriode, datestartPeriode, lastOne.getCumulPerpetual(), lastOne.getCumulPerpetualReel(), lastOne.getSignature(), idUser, lastOne.isBefore_perpetual_reset());
                    }
                    this.calendar.add(PERIODE_INCREMENT, 1);
                    datestartPeriode = this.calendar.getTime();
                    lastOne = this.getLastGrandTotalPeriode(typePeriode);
                    diff = today.getTime() - datestartPeriode.getTime();
                    HoursDiff = TimeUnit.HOURS.convert(diff, TimeUnit.MILLISECONDS);
                    isNotoday = !typePeriode.equals("j") ? true : HoursDiff >= 30L;
                }
                if (lastOne != null && new Integer(lastOne.getId()) < new Integer(idGRAND) && !com.openbravo.pos.util.DateUtils.isToday(datestartPeriode) && isNotoday) {
                    this.insertCloturePeriode(typePeriode, datestartPeriode, lastOne.getCumulPerpetual(), lastOne.getCumulPerpetualReel(), lastOne.getSignature(), idUser, lastOne.isBefore_perpetual_reset());
                }
            } else {
                GrandTotalPeriode lastOne;
                if (datestartPeriode != null && datestartPeriode.getHours() < 6 && typePeriode != null && typePeriode.equals("j")) {
                    this.calendar.setTime(datestartPeriode);
                    this.calendar.add(PERIODE_INCREMENT, -1);
                    datestartPeriode = this.calendar.getTime();
                }
                if (new Integer(this.dateFormatterId.format(datestartPeriode)) <= new Integer(this.dateFormatterId.format(dateFinPeriode)) && !com.openbravo.pos.util.DateUtils.isToday(datestartPeriode)) {
                    this.calendar.setTime(datestartPeriode);
                    this.insertCloturePeriode(typePeriode, datestartPeriode, 0.0, 0.0, null, idUser, false);
                    this.calendar.add(PERIODE_INCREMENT, 1);
                    datestartPeriode = this.calendar.getTime();
                }
                while (datestartPeriode.before(dateFinPeriode)) {
                    lastOne = this.getLastGrandTotalPeriode(typePeriode);
                    if (!lastOne.getId().equals(this.dateFormatterId.format(datestartPeriode)) && !com.openbravo.pos.util.DateUtils.isToday(datestartPeriode)) {
                        this.insertCloturePeriode(typePeriode, datestartPeriode, lastOne.getCumulPerpetual(), lastOne.getCumulPerpetualReel(), lastOne.getSignature(), idUser, lastOne.isBefore_perpetual_reset());
                    }
                    this.calendar.add(PERIODE_INCREMENT, 1);
                    datestartPeriode = this.calendar.getTime();
                }
                lastOne = this.getLastGrandTotalPeriode(typePeriode);
                if (lastOne != null && new Integer(lastOne.getId()) < new Integer(idGRAND) && !com.openbravo.pos.util.DateUtils.isToday(datestartPeriode)) {
                    this.insertCloturePeriode(typePeriode, datestartPeriode, lastOne.getCumulPerpetual(), lastOne.getCumulPerpetualReel(), lastOne.getSignature(), idUser, lastOne.isBefore_perpetual_reset());
                }
            }
            this.checkCumulPerpetualReset(idUser, false);
        }
    }

    private void insertCloturePeriode(final String typePeriode, Date todayDate, double cumulPerpetualPrevious, double cumulPerpetualReelPrevious, String previousSignature, String idUser, boolean lastGTP_before_perpetual_reset) throws BasicException {
        System.out.println("+++++++ insertCloturePeriode : " + new Date());
        final String idGRAND = this.dateFormatterId.format(todayDate);
        GrandTotalPeriode gtp = this.getGrandTotalPeriodeById(idGRAND);
        if (gtp == null) {
            double cumulPerpetual;
            GrandTotalPeriode lastMonthlygtp;
            boolean before_perpetual_reset;
            Date dateEnd = new Date();
            switch (typePeriode) {
                case "j": {
                    com.openbravo.pos.util.DateUtils.setDateHours(todayDate, dateEnd);
                    break;
                }
                case "m": {
                    com.openbravo.pos.util.DateUtils.setDateMonths(todayDate, dateEnd);
                    break;
                }
                case "a": {
                    dateEnd = new Date(todayDate.getYear() + 1, 0, 1);
                }
            }
            if (!typePeriode.equals("a")) {
                this.mClotureService = ClotureService.getInstance(this, (JRootApp)BasicStorage.getObject("APP_ROOT_INSTANCE"));
            }
            final HashMap<String, Object> map_infos = typePeriode.equals("a") ? this.getFinancialInfoPeriode(idGRAND, "m") : (typePeriode.equals("m") ? this.getFinancialInfoPeriode(idGRAND, "j") : this.mClotureService.getFinancialReportInfo(todayDate, dateEnd));
            System.out.println("+++++++ get infos : " + new Date());
            final Date thisTimeStampe = new Date();
            StringBuilder builderEmprinteGrandPeriode = new StringBuilder();
            final double cumule = this.getCumulePeriode(todayDate, typePeriode, false, idGRAND);
            final double totalTVAPeriode5 = this.getTVAPeriode(todayDate, typePeriode, "TVA_5_5", idGRAND);
            final double totalTVAPeriode10 = this.getTVAPeriode(todayDate, typePeriode, "TVA_10", idGRAND);
            final double totalTVAPeriode20 = this.getTVAPeriode(todayDate, typePeriode, "TVA_20", idGRAND);
            final double totalTVAPeriode0 = this.getTVAPeriode(todayDate, typePeriode, "TVA_0", idGRAND);
            final double totalTVAPeriode_7_7 = this.getTVAPeriode(todayDate, typePeriode, "TVA_7_7", idGRAND);
            final double totalTVAPeriode_2_5 = this.getTVAPeriode(todayDate, typePeriode, "TVA_2_5", idGRAND);
            final double totalTVAPeriode_2_1 = this.getTVAPeriode(todayDate, typePeriode, "TVA_2_1", idGRAND);
            final double totalTVAPeriode_8_5 = this.getTVAPeriode(todayDate, typePeriode, "TVA_8_5", idGRAND);
            final double totalTVAPeriode_6 = this.getTVAPeriode(todayDate, typePeriode, "TVA_6", idGRAND);
            final double totalTVAPeriode_12 = this.getTVAPeriode(todayDate, typePeriode, "TVA_12", idGRAND);
            final double totalTVAPeriode_21 = this.getTVAPeriode(todayDate, typePeriode, "TVA_21", idGRAND);
            final double totalTVAPeriode_8_1 = this.getTVAPeriode(todayDate, typePeriode, "TVA_8_1", idGRAND);
            final double totalTVAPeriode_2_6 = this.getTVAPeriode(todayDate, typePeriode, "TVA_2_6", idGRAND);
            double cumuleABS = this.getCumulePeriodeABS(todayDate, typePeriode, false);
            double cumul_after_perpatual_reset = cumule;
            double cumulABS_after_perpatual_reset = cumuleABS;
            MarqueNFC marqueNFC = this.getMarqueNF();
            boolean bl = before_perpetual_reset = marqueNFC != null && marqueNFC.getUpdate_siret_at() != null && marqueNFC.getUpdate_siret_at().after(dateEnd);
            if (!before_perpetual_reset && marqueNFC != null && marqueNFC.getUpdate_siret_at() != null) {
                cumul_after_perpatual_reset = this.getCumulePeriode(todayDate, typePeriode, true, idGRAND);
                cumulABS_after_perpatual_reset = this.getCumulePeriodeABS(todayDate, typePeriode, true);
            }
            double cumulPerpetualAnnual = 0.0;
            double cumulPerpetualReelAnnual = 0.0;
            if (typePeriode.equals("a") && (lastMonthlygtp = this.getLastMonthlyGrandTotalPeriode(todayDate)) != null) {
                cumulPerpetualAnnual = lastMonthlygtp.getCumulPerpetual();
                cumulPerpetualReelAnnual = lastMonthlygtp.getCumulPerpetualReel();
            }
            double d = typePeriode.equals("a") ? cumulPerpetualAnnual : (before_perpetual_reset ? cumulPerpetualPrevious + Math.abs(cumuleABS) : (cumulPerpetual = lastGTP_before_perpetual_reset ? Math.abs(cumulABS_after_perpatual_reset) : cumulPerpetualPrevious + Math.abs(cumulABS_after_perpatual_reset)));
            final double cumulPerpetualReel = typePeriode.equals("a") ? cumulPerpetualReelAnnual : (before_perpetual_reset ? NumericUtils.round(cumulPerpetualReelPrevious + cumule) : (lastGTP_before_perpetual_reset ? cumul_after_perpatual_reset : cumulPerpetualReelPrevious + cumul_after_perpatual_reset));
            this.addTvaToSignature(builderEmprinteGrandPeriode, totalTVAPeriode5, totalTVAPeriode10, totalTVAPeriode20, totalTVAPeriode0, totalTVAPeriode_7_7, totalTVAPeriode_2_5, totalTVAPeriode_2_1, totalTVAPeriode_8_5, totalTVAPeriode_6, totalTVAPeriode_12, totalTVAPeriode_21, totalTVAPeriode_8_1, totalTVAPeriode_2_6);
            builderEmprinteGrandPeriode.append(",").append((long)NumericUtils.round(NumericUtils.round(cumule) * 100.0)).append(",").append((long)NumericUtils.round(NumericUtils.round(cumulPerpetualReel * 100.0))).append(",").append(com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(thisTimeStampe)).append(",").append(idGRAND);
            boolean hasPreviousSignature = false;
            if (previousSignature == null) {
                builderEmprinteGrandPeriode.append(",N,");
            } else {
                hasPreviousSignature = true;
                builderEmprinteGrandPeriode.append(",O,").append(previousSignature);
            }
            String regVar = "";
            switch (typePeriode) {
                case "j": {
                    regVar = "gtpdj";
                    break;
                }
                case "m": {
                    regVar = "gtpdm";
                    break;
                }
                case "a": {
                    regVar = "gtpda";
                }
            }
            if (!hasPreviousSignature) {
                this.detecter.detectDeletion(regVar, "");
            } else {
                this.detecter.detectDeletion(regVar, previousSignature);
            }
            final String signature = DataLogicSales.signer(builderEmprinteGrandPeriode.toString());
            new PreparedSentence(this.s, "INSERT INTO GRAND_TOTAL_PERIODE (id, grand_total, grand_total_Perpetual, TVA_5_5, TVA_10, TVA_20, type_periode , signature,   timestampGDH ,horodatage, grand_total_Perpetual_reel,  CASH_TOTAL, CB_TOTAL, TR_TOTAL, DEBIT_TOTAL, CREDIT_EMPLOYEE_TOTAL, LOYALTY_CARD, CASHDRO_TOTAL, CACH_GLORY_TOTAL, VIRMENT_TOTAL, CHEQUE_TOTAL, AVOIR_DECAISSE_TOTAL, AVOIR_ENCAISSE_TOTAL,  TVA_5_5_HT, TVA_10_HT, TVA_20_HT, NUMBER_ORDERS, NUMBER_PRODUCTS_SOLD,  TURNOVER_CANCELED, TOTAL_ORDERS_AT_SPOT, TOTAL_ORDERS_TAKE_AWAY, TOTAL_ORDERS_DELIVERY, TOTAL_ORDERS_UBER, TOTAL_ORDERS_DELIVERO, NUMBER_CB, NUMBER_TR, TOTAL_DISCOUNT, TOTAL_DISCOUNT_LINES, INSERT_FINANCIAL_INFOS, TOTAL_ORDERS_JUST_EAT, TVA_0, TVA_0_HT, TOTAL_ORDERS_DRIVE, TVA_7_7, TVA_2_5, TVA_2_1, TVA_8_5, TVA_7_7_HT, TVA_2_5_HT, TVA_2_1_HT, TVA_8_5_HT, TWINT_TOTAL, TOTAL_ORDERS_SMOOD, CHEQUE_VACANCES_TOTAL, BEFORE_PERPETUAL_RESET, ISSYNCHRONIZED, ROUND_AMOUNT, TURNOVER_PLATFORM, NUMBER_ORDERS_PLATFORM, TOTAL_ORDERS_DELIVEROO,  TVA_6, TVA_12, TVA_21, TVA_6_HT, TVA_12_HT, TVA_21_HT, TURNOVER_UBEREAT, TOTAL_ORDERS_DISHOP, STRIPE_TOTAL, CASH_LOGY_TOTAL, TVA_8_1, TVA_2_6, TVA_8_1_HT, TVA_2_6_HT, TPS, TVQ, CREDIT_CARD_TOTAL, DEBIT_CARD_TOTAL, TOTAL_HT_TAXABLE, TOTAL_HT_NO_TAXABLE,  TOTAL_HT_ORDERS_AT_SPOT, TOTAL_HT_ORDERS_TAKE_AWAY, TOTAL_HT_ORDERS_DELIVERY, TOTAL_HT_ORDERS_DRIVE, NUMBER_ORDERS_AT_SPOT, NUMBER_ORDERS_TAKE_AWAY, NUMBER_ORDERS_DELIVERY, NUMBER_ORDERS_DRIVE, CARTE_TR_TOTAL, BANK_TRANSFER_TOTAL, NUMBER_CARTE_TR) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, idGRAND);
                    this.setDouble(2, NumericUtils.round(cumule));
                    this.setDouble(3, NumericUtils.round(cumulPerpetual));
                    this.setDouble(4, NumericUtils.round(totalTVAPeriode5));
                    this.setDouble(5, NumericUtils.round(totalTVAPeriode10));
                    this.setDouble(6, NumericUtils.round(totalTVAPeriode20));
                    this.setString(7, typePeriode);
                    this.setString(8, signature);
                    this.setTimestamp(9, thisTimeStampe);
                    this.setString(10, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(thisTimeStampe));
                    this.setDouble(11, NumericUtils.round(cumulPerpetualReel));
                    this.setDouble(12, NumericUtils.round((Double)map_infos.get("CASH_TOTAL")));
                    this.setDouble(13, NumericUtils.round((Double)map_infos.get("CB_TOTAL")));
                    this.setDouble(14, NumericUtils.round((Double)map_infos.get("TR_TOTAL")));
                    this.setDouble(15, NumericUtils.round((Double)map_infos.get("DEBIT_TOTAL")));
                    this.setDouble(16, NumericUtils.round((Double)map_infos.get("CREDIT_EMPLOYEE_TOTAL")));
                    this.setDouble(17, NumericUtils.round((Double)map_infos.get("LOYALTY_CARD")));
                    this.setDouble(18, NumericUtils.round((Double)map_infos.get("CASHDRO_TOTAL")));
                    this.setDouble(19, NumericUtils.round((Double)map_infos.get("CACH_GLORY_TOTAL")));
                    this.setDouble(20, NumericUtils.round((Double)map_infos.get("VIRMENT_TOTAL")));
                    this.setDouble(21, NumericUtils.round((Double)map_infos.get("CHEQUE_TOTAL")));
                    this.setDouble(22, NumericUtils.round((Double)map_infos.get("AVOIR_TOTAL_DECAISSE")));
                    this.setDouble(23, NumericUtils.round((Double)map_infos.get("AVOIR_TOTAL_ENCAISSE")));
                    this.setDouble(24, NumericUtils.round((Double)map_infos.get("TVA_5_5_HT")));
                    this.setDouble(25, NumericUtils.round((Double)map_infos.get("TVA_10_HT")));
                    this.setDouble(26, NumericUtils.round((Double)map_infos.get("TVA_20_HT")));
                    this.setInt(27, (Integer)map_infos.get("NUMBER_ORDERS"));
                    this.setDouble(28, NumericUtils.round((Double)map_infos.get("NUMBER_PRODUCTS_SOLD")));
                    this.setDouble(29, NumericUtils.round((Double)map_infos.get("TURNOVER_CANCELED")));
                    this.setDouble(30, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_AT_SPOT")));
                    this.setDouble(31, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_TAKE_AWAY")));
                    this.setDouble(32, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_DELIVERY")));
                    this.setDouble(33, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_UBER")));
                    this.setDouble(34, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_DELIVERO")));
                    this.setInt(35, (Integer)map_infos.get("NUMBER_CB"));
                    this.setInt(36, (Integer)map_infos.get("NUMBER_TR"));
                    this.setDouble(37, NumericUtils.round((Double)map_infos.get("TOTAL_DISCOUNT")));
                    this.setDouble(38, NumericUtils.round((Double)map_infos.get("TOTAL_DISCOUNT_LINES")));
                    this.setBoolean(39, true);
                    this.setDouble(40, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_JUST_EAT")));
                    this.setDouble(41, NumericUtils.round(totalTVAPeriode0));
                    this.setDouble(42, NumericUtils.round((Double)map_infos.get("TVA_0_HT")));
                    this.setDouble(43, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_DRIVE")));
                    this.setDouble(44, NumericUtils.round(totalTVAPeriode_7_7));
                    this.setDouble(45, NumericUtils.round(totalTVAPeriode_2_5));
                    this.setDouble(46, NumericUtils.round(totalTVAPeriode_2_1));
                    this.setDouble(47, NumericUtils.round(totalTVAPeriode_8_5));
                    this.setDouble(48, NumericUtils.round((Double)map_infos.get("TVA_7_7_HT")));
                    this.setDouble(49, NumericUtils.round((Double)map_infos.get("TVA_2_5_HT")));
                    this.setDouble(50, NumericUtils.round((Double)map_infos.get("TVA_2_1_HT")));
                    this.setDouble(51, NumericUtils.round((Double)map_infos.get("TVA_8_5_HT")));
                    this.setDouble(52, NumericUtils.round((Double)map_infos.get("TWINT_TOTAL")));
                    this.setDouble(53, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_SMOOD")));
                    this.setDouble(54, NumericUtils.round((Double)map_infos.get("CHEQUE_VACANCES_TOTAL")));
                    this.setBoolean(55, before_perpetual_reset);
                    this.setBoolean(56, false);
                    this.setBoolean(57, true);
                    this.setDouble(58, NumericUtils.round((Double)map_infos.get("TURNOVER_PLATFORM")));
                    this.setInt(59, (Integer)map_infos.get("NUMBER_ORDERS_PLATFORM"));
                    this.setDouble(60, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_DELIVEROO")));
                    this.setDouble(61, NumericUtils.round(totalTVAPeriode_6));
                    this.setDouble(62, NumericUtils.round(totalTVAPeriode_12));
                    this.setDouble(63, NumericUtils.round(totalTVAPeriode_21));
                    this.setDouble(64, NumericUtils.round((Double)map_infos.get("TVA_6_HT")));
                    this.setDouble(65, NumericUtils.round((Double)map_infos.get("TVA_12_HT")));
                    this.setDouble(66, NumericUtils.round((Double)map_infos.get("TVA_21_HT")));
                    this.setDouble(67, NumericUtils.round((Double)map_infos.get("TURNOVER_UBEREAT")));
                    this.setDouble(68, NumericUtils.round((Double)map_infos.get("TOTAL_ORDERS_DISHOP")));
                    this.setDouble(69, NumericUtils.round((Double)map_infos.get("STRIPE_TOTAL")));
                    this.setDouble(70, NumericUtils.round((Double)map_infos.get("CASH_LOGY_TOTAL")));
                    this.setDouble(71, NumericUtils.round(totalTVAPeriode_8_1));
                    this.setDouble(72, NumericUtils.round(totalTVAPeriode_2_6));
                    this.setDouble(73, NumericUtils.round((Double)map_infos.get("TVA_8_1_HT")));
                    this.setDouble(74, NumericUtils.round((Double)map_infos.get("TVA_2_6_HT")));
                    this.setDouble(75, NumericUtils.round((Double)map_infos.get("TPS")));
                    this.setDouble(76, NumericUtils.round((Double)map_infos.get("TVQ")));
                    this.setDouble(77, NumericUtils.round((Double)map_infos.get("CREDIT_CARD_TOTAL")));
                    this.setDouble(78, NumericUtils.round((Double)map_infos.get("DEBIT_CARD_TOTAL")));
                    this.setDouble(79, NumericUtils.round((Double)map_infos.get("TOTAL_HT_TAXABLE")));
                    this.setDouble(80, NumericUtils.round((Double)map_infos.get("TOTAL_HT_NO_TAXABLE")));
                    this.setDouble(81, NumericUtils.round((Double)map_infos.get("TOTAL_HT_ORDERS_AT_SPOT")));
                    this.setDouble(82, NumericUtils.round((Double)map_infos.get("TOTAL_HT_ORDERS_TAKE_AWAY")));
                    this.setDouble(83, NumericUtils.round((Double)map_infos.get("TOTAL_HT_ORDERS_DELIVERY")));
                    this.setDouble(84, NumericUtils.round((Double)map_infos.get("TOTAL_HT_ORDERS_DRIVE")));
                    this.setInt(85, (Integer)map_infos.get("NUMBER_ORDERS_AT_SPOT"));
                    this.setInt(86, (Integer)map_infos.get("NUMBER_ORDERS_TAKE_AWAY"));
                    this.setInt(87, (Integer)map_infos.get("NUMBER_ORDERS_DELIVERY"));
                    this.setInt(88, (Integer)map_infos.get("NUMBER_ORDERS_DRIVE"));
                    this.setDouble(89, NumericUtils.round((Double)map_infos.get("CARTE_TR_TOTAL")));
                    this.setDouble(90, NumericUtils.round((Double)map_infos.get("BANK_TRANSFER_TOTAL")));
                    this.setInt(91, (Integer)map_infos.get("NUMBER_CARTE_TR"));
                }
            });
            this.detecter.pushToRegistre(regVar, signature);
            try {
                switch (typePeriode) {
                    case "j": {
                        String annee = idGRAND.substring(0, 4);
                        String mois = idGRAND.substring(4, 6);
                        String jour = idGRAND.substring(6, idGRAND.length());
                        this.lastCloturedday = Integer.valueOf(idGRAND);
                        Journal.writeToJET(new Event(50, "Cloture journali\u00e8re", idUser, "Jour clotur\u00e9", thisTimeStampe.getTime(), annee + "-" + mois + "-" + jour));
                        break;
                    }
                    case "m": {
                        String annee = idGRAND.substring(0, 4);
                        String mois = idGRAND.substring(4, idGRAND.length());
                        Journal.writeToJET(new Event(50, "Cloture de pr\u00e9iode", idUser, "Mois clotur\u00e9", thisTimeStampe.getTime(), this.getMonthForInt(new Integer(mois) - 1) + " " + annee));
                        break;
                    }
                    case "a": {
                        String annee = idGRAND;
                        Journal.writeToJET(new Event(60, "Cloture d'exercice", idUser, "Ann\u00e9e clotur\u00e9e", thisTimeStampe.getTime(), annee));
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            List taxes = (List)map_infos.get("TAXES");
            if (taxes != null && !taxes.isEmpty()) {
                for (GroupedTax taxe : taxes) {
                    taxe.setId_period(idGRAND);
                    taxe.setType_periode(typePeriode);
                    this.addGTPTaxes(taxe);
                }
            }
        }
    }

    public final Double getCumulePeriode(Date myDate, String typePeriode, boolean after_perpetual_reset, String date_periode) throws BasicException {
        String request = after_perpetual_reset ? " AND t.BEFORE_PERPETUAL_RESET = 0 " : "";
        int myYear = myDate.getYear() + 1900;
        if (typePeriode != null && typePeriode.equals("j")) {
            int myDay = myDate.getDate();
            int myMonth = myDate.getMonth() + 1;
            Object[] recsales = null;
            if (typePeriode.equals("j")) {
                final Date dateEnd = new Date();
                final Date dateStart = new Date(myDate.getTime());
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                String query = "SELECT SUM ( t.grand_total) FROM grand_total t WHERE t.timestampGDH >= ? AND t.timestampGDH < ? " + request;
                recsales = (Object[])new StaticSentence(this.s, query, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setTimestamp(1, dateStart);
                        this.setTimestamp(2, dateEnd);
                    }
                });
            }
            if (recsales == null) {
                return null;
            }
            return (Double)recsales[0];
        }
        return this.getCumulePeriode(date_periode, "grand_total", after_perpetual_reset, typePeriode);
    }

    public ArchivPeriode getLastArchivPeriode(String typePeriode) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestArchivPeriode + "FROM ARCHIV_PERIODE where type_PERIODE = ? order by CAST(id AS INTEGER) desc FETCH FIRST 1 rows only  ", SerializerWriteString.INSTANCE, ArchivPeriode.getSerializerRead()).list((Object)typePeriode);
        if (listTotaux.size() > 0) {
            return (ArchivPeriode)listTotaux.get(0);
        }
        return null;
    }

    public GrandTotalPeriode getGrandTotalPeriodeById(String id) throws BasicException {
        GrandTotalPeriode listTotaux = (GrandTotalPeriode)new PreparedSentence(this.s, this.requestGTP + " where id = ?  ", SerializerWriteString.INSTANCE, GrandTotalPeriode.getSerializerRead()).find((Object)id);
        if (listTotaux != null) {
            return listTotaux;
        }
        return null;
    }

    public final List<Facture> getFacturesByPeriode(String typePeriode, Date myDate) throws BasicException {
        List<Facture> factures = new ArrayList();
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        factures = new PreparedSentence(this.s, this.requestFacture + "JOIN GRAND_TOTAL G ON F.ticket = G.ticket WHERE  F.date_created>= ?  and F.date_created < ? ORDER BY F.id  ", SerializerWriteParams.INSTANCE, Facture.getSerializerReadWtithTvas()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (Facture facture : factures) {
            this.setInfoFacture(facture);
        }
        return factures;
    }

    public final List<TicketInfo> getTicketsByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        List tickets = new PreparedSentence(this.s, this.requestTicket + "LEFT OUTER JOIN GRAND_TOTAL G ON G.ticket = T.ID WHERE G.timestampGDH >= ? and  G.timestampGDH < ?   ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public List<TotaleEncaissement> getTotalEncaissementByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestTotalEncaissement + "LEFT JOIN TICKETS as T ON E.ticket = T.ID LEFT JOIN GRAND_TOTAL as G on G.ticket = T.ID WHERE G.timestampGDH >= ? and  G.timestampGDH < ?   ", SerializerWriteParams.INSTANCE, TotaleEncaissement.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<GrandTotalTicket> getGrandTotalTicketByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestGrandToTalTicket + "FROM GRAND_TOTAL WHERE  timestampGDH >= ? and timestampGDH < ?  order by timestampGDH ", SerializerWriteParams.INSTANCE, GrandTotalTicket.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public synchronized void insertArchivagePeriode(final GrandTotalPeriode grandTotalPeriode, final String signature, final String chemin, String idUser) throws BasicException {
        ArchivPeriode lastArchv = this.getArchivPeriodeById(grandTotalPeriode.getId());
        if (lastArchv == null) {
            final Date d = new Date();
            String regVar = "";
            switch (grandTotalPeriode.getTypePeriode()) {
                case "j": {
                    regVar = "archj";
                    break;
                }
                case "m": {
                    regVar = "archm";
                    break;
                }
                case "a": {
                    regVar = "archa";
                }
            }
            new PreparedSentence(this.s, "INSERT INTO ARCHIV_PERIODE (id, grand_total, grand_total_Perpetual, TVA_5_5, TVA_10, TVA_20, type_periode , signature,   timestampGDH, chemin, horodatage, TVA_0, TVA_7_7, TVA_2_5, TVA_2_1, TVA_8_5, ROUND_AMOUNT, TVA_6, TVA_12, TVA_21, TVA_8_1, TVA_2_6) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, grandTotalPeriode.getId());
                    this.setDouble(2, NumericUtils.round(grandTotalPeriode.getCumul()));
                    this.setDouble(3, NumericUtils.round(grandTotalPeriode.getCumulPerpetual()));
                    this.setDouble(4, NumericUtils.round(grandTotalPeriode.getTva5()));
                    this.setDouble(5, NumericUtils.round(grandTotalPeriode.getTva10()));
                    this.setDouble(6, NumericUtils.round(grandTotalPeriode.getTva20()));
                    this.setString(7, grandTotalPeriode.getTypePeriode());
                    this.setString(8, signature);
                    this.setTimestamp(9, d);
                    this.setString(10, chemin);
                    this.setString(11, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(d));
                    this.setDouble(12, NumericUtils.round(grandTotalPeriode.getTva0()));
                    this.setDouble(13, NumericUtils.round(grandTotalPeriode.getTva_7_7()));
                    this.setDouble(14, NumericUtils.round(grandTotalPeriode.getTva_2_5()));
                    this.setDouble(15, NumericUtils.round(grandTotalPeriode.getTva_2_1()));
                    this.setDouble(16, NumericUtils.round(grandTotalPeriode.getTva_8_5()));
                    this.setBoolean(17, true);
                    this.setDouble(18, NumericUtils.round(grandTotalPeriode.getTva_6()));
                    this.setDouble(19, NumericUtils.round(grandTotalPeriode.getTva_12()));
                    this.setDouble(20, NumericUtils.round(grandTotalPeriode.getTva_21()));
                    this.setDouble(21, NumericUtils.round(grandTotalPeriode.getTva_8_1()));
                    this.setDouble(22, NumericUtils.round(grandTotalPeriode.getTva_2_6()));
                }
            });
            this.detecter.pushToRegistre(regVar, signature);
            try {
                switch (grandTotalPeriode.getTypePeriode()) {
                    case "j": {
                        Date dateEnd = new Date();
                        Date dateStart = com.openbravo.pos.util.DateUtils.SDF_YYYYMMDD.parse(grandTotalPeriode.getId());
                        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        Journal.writeToJET(new Event(20, "Archivage fiscal de p\u00e9riode", idUser, "P\u00e9riode concern\u00e9e", d.getTime(), "de " + sdf.format(dateStart) + " \u00e0 " + sdf.format(dateEnd)));
                        break;
                    }
                    case "m": {
                        String annee = grandTotalPeriode.getId().substring(0, 4);
                        String mois = grandTotalPeriode.getId().substring(4, grandTotalPeriode.getId().length());
                        Journal.writeToJET(new Event(20, "Archivage fiscal de p\u00e9riode", idUser, "P\u00e9riode concern\u00e9e", d.getTime(), this.getMonthForInt(new Integer(mois) - 1) + " " + annee));
                        break;
                    }
                    case "a": {
                        String annee = grandTotalPeriode.getId();
                        Journal.writeToJET(new Event(30, "Archivage fiscal d'exercice ", idUser, "P\u00e9riode de l'Archivage", d.getTime(), annee));
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void addOptionLine(OptionItemOrder supplement, int idLine) throws SQLException {
        try {
            String SQL = "INSERT INTO Option_ticket (idCarte, nameCarte, idProduct, nameProduct, idOption, nameOption, idTicketLine, numberoption, is_bold, price, index_carte, number_free, separate, multiple, weight, display_free, force_free, printer, order_option, shift_option, NO_PRINTABLE, parent_supplement_id, TAX_ID, HT_AMOUNT, TAX_AMOUNT, FULL_PRICE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
            this.pstmt.setInt(1, supplement.getIdCarte());
            this.pstmt.setString(2, supplement.getNameCarte());
            this.pstmt.setInt(3, supplement.getIdProduct());
            this.pstmt.setString(4, supplement.getNameProduct());
            this.pstmt.setInt(5, supplement.getSupplement());
            this.pstmt.setString(6, supplement.getNameSupplement());
            this.pstmt.setInt(7, idLine);
            this.pstmt.setInt(8, supplement.getNumberOption());
            this.pstmt.setBoolean(9, supplement.getIsBold());
            this.pstmt.setDouble(10, supplement.getPrice());
            this.pstmt.setInt(11, supplement.getIndex_carte());
            this.pstmt.setInt(12, supplement.getNumber_free());
            this.pstmt.setBoolean(13, supplement.isSeparate());
            this.pstmt.setBoolean(14, supplement.isMultiple());
            this.pstmt.setString(15, supplement.getWeight());
            this.pstmt.setBoolean(16, supplement.isDisplay_free());
            this.pstmt.setBoolean(17, supplement.isForce_free());
            this.pstmt.setInt(18, supplement.getPrinter());
            this.pstmt.setInt(19, supplement.getOrder_option());
            this.pstmt.setInt(20, supplement.getShift_option());
            this.pstmt.setBoolean(21, supplement.isNo_printable());
            this.pstmt.setInt(22, supplement.getParent_supplement_id());
            this.pstmt.setString(23, supplement.getTaxId());
            this.pstmt.setDouble(24, NumericUtils.round(supplement.getHtAmount()));
            this.pstmt.setDouble(25, NumericUtils.round(supplement.getTaxAmount()));
            this.pstmt.setDouble(26, NumericUtils.round(supplement.getFull_price()));
            this.pstmt.executeUpdate();
            ResultSet rs = this.pstmt.getGeneratedKeys();
            int id_option = 0;
            if (rs.next()) {
                int last_inserted_id;
                id_option = last_inserted_id = rs.getInt(1);
                supplement.setId(id_option);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void addMaintenanceOperation(final String operationName, final Date dateStartMaintenance, final Date dateEndMaintenance, final boolean finiched) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO Maintenance_Operation (  operation_Name, date_Start, date_end, finiched) VALUES( ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, operationName);
                this.setTimestamp(2, dateStartMaintenance);
                this.setTimestamp(3, dateEndMaintenance);
                this.setBoolean(4, finiched);
            }
        });
    }

    public MaintenanceOperation getLastMaintenanceOperation() throws BasicException {
        List operations = new PreparedSentence(this.s, "SELECT  id, operation_Name, date_Start, date_end, finiched FROM Maintenance_Operation ORDER BY id desc  FETCH FIRST 1 rows only", null, MaintenanceOperation.getSerializerRead()).list();
        if (operations.size() > 0) {
            return (MaintenanceOperation)operations.get(0);
        }
        return null;
    }

    public void updateMaintenanceOperation(final MaintenanceOperation maintenanceOperation) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  Maintenance_Operation SET operation_Name = ? , date_Start= ? , date_end = ? , finiched = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, maintenanceOperation.getOperationName());
                this.setTimestamp(2, maintenanceOperation.getDateStartMAintenance());
                this.setTimestamp(3, maintenanceOperation.getDateEndMaintenance());
                this.setBoolean(4, maintenanceOperation.isFiniched());
                this.setInt(5, (int)maintenanceOperation.getId());
            }
        });
    }

    public String getMonthForInt(int num) {
        String month = "wrong";
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.FRANCE);
        String[] months = dfs.getMonths();
        if (num >= 0 && num <= 11) {
            month = months[num];
        }
        return month;
    }

    public Duplicata getDuplicataByIdDoc(final String idDoc, final String type_doc) throws BasicException {
        Duplicata duplicata = (Duplicata)new PreparedSentence(this.s, this.requestDuplicata + " where id_Doc = ? and type_doc = ? ORDER BY date_impression desc", SerializerWriteParams.INSTANCE, Duplicata.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idDoc);
                this.setString(2, type_doc);
            }
        });
        return duplicata;
    }

    public final List<TicketInfo> loadTicketMonth(final int year, final int month) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND YEAR(R.DATENEW) = ? AND MONTH(R.DATENEW) = ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public void addLog(final LogPanier panier) throws BasicException {
        System.out.println("******* addLog");
        new PreparedSentence(this.s, "INSERT INTO LOG_PANIER (user_delete, numero_order, multiply, price, nameProduct, discount, label_discount,validate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, panier.getIdUser());
                this.setInt(2, panier.getNumero_order());
                this.setDouble(3, panier.getMultiply());
                this.setDouble(4, panier.getPrice());
                this.setString(5, panier.getNameProduct());
                this.setDouble(6, panier.getDiscount());
                this.setString(7, panier.getLabelDiscount());
                this.setBoolean(8, panier.isValidate());
            }
        });
    }

    public final List<LogPanier> loadLogPanier(final int year, final int month, final int day) throws BasicException {
        List paniers = new PreparedSentence(this.s, "SELECT LP.id, P.ID, P.NAME as user_name, LP.numero_order, LP.multiply, LP.price, LP.nameProduct, LP.date_delete,LP.discount, LP.label_discount, LP.validate FROM LOG_PANIER LP LEFT OUTER JOIN PEOPLE P ON LP.user_delete = P.ID WHERE YEAR(LP.date_delete) = ? AND MONTH(LP.date_delete) = ? AND DAY(LP.date_delete) = ? ORDER BY LP.date_delete desc ", SerializerWriteParams.INSTANCE, LogPanier.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        return paniers;
    }

    public final List<LogPanier> loadNotSynchLogPanier() throws BasicException {
        List paniers = new PreparedSentence(this.s, "SELECT LP.id, P.ID, P.NAME as user_name, LP.numero_order, LP.multiply, LP.price, LP.nameProduct, LP.date_delete,LP.discount, LP.label_discount, LP.validate FROM LOG_PANIER LP LEFT OUTER JOIN PEOPLE P ON LP.user_delete = P.ID WHERE  IS_SYNCHRO = ? ORDER BY LP.date_delete desc ", SerializerWriteParams.INSTANCE, LogPanier.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, false);
            }
        });
        return paniers;
    }

    public final List<LogPanier> loadLogPanier(final Date date_start, final Date date_finish) throws BasicException {
        List paniers = new PreparedSentence(this.s, "SELECT LP.id, P.ID, P.NAME as user_name, LP.numero_order, LP.multiply, LP.price, LP.nameProduct, LP.date_delete,LP.discount, LP.label_discount, LP.validate FROM LOG_PANIER LP LEFT OUTER JOIN PEOPLE P ON LP.user_delete = P.ID WHERE LP.date_delete >= ? AND LP.date_delete <= ?  ORDER BY LP.date_delete desc ", SerializerWriteParams.INSTANCE, LogPanier.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, date_start);
                this.setTimestamp(2, date_finish);
            }
        });
        return paniers;
    }

    public void addIngredientLine(ItemOrderInfo ingredient, int idLine) throws SQLException {
        String SQL = "INSERT INTO ingredient_ticket (idCarte, nameCarte, idProduct, nameProduct, idIngredient, nameIngredient, idTicketLine, index_carte) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setInt(1, ingredient.getIdCarte());
        this.pstmt.setString(2, ingredient.getNameCarte());
        this.pstmt.setInt(3, ingredient.getIdProduct());
        this.pstmt.setString(4, ingredient.getNameProduct());
        this.pstmt.setInt(5, ingredient.getSupplement());
        this.pstmt.setString(6, ingredient.getNameSupplement());
        this.pstmt.setInt(7, idLine);
        this.pstmt.setInt(8, ingredient.getIndex_carte());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int id_ingredient = 0;
        if (rs.next()) {
            int last_inserted_id;
            id_ingredient = last_inserted_id = rs.getInt(1);
        }
        ingredient.setId(id_ingredient);
    }

    public void addEntete(final MarqueNFC marqueNF, final TicketInfo ticket, final String statut, StringBuilder ticketEmprinte) throws BasicException {
        EnteteInfo lastEntete = this.getLastEntete();
        final String codeCaisse = this.getCodeCaisse();
        final int nbLine = ticket.getNbrArticles();
        System.out.println("nbLine addEntete **************** : " + nbLine);
        new PreparedSentence(this.s, "INSERT INTO ENTETE ( num_doc, nb_print, company, address, zip_code, city, country, siret, code_NAF, num_tva, code_operator, name_operator, timestampGDH, nb_lines, ticket , header_Supplementaire, footer_Supplementaire,  ticket_status, type_operation,version_soft ,nb_customer ,code_caisse,horodatage,code_remise, NAME_SOFT, USE_ID_IN_SIGNATURE, ROUND_AMOUNT) VALUES(?, ?, ?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, String.valueOf(DataLogicSales.this.idDocument));
                this.setInt(2, 0);
                this.setString(3, marqueNF.getCompany());
                this.setString(4, marqueNF.getAdresse1());
                this.setString(5, marqueNF.getZipCode());
                this.setString(6, marqueNF.getCity());
                this.setString(7, marqueNF.getCountry());
                this.setString(8, marqueNF.getSiret());
                this.setString(9, marqueNF.getCodeNAF());
                this.setString(10, marqueNF.getIntraTVA());
                this.setString(11, ticket.getUser().getId());
                this.setString(12, ticket.getUser().getName());
                this.setTimestamp(13, ticket.getLastUpdate());
                this.setInt(14, nbLine);
                this.setString(15, ticket.getId());
                this.setString(16, AppLocal.header);
                this.setString(17, AppLocal.footer);
                if (ticket.getTicketType() == 1) {
                    this.setString(18, "Canceled");
                    this.setString(19, "Annulation");
                } else {
                    this.setString(18, statut);
                    this.setString(19, "Vente");
                }
                this.setString(20, "10.0.1.27");
                this.setInt(21, 1);
                this.setString(22, codeCaisse);
                this.setString(23, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getLastUpdate()));
                this.setBoolean(24, ticket.getTypeDiscount().equalsIgnoreCase("pourcentage"));
                this.setString(25, "BIBORNE");
                this.setBoolean(26, true);
                this.setBoolean(27, true);
            }
        });
        final EnteteInfo thisEntete = this.getLastEntete();
        ticketEmprinte.append(",").append((long)((double)this.multiplyPositif(ticket) * NumericUtils.round(NumericUtils.round(ticket.getTotal()) * 100.0)));
        ticketEmprinte.append(",").append(com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getLastUpdate()));
        ticketEmprinte.append(",").append(thisEntete.getId());
        ticketEmprinte.append(",").append(thisEntete.getTypeOperation().replace(',', '<'));
        if (lastEntete == null) {
            ticketEmprinte.append(",N,");
        } else {
            ticketEmprinte.append(",O,");
            ticketEmprinte.append(lastEntete.getSignature());
        }
        String[] tab = ticketEmprinte.toString().split(",");
        if (tab[tab.length - 1].equals("N")) {
            this.detecter.detectDeletion("ent", "");
        } else {
            this.detecter.detectDeletion("ent", tab[tab.length - 1]);
        }
        System.out.println("emprint entete : " + ticketEmprinte.toString());
        final String signature = DataLogicSales.signer(ticketEmprinte.toString());
        new PreparedSentence(this.s, "UPDATE  ENTETE SET signature_Ticket = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, signature);
                this.setInt(2, Integer.parseInt(thisEntete.getId()));
            }
        });
        this.detecter.pushToRegistre("ent", signature);
    }

    public void addEntete(final TicketInfo ticket, String statut, StringBuilder ticketEmprinte) throws BasicException {
        String[] tab = ticketEmprinte.toString().split(",");
        final String codeCaisse = this.getCodeCaisse();
        if (tab[tab.length - 1].equals("N")) {
            this.detecter.detectDeletion("ent", "");
        } else {
            this.detecter.detectDeletion("ent", tab[tab.length - 1]);
        }
        final String signature = DataLogicSales.signer(ticketEmprinte.toString());
        final int nbLine = ticket.getNbrArticles();
        new PreparedSentence(this.s, "INSERT INTO ENTETE ( num_doc, nb_print, code_operator, name_operator, timestampGDH, nb_lines, ticket, header_Supplementaire, footer_Supplementaire, ticket_status, signature_Ticket , version_soft ,nb_customer , code_caisse ,type_operation,horodatage,code_remise, NAME_SOFT) VALUES(?, ?, ?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?,?, ?,? ,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, String.valueOf(DataLogicSales.this.idDocument));
                this.setInt(2, 0);
                this.setString(3, ticket.getUser().getId());
                this.setString(4, ticket.getUser().getName());
                this.setTimestamp(5, ticket.getLastUpdate());
                this.setInt(6, nbLine);
                this.setString(7, ticket.getId());
                this.setString(8, AppLocal.header);
                this.setString(9, AppLocal.footer);
                this.setString(10, ticket.getStatus());
                this.setString(11, signature);
                this.setString(12, "10.0.1.27");
                this.setInt(13, 1);
                this.setString(14, codeCaisse);
                if (ticket.getTicketType() == 1) {
                    this.setString(15, "Annulation");
                } else {
                    this.setString(15, "Vente");
                }
                this.setString(16, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getLastUpdate()));
                this.setBoolean(17, ticket.getTypeDiscount().equalsIgnoreCase("pourcentage"));
                this.setString(18, "BIBORNE");
            }
        });
        this.detecter.pushToRegistre("ent", signature);
    }

    public final List<PhotoDispaly> getPubPhoto() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, path, REF_SYNCH FROM PHOTO_PUB_BORNE ORDER BY ID ", null, PhotoDispaly.getSerializerRead()).list();
    }

    public final List<PhotoDispaly> getHomeBornePhoto() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, path, REF_SYNCH, LAST_UPDATE FROM PHOTO_HOME_BORNE ORDER BY ID ", null, PhotoDispaly.getSerializerReadHome()).list();
    }

    public void addPubPhoto(final PhotoDispaly photo) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PHOTO_PUB_BORNE(path) VALUES(?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, photo.getPath());
            }
        });
    }

    public void deletePubPhoto(final int id) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PHOTO_PUB_BORNE WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    public void addHomeBornePhoto(final PhotoDispaly photo) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PHOTO_HOME_BORNE(path, LAST_UPDATE) VALUES(?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, photo.getPath());
                this.setTimestamp(2, photo.getLast_update());
            }
        });
    }

    public void deleteHomeBornePhoto(final int id) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PHOTO_HOME_BORNE WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    public List<ProductInfoExt> getAdditionnalProductsByType(String type_order, TagInfo mTagInfo) throws BasicException {
        String request = type_order != null && type_order.equals("A Emporter") ? "P.ADDITIONAL_SALE_TAKE_AWAY = 1 " : "P.ADDITIONAL_SALE_AT_SPOT = 1 ";
        String request_opening_mode = AppLocal.OPENING_MODE ? " AND P.ENABLE_IN_OPENING = 1 " : "";
        String requestSql = this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.SOLD_OUT = 0 AND P.HIDDEN_BORNE = 0 AND P.PRODUCT_UBEREAT = 0 AND AVAILABLE_CAISSE = 0 AND " + request + " AND P.CATEGORY NOT IN (select ID FROM CATEGORIES WHERE REMOVED_BY_ADMIN = 1 OR removed = 1) " + request_opening_mode + this.request_campaign_product;
        if (mTagInfo != null) {
            requestSql = requestSql + " AND P.CATEGORY IN (select TC.ID_CATEGORY from TAGS_CATEGORIES TC JOIN TAGS T ON TC.ID_TAG = T.ID WHERE TC.ID_TAG = " + mTagInfo.getId() + ") ";
        }
        requestSql = requestSql + "ORDER BY  P.order_item ";
        return new PreparedSentence(this.s, requestSql, null, ProductInfoExt.getSerializerRead()).list();
    }

    public Facture getFactureById(long id) throws BasicException {
        Facture facture = (Facture)new PreparedSentence(this.s, this.requestFacture + "JOIN GRAND_TOTAL G ON F.ticket = G.ticket WHERE F.id = ? ", SerializerWriteInteger.INSTANCE, Facture.getSerializerReadWtithTvas()).find((Object)((int)id));
        this.setInfoFacture(facture);
        return facture;
    }

    public DataLogicStats getDlStats() {
        return this.dlStats;
    }

    public void setDlStats(DataLogicStats dlStats) {
        this.dlStats = dlStats;
    }

    public DataLogicItems getDlItems() {
        return this.dlItems;
    }

    public void setDlItems(DataLogicItems dlItems) {
        this.dlItems = dlItems;
    }

    public void incrementPrinterFacture(String idTicket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE FACTURE SET nb_print = 1 WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)idTicket);
    }

    public long getNumberPrintDuplicata(String id_doc, String type_doc) throws BasicException {
        Duplicata previousDuplicata = this.getDuplicataByIdDoc(id_doc, type_doc);
        long nbPrint = 1L;
        if (previousDuplicata != null) {
            nbPrint = previousDuplicata.getImpression_Number() + 1L;
        }
        return nbPrint;
    }

    public void increaseStock(final int idProduct, final double quantity, Date dateOperation, String idUser) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  PRODUCTS SET quantity = quantity + ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, quantity);
                this.setInt(2, idProduct);
            }
        });
        this.addStockHistory(idProduct, quantity, "entree", dateOperation, idUser);
    }

    public void addStockHistory(final int idProduct, final double quantity, final String typeOperation, final Date dateOperation, final String idUser) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO HISTORIQUE_STOCK(product, date_operation, type_operation, quantity, user_operator) VALUES(?,?,?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idProduct);
                this.setTimestamp(2, dateOperation);
                this.setString(3, typeOperation);
                this.setDouble(4, quantity);
                this.setString(5, idUser);
            }
        });
    }

    public void decreaseStock(final int idProduct, final double quantity, String typeOperation, Date dateOperation, String idUser) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  PRODUCTS SET quantity = quantity - ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, quantity);
                this.setInt(2, idProduct);
            }
        });
        this.addStockHistory(idProduct, quantity, typeOperation, dateOperation, idUser);
    }

    public final ProductInfoExt addProduct(ProductInfoExt product) throws BasicException, SQLException {
        String SQL = "INSERT INTO PRODUCTS (CODE, NAME, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, ORDER_ITEM, color, quantity, sp, emp, lv, bar, terasse) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, product.getCode());
        this.pstmt.setString(2, product.getName());
        this.pstmt.setDouble(3, product.getPriceBuy());
        this.pstmt.setDouble(4, product.getPriceSell());
        this.pstmt.setInt(5, product.getCategoryid());
        this.pstmt.setString(6, product.getTaxcategoryid());
        this.pstmt.setInt(7, product.getOrder_item());
        this.pstmt.setString(8, product.getColor());
        this.pstmt.setDouble(9, product.getQuantity());
        this.pstmt.setBoolean(10, product.getSp());
        this.pstmt.setBoolean(11, product.getEmp());
        this.pstmt.setBoolean(12, product.getLv());
        this.pstmt.setBoolean(13, product.getBar());
        this.pstmt.setBoolean(14, product.getTerasse());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        if (rs.next()) {
            int last_inserted_id;
            this.id_Product = last_inserted_id = rs.getInt(1);
        }
        product.setID(this.id_Product);
        product.setUnit("piece");
        return product;
    }

    public final List<StockHistoryInfo> getStockHistory(Date date) throws BasicException {
        final int year = date.getYear() + 1900;
        final int month = date.getMonth() + 1;
        final int day = date.getDate();
        List stockHistory = new PreparedSentence(this.s, "SELECT distinct P.NAME, (Select COALESCE(SUM(H1.quantity),0) From HISTORIQUE_STOCK H1 WHERE H1.product= P.ID AND H1.type_operation= 'commande' AND YEAR(H1.date_operation) = ? AND MONTH(H1.date_operation) = ? AND DAY(H1.date_operation) = ?) as commande, (Select COALESCE(SUM(H1.quantity),0) From HISTORIQUE_STOCK H1 WHERE H1.product= P.ID AND H1.type_operation= 'sortie' AND YEAR(H1.date_operation) = ? AND MONTH(H1.date_operation) = ? AND DAY(H1.date_operation) = ?) as Sortie, (Select COALESCE(SUM(H1.quantity),0) From HISTORIQUE_STOCK H1 WHERE H1.product= P.ID AND H1.type_operation= 'entree' AND YEAR(H1.date_operation) = ? AND MONTH(H1.date_operation) = ? AND DAY(H1.date_operation) = ?) as Entree, (Select COALESCE(SUM(H1.quantity),0) From HISTORIQUE_STOCK H1 WHERE H1.product= P.ID AND H1.type_operation= 'casse' AND YEAR(H1.date_operation) = ? AND MONTH(H1.date_operation) = ? AND DAY(H1.date_operation) = ?) as Casse, P.quantity FROM HISTORIQUE_STOCK as H LEFT JOIN PRODUCTS P ON H.product = P.ID WHERE YEAR(H.date_operation) = ? AND MONTH(H.date_operation) = ? AND DAY(H.date_operation) = ?", SerializerWriteParams.INSTANCE, StockHistoryInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
                this.setInt(4, year);
                this.setInt(5, month);
                this.setInt(6, day);
                this.setInt(7, year);
                this.setInt(8, month);
                this.setInt(9, day);
                this.setInt(10, year);
                this.setInt(11, month);
                this.setInt(12, day);
                this.setInt(13, year);
                this.setInt(14, month);
                this.setInt(15, day);
            }
        });
        return stockHistory;
    }

    private void changeStock(TicketInfo ticket) throws BasicException {
        String request = "";
        request = AppLocal.licence.equals("venteDetail") ? "UPDATE  PRODUCTS SET quantity = quantity + ? WHERE ID = ?" : "UPDATE  PRODUCTS SET quantity = quantity + ? WHERE STORABLE = 1 AND ID = ?";
        for (final TicketLineInfo line : ticket.getLines()) {
            new PreparedSentence(this.s, request, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setDouble(1, line.getMultiply());
                    this.setInt(2, line.getProductID());
                }
            });
        }
    }

    public ProductInfoExt addProductMaxColumns(ProductInfoExt product) throws SQLException {
        String SQL = "INSERT INTO PRODUCTS (CODE, NAME, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, order_item, sp, emp, lv, price_sp, price_emp, price_lv, price_junior, price_senior, price_mega, price_sp_junior, price_sp_senior, price_sp_mega, price_emp_junior, price_emp_senior, price_emp_mega, price_lv_junior, price_lv_senior, price_lv_mega, menu, prepared, many_size, different_price, color, TAXEMP, TAXLV, label, bar, terasse, happy_hour, price_bar, price_terasse, price_happy, price_bar_junior, price_bar_senior, price_bar_mega, price_terasse_junior, price_terasse_senior, price_terasse_mega, price_happy_junior, price_happy_senior, price_happy_mega, option_free, special_option, number_line, number_column, max_line, additional_sale, moment_product, quantity) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, product.getCode());
        this.pstmt.setString(2, product.getName());
        this.pstmt.setDouble(3, product.getPriceBuy());
        this.pstmt.setDouble(4, product.getPriceSell());
        this.pstmt.setInt(5, product.getCategoryid());
        this.pstmt.setString(6, product.getTaxcategoryid());
        this.pstmt.setInt(7, product.getOrder_item());
        this.pstmt.setBoolean(8, product.getSp());
        this.pstmt.setBoolean(9, product.getEmp());
        this.pstmt.setBoolean(10, product.getLv());
        this.pstmt.setDouble(11, product.getPrice_sp());
        this.pstmt.setDouble(12, product.getPrice_emp());
        this.pstmt.setDouble(13, product.getPrice_lv());
        this.pstmt.setDouble(14, product.getPrice_junior());
        this.pstmt.setDouble(15, product.getPrice_senior());
        this.pstmt.setDouble(16, product.getPrice_mega());
        this.pstmt.setDouble(17, product.getPrice_sp_junior());
        this.pstmt.setDouble(18, product.getPrice_sp_senior());
        this.pstmt.setDouble(19, product.getPrice_sp_mega());
        this.pstmt.setDouble(20, product.getPrice_emp_junior());
        this.pstmt.setDouble(21, product.getPrice_emp_senior());
        this.pstmt.setDouble(22, product.getPrice_emp_mega());
        this.pstmt.setDouble(23, product.getPrice_lv_junior());
        this.pstmt.setDouble(24, product.getPrice_lv_senior());
        this.pstmt.setDouble(25, product.getPrice_lv_mega());
        this.pstmt.setBoolean(26, product.isMenu());
        this.pstmt.setBoolean(27, product.isPrepared());
        this.pstmt.setBoolean(28, product.isMany_size());
        this.pstmt.setBoolean(29, product.isDifferent_price());
        this.pstmt.setString(30, product.getColor());
        this.pstmt.setString(31, product.getTaxemp());
        this.pstmt.setString(32, product.getTaxlv());
        this.pstmt.setBoolean(33, product.isHasLabel());
        this.pstmt.setBoolean(34, product.getBar());
        this.pstmt.setBoolean(35, product.getTerasse());
        this.pstmt.setBoolean(36, product.getHappy_hour());
        this.pstmt.setDouble(37, product.getPrice_bar());
        this.pstmt.setDouble(38, product.getPrice_terasse());
        this.pstmt.setDouble(39, product.getPrice_happy_hour());
        this.pstmt.setDouble(40, product.getPrice_bar_junior());
        this.pstmt.setDouble(41, product.getPrice_bar_senior());
        this.pstmt.setDouble(42, product.getPrice_bar_mega());
        this.pstmt.setDouble(43, product.getPrice_terasse_junior());
        this.pstmt.setDouble(44, product.getPrice_terasse_senior());
        this.pstmt.setDouble(45, product.getPrice_terasse_mega());
        this.pstmt.setDouble(46, product.getPrice_happy_junior());
        this.pstmt.setDouble(47, product.getPrice_happy_senior());
        this.pstmt.setDouble(48, product.getPrice_happy_mega());
        this.pstmt.setInt(49, product.getOption_free());
        this.pstmt.setBoolean(50, product.isSpecial_option());
        this.pstmt.setInt(51, product.getNumber_line());
        this.pstmt.setInt(52, product.getNumber_column());
        this.pstmt.setInt(53, product.getMax_line());
        this.pstmt.setBoolean(54, product.isAdditional_sale());
        this.pstmt.setBoolean(55, product.isMoment_product());
        this.pstmt.setDouble(56, product.getQuantity());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        if (rs.next()) {
            int last_inserted_id;
            this.id_Product = last_inserted_id = rs.getInt(1);
        }
        product.setID(this.id_Product);
        return product;
    }

    public PrinterInfo addPrinter(PrinterInfo printer) throws SQLException {
        String SQL = "INSERT INTO PRINTER(NAME, NAME_PRINTER, TYPE, IP, WITH_TICKET, NUMBER_TICKET, typePrinter, PORT, band_rate , MODEL ) VALUES(?,?,?,?,?,?,?,?,?,?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, printer.getName());
        this.pstmt.setString(2, printer.getNamePrinter());
        this.pstmt.setString(3, printer.getType());
        this.pstmt.setString(4, printer.getIp());
        this.pstmt.setInt(5, printer.getWith());
        this.pstmt.setInt(6, printer.getNumber());
        this.pstmt.setString(7, printer.getTypePrinter());
        this.pstmt.setString(8, printer.getPort());
        this.pstmt.setString(9, printer.getBand_rate());
        this.pstmt.setString(10, printer.getModel());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idPrinter = 0;
        if (rs.next()) {
            int last_inserted_id;
            idPrinter = last_inserted_id = rs.getInt(1);
        }
        printer.setId(idPrinter);
        return printer;
    }

    public void paidLines(Collection<TicketLineInfo> lines) throws BasicException {
        for (final TicketLineInfo line : lines) {
            if (line.isNext()) continue;
            if (line.getMultiply() == line.getUnits_paid()) {
                line.setPaid(true);
            } else {
                line.setPaid(false);
            }
            if (!line.isDiver()) {
                new PreparedSentence(this.s, "UPDATE TICKETLINES SET paid = ?, units_paid = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setBoolean(1, line.isPaid());
                        this.setDouble(2, NumericUtils.round(line.getUnits_paid()));
                        this.setInt(3, line.getID());
                    }
                });
                continue;
            }
            new PreparedSentence(this.s, "UPDATE PRODUCT_DIVERS SET paid = ?, units_paid = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, line.isPaid());
                    this.setDouble(2, NumericUtils.round(line.getUnits_paid()));
                    this.setInt(3, line.getProductID());
                }
            });
        }
    }

    public void addPaymentTicket(TicketInfo ticket, List<PaymentInfo> m_aPaymentInfo, HashMap<Integer, TicketResto> ticketsRestau) throws BasicException {
        for (PaymentInfo paymentInfo : m_aPaymentInfo) {
            this.addPayment(ticket, paymentInfo);
        }
        if (ticketsRestau != null) {
            for (TicketResto ticketResto : ticketsRestau.values()) {
                this.addTicketResto(ticketResto);
            }
        }
    }

    public void updatePayment(TicketInfo ticket, List<PaymentInfo> payments, HashMap<Integer, TicketResto> ticketsRestau) throws BasicException {
        List<PaymentInfo> oldPayments = this.findPaymetsByIdTicket(ticket.getId());
        for (PaymentInfo oldPayment : oldPayments) {
            int found = -1;
            for (PaymentInfo payment : payments) {
                if (!oldPayment.getId().equals(payment.getId())) continue;
                found = 1;
                break;
            }
            if (found != -1) continue;
            this.deletePayment(oldPayment.getId());
        }
        for (PaymentInfo payment : payments) {
            if (!"No ID".equals(payment.getId())) continue;
            this.addPayment(ticket, payment);
        }
        this.deletePaymentTicket(ticket.getId());
        EnteteInfo entete = this.getEnteteByTicket(ticket.getId(), true);
        for (PaymentInfo payment : payments) {
            this.addTICKET_PAYMENT(ticket, payment, Integer.parseInt(entete.getId()), entete.getCode_caisse());
        }
        if (ticketsRestau != null) {
            for (TicketResto ticketResto : ticketsRestau.values()) {
                this.addTicketResto(ticketResto);
            }
        }
    }

    public void deletePayment(String ID) throws BasicException {
        this.mDebitCustomerService.deleteByPaymentId(ID);
        this.dlEmployees.deleteTransactionEmployee(ID);
        new StaticSentence(this.s, "DELETE FROM PAYMENTS WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)ID);
    }

    public void deletePaymentTicket(String idTICKET) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM TICKET_PAYMENT WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)idTICKET);
    }

    public final List<TicketInfo> loadAllTicket(final Date dateStart, final Date dateEnd, boolean sales, boolean cancel, boolean refund, boolean get_payment) throws BasicException {
        Object wq = " AND T.paid = 1 AND (";
        if (sales) {
            wq = (String)wq + " T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' ";
        }
        if (cancel) {
            if (sales) {
                wq = (String)wq + " OR ";
            }
            wq = (String)wq + " STATUS = 'cancel' ";
        }
        if (refund) {
            if (cancel || sales) {
                wq = (String)wq + " OR ";
            }
            wq = (String)wq + " T.STATUS = 'Refund' ";
        }
        wq = (String)wq + " ) ";
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE R.DATENEW >= ? AND R.DATENEW <= ? " + (String)wq + "ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            if (!get_payment) continue;
            ticket.setPayments(this.findPaymetsByIdTicket(ticket.getId()));
        }
        return tickets;
    }

    public final Integer getNbOrderByStatus(final Date dateStart, final Date dateEnd, final String status) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM TICKETS T WHERE T.paid = 1 AND T.CREATED > ? AND T.CREATED < ?  AND T.STATUS = ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
                this.setString(3, status);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final List<TicketInfo> loadTicketByCustomer(int idCustomer) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE CUSTOMER = ?  ORDER BY R.DATENEW desc ", SerializerWriteInteger.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)idCustomer);
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public void addTableToTicket(final TicketInfo ticket, final TableInfo table) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TABLES SET available = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, false);
                this.setInt(2, table.getId());
            }
        });
        new PreparedSentence(this.s, "UPDATE  TICKETS SET idTable = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, table.getId());
                this.setString(2, ticket.getId());
            }
        });
    }

    public void changeInfoOrder(final TicketInfo ticket) throws BasicException {
        if (ticket.getAddressInfo().getId() != -1) {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET address = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, ticket.getAddressInfo().getId());
                    this.setString(2, ticket.getId());
                }
            });
        }
        if (ticket.getCustomerId() != -1) {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET CUSTOMER = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, ticket.getCustomerId());
                    this.setString(2, ticket.getId());
                }
            });
        }
    }

    private void changeTicketLine(final TicketLineInfo l, final TicketInfo ticket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TICKETLINES SET TICKET = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticket.getId());
                this.setInt(2, l.getID());
            }
        });
    }

    private void changeTicketDivers(final TicketLineInfo l, final TicketInfo ticket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCT_DIVERS SET  TICKET = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticket.getId());
                this.setInt(2, l.getProductID());
            }
        });
    }

    public void changeTotalOrder(final TicketInfo ticket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TICKETS SET total = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(ticket.getTotal()));
                this.setString(2, ticket.getId());
            }
        });
        for (final TicketLineInfo l : ticket.getLines()) {
            if (l.isNext()) continue;
            if (!l.isDiver()) {
                new PreparedSentence(this.s, "UPDATE  TICKETLINES SET UNITS = ?, PRICE = ?,  htAmount = ?, taxAmount = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setDouble(1, NumericUtils.round(l.getMultiply()));
                        this.setDouble(2, NumericUtils.round(l.getPrice()));
                        this.setDouble(3, NumericUtils.round(l.getHtAmount()));
                        this.setDouble(4, NumericUtils.round(l.getTaxAmount()));
                        this.setInt(5, l.getID());
                    }
                });
                continue;
            }
            new PreparedSentence(this.s, "UPDATE PRODUCT_DIVERS SET  PRICE = ?,  htAmount = ?, taxAmount = ?, UNITS = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setDouble(1, NumericUtils.round(l.getPrice(), 2));
                    this.setDouble(2, NumericUtils.round(l.getHtAmount(), 2));
                    this.setDouble(3, NumericUtils.round(l.getTaxAmount()));
                    this.setDouble(4, NumericUtils.round(l.getMultiply()));
                    this.setInt(5, l.getProductID());
                }
            });
        }
    }

    public final List<PaymentLine> loadPaymentAvoirTRXDay(final int year, final int month) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND YEAR(T.CREATED) = ? AND MONTH(T.CREATED) = ?    AND  P.PAYMENT='Avoir' AND P.TOTAL<0 AND avoir_origin like '%Ticket Resto%' GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
            }
        });
    }

    public final List<PaymentLine> loadPaymentAvoirTRXDay(final int year) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.PAYMENT, SUM(P.TOTAL), COUNT(P.ID) FROM PAYMENTS P LEFT OUTER JOIN TICKETS T ON P.RECEIPT = T.ID WHERE T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.paid = 1 AND YEAR(T.CREATED) = ?     AND  P.PAYMENT='Avoir' AND P.TOTAL<0 AND avoir_origin like '%Ticket Resto%' GROUP BY P.PAYMENT", SerializerWriteParams.INSTANCE, PaymentLine.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
            }
        });
    }

    public void ApplyDiscount(final CategoryInfo category) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  CATEGORIES SET APPLY_DISCOUNT = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, category.isApply_discount());
                this.setInt(2, category.getID());
            }
        });
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET APPLY_DISCOUNT = ? WHERE CATEGORY = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, category.isApply_discount());
                this.setInt(2, category.getID());
            }
        });
    }

    public final List<TicketInfo> loadTicketCanceled() throws BasicException {
        String request_hidden_orders = AppLocal.HIDE_ORDERS ? " AND T.PAID_IN_OTHER_CAISSE = 0 " : "";
        String sQuery = this.requestTicket + "WHERE T.closed = 0 AND T.STATUS = 'cancel' " + request_hidden_orders + "ORDER BY R.DATENEW desc ";
        List tickets = new PreparedSentence(this.s, sQuery, null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadAllTicketByuserNotRefund(final Date dateStart, final Date dateEnd, final String user) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ?   AND R.DATENEW >= ? AND R.DATENEW <= ? AND T.status<>'Refund' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketToPrintNotRefund(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE R.DATENEW >= ? AND R.DATENEW <= ? AND T.status <> 'Refund' ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        }
        return tickets;
    }

    public TicketInfo getTicketByOrigin(String idCanceled) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE T.CANCELED_TICKET_ID = ? ", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)idCanceled);
        if (ticket != null) {
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return ticket;
    }

    public final List<Duplicata> getDuplicataByPeriode(String typePeriode, Date myDate, boolean check) throws BasicException {
        String request = check ? "CHECK_TYPE_DOC = 0 and " : "";
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        List duplicatas = new PreparedSentence(this.s, this.requestDuplicata + "WHERE  " + request + " date_impression >= ? and date_impression <  ? ORDER BY id ", SerializerWriteParams.INSTANCE, Duplicata.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return duplicatas;
    }

    public void updateCouvertTicket(final int couvert, final TicketInfo ticket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TICKETS SET couverts = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, couvert);
                this.setString(2, ticket.getId());
            }
        });
    }

    public int multiplyPositif(TicketInfo ticket) {
        if (ticket.getTicketType() == 1) {
            return -1;
        }
        return 1;
    }

    public List<EnteteInfo> getTicketToClear(final Date dateVidange) throws BasicException {
        List entetes = new PreparedSentence(this.s, this.requestEntete + " JOIN TICKETS T ON E.ticket = T.ID WHERE T.CLOSED = 1 AND E.timestampGDH <= ? ", SerializerWriteParams.INSTANCE, EnteteInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
        return entetes;
    }

    public void vidangerCaisse(Date dateVidange) throws BasicException {
        this.deleteInfoFactureByTicket("LINES_FACTURE", dateVidange);
        this.deleteInfoFactureByTicket("RECAP_GENERAL_FACTURE", dateVidange);
        this.deleteInfoFactureByTicket("RECAP_TAX_FACTURE", dateVidange);
        this.deleteInfoNoteByTicket("LINES_NOTE", dateVidange);
        this.deleteInfoNoteByTicket("RECAP_GENERAL_NOTE", dateVidange);
        this.deleteByTicket("GRAND_TOTAL", dateVidange);
        this.deleteByTicket("ENTETE", dateVidange);
        this.deleteByTicket("FACTURE", dateVidange);
        this.deleteByTicket("LINES", dateVidange);
        this.deleteByTicket("TOTAL_TAX", dateVidange);
        this.deleteByTicket("TOTAL_ENCAISSEMENT", dateVidange);
        this.deleteByTicket("TICKET_PAYMENT", dateVidange);
        this.deleteByTicket("DOCUMENT", dateVidange);
        this.deleteByTicket("ENTETE_NOTE", dateVidange);
        this.deleteDiversByTicket(dateVidange);
        this.deleteDuplicataByTicket(dateVidange);
        this.deleteAVOIRByTicket(dateVidange);
        this.deleteInfoLineByTicket("Option_ticket", dateVidange);
        this.deleteInfoLineByTicket("ingredient_ticket", dateVidange);
        this.deleteInfoLineByTicket("Product_ticket", dateVidange);
        this.deleteInfoLineByTicket("PRODUCT_ORDER", dateVidange);
        this.deleteByTicket("DEBIT_CUSTOMER", dateVidange);
        this.deleteByTicket("CREDIT_EMPLOYEE", dateVidange);
        this.deleteLineByTicket(dateVidange);
        this.deleteDuplicataJustificatifByTicket(dateVidange);
        this.deleteJustificatifByTicket(dateVidange);
        this.deleteTicket(dateVidange);
        this.deletePaymentByTicket();
        this.deleteRECEIPTByTicket();
        try {
            String user_id = AppLocal.user != null ? AppLocal.user.getId() : (AppLocal.user_maintenance != null ? AppLocal.user_maintenance.getId() : "");
            Journal.writeToJET(new Event(200, "Purge", user_id, "Purge des donn\u00e9es jusqu'\u00e0 la date", new Date().getTime(), new SimpleDateFormat("yyyy:MM:dd HH:mm").format(dateVidange)));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void deleteByTicket(String tableName, final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM " + tableName + " WHERE ticket in (SELECT id from TICKETS WHERE CLOSED = 1 AND created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void deleteDiversByTicket(final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM PRODUCT_DIVERS WHERE TICKET in (SELECT id from TICKETS WHERE CLOSED = 1 AND created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void deleteDuplicataByTicket(final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM Duplicata WHERE id_Doc in (SELECT id from TICKETS WHERE CLOSED = 1 AND created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void deleteAVOIRByTicket(final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM TICKET_AVOIR WHERE TICKET in (SELECT id from TICKETS WHERE CLOSED = 1 AND created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void deleteLineByTicket(final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM TICKETLINES WHERE TICKET in (SELECT id from TICKETS WHERE CLOSED = 1 AND created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void deleteTicket(final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM TICKETS WHERE CLOSED = 1 AND created <= ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void deleteInfoLineByTicket(String tableName, final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM " + tableName + " WHERE idTicketLine in(select L.ID FROM TICKETLINES L JOIN TICKETS T ON L.TICKET = T.ID WHERE T.CLOSED = 1 AND T.created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void deletePaymentByTicket() throws BasicException {
        new StaticSentence(this.s, "delete from PAYMENTS WHERE RECEIPT NOT IN (SELECT ID FROM TICKETS)", null).exec();
    }

    public void deleteRECEIPTByTicket() throws BasicException {
        new StaticSentence(this.s, "delete from RECEIPTS WHERE ID NOT IN (SELECT ID FROM TICKETS)", null).exec();
    }

    public void addLineToTicket(final TicketInfo ticket, TicketLineInfo line) throws BasicException, SQLException {
        if (!line.isDiver()) {
            this.addTicketLine(ticket, line);
        } else {
            this.addProductDivers(ticket, line);
        }
        new PreparedSentence(this.s, "UPDATE  TICKETS SET total = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(ticket.getTotal()));
                this.setString(2, ticket.getId());
            }
        });
    }

    public void changeLine(final TicketInfo ticket, final TicketLineInfo line, boolean update) throws BasicException {
        if (update) {
            new PreparedSentence(this.s, "UPDATE  TICKETLINES SET UNITS = ?, PRICE = ?,  htAmount = ?, taxAmount = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setDouble(1, NumericUtils.round(line.getMultiply()));
                    this.setDouble(2, NumericUtils.round(line.getPrice()));
                    this.setDouble(3, NumericUtils.round(line.getHtAmount()));
                    this.setDouble(4, NumericUtils.round(line.getTaxAmount()));
                    this.setInt(5, line.getID());
                }
            });
        } else {
            this.deleteTicketLine(line);
        }
        new PreparedSentence(this.s, "UPDATE  TICKETS SET total = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(ticket.getTotal()));
                this.setString(2, ticket.getId());
            }
        });
    }

    public List<EnteteInfo> getEnteteBetween(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        List entetes = new PreparedSentence(this.s, "SELECT  E.id, E.num_doc, E.version_soft, E.nb_print, E.company, E.address, E.zip_code, E.city, E.country, E.siret, E.code_NAF, E.num_tva, E.timestampGDH, E.type_operation, E.nb_lines, E.ticket, E.header_Supplementaire, E.footer_Supplementaire, E.ticket_status, E.signature_Ticket, G.id, G.num_doc, G.timestampGDH, G.grand_total, G.grand_total_Perpetual,G.ticket, G.TVA_5_5, G.TVA_10, G.TVA_20, G.signature, G.grand_total_Perpetual_reel,G.TVA_0, G.TVA_7_7, G.TVA_2_5, G.TVA_2_1, G.TVA_8_5, " + DAOConstants.SQLFunction + "(G.BEFORE_PERPETUAL_RESET, 0) as BEFORE_PERPETUAL_RESET, E.code_caisse, E.NAME_SOFT, E.code_operator, " + DAOConstants.SQLFunction + "(G.REF_ORIGINE, 0) as REF_ORIGINE, " + DAOConstants.SQLFunction + "(E.USE_ID_IN_SIGNATURE, 0) as USE_ID_IN_SIGNATURE, " + DAOConstants.SQLFunction + "(G.ADD_PERPETUAL_IN_SIGNATURE, 0) as ADD_PERPETUAL_IN_SIGNATURE, " + DAOConstants.SQLFunction + "(E.ROUND_AMOUNT, 0) as ROUND_AMOUNT, " + DAOConstants.SQLFunction + "(G.ROUND_AMOUNT, 0) as ROUND_AMOUNT, G.TVA_6, G.TVA_12, G.TVA_21, G.TVA_8_1, G.TVA_2_6, E.RESTITUTION_TYPE, E.NB_SEND_E_TICKET, E.name_operator FROM ENTETE E LEFT JOIN TICKETS T ON E.ticket = T.ID LEFT JOIN GRAND_TOTAL G on E.ticket = G.ticket WHERE E.timestampGDH >= ? AND E.timestampGDH  < ?  order by E.id ", SerializerWriteParams.INSTANCE, EnteteInfo.getSerializerReadWithGrandTotal()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return entetes;
    }

    public boolean isTodayClotured() {
        Date newDate;
        if (this.lastCloturedday == 0) {
            try {
                GrandTotalPeriode lasttotalPeriode = this.getLastGrandTotalPeriode("j");
                if (lasttotalPeriode != null) {
                    this.lastCloturedday = Integer.valueOf(lasttotalPeriode.getId());
                }
            }
            catch (BasicException ex) {
                Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.lastCloturedday >= Integer.valueOf(com.openbravo.pos.util.DateUtils.SDF_ID_DAY_PERIOD.format(newDate = new Date()));
    }

    public ArchivPeriode getArchivPeriodeById(String id) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestArchivPeriode + "FROM ARCHIV_PERIODE where id = ? order by timestampGDH desc FETCH FIRST 1 rows only  ", SerializerWriteString.INSTANCE, ArchivPeriode.getSerializerRead()).list((Object)id);
        if (listTotaux.size() > 0) {
            return (ArchivPeriode)listTotaux.get(0);
        }
        return null;
    }

    public void addEnteteNote(final TicketInfo ticket, final MarqueNFC marqueNF) throws BasicException {
        StringBuilder ticketEmprinte = new StringBuilder();
        EnteteInfo lastEntete = this.getLastEnteteNote();
        final String code_caisse = this.getCodeCaisse();
        this.calculTotalTva(ticket);
        final double TVA5 = this.totalTVA5;
        final double TVA10 = this.totalTVA10;
        final double TVA20 = this.totalTVA20;
        final double TVA0 = this.totalTVA0;
        final double TVA_7_7 = this.totalTVA_7_7;
        final double TVA_2_5 = this.totalTVA_2_5;
        final double TVA_2_1 = this.totalTVA_2_1;
        final double TVA_8_5 = this.totalTVA_8_5;
        final double TVA_6 = this.totalTVA_6;
        final double TVA_12 = this.totalTVA_12;
        final double TVA_21 = this.totalTVA_21;
        final double TVA_8_1 = this.totalTVA_8_1;
        final double TVA_2_6 = this.totalTVA_2_6;
        final Date createdNote = new Date();
        final int nbLine = ticket.getNbrArticles();
        new PreparedSentence(this.s, "INSERT INTO ENTETE_NOTE ( num_doc, nb_print, company, address, zip_code, city, country, siret, code_NAF, num_tva, code_operator, name_operator, timestampGDH, nb_lines, ticket , header_Supplementaire, footer_Supplementaire,  ticket_status, type_operation,version_soft ,nb_customer ,code_caisse,horodatage,code_remise,total,tva5,tva10,tva20, tva0, tva_7_7, tva_2_5, tva_2_1, tva_8_5, NAME_SOFT, ROUND_AMOUNT, tva_6, tva_12, tva_21, TVA_8_1, TVA_2_6) VALUES(?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, String.valueOf(DataLogicSales.this.idDocument));
                this.setInt(2, 0);
                this.setString(3, marqueNF.getCompany());
                this.setString(4, marqueNF.getAdresse1());
                this.setString(5, marqueNF.getZipCode());
                this.setString(6, marqueNF.getCity());
                this.setString(7, marqueNF.getCountry());
                this.setString(8, marqueNF.getSiret());
                this.setString(9, marqueNF.getCodeNAF());
                this.setString(10, marqueNF.getIntraTVA());
                this.setString(11, ticket.getUser().getId());
                this.setString(12, ticket.getUser().getName());
                this.setTimestamp(13, createdNote);
                this.setInt(14, nbLine);
                this.setString(15, ticket.getId());
                this.setString(16, AppLocal.header);
                this.setString(17, AppLocal.footer);
                this.setString(18, "pending");
                this.setString(19, "Vente");
                this.setString(20, "10.0.1.27");
                this.setInt(21, 1);
                this.setString(22, code_caisse);
                this.setString(23, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(createdNote));
                this.setBoolean(24, ticket.getTypeDiscount().equalsIgnoreCase("pourcentage"));
                this.setDouble(25, NumericUtils.round(ticket.getTotal()));
                this.setDouble(26, NumericUtils.round(TVA5));
                this.setDouble(27, NumericUtils.round(TVA10));
                this.setDouble(28, NumericUtils.round(TVA20));
                this.setDouble(29, NumericUtils.round(TVA0));
                this.setDouble(30, NumericUtils.round(TVA_7_7));
                this.setDouble(31, NumericUtils.round(TVA_2_5));
                this.setDouble(32, NumericUtils.round(TVA_2_1));
                this.setDouble(33, NumericUtils.round(TVA_8_5));
                this.setString(34, "BIBORNE");
                this.setBoolean(35, true);
                this.setDouble(36, NumericUtils.round(TVA_6));
                this.setDouble(37, NumericUtils.round(TVA_12));
                this.setDouble(38, NumericUtils.round(TVA_21));
                this.setDouble(39, NumericUtils.round(TVA_8_1));
                this.setDouble(40, NumericUtils.round(TVA_2_6));
            }
        });
        final EnteteInfo enteteToUpdate = this.getLastEnteteNote();
        if (enteteToUpdate != null) {
            this.addTvaToSignature(ticketEmprinte, ticket);
            ticketEmprinte.append(",").append((long)((double)this.multiplyPositif(ticket) * NumericUtils.round(NumericUtils.round(ticket.getTotal()) * 100.0)));
            ticketEmprinte.append(",").append(com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(createdNote));
            ticketEmprinte.append(",").append(enteteToUpdate.getId());
            ticketEmprinte.append(",").append("Vente");
            if (lastEntete == null) {
                ticketEmprinte.append(",N,");
            } else {
                ticketEmprinte.append(",O,");
                ticketEmprinte.append(lastEntete.getSignature());
            }
            String[] tab = ticketEmprinte.toString().split(",");
            if (tab[tab.length - 1].equals("N")) {
                this.detecter.detectDeletion("ent", "");
            } else {
                this.detecter.detectDeletion("ent", tab[tab.length - 1]);
            }
            final String signature = DataLogicSales.signer(ticketEmprinte.toString());
            new PreparedSentence(this.s, "UPDATE  ENTETE_NOTE SET signature_Ticket = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, signature);
                    this.setInt(2, Integer.parseInt(enteteToUpdate.getId()));
                }
            });
            this.numLine = 0;
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.isNext()) continue;
                line.setNumLine(this.numLine);
                this.restReduction = ticket.getTypeDiscount().equals("pourcentage") ? ticket.getDiscount() * ticket.getRealTotal() / 100.0 : ticket.getDiscount();
                this.addLineNote(line, ticket, Integer.parseInt(enteteToUpdate.getId()), createdNote, enteteToUpdate.getCode_caisse());
                ++this.numLine;
                if (!AppLocal.MODULE_MULTI_TVA) continue;
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (!supplement.addTaxeToOption() || supplement.getTax() == null) continue;
                    supplement.setNumLine(this.numLine);
                    this.addLineNote(line, supplement, ticket, Integer.parseInt(enteteToUpdate.getId()));
                    ++this.numLine;
                }
            }
            this.totalHT = 0.0;
            for (TaxLineInfo taxe : ticket.getTaxes()) {
                this.totalHT += Math.abs(taxe.getSumHT());
            }
            this.addRecapGeneralNote(ticket, Integer.parseInt(enteteToUpdate.getId()));
        }
    }

    public EnteteInfo getLastEnteteNote() throws BasicException {
        List entete = new PreparedSentence(this.s, this.requestEnteteNote + " ORDER BY E.id desc FETCH FIRST 1 rows only ", null, EnteteInfo.getSerializerRead()).list();
        if (entete.size() > 0) {
            return (EnteteInfo)entete.get(0);
        }
        return null;
    }

    public void incrementPrinterNote(String idTicket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ENTETE_note SET nb_print = 1 WHERE ticket = ?", SerializerWriteString.INSTANCE).exec((Object)idTicket);
    }

    public void addEnteteNoteAfterPrint(TicketInfo ticket) throws BasicException {
        this.idDocument = this.getDocumentTicket(ticket.getId()).getId();
        new PreparedSentence(this.s, "UPDATE TICKETS SET PRINT_AFTER_UPDATE = 1 WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
        MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this);
        if (marqueNF == null) {
            marqueNF = new MarqueNFC("", "", "", "", "", "", "", "", "");
        }
        this.addEnteteNote(ticket, marqueNF);
    }

    public void updateColorOption(final SupplementItemInfo option) throws BasicException {
        new PreparedSentence(this.s, "UPDATE SUPPLEMENT_ITEM SET color = ? WHERE id = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, option.getColor());
                this.setInt(2, option.getiD());
            }
        });
    }

    public Session getCurrentSession() {
        return this.s;
    }

    public final List<TicketInfo> loadTicketcanceled(final Date dateStart, final Date dateEnd) throws BasicException {
        String request_hidden_orders = AppLocal.HIDE_ORDERS ? " AND T.PAID_IN_OTHER_CAISSE = 0 " : "";
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE R.DATENEW >= ? AND R.DATENEW <= ?  AND T.STATUS = 'cancel' " + request_hidden_orders + "ORDER BY T.TICKETID desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            ticket.setPayments(this.findPaymetsByIdTicket(ticket.getId()));
        }
        return tickets;
    }

    public DataLogicEmployees getDlEmployees() {
        return this.dlEmployees;
    }

    public void setDlEmployees(DataLogicEmployees dlEmployees) {
        this.dlEmployees = dlEmployees;
    }

    public void resetCarte() throws BasicException {
        new StaticSentence(this.s, "UPDATE CATEGORIES SET REMOVED_BY_ADMIN = 1 ", SerializerWriteInteger.INSTANCE).exec();
        new StaticSentence(this.s, "UPDATE PRODUCTS SET REMOVED_BY_ADMIN = 1 ", SerializerWriteInteger.INSTANCE).exec();
        new StaticSentence(this.s, "UPDATE supplement SET REMOVED_BY_ADMIN = 1 ", SerializerWriteInteger.INSTANCE).exec();
        new StaticSentence(this.s, "UPDATE supplement_item SET REMOVED_BY_ADMIN = 1 ", SerializerWriteInteger.INSTANCE).exec();
        new StaticSentence(this.s, "UPDATE carte SET REMOVED_BY_ADMIN = 1 ", SerializerWriteInteger.INSTANCE).exec();
        new StaticSentence(this.s, "UPDATE GROUPE_SUB_SUPPLEMENTS SET REMOVED = 1 ", SerializerWriteInteger.INSTANCE).exec();
        new StaticSentence(this.s, "UPDATE PROMOTIONS SET REMOVED_BY_ADMIN = 1 ", SerializerWriteInteger.INSTANCE).exec();
        new StaticSentence(this.s, "DELETE FROM item_ingredients ", null).exec();
        new StaticSentence(this.s, "DELETE FROM item_supplements ", null).exec();
        new StaticSentence(this.s, "DELETE FROM SUB_SUPPLEMENTS ", null).exec();
        new StaticSentence(this.s, "DELETE FROM SUPPLEMENTS_GROUPE ", null).exec();
        new StaticSentence(this.s, "DELETE FROM ADDITIONAL_SALES ", null).exec();
        new StaticSentence(this.s, "DELETE FROM PRODUCTS_PROMOTIONS ", null).exec();
        new StaticSentence(this.s, "DELETE FROM SCREENS_SUPPLEMENT ", null).exec();
        new StaticSentence(this.s, "DELETE FROM SUPPLEMENT_ITEM_PRICES ", null).exec();
        new StaticSentence(this.s, "DELETE FROM SUB_PRODUCTS ", null).exec();
        new StaticSentence(this.s, "DELETE FROM PRODUCT_DAYS_ON ", null).exec();
        new StaticSentence(this.s, "DELETE FROM carte_item ", null).exec();
        new StaticSentence(this.s, "DELETE FROM carte_menu ", null).exec();
        new StaticSentence(this.s, "DELETE FROM PRODUCTS_SIZE ", null).exec();
    }

    private void changeStockProduct(final TicketLineInfo line, final double quantity) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  PRODUCTS SET quantity = quantity + ? WHERE STORABLE = 1 AND ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, quantity);
                this.setInt(2, line.getProductID());
            }
        });
    }

    public final void disburseTicket(TicketInfo ticket) throws BasicException {
        if (this.isValidPeriod()) {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET DISBURSED = 1 WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)ticket.getId());
        }
    }

    public final void deliverTicket(String ticket_id) throws BasicException {
        if (this.isValidPeriod()) {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET DELIVERED = 1, STATUS = 'livre' WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)ticket_id);
        }
    }

    public final AppUser getUserById(String id) throws BasicException {
        return (AppUser)new PreparedSentence(this.s, "SELECT P.ID, P.NAME, P.APPPASSWORD, P.ROLE, C.ID as code FROM PEOPLE P  LEFT JOIN COUNTER_USER C ON P.ID = C.ID_USER WHERE P.ID = ? AND P.removed = 0 ", SerializerWriteString.INSTANCE, AppUser.getSerializerRead()).find((Object)id);
    }

    public void addItemSupplement(final SupplementProduct option, final int id_product) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO ITEM_SUPPLEMENTS (id_supplement, id_item, free_able , separate, option_free, has_limit_options, min_options, max_options, option_free_size2, min_options_size2, max_options_size2, option_free_size3, min_options_size3, max_options_size3, option_free_size4, min_options_size4, max_options_size4, option_free_size5, min_options_size5, max_options_size5, option_free_size6, min_options_size6, max_options_size6, many_size, OPTION_FREE_SIZE7, MIN_OPTIONS_SIZE7, MAX_OPTIONS_SIZE7, OPTION_FREE_SIZE8, MIN_OPTIONS_SIZE8, MAX_OPTIONS_SIZE8, OPTION_FREE_SIZE9, MIN_OPTIONS_SIZE9, MAX_OPTIONS_SIZE9, OPTION_FREE_SIZE10, MIN_OPTIONS_SIZE10, MAX_OPTIONS_SIZE10) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, option.getiD());
                this.setInt(2, id_product);
                this.setBoolean(3, option.isFree_able());
                this.setBoolean(4, option.isSeparate());
                this.setInt(5, option.getOption_free());
                this.setBoolean(6, option.getHas_options());
                this.setInt(7, option.getMin_options());
                this.setInt(8, option.getMax_options());
                this.setInt(9, option.getOption_free_size2());
                this.setInt(10, option.getMin_options_size2());
                this.setInt(11, option.getMax_options_size2());
                this.setInt(12, option.getOption_free_size3());
                this.setInt(13, option.getMin_options_size3());
                this.setInt(14, option.getMax_options_size3());
                this.setInt(15, option.getOption_free_size4());
                this.setInt(16, option.getMin_options_size4());
                this.setInt(17, option.getMax_options_size4());
                this.setInt(18, option.getOption_free_size5());
                this.setInt(19, option.getMin_options_size5());
                this.setInt(20, option.getMax_options_size5());
                this.setInt(21, option.getOption_free_size6());
                this.setInt(22, option.getMin_options_size6());
                this.setInt(23, option.getMax_options_size6());
                this.setBoolean(24, option.isMany_size());
                this.setInt(25, option.getOption_free_size7());
                this.setInt(26, option.getMin_options_size7());
                this.setInt(27, option.getMax_options_size7());
                this.setInt(28, option.getOption_free_size8());
                this.setInt(29, option.getMin_options_size8());
                this.setInt(30, option.getMax_options_size8());
                this.setInt(31, option.getOption_free_size9());
                this.setInt(32, option.getMin_options_size9());
                this.setInt(33, option.getMax_options_size9());
                this.setInt(34, option.getOption_free_size10());
                this.setInt(35, option.getMin_options_size10());
                this.setInt(36, option.getMax_options_size10());
            }
        });
    }

    public void updateItemSupplement(final SupplementProduct option, final int id_product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ITEM_SUPPLEMENTS SET free_able = ?, separate = ?, option_free = ?, has_limit_options = ?, min_options = ?, max_options = ?, option_free_size2 = ?, min_options_size2 = ?, max_options_size2 = ?, option_free_size3 = ?, min_options_size3 = ?, max_options_size3 = ?, option_free_size4 = ?, min_options_size4 = ?, max_options_size4 = ?, option_free_size5 = ?, min_options_size5 = ?, max_options_size5 = ?, option_free_size6 = ?, min_options_size6 = ?, max_options_size6 = ?, many_size = ?, OPTION_FREE_SIZE7 = ?, MIN_OPTIONS_SIZE7 = ?, MAX_OPTIONS_SIZE7 = ?, OPTION_FREE_SIZE8 = ?, MIN_OPTIONS_SIZE8 = ?, MAX_OPTIONS_SIZE8 = ?, OPTION_FREE_SIZE9 = ?, MIN_OPTIONS_SIZE9 = ?, MAX_OPTIONS_SIZE9 = ?, OPTION_FREE_SIZE10 = ?, MIN_OPTIONS_SIZE10 = ?, MAX_OPTIONS_SIZE10 = ? WHERE id_supplement = ? AND  id_item = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, option.isFree_able());
                this.setBoolean(2, option.isSeparate());
                this.setInt(3, option.getOption_free());
                this.setBoolean(4, option.getHas_options());
                this.setInt(5, option.getMin_options());
                this.setInt(6, option.getMax_options());
                this.setInt(7, option.getOption_free_size2());
                this.setInt(8, option.getMin_options_size2());
                this.setInt(9, option.getMax_options_size2());
                this.setInt(10, option.getOption_free_size3());
                this.setInt(11, option.getMin_options_size3());
                this.setInt(12, option.getMax_options_size3());
                this.setInt(13, option.getOption_free_size4());
                this.setInt(14, option.getMin_options_size4());
                this.setInt(15, option.getMax_options_size4());
                this.setInt(16, option.getOption_free_size5());
                this.setInt(17, option.getMin_options_size5());
                this.setInt(18, option.getMax_options_size5());
                this.setInt(19, option.getOption_free_size6());
                this.setInt(20, option.getMin_options_size6());
                this.setInt(21, option.getMax_options_size6());
                this.setBoolean(22, option.isMany_size());
                this.setInt(23, option.getOption_free_size7());
                this.setInt(24, option.getMin_options_size7());
                this.setInt(25, option.getMax_options_size7());
                this.setInt(26, option.getOption_free_size8());
                this.setInt(27, option.getMin_options_size8());
                this.setInt(28, option.getMax_options_size8());
                this.setInt(29, option.getOption_free_size9());
                this.setInt(30, option.getMin_options_size9());
                this.setInt(31, option.getMax_options_size9());
                this.setInt(32, option.getOption_free_size10());
                this.setInt(33, option.getMin_options_size10());
                this.setInt(34, option.getMax_options_size10());
                this.setInt(35, option.getiD());
                this.setInt(36, id_product);
            }
        });
    }

    public List<ProductInfoExt> getProducts(int category) throws BasicException {
        List products = new PreparedSentence(this.s, this.requestProducts + "WHERE P.CATEGORY = ? ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)category);
        return products;
    }

    public Facture addFacture(final Facture facture, String codeOperator, final String type_operation, final int canceled_facture_id) throws BasicException {
        facture.setType_operation(type_operation);
        facture.setDateFacture(new Date());
        StringBuilder ticketEmprinte = new StringBuilder();
        TicketInfo ticketInfo = this.getTicketById(facture.getTicket());
        List<TicketLineInfo> lines = this.loadLines(facture.getTicket());
        List<TicketLineInfo> linesExterne = this.getTicketLineExterne(facture.getTicket());
        lines.addAll(linesExterne);
        ticketInfo.setLines(lines);
        ticketInfo.setPayments(this.findPaymetsByIdTicket(facture.getTicket()));
        System.out.println("facture.getNum_tva_sender()  : " + facture.getNum_tva_sender());
        final EnteteInfo entete = this.getEnteteByTicket(facture.getTicket(), true);
        Facture lastFacture = this.getLastFacture();
        new PreparedSentence(this.s, "INSERT INTO FACTURE ( company, name_contact, address, zip_code, city, country, siret, code_NAF, num_tva, ticket, physical_person, nb_print, num_doc, TYPE_OPERATION, CANCELED_FACTURE_ID, date_created, VERSION_SOFT, NAME_SOFT, ID_CUSTOMER, COMPANY_SENDER, ADDRESS_SENDER, ZIP_CODE_SENDER, CITY_SENDER, COUNTREY_SENDER, SIRET_SENDER, CODE_NAF_SENDER, NUM_TVA_SENDER, FORME_JURIDIQUE_SENDER, CAPITAL_SOCIAL_SENDER, RCS_SENDER, GREFFE_SENDER, METIER_SENDER, code_operator, name_operator, REF_TICKET, INFO_SENDER_INCLUDED, USE_TYPE_IN_SIGNATURE, ROUND_AMOUNT, code_caisse) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, facture.getCompany() == null ? "" : facture.getCompany());
                this.setString(2, facture.getName_contact());
                this.setString(3, facture.getAddress());
                this.setString(4, facture.getZip_code());
                this.setString(5, facture.getCity());
                this.setString(6, facture.getCountry());
                this.setString(7, facture.getSiret());
                this.setString(8, facture.getCode_NAF());
                this.setString(9, facture.getNum_tva());
                this.setString(10, facture.getTicket());
                this.setBoolean(11, facture.isPhysical_person());
                this.setInt(12, 0);
                this.setInt(13, new Integer(entete.getNumDoc()));
                this.setString(14, type_operation);
                this.setInt(15, canceled_facture_id);
                this.setTimestamp(16, facture.getDateFacture());
                this.setString(17, "10.0.1.27");
                this.setString(18, "BIBORNE");
                this.setInt(19, facture.getId_customer());
                this.setString(20, facture.getCompany_sender());
                this.setString(21, facture.getAddress_sender());
                this.setString(22, facture.getZip_code_sender());
                this.setString(23, facture.getCity_sender());
                this.setString(24, facture.getCountry_sender());
                this.setString(25, facture.getSiret_sender());
                this.setString(26, facture.getCode_NAF_sender());
                this.setString(27, facture.getNum_tva_sender());
                this.setString(28, facture.getForme_juridique_sender());
                this.setString(29, facture.getCapital_social_sender());
                this.setString(30, facture.getRCS_sender());
                this.setString(31, facture.getGreffe_sender());
                this.setString(32, facture.getMetier_sender());
                this.setString(33, facture.getCode_operator());
                this.setString(34, facture.getName_operator());
                this.setInt(35, Integer.parseInt(entete.getId()));
                this.setBoolean(36, true);
                this.setBoolean(37, true);
                this.setBoolean(38, true);
                this.setString(39, entete.getCode_caisse());
            }
        });
        this.calculTotalTva(ticketInfo);
        int multiply = type_operation != null && type_operation.equalsIgnoreCase("FACTURE") ? 1 : -1;
        this.signatureUtils.addTvaToSignature(ticketEmprinte, this.totalTVA5, this.totalTVA10, this.totalTVA20, this.totalTVA0, this.totalTVA_7_7, this.totalTVA_2_5, this.totalTVA_2_1, this.totalTVA_8_5, this.totalTVA_6, this.totalTVA_12, this.totalTVA_21, this.totalTVA_8_1, this.totalTVA_2_6, multiply);
        final Facture thisFacture = this.getLastFacture();
        final String facture_signature = this.mDataLogicSalesHelper.buildFactureSignature(multiply, Math.abs(ticketInfo.getTotal()), ticketEmprinte, thisFacture, lastFacture, type_operation);
        System.out.println("facture_signature : " + facture_signature);
        new PreparedSentence(this.s, "UPDATE Facture SET signature = ? , horodatage=? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, DataLogicSales.signer(facture_signature));
                this.setString(2, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(facture.getDateFacture()));
                this.setInt(3, (int)thisFacture.getId());
            }
        });
        if (type_operation != null && type_operation.equalsIgnoreCase("FACTURE")) {
            new PreparedSentence(this.s, "UPDATE TICKETS SET invoice = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, (int)thisFacture.getId());
                    this.setString(2, thisFacture.getTicket());
                }
            });
        }
        Facture factureSaved = this.getLastFacture();
        Collections.sort(ticketInfo.getLines(), TicketInfo.infoComparator);
        this.restReduction = ticketInfo.getTypeDiscount().equals("pourcentage") ? ticketInfo.getDiscount() * ticketInfo.getRealTotal() / 100.0 : ticketInfo.getDiscount();
        this.numLine = 0;
        for (TicketLineInfo line : ticketInfo.getLines()) {
            if (line.isNext()) continue;
            line.setNumLine(this.numLine++);
            this.addLineFacture(line, ticketInfo, factureSaved);
        }
        this.totalHT = 0.0;
        for (TaxLineInfo taxe : ticketInfo.getTaxes()) {
            this.totalHT += Math.abs(NumericUtils.round(taxe.getSumHT()));
            this.addRecapTaxFacture(taxe, factureSaved);
        }
        this.addRecapGeneralFacture(ticketInfo, factureSaved);
        return factureSaved;
    }

    public void setNumOrderKitchen(final TicketInfo ticket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  TICKETS SET num_order_kitchen = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, ticket.getNum_order_kitchen());
                this.setString(2, ticket.getId());
            }
        });
    }

    public boolean isCurrentPeriod() {
        GrandTotalPeriode lasttotalPeriode = null;
        Date last_date_period = com.openbravo.pos.util.DateUtils.START_DATE;
        try {
            lasttotalPeriode = this.getLastGrandTotalPeriode("j");
            if (lasttotalPeriode != null) {
                last_date_period = lasttotalPeriode.getTimestampGDH();
            }
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
        Date newDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(last_date_period);
        if (com.openbravo.pos.util.DateUtils.isAfterHour(last_date_period, 6)) {
            cal.add(5, 1);
        }
        Date validDate = cal.getTime();
        validDate.setHours(6);
        validDate.setMinutes(0);
        return newDate.before(validDate);
    }

    public boolean isValidPeriod() {
        return this.isCurrentPeriod() && !this.isTodayClotured() && this.isCaisseOuverte();
    }

    public List<EnteteInfo> getEnteteNoteBetween(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        List entetes = new PreparedSentence(this.s, "SELECT  E.id, E.num_doc, E.version_soft, E.nb_print, E.company, E.address, E.zip_code, E.city, E.country, E.siret, E.code_NAF, E.num_tva, E.timestampGDH, E.type_operation, E.nb_lines, E.ticket, E.header_Supplementaire, E.footer_Supplementaire, E.ticket_status, E.signature_Ticket, E.total, E.tva5, E.tva10, E.tva20, E.tva0, E.tva_7_7, E.tva_2_5, E.tva_2_1, E.tva_8_5, E.code_caisse, E.NAME_SOFT, E.code_operator, E.ROUND_AMOUNT, E.tva_6, E.tva_12, E.tva_21, E.TVA_8_1, E.TVA_2_6, E.HAS_RECAP_TAX, E.name_operator FROM ENTETE_NOTE E WHERE E.timestampGDH >= ? AND E.timestampGDH  < ?  order by E.id ", SerializerWriteParams.INSTANCE, EnteteInfo.getSerializerReadNotes()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (EnteteInfo entete : entetes) {
            System.out.println("entete.isHas_recap_tax() : " + entete.isHas_recap_tax());
            if (!entete.isHas_recap_tax()) continue;
            List taxesNote = new PreparedSentence(this.s, this.requestRecapTaxNote + "WHERE REF_NOTE = ?   ", SerializerWriteInteger.INSTANCE, RecapTaxNote.getSerializerRead()).list((Object)Integer.parseInt(entete.getId()));
            entete.setRecapTaxNote(taxesNote);
        }
        return entetes;
    }

    private void updatePositionCategory(final CategoryInfo category) throws BasicException {
        new PreparedSentence(this.s, "UPDATE CATEGORIES SET order_category = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category.getOrdercategory());
                this.setInt(2, category.getID());
            }
        });
    }

    public final Double getCumulePeriode(String date_periode, String column, boolean after_perpetual_reset, String type_periode) throws BasicException {
        String request;
        final String id = date_periode + "%";
        String request_type_periode = type_periode.equals("a") ? " type_periode = 'm' " : " type_periode = 'j' ";
        Object[] cumul = (Object[])new StaticSentence(this.s, " select sum (" + column + ") from GRAND_TOTAL_PERIODE where " + request_type_periode + (request = after_perpetual_reset ? " AND BEFORE_PERPETUAL_RESET = 0 " : "") + " and ID like ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
        if (cumul == null) {
            return null;
        }
        Double result = (Double)cumul[0];
        return result;
    }

    public final HashMap<String, Object> getFinancialInfoPeriode(String date_periode, String typePeriod) throws BasicException {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(date_periode);
        idBuilder.append("%");
        String requestTypeOrder = typePeriod != null && typePeriod.equals("m") ? " type_periode = 'm' " : " type_periode = 'j' ";
        final String id = idBuilder.toString();
        HashMap<String, Object> map_infos = new HashMap<String, Object>();
        Object[] cumul = (Object[])new StaticSentence(this.s, " select sum(CASH_TOTAL), sum(CB_TOTAL), sum(TR_TOTAL), sum(DEBIT_TOTAL), sum(CREDIT_EMPLOYEE_TOTAL), sum(LOYALTY_CARD), sum(CASHDRO_TOTAL), sum(CACH_GLORY_TOTAL), sum(VIRMENT_TOTAL), sum(CHEQUE_TOTAL), sum(AVOIR_DECAISSE_TOTAL), sum(AVOIR_ENCAISSE_TOTAL), sum(TVA_5_5_HT), sum(TVA_10_HT), sum(TVA_20_HT), sum(NUMBER_ORDERS), sum(NUMBER_PRODUCTS_SOLD), sum(TURNOVER_CANCELED), sum(TOTAL_ORDERS_AT_SPOT), sum(TOTAL_ORDERS_TAKE_AWAY), sum(TOTAL_ORDERS_DELIVERY), sum(TOTAL_ORDERS_UBER), sum(TOTAL_ORDERS_DELIVERO), sum(NUMBER_CB), sum(NUMBER_TR), sum(TOTAL_DISCOUNT), sum(TOTAL_DISCOUNT_LINES), sum(TOTAL_ORDERS_JUST_EAT), sum(TVA_0_HT), sum(TOTAL_ORDERS_DRIVE), sum(TVA_7_7_HT), sum(TVA_2_5_HT), sum(TVA_2_1_HT), sum(TVA_8_5_HT), sum(TWINT_TOTAL), sum(TOTAL_ORDERS_SMOOD), sum(CHEQUE_VACANCES_TOTAL), sum(TURNOVER_PLATFORM), sum(NUMBER_ORDERS_PLATFORM), sum(TOTAL_ORDERS_DELIVEROO), sum(TVA_6_HT), sum(TVA_12_HT), sum(TVA_21_HT), sum(TURNOVER_UBEREAT), sum(TOTAL_ORDERS_DISHOP), sum(STRIPE_TOTAL), sum(CASH_LOGY_TOTAL), sum(TVA_8_1_HT), sum(TVA_2_6_HT), sum(TPS), sum(TVQ), sum(CREDIT_CARD_TOTAL), sum(DEBIT_CARD_TOTAL), sum(TOTAL_HT_TAXABLE), sum(TOTAL_HT_NO_TAXABLE), sum(TOTAL_HT_ORDERS_AT_SPOT), sum(TOTAL_HT_ORDERS_TAKE_AWAY), sum(TOTAL_HT_ORDERS_DELIVERY), sum(TOTAL_HT_ORDERS_DRIVE), sum(NUMBER_ORDERS_AT_SPOT), sum(NUMBER_ORDERS_TAKE_AWAY), sum(NUMBER_ORDERS_DELIVERY), sum(NUMBER_ORDERS_DRIVE), sum(CARTE_TR_TOTAL), sum(BANK_TRANSFER_TOTAL), sum(NUMBER_CARTE_TR) from GRAND_TOTAL_PERIODE where " + requestTypeOrder + " and ID like ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.INT, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.INT, Datas.INT, Datas.INT, Datas.INT, Datas.DOUBLE, Datas.DOUBLE, Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
        if (cumul == null) {
            return null;
        }
        map_infos.put("CASH_TOTAL", (Double)cumul[0]);
        map_infos.put("CB_TOTAL", (Double)cumul[1]);
        map_infos.put("TR_TOTAL", (Double)cumul[2]);
        map_infos.put("DEBIT_TOTAL", (Double)cumul[3]);
        map_infos.put("CREDIT_EMPLOYEE_TOTAL", (Double)cumul[4]);
        map_infos.put("LOYALTY_CARD", (Double)cumul[5]);
        map_infos.put("CASHDRO_TOTAL", (Double)cumul[6]);
        map_infos.put("CACH_GLORY_TOTAL", (Double)cumul[7]);
        map_infos.put("VIRMENT_TOTAL", (Double)cumul[8]);
        map_infos.put("CHEQUE_TOTAL", (Double)cumul[9]);
        map_infos.put("AVOIR_TOTAL_DECAISSE", (Double)cumul[10]);
        map_infos.put("AVOIR_TOTAL_ENCAISSE", (Double)cumul[11]);
        map_infos.put("TVA_5_5_HT", (Double)cumul[12]);
        map_infos.put("TVA_10_HT", (Double)cumul[13]);
        map_infos.put("TVA_20_HT", (Double)cumul[14]);
        map_infos.put("NUMBER_ORDERS", (Integer)cumul[15]);
        map_infos.put("NUMBER_PRODUCTS_SOLD", (Double)cumul[16]);
        map_infos.put("TURNOVER_CANCELED", (Double)cumul[17]);
        map_infos.put("TOTAL_ORDERS_AT_SPOT", (Double)cumul[18]);
        map_infos.put("TOTAL_ORDERS_TAKE_AWAY", (Double)cumul[19]);
        map_infos.put("TOTAL_ORDERS_DELIVERY", (Double)cumul[20]);
        map_infos.put("TOTAL_ORDERS_UBER", (Double)cumul[21]);
        map_infos.put("TOTAL_ORDERS_DELIVERO", (Double)cumul[22]);
        map_infos.put("NUMBER_CB", (Integer)cumul[23]);
        map_infos.put("NUMBER_TR", (Integer)cumul[24]);
        map_infos.put("TOTAL_DISCOUNT", (Double)cumul[25]);
        map_infos.put("TOTAL_DISCOUNT_LINES", (Double)cumul[26]);
        map_infos.put("TOTAL_ORDERS_JUST_EAT", (Double)cumul[27]);
        map_infos.put("TVA_0_HT", (Double)cumul[28]);
        map_infos.put("TOTAL_ORDERS_DRIVE", (Double)cumul[29]);
        map_infos.put("TVA_7_7_HT", (Double)cumul[30]);
        map_infos.put("TVA_2_5_HT", (Double)cumul[31]);
        map_infos.put("TVA_2_1_HT", (Double)cumul[32]);
        map_infos.put("TVA_8_5_HT", (Double)cumul[33]);
        map_infos.put("TWINT_TOTAL", (Double)cumul[34]);
        map_infos.put("TOTAL_ORDERS_SMOOD", (Double)cumul[35]);
        map_infos.put("CHEQUE_VACANCES_TOTAL", (Double)cumul[36]);
        map_infos.put("TURNOVER_PLATFORM", (Double)cumul[37]);
        map_infos.put("NUMBER_ORDERS_PLATFORM", (Integer)cumul[38]);
        map_infos.put("TOTAL_ORDERS_DELIVEROO", (Double)cumul[39]);
        map_infos.put("TVA_6_HT", (Double)cumul[40]);
        map_infos.put("TVA_12_HT", (Double)cumul[41]);
        map_infos.put("TVA_21_HT", (Double)cumul[42]);
        map_infos.put("TURNOVER_UBEREAT", (Double)cumul[43]);
        map_infos.put("TOTAL_ORDERS_DISHOP", (Double)cumul[44]);
        map_infos.put("STRIPE_TOTAL", (Double)cumul[45]);
        map_infos.put("CASH_LOGY_TOTAL", (Double)cumul[46]);
        map_infos.put("TVA_8_1_HT", (Double)cumul[47]);
        map_infos.put("TVA_2_6_HT", (Double)cumul[48]);
        map_infos.put("TPS", (Double)cumul[49]);
        map_infos.put("TVQ", (Double)cumul[50]);
        map_infos.put("CREDIT_CARD_TOTAL", (Double)cumul[51]);
        map_infos.put("DEBIT_CARD_TOTAL", (Double)cumul[52]);
        map_infos.put("TOTAL_HT_TAXABLE", (Double)cumul[53]);
        map_infos.put("TOTAL_HT_NO_TAXABLE", (Double)cumul[54]);
        map_infos.put("TOTAL_HT_ORDERS_AT_SPOT", (Double)cumul[55]);
        map_infos.put("TOTAL_HT_ORDERS_TAKE_AWAY", (Double)cumul[56]);
        map_infos.put("TOTAL_HT_ORDERS_DELIVERY", (Double)cumul[57]);
        map_infos.put("TOTAL_HT_ORDERS_DRIVE", (Double)cumul[58]);
        map_infos.put("NUMBER_ORDERS_AT_SPOT", (Integer)cumul[59]);
        map_infos.put("NUMBER_ORDERS_TAKE_AWAY", (Integer)cumul[60]);
        map_infos.put("NUMBER_ORDERS_DELIVERY", (Integer)cumul[61]);
        map_infos.put("NUMBER_ORDERS_DRIVE", (Integer)cumul[62]);
        map_infos.put("CARTE_TR_TOTAL", (Double)cumul[63]);
        map_infos.put("BANK_TRANSFER_TOTAL", (Double)cumul[64]);
        map_infos.put("NUMBER_CARTE_TR", (Integer)cumul[65]);
        List taxes = new StaticSentence(this.s, " select CODE_TAX, NAME, RATE_TAX, TAXE_GLOBAL, sum(TOTAL_TAX),sum(TOTAL_HT),  sum(TOTAL_TTC)  from GTP_TAXES where " + requestTypeOrder + " and ID_PERIOD like ?  GROUP BY CODE_TAX, NAME, RATE_TAX, TAXE_GLOBAL ", SerializerWriteParams.INSTANCE, GroupedTax.getSerializerReadGrouped()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
        map_infos.put("TAXES", taxes);
        return map_infos;
    }

    public void resetCaisse(Date dateReset) throws BasicException {
        this.deleteByTicket("GRAND_TOTAL", dateReset);
        this.deleteByTicket("ENTETE", dateReset);
        this.deleteByTicket("FACTURE", dateReset);
        this.deleteByTicket("LINES", dateReset);
        this.deleteByTicket("TOTAL_TAX", dateReset);
        this.deleteByTicket("TOTAL_ENCAISSEMENT", dateReset);
        this.deleteByTicket("TICKET_PAYMENT", dateReset);
        this.deleteByTicket("DOCUMENT", dateReset);
        this.deleteByTicket("ENTETE_NOTE", dateReset);
        this.deleteDiversByTicket(dateReset);
        this.deleteDuplicataByTicket(dateReset);
        this.deleteAVOIRByTicket(dateReset);
        this.deleteInfoLineByTicket("Option_ticket", dateReset);
        this.deleteInfoLineByTicket("ingredient_ticket", dateReset);
        this.deleteInfoLineByTicket("Product_ticket", dateReset);
        this.deleteInfoLineByTicket("PRODUCT_ORDER", dateReset);
        this.deleteByTicket("DEBIT_CUSTOMER", dateReset);
        this.deleteByTicket("CREDIT_EMPLOYEE", dateReset);
        this.deleteLineByTicket(dateReset);
        this.deleteTicket(dateReset);
        this.deletePaymentByTicket();
        this.deleteRECEIPTByTicket();
        this.deleteTabePeriodByDate("GRAND_TOTAL_PERIODE", dateReset);
        this.deleteTabePeriodByDate("ARCHIV_PERIODE", dateReset);
        this.deleteHistoriqueCaisseByDate(dateReset);
    }

    public void deleteTabePeriodByDate(String name_table, Date dateReset) throws BasicException {
        final String year = com.openbravo.pos.util.DateUtils.SDF_ID_YEAR_PERIOD.format(dateReset);
        final String month = com.openbravo.pos.util.DateUtils.SDF_ID_MONTH_PERIOD.format(dateReset);
        final String day = com.openbravo.pos.util.DateUtils.SDF_ID_DAY_PERIOD.format(dateReset);
        new StaticSentence(this.s, "DELETE FROM " + name_table + " WHERE (type_periode = 'a' and id <= ?)  or (type_periode = 'm' and id <= ?) or (type_periode = 'j' and id <= ?) ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, year);
                this.setString(2, month);
                this.setString(3, day);
            }
        });
    }

    public void deleteHistoriqueCaisseByDate(final Date dateReset) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM HISTORIQUE_CAISSE WHERE dateClose  <= ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateReset);
            }
        });
    }

    private void addAdditionalSales(ProductInfoExt product) throws BasicException {
        if (product.getAdditional_sales() != null) {
            for (ProductInfoExt additional_sale : product.getAdditional_sales()) {
                this.addAdditionalSale(product, additional_sale);
            }
        }
    }

    private void addAdditionalSale(final ProductInfoExt product, final ProductInfoExt additional_sale) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO ADDITIONAL_SALES(ID_PRODUCT, ID_PRODUCT_PARENT) VALUES(? ,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, additional_sale.getID());
                this.setInt(2, product.getID());
            }
        });
    }

    private void deleteAdditionalSale(final ProductInfoExt product, final ProductInfoExt additional_sale) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM ADDITIONAL_SALES WHERE ID_PRODUCT = ? AND ID_PRODUCT_PARENT = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, additional_sale.getID());
                this.setInt(2, product.getID());
            }
        });
    }

    public List<ProductInfoExt> getAdditionalSales(int id_product, boolean catalog_borne) throws BasicException {
        String request = catalog_borne ? " AND P.HIDDEN_BORNE = 0 AND P.PRODUCT_UBEREAT = 0  " : "";
        String request_opening_mode = catalog_borne && AppLocal.OPENING_MODE ? " AND P.ENABLE_IN_OPENING = 1 " : "";
        List products = new PreparedSentence(this.s, this.requestProducts + "JOIN ADDITIONAL_SALES A  ON P.ID = A.ID_PRODUCT WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.SOLD_OUT = 0 " + request + "AND A.ID_PRODUCT_PARENT = ? " + request_opening_mode + this.request_campaign_product + " ORDER BY  P.order_item ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)id_product);
        return products;
    }

    public List<ProductInfoExt> getAllAdditionalSales(int id_product) throws BasicException {
        List products = new PreparedSentence(this.s, this.requestProducts + "JOIN ADDITIONAL_SALES A  ON P.ID = A.ID_PRODUCT WHERE A.ID_PRODUCT_PARENT = ?  ORDER BY  P.order_item ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)id_product);
        return products;
    }

    public List<ProductInfoExt> getProducts() throws BasicException {
        List products = new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.PRODUCT_UBEREAT = 0 " + this.request_campaign_product + "ORDER BY  P.order_item ", null, ProductInfoExt.getSerializerRead()).list();
        for (ProductInfoExt product : products) {
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
        }
        return products;
    }

    public ProductInfoExt getProductPromoBasket() throws BasicException {
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.PROMO_BASKET = 1 ", null, ProductInfoExt.getSerializerRead()).find();
        return product;
    }

    public void updateProductPromo(int id_product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  PROMO_BASKET = 1 WHERE ID = ?", SerializerWriteInteger.INSTANCE).exec((Object)id_product);
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  PROMO_BASKET = 0 WHERE ID <> ?", SerializerWriteInteger.INSTANCE).exec((Object)id_product);
    }

    public final List<TicketInfo> loadTicketUberUser(final String user, final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND TYPE = 'Uber Eats' AND R.DATENEW BETWEEN ? AND ?  ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketUber(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE TYPE = 'Uber Eats' AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public final void updateTicket(TicketInfo ticket, String location, AppUser user) throws BasicException, SQLException {
        this.updateTicket(ticket, location, user, true);
    }

    public List<ProductInfoExt> getProductsWithoutDetails(final int category, final boolean catalog, boolean all, final boolean sub_child, boolean ubereat) throws BasicException {
        Object request = "";
        if (catalog) {
            request = "  AND P.HIDDEN_UBEREAT = 0   AND (P.HAS_TIMETABLE = 0 OR P.ID IN (SELECT PD.ID_PRODUCT from PRODUCT_DAYS_ON PD where PD.DAY_OF_WEEK = ?)) ";
            if (AppLocal.OPENING_MODE) {
                request = (String)request + "AND P.ENABLE_IN_OPENING = 1 ";
            }
        }
        request = (String)request + this.request_campaign_product;
        final int index_param_calendar = sub_child ? 3 : 2;
        String request_removed = all ? "" : "AND P.removed = 0 AND P.hidden = 0";
        String request_category = sub_child ? " (P.CATEGORY = ? OR (C.PARENTID IS NOT NULL AND C.PARENTID = ? AND C.REMOVED_BY_ADMIN = 0 AND C.removed = 0)) " : " P.CATEGORY = ? ";
        String request_join = sub_child ? "JOIN CATEGORIES C ON P.CATEGORY = C.ID " : "";
        String requestUberEat = ubereat ? "AND P.HIDDEN_UBEREAT = 0 AND P.SOLD_OUT = 0 " : "";
        List products = new PreparedSentence(this.s, this.requestProducts + request_join + "WHERE P.REMOVED_BY_ADMIN = 0 AND" + request_category + request_removed + (String)request + requestUberEat + "ORDER BY  P.order_item ", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category);
                if (sub_child) {
                    this.setInt(2, category);
                }
                if (catalog) {
                    this.setInt(index_param_calendar, com.openbravo.pos.util.DateUtils.getDayOfWeek());
                }
            }
        });
        return products;
    }

    public List<ProductInfoExt> getSubProducts(int id_product, boolean catalog_borne) throws BasicException {
        String request_borne = catalog_borne ? "AND P.SOLD_OUT = 0 AND P.HIDDEN_BORNE = 0" : "";
        List products = new PreparedSentence(this.s, this.requestSubProducts + "JOIN SUB_PRODUCTS SP  ON P.ID = SP.ID_PRODUCT WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND SP.ID_PRODUCT_PARENT = ? " + request_borne, SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerReadofSubProduct()).list((Object)id_product);
        for (ProductInfoExt product : products) {
            product.setPriceSell(0.0);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        return products;
    }

    public List<ProductInfoExt> getAllSubProducts(int id_product, boolean check_if_removed) throws BasicException {
        String requestRemoved = check_if_removed ? " AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 " : "";
        List products = new PreparedSentence(this.s, this.requestSubProducts + "JOIN SUB_PRODUCTS SP  ON P.ID = SP.ID_PRODUCT WHERE SP.ID_PRODUCT_PARENT = ? " + requestRemoved, SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerReadofSubProduct()).list((Object)id_product);
        return products;
    }

    public final Double getTVAPeriode(Date myDate, String typePeriode, String column_tva, String date_periode) throws BasicException {
        if (typePeriode != null && typePeriode.equals("j")) {
            final Date dateEnd = new Date();
            final Date dateStart = new Date(myDate.getTime());
            com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
            Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM ( t." + column_tva + ") FROM grand_total t WHERE   t.timestampGDH  >= ? AND t.timestampGDH < ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setTimestamp(1, dateStart);
                    this.setTimestamp(2, dateEnd);
                }
            });
            if (recsales == null) {
                return null;
            }
            return (Double)recsales[0];
        }
        return this.getCumulePeriode(date_periode, column_tva, false, typePeriode);
    }

    private boolean isCaisseOuverte() {
        if (AppLocal.modeCaisse != null && (AppLocal.modeCaisse.equalsIgnoreCase("Borne") || AppLocal.modeCaisse.equalsIgnoreCase("Self-checkout"))) {
            return true;
        }
        CaisseInfo caisse = this.mCaisseService.findByToken(AppLocal.token);
        return caisse != null && caisse.isOuverte() != false;
    }

    private void calculTotalTva(TicketInfo ticket) {
        this.totalTVA5 = 0.0;
        this.totalTVA10 = 0.0;
        this.totalTVA20 = 0.0;
        this.totalTVA0 = 0.0;
        this.totalTVA_7_7 = 0.0;
        this.totalTVA_2_5 = 0.0;
        this.totalTVA_2_1 = 0.0;
        this.totalTVA_8_5 = 0.0;
        this.totalTVA_6 = 0.0;
        this.totalTVA_12 = 0.0;
        this.totalTVA_21 = 0.0;
        this.totalTVA_8_1 = 0.0;
        this.totalTVA_2_6 = 0.0;
        for (TaxLineInfo taxe : ticket.getTaxes()) {
            if (taxe.getRate() == 0.055) {
                this.totalTVA5 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.1) {
                this.totalTVA10 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.2) {
                this.totalTVA20 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.0) {
                this.totalTVA0 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.077) {
                this.totalTVA_7_7 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.025) {
                this.totalTVA_2_5 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.021) {
                this.totalTVA_2_1 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.085) {
                this.totalTVA_8_5 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.06) {
                this.totalTVA_6 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.12) {
                this.totalTVA_12 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.21) {
                this.totalTVA_21 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() == 0.081) {
                this.totalTVA_8_1 = taxe.getSumTTC();
                continue;
            }
            if (taxe.getRate() != 0.026) continue;
            this.totalTVA_2_6 = taxe.getSumTTC();
        }
    }

    private void addTvaToSignature(StringBuilder ticketEmprinte, TicketInfo ticket) {
        int multiply = this.multiplyPositif(ticket);
        this.signatureUtils.addTvaToSignature(ticketEmprinte, this.totalTVA5, this.totalTVA10, this.totalTVA20, this.totalTVA0, this.totalTVA_7_7, this.totalTVA_2_5, this.totalTVA_2_1, this.totalTVA_8_5, this.totalTVA_6, this.totalTVA_12, this.totalTVA_21, this.totalTVA_8_1, this.totalTVA_2_6, multiply);
    }

    private void calculAndAddTvaToSignature(StringBuilder ticketEmprinte, TicketInfo ticket) {
        this.calculTotalTva(ticket);
        this.addTvaToSignature(ticketEmprinte, ticket);
    }

    private void addTvaToSignature(StringBuilder builderEmprinteGrandPeriode, double totalTVA5, double totalTVA10, double totalTVA20, double totalTVA0, double totalTVA_7_7, double totalTVA_2_5, double totalTVA_2_1, double totalTVA_8_5, double totalTVA_6, double totalTVA_12, double totalTVA_21, double totalTVA_8_1, double totalTVA_2_6) {
        this.signatureUtils.addTvaToSignature(builderEmprinteGrandPeriode, totalTVA5, totalTVA10, totalTVA20, totalTVA0, totalTVA_7_7, totalTVA_2_5, totalTVA_2_1, totalTVA_8_5, totalTVA_6, totalTVA_12, totalTVA_21, totalTVA_8_1, totalTVA_2_6, 1);
    }

    public final ProductInfoExt getProductInfoById(int id) throws BasicException {
        return this.getProductInfoById(id, false);
    }

    public final List<TicketInfo> getOrdersPending(final Date dateOpen) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE T.paid = 0 AND STATUS <> 'cancel' AND PLATFORM_ORDER = 0 AND R.DATENEW >= ? ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateOpen);
            }
        });
        return tickets;
    }

    public TicketInfo getTicketById(final String idSourceSharedOrder, final int id_shared_order) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE T.ID = ? and T.ID_SHARED_ORDER = ?", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idSourceSharedOrder);
                this.setInt(2, id_shared_order);
            }
        });
        if (ticket != null) {
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return ticket;
    }

    public void deleteHomeBornePhoto() throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PHOTO_HOME_BORNE ", null).exec();
    }

    public void deletePubBornePhoto() throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PHOTO_PUB_BORNE ", null).exec();
    }

    public void deletePubs() throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PUBLICATION_BORNE ", null).exec();
    }

    public void deletePubBornePhoto(final String name) throws BasicException {
        System.out.println("+++++++++++++++++ delete pub name " + name);
        try {
            new PreparedSentence(this.s, "DELETE FROM PHOTO_PUB_BORNE WHERE PATH LIKE ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, name + "%");
                }
            });
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
    }

    public void deleteHomeBornePhoto(final String name) throws BasicException {
        System.out.println("+++++++++++++++++ delete pub name " + name);
        try {
            new PreparedSentence(this.s, "DELETE FROM PHOTO_HOME_BORNE WHERE PATH LIKE ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, name + "%");
                }
            });
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
    }

    public final List<PhotoDispaly> getSortHomeBornePhoto() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, path, REF_SYNCH, LAST_UPDATE FROM PHOTO_HOME_BORNE ORDER BY LAST_UPDATE, ID desc", null, PhotoDispaly.getSerializerReadHome()).list();
    }

    public void cancelFacture(Facture facture, String idUsert, String raison, String idTicket) throws BasicException {
        if (raison == null) {
            raison = "";
        }
        Facture f = this.getFactureById(facture.getId());
        if (idTicket != null) {
            f.setTicket(idTicket);
        }
        this.addFacture(f, idUsert, "ANNULATION", (int)f.getId());
        new PreparedSentence(this.s, "UPDATE FACTURE SET cancel = 1 WHERE id = ? ", SerializerWriteInteger.INSTANCE).exec((Object)((int)facture.getId()));
        try {
            Journal.writeToJET(new Event(190, "Annulation comptable de Facture", idUsert, "Id de Facture", new Date().getTime(), "Facture :" + facture.getId()));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public JustificatifPayment getLastJustificatifPayment() throws BasicException {
        List listJustificatifPayment = new PreparedSentence(this.s, this.requestJustificatifPayment + " ORDER BY ID desc", null, JustificatifPayment.getSerializerRead()).list();
        if (listJustificatifPayment != null && !listJustificatifPayment.isEmpty()) {
            return (JustificatifPayment)listJustificatifPayment.get(0);
        }
        return null;
    }

    public JustificatifPayment getJustificatifPaymentByTicket(String idTicket) throws BasicException {
        JustificatifPayment mJustificatifPayment = (JustificatifPayment)new PreparedSentence(this.s, this.requestJustificatifPayment + " where TICKET = ? ", SerializerWriteString.INSTANCE, JustificatifPayment.getSerializerRead()).find((Object)idTicket);
        return mJustificatifPayment;
    }

    public JustificatifPayment addJustificatifPayment(final JustificatifPayment mJustificatifPayment) throws BasicException {
        final TicketInfo ticket = this.getTicketById(mJustificatifPayment.getTicket());
        this.idDocument = this.getDocumentTicket(ticket.getId()).getId();
        final EnteteInfo entete = this.getEnteteByTicket(ticket.getId(), true);
        JustificatifPayment lastJustificatifPayment = this.getLastJustificatifPayment();
        new PreparedSentence(this.s, "INSERT INTO JUSTIFICATIF_PAIEMENT (NUM_DOC, HORODATAGE, TICKET, TIMESTAMPGDH, TOTAL, REF_TICKET, ROUND_AMOUNT) VALUES(?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, DataLogicSales.this.idDocument);
                this.setString(2, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(mJustificatifPayment.getTimestampGDH()));
                this.setString(3, ticket.getId());
                this.setTimestamp(4, mJustificatifPayment.getTimestampGDH());
                this.setDouble(5, NumericUtils.round(ticket.getTotalOrder()));
                this.setInt(6, Integer.parseInt(entete.getId()));
                this.setBoolean(7, true);
            }
        });
        final JustificatifPayment thisJustificatifPayment = this.getLastJustificatifPayment();
        String justificatifPaymentEmprinte = this.mDataLogicSalesHelper.buildSignatureJustificatifPayment(ticket, thisJustificatifPayment, lastJustificatifPayment);
        final String signature = DataLogicSales.signer(justificatifPaymentEmprinte.toString());
        new PreparedSentence(this.s, "UPDATE  JUSTIFICATIF_PAIEMENT SET SIGNATURE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, signature);
                this.setInt(2, thisJustificatifPayment.getId());
            }
        });
        thisJustificatifPayment.setSignature(signature);
        return thisJustificatifPayment;
    }

    public DuplicataJustificatifPayment getDuplicataJustificatifPaymentById(final int id_justificatif_payment, final String type_doc) throws BasicException {
        DuplicataJustificatifPayment mDuplicataJustificatifPayment = (DuplicataJustificatifPayment)new PreparedSentence(this.s, this.requestDuplicataJustificatifPayment + " where NUM_JUSTIFICATIF_PAIEMENT = ? and TYPE_DOCUMENT = ? ORDER BY ID desc", SerializerWriteParams.INSTANCE, DuplicataJustificatifPayment.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_justificatif_payment);
                this.setString(2, type_doc);
            }
        });
        return mDuplicataJustificatifPayment;
    }

    public DuplicataJustificatifPayment getLastDuplicataJustificatifPayment() throws BasicException {
        List duplicatas = new PreparedSentence(this.s, this.requestDuplicataJustificatifPayment + " ORDER BY ID desc", null, DuplicataJustificatifPayment.getSerializerRead()).list();
        if (duplicatas.size() > 0) {
            return (DuplicataJustificatifPayment)duplicatas.get(0);
        }
        return null;
    }

    public DuplicataJustificatifPayment addDuplicataJustificatidPayment(final DuplicataJustificatifPayment duplicatat) throws BasicException {
        final String type_document = "JUSTIFICATIF_PAIEMENT";
        DuplicataJustificatifPayment previousDuplicata = this.getDuplicataJustificatifPaymentById(duplicatat.getmJustificatifPayment().getId(), type_document);
        int nbPrint = 1;
        if (previousDuplicata != null) {
            nbPrint = previousDuplicata.getImpression_number() + 1;
        }
        final int impression_number = nbPrint;
        DuplicataJustificatifPayment lastDuplicata = this.getLastDuplicataJustificatifPayment();
        final Date dateDuplication = new Date();
        new PreparedSentence(this.s, "INSERT INTO DUPLICATA_JUSTIFICATIF_PAIEMENT (TYPE_DOCUMENT, IMPRESSION_NUMBER, CODE_USER, DATE_IMPRESSION, NUM_JUSTIFICATIF_PAIEMENT, MOTIF_IMPRESSION, VERSION_SOFT) VALUES(?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_document);
                this.setInt(2, impression_number);
                this.setString(3, duplicatat.getCode_user());
                this.setTimestamp(4, dateDuplication);
                this.setInt(5, duplicatat.getmJustificatifPayment().getId());
                this.setString(6, duplicatat.getMotif_impression());
                this.setString(7, "10.0.1.27");
            }
        });
        final DuplicataJustificatifPayment thisDuplicata = this.getLastDuplicataJustificatifPayment();
        String justificatifPaymentEmprinte = this.mDataLogicSalesHelper.buildDuplicataJustificatifPaymentSignature(thisDuplicata, lastDuplicata);
        final String signature = DataLogicSales.signer(justificatifPaymentEmprinte);
        new PreparedSentence(this.s, "UPDATE DUPLICATA_JUSTIFICATIF_PAIEMENT SET SIGNATURE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, signature);
                this.setInt(2, thisDuplicata.getId());
            }
        });
        thisDuplicata.setSignature(signature);
        try {
            String user_id = AppLocal.user != null ? AppLocal.user.getId() : (AppLocal.user_maintenance != null ? AppLocal.user_maintenance.getId() : "");
            Journal.writeToJET(new Event(156, "Duplicatat d'un justificatif de paiement", user_id, "Id de duplicatat de justificatif de paiement", new Date().getTime(), String.valueOf(thisDuplicata.getId())));
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return thisDuplicata;
    }

    public final List<CaisseZ> getCaisseZ(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        List caissez = new PreparedSentence(this.s, this.requestCaisseZ + " LEFT OUTER JOIN caisse C ON H.caisse = C.ID  WHERE C.token = ?  AND H.dateOpen >= ? AND H.dateOpen  < ?  order by H.ID  ", SerializerWriteParams.INSTANCE, CaisseZ.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (CaisseZ caisse : caissez) {
            if (caisse.getUser_open_id() != null) {
                caisse.setUser_open(UserInfo.fetchOrStore(caisse.getUser_open_id(), this));
            } else {
                caisse.setUser_open(null);
            }
            if (caisse.getUser_close_id() != null) {
                caisse.setUser_close(UserInfo.fetchOrStore(caisse.getUser_close_id(), this));
                continue;
            }
            caisse.setUser_close(null);
        }
        return caissez;
    }

    private void updateInfoSiret(final MarqueNFC marqueNFC) throws BasicException {
        new PreparedSentence(this.s, "UPDATE MARUQENF525 SET NEW_SIRET = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, false);
                this.setInt(2, marqueNFC.getId());
            }
        });
    }

    private void setNewSiretAndResetPerpetual(final MarqueNFC marqueNFC) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  MARUQENF525 SET NEW_SIRET = ? , UPDATE_SIRET_AT = ?, OLD_SIRET = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, marqueNFC.isNew_siret());
                this.setTimestamp(2, new Date());
                this.setString(3, marqueNFC.getOld_siret());
                this.setInt(4, marqueNFC.getId());
            }
        });
        new PreparedSentence(this.s, "UPDATE GRAND_TOTAL SET BEFORE_PERPETUAL_RESET = 1", null).exec();
        new PreparedSentence(this.s, "UPDATE GRAND_TOTAL_PERIODE SET BEFORE_PERPETUAL_RESET = 1", null).exec();
    }

    public GrandTotalPeriode getLastGTlPBeforePerpetualReset(String typePeriode) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGTP + " where BEFORE_PERPETUAL_RESET = 1 and type_PERIODE = ? order by CAST (id AS Integer)  desc FETCH FIRST 1 rows only  ", SerializerWriteString.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)typePeriode);
        if (listTotaux.size() > 0) {
            return (GrandTotalPeriode)listTotaux.get(0);
        }
        return null;
    }

    public final GrandTotalTicket getLastGTTBeforePerpetualReset() throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGrandToTalTicket + "FROM GRAND_TOTAL where BEFORE_PERPETUAL_RESET = 1 order by  timestampGDH desc FETCH FIRST 1 rows only  ", null, GrandTotalTicket.getSerializerRead()).list();
        if (listTotaux.size() > 0) {
            return (GrandTotalTicket)listTotaux.get(0);
        }
        return null;
    }

    public final double getCumulePeriodeABS(Date myDate, String typePeriode, boolean after_perpetual_reset) throws BasicException {
        String request = after_perpetual_reset ? " AND t.BEFORE_PERPETUAL_RESET = 0 " : "";
        int myYear = myDate.getYear() + 1900;
        if (typePeriode != null && !typePeriode.equals("a")) {
            Object[] recsales;
            int myDay = myDate.getDate();
            int myMonth = myDate.getMonth() + 1;
            if (typePeriode.equals("m")) {
                final Date dateStartMonth = new Date(myDate.getTime());
                final Date dateEndMonth = new Date();
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStartMonth, dateEndMonth);
                String query = "SELECT SUM (ABS( t.grand_total)) FROM grand_total t WHERE t.timestampGDH >= ? AND t.timestampGDH < ? " + request;
                recsales = (Object[])new StaticSentence(this.s, query, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setTimestamp(1, dateStartMonth);
                        this.setTimestamp(2, dateEndMonth);
                    }
                });
            } else {
                final Date dateEnd = new Date();
                final Date dateStart = new Date(myDate.getTime());
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                String query = "SELECT SUM ( ABS(t.grand_total)) FROM grand_total t WHERE t.timestampGDH >= ? AND t.timestampGDH < ? " + request;
                recsales = (Object[])new StaticSentence(this.s, query, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setTimestamp(1, dateStart);
                        this.setTimestamp(2, dateEnd);
                    }
                });
            }
            if (recsales == null) {
                return 0.0;
            }
            double result = (Double)recsales[0];
            return (Double)recsales[0];
        }
        return 0.0;
    }

    public GrandTotalPeriode getLastMonthlyGrandTotalPeriode(Date myDate) throws BasicException {
        int myYear = myDate.getYear() + 1900;
        String year_period = myYear + "%";
        List listTotaux = new PreparedSentence(this.s, this.requestGTP + " where type_PERIODE = 'm' and ID like ? order by CAST (id AS Integer)  desc FETCH FIRST 1 rows only  ", SerializerWriteString.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)year_period);
        if (listTotaux.size() > 0) {
            return (GrandTotalPeriode)listTotaux.get(0);
        }
        return null;
    }

    private void writeOldCumulPerpetualInJET(double cumulPerpetual, double cumulPerpetualReel, MarqueNFC marqueNFC, String idUser) {
        try {
            Journal.writeToJET(new Event(128, "changement de l'entit\u00e9 assujettie d\u00e9tenant et utilisant le logiciel", idUser, "l'identification de l'entit\u00e9 /Grand Total Perp\u00e9tuel en Valeur Absolue (GTPVA) avant le changement", new Date().getTime(), marqueNFC.getOld_siret() + " / " + cumulPerpetual));
            Journal.writeToJET(new Event(128, "changement de l'entit\u00e9 assujettie d\u00e9tenant et utilisant le logiciel", idUser, "l'identification de l'entit\u00e9 /Grand Total Perp\u00e9tuel en Cumul Alg\u00e9brique (GTPCA)  avant le changement", new Date().getTime(), marqueNFC.getOld_siret() + " / " + cumulPerpetualReel));
        }
        catch (IOException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void checkCumulPerpetualReset(String idUser, boolean using_grand_total_ticket) throws BasicException {
        MarqueNFC marqueNFC = this.getMarqueNF();
        if (marqueNFC != null && marqueNFC.isNew_siret()) {
            boolean writeToJET = false;
            double cumulPerpetual = 0.0;
            double cumulPerpetualReel = 0.0;
            if (using_grand_total_ticket) {
                GrandTotalTicket grandTotalTicket = this.getLastGTTBeforePerpetualReset();
                if (grandTotalTicket != null) {
                    cumulPerpetual = grandTotalTicket.getCumulPerpetual();
                    cumulPerpetualReel = grandTotalTicket.getCumulPerpetualReel();
                    writeToJET = true;
                } else {
                    GrandTotalPeriode gtp = this.getLastGTlPBeforePerpetualReset("j");
                    if (gtp != null) {
                        cumulPerpetual = gtp.getCumulPerpetual();
                        cumulPerpetualReel = gtp.getCumulPerpetualReel();
                        writeToJET = true;
                    }
                }
            } else {
                GrandTotalPeriode gtp = this.getLastGTlPBeforePerpetualReset("j");
                if (gtp != null) {
                    cumulPerpetual = gtp.getCumulPerpetual();
                    cumulPerpetualReel = gtp.getCumulPerpetualReel();
                    writeToJET = true;
                }
            }
            if (writeToJET) {
                this.writeOldCumulPerpetualInJET(cumulPerpetual, cumulPerpetualReel, marqueNFC, idUser);
            }
            this.updateInfoSiret(marqueNFC);
        }
    }

    private EnteteInfo getEnteteNote(String idTicket) throws BasicException {
        List entete = new PreparedSentence(this.s, this.requestEnteteNote + "WHERE E.ticket = ? order by E.id desc ", SerializerWriteString.INSTANCE, EnteteInfo.getSerializerRead()).list((Object)idTicket);
        if (entete.size() > 0) {
            return (EnteteInfo)entete.get(0);
        }
        return null;
    }

    public List<ArchivPeriode> getArchivesByPeriode(String typePeriode, Date myDate, String typePeriodeFilter) throws BasicException {
        int myYear = myDate.getYear() + 1900;
        if (typePeriode.equals("j")) {
            StringBuilder monthBuilder = new StringBuilder();
            monthBuilder.append(com.openbravo.pos.util.DateUtils.SDF_ID_MONTH_PERIOD.format(myDate));
            monthBuilder.append("%");
            String month_period = monthBuilder.toString();
            final String period_cloture = typePeriodeFilter != null && typePeriodeFilter.equals("a") ? myYear + "%" : month_period;
            return new PreparedSentence(this.s, this.requestArchivPeriode + " FROM ARCHIV_PERIODE WHERE  id like ? and type_periode = 'j' order by CAST (id AS INTEGER)  ", SerializerWriteParams.INSTANCE, ArchivPeriode.getSerializerRead()).list((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, period_cloture);
                }
            });
        }
        if (typePeriode.equals("m")) {
            final String year_period = myYear + "%";
            return new PreparedSentence(this.s, this.requestArchivPeriode + " FROM ARCHIV_PERIODE WHERE id like ? and type_periode = 'm' order by CAST (id AS INTEGER)   ", SerializerWriteParams.INSTANCE, ArchivPeriode.getSerializerRead()).list((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, year_period);
                }
            });
        }
        return null;
    }

    public Duplicata getLastDuplicata(String type_doc) throws BasicException {
        List duplicatas = new PreparedSentence(this.s, this.requestDuplicata + "WHERE type_doc = ? ORDER BY id desc", SerializerWriteString.INSTANCE, Duplicata.getSerializerRead()).list((Object)type_doc);
        if (duplicatas.size() > 0) {
            return (Duplicata)duplicatas.get(0);
        }
        return null;
    }

    public final List<Duplicata> getDuplicataByPeriodeAndTypeDoc(String typePeriode, Date myDate, final String type_doc) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        List duplicatas = new PreparedSentence(this.s, this.requestDuplicata + "WHERE  CHECK_TYPE_DOC = 1 and type_doc = ? and date_impression >= ?  and date_impression <  ?  ORDER BY id ", SerializerWriteParams.INSTANCE, Duplicata.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_doc);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        return duplicatas;
    }

    public final List<DuplicataJustificatifPayment> getDuplicataJustificatifPaymentByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        List duplicatas = new PreparedSentence(this.s, this.requestDuplicataJustificatifPayment + "WHERE  DATE_IMPRESSION >= ?  and DATE_IMPRESSION <  ?  ORDER BY ID ", SerializerWriteParams.INSTANCE, DuplicataJustificatifPayment.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return duplicatas;
    }

    public final List<JustificatifPayment> getJustificatifPaymentByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                com.openbravo.pos.util.DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                com.openbravo.pos.util.DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                com.openbravo.pos.util.DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        List justificatifPayment = new PreparedSentence(this.s, this.requestJustificatifPayment + "WHERE  TIMESTAMPGDH >= ?  and TIMESTAMPGDH < ? ORDER BY ID  ", SerializerWriteParams.INSTANCE, JustificatifPayment.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return justificatifPayment;
    }

    private void setInfoFacture(Facture facture) throws BasicException {
        EnteteInfo entete;
        if (!facture.isInfo_sender_included() && (entete = this.getEnteteByTicket(facture.getTicket(), true)) != null) {
            facture.setInfo(entete);
        }
    }

    public final List<Facture> getFacturesBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        List factures = new PreparedSentence(this.s, this.requestFacture + "JOIN GRAND_TOTAL G ON F.ticket = G.ticket WHERE F.date_created >= ? AND F.date_created <= ? ORDER BY F.id ", SerializerWriteParams.INSTANCE, Facture.getSerializerReadWtithTvas()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (Facture facture : factures) {
            this.setInfoFacture(facture);
        }
        return factures;
    }

    public void addLineNote(final TicketLineInfo l, final TicketInfo ticket, final int idEntete, final Date dateEnteteNote, final String code_caisse) throws BasicException {
        double ttcWithDiscount;
        final double discount = l.getDiscountPriceWithoutTaxedOptions();
        final double ttc = NumericUtils.round(l.getHtAmount() + l.getTaxAmount());
        if (ttc - this.restReduction >= 0.0) {
            ttcWithDiscount = ttc - this.restReduction;
            double discountFromTicket = this.restReduction;
            this.restReduction = 0.0;
        } else {
            ttcWithDiscount = 0.0;
            double discountFromTicket = ttc;
            this.restReduction = this.restReduction - ttc;
        }
        final double rate_tax = l.getTaxInfo() != null ? l.getTaxInfo().getRate() : 0.0;
        new PreparedSentence(this.s, "INSERT INTO LINES_NOTE (ref_note, num_line, code_product, origin_data, descriptive_product, price_TTC, total_ttc,code_operator, timestampGDH, quantite ,discount ,taux_discount,horodatage, CODE_TAX, RATE_TAX, TOTAL_HT, code_caisse) VALUES(?, ?, ?, ?, ?,?,?,?,?,?,?,?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idEntete);
                this.setInt(2, l.getNumLine() + 1);
                this.setString(3, String.valueOf(l.getProductID()));
                this.setString(4, "IN");
                this.setString(5, l.getProductName());
                this.setDouble(6, NumericUtils.round(l.getPriceWithoutTaxedOptions()));
                this.setDouble(7, NumericUtils.round(ttc));
                this.setString(8, ticket.getUser().getId());
                this.setTimestamp(9, dateEnteteNote);
                this.setDouble(10, Math.abs(NumericUtils.round(l.getMultiply())));
                this.setDouble(11, NumericUtils.round(discount / l.getMultiply()));
                this.setDouble(12, NumericUtils.round(100.0 * NumericUtils.round(discount) / NumericUtils.round(l.getMultiply() * l.getPriceWithoutTaxedOptions())));
                if (dateEnteteNote != null) {
                    this.setString(13, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(dateEnteteNote));
                } else {
                    this.setString(13, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(new Date()));
                }
                this.setString(14, l.getTaxInfo() != null ? l.getTaxInfo().getId() : "000");
                this.setDouble(15, NumericUtils.round(rate_tax, 3));
                this.setDouble(16, NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax)));
                this.setString(17, code_caisse);
            }
        });
    }

    public TicketInfo getTicketByIdShared(final int id_shared_order) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE  T.paid = 0 AND T.STATUS <> 'cancel' AND T.ID_SHARED_ORDER = ?", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_shared_order);
            }
        });
        if (ticket != null) {
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return ticket;
    }

    public void cancelOrderPending(TicketInfo ticket, String raison, String idUser) throws BasicException, SQLException {
        this.cancelOrderPending(ticket, raison, idUser, false);
    }

    public void resetClotures() throws BasicException {
        new StaticSentence(this.s, "DELETE FROM GRAND_TOTAL_PERIODE  WHERE type_periode = 'm' ", null).exec();
    }

    public List<GrandTotalPeriode> getGrandTotauxJournalier(String date_periode) throws BasicException {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(date_periode);
        idBuilder.append("%");
        final String id = idBuilder.toString();
        return new PreparedSentence(this.s, this.requestGTP + "WHERE type_periode = 'j' and ID like ?  order by CAST (id AS INTEGER)   ", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
    }

    private String getRequestTags() {
        Object request_type_order;
        List<Integer> tags = AppLocal.TAGS;
        Object object = request_type_order = tags != null && !tags.isEmpty() ? " T.NUMBER in (" : "";
        if (tags != null && !tags.isEmpty()) {
            CharSequence[] tab_type_order = new String[tags.size()];
            int i = 0;
            for (int tag : tags) {
                tab_type_order[i] = String.valueOf(tag);
                ++i;
            }
            String text_type_order = String.join((CharSequence)",", tab_type_order);
            request_type_order = (String)request_type_order + text_type_order + ") ";
        }
        return request_type_order;
    }

    public void setSynchronized() throws BasicException {
        System.out.println("++++++++++++++++ Changes Status IS_SYNC_POSTGRE and IS_SYNC_CANCLED");
        new StaticSentence(this.s, "UPDATE TICKETS SET IS_SYNC_POSTGRE = 0 , IS_SYNC_CANCLED =0 ", SerializerWriteInteger.INSTANCE).exec();
    }

    public void setSynchronizedCloture() throws BasicException {
        System.out.println("++++++++++++++++ Changes Status ISSYNCHRONIZED and ISSYNCHRONIZED_PAYMENT");
        new StaticSentence(this.s, "UPDATE GRAND_TOTAL_PERIODE  SET ISSYNCHRONIZED = 0 ", SerializerWriteInteger.INSTANCE).exec();
    }

    public void addInfoKitchenToItem(final int id_item, final int id_item_kitchen) throws BasicException {
        new PreparedSentence(this.s, "UPDATE Product_ticket  SET ID_ITEM_KITCHEN = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_item_kitchen);
                this.setInt(2, id_item);
            }
        });
    }

    public void resetZglobal() throws BasicException {
        new PreparedSentence(this.s, "UPDATE GRAND_TOTAL_PERIODE  SET ADD_TO_Z_GLOBAL = 0 ", null).exec();
        new PreparedSentence(this.s, "delete from Z_GLOBAL ", null).exec();
    }

    public final Double getCA(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE  T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund'  AND T.CREATED >= ? AND T.CREATED <= ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final Integer getNbOrder(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT COUNT(DISTINCT T.ID) FROM  TICKETS T WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.CREATED > ? AND T.CREATED < ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Integer)recsales[0];
    }

    public final Double getTurnoverCanceled(final Date dateStart, final Date dateEnd) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT SUM(T.total) FROM TICKETS T WHERE T.paid = 1 AND T.STATUS = 'cancel' AND T.CREATED >= ? AND T.CREATED < ?", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (recsales == null) {
            return null;
        }
        return (Double)recsales[0];
    }

    public final List<TicketInfo> loadTicketCanceled(final Date dateStart, final Date dateEnd) throws BasicException {
        String request_hidden_orders = AppLocal.HIDE_ORDERS ? " AND T.PAID_IN_OTHER_CAISSE = 0 " : "";
        String sQuery = this.requestTicket + "WHERE T.paid = 1 AND T.STATUS = 'cancel' AND R.DATENEW >= ? AND R.DATENEW < ? " + request_hidden_orders;
        List tickets = new PreparedSentence(this.s, sQuery, SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return tickets;
    }

    public final List<TicketInfo> discountOrders(final Date dateStart, final Date dateEnd) throws BasicException {
        String sQuery = this.requestTicket + "WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND (T.discount <> 0 OR T.ID in (select L.TICKET from TICKETLINES L WHERE L.discount <> 0)) AND R.DATENEW >= ? AND R.DATENEW < ? ";
        List tickets = new PreparedSentence(this.s, sQuery, SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            List<TicketLineInfo> lines = this.loadLines(ticket.getId());
            List<TicketLineInfo> linesExterne = this.getTicketLineExterne(ticket.getId());
            lines.addAll(linesExterne);
            ticket.setLines(lines);
        }
        return tickets;
    }

    private void cancelOldOrders(String userId) throws BasicException, SQLException {
        List<TicketInfo> tickets = this.getOrdersPending();
        for (TicketInfo ticket : tickets) {
            this.cancelOrderPending(ticket, "cloture periode", userId);
        }
    }

    public final List<TicketInfo> getOrdersPending() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE  T.paid = 0 AND STATUS <> 'cancel' and T.PLATFORM_ORDER = 0 ", null, new SerializerReadClass(TicketInfo.class)).list();
        return tickets;
    }

    public final TicketInfo getTicketByOnlineId(String idOnlineOrder) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE T.ID_ONLINE_ORDER = ? ", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)idOnlineOrder);
        if (ticket != null) {
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return ticket;
    }

    public void updateGTP(final int number_orders_platform, final String id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  GRAND_TOTAL_PERIODE SET NUMBER_ORDERS_PLATFORM = ?  WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, number_orders_platform);
                this.setString(2, id);
            }
        });
    }

    private void addTicketLineDivers(TicketInfo ticket, final TicketLineInfo l) throws BasicException, SQLException {
        try {
            String SQL = "INSERT INTO TICKETLINES (TICKET, UNITS, PRICE, menu, htAmount, taxAmount, nextElement, note, discount, sizeproduct, label_discount, paid, name_sizeproduct, units_paid, place_served, time_served, numero_line, label, PRINTER_KITCHEN, PROMO_BASKET, TYPE_DISCOUNT, PROMO_PRODUCT, POINTS_LOYALTY, NAME_PRODUCT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
            this.pstmt.setString(1, ticket.getId());
            if (ticket.getTicketType() != 1) {
                this.pstmt.setDouble(2, NumericUtils.round(l.getMultiply()));
            } else {
                this.pstmt.setDouble(2, -1.0 * Math.abs(NumericUtils.round(l.getMultiply())));
            }
            this.pstmt.setDouble(3, NumericUtils.round(l.getPrice(), 2));
            this.pstmt.setBoolean(4, l.isMenu());
            this.pstmt.setDouble(5, NumericUtils.round(l.getHtAmount(), 2));
            this.pstmt.setDouble(6, NumericUtils.round(l.getTaxAmount(), 2));
            this.pstmt.setBoolean(7, false);
            this.pstmt.setString(8, l.getNote());
            this.pstmt.setDouble(9, NumericUtils.round(l.getValueDiscount(), 2));
            this.pstmt.setString(10, l.getSizeProduct());
            this.pstmt.setString(11, l.getLabelDiscount());
            this.pstmt.setBoolean(12, l.isPaid());
            this.pstmt.setString(13, l.getName_sizeProduct());
            this.pstmt.setDouble(14, NumericUtils.round(l.getUnits_paid()));
            this.pstmt.setString(15, l.getPlace_served());
            this.pstmt.setString(16, l.getTime_served());
            this.pstmt.setInt(17, l.getNumero_line());
            this.pstmt.setBoolean(18, l.isLabel());
            this.pstmt.setString(19, l.getPrinter_kitchen());
            this.pstmt.setBoolean(20, l.isPromo_basket());
            this.pstmt.setString(21, l.getType_discount());
            this.pstmt.setBoolean(22, l.isPromo_product());
            this.pstmt.setDouble(23, NumericUtils.round(l.getPoints_loyalty()));
            this.pstmt.setString(24, l.getNameProduct());
            this.pstmt.executeUpdate();
            ResultSet rs = this.pstmt.getGeneratedKeys();
            if (rs.next()) {
                int last_inserted_id;
                this.idTicketLine = last_inserted_id = rs.getInt(1);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (l.getTaxInfo() != null) {
            new PreparedSentence(this.s, "UPDATE  TICKETLINES SET TAXID = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, l.getTaxInfo().getId());
                    this.setInt(2, DataLogicSales.this.idTicketLine);
                }
            });
        }
        for (ProductTicket product : l.getListProducts()) {
            this.addProductLine(product, this.idTicketLine);
        }
        for (OptionItemOrder supplement : l.getListSupplements()) {
            this.addOptionLine(supplement, this.idTicketLine);
        }
        l.setID(this.idTicketLine);
    }

    public List<TicketLineInfo> loadLinesPlatform(String ticket) throws BasicException {
        List lines = new PreparedSentence(this.s, this.requestLine + " WHERE L.TICKET = ? AND L.PRODUCT is not null ORDER BY L.ID ", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketLineInfo.class)).list((Object)ticket);
        List ticketsLines = new PreparedSentence(this.s, this.requestLinePlatform + " WHERE L.TICKET = ? AND L.PRODUCT is null ORDER BY L.ID ", SerializerWriteString.INSTANCE, TicketLineInfo.getSerializerReadPlatform()).list((Object)ticket);
        lines.addAll(ticketsLines);
        for (TicketLineInfo ticketsLine : lines) {
            List options = new PreparedSentence(this.s, this.requestSuplementLine, SerializerWriteInteger.INSTANCE, OptionItemOrder.getSerializerRead()).list((Object)ticketsLine.getID());
            List options_platform = new PreparedSentence(this.s, this.requestSuplementLinePlatform, SerializerWriteInteger.INSTANCE, OptionItemOrder.getSerializerRead()).list((Object)ticketsLine.getID());
            options.addAll(options_platform);
            ticketsLine.setListSupplements(options);
            List subProducts = new PreparedSentence(this.s, this.requestProductTicketPlatform, SerializerWriteInteger.INSTANCE, ProductTicket.getSerializerRead()).list((Object)ticketsLine.getID());
            ticketsLine.setListProducts(subProducts);
        }
        List<TicketLineInfo> linesDivers = this.getTicketLineExterne(ticket);
        lines.addAll(linesDivers);
        return lines;
    }

    public final List<TicketInfo> loadPlatformTicketsByType(final String type_order, final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE type = ?  AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_order);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public void setIdGlobalItem(final int id, String tableName, String columnName, String id_global) throws BasicException {
        if (AppLocal.GENERATE_ID_GLOBAL_ITEMS && !AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS && AppLocal.MODEL_CAISSE != null && (AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre") || AppLocal.MODEL_CAISSE.equalsIgnoreCase("Standalone")) || id_global != null && !id_global.isEmpty()) {
            final String id_global_final = AppLocal.GENERATE_ID_GLOBAL_ITEMS && !AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS && AppLocal.MODEL_CAISSE != null && (AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre") || AppLocal.MODEL_CAISSE.equalsIgnoreCase("Standalone")) ? UUID.randomUUID().toString() : id_global;
            new PreparedSentence(this.s, "UPDATE " + tableName + " SET " + columnName + " = ?  WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, id_global_final);
                    this.setInt(2, id);
                }
            });
        }
    }

    public SupplementItemInfo getSuppelementByPlu(String item_plu) throws BasicException {
        return (SupplementItemInfo)new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.ITEM_PLU = ? ", SerializerWriteString.INSTANCE, SupplementItemInfo.getSerializerRead()).find((Object)item_plu);
    }

    public final List<TicketInfo> loadDishopTickets(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE (type in ('Commande en ligne', 'Dishop') or SENT_FROM = 'Dishop')  AND R.DATENEW BETWEEN ? AND ? ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null) continue;
            this.loadOrderInfo(ticket);
        }
        return tickets;
    }

    public final LivreurInfo getLivreur(final String idlivreur) throws BasicException {
        return (LivreurInfo)new PreparedSentence(this.s, "SELECT  ID, NAME, APPPASSWORD FROM PEOPLE WHERE ID = ? ORDER BY NAME", SerializerWriteParams.INSTANCE, new SerializerReadClass(LivreurInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idlivreur);
            }
        }).get(0);
    }

    public final TicketInfo getTicketByIdAndIdOnline(final String idTicket, final String id_online_order) throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE T.ID = ? OR T.ID_ONLINE_ORDER = ? ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idTicket);
                this.setString(2, id_online_order);
            }
        });
        if (ticket != null) {
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.loadCustomerExt(customerid));
        }
        return ticket;
    }

    public final List<TicketInfo> loadAllOrders(final Date dateStart, final Date dateEnd) throws BasicException {
        String request_hidden_orders = AppLocal.HIDE_ORDERS ? " AND T.PAID_IN_OTHER_CAISSE = 0 " : "";
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE T.CREATED >= ? AND T.CREATED <= ? " + request_hidden_orders + "ORDER BY T.TICKETID desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        Iterator iterator = tickets.iterator();
        while (iterator.hasNext()) {
            TicketInfo ticket;
            int idTable = (ticket = (TicketInfo)iterator.next()).getIdTable();
            ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
            List<TicketLineInfo> lines = this.loadLines(ticket.getId());
            List<TicketLineInfo> linesExterne = this.getTicketLineExterne(ticket.getId());
            lines.addAll(linesExterne);
            ticket.setPayments(this.findPaymetsByIdTicket(ticket.getId()));
            ticket.setLines(lines);
        }
        return tickets;
    }

    public void addPubBornePhoto(final PhotoDispaly photo) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PHOTO_PUB_BORNE(path, LAST_UPDATE) VALUES(?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, photo.getPath());
                this.setTimestamp(2, photo.getLast_update());
            }
        });
    }

    public void deleteJustificatifByTicket(final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM JUSTIFICATIF_PAIEMENT WHERE TICKET in (SELECT id from TICKETS WHERE CLOSED = 1 AND created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void setEnableTAX(final String id, final boolean enabled) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TAXCATEGORIES SET ENABLED = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, enabled);
                this.setString(2, id);
            }
        });
    }

    public final List<TaxInfo> getEnabledTax() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, RATE, ENABLED, TAXE_GLOBAL FROM TAXCATEGORIES where REMOVED = 0 and ENABLED = 1 and TAXE_GLOBAL = 0 ORDER BY RATE ", null, TaxInfo.getSerializerRead()).list();
    }

    public final String getTicketByIdPlatform(String idOrderPlatform) throws BasicException {
        Object[] result = (Object[])new PreparedSentence(this.s, this.requestTicket + "WHERE T.ID_ONLINE_ORDER = ? ", SerializerWriteString.INSTANCE, new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)idOrderPlatform);
        if (result == null) {
            return null;
        }
        return (String)result[0];
    }

    private void deleteDuplicataJustificatifByTicket(final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM DUPLICATA_JUSTIFICATIF_PAIEMENT where NUM_JUSTIFICATIF_PAIEMENT in (select J.ID from JUSTIFICATIF_PAIEMENT J  WHERE J.TICKET in (SELECT T.id from TICKETS T WHERE T.CLOSED = 1 AND T.created <= ?))", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public List<GrandTotalPeriode> loadGTPToUpdateTaxes(final String type) throws BasicException {
        ArrayList listTotaux = new PreparedSentence(this.s, this.requestGTP + " WHERE type_PERIODE = ?  order by timestampGDH ASC", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type);
            }
        });
        if (listTotaux == null) {
            listTotaux = new ArrayList();
        }
        return listTotaux;
    }

    public void addPaymentsToOldGTP(final GrandTotalPeriode grandTotalPeriode) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  GRAND_TOTAL_PERIODE SET CREDIT_CARD_TOTAL = ?, DEBIT_CARD_TOTAL = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(grandTotalPeriode.getCredit_card_total()));
                this.setDouble(2, NumericUtils.round(grandTotalPeriode.getDebit_card_total()));
                this.setString(3, grandTotalPeriode.getId());
            }
        });
    }

    public final HashMap<String, Object> getPaymentsInfoPeriode(String date_periode, String typePeriod) throws BasicException {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(date_periode);
        idBuilder.append("%");
        String requestTypeOrder = typePeriod != null && typePeriod.equals("m") ? " type_periode = 'm' " : " type_periode = 'j' ";
        final String id = idBuilder.toString();
        HashMap<String, Object> map_infos = new HashMap<String, Object>();
        Object[] cumul = (Object[])new StaticSentence(this.s, " select sum(CREDIT_CARD_TOTAL), sum(DEBIT_CARD_TOTAL) from GRAND_TOTAL_PERIODE where " + requestTypeOrder + " and ID like ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE, Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
        if (cumul == null) {
            return null;
        }
        map_infos.put("CREDIT_CARD_TOTAL", (Double)cumul[0]);
        map_infos.put("DEBIT_CARD_TOTAL", (Double)cumul[1]);
        return map_infos;
    }

    private void addRecapTaxNote(final TaxLineInfo taxe, final int enteteNoteId) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO RECAP_TAX_NOTE (TOTAL_HT, CODE_TAX, RATE_TAX, TOTAL_TAX, TOTAL_TTC, REF_NOTE) VALUES(?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(taxe.getSumHT()));
                this.setString(2, taxe.getId());
                this.setDouble(3, NumericUtils.round(taxe.getRate(), 3));
                this.setDouble(4, NumericUtils.round(taxe.getAmount()));
                this.setDouble(5, NumericUtils.round(taxe.getSumTTC()));
                this.setInt(6, enteteNoteId);
            }
        });
    }

    public void addRecapGeneralNote(final TicketInfo ticket, final int idEntete) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO RECAP_GENERAL_NOTE (TOTAL_HT, TOTAL_TTC, REF_NOTE, TOTAL_DISCOUNT) VALUES(?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(DataLogicSales.this.totalHT));
                this.setDouble(2, NumericUtils.round(ticket.getTotal()));
                this.setInt(3, idEntete);
                this.setDouble(4, NumericUtils.round(ticket.getGlobalDiscountLinesAndOrder()));
            }
        });
    }

    public void addLineFacture(TicketLineInfo l, TicketInfo ticket, Facture facture) throws BasicException {
        double discountFromTicket;
        double ttcWithDiscount;
        double ttc = NumericUtils.round(l.getHtAmount() + l.getTaxAmount());
        if (ttc - this.restReduction >= 0.0) {
            ttcWithDiscount = ttc - this.restReduction;
            discountFromTicket = this.restReduction;
            this.restReduction = 0.0;
        } else {
            ttcWithDiscount = 0.0;
            discountFromTicket = ttc;
            this.restReduction = this.restReduction - ttc;
        }
        double rate_tax = l.getTaxInfo() != null ? l.getTaxInfo().getRate() : 0.0;
        double total_tax = NumericUtils.round(ttcWithDiscount) - Math.abs(NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax)));
        double total_ht_discounted = (NumericUtils.round(l.getPrice()) - NumericUtils.round((l.getDiscount() + discountFromTicket) / l.getMultiply())) / (1.0 + l.getTaxRate());
        LineFacture lineFacture = new LineFacture();
        lineFacture.setNum_line(l.getNumLine() + 1);
        lineFacture.setCode_product(String.valueOf(l.getProductID()));
        lineFacture.setLabel_product(l.getProductName());
        int multiply = facture.getType_operation() != null && facture.getType_operation().equals(Facture.CANCEL) ? -1 : 1;
        lineFacture.setQuantity((double)multiply * Math.abs(NumericUtils.round(l.getMultiply())));
        lineFacture.setPrice_ht(Math.abs(NumericUtils.round(l.getPrice() / (1.0 + rate_tax))));
        lineFacture.setTaux_discount((double)multiply * Math.abs(NumericUtils.round(100.0 * NumericUtils.round(l.getDiscount() + discountFromTicket) / NumericUtils.round(l.getMultiply() * l.getPrice()))));
        lineFacture.setTotal_ht_discounted((double)multiply * Math.abs(NumericUtils.round(total_ht_discounted)));
        lineFacture.setTotal_ht((double)multiply * Math.abs(NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax))));
        lineFacture.setCode_tax(l.getTaxInfo() != null ? l.getTaxInfo().getId() : "000");
        lineFacture.setRate_tax(NumericUtils.round(rate_tax, 3));
        lineFacture.setPrice_ttc(NumericUtils.round(l.getPrice()));
        lineFacture.setTotal_tax((double)multiply * Math.abs(NumericUtils.round(total_tax)));
        lineFacture.setTotal_ttc((double)multiply * Math.abs(NumericUtils.round(ttcWithDiscount)));
        lineFacture.setTimestampGDH(facture.getDateFacture() != null ? facture.getDateFacture() : new Date());
        lineFacture.setHorodatage(com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(lineFacture.getTimestampGDH()));
        lineFacture.setRef_facture((int)facture.getId());
        facture.getLines().add(lineFacture);
        this.addLineFacture(lineFacture);
    }

    private void addLineFacture(final LineFacture lineFacture) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO LINES_FACTURE (NUM_LINE, CODE_PRODUCT, LABEL_PRODUCT, QUANTITY, PRICE_HT, TAUX_DISCOUNT, TOTAL_HT_DISCOUNTED, TOTAL_HT, CODE_TAX, RATE_TAX, PRICE_TTC, TOTAL_TAX, TOTAL_TTC, timestampGDH, horodatage, REF_FACTURE) VALUES(?,?,?,?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, lineFacture.getNum_line());
                this.setString(2, lineFacture.getCode_product());
                this.setString(3, lineFacture.getLabel_product());
                this.setDouble(4, lineFacture.getQuantity());
                this.setDouble(5, lineFacture.getPrice_ht());
                this.setDouble(6, lineFacture.getTaux_discount());
                this.setDouble(7, lineFacture.getTotal_ht_discounted());
                this.setDouble(8, lineFacture.getTotal_ht());
                this.setString(9, lineFacture.getCode_tax());
                this.setDouble(10, lineFacture.getRate_tax());
                this.setDouble(11, lineFacture.getPrice_ttc());
                this.setDouble(12, lineFacture.getTotal_tax());
                this.setDouble(13, lineFacture.getTotal_ttc());
                this.setTimestamp(14, lineFacture.getTimestampGDH());
                this.setString(15, lineFacture.getHorodatage());
                this.setInt(16, lineFacture.getRef_facture());
            }
        });
    }

    private void addRecapTaxFacture(TaxLineInfo taxe, Facture facture) throws BasicException {
        RecapTaxFacture recapTaxFacture = new RecapTaxFacture();
        System.out.println("facture.getType_operation() : " + facture.getType_operation());
        if (facture.getType_operation() != null && facture.getType_operation().equals(Facture.CANCEL)) {
            recapTaxFacture.setTotal_ht(-1.0 * NumericUtils.round(taxe.getSumHT()));
            recapTaxFacture.setTotal_tax(-1.0 * NumericUtils.round(taxe.getAmount()));
            recapTaxFacture.setTotal_ttc(-1.0 * NumericUtils.round(taxe.getSumTTC()));
        } else {
            recapTaxFacture.setTotal_ht(NumericUtils.round(taxe.getSumHT()));
            recapTaxFacture.setTotal_tax(NumericUtils.round(taxe.getAmount()));
            recapTaxFacture.setTotal_ttc(NumericUtils.round(taxe.getSumTTC()));
        }
        recapTaxFacture.setCode_tax(taxe.getId());
        recapTaxFacture.setRate_tax(NumericUtils.round(taxe.getRate(), 3));
        recapTaxFacture.setRef_facture((int)facture.getId());
        facture.getRecapTaxes().add(recapTaxFacture);
        this.addRecapTaxFacture(recapTaxFacture);
    }

    private void addRecapTaxFacture(final RecapTaxFacture recapTaxFacture) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO RECAP_TAX_FACTURE (TOTAL_HT, TOTAL_TAX, CODE_TAX, RATE_TAX, TOTAL_TTC, REF_FACTURE) VALUES(?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, recapTaxFacture.getTotal_ht());
                this.setDouble(2, recapTaxFacture.getTotal_tax());
                this.setString(3, recapTaxFacture.getCode_tax());
                this.setDouble(4, recapTaxFacture.getRate_tax());
                this.setDouble(5, recapTaxFacture.getTotal_ttc());
                this.setInt(6, recapTaxFacture.getRef_facture());
            }
        });
    }

    public void addRecapGeneralFacture(TicketInfo ticket, Facture facture) throws BasicException {
        double total_tax = NumericUtils.round(Math.abs(ticket.getTotal())) - NumericUtils.round(Math.abs(this.totalHT));
        RecapGeneralFacture recapGeneralFacture = new RecapGeneralFacture();
        if (facture.getType_operation() != null && facture.getType_operation().equals(Facture.CANCEL)) {
            recapGeneralFacture.setTotal_ht(-1.0 * NumericUtils.round(Math.abs(this.totalHT)));
            recapGeneralFacture.setTotal_ttc(-1.0 * NumericUtils.round(Math.abs(ticket.getTotal())));
            recapGeneralFacture.setTotal_tax(-1.0 * NumericUtils.round(Math.abs(total_tax)));
            recapGeneralFacture.setTotal_discount(-1.0 * NumericUtils.round(Math.abs(ticket.getGlobalDiscountLinesAndOrder())));
        } else {
            recapGeneralFacture.setTotal_ht(NumericUtils.round(Math.abs(this.totalHT)));
            recapGeneralFacture.setTotal_ttc(NumericUtils.round(Math.abs(ticket.getTotal())));
            recapGeneralFacture.setTotal_tax(NumericUtils.round(Math.abs(total_tax)));
            recapGeneralFacture.setTotal_discount(NumericUtils.round(Math.abs(ticket.getGlobalDiscountLinesAndOrder())));
        }
        recapGeneralFacture.setRef_facture((int)facture.getId());
        facture.setRecapGeneralFacture(recapGeneralFacture);
        this.addRecapGeneralFacture(recapGeneralFacture);
    }

    private void addRecapGeneralFacture(final RecapGeneralFacture recapGeneralFacture) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO RECAP_GENERAL_FACTURE (TOTAL_HT, TOTAL_TTC, TOTAL_TAX, TOTAL_DISCOUNT, REF_FACTURE) VALUES(?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, recapGeneralFacture.getTotal_ht());
                this.setDouble(2, recapGeneralFacture.getTotal_ttc());
                this.setDouble(3, recapGeneralFacture.getTotal_tax());
                this.setDouble(4, recapGeneralFacture.getTotal_discount());
                this.setInt(5, recapGeneralFacture.getRef_facture());
            }
        });
    }

    public final GrandTotalTicket getGrandTotalTicket(String idTicket) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGrandToTalTicket + "FROM GRAND_TOTAL WHERE ticket = ? ", SerializerWriteString.INSTANCE, Document.getSerializerRead()).list((Object)idTicket);
        if (listTotaux.size() > 0) {
            return (GrandTotalTicket)listTotaux.get(0);
        }
        return null;
    }

    public final TicketInfo getTicketById(String idTicket) throws BasicException {
        return this.getTicketById(idTicket, true);
    }

    public void generateTotalTax() throws BasicException {
        new PreparedSentence(this.s, "delete from total_tax", null).exec();
        new PreparedSentence(this.s, "INSERT INTO TOTAL_TAX ( num_line, total_ht, code_tax, rate_tax, total_tax, total_ttc, ticket, num_doc , timestampGDH, REF_ORIGINE, TAXE_GLOBAL) SELECT 1, 0, 'tps', 0.05, T.TPS, 0, T.ID, TRIM(CAST (D.ID AS CHAR(10))), T.CREATED, E.ID, 1 FROM Tickets T JOIN DOCUMENT D ON T.ID = D.TICKET JOIN ENTETE E ON T.ID = E.TICKET", null).exec();
        new PreparedSentence(this.s, "INSERT INTO TOTAL_TAX ( num_line, total_ht, code_tax, rate_tax, total_tax, total_ttc, ticket, num_doc , timestampGDH, REF_ORIGINE, TAXE_GLOBAL) SELECT 1, 0, 'tvq', 0.09975, T.TVQ, 0, T.ID, TRIM(CAST (D.ID AS CHAR(10))), T.CREATED, E.ID, 1 FROM Tickets T JOIN DOCUMENT D ON T.ID = D.TICKET JOIN ENTETE E ON T.ID = E.TICKET ", null).exec();
    }

    private void addGTPTaxes(final GroupedTax gtpTaxe) throws BasicException {
        String requestInsertTaxes = "insert into GTP_TAXES(ID_PERIOD, CODE_TAX, NAME, RATE_TAX, TOTAL_HT, TOTAL_TAX, TOTAL_TTC, TAXE_GLOBAL, type_periode) values (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        new PreparedSentence(this.s, requestInsertTaxes, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, gtpTaxe.getId_period());
                this.setString(2, gtpTaxe.getCode_taxe());
                this.setString(3, gtpTaxe.getName());
                this.setDouble(4, gtpTaxe.getRate());
                this.setDouble(5, NumericUtils.round(gtpTaxe.getTotal_ht()));
                this.setDouble(6, NumericUtils.round(gtpTaxe.getTotal_tax()));
                this.setDouble(7, NumericUtils.round(gtpTaxe.getTotal_ttc()));
                this.setBoolean(8, gtpTaxe.isTaxe_global());
                this.setString(9, gtpTaxe.getType_periode());
            }
        });
    }

    public final List<TaxInfo> getGloablTaxes() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, RATE, ENABLED, TAXE_GLOBAL FROM TAXCATEGORIES where REMOVED = 0 and ENABLED = 1 and TAXE_GLOBAL = 1 ORDER BY RATE ", null, TaxInfo.getSerializerRead()).list();
    }

    public final List<TaxInfo> getAllTax(final boolean globalTaxes) throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, RATE, ENABLED, TAXE_GLOBAL FROM TAXCATEGORIES where REMOVED = 0 and TAXE_GLOBAL = ? ORDER BY RATE ", SerializerWriteParams.INSTANCE, TaxInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, globalTaxes);
            }
        });
    }

    public void addLine(final TicketLineInfo line, final OptionItemOrder option, final TicketInfo ticket, final int documentId, final int idEntete, final String code_caisse) throws BasicException {
        double discountFromTicket;
        double ttcWithDiscount;
        final double discount = option.getDiscount(line.getDiscountPercent(), line.getMultiply());
        double ttc = NumericUtils.round(option.getHtAmount() + option.getTaxAmount());
        if (ttc - this.restReduction >= 0.0) {
            ttcWithDiscount = ttc - this.restReduction;
            discountFromTicket = this.restReduction;
            this.restReduction = 0.0;
        } else {
            ttcWithDiscount = 0.0;
            discountFromTicket = ttc;
            this.restReduction = this.restReduction - ttc;
        }
        final double rate_tax = option.getTax() != null ? option.getTax().getRate() : 0.0;
        final boolean isRefund = ticket.getTicketType() == 1;
        final double total_tax = NumericUtils.round(ttcWithDiscount) - Math.abs(NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax)));
        new PreparedSentence(this.s, "INSERT INTO LINES ( num_doc, num_line, code_product, origin_data, descriptive_product, code_tax, rate_tax, price_HT, price_TTC, total_ht, total_ttc, code_user, timestampGDH, centre_profit, ticket ,quantite ,code_operator ,discount ,taux_discount,horodatage, TYPE_OPERATION , code_Caisse , REF_ORIGINE, TOTAL_TAX) VALUES(?,?,?,?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, String.valueOf(documentId));
                this.setInt(2, option.getNumLine() + 1);
                this.setString(3, String.valueOf(option.getSupplement()));
                this.setString(4, "IN");
                this.setString(5, option.getNameSupplement());
                this.setString(6, option.getTax() != null ? option.getTax().getId() : "000");
                this.setDouble(7, NumericUtils.round(rate_tax, 3));
                this.setDouble(8, NumericUtils.round(option.getUnitPrice() / (1.0 + rate_tax)));
                this.setDouble(9, NumericUtils.round(option.getUnitPrice()));
                this.setString(12, ticket.getUser().getId());
                this.setTimestamp(13, ticket.getLastUpdate());
                this.setString(14, "N/A");
                this.setString(15, ticket.getId());
                if (isRefund) {
                    this.setDouble(16, -1.0 * Math.abs(NumericUtils.round((double)option.getNumberOption() * line.getMultiply())));
                    this.setDouble(10, -1.0 * Math.abs(NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax))));
                    this.setDouble(11, -1.0 * Math.abs(NumericUtils.round(ttcWithDiscount)));
                    this.setString(21, "Annulation");
                    this.setDouble(18, -1.0 * Math.abs(NumericUtils.round((discount + discountFromTicket) / ((double)option.getNumberOption() * line.getMultiply()))));
                    this.setDouble(19, -1.0 * Math.abs(NumericUtils.round(100.0 * NumericUtils.round(discount + discountFromTicket) / NumericUtils.round(option.getFull_price() * line.getMultiply()))));
                    this.setDouble(24, -1.0 * Math.abs(NumericUtils.round(total_tax)));
                } else {
                    this.setDouble(10, NumericUtils.round(ttcWithDiscount / (1.0 + rate_tax)));
                    this.setDouble(11, NumericUtils.round(ttcWithDiscount));
                    this.setDouble(16, Math.abs(NumericUtils.round((double)option.getNumberOption() * line.getMultiply())));
                    this.setString(21, "Vente");
                    this.setDouble(18, NumericUtils.round((discount + discountFromTicket) / ((double)option.getNumberOption() * line.getMultiply())));
                    this.setDouble(19, NumericUtils.round(100.0 * NumericUtils.round(discount + discountFromTicket) / NumericUtils.round(option.getFull_price() * line.getMultiply())));
                    this.setDouble(24, Math.abs(NumericUtils.round(total_tax)));
                }
                this.setString(17, ticket.getUser().getId());
                if (ticket.getLastUpdate() != null) {
                    this.setString(20, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getLastUpdate()));
                } else if (ticket.getDate() != null) {
                    this.setString(20, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getDate()));
                } else {
                    this.setString(20, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(new Date()));
                }
                this.setString(22, code_caisse);
                this.setInt(23, idEntete);
            }
        });
    }

    public void addLineNote(final TicketLineInfo line, final OptionItemOrder option, final TicketInfo ticket, final int idEntete) throws BasicException {
        final double discount = option.getDiscount(line.getDiscountPercent(), line.getMultiply());
        final double ttc = NumericUtils.round(option.getHtAmount() + option.getTaxAmount());
        new PreparedSentence(this.s, "INSERT INTO LINES_NOTE (ref_note, num_line, code_product, origin_data, descriptive_product, price_TTC, total_ttc,code_operator, timestampGDH, quantite ,discount ,taux_discount,horodatage) VALUES(?,?,?,?,?,?,?,?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idEntete);
                this.setInt(2, option.getNumLine() + 1);
                this.setString(3, String.valueOf(option.getSupplement()));
                this.setString(4, "IN");
                this.setString(5, option.getNameSupplement());
                this.setDouble(6, NumericUtils.round(option.getUnitPrice()));
                this.setDouble(7, NumericUtils.round(ttc));
                this.setString(8, ticket.getUser().getId());
                this.setTimestamp(9, ticket.getLastUpdate());
                this.setDouble(10, Math.abs(NumericUtils.round((double)option.getNumberOption() * line.getMultiply())));
                this.setDouble(11, NumericUtils.round(discount / ((double)option.getNumberOption() * line.getMultiply())));
                this.setDouble(12, NumericUtils.round(100.0 * NumericUtils.round(discount) / NumericUtils.round(line.getMultiply() * option.getFull_price())));
                if (ticket.getLastUpdate() != null) {
                    this.setString(13, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getLastUpdate()));
                } else if (ticket.getDate() != null) {
                    this.setString(13, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(ticket.getDate()));
                } else {
                    this.setString(13, com.openbravo.pos.util.DateUtils.SDF_DATE_SIGNATURE.format(new Date()));
                }
            }
        });
    }

    public final List<TaxInfo> getTaxItems() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME, RATE, ENABLED, TAXE_GLOBAL FROM TAXCATEGORIES where REMOVED = 0 and TAXE_GLOBAL = 0 ORDER BY RATE ", null, TaxInfo.getSerializerRead()).list();
    }

    public final List<CategoryInfo> getCategories() throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory, null, CategoryInfo.getSerializerRead()).list();
    }

    public final List<TicketInfo> loadNotesCanceled(final Date dateStart, final Date dateEnd) throws BasicException {
        String request_hidden_orders = AppLocal.HIDE_ORDERS ? " AND T.PAID_IN_OTHER_CAISSE = 0 " : "";
        String sQuery = this.requestTicket + "WHERE T.paid = 0 AND T.STATUS = 'cancel' AND R.DATENEW >= ? AND R.DATENEW < ? " + request_hidden_orders;
        List tickets = new PreparedSentence(this.s, sQuery, SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return tickets;
    }

    public void deleteSupplement(int idSupplement, boolean removed_definitely) throws BasicException {
        String request_removed = removed_definitely || AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "UPDATE SUPPLEMENT SET " + request_removed + " WHERE id = ?", SerializerWriteInteger.INSTANCE).exec((Object)idSupplement);
        new StaticSentence(this.s, "UPDATE supplement_item SET " + request_removed + " WHERE id_supplement = ?", SerializerWriteInteger.INSTANCE).exec((Object)idSupplement);
    }

    public final ProductInfoExt getProductInfoById(int id, boolean catalog_borne) throws BasicException {
        return this.getProductInfoById(id, catalog_borne, true);
    }

    public final TicketInfo getLastCmiOrder() throws BasicException {
        String query = this.requestTicket + "WHERE DATE(CREATED) = CURRENT_DATE AND (session_id IS NOT NULL AND session_id <> 'null' AND session_id <> '') ORDER BY CREATED DESC";
        List tickets = new PreparedSentence(this.s, query, null, new SerializerReadClass(TicketInfo.class)).list();
        if (tickets.isEmpty()) {
            return null;
        }
        return (TicketInfo)tickets.get(0);
    }

    public final void UpdateOldUserMaintain(AppUser user, String code) throws BasicException {
        System.out.println("+++++++++code :" + code);
        if (user != null) {
            new PreparedSentence(this.s, "UPDATE PEOPLE SET APPPASSWORD = '" + code + "' WHERE ID = ?", SerializerWriteString.INSTANCE).exec((Object)user.getId());
        }
    }

    public void deleteSupplementItem(int idSupplement, boolean removed_definitely) throws BasicException {
        String request_removed = removed_definitely || AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "removed = 1";
        new StaticSentence(this.s, "UPDATE supplement_item  SET " + request_removed + " WHERE id = ?", SerializerWriteInteger.INSTANCE).exec((Object)idSupplement);
    }

    public void setPOSDateFirstConnexion(final MarqueNFC marqueNFC) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  MARUQENF525 SET FIRST_CONNEXION = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, marqueNFC.getDateFirstConnexion());
                this.setInt(2, marqueNFC.getId());
            }
        });
    }

    public void deleteInfoFactureByTicket(String tableName, final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM " + tableName + " WHERE REF_FACTURE in (select F.ID from FACTURE F join tickets T on F.ticket = T.ID where t.created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public void deleteInfoNoteByTicket(String tableName, final Date dateVidange) throws BasicException {
        new StaticSentence(this.s, "DELETE FROM " + tableName + " WHERE ref_note in (select E.ID from ENTETE_NOTE E join tickets T on E.ticket = T.ID where t.created <= ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateVidange);
            }
        });
    }

    public final List<TicketInfo> getCancelNotes() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE  T.paid = 0 AND STATUS = 'cancel' and noteIsSentToPostgre = 0 order  by CREATED desc", null, new SerializerReadClass(TicketInfo.class)).list();
        return tickets;
    }

    private String getCodeCaisse() throws BasicException {
        String keenio = this.getKeenio();
        String codeCaisse = this.mDataLogicSalesHelper.get4lastCharsOfKeenio(keenio);
        if (codeCaisse == null || codeCaisse.isEmpty()) {
            codeCaisse = "1";
        }
        return codeCaisse;
    }

    private String getKeenio() throws BasicException {
        String data = null;
        String q = "SELECT user_keenio_id FROM caisse WHERE token = ? ";
        Object[] record = (Object[])new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
            }
        });
        if (record != null) {
            data = (String)record[0];
        }
        return data;
    }

    public List<ItemIngredientInfo> getItemsDetailIngredients(int productID) throws BasicException {
        return new PreparedSentence(this.s, "SELECT I.id_supplement_item, I.id_item, I.quantity, S.ITEM_PLU FROM ITEM_INGREDIENTS I JOIN SUPPLEMENT_ITEM S ON I.id_supplement_item = S.id WHERE I.id_item = ?", SerializerWriteInteger.INSTANCE, ItemIngredientInfo.getSerializerReadDetailed()).list((Object)productID);
    }

    public List<ZoneInfo> getAllZones() {
        List zones = null;
        try {
            zones = new PreparedSentence(this.s, this.requestZone, null, ZoneInfo.getSerializerRead()).list();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return zones;
    }

    public ZoneInfo getZoneInfoById(int id) throws BasicException {
        ZoneInfo zone = (ZoneInfo)new PreparedSentence(this.s, this.requestZone + "WHERE Z.ID = ? ", SerializerWriteInteger.INSTANCE, ZoneInfo.getSerializerRead()).find((Object)id);
        return zone;
    }

    public ZoneInfo getZoneInfoByref_id(int ref_id) throws BasicException {
        ZoneInfo zone = (ZoneInfo)new PreparedSentence(this.s, this.requestZone + "WHERE Z.ref_id = ? ", SerializerWriteInteger.INSTANCE, ZoneInfo.getSerializerRead()).find((Object)ref_id);
        return zone;
    }

    public void upsertZone(ZoneInfo zone) throws BasicException {
        Color color = zone.getColor();
        int id_ref = zone.getRef_id() != null ? zone.getRef_id() : 0;
        System.out.println("id_ref : " + id_ref);
        String hexColor = String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        System.out.println("zone.getId() : " + zone.getId());
        String query = zone.getId() == null ? "INSERT INTO ZONES (NAME, POSITION, COLOR, ref_id) VALUES(?, ?, ?, ?)" : "UPDATE ZONES SET NAME = ?, POSITION = ?, COLOR = ?, ref_id = ? WHERE ID = ?";
        try {
            ResultSet generatedKeys;
            PreparedStatement ps = this.s.getConnection().prepareStatement(query, 1);
            ps.setString(1, zone.getName());
            ps.setInt(2, zone.getPosition());
            ps.setString(3, hexColor);
            ps.setInt(4, id_ref);
            if (zone.getId() != null) {
                ps.setInt(5, zone.getId());
            }
            ps.executeUpdate();
            if (zone.getId() == null && (generatedKeys = ps.getGeneratedKeys()).next()) {
                int generatedId = generatedKeys.getInt(1);
                zone.setId(generatedId);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public final String getTicketByIdPlatform(final String idOrderPlatform, final String numerOrderPlatform) throws BasicException {
        Object[] result = (Object[])new PreparedSentence(this.s, this.requestTicket + "WHERE T.ID_ONLINE_ORDER in (?, ?)", SerializerWriteParams.INSTANCE, new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idOrderPlatform);
                this.setString(2, numerOrderPlatform);
            }
        });
        if (result == null) {
            return null;
        }
        return (String)result[0];
    }

    public List<SupplementItemInfo> getSuppelementsItemSoldOut() throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.SOLD_OUT = 1 AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0  AND S.id_supplement in (select G.id from supplement G where G.removed = 0 AND G.REMOVED_BY_ADMIN = 0) " + this.request_campaign_supplement_item + "ORDER BY  S.id_supplement ", null, SupplementItemInfo.getSerializerRead()).list();
    }
}

