/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerWriteInteger;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.Course;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ScreenSupplementInfo;
import com.openbravo.pos.ticket.ScreenSupplementItem;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.UserInfo;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.StaticSentence;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import fr.protactile.procaisse.dao.entities.NutritionalInfoProduct;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public class DataLogicProduct
extends DataLogicSales {
    protected String requestCourse = "SELECT C.ID, C.PRODUCT, C.UNITS, C.PRICE, C.VALID, C.CREATED, C.DATE_VALIDATION, C.USER_OPERATOR FROM COURSES C ";

    public ProductInfoExt getProductInfo(int id_product, boolean without_filter) throws BasicException {
        String request_filter = without_filter ? "" : "P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND ";
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE " + request_filter + " P.ID = ? ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)id_product);
        if (product != null) {
            product.setSub_products(this.getSubProducts(product.getID(), false));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            if (product.getZoneId() != null) {
                product.setZoneInfo(this.getZoneInfoById(product.getZoneId()));
            }
        }
        return product;
    }

    public CarteInfo getCarteById(int id_carte) throws BasicException {
        return (CarteInfo)new PreparedSentence(this.s, this.requestCarte + "WHERE  id = ? ", SerializerWriteInteger.INSTANCE, CarteInfo.getSerializerRead()).find((Object)id_carte);
    }

    public ProductInfoExt getProductPlatById(final int id_carte, final int id_item, boolean without_filter) throws BasicException {
        String request_filter = without_filter ? "" : "P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND ";
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProductPlat + "WHERE " + request_filter + " P.ID = ? AND C.id_carte = ?  ", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_item);
                this.setInt(2, id_carte);
            }
        });
        if (product != null) {
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        return product;
    }

    public final CategoryInfo getCategoryInfoByName(String name) throws BasicException {
        return (CategoryInfo)new PreparedSentence(this.s, this.requestCategory + " WHERE  UPPER(C.NAME) LIKE ? and C.REMOVED=0 AND C.REMOVED_BY_ADMIN = 0 ", SerializerWriteString.INSTANCE, CategoryInfo.getSerializerRead()).find((Object)name.toUpperCase());
    }

    public CategoryInfo addCategory(CategoryInfo category) throws BasicException, SQLException {
        String SQL = "INSERT INTO CATEGORIES (NAME) VALUES (?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, category.getName());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idCategory = -1;
        if (rs.next()) {
            idCategory = rs.getInt(1);
        }
        category.setID(idCategory);
        return category;
    }

    public final ProductInfoExt addProductLessParams(ProductInfoExt product) throws BasicException, SQLException {
        String SQL = "INSERT INTO PRODUCTS (CODE, NAME, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, quantity,lv,sp,emp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, product.getCode().trim());
        this.pstmt.setString(2, product.getName().trim());
        this.pstmt.setDouble(3, product.getPriceBuy());
        this.pstmt.setDouble(4, product.getPriceSell());
        this.pstmt.setInt(5, product.getCategoryid());
        this.pstmt.setString(6, product.getTaxcategoryid());
        this.pstmt.setDouble(7, product.getQuantity());
        this.pstmt.setBoolean(8, true);
        this.pstmt.setBoolean(9, true);
        this.pstmt.setBoolean(10, true);
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        if (rs.next()) {
            int last_inserted_id;
            this.id_Product = last_inserted_id = rs.getInt(1);
        }
        product.setID(this.id_Product);
        return product;
    }

    public final ProductInfoExt getProductInfoByName(String name) throws BasicException {
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.NAME = ? ", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)name);
        if (product != null) {
            product.setSub_products(this.getSubProducts(product.getID(), false));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        return product;
    }

    public ProductInfoExt getProductInfoByNameOrCode(final String name, final String code) throws BasicException {
        List list = new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND ( UPPER(P.NAME) like UPPER(?) OR P.CODE = ? )", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, name.trim());
                this.setString(2, code.trim());
            }
        });
        if (list != null && !list.isEmpty()) {
            return (ProductInfoExt)list.get(0);
        }
        return null;
    }

    public ProductInfoExt addOrUpdateProductIfExist(ProductInfoExt product) throws BasicException, SQLException {
        ProductInfoExt productDb = this.getProductInfoByNameOrCode(product.getName(), product.getCode());
        if (productDb == null) {
            return this.addProductLessParams(product);
        }
        product.setID(productDb.getID());
        return this.updateProductLessPrams(product);
    }

    public ProductInfoExt updateProductLessPrams(final ProductInfoExt product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET name = ? , code = ? , PRICEBUY =?, PRICESELL  =?, CATEGORY  =?, TAXCAT =?, quantity =?  WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, product.getName().trim());
                this.setString(2, product.getCode().trim());
                this.setDouble(3, product.getPriceBuy());
                this.setDouble(4, product.getPriceSell());
                this.setInt(5, product.getCategoryid());
                this.setString(6, product.getTaxCategoryID());
                this.setDouble(7, product.getQuantity());
                this.setInt(8, product.getID());
            }
        });
        return product;
    }

    public void addCource(final Course course) throws BasicException {
        if (course.getPrice() != 0.0) {
            new PreparedSentence(this.s, "INSERT INTO COURSES (PRODUCT, UNITS, PRICE, VALID, DATE_VALIDATION, USER_OPERATOR) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, course.getProduct());
                    this.setDouble(2, course.getUnit());
                    this.setDouble(3, course.getPrice());
                    this.setBoolean(4, Boolean.TRUE);
                    this.setTimestamp(5, new Date());
                    this.setString(6, course.getUser().getId());
                }
            });
        } else {
            new PreparedSentence(this.s, "INSERT INTO COURSES (PRODUCT, UNITS, PRICE, USER_OPERATOR) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, course.getProduct());
                    this.setDouble(2, course.getUnit());
                    this.setDouble(3, course.getPrice());
                    this.setString(4, course.getUser().getId());
                }
            });
        }
    }

    public void updateCource(final Course course) throws BasicException {
        new PreparedSentence(this.s, "UPDATE COURSES SET PRODUCT = ?, UNITS = ?, PRICE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, course.getProduct());
                this.setDouble(2, course.getUnit());
                this.setDouble(3, course.getPrice());
                this.setInt(4, course.getId());
            }
        });
        if (course.getPrice() != 0.0) {
            this.validCource(course);
        }
    }

    public void validCource(final Course course) throws BasicException {
        new PreparedSentence(this.s, "UPDATE COURSES SET VALID = 1, DATE_VALIDATION = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, course.getDate_validation());
                this.setInt(2, course.getId());
            }
        });
    }

    public void deleteCource(final Course course) throws BasicException {
        new PreparedSentence(this.s, "UPDATE COURSES SET REMOVED = 1 WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, course.getId());
            }
        });
    }

    public List<Course> getCourseByDate(Date date_course) throws BasicException {
        final int day = date_course.getDate();
        final int month = date_course.getMonth() + 1;
        final int year = date_course.getYear() + 1900;
        return new PreparedSentence(this.s, this.requestCourse + " WHERE C.REMOVED = 0 AND YEAR(C.CREATED) = ? AND MONTH(C.CREATED) = ? AND DAY(C.CREATED) = ?", SerializerWriteParams.INSTANCE, Course.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
    }

    public List<Course> getCourses() throws BasicException {
        List courses = new PreparedSentence(this.s, this.requestCourse + "WHERE C.VALID = 1 AND C.CLOSED = 0 AND C.REMOVED = 0 ", null, Course.getSerializerRead()).list();
        for (Course course : courses) {
            if (course.getId_user() == null) continue;
            course.setUser(UserInfo.fetchOrStore(course.getId_user(), this));
        }
        return courses;
    }

    public final List<ScreenSupplementItem> getScreenByIngredient(int supplement) throws BasicException {
        return new PreparedSentence(this.s, "SELECT distinct SC.ID, SC.ID_SUPPLEMENT, SC.ID_SCREEN, SC.NAME_SCREEN FROM SCREENS_SUPPLEMENT SC JOIN supplement_item SI ON SC.ID_SUPPLEMENT = SI.id WHERE SI.id = ? ", SerializerWriteInteger.INSTANCE, ScreenSupplementItem.getSerializerRead()).list((Object)supplement);
    }

    public final List<ScreenSupplementInfo> getScreenByGoption(int goption) throws BasicException {
        return new PreparedSentence(this.s, "SELECT SC.ID, SC.ID_GROUP_SUPPLEMENT, SC.ID_SCREEN, SC.NAME_SCREEN FROM SCREENS_GROUP_SUPPLEMENT SC JOIN supplement S ON SC.ID_GROUP_SUPPLEMENT = S.id WHERE S.id = ? ", SerializerWriteInteger.INSTANCE, ScreenSupplementInfo.getSerializerRead()).list((Object)goption);
    }

    public void addScreensIngredient(SupplementItemInfo ingredient) throws BasicException {
        for (ScreenSupplementItem screen : ingredient.getScreen()) {
            if (screen.getId() != -1) continue;
            screen.setId_supplement(ingredient.getiD());
            this.addScreenIngredient(screen);
        }
    }

    public void addScreensGroupeSupplement(SupplementInfo groupeOption) throws BasicException {
        for (ScreenSupplementInfo screen : groupeOption.getScreens()) {
            if (screen.getId() != -1) continue;
            screen.setId_supplement(groupeOption.getiD());
            this.addScreenGroupeSupplement(screen);
        }
    }

    public void persistScreensGroupeSupplement(SupplementInfo groupeOption) throws BasicException {
        List<ScreenSupplementInfo> oldScreens = this.getScreenByGoption(groupeOption.getiD());
        for (ScreenSupplementInfo oldScreen : oldScreens) {
            int found = -1;
            for (ScreenSupplementInfo screen : groupeOption.getScreens()) {
                if (oldScreen.getId() != screen.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteSupplementScreen(oldScreen);
        }
        this.addScreensGroupeSupplement(groupeOption);
    }

    public void persistScreensIngredient(SupplementItemInfo ingredient) throws BasicException {
        List<ScreenSupplementItem> oldScreens = this.getScreenByIngredient(ingredient.getiD());
        for (ScreenSupplementItem oldScreen : oldScreens) {
            int found = -1;
            for (ScreenSupplementItem screen : ingredient.getScreen()) {
                if (oldScreen.getId() != screen.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteIngredientScreen(oldScreen);
        }
        this.addScreensIngredient(ingredient);
    }

    private void addScreenIngredient(final ScreenSupplementItem screen) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SCREENS_SUPPLEMENT(ID_SUPPLEMENT, ID_SCREEN, NAME_SCREEN) VALUES(?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, screen.getId_supplement());
                this.setInt(2, screen.getId_screen());
                this.setString(3, screen.getName_screen());
            }
        });
    }

    public void deleteIngredientScreen(final ScreenSupplementItem screen) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SCREENS_SUPPLEMENT WHERE ID_SUPPLEMENT = ? AND ID_SCREEN = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, screen.getId_supplement());
                this.setInt(2, screen.getId_screen());
            }
        });
    }

    private void addScreenGroupeSupplement(final ScreenSupplementInfo screen) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SCREENS_GROUP_SUPPLEMENT(ID_GROUP_SUPPLEMENT, ID_SCREEN, NAME_SCREEN) VALUES(?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, screen.getId_supplement());
                this.setInt(2, screen.getId_screen());
                this.setString(3, screen.getName_screen());
            }
        });
    }

    public void deleteSupplementScreen(final ScreenSupplementInfo screen) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SCREENS_GROUP_SUPPLEMENT WHERE ID_GROUP_SUPPLEMENT = ? AND ID_SCREEN = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, screen.getId_supplement());
                this.setInt(2, screen.getId_screen());
            }
        });
    }

    public ProductInfoExt getProductInfoByPLU(String product_plu, boolean without_filter) throws BasicException {
        String request_filter = without_filter ? "" : "P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND ";
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE " + request_filter + " P.PRODUCT_PLU = ? ", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)product_plu);
        if (product != null) {
            product.setSub_products(this.getSubProducts(product.getID(), false));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        return product;
    }

    public ProductInfoExt getProductByIdGlobal(String idGlobal) throws BasicException {
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE  P.PRODUCT_PLU = ? ", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)idGlobal);
        if (product != null) {
            product.setSub_products(this.getSubProducts(product.getID(), false));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        return product;
    }

    public int getIdCarteByIdGlobal(String idGlobal) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT id FROM carte WHERE ID_GLOBAL = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idGlobal);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public int getIdProductByIdGlobal(String idGlobal) throws BasicException {
        Object[] iD = (Object[])new StaticSentence(this.s, "SELECT id FROM PRODUCTS WHERE PRODUCT_PLU = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)idGlobal);
        return iD != null ? (Integer)iD[0] : -1;
    }

    public ProductInfoExt getProductPlatByIdGlobal(final String idGlobalCarte, final String idGloablItem) throws BasicException {
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProductPlat + " JOIN CARTE CA ON C.id_carte = CA.id WHERE P.PRODUCT_PLU = ? AND CA.ID_GLOBAL = ?  ", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idGloablItem);
                this.setString(2, idGlobalCarte);
            }
        });
        if (product != null) {
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
        }
        return product;
    }

    public ProductInfoExt getProductPlatByIdExternal(final String idExternalCarte, final String idExternalItem, boolean without_filter) throws BasicException {
        String request_filter = without_filter ? "" : "P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND ";
        return (ProductInfoExt)new PreparedSentence(this.s, this.requestProductPlat + "JOIN CARTE CA ON  C.ID_CARTE = CA.ID WHERE " + request_filter + " P.PRODUCT_PLU = ? AND CA.ID_GLOBAL = ?  ", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idExternalItem);
                this.setString(2, idExternalCarte);
            }
        });
    }

    public CarteInfo getCarteByIdGlobal(String idGlobal) throws BasicException {
        return (CarteInfo)new PreparedSentence(this.s, this.requestCarte + "WHERE ID_GLOBAL = ? ", SerializerWriteString.INSTANCE, CarteInfo.getSerializerRead()).find((Object)idGlobal);
    }
}

