/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.TicketAvoir;
import com.openbravo.dao.DAOConstants;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerReadClass;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.StaticSentence;
import fr.protactile.norm.beans.ArchivPeriode;
import fr.protactile.norm.beans.Duplicata;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.TotalTax;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DataLogicOrder
extends BeanFactoryDataSingle {
    protected Session s;
    protected PreparedStatement pstmt;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private DataLogicSales m_dlSales = null;
    private String requestTicket;
    private String requestFacture;
    private String RequestAvoirQuery;
    private String requestDuplicata;
    private String requestGTP;
    private String requestGrandToTalTicket;

    public DataLogicOrder() throws SQLException {
        this.initializer();
        this.m_dlSales = new DataLogicSales();
    }

    public DataLogicOrder(String db_url, String db_user, String db_password) throws SQLException {
        this.initConnection(db_url, db_user, db_password);
    }

    private void initConnection(String db_url, String db_user, String db_password) throws SQLException {
    }

    private void initializer() throws SQLException {
        String db_url = AppLocal.db_url;
        this.initConnection(db_url, "APP", "protactilepa42");
    }

    @Override
    public void init(Session s) {
        this.s = s;
        if (this.m_dlSales != null) {
            this.m_dlSales.init(s);
        }
        this.requestTicket = "SELECT T.ID, T.TICKETTYPE, T.TICKETID, T.type, T.modePayment, T.tempsLv, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, " + DAOConstants.SQLFunction + "(T.CUSTOMER, -1) as CUSTOMER, T.STATUS, T.total, " + DAOConstants.SQLFunction + "(T.address, -1) as address,T.numero_order, " + DAOConstants.SQLFunction + "(T.idTable, -1) as idTable, T.discount, T.typediscount, T.bipper, T.transferred, T.reason_cancel, " + DAOConstants.SQLFunction + "(T.invoice , 0) as invoice , PL.ID as ID_LIVREUR, PL.NAME as NAME_LIVREUR, " + DAOConstants.SQLFunction + "(T.canceled_ticket_id_Int,0) as OrigineTicket,T.accepted , T.paid ,T.last_update, T.couverts, T.SOURCE_ORDER, T.NAME_CUSTOMER, T.date_paid, T.closed, T.canceled_ticket_id," + DAOConstants.SQLFunction + "(T.num_order_kitchen, -1) as num_order_kitchen, CU.ID, T.ORDERED_FROM, T.ID_ORDER_KITCHEN, T.SENT_FROM, T.NUMERO_ONLINE_ORDER, T.PRINT_AFTER_UPDATE, T.NUM_TABLE, T.NUM_PLATFORM_ORDER, T.LABEL_DISCOUNT, T.ID_SHARED_ORDER, T.DELIVERED_AT, T.LICENCE_ID_MACHINE, T.CUSTOMER_LOYALTY_VERIFIED, T.EASEL_NUMBER, T.PLATFORM_ORDER, T.SHARED_ORDER, T.ORDER_ID_BASE, T.KEENIO_BASE_ORDER, T.TAKE_AWAY_PHONE, T.TPS, T.TVQ, T.session_id,T.tag_erc_stan,  T.eft_stan,  T.last_digit,  T.EcrDateTime, T.holder FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID LEFT OUTER JOIN PEOPLE PL ON T.livreur = PL.ID LEFT JOIN COUNTER_USER CU ON P.ID = CU.ID_USER ";
        this.RequestAvoirQuery = "SELECT ID, AMOUNT, USED, EXPIRATION_DATE, BAR_CODE, ORIGIN FROM  TICKET_AVOIR ";
        this.requestFacture = "SELECT F.id, F.company, F.name_contact,F.address, F.zip_code, F.city, F.country, F.siret, F.code_NAF, F.num_tva, F.ticket, F.physical_person, F.cancel, F.nb_print, F.signature, F.date_created, F.num_doc, T.total, G.TVA_5_5, G.TVA_10, G.TVA_20, G.TVA_0, G.TVA_7_7, G.TVA_2_5, G.TVA_2_1, G.TVA_8_5,F.TYPE_OPERATION, F.VERSION_SOFT, F.NAME_SOFT, " + DAOConstants.SQLFunction + "(F.ID_CUSTOMER, 0) as ID_CUSTOMER, F.COMPANY_SENDER, F.ADDRESS_SENDER, F.ZIP_CODE_SENDER, F.CITY_SENDER, F.COUNTREY_SENDER, F.SIRET_SENDER, F.CODE_NAF_SENDER, F.NUM_TVA_SENDER, F.FORME_JURIDIQUE_SENDER, F.CAPITAL_SOCIAL_SENDER, F.RCS_SENDER, F.GREFFE_SENDER, F.METIER_SENDER, F.code_operator, F.name_operator, F.code_caisse, " + DAOConstants.SQLFunction + "(F.REF_TICKET, 0) as REF_TICKET, F.INFO_SENDER_INCLUDED, G.TVA_6, G.TVA_12, G?TVA_21 FROM FACTURE F JOIN TICKETS T ON F.ticket = T.ID ";
        this.requestDuplicata = "SELECT  id, id_Doc, impression_Number, type_doc, user_operator, date_impression, signature, num_doc, VERSION_SOFT, MOTIF_IMPRESSION, REF_FACTURE, REF_TICKET, CHECK_TYPE_DOC FROM DUPLICATA ";
        this.requestGTP = "SELECT  id, grand_total, grand_total_Perpetual, " + DAOConstants.SQLFunction + "(TVA_5_5 ,0.0) as Tva_5_5, " + DAOConstants.SQLFunction + "(TVA_10 ,0.0) as TVA_10, " + DAOConstants.SQLFunction + "(TVA_20 ,0.0) as TVA_20, signature, type_PERIODE, timestampGDH, grand_total_Perpetual_reel,CASH_TOTAL, CB_TOTAL, TR_TOTAL, DEBIT_TOTAL, CREDIT_EMPLOYEE_TOTAL, LOYALTY_CARD, CASHDRO_TOTAL, CACH_GLORY_TOTAL, VIRMENT_TOTAL, CHEQUE_TOTAL, AVOIR_DECAISSE_TOTAL, AVOIR_ENCAISSE_TOTAL, TVA_5_5_HT, TVA_10_HT, TVA_20_HT, NUMBER_ORDERS, NUMBER_PRODUCTS_SOLD, TURNOVER_CANCELED, TOTAL_ORDERS_AT_SPOT, TOTAL_ORDERS_TAKE_AWAY, TOTAL_ORDERS_DELIVERY, TOTAL_ORDERS_UBER, TOTAL_ORDERS_DELIVERO, NUMBER_CB, NUMBER_TR, TOTAL_DISCOUNT, TOTAL_DISCOUNT_LINES, INSERT_FINANCIAL_INFOS, TOTAL_ORDERS_JUST_EAT, " + DAOConstants.SQLFunction + "(TVA_0 ,0.0) as TVA_0, TVA_0_HT, TOTAL_ORDERS_DRIVE, " + DAOConstants.SQLFunction + "(TVA_7_7 ,0.0) as TVA_7_7, " + DAOConstants.SQLFunction + "(TVA_2_5 ,0.0) as TVA_2_5, " + DAOConstants.SQLFunction + "(TVA_2_1 ,0.0) as TVA_2_1, " + DAOConstants.SQLFunction + "(TVA_8_5 ,0.0) as TVA_8_5, TVA_7_7_HT, TVA_2_5_HT, TVA_2_1_HT, TVA_8_5_HT, TWINT_TOTAL, TOTAL_ORDERS_SMOOD,CHEQUE_VACANCES_TOTAL, BEFORE_PERPETUAL_RESET, ISSYNCHRONIZED, ROUND_AMOUNT, TURNOVER_PLATFORM, NUMBER_ORDERS_PLATFORM, TOTAL_ORDERS_DELIVEROO, " + DAOConstants.SQLFunction + "(TVA_6 ,0.0) as TVA_6, " + DAOConstants.SQLFunction + "(TVA_12 ,0.0) as TVA_12, " + DAOConstants.SQLFunction + "(TVA_21 ,0.0) as TVA_21, TVA_6_HT, TVA_12_HT, TVA_21_HT, TURNOVER_UBEREAT, TOTAL_ORDERS_DISHOP, STRIPE_TOTAL, CASH_LOGY_TOTAL, " + DAOConstants.SQLFunction + "(TVA_8_1 ,0.0) as TVA_8_1, " + DAOConstants.SQLFunction + "(TVA_2_6 ,0.0) as TVA_2_6, TVA_8_1_HT, TVA_2_6_HT, TPS, TVQ, CREDIT_CARD_TOTAL, DEBIT_CARD_TOTAL, TOTAL_HT_TAXABLE, TOTAL_HT_NO_TAXABLE, TOTAL_HT_ORDERS_AT_SPOT, TOTAL_HT_ORDERS_TAKE_AWAY, TOTAL_HT_ORDERS_DELIVERY, TOTAL_HT_ORDERS_DRIVE, NUMBER_ORDERS_AT_SPOT, NUMBER_ORDERS_TAKE_AWAY, NUMBER_ORDERS_DELIVERY, NUMBER_ORDERS_DRIVE, CARTE_TR_TOTAL, BANK_TRANSFER_TOTAL, NUMBER_CARTE_TR FROM GRAND_TOTAL_PERIODE ";
        this.requestGrandToTalTicket = "SELECT  id, num_doc, timestampGDH, grand_total, grand_total_Perpetual,ticket, TVA_5_5, TVA_10, TVA_20, signature, grand_total_Perpetual_reel, TVA_0, TVA_7_7, TVA_2_5, TVA_2_1, TVA_8_5, " + DAOConstants.SQLFunction + "(BEFORE_PERPETUAL_RESET, 0) as BEFORE_PERPETUAL_RESET, " + DAOConstants.SQLFunction + "(REF_ORIGINE, 0) as REF_ORIGINE, " + DAOConstants.SQLFunction + "(ADD_PERPETUAL_IN_SIGNATURE, 0) as ADD_PERPETUAL_IN_SIGNATURE, " + DAOConstants.SQLFunction + "(ROUND_AMOUNT, 0) as ROUND_AMOUNT, TVA_6, TVA_12, TVA_21, TVA_8_1, TVA_2_6 ";
    }

    public final List<TicketInfo> loadCallCenter() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE paid = 0 AND STATUS = 'pending' AND T.is_agent_callcenter = 1 ORDER BY R.DATENEW desc ", null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null || this.m_dlSales == null) continue;
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.m_dlSales.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadTicketCallCenter() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE T.paid = 0 AND T.STATUS = 'pending' AND T.is_agent_callcenter = 1  AND T.is_notified_callcenter = 0 ORDER BY R.DATENEW desc ", null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null || this.m_dlSales == null) continue;
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.m_dlSales.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadDecaissementCallCenter() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE T.paid = 0 AND T.STATUS = 'livre' AND T.is_agent_callcenter = 1 ORDER BY R.DATENEW desc ", null, new SerializerReadClass(TicketInfo.class)).list();
        for (TicketInfo ticket : tickets) {
            if (ticket == null || this.m_dlSales == null) continue;
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.m_dlSales.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadDecaissementByUser(final String user) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE P.ID = ? AND paid = 0 AND STATUS = 'livre' AND T.is_agent_callcenter = 1 ORDER BY R.DATENEW desc ", SerializerWriteString.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null || this.m_dlSales == null) continue;
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.m_dlSales.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public final List<TicketInfo> loadCallCenterByUser(final String user) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE  P.ID = ? AND paid = 0 AND type ='En Livraison' AND STATUS = 'pending' AND T.is_agent_callcenter = 1ORDER BY R.DATENEW desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user);
            }
        });
        for (TicketInfo ticket : tickets) {
            if (ticket == null || this.m_dlSales == null) continue;
            int customerid = ticket.getCustomerId();
            ticket.setCustomer(customerid == -1 ? null : this.m_dlSales.loadCustomerExt(customerid));
        }
        return tickets;
    }

    public void setTicketCallCenterNotify(final boolean b) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS T SET T.is_notified_callcenter = ? WHERE T.caisse NOT IN (SELECT C.ID FROM caisse C WHERE C.token = ? ) AND T.paid = 0 AND T.STATUS = 'pending' AND T.is_agent_callcenter = 1", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, b);
                this.setString(2, AppLocal.token);
            }
        });
    }

    public void acceptOrder(final String id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS  SET accepted = 1 WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
    }

    public TicketAvoir AddAvoir(final TicketAvoir avoir) throws BasicException, SQLException {
        String SQL = "INSERT INTO TICKET_AVOIR  ( AMOUNT, USED, EXPIRATION_DATE, BAR_CODE,origin, TICKET)  VALUES( ? , ?, ?, ?, ?, ?)";
        new PreparedSentence(this.s, SQL, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(Math.abs(avoir.getAmount())));
                this.setBoolean(2, avoir.isUsed());
                this.setTimestamp(3, avoir.getExpirationDate());
                this.setString(4, avoir.getBarCode());
                this.setString(5, avoir.getOrigin());
                this.setString(6, avoir.getTicket());
            }
        });
        return avoir;
    }

    public final int getLastAvoirId() throws SQLException {
        int number = 0;
        String SQL = "select max(id) as last_id from Ticket_Avoir ";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("last_id");
        }
        TicketAvoir.setLastId(number);
        return number;
    }

    public final TicketAvoir findTicketAvoirByBarCode(String barCode) throws BasicException {
        return (TicketAvoir)new PreparedSentence(this.s, this.RequestAvoirQuery + " WHERE BAR_CODE like ? ", SerializerWriteString.INSTANCE, TicketAvoir.getSerializerRead()).find((Object)barCode);
    }

    public final TicketAvoir findTicketAvoirByTicket(String ticket) throws BasicException {
        return (TicketAvoir)new PreparedSentence(this.s, this.RequestAvoirQuery + " WHERE TICKET = ? ", SerializerWriteString.INSTANCE, TicketAvoir.getSerializerRead()).find((Object)ticket);
    }

    public void updateTicketAvoir(final TicketAvoir avoir) throws BasicException {
        String sql = "UPDATE TICKET_AVOIR SET  AMOUNT = ?, USED = ?, EXPIRATION_DATE =?, BAR_CODE = ? WHERE ID = ? ";
        new PreparedSentence(this.s, sql, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(avoir.getAmount()));
                this.setBoolean(2, avoir.isUsed());
                this.setTimestamp(3, avoir.getExpirationDate());
                this.setString(4, avoir.getBarCode());
                this.setInt(5, avoir.getId());
            }
        });
    }

    public List<EnteteInfo> getEnteteBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        String queryRest = "WHERE E.timestampGDH  >= ? AND E.timestampGDH <= ? order by E.id  ";
        List entetes = new PreparedSentence(this.s, "SELECT  E.id, E.num_doc, E.version_soft, E.nb_print, E.company, E.address, E.zip_code, E.city, E.country, E.siret, E.code_NAF, E.num_tva, E.timestampGDH, E.type_operation, E.nb_lines, E.ticket, E.header_Supplementaire, E.footer_Supplementaire, E.ticket_status, E.signature_Ticket, G.id, G.num_doc, G.timestampGDH, G.grand_total, G.grand_total_Perpetual,G.ticket, G.TVA_5_5, G.TVA_10, G.TVA_20, G.signature, G.grand_total_Perpetual_reel,G.TVA_0, G.TVA_7_7, G.TVA_2_5, G.TVA_2_1, G.TVA_8_5, " + DAOConstants.SQLFunction + "(G.BEFORE_PERPETUAL_RESET, 0) as BEFORE_PERPETUAL_RESET, E.code_caisse, E.NAME_SOFT, E.code_operator, " + DAOConstants.SQLFunction + "(G.REF_ORIGINE, 0) as REF_ORIGINE, " + DAOConstants.SQLFunction + "(E.USE_ID_IN_SIGNATURE, 0) as USE_ID_IN_SIGNATURE, " + DAOConstants.SQLFunction + "(G.ADD_PERPETUAL_IN_SIGNATURE, 0) as ADD_PERPETUAL_IN_SIGNATURE, " + DAOConstants.SQLFunction + "(E.ROUND_AMOUNT, 0) as ROUND_AMOUNT, " + DAOConstants.SQLFunction + "(G.ROUND_AMOUNT, 0) as ROUND_AMOUNT, G.TVA_6, G.TVA_12, G.TVA_21, G.TVA_8_1, G.TVA_2_6, E.RESTITUTION_TYPE, E.NB_SEND_E_TICKET, E.E.name_operator FROM ENTETE E LEFT JOIN TICKETS T ON E.ticket = T.ID LEFT JOIN GRAND_TOTAL G on E.ticket = G.ticket " + queryRest, SerializerWriteParams.INSTANCE, EnteteInfo.getSerializerReadWithGrandTotal()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return entetes;
    }

    public List<GrandTotalTicket> getGrandTotalTicketBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        return new PreparedSentence(this.s, this.requestGrandToTalTicket + "FROM GRAND_TOTAL WHERE  timestampGDH >= ? and timestampGDH <= ?  order by timestampGDH ", SerializerWriteParams.INSTANCE, GrandTotalTicket.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public final List<Duplicata> getDuplicataByPeriode(final Date dateStart, final Date dateEnd) throws BasicException {
        List duplicatas = new PreparedSentence(this.s, this.requestDuplicata + "WHERE  CHECK_TYPE_DOC = 0 and date_impression >= ?  and date_impression <=  ?  ORDER BY id ", SerializerWriteParams.INSTANCE, Duplicata.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        return duplicatas;
    }

    public final List<Duplicata> getDuplicataByPeriodeAndTypeDoc(final Date dateStart, final Date dateEnd, final String type_doc) throws BasicException {
        List duplicatas = new PreparedSentence(this.s, this.requestDuplicata + "WHERE CHECK_TYPE_DOC = 1 and type_doc = ? and date_impression >= ?  and date_impression <=  ?  ORDER BY id ", SerializerWriteParams.INSTANCE, Duplicata.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_doc);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        return duplicatas;
    }

    public List<GrandTotalPeriode> getGrandTotalPeriodeBetween(final String typePeriode, final Date dateStart, final Date dateEnd) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGTP + " where type_PERIODE= ? AND timestampGDH >= ? And timestampGDH <= ? order by CAST (id AS INTEGER) ", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, typePeriode);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        return listTotaux;
    }

    public List<ArchivPeriode> getArchivPeriodeBetween(final String typePeriode, final Date dateStart, final Date dateEnd) throws BasicException {
        List listTotaux = new PreparedSentence(this.s, "SELECT  id, grand_total, grand_total_Perpetual,TVA_5_5, TVA_10, TVA_20, signature, type_PERIODE, timestampGDH, chemin, TVA_0, TVA_7_7, TVA_2_5, TVA_2_1, TVA_8_5, ROUND_AMOUNT, TVA_6, TVA_12, TVA_21, TVA_8_1, TVA_2_6 FROM ARCHIV_PERIODE where type_PERIODE= ? AND timestampGDH >= ? And timestampGDH <= ?  order by CAST (id AS INTEGER) ", SerializerWriteParams.INSTANCE, ArchivPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, typePeriode);
                this.setTimestamp(2, dateStart);
                this.setTimestamp(3, dateEnd);
            }
        });
        return listTotaux;
    }

    public TicketInfo getFirstTicket() throws BasicException {
        TicketInfo ticket = (TicketInfo)new PreparedSentence(this.s, this.requestTicket + "WHERE CREATED = (SELECT MIN(CREATED) FROM TICKETS)", null, new SerializerReadClass(TicketInfo.class)).find();
        return ticket;
    }

    public Date getFirstDateLineTotalTax() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT MIN(TIMESTAMPGDH) FROM TOTAL_TAX ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.TIMESTAMP})).find();
        if (recsales != null) {
            return (Date)recsales[0];
        }
        return null;
    }

    public Integer getDocumentIdByTicketId(final String ticketId) throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT ID FROM DOCUMENT WHERE TICKET = ? ", SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticketId);
            }
        });
        if (recsales != null) {
            return (Integer)recsales[0];
        }
        return null;
    }

    public TotalTax hasTotalTaxByRateId(final TicketInfo mTicketInfo, final Double rateValue) throws BasicException {
        String q = "SELECT ID, NUM_DOC, NUM_LINE, TOTAL_HT, CODE_TAX, RATE_TAX, TOTAL_TAX, TOTAL_TTC, TICKET, TIMESTAMPGDH FROM TOTAL_TAX WHERE TICKET = ? AND RATE_TAX = ?";
        TotalTax m = (TotalTax)new PreparedSentence(this.s, q, SerializerWriteParams.INSTANCE, TotalTax.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, mTicketInfo.getId());
                this.setDouble(2, rateValue);
            }
        });
        return m;
    }

    public TotaleEncaissement hasTotalEncaissemntById(final TicketInfo mTicketInfo) throws BasicException {
        String q = "SELECT  E.id, E.num_doc, E.total_ht, E.total_ttc, E.ticket, E.total_tax, " + DAOConstants.SQLFunction + "(E.REF_ORIGINE, 0) as REF_ORIGINE, E.TOTAL_DISCOUNT FROM TOTAL_ENCAISSEMENT as E WHERE E.ticket = ?";
        TotaleEncaissement m = (TotaleEncaissement)new PreparedSentence(this.s, q, SerializerWriteParams.INSTANCE, TotaleEncaissement.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, mTicketInfo.getId());
            }
        });
        return m;
    }

    public GrandTotalTicket getGrandTotalTicketById(final TicketInfo mTicketInfo) throws BasicException {
        return (GrandTotalTicket)new PreparedSentence(this.s, this.requestGrandToTalTicket + "FROM GRAND_TOTAL WHERE ticket = ?", SerializerWriteParams.INSTANCE, GrandTotalTicket.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, mTicketInfo.getId());
            }
        });
    }

    public Double getCumulPerpetualGrandTotalBefore(final Date mDateTotal) throws BasicException {
        Object[] values = (Object[])new PreparedSentence(this.s, "SELECT SUM(ABS(G.grand_total)) as cumul FROM GRAND_TOTAL G WHERE G.timestampGDH <= ? ", SerializerWriteParams.INSTANCE, new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, mDateTotal);
            }
        });
        return (Double)values[0];
    }

    public void updateGrandTotal(final GrandTotalTicket mGrandTotalTicket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE GRAND_TOTAL SET grand_total = ?, grand_total_Perpetual =  ?, TVA_5_5 = ?, TVA_10 = ?, TVA_20 = ?, grand_total_Perpetual_reel =  ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, mGrandTotalTicket.getCumul());
                this.setDouble(2, mGrandTotalTicket.getCumulPerpetual());
                this.setDouble(3, mGrandTotalTicket.getTva5());
                this.setDouble(4, mGrandTotalTicket.getTva10());
                this.setDouble(5, mGrandTotalTicket.getTva20());
                this.setDouble(6, mGrandTotalTicket.getCumulPerpetualReel());
                this.setString(7, mGrandTotalTicket.getId());
            }
        });
    }

    public void addInfoKitchenToOrder(final String id, final int id_order_kitchen) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS  SET ID_ORDER_KITCHEN = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_order_kitchen);
                this.setString(2, id);
            }
        });
    }

    public Double getCumulPerpetualGrandTotalReelBefore(final Date mDateTotal) throws BasicException {
        Object[] values = (Object[])new PreparedSentence(this.s, "SELECT SUM(G.grand_total) as cumul FROM GRAND_TOTAL G WHERE G.timestampGDH <= ? ", SerializerWriteParams.INSTANCE, new SerializerReadBasic(new Datas[]{Datas.DOUBLE})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, mDateTotal);
            }
        });
        return (Double)values[0];
    }

    public void setSharedOrderInfos(final String id, final int id_shared_order, final boolean shared_order) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS  SET ID_SHARED_ORDER = ?, SHARED_ORDER = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_shared_order);
                this.setBoolean(2, shared_order);
                this.setString(3, id);
            }
        });
    }

    public final List<TicketInfo> loadPaidOrder(final Date dateStart, final Date dateEnd) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicket + "WHERE T.DATE_PAID >= ? AND T.DATE_PAID <= ? ORDER BY T.TICKETID desc ", SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        for (TicketInfo ticket : tickets) {
            this.loadInfoOrder(ticket);
        }
        return tickets;
    }

    private void loadInfoOrder(TicketInfo ticket) throws BasicException {
        if (ticket != null) {
            int idTable = ticket.getIdTable();
            ticket.setTable(idTable == -1 ? null : this.m_dlSales.loadTable(idTable));
            ticket.setPayments(this.m_dlSales.findPaymetsByIdTicket(ticket.getId()));
        }
    }

    public void addInfoKitchenToLine(final int id_line, final int id_line_kitchen) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETLINES  SET ID_LINE_KITCHEN = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_line_kitchen);
                this.setInt(2, id_line);
            }
        });
    }

    public void addInfoKitchenToSupplement(final int id_supplement, final int id_supplement_kitchen) throws BasicException {
        new PreparedSentence(this.s, "UPDATE Option_ticket  SET ID_SUPPLEMENT_KITCHEN = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_supplement_kitchen);
                this.setInt(2, id_supplement);
            }
        });
    }

    public void addInfoKitchenToIngredient(final int id_ingredient, final int id_ingredient_kitchen) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ingredient_ticket  SET ID_INGREDIENT_KITCHEN = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_ingredient_kitchen);
                this.setInt(2, id_ingredient);
            }
        });
    }

    public void addInfoKitchenToItem(final int id_item, final int id_item_kitchen) throws BasicException {
        new PreparedSentence(this.s, "UPDATE Product_ticket  SET ID_ITEM_KITCHEN = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_item_kitchen);
                this.setInt(2, id_item);
            }
        });
    }

    public List<GrandTotalPeriode> getGrandTotauxPeriod() throws BasicException {
        List listTotaux = new PreparedSentence(this.s, this.requestGTP + " where ADD_TO_Z_GLOBAL = 0 order by CAST (id AS INTEGER) ", null, GrandTotalPeriode.getSerializerRead()).list();
        for (GrandTotalPeriode grandTotalPeriode : listTotaux) {
            grandTotalPeriode.setGtpTaxes(this.getGTPTaxes(grandTotalPeriode.getId()));
        }
        return listTotaux;
    }

    public void addToZGlobal(final GrandTotalPeriode grandTotalPeriod) throws BasicException {
        new PreparedSentence(this.s, "UPDATE GRAND_TOTAL_PERIODE  SET ADD_TO_Z_GLOBAL = 1 WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, grandTotalPeriod.getId());
            }
        });
    }

    public List<GrandTotalPeriode> loadGTPToUpdateTaxes(final String type) throws BasicException {
        ArrayList listTotaux = new PreparedSentence(this.s, this.requestGTP + " WHERE type_PERIODE = ? and ISSYNCHRONIZED = 1  order by timestampGDH DESC", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type);
            }
        });
        if (listTotaux == null) {
            listTotaux = new ArrayList();
        }
        return listTotaux;
    }

    public List<GroupedTax> getGTPTaxes(String idPeriod) throws BasicException {
        List gtpTaxes = new PreparedSentence(this.s, "SELECT ID, ID_PERIOD, CODE_TAX, NAME, RATE_TAX, TOTAL_HT, TOTAL_TAX, TOTAL_TTC, TAXE_GLOBAL FROM GTP_TAXES where ID_PERIOD = ? ", SerializerWriteString.INSTANCE, GroupedTax.getSerializerRead()).list((Object)idPeriod);
        return gtpTaxes;
    }
}

