/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.AppConstants;
import com.openbravo.basic.BasicException;
import com.openbravo.beans.CarteMenu;
import com.openbravo.beans.ProductSupplementsRelation;
import com.openbravo.beans.ProdustIngredientRelation;
import com.openbravo.dao.DAOConstants;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerReadClass;
import com.openbravo.data.loader.SerializerReadDate;
import com.openbravo.data.loader.SerializerReadString;
import com.openbravo.data.loader.SerializerWriteInteger;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.CarteInfo;
import com.openbravo.pos.ticket.CarteItemInfo;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.CategoryDayAvailable;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.ItemIngredientInfo;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductDayOn;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductPriceInfo;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.ticket.ScreenProduct;
import com.openbravo.pos.ticket.ScreenSupplementInfo;
import com.openbravo.pos.ticket.ScreenSupplementItem;
import com.openbravo.pos.ticket.ShiftCategory;
import com.openbravo.pos.ticket.ShiftProduct;
import com.openbravo.pos.ticket.StockDetailHistoryInfo;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementPriceInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TableInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TaxLineTicket;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.StaticSentence;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.Line;
import fr.protactile.norm.beans.LineFacture;
import fr.protactile.norm.beans.LineNote;
import fr.protactile.norm.beans.RecapGeneralFacture;
import fr.protactile.norm.beans.RecapGeneralNote;
import fr.protactile.norm.beans.RecapTaxFacture;
import fr.protactile.norm.beans.RecapTaxNote;
import fr.protactile.norm.beans.TicketPayementNorm;
import fr.protactile.norm.beans.TotalTax;
import fr.protactile.procaisse.dao.entities.Allergene;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import fr.protactile.procaisse.dao.entities.MultiLanguageCategory;
import fr.protactile.procaisse.dao.entities.MultiLanguageProduct;
import fr.protactile.procaisse.dao.entities.MultiLanguagePromotion;
import fr.protactile.procaisse.dao.entities.NutritionalInfoProduct;
import fr.protactile.procaisse.dao.entities.TagInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DataLogicItems
extends DataLogicSales {
    String requestSuppProduct = "SELECT S.id, S.name, I.has_limit_options, " + DAOConstants.SQLFunction + "(I.min_options, 0) as min_options, " + DAOConstants.SQLFunction + "(I.max_options, 0) as max_options, S.is_ingredient, S.is_bold, S.color, S.number_click, S.path, S.order_name, I.free_able, I.separate, S.multiple_category, S.display_free, " + DAOConstants.SQLFunction + "(S.printer, -1) as printer, S.shift_option, S.display_screen_sorti, I.option_free, S.NO_PRINTABLE,I.option_free_size2, I.min_options_size2, I.max_options_size2, I.option_free_size3, I.min_options_size3, I.max_options_size3, I.option_free_size4, I.min_options_size4, I.max_options_size4, I.option_free_size5, I.min_options_size5, I.max_options_size5, I.option_free_size6, I.min_options_size6, I.max_options_size6,I.many_size, I.OPTION_FREE_SIZE7, I.MIN_OPTIONS_SIZE7, I.MAX_OPTIONS_SIZE7, I.OPTION_FREE_SIZE8, I.MIN_OPTIONS_SIZE8, I.MAX_OPTIONS_SIZE8, I.OPTION_FREE_SIZE9, I.MIN_OPTIONS_SIZE9, I.MAX_OPTIONS_SIZE9, I.OPTION_FREE_SIZE10, I.MIN_OPTIONS_SIZE10, I.MAX_OPTIONS_SIZE10, S.PRINT_BLACK_BACKGROUND, S.ID_GLOBAL, S.order_supplement, S.SUPPLEMENT_UBEREAT FROM SUPPLEMENT S JOIN ITEM_SUPPLEMENTS I ON S.id = I.id_supplement  ";
    String requestLines = "SELECT ID,  NUM_DOC, NUM_LINE, CODE_PRODUCT, ORIGIN_DATA, DESCRIPTIVE_PRODUCT, CODE_TAX, RATE_TAX, PRICE_HT, PRICE_TTC, TOTAL_HT, TOTAL_TTC, TYPE_OPERATION,\tCODE_USER,TIMESTAMPGDH,\tCODE_CAISSE,\tTICKET,\tQUANTITE, DISCOUNT, TAUX_DISCOUNT,\t HORODATAGE, " + DAOConstants.SQLFunction + "(REF_ORIGINE, 0) as REF_ORIGINE, " + DAOConstants.SQLFunction + "(TOTAL_TAX, 0) as TOTAL_TAX  FROM LINES ";
    String requestTotalTax = "SELECT ID, NUM_DOC, NUM_LINE, TOTAL_HT, CODE_TAX, RATE_TAX, TOTAL_TAX, TOTAL_TTC, TICKET, TIMESTAMPGDH, " + DAOConstants.SQLFunction + "(REF_ORIGINE, 0) as REF_ORIGINE FROM TOTAL_TAX ";
    String requestTicketPayement = "SELECT \tID, \tNUM_DOC, \tTYPE_REGULATION, \tCODE_REGULATION, \tMODE_REGULATION,\tTOTAL,\tQUANTITY,\tTYPE_OPERATION,\tCODE_USER,\tTIMESTAMPGDH,\tCODE_CAISSE,\tTICKET,\tHORODATAGE, " + DAOConstants.SQLFunction + "(REF_ORIGINE, 0) as REF_ORIGINE FROM TICKET_PAYMENT ";
    private String requestSupplementPrice = "SELECT S.ID, S.TYPE_ORDER, S.PRICE, S.PRICE_JUNIOR, S.PRICE_SENIOR,  S.PRICE_MEGA, S.PRICE_SIZE1, S.PRICE_SIZE2, S.PRICE_SIZE3, S.SUPPLEMENT_ID, S.REF_SYNCHRO, S.PRICE_SIZE4, S.PRICE_SIZE5, S.PRICE_SIZE6, S.PRICE_SIZE7, S.ID_GLOBAL  FROM SUPPLEMENT_ITEM_PRICES S ";
    private String requestFullSuppItem = "SELECT S.id, S.name, S.price, S.price2, S.price3, S.price_junior, S.price_senior, S.price_mega, S.id_supplement, S.many_size, S.path, S.price_size1, S.price_size2, S.price_size3, S.REF_WEB, S.removed, S.order_item, S.HIDDEN_BORNE, S.color, S.ALIAS_KITCHEN, S.SEND_COLOR, S.FLAME_ENABLED, S.NUMBER_FLAME, S.REMOVED_BY_ADMIN, S.MANY_TYPE, S.HIDDEN, G.is_bold, " + DAOConstants.SQLFunction + "(G.printer, -1) as printer, G.shift_option, G.display_screen_sorti, G.color, G.NO_PRINTABLE, S.HIDDEN_UBEREAT, S.HIDDEN_ONLINE, S.PRICE_SIZE4, S.PRICE_SIZE5, S.PRICE_SIZE6, S.PRICE_SIZE7, S.SUPPLEMENT_ITEM_UBEREAT, " + DAOConstants.SQLFunction + "(S.ID_PRODUCT, 0) as ID_PRODUCT, G.name, S.SOLD_OUT, S.HIDDEN_IN_KITCHEN, G.display_free, G.PRINT_BLACK_BACKGROUND, S.ITEM_PLU, S.COOKABLE, S.TAX_ID, S.PRICE_ALREADY_INCLUDED, G.PRINT_BLACK_BACKGROUND,S.DATE_START_DISPLAY, S.DATE_END_DISPLAY FROM SUPPLEMENT_ITEM S ";
    private String requestGroupeSubSupplement = "SELECT G.ID, G.NAME_GROUP, G.TITLE_GROUP, G.REMOVED, G.HAS_LIMIT_OPTIONS, " + DAOConstants.SQLFunction + "(G.MIN_OPTIONS, 0) as MIN_OPTIONS, " + DAOConstants.SQLFunction + "(G.MAX_OPTIONS, 0) as MAX_OPTIONS, G.OPTION_FREE, G.NUMBER_CLICK, G.ID_GLOBAL FROM GROUPE_SUB_SUPPLEMENTS G ";
    private String requestPromotions = "SELECT P.ID, P.NAME_PROMOTION, P.TYPE_ORDER, P.SIZE_PRODUCT, P.QUANTITY, P.DISCOUNT, P.REMOVED, P.REMOVED_BY_ADMIN, P.REF_SYNCHRO,P.LABEL_SIZE_PRODUCT, P.LABEL_DISCOUNT, P.DESCRIPTION, P.TEXT_PROMOTION, P.ID_GLOBAL FROM PROMOTIONS P ";
    String requestLinesNote = "SELECT ID,  ref_note, NUM_LINE, CODE_PRODUCT, ORIGIN_DATA, DESCRIPTIVE_PRODUCT, PRICE_TTC, TOTAL_TTC, TYPE_OPERATION,\tcode_operator, TIMESTAMPGDH,\tCODE_CAISSE,\tQUANTITE, DISCOUNT, TAUX_DISCOUNT,\t HORODATAGE,  CODE_TAX,  RATE_TAX,  TOTAL_HT  FROM LINES_NOTE ";
    private final String AT_SPOT = "Sur Place";
    private final String TAKE_AWAY = "A Emporter";
    private final String DELIVERY = "En Livraison";
    private final String PLATFORM = "Platform";

    public Map<String, Object> getItemInfoById(final int id) throws BasicException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String q = "SELECT P.ID AS ID_PRODUCT, P.NAME AS NAME_PRODUCT, P.PRICEBUY, C.ID AS ID_CATEGORY, C.NAME, C.ID_GLOBAL AS CATEGORY_NAME FROM PRODUCTS P LEFT JOIN CATEGORIES C ON C.ID = P.CATEGORY WHERE P.ID = ? ";
        Object[] record = (Object[])new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.STRING, Datas.DOUBLE, Datas.INT, Datas.STRING, Datas.STRING})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
        if (record != null) {
            data.put("item_id", (int)((Integer)record[0]));
            data.put("item_name", (String)record[1]);
            data.put("price_buy", (double)((Double)record[2]));
            data.put("category_id", (int)((Integer)record[3]));
            data.put("category_name", (String)record[4]);
            data.put("category_id_global", (String)record[5]);
        }
        return data;
    }

    public Map<String, Object> getOptionInfoById(final int idOption) throws BasicException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String q = " SELECT SI.id AS ID, SI.name AS NAME, S.id AS ID_CATEGORY, S.name AS CATEGORY_NAME, SI.ITEM_PLU as ID_GLOBAL, S.ID_GLOBAL as CATEGORY_ID_GLOBAL FROM SUPPLEMENT_ITEM SI LEFT JOIN SUPPLEMENT S ON S.id = SI.id_supplement WHERE SI.id = ?";
        Object[] record = (Object[])new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT, Datas.STRING, Datas.INT, Datas.STRING, Datas.STRING, Datas.STRING})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idOption);
            }
        });
        if (record != null) {
            data.put("option_id", (int)((Integer)record[0]));
            data.put("option_name", (String)record[1]);
            data.put("category_id", (int)((Integer)record[2]));
            data.put("category_name", (String)record[3]);
            data.put("id_global", (String)record[4]);
            data.put("category_id_global", (String)record[5]);
        }
        return data;
    }

    public void updateUserKeenIo(final String userKeenIo) throws BasicException {
        System.out.println("+++++ userKeenIo : " + userKeenIo);
        new PreparedSentence(this.s, "UPDATE  caisse SET user_keenio_id = ? WHERE token = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, userKeenIo);
                this.setString(2, AppLocal.token);
            }
        });
    }

    public String getUserKeenIo() throws BasicException {
        String data = null;
        String q = "SELECT user_keenio_id FROM caisse  WHERE token = ? ";
        Object[] record = (Object[])new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, AppLocal.token);
            }
        });
        if (record != null) {
            data = (String)record[0];
        }
        System.out.println("+++++ data 1 : " + data);
        return data;
    }

    public void setTicketSynchronized(final String ticket_id, final boolean is_sync) throws BasicException {
        System.out.println("++++++++++++++++ is_sync : " + is_sync);
        new PreparedSentence(this.s, "UPDATE TICKETS SET is_sync_keenio = ?, IS_SYNC_SOURCE_ORDER = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, is_sync);
                this.setBoolean(2, true);
                this.setString(3, ticket_id);
            }
        });
    }

    public void unsetTicketSynchronized(final String ticket_id, final boolean value, final boolean detach_sync_keenio_verified) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS SET detach_sync_keenio = ?, DETACH_SYNC_KEENIO_VERIFIED = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, value);
                this.setBoolean(2, detach_sync_keenio_verified);
                this.setString(3, ticket_id);
            }
        });
    }

    private void fillTicketInfo(TicketInfo ticket) throws BasicException {
        int idTable = ticket.getIdTable();
        ticket.setTable(idTable == -1 ? null : this.loadTable(idTable));
        List<TicketLineInfo> lines = super.loadLines(ticket.getId());
        List<TicketLineInfo> linesExterne = super.getTicketLineExterne(ticket.getId());
        List<PaymentLine> payments = super.loadPaymentByTicket(ticket.getId());
        ArrayList<PaymentInfo> paymentsInfo = new ArrayList<PaymentInfo>();
        for (PaymentLine next : payments) {
            double value = next.getM_PaymentValue();
            if (next.getM_PaymentType().equals("Espece") || next.getM_PaymentType().equals("cash")) {
                paymentsInfo.add(new PaymentInfo("Espece", value, value));
                continue;
            }
            if (next.getM_PaymentType().equals("cheque")) {
                paymentsInfo.add(new PaymentInfo("cheque", value, value));
                continue;
            }
            if (next.getM_PaymentType().equals("CB")) {
                paymentsInfo.add(new PaymentInfo("CB", value, value));
                continue;
            }
            if (next.getM_PaymentType().equals(AppConstants.PAYMENT_MODE.TICKET_RESTO.getName())) {
                paymentsInfo.add(new PaymentInfo(AppConstants.PAYMENT_MODE.TICKET_RESTO.getName(), value, value));
                continue;
            }
            if (next.getM_PaymentType().equals("Avoir")) {
                paymentsInfo.add(new PaymentInfo("Avoir", value, value));
                continue;
            }
            paymentsInfo.add(new PaymentInfo(next.getM_PaymentType(), value, value));
        }
        ticket.setPayments(paymentsInfo);
        lines.addAll(linesExterne);
        ticket.setLines(lines);
    }

    private List<TicketInfo> orderLoaderByQuery(String query, boolean has_detail) throws BasicException {
        List tickets = new PreparedSentence(this.s, query, null, new SerializerReadClass(TicketInfo.class)).list();
        if (has_detail) {
            for (TicketInfo ticket : tickets) {
                if (ticket == null) continue;
                this.fillTicketInfo(ticket);
            }
        }
        return tickets;
    }

    public final List<String> loadOrderIdsNotSynchronized(int rows) throws BasicException {
        String q = "SELECT T.ID  FROM RECEIPTS R LEFT JOIN TICKETS T ON R.ID = T.ID WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.is_sync_keenio = 0 ORDER BY T.TICKETID desc fetch first " + rows + " rows only";
        ArrayList<String> mList = new ArrayList<String>();
        List recsales = new PreparedSentence(this.s, q, null, new SerializerReadBasic(new Datas[]{Datas.STRING})).list();
        if (recsales != null) {
            for (Object[] next : recsales) {
                if (next == null || next.length <= 0) continue;
                mList.add((String)next[0]);
            }
        }
        return mList;
    }

    public final List<String> loadOrderIdsNotSynchronized() throws BasicException {
        return this.loadOrderIdsNotSynchronized(100);
    }

    public final TicketInfo fetchTicketNotSynchronized(final String ticketID, boolean has_detail) throws BasicException {
        String q = "SELECT T.ID, T.TICKETTYPE, T.TICKETID, T.type, T.modePayment, T.tempsLv, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, " + DAOConstants.SQLFunction + "(T.CUSTOMER, -1) as CUSTOMER, T.STATUS, T.total, " + DAOConstants.SQLFunction + "(T.address, -1) as address, T.numero_order, " + DAOConstants.SQLFunction + "(T.idTable, -1) as idTable, T.discount, T.typediscount, T.bipper, T.transferred, T.reason_cancel, " + DAOConstants.SQLFunction + "(T.invoice , 0) as invoice , PL.ID as ID_LIVREUR, PL.NAME as NAME_LIVREUR, " + DAOConstants.SQLFunction + "(T.canceled_ticket_id_Int,0) as OrigineTicket,T.accepted, T.paid ,T.last_update, T.couverts, T.SOURCE_ORDER, T.NAME_CUSTOMER, T.date_paid, T.closed, T.canceled_ticket_id," + DAOConstants.SQLFunction + "(T.num_order_kitchen, -1) as num_order_kitchen, CU.ID, T.ORDERED_FROM, T.ID_ORDER_KITCHEN, T.SENT_FROM, T.NUMERO_ONLINE_ORDER, T.PRINT_AFTER_UPDATE, T.NUM_TABLE, T.NUM_PLATFORM_ORDER, T.LABEL_DISCOUNT, T.ID_SHARED_ORDER, T.DELIVERED_AT, T.LICENCE_ID_MACHINE, T.CUSTOMER_LOYALTY_VERIFIED, T.EASEL_NUMBER, T.PLATFORM_ORDER, T.SHARED_ORDER, T.ORDER_ID_BASE, T.KEENIO_BASE_ORDER, T.TAKE_AWAY_PHONE, T.TPS, T.TVQ, T.session_id,T.tag_erc_stan,  T.eft_stan,  T.last_digit,  T.EcrDateTime, T.holder FROM RECEIPTS R LEFT JOIN TICKETS T ON R.ID = T.ID LEFT JOIN caisse C ON T.caisse = C.ID LEFT JOIN PEOPLE P ON T.PERSON = P.ID LEFT JOIN PEOPLE PL ON T.livreur = PL.ID LEFT JOIN COUNTER_USER CU ON P.ID = CU.ID_USER WHERE T.ID = ? AND T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND T.is_sync_keenio = 0";
        TicketInfo mTicket = (TicketInfo)new PreparedSentence(this.s, q, SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticketID);
            }
        });
        if (has_detail && mTicket != null) {
            this.fillTicketInfo(mTicket);
        }
        return mTicket;
    }

    public final List<TicketInfo> loadOrderNotSynchronized() throws BasicException {
        String q = "SELECT T.ID, T.TICKETTYPE, T.TICKETID, T.type, T.modePayment, T.tempsLv, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, " + DAOConstants.SQLFunction + "(T.CUSTOMER, -1) as CUSTOMER, T.STATUS, T.total, " + DAOConstants.SQLFunction + "(T.address, -1) as address, T.numero_order, " + DAOConstants.SQLFunction + "(T.idTable, -1) as idTable, T.discount, T.typediscount, T.bipper, T.transferred, T.reason_cancel, " + DAOConstants.SQLFunction + "(T.invoice , 0) as invoice , PL.ID as ID_LIVREUR, PL.NAME as NAME_LIVREUR, " + DAOConstants.SQLFunction + "(T.canceled_ticket_id_Int,0) as OrigineTicket,T.accepted, T.paid ,T.last_update, T.couverts, T.SOURCE_ORDER, T.NAME_CUSTOMER, T.date_paid, T.closed, T.canceled_ticket_id," + DAOConstants.SQLFunction + "(T.num_order_kitchen, -1) as num_order_kitchen, CU.ID, T.ORDERED_FROM, T.ID_ORDER_KITCHEN, T.SENT_FROM, T.NUMERO_ONLINE_ORDER, T.PRINT_AFTER_UPDATE, T.NUM_TABLE, T.NUM_PLATFORM_ORDER, T.LABEL_DISCOUNT,  T.ID_SHARED_ORDER, T.DELIVERED_AT, T.LICENCE_ID_MACHINE, T.CUSTOMER_LOYALTY_VERIFIED, T.EASEL_NUMBER,T.PLATFORM_ORDER, T.SHARED_ORDER, T.ORDER_ID_BASE, T.KEENIO_BASE_ORDER, T.TAKE_AWAY_PHONE, T.TPS, T.TVQ, T.session_id,T.tag_erc_stan,  T.eft_stan,  T.last_digit,  T.EcrDateTime, T.holder FROM RECEIPTS R LEFT JOIN TICKETS T ON R.ID = T.ID LEFT JOIN caisse C ON T.caisse = C.ID LEFT JOIN PEOPLE P ON T.PERSON = P.ID LEFT JOIN PEOPLE PL ON T.livreur = PL.ID LEFT JOIN COUNTER_USER CU ON P.ID = CU.ID_USER WHERE paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND is_sync_keenio = 0 ORDER BY R.DATENEW desc fetch first 10 rows only";
        return this.orderLoaderByQuery(q, true);
    }

    public List<TicketInfo> loadOrderSynchronizedToUnattach() throws BasicException {
        String q = "SELECT T.ID, T.TICKETTYPE, T.TICKETID, T.type, T.modePayment, T.tempsLv, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, " + DAOConstants.SQLFunction + "(T.CUSTOMER, -1) as CUSTOMER, T.STATUS, T.total, " + DAOConstants.SQLFunction + "(T.address, -1) as address,T.numero_order, " + DAOConstants.SQLFunction + "(T.idTable, -1) as idTable,T.discount, T.typediscount, T.bipper, T.transferred, T.reason_cancel, " + DAOConstants.SQLFunction + "(T.invoice , 0) as invoice , PL.ID as ID_LIVREUR, PL.NAME as NAME_LIVREUR, " + DAOConstants.SQLFunction + "(T.canceled_ticket_id_Int,0) as OrigineTicket, T.accepted, T.paid ,T.last_update, T.couverts, T.SOURCE_ORDER, T.NAME_CUSTOMER, T.date_paid, T.closed, T.canceled_ticket_id, " + DAOConstants.SQLFunction + "(T.num_order_kitchen, -1) as num_order_kitchen, CU.ID, T.ORDERED_FROM, T.ID_ORDER_KITCHEN, T.SENT_FROM, T.NUMERO_ONLINE_ORDER, T.PRINT_AFTER_UPDATE, T.NUM_TABLE, T.NUM_PLATFORM_ORDER, T.LABEL_DISCOUNT,  T.ID_SHARED_ORDER, T.DELIVERED_AT, T.LICENCE_ID_MACHINE, T.CUSTOMER_LOYALTY_VERIFIED, T.EASEL_NUMBER,T.PLATFORM_ORDER, T.SHARED_ORDER, T.ORDER_ID_BASE, T.KEENIO_BASE_ORDER, T.TAKE_AWAY_PHONE, T.TPS, T.TVQ, T.session_id,T.tag_erc_stan,  T.eft_stan,  T.last_digit,  T.EcrDateTime, T.holder FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID JOIN caisse C ON T.caisse = C.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID LEFT OUTER JOIN PEOPLE PL ON T.livreur = PL.ID LEFT JOIN COUNTER_USER CU ON P.ID = CU.ID_USER WHERE STATUS = 'cancel' AND is_sync_keenio = 1 AND detach_sync_keenio = 1 ORDER BY R.DATENEW desc fetch first 1000 rows only";
        return this.orderLoaderByQuery(q, false);
    }

    public boolean isClotured(String typePeriode, Date toDay) {
        boolean isClotured = false;
        try {
            GrandTotalPeriode lastGrandTotalPeriode = this.getLastGrandTotalPeriode(typePeriode);
            if (lastGrandTotalPeriode != null) {
                switch (typePeriode) {
                    case "j": {
                        if (new Integer(DateUtils.SDF_ID_DAY_PERIOD.format(toDay)) > new Integer(lastGrandTotalPeriode.getId())) break;
                        isClotured = true;
                        break;
                    }
                    case "m": {
                        if (new Integer(DateUtils.SDF_ID_MONTH_PERIOD.format(toDay)) > new Integer(lastGrandTotalPeriode.getId())) break;
                        isClotured = true;
                        break;
                    }
                    case "a": {
                        if (new Integer(DateUtils.SDF_ID_YEAR_PERIOD.format(toDay)) > new Integer(lastGrandTotalPeriode.getId())) break;
                        isClotured = true;
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return isClotured;
    }

    public boolean isFirstDay() {
        try {
            Date now = new Date();
            GrandTotalTicket g = this.getFirstTotalTicket();
            System.out.println("++++++++++++++ g : " + g);
            if (g == null || g != null && g.getTimestampGDH().getDate() == now.getDate() && g.getTimestampGDH().getMonth() == now.getMonth() && g.getTimestampGDH().getYear() == now.getYear()) {
                GrandTotalPeriode mGrandTotalPeriode = this.getGrandTotal();
                return mGrandTotalPeriode == null;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return false;
    }

    public boolean isFirstMonth() {
        try {
            Date now = new Date();
            GrandTotalTicket g = this.getFirstTotalTicket();
            if (g == null || g != null && g.getTimestampGDH().getMonth() == now.getMonth() && g.getTimestampGDH().getYear() == now.getYear()) {
                GrandTotalPeriode mGrandTotalPeriode = this.getLastGrandTotalPeriode("m");
                return mGrandTotalPeriode == null;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return false;
    }

    public boolean isFirstYear() {
        try {
            Date now = new Date();
            GrandTotalTicket g = this.getFirstTotalTicket();
            if (g == null || g != null && g.getTimestampGDH().getYear() == now.getYear()) {
                GrandTotalPeriode mGrandTotalPeriode = this.getLastGrandTotalPeriode("a");
                return mGrandTotalPeriode == null;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return false;
    }

    public void copieIngredient(SupplementInfo gIngredient) throws BasicException, SQLException {
        int idIngredient = gIngredient.getiD();
        SupplementInfo groupeOption = (SupplementInfo)gIngredient.clone();
        groupeOption.setIs_ingredient(false);
        groupeOption.setId_global(null);
        SupplementInfo gOption = this.addGroupeOption(groupeOption, true);
        List<SupplementItemInfo> items = this.getIngredientsItem(idIngredient);
        for (SupplementItemInfo ingredientItem : items) {
            SupplementItemInfo optionItem = (SupplementItemInfo)ingredientItem.clone();
            optionItem.setId_global(null);
            optionItem.setId_supplement(gOption.getiD());
            this.addOption(optionItem, false);
        }
    }

    public void cloneOption(SupplementInfo OldGOption) throws BasicException, SQLException {
        int idGOption = OldGOption.getiD();
        SupplementInfo groupeOption = (SupplementInfo)OldGOption.clone();
        groupeOption.setId_global(null);
        groupeOption.setName(OldGOption.getName() + " copie");
        SupplementInfo gOption = this.addGroupeOption(groupeOption, true);
        List<SupplementItemInfo> items = this.getSuppelementsItem(idGOption, false);
        for (SupplementItemInfo item : items) {
            SupplementItemInfo optionItem = (SupplementItemInfo)item.clone();
            optionItem.setId_global(null);
            optionItem.setId_supplement(gOption.getiD());
            this.addOption(optionItem, false);
        }
    }

    public final List<StockDetailHistoryInfo> getStockDetailHistory(Date date) throws BasicException {
        final int year = date.getYear() + 1900;
        final int month = date.getMonth() + 1;
        final int day = date.getDate();
        List stockDetailHistory = new PreparedSentence(this.s, "SELECT PR.NAME, P.NAME, H.date_operation, H.quantity, H.type_operation FROM HISTORIQUE_STOCK as H LEFT JOIN PRODUCTS PR ON H.product = PR.ID LEFT JOIN PEOPLE P ON H.user_operator = P.ID WHERE YEAR(H.date_operation) = ? AND MONTH(H.date_operation) = ? AND DAY(H.date_operation) = ?ORDER BY H.date_operation desc ", SerializerWriteParams.INSTANCE, StockDetailHistoryInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, year);
                this.setInt(2, month);
                this.setInt(3, day);
            }
        });
        return stockDetailHistory;
    }

    public List<GrandTotalPeriode> loadGrandTotalPeriodBetween(final Date dateStart, final Date dateEnd) throws BasicException {
        ArrayList listTotaux = new PreparedSentence(this.s, this.requestGTP + " WHERE timestampGDH >= ? and timestampGDH <= ? order by timestampGDH DESC", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
        if (listTotaux == null) {
            listTotaux = new ArrayList();
        }
        return listTotaux;
    }

    public void updateProductCaisse(final ProductInfoExt product, int oldPosition) throws BasicException {
        List<ProductInfoExt> products;
        if (oldPosition > product.getOrder_item()) {
            products = this.getProductsInf(product.getOrder_item(), oldPosition);
            for (final ProductInfoExt product1 : products) {
                new PreparedSentence(this.s, "UPDATE PRODUCTS SET order_item = order_item + 1 WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, product1.getID());
                    }
                });
            }
        }
        if (oldPosition < product.getOrder_item()) {
            products = this.getProductsSup(oldPosition);
            for (final ProductInfoExt product1 : products) {
                new PreparedSentence(this.s, "UPDATE PRODUCTS SET order_item = order_item - 1 WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, product1.getID());
                    }
                });
            }
        }
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET NAME = ?, PRICESELL = ?, order_item = ?, color = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, product.getName());
                this.setDouble(2, product.getPriceSell());
                this.setInt(3, product.getOrder_item());
                this.setString(4, product.getColor());
                this.setInt(5, product.getID());
            }
        });
    }

    public void updateCategoryCaisse(final CategoryInfo category, int oldPosition) throws BasicException {
        List<CategoryInfo> categories;
        if (oldPosition > category.getOrdercategory()) {
            categories = this.getCategoriesInf(category.getOrdercategory(), oldPosition);
            for (final CategoryInfo category1 : categories) {
                new PreparedSentence(this.s, "UPDATE CATEGORIES SET order_category = order_category +1 WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, category1.getID());
                    }
                });
            }
        }
        if (oldPosition < category.getOrdercategory()) {
            categories = this.getCategoriesSup(oldPosition);
            for (final CategoryInfo category1 : categories) {
                new PreparedSentence(this.s, "UPDATE CATEGORIES SET order_category = order_category -1 WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, category1.getID());
                    }
                });
            }
        }
        new PreparedSentence(this.s, "UPDATE CATEGORIES SET NAME = ?, order_category = ?, color = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, category.getName());
                this.setInt(2, category.getOrdercategory());
                this.setString(3, category.getColor());
                this.setInt(4, category.getID());
            }
        });
    }

    public List<CategoryInfo> getCategoriesInf(final int firstPosition, final int lastPosition) throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 AND order_category >= ? AND order_category < ?", SerializerWriteParams.INSTANCE, CategoryInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, firstPosition);
                this.setInt(2, lastPosition);
            }
        });
    }

    public List<ProductInfoExt> getProductsInf(final int firstPosition, final int lastPosition) throws BasicException {
        return new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.order_item >= ? AND P.order_item < ?", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, firstPosition);
                this.setInt(2, lastPosition);
            }
        });
    }

    public List<CategoryInfo> getCategoriesSup(final int oldPosition) throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 AND order_category > ?", SerializerWriteParams.INSTANCE, CategoryInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, oldPosition);
            }
        });
    }

    public List<ProductInfoExt> getProductsSup(final int oldPosition) throws BasicException {
        return new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.order_item > ?", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, oldPosition);
            }
        });
    }

    public CarteInfo addCarte(CarteInfo carteInfo) throws BasicException, SQLException {
        String SQL = "INSERT INTO CARTE (name) VALUES (?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, carteInfo.getName());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        if (rs.next()) {
            int last_inserted_id = rs.getInt(1);
            carteInfo.setId(last_inserted_id);
        }
        this.setIdGlobalItem(carteInfo.getId(), "CARTE", "ID_GLOBAL", carteInfo.getId_global());
        return carteInfo;
    }

    public void addCarteItem(final CarteItemInfo carteItemInfo) throws BasicException, SQLException {
        PreparedSentence carteItemInsert = new PreparedSentence(this.s, "INSERT INTO CARTE_ITEM (id_carte, id_item, price) VALUES (?, ?, ?)", SerializerWriteParams.INSTANCE);
        carteItemInsert.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, carteItemInfo.getId_carte());
                this.setInt(2, carteItemInfo.getId_item());
                this.setDouble(3, NumericUtils.round(carteItemInfo.getPrice()));
            }
        });
    }

    public void addCarteMenu(List<CarteMenu> cartes) throws BasicException {
        PreparedSentence carteinsert = new PreparedSentence(this.s, "INSERT INTO CARTE_MENU (id_carte, id_item, carteOrder, number_carte) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
        for (final CarteMenu carte : cartes) {
            carteinsert.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, carte.getIdCarte());
                    this.setInt(2, carte.getIdItem());
                    this.setInt(3, carte.getCarteOrder());
                    this.setInt(4, carte.getNumber_carte());
                }
            });
        }
    }

    public SupplementItemInfo addSupplementItem(SupplementItemInfo option) throws SQLException, BasicException {
        String SQL = "INSERT INTO SUPPLEMENT_ITEM (name, price, price_junior, price_senior, price_mega, id_supplement, order_item, many_size, path, price_size1, price_size2, price_size3, COOKABLE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, option.getName());
        this.pstmt.setDouble(2, option.getPrice());
        this.pstmt.setDouble(3, option.getPrice_junior());
        this.pstmt.setDouble(4, option.getPrice_senior());
        this.pstmt.setDouble(5, option.getPrice_mega());
        this.pstmt.setInt(6, option.getId_supplement());
        this.pstmt.setInt(7, option.getOrderItem());
        this.pstmt.setBoolean(8, option.isMany_size());
        this.pstmt.setString(9, option.getPath());
        this.pstmt.setDouble(10, option.getPrice_size1());
        this.pstmt.setDouble(11, option.getPrice_size2());
        this.pstmt.setDouble(12, option.getPrice_size3());
        this.pstmt.setBoolean(13, option.isCookable());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idGIngredient = -1;
        if (rs.next()) {
            idGIngredient = rs.getInt(1);
        }
        option.setiD(idGIngredient);
        this.setIdGlobalItem(option.getiD(), "SUPPLEMENT_ITEM", "ITEM_PLU", option.getId_global());
        return option;
    }

    public void addItemIngredientRelation(List<ProdustIngredientRelation> ingredients) throws BasicException {
        PreparedSentence itemIngredientinsert = new PreparedSentence(this.s, "INSERT INTO ITEM_INGREDIENTS (id_supplement_item, id_item, quantity) VALUES (?, ?, ?)", SerializerWriteParams.INSTANCE);
        for (final ProdustIngredientRelation ingredient : ingredients) {
            itemIngredientinsert.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, ingredient.getSupplementId());
                    this.setInt(2, ingredient.getProductId());
                    this.setInt(3, ingredient.getQuantity());
                }
            });
        }
    }

    public void addItemSupplements(List<ProductSupplementsRelation> options) throws BasicException {
        PreparedSentence itemOptioninsert = new PreparedSentence(this.s, "INSERT INTO ITEM_SUPPLEMENTS (id_supplement, id_item, free_able , separate) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
        for (final ProductSupplementsRelation option : options) {
            itemOptioninsert.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, option.getSupplementId());
                    this.setInt(2, option.getProductId());
                    this.setBoolean(3, option.isFreeAble());
                    this.setBoolean(4, option.isSeparable());
                }
            });
        }
    }

    public final List<CategoryInfo> getCategories(boolean load_sub_categories, boolean check_if_removed, boolean detail_category) throws BasicException {
        String requestRemoved = check_if_removed ? " WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 AND C.CATEGORY_UBEREAT = 0 " + this.request_campaign_category : "";
        List categories = new PreparedSentence(this.s, this.requestCategory + requestRemoved + " ORDER BY order_category ", null, CategoryInfo.getSerializerRead()).list();
        if (load_sub_categories) {
            for (CategoryInfo category : categories) {
                List<CategoryInfo> subCategories = this.getSubCategories(category.getID(), check_if_removed);
                for (CategoryInfo subCategory : subCategories) {
                    subCategory.setParent_id_global(category.getId_global());
                    if (!detail_category) continue;
                    subCategory.setTags(this.getTagsByCategory(subCategory.getID()));
                    subCategory.setDaysOn(this.getCategoryDaysOn(subCategory.getID()));
                    subCategory.setShiftsCategory(this.getShiftCategories(subCategory.getID()));
                    List<MultiLanguageCategory> multiLanguageTexts = this.multiLanguageCategoryService.getMultiLanguageTexts(subCategory.getID());
                    subCategory.setMultiLanguageTexts(multiLanguageTexts);
                }
                category.setSub_categories(subCategories);
            }
        }
        if (detail_category) {
            for (CategoryInfo category : categories) {
                category.setTags(this.getTagsByCategory(category.getID()));
                category.setDaysOn(this.getCategoryDaysOn(category.getID()));
                category.setShiftsCategory(this.getShiftCategories(category.getID()));
                List<MultiLanguageCategory> multiLanguageTexts = this.multiLanguageCategoryService.getMultiLanguageTexts(category.getID());
                category.setMultiLanguageTexts(multiLanguageTexts);
            }
        }
        return categories;
    }

    public final List<CategoryInfo> getAllCategories() throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 ORDER BY order_category ", null, CategoryInfo.getSerializerRead()).list();
    }

    public final List<SupplementInfo> getAllIngredientsAndSupplements() throws BasicException {
        return new PreparedSentence(this.s, this.requestSupplement + "WHERE S.REMOVED_BY_ADMIN = 0 AND S.removed = 0 ", null, SupplementInfo.getSerializerRead()).list();
    }

    public List<ProductInfoExt> getAllProductsWithoutConstraints() throws BasicException {
        return new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 ", null, ProductInfoExt.getSerializerRead()).list();
    }

    public List<ProductInfoExt> getAllItems(boolean check_if_removed, boolean filter_price_tariff) throws BasicException {
        String requestRemoved = check_if_removed ? " WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.CATEGORY IN (SELECT C.ID from CATEGORIES C where C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 ) " + this.request_campaign_product : "";
        List products = new PreparedSentence(this.s, this.requestProducts + requestRemoved, null, ProductInfoExt.getSerializerRead()).list();
        for (ProductInfoExt product : products) {
            CategoryInfo category;
            TaxInfo tax_lv;
            TaxInfo tax_emp;
            TaxInfo tax = this.getTaxById(product.getTaxCategoryID());
            if (tax != null) {
                product.setRate_tax(tax.getRate());
            }
            if ((tax_emp = this.getTaxById(product.getTaxemp())) != null) {
                product.setRate_tax_emp(tax_emp.getRate());
            }
            if ((tax_lv = this.getTaxById(product.getTaxlv())) != null) {
                product.setRate_tax_lv(tax_lv.getRate());
            }
            product.setId_global_category((category = this.getCategoryInfo(String.valueOf(product.getCategoryid()))) != null ? category.getId_global() : "");
            product.setIngredients(this.getIngredientsByProducts(product.getID(), true, true));
            product.setSupplements(this.getSupplementsByProduct(product.getID(), false, false));
            product.setCartes(this.getCartesByItem(product.getID()));
            product.setListSizes(this.getProductSizes(product.getID(), filter_price_tariff));
            product.setScreens(this.getScreenByProduct(product.getID()));
            product.setAdditional_sales(this.getAllAdditionalSales(product.getID(), check_if_removed));
            product.setPromotions(this.getPromotionsByPproduct(product.getID(), check_if_removed));
            product.setSub_products(this.getAllSubProducts(product.getID(), check_if_removed));
            product.setDaysOn(this.getProductDaysOn(product.getID()));
            product.setPrices(this.getProductPrices(product.getID(), filter_price_tariff));
            product.setShiftsCProduct(this.getShiftProducts(product.getID()));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            product.setItemIngredients(this.getItemsDetailIngredients(product.getID()));
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return products;
    }

    public final SupplementItemInfo getIngredientByName(String name) throws BasicException {
        return (SupplementItemInfo)new PreparedSentence(this.s, this.requestSuppItem + " JOIN supplement G ON G.id = S.id_supplement WHERE G.is_ingredient = 1 and G.removed = 0 and G.REMOVED_BY_ADMIN = 0  and S.name = ? and S.removed = 0 and S.REMOVED_BY_ADMIN = 0 ", SerializerWriteString.INSTANCE, SupplementItemInfo.getSerializerRead()).find((Object)name);
    }

    public final SupplementInfo getDefaultIngredient() throws BasicException {
        return (SupplementInfo)new PreparedSentence(this.s, this.requestSupplement + "WHERE S.is_ingredient = 1 AND S.removed = 0 and S.REMOVED_BY_ADMIN = 0 AND S.default_category =1 ", null, SupplementInfo.getSerializerRead()).find();
    }

    public void updateProduct_Size(final ProductSizeInfo productSize, boolean synchronization) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS_SIZE SET name_size = ?, label_size = ?, price = ?, price_sp = ?, price_emp = ?, price_lv = ?, price_bar = ?, price_terasse = ?, price_happy_hour = ?, PRICE_UBER = ?, PRICE_DELIVERO = ?, PRICE_PLATFORM = ?, SIZE_ENABLED = ?, REF_WEB = ?, PRICE_DRIVE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, productSize.getName());
                this.setString(2, productSize.getLabel_size());
                this.setDouble(3, productSize.getPrice());
                this.setDouble(4, productSize.getPrice_sp());
                this.setDouble(5, productSize.getPrice_emp());
                this.setDouble(6, productSize.getPrice_lv());
                this.setDouble(7, productSize.getPrice_bar());
                this.setDouble(8, productSize.getPrice_terasse());
                this.setDouble(9, productSize.getPrice_happy_hour());
                this.setDouble(10, productSize.getPrice_uber());
                this.setDouble(11, productSize.getPrice_delivero());
                this.setDouble(12, productSize.getPrice_platform());
                this.setBoolean(13, productSize.isSize_enabled());
                this.setString(14, productSize.getRef_synchro());
                this.setDouble(15, productSize.getPrice_drive());
                this.setInt(16, productSize.getID());
            }
        });
        if (synchronization) {
            this.setIdGlobalItem(productSize.getID(), "PRODUCTS_SIZE", "ID_GLOBAL", productSize.getId_global());
        }
    }

    public void addProduct_Size(ProductSizeInfo productSize) throws SQLException, BasicException {
        int size_order = AppConstants.mapOrderSizes.get((Object)productSize.getName()) != null ? (Integer)AppConstants.mapOrderSizes.get((Object)productSize.getName()) : 0;
        String SQL = "INSERT INTO PRODUCTS_SIZE (name_size, label_size, price, price_sp, price_emp, price_lv, price_bar, price_terasse, price_happy_hour, product, PRICE_UBER, PRICE_DELIVERO, PRICE_PLATFORM, SIZE_ENABLED, PRICE_DRIVE, ORDER_SIZE, TARIFF) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, productSize.getName());
        this.pstmt.setString(2, productSize.getLabel_size());
        this.pstmt.setDouble(3, productSize.getPrice());
        this.pstmt.setDouble(4, productSize.getPrice_sp());
        this.pstmt.setDouble(5, productSize.getPrice_emp());
        this.pstmt.setDouble(6, productSize.getPrice_lv());
        this.pstmt.setDouble(7, productSize.getPrice_bar());
        this.pstmt.setDouble(8, productSize.getPrice_terasse());
        this.pstmt.setDouble(9, productSize.getPrice_happy_hour());
        this.pstmt.setInt(10, productSize.getIdProduct());
        this.pstmt.setDouble(11, productSize.getPrice_uber());
        this.pstmt.setDouble(12, productSize.getPrice_delivero());
        this.pstmt.setDouble(13, productSize.getPrice_platform());
        this.pstmt.setBoolean(14, productSize.isSize_enabled());
        this.pstmt.setDouble(15, productSize.getPrice_drive());
        this.pstmt.setInt(16, size_order);
        this.pstmt.setInt(17, productSize.getTariff());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idProductSize = -1;
        if (rs.next()) {
            idProductSize = rs.getInt(1);
        }
        productSize.setID(idProductSize);
        this.setIdGlobalItem(productSize.getID(), "PRODUCTS_SIZE", "ID_GLOBAL", productSize.getId_global());
    }

    public List<ProductSizeInfo> getProductSizes(final int idProduct, final boolean filter_by_tariff) throws BasicException {
        String requestTariff = filter_by_tariff ? " AND P.TARIFF = ? " : "";
        return new PreparedSentence(this.s, this.requestProductSize + "WHERE  P.product = ? " + requestTariff + " order by P.ORDER_SIZE ", SerializerWriteParams.INSTANCE, ProductSizeInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idProduct);
                if (filter_by_tariff) {
                    this.setInt(2, AppLocal.TARIFF);
                }
            }
        });
    }

    public ProductSizeInfo getProductSizeByName(final int idProduct, final String name) throws BasicException {
        return (ProductSizeInfo)new PreparedSentence(this.s, this.requestProductSize + "WHERE  P.product = ? AND name_size = ? ", SerializerWriteParams.INSTANCE, ProductSizeInfo.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idProduct);
                this.setString(2, name);
            }
        });
    }

    public ProductSizeInfo getProductSizeById(int id) throws BasicException {
        return (ProductSizeInfo)new PreparedSentence(this.s, this.requestProductSize + "WHERE  P.ID = ?", SerializerWriteInteger.INSTANCE, ProductSizeInfo.getSerializerRead()).find((Object)id);
    }

    public final List<SupplementInfo> getAllSupplements(boolean check_if_removed) throws BasicException {
        String requestRemoved = check_if_removed ? "WHERE  S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + this.request_campaign_supplement : "";
        List supplements = new PreparedSentence(this.s, this.requestSupplement + requestRemoved, null, SupplementInfo.getSerializerRead()).list();
        for (SupplementInfo supplement : supplements) {
            supplement.setMultiLanguageTexts(this.multiLanguageSupplementService.getMultiLanguageTexts(supplement.getiD()));
            List<SupplementItemInfo> items = this.getSuppelementByParent(supplement.getiD(), check_if_removed);
            for (SupplementItemInfo item : items) {
                TaxInfo tax;
                item.setScreen(this.getScreenByIngredient(item.getiD()));
                item.setSupplementPrices(this.getSupplementPrices(item.getiD()));
                item.setGroupsSubSupplement(this.getGroupsSubSupplements(item.getiD()));
                for (GroupSubSupplementInfo groupSubSupplement : item.getGroupsSubSupplement()) {
                    groupSubSupplement.setSupplements(this.getSubSupplements(groupSubSupplement.getId(), false, false));
                }
                TaxInfo taxInfo = tax = item.getTaxId() != null && !item.getTaxId().isEmpty() ? this.getTaxById(item.getTaxId()) : null;
                if (tax != null) {
                    item.setRateTaxe(tax.getRate());
                } else {
                    item.setRateTaxe(-1.0);
                }
                item.setMultiLanguageTexts(this.multiLanguageSupplementItemService.getMultiLanguageTexts(item.getiD()));
                item.setAllergenes(this.mAllergeneSupplementService.getAllergenesForSupplement(item.getiD()));
            }
            supplement.getItems().addAll(items);
            supplement.setScreens(this.getScreenByGoption(supplement.getiD()));
        }
        return supplements;
    }

    public List<SupplementItemInfo> getSuppelementByParent(int supplement, boolean check_if_removed) throws BasicException {
        String requestRemoved = check_if_removed ? " AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + this.request_campaign_supplement_item : "";
        return new PreparedSentence(this.s, this.requestSuppItem_Product + "LEFT JOIN PRODUCTS P ON S.ID_PRODUCT = P.ID WHERE S.id_supplement = ? " + requestRemoved + "ORDER BY  S.order_item ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerReadItemProduct()).list((Object)supplement);
    }

    public List<CarteInfo> getAllCartes(boolean check_if_removed) throws BasicException {
        String requestRemoved = check_if_removed ? "WHERE removed = 0 AND REMOVED_BY_ADMIN = 0 " : "";
        List cartes = new PreparedSentence(this.s, this.requestCarte + requestRemoved, null, CarteInfo.getSerializerRead()).list();
        for (CarteInfo carte : cartes) {
            carte.setCarteItems(this.getCarteItems(carte.getId(), check_if_removed));
            carte.setMultiLanguageTexts(this.multiLanguageCarteService.getMultiLanguageTexts(carte.getId()));
        }
        return cartes;
    }

    public final List<PrinterInfo> getPrinterByMode(String type) throws BasicException {
        return new PreparedSentence(this.s, this.requestPrinter + "WHERE P.TYPE = ? ", SerializerWriteString.INSTANCE, PrinterInfo.getSerializerRead()).list((Object)type);
    }

    public int cleanByPeriodId(final String id) throws BasicException {
        int count0 = new StaticSentence(this.s, "DELETE FROM GRAND_TOTAL_PERIODE WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
        int count1 = new StaticSentence(this.s, "DELETE FROM ARCHIV_PERIODE WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, id);
            }
        });
        return count0 + count1;
    }

    public List<Line> getLinesByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestLines + "WHERE  timestampGDH >= ? and  timestampGDH < ?   ", SerializerWriteParams.INSTANCE, Line.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<TotalTax> getTotalTaxByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestTotalTax + "WHERE  timestampGDH >= ? and  timestampGDH < ?   ", SerializerWriteParams.INSTANCE, TotalTax.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<TicketPayementNorm> getTicketPayementsNormByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestTicketPayement + "WHERE  timestampGDH >= ? and  timestampGDH < ?   ", SerializerWriteParams.INSTANCE, TicketPayementNorm.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<GrandTotalPeriode> getGTPByPeriode(String typePeriode, Date myDate) throws BasicException {
        int myDay = myDate.getDate();
        final int myMonth = myDate.getMonth() + 1;
        final int myYear = myDate.getYear() + 1900;
        if (typePeriode.equals("j")) {
            final Date dateEnd = new Date();
            final Date dateStart = new Date(myDate.getTime());
            DateUtils.setDateHours(dateStart, dateEnd);
            return new PreparedSentence(this.s, this.requestGTP + "WHERE  timestampGDH >= ? and  timestampGDH < ?  order by CAST (id AS INTEGER)  ", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setTimestamp(1, dateStart);
                    this.setTimestamp(2, dateEnd);
                }
            });
        }
        if (typePeriode.equals("m")) {
            return new PreparedSentence(this.s, this.requestGTP + "WHERE YEAR(timestampGDH)= ? and MONTH(timestampGDH)= ?  order by CAST (id AS INTEGER)   ", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, myYear);
                    this.setInt(2, myMonth);
                }
            });
        }
        return new PreparedSentence(this.s, this.requestGTP + "WHERE  YEAR(timestampGDH)= ? order by CAST (id AS INTEGER)   ", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, myYear);
            }
        });
    }

    public final List<ScreenSupplementItem> getScreenByIngredient(int supplement) throws BasicException {
        PreparedSentence preparedSentence = new PreparedSentence(this.s, "SELECT distinct SC.ID, SC.ID_SUPPLEMENT, SC.ID_SCREEN, SC.NAME_SCREEN FROM SCREENS_SUPPLEMENT SC JOIN supplement_item SI ON SC.ID_SUPPLEMENT = SI.id WHERE SI.id = ? ", SerializerWriteInteger.INSTANCE, ScreenSupplementItem.getSerializerRead());
        return preparedSentence.list((Object)supplement);
    }

    public final List<ScreenSupplementInfo> getScreenByGoption(int goption) throws BasicException {
        PreparedSentence preparedSentence = new PreparedSentence(this.s, "SELECT SC.ID, SC.ID_GROUP_SUPPLEMENT, SC.ID_SCREEN, SC.NAME_SCREEN FROM SCREENS_GROUP_SUPPLEMENT SC JOIN supplement S ON SC.ID_GROUP_SUPPLEMENT = S.id WHERE S.id = ? ", SerializerWriteInteger.INSTANCE, ScreenSupplementInfo.getSerializerRead());
        return preparedSentence.list((Object)goption);
    }

    public final List<ScreenProduct> getScreenByProduct(int product) throws BasicException {
        return new PreparedSentence(this.s, "SELECT SC.ID, SC.ID_PRODUCT, SC.ID_SCREEN, LS.NAME, LS.NUMBER FROM SCREENS_PRODUCT SC JOIN LOCAL_SCREENS LS ON SC.ID_SCREEN = LS.ID WHERE LS.deleted = 0 and SC.ID_PRODUCT = ? ", SerializerWriteInteger.INSTANCE, ScreenProduct.getSerializerRead()).list((Object)product);
    }

    @Override
    public int addDocument(TicketInfo mTicketInfo) throws SQLException {
        return super.addDocument(mTicketInfo);
    }

    public Line getLineByTicketIdAndLineInfo(final TicketInfo mTicketInfo, final TicketLineInfo mTicketLineInfo) throws BasicException {
        return (Line)new PreparedSentence(this.s, this.requestLines + "WHERE  TICKET = ? and  CODE_PRODUCT = ?   ", SerializerWriteParams.INSTANCE, Line.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, mTicketInfo.getId());
                this.setString(2, String.valueOf(mTicketLineInfo.getProductID()));
            }
        });
    }

    public TicketPayementNorm getPaymentNormByTicket(final TicketInfo mTicketInfo, PaymentInfo mPaymentInfo) throws BasicException {
        String type_regulation = "";
        switch (mPaymentInfo.getName()) {
            case "cash": {
                type_regulation = "ESPECE";
                break;
            }
            case "Ticket Resto": {
                type_regulation = "TICKET RESTAURANT";
                break;
            }
            case "Avoir": {
                type_regulation = "AVOIR";
                break;
            }
            case "cheque": {
                type_regulation = "CHEQUE";
                break;
            }
            case "CB": {
                type_regulation = "CARTE BANCAIRE";
                break;
            }
            case "cashdro": {
                type_regulation = "ESPECE";
                break;
            }
            default: {
                type_regulation = "ESPECE";
            }
        }
        final String mValueType = type_regulation;
        return (TicketPayementNorm)new PreparedSentence(this.s, this.requestTicketPayement + "WHERE  TICKET = ? AND  TYPE_REGULATION = ? ", SerializerWriteParams.INSTANCE, TicketPayementNorm.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, mTicketInfo.getId());
                this.setString(2, mValueType);
            }
        });
    }

    public List<GrandTotalPeriode> loadGrandTotalPeriodByDate(int month, int year, final String type) throws BasicException {
        String request;
        final String type_period = type.equals("Journalier") ? "j" : (type.equals("Mensuel") ? "m" : "a");
        String string = request = type.equals("Journalier") || type.equals("Mensuel") ? " AND ID like ? " : "";
        Object date_period = type.equals("Journalier") ? String.valueOf(year) + DateUtils.formatMonth(String.valueOf(month)) + "%" : (type.equals("Mensuel") ? String.valueOf(year) + "%" : "");
        ArrayList<GrandTotalPeriode> listTotaux = new PreparedSentence(this.s, this.requestGTP + " WHERE type_PERIODE = ? " + request + "order by ID DESC", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams((String)date_period){
            final /* synthetic */ String val$date_period;
            {
                this.val$date_period = string3;
            }

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type_period);
                if (type.equalsIgnoreCase("Journalier") || type.equalsIgnoreCase("Mensuel")) {
                    this.setString(2, this.val$date_period);
                }
            }
        });
        if (listTotaux == null) {
            listTotaux = new ArrayList<GrandTotalPeriode>();
        }
        for (GrandTotalPeriode grandTotalPeriode : listTotaux) {
            grandTotalPeriode.setGtpTaxes(this.getGTPTaxes(grandTotalPeriode.getId()));
        }
        return listTotaux;
    }

    public void deployPrinter(final CategoryInfo category) throws BasicException {
        new PreparedSentence(this.s, "UPDATE CATEGORIES SET PRINTER = ?, PRINTER_LABEL = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category.getPrinter_id());
                this.setInt(2, category.getPrinter_label_id());
                this.setInt(3, category.getID());
            }
        });
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET printer = ?, prepared = ?, printerLabel = ?, label = ?  WHERE CATEGORY = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category.getPrinter_id() == 0 ? null : Integer.valueOf(category.getPrinter_id()));
                this.setBoolean(2, category.getPrinter_id() != 0);
                this.setInt(3, category.getPrinter_label_id() == 0 ? null : Integer.valueOf(category.getPrinter_label_id()));
                this.setBoolean(4, category.getPrinter_label_id() != 0);
                this.setInt(5, category.getID());
            }
        });
    }

    public void deleteProduct_Size(final int id_product_size) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PRODUCTS_SIZE  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_product_size);
            }
        });
    }

    public final List<SupplementPriceInfo> getSupplementPrices(int supplemnt) throws BasicException {
        return new PreparedSentence(this.s, this.requestSupplementPrice + "WHERE S.SUPPLEMENT_ID = ? ", SerializerWriteInteger.INSTANCE, SupplementPriceInfo.getSerializerRead()).list((Object)supplemnt);
    }

    public void addSupplementPrices(SupplementPriceInfo mSupplementPriceInfo) throws BasicException, SQLException {
        String SQL = "INSERT INTO SUPPLEMENT_ITEM_PRICES(TYPE_ORDER, PRICE, PRICE_JUNIOR, PRICE_SENIOR, PRICE_MEGA, PRICE_SIZE1, PRICE_SIZE2, PRICE_SIZE3, SUPPLEMENT_ID, REF_SYNCHRO, PRICE_SIZE4, PRICE_SIZE5, PRICE_SIZE6, PRICE_SIZE7) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, mSupplementPriceInfo.getType_order());
        this.pstmt.setDouble(2, mSupplementPriceInfo.getPrice());
        this.pstmt.setDouble(3, mSupplementPriceInfo.getPrice_junior());
        this.pstmt.setDouble(4, mSupplementPriceInfo.getPrice_senior());
        this.pstmt.setDouble(5, mSupplementPriceInfo.getPrice_mega());
        this.pstmt.setDouble(6, mSupplementPriceInfo.getPrice_size1());
        this.pstmt.setDouble(7, mSupplementPriceInfo.getPrice_size2());
        this.pstmt.setDouble(8, mSupplementPriceInfo.getPrice_size3());
        this.pstmt.setInt(9, mSupplementPriceInfo.getId_supplement());
        this.pstmt.setString(10, mSupplementPriceInfo.getRef_synchro());
        this.pstmt.setDouble(11, mSupplementPriceInfo.getPrice_size4());
        this.pstmt.setDouble(12, mSupplementPriceInfo.getPrice_size5());
        this.pstmt.setDouble(13, mSupplementPriceInfo.getPrice_size6());
        this.pstmt.setDouble(14, mSupplementPriceInfo.getPrice_size7());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idSupplementPrice = -1;
        if (rs.next()) {
            idSupplementPrice = rs.getInt(1);
        }
        mSupplementPriceInfo.setId(idSupplementPrice);
        this.setIdGlobalItem(mSupplementPriceInfo.getId(), "SUPPLEMENT_ITEM_PRICES", "ID_GLOBAL", mSupplementPriceInfo.getId_global());
    }

    public void updateSupplementPrices(final SupplementPriceInfo mSupplementPriceInfo) throws BasicException {
        new PreparedSentence(this.s, "UPDATE SUPPLEMENT_ITEM_PRICES SET TYPE_ORDER = ?, PRICE = ?, PRICE_JUNIOR = ?, PRICE_SENIOR = ?, PRICE_MEGA = ?, PRICE_SIZE1 = ?, PRICE_SIZE2 = ?, PRICE_SIZE3 = ?, PRICE_SIZE4 = ?, PRICE_SIZE5 = ?, PRICE_SIZE6 = ?, PRICE_SIZE7 = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, mSupplementPriceInfo.getType_order());
                this.setDouble(2, mSupplementPriceInfo.getPrice());
                this.setDouble(3, mSupplementPriceInfo.getPrice_junior());
                this.setDouble(4, mSupplementPriceInfo.getPrice_senior());
                this.setDouble(5, mSupplementPriceInfo.getPrice_mega());
                this.setDouble(6, mSupplementPriceInfo.getPrice_size1());
                this.setDouble(7, mSupplementPriceInfo.getPrice_size2());
                this.setDouble(8, mSupplementPriceInfo.getPrice_size3());
                this.setDouble(9, mSupplementPriceInfo.getPrice_size4());
                this.setDouble(10, mSupplementPriceInfo.getPrice_size5());
                this.setDouble(11, mSupplementPriceInfo.getPrice_size6());
                this.setDouble(12, mSupplementPriceInfo.getPrice_size7());
                this.setInt(13, mSupplementPriceInfo.getId());
            }
        });
    }

    @Override
    public List<SupplementItemInfo> getSuppelementsItemOrderAlpha(int id_supplement) throws BasicException {
        List<SupplementItemInfo> supplements = super.getSuppelementsItemOrderAlpha(id_supplement);
        for (SupplementItemInfo supplement : supplements) {
            supplement.setSupplementPrices(this.getSupplementPrices(supplement.getiD()));
            supplement.setGroupsSubSupplement(this.getGroupsSubSupplements(supplement.getiD()));
            for (GroupSubSupplementInfo groupSubSupplement : supplement.getGroupsSubSupplement()) {
                groupSubSupplement.setSupplements(this.getSubSupplements(groupSubSupplement.getId(), false, true));
            }
        }
        return supplements;
    }

    @Override
    public List<SupplementItemInfo> getSuppelementsItem(int id_supplement, boolean catalog, boolean only_available) throws BasicException {
        List<SupplementItemInfo> supplements = super.getSuppelementsItem(id_supplement, catalog, only_available);
        for (SupplementItemInfo supplement : supplements) {
            supplement.setSupplementPrices(this.getSupplementPrices(supplement.getiD()));
            supplement.setGroupsSubSupplement(this.getGroupsSubSupplements(supplement.getiD()));
            for (GroupSubSupplementInfo groupSubSupplement : supplement.getGroupsSubSupplement()) {
                groupSubSupplement.setSupplements(this.getSubSupplements(groupSubSupplement.getId(), false, catalog));
            }
        }
        return supplements;
    }

    @Override
    public SupplementItemInfo addOption(SupplementItemInfo option, boolean synchronisation) throws BasicException, SQLException {
        super.addOption(option, synchronisation);
        for (SupplementPriceInfo supplementPrice : option.getSupplementPrices()) {
            supplementPrice.setId_supplement(option.getiD());
            this.addSupplementPrices(supplementPrice);
        }
        for (GroupSubSupplementInfo groupSubSupplement : option.getGroupsSubSupplement()) {
            this.addSupplementGroup(groupSubSupplement, option);
        }
        return option;
    }

    @Override
    public void updateOption(SupplementItemInfo option, boolean synchronization) throws BasicException, SQLException {
        super.updateOption(option, synchronization);
        if (!synchronization) {
            System.out.println("++++++++++++ option.getSupplementPrices() 1 : " + option.getSupplementPrices());
            for (SupplementPriceInfo supplementPrice : option.getSupplementPrices()) {
                if (supplementPrice.getId() == -1) {
                    supplementPrice.setId_supplement(option.getiD());
                    this.addSupplementPrices(supplementPrice);
                    continue;
                }
                this.updateSupplementPrices(supplementPrice);
            }
            this.persistSupplementGroup(option);
        }
    }

    @Override
    public SupplementItemInfo getSuppelementById(int id) throws BasicException {
        SupplementItemInfo option = super.getSuppelementById(id);
        if (option != null) {
            option.setSupplementPrices(this.getSupplementPrices(option.getiD()));
            option.setMultiLanguageTexts(this.multiLanguageSupplementItemService.getMultiLanguageTexts(option.getiD()));
            option.setAllergenes(this.mAllergeneSupplementService.getAllergenesForSupplement(option.getiD()));
        }
        return option;
    }

    @Override
    public List<SupplementItemInfo> getSuppelementsItemBorne(int supplement, boolean order_name) throws BasicException {
        List<SupplementItemInfo> options = super.getSuppelementsItemBorne(supplement, order_name);
        for (SupplementItemInfo option : options) {
            option.setSupplementPrices(this.getSupplementPrices(option.getiD()));
            option.setMultiLanguageTexts(this.multiLanguageSupplementItemService.getMultiLanguageTexts(option.getiD()));
            option.setAllergenes(this.mAllergeneSupplementService.getAllergenesForSupplement(option.getiD()));
            List<GroupSubSupplementInfo> groupsSubSupplementDB = this.getGroupsSubSupplements(option.getiD());
            ArrayList<GroupSubSupplementInfo> groupsSubSupplement = new ArrayList<GroupSubSupplementInfo>();
            for (GroupSubSupplementInfo groupSubSupplement : groupsSubSupplementDB) {
                groupSubSupplement.setMultiLanguageTexts(this.multiLanguageGSSService.getMultiLanguageTexts(groupSubSupplement.getId()));
                List<SupplementItemInfo> subSupplements = this.getSubSupplements(groupSubSupplement.getId(), true, true);
                if (subSupplements == null || subSupplements.isEmpty()) continue;
                groupSubSupplement.setSupplements(subSupplements);
                groupsSubSupplement.add(groupSubSupplement);
            }
            option.setGroupsSubSupplement(groupsSubSupplement);
        }
        return options;
    }

    public List<SupplementInfo> getSupplementsInfo() throws BasicException {
        return new PreparedSentence(this.s, this.requestSupplement, null, SupplementInfo.getSerializerRead()).list();
    }

    private void updateItemSupplement(final SupplementInfo option) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ITEM_SUPPLEMENTS SET  has_limit_options = ?, min_options = ?, max_options = ?  WHERE id_supplement = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, option.getHas_options());
                this.setInt(2, option.getMin_options());
                this.setInt(3, option.getMax_options());
                this.setInt(4, option.getiD());
            }
        });
    }

    private void updateItemSupplement(final ProductInfoExt product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ITEM_SUPPLEMENTS SET  option_free = ? WHERE id_item = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, product.getOption_free());
                this.setInt(2, product.getID());
            }
        });
    }

    public void getTheOldInfoOptions() {
        try {
            List<SupplementInfo> supplements = this.getSupplementsInfo();
            for (SupplementInfo supplement : supplements) {
                this.updateItemSupplement(supplement);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public List<ProductInfoExt> getproductsInfo() throws BasicException {
        List products = new PreparedSentence(this.s, this.requestProducts + " where P.REMOVED_BY_ADMIN = 0 ", null, ProductInfoExt.getSerializerRead()).list();
        for (ProductInfoExt product : products) {
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            product.setMultiLanguageTexts(multiLanguageTexts);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return products;
    }

    public void getTheOldInfoFreeOption() {
        try {
            List<ProductInfoExt> products = this.getproductsInfo();
            for (ProductInfoExt product : products) {
                this.updateItemSupplement(product);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void deployOptions(CategoryInfo category, SupplementProduct option) throws BasicException {
        List<ProductInfoExt> products = super.getProducts(category.getID());
        for (ProductInfoExt product : products) {
            List<SupplementProduct> itemsOptions = this.getSupplementsByProduct(product.getID(), false, false);
            int found = -1;
            for (SupplementProduct itemOption : itemsOptions) {
                if (option.getiD() != itemOption.getiD()) continue;
                found = 1;
            }
            if (found == -1) {
                super.addItemSupplement(option, product.getID());
                continue;
            }
            super.updateItemSupplement(option, product.getID());
        }
    }

    public void persistSubSupplement(GroupSubSupplementInfo groupSubSupplement) throws BasicException {
        int found;
        List<SupplementItemInfo> oldMultipleSupplements = this.getOldSubSupplements(groupSubSupplement.getId());
        for (SupplementItemInfo oldSupplement : oldMultipleSupplements) {
            found = -1;
            for (SupplementItemInfo newSupplement : groupSubSupplement.getSupplements()) {
                if (oldSupplement.getiD() != newSupplement.getiD()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteSubSupplement(groupSubSupplement, oldSupplement);
        }
        for (SupplementItemInfo newSupplement : groupSubSupplement.getSupplements()) {
            found = -1;
            for (SupplementItemInfo oldSupplement : oldMultipleSupplements) {
                if (oldSupplement.getiD() != newSupplement.getiD()) continue;
                found = 1;
            }
            if (found != -1) continue;
            System.out.println("++++++++++ newSupplement id : " + newSupplement.getiD());
            this.addSubSupplement(groupSubSupplement, newSupplement);
        }
    }

    private void addSubSupplement(final GroupSubSupplementInfo groupSubSupplement, final SupplementItemInfo sub_supplement) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SUB_SUPPLEMENTS(ID_SUPPLEMENT, ID_GROUPESUPPLEMENT) VALUES(? ,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, sub_supplement.getiD());
                this.setInt(2, groupSubSupplement.getId());
            }
        });
    }

    private void deleteSubSupplement(final GroupSubSupplementInfo groupSubSupplement, final SupplementItemInfo sub_supplement) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM  SUB_SUPPLEMENTS WHERE  ID_SUPPLEMENT = ? AND ID_GROUPESUPPLEMENT = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, sub_supplement.getiD());
                this.setInt(2, groupSubSupplement.getId());
            }
        });
    }

    public final List<CategoryInfo> getSubCategories(int parentCategory, boolean check_if_removed) throws BasicException {
        String requestRemoved = check_if_removed ? "AND C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 " + this.request_campaign_category : "";
        return new PreparedSentence(this.s, this.requestCategory + "WHERE C.PARENTID = ? " + requestRemoved + "ORDER BY order_category ", SerializerWriteInteger.INSTANCE, CategoryInfo.getSerializerRead()).list((Object)parentCategory);
    }

    public List<GroupSubSupplementInfo> getGroupsSubSupplements(int id_supplement) throws BasicException {
        return new PreparedSentence(this.s, this.requestGroupeSubSupplement + " JOIN SUPPLEMENTS_GROUPE S ON G.ID = S.ID_GROUPESUPPLEMENT WHERE S.ID_SUPPLEMENT = ? AND G.REMOVED = 0  ", SerializerWriteInteger.INSTANCE, GroupSubSupplementInfo.getSerializerRead()).list((Object)id_supplement);
    }

    public List<SupplementItemInfo> getSubSupplements(int id_group, boolean borne, boolean catalog) throws BasicException {
        String requestBorne = borne ? "AND S.HIDDEN_BORNE = 0 " : "";
        String requestCatalog = catalog ? "AND S.SUPPLEMENT_ITEM_UBEREAT = 0 AND S.SOLD_OUT = 0 " : "";
        List subSupplements = new PreparedSentence(this.s, this.requestFullSuppItem + " JOIN supplement G ON G.id = S.id_supplement JOIN SUB_SUPPLEMENTS SS ON S.id = SS.ID_SUPPLEMENT  WHERE SS.ID_GROUPESUPPLEMENT = ? AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + requestBorne + requestCatalog + "ORDER BY  S.order_item ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getFullOptions()).list((Object)id_group);
        for (SupplementItemInfo subSupplement : subSupplements) {
            subSupplement.setSupplementPrices(this.getSupplementPrices(subSupplement.getiD()));
            subSupplement.setMultiLanguageTexts(this.multiLanguageSupplementItemService.getMultiLanguageTexts(subSupplement.getiD()));
            subSupplement.setAllergenes(this.mAllergeneSupplementService.getAllergenesForSupplement(subSupplement.getiD()));
        }
        return subSupplements;
    }

    public void addGroupSubSupplement(GroupSubSupplementInfo groupSubSupplement) throws SQLException, BasicException {
        this.addGroupSubSupplement(groupSubSupplement, true);
    }

    public void updateGroupSubSupplement(GroupSubSupplementInfo groupSubSupplement) throws BasicException {
        this.updateGroupSubSupplement(groupSubSupplement, true);
    }

    public void deleteGroupSubSupplement(final GroupSubSupplementInfo groupSubSupplement) throws BasicException {
        new PreparedSentence(this.s, "UPDATE GROUPE_SUB_SUPPLEMENTS SET REMOVED = 1 WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, groupSubSupplement.getId());
            }
        });
    }

    public void persistSupplementGroup(SupplementItemInfo supplement) throws BasicException {
        int found;
        List<GroupSubSupplementInfo> oldGroupsSubSupplement = this.getGroupsSubSupplements(supplement.getiD());
        for (GroupSubSupplementInfo oldGroupSubSupplement : oldGroupsSubSupplement) {
            found = -1;
            for (GroupSubSupplementInfo newGroupSubSupplement : supplement.getGroupsSubSupplement()) {
                if (oldGroupSubSupplement.getId() != newGroupSubSupplement.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteSupplementGroup(oldGroupSubSupplement, supplement);
        }
        for (GroupSubSupplementInfo newGroupSubSupplement : supplement.getGroupsSubSupplement()) {
            found = -1;
            for (GroupSubSupplementInfo oldGroupSubSupplement : oldGroupsSubSupplement) {
                if (oldGroupSubSupplement.getId() != newGroupSubSupplement.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.addSupplementGroup(newGroupSubSupplement, supplement);
        }
    }

    public void addSupplementGroup(final GroupSubSupplementInfo groupSubSupplement, final SupplementItemInfo supplement) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SUPPLEMENTS_GROUPE(ID_SUPPLEMENT, ID_GROUPESUPPLEMENT) VALUES(? ,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, supplement.getiD());
                this.setInt(2, groupSubSupplement.getId());
            }
        });
    }

    private void deleteSupplementGroup(final GroupSubSupplementInfo groupSubSupplement, final SupplementItemInfo supplement) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM  SUPPLEMENTS_GROUPE WHERE  ID_SUPPLEMENT = ? AND ID_GROUPESUPPLEMENT = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, supplement.getiD());
                this.setInt(2, groupSubSupplement.getId());
            }
        });
    }

    public List<GroupSubSupplementInfo> getGroupsSubSupplements() throws BasicException {
        List groupsSubSupplement = new PreparedSentence(this.s, this.requestGroupeSubSupplement + " WHERE G.REMOVED = 0 ", null, GroupSubSupplementInfo.getSerializerRead()).list();
        for (GroupSubSupplementInfo groupSubSupplementInfo : groupsSubSupplement) {
            groupSubSupplementInfo.setSupplements(this.getSubSupplements(groupSubSupplementInfo.getId(), false, false));
        }
        return groupsSubSupplement;
    }

    public List<GroupSubSupplementInfo> getGroupsSubSupplementsExcluded(int id_supplement) throws BasicException {
        return new PreparedSentence(this.s, this.requestGroupeSubSupplement + " WHERE G.ID not in (select S.ID_GROUPESUPPLEMENT FROM  SUPPLEMENTS_GROUPE S  WHERE S.ID_SUPPLEMENT = ? ) AND G.REMOVED = 0 ", SerializerWriteInteger.INSTANCE, GroupSubSupplementInfo.getSerializerRead()).list((Object)id_supplement);
    }

    public TableInfo getTableByName(int num_table) throws BasicException {
        return (TableInfo)new PreparedSentence(this.s, "SELECT ID, NUMBER, TYPE, PERSONS, POSITIONX, POSITIONY, available, salle FROM TABLES WHERE NUMBER = ? ", SerializerWriteInteger.INSTANCE, TableInfo.getSerializerRead()).find((Object)num_table);
    }

    public final List<SupplementProduct> getSupplementsByProduct(int productID, boolean borne, boolean ubereat, boolean catalog) throws BasicException {
        String request_borne = "";
        if (borne) {
            request_borne = " and S.HIDDEN_BORNE = 0 ";
        }
        String requestUberEat = ubereat ? " and S.HIDDEN_UBEREAT = 0 " : "";
        String request = catalog ? " and S.SUPPLEMENT_UBEREAT = 0 " : "";
        List supplements = new PreparedSentence(this.s, this.requestSuppProduct + "WHERE S.is_ingredient = 0 AND S.REMOVED_BY_ADMIN = 0 AND S.removed =0 AND I.id_item = ? " + request_borne + requestUberEat + request + this.request_campaign_supplement + "ORDER BY S.order_supplement", SerializerWriteInteger.INSTANCE, SupplementProduct.getSerializerRead()).list((Object)productID);
        for (SupplementProduct supplement : supplements) {
            if (supplement == null) continue;
            supplement.setMultiLanguageTexts(this.multiLanguageSupplementService.getMultiLanguageTexts(supplement.getiD()));
        }
        return supplements;
    }

    public final SupplementProduct getSupplementByID(int idSupplement) throws BasicException {
        SupplementProduct supplement = (SupplementProduct)new PreparedSentence(this.s, this.requestSuppProduct + "WHERE S.id = ? ", SerializerWriteInteger.INSTANCE, SupplementProduct.getSerializerRead()).find((Object)idSupplement);
        if (supplement != null) {
            supplement.setMultiLanguageTexts(this.multiLanguageSupplementService.getMultiLanguageTexts(supplement.getiD()));
        }
        return supplement;
    }

    public final List<SupplementProduct> getSupplementsByProduct(int productID, boolean uberEat, boolean catalog) throws BasicException {
        return this.getSupplementsByProduct(productID, false, uberEat, catalog);
    }

    public List<GroupSubSupplementInfo> getAllGroupsSubSupplements(boolean check_if_removed) throws BasicException {
        String requestRemoved = check_if_removed ? " WHERE G.REMOVED = 0 " : "";
        List groupsSubSupplement = new PreparedSentence(this.s, this.requestGroupeSubSupplement + requestRemoved, null, GroupSubSupplementInfo.getSerializerRead()).list();
        for (GroupSubSupplementInfo groupSubSupplementInfo : groupsSubSupplement) {
            groupSubSupplementInfo.setSupplements(this.getSubSupplements(groupSubSupplementInfo.getId(), false, false));
            groupSubSupplementInfo.setMultiLanguageTexts(this.multiLanguageGSSService.getMultiLanguageTexts(groupSubSupplementInfo.getId()));
        }
        return groupsSubSupplement;
    }

    public void addGroupSubSupplement(GroupSubSupplementInfo groupSubSupplement, boolean add_supplement) throws SQLException, BasicException {
        String SQL = "INSERT INTO GROUPE_SUB_SUPPLEMENTS (NAME_GROUP, TITLE_GROUP, REMOVED, REF_SYNCHRO, HAS_LIMIT_OPTIONS, MIN_OPTIONS, MAX_OPTIONS, OPTION_FREE, NUMBER_CLICK, ID_GLOBAL) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, groupSubSupplement.getName_group());
        this.pstmt.setString(2, groupSubSupplement.getTitle_group());
        this.pstmt.setBoolean(3, groupSubSupplement.isRemoved());
        this.pstmt.setString(4, groupSubSupplement.getRef_synchro());
        this.pstmt.setBoolean(5, groupSubSupplement.isHas_limit_options());
        this.pstmt.setInt(6, groupSubSupplement.getMin_options());
        this.pstmt.setInt(7, groupSubSupplement.getMax_options());
        this.pstmt.setInt(8, groupSubSupplement.getOption_free());
        this.pstmt.setInt(9, groupSubSupplement.getNumber_click());
        this.pstmt.setString(10, groupSubSupplement.getId_global());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idResult = -1;
        if (rs.next()) {
            int last_inserted_id;
            idResult = last_inserted_id = rs.getInt(1);
        }
        groupSubSupplement.setId(idResult);
        if (add_supplement) {
            for (SupplementItemInfo supplement : groupSubSupplement.getSupplements()) {
                this.addSubSupplement(groupSubSupplement, supplement);
            }
        }
        this.setIdGlobalItem(groupSubSupplement.getId(), "GROUPE_SUB_SUPPLEMENTS", "ID_GLOBAL", groupSubSupplement.getId_global());
    }

    public void updateGroupSubSupplement(final GroupSubSupplementInfo groupSubSupplement, boolean persist_supplement) throws BasicException {
        new PreparedSentence(this.s, "UPDATE GROUPE_SUB_SUPPLEMENTS SET NAME_GROUP = ?, TITLE_GROUP = ?, REMOVED = ?, HAS_LIMIT_OPTIONS = ?, MIN_OPTIONS = ?, MAX_OPTIONS = ?, OPTION_FREE = ?, NUMBER_CLICK = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, groupSubSupplement.getName_group());
                this.setString(2, groupSubSupplement.getTitle_group());
                this.setBoolean(3, groupSubSupplement.isRemoved());
                this.setBoolean(4, groupSubSupplement.isHas_limit_options());
                this.setInt(5, groupSubSupplement.getMin_options());
                this.setInt(6, groupSubSupplement.getMax_options());
                this.setInt(7, groupSubSupplement.getOption_free());
                this.setInt(8, groupSubSupplement.getNumber_click());
                this.setInt(9, groupSubSupplement.getId());
            }
        });
        if (persist_supplement) {
            this.persistSubSupplement(groupSubSupplement);
        } else {
            this.setIdGlobalItem(groupSubSupplement.getId(), "GROUPE_SUB_SUPPLEMENTS", "ID_GLOBAL", groupSubSupplement.getId_global());
        }
    }

    public void updateStatusProduct(int product_id, final boolean sold_out, final boolean hidden_borne, final boolean sold_out_temporary, String id_global) throws BasicException {
        String request_ref_synchro = id_global != null && !id_global.isEmpty() ? "PRODUCT_PLU = ?" : "REF_WEB = ?";
        final String ref_synchro = id_global != null && !id_global.isEmpty() ? id_global : String.valueOf(product_id);
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ?,  HIDDEN_BORNE = ?, SOLD_OUT_TEMPORARY = ? WHERE " + request_ref_synchro, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, hidden_borne);
                this.setBoolean(3, sold_out_temporary);
                this.setString(4, ref_synchro);
            }
        });
    }

    public void persistSizesProduct(ProductInfoExt product, boolean synchronization) throws BasicException, SQLException {
        List<ProductSizeInfo> oldSizes = this.getProductSizes(product.getID(), false);
        for (ProductSizeInfo oldSize : oldSizes) {
            int found = -1;
            for (ProductSizeInfo size : product.getListSizes()) {
                if (size.getID() != oldSize.getID()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteProduct_Size(oldSize.getID());
        }
        for (ProductSizeInfo productSize : product.getListSizes()) {
            if (productSize.getID() != -1) {
                this.updateProduct_Size(productSize, synchronization);
                continue;
            }
            if (!productSize.isSize_enabled()) continue;
            productSize.setIdProduct(product.getID());
            this.addProduct_Size(productSize);
        }
    }

    public void updatePromoBasket(final ProductInfoExt product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  PROMO_BASKET = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, product.isPromo_basket());
                this.setInt(2, product.getID());
            }
        });
    }

    public final List<SupplementProduct> getAllSupplementsByProduct(int productID) throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppProduct + "WHERE S. is_ingredient= 0 AND I.id_item = ? ORDER BY S.order_supplement", SerializerWriteInteger.INSTANCE, SupplementProduct.getSerializerRead()).list((Object)productID);
    }

    public List<CarteOrderInfo> getAllCartesByItem(int idItem) throws BasicException {
        return new PreparedSentence(this.s, this.requestOrderCarte + "WHERE C.id = M.id_carte AND M.id_item = ? ORDER BY  M.carteOrder ", SerializerWriteInteger.INSTANCE, CarteOrderInfo.getSerializerRead()).list((Object)idItem);
    }

    public List<ProductInfoExt> getProductCatalogBorne(final int category, String type) throws BasicException {
        String request = "";
        switch (type) {
            case "Sur Place": {
                request = "P.sp= 1";
                break;
            }
            case "A Emporter": {
                request = "P.emp= 1";
            }
        }
        final int dayOfWeek = DateUtils.getDayOfWeek();
        String request_opening_mode = AppLocal.OPENING_MODE ? " AND P.ENABLE_IN_OPENING = 1 " : "";
        List products = new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0  AND P.HIDDEN_BORNE = 0 AND P.CATEGORY = ? AND P.PRODUCT_UBEREAT = 0  AND (P.HAS_TIMETABLE = 0 OR P.ID IN (SELECT PD.ID_PRODUCT from PRODUCT_DAYS_ON PD where PD.DAY_OF_WEEK = ?)) AND " + request + request_opening_mode + this.request_campaign_product + " ORDER BY  P.order_item ", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category);
                this.setInt(2, dayOfWeek);
            }
        });
        for (ProductInfoExt product : products) {
            product.setListSizes(this.getProductSizes(product.getID(), true));
            product.setAdditional_sales(this.getAdditionalSales(product.getID(), true));
            product.setSub_products(this.getSubProducts(product.getID(), true));
            for (ProductInfoExt sub_product : product.getSub_products()) {
                List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(sub_product.getID());
                sub_product.setMultiLanguageTexts(multiLanguageTexts);
            }
            System.out.println("++++++++++ product.getAdditional_sales() : " + product.getAdditional_sales());
            for (ProductInfoExt product_additional : product.getAdditional_sales()) {
                product_additional.setListSizes(this.getProductSizes(product_additional.getID(), true));
                product_additional.setPrices(this.getProductPrices(product_additional.getID(), true));
                if (AppLocal.SHOW_TAGS_IN_BORNE) {
                    TagInfo tag;
                    List<TagInfo> tags = this.getTagsByCategory(product_additional.getCategoryid());
                    if (tags == null || tags.isEmpty()) {
                        CategoryInfo categoryAdditional = this.getCategoryInfo(String.valueOf(product_additional.getCategoryid()));
                        tags = this.getTagsByCategory(categoryAdditional.getParent_id());
                    }
                    if (tags != null && !tags.isEmpty() && (tag = tags.get(0)) != null) {
                        product_additional.setmTagInfo(tag);
                        System.out.println("++++++ product_additional getmTagInfo : " + product_additional.getmTagInfo());
                    }
                }
                List<ImageProduct> images = this.imageProductService.getImages(product_additional.getID());
                product_additional.setImages(images);
                List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product_additional.getID());
                product_additional.setMultiLanguageTexts(multiLanguageTexts);
            }
            product.setPrices(this.getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return products;
    }

    public ProductInfoExt getProductInfo(String ref_synchro, boolean without_filter) throws BasicException {
        String request_filter = without_filter ? "" : "P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND ";
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE " + request_filter + " P.REF_WEB = ? ", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)ref_synchro);
        if (product != null) {
            product.setSub_products(this.getSubProducts(product.getID(), false));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return product;
    }

    public SupplementItemInfo getSuppelementByRefSynchro(String ref_synchro) throws BasicException {
        return (SupplementItemInfo)new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.REF_WEB = ? ", SerializerWriteString.INSTANCE, SupplementItemInfo.getSerializerRead()).find((Object)ref_synchro);
    }

    public void updateStatusSoldOutProduct(final int product_id, final boolean sold_out) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ? WHERE REF_WEB = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setString(2, String.valueOf(product_id));
            }
        });
    }

    public void updateStatusSoldOutProductById(final int product_id, final boolean sold_out) throws BasicException {
        System.out.println("+++++++++++ change sttaus sold out");
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setInt(2, product_id);
            }
        });
    }

    public void changeStorableProducts() throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ? WHERE DAILY_STOCK <> 0", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, false);
            }
        });
    }

    public List<ProductInfoExt> getProductDailyStock() throws BasicException {
        return new PreparedSentence(this.s, this.requestProducts + "WHERE P.DAILY_STOCK <> 0", null, ProductInfoExt.getSerializerRead()).list();
    }

    @Override
    public List<SupplementInfo> getSupplements() throws BasicException {
        List<SupplementInfo> groupsOptions = super.getSupplements();
        for (SupplementInfo groupOptions : groupsOptions) {
            groupOptions.setItems(super.getSuppelementsItem(groupOptions.getiD(), false, false));
        }
        return groupsOptions;
    }

    public final List<CategoryInfo> getUberEatCategories() throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory + "WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 AND (C.PARENTID is null or  C.PARENTID = -1) AND C.HIDDEN_UBEREAT = 0 " + this.request_campaign_category + "ORDER BY order_category ", null, CategoryInfo.getSerializerRead()).list();
    }

    public List<SupplementInfo> getUberEatSupplements() throws BasicException {
        List<SupplementInfo> groupsOptions = this.getSupplements(true);
        for (SupplementInfo groupOptions : groupsOptions) {
            List<SupplementItemInfo> options = this.getSuppelementsItemUberEat(groupOptions.getiD());
            for (SupplementItemInfo option : options) {
                option.setSupplementPrices(this.getSupplementPrices(option.getiD()));
                option.setAllergenes(this.mAllergeneSupplementService.getAllergenesForSupplement(option.getiD()));
            }
            groupOptions.setItems(options);
        }
        return groupsOptions;
    }

    public List<SupplementInfo> getSupplements(Boolean uberEat) throws BasicException {
        String request = uberEat != false ? "AND S.HIDDEN_UBEREAT = 0 " : "";
        return new PreparedSentence(this.s, this.requestSupplement + "WHERE S.is_ingredient = 0 AND S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + request + this.request_campaign_supplement + "ORDER BY S.order_supplement", null, SupplementInfo.getSerializerRead()).list();
    }

    public List<SupplementItemInfo> getSuppelementsItemUberEat(int supplement) throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.id_supplement = ? AND S.HIDDEN_UBEREAT = 0 and S.SOLD_OUT = 0 and S.removed =0 AND S.REMOVED_BY_ADMIN = 0 " + this.request_campaign_supplement_item + "ORDER BY  S.order_item ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getSerializerRead()).list((Object)supplement);
    }

    public void addPromotion(PromotionInfo mPromotionInfo) throws SQLException, BasicException {
        String SQL = "INSERT INTO PROMOTIONS(NAME_PROMOTION, TYPE_ORDER, SIZE_PRODUCT, QUANTITY, DISCOUNT, REMOVED, REMOVED_BY_ADMIN, REF_SYNCHRO, LABEL_SIZE_PRODUCT, LABEL_DISCOUNT, DESCRIPTION, TEXT_PROMOTION) VALUES(?, ?, ?, ?, ? ,?, ?, ?, ? ,?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, mPromotionInfo.getName_promotion());
        this.pstmt.setString(2, mPromotionInfo.getType_order());
        this.pstmt.setString(3, mPromotionInfo.getSize_product());
        this.pstmt.setDouble(4, mPromotionInfo.getQuantity());
        this.pstmt.setDouble(5, mPromotionInfo.getDiscount());
        this.pstmt.setBoolean(6, mPromotionInfo.isRemoved());
        this.pstmt.setBoolean(7, mPromotionInfo.isRemoved_by_admin());
        this.pstmt.setString(8, mPromotionInfo.getRef_synchro());
        this.pstmt.setString(9, mPromotionInfo.getLabel_size_product());
        this.pstmt.setString(10, mPromotionInfo.getLabel_discount());
        this.pstmt.setString(11, mPromotionInfo.getDescription());
        this.pstmt.setString(12, mPromotionInfo.getText_promo());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idResult = -1;
        if (rs.next()) {
            int last_inserted_id;
            idResult = last_inserted_id = rs.getInt(1);
        }
        mPromotionInfo.setId(idResult);
        this.setIdGlobalItem(mPromotionInfo.getId(), "PROMOTIONS", "ID_GLOBAL", mPromotionInfo.getId_global());
    }

    public void updatePromotion(final PromotionInfo mPromotionInfo) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PROMOTIONS SET NAME_PROMOTION = ?, TYPE_ORDER = ?, SIZE_PRODUCT = ?, QUANTITY = ?, DISCOUNT = ?, REMOVED = ?, REMOVED_BY_ADMIN = ?, LABEL_SIZE_PRODUCT = ?, LABEL_DISCOUNT = ?, DESCRIPTION = ?, TEXT_PROMOTION = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, mPromotionInfo.getName_promotion());
                this.setString(2, mPromotionInfo.getType_order());
                this.setString(3, mPromotionInfo.getSize_product());
                this.setDouble(4, mPromotionInfo.getQuantity());
                this.setDouble(5, mPromotionInfo.getDiscount());
                this.setBoolean(6, mPromotionInfo.isRemoved());
                this.setBoolean(7, mPromotionInfo.isRemoved_by_admin());
                this.setString(8, mPromotionInfo.getLabel_size_product());
                this.setString(9, mPromotionInfo.getLabel_discount());
                this.setString(10, mPromotionInfo.getDescription());
                this.setString(11, mPromotionInfo.getText_promo());
                this.setInt(12, mPromotionInfo.getId());
            }
        });
    }

    public List<PromotionInfo> getPromotions(boolean all) throws BasicException {
        String request_removed = all ? "" : "AND P.REMOVED = 0";
        List promotions = new PreparedSentence(this.s, this.requestPromotions + "WHERE P.REMOVED_BY_ADMIN = 0 " + request_removed, null, PromotionInfo.getSerializerRead()).list();
        for (PromotionInfo promotionInfo : promotions) {
            List<MultiLanguagePromotion> multiLanguageTexts = this.multiLanguagePromotionService.getMultiLanguageTexts(promotionInfo.getId());
            promotionInfo.setMultiLanguageTexts(multiLanguageTexts);
        }
        return promotions;
    }

    public List<PromotionInfo> getPromotionsByPproduct(int id_product, boolean filter_by_removed) throws BasicException {
        String request_filter_by_removed = filter_by_removed ? "AND P.REMOVED = 0 AND P.REMOVED_BY_ADMIN = 0 " : "";
        List promotions = new PreparedSentence(this.s, this.requestPromotions + "JOIN PRODUCTS_PROMOTIONS PR ON P.ID = PR.ID_PROMOTION WHERE PR.ID_PRODUCT = ? " + request_filter_by_removed, SerializerWriteInteger.INSTANCE, PromotionInfo.getSerializerRead()).list((Object)id_product);
        for (PromotionInfo promotionInfo : promotions) {
            List<MultiLanguagePromotion> multiLanguageTexts = this.multiLanguagePromotionService.getMultiLanguageTexts(promotionInfo.getId());
            promotionInfo.setMultiLanguageTexts(multiLanguageTexts);
        }
        return promotions;
    }

    public void deletePromotion(final PromotionInfo mPromotionInfo) throws BasicException {
        String request_removed = AppLocal.user != null && AppLocal.user.getRole().equals("0") ? "REMOVED_BY_ADMIN = 1" : "REMOVED = 1";
        new PreparedSentence(this.s, "UPDATE PROMOTIONS SET " + request_removed + " WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, mPromotionInfo.getId());
            }
        });
    }

    public int addItemProduct(ProductInfoExt product) throws SQLException, BasicException {
        String SQL = "INSERT INTO PRODUCTS (CODE, NAME, PRICEBUY, PRICESELL, CATEGORY, TAXCAT, order_item, sp, emp, lv, price_sp, price_emp, price_lv, price_junior, price_senior, price_mega, price_sp_junior, price_sp_senior, price_sp_mega, price_emp_junior, price_emp_senior, price_emp_mega, price_lv_junior, price_lv_senior, price_lv_mega, menu, prepared, many_size, different_price, color, TAXEMP, TAXLV, label, bar, terasse, happy_hour, price_bar, price_terasse, price_happy, price_bar_junior, price_bar_senior, price_bar_mega, price_terasse_junior, price_terasse_senior, price_terasse_mega, price_happy_junior, price_happy_senior, price_happy_mega, option_free, special_option, number_line, number_column, max_line, additional_sale, moment_product, quantity, unit, weight, extra_unit, PRINTER_KITCHEN, HIDDEN_BORNE, SOLD_OUT, FREE_PRICE, ALIAS_KITCHEN, SEND_COLOR, HAS_DISPLAY_TIME, FIRST_PERIOD, END_PERIOD, DESCRIPTION, STORABLE, MIN_STORE, ADDITIONAL_SALE_AT_SPOT, ADDITIONAL_SALE_TAKE_AWAY, PRICE_UBER, PRICE_DELIVERO, PRICE_UBER_JUNIOR, PRICE_UBER_SENIOR, PRICE_UBER_MEGA, PRICE_DELIVERO_JUNIOR, PRICE_DELIVERO_SENIOR, PRICE_DELIVERO_MEGA, LATER, PRINT_INGREDIENTS, OPTIONS_FREE_GROUPED, PRICE_PLATFORM, PRICE_PLATFORM_JUNIOR, PRICE_PLATFORM_SENIOR, PRICE_PLATFORM_MEGA, AVAILABLE_CAISSE, SIZE_JUNIOR_ENABLED, SIZE_SENIOR_ENABLED, SIZE_MEGA_ENABLED, LABELED, BEST_SALE, DISPLAY_IMAGE_IN_KITCHEN, DAILY_STOCK, HAS_BAR_CODE, TOP_PRODUCT, HIDDEN_UBEREAT, DESCRIPTION_UBEREAT, HIDE_NAME_IN_BORNE, HIDE_PRICE_IN_BORNE, HAS_TIMETABLE, UNAVAILABLE_ONLINE, HIDDEN_ONLINE, PRODUCT_UBEREAT, MIXED_PRODUCT, PRICE_DRIVE, PRICE_DRIVE_JUNIOR, PRICE_DRIVE_SENIOR, PRICE_DRIVE_MEGA, PRODUCT_LOYALTY, PRICE_POINT, SOLD_OUT_TEMPORARY, ENABLE_IN_OPENING, PRICE_OPENING, HIDDEN_CAISSE, ISVALID_CAISSE ,marque, ZONE_ID, PRODUCT_PLU, DATE_START_DISPLAY , DATE_END_DISPLAY, TVA_GLOBAL_NO_APPLICABLE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, product.getCode());
        this.pstmt.setString(2, product.getName());
        this.pstmt.setDouble(3, product.getPriceBuy());
        this.pstmt.setDouble(4, product.getPriceSell());
        this.pstmt.setInt(5, product.getCategoryid());
        this.pstmt.setString(6, product.getTaxcategoryid());
        this.pstmt.setInt(7, product.getOrder_item());
        this.pstmt.setBoolean(8, product.getSp());
        this.pstmt.setBoolean(9, product.getEmp());
        this.pstmt.setBoolean(10, product.getLv());
        this.pstmt.setDouble(11, product.getPrice_sp());
        this.pstmt.setDouble(12, product.getPrice_emp());
        this.pstmt.setDouble(13, product.getPrice_lv());
        this.pstmt.setDouble(14, product.getPrice_junior());
        this.pstmt.setDouble(15, product.getPrice_senior());
        this.pstmt.setDouble(16, product.getPrice_mega());
        this.pstmt.setDouble(17, product.getPrice_sp_junior());
        this.pstmt.setDouble(18, product.getPrice_sp_senior());
        this.pstmt.setDouble(19, product.getPrice_sp_mega());
        this.pstmt.setDouble(20, product.getPrice_emp_junior());
        this.pstmt.setDouble(21, product.getPrice_emp_senior());
        this.pstmt.setDouble(22, product.getPrice_emp_mega());
        this.pstmt.setDouble(23, product.getPrice_lv_junior());
        this.pstmt.setDouble(24, product.getPrice_lv_senior());
        this.pstmt.setDouble(25, product.getPrice_lv_mega());
        this.pstmt.setBoolean(26, product.isMenu());
        this.pstmt.setBoolean(27, product.isPrepared());
        this.pstmt.setBoolean(28, product.isMany_size());
        this.pstmt.setBoolean(29, product.isDifferent_price());
        this.pstmt.setString(30, product.getColor());
        this.pstmt.setString(31, product.getTaxemp());
        this.pstmt.setString(32, product.getTaxlv());
        this.pstmt.setBoolean(33, product.isHasLabel());
        this.pstmt.setBoolean(34, product.getBar());
        this.pstmt.setBoolean(35, product.getTerasse());
        this.pstmt.setBoolean(36, product.getHappy_hour());
        this.pstmt.setDouble(37, product.getPrice_bar());
        this.pstmt.setDouble(38, product.getPrice_terasse());
        this.pstmt.setDouble(39, product.getPrice_happy_hour());
        this.pstmt.setDouble(40, product.getPrice_bar_junior());
        this.pstmt.setDouble(41, product.getPrice_bar_senior());
        this.pstmt.setDouble(42, product.getPrice_bar_mega());
        this.pstmt.setDouble(43, product.getPrice_terasse_junior());
        this.pstmt.setDouble(44, product.getPrice_terasse_senior());
        this.pstmt.setDouble(45, product.getPrice_terasse_mega());
        this.pstmt.setDouble(46, product.getPrice_happy_junior());
        this.pstmt.setDouble(47, product.getPrice_happy_senior());
        this.pstmt.setDouble(48, product.getPrice_happy_mega());
        this.pstmt.setInt(49, product.getOption_free());
        this.pstmt.setBoolean(50, product.isSpecial_option());
        this.pstmt.setInt(51, product.getNumber_line());
        this.pstmt.setInt(52, product.getNumber_column());
        this.pstmt.setInt(53, product.getMax_line());
        this.pstmt.setBoolean(54, product.isAdditional_sale());
        this.pstmt.setBoolean(55, product.isMoment_product());
        this.pstmt.setDouble(56, product.getQuantity());
        this.pstmt.setString(57, product.getUnit());
        this.pstmt.setDouble(58, product.getWeight());
        this.pstmt.setString(59, product.getExtra_unit());
        this.pstmt.setString(60, product.getPrinter_kitchen());
        this.pstmt.setBoolean(61, product.isHidden_borne());
        this.pstmt.setBoolean(62, product.isSold_out());
        this.pstmt.setBoolean(63, product.isFree_price());
        this.pstmt.setString(64, product.getAlias_kitchen());
        this.pstmt.setBoolean(65, product.isSend_color());
        this.pstmt.setBoolean(66, product.isHas_display_time());
        this.pstmt.setInt(67, product.getFirst_period());
        this.pstmt.setInt(68, product.getEnd_period());
        this.pstmt.setString(69, product.getDescription());
        this.pstmt.setBoolean(70, product.isStorable());
        this.pstmt.setDouble(71, product.getMin_store());
        this.pstmt.setBoolean(72, product.isAdditional_sale_at_spot());
        this.pstmt.setBoolean(73, product.isAdditional_sale_take_away());
        this.pstmt.setDouble(74, product.getPrice_uber());
        this.pstmt.setDouble(75, product.getPrice_delivero());
        this.pstmt.setDouble(76, product.getPrice_uber_junior());
        this.pstmt.setDouble(77, product.getPrice_uber_senior());
        this.pstmt.setDouble(78, product.getPrice_uber_mega());
        this.pstmt.setDouble(79, product.getPrice_delivero_junior());
        this.pstmt.setDouble(80, product.getPrice_delivero_senior());
        this.pstmt.setDouble(81, product.getPrice_delivero_mega());
        this.pstmt.setBoolean(82, product.isLater());
        this.pstmt.setBoolean(83, product.isPrint_ingredients());
        this.pstmt.setBoolean(84, product.isOptions_free_grouped());
        this.pstmt.setDouble(85, product.getPrice_platform());
        this.pstmt.setDouble(86, product.getPrice_platform_junior());
        this.pstmt.setDouble(87, product.getPrice_platform_senior());
        this.pstmt.setDouble(88, product.getPrice_platform_mega());
        this.pstmt.setBoolean(89, product.isAvailable_caisse());
        this.pstmt.setBoolean(90, product.isSize_junior_enabled());
        this.pstmt.setBoolean(91, product.isSize_senior_enabled());
        this.pstmt.setBoolean(92, product.isSize_mega_enabled());
        this.pstmt.setBoolean(93, product.isLabeled());
        this.pstmt.setBoolean(94, product.isBest_sale());
        this.pstmt.setBoolean(95, product.isDisplay_image_in_kitchen());
        this.pstmt.setInt(96, product.getDaily_stock());
        this.pstmt.setBoolean(97, product.isHas_bar_code());
        this.pstmt.setBoolean(98, product.isTop_product());
        this.pstmt.setBoolean(99, product.isHidden_platform());
        this.pstmt.setString(100, product.getDescription_uberEat());
        this.pstmt.setBoolean(101, product.isHide_name_in_borne());
        this.pstmt.setBoolean(102, product.isHide_price_in_borne());
        this.pstmt.setBoolean(103, product.isHas_timetable());
        this.pstmt.setBoolean(104, product.isUnavailable_online());
        this.pstmt.setBoolean(105, product.isHidden_online());
        this.pstmt.setBoolean(106, product.isProduct_ubereat());
        this.pstmt.setBoolean(107, product.isMixed_product());
        this.pstmt.setDouble(108, product.getPrice_drive());
        this.pstmt.setDouble(109, product.getPrice_drive_junior());
        this.pstmt.setDouble(110, product.getPrice_drive_senior());
        this.pstmt.setDouble(111, product.getPrice_drive_mega());
        this.pstmt.setBoolean(112, product.isProduct_loyalty());
        this.pstmt.setDouble(113, product.getPrice_point());
        this.pstmt.setBoolean(114, product.isSold_out_temporary());
        this.pstmt.setBoolean(115, product.isEnable_in_opening());
        this.pstmt.setDouble(116, product.getPrice_opening());
        this.pstmt.setBoolean(117, product.isHidden_caisse());
        this.pstmt.setBoolean(118, product.isValid_caisse());
        this.pstmt.setInt(119, product.getMarque());
        if (product.getZoneId() != null) {
            this.pstmt.setInt(120, product.getZoneId());
        } else {
            this.pstmt.setNull(120, 4);
        }
        this.pstmt.setString(121, product.getId_global());
        Date startDisplay = product.getDateStartDisplay();
        Date endDisplay = product.getDateEndDisplay();
        if (startDisplay != null) {
            this.pstmt.setTimestamp(122, new Timestamp(startDisplay.getTime()));
        } else {
            this.pstmt.setTimestamp(122, null);
        }
        if (endDisplay != null) {
            this.pstmt.setTimestamp(123, new Timestamp(endDisplay.getTime()));
        } else {
            this.pstmt.setTimestamp(123, null);
        }
        this.pstmt.setBoolean(124, product.isTva_global_no_applicable());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idResult = -1;
        if (rs.next()) {
            int last_inserted_id;
            idResult = last_inserted_id = rs.getInt(1);
        }
        this.setIdGlobalItem(idResult, "PRODUCTS", "PRODUCT_PLU", product.getId_global());
        return idResult;
    }

    public final ProductInfoExt addProduct(final ProductInfoExt product, List<SupplementItemInfo> ingredients, Map<Integer, Integer> ingredientsQuantities, List<SupplementProduct> options, List<CarteOrderInfo> cartes) throws BasicException, SQLException {
        this.id_Product = this.addItemProduct(product);
        product.setID(this.id_Product);
        if (product.getPrinterID() != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printer = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, product.getPrinterID());
                    this.setInt(2, DataLogicItems.this.id_Product);
                }
            });
        }
        if (product.getPrinterLabel() != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printerLabel = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, product.getPrinterLabel());
                    this.setInt(2, DataLogicItems.this.id_Product);
                }
            });
        }
        if (product.getDisplayKitchen() != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET display_kitchen = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, product.getDisplayKitchen());
                    this.setInt(2, DataLogicItems.this.id_Product);
                }
            });
        }
        this.addItemIngredient(ingredients, ingredientsQuantities);
        this.addItemSupplements(options, this.id_Product);
        this.addCarteMenu(cartes, this.id_Product);
        for (ProductSizeInfo productSize : product.getListSizes()) {
            if (!productSize.isSize_enabled()) continue;
            productSize.setIdProduct(product.getID());
            this.addProduct_Size(productSize);
        }
        this.addAdditionalSales(product);
        this.addPromotionsProduct(product);
        this.addSubProducts(product);
        this.addProductDaysOn(product);
        this.addScreensProduct(product);
        this.persistShiftProducts(product);
        for (ProductPriceInfo productPrice : product.getPrices()) {
            productPrice.setIdProduct(product.getID());
            this.addProductPrice(productPrice);
        }
        return product;
    }

    private void addAdditionalSales(ProductInfoExt product) throws BasicException {
        if (product.getAdditional_sales() != null) {
            for (ProductInfoExt additional_sale : product.getAdditional_sales()) {
                this.addAdditionalSale(product, additional_sale);
            }
        }
    }

    private void addAdditionalSale(final ProductInfoExt product, final ProductInfoExt additional_sale) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO ADDITIONAL_SALES(ID_PRODUCT, ID_PRODUCT_PARENT) VALUES(? ,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, additional_sale.getID());
                this.setInt(2, product.getID());
            }
        });
    }

    private void deleteAdditionalSale(final ProductInfoExt product, final ProductInfoExt additional_sale) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM ADDITIONAL_SALES WHERE ID_PRODUCT = ? AND ID_PRODUCT_PARENT = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, additional_sale.getID());
                this.setInt(2, product.getID());
            }
        });
    }

    public List<ProductInfoExt> getAllAdditionalSales(int id_product, boolean check_if_removed) throws BasicException {
        String requestRemoved = check_if_removed ? " AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 " : "";
        List products = new PreparedSentence(this.s, this.requestProducts + "JOIN ADDITIONAL_SALES A  ON P.ID = A.ID_PRODUCT WHERE A.ID_PRODUCT_PARENT = ? " + requestRemoved + " ORDER BY  P.order_item ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)id_product);
        for (ProductInfoExt product : products) {
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return products;
    }

    public void persistAdditionalSales(ProductInfoExt product) throws BasicException {
        int found;
        List<ProductInfoExt> oldAdditionalSales = this.getAllAdditionalSales(product.getID());
        for (ProductInfoExt oldAddionalSale : oldAdditionalSales) {
            found = -1;
            for (ProductInfoExt newAdditionalSale : product.getAdditional_sales()) {
                if (oldAddionalSale.getID() != newAdditionalSale.getID()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteAdditionalSale(product, oldAddionalSale);
        }
        for (ProductInfoExt newAdditionalSale : product.getAdditional_sales()) {
            found = -1;
            for (ProductInfoExt oldAddionalSale : oldAdditionalSales) {
                if (oldAddionalSale.getID() != newAdditionalSale.getID()) continue;
                found = 1;
            }
            if (found != -1 || newAdditionalSale.getID() == -1) continue;
            this.addAdditionalSale(product, newAdditionalSale);
        }
    }

    public void updateItemProduct(final ProductInfoExt product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  PRODUCTS SET CODE = ?, NAME = ?, PRICEBUY = ?, PRICESELL = ?, CATEGORY = ?, TAXCAT = ?, sp = ?, emp = ?, lv = ?,  price_sp = ?, price_emp = ?, price_lv = ?, price_junior = ?, price_senior = ?, price_mega = ?, price_sp_junior = ?, price_sp_senior = ?, price_sp_mega = ?, price_emp_junior = ?, price_emp_senior = ?, price_emp_mega = ?, price_lv_junior = ?, price_lv_senior = ?, price_lv_mega = ?, menu = ?, prepared = ?,  many_size = ?, different_price = ?, color = ?, TAXEMP = ?, TAXLV = ?, label = ?, bar = ?, terasse = ?, happy_hour = ?, price_bar = ?, price_terasse = ?, price_happy = ?, price_bar_junior = ?, price_bar_senior = ?, price_bar_mega = ?, price_terasse_junior = ?, price_terasse_senior = ?, price_terasse_mega = ?, price_happy_junior = ?, price_happy_senior = ?, price_happy_mega = ?, removed = ?, option_free = ?, special_option = ?, number_line = ?, number_column = ?, max_line = ?, additional_sale = ?, moment_product = ?, quantity = ?, unit = ?, weight = ?, extra_unit = ?, PRINTER_KITCHEN = ?, HIDDEN_BORNE = ?, SOLD_OUT = ?, FREE_PRICE = ?, ALIAS_KITCHEN = ?, SEND_COLOR = ?, HAS_DISPLAY_TIME = ?, FIRST_PERIOD = ?, END_PERIOD = ?, DESCRIPTION = ?, STORABLE = ?, MIN_STORE = ?, ADDITIONAL_SALE_AT_SPOT = ?, ADDITIONAL_SALE_TAKE_AWAY = ?, PRICE_UBER = ?, PRICE_DELIVERO = ?, PRICE_UBER_JUNIOR = ?, PRICE_UBER_SENIOR = ?, PRICE_UBER_MEGA = ?, PRICE_DELIVERO_JUNIOR = ?, PRICE_DELIVERO_SENIOR = ?, PRICE_DELIVERO_MEGA = ?, LATER = ?, PRINT_INGREDIENTS = ?, OPTIONS_FREE_GROUPED = ?, PRICE_PLATFORM = ?, PRICE_PLATFORM_JUNIOR = ?, PRICE_PLATFORM_SENIOR = ?, PRICE_PLATFORM_MEGA = ?, AVAILABLE_CAISSE = ?, SIZE_JUNIOR_ENABLED = ?, SIZE_SENIOR_ENABLED = ?, SIZE_MEGA_ENABLED = ?, LABELED = ?, BEST_SALE = ?, DISPLAY_IMAGE_IN_KITCHEN = ?, DAILY_STOCK = ?, HAS_BAR_CODE = ?, TOP_PRODUCT = ?, HIDDEN_UBEREAT = ?, DESCRIPTION_UBEREAT = ?, HIDE_NAME_IN_BORNE = ?, HIDE_PRICE_IN_BORNE = ?, HAS_TIMETABLE = ?, UNAVAILABLE_ONLINE = ?, HIDDEN_ONLINE = ?, PRODUCT_UBEREAT = ?, MIXED_PRODUCT = ?, PRICE_DRIVE = ?, PRICE_DRIVE_JUNIOR = ?, PRICE_DRIVE_SENIOR = ?, PRICE_DRIVE_MEGA = ?, PRODUCT_LOYALTY = ?, PRICE_POINT = ?, SOLD_OUT_TEMPORARY = ?, ENABLE_IN_OPENING = ?, PRICE_OPENING = ?, HIDDEN_CAISSE = ?, ISVALID_CAISSE = ?, marque = ?, ZONE_ID = ?, PRODUCT_PLU = ? , DATE_START_DISPLAY = ? , DATE_END_DISPLAY = ?,  TVA_GLOBAL_NO_APPLICABLE = ?  WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, product.getCode());
                this.setString(2, product.getName());
                this.setDouble(3, product.getPriceBuy());
                this.setDouble(4, product.getPriceSell());
                this.setInt(5, product.getCategoryid());
                this.setString(6, product.getTaxcategoryid());
                this.setBoolean(7, product.getSp());
                this.setBoolean(8, product.getEmp());
                this.setBoolean(9, product.getLv());
                this.setDouble(10, product.getPrice_sp());
                this.setDouble(11, product.getPrice_emp());
                this.setDouble(12, product.getPrice_lv());
                this.setDouble(13, product.getPrice_junior());
                this.setDouble(14, product.getPrice_senior());
                this.setDouble(15, product.getPrice_mega());
                this.setDouble(16, product.getPrice_sp_junior());
                this.setDouble(17, product.getPrice_sp_senior());
                this.setDouble(18, product.getPrice_sp_mega());
                this.setDouble(19, product.getPrice_emp_junior());
                this.setDouble(20, product.getPrice_emp_senior());
                this.setDouble(21, product.getPrice_emp_mega());
                this.setDouble(22, product.getPrice_lv_junior());
                this.setDouble(23, product.getPrice_lv_senior());
                this.setDouble(24, product.getPrice_lv_mega());
                this.setBoolean(25, product.isMenu());
                this.setBoolean(26, product.isPrepared());
                this.setBoolean(27, product.isMany_size());
                this.setBoolean(28, product.isDifferent_price());
                this.setString(29, product.getColor());
                this.setString(30, product.getTaxemp());
                this.setString(31, product.getTaxlv());
                this.setBoolean(32, product.isHasLabel());
                this.setBoolean(33, product.getBar());
                this.setBoolean(34, product.getTerasse());
                this.setBoolean(35, product.getHappy_hour());
                this.setDouble(36, product.getPrice_bar());
                this.setDouble(37, product.getPrice_terasse());
                this.setDouble(38, product.getPrice_happy_hour());
                this.setDouble(39, product.getPrice_bar_junior());
                this.setDouble(40, product.getPrice_bar_senior());
                this.setDouble(41, product.getPrice_bar_mega());
                this.setDouble(42, product.getPrice_terasse_junior());
                this.setDouble(43, product.getPrice_terasse_senior());
                this.setDouble(44, product.getPrice_terasse_mega());
                this.setDouble(45, product.getPrice_happy_junior());
                this.setDouble(46, product.getPrice_happy_senior());
                this.setDouble(47, product.getPrice_happy_mega());
                this.setBoolean(48, product.isRemoved());
                this.setInt(49, product.getOption_free());
                this.setBoolean(50, product.isSpecial_option());
                this.setInt(51, product.getNumber_line());
                this.setInt(52, product.getNumber_column());
                this.setInt(53, product.getMax_line());
                this.setBoolean(54, product.isAdditional_sale());
                this.setBoolean(55, product.isMoment_product());
                this.setDouble(56, product.getQuantity());
                this.setString(57, product.getUnit());
                this.setDouble(58, product.getWeight());
                this.setString(59, product.getExtra_unit());
                this.setString(60, product.getPrinter_kitchen());
                this.setBoolean(61, product.isHidden_borne());
                this.setBoolean(62, product.isSold_out());
                this.setBoolean(63, product.isFree_price());
                this.setString(64, product.getAlias_kitchen());
                this.setBoolean(65, product.isSend_color());
                this.setBoolean(66, product.isHas_display_time());
                this.setInt(67, product.getFirst_period());
                this.setInt(68, product.getEnd_period());
                this.setString(69, product.getDescription());
                this.setBoolean(70, product.isStorable());
                this.setDouble(71, product.getMin_store());
                this.setBoolean(72, product.isAdditional_sale_at_spot());
                this.setBoolean(73, product.isAdditional_sale_take_away());
                this.setDouble(74, product.getPrice_uber());
                this.setDouble(75, product.getPrice_delivero());
                this.setDouble(76, product.getPrice_uber_junior());
                this.setDouble(77, product.getPrice_uber_senior());
                this.setDouble(78, product.getPrice_uber_mega());
                this.setDouble(79, product.getPrice_delivero_junior());
                this.setDouble(80, product.getPrice_delivero_senior());
                this.setDouble(81, product.getPrice_delivero_mega());
                this.setBoolean(82, product.isLater());
                this.setBoolean(83, product.isPrint_ingredients());
                this.setBoolean(84, product.isOptions_free_grouped());
                this.setDouble(85, product.getPrice_platform());
                this.setDouble(86, product.getPrice_platform_junior());
                this.setDouble(87, product.getPrice_platform_senior());
                this.setDouble(88, product.getPrice_platform_mega());
                this.setBoolean(89, product.isAvailable_caisse());
                this.setBoolean(90, product.isSize_junior_enabled());
                this.setBoolean(91, product.isSize_senior_enabled());
                this.setBoolean(92, product.isSize_mega_enabled());
                this.setBoolean(93, product.isLabeled());
                this.setBoolean(94, product.isBest_sale());
                this.setBoolean(95, product.isDisplay_image_in_kitchen());
                this.setInt(96, product.getDaily_stock());
                this.setBoolean(97, product.isHas_bar_code());
                this.setBoolean(98, product.isTop_product());
                this.setBoolean(99, product.isHidden_platform());
                this.setString(100, product.getDescription_uberEat());
                this.setBoolean(101, product.isHide_name_in_borne());
                this.setBoolean(102, product.isHide_price_in_borne());
                this.setBoolean(103, product.isHas_timetable());
                this.setBoolean(104, product.isUnavailable_online());
                this.setBoolean(105, product.isHidden_online());
                this.setBoolean(106, product.isProduct_ubereat());
                this.setBoolean(107, product.isMixed_product());
                this.setDouble(108, product.getPrice_drive());
                this.setDouble(109, product.getPrice_drive_junior());
                this.setDouble(110, product.getPrice_drive_senior());
                this.setDouble(111, product.getPrice_drive_mega());
                this.setBoolean(112, product.isProduct_loyalty());
                this.setDouble(113, product.getPrice_point());
                this.setBoolean(114, product.isSold_out_temporary());
                this.setBoolean(115, product.isEnable_in_opening());
                this.setDouble(116, product.getPrice_opening());
                this.setBoolean(117, product.isHidden_caisse());
                this.setBoolean(118, product.isValid_caisse());
                this.setInt(119, product.getMarque());
                this.setInt(120, product.getZoneId());
                this.setString(121, product.getId_global());
                this.setTimestamp(122, product.getDateStartDisplay());
                this.setTimestamp(123, product.getDateEndDisplay());
                this.setBoolean(124, product.isTva_global_no_applicable());
                this.setInt(125, product.getID());
            }
        });
    }

    public final void updateProduct(final ProductInfoExt product, List<SupplementItemInfo> ingredients, Map<Integer, Integer> ingredientsQuantities, List<SupplementProduct> options, List<CarteOrderInfo> cartes) throws BasicException, SQLException {
        int found;
        this.updateItemProduct(product);
        if (product.getPrinterID() != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printer = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, product.getPrinterID());
                    this.setInt(2, product.getID());
                }
            });
        } else {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printer = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, null);
                    this.setInt(2, product.getID());
                }
            });
        }
        if (product.getPrinterLabel() != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printerLabel = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, product.getPrinterLabel());
                    this.setInt(2, product.getID());
                }
            });
        } else {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET printerLabel = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, null);
                    this.setInt(2, product.getID());
                }
            });
        }
        if (product.getDisplayKitchen() != -1) {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET display_kitchen = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, product.getDisplayKitchen());
                    this.setInt(2, product.getID());
                }
            });
        } else {
            new PreparedSentence(this.s, "UPDATE PRODUCTS SET display_kitchen = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, null);
                    this.setInt(2, product.getID());
                }
            });
        }
        this.persistSizesProduct(product, false);
        List<ItemIngredientInfo> itemsIngredients = this.getItemsIngredients(product.getID());
        PreparedSentence itemIngredientinsert = new PreparedSentence(this.s, "INSERT INTO ITEM_INGREDIENTS (id_supplement_item, id_item, quantity) VALUES (?, ?, ?)", SerializerWriteParams.INSTANCE);
        PreparedSentence itemIngredientUpdate = new PreparedSentence(this.s, "UPDATE ITEM_INGREDIENTS SET quantity = ? WHERE id_supplement_item = ? AND id_item = ?", SerializerWriteParams.INSTANCE);
        PreparedSentence itemIngredientdelete = new PreparedSentence(this.s, "DELETE FROM ITEM_INGREDIENTS WHERE id_supplement_item = ? AND id_item = ? ", SerializerWriteParams.INSTANCE);
        List<SupplementProduct> itemsOptions = this.getSupplementsByProduct(product.getID(), false, false);
        PreparedSentence itemOptiondelete = new PreparedSentence(this.s, "DELETE FROM  ITEM_SUPPLEMENTS WHERE id_supplement = ? AND id_item = ? ", SerializerWriteParams.INSTANCE);
        List<CarteOrderInfo> itemCartes = this.getCartesByItem(product.getID());
        PreparedSentence carteinsert = new PreparedSentence(this.s, "INSERT INTO CARTE_MENU (id_carte, id_item, carteOrder, number_carte) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
        PreparedSentence cartedelete = new PreparedSentence(this.s, "DELETE FROM  CARTE_MENU WHERE id_carte = ? AND id_item = ? ", SerializerWriteParams.INSTANCE);
        PreparedSentence carteupdate = new PreparedSentence(this.s, "UPDATE CARTE_MENU SET carteOrder = ?, number_carte = ? WHERE id_carte = ? AND id_item = ? ", SerializerWriteParams.INSTANCE);
        for (final SupplementProduct itemOption : itemsOptions) {
            found = -1;
            for (SupplementProduct option : options) {
                if (option.getiD() != itemOption.getiD()) continue;
                found = 1;
            }
            if (found != -1) continue;
            itemOptiondelete.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, itemOption.getiD());
                    this.setInt(2, product.getID());
                }
            });
        }
        for (SupplementProduct option : options) {
            found = -1;
            for (SupplementProduct itemOption : itemsOptions) {
                if (option.getiD() != itemOption.getiD()) continue;
                found = 1;
            }
            if (found == -1) {
                this.addItemSupplement(option, product.getID());
                continue;
            }
            this.updateItemSupplement(option, product.getID());
        }
        for (final ItemIngredientInfo itemIngredient : itemsIngredients) {
            found = -1;
            for (SupplementItemInfo ingredient : ingredients) {
                if (ingredient.getiD() != itemIngredient.getId_supplement_item()) continue;
                found = 1;
            }
            if (found != -1) continue;
            itemIngredientdelete.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, itemIngredient.getId_supplement_item());
                    this.setInt(2, product.getID());
                }
            });
        }
        for (final SupplementItemInfo ingredient : ingredients) {
            boolean exists = false;
            for (ItemIngredientInfo itemIngredient : itemsIngredients) {
                if (ingredient.getiD() != itemIngredient.getId_supplement_item()) continue;
                exists = true;
                break;
            }
            final int quantity = ingredientsQuantities.getOrDefault(ingredient.getiD(), 1);
            if (!exists) {
                itemIngredientinsert.exec((Object)new DataParams(){

                    @Override
                    public void writeValues() throws BasicException {
                        this.setInt(1, ingredient.getiD());
                        this.setInt(2, product.getID());
                        this.setInt(3, quantity);
                    }
                });
                continue;
            }
            itemIngredientUpdate.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, quantity);
                    this.setInt(2, ingredient.getiD());
                    this.setInt(3, product.getID());
                }
            });
        }
        for (final CarteOrderInfo itemCarte : itemCartes) {
            found = -1;
            for (CarteOrderInfo carte : cartes) {
                if (carte.getId() != itemCarte.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            cartedelete.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, itemCarte.getId());
                    this.setInt(2, product.getID());
                }
            });
        }
        for (final CarteOrderInfo carte : cartes) {
            found = -1;
            for (CarteOrderInfo itemCarte : itemCartes) {
                if (carte.getId() != itemCarte.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            carteinsert.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, carte.getId());
                    this.setInt(2, product.getID());
                    this.setInt(3, carte.getOrderCarte());
                    this.setInt(4, carte.getNumber_carte());
                }
            });
        }
        for (final CarteOrderInfo carte : cartes) {
            carteupdate.exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, carte.getOrderCarte());
                    this.setInt(2, carte.getNumber_carte());
                    this.setInt(3, carte.getId());
                    this.setInt(4, product.getID());
                }
            });
        }
        this.persistAdditionalSales(product);
        this.persistPromotionsProduct(product);
        this.persistSubProducts(product);
        this.persistProductDaysOn(product);
        this.persistScreensProduct(product);
        this.persistPricesProduct(product);
        this.persistShiftProducts(product);
        this.updateImagesProduct(product);
    }

    private void addPromotionsProduct(ProductInfoExt product) throws BasicException {
        if (product.getPromotions() != null) {
            for (PromotionInfo promotion : product.getPromotions()) {
                this.addPromotionProduct(product.getID(), promotion);
            }
        }
    }

    public void addPromotionProduct(final int product_id, final PromotionInfo promotion) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PRODUCTS_PROMOTIONS(ID_PROMOTION, ID_PRODUCT) VALUES(? ,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, promotion.getId());
                this.setInt(2, product_id);
            }
        });
    }

    private void deletePromotionProduct(final ProductInfoExt product, final PromotionInfo promotion) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PRODUCTS_PROMOTIONS WHERE ID_PROMOTION = ? AND ID_PRODUCT = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, promotion.getId());
                this.setInt(2, product.getID());
            }
        });
    }

    public void persistPromotionsProduct(ProductInfoExt product) throws BasicException {
        int found;
        List<PromotionInfo> oldPromotions = this.getPromotionsByPproduct(product.getID(), false);
        for (PromotionInfo oldPromotion : oldPromotions) {
            found = -1;
            for (PromotionInfo newPromotion : product.getPromotions()) {
                if (oldPromotion.getId() != newPromotion.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deletePromotionProduct(product, oldPromotion);
        }
        for (PromotionInfo newPromotion : product.getPromotions()) {
            found = -1;
            for (PromotionInfo omdPromotion : oldPromotions) {
                if (omdPromotion.getId() != newPromotion.getId()) continue;
                found = 1;
            }
            if (found != -1 || newPromotion.getId() == -1) continue;
            this.addPromotionProduct(product.getID(), newPromotion);
        }
    }

    public List<ProductInfoExt> getProducts(int category, boolean catalog, boolean all, boolean sub_child, boolean filter_by_tariff) throws BasicException {
        List<ProductInfoExt> products = this.getProductsWithoutDetails(category, catalog, all, sub_child, false);
        for (ProductInfoExt product : products) {
            product.setListSizes(this.getProductSizes(product.getID(), filter_by_tariff));
            product.setAdditional_sales(this.getAdditionalSales(product.getID(), false));
            product.setPromotions(this.getPromotionsByPproduct(product.getID(), true));
            product.setSub_products(this.getSubProducts(product.getID(), false));
            product.setPrices(this.getProductPrices(product.getID(), filter_by_tariff));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
            if (catalog) continue;
            product.setIngredients(this.getIngredientsByProducts(product.getID(), true, true));
            product.setSupplements(this.getSupplementsByProduct(product.getID(), false, false));
            product.setCartes(this.getCartesByItem(product.getID()));
            product.setScreens(this.getScreenByProduct(product.getID()));
        }
        return products;
    }

    public List<ProductInfoExt> getProductCatalogType(final int category, String type, final boolean sub_child, boolean product_loyalty) throws BasicException {
        int index_param_calendar;
        Object request2 = "";
        if (type != null) {
            request2 = " AND ";
            switch (type) {
                case "sp": {
                    request2 = (String)request2 + "P.sp= 1";
                    break;
                }
                case "emp": {
                    request2 = (String)request2 + "P.emp= 1";
                    break;
                }
                case "lv": {
                    request2 = (String)request2 + "P.lv= 1";
                    break;
                }
                case "bar": {
                    request2 = (String)request2 + "P.bar= 1";
                    break;
                }
                case "terasse": {
                    request2 = (String)request2 + "P.terasse= 1";
                    break;
                }
                case "happy_hour": {
                    request2 = (String)request2 + "P.happy_hour= 1";
                }
            }
        }
        final int dayOfWeek = DateUtils.getDayOfWeek();
        int n = index_param_calendar = sub_child ? 3 : 2;
        String request_category = sub_child ? (product_loyalty ? " (P.PRODUCT_LOYALTY = 1  OR P.CATEGORY = ? OR (C.PARENTID IS NOT NULL AND C.PARENTID = ?)) " : " (P.CATEGORY = ? OR (C.PARENTID IS NOT NULL AND C.PARENTID = ?)) ") : (product_loyalty ? " (P.PRODUCT_LOYALTY = 1  OR  P.CATEGORY = ?) " : " P.CATEGORY = ?");
        String request_join = sub_child || product_loyalty ? "JOIN CATEGORIES C ON P.CATEGORY = C.ID " : "";
        String request_category_exist = sub_child || product_loyalty ? " AND C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 " : "";
        String request_opening_mode = AppLocal.OPENING_MODE ? "AND P.ENABLE_IN_OPENING = 1 " : "";
        String request_product_menu = "AND ( P.menu = 0 OR (P.menu = 1 AND NOT EXISTS ( SELECT 1 FROM carte_menu cm WHERE cm.id_item = P.id AND NOT EXISTS (SELECT 1 FROM carte_item ci JOIN products pi ON ci.id_item = pi.id WHERE ci.id_carte = cm.id_carte AND pi.sold_out = 0))) )";
        List products = new PreparedSentence(this.s, this.requestProducts + request_join + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.HIDDEN_CAISSE = 0 AND P.PRODUCT_UBEREAT = 0 AND " + request_category + (String)request2 + " AND (P.HAS_TIMETABLE = 0 OR P.ID IN (SELECT PD.ID_PRODUCT from PRODUCT_DAYS_ON PD where PD.DAY_OF_WEEK = ?)) " + request_opening_mode + request_category_exist + request_product_menu + this.request_campaign_product + " ORDER BY P.CATEGORY, P.order_item ", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category);
                if (sub_child) {
                    this.setInt(2, category);
                }
                this.setInt(index_param_calendar, dayOfWeek);
            }
        });
        return products;
    }

    public final ProductInfoExt getProductWidthSize(int id) throws BasicException {
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.ID = ? ORDER BY  P.order_item ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)id);
        if (product != null) {
            product.setListSizes(this.getProductSizes(product.getID(), true));
            product.setAdditional_sales(this.getAdditionalSales(product.getID(), false));
            product.setPromotions(this.getPromotionsByPproduct(product.getID(), true));
            product.setSub_products(this.getSubProducts(product.getID(), false));
            product.setPrices(this.getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return product;
    }

    public SupplementItemInfo getFullInfoSupplementById(int id_supplement) throws BasicException {
        SupplementItemInfo item = (SupplementItemInfo)new PreparedSentence(this.s, this.requestFullSuppItem + " JOIN supplement G ON G.id = S.id_supplement  where S.id = ?", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getFullOptions()).find((Object)id_supplement);
        if (item != null) {
            item.setSupplementPrices(this.getSupplementPrices(item.getiD()));
        }
        return item;
    }

    private void addSubProducts(ProductInfoExt product) throws BasicException {
        if (product.getSub_products() != null) {
            for (ProductInfoExt sub_product : product.getSub_products()) {
                this.addSubProduct(product, sub_product);
            }
        }
    }

    private void addSubProduct(final ProductInfoExt product, final ProductInfoExt sub_product) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SUB_PRODUCTS(ID_PRODUCT, ID_PRODUCT_PARENT, NUMBER_EXEMPLARY) VALUES(? ,?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, sub_product.getID());
                this.setInt(2, product.getID());
                this.setInt(3, sub_product.getNumber_exemplary());
            }
        });
    }

    private void updateSubProduct(final ProductInfoExt product, final ProductInfoExt sub_product) throws BasicException {
        new PreparedSentence(this.s, "UPDATE SUB_PRODUCTS SET NUMBER_EXEMPLARY = ? WHERE ID_PRODUCT = ? AND ID_PRODUCT_PARENT = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, sub_product.getNumber_exemplary());
                this.setInt(2, sub_product.getID());
                this.setInt(3, product.getID());
            }
        });
    }

    private void deleteSubProduct(final ProductInfoExt product, final ProductInfoExt sub_product) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SUB_PRODUCTS WHERE ID_PRODUCT = ? AND ID_PRODUCT_PARENT = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, sub_product.getID());
                this.setInt(2, product.getID());
            }
        });
    }

    public void persistSubProducts(ProductInfoExt product) throws BasicException {
        int found;
        List<ProductInfoExt> oldSubProducts = this.getAllSubProducts(product.getID(), false);
        for (ProductInfoExt oldSubProduct : oldSubProducts) {
            found = -1;
            for (ProductInfoExt newSubProduct : product.getSub_products()) {
                if (oldSubProduct.getID() != newSubProduct.getID()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteSubProduct(product, oldSubProduct);
        }
        for (ProductInfoExt newSubProduct : product.getSub_products()) {
            found = -1;
            for (ProductInfoExt oldSubProduct : oldSubProducts) {
                if (oldSubProduct.getID() != newSubProduct.getID()) continue;
                found = 1;
            }
            if (found == 1) {
                this.updateSubProduct(product, newSubProduct);
                continue;
            }
            if (newSubProduct.getID() == -1) continue;
            this.addSubProduct(product, newSubProduct);
        }
    }

    public List<TicketInfo> loadOrderSynchronizedToVerify() throws BasicException {
        String q = this.requestTicket + "WHERE TYPE = 'En Livraison' and STATUS = 'cancel' AND is_sync_keenio = 1 AND detach_sync_keenio = 0 and DETACH_SYNC_KEENIO_VERIFIED = 0 ORDER BY R.DATENEW desc fetch first 1000 rows only";
        return this.orderLoaderByQuery(q, false);
    }

    public CategoryInfo addCategory(CategoryInfo category, boolean synchronisation) throws BasicException, SQLException {
        String SQL = "INSERT INTO CATEGORIES (NAME, path, color, order_category, removed, hidden, REF_WEB, APPLY_DISCOUNT, TAXEMP, TAXLV, TAXSP, HIDDEN_BORNE, HIDDEN_CAISSE, MOMENT_CATEGORY, RAW_MATERIAL, SOLD_OUT, PRODUCTS_FIRST, NEXT_AVAILABLE, HAS_DISPLAY_TIME, FIRST_PERIOD, END_PERIOD, AVAILABLE_CAISSE, HIDDEN_UBEREAT, HIDE_NAME_IN_BORNE, HIDDEN_ONLINE, CATEGORY_UBEREAT, OFFSET_PRINT_KITCEHN ,PATH_CATEGORY_MOMENT , type_image_category_moment, ID_GLOBAL, HAS_TIMETABLE, DATE_START_DISPLAY,DATE_END_DISPLAY, IMAGE_URL) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setString(1, category.getName());
        this.pstmt.setString(2, category.getPath());
        this.pstmt.setString(3, category.getColor());
        this.pstmt.setInt(4, category.getOrdercategory());
        this.pstmt.setBoolean(5, category.isRemoved());
        this.pstmt.setBoolean(6, category.isHidden());
        this.pstmt.setString(7, category.getRef_web());
        this.pstmt.setBoolean(8, category.isApply_discount());
        this.pstmt.setString(9, category.getTaxEMP());
        this.pstmt.setString(10, category.getTaxLV());
        this.pstmt.setString(11, category.getTaxSP());
        this.pstmt.setBoolean(12, category.isHidden_borne());
        this.pstmt.setBoolean(13, category.isHidden_caisse());
        this.pstmt.setBoolean(14, category.isMoment_category());
        this.pstmt.setBoolean(15, category.isRaw_material());
        this.pstmt.setBoolean(16, category.isSold_out());
        this.pstmt.setBoolean(17, category.isProducts_first());
        this.pstmt.setBoolean(18, category.isNext_available());
        this.pstmt.setBoolean(19, category.isHas_display_time());
        this.pstmt.setInt(20, category.getFirst_period());
        this.pstmt.setInt(21, category.getEnd_period());
        this.pstmt.setBoolean(22, category.isAvailable_caisse());
        this.pstmt.setBoolean(23, category.isHidden_ubereat());
        this.pstmt.setBoolean(24, category.isHide_name_in_borne());
        this.pstmt.setBoolean(25, category.isHidden_online());
        this.pstmt.setBoolean(26, category.isCategory_ubereat());
        this.pstmt.setInt(27, category.getOffset_print_kitchen());
        this.pstmt.setString(28, category.getPath_category_moment());
        this.pstmt.setString(29, category.getType_image_category_moment());
        this.pstmt.setString(30, category.getId_global());
        this.pstmt.setBoolean(31, category.isHas_timetable());
        Date startDisplay = category.getDateStartDisplay();
        Date endDisplay = category.getDateEndDisplay();
        if (startDisplay != null) {
            this.pstmt.setTimestamp(32, new Timestamp(startDisplay.getTime()));
        } else {
            this.pstmt.setTimestamp(32, null);
        }
        if (endDisplay != null) {
            this.pstmt.setTimestamp(33, new Timestamp(endDisplay.getTime()));
        } else {
            this.pstmt.setTimestamp(33, null);
        }
        this.pstmt.setString(34, category.getImageUrl());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idCategory = -1;
        if (rs.next()) {
            idCategory = rs.getInt(1);
        }
        category.setID(idCategory);
        if (category.getParent_id() != -1) {
            this.setParentCategory(category);
        }
        if (!synchronisation) {
            this.addTagsCatgory(category);
        }
        this.setIdGlobalItem(category.getID(), "CATEGORIES", "ID_GLOBAL", category.getId_global());
        this.persistCategoryDaysOn(category);
        return category;
    }

    public void updateCategory(final CategoryInfo category, boolean synchronization) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  CATEGORIES SET NAME = ?,  path = ?, color = ?, TAXEMP = ?, TAXLV = ?, TAXSP = ?, HIDDEN_BORNE = ?, HIDDEN_CAISSE = ?, MOMENT_CATEGORY = ?, RAW_MATERIAL = ?, SOLD_OUT = ?, PRODUCTS_FIRST = ?, NEXT_AVAILABLE = ?, HAS_DISPLAY_TIME = ?, FIRST_PERIOD = ?, END_PERIOD = ?, AVAILABLE_CAISSE = ?, HIDDEN_UBEREAT = ?, HIDE_NAME_IN_BORNE = ?, HIDDEN_ONLINE = ?, CATEGORY_UBEREAT = ?, OFFSET_PRINT_KITCEHN = ? ,PATH_CATEGORY_MOMENT = ? , type_image_category_moment = ?, HAS_TIMETABLE = ?, DATE_START_DISPLAY = ? , DATE_END_DISPLAY = ?, IMAGE_URL = ?  WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, category.getName());
                this.setString(2, category.getPath());
                this.setString(3, category.getColor());
                this.setString(4, category.getTaxEMP());
                this.setString(5, category.getTaxLV());
                this.setString(6, category.getTaxSP());
                this.setBoolean(7, category.isHidden_borne());
                this.setBoolean(8, category.isHidden_caisse());
                this.setBoolean(9, category.isMoment_category());
                this.setBoolean(10, category.isRaw_material());
                this.setBoolean(11, category.isSold_out());
                this.setBoolean(12, category.isProducts_first());
                this.setBoolean(13, category.isNext_available());
                this.setBoolean(14, category.isHas_display_time());
                this.setInt(15, category.getFirst_period());
                this.setInt(16, category.getEnd_period());
                this.setBoolean(17, category.isAvailable_caisse());
                this.setBoolean(18, category.isHidden_ubereat());
                this.setBoolean(19, category.isHide_name_in_borne());
                this.setBoolean(20, category.isHidden_online());
                this.setBoolean(21, category.isCategory_ubereat());
                this.setInt(22, category.getOffset_print_kitchen());
                this.setString(23, category.getPath_category_moment());
                this.setString(24, category.getType_image_category_moment());
                this.setBoolean(25, category.isHas_timetable());
                this.setTimestamp(26, category.getDateStartDisplay());
                this.setTimestamp(27, category.getDateEndDisplay());
                this.setString(28, category.getImageUrl());
                this.setInt(29, category.getID());
            }
        });
        if (!synchronization) {
            if (category.getParent_id() != -1) {
                this.setParentCategory(category);
            } else {
                this.setParentCategoryNull(category);
            }
            this.persistTagsCatgory(category);
        }
        this.persistCategoryDaysOn(category);
        this.persistShiftCategories(category);
    }

    public void setParentCategory(final CategoryInfo category) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  CATEGORIES SET PARENTID = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category.getParent_id());
                this.setInt(2, category.getID());
            }
        });
    }

    public void setParentCategoryNull(final CategoryInfo category) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  CATEGORIES SET PARENTID =null WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category.getID());
            }
        });
    }

    public List<ProductDayOn> getProductDaysOn(int idProduct) throws BasicException {
        return new PreparedSentence(this.s, this.requestProductDaysOn + "WHERE  ID_PRODUCT = ?", SerializerWriteInteger.INSTANCE, ProductDayOn.getSerializerRead()).list((Object)idProduct);
    }

    public void addProductDayOn(final ProductDayOn mProductTimeTable) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO  PRODUCT_DAYS_ON(DAY_OF_WEEK, ID_PRODUCT) VALUES(?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, mProductTimeTable.getDay_of_week());
                this.setInt(2, mProductTimeTable.getId_product());
            }
        });
    }

    public void deleteProductDayOn(final ProductDayOn mProductTimeTable) throws BasicException {
        new PreparedSentence(this.s, "delete from PRODUCT_DAYS_ON  WHERE DAY_OF_WEEK = ? and ID_PRODUCT = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, mProductTimeTable.getDay_of_week());
                this.setInt(2, mProductTimeTable.getId_product());
            }
        });
    }

    public void deleteProductDaysOn(final ProductInfoExt product) throws BasicException {
        new PreparedSentence(this.s, "delete from PRODUCT_DAYS_ON  WHERE ID_PRODUCT = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, product.getID());
            }
        });
    }

    public void addProductDaysOn(ProductInfoExt product) throws BasicException {
        if (product.getDaysOn() != null && !product.getDaysOn().isEmpty()) {
            for (ProductDayOn productDayOn : product.getDaysOn()) {
                productDayOn.setId_product(product.getID());
                this.addProductDayOn(productDayOn);
            }
        }
    }

    public void persistProductDaysOn(ProductInfoExt product) throws BasicException {
        List<ProductDayOn> oldProductDaysOn = this.getProductDaysOn(product.getID());
        if (product.getDaysOn() == null || product.getDaysOn().isEmpty()) {
            if (oldProductDaysOn != null && !oldProductDaysOn.isEmpty()) {
                this.deleteProductDaysOn(product);
            }
        } else {
            int found;
            for (ProductDayOn oldProductDayOn : oldProductDaysOn) {
                found = -1;
                for (ProductDayOn newProductDayOn : product.getDaysOn()) {
                    if (oldProductDayOn.getDay_of_week() != newProductDayOn.getDay_of_week()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                this.deleteProductDayOn(oldProductDayOn);
            }
            for (ProductDayOn newProductDayOn : product.getDaysOn()) {
                found = -1;
                for (ProductDayOn oldProductDayOn : oldProductDaysOn) {
                    if (oldProductDayOn.getDay_of_week() != newProductDayOn.getDay_of_week()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                newProductDayOn.setId_product(product.getID());
                this.addProductDayOn(newProductDayOn);
            }
        }
    }

    public List<SupplementItemInfo> getAllSupplementItems() throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + " JOIN supplement G ON G.id = S.id_supplement WHERE G.is_ingredient = 0 ", null, SupplementItemInfo.getSerializerRead()).list();
    }

    public List<ProductInfoExt> getProductsWithSpaceInImage() throws BasicException {
        List products = new PreparedSentence(this.s, this.requestProducts + " where P.path like '% %'", null, ProductInfoExt.getSerializerRead()).list();
        return products;
    }

    public final List<CategoryInfo> getCategoriesWithSpaceInImage() throws BasicException {
        List categories = new PreparedSentence(this.s, this.requestCategory + "  where C.path like '% %'", null, CategoryInfo.getSerializerRead()).list();
        return categories;
    }

    public List<SupplementInfo> getSupplementsWithSpaceInImage() throws BasicException {
        return new PreparedSentence(this.s, this.requestSupplement + "  where S.path like '% %'", null, SupplementInfo.getSerializerRead()).list();
    }

    public List<SupplementItemInfo> getSuppelementItemsWithSpaceInImage() throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + " JOIN supplement G ON G.id = S.id_supplement WHERE G.is_ingredient = 0 and  S.path like '% %'", null, SupplementItemInfo.getSerializerRead()).list();
    }

    public void updatePathItem(String name_table, final int id_product, final String path) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  " + name_table + " SET PATH = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, path);
                this.setInt(2, id_product);
            }
        });
    }

    public final SupplementInfo getIngredient() throws BasicException {
        return (SupplementInfo)new PreparedSentence(this.s, this.requestSupplement + "WHERE S.is_ingredient = 1 AND S.removed = 0 and S.REMOVED_BY_ADMIN = 0", null, SupplementInfo.getSerializerRead()).find();
    }

    public List<ProductInfoExt> getProductsWithPoints(String type, TagInfo mTagInfo) throws BasicException {
        String request = "";
        switch (type) {
            case "Sur Place": {
                request = "P.sp= 1";
                break;
            }
            case "A Emporter": {
                request = "P.emp= 1";
            }
        }
        final int dayOfWeek = DateUtils.getDayOfWeek();
        String requestSql = this.requestProducts + "JOIN CATEGORIES C ON P.CATEGORY = C.ID WHERE C.REMOVED_BY_ADMIN = 0 AND C.removed = 0 AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.PRODUCT_LOYALTY = 1 AND P.HIDDEN_BORNE = 0 AND P.PRODUCT_UBEREAT = 0  AND (P.HAS_TIMETABLE = 0 OR P.ID IN (SELECT PD.ID_PRODUCT from PRODUCT_DAYS_ON PD where PD.DAY_OF_WEEK = ?)) AND " + request + this.request_campaign_product;
        if (mTagInfo != null) {
            requestSql = requestSql + " AND P.CATEGORY IN (select TC.ID_CATEGORY from TAGS_CATEGORIES TC JOIN TAGS T ON TC.ID_TAG = T.ID WHERE TC.ID_TAG = " + mTagInfo.getId() + ") ";
        }
        requestSql = requestSql + " ORDER BY  P.PRICE_POINT desc ";
        List products = new PreparedSentence(this.s, requestSql, SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, dayOfWeek);
            }
        });
        for (ProductInfoExt product : products) {
            product.setListSizes(this.getProductSizes(product.getID(), true));
            product.setAdditional_sales(this.getAdditionalSales(product.getID(), true));
            product.setSub_products(this.getSubProducts(product.getID(), true));
            for (ProductInfoExt product_additional : product.getAdditional_sales()) {
                product_additional.setListSizes(this.getProductSizes(product_additional.getID(), true));
                product_additional.setPrices(this.getProductPrices(product_additional.getID(), true));
                List<ImageProduct> images = this.imageProductService.getImages(product_additional.getID());
                product_additional.setImages(images);
                List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product_additional.getID());
                product_additional.setMultiLanguageTexts(multiLanguageTexts);
            }
            product.setPrices(this.getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return products;
    }

    public List<SupplementItemInfo> getAllIngredients() throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + " JOIN supplement G ON G.id = S.id_supplement WHERE G.is_ingredient = 1 ", null, SupplementItemInfo.getSerializerRead()).list();
    }

    public List<SupplementItemInfo> getIngredientsWithSpaceInImage() throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + " JOIN supplement G ON G.id = S.id_supplement WHERE G.is_ingredient = 1 and S.path like '% %'", null, SupplementItemInfo.getSerializerRead()).list();
    }

    public void setSoldOutAndHidden(final int product_id, final boolean sold_out) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ?, HIDDEN_BORNE = ?, HIDDEN_UBEREAT = ?, HIDDEN_ONLINE = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, sold_out);
                this.setBoolean(3, sold_out);
                this.setBoolean(4, sold_out);
                this.setInt(5, product_id);
            }
        });
    }

    public void setHiddenOnline(final int product_id, final boolean hidden_online) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_ONLINE = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, hidden_online);
                this.setInt(2, product_id);
            }
        });
    }

    public void setHiddenBorne(final int product_id, final boolean hidden_borne) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_BORNE = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, hidden_borne);
                this.setInt(2, product_id);
            }
        });
    }

    public void setHiddenUberEats(final int product_id, final boolean hidden_ubereats) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_UBEREAT = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, hidden_ubereats);
                this.setInt(2, product_id);
            }
        });
    }

    public void setSoldOutTemporary(final int product_id, final boolean sold_out, boolean sold_out_supers) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ?, HIDDEN_BORNE = ?, HIDDEN_UBEREAT = ?, HIDDEN_ONLINE = ?, SOLD_OUT_TEMPORARY = ?, HIDDEN_BORNE_TEMPORARY = ?, HIDDEN_UBEREAT_TEMPORARY = ?, HIDDEN_ONLINE_TEMPORARY = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, sold_out);
                this.setBoolean(3, sold_out);
                this.setBoolean(4, sold_out);
                this.setBoolean(5, sold_out);
                this.setBoolean(6, sold_out);
                this.setBoolean(7, sold_out);
                this.setBoolean(8, sold_out);
                this.setInt(9, product_id);
            }
        });
        if (sold_out && sold_out_supers) {
            this.setSoldOutProductsTemporary(product_id);
        }
    }

    public void setHiddenOnlineTemporary(final int product_id, final boolean hidden_online) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_ONLINE = ?, HIDDEN_ONLINE_TEMPORARY =?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, hidden_online);
                this.setBoolean(2, hidden_online);
                this.setInt(3, product_id);
            }
        });
    }

    public void setHiddenBorneTemporary(final int product_id, final boolean hidden_borne) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_BORNE = ?, HIDDEN_BORNE_TEMPORARY = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, hidden_borne);
                this.setBoolean(2, hidden_borne);
                this.setInt(3, product_id);
            }
        });
    }

    public void setHiddenUberEatsTemporary(final int product_id, final boolean hidden_ubereats) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_UBEREAT = ?, HIDDEN_UBEREAT_TEMPORARY = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, hidden_ubereats);
                this.setBoolean(2, hidden_ubereats);
                this.setInt(3, product_id);
            }
        });
    }

    public void setEnableProducts() throws BasicException {
        final boolean sold_out = false;
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ?, HIDDEN_BORNE = ?, HIDDEN_UBEREAT = ?, HIDDEN_ONLINE = ?, SOLD_OUT_TEMPORARY = ?, HIDDEN_BORNE_TEMPORARY = ?, HIDDEN_UBEREAT_TEMPORARY = ?, HIDDEN_ONLINE_TEMPORARY = ?  WHERE SOLD_OUT_TEMPORARY = 1", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, sold_out);
                this.setBoolean(3, sold_out);
                this.setBoolean(4, sold_out);
                this.setBoolean(5, sold_out);
                this.setBoolean(6, sold_out);
                this.setBoolean(7, sold_out);
                this.setBoolean(8, sold_out);
            }
        });
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_UBEREAT = ?, HIDDEN_UBEREAT_TEMPORARY = ?  WHERE HIDDEN_UBEREAT_TEMPORARY = 1", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, sold_out);
            }
        });
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_BORNE = ?, HIDDEN_BORNE_TEMPORARY = ? WHERE HIDDEN_BORNE_TEMPORARY = 1", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, sold_out);
            }
        });
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET HIDDEN_ONLINE = ?, HIDDEN_ONLINE_TEMPORARY =?  WHERE HIDDEN_ONLINE_TEMPORARY = 1", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, sold_out);
            }
        });
    }

    public List<ProductInfoExt> getSuperProducts(int id_sub_product) throws BasicException {
        List products = new PreparedSentence(this.s, this.requestProducts + "JOIN SUB_PRODUCTS SP  ON P.ID = SP.ID_PRODUCT_PARENT WHERE SP.ID_PRODUCT = ?  ORDER BY  P.order_item ", SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)id_sub_product);
        return products;
    }

    private void setSoldOutProductsTemporary(int product_id) throws BasicException {
        List<ProductInfoExt> products = this.getSuperProducts(product_id);
        for (ProductInfoExt product : products) {
            this.setSoldOutTemporary(product.getID(), true, false);
        }
    }

    public final ProductInfoExt getProduct(String ref_web) throws BasicException {
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE P.REF_WEB = ? ", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)ref_web);
        return product;
    }

    public void setSourceOrderSynchronized(final String id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS SET IS_SYNC_SOURCE_ORDER = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, true);
                this.setString(2, id);
            }
        });
    }

    public List<TicketInfo> loadOrderToSynchSource(int rows) throws BasicException {
        String q = this.requestTicket + "WHERE T.paid = 1 AND T.STATUS <> 'cancel' AND T.STATUS <> 'Refund' AND is_sync_keenio = 1 AND detach_sync_keenio = 0 and IS_SYNC_SOURCE_ORDER = 0 ORDER BY T.TICKETID desc fetch first " + rows + " rows only";
        return this.orderLoaderByQuery(q, false);
    }

    public void addScreenProduct(final ScreenProduct screen) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SCREENS_PRODUCT(ID_PRODUCT, ID_SCREEN, IS_ID_UPDATED) VALUES(?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, screen.getId_product());
                this.setInt(2, screen.getId_screen());
                this.setBoolean(3, true);
            }
        });
    }

    public void deleteScreenProduct(final int id_product, final int id_screen) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SCREENS_PRODUCT WHERE ID_PRODUCT = ? AND ID_SCREEN = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_product);
                this.setInt(2, id_screen);
            }
        });
    }

    private void deleteScreenProduct(ScreenProduct screen) throws BasicException {
        this.deleteScreenProduct(screen.getId_product(), screen.getId_screen());
    }

    public void addScreensProduct(ProductInfoExt product) throws BasicException {
        for (ScreenProduct screen : product.getScreens()) {
            if (screen.getId() != -1) continue;
            screen.setId_product(product.getID());
            this.addScreenProduct(screen);
        }
    }

    public void persistScreensProduct(ProductInfoExt product) throws BasicException {
        List<ScreenProduct> oldScreens = this.getScreenByProduct(product.getID());
        for (ScreenProduct oldScreen : oldScreens) {
            int found = -1;
            for (ScreenProduct screen : product.getScreens()) {
                if (oldScreen.getId() != screen.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteScreenProduct(oldScreen);
        }
        this.addScreensProduct(product);
    }

    public void updateIdScreen(final int new_screen, final int old_screen) throws BasicException {
        new PreparedSentence(this.s, "UPDATE SCREENS_PRODUCT SET  ID_SCREEN = ? , IS_ID_UPDATED = 1 WHERE ID_SCREEN = ? AND IS_ID_UPDATED = 0", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, new_screen);
                this.setInt(2, old_screen);
            }
        });
    }

    public int countScreenProduct(int id_screen) throws SQLException {
        int number = 0;
        String SQL = "SELECT COUNT(*) as number from SCREENS_PRODUCT where ID_SCREEN = ?";
        this.pstmt = this.s.getConnection().prepareStatement(SQL);
        this.pstmt.setInt(1, id_screen);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            number = rs.getInt("number");
        }
        return number;
    }

    public void deleteProductScreen() throws BasicException {
        new PreparedSentence(this.s, "delete from SCREENS_PRODUCT", null).exec();
    }

    public void deployScreens(CategoryInfo category, LocalScreen screen) throws BasicException {
        List<ProductInfoExt> products = super.getProducts(category.getID());
        for (ProductInfoExt product : products) {
            List<ScreenProduct> oldScreens = this.getScreenByProduct(product.getID());
            int found = -1;
            for (ScreenProduct oldScreen : oldScreens) {
                if (oldScreen.getId_screen() != screen.getId().intValue()) continue;
                found = 1;
            }
            if (found != -1) continue;
            ScreenProduct screenTmp = new ScreenProduct(-1, product.getID(), screen.getId(), screen.getName(), screen.getNumber());
            this.addScreenProduct(screenTmp);
        }
    }

    public void deployMarque(CategoryInfo category, int marque) throws BasicException {
        System.out.println("+++++++++++++++++ marque :" + marque);
        List<ProductInfoExt> products = super.getProducts(category.getID());
        for (ProductInfoExt product : products) {
            product.setMarque(marque);
            this.updateItemProduct(product);
        }
    }

    public void setSoldOutAndHiddenOption(final int option_id, final boolean sold_out) throws BasicException {
        new PreparedSentence(this.s, "UPDATE supplement_item SET  SOLD_OUT = ?, HIDDEN_BORNE = ?, HIDDEN_UBEREAT = ?, HIDDEN_ONLINE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, sold_out);
                this.setBoolean(3, sold_out);
                this.setBoolean(4, sold_out);
                this.setInt(5, option_id);
            }
        });
    }

    public void updateStatusOption(int option_id, final boolean sold_out, boolean hidden_borne, String id_global) throws BasicException {
        String request_ref_synchro = id_global != null && !id_global.isEmpty() ? "ITEM_PLU = ?" : "REF_WEB = ?";
        final String ref_synchro = id_global != null && !id_global.isEmpty() ? id_global : String.valueOf(option_id);
        new PreparedSentence(this.s, "UPDATE supplement_item SET  SOLD_OUT = ?, HIDDEN_BORNE = ? WHERE " + request_ref_synchro, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setBoolean(2, sold_out);
                this.setString(3, ref_synchro);
            }
        });
    }

    public List<SupplementItemInfo> getSuppelementsItem(int id_supplement, boolean catalog) throws BasicException {
        return this.getSuppelementsItem(id_supplement, catalog, catalog);
    }

    public List<GrandTotalPeriode> getGTPByPeriodeArchive(String typePeriode, Date myDate) throws BasicException {
        int myDay = myDate.getDate();
        int myMonth = myDate.getMonth() + 1;
        int myYear = myDate.getYear() + 1900;
        final String year_period = myYear + "%";
        if (typePeriode.equals("j")) {
            final String idGTP = DateUtils.SDF_ID_DAY_PERIOD.format(myDate);
            return new PreparedSentence(this.s, this.requestGTP + "WHERE  ID like ?  order by CAST (id AS INTEGER)  ", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, idGTP);
                }
            });
        }
        if (typePeriode.equals("m")) {
            StringBuilder monthBuilder = new StringBuilder();
            monthBuilder.append(DateUtils.SDF_ID_MONTH_PERIOD.format(myDate));
            monthBuilder.append("%");
            final String month_period = monthBuilder.toString();
            System.out.println("+++++++++++++++++ month_period : " + month_period);
            return new PreparedSentence(this.s, this.requestGTP + "WHERE ID like ?  order by CAST (id AS INTEGER)   ", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, month_period);
                }
            });
        }
        return new PreparedSentence(this.s, this.requestGTP + "WHERE  ID like ? order by CAST (id AS INTEGER)   ", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, year_period);
            }
        });
    }

    public List<LineNote> getLinesNoteByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestLinesNote + "WHERE  timestampGDH >= ? and  timestampGDH < ?   ", SerializerWriteParams.INSTANCE, LineNote.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<ProductInfoExt> getProductsWithSizes() throws BasicException {
        return new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.many_size = 1 ", null, ProductInfoExt.getSerializerRead()).list();
    }

    public void setOrderSize(final ProductSizeInfo productSize) throws BasicException {
        final int size_order = AppConstants.mapOrderSizes.get((Object)productSize.getName()) != null ? (Integer)AppConstants.mapOrderSizes.get((Object)productSize.getName()) : 0;
        new PreparedSentence(this.s, "UPDATE PRODUCTS_SIZE SET ORDER_SIZE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, size_order);
                this.setInt(2, productSize.getID());
            }
        });
    }

    public List<ProductPriceInfo> getProductPrices(final int idProduct, final boolean filter_by_tariff) throws BasicException {
        String requestTariff = filter_by_tariff ? " AND P.TARIFF = ? " : "";
        return new PreparedSentence(this.s, this.requestProductPrice + "WHERE  P.PRODUCT = ? " + requestTariff, SerializerWriteParams.INSTANCE, ProductPriceInfo.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idProduct);
                if (filter_by_tariff) {
                    this.setInt(2, AppLocal.TARIFF);
                }
            }
        });
    }

    public void addProductPrice(final ProductPriceInfo mProductPriceInfo) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PRODUCTS_PRICES (PRICE, TYPE_ORDER, TARIFF, PRODUCT) VALUES (?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, mProductPriceInfo.getPrice());
                this.setString(2, mProductPriceInfo.getType_order());
                this.setInt(3, mProductPriceInfo.getTariff());
                this.setInt(4, mProductPriceInfo.getIdProduct());
            }
        });
    }

    public void updateProductPrice(final ProductPriceInfo mProductPriceInfo) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS_PRICES SET PRICE = ?, TYPE_ORDER = ?, TARIFF = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, mProductPriceInfo.getPrice());
                this.setString(2, mProductPriceInfo.getType_order());
                this.setInt(3, mProductPriceInfo.getTariff());
                this.setInt(4, mProductPriceInfo.getId());
            }
        });
    }

    public void persistPricesProduct(ProductInfoExt product) throws BasicException {
        List<ProductPriceInfo> oldPrices = this.getProductPrices(product.getID(), false);
        for (ProductPriceInfo oldPrice : oldPrices) {
            int found = -1;
            for (ProductPriceInfo productPrice : product.getPrices()) {
                if (productPrice.getId() != oldPrice.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteProductPrice(oldPrice.getId());
        }
        for (ProductPriceInfo productPrice : product.getPrices()) {
            if (productPrice.getId() == -1 || productPrice.getId() == 0) {
                productPrice.setIdProduct(product.getID());
                this.addProductPrice(productPrice);
                continue;
            }
            this.updateProductPrice(productPrice);
        }
    }

    public List<ProductInfoExt> getProductsWithDifferentPrice() throws BasicException {
        return new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.different_price = 1 ", null, ProductInfoExt.getSerializerRead()).list();
    }

    public void deleteProductPrice(final int id_product_price) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM PRODUCTS_PRICES  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_product_price);
            }
        });
    }

    public void updateImageUber(int productID, String path2) throws BasicException {
        this.imageProductService.setImagePlatform(productID, path2);
    }

    public List<ProductInfoExt> getMomentProducts(TagInfo mTagInfo) throws BasicException {
        String request_opening_mode = AppLocal.OPENING_MODE ? " AND P.ENABLE_IN_OPENING = 1 " : "";
        String requestSql = this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.moment_product = 1 AND P.HIDDEN_BORNE = 0 AND P.SOLD_OUT = 0 AND P.PRODUCT_UBEREAT = 0  AND P.CATEGORY NOT IN (select ID FROM CATEGORIES WHERE REMOVED_BY_ADMIN = 1 OR removed = 1) " + request_opening_mode + this.request_campaign_product;
        if (mTagInfo != null) {
            requestSql = requestSql + " AND P.CATEGORY IN (select TC.ID_CATEGORY from TAGS_CATEGORIES TC JOIN TAGS T ON TC.ID_TAG = T.ID WHERE TC.ID_TAG = " + mTagInfo.getId() + ") ";
        }
        requestSql = requestSql + "ORDER BY  P.order_item ";
        List products = new PreparedSentence(this.s, requestSql, null, ProductInfoExt.getSerializerRead()).list();
        return products;
    }

    public List<ProductInfoExt> getAdditionnalProducts(String type_order) throws BasicException {
        String request = type_order != null && type_order.equals("A Emporter") ? "P.ADDITIONAL_SALE_TAKE_AWAY = 1 " : "P.ADDITIONAL_SALE_AT_SPOT = 1 ";
        return new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND P.SOLD_OUT = 0 AND P.HIDDEN_BORNE = 0 AND P.PRODUCT_UBEREAT = 0 AND AVAILABLE_CAISSE = 0 AND " + request + this.request_campaign_product + "ORDER BY  P.order_item ", null, ProductInfoExt.getSerializerRead()).list();
    }

    public List<GrandTotalPeriode> loadGrandTotalPeriod(final String type) throws BasicException {
        ArrayList<GrandTotalPeriode> listTotaux = new PreparedSentence(this.s, this.requestGTP + " WHERE type_PERIODE = ? and ISSYNCHRONIZED = 0 order by timestampGDH DESC", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type);
            }
        });
        if (listTotaux == null) {
            listTotaux = new ArrayList<GrandTotalPeriode>();
        }
        for (GrandTotalPeriode grandTotalPeriode : listTotaux) {
            grandTotalPeriode.setGtpTaxes(this.getGTPTaxes(grandTotalPeriode.getId()));
            if (type == null || !type.equalsIgnoreCase("j")) continue;
            try {
                this.setTvasUber(grandTotalPeriode);
            }
            catch (ParseException ex) {
                LogToFile.log("severe", null, ex);
            }
        }
        return listTotaux;
    }

    public void updateIsSynchronisedCloture(final String idCloture) {
        try {
            new PreparedSentence(this.s, "UPDATE  GRAND_TOTAL_PERIODE SET ISSYNCHRONIZED = ?, STATS_UPDATED = ?, NB_PLATFORM_STATS_UPDATED = ? , CASHLOGY_UPDATED =? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setBoolean(2, true);
                    this.setBoolean(3, true);
                    this.setBoolean(4, true);
                    this.setString(5, idCloture);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateSynchroLogPanier(final int idLogPanier) {
        try {
            new PreparedSentence(this.s, "UPDATE  LOG_PANIER SET IS_SYNCHRO = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setInt(2, idLogPanier);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public final List<TagInfo> getTagsByCategory(int category) throws BasicException {
        return new PreparedSentence(this.s, "SELECT T.ID, T.NAME, T.NUMBER, T.DELETED, T.ENABLED, T.CLOSED, T.LOGO_TAG, T.BACKGROUND_CATALOG FROM TAGS T JOIN TAGS_CATEGORIES TC ON T.ID = TC.ID_TAG WHERE TC.ID_CATEGORY = ? ", SerializerWriteInteger.INSTANCE, TagInfo.getSerializerRead()).list((Object)category);
    }

    public void addTagsCatgory(CategoryInfo category) throws BasicException {
        for (TagInfo mTagInfo : category.getTags()) {
            this.addTagCategory(mTagInfo, category.getID());
        }
    }

    public void addTagCategory(final TagInfo tagInfo, final int idCatgory) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO TAGS_CATEGORIES(ID_CATEGORY, ID_TAG) VALUES(?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idCatgory);
                this.setInt(2, tagInfo.getId());
            }
        });
    }

    public void persistTagsCatgory(CategoryInfo category) throws BasicException {
        int found;
        List<TagInfo> oldTags = this.getTagsByCategory(category.getID());
        for (TagInfo oldTag : oldTags) {
            found = -1;
            for (TagInfo newTag : category.getTags()) {
                if (oldTag.getId() != newTag.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.deleteTagCategory(category.getID(), oldTag.getId());
        }
        for (TagInfo newTag : category.getTags()) {
            found = -1;
            for (TagInfo oldTag : oldTags) {
                if (oldTag.getId() != newTag.getId()) continue;
                found = 1;
            }
            if (found != -1) continue;
            this.addTagCategory(newTag, category.getID());
        }
    }

    public void deleteTagCategory(final int id_category, final int id_tag) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM TAGS_CATEGORIES WHERE ID_CATEGORY = ? AND ID_TAG = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_category);
                this.setInt(2, id_tag);
            }
        });
    }

    public final List<String> loadPostgreOrderIdsNotSynchronized(int rows) throws BasicException {
        String q = "SELECT T.ID  FROM TICKETS T LEFT JOIN GRAND_TOTAL G ON T.ID = G.TICKET WHERE ((T.paid = 1 and G.TICKET IS NOT NULL ) or (T.paid = 0 and T.platform_order = 1 and T.sent_from <> 'Dishop'))AND T.STATUS <> 'Refund' AND T.is_sync_postgre = 0 and sendorder_progress <> 'Pending' and SENDORDER_PROGRESS <> 'preSending' ORDER BY T.TICKETID desc fetch first " + rows + " rows only";
        ArrayList<String> mList = new ArrayList<String>();
        List recsales = new PreparedSentence(this.s, q, null, new SerializerReadBasic(new Datas[]{Datas.STRING})).list();
        if (recsales != null) {
            for (Object[] next : recsales) {
                if (next == null || next.length <= 0) continue;
                mList.add((String)next[0]);
            }
        }
        return mList;
    }

    public final TicketInfo fetchPostgreTicketNotSynchronized(final String ticketID, boolean has_detail) throws BasicException {
        String q = "SELECT T.ID, T.TICKETTYPE, T.TICKETID, T.type, T.modePayment, T.tempsLv, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, " + DAOConstants.SQLFunction + "(T.CUSTOMER, -1) as CUSTOMER, T.STATUS, T.total, " + DAOConstants.SQLFunction + "(T.address, -1) as address, T.numero_order, " + DAOConstants.SQLFunction + "(T.idTable, -1) as idTable, T.discount, T.typediscount, T.bipper, T.transferred, T.reason_cancel, " + DAOConstants.SQLFunction + "(T.invoice , 0) as invoice , PL.ID as ID_LIVREUR, PL.NAME as NAME_LIVREUR, " + DAOConstants.SQLFunction + "(T.canceled_ticket_id_Int,0) as OrigineTicket,T.accepted, T.paid ,T.last_update, T.couverts, T.SOURCE_ORDER, T.NAME_CUSTOMER, T.date_paid, T.closed, T.canceled_ticket_id," + DAOConstants.SQLFunction + "(T.num_order_kitchen, -1) as num_order_kitchen, CU.ID, T.ORDERED_FROM, T.ID_ORDER_KITCHEN, T.SENT_FROM, T.NUMERO_ONLINE_ORDER, T.PRINT_AFTER_UPDATE, T.NUM_TABLE, T.NUM_PLATFORM_ORDER, T.LABEL_DISCOUNT, T.ID_SHARED_ORDER, T.DELIVERED_AT, T.LICENCE_ID_MACHINE, T.CUSTOMER_LOYALTY_VERIFIED, T.EASEL_NUMBER, T.PLATFORM_ORDER, T.SHARED_ORDER, T.ORDER_ID_BASE, T.KEENIO_BASE_ORDER, T.TAKE_AWAY_PHONE, T.TPS, T.TVQ, T.session_id,T.tag_erc_stan,  T.eft_stan,  T.last_digit,  T.EcrDateTime, T.holder FROM RECEIPTS R LEFT JOIN TICKETS T ON R.ID = T.ID LEFT JOIN caisse C ON T.caisse = C.ID LEFT JOIN PEOPLE P ON T.PERSON = P.ID LEFT JOIN PEOPLE PL ON T.livreur = PL.ID LEFT JOIN COUNTER_USER CU ON P.ID = CU.ID_USER LEFT JOIN GRAND_TOTAL G ON T.ID = G.TICKET WHERE T.ID = ? AND ((T.paid = 1 and G.TICKET IS NOT NULL ) or (T.paid = 0 and T.platform_order = 1 and T.sent_from <> 'Dishop')) AND T.STATUS <> 'Refund' AND  T.is_sync_postgre = 0 and SENDORDER_PROGRESS <> 'Pending' ";
        TicketInfo mTicket = (TicketInfo)new PreparedSentence(this.s, q, SerializerWriteParams.INSTANCE, new SerializerReadClass(TicketInfo.class)).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticketID);
            }
        });
        if (has_detail && mTicket != null) {
            this.fillTicketInfo(mTicket);
        }
        return mTicket;
    }

    public void updateOrderSynchro(final String idTicket, final boolean sync) {
        try {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET is_sync_postgre = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, sync);
                    this.setString(2, idTicket);
                }
            });
            System.out.println("+++++++++++++++++++++++++++++ sync : " + sync);
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateOrderProgress(final String idTicket, final String status) {
        try {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET sendorder_progress = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, status);
                    this.setString(2, idTicket);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateCancledPostgre(final String idTicket) {
        try {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET is_sync_cancled = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setString(2, idTicket);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateProgress() throws BasicException {
        new StaticSentence(this.s, "UPDATE TICKETS SET sendorder_progress = 'Started' where  is_sync_postgre =0 ", null).exec();
    }

    public List<TicketInfo> CancledloadOrder() throws BasicException {
        String q = "SELECT T.ID, T.TICKETTYPE, T.TICKETID, T.type, T.modePayment, T.tempsLv, R.DATENEW, R.MONEY, R.ATTRIBUTES, P.ID, P.NAME, " + DAOConstants.SQLFunction + "(T.CUSTOMER, -1) as CUSTOMER, T.STATUS, T.total, " + DAOConstants.SQLFunction + "(T.address, -1) as address,T.numero_order, " + DAOConstants.SQLFunction + "(T.idTable, -1) as idTable,T.discount, T.typediscount, T.bipper, T.transferred, T.reason_cancel, " + DAOConstants.SQLFunction + "(T.invoice , 0) as invoice , PL.ID as ID_LIVREUR, PL.NAME as NAME_LIVREUR, " + DAOConstants.SQLFunction + "(T.canceled_ticket_id_Int,0) as OrigineTicket, T.accepted, T.paid ,T.last_update, T.couverts, T.SOURCE_ORDER, T.NAME_CUSTOMER, T.date_paid, T.closed, T.canceled_ticket_id, " + DAOConstants.SQLFunction + "(T.num_order_kitchen, -1) as num_order_kitchen, CU.ID, T.ORDERED_FROM, T.ID_ORDER_KITCHEN, T.SENT_FROM, T.NUMERO_ONLINE_ORDER, T.PRINT_AFTER_UPDATE, T.NUM_TABLE, T.NUM_PLATFORM_ORDER, T.LABEL_DISCOUNT,  T.ID_SHARED_ORDER, T.DELIVERED_AT, T.LICENCE_ID_MACHINE, T.CUSTOMER_LOYALTY_VERIFIED, T.EASEL_NUMBER, T.PLATFORM_ORDER, T.SHARED_ORDER, T.ORDER_ID_BASE, T.KEENIO_BASE_ORDER, T.TAKE_AWAY_PHONE, T.TPS, T.TVQ, T.session_id,T.tag_erc_stan,  T.eft_stan,  T.last_digit,  T.EcrDateTime, T.holder FROM RECEIPTS R JOIN TICKETS T ON R.ID = T.ID JOIN caisse C ON T.caisse = C.ID LEFT OUTER JOIN PEOPLE P ON T.PERSON = P.ID LEFT OUTER JOIN PEOPLE PL ON T.livreur = PL.ID LEFT JOIN COUNTER_USER CU ON P.ID = CU.ID_USER WHERE STATUS = 'cancel' AND (T.paid = 1 or (T.PLATFORM_ORDER = 1 and  (T.SENT_FROM is null or T.SENT_FROM <> 'Dishop'))) and is_sync_cancled =0 ORDER BY R.DATENEW desc fetch first 500 rows only";
        return this.orderLoaderByQuery(q, false);
    }

    private String getRequestIds(List<String> idTickets) {
        Object request = "(";
        boolean first = true;
        for (String idTicket : idTickets) {
            if (!first) {
                request = (String)request + ",";
            }
            request = (String)request + "'" + idTicket + "'";
            first = false;
        }
        request = (String)request + ")";
        return request;
    }

    public void updateOrderProgress(List<String> idTickets, final String status) {
        String request = this.getRequestIds(idTickets);
        try {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET sendorder_progress = ? WHERE ID in " + request, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, status);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void deployAdditionalSales(CategoryInfo category, List<ProductInfoExt> additionalSalesCategory) throws BasicException {
        List<ProductInfoExt> products = super.getProducts(category.getID());
        for (ProductInfoExt product : products) {
            List<ProductInfoExt> oldAdditionalSales = this.getAllAdditionalSales(product.getID());
            for (ProductInfoExt newAdditionalSale : additionalSalesCategory) {
                int found = -1;
                for (ProductInfoExt oldAddionalSale : oldAdditionalSales) {
                    if (oldAddionalSale.getID() != newAdditionalSale.getID()) continue;
                    found = 1;
                }
                if (found != -1 || newAdditionalSale.getID() == -1) continue;
                this.addAdditionalSale(product, newAdditionalSale);
            }
        }
    }

    public void updateIsSynchronisedClient(final int idClient) {
        try {
            new PreparedSentence(this.s, "UPDATE  CUSTOMERS SET ISSYNCHROCLIENT = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setInt(2, idClient);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateIsSynchronisedAddress(final int idAddress) {
        try {
            new PreparedSentence(this.s, "UPDATE  ADRESSECLIENT SET ISSYNCHROADDRESS = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setInt(2, idAddress);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public SupplementItemInfo getSuppelementByName(String name) throws BasicException {
        return (SupplementItemInfo)new PreparedSentence(this.s, this.requestSuppItem + "WHERE S.name = ? ", SerializerWriteString.INSTANCE, SupplementItemInfo.getSerializerRead()).find((Object)name);
    }

    public ProductInfoExt getProductInfoByName(String name_product, boolean without_filter) throws BasicException {
        String request_filter = without_filter ? "" : "P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0 AND ";
        ProductInfoExt product = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE " + request_filter + " UPPER(P.name) = ? ", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)name_product);
        if (product != null) {
            product.setSub_products(this.getSubProducts(product.getID(), false));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return product;
    }

    public List<GrandTotalPeriode> loadGrandTotalPeriodToUpdate(final String type) throws BasicException {
        ArrayList listTotaux = new PreparedSentence(this.s, this.requestGTP + " WHERE type_PERIODE = ? and ISSYNCHRONIZED = 1 and STATS_UPDATED = 0  order by timestampGDH DESC", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type);
            }
        });
        if (listTotaux == null) {
            listTotaux = new ArrayList();
        }
        return listTotaux;
    }

    public List<GrandTotalPeriode> loadGrandTotalToUpdateNbPlatform(final String type) throws BasicException {
        ArrayList listTotaux = new PreparedSentence(this.s, this.requestGTP + " WHERE type_PERIODE = ? and ISSYNCHRONIZED = 1  and NB_PLATFORM_STATS_UPDATED = 0 order by timestampGDH DESC", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type);
            }
        });
        if (listTotaux == null) {
            listTotaux = new ArrayList();
        }
        return listTotaux;
    }

    public List<GrandTotalPeriode> loadGTPToUpdateCashlogy(final String type) throws BasicException {
        ArrayList listTotaux = new PreparedSentence(this.s, this.requestGTP + " WHERE type_PERIODE = ? and ISSYNCHRONIZED = 1  and CASHLOGY_UPDATED = 0 order by timestampGDH DESC", SerializerWriteParams.INSTANCE, GrandTotalPeriode.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, type);
            }
        });
        if (listTotaux == null) {
            listTotaux = new ArrayList();
        }
        return listTotaux;
    }

    public void setZUpdated(final String idCloture) {
        try {
            new PreparedSentence(this.s, "UPDATE  GRAND_TOTAL_PERIODE SET STATS_UPDATED = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setString(2, idCloture);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void deleteDuplicatePrices(SupplementItemInfo option) throws BasicException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<Integer> ids_sp = this.getSupplementPrice(option.getSupplementPrices(), "Sur Place");
        List<Integer> ids_take_away = this.getSupplementPrice(option.getSupplementPrices(), "A Emporter");
        List<Integer> ids_delivery = this.getSupplementPrice(option.getSupplementPrices(), "En Livraison");
        List<Integer> ids_platform = this.getSupplementPrice(option.getSupplementPrices(), "Platform");
        ids.addAll(ids_sp);
        ids.addAll(ids_take_away);
        ids.addAll(ids_delivery);
        ids.addAll(ids_platform);
        for (final Integer id : ids) {
            new PreparedSentence(this.s, "delete from  SUPPLEMENT_ITEM_PRICES  WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setInt(1, id);
                }
            });
        }
    }

    private List<Integer> getSupplementPrice(List<SupplementPriceInfo> prices, String type_order) {
        boolean exist = false;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SupplementPriceInfo price : prices) {
            if (price.getType_order() == null || !price.getType_order().equalsIgnoreCase(type_order)) continue;
            if (exist) {
                ids.add(price.getId());
                continue;
            }
            exist = true;
        }
        return ids;
    }

    public void setNbPlatformUpdated(final String idCloture) {
        try {
            new PreparedSentence(this.s, "UPDATE  GRAND_TOTAL_PERIODE SET NB_PLATFORM_STATS_UPDATED = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setString(2, idCloture);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setCashlogyUpdated(final String idCloture) {
        try {
            new PreparedSentence(this.s, "UPDATE  GRAND_TOTAL_PERIODE SET CASHLOGY_UPDATED = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setString(2, idCloture);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setTvaUberUpdated(final String idCloture) {
        try {
            new PreparedSentence(this.s, "UPDATE  GRAND_TOTAL_PERIODE SET TVA_UBER_UPDATED = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, true);
                    this.setString(2, idCloture);
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setIdGlobalItems(String prefixIdGlobal) throws BasicException {
        System.out.println("+++++++ prefixIdGlobal : " + prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET PRODUCT_PLU = ? || TRIM(CAST (ID AS CHAR(10))) WHERE PRODUCT_PLU is null or PRODUCT_PLU = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE supplement_item SET ITEM_PLU = ? || TRIM(CAST (ID AS CHAR(10))) WHERE ITEM_PLU is null or ITEM_PLU = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE supplement SET ID_GLOBAL = ? || TRIM(CAST (ID AS CHAR(10)))  where ID_GLOBAL is null or ID_GLOBAL = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE CATEGORIES SET ID_GLOBAL = ? || TRIM(CAST (ID AS CHAR(10)))  where ID_GLOBAL is null or ID_GLOBAL = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE carte SET ID_GLOBAL = ? || TRIM(CAST (ID AS CHAR(10)))  where ID_GLOBAL is null or ID_GLOBAL = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE PRODUCTS_SIZE SET ID_GLOBAL = ? || TRIM(CAST (ID AS CHAR(10)))  where ID_GLOBAL is null or ID_GLOBAL = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE SUPPLEMENT_ITEM_PRICES SET ID_GLOBAL = ? || TRIM(CAST (ID AS CHAR(10)))  where ID_GLOBAL is null or ID_GLOBAL = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE GROUPE_SUB_SUPPLEMENTS SET ID_GLOBAL = ? || TRIM(CAST (ID AS CHAR(10)))  where ID_GLOBAL is null or ID_GLOBAL = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
        new PreparedSentence(this.s, "UPDATE PROMOTIONS SET ID_GLOBAL = ? || TRIM(CAST (ID AS CHAR(10)))  where ID_GLOBAL is null or ID_GLOBAL = '' ", SerializerWriteString.INSTANCE).exec((Object)prefixIdGlobal);
    }

    @Override
    public SupplementItemInfo getSuppelementByPlu(String item_plu) throws BasicException {
        SupplementItemInfo option = super.getSuppelementByPlu(item_plu);
        if (option != null) {
            option.setSupplementPrices(this.getSupplementPrices(option.getiD()));
        }
        return option;
    }

    public void updateCodeLivreurTicket(final String code, final String id) throws BasicException {
        System.out.println("+++++ codeLivreur : " + code);
        new PreparedSentence(this.s, "UPDATE  TICKETS SET CODE_LIVREUR = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, code);
                this.setString(2, id);
            }
        });
    }

    public List<ProductInfoExt> getPromotionProducts(final int idPromotion, String type) throws BasicException {
        String request = "";
        switch (type) {
            case "Sur Place": {
                request = "P.sp= 1";
                break;
            }
            case "A Emporter": {
                request = "P.emp= 1";
            }
        }
        final int dayOfWeek = DateUtils.getDayOfWeek();
        String request_opening_mode = AppLocal.OPENING_MODE ? " AND P.ENABLE_IN_OPENING = 1 " : "";
        List products = new PreparedSentence(this.s, this.requestProducts + "JOIN PRODUCTS_PROMOTIONS PR ON PR.ID_PRODUCT = P.ID WHERE PR.ID_PROMOTION = ? AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.hidden = 0  AND P.HIDDEN_BORNE = 0 AND P.PRODUCT_UBEREAT = 0  AND (P.HAS_TIMETABLE = 0 OR P.ID IN (SELECT PD.ID_PRODUCT from PRODUCT_DAYS_ON PD where PD.DAY_OF_WEEK = ?)) AND " + request + request_opening_mode + this.request_campaign_product + " ORDER BY  P.order_item ", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idPromotion);
                this.setInt(2, dayOfWeek);
            }
        });
        for (ProductInfoExt product : products) {
            product.setListSizes(this.getProductSizes(product.getID(), true));
            product.setAdditional_sales(this.getAdditionalSales(product.getID(), true));
            product.setSub_products(this.getSubProducts(product.getID(), true));
            for (ProductInfoExt product_additional : product.getAdditional_sales()) {
                TagInfo tag;
                product_additional.setListSizes(this.getProductSizes(product_additional.getID(), true));
                product_additional.setPrices(this.getProductPrices(product_additional.getID(), true));
                List<ImageProduct> images = this.imageProductService.getImages(product_additional.getID());
                product_additional.setImages(images);
                List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product_additional.getID());
                product_additional.setMultiLanguageTexts(multiLanguageTexts);
                if (!AppLocal.SHOW_TAGS_IN_BORNE) continue;
                List<TagInfo> tags = this.getTagsByCategory(product_additional.getCategoryid());
                if (tags == null || tags.isEmpty()) {
                    CategoryInfo categoryAdditional = this.getCategoryInfo(String.valueOf(product_additional.getCategoryid()));
                    tags = this.getTagsByCategory(categoryAdditional.getParent_id());
                }
                if (tags == null || tags.isEmpty() || (tag = tags.get(0)) == null) continue;
                product_additional.setmTagInfo(tag);
            }
            product.setPrices(this.getProductPrices(product.getID(), true));
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
            List<MultiLanguageProduct> multiLanguageTexts = this.multiLanguageProductService.getMultiLanguageTexts(product.getID());
            product.setMultiLanguageTexts(multiLanguageTexts);
            NutritionalInfoProduct mNutritionals = this.mNutritionalService.getNutriByProduct(product.getID());
            product.setNutriValues(mNutritionals);
            List<Allergene> listAllergenes = this.mAllergeneService.getAllergenesForProduct(product.getID());
            product.setAllergenes(listAllergenes);
        }
        return products;
    }

    public List<RecapTaxNote> getRecapTaxNoteByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        System.out.println("date start recap : " + dateStart);
        System.out.println("date end recap : " + dateEnd);
        return new PreparedSentence(this.s, this.requestRecapTaxNote + "WHERE REF_NOTE in (SELECT E.ID FROM ENTETE_NOTE E where E.timestampGDH >= ? AND E.timestampGDH  < ?) ", SerializerWriteParams.INSTANCE, RecapTaxNote.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<RecapGeneralNote> getRecapGeneralNoteByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestRecapGeneralNote + "WHERE REF_NOTE in (SELECT E.ID FROM ENTETE_NOTE E where E.timestampGDH >= ? AND E.timestampGDH  < ?) ", SerializerWriteParams.INSTANCE, RecapGeneralNote.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<LineFacture> getLinesFactureByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestLineFacture + "WHERE REF_FACTURE in (SELECT F.ID FROM FACTURE F where F.date_created>= ?  and F.date_created < ?) ", SerializerWriteParams.INSTANCE, LineFacture.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<RecapTaxFacture> getRecapTaxFactureByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestRecapTaxFacture + "WHERE REF_FACTURE in (SELECT F.ID FROM FACTURE F where F.date_created>= ?  and F.date_created < ?) ", SerializerWriteParams.INSTANCE, RecapTaxFacture.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public List<RecapGeneralFacture> getRecapGeneralFactureByPeriode(String typePeriode, Date myDate) throws BasicException {
        final Date dateEnd = new Date();
        final Date dateStart = new Date(myDate.getTime());
        DateUtils.setDateHours(dateStart, dateEnd);
        switch (typePeriode) {
            case "j": {
                DateUtils.setDateHours(dateStart, dateEnd);
                break;
            }
            case "m": {
                DateUtils.setDateMonths(dateStart, dateEnd);
                break;
            }
            case "a": {
                DateUtils.setDateYears(dateStart, dateEnd);
            }
        }
        return new PreparedSentence(this.s, this.requestRecapGeneralFacture + "WHERE REF_FACTURE in (SELECT F.ID FROM FACTURE F where F.date_created>= ?  and F.date_created < ?) ", SerializerWriteParams.INSTANCE, RecapGeneralFacture.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, dateStart);
                this.setTimestamp(2, dateEnd);
            }
        });
    }

    public final ProductInfoExt getProduct(ProductInfoExt product) throws BasicException {
        String idSynchro = product.getId_global() != null && !product.getId_global().isEmpty() ? product.getId_global() : product.getRef_web();
        String DB_COLUMN_TO_CHECK = product.getId_global() != null && !product.getId_global().isEmpty() ? "P.PRODUCT_PLU" : "P.REF_WEB";
        ProductInfoExt productResult = (ProductInfoExt)new PreparedSentence(this.s, this.requestProducts + "WHERE " + DB_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, ProductInfoExt.getSerializerRead()).find((Object)idSynchro);
        return productResult;
    }

    public List<ProductInfoExt> getProductsWithoutFilter() throws BasicException {
        return new PreparedSentence(this.s, this.requestProducts + " WHERE P.PRODUCT_PLU is null or P.PRODUCT_PLU = '' ", null, ProductInfoExt.getSerializerRead()).list();
    }

    public List<CategoryInfo> getCategoriesWithoutFilter() throws BasicException {
        return new PreparedSentence(this.s, this.requestCategory + " WHERE C.ID_GLOBAL is null or C.ID_GLOBAL = '' ", null, CategoryInfo.getSerializerRead()).list();
    }

    public final List<SupplementInfo> getSupplementsWithoutFilter() throws BasicException {
        return new PreparedSentence(this.s, this.requestSupplement + " WHERE S.ID_GLOBAL is null or S.ID_GLOBAL = '' ", null, SupplementInfo.getSerializerRead()).list();
    }

    public List<SupplementItemInfo> getSupplementItemsWithoutFilter() throws BasicException {
        return new PreparedSentence(this.s, this.requestSuppItem + " WHERE S.ITEM_PLU is null or S.ITEM_PLU = '' ", null, SupplementItemInfo.getSerializerRead()).list();
    }

    public List<CarteInfo> getCartesWithoutFilter() throws BasicException {
        List cartes = new PreparedSentence(this.s, "SELECT id, name, sizeCarte, removed, REF_WEB, REMOVED_BY_ADMIN, ID_GLOBAL FROM CARTE where ID_GLOBAL is null or ID_GLOBAL = '' ", null, CarteInfo.getSerializerRead()).list();
        return cartes;
    }

    public List<GroupSubSupplementInfo> getAllGroupsSubSupplementsWithoutFilter() throws BasicException {
        return new PreparedSentence(this.s, this.requestGroupeSubSupplement + " where G.ID_GLOBAL is null or G.ID_GLOBAL = '' ", null, GroupSubSupplementInfo.getSerializerRead()).list();
    }

    public List<PromotionInfo> getPromotionsWithoutFilter() throws BasicException {
        return new PreparedSentence(this.s, this.requestPromotions + " where P.ID_GLOBAL is null or P.ID_GLOBAL = '' ", null, PromotionInfo.getSerializerRead()).list();
    }

    public List<GroupedTax> getGTPTaxes(String idPeriod) throws BasicException {
        List gtpTaxes = new PreparedSentence(this.s, "SELECT ID, ID_PERIOD, CODE_TAX, NAME, RATE_TAX, TOTAL_HT, TOTAL_TAX, TOTAL_TTC, TAXE_GLOBAL FROM GTP_TAXES where ID_PERIOD = ? ", SerializerWriteString.INSTANCE, GroupedTax.getSerializerRead()).list((Object)idPeriod);
        return gtpTaxes;
    }

    public void addCategoryDayOn(final CategoryDayAvailable categoryDayAvailable) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO CATEGORY_DAYS_ON(DAY_OF_WEEK, ID_CATEGORY, STATUS) VALUES(?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, categoryDayAvailable.getDayOfWeek());
                this.setInt(2, categoryDayAvailable.getCategoryId());
                this.setBoolean(3, categoryDayAvailable.isStatus());
            }
        });
    }

    public Date getFirstDateInstall() throws BasicException {
        String sql = "SELECT LAST_UPGRADE_DATE FROM SOFTWARE WHERE ID = 1";
        Date date_first_install = (Date)new PreparedSentence(this.s, sql, null, SerializerReadDate.INSTANCE).list().get(0);
        return date_first_install;
    }

    public void setGeneratedGTP(final String idGPT) throws BasicException {
        System.out.println("+++++++++++++++idGPT : " + idGPT);
        new PreparedSentence(this.s, "UPDATE GRAND_TOTAL_PERIODE SET FORCED_CLOTURE_GENERATED = ?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, true);
                this.setString(2, idGPT);
            }
        });
    }

    public void deleteCategoryDayOn(final CategoryDayAvailable categoryDayAvailable) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM CATEGORY_DAYS_ON WHERE DAY_OF_WEEK = ? AND ID_CATEGORY = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, categoryDayAvailable.getDayOfWeek());
                this.setInt(2, categoryDayAvailable.getCategoryId());
            }
        });
    }

    public void deleteCategoryDaysOn(final CategoryInfo category) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM CATEGORY_DAYS_ON WHERE ID_CATEGORY = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category.getID());
            }
        });
    }

    public void persistCategoryDaysOn(CategoryInfo category) throws BasicException {
        List<CategoryDayAvailable> oldCategoryDaysOn = this.getCategoryDaysOn(category.getID());
        if (category.getDaysOn() == null || category.getDaysOn().isEmpty()) {
            if (oldCategoryDaysOn != null && !oldCategoryDaysOn.isEmpty()) {
                this.deleteCategoryDaysOn(category);
            }
        } else {
            int found;
            for (CategoryDayAvailable oldCategoryDayOn : oldCategoryDaysOn) {
                found = -1;
                for (CategoryDayAvailable newCategoryDayOn : category.getDaysOn()) {
                    if (oldCategoryDayOn.getDayOfWeek() != newCategoryDayOn.getDayOfWeek()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                this.deleteCategoryDayOn(oldCategoryDayOn);
            }
            for (CategoryDayAvailable newCategoryDayOn : category.getDaysOn()) {
                found = -1;
                for (CategoryDayAvailable oldCategoryDayOn : oldCategoryDaysOn) {
                    if (oldCategoryDayOn.getDayOfWeek() != newCategoryDayOn.getDayOfWeek()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                newCategoryDayOn.setCategoryId(category.getID());
                this.addCategoryDayOn(newCategoryDayOn);
            }
        }
    }

    public List<CategoryDayAvailable> getCategoryDaysOn(int idCategory) throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, DAY_OF_WEEK, ID_CATEGORY, STATUS FROM CATEGORY_DAYS_ON WHERE ID_CATEGORY = ?", SerializerWriteInteger.INSTANCE, CategoryDayAvailable.getSerializerRead()).list((Object)idCategory);
    }

    public List<Integer> getDayByIdCategory(int idCategory) throws BasicException {
        ArrayList<Integer> daysOfCat = new ArrayList<Integer>();
        List categoryDayAvailableList = new PreparedSentence(this.s, "SELECT ID, DAY_OF_WEEK, ID_CATEGORY, STATUS FROM CATEGORY_DAYS_ON WHERE ID_CATEGORY = ?", SerializerWriteInteger.INSTANCE, CategoryDayAvailable.getSerializerRead()).list((Object)idCategory);
        if (categoryDayAvailableList != null && !categoryDayAvailableList.isEmpty()) {
            for (CategoryDayAvailable mCategoryDayAvailable : categoryDayAvailableList) {
                daysOfCat.add(mCategoryDayAvailable.getDayOfWeek());
            }
            return daysOfCat;
        }
        throw new BasicException("No entry found for the given idCategory");
    }

    public void persistShiftCategories(CategoryInfo category) throws BasicException {
        int idCategory = category.getID();
        List<ShiftCategory> oldShiftCategories = this.getShiftCategories(idCategory);
        if (category.getShiftsCategory() == null || category.getShiftsCategory().isEmpty()) {
            if (oldShiftCategories != null && !oldShiftCategories.isEmpty()) {
                this.deleteShiftCategorie(idCategory);
            }
        } else {
            int found;
            for (ShiftCategory oldShiftCategory : oldShiftCategories) {
                found = -1;
                for (ShiftCategory newShiftCategory : category.getShiftsCategory()) {
                    if (oldShiftCategory.getId() != newShiftCategory.getId()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                this.deleteShiftCategories(oldShiftCategory);
            }
            for (ShiftCategory newShiftCategory : category.getShiftsCategory()) {
                found = -1;
                for (ShiftCategory oldShiftCategory : oldShiftCategories) {
                    if (oldShiftCategory.getId() != newShiftCategory.getId()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                newShiftCategory.setICategory(idCategory);
                this.addShiftCategory(newShiftCategory);
            }
        }
    }

    public List<ShiftCategory> getShiftCategories(int idCategory) throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, DATE_START, DATE_END, idCategory FROM SHIFT_CATEGORY WHERE idCategory = ?", SerializerWriteInteger.INSTANCE, ShiftCategory.getSerializerRead()).list((Object)idCategory);
    }

    public void deleteShiftCategorie(final int idCategory) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SHIFT_CATEGORY WHERE idCategory = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idCategory);
            }
        });
    }

    public void addShiftCategory(final ShiftCategory shiftCategory) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SHIFT_CATEGORY(DATE_START, DATE_END, idCategory) VALUES(?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, shiftCategory.getDateStart());
                this.setString(2, shiftCategory.getDateEnd());
                this.setInt(3, shiftCategory.getICategory());
            }
        });
    }

    public void deleteShiftCategories(final ShiftCategory oldShiftCategory) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SHIFT_CATEGORY WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, oldShiftCategory.getId());
            }
        });
    }

    public void persistShiftProducts(ProductInfoExt product) throws BasicException {
        int id_product = product.getID();
        List<ShiftProduct> oldShiftProducts = this.getShiftProducts(id_product);
        if (product.getShiftsCProduct() == null || product.getShiftsCProduct().isEmpty()) {
            if (oldShiftProducts != null && !oldShiftProducts.isEmpty()) {
                this.deleteShiftProducts(id_product);
            }
        } else {
            int found;
            for (ShiftProduct oldShiftProduct : oldShiftProducts) {
                found = -1;
                for (ShiftProduct newShiftProducts : product.getShiftsCProduct()) {
                    if (oldShiftProduct.getId() != newShiftProducts.getId()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                this.deleteShiftProduct(oldShiftProduct);
            }
            for (ShiftProduct newShiftProduct : product.getShiftsCProduct()) {
                found = -1;
                for (ShiftProduct oldShiftCategory : oldShiftProducts) {
                    if (oldShiftCategory.getId() != newShiftProduct.getId()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                newShiftProduct.setProduct(id_product);
                this.addShiftProduct(newShiftProduct);
            }
        }
    }

    public void deleteShiftProducts(final int id_product) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SHIFT_PRODUCT WHERE idproduct = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id_product);
            }
        });
    }

    public List<ShiftProduct> getShiftProducts(int id_product) throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, DATE_START, DATE_END, idproduct FROM SHIFT_PRODUCT WHERE idproduct = ?", SerializerWriteInteger.INSTANCE, ShiftProduct.getSerializerRead()).list((Object)id_product);
    }

    public void deleteShiftProduct(final ShiftProduct oldShiftProduct) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM SHIFT_PRODUCT WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, oldShiftProduct.getId());
            }
        });
    }

    public void addShiftProduct(final ShiftProduct shiftProduct) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO SHIFT_PRODUCT(DATE_START, DATE_END, idproduct) VALUES(?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, shiftProduct.getDateStart());
                this.setString(2, shiftProduct.getDateEnd());
                this.setInt(3, shiftProduct.getIProduct());
            }
        });
    }

    public void addShifts() {
        try {
            Object mshift;
            String dateEnd;
            String dateStart;
            List<ProductInfoExt> products = this.getAllProductsWithoutConstraints();
            List<CategoryInfo> categories = this.getAllCategories();
            for (ProductInfoExt product : products) {
                dateStart = product.getFirst_period() <= 9 ? "0" + String.valueOf(product.getFirst_period()) + ":00" : String.valueOf(product.getFirst_period()) + ":00";
                String string = dateEnd = product.getFirst_period() <= 9 ? "0" + String.valueOf(product.getEnd_period()) + ":00" : String.valueOf(product.getEnd_period()) + ":00";
                if (dateStart.equals("00:00") && dateEnd.equals("00:00")) continue;
                mshift = new ShiftProduct(dateStart, dateEnd, product.getID());
                this.addShiftProduct((ShiftProduct)mshift);
            }
            for (CategoryInfo category : categories) {
                dateStart = category.getFirst_period() <= 9 ? "0" + String.valueOf(category.getFirst_period()) + ":00" : String.valueOf(category.getFirst_period()) + ":00";
                String string = dateEnd = category.getFirst_period() <= 9 ? "0" + String.valueOf(category.getEnd_period()) + ":00" : String.valueOf(category.getEnd_period()) + ":00";
                if (dateStart.equals("00:00") && dateEnd.equals("00:00")) continue;
                mshift = new ShiftCategory(dateStart, dateEnd, category.getID());
                this.addShiftCategory((ShiftCategory)mshift);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setTvasUber(GrandTotalPeriode grandTotalPeriode) throws BasicException, ParseException {
        Date dateStart = DateUtils.SDF_YYYYMMDD.parse(grandTotalPeriode.getId());
        Date dateEnd = new Date();
        double totalttc10 = 0.0;
        DateUtils.setDateHours(dateStart, dateEnd);
        List<TaxLineTicket> taxes = AppLocal.dlStats.getTaxeUber(dateStart, dateEnd);
        double tva10 = 0.0;
        double tva5 = 0.0;
        for (TaxLineTicket taxe : taxes) {
            if (taxe.getRate() == 0.1) {
                tva10 = NumericUtils.round(taxe.getAmount());
                totalttc10 += NumericUtils.round(taxe.getSumTTC());
            }
            if (taxe.getRate() != 0.055) continue;
            tva5 = NumericUtils.round(taxe.getAmount());
        }
        grandTotalPeriode.setTva_5_5_ubereats(tva5);
        grandTotalPeriode.setTva_10_ubereats(tva10);
    }

    public SupplementItemInfo getFullInfoSupplementByIdGlobal(String idGlobal) throws BasicException {
        SupplementItemInfo item = (SupplementItemInfo)new PreparedSentence(this.s, this.requestFullSuppItem + " JOIN supplement G ON G.id = S.id_supplement  where S.ITEM_PLU = ?", SerializerWriteString.INSTANCE, SupplementItemInfo.getFullOptions()).find((Object)idGlobal);
        if (item != null) {
            item.setSupplementPrices(this.getSupplementPrices(item.getiD()));
        }
        return item;
    }

    public void updateImagesProduct(ProductInfoExt product) {
        this.imageProductService.setImages(product.getImages(), product.getID());
    }

    public void updateMultiLanguagesProduct(ProductInfoExt product) {
        this.multiLanguageProductService.setMultiLanguagesProduct(product.getMultiLanguageTexts(), product.getID());
    }

    public void updateNutritional(ProductInfoExt product) {
        if (product.getNutriValues() != null) {
            this.mNutritionalService.update(product.getNutriValues(), product.getID());
        } else {
            this.mNutritionalService.deleteByProductId(product.getID());
        }
    }

    public void updateAllergenes(ProductInfoExt product) {
        List<Allergene> currentAllergenes = product.getAllergenes();
        int productId = product.getID();
        if (currentAllergenes == null || currentAllergenes.isEmpty()) {
            this.mAllergeneService.deleteAllAllergenesForProduct(productId);
        } else {
            Set incomingNames = currentAllergenes.stream().map(Allergene::getName).collect(Collectors.toSet());
            List<Allergene> dbAllergenes = this.mAllergeneService.getAllergenesForProduct(productId);
            for (Allergene dbAllergene : dbAllergenes) {
                if (incomingNames.contains(dbAllergene.getName())) continue;
                this.mAllergeneService.deleteAllergene(productId, dbAllergene.getName());
            }
            for (Allergene mAllergene : currentAllergenes) {
                System.out.println("**********mAllergene********" + mAllergene.getName());
                this.mAllergeneService.updateAllergene(mAllergene, productId);
            }
        }
    }

    public void updateCancelledNoteSynchro(final TicketInfo ticketInfo, final boolean sync) {
        try {
            new PreparedSentence(this.s, "UPDATE  TICKETS SET noteIsSentToPostgre = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setBoolean(1, sync);
                    this.setString(2, ticketInfo.getId());
                }
            });
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLogicSales.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void deleteOptionPrice(final int idPrice) throws BasicException {
        new PreparedSentence(this.s, "delete from  SUPPLEMENT_ITEM_PRICES  WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idPrice);
            }
        });
    }

    public List<SupplementItemInfo> getOldSubSupplements(int id_group) throws BasicException {
        List subSupplements = new PreparedSentence(this.s, this.requestFullSuppItem + " JOIN supplement G ON G.id = S.id_supplement JOIN SUB_SUPPLEMENTS SS ON S.id = SS.ID_SUPPLEMENT  WHERE SS.ID_GROUPESUPPLEMENT = ? ORDER BY  S.order_item ", SerializerWriteInteger.INSTANCE, SupplementItemInfo.getFullOptions()).list((Object)id_group);
        return subSupplements;
    }

    public final SupplementItemInfo getOption(SupplementItemInfo option) throws BasicException {
        String idSynchro = option.getId_global() != null && !option.getId_global().isEmpty() ? option.getId_global() : option.getRef_web();
        String DB_COLUMN_TO_CHECK = option.getId_global() != null && !option.getId_global().isEmpty() ? "S.ITEM_PLU" : "S.REF_WEB";
        SupplementItemInfo optionResult = (SupplementItemInfo)new PreparedSentence(this.s, this.requestSuppItem + "WHERE " + DB_COLUMN_TO_CHECK + " = ? ", SerializerWriteString.INSTANCE, SupplementItemInfo.getSerializerRead()).find((Object)idSynchro);
        return optionResult;
    }

    public void resetIdGlobal() throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET PRODUCT_PLU = null where PRODUCT_PLU in (select PRODUCT_PLU from products group by PRODUCT_PLU having count(*) > 1) ", null).exec();
        new PreparedSentence(this.s, "UPDATE supplement_item SET ITEM_PLU = null where ITEM_PLU in (select ITEM_PLU from supplement_item group by ITEM_PLU having count(*) > 1) ", null).exec();
        new PreparedSentence(this.s, "UPDATE supplement SET ID_GLOBAL = null where ID_GLOBAL in (select ID_GLOBAL from supplement group by ID_GLOBAL having count(*) > 1) ", null).exec();
        new PreparedSentence(this.s, "UPDATE CATEGORIES SET ID_GLOBAL = null where ID_GLOBAL in (select ID_GLOBAL from CATEGORIES group by ID_GLOBAL having count(*) > 1) ", null).exec();
        new PreparedSentence(this.s, "UPDATE carte SET ID_GLOBAL = null where ID_GLOBAL in (select ID_GLOBAL from carte group by ID_GLOBAL having count(*) > 1) ", null).exec();
        new PreparedSentence(this.s, "UPDATE PRODUCTS_SIZE SET ID_GLOBAL = null where ID_GLOBAL in (select ID_GLOBAL from PRODUCTS_SIZE group by ID_GLOBAL having count(*) > 1) ", null).exec();
        new PreparedSentence(this.s, "UPDATE SUPPLEMENT_ITEM_PRICES SET ID_GLOBAL = null where ID_GLOBAL in (select ID_GLOBAL from SUPPLEMENT_ITEM_PRICES group by ID_GLOBAL having count(*) > 1) ", null).exec();
        new PreparedSentence(this.s, "UPDATE GROUPE_SUB_SUPPLEMENTS SET ID_GLOBAL = null where ID_GLOBAL in (select ID_GLOBAL from GROUPE_SUB_SUPPLEMENTS group by ID_GLOBAL having count(*) > 1) ", null).exec();
        new PreparedSentence(this.s, "UPDATE PROMOTIONS SET ID_GLOBAL = null where ID_GLOBAL in (select ID_GLOBAL from PROMOTIONS group by ID_GLOBAL having count(*) > 1) ", null).exec();
    }

    public List<ProductInfoExt> getProductsByIdCategory(int category) throws BasicException {
        List<ProductInfoExt> products = this.getProductsWithoutDetails(category, true, false, false, false);
        for (ProductInfoExt product : products) {
            List<ImageProduct> images = this.imageProductService.getImages(product.getID());
            product.setImages(images);
        }
        return products;
    }

    public final void setSoldOutIngredient(final int ingredient_id, final boolean sold_out) throws BasicException {
        new PreparedSentence(this.s, "UPDATE  SUPPLEMENT_ITEM SET  SOLD_OUT = ? WHERE id = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setInt(2, ingredient_id);
            }
        });
    }

    public void updateStatusIngredient(int ingredient_id, final boolean hidden, String id_global) throws BasicException {
        String request_ref_synchro = id_global != null && !id_global.isEmpty() ? "ITEM_PLU = ?" : "REF_WEB = ?";
        final String ref_synchro = id_global != null && !id_global.isEmpty() ? id_global : String.valueOf(ingredient_id);
        new PreparedSentence(this.s, "UPDATE supplement_item SET  SOLD_OUT = ? WHERE " + request_ref_synchro, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, hidden);
                this.setString(2, ref_synchro);
            }
        });
    }

    public List<ProductInfoExt> getProductsByIngredients(int ingredient_id) throws BasicException {
        String requestSql = this.requestProducts + " JOIN ITEM_INGREDIENTS I ON I.id_item = P.ID WHERE I.id_supplement_item = ? AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.SOLD_OUT = 0  AND P.CATEGORY NOT IN (select ID FROM CATEGORIES WHERE REMOVED_BY_ADMIN = 1 OR removed = 1) " + this.request_campaign_product;
        requestSql = requestSql + "ORDER BY  P.order_item ";
        List products = new PreparedSentence(this.s, requestSql, SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)ingredient_id);
        return products;
    }

    public List<ProductInfoExt> getSoldOutProductsByIngredients(int ingredient_id) throws BasicException {
        String requestSql = this.requestProducts + " JOIN ITEM_INGREDIENTS I ON I.id_item = P.ID WHERE I.id_supplement_item = ? AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.SOLD_OUT = 1  AND P.CATEGORY NOT IN (select ID FROM CATEGORIES WHERE REMOVED_BY_ADMIN = 1 OR removed = 1)  AND P.ID not in (select II.id_item from ITEM_INGREDIENTS II JOIN SUPPLEMENT_ITEM S ON II.id_supplement_item = S.id where S.SOLD_OUT = 1)  AND P.ID not in (select SP.ID_PRODUCT_PARENT from SUB_PRODUCTS SP JOIN PRODUCTS P1 ON SP.ID_PRODUCT = P1.ID where P1.SOLD_OUT = 1) " + this.request_campaign_product;
        requestSql = requestSql + "ORDER BY  P.order_item ";
        List products = new PreparedSentence(this.s, requestSql, SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)ingredient_id);
        return products;
    }

    public List<ProductInfoExt> getSuperProductsSoldOut(int id_sub_product) throws BasicException {
        String requestSql = this.requestProducts + " JOIN SUB_PRODUCTS SP ON P.ID = SP.ID_PRODUCT_PARENT WHERE SP.ID_PRODUCT = ? AND P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.SOLD_OUT = 1  AND P.CATEGORY NOT IN (select ID FROM CATEGORIES WHERE REMOVED_BY_ADMIN = 1 OR removed = 1)  AND P.ID not in (select II.id_item from ITEM_INGREDIENTS II JOIN SUPPLEMENT_ITEM S ON II.id_supplement_item = S.id where S.SOLD_OUT = 1)  AND P.ID not in (select SP.ID_PRODUCT_PARENT from SUB_PRODUCTS SP JOIN PRODUCTS P1 ON SP.ID_PRODUCT = P1.ID where P1.SOLD_OUT = 1) " + this.request_campaign_product;
        requestSql = requestSql + "ORDER BY  P.order_item ";
        List products = new PreparedSentence(this.s, requestSql, SerializerWriteInteger.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)id_sub_product);
        return products;
    }

    public List<ProductInfoExt> getProductsByCategory(final int category) throws BasicException {
        List products = new PreparedSentence(this.s, this.requestProducts + "WHERE P.REMOVED_BY_ADMIN = 0 AND P.removed = 0 AND P.CATEGORY = ? " + this.request_campaign_product + "ORDER BY  P.order_item ", SerializerWriteParams.INSTANCE, ProductInfoExt.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, category);
            }
        });
        return products;
    }

    public String getHolderTicket(final String ticket) throws BasicException {
        String data = null;
        String q = "SELECT holder FROM TICKETS WHERE ID = ?";
        Object[] result = (Object[])new StaticSentence(this.s, q, SerializerWriteParams.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING})).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticket);
            }
        });
        data = result != null && result.length > 0 ? (String)result[0] : null;
        System.out.println("+++++ holder : " + data);
        return data;
    }

    public void setSoldOutOption(final int option_id, final boolean sold_out) throws BasicException {
        new PreparedSentence(this.s, "UPDATE supplement_item SET  SOLD_OUT = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setInt(2, option_id);
            }
        });
    }

    public void setSoldOut(final int product_id, final boolean sold_out) throws BasicException {
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setInt(2, product_id);
            }
        });
    }

    public void setSoldOutProductVyIdGlobal(int product_id, final boolean sold_out, String id_global) throws BasicException {
        String request_ref_synchro = id_global != null && !id_global.isEmpty() ? "PRODUCT_PLU = ?" : "REF_WEB = ?";
        final String ref_synchro = id_global != null && !id_global.isEmpty() ? id_global : String.valueOf(product_id);
        new PreparedSentence(this.s, "UPDATE PRODUCTS SET  SOLD_OUT = ? WHERE " + request_ref_synchro, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setString(2, ref_synchro);
            }
        });
    }

    public void setSoldOutOptionByIdGlobal(int option_id, final boolean sold_out, String id_global) throws BasicException {
        String request_ref_synchro = id_global != null && !id_global.isEmpty() ? "ITEM_PLU = ?" : "REF_WEB = ?";
        final String ref_synchro = id_global != null && !id_global.isEmpty() ? id_global : String.valueOf(option_id);
        new PreparedSentence(this.s, "UPDATE supplement_item SET  SOLD_OUT = ? WHERE " + request_ref_synchro, SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, sold_out);
                this.setString(2, ref_synchro);
            }
        });
    }

    public List<String> loadIdsArchiveNotSynchronized() throws BasicException {
        List listIds = new PreparedSentence(this.s, "SELECT ID FROM ARCHIV_PERIODE WHERE ISSYNCHRONIZED = 0 ORDER BY ID DESC", null, SerializerReadString.INSTANCE).list();
        return listIds;
    }

    public void updateArchiveSynchronized(String archiveId) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ARCHIV_PERIODE SET ISSYNCHRONIZED = 1 WHERE ID = ?", SerializerWriteString.INSTANCE, null).exec((Object)archiveId);
    }

    public SupplementItemInfo getSupplementByIdGlobal(String id_global) throws BasicException {
        SupplementItemInfo option = (SupplementItemInfo)new PreparedSentence(this.s, this.requestSuppItem + " where S.ITEM_PLU = ?", SerializerWriteString.INSTANCE, SupplementItemInfo.getSerializerRead()).find((Object)id_global);
        return option;
    }

    public void deleteUnusedItems() throws BasicException {
        System.out.println("start purge items : " + new Date());
        String requestDeleteCarteItem = "DELETE FROM carte_item ci WHERE EXISTS (SELECT 1 FROM products p WHERE ci.id_item = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteCarteMenu = "DELETE FROM carte_menu cm WHERE EXISTS (SELECT 1 FROM products p WHERE cm.id_item = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteSupplementItem = "update supplement_item S set S.ID_PRODUCT = null  WHERE EXISTS (SELECT 1 FROM products p WHERE S.ID_PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteItemIngredient = "DELETE FROM item_ingredients I WHERE EXISTS (SELECT 1 FROM products p WHERE I.id_item = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteItemSupplement = "DELETE FROM item_supplements I WHERE EXISTS (SELECT 1 FROM products p WHERE I.id_item = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteAdditionalChild = "DELETE FROM ADDITIONAL_SALES A WHERE EXISTS (SELECT 1 FROM products p WHERE A.ID_PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteAdditionalParent = "DELETE FROM ADDITIONAL_SALES A WHERE EXISTS (SELECT 1 FROM products p WHERE A.ID_PRODUCT_PARENT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteProductPromotion = "DELETE FROM PRODUCTS_PROMOTIONS PR WHERE EXISTS (SELECT 1 FROM products p WHERE PR.ID_PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteSubProductChild = "DELETE FROM SUB_PRODUCTS SB WHERE EXISTS (SELECT 1 FROM products p WHERE SB.ID_PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteSubProductParent = "DELETE FROM SUB_PRODUCTS SB WHERE EXISTS (SELECT 1 FROM products p WHERE SB.ID_PRODUCT_PARENT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteProductDays = "DELETE FROM PRODUCT_DAYS_ON D WHERE EXISTS (SELECT 1 FROM products p WHERE D.ID_PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteProductPrices = "DELETE FROM PRODUCTS_PRICES PP WHERE EXISTS (SELECT 1 FROM products p WHERE PP.PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteShiftProduct = "DELETE FROM SHIFT_PRODUCT S WHERE EXISTS (SELECT 1 FROM products p WHERE S.idproduct = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteImageProduct = "DELETE FROM IMAGES_PRODUCTS I WHERE EXISTS (SELECT 1 FROM products p WHERE I.ID_PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteMultiLanguage = "DELETE FROM MULTILANGUAGE_PRODUCT M WHERE EXISTS (SELECT 1 FROM products p WHERE M.ID_PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteNutritional = "DELETE FROM Nutritional N WHERE EXISTS (SELECT 1 FROM products p WHERE N.idProductNutri = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteAllergen = "DELETE FROM ALLERGENE A WHERE EXISTS (SELECT 1 FROM products p WHERE A.idProductAllergene = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteHistoriqueStock = "DELETE FROM HISTORIQUE_STOCK H WHERE EXISTS (SELECT 1 FROM products p WHERE H.product = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteProductSize = "DELETE FROM PRODUCTS_SIZE PS WHERE EXISTS (SELECT 1 FROM products p WHERE PS.product = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteScreenProduct = "DELETE FROM SCREENS_PRODUCT S WHERE EXISTS (SELECT 1 FROM products p WHERE S.ID_PRODUCT = p.ID AND p.removed_by_admin = 1 AND NOT EXISTS ( SELECT 1 FROM ticketlines t WHERE t.product = p.ID))";
        String requestDeleteProduct = "DELETE FROM products P WHERE removed_by_admin = 1 AND NOT EXISTS ( SELECT 1  FROM ticketlines t WHERE t.product = P.ID)";
        new PreparedSentence(this.s, requestDeleteCarteItem, null).exec();
        new PreparedSentence(this.s, requestDeleteCarteMenu, null).exec();
        new PreparedSentence(this.s, requestDeleteSupplementItem, null).exec();
        new PreparedSentence(this.s, requestDeleteItemIngredient, null).exec();
        new PreparedSentence(this.s, requestDeleteItemSupplement, null).exec();
        new PreparedSentence(this.s, requestDeleteAdditionalChild, null).exec();
        new PreparedSentence(this.s, requestDeleteAdditionalParent, null).exec();
        new PreparedSentence(this.s, requestDeleteProductPromotion, null).exec();
        new PreparedSentence(this.s, requestDeleteSubProductChild, null).exec();
        new PreparedSentence(this.s, requestDeleteSubProductParent, null).exec();
        new PreparedSentence(this.s, requestDeleteProductDays, null).exec();
        new PreparedSentence(this.s, requestDeleteProductPrices, null).exec();
        new PreparedSentence(this.s, requestDeleteShiftProduct, null).exec();
        new PreparedSentence(this.s, requestDeleteImageProduct, null).exec();
        new PreparedSentence(this.s, requestDeleteMultiLanguage, null).exec();
        new PreparedSentence(this.s, requestDeleteNutritional, null).exec();
        new PreparedSentence(this.s, requestDeleteAllergen, null).exec();
        new PreparedSentence(this.s, requestDeleteHistoriqueStock, null).exec();
        new PreparedSentence(this.s, requestDeleteProductSize, null).exec();
        new PreparedSentence(this.s, requestDeleteScreenProduct, null).exec();
        new PreparedSentence(this.s, requestDeleteProduct, null).exec();
        String requestDeleteSubCategoryTags = "DELETE FROM TAGS_CATEGORIES TG WHERE EXISTS (SELECT 1 from categories C where TG.ID_CATEGORY = C.ID AND C.REMOVED_BY_ADMIN = 1 AND PARENTID <> -1 and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID))";
        String requestDeleteSubCategoryDaysON = "DELETE FROM CATEGORY_DAYS_ON CD WHERE EXISTS (SELECT 1 from categories C where CD.ID_CATEGORY = C.ID AND C.REMOVED_BY_ADMIN = 1 AND PARENTID <> -1 and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID))";
        String requestDeleteSubCategoryShift = "DELETE FROM SHIFT_CATEGORY SC WHERE EXISTS (SELECT 1 from categories C where SC.idCategory = C.ID AND C.REMOVED_BY_ADMIN = 1 AND PARENTID <> -1 and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID))";
        String requestDeleteSubCategoryMultiLanguage = "DELETE FROM MULTILANGUAGE_CATEGORY MC WHERE EXISTS (SELECT 1 from categories C where MC.ID_CATEGORY = C.ID AND C.REMOVED_BY_ADMIN = 1 AND PARENTID <> -1 and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID))";
        String requestDeleteSubCategory = "delete from categories C where C.REMOVED_BY_ADMIN = 1 AND PARENTID <> -1 and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID)";
        String requestDeleteCategoryTags = "DELETE FROM TAGS_CATEGORIES TG WHERE EXISTS (SELECT 1 from categories C where TG.ID_CATEGORY = C.ID AND C.REMOVED_BY_ADMIN = 1  and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID) and NOT EXISTS ( SELECT 1  FROM CATEGORIES SB WHERE SB.PARENTID = C.ID))";
        String requsetDeleteCategoryDaysOn = "DELETE FROM CATEGORY_DAYS_ON CD WHERE EXISTS (SELECT 1 from categories C where CD.ID_CATEGORY = C.ID AND C.REMOVED_BY_ADMIN = 1  and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID) and NOT EXISTS ( SELECT 1  FROM CATEGORIES SB WHERE SB.PARENTID = C.ID))";
        String requestDeleteCategoryShift = "DELETE FROM SHIFT_CATEGORY SC WHERE EXISTS (SELECT 1 from categories C where SC.idCategory = C.ID AND C.REMOVED_BY_ADMIN = 1  and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID) and NOT EXISTS ( SELECT 1  FROM CATEGORIES SB WHERE SB.PARENTID = C.ID))";
        String requestDeleteCategoryMultilanguage = "DELETE FROM MULTILANGUAGE_CATEGORY MC WHERE EXISTS (SELECT 1 from categories C where MC.ID_CATEGORY = C.ID AND C.REMOVED_BY_ADMIN = 1 and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID) and NOT EXISTS ( SELECT 1  FROM CATEGORIES SB WHERE SB.PARENTID = C.ID))";
        String requestDeleteCategory = "delete from categories C where C.REMOVED_BY_ADMIN = 1 AND PARENTID = -1 and NOT EXISTS ( SELECT 1  FROM products P WHERE P.category = C.ID) AND NOT EXISTS ( SELECT 1  FROM CATEGORIES SB WHERE SB.PARENTID = C.ID)";
        new PreparedSentence(this.s, requestDeleteSubCategoryTags, null).exec();
        new PreparedSentence(this.s, requestDeleteSubCategoryDaysON, null).exec();
        new PreparedSentence(this.s, requestDeleteSubCategoryShift, null).exec();
        new PreparedSentence(this.s, requestDeleteSubCategoryMultiLanguage, null).exec();
        new PreparedSentence(this.s, requestDeleteSubCategory, null).exec();
        new PreparedSentence(this.s, requestDeleteCategoryTags, null).exec();
        new PreparedSentence(this.s, requsetDeleteCategoryDaysOn, null).exec();
        new PreparedSentence(this.s, requestDeleteCategoryShift, null).exec();
        new PreparedSentence(this.s, requestDeleteCategoryMultilanguage, null).exec();
        new PreparedSentence(this.s, requestDeleteCategory, null).exec();
        String requestDeleteSupplementGroup = "delete from SUPPLEMENTS_GROUPE SG where EXISTS (select 1 from supplement_item S where SG.ID_SUPPLEMENT = S.ID AND S.removed_by_admin = 1 and not exists (select 1 from INGREDIENT_TICKET IT where IT.IDINGREDIENT = S.ID) and not exists (select 1 from OPTION_TICKET OP where OP.IDOPTION = S.ID))";
        String requestDeleteAllergenSup = "delete from ALLERGENE_SUPPLEMENT AL where EXISTS (select 1 from supplement_item S where AL.ID_SUPPLEMENT = S.ID AND S.removed_by_admin = 1 and not exists (select 1 from INGREDIENT_TICKET IT where IT.IDINGREDIENT = S.ID) and not exists (select 1 from OPTION_TICKET OP where OP.IDOPTION = S.ID))";
        String requestDeleteMultiLanguageSup = "delete from MULTILANGUAGE_SUPPLEMENT_ITEM MS where EXISTS (select 1 from supplement_item S where MS.ID_SUPPLEMENT_ITEM = S.ID AND S.removed_by_admin = 1 and not exists (select 1 from INGREDIENT_TICKET IT where IT.IDINGREDIENT = S.ID) and not exists (select 1 from OPTION_TICKET OP where OP.IDOPTION = S.ID))";
        String requestDeleteSubSupplement = "delete from SUB_SUPPLEMENTS SS where EXISTS (select 1 from supplement_item S where SS.ID_SUPPLEMENT = S.ID AND S.removed_by_admin = 1 and not exists (select 1 from INGREDIENT_TICKET IT where IT.IDINGREDIENT = S.ID) and not exists (select 1 from OPTION_TICKET OP where OP.IDOPTION = S.ID))";
        String requestDeleteSupplementItemPrice = "delete from SUPPLEMENT_ITEM_PRICES SP where EXISTS (select 1 from supplement_item S where SP.SUPPLEMENT_ID = S.ID AND S.removed_by_admin = 1 and not exists (select 1 from INGREDIENT_TICKET IT where IT.IDINGREDIENT = S.ID) and not exists (select 1 from OPTION_TICKET OP where OP.IDOPTION = S.ID))";
        String requestDeleteScreensSupplement = "delete from SCREENS_SUPPLEMENT SS where EXISTS (select 1 from supplement_item S where SS.ID_SUPPLEMENT = S.ID AND S.removed_by_admin = 1 and not exists (select 1 from INGREDIENT_TICKET IT where IT.IDINGREDIENT = S.ID) and not exists (select 1 from OPTION_TICKET OP where OP.IDOPTION = S.ID))";
        String requestDeleteItemIngredients = "delete from item_ingredients II where EXISTS (select 1 from supplement_item S where II.id_supplement_item = S.ID AND S.removed_by_admin = 1 and not exists (select 1 from INGREDIENT_TICKET IT where IT.IDINGREDIENT = S.ID) and not exists (select 1 from OPTION_TICKET OP where OP.IDOPTION = S.ID))";
        String requestDeleteSupplementItems = "delete from supplement_item S where S.removed_by_admin = 1 and not exists (select 1 from INGREDIENT_TICKET IT where IT.IDINGREDIENT = S.ID) and not exists (select 1 from OPTION_TICKET OP where OP.IDOPTION = S.ID)";
        new PreparedSentence(this.s, requestDeleteSupplementGroup, null).exec();
        new PreparedSentence(this.s, requestDeleteAllergenSup, null).exec();
        new PreparedSentence(this.s, requestDeleteMultiLanguageSup, null).exec();
        new PreparedSentence(this.s, requestDeleteSubSupplement, null).exec();
        new PreparedSentence(this.s, requestDeleteSupplementItemPrice, null).exec();
        new PreparedSentence(this.s, requestDeleteScreensSupplement, null).exec();
        new PreparedSentence(this.s, requestDeleteItemIngredients, null).exec();
        new PreparedSentence(this.s, requestDeleteSupplementItems, null).exec();
        String requestDeleteMultiLanguageGSS = "delete from MULTILANGUAGE_GROUPE_SUB_SUPPLEMENTS MGS where exists (select 1 from GROUPE_SUB_SUPPLEMENTS GSS where MGS.ID_GROUPE_SUB_SUPPLEMENTS = GSS.ID AND GSS.REMOVED = 1  and not exists ( select 1 from SUB_SUPPLEMENTS SS where GSS.ID = SS.ID_GROUPESUPPLEMENT) and not exists ( select 1 from SUPPLEMENTS_GROUPE SG where GSS.ID = SG.ID_GROUPESUPPLEMENT))";
        String requestDeleteGSS = "delete from GROUPE_SUB_SUPPLEMENTS GSS where GSS.REMOVED = 1  and not exists ( select 1 from SUB_SUPPLEMENTS SS where GSS.ID = SS.ID_GROUPESUPPLEMENT) and not exists ( select 1 from SUPPLEMENTS_GROUPE SG where GSS.ID = SG.ID_GROUPESUPPLEMENT)";
        new PreparedSentence(this.s, requestDeleteMultiLanguageGSS, null).exec();
        new PreparedSentence(this.s, requestDeleteGSS, null).exec();
        String requestDeleteScreenSupplement = "DELETE FROM SCREENS_GROUP_SUPPLEMENT SGS WHERE EXISTS (SELECT 1 from supplement S where SGS.ID_GROUP_SUPPLEMENT = S.ID AND S.REMOVED_BY_ADMIN = 1 and NOT EXISTS ( SELECT 1  FROM supplement_item SI WHERE SI.id_supplement = S.ID))";
        String requestDeleteMultiLanguageSupplment = "DELETE FROM MULTILANGUAGE_SUPPLEMENT MS WHERE EXISTS (SELECT 1 from supplement S where MS.ID_SUPPLEMENT = S.ID AND S.REMOVED_BY_ADMIN = 1 and NOT EXISTS ( SELECT 1  FROM supplement_item SI WHERE SI.id_supplement = S.ID))";
        String requestDeleteItemSupplementGroup = "DELETE FROM item_supplements I WHERE EXISTS (SELECT 1 from supplement S where I.id_supplement = S.ID AND S.REMOVED_BY_ADMIN = 1 and NOT EXISTS ( SELECT 1  FROM supplement_item SI WHERE SI.id_supplement = S.ID))";
        String requestDeleteSupplment = "delete from supplement S where S.REMOVED_BY_ADMIN = 1 and NOT EXISTS ( SELECT 1  FROM supplement_item SI WHERE SI.id_supplement = S.ID)";
        new PreparedSentence(this.s, requestDeleteScreenSupplement, null).exec();
        new PreparedSentence(this.s, requestDeleteMultiLanguageSupplment, null).exec();
        new PreparedSentence(this.s, requestDeleteItemSupplementGroup, null).exec();
        new PreparedSentence(this.s, requestDeleteSupplment, null).exec();
        String requestDeleteMultiLanguageCarte = "delete from MULTILANGUAGE_CARTE MS where exists (select 1 from carte C where MS.ID_CARTE = C.ID AND C.REMOVED_BY_ADMIN = 1  and not exists ( select 1 from carte_item CI where C.ID = CI.id_carte) and not exists ( select 1 from carte_menu CM where C.ID = CM.id_carte))";
        String requestDeleteCarte = "delete from carte C where C.REMOVED_BY_ADMIN = 1  and not exists ( select 1 from carte_item CI where C.ID = CI.id_carte) and not exists ( select 1 from carte_menu CM where C.ID = CM.id_carte)";
        new PreparedSentence(this.s, requestDeleteMultiLanguageCarte, null).exec();
        new PreparedSentence(this.s, requestDeleteCarte, null).exec();
        String requestDeleteMultiLanguagePromotion = "delete from MULTILANGUAGE_PROMOTION MP where EXISTS(select 1 from PROMOTIONS P where MP.ID_PROMOTION = P.ID AND P.REMOVED_BY_ADMIN = 1 and not exists (select 1 from PRODUCTS_PROMOTIONS PP where PP.ID_PROMOTION = P.ID))";
        String requestDeletePromotion = "delete from PROMOTIONS P where P.REMOVED_BY_ADMIN = 1 and not exists (select 1 from PRODUCTS_PROMOTIONS PP where PP.ID_PROMOTION = P.ID)";
        new PreparedSentence(this.s, requestDeleteMultiLanguagePromotion, null).exec();
        new PreparedSentence(this.s, requestDeletePromotion, null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'CARTE_ITEM', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'CARTE_MENU', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SUPPLEMENT_ITEM', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'ITEM_INGREDIENTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'ITEM_SUPPLEMENTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'ADDITIONAL_SALES', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'PRODUCTS_PROMOTIONS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SUB_PRODUCTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'PRODUCT_DAYS_ON', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'PRODUCTS_PRICES', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SHIFT_PRODUCT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'IMAGES_PRODUCTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'MULTILANGUAGE_PRODUCT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'NUTRITIONAL', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'ALLERGENE', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'HISTORIQUE_STOCK', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'PRODUCTS_SIZE', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SCREENS_PRODUCT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'PRODUCTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TAGS_CATEGORIES', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'CATEGORY_DAYS_ON', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SHIFT_CATEGORY', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'MULTILANGUAGE_CATEGORY', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'CATEGORIES', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SUPPLEMENTS_GROUPE', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'ALLERGENE_SUPPLEMENT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'MULTILANGUAGE_SUPPLEMENT_ITEM', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SUB_SUPPLEMENTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SUPPLEMENT_ITEM_PRICES', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SCREENS_SUPPLEMENT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'MULTILANGUAGE_GROUPE_SUB_SUPPLEMENTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'GROUPE_SUB_SUPPLEMENTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SCREENS_GROUP_SUPPLEMENT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'MULTILANGUAGE_SUPPLEMENT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'SUPPLEMENT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'MULTILANGUAGE_CARTE', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'CARTE', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'MULTILANGUAGE_PROMOTION', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'PROMOTIONS', 0)", null).exec();
        System.out.println("end purge items : " + new Date());
    }
}

