/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerWriteInteger;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.models.Employee;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.StaticSentence;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public class DataLogicEmployees
extends BeanFactoryDataSingle {
    protected Session s;
    protected PreparedStatement pstmt;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private String requestEmployee = "SELECT E.ID, E.NAME_EMPLOYEE, E.PHONE, E.CREDIT, E.EMAIL, E.FUNCTION_EMPLOYEE, E.CODE_CARTE, E.FIXED_AMOUNT FROM EMPLOYEES E ";

    @Override
    public void init(Session s) {
        this.s = s;
    }

    public void addEmployee(final Employee employee) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO EMPLOYEES (NAME_EMPLOYEE, PHONE, CREDIT, FUNCTION_EMPLOYEE, CODE_CARTE, FIXED_AMOUNT) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, employee.getName());
                this.setString(2, employee.getPhone());
                this.setDouble(3, employee.getCredit());
                this.setString(4, employee.getFonction());
                this.setString(5, employee.getCode_carte());
                this.setDouble(6, employee.getFixed_amount());
            }
        });
    }

    public void updateEmployee(final Employee employee) throws BasicException {
        new PreparedSentence(this.s, "UPDATE EMPLOYEES SET NAME_EMPLOYEE = ?, PHONE = ?, CREDIT = ?, FUNCTION_EMPLOYEE = ?, CODE_CARTE = ?, FIXED_AMOUNT = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, employee.getName());
                this.setString(2, employee.getPhone());
                this.setDouble(3, employee.getCredit());
                this.setString(4, employee.getFonction());
                this.setString(5, employee.getCode_carte());
                this.setDouble(6, employee.getFixed_amount());
                this.setInt(7, employee.getId());
            }
        });
    }

    public List<Employee> getEmployees() throws BasicException {
        return new PreparedSentence(this.s, this.requestEmployee + "WHERE E.REMOVED = 0 ", null, Employee.getSerializerRead()).list();
    }

    public Employee getEmployeesByName(String name) throws BasicException {
        return (Employee)new PreparedSentence(this.s, this.requestEmployee + "WHERE E.REMOVED = 0 AND E.NAME_EMPLOYEE = ? ", SerializerWriteString.INSTANCE, Employee.getSerializerRead()).find((Object)name);
    }

    public Employee getEmployeeByCarte(String code_carte) throws BasicException {
        return (Employee)new PreparedSentence(this.s, this.requestEmployee + "WHERE E.REMOVED = 0 AND E.CODE_CARTE = ? ", SerializerWriteString.INSTANCE, Employee.getSerializerRead()).find((Object)code_carte);
    }

    public Employee getEmployeesById(int id) throws BasicException {
        return (Employee)new PreparedSentence(this.s, this.requestEmployee + "WHERE E.REMOVED = 0 AND E.ID = ? ", SerializerWriteInteger.INSTANCE, Employee.getSerializerRead()).find((Object)id);
    }

    private void changeValCredit(final int id_employee, final double amount, final boolean increase) throws BasicException {
        final Employee employee = this.getEmployeesById(id_employee);
        new PreparedSentence(this.s, "UPDATE EMPLOYEES SET CREDIT = ? WHERE ID = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                if (increase) {
                    this.setDouble(1, NumericUtils.round(employee.getCredit() + amount));
                } else {
                    this.setDouble(1, NumericUtils.round(employee.getCredit() - amount));
                }
                this.setInt(2, id_employee);
            }
        });
    }

    public void addTransactionEmployee(final PaymentInfo payment, final TicketInfo order) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO CREDIT_EMPLOYEE (AMOUNT, DATE_PAYMENT, EMPLOYEE, TICKET, PAYMENT) VALUES (?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, NumericUtils.round(payment.getPaid()));
                this.setTimestamp(2, new Date());
                this.setInt(3, payment.getIdEmployee());
                this.setString(4, order.getId());
                this.setString(5, payment.getId());
            }
        });
        this.changeValCredit(payment.getIdEmployee(), payment.getPaid(), false);
    }

    public void deleteTransactionEmployee(String id_payment) throws BasicException {
        Object[] infos_emplpoyee = (Object[])new StaticSentence(this.s, "SELECT AMOUNT, EMPLOYEE FROM CREDIT_EMPLOYEE WHERE PAYMENT = ? ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.DOUBLE, Datas.INT})).find((Object)id_payment);
        if (infos_emplpoyee != null) {
            this.changeValCredit((Integer)infos_emplpoyee[1], (Double)infos_emplpoyee[0], true);
            new PreparedSentence(this.s, "DELETE FROM CREDIT_EMPLOYEE WHERE PAYMENT = ? ", SerializerWriteString.INSTANCE).exec((Object)id_payment);
        }
    }

    public void incrementeCredit() throws BasicException {
        new PreparedSentence(this.s, "UPDATE EMPLOYEES SET CREDIT = CREDIT + FIXED_AMOUNT", null).exec();
        this.updateDateMAJ();
    }

    private void updateDateMAJ() throws BasicException {
        new PreparedSentence(this.s, "UPDATE RECHARGE_CREDIT_EMPLOYEE SET DATE_MAJ = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, new Date());
            }
        });
    }

    public int getMonthUpdated() throws BasicException {
        Object[] month_saved = (Object[])new StaticSentence(this.s, "SELECT MONTH(DATE_MAJ)  FROM RECHARGE_CREDIT_EMPLOYEE ", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find();
        if (month_saved != null) {
            return (Integer)month_saved[0];
        }
        return -1;
    }
}

