/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DAOConstants;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.loader.SerializerWriteInteger;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.openbravo.pos.ticket.ItemLine;
import com.openbravo.pos.ticket.LineKitchen;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketKitchen;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.NumericUtils;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.sql.PreparedSentence;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DataLogicDK
extends BeanFactoryDataSingle {
    protected Session s;
    protected PreparedStatement pstmt;
    private DataLogicSales m_dlSales = null;
    private String requestTicketKitchen;
    private String requestLineKitchen;

    public DataLogicDK() throws SQLException {
        this.initializer();
        this.m_dlSales = new DataLogicSales();
    }

    private void initializer() throws SQLException {
        String db_url = AppLocal.db_url;
    }

    @Override
    public void init(Session s) {
        this.s = s;
        if (this.m_dlSales != null) {
            this.m_dlSales.init(s);
            this.requestLineKitchen = "SELECT ID, TICKET, PRODUCT, UNITS, NOTE, SIZE_PRODUCT, FINISHED, SUPPLEMENTS, INGREDIENTS, " + DAOConstants.SQLFunction + "(ID_LINE, -1) as ID_LINE, STATUS , PAID, NUMLINE, LINES_SIZE, AFTER_SEPARATOR, PLACE_SERVED, TIME_SERVED, " + DAOConstants.SQLFunction + "(NUMERO_LINE, 0) as NUMERO_LINE,  LABEL, INGREDIENTS_INCLUS, FINISHED_DATE, PRINT_WARNING, PRINTER_KITCHEN ";
            this.requestTicketKitchen = "SELECT ID, TOTAL, TYPE_ORDER, CREATED, CAISSE, NUM_ORDER, NUM_TABLE, BIPPER, COUVERTS, FINISHED, DATE_ORDER, STATUS, ID_TICKET ";
        }
    }

    private TicketKitchen getTicketByIdSource(TicketInfo ticket) throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicketKitchen + "FROM TICKETS_KITCHEN  WHERE ID_TICKET = ?", SerializerWriteString.INSTANCE, TicketKitchen.getSerializerRead()).list((Object)ticket.getId());
        for (TicketKitchen ticketSource : tickets) {
            if (ticketSource.getCaisse() == null || !ticketSource.getCaisse().equals(ticket.getCaisse())) continue;
            return ticketSource;
        }
        return tickets.size() > 0 ? (TicketKitchen)tickets.get(0) : null;
    }

    public void updateOrderKitchen(TicketInfo ticket) throws SQLException, BasicException {
        TicketKitchen oldTicket = this.getTicketByIdSource(ticket);
        if (oldTicket != null) {
            int idTicket = oldTicket.getId();
            List<LineKitchen> oldLines = this.loadLines(idTicket);
            for (LineKitchen lineKitchen : oldLines) {
                boolean found = false;
                for (TicketLineInfo line : ticket.getLines()) {
                    if (lineKitchen.getId_line_source() != line.getID()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.changeStatusLine(lineKitchen.getId(), "Annul\u00e9");
            }
            oldTicket.setType_order(ticket.getType());
            oldTicket.setBipper(ticket.getBipper());
            oldTicket.setNum_table(ticket.getNumTable());
            oldTicket.setCouverts(ticket.getCouverts());
            this.updateTicketKitchen(oldTicket);
            String afterSeparator = "Not Separated";
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.isNext()) continue;
                afterSeparator = line.getTime_served().equals("later") ? "Emporter plus tard" : "Not Separated";
                if (this.getLineBySource(line.getID(), oldTicket.getId()) == null) {
                    int i = 0;
                    while ((double)i < line.getMultiply()) {
                        this.addLineKitchen(line, idTicket, true, ticket.getNumberLine2(), afterSeparator, 0);
                        ++i;
                    }
                    continue;
                }
                double unit = line.getMultiply() - (double)this.getLinesBySource(line.getID(), oldTicket.getId()).size();
                this.updateLineKitchen(line);
                if (!(unit > 0.0)) continue;
                int i = 0;
                while ((double)i < unit) {
                    this.addLineKitchen(line, idTicket, true, ticket.getNumberLine2(), afterSeparator, 0);
                    ++i;
                }
            }
            List<LineKitchen> list = this.loadLinesSort(oldTicket.getId());
            int size = list.size();
            int numero_line = 1;
            for (LineKitchen line : list) {
                this.updateInfoLabel(numero_line, line, size);
                ++numero_line;
            }
        }
    }

    public void addOrderKitchen(TicketInfo ticket) throws SQLException, BasicException {
        TicketKitchen dest = this.getTicketByIdSource(ticket);
        if (dest == null) {
            int idTicket = this.addOrder(ticket);
            String afterSeparator = "Not Separated";
            int numero_line = 1;
            for (TicketLineInfo line : ticket.getLines()) {
                if (line.isNext()) continue;
                afterSeparator = line.getTime_served().equals("later") ? "Emporter plus tard" : "Not Separated";
                int i = 0;
                while ((double)i < line.getMultiply()) {
                    this.addLineKitchen(line, idTicket, false, ticket.getNumberLine2(), afterSeparator, numero_line);
                    ++numero_line;
                    ++i;
                }
            }
            List<LineKitchen> lines = this.loadLines(idTicket);
            int size = lines.size();
            for (LineKitchen lineKitchen : lines) {
                this.updateSizeLine(lineKitchen, size);
            }
        }
    }

    private int addOrder(TicketInfo ticket) throws SQLException {
        String SQL = "INSERT INTO TICKETS_KITCHEN (TOTAL, TYPE_ORDER, CAISSE, NUM_ORDER, NUM_TABLE, BIPPER, COUVERTS, DATE_ORDER, STATUS, ID_TICKET) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setDouble(1, NumericUtils.round(ticket.getTotal()));
        this.pstmt.setString(2, ticket.getType());
        this.pstmt.setString(3, AppLocal.source_order);
        this.pstmt.setInt(4, ticket.getNumero_order());
        this.pstmt.setInt(5, ticket.getNumTable());
        this.pstmt.setInt(6, ticket.getBipper());
        this.pstmt.setInt(7, ticket.getCouverts());
        this.pstmt.setTimestamp(8, new Timestamp(ticket.getDate().getTime()));
        this.pstmt.setString(9, "pending");
        this.pstmt.setString(10, ticket.getId());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idResult = -1;
        if (rs.next()) {
            int last_inserted_id;
            idResult = last_inserted_id = rs.getInt(1);
        }
        return idResult;
    }

    private void addLineKitchen(TicketLineInfo line, int idTicket, boolean updated, int size, String afterSepartor, int numero_line) throws BasicException, SQLException {
        String SQL = "INSERT INTO LINES_KITCHEN (TICKET, PRODUCT, UNITS, NOTE, SIZE_PRODUCT, SUPPLEMENTS, INGREDIENTS, ID_LINE, PAID, NUMLINE, LINES_SIZE, AFTER_SEPARATOR, PLACE_SERVED, TIME_SERVED, LABEL, INGREDIENTS_INCLUS, PRINTER_KITCHEN) VALUES (?, ?, ?, ?, ?, ?, ?, ? ,?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.pstmt = this.s.getConnection().prepareStatement(SQL, 1);
        this.pstmt.setInt(1, idTicket);
        this.pstmt.setString(2, line.getProductName());
        this.pstmt.setDouble(3, 1.0);
        this.pstmt.setString(4, line.getNote());
        this.pstmt.setString(5, line.getSizeProduct());
        this.pstmt.setString(6, line.getSupplement());
        this.pstmt.setString(7, line.getIngredients());
        this.pstmt.setInt(8, line.getID());
        this.pstmt.setBoolean(9, line.isPaid());
        this.pstmt.setInt(10, line.getNumLine());
        this.pstmt.setInt(11, size);
        this.pstmt.setString(12, afterSepartor);
        this.pstmt.setString(13, line.getPlace_served());
        this.pstmt.setString(14, line.getTime_served());
        this.pstmt.setBoolean(15, line.isLabel());
        this.pstmt.setString(16, line.getIngredientsInclus());
        this.pstmt.setString(17, line.getPrinter_kitchen());
        this.pstmt.executeUpdate();
        ResultSet rs = this.pstmt.getGeneratedKeys();
        int idResult = -1;
        if (rs.next()) {
            int last_inserted_id;
            idResult = last_inserted_id = rs.getInt(1);
        }
        if (numero_line != 0) {
            this.updateNumLine(idResult, numero_line);
        }
        if (updated) {
            this.changeStatusLine(idResult, "Modifi\u00e9");
        }
        for (ProductTicket product : line.getListProducts()) {
            this.addLineItem(product, line, idResult);
        }
    }

    public List<ItemLine> loadItems(int line) throws BasicException {
        List items = new PreparedSentence(this.s, "SELECT ID, LINE, PRODUCT, UNITS, SIZE_PRODUCT, SUPPLEMENTS, INGREDIENTS, " + DAOConstants.SQLFunction + "(ID_PRODUCT, -1) as ID_PRODUCT FROM ITEMS_LINE  WHERE LINE = ? ", SerializerWriteInteger.INSTANCE, ItemLine.getSerializerRead()).list((Object)line);
        return items;
    }

    private LineKitchen getLineBySource(final int idLine, final int idTicket) throws BasicException {
        LineKitchen line = (LineKitchen)new PreparedSentence(this.s, this.requestLineKitchen + "FROM LINES_KITCHEN  WHERE ID_LINE = ? AND TICKET = ? ", SerializerWriteParams.INSTANCE, LineKitchen.getSerializerRead()).find((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idLine);
                this.setInt(2, idTicket);
            }
        });
        return line;
    }

    private List<LineKitchen> getLinesBySource(final int idLine, final int idTicket) throws BasicException {
        List lines = new PreparedSentence(this.s, this.requestLineKitchen + "FROM LINES_KITCHEN  WHERE ID_LINE = ? AND TICKET = ? ", SerializerWriteParams.INSTANCE, LineKitchen.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idLine);
                this.setInt(2, idTicket);
            }
        });
        return lines;
    }

    private LineKitchen getLineById(int idLine) throws BasicException {
        LineKitchen line = (LineKitchen)new PreparedSentence(this.s, this.requestLineKitchen + "FROM LINES_KITCHEN  WHERE ID = ? ", SerializerWriteInteger.INSTANCE, LineKitchen.getSerializerRead()).find((Object)idLine);
        return line;
    }

    public List<LineKitchen> loadLines(int ticket) throws BasicException {
        List lines = new PreparedSentence(this.s, this.requestLineKitchen + "FROM LINES_KITCHEN  WHERE TICKET = ? order by FINISHED, NUMERO_LINE ", SerializerWriteInteger.INSTANCE, LineKitchen.getSerializerRead()).list((Object)ticket);
        for (LineKitchen line : lines) {
            line.setItems(this.loadItems(line.getId()));
        }
        return lines;
    }

    public List<LineKitchen> loadLinesSort(int ticket) throws BasicException {
        List lines = new PreparedSentence(this.s, this.requestLineKitchen + "FROM LINES_KITCHEN  WHERE TICKET = ? order by ID ", SerializerWriteInteger.INSTANCE, LineKitchen.getSerializerRead()).list((Object)ticket);
        for (LineKitchen line : lines) {
            line.setItems(this.loadItems(line.getId()));
        }
        return lines;
    }

    public List<TicketKitchen> loadTicketsKitchen() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicketKitchen + "FROM TICKETS_KITCHEN  WHERE FINISHED = 0 AND STATUS = 'pending' ORDER BY CREATED ", null, TicketKitchen.getSerializerRead()).list();
        for (TicketKitchen ticket : tickets) {
            ticket.setLines(this.loadLines(ticket.getId()));
        }
        return tickets;
    }

    public void finishLine(final int id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE LINES_KITCHEN SET PRINT_WARNING = 0, FINISHED = 1, FINISHED_DATE=?  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, new Date());
                this.setInt(2, id);
            }
        });
    }

    public void cancelOrder(final int id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS_KITCHEN SET STATUS = 'canceled' WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    public void finishOrder(final int id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS_KITCHEN SET FINISHED = 1, STATUS = 'finished' WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }

    private void addLineItem(final ProductTicket product, final TicketLineInfo line, final int idLine) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO ITEMS_LINE(LINE, PRODUCT, UNITS, SIZE_PRODUCT, SUPPLEMENTS, INGREDIENTS, ID_PRODUCT) VALUES(?,?,?,?,?,?,?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, idLine);
                this.setString(2, product.getNameProduct());
                this.setDouble(3, Double.valueOf(product.getNumberProduct()));
                this.setString(4, null);
                this.setString(5, line.getItemSupplement(product));
                this.setString(6, line.getItemIngredients(product));
                this.setInt(7, product.getId());
            }
        });
    }

    public void updateTicketKitchen(final TicketKitchen ticket) throws BasicException {
        new PreparedSentence(this.s, "UPDATE TICKETS_KITCHEN SET TYPE_ORDER = ?, NUM_TABLE = ?, BIPPER = ?, COUVERTS = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, ticket.getType_order());
                this.setInt(2, ticket.getNum_table());
                this.setInt(3, ticket.getBipper());
                this.setInt(4, ticket.getCouverts());
                this.setInt(5, ticket.getId());
            }
        });
    }

    public void updateLineKitchen(final TicketLineInfo line) throws BasicException {
        new PreparedSentence(this.s, "UPDATE LINES_KITCHEN SET UNITS = ?, NOTE = ?, SUPPLEMENTS = ?, INGREDIENTS = ?, PLACE_SERVED = ?, TIME_SERVED = ?, NUMERO_LINE = ?, LABEL = ? WHERE ID_LINE = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, 1.0);
                this.setString(2, line.getNote());
                this.setString(3, line.getSupplement());
                this.setString(4, line.getIngredients());
                this.setString(5, line.getPlace_served());
                this.setString(6, line.getTime_served());
                this.setInt(7, line.getNumero_line());
                this.setBoolean(8, line.isLabel());
                this.setInt(9, line.getID());
            }
        });
    }

    public void updateItemsLine(final ProductTicket product, final TicketLineInfo line) throws BasicException {
        new PreparedSentence(this.s, "UPDATE ITEMS_LINE SET UNITS =  ?,  SUPPLEMENTS = ?, INGREDIENTS = ? WHERE ID_PRODUCT = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setDouble(1, Double.valueOf(product.getNumberProduct()));
                this.setString(2, line.getItemSupplement(product));
                this.setString(3, line.getItemIngredients(product));
                this.setInt(4, product.getId());
            }
        });
    }

    private void updateNumLine(final int idLine, final int numero_line) throws BasicException {
        new PreparedSentence(this.s, "UPDATE LINES_KITCHEN SET NUMERO_LINE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, numero_line);
                this.setInt(2, idLine);
            }
        });
    }

    private void changeStatusLine(final int idLine, final String status) throws BasicException {
        new PreparedSentence(this.s, "UPDATE LINES_KITCHEN SET STATUS = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, status);
                this.setInt(2, idLine);
            }
        });
    }

    public void preparefinishOrder(int idLine) throws BasicException {
        LineKitchen lineTicket = this.getLineById(idLine);
        boolean finished = true;
        List<LineKitchen> lines = this.loadLines(lineTicket.getTicket());
        for (LineKitchen line : lines) {
            if (line.isFinished()) continue;
            finished = false;
        }
        if (finished) {
            this.finishOrder(lineTicket.getTicket());
        }
    }

    public List<TicketKitchen> loadTicketsKitchenHistorik() throws BasicException {
        List tickets = new PreparedSentence(this.s, this.requestTicketKitchen + "FROM TICKETS_KITCHEN  WHERE FINISHED = 1 or STATUS = 'canceled' ORDER BY CREATED ", null, TicketKitchen.getSerializerRead()).list();
        for (TicketKitchen ticket : tickets) {
            ticket.setLines(this.loadLines(ticket.getId()));
        }
        return tickets;
    }

    public List<TicketKitchen> loadTicketsKitchenHistorik(Date myDate) throws BasicException {
        final Calendar cal = Calendar.getInstance();
        cal.setTime(myDate);
        List tickets = new PreparedSentence(this.s, this.requestTicketKitchen + "FROM TICKETS_KITCHEN  WHERE (year(created) = ? and month(created) = ? and DAY(created) = ? ) and (FINISHED = 1 or STATUS = 'canceled') ORDER BY CREATED ", SerializerWriteParams.INSTANCE, TicketKitchen.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, cal.get(1));
                this.setInt(2, cal.get(2) + 1);
                this.setInt(3, cal.get(5));
            }
        });
        for (TicketKitchen ticket : tickets) {
            ticket.setLines(this.loadLines(ticket.getId()));
        }
        return tickets;
    }

    public List<TicketKitchen> loadTicketsKitchen(Date myDate) throws BasicException {
        final Calendar cal = Calendar.getInstance();
        cal.setTime(myDate);
        List tickets = new PreparedSentence(this.s, this.requestTicketKitchen + "FROM TICKETS_KITCHEN  WHERE (year(created)=? and month(created)=? and day(created)=? ) AND( FINISHED = 0 AND STATUS <> 'canceled' )ORDER BY CREATED ", SerializerWriteParams.INSTANCE, TicketKitchen.getSerializerRead()).list((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, cal.get(1));
                this.setInt(2, cal.get(2) + 1);
                this.setInt(3, cal.get(5));
            }
        });
        for (TicketKitchen ticket : tickets) {
            ticket.setLines(this.loadLines(ticket.getId()));
        }
        return tickets;
    }

    private void updateInfoLabel(final int numero_line, final LineKitchen line, final int numberLine2) throws BasicException {
        new PreparedSentence(this.s, "UPDATE LINES_KITCHEN SET NUMERO_LINE = ?, LINES_SIZE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, numero_line);
                this.setInt(2, numberLine2);
                this.setInt(3, line.getId());
            }
        });
    }

    private void updateSizeLine(final LineKitchen line, final int numberLine2) throws BasicException {
        new PreparedSentence(this.s, "UPDATE LINES_KITCHEN SET LINES_SIZE = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, numberLine2);
                this.setInt(2, line.getId());
            }
        });
    }

    public void setPrintWarning(final int id) throws BasicException {
        new PreparedSentence(this.s, "UPDATE LINES_KITCHEN SET PRINT_WARNING = 1  WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setInt(1, id);
            }
        });
    }
}

