/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.selfCheckout;

import com.biborne.executors.BiborneExecutors;
import com.biborne.fxmlcache.FXMLCacheEntry;
import com.biborne.fxmlcache.FXMLCacheManager;
import com.openbravo.basic.BasicException;
import com.openbravo.controllers.selfCheckout.SummaryOrderSelfSheckout;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.StringUtils;
import com.openbravo.postgresql.db.PostgreService;
import com.openbravo.service.ClotureService;
import com.openbravo.service.ItemService;
import fr.protactile.kitchen.dao.entities.Tickets;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.procaisse.services.ZGlobalService;
import fr.protactile.procaisse.tasks.AppTimerRunnable;
import fr.protactile.procaisse.tasks.AppTimerTask;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;

public class SelfCheckoutController
implements AppTimerRunnable {
    private Scene scene;
    private JRootApp m_App;
    @FXML
    GridPane main_pane;
    @FXML
    Label label_background_main;
    @FXML
    Label label_logo;
    @FXML
    Button btn_exit;
    private TextField jTextFieldQRCodeScanner;
    private List<Integer> ids_tickets_kitchen;
    private TicketInfo ticket;
    private SummaryOrderSelfSheckout mSummaryOrderSelfSheckout;
    private Scene orderScene;
    private ClotureService clotureService;
    private Image image_logo;
    private AppTimerTask mAppTimerTask;
    @FXML
    GridPane pane_bloc_cloture;
    @FXML
    Label label_cloture;
    @FXML
    GridPane second_pane;
    private PostgreService mPostgreService = null;
    private ZGlobalService mZGlobalService;
    private FilerUtils m_FilerUtils = null;
    private final ExecutorService stExecutor = BiborneExecutors.getSingleThreadExecutor();
    private EventHandler mEventHandlerQRCodeKeyReleased = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                SelfCheckoutController.this.appendTicketScanner(SelfCheckoutController.this.jTextFieldQRCodeScanner.getText());
                SelfCheckoutController.this.jTextFieldQRCodeScanner.requestFocus();
            }
        }
    };

    public void initialize(JRootApp app, Scene scene) throws BasicException {
        try {
            this.m_FilerUtils = FilerUtils.getInstance();
            this.jTextFieldQRCodeScanner = new TextField();
            this.ids_tickets_kitchen = new ArrayList<Integer>();
            double height = AppVarUtils.getScreenDimension().getHeight();
            double width = AppVarUtils.getScreenDimension().getWidth();
            this.scene = scene;
            this.m_App = app;
            Image img_back = this.setImageBackGround();
            ImageView imageview = new ImageView(img_back);
            imageview.setFitHeight(height);
            imageview.setFitWidth(width);
            this.label_background_main.setPrefHeight(height);
            this.label_background_main.setPrefWidth(width);
            this.label_background_main.setGraphic((Node)imageview);
            this.initQRCodeScanner();
            System.out.println("+++++++++++++++jTextFieldQRCodeScanner :" + this.jTextFieldQRCodeScanner.getText());
            this.jTextFieldQRCodeScanner.setPrefWidth(width);
            this.jTextFieldQRCodeScanner.setPrefHeight(0.0);
            this.jTextFieldQRCodeScanner.setManaged(false);
            this.main_pane.getChildren().clear();
            this.pane_bloc_cloture.getChildren().clear();
            this.pane_bloc_cloture.setPrefHeight(height * 0.05);
            this.pane_bloc_cloture.setPrefWidth(width);
            this.label_cloture.setPrefHeight(height * 0.05);
            this.label_cloture.setPrefWidth(width);
            this.main_pane.add((Node)this.label_background_main, 0, 0);
            this.main_pane.add((Node)this.label_logo, 0, 0);
            this.main_pane.add((Node)this.pane_bloc_cloture, 0, 0);
            this.main_pane.add((Node)this.jTextFieldQRCodeScanner, 0, 0);
            this.main_pane.requestLayout();
            this.main_pane.layout();
            this.jTextFieldQRCodeScanner.setOnKeyReleased(this.mEventHandlerQRCodeKeyReleased);
            this.clotureService = ClotureService.getInstance(AppLocal.dlSales, this.m_App);
            this.label_logo.setPrefHeight(height);
            this.label_logo.setPrefWidth(width);
            this.setLogo(height * 0.2);
            this.mAppTimerTask = AppTimerTask.getInstance(this);
            Date today = new Date();
            if (!(this.m_App.getM_dlItems().isClotured("j", today) || this.m_App.getM_dlItems().isClotured("m", today) || this.m_App.getM_dlItems().isClotured("a", today))) {
                System.out.println("++++++++++++++++++ cloture start 1 ");
                this.clotureCaisse(true);
            }
            this.pane_bloc_cloture.setOnMouseClicked(event -> {
                if (event.getClickCount() == 6) {
                    this.exit();
                }
            });
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void initQRCodeScanner() {
        this.jTextFieldQRCodeScanner.setVisible(true);
        this.jTextFieldQRCodeScanner.requestFocus();
        this.jTextFieldQRCodeScanner.setText("");
        this.jTextFieldQRCodeScanner.getProperties().put((Object)"vkType", (Object)4);
    }

    private void appendTicketScanner(String data) {
        this.stExecutor.execute(() -> {
            try {
                AppLocal.table = null;
                TicketInfo ticketInfo = null;
                if (AppLocal.KITCHEN_COMPOSITE) {
                    TicketSharedService ticketSharedService = TicketSharedService.getInstance();
                    Tickets order = null;
                    String result_id = StringUtils.asLineWithSpaceSeparation(data);
                    System.out.println("++++++++++++result_id " + result_id);
                    if (result_id != null) {
                        int id_order = Integer.parseInt(result_id);
                        order = ticketSharedService.getOrderById(id_order);
                    }
                    if (order != null) {
                        System.out.println("++++++++++++order " + order.toString());
                        ticketInfo = TicketInfoBuilder.create(AppLocal.dlSales).order(order).build().toTicketInfo();
                    } else {
                        Platform.runLater(() -> {
                            this.jTextFieldQRCodeScanner.requestFocus();
                            this.jTextFieldQRCodeScanner.setText("");
                        });
                    }
                } else {
                    List<String> arrays = StringUtils.asLinesWithCommaSeparation(data);
                    ticketInfo = TicketInfoBuilder.create(AppLocal.dlSales).build(arrays).toTicketInfo();
                }
                System.out.println("ticketInfo?" + ticketInfo);
                if (ticketInfo != null) {
                    System.out.println("+++++++++++++++++++ ticketInfo getLines" + ticketInfo.getLines());
                    this.loadTicketSelfCheckout(ticketInfo);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                Platform.runLater(() -> {
                    this.jTextFieldQRCodeScanner.requestFocus();
                    this.jTextFieldQRCodeScanner.setText("");
                });
            }
        });
    }

    public void loadTicketSelfCheckout(TicketInfo ticketBorne) {
        AppLocal.ticketBorne = ticketBorne;
        this.validOrder();
        System.out.println("+++++++++++++++++ ticketBorne.getLines()" + ticketBorne.getLines());
    }

    public void validOrder() {
        if (!AppLocal.ticketBorne.getLines().isEmpty()) {
            try {
                if (this.mSummaryOrderSelfSheckout == null || this.orderScene == null) {
                    System.out.println("++++++++++++++++++ here ");
                    FXMLCacheEntry fxmlCacheEntry = FXMLCacheManager.loadFXML("/fx/selfcheckout/summary_page_checkout.fxml");
                    Parent rootNode = fxmlCacheEntry.getRootNode();
                    this.mSummaryOrderSelfSheckout = (SummaryOrderSelfSheckout)fxmlCacheEntry.getController();
                    this.orderScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                    this.orderScene.getStylesheets().add((Object)"/styles/styles.css");
                    this.orderScene.getStylesheets().add((Object)"/styles/app.css");
                    Platform.runLater(() -> {
                        try {
                            this.mSummaryOrderSelfSheckout.initialize(this.m_App, this, this.orderScene);
                            this.clotureService.addPropertyChangeListener(this.mSummaryOrderSelfSheckout);
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    });
                }
                Platform.runLater(() -> {
                    try {
                        this.mSummaryOrderSelfSheckout.loadInfoPromoAndBasket();
                        this.m_App.getFxPanel().setScene(this.orderScene);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                });
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            this.jTextFieldQRCodeScanner.setText("");
        }
    }

    public Scene getScene() {
        return this.scene;
    }

    private void setLogo(double hieght) {
        File image;
        ImageView background_log = new ImageView();
        if (AppLocal.LOGO_BORNE != null && !AppLocal.LOGO_BORNE.isEmpty() && (image = new File(new File(System.getProperty("user.home")), "images/logos/" + AppLocal.LOGO_BORNE)).exists()) {
            this.image_logo = new Image(image.toURI().toString());
        }
        if (this.image_logo == null) {
            try {
                this.image_logo = new Image(this.getClass().getResource("/com/openbravo/images/logo_biborne_selfcheckout.png").toURI().toString());
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        System.out.println("++++++++image_logo " + this.image_logo.getUrl().toString());
        background_log.setImage(this.image_logo);
        background_log.setFitWidth(AppVarUtils.getScreenDimension().getWidth() * 0.7);
        background_log.setFitWidth(hieght);
        background_log.setPreserveRatio(true);
        background_log.setSmooth(true);
        background_log.setCache(true);
        this.label_logo.setGraphic((Node)background_log);
        this.label_logo.setAlignment(Pos.TOP_CENTER);
        GridPane.setValignment((Node)this.label_logo, (VPos)VPos.TOP);
        GridPane.setHalignment((Node)this.label_logo, (HPos)HPos.CENTER);
    }

    @Override
    public void executor() {
        Date now = new Date();
        if (now.getHours() == 6 && now.getMinutes() == 1 && now.getSeconds() == 0) {
            try {
                this.clotureService.doClotureAutomatiqueSelfCheckout(now);
                ItemService mItemService = ItemService.getInstance();
                mItemService.changeStorableProducts();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (this.mAppTimerTask.shouldCloseBorne()) {
            this.m_App.showSelfcheckoutWithoutCashlogy();
        }
    }

    @Override
    public void doFinalize() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            Logger.getLogger(SelfCheckoutController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reload() {
        System.out.println("++++++++++++ reload" + AppLocal.START_CLOTURE);
        if (AppLocal.START_CLOTURE) {
            System.out.println("+++++++++++++ show bloc cloture");
            this.showBlocInfoCloture();
        } else {
            System.out.println("+++++++++++++ hide bloc cloture");
            this.hideBlocInfoCloture();
        }
    }

    private void showBlocInfoCloture() {
        this.pane_bloc_cloture.getChildren().clear();
        this.pane_bloc_cloture.add((Node)this.label_cloture, 0, 0);
    }

    private void hideBlocInfoCloture() {
        this.pane_bloc_cloture.getChildren().clear();
    }

    public void clotureCaisse(final boolean borne) {
        final Calendar cal = Calendar.getInstance();
        final Date today = new Date();
        cal.setTime(today);
        cal.add(5, -1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("+++++++++++++ cal.getTime() : " + cal.getTime());
                System.out.println("++++++ m_appview.getM_dlItems().isFirstDay() : " + SelfCheckoutController.this.m_App.getM_dlItems().isFirstDay());
                if (!SelfCheckoutController.this.m_App.getM_dlItems().isFirstDay() && !SelfCheckoutController.this.m_App.getM_dlItems().isClotured("j", cal.getTime()) && DateUtils.isAfterHour(today, 6)) {
                    AppLocal.START_CLOTURE = true;
                    Platform.runLater(() -> SelfCheckoutController.this.reload());
                    try {
                        System.out.println("++++++++++++++++ cloture day");
                        SelfCheckoutController.this.clotureService.closeCaisseAutomatiqueDay(false);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
                cal.setTime(today);
                cal.add(2, -1);
                if (!SelfCheckoutController.this.m_App.getM_dlItems().isFirstMonth() && !SelfCheckoutController.this.m_App.getM_dlItems().isClotured("m", cal.getTime()) && DateUtils.isAfterHour(today, 6)) {
                    try {
                        if (!AppLocal.START_CLOTURE) {
                            AppLocal.START_CLOTURE = true;
                            Platform.runLater(() -> SelfCheckoutController.this.reload());
                        }
                        SelfCheckoutController.this.clotureService.closeCaisseAutomatiqueMonth(false);
                        if (!borne) {
                            AppLocal.isBackupRecomended = true;
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
                if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
                    SelfCheckoutController.this.mPostgreService = PostgreService.getInstance();
                    SelfCheckoutController.this.mPostgreService.SendDataToPostgree();
                    SelfCheckoutController.this.mPostgreService.doSynchronizeOrderDataTimer();
                }
                SelfCheckoutController.this.mZGlobalService = ZGlobalService.getInstance();
                SelfCheckoutController.this.mZGlobalService.addToZGlobal("self_checkout");
                AppLocal.START_CLOTURE = false;
                Platform.runLater(() -> SelfCheckoutController.this.reload());
            }
        }).start();
    }

    private Image setImageBackGround() throws URISyntaxException {
        File image_path;
        Image image = null;
        String path = AppLocal.BACKGROUND_SELF_CHECKOUT;
        double heightImage = AppVarUtils.getScreenDimension().getHeight();
        if (path != null && !path.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path)) != null && image_path.exists()) {
            image = new Image(image_path.toURI().toString());
        }
        if (image == null) {
            image = new Image(this.getClass().getResource("/com/openbravo/images/Scan_Code.png").toURI().toString());
        }
        return image;
    }

    private void exit() {
        this.m_App.showCaisse();
    }
}

