/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.selfCheckout;

import com.biborne.executors.BiborneExecutors;
import com.biborne.fxmlcache.FXMLCacheEntry;
import com.biborne.fxmlcache.FXMLCacheManager;
import com.openbravo.basic.BasicException;
import com.openbravo.beans.TrackPayement;
import com.openbravo.cashlogy.services.CashLogyServices;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.borne.EaselNumberController;
import com.openbravo.controllers.borne.MessageComptoirController;
import com.openbravo.controllers.borne.PaymentCBController;
import com.openbravo.controllers.selfCheckout.SelfCheckoutController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.tpeCB.PaymentByCardFacade;
import java.awt.Dimension;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;

public class PaymentOrderSelfCheckout {
    private JRootApp m_App;
    @FXML
    ImageView logo;
    @FXML
    Button btn_cb;
    @FXML
    Button btn_comptoir;
    @FXML
    Button btn_cash;
    @FXML
    FlowPane main_pane;
    @FXML
    ImageView background;
    @FXML
    private GridPane center_pane;
    @FXML
    private GridPane pane_type;
    @FXML
    private GridPane pane_button;
    @FXML
    private Button btn_cancel;
    @FXML
    private Button btn_valid;
    @FXML
    Label label_logo;
    private String color_hex;
    private Scene selfcheckout_scene;
    private SelfCheckoutController mSelfCheckoutController;
    private String fond_color_hex;
    Dimension dim = AppVarUtils.getScreenDimension();
    private PaymentCBController mPaymentCBController;
    private Scene paymentCBScene;
    private MessageComptoirController mMessageComptoirController;
    private Scene paymentComptoirScene;
    private TicketService mTicketService;
    private String easel_number_fxml = "/fx/templates/borne/popUp_easel_number.fxml";
    private LazyModal mLazyModalEaselNumber = null;
    private EventHiddenModal mActionEventEaselNumber = null;
    private Scene scene;
    private TrackPayement trackPayment;
    private Image image_background;
    private Image image_background_message;
    private Image image_message_cashlogy;
    private double heightImage = AppVarUtils.getScreenDimension().getHeight();
    private Image image_logo;
    private double totalorder;
    private final ExecutorService stExecutor = BiborneExecutors.getSingleThreadExecutor();
    private final ScheduledExecutorService stScheduledExecutor = BiborneExecutors.getSingleThreadScheduledExecutor();

    public void initialize(JRootApp app, SelfCheckoutController mSelfCheckoutController, Scene paymentOrderScene) throws BasicException {
        try {
            this.m_App = app;
            double height = AppVarUtils.getScreenDimension().getHeight();
            double width = AppVarUtils.getScreenDimension().getWidth();
            this.scene = paymentOrderScene;
            this.mSelfCheckoutController = mSelfCheckoutController;
            this.selfcheckout_scene = mSelfCheckoutController.getScene();
            this.mTicketService = TicketService.getInstance();
            this.mTicketService.setMPopUpTicketDateError(this.selfcheckout_scene);
            this.fond_color_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
            this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
            this.main_pane.setStyle("-fx-background-color: " + this.color_hex + ";");
            System.out.println("center_pane: " + this.center_pane);
            System.out.println("******* AppLocal.ALLOW_CASH_ONLY_SELF_CHECKOUT :" + AppLocal.ALLOW_CASH_ONLY_SELF_CHECKOUT);
            if (AppLocal.ALLOW_CASH_ONLY_SELF_CHECKOUT) {
                this.center_pane.getChildren().clear();
                this.loadMessageAndDoPaymentCashlogy();
            } else {
                this.btn_cb.setStyle("-fx-background-color: transparent;");
                this.btn_comptoir.setStyle("-fx-background-color: transparent;");
                this.btn_cash.setStyle("-fx-background-color: transparent;");
                this.addIconToButton();
                if (this.center_pane == null) {
                    System.err.println("center_pane is null");
                } else {
                    this.center_pane.getChildren().clear();
                    if (this.pane_type != null) {
                        this.center_pane.add((Node)this.pane_type, 0, 0);
                    } else {
                        System.err.println("pane_type is null");
                    }
                    if (this.pane_button != null) {
                        this.pane_button.getChildren().clear();
                        this.center_pane.add((Node)this.pane_button, 0, 1);
                    } else {
                        System.err.println("pane_buttons is null");
                    }
                }
                this.btn_valid.setStyle("-fx-border-radius: 25px; -fx-border-width: 3px; -fx-border-color: #FFFFFF; -fx-background-color: #0CA858; -fx-background-radius: 25px; -fx-text-fill: #FFFFFF; -fx-font-family: 'Roboto'; -fx-font-size: 25.126px; -fx-font-style: normal; -fx-font-weight: 700; -fx-text-transform: uppercase; -fx-padding: 10;");
                this.image_background = null;
                this.image_message_cashlogy = null;
                this.image_background_message = null;
                this.setImageBackGround();
            }
            this.label_logo.setPrefHeight(height);
            this.label_logo.setPrefWidth(width);
            this.setLogo(height * 0.2);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void chooseCB() {
        AppLocal.ticketBorne.setModePayment("CB");
        this.selected(this.btn_cb);
        this.deselected(this.btn_comptoir);
        this.deselected(this.btn_cash);
    }

    @FXML
    public void next() {
        if (AppLocal.ticketBorne.getModePayment() != null) {
            if (AppLocal.ticketBorne.getModePayment().equals("CB")) {
                int resultPing;
                PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
                if (facade.isTransactionSuccessed(resultPing = facade.doPing())) {
                    if (AppLocal.ADD_EASEL_NUMBER && AppLocal.ticketBorne.getType() != null && AppLocal.ticketBorne.getType().equalsIgnoreCase("Sur Place")) {
                        this.loadPopUpEaselNumber();
                    } else {
                        this.showPaymentCB();
                    }
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le payement en Carte Blue n'est pas connect\u00e9.", 4000, NPosition.CENTER);
                }
            } else if (AppLocal.ticketBorne.getModePayment().equals("Espece")) {
                if (AppLocal.CASHLOGY_ENABLED) {
                    try {
                        this.loadMessageAndDoPaymentCashlogy();
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(PaymentOrderSelfCheckout.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else {
                this.showMessageComptoir();
            }
        }
    }

    private void showPaymentCB() {
        this.stExecutor.execute(() -> {
            if (this.mTicketService.isValidPeriodWithoutAlert()) {
                try {
                    if (this.mPaymentCBController == null || this.paymentCBScene == null) {
                        FXMLCacheEntry fxmlCacheEntry = FXMLCacheManager.loadFXML("/fx/templates/borne/payment_cb.fxml");
                        Parent rootNode = fxmlCacheEntry.getRootNode();
                        this.mPaymentCBController = (PaymentCBController)fxmlCacheEntry.getController();
                        this.paymentCBScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                        this.paymentCBScene.getStylesheets().add((Object)"/styles/styles.css");
                        this.paymentCBScene.getStylesheets().add((Object)"/styles/app.css");
                        Platform.runLater(() -> {
                            try {
                                this.mPaymentCBController.initialize(this.m_App);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        });
                    }
                    Platform.runLater(() -> {
                        try {
                            this.m_App.getFxPanel().setScene(this.paymentCBScene);
                            this.mPaymentCBController.doPayementEndShowMessageSelfCheckout(this.mSelfCheckoutController);
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    });
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void showMessageComptoir() {
        try {
            if (this.mMessageComptoirController == null || this.paymentComptoirScene == null) {
                FXMLCacheEntry fxmlCacheEntry = FXMLCacheManager.loadFXML("/fx/templates/borne/payment_message_comptoir.fxml");
                Parent rootNode = fxmlCacheEntry.getRootNode();
                this.mMessageComptoirController = (MessageComptoirController)fxmlCacheEntry.getController();
                this.paymentComptoirScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.paymentComptoirScene.getStylesheets().add((Object)"/styles/styles.css");
                this.paymentComptoirScene.getStylesheets().add((Object)"/styles/app.css");
                this.mMessageComptoirController.initialize(this.m_App);
            }
            this.mMessageComptoirController.printOrderAndRestartSelfCheckout();
            this.m_App.getFxPanel().setScene(this.paymentComptoirScene);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void chooseComptoir() {
        AppLocal.ticketBorne.setModePayment("Au Comptoir");
        this.selected(this.btn_comptoir);
        this.deselected(this.btn_cb);
        this.deselected(this.btn_cash);
    }

    public void chooseCash() {
        AppLocal.ticketBorne.setModePayment("Espece");
        this.selected(this.btn_cash);
        this.deselected(this.btn_comptoir);
        this.deselected(this.btn_cb);
    }

    public void deselected(Button btn) {
        if (btn.getProperties().containsKey((Object)"paneBackGround")) {
            GridPane paneBackGround = (GridPane)btn.getProperties().get((Object)"paneBackGround");
            paneBackGround.setStyle(" ");
        }
    }

    public void selected(Button btn) {
        this.lodValidButton();
        if (btn.getProperties().containsKey((Object)"paneBackGround")) {
            GridPane paneBackGround = (GridPane)btn.getProperties().get((Object)"paneBackGround");
            paneBackGround.setStyle("-fx-border-radius: 25px; -fx-border-width: 15px; -fx-border-color: #ffffff;");
        }
    }

    private void addIconToButton() {
        try {
            double height_pane_button = this.dim.getHeight() * 0.15;
            System.out.println("++++++++++++height pane button : " + height_pane_button);
            ImageView imageCB = this.getImage("cb");
            ImageView imageComptoir = this.getImage("comptoir");
            ImageView imageCash = this.getImage("cash");
            double height = imageCB.getBoundsInLocal().getHeight() * 1.25 + 30.0;
            height = height_pane_button > height ? height_pane_button : height;
            this.buildButton(imageCB, this.btn_cb, height);
            this.buildButton(imageComptoir, this.btn_comptoir, height);
            this.buildButton(imageCash, this.btn_cash, height);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private ImageView getImage(String name_image) {
        ImageView image_back = null;
        try {
            double widthImage = this.dim.getWidth() * 0.25 * 0.8;
            Image img_logo = null;
            switch (name_image) {
                case "cb": {
                    img_logo = new Image(this.getClass().getResource("/com/openbravo/images/Carte_Bancaure.png").toURI().toString());
                    break;
                }
                case "comptoir": {
                    img_logo = new Image(this.getClass().getResource("/com/openbravo/images/EnCaisse.png").toURI().toString());
                    break;
                }
                case "cash": {
                    img_logo = new Image(this.getClass().getResource("/com/openbravo/images/Espace.png").toURI().toString());
                }
            }
            if (img_logo != null) {
                image_back = new ImageView();
                image_back.setImage(img_logo);
                image_back.setFitWidth(widthImage);
                image_back.setPreserveRatio(true);
                image_back.setSmooth(true);
                image_back.setCache(true);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return image_back;
    }

    public void cancelPayment() {
        if (this.m_App != null && this.m_App.getFxPanel() != null) {
            this.m_App.getFxPanel().setScene(this.selfcheckout_scene);
        }
    }

    private void buildButton(ImageView imageView, Button button_type_payment, double height) {
        double width = this.dim.getWidth() * 0.2;
        System.out.println("+++++++++++ height button : " + height);
        GridPane pane = new GridPane();
        Label icon = new Label();
        Label title_button = new Label();
        pane.setPrefHeight(height - 30.0);
        pane.setPrefWidth(width - 30.0);
        pane.setAlignment(Pos.CENTER);
        icon.setAlignment(Pos.CENTER);
        title_button.setAlignment(Pos.CENTER);
        title_button.setStyle("-fx-text-fill: " + this.fond_color_hex + ";");
        title_button.getStyleClass().add((Object)"text-size-20");
        title_button.setWrapText(true);
        icon.setPrefHeight(pane.getPrefHeight() * 0.8);
        icon.setPrefWidth(pane.getPrefWidth());
        System.out.println("++++++++++++++ height icon : " + icon.getPrefHeight());
        title_button.setPrefHeight(pane.getPrefHeight() * 0.2);
        title_button.setPrefWidth(pane.getPrefWidth());
        icon.setGraphic((Node)imageView);
        pane.add((Node)icon, 0, 0);
        pane.add((Node)title_button, 0, 1);
        GridPane paneBackGround = new GridPane();
        paneBackGround.setAlignment(Pos.CENTER);
        paneBackGround.setPrefHeight(height);
        paneBackGround.setPrefWidth(width);
        pane.setStyle("-fx-background-radius: 1em;");
        paneBackGround.setStyle("-fx-background-radius: 1em;");
        paneBackGround.add((Node)pane, 0, 0);
        System.out.println("+++++++++++++ pane height : " + pane.getPrefHeight());
        System.out.println("++++++++++++ paneGround height : " + paneBackGround.getPrefHeight());
        button_type_payment.setGraphic((Node)paneBackGround);
        button_type_payment.setPrefHeight(height);
        button_type_payment.getProperties().put((Object)"paneBackGround", (Object)paneBackGround);
        button_type_payment.setAlignment(Pos.CENTER);
    }

    public void startPayment() {
        AppLocal.START_PAYMENT_BORNE = true;
        this.deselected(this.btn_cb);
        this.deselected(this.btn_comptoir);
    }

    public void loadPopUpEaselNumber() {
        try {
            this.mActionEventEaselNumber = new EventHiddenModal(){
                Object[] results;

                @Override
                public void onHidden() {
                    if (((Boolean)this.results[0]).booleanValue()) {
                        AppLocal.ticketBorne.setEasel_number((int)((Integer)this.results[1]));
                        PaymentOrderSelfCheckout.this.showPaymentCB();
                    }
                    PaymentOrderSelfCheckout.this.mLazyModalEaselNumber.destroyEvents();
                    PaymentOrderSelfCheckout.this.mActionEventEaselNumber = null;
                    PaymentOrderSelfCheckout.this.main_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        EaselNumberController mController = (EaselNumberController)mBuilder.getController();
                        this.results = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalEaselNumber == null) {
                this.mLazyModalEaselNumber = new LazyModal(StageStyle.UNDECORATED, this.scene, this.easel_number_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.7), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.55)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.main_pane.setEffect((Effect)blur);
            this.mLazyModalEaselNumber.setEventHiddenModal(this.mActionEventEaselNumber);
            this.mLazyModalEaselNumber.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void doCashlogyPayment() {
        try {
            double total;
            TicketInfo tickinfo = (TicketInfo)AppLocal.ticketBorne.clone();
            this.totalorder = total = NumericUtils.round(tickinfo.getTotal());
            this.trackPayment = new TrackPayement(total);
            if (total > 0.0) {
                ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
                m_aPaymentInfo.add(new PaymentInfo("Cashlogy", this.trackPayment.getTotal(), 0.0));
                System.out.println("****** trackPayment.getTotal() ******* " + this.trackPayment.getTotal());
                System.out.println("****** total ******* " + total);
                CashLogyServices mCashLogyServices = new CashLogyServices();
                String respense = mCashLogyServices.encaisserCommandeSelfcheckout(tickinfo.getNumberOrder(), total, AppLocal.dlItems.getUserKeenIo());
                HashMap<String, Integer> encaisseHash = mCashLogyServices.Descreption(respense, tickinfo);
                Set<String> keySet = encaisseHash.keySet();
                if (!keySet.isEmpty()) {
                    String descreption = keySet.iterator().next();
                    Integer number_type = encaisseHash.get(descreption);
                    switch (number_type) {
                        case 1: {
                            this.encaisserOrder(tickinfo, m_aPaymentInfo);
                            this.ShowMessageCashLogy(descreption);
                            break;
                        }
                        case 2: {
                            System.out.println("+++++++++++++++++++CANCEL  ORDER CONTROLLER");
                            this.ShowMessageCashLogy(descreption);
                            break;
                        }
                        case 3: {
                            this.encaisserOrder(tickinfo, m_aPaymentInfo);
                            this.ShowMessageCashLogy(descreption);
                            break;
                        }
                        case 4: {
                            this.ShowMessageCashLogy(descreption);
                            break;
                        }
                        case 5: {
                            this.ShowMessageCashLogy(descreption);
                            break;
                        }
                        case 6: {
                            this.ShowMessageCashLogy(descreption);
                            break;
                        }
                        case 7: {
                            this.encaisserOrder(tickinfo, m_aPaymentInfo);
                            this.ShowMessageCashLogy(descreption);
                        }
                        case 8: {
                            this.ShowMessageCashLogy(descreption);
                            break;
                        }
                        case 9: {
                            this.encaisserOrder(tickinfo, m_aPaymentInfo);
                            this.ShowMessageCashLogy(descreption);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void encaisserOrder(final TicketInfo ticket, final List<PaymentInfo> payments) {
        if (this.mTicketService.isValidPeriod() && ticket.getLinesCount() > 0) {
            try {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean add_ticket;
                            boolean send_to_kitchen = ticket.getNum_order_kitchen() == 0 || ticket.getNum_order_kitchen() == -1;
                            ArrayList<Integer> ids_tickets_borne = new ArrayList<Integer>();
                            ArrayList<Integer> ids_tickets_kitchen = new ArrayList<Integer>();
                            if (ticket.getId_shared_order() != 0) {
                                ids_tickets_borne.add(ticket.getId_shared_order());
                            }
                            if (ticket.getId_order_kitchen() != 0 && ticket.getId_order_kitchen() != -1) {
                                ids_tickets_kitchen.add(ticket.getId_order_kitchen());
                            }
                            if (add_ticket = PaymentOrderSelfCheckout.this.mTicketService.validOrder(false, ticket, null, send_to_kitchen, ids_tickets_borne, null, true, payments, null, null, "paid", false, false, ids_tickets_kitchen)) {
                                TicketInfo ticketToSend = (TicketInfo)ticket.clone();
                                PaymentOrderSelfCheckout.this.mTicketService.sendAndPrintOrder(ticketToSend, false, true, send_to_kitchen, true, false, null, true, null, "self-checkout", true, null, true, false, false, "print paper", null);
                            }
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void ShowMessageCashLogy(String messageText) {
        Platform.runLater(() -> {
            try {
                this.center_pane.setAlignment(Pos.CENTER);
                Label message = new Label(messageText);
                message.setPrefHeight(this.center_pane.getPrefHeight() * 0.5);
                message.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.9);
                message.setWrapText(true);
                message.setStyle("-fx-font-family: 'Arial'; -fx-font-weight: bold; -fx-font-size: 40px; -fx-text-fill: white;");
                message.setAlignment(Pos.CENTER);
                StackPane messagePane = new StackPane();
                messagePane.setAlignment(Pos.CENTER);
                DropShadow dropShadow = new DropShadow();
                dropShadow.setColor(Color.BLACK);
                dropShadow.setOffsetX(5.0);
                dropShadow.setOffsetY(5.0);
                dropShadow.setRadius(15.0);
                messagePane.setEffect((Effect)dropShadow);
                messagePane.getChildren().add((Object)message);
                this.center_pane.getChildren().clear();
                this.center_pane.getChildren().add((Object)messagePane);
                this.setImageBackGroundMessage();
                this.stScheduledExecutor.schedule(this.m_App::showSelfcheckoutWithoutCashlogy, 3L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        });
    }

    private void setImageBackGround() throws URISyntaxException {
        System.out.println("++++++++++++setImageBackGround ++++++++++++");
        if (this.image_background == null) {
            this.image_background = new Image(this.getClass().getResource("/com/openbravo/images/Payment_Mode.png").toURI().toString());
            this.background.setImage(this.image_background);
            this.background.setFitHeight(this.heightImage);
            this.background.setPreserveRatio(true);
            this.background.setSmooth(true);
            this.background.setCache(true);
        }
    }

    private void setImageBackGroundMessage() throws URISyntaxException {
        System.out.println("++++++++++++setImageBackGroundMessage ++++++++++++");
        this.image_background_message = new Image(this.getClass().getResource("/com/openbravo/images/message_background.jpg").toURI().toString());
        this.background.setImage(this.image_background_message);
        this.background.setFitHeight(this.heightImage);
        this.background.setPreserveRatio(true);
        this.background.setSmooth(true);
        this.background.setCache(true);
    }

    public void lodValidButton() {
        this.pane_button.getChildren().clear();
        this.pane_button.add((Node)this.btn_valid, 0, 0);
        this.pane_button.add((Node)this.btn_cancel, 0, 1);
    }

    public void loadMessageAndDoPaymentCashlogy() throws URISyntaxException {
        this.center_pane.getChildren().clear();
        this.image_message_cashlogy = new Image(this.getClass().getResource("/com/openbravo/images/messageCashlogy.png").toURI().toString());
        this.background.setImage(this.image_message_cashlogy);
        Label labeltotal = new Label("Total : " + AppLocal.ticketBorne.printTotal());
        labeltotal.setStyle("-fx-font-family: 'Arial'; -fx-font-weight: bold; -fx-font-size: 40px; -fx-text-fill: white;");
        labeltotal.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.6);
        labeltotal.setAlignment(Pos.BOTTOM_CENTER);
        this.center_pane.add((Node)labeltotal, 0, 1);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                PaymentOrderSelfCheckout.this.doCashlogyPayment();
            }
        };
        scheduler.schedule(task, 1L, TimeUnit.SECONDS);
        scheduler.shutdown();
    }

    private void setLogo(double hieght) {
        File image;
        ImageView background_log = new ImageView();
        if (AppLocal.LOGO_BORNE != null && !AppLocal.LOGO_BORNE.isEmpty() && (image = new File(new File(System.getProperty("user.home")), "images/logos/" + AppLocal.LOGO_BORNE)).exists()) {
            this.image_logo = new Image(image.toURI().toString());
        }
        if (this.image_logo == null) {
            try {
                this.image_logo = new Image(this.getClass().getResource("/com/openbravo/images/logo_biborne_selfcheckout.png").toURI().toString());
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        background_log.setImage(this.image_logo);
        background_log.setFitWidth(AppVarUtils.getScreenDimension().getWidth() * 0.7);
        background_log.setFitWidth(hieght);
        background_log.setPreserveRatio(true);
        background_log.setSmooth(true);
        background_log.setCache(true);
        this.label_logo.setGraphic((Node)background_log);
        this.label_logo.setAlignment(Pos.TOP_CENTER);
        GridPane.setValignment((Node)this.label_logo, (VPos)VPos.TOP);
        GridPane.setHalignment((Node)this.label_logo, (HPos)HPos.CENTER);
    }
}

