/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.loyalty;

import com.biborne.sms.SmsService;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CustomerLoyalty;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.LoyaltyService;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class SendValidCodeController
implements RootController {
    private Stage stage;
    private boolean popup_borne;
    private String valid_code;
    private SmsService mSmsService;
    private LoyaltyService mLoyaltyService;
    private boolean result;
    private String gender;
    private Date birthdate;
    private int day;
    private int month;
    private int year;
    private int year_current;
    private CustomerLoyalty mCustomerLoyalty;
    @FXML
    GridPane center_pane;
    @FXML
    GridPane pane_info;
    @FXML
    Button btn_male;
    @FXML
    Button btn_female;
    @FXML
    Label label_datepicker;
    @FXML
    Button btn_valid;
    @FXML
    FlowPane main_pane;
    @FXML
    GridPane pane_close;
    @FXML
    Button btn_cancel;
    @FXML
    Label label_day;
    @FXML
    Label label_month;
    @FXML
    Label label_year;
    @FXML
    Button btn_decrease_day;
    @FXML
    Button btn_increase_day;
    @FXML
    Button btn_decrease_month;
    @FXML
    Button btn_increase_month;
    @FXML
    Button btn_decrease_year;
    @FXML
    Button btn_increase_year;
    @FXML
    Button label_female;
    @FXML
    Button label_male;
    @FXML
    Label label_title;
    @FXML
    GridPane pane_valid;
    @FXML
    ImageView image_female;
    @FXML
    ImageView image_male;
    @FXML
    Label label_you;
    @FXML
    Label label_title_day;
    @FXML
    Label label_title_month;
    @FXML
    Label label_title_year;
    private String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    private String styleGender;

    public void initializer() {
        try {
            this.styleGender = "-fx-border-color: " + this.color_hex + ";-fx-border-radius: 50%; -fx-border-width : 2";
            String style_class_size = this.popup_borne ? "text-size-20" : "text-size-13";
            double height_screen = AppVarUtils.getScreenDimension().getHeight();
            double width_screen = AppVarUtils.getScreenDimension().getWidth();
            double height_pane = this.mCustomerLoyalty.isActif() && this.mCustomerLoyalty.getGender() != null ? (this.popup_borne ? height_screen * 0.4 * 0.8 : height_screen * 0.5) : (this.popup_borne ? height_screen * 0.6 * 0.8 : height_screen * 0.8);
            double width_pane = this.popup_borne ? width_screen * 0.7 * 0.9 : width_screen * 0.5 * 0.9;
            this.center_pane.setPrefHeight(height_pane);
            this.center_pane.setPrefWidth(width_pane);
            double height = !this.mCustomerLoyalty.isActif() || this.mCustomerLoyalty.getGender() == null ? height_pane * 0.4 : height_pane * 0.9;
            this.mSmsService = SmsService.getInstance();
            this.mLoyaltyService = LoyaltyService.getInstance();
            int row = 0;
            this.center_pane.getChildren().clear();
            if (!this.popup_borne) {
                this.center_pane.add((Node)this.pane_close, 0, row++);
            }
            if (!this.mCustomerLoyalty.isActif() || this.mCustomerLoyalty.getGender() == null) {
                this.center_pane.add((Node)this.pane_info, 0, row++);
            }
            this.center_pane.add((Node)this.pane_valid, 0, row++);
            if (this.popup_borne) {
                this.center_pane.add((Node)this.btn_cancel, 0, row);
            }
            if (this.popup_borne) {
                this.main_pane.getStyleClass().add((Object)"bg-white");
                this.main_pane.getStyleClass().add((Object)"bg_radius_4");
                this.main_pane.getStyleClass().add((Object)"border_radius_3");
                this.main_pane.getStyleClass().add((Object)"border_width_8");
                this.main_pane.setStyle("-fx-border-color: " + this.color_hex + ";");
                this.btn_valid.setStyle("-fx-background-color: " + this.color_hex + "; -fx-background-radius: 1em;");
                this.label_female.setStyle("-fx-background-color: " + this.color_hex + "; -fx-background-radius: 1em;");
                this.label_male.setStyle("-fx-background-color: " + this.color_hex + "; -fx-background-radius: 1em;");
                this.label_day.setStyle("-fx-background-color: " + this.color_hex + "; -fx-background-radius: 1em;");
                this.label_month.setStyle("-fx-background-color: " + this.color_hex + "; -fx-background-radius: 1em;");
                this.label_year.setStyle("-fx-background-color: " + this.color_hex + "; -fx-background-radius: 1em;");
                String style_btn_date = "-fx-background-color: orange; -fx-background-radius: 3em; -fx-font-size: 15pt;";
                this.btn_decrease_day.setStyle(style_btn_date);
                this.btn_decrease_month.setStyle(style_btn_date);
                this.btn_decrease_year.setStyle(style_btn_date);
                this.btn_increase_day.setStyle(style_btn_date);
                this.btn_increase_month.setStyle(style_btn_date);
                this.btn_increase_year.setStyle(style_btn_date);
            } else {
                this.label_day.getStyleClass().add((Object)"border_black");
                this.label_month.getStyleClass().add((Object)"border_black");
                this.label_year.getStyleClass().add((Object)"border_black");
                this.btn_valid.getStyleClass().add((Object)"bg_caribbean_green");
                this.btn_decrease_day.getStyleClass().add((Object)style_class_size);
                this.btn_increase_day.getStyleClass().add((Object)style_class_size);
                this.btn_decrease_month.getStyleClass().add((Object)style_class_size);
                this.btn_increase_month.getStyleClass().add((Object)style_class_size);
                this.btn_decrease_year.getStyleClass().add((Object)style_class_size);
                this.btn_increase_year.getStyleClass().add((Object)style_class_size);
                this.label_female.getStyleClass().add((Object)"bg_transparent");
                this.label_male.getStyleClass().add((Object)"bg_transparent");
            }
            this.btn_male.getStyleClass().add((Object)style_class_size);
            this.btn_female.getStyleClass().add((Object)style_class_size);
            this.label_datepicker.getStyleClass().add((Object)style_class_size);
            this.btn_valid.getStyleClass().add((Object)style_class_size);
            this.label_day.getStyleClass().add((Object)style_class_size);
            this.label_month.getStyleClass().add((Object)style_class_size);
            this.label_year.getStyleClass().add((Object)style_class_size);
            this.label_title.getStyleClass().add((Object)style_class_size);
            double height_image = height_pane * 0.7 * 0.4 * 0.3;
            Image img_female = new Image(this.getClass().getResource("/com/openbravo/images/icon_female.png").toURI().toString());
            this.image_female.setImage(img_female);
            this.image_female.setFitHeight(height_image);
            this.image_female.setPreserveRatio(true);
            this.image_female.setSmooth(true);
            this.image_female.setCache(true);
            this.btn_female.setGraphic((Node)this.image_female);
            Image img_male = new Image(this.getClass().getResource("/com/openbravo/images/icon_male.png").toURI().toString());
            this.image_male.setImage(img_male);
            this.image_male.setFitHeight(height_image);
            this.image_male.setPreserveRatio(true);
            this.image_male.setSmooth(true);
            this.image_male.setCache(true);
            this.btn_male.setGraphic((Node)this.image_male);
            this.birthdate = new Date();
            this.day = this.birthdate.getDate();
            this.month = this.birthdate.getMonth() + 1;
            this.year = this.birthdate.getYear() + 1900 - 20;
            this.year_current = this.birthdate.getYear() + 1900;
            this.setYear();
            this.setMonth();
            this.setDay();
            this.setText();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void valid() {
        boolean valid = true;
        if (!this.mCustomerLoyalty.isActif() || this.mCustomerLoyalty.getGender() == null) {
            this.birthdate.setDate(this.day);
            this.birthdate.setMonth(this.month - 1);
            this.birthdate.setYear(this.year - 1900);
            if (this.birthdate != null && DateUtils.isDateValid(this.year, this.month, this.day) && DateUtils.getAgeFromDate(this.year, this.month, this.day) >= 15 && this.gender != null) {
                this.mCustomerLoyalty.setGender(this.gender);
                this.mCustomerLoyalty.setBirthdate(DateUtils.formatterYEAR_MONTH_DAY_TIRETS6.format(this.birthdate));
                this.mLoyaltyService.activateLoyaltyUser(this.mCustomerLoyalty);
            } else {
                valid = false;
            }
        }
        if (valid) {
            this.result = true;
            this.stage.close();
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.popup_borne = (Boolean)object;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        if (objects.length > 0) {
            this.popup_borne = (Boolean)objects[0];
            this.mCustomerLoyalty = (CustomerLoyalty)objects[1];
        }
        this.initializer();
    }

    public void sendValidCode() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> {
            if (this.valid_code == null || this.valid_code.isEmpty()) {
                Random number_random = new Random();
                int code = number_random.nextInt(90000) + 10000;
                this.valid_code = String.valueOf(code);
            }
            System.out.println("+++++++++++ valid_code 1 : " + this.valid_code);
            String message = "Votre code est " + this.valid_code;
            this.mSmsService.sendSMS(this.mCustomerLoyalty.getPhone(), message);
        });
    }

    public boolean getResult() {
        return this.result;
    }

    public void cancel() {
        this.result = false;
        this.stage.close();
    }

    public void setFGender() {
        System.out.println("++++++++++++++ set F gender+++++++++++");
        this.gender = "F";
        this.selectGender(this.btn_female);
        this.deselectGender(this.btn_male);
    }

    public void setMGender() {
        this.gender = "M";
        this.deselectGender(this.btn_female);
        this.selectGender(this.btn_male);
    }

    private void selectGender(Button button) {
        if (this.popup_borne) {
            button.setStyle(this.styleGender);
        } else {
            if (button.getStyleClass().contains((Object)"bg_transparent")) {
                button.getStyleClass().remove((Object)"bg_transparent");
            }
            if (!button.getStyleClass().contains((Object)"bg_caribbean_green")) {
                button.getStyleClass().add((Object)"bg_caribbean_green");
            }
        }
    }

    private void deselectGender(Button button) {
        if (this.popup_borne) {
            button.setStyle("");
        } else {
            if (!button.getStyleClass().contains((Object)"bg_transparent")) {
                button.getStyleClass().add((Object)"bg_transparent");
            }
            if (button.getStyleClass().contains((Object)"bg_caribbean_green")) {
                button.getStyleClass().remove((Object)"bg_caribbean_green");
            }
        }
    }

    public void increaseDay() {
        if (this.day < 31) {
            ++this.day;
            this.setDay();
        }
    }

    public void decreaseDay() {
        if (this.day > 1) {
            --this.day;
            this.setDay();
        }
    }

    public void increaseMonth() {
        if (this.month < 12) {
            ++this.month;
            this.setMonth();
        }
    }

    public void decreaseMonth() {
        if (this.month > 1) {
            --this.month;
            this.setMonth();
        }
    }

    public void increaseYear() {
        if (this.year < this.year_current) {
            ++this.year;
            this.setYear();
        }
    }

    public void decreaseYear() {
        --this.year;
        this.setYear();
    }

    private void setYear() {
        this.label_year.setText(String.valueOf(this.year));
    }

    private void setMonth() {
        this.label_month.setText((String)(this.month >= 10 ? String.valueOf(this.month) : "0" + String.valueOf(this.month)));
    }

    private void setDay() {
        this.label_day.setText((String)(this.day >= 10 ? String.valueOf(this.day) : "0" + String.valueOf(this.day)));
    }

    private void setText() {
        this.label_title.setText(AppLocal.getIntString("Text.activate.loyalty.account"));
        this.label_you.setText(AppLocal.getIntString("Text.you.are"));
        this.label_female.setText(AppLocal.getIntString("Text.woman"));
        this.label_male.setText(AppLocal.getIntString("Text.man"));
        this.label_datepicker.setText(AppLocal.getIntString("Text.birth.date"));
        this.label_title_day.setText(AppLocal.getIntString("Text.day").toUpperCase());
        this.label_title_month.setText(AppLocal.getIntString("Text.month").toUpperCase());
        this.label_title_year.setText(AppLocal.getIntString("Text.year"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid"));
        this.btn_cancel.setText(AppLocal.getIntString("Button.cancel"));
    }
}

