/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.displayKitchen;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.displayKitchen.AddOrderInterface;
import com.openbravo.dao.DataLogicDK;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.parser.OrdersParser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.ItemLine;
import com.openbravo.pos.ticket.LineKitchen;
import com.openbravo.pos.ticket.OrderKitchenView;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketKitchen;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.PrinterUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.json.JSONTokener;

public class MainKitchenController
extends UnicastRemoteObject
implements AddOrderInterface {
    private JRootApp app;
    private List<LineKitchen> lines;
    private List<TicketKitchen> ordersKitchen;
    private List<OrderKitchenView> items;
    private ObservableList<OrderKitchenView> dataLines;
    private DataLogicDK dlDK;
    private LineKitchen currentLine;
    private List<LineKitchen> numeros_order;
    @FXML
    TableView orders;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn time_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn bipper_order;
    @FXML
    TableColumn items_order;
    @FXML
    TableColumn options_order;
    @FXML
    TableColumn source_order;
    private Timer m_timer;
    private Timer m_timer_order;
    private Timer m_timer_rmi;
    private int index_selected;
    @FXML
    Button btn_exit;
    @FXML
    Button button_print;
    @FXML
    Button button_historique;
    @FXML
    Button button_ok;
    @FXML
    Button button_previous;
    @FXML
    Button button_next;
    @FXML
    GridPane main_pane;
    @FXML
    GridPane right_pane;
    @FXML
    Label label_time;
    @FXML
    Label label_date_display;
    @FXML
    DatePicker datePickerFilter;
    @FXML
    GridPane button_pane;
    private boolean slave;
    private boolean standalone;
    private boolean toHistory = false;
    private Date dateCurrent;
    private Image imageNext;
    private Image imagePrevious;

    public void init(JRootApp app, Scene scene) {
        Image image = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/exit.png"));
        this.btn_exit.setGraphic((Node)new ImageView(image));
        this.imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1rightarrow.png"));
        this.imagePrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1leftarrow.png"));
        this.button_previous.setGraphic((Node)new ImageView(this.imageNext));
        this.button_next.setGraphic((Node)new ImageView(this.imagePrevious));
        this.dateCurrent = new Date();
        this.setDateCurrent();
        this.app = app;
        this.slave = AppLocal.MODEL_CAISSE != null && AppLocal.MODEL_CAISSE.equals("Esclave");
        this.standalone = AppLocal.MODEL_CAISSE == null || AppLocal.MODEL_CAISSE.isEmpty() || AppLocal.MODEL_CAISSE.equals("Standalone");
        this.lines = new ArrayList<LineKitchen>();
        this.items = new ArrayList<OrderKitchenView>();
        this.numeros_order = new ArrayList<LineKitchen>();
        this.ordersKitchen = new ArrayList<TicketKitchen>();
        this.dlDK = (DataLogicDK)this.app.getBean("com.openbravo.dao.DataLogicDK");
        this.hideHistory();
        this.createTableView();
        this.m_timer = new Timer("Main Kitchen Timer (MainKitchenController)- " + System.currentTimeMillis());
        final SimpleDateFormat dateFormattertime = DateUtils.timeFormatter;
        this.m_timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Date now = new Date();
                        MainKitchenController.this.label_time.setText(dateFormattertime.format(now));
                    }
                });
            }
        }, 0L, 3000L);
        if (this.standalone) {
            this.loadOrders();
        } else {
            this.m_timer_order = new Timer("Main Kitchen Timer 2 (MainKitchenController)- " + System.currentTimeMillis());
            this.m_timer_order.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MainKitchenController.this.loadOrders();
                        }
                    });
                }
            }, 0L, 15000L);
        }
        this.startRmiServer();
    }

    private void createTableView() {
        Callback<TableColumn<OrderKitchenView, String>, TableCell<OrderKitchenView, String>> cellNumFactory = new Callback<TableColumn<OrderKitchenView, String>, TableCell<OrderKitchenView, String>>(){

            public TableCell call(TableColumn<OrderKitchenView, String> param) {
                TableCell<OrderKitchenView, String> cell = new TableCell<OrderKitchenView, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            boolean print_warning;
                            String item_display = "";
                            String item_print = item;
                            if (item.length() > 1) {
                                item_display = item.substring(0, item.length() - 1);
                                item_print = item.substring(item.length() - 1, item.length());
                            }
                            if (print_warning = item_print.equals("1")) {
                                try {
                                    Image img_logo = new Image(((Object)((Object)this)).getClass().getResource("/com/openbravo/images/warning_print.png").toURI().toString(), 30.0, 30.0, false, false);
                                    Label label_print = new Label();
                                    label_print.setGraphic((Node)new ImageView(img_logo));
                                    GridPane pane = new GridPane();
                                    pane.setAlignment(Pos.CENTER);
                                    Text text = new Text(item_display);
                                    text.setStyle("-fx-padding: 5px 30px 5px 5px;-fx-text-alignment:center;");
                                    text.wrappingWidthProperty().bind((ObservableValue)this.getTableColumn().widthProperty().subtract(35));
                                    pane.add((Node)text, 0, 0);
                                    pane.add((Node)label_print, 1, 0);
                                    this.setGraphic((Node)pane);
                                }
                                catch (URISyntaxException ex) {
                                    LogToFile.log("severe", ex.getMessage(), ex);
                                }
                            } else {
                                Text text = new Text(item_display);
                                text.setStyle("-fx-padding: 5px 30px 5px 5px;-fx-text-alignment:center;");
                                text.wrappingWidthProperty().bind((ObservableValue)this.getTableColumn().widthProperty().subtract(35));
                                this.setGraphic((Node)text);
                            }
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return cell;
            }
        };
        Callback<TableColumn<OrderKitchenView, String>, TableCell<OrderKitchenView, String>> cellFactory = new Callback<TableColumn<OrderKitchenView, String>, TableCell<OrderKitchenView, String>>(){

            public TableCell call(TableColumn<OrderKitchenView, String> param) {
                TableCell<OrderKitchenView, String> cell = new TableCell<OrderKitchenView, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Text text = new Text(item);
                            text.setStyle("-fx-padding: 5px 30px 5px 5px;-fx-text-alignment:center;");
                            text.wrappingWidthProperty().bind((ObservableValue)this.getTableColumn().widthProperty().subtract(35));
                            this.setGraphic((Node)text);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return cell;
            }
        };
        if (!this.toHistory) {
            this.time_order.setText("Temps \u00e9coul\u00e9");
        } else {
            this.time_order.setText("Temps pr\u00e9paration");
        }
        this.num_order.setCellFactory((Callback)cellNumFactory);
        this.items_order.setCellFactory((Callback)cellFactory);
        this.type_order.setCellFactory((Callback)cellFactory);
        this.time_order.setCellFactory((Callback)cellFactory);
        this.options_order.setCellFactory((Callback)cellFactory);
        this.bipper_order.setCellFactory((Callback)cellFactory);
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("num_order"));
        this.time_order.setCellValueFactory((Callback)new PropertyValueFactory("remaining_time"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("type_order"));
        this.bipper_order.setCellValueFactory((Callback)new PropertyValueFactory("bipper"));
        this.items_order.setCellValueFactory((Callback)new PropertyValueFactory("item"));
        this.options_order.setCellValueFactory((Callback)new PropertyValueFactory("supplements"));
        this.source_order.setCellValueFactory((Callback)new PropertyValueFactory("caisse"));
        this.button_print.setVisible(false);
        this.button_historique.setVisible(true);
        this.orders.setRowFactory((Callback)new Callback<TableView<OrderKitchenView>, TableRow<OrderKitchenView>>(){

            public TableRow<OrderKitchenView> call(TableView<OrderKitchenView> param) {
                TableRow<OrderKitchenView> row = new TableRow<OrderKitchenView>(){

                    public void updateItem(OrderKitchenView item, boolean empty) {
                        int i;
                        super.updateItem((Object)item, empty);
                        this.setStyle("");
                        int nb_bg_white = 0;
                        int nb_bg_ebeff2 = 0;
                        for (String styleClas : this.getStyleClass()) {
                            if (!styleClas.equalsIgnoreCase("bg-white")) continue;
                            ++nb_bg_white;
                        }
                        for (String styleClas : this.getStyleClass()) {
                            if (!styleClas.equalsIgnoreCase("bg-ebeff2")) continue;
                            ++nb_bg_ebeff2;
                        }
                        for (i = 0; i < nb_bg_white; ++i) {
                            this.getStyleClass().remove((Object)"bg-white");
                        }
                        for (i = 0; i < nb_bg_ebeff2; ++i) {
                            this.getStyleClass().remove((Object)"bg-ebeff2");
                        }
                        if (item != null) {
                            super.setStyle("");
                            if (!item.getNum_order().isEmpty() && item.getFinished()) {
                                if (this.getStyleClass().contains((Object)"border-0")) {
                                    this.getStyleClass().remove((Object)"border-0");
                                }
                                if (!this.getStyleClass().contains((Object)"border_89d3d6")) {
                                    this.getStyleClass().add((Object)"border_89d3d6");
                                }
                                if (!this.getStyleClass().contains((Object)"bg_1bbc9b")) {
                                    this.getStyleClass().add((Object)"bg_1bbc9b");
                                }
                                if (!this.getStyleClass().contains((Object)"top_border")) {
                                    this.getStyleClass().add((Object)"top_border");
                                }
                            } else if (!item.getNum_order().isEmpty() && !item.getFinished()) {
                                if (this.getStyleClass().contains((Object)"bg_1bbc9b")) {
                                    this.getStyleClass().remove((Object)"bg_1bbc9b");
                                }
                                if (this.getStyleClass().contains((Object)"border-0")) {
                                    this.getStyleClass().remove((Object)"border-0");
                                }
                                if (!this.getStyleClass().contains((Object)"border_89d3d6")) {
                                    this.getStyleClass().add((Object)"border_89d3d6");
                                }
                                if (!this.getStyleClass().contains((Object)"top_border")) {
                                    this.getStyleClass().add((Object)"top_border");
                                }
                                if (!this.getStyleClass().contains((Object)MainKitchenController.this.getBackgroundRow(item.getColor()))) {
                                    this.getStyleClass().add((Object)MainKitchenController.this.getBackgroundRow(item.getColor()));
                                }
                            } else if (item.getNum_order().isEmpty() && item.getFinished()) {
                                if (this.getStyleClass().contains((Object)"top_border")) {
                                    this.getStyleClass().remove((Object)"top_border");
                                }
                                if (this.getStyleClass().contains((Object)"border_89d3d6")) {
                                    this.getStyleClass().remove((Object)"border_89d3d6");
                                }
                                if (this.getStyleClass().contains((Object)"bg-ebeff2")) {
                                    this.getStyleClass().remove((Object)"bg-ebeff2");
                                }
                                if (this.getStyleClass().contains((Object)"bg-white")) {
                                    this.getStyleClass().remove((Object)"bg-white");
                                }
                                if (this.getStyleClass().contains((Object)"border-0")) {
                                    this.getStyleClass().remove((Object)"border-0");
                                }
                                if (!this.getStyleClass().contains((Object)"bg_1bbc9b")) {
                                    this.getStyleClass().add((Object)"bg_1bbc9b");
                                }
                            } else {
                                if (this.getStyleClass().contains((Object)"top_border")) {
                                    this.getStyleClass().remove((Object)"top_border");
                                }
                                if (this.getStyleClass().contains((Object)"border_89d3d6")) {
                                    this.getStyleClass().remove((Object)"border_89d3d6");
                                }
                                if (this.getStyleClass().contains((Object)"bg_1bbc9b")) {
                                    this.getStyleClass().remove((Object)"bg_1bbc9b");
                                }
                                if (this.getStyleClass().contains((Object)"border-0")) {
                                    this.getStyleClass().remove((Object)"border-0");
                                }
                                if (!this.getStyleClass().contains((Object)MainKitchenController.this.getBackgroundRow(item.getColor()))) {
                                    this.getStyleClass().add((Object)MainKitchenController.this.getBackgroundRow(item.getColor()));
                                }
                                this.getStyleClass().add((Object)MainKitchenController.this.getBackgroundRow(item.getColor()));
                            }
                        } else {
                            if (this.getStyleClass().contains((Object)"bg-ebeff2")) {
                                this.getStyleClass().remove((Object)"bg-ebeff2");
                            }
                            if (this.getStyleClass().contains((Object)"top_border")) {
                                this.getStyleClass().remove((Object)"top_border");
                            }
                            if (this.getStyleClass().contains((Object)"border_89d3d6")) {
                                this.getStyleClass().remove((Object)"border_89d3d6");
                            }
                            if (this.getStyleClass().contains((Object)"bg_1bbc9b")) {
                                this.getStyleClass().remove((Object)"bg_1bbc9b");
                            }
                            if (!this.getStyleClass().contains((Object)"bg-white")) {
                                this.getStyleClass().add((Object)"bg-white");
                            }
                            if (!this.getStyleClass().contains((Object)"border-0")) {
                                this.getStyleClass().add((Object)"border-0");
                            }
                        }
                    }
                };
                return row;
            }
        });
        this.orders.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (MainKitchenController.this.orders.getSelectionModel().getSelectedIndex() != -1 && (row = MainKitchenController.this.orders.getSelectionModel().getSelectedIndex()) != -1) {
                    MainKitchenController.this.currentLine = MainKitchenController.this.lines.get(row);
                    if (MainKitchenController.this.currentLine.isFinished()) {
                        MainKitchenController.this.button_print.setVisible(true);
                    } else {
                        MainKitchenController.this.button_print.setVisible(false);
                    }
                }
            }
        });
        this.orders.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                int row;
                int selecetd;
                if (t.getCode() == KeyCode.NUMPAD2 && MainKitchenController.this.orders.getSelectionModel().getSelectedIndex() != -1 && (selecetd = (row = MainKitchenController.this.orders.getSelectionModel().getSelectedIndex()) + 1) < MainKitchenController.this.items.size()) {
                    MainKitchenController.this.orders.getSelectionModel().select(selecetd);
                    MainKitchenController.this.currentLine = MainKitchenController.this.lines.get(row);
                    if (MainKitchenController.this.currentLine.isFinished()) {
                        MainKitchenController.this.button_print.setVisible(true);
                    } else {
                        MainKitchenController.this.button_print.setVisible(false);
                    }
                }
                if (t.getCode() == KeyCode.NUMPAD8 && MainKitchenController.this.orders.getSelectionModel().getSelectedIndex() != -1 && (selecetd = (row = MainKitchenController.this.orders.getSelectionModel().getSelectedIndex()) - 1) != -1) {
                    MainKitchenController.this.orders.getSelectionModel().select(selecetd);
                    MainKitchenController.this.currentLine = MainKitchenController.this.lines.get(row);
                    if (MainKitchenController.this.currentLine.isFinished()) {
                        MainKitchenController.this.button_print.setVisible(true);
                    } else {
                        MainKitchenController.this.button_print.setVisible(false);
                    }
                }
                if (t.getCode() == KeyCode.ENTER && MainKitchenController.this.orders.getSelectionModel().getSelectedIndex() != -1 && (row = MainKitchenController.this.orders.getSelectionModel().getSelectedIndex()) != -1) {
                    MainKitchenController.this.currentLine = MainKitchenController.this.lines.get(row);
                    MainKitchenController.this.finishLine();
                }
            }
        });
    }

    private void loadOrders() {
        block5: {
            try {
                this.index_selected = this.items.size() > 0 ? this.orders.getSelectionModel().getSelectedIndex() : -1;
                try {
                    if (this.slave) {
                        this.loadOrderWS();
                        break block5;
                    }
                    this.ordersKitchen = this.toHistory ? this.dlDK.loadTicketsKitchenHistorik(this.dateCurrent) : this.dlDK.loadTicketsKitchen();
                    this.buildLines();
                    this.fillInTale();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            catch (Exception e) {
                LogToFile.log("severe", e.getMessage(), e);
            }
        }
    }

    public void exit() {
        this.app.showCaisse();
    }

    private int getTimeByOrder(long time_order, Date date) {
        long diff = date.getTime() - time_order;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(diff);
        return (int)minutes;
    }

    private void buildLines() {
        this.lines.clear();
        this.numeros_order.clear();
        for (TicketKitchen order : this.ordersKitchen) {
            for (LineKitchen line : order.getLines()) {
                this.lines.add(this.getLine(line, order));
                for (ItemLine item : line.getItems()) {
                    this.lines.add(this.getLineItem(item, order, line));
                }
            }
        }
    }

    private void fillInTale() {
        this.currentLine = null;
        if (!this.orders.getItems().isEmpty()) {
            this.orders.getItems().clear();
            this.orders.setItems(null);
        }
        if (!this.items.isEmpty()) {
            this.items.clear();
        }
        String color = "";
        for (LineKitchen line : this.lines) {
            Object remainingTime = null;
            remainingTime = line.getTime() == -1 ? "OK" : String.valueOf(line.getTime()) + " min";
            if (this.existLine(line)) {
                String numero_order_print = line.isPrint_warning() ? "1" : "0";
                String name_item = line.getStatus() != null && !line.getStatus().isEmpty() ? line.getProduct() + " (" + line.getStatus() + ")" : line.getProduct();
                this.items.add(new OrderKitchenView(numero_order_print, (String)(line.isFinished() ? remainingTime : ""), line.getType_order(), line.getAfterSeparator() != null && line.getAfterSeparator().contains("Emporter plus tard") ? "plus tard" : "", name_item, line.getOptions(), line.getCaisse(), line.isFinished(), color, line.isPrint_warning()));
                continue;
            }
            color = color.isEmpty() || color.equals("gray") ? "white" : "gray";
            String name_item = line.getStatus() != null && !line.getStatus().isEmpty() ? line.getProduct() + " (" + line.getStatus() + ")" : line.getProduct();
            this.numeros_order.add(line);
            String numero_order_print = line.isPrint_warning() ? "1" : "0";
            String orderNum = line.getCaisse() != null ? line.getCaisse() + line.getNum_order() : String.valueOf(line.getNum_order());
            String numero_order = orderNum + numero_order_print;
            this.items.add(new OrderKitchenView(numero_order, (String)remainingTime, line.getType_order(), line.getAfterSeparator() != null && line.getAfterSeparator().contains("Emporter plus tard") ? "plus tard" : String.valueOf(line.getBipper()), name_item, line.getOptions(), line.getCaisse(), line.isFinished(), color, line.isPrint_warning()));
        }
        this.dataLines = FXCollections.observableArrayList(this.items);
        this.orders.getStyleClass().add((Object)"");
        this.orders.setItems(this.dataLines);
        if (this.index_selected != -1 && this.index_selected < this.items.size()) {
            this.orders.getSelectionModel().select(this.index_selected);
            this.currentLine = this.lines.get(this.index_selected);
        } else if (this.items.size() > 0) {
            this.index_selected = 0;
            this.orders.getSelectionModel().select(0);
            this.currentLine = this.lines.get(0);
        }
        if (this.currentLine != null && this.currentLine.isFinished()) {
            this.button_print.setVisible(true);
        } else {
            this.button_print.setVisible(false);
        }
    }

    public void finishLine() {
        if (this.currentLine != null && !this.currentLine.isFinished() && !this.currentLine.isItem()) {
            LineKitchen lineToPrinter = (LineKitchen)this.currentLine.clone();
            if (this.isPrinterConnected(this.currentLine.getPrinter_kitchen())) {
                this.currentLine.setFinished(true);
                this.currentLine.setFinishedDate(new Date());
                this.printLabel(lineToPrinter);
                if (this.slave) {
                    this.changeStatusWS(this.currentLine.getId(), "finish");
                } else {
                    try {
                        this.dlDK.finishLine(this.currentLine.getId());
                        this.finishOrder(this.currentLine.getTicket());
                        this.loadOrders();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            } else {
                try {
                    if (this.slave) {
                        this.changeStatusWS(this.currentLine.getId(), "print_warning");
                    } else {
                        this.dlDK.setPrintWarning(this.currentLine.getId());
                        this.loadOrders();
                    }
                }
                catch (BasicException ex) {
                    Logger.getLogger(MainKitchenController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void reprintLabel() {
        final LineKitchen lineToPrinter = (LineKitchen)this.currentLine.clone();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                MainKitchenController.this.printLabel(lineToPrinter);
            }
        });
    }

    @Override
    public void addOrderKitchen(final TicketInfo ticket) throws RemoteException {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MainKitchenController.this.dlDK.addOrderKitchen(ticket);
                    MainKitchenController.this.loadOrders();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public void cancelOrder() {
        if (this.currentLine != null && !this.currentLine.isItem()) {
            try {
                if (this.slave) {
                    this.changeStatusWS(this.currentLine.getId(), "cancel");
                } else {
                    this.dlDK.cancelOrder(this.currentLine.getTicket());
                    this.loadOrders();
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void finishOrder(int ticket) throws BasicException {
        boolean finished = true;
        for (LineKitchen line : this.lines) {
            if (line.getTicket() != ticket || line.isFinished()) continue;
            finished = false;
        }
        if (finished) {
            this.dlDK.finishOrder(ticket);
        }
    }

    @Override
    public void cancelOrderKitchen(TicketInfo ticket) throws RemoteException {
    }

    @Override
    public void updateOrderKitchen(final TicketInfo ticket) throws RemoteException {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MainKitchenController.this.dlDK.updateOrderKitchen(ticket);
                    MainKitchenController.this.loadOrders();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    public String getBackgroundRow(String color) {
        if (color.isEmpty() || color.equals("white")) {
            return "bg-white";
        }
        return "bg-ebeff2";
    }

    private LineKitchen getLine(LineKitchen line, TicketKitchen order) {
        long time_order;
        LineKitchen newLine = (LineKitchen)line.clone();
        newLine.setNum_order(order.getNum_order());
        newLine.setCaisse(order.getCaisse());
        long l = time_order = this.slave ? order.getTime_order() : order.getDate_order().getTime();
        if (line.isFinished() && line.getFinishedDate() != null) {
            if (this.toHistory) {
                newLine.setTime(this.getTimeByOrder(time_order, line.getFinishedDate()));
            } else {
                newLine.setTime(-1);
            }
        } else {
            newLine.setTime(this.getTimeByOrder(time_order, new Date()));
        }
        newLine.setBipper(order.getBipper());
        newLine.setType_order(line.getPlace_served());
        newLine.setItem(false);
        return newLine;
    }

    private LineKitchen getLineItem(ItemLine item, TicketKitchen order, LineKitchen line) {
        long time_order;
        boolean finished = line.isFinished();
        LineKitchen newLine = new LineKitchen();
        newLine.setProduct(item.getProduct() + " *");
        newLine.setUnits(item.getUnits());
        newLine.setIngredients(item.getIngredients());
        newLine.setSupplements(item.getSupplements());
        newLine.setFinished(finished);
        newLine.setNum_order(order.getNum_order());
        newLine.setCaisse(order.getCaisse());
        newLine.setPrint_warning(false);
        long l = time_order = this.slave ? order.getTime_order() : order.getDate_order().getTime();
        if (line.isFinished() && line.getFinishedDate() != null) {
            newLine.setTime(this.getTimeByOrder(time_order, line.getFinishedDate()));
        } else {
            newLine.setTime(this.getTimeByOrder(time_order, new Date()));
        }
        newLine.setBipper(order.getBipper());
        newLine.setType_order(order.getType_order());
        newLine.setItem(true);
        return newLine;
    }

    public void startRmiServer() {
        try {
            LocateRegistry.createRegistry(1099);
            MainKitchenController orderRemote = this;
            String url = "rmi://" + InetAddress.getLocalHost().getHostAddress() + "/TestRMI";
            Naming.rebind(url, orderRemote);
        }
        catch (RemoteException e) {
            new NotifyWindow(Color.RED, "Erreur de lancement de serveur de commandes ", 5, NPosition.BOTTOM_RIGHT);
            LogToFile.log("severe", e.getMessage() + " " + e.getCause(), e);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void printLabel(LineKitchen line) {
        try {
            PrinterHelper printer = new PrinterHelper();
            PrinterInfo printerLabel = PrinterUtils.getPrinterLabel(line.getPrinter_kitchen());
            if (printerLabel != null) {
                printer.printLabelKitchen(line, printerLabel, null);
            } else {
                new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, "Merci d'ajouter une imprimante etiquette.", 1500, NPosition.CENTER);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadOrderWS() {
        String ip_address = AppLocal.master_address;
        if (ip_address != null) {
            try {
                String url_base = this.toHistory ? "http://" + ip_address + ":9097/newItems/ordershistorik" : "http://" + ip_address + ":9097/newItems/orders";
                URL url = new URL(url_base);
                JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                JSONObject data = new JSONObject(tokener);
                List<TicketKitchen> ordersWS = OrdersParser.parseOrders(data);
                this.ordersKitchen = this.toHistory ? this.filterOrders(ordersWS) : ordersWS;
                this.buildLines();
                this.fillInTale();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void changeStatusWS(int idLine, String status) {
        try {
            String ip_address = AppLocal.master_address;
            if (ip_address != null && !ip_address.isEmpty()) {
                DefaultHttpClient httpClient = new DefaultHttpClient();
                String url_base = "http://" + ip_address + ":9097/newItems/change";
                HttpPost post = new HttpPost(url_base);
                post.setHeader("Content-type", "application/json; charset=utf-8");
                JSONObject jsonParams = new JSONObject();
                jsonParams.put("line", (Object)String.valueOf(idLine));
                jsonParams.put("status", (Object)status);
                StringEntity params = new StringEntity(jsonParams.toString(), "UTF-8");
                post.setEntity((HttpEntity)params);
                CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
                String json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.getString("error");
                if (message.equals("OK")) {
                    JSONObject jsonData = jsonObject.getJSONObject("data");
                    List<TicketKitchen> ordersWS = OrdersParser.parseOrders(jsonData);
                    this.ordersKitchen = this.filterOrders(ordersWS);
                    this.buildLines();
                    this.fillInTale();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void toggleHistorique() {
        this.toHistory = !this.toHistory;
        this.button_historique.setText(!this.toHistory ? "Historique" : "Nouveaux");
        if (this.toHistory) {
            this.showHistory();
        } else {
            this.hideHistory();
        }
        if (!this.toHistory) {
            this.m_timer_order = new Timer("Main Kitchen Timer 3 (MainKitchenController)- " + System.currentTimeMillis());
            this.m_timer_order.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MainKitchenController.this.loadOrders();
                        }
                    });
                }
            }, 0L, 8000L);
        } else {
            if (this.m_timer_order != null) {
                this.m_timer_order.cancel();
            }
            this.loadOrders();
        }
    }

    public void increase() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.dateCurrent);
        cal.add(5, 1);
        this.dateCurrent = cal.getTime();
        this.setDateCurrent();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MainKitchenController.this.loadOrders();
            }
        });
    }

    public void decrease() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.dateCurrent);
        cal.add(5, -1);
        this.dateCurrent = cal.getTime();
        this.setDateCurrent();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MainKitchenController.this.loadOrders();
            }
        });
    }

    private void setDateCurrent() {
        this.label_date_display.setText(DateUtils.formatDate(this.dateCurrent));
    }

    private List<TicketKitchen> filterOrders(List<TicketKitchen> orders) {
        ArrayList<TicketKitchen> ordersFiltered = new ArrayList<TicketKitchen>();
        for (TicketKitchen order : orders) {
            if (order.getDate_created().getDate() != this.dateCurrent.getDate() || order.getDate_created().getMonth() != this.dateCurrent.getMonth() || order.getDate_created().getYear() != this.dateCurrent.getYear()) continue;
            ordersFiltered.add(order);
        }
        return ordersFiltered;
    }

    private void showHistory() {
        this.button_pane.getChildren().clear();
        this.button_pane.add((Node)this.label_time, 0, 0);
        this.button_pane.add((Node)this.button_previous, 0, 1);
        this.button_pane.add((Node)this.label_date_display, 0, 2);
        this.button_pane.add((Node)this.button_next, 0, 3);
        this.button_pane.add((Node)this.button_historique, 0, 4);
        this.button_pane.add((Node)this.button_print, 0, 5);
    }

    private void hideHistory() {
        this.button_pane.getChildren().clear();
        this.button_pane.add((Node)this.label_time, 0, 0);
        this.button_pane.add((Node)this.button_historique, 0, 1);
        this.button_pane.add((Node)this.button_ok, 0, 2);
        this.button_pane.add((Node)this.button_print, 0, 3);
    }

    private boolean existLine(LineKitchen line) {
        for (LineKitchen lineKitchen : this.numeros_order) {
            if (line.getCaisse() == null || lineKitchen.getCaisse() == null || lineKitchen.getNum_order() != line.getNum_order() || !lineKitchen.getCaisse().equals(line.getCaisse())) continue;
            return true;
        }
        for (LineKitchen lineKitchen : this.numeros_order) {
            if (line.getCaisse() != null && lineKitchen.getCaisse() != null || lineKitchen.getNum_order() != line.getNum_order()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrinterConnected(String ip_address) {
        PrinterInfo printerLabel = PrinterUtils.getPrinterLabel(ip_address);
        if (printerLabel.getType().equalsIgnoreCase("usb")) {
            return true;
        }
        try {
            InetAddress host = InetAddress.getByName(printerLabel.getIp());
            boolean test = host.isReachable(1000);
            return test;
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(MainKitchenController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MainKitchenController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }
}

