/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.borne.AvomarkCodeController;
import com.openbravo.controllers.borne.AvomarkController;
import com.openbravo.controllers.borne.CatalogueController;
import com.openbravo.controllers.borne.Tagscontroller;
import com.openbravo.controllers.loyalty.LoyaltyInfocontroller;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ClotureService;
import com.openbravo.service.LoyaltyService;
import com.procaisse.avomark.AvomarkClient;
import com.procaisse.avomark.AvomarkService;
import com.utils.NetworkUtils;
import fr.protactile.procaisse.dao.entities.LanguageInfo;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.services.LanguageService;
import fr.protactile.procaisse.services.TagsService;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.stage.StageStyle;

public class TypeOrdercontroller
implements PropertyChangeListener {
    private JRootApp m_App;
    private Scene scene;
    private String color_hex;
    private String fond_color_hex;
    private String color_type_order;
    private Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private Scene catalogScene;
    private CatalogueController controller;
    private FilerUtils m_FilerUtils = null;
    private ClotureService clotureService;
    private String loyalty_fxml = "/fx/templates/borne/loyalty_info.fxml";
    private LazyModal mLazyModalLoyalty = null;
    private EventHiddenModal mActionEventLoyalty = null;
    private LoyaltyService mLoyaltyService;
    private boolean load_popup;
    private String KEY_NAME_AT_SPOT = "name_At_Spot";
    private String KEY_NAME_TAKE_AWAY = "name_take_away";
    private TagsService mTagsService;
    private Scene tagsgScene;
    private Tagscontroller mTagscontroller;
    private String KEY_IMAGE_AT_SPOT = "image_At_Spot";
    private String KEY_IMAGE_TAKE_AWAY = "image_take_away";
    @FXML
    Button btn_sp;
    @FXML
    Button btn_emp;
    @FXML
    ImageView logo;
    @FXML
    GridPane center_pane;
    @FXML
    Button btn_exit;
    @FXML
    Label message;
    @FXML
    Label label_background;
    @FXML
    ImageView background;
    @FXML
    GridPane pane_bloc_cloture;
    @FXML
    GridPane pane_languages;
    @FXML
    GridPane main_pane;
    @FXML
    Label label_cloture;
    private Image img_at_spot_fr;
    private Image img_at_spot_es;
    private Image img_at_spot_en;
    private Image img_at_spot_ar;
    private Image img_take_away_fr;
    private Image img_take_away_es;
    private Image img_take_away_en;
    private Image img_take_away_ar;
    private Image img_at_spot_default;
    private Image img_take_away_default;
    private ImageView at_spotImgView;
    private ImageView take_awayImgView;
    private GridPane paneSp;
    private GridPane paneEmp;
    private Label iconSP;
    private Label iconEMP;
    private Label name_At_Spot;
    private Label name_take_away;
    private List<LanguageInfo> languages;
    private LanguageService languageService;
    private Map<String, Image> mapImagesTypeOrder = new HashMap<String, Image>();
    private Map<String, Image> mapResourceImagesTypeOrder = new HashMap<String, Image>();
    private EventHiddenModal mActionEventAvomark = null;
    private final String Avomarkfxml = "/fx/templates/borne/Avomark_info.fxml";
    private LazyModal mLazyModalAvomark = null;
    private AvomarkService mAvomarkService;
    private EventHiddenModal avomarkCodeEventHandler = null;
    private LazyModal avomarkCodeModal = null;
    private EventHandler mEventHandlerChooseLanguage = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"language") != null) {
                try {
                    LanguageInfo language = (LanguageInfo)mButtonSource.getProperties().get((Object)"language");
                    TypeOrdercontroller.this.selectLanguage(language);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    };

    public void initialize(JRootApp app, Scene scene) throws BasicException {
        this.m_App = app;
        this.scene = scene;
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.fond_color_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
        this.color_type_order = ColorUtils.getColor(AppLocal.COLOR_TYPE_ORDER);
        if (AppLocal.IMAGES_TYPE_ORDER_TRANSPARENT) {
            this.btn_sp.setStyle("-fx-background-color: transparent; -fx-text-fill: " + this.color_hex + ";");
            this.btn_emp.setStyle("-fx-background-color: transparent; -fx-text-fill: " + this.color_hex + ";");
        } else {
            this.btn_sp.setStyle("-fx-background-color: white; -fx-text-fill: " + this.color_hex + ";");
            this.btn_emp.setStyle("-fx-background-color: white; -fx-text-fill: " + this.color_hex + ";");
        }
        this.message.setStyle("-fx-text-fill: " + this.color_type_order + ";");
        this.message.setVisible(!AppLocal.HIDE_MESSAGE_TYPE_ORDER);
        this.m_FilerUtils = FilerUtils.getInstance();
        DataLogicSales dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.clotureService = ClotureService.getInstance(dlSales, this.m_App);
        try {
            this.languageService = LanguageService.getInstance();
            this.languages = this.languageService.getEnabledLanguages();
            this.setFlags();
            this.setImageBackGround();
            if (!AppLocal.SHOW_TAGS_IN_BORNE) {
                ExecutorService exec = Executors.newSingleThreadExecutor();
                exec.execute(() -> Platform.runLater(() -> {
                    try {
                        this.initCatalogController();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.btn_exit.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 5) {
                    TypeOrdercontroller.this.exit();
                }
            }
        });
        this.mTagsService = TagsService.getInstance();
    }

    public void chooseSurPlace() {
        if (AppLocal.ONLY_TAKE_AWAY_BORNE) {
            return;
        }
        if (!this.load_popup) {
            this.load_popup = true;
            boolean avomark_activated = AppLocal.MODULE_AVOMARK;
            AppLocal.ticketBorne.setType("Sur Place");
            if (AppLocal.CUSTOMER_LOYALTY && AppLocal.CUSTOMER_LOYALTY_ID != null && !AppLocal.CUSTOMER_LOYALTY_ID.isEmpty() && this.isNetworkConnected()) {
                this.loadPopUpLoyalty();
            } else if (avomark_activated) {
                this.loadAvomarkScanner();
            } else {
                this.showNext();
            }
        }
    }

    public void showNext() {
        System.out.println("*******showNext()*******");
        try {
            boolean show_tags = false;
            if (AppLocal.SHOW_TAGS_IN_BORNE) {
                List<TagInfo> tags = this.mTagsService.getActiveTags();
                show_tags = tags != null && !tags.isEmpty();
            }
            System.out.println("************show_tags" + show_tags);
            if (show_tags) {
                if (this.tagsgScene == null || this.mTagscontroller == null) {
                    this.initTagsController();
                }
                this.mTagscontroller.reload();
                this.m_App.getFxPanel().setScene(this.tagsgScene);
            } else {
                System.out.println("************controller******" + this.controller);
                if (this.catalogScene == null || this.controller == null) {
                    this.initCatalogController();
                }
                this.controller.loadCatalog(null);
                this.m_App.getFxPanel().setScene(this.catalogScene);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void chooseEmporter() {
        if (!this.load_popup) {
            this.load_popup = true;
            boolean avomark_activated = AppLocal.MODULE_AVOMARK;
            AppLocal.ticketBorne.setType("A Emporter");
            if (AppLocal.CUSTOMER_LOYALTY && this.isNetworkConnected()) {
                this.loadPopUpLoyalty();
            } else if (avomark_activated) {
                this.loadAvomarkScanner();
            } else {
                this.showNext();
            }
        }
    }

    public void reload() {
        AppLocal.APP_LANGUAGE = AppLocal.APP_LANGUAGE_DEFAULT;
        AppLocal.loadLanguages();
        this.load_popup = false;
        if (AppLocal.START_CLOTURE) {
            System.out.println("+++++++++++++ show bloc cloture");
            this.showBlocInfoCloture();
        } else {
            System.out.println("+++++++++++++ hide bloc cloture");
            this.hideBlocInfoCloture();
        }
        for (Node node : this.pane_languages.getChildren()) {
            Button button_language = (Button)node;
            if (button_language.getProperties().get((Object)"language") == null) continue;
            LanguageInfo language = (LanguageInfo)button_language.getProperties().get((Object)"language");
            if (language != null && language.getCode_language().equals(AppLocal.APP_LANGUAGE)) {
                this.selectFlag(button_language);
                continue;
            }
            this.deselectFlag(button_language);
        }
        this.setImagesTypeOrder();
        this.setTexts();
    }

    private void exit() {
        this.m_App.showCaisse();
    }

    private void setImageBackGround() {
        File image_path;
        String path = AppLocal.BACKGROUND_TYPE_ORDER_BORNE;
        double heightImage = AppVarUtils.getScreenDimension().getHeight();
        Image img_logo = null;
        if (path != null && !path.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path)) != null && image_path.exists()) {
            img_logo = new Image(image_path.toURI().toString());
        }
        if (img_logo != null) {
            this.background.setImage(img_logo);
            this.background.setFitHeight(heightImage);
            this.background.setPreserveRatio(true);
            this.background.setSmooth(true);
            this.background.setCache(true);
        } else {
            this.label_background.setStyle("-fx-background-color: " + this.color_hex + ";");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String event = evt.getPropertyName();
        if (event.equals("end_cloture")) {
            this.hideBlocInfoCloture();
        } else {
            System.out.println("+++++++++++++++ show bloc cloture");
            this.showBlocInfoCloture();
        }
    }

    private void showBlocInfoCloture() {
        this.pane_bloc_cloture.getChildren().clear();
        this.pane_bloc_cloture.add((Node)this.label_cloture, 0, 0);
    }

    private void hideBlocInfoCloture() {
        this.pane_bloc_cloture.getChildren().clear();
    }

    private void initCatalogController() throws IOException, BasicException, URISyntaxException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/catalog_page.fxml"));
        Parent rootNode = (Parent)loader.load();
        this.controller = (CatalogueController)loader.getController();
        this.catalogScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
        Font.loadFont((InputStream)this.getClass().getResourceAsStream("/fonts/Bukhari Script.ttf"), (double)20.0);
        this.catalogScene.getStylesheets().add((Object)"/styles/styles.css");
        this.catalogScene.getStylesheets().add((Object)"/styles/app.css");
        this.controller.initialize(this.m_App, this.catalogScene);
        this.clotureService.addPropertyChangeListener(this.controller);
    }

    public void loadPopUpLoyalty() {
        System.out.println("+++++++++++++++++loadPopUpLoyalty()  TypeOrderController");
        try {
            this.mActionEventLoyalty = new EventHiddenModal(){
                Object[] result;

                @Override
                public void onHidden() {
                    TypeOrdercontroller.this.showNext();
                    if (this.result != null && ((Boolean)this.result[0]).booleanValue()) {
                        TypeOrdercontroller.this.getCagnoteByLoyaltyUser((String)this.result[1]);
                    } else {
                        AppLocal.currentCustomerLoyalty = null;
                        if (TypeOrdercontroller.this.controller != null) {
                            TypeOrdercontroller.this.controller.laodCategoriesWithoutPoints();
                        }
                    }
                    TypeOrdercontroller.this.mLazyModalLoyalty.destroyEvents();
                    TypeOrdercontroller.this.mActionEventLoyalty = null;
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        LoyaltyInfocontroller mController = (LoyaltyInfocontroller)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalLoyalty == null) {
                this.mLazyModalLoyalty = new LazyModal(StageStyle.UNDECORATED, this.scene, this.loyalty_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.8), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.6)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.mLazyModalLoyalty.setEventHiddenModal(this.mActionEventLoyalty);
            this.mLazyModalLoyalty.load(true);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void getCagnoteByLoyaltyUser(final String phone) {
        if (this.mLoyaltyService == null) {
            this.mLoyaltyService = LoyaltyService.getInstance();
        }
        if (this.controller != null) {
            this.controller.setCustomerPoints(AppLocal.getIntString("Label.cagnotte") + " ...", false, false);
        }
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AppLocal.currentCustomerLoyalty = TypeOrdercontroller.this.mLoyaltyService.getCagnoteByLoyaltyUser(phone);
                if (TypeOrdercontroller.this.controller != null) {
                    TypeOrdercontroller.this.controller.laodCategoriesAfterGetPoints();
                }
            }
        }));
    }

    private boolean isNetworkConnected() {
        return NetworkUtils.isNetworkConnected("www.google.com", 80, 5000);
    }

    public void setTexts() {
        System.out.println("+++++++= AppLocal.APP_LANGUAGE : " + AppLocal.APP_LANGUAGE);
        this.message.setText(AppLocal.getIntString("Label.place.eat"));
        if (this.btn_sp.getProperties().get((Object)this.KEY_NAME_AT_SPOT) != null) {
            Label label_at_spot = (Label)this.btn_sp.getProperties().get((Object)this.KEY_NAME_AT_SPOT);
            label_at_spot.setText(AppLocal.getIntString("Label.ATSPOT"));
        }
        if (this.btn_emp.getProperties().get((Object)this.KEY_NAME_TAKE_AWAY) != null) {
            Label label_take_away = (Label)this.btn_emp.getProperties().get((Object)this.KEY_NAME_TAKE_AWAY);
            label_take_away.setText(AppLocal.getIntString("Label.TAKEAWAY"));
        }
    }

    private void setFlags() throws URISyntaxException {
        if (this.languages != null && this.languages.size() > 1) {
            Image french_flag = new Image(this.getClass().getResource("/com/openbravo/images/french_flag.png").toURI().toString());
            Image english_flag = new Image(this.getClass().getResource("/com/openbravo/images/english_flag.png").toURI().toString());
            Image spanish_flag = new Image(this.getClass().getResource("/com/openbravo/images/spanish_flag.png").toURI().toString());
            Image arabic_flag = new Image(this.getClass().getResource("/com/openbravo/images/arabic_flag.png").toURI().toString());
            HashMap<String, Image> flags = new HashMap<String, Image>();
            flags.put("fr", french_flag);
            flags.put("en", english_flag);
            flags.put("es", spanish_flag);
            flags.put("ar", arabic_flag);
            double heightFlags = this.getHeightLanguageFlags();
            int column = 0;
            for (LanguageInfo language : this.languages) {
                if (!language.isEnabled() || flags.get(language.getCode_language()) == null) continue;
                Button btn_language = new Button();
                btn_language.getProperties().put((Object)"language", (Object)language);
                btn_language.setPrefHeight(heightFlags);
                btn_language.setPrefWidth(heightFlags);
                btn_language.getStyleClass().add((Object)"bg_transparent");
                Image language_flag = (Image)flags.get(language.getCode_language());
                this.setContentFlag(heightFlags, btn_language, language_flag);
                btn_language.setOnAction(this.mEventHandlerChooseLanguage);
                this.pane_languages.add((Node)btn_language, column++, 0);
                if (language.getCode_language().equalsIgnoreCase(AppLocal.APP_LANGUAGE)) {
                    this.selectFlag(btn_language);
                    continue;
                }
                this.deselectFlag(btn_language);
            }
        }
    }

    private void initTagsController() throws IOException, BasicException, URISyntaxException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/tags.fxml"));
        Parent rootNode = (Parent)loader.load();
        this.mTagscontroller = (Tagscontroller)loader.getController();
        this.tagsgScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
        Font.loadFont((InputStream)this.getClass().getResourceAsStream("/fonts/Bukhari Script.ttf"), (double)20.0);
        this.tagsgScene.getStylesheets().add((Object)"/styles/styles.css");
        this.tagsgScene.getStylesheets().add((Object)"/styles/app.css");
        this.mTagscontroller.initialize(this.m_App, this.tagsgScene);
        this.clotureService.addPropertyChangeListener(this.mTagscontroller);
    }

    public void setImagesTypeOrder() {
        double width = (AppVarUtils.getScreenDimension().getWidth() * 0.75 - 30.0) * 0.4;
        double height = AppVarUtils.getScreenDimension().getHeight() * 0.25;
        Image img_at_spot = null;
        Image img_take_away = null;
        try {
            String pathResourceImageTakeAway;
            String pathImageTakeAway;
            String pathResourceImageDineIn;
            String pathImageDineIn = this.getImageDineIn();
            if (pathImageDineIn != null && !pathImageDineIn.isEmpty() && (img_at_spot = this.mapImagesTypeOrder.get(pathImageDineIn)) == null) {
                File image = null;
                image = this.m_FilerUtils.getFileFullPath("images/logos/" + pathImageDineIn);
                if (image != null && image.exists()) {
                    img_at_spot = new Image(image.toURI().toString());
                    this.mapImagesTypeOrder.put(pathImageDineIn, img_at_spot);
                }
            }
            if (img_at_spot == null && (pathResourceImageDineIn = this.getResourceImageDineIn()) != null && !pathResourceImageDineIn.isEmpty() && (img_at_spot = this.mapResourceImagesTypeOrder.get(pathResourceImageDineIn)) == null) {
                img_at_spot = new Image(this.getClass().getResource(pathResourceImageDineIn).toURI().toString());
                this.mapResourceImagesTypeOrder.put(pathResourceImageDineIn, img_at_spot);
            }
            if ((pathImageTakeAway = this.getImageTakeAway()) != null && !pathImageTakeAway.isEmpty() && (img_take_away = this.mapImagesTypeOrder.get(pathImageTakeAway)) == null) {
                File image = null;
                image = this.m_FilerUtils.getFileFullPath("images/logos/" + pathImageTakeAway);
                if (image != null && image.exists()) {
                    img_take_away = new Image(image.toURI().toString());
                    this.mapImagesTypeOrder.put(pathImageTakeAway, img_take_away);
                }
            }
            if (img_take_away == null && (pathResourceImageTakeAway = this.getResourceImageTakeAway()) != null && !pathResourceImageTakeAway.isEmpty() && (img_take_away = this.mapResourceImagesTypeOrder.get(pathResourceImageTakeAway)) == null) {
                img_take_away = new Image(this.getClass().getResource(pathResourceImageTakeAway).toURI().toString());
                this.mapResourceImagesTypeOrder.put(pathResourceImageTakeAway, img_take_away);
            }
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (img_at_spot != null) {
            if (this.at_spotImgView == null) {
                this.at_spotImgView = new ImageView();
            }
            this.at_spotImgView.setImage(img_at_spot);
            System.out.println("img_at_spot.getHeight() : " + img_at_spot.getHeight());
            System.out.println("img_at_spot.getWidth() : " + img_at_spot.getWidth());
            if (img_at_spot.getHeight() > img_at_spot.getWidth()) {
                this.at_spotImgView.setFitHeight(height);
            } else {
                this.at_spotImgView.setFitWidth(width);
            }
            this.at_spotImgView.setPreserveRatio(true);
            this.at_spotImgView.setSmooth(true);
            this.at_spotImgView.setCache(true);
            if (this.name_At_Spot != null) {
                this.name_At_Spot.setText("");
            }
            if (this.iconSP != null) {
                this.iconSP.setGraphic(null);
            }
            if (AppLocal.ONLY_TAKE_AWAY_BORNE && AppLocal.SHOW_ONSEAT_BORNE_WITH_CLOSE_OVERLAY) {
                this.btn_sp.setGraphic((Node)TypeOrdercontroller.getClosedTypeStack(this.at_spotImgView, "23"));
            } else {
                this.at_spotImgView.setOpacity(1.0);
                this.btn_sp.setGraphic((Node)this.at_spotImgView);
            }
        }
        if (img_take_away != null) {
            if (this.take_awayImgView == null) {
                this.take_awayImgView = new ImageView();
            }
            this.take_awayImgView.setImage(img_take_away);
            System.out.println("img_take_away.getHeight() : " + img_take_away.getHeight());
            System.out.println("img_take_away.getWidth() : " + img_take_away.getWidth());
            if (img_take_away.getHeight() > img_take_away.getWidth()) {
                this.take_awayImgView.setFitHeight(height);
            } else {
                this.take_awayImgView.setFitWidth(width);
            }
            this.take_awayImgView.setPreserveRatio(true);
            this.take_awayImgView.setSmooth(true);
            this.take_awayImgView.setCache(true);
            if (this.name_take_away != null) {
                this.name_take_away.setText("");
            }
            if (this.iconEMP != null) {
                this.iconEMP.setGraphic(null);
            }
            this.btn_emp.setGraphic((Node)this.take_awayImgView);
        }
    }

    private double getHeightLanguageFlags() {
        double heightLanguageFlags = AppVarUtils.getScreenDimension().getHeight() * 0.2 * 0.35;
        return heightLanguageFlags;
    }

    private void setContentFlag(double height, Button buttonFlag, Image imageFlag) {
        ImageView image_french_flag = this.getImageView(imageFlag, height);
        StackPane stackPane = new StackPane();
        Circle arc = new Circle(height * 0.45);
        arc.setFill((Paint)Color.TRANSPARENT);
        arc.setStroke((Paint)Color.web((String)this.color_hex));
        arc.setStrokeWidth(10.0);
        GridPane arcPane = new GridPane();
        stackPane.setPrefHeight(height);
        stackPane.setPrefWidth(height);
        arcPane.setPrefHeight(height);
        arcPane.setPrefWidth(height);
        arcPane.setAlignment(Pos.CENTER);
        stackPane.getChildren().add((Object)image_french_flag);
        stackPane.getChildren().add((Object)arcPane);
        buttonFlag.getProperties().put((Object)"arcPane", (Object)arcPane);
        buttonFlag.getProperties().put((Object)"arc", (Object)arc);
        buttonFlag.setGraphic((Node)stackPane);
    }

    private ImageView getImageView(Image imageFlag, double heightImage) {
        ImageView imageView = new ImageView(imageFlag);
        imageView.setFitHeight(heightImage);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setCache(true);
        return imageView;
    }

    private void selectFlag(Button buttonFlag) {
        if (buttonFlag.getProperties().get((Object)"arcPane") != null && buttonFlag.getProperties().get((Object)"arc") != null) {
            GridPane arcPane = (GridPane)buttonFlag.getProperties().get((Object)"arcPane");
            Circle arc = (Circle)buttonFlag.getProperties().get((Object)"arc");
            arcPane.getChildren().clear();
            arcPane.add((Node)arc, 0, 0);
        }
    }

    private void deselectFlag(Button buttonFlag) {
        if (buttonFlag.getProperties().get((Object)"arcPane") != null) {
            GridPane arcPane = (GridPane)buttonFlag.getProperties().get((Object)"arcPane");
            arcPane.getChildren().clear();
        }
    }

    private void selectLanguage(LanguageInfo currentLanguage) {
        AppLocal.APP_LANGUAGE = currentLanguage.getCode_language();
        System.out.println("AppLocal.APP_LANGUAGE  : " + AppLocal.APP_LANGUAGE);
        AppLocal.loadLanguages();
        this.setImagesTypeOrder();
        this.setTexts();
        for (Node node : this.pane_languages.getChildren()) {
            Button button_language = (Button)node;
            if (button_language.getProperties().get((Object)"language") == null) continue;
            LanguageInfo language = (LanguageInfo)button_language.getProperties().get((Object)"language");
            if (language != null && language.getId() == currentLanguage.getId()) {
                this.selectFlag(button_language);
                continue;
            }
            this.deselectFlag(button_language);
        }
    }

    private String getImageDineIn() {
        String path = null;
        if (AppLocal.APP_LANGUAGE != null) {
            switch (AppLocal.APP_LANGUAGE) {
                case "fr": {
                    if (AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE == null || AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE;
                    break;
                }
                case "en": {
                    if (AppLocal.BACKGROUND_AT_SPOT_EN_ORDER_BORNE == null || AppLocal.BACKGROUND_AT_SPOT_EN_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_AT_SPOT_EN_ORDER_BORNE;
                    break;
                }
                case "es": {
                    if (AppLocal.BACKGROUND_AT_SPOT_ES_ORDER_BORNE == null || AppLocal.BACKGROUND_AT_SPOT_ES_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_AT_SPOT_ES_ORDER_BORNE;
                    break;
                }
                case "ar": {
                    path = AppLocal.BACKGROUND_AT_SPOT_AR_ORDER_BORNE;
                    break;
                }
                default: {
                    if (AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE == null || AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE;
                }
            }
        }
        if (path == null && AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE != null && !AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE.isEmpty()) {
            path = AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE;
        }
        return path;
    }

    private String getImageTakeAway() {
        String path = null;
        if (AppLocal.APP_LANGUAGE != null) {
            switch (AppLocal.APP_LANGUAGE) {
                case "fr": {
                    if (AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE == null || AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE;
                    break;
                }
                case "en": {
                    if (AppLocal.BACKGROUND_TAKE_AWAY_EN_ORDER_BORNE == null || AppLocal.BACKGROUND_TAKE_AWAY_EN_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_TAKE_AWAY_EN_ORDER_BORNE;
                    break;
                }
                case "es": {
                    if (AppLocal.BACKGROUND_TAKE_AWAY_ES_ORDER_BORNE == null || AppLocal.BACKGROUND_TAKE_AWAY_ES_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_TAKE_AWAY_ES_ORDER_BORNE;
                    break;
                }
                case "ar": {
                    if (AppLocal.BACKGROUND_TAKE_AWAY_AR_ORDER_BORNE == null || AppLocal.BACKGROUND_TAKE_AWAY_AR_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_TAKE_AWAY_AR_ORDER_BORNE;
                    break;
                }
                default: {
                    if (AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE == null || AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE.isEmpty()) break;
                    path = AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE;
                }
            }
        }
        if (path == null && AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE != null && !AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE.isEmpty()) {
            path = AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE;
        }
        return path;
    }

    private String getResourceImageDineIn() {
        String path = null;
        if (AppLocal.APP_LANGUAGE != null) {
            switch (AppLocal.APP_LANGUAGE) {
                case "fr": {
                    path = "/com/openbravo/images/dine_in_fr.png";
                    break;
                }
                case "en": {
                    path = "/com/openbravo/images/dine_in_en.png";
                    break;
                }
                case "es": {
                    path = "/com/openbravo/images/dine_in_es.png";
                    break;
                }
                case "ar": {
                    path = "/com/openbravo/images/dine_in_ar.png";
                    break;
                }
                default: {
                    path = "/com/openbravo/images/dine_in_fr.png";
                }
            }
        }
        if (path == null) {
            path = "/com/openbravo/images/dine_in_fr.png";
        }
        return path;
    }

    private String getResourceImageTakeAway() {
        String path = null;
        if (AppLocal.APP_LANGUAGE != null) {
            switch (AppLocal.APP_LANGUAGE) {
                case "fr": {
                    path = "/com/openbravo/images/take_away_fr.png";
                    break;
                }
                case "en": {
                    path = "/com/openbravo/images/take_away_en.png";
                    break;
                }
                case "es": {
                    path = "/com/openbravo/images/take_away_es.png";
                    break;
                }
                case "ar": {
                    path = "/com/openbravo/images/take_away_ar.png";
                    break;
                }
                default: {
                    path = "/com/openbravo/images/take_away_fr.png";
                }
            }
        }
        if (path == null) {
            path = "/com/openbravo/images/take_away_fr.png";
        }
        return path;
    }

    public void loadAvomarkScanner() {
        System.out.println("******* Load Avomark Scanner *******");
        try {
            this.mActionEventAvomark = new EventHiddenModal(){
                Object[] result;
                boolean useCode = false;

                @Override
                public void onHidden() {
                    if (this.useCode) {
                        TypeOrdercontroller.this.useAvomarkCode();
                    } else {
                        TypeOrdercontroller.this.showNext();
                        System.out.println("***********(String) result[0] " + (String)this.result[0]);
                        if ((String)this.result[0] != null) {
                            String CardNumber = (String)this.result[0];
                            TypeOrdercontroller.this.getAvomarkClient(CardNumber);
                        } else {
                            AppLocal.currentAvomarkClient = null;
                        }
                    }
                    TypeOrdercontroller.this.mLazyModalAvomark.destroyEvents();
                    TypeOrdercontroller.this.mActionEventAvomark = null;
                    TypeOrdercontroller.this.main_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        AvomarkController mController = (AvomarkController)mBuilder.getController();
                        this.result = mController.getResult();
                        this.useCode = mController.wantToUseCode();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalAvomark == null) {
                this.mLazyModalAvomark = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fx/templates/borne/Avomark_info.fxml", AppVarUtils.getScreenDimension());
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            ColorAdjust colorAdjust = new ColorAdjust();
            colorAdjust.setBrightness(-0.5);
            colorAdjust.setInput((Effect)blur);
            this.main_pane.setEffect((Effect)colorAdjust);
            this.mLazyModalAvomark.setEventHiddenModal(this.mActionEventAvomark);
            this.mLazyModalAvomark.load(true);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void useAvomarkCode() {
        try {
            this.avomarkCodeEventHandler = new EventHiddenModal(){
                Object[] result;

                @Override
                public void onHidden() {
                    TypeOrdercontroller.this.avomarkCodeModal.destroyEvents();
                    TypeOrdercontroller.this.avomarkCodeEventHandler = null;
                    TypeOrdercontroller.this.main_pane.setEffect(null);
                    if ((AvomarkClient)this.result[0] != null) {
                        AppLocal.currentAvomarkClient = (AvomarkClient)this.result[0];
                        TypeOrdercontroller.this.showNext();
                        TypeOrdercontroller.this.laodCategoriesAfterGetVouchers();
                    } else {
                        AppLocal.currentAvomarkClient = null;
                        TypeOrdercontroller.this.loadAvomarkScanner();
                    }
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        AvomarkCodeController mController = (AvomarkCodeController)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.avomarkCodeModal == null) {
                this.avomarkCodeModal = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fx/templates/borne/avomark_code_template.fxml", new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.85), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.8)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            ColorAdjust colorAdjust = new ColorAdjust();
            colorAdjust.setBrightness(-0.5);
            colorAdjust.setInput((Effect)blur);
            this.main_pane.setEffect((Effect)colorAdjust);
            this.avomarkCodeModal.setEventHiddenModal(this.avomarkCodeEventHandler);
            this.avomarkCodeModal.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void getAvomarkClient(String cardNumber) {
        if (this.mAvomarkService == null) {
            this.mAvomarkService = AvomarkService.getInstance();
        }
        AppLocal.currentAvomarkClient = this.mAvomarkService.getAvomarkClient(cardNumber);
        this.laodCategoriesAfterGetVouchers();
    }

    public void laodCategoriesAfterGetVouchers() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                System.out.println("********controller" + TypeOrdercontroller.this.controller);
                if (TypeOrdercontroller.this.controller != null) {
                    TypeOrdercontroller.this.controller.laodCategoriesAfterGetVouchers();
                }
            }
        }));
    }

    public static StackPane getClosedTypeStack(ImageView imageView, String fontSize) {
        StackPane stack = new StackPane();
        stack.setAlignment(Pos.CENTER);
        stack.setStyle("-fx-padding: 0px;");
        Label closed = new Label("FERM\u00c9E");
        closed.setStyle("-fx-border-color: transparent; -fx-text-fill: white; -fx-font-size: " + fontSize + "pt; -fx-background-color: black; -fx-font-weight: bold; -fx-border-radius: 10px; -fx-background-radius: 10px; -fx-padding: 8 15 8 15;");
        closed.setAlignment(Pos.BOTTOM_CENTER);
        imageView.setOpacity(0.5);
        stack.getChildren().add((Object)imageView);
        stack.getChildren().add((Object)closed);
        return stack;
    }
}

