/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.borne.CatalogueController;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ClotureService;
import com.openbravo.service.LoyaltyService;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.services.TagsService;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;

public class Tagscontroller
implements PropertyChangeListener {
    private JRootApp m_App;
    private Scene scene;
    private String color_hex;
    private String fond_color_hex;
    private String color_type_order;
    private Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private Scene catalogScene;
    private CatalogueController controller;
    private FilerUtils m_FilerUtils = null;
    private ClotureService clotureService;
    private String loyalty_fxml = "/fx/templates/borne/loyalty_info.fxml";
    private LazyModal mLazyModalLoyalty = null;
    private EventHiddenModal mActionEventLoyalty = null;
    private LoyaltyService mLoyaltyService;
    private boolean load_popup;
    private int number_line;
    private int number_column;
    private List<TagInfo> tags;
    private TagsService mTagsService;
    private Dimension sizeScreen = Toolkit.getDefaultToolkit().getScreenSize();
    @FXML
    GridPane pane_tags;
    @FXML
    Label label_background;
    @FXML
    ImageView background;
    @FXML
    GridPane pane_bloc_cloture;
    @FXML
    Label label_cloture;
    private EventHandler mEventHandlerChooseTag = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            System.out.println("load_popup : " + Tagscontroller.this.load_popup);
            if (!Tagscontroller.this.load_popup) {
                Tagscontroller.this.load_popup = true;
                System.out.println("mButtonSource : " + mButtonSource);
                System.out.println(" mButtonSource.getProperties().get(\"tag\") : " + mButtonSource.getProperties().get((Object)"tag"));
                if (mButtonSource != null && mButtonSource.getProperties().get((Object)"tag") != null) {
                    try {
                        TagInfo mTagInfo = (TagInfo)mButtonSource.getProperties().get((Object)"tag");
                        System.out.println("mTagInfo check : " + mTagInfo);
                        if (Tagscontroller.this.catalogScene == null || Tagscontroller.this.controller == null) {
                            Tagscontroller.this.initCatalogController();
                        }
                        Tagscontroller.this.controller.loadCatalog(mTagInfo);
                        Tagscontroller.this.controller.displayAvomarkUserInfos();
                        if (AppLocal.currentCustomerLoyalty != null) {
                            if (Tagscontroller.this.controller != null) {
                                Tagscontroller.this.controller.setCustomerPoints(AppLocal.currentCustomerLoyalty.printPoints(), true, true);
                            }
                        } else if (Tagscontroller.this.controller != null) {
                            Tagscontroller.this.controller.setCustomerPoints("", false, true);
                        }
                        System.out.println("check launch");
                        Tagscontroller.this.m_App.getFxPanel().setScene(Tagscontroller.this.catalogScene);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        }
    };

    public void initialize(JRootApp app, Scene scene) throws BasicException {
        this.m_App = app;
        this.scene = scene;
        this.number_line = 2;
        this.number_column = 2;
        this.mTagsService = TagsService.getInstance();
        this.tags = new ArrayList<TagInfo>();
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.fond_color_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
        this.color_type_order = ColorUtils.getColor(AppLocal.COLOR_TYPE_ORDER);
        this.m_FilerUtils = FilerUtils.getInstance();
        DataLogicSales dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.clotureService = ClotureService.getInstance(dlSales, this.m_App);
        try {
            this.setImageBackGround();
            ExecutorService exec = Executors.newSingleThreadExecutor();
            exec.execute(() -> Platform.runLater(() -> {
                try {
                    System.out.println("+++++++++++++ date init start : " + new Date());
                    this.initCatalogController();
                    System.out.println("+++++++++++++ date init end : " + new Date());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }));
            this.loadTags();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void initCatalogController() throws IOException, BasicException, URISyntaxException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/catalog_page.fxml"));
        Parent rootNode = (Parent)loader.load();
        this.controller = (CatalogueController)loader.getController();
        this.catalogScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
        Font.loadFont((InputStream)this.getClass().getResourceAsStream("/fonts/Bukhari Script.ttf"), (double)20.0);
        this.catalogScene.getStylesheets().add((Object)"/styles/styles.css");
        this.catalogScene.getStylesheets().add((Object)"/styles/app.css");
        this.controller.initialize(this.m_App, this.catalogScene);
        this.clotureService.addPropertyChangeListener(this.controller);
    }

    public void reload() {
        this.load_popup = false;
        if (AppLocal.START_CLOTURE) {
            System.out.println("+++++++++++++ show bloc cloture");
            this.showBlocInfoCloture();
        } else {
            System.out.println("+++++++++++++ hide bloc cloture");
            this.hideBlocInfoCloture();
        }
        if (AppLocal.RECEIVED_TAG_CHANGE_EVENT) {
            AppLocal.RECEIVED_TAG_CHANGE_EVENT = false;
            this.pane_tags.getChildren().clear();
            this.loadTags();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String event = evt.getPropertyName();
        if (event.equals("end_cloture")) {
            this.hideBlocInfoCloture();
        } else {
            System.out.println("+++++++++++++++ show bloc cloture");
            this.showBlocInfoCloture();
        }
    }

    private void showBlocInfoCloture() {
        this.pane_bloc_cloture.getChildren().clear();
        this.pane_bloc_cloture.add((Node)this.label_cloture, 0, 0);
    }

    private void hideBlocInfoCloture() {
        this.pane_bloc_cloture.getChildren().clear();
    }

    private void setImageBackGround() {
        File image_path;
        String path = AppLocal.BACKGROUND_TAGS_BORNE;
        double heightImage = AppVarUtils.getScreenDimension().getHeight();
        Image img_logo = null;
        if (path != null && !path.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path)) != null && image_path.exists()) {
            img_logo = new Image(image_path.toURI().toString());
        }
        if (img_logo != null) {
            this.background.setImage(img_logo);
            this.background.setFitHeight(heightImage);
            this.background.setPreserveRatio(true);
            this.background.setSmooth(true);
            this.background.setCache(true);
        }
    }

    public void loadTags() {
        boolean canShowTags = false;
        if (AppLocal.SHOW_TAGS_IN_BORNE && !AppLocal.HIDE_TAGS_IN_CATALOG) {
            this.tags = this.mTagsService.getActiveTags();
            boolean bl = canShowTags = this.tags != null && !this.tags.isEmpty();
        }
        if (canShowTags) {
            this.showTags();
        }
    }

    private void showTags() {
        if (this.tags != null) {
            int totalTags = this.tags.size();
            int nbTagPerRow = 2;
            int nbRows = (int)Math.ceil((double)totalTags / (double)nbTagPerRow);
            double tagBtnSize = 300.0;
            for (int i = 0; i < nbRows; ++i) {
                HBox hb = new HBox();
                hb.setStyle("-fx-background-color: transparent;");
                hb.setAlignment(Pos.CENTER);
                hb.setSpacing(30.0);
                int end = Math.min((i + 1) * nbTagPerRow, totalTags);
                for (int j = i * nbTagPerRow; j < end; ++j) {
                    hb.getChildren().add((Object)this.getTagButton(this.tags.get(j), tagBtnSize));
                }
                this.pane_tags.add((Node)hb, 0, i);
            }
        }
    }

    private Button getTagButton(TagInfo ti, double tagBtnSize) {
        Button buttonTag = new Button();
        buttonTag.setPrefHeight(tagBtnSize);
        buttonTag.setPrefWidth(tagBtnSize);
        buttonTag.setMaxSize(tagBtnSize, tagBtnSize);
        buttonTag.setMinSize(tagBtnSize, tagBtnSize);
        buttonTag.setStyle("-fx-border-radius: 50%; -fx-background-radius: 50%; -fx-background-color: transparent; -fx-border-color: transparent; -fx-text-fill: black; -fx-font-size: 22pt;");
        if (ti.getLogo_tag() != null && !ti.getLogo_tag().isEmpty()) {
            Image tagImage;
            File image = this.m_FilerUtils.getFileFullPath("images/tags/" + ti.getLogo_tag());
            if (image.exists() && (tagImage = new Image(image.toURI().toString())).getException() == null) {
                ImageView imageView = new ImageView(tagImage);
                imageView.setFitHeight(buttonTag.getPrefHeight() * 0.9);
                imageView.setFitWidth(buttonTag.getPrefWidth() * 0.9);
                imageView.setPreserveRatio(false);
                imageView.setSmooth(false);
                if (ti.isClosed()) {
                    buttonTag.setGraphic((Node)Tagscontroller.getClosedTagStack(imageView, "22"));
                } else {
                    buttonTag.setGraphic((Node)imageView);
                }
            }
        } else {
            buttonTag.setWrapText(true);
            buttonTag.setText(ti.toString());
        }
        System.out.println("!ti.isClosed() : " + !ti.isClosed());
        if (!ti.isClosed()) {
            buttonTag.getProperties().put((Object)"tag", (Object)ti);
            buttonTag.setOnAction(this.mEventHandlerChooseTag);
        }
        return buttonTag;
    }

    public static StackPane getClosedTagStack(ImageView imageView, String fontSize) {
        StackPane stack = new StackPane();
        stack.setAlignment(Pos.BOTTOM_CENTER);
        stack.setStyle("-fx-padding: 0 0 20 0;");
        Label closed = new Label("FERM\u00c9E");
        closed.setStyle("-fx-border-color: transparent; -fx-text-fill: white; -fx-font-size: " + fontSize + "pt; -fx-background-color: #8B0000; -fx-font-weight: bold; -fx-border-radius: 10px; -fx-background-radius: 10px; -fx-padding: 5px;");
        closed.setAlignment(Pos.BOTTOM_CENTER);
        imageView.setOpacity(0.5);
        stack.getChildren().add((Object)imageView);
        stack.getChildren().add((Object)closed);
        return stack;
    }
}

