/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.borne.AbstractController;
import com.openbravo.controllers.borne.AddNameClientBorne;
import com.openbravo.controllers.borne.AvomarkConfirmLoyaltyController;
import com.openbravo.controllers.borne.BipperBorneController;
import com.openbravo.controllers.borne.CatalogueController;
import com.openbravo.controllers.borne.EaselNumberController;
import com.openbravo.controllers.borne.MessageCBController;
import com.openbravo.controllers.borne.MessageComptoirController;
import com.openbravo.controllers.borne.MessageSoldOutcontroller;
import com.openbravo.controllers.borne.PaymentCBController;
import com.openbravo.controllers.borne.PaymentOrdercontroller;
import com.openbravo.controllers.borne.PhoneCustomercontroller;
import com.openbravo.controllers.borne.PromoCodeController;
import com.openbravo.controllers.loyalty.SendValidCodeController;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.events.CustomBasketListBorne;
import com.openbravo.format.Formats;
import com.openbravo.models.HBoxBorne;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.UserInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.service.TicketService;
import com.procaisse.avomark.AvomarkService;
import fr.protactile.procaisse.cache.SharedMemoryCache;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.services.CustomerService;
import fr.protactile.procaisse.tpeCB.PaymentByCardFacade;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.json.simple.JSONObject;

public class SummaryOrdercontroller
extends AbstractController
implements PropertyChangeListener {
    private Scene catalogScene;
    @FXML
    ListView list_detail;
    @FXML
    Label total_order_label;
    @FXML
    GridPane main_pane;
    @FXML
    Button btn_update;
    @FXML
    Label title_order;
    @FXML
    Label label_background;
    @FXML
    ImageView background;
    @FXML
    ImageView image_product;
    @FXML
    GridPane first_pane;
    @FXML
    GridPane pane_product;
    @FXML
    Button btn_add_promo;
    @FXML
    GridPane pane_price;
    @FXML
    Label price_promo;
    @FXML
    Label name_product;
    @FXML
    StackPane pane_image;
    @FXML
    Label min_price_order;
    @FXML
    GridPane pane_min_price_order;
    @FXML
    Button button_valid;
    @FXML
    Button add_promobtn;
    @FXML
    GridPane pane_bloc_cloture;
    @FXML
    Label label_cloture;
    @FXML
    GridPane pane_add_promo;
    @FXML
    StackPane pane_info_product;
    @FXML
    GridPane parent_pane;
    @FXML
    Label label_total;
    private JRootApp m_App;
    private CatalogueController catalogueController;
    private String color_hex;
    private ProductInfoExt product_promo;
    private PaymentOrdercontroller mPaymentOrdercontroller;
    private Scene paymentOrderScene;
    private MessageComptoirController mMessageComptoirController;
    private Scene paymentComptoirScene;
    private ProductInfoExt product;
    private double heightImage = AppVarUtils.getScreenDimension().getHeight();
    private Image image_background;
    private Image image_background_promo;
    private TicketService mTicketService;
    private List<TicketLineInfo> linesSoldOut;
    private LazyModal mLazyModalMessageSoldOut = null;
    private EventHiddenModal mActionEventMessageSoldOut = null;
    private Scene scene;
    private PaymentCBController mPaymentCBController;
    private Scene paymentCBScene;
    private String valid_code_fxml = "/fx/templates/borne/send_valid_code.fxml";
    private LazyModal mLazyModalValidCode = null;
    private EventHiddenModal mActionEventValidCode = null;
    private String promo_code_fxml = "/fx/templates/borne/promo_code.fxml";
    private LazyModal mLazyModalPromocode = null;
    private EventHiddenModal mActionEventPromoCode = null;
    private final String SIZE_IMAGE_128 = "_128px";
    private final String SIZE_IMAGE_512 = "_512px";
    private MessageCBController mMessageCBController;
    private Scene messageScene;
    private boolean addPromoCode;
    private String bipper_fxml = "/fx/templates/borne/popUp_bipper_borne.fxml";
    private LazyModal mLazyModalBipper = null;
    private EventHiddenModal mActionEventBipper = null;
    private String label_discount_code_promo = "Code promo ";
    private String label_discount_biborne_lunch = "Biborne lunch ";
    private String phone_customer_fxml = "/fx/templates/borne/phone_customer.fxml";
    private LazyModal mLazyModalPhoneCustomer = null;
    private EventHiddenModal mActionEventPhoneCustomer = null;
    private CustomerService mCustomerService;
    private Image imagePromo;
    private String bg_color_button_validation;
    private String bg_color_code_promo;
    private String addNameClientBorne_fxml = "/fx/templates/borne/add_name_client_borne.fxml";
    private LazyModal mLazyModalNameClientBorne = null;
    private EventHiddenModal mActionEventNameClientBorne = null;
    private String easel_number_fxml = "/fx/templates/borne/popUp_easel_number.fxml";
    private LazyModal mLazyModalEaselNumber = null;
    private EventHiddenModal mActionEventEaselNumber = null;
    private final String CB_PAYMENT = "cb_payment";
    private final String COUNTER_PAYMENT = "counter_payment";
    private EventHiddenModal avomarkConfirmLoyaltyEventHandler = null;
    private LazyModal avomarkConfirmLoyaltyModal = null;
    private String label_reduction_avomark = "R\u00e9duction Avomark ";
    private double discount_avomark = 0.0;
    private SharedMemoryCache mSharedMemoryCache;
    private AvomarkService mAvomarkService;
    boolean cashBack_used = false;

    public void initialize(JRootApp app, CatalogueController catalogueController, Scene orderScene) throws BasicException {
        this.m_App = app;
        this.scene = orderScene;
        this.bg_color_button_validation = ColorUtils.getColor(AppLocal.BG_COLOR_CODE_PROMO);
        this.add_promobtn.setStyle("-fx-background-color: " + this.bg_color_code_promo + ";\n-fx-background-radius: 50px;\n    -fx-border-radius: 50px;\n-fx-font-size: 14pt;\n     -fx-font-weight: bold; -fx-text-fill: black;");
        this.mTicketService = TicketService.getInstance();
        this.linesSoldOut = new ArrayList<TicketLineInfo>();
        this.catalogueController = catalogueController;
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.main_pane.setStyle("-fx-background-color: transparent;");
        this.btn_update.setStyle("-fx-background-color: " + this.color_hex + ";");
        this.catalogScene = catalogueController.getScene();
        this.refProducts = new HashMap();
        this.m_FilerUtils = FilerUtils.getInstance();
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlItems = (DataLogicItems)this.m_App.getBean("com.openbravo.dao.DataLogicItems");
        this.list_detail.setCellFactory((Callback)new Callback<ListView<HBoxBorne>, ListCell<HBoxBorne>>(){

            public CustomBasketListBorne call(ListView<HBoxBorne> listView) {
                return new CustomBasketListBorne();
            }
        });
        this.first_pane.getChildren().clear();
        if (AppLocal.PROMO_BASKET && AppLocal.MIN_PRICE_ORDER_PROMO_BASKET != 0.0) {
            this.product_promo = null;
            this.product = this.dlSales.getProductPromoBasket();
            if (this.product != null) {
                this.name_product.setText(this.product.getName().toUpperCase());
                Image image = this.getImageProduct(this.product, "_512px");
                double width_image = AppVarUtils.getScreenDimension().getWidth() * 0.35 * 0.8;
                double height_image = AppVarUtils.getScreenDimension().getHeight() * 0.25 * 0.9 * 0.7;
                this.image_product.setImage(image);
                if (image.getWidth() > image.getHeight()) {
                    this.image_product.setFitWidth(width_image);
                } else {
                    this.image_product.setFitHeight(height_image);
                }
                this.image_product.setPreserveRatio(true);
                this.image_product.setSmooth(true);
                this.image_product.setCache(true);
                this.pane_image.setPrefHeight(this.image_product.getBoundsInLocal().getHeight());
                this.first_pane.add((Node)this.pane_info_product, 0, 0);
                this.first_pane.add((Node)this.pane_add_promo, 0, 1);
            }
        } else {
            this.first_pane.add((Node)this.pane_bloc_cloture, 0, 0);
        }
        this.addPromoCode = AppLocal.PROMO_CODE_BORNE;
        if (this.addPromoCode) {
            this.add_promobtn.setVisible(true);
        } else {
            this.add_promobtn.setVisible(false);
        }
        this.mCustomerService = CustomerService.getInstance();
        this.bg_color_button_validation = ColorUtils.getColor(AppLocal.BG_COLOR_BUTTON_VALIDATION);
        this.button_valid.setStyle("-fx-background-color: " + this.bg_color_button_validation + ";-fx-border-color: " + this.bg_color_button_validation + ";");
        this.mSharedMemoryCache = SharedMemoryCache.getInstance();
        this.mAvomarkService = AvomarkService.getInstance();
    }

    public void addPromoCode() {
        this.loadPopUpPromoCode();
    }

    public void AddOrder() {
        String type;
        boolean bipMandatory = false;
        if (AppLocal.ticketBorne != null && ((type = AppLocal.ticketBorne.getType()).equalsIgnoreCase("Sur Place") && AppLocal.BIP_ONSITE || type.equalsIgnoreCase("A Emporter") && !AppLocal.ticketBorne.isTake_away_phone() && AppLocal.BIP_TAKEAWAY || AppLocal.ticketBorne.isTake_away_phone() && AppLocal.BIP_TAKEAWAY_PHONE)) {
            bipMandatory = true;
        }
        if (AppLocal.CUSTOMER_LOYALTY && AppLocal.currentCustomerLoyalty != null) {
            if (!AppLocal.currentCustomerLoyalty.isActif() || AppLocal.currentCustomerLoyalty.getGender() == null) {
                System.out.println("Gender 2: " + AppLocal.currentCustomerLoyalty.getGender());
                this.loadPopUpValidCode();
            } else if (bipMandatory) {
                this.loadPopUpBipper();
            } else {
                this.setCustomerPhone();
            }
        } else if (bipMandatory) {
            this.loadPopUpBipper();
        } else {
            this.setCustomerPhone();
        }
    }

    public void showPayment() {
        try {
            if (this.mPaymentOrdercontroller == null || this.paymentOrderScene == null || AppLocal.CASHLOGY_ENABLED) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/typePayment_page.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mPaymentOrdercontroller = (PaymentOrdercontroller)loader.getController();
                this.paymentOrderScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.paymentOrderScene.getStylesheets().add((Object)"/styles/styles.css");
                this.paymentOrderScene.getStylesheets().add((Object)"/styles/app.css");
                this.mPaymentOrdercontroller.initialize(this.m_App, this.catalogueController, this.paymentOrderScene);
            }
            this.mPaymentOrdercontroller.startPayment();
            this.m_App.getFxPanel().setScene(this.paymentOrderScene);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void showMessageComptoir() {
        try {
            if (this.mMessageComptoirController == null || this.paymentComptoirScene == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/payment_message_comptoir.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mMessageComptoirController = (MessageComptoirController)loader.getController();
                this.paymentComptoirScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.paymentComptoirScene.getStylesheets().add((Object)"/styles/styles.css");
                this.paymentComptoirScene.getStylesheets().add((Object)"/styles/app.css");
                this.mMessageComptoirController.initialize(this.m_App);
            }
            this.mMessageComptoirController.setImageBackground();
            this.mMessageComptoirController.printOrderAndRestart();
            this.m_App.getFxPanel().setScene(this.paymentComptoirScene);
        }
        catch (BasicException | IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadPanier() {
        if (AppLocal.ticketBorne != null) {
            this.total_order_label.setText(AppLocal.ticketBorne.printTotal());
            this.list_detail.getItems().clear();
            ArrayList<HBoxBorne> list = new ArrayList<HBoxBorne>();
            if (this.imagePromo == null) {
                this.setImagePromo();
            }
            for (TicketLineInfo line : AppLocal.ticketBorne.getLines()) {
                if (line.isNext()) continue;
                System.out.println("+++++++++++++++ panier supplement size : " + line.getListSupplements().size());
                HBoxBorne componentLine = new HBoxBorne(line, this.imagePromo);
                list.add(componentLine);
            }
            if (AppLocal.ticketBorne.getLinesCount() > 0 && AppLocal.ticketBorne.getDiscount() > 0.0) {
                String text_discount = "";
                String label_discount_ticket_borne = AppLocal.ticketBorne.getLabel_discount();
                System.out.println("**********label_discount_ticket_borne : " + label_discount_ticket_borne);
                if (label_discount_ticket_borne != null && !label_discount_ticket_borne.isEmpty()) {
                    StringBuilder label_discount = new StringBuilder();
                    label_discount.append(label_discount_ticket_borne);
                    if (!label_discount_ticket_borne.startsWith(this.label_discount_code_promo) && !label_discount_ticket_borne.startsWith(this.label_reduction_avomark)) {
                        label_discount.append(" ");
                        label_discount.append("-");
                        label_discount.append((int)AppLocal.ticketBorne.getDiscount());
                        label_discount.append(" ");
                        label_discount.append("pourcentage".equals(AppLocal.ticketBorne.getTypeDiscount()) ? "%" : Formats.getCurrency());
                    }
                    text_discount = label_discount_ticket_borne.startsWith(this.label_reduction_avomark) ? "Programme de fid\u00e9lit\u00e9 " : label_discount.toString();
                } else {
                    text_discount = "pourcentage".equals(AppLocal.ticketBorne.getTypeDiscount()) ? "Promotion globale " + String.valueOf((int)AppLocal.ticketBorne.getDiscount()) + "%" : "Promotion globale";
                }
                System.out.println("****** text_discount" + text_discount);
                System.out.println("****** discount" + AppLocal.ticketBorne.printDiscount());
                HBoxBorne componentDiscount = new HBoxBorne(text_discount, AppLocal.ticketBorne.printDiscount());
                list.add(componentDiscount);
            }
            ObservableList observableList = FXCollections.observableArrayList();
            observableList.setAll(list);
            this.list_detail.setItems(observableList);
        }
    }

    public void updateOrder() {
        if (AppLocal.ticketBorne.getLabel_discount() != null && AppLocal.ticketBorne.getLabel_discount().equals(this.label_reduction_avomark)) {
            AppLocal.ticketBorne.setDiscount(0.0);
            AppLocal.ticketBorne.setLabel_discount(null);
        }
        if (this.m_App != null && this.m_App.getFxPanel() != null) {
            this.m_App.getFxPanel().setScene(this.catalogScene);
        }
    }

    private void setImageBackGround() {
        boolean backgroudn_promo = false;
        if (AppLocal.PROMO_BASKET && this.product_promo != null && AppLocal.ticketBorne.getTotal() > AppLocal.MIN_PRICE_ORDER_PROMO_BASKET) {
            backgroudn_promo = true;
            if (this.image_background_promo == null) {
                this.image_background_promo = this.getImage(AppLocal.BACKGROUND_SUMMARY_ORDER_PROMO);
            }
        }
        if (backgroudn_promo) {
            this.min_price_order.setText(AppLocal.MIN_PRICE_ORDER_PROMO_BASKET_TEXT + " " + Formats.getCurrency());
        } else if (this.image_background == null) {
            this.image_background = this.getImage(AppLocal.BACKGROUND_SUMMARY_ORDER);
        }
        if (this.image_background != null || backgroudn_promo && this.image_background_promo != null) {
            if (backgroudn_promo && this.image_background_promo != null) {
                this.background.setImage(this.image_background_promo);
            } else {
                this.background.setImage(this.image_background);
            }
            this.background.setFitHeight(this.heightImage);
            this.background.setPreserveRatio(true);
            this.background.setSmooth(true);
            this.background.setCache(true);
        } else {
            this.label_background.setStyle("-fx-background-color: " + this.color_hex + ";");
        }
    }

    public void addPromo() {
        try {
            ArrayList<ItemOrderInfo> listChoiceIngredient = new ArrayList<ItemOrderInfo>();
            ArrayList<OptionItemOrder> listChoiceSupplement = new ArrayList<OptionItemOrder>();
            ArrayList<ProductTicket> listProducts = new ArrayList<ProductTicket>();
            this.loadInfoProduct(this.product_promo, false, listChoiceSupplement);
            if (this.product_promo.getIngredients() != null && !this.product_promo.getIngredients().isEmpty() || this.product_promo.getSupplements() != null && !this.product_promo.getSupplements().isEmpty() || this.product_promo.getCartes() != null && !this.product_promo.getCartes().isEmpty()) {
                this.loadProduct();
            } else {
                boolean promo_product = AppLocal.ticketBorne.getTotal() > AppLocal.MIN_PRICE_ORDER_PROMO_BASKET;
                this.addTicketLine(this.product_promo, this.product_promo.getPriceSell(), listChoiceSupplement, listChoiceIngredient, listProducts, false, null, null, 1, false, promo_product);
                this.btn_add_promo.setVisible(false);
                this.loadPanier();
            }
            this.main_pane.requestFocus();
        }
        catch (BasicException ex) {
            Logger.getLogger(SummaryOrdercontroller.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean existPromoBasket() {
        for (TicketLineInfo line : AppLocal.ticketBorne.getLines()) {
            if (!line.isPromo_basket()) continue;
            return true;
        }
        return false;
    }

    private void loadProduct() {
        if (this.m_App != null && this.m_App.getFxPanel() != null) {
            this.m_App.getFxPanel().setScene(this.catalogScene);
            this.catalogueController.chooseProductPromoBasket(this.product_promo, AppLocal.ticketBorne.getTotal() > AppLocal.MIN_PRICE_ORDER_PROMO_BASKET);
        }
    }

    private Image getImage(String path) {
        File image_path;
        Image img_logo = null;
        if (path != null && !path.isEmpty() && (image_path = new File(new File(System.getProperty("user.home")), "images/logos/" + path)).exists()) {
            img_logo = new Image(image_path.toURI().toString());
        }
        return img_logo;
    }

    public void loadInfoPromoAndBasket(boolean canceled_cb_payment) {
        System.out.println("********loadInfoPromoAndBasket()************");
        if (this.product != null && AppLocal.MIN_PRICE_ORDER_PROMO_BASKET != 0.0) {
            this.product_promo = (ProductInfoExt)this.product.clone();
            if (this.existPromoBasket()) {
                this.btn_add_promo.setVisible(false);
            } else {
                this.btn_add_promo.setVisible(true);
            }
            if (AppLocal.ticketBorne.getTotal() > AppLocal.MIN_PRICE_ORDER_PROMO_BASKET) {
                this.product_promo.setPriceSell(AppLocal.PRICE_PROMO_BASKET);
            } else if (this.product_promo.isDifferent_price() && AppLocal.ticketBorne != null && AppLocal.ticketBorne.getType() != null) {
                switch (AppLocal.ticketBorne.getType()) {
                    case "Sur Place": {
                        this.product_promo.setPriceSell(this.product_promo.getPrice_sp());
                        break;
                    }
                    case "A Emporter": {
                        this.product_promo.setPriceSell(this.product_promo.getPrice_emp());
                        break;
                    }
                    default: {
                        this.product_promo.setPriceSell(this.product_promo.getPrice_sp());
                    }
                }
            }
            this.price_promo.setText(Formats.CURRENCY.formatValue(this.product_promo.getPriceSell()));
        }
        this.setTexts();
        if (!canceled_cb_payment) {
            this.validateOrder();
        }
        this.main_pane.requestFocus();
        this.main_pane.setAlignment(Pos.TOP_RIGHT);
        this.setImageBackGround();
        if (AppLocal.START_CLOTURE) {
            this.showBlocInfoCloture();
        } else {
            this.hideBlocInfoCloture();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String event = evt.getPropertyName();
        if (event.equals("end_cloture")) {
            this.hideBlocInfoCloture();
        }
    }

    private void showBlocInfoCloture() {
        this.pane_bloc_cloture.getChildren().clear();
        this.pane_bloc_cloture.add((Node)this.label_cloture, 0, 0);
        this.button_valid.setDisable(true);
    }

    private void hideBlocInfoCloture() {
        this.pane_bloc_cloture.getChildren().clear();
        this.button_valid.setDisable(false);
    }

    public void loadPopUpMessageSoldOut(String message) {
        try {
            this.mActionEventMessageSoldOut = new EventHiddenModal(){

                @Override
                public void onHidden() {
                    SummaryOrdercontroller.this.mLazyModalMessageSoldOut.destroyEvents();
                    SummaryOrdercontroller.this.mActionEventMessageSoldOut = null;
                    SummaryOrdercontroller.this.main_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        MessageSoldOutcontroller messageSoldOutcontroller = (MessageSoldOutcontroller)mBuilder.getController();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalMessageSoldOut == null) {
                this.mLazyModalMessageSoldOut = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fx/templates/borne/message_sold_out.fxml", new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.4)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.main_pane.setEffect((Effect)blur);
            this.mLazyModalMessageSoldOut.setEventHiddenModal(this.mActionEventMessageSoldOut);
            this.mLazyModalMessageSoldOut.load(message);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void deleteSoldOut() {
        for (TicketLineInfo ticketLineInfo : this.linesSoldOut) {
            AppLocal.ticketBorne.getLines().remove(ticketLineInfo);
        }
        this.loadPanier();
    }

    private void paymentCB() {
        int resultPing;
        PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
        if (facade.isTransactionSuccessed(resultPing = facade.doPing()) || AppLocal.CMI_TPE_PAYMENT) {
            if (AppLocal.ADD_EASEL_NUMBER && AppLocal.ticketBorne.getType() != null && AppLocal.ticketBorne.getType().equalsIgnoreCase("Sur Place")) {
                this.loadPopUpEaselNumber("cb_payment");
            } else {
                this.showPaymentCB();
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le payement en Carte Blue n'est pas connect\u00e9.", 4000, NPosition.CENTER);
        }
    }

    private void showPaymentCB() {
        if (this.mTicketService.isValidPeriodWithoutAlert()) {
            try {
                if (this.mPaymentCBController == null || this.paymentCBScene == null) {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/payment_cb.fxml"));
                    Parent rootNode = (Parent)loader.load();
                    this.mPaymentCBController = (PaymentCBController)loader.getController();
                    this.paymentCBScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                    this.paymentCBScene.getStylesheets().add((Object)"/styles/styles.css");
                    this.paymentCBScene.getStylesheets().add((Object)"/styles/app.css");
                    this.mPaymentCBController.initialize(this.m_App);
                }
                this.mPaymentCBController.setImage();
                AppLocal.ticketBorne.setModePayment("CB");
                AppLocal.START_PAYMENT_BORNE = true;
                this.m_App.getFxPanel().setScene(this.paymentCBScene);
                Platform.runLater(() -> this.mPaymentCBController.doPayementEndShowMessage(this.catalogueController));
            }
            catch (BasicException | IOException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void loadPopUpValidCode() {
        try {
            int height_popUp = AppLocal.currentCustomerLoyalty.isActif() && AppLocal.currentCustomerLoyalty.getGender() != null ? (int)(AppVarUtils.getScreenDimension().getHeight() * 0.4) : (int)(AppVarUtils.getScreenDimension().getHeight() * 0.6);
            this.mActionEventValidCode = new EventHiddenModal(){
                boolean result;

                @Override
                public void onHidden() {
                    String type;
                    boolean bipMandatory = false;
                    if (AppLocal.ticketBorne != null && AppLocal.ticketBorne.getType() != null && ((type = AppLocal.ticketBorne.getType()).equalsIgnoreCase("Sur Place") && AppLocal.BIP_ONSITE || type.equalsIgnoreCase("A Emporter") && !AppLocal.ticketBorne.isTake_away_phone() && AppLocal.BIP_TAKEAWAY || AppLocal.ticketBorne.isTake_away_phone() && AppLocal.BIP_TAKEAWAY_PHONE)) {
                        bipMandatory = true;
                    }
                    if (this.result) {
                        System.out.println("++++++++ result : " + this.result);
                        if (bipMandatory) {
                            SummaryOrdercontroller.this.loadPopUpBipper();
                        } else {
                            SummaryOrdercontroller.this.setCustomerPhone();
                        }
                    }
                    SummaryOrdercontroller.this.mLazyModalValidCode.destroyEvents();
                    SummaryOrdercontroller.this.mActionEventValidCode = null;
                    SummaryOrdercontroller.this.parent_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        SendValidCodeController mController = (SendValidCodeController)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalValidCode == null) {
                this.mLazyModalValidCode = new LazyModal(StageStyle.UNDECORATED, this.scene, this.valid_code_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.7), height_popUp));
            } else {
                this.mLazyModalValidCode.setmDimension(new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.7), height_popUp));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.parent_pane.setEffect((Effect)blur);
            this.mLazyModalValidCode.setEventHiddenModal(this.mActionEventValidCode);
            this.mLazyModalValidCode.load(true, AppLocal.currentCustomerLoyalty);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadPopUpPromoCode() {
        try {
            int height_popUp = (int)(AppVarUtils.getScreenDimension().getHeight() * 0.95);
            this.mActionEventPromoCode = new EventHiddenModal(){
                Object[] result;

                @Override
                public void onHidden() {
                    if (((Boolean)this.result[0]).booleanValue()) {
                        String source;
                        AppLocal.ticketBorne.setDiscount((Double)this.result[1]);
                        AppLocal.ticketBorne.setTypeDiscount((String)this.result[2]);
                        String code = (String)this.result[3];
                        if (AppLocal.ticketBorne.getTypeDiscount() != null && !AppLocal.ticketBorne.getTypeDiscount().equalsIgnoreCase("pourcentage") && AppLocal.ticketBorne.getDiscount() > AppLocal.ticketBorne.getRealTotal()) {
                            AppLocal.ticketBorne.setDiscount(AppLocal.ticketBorne.getRealTotal());
                        }
                        if ("biborne_lunch_app".equals(source = (String)this.result[4])) {
                            AppLocal.ticketBorne.setLabel_discount(SummaryOrdercontroller.this.label_discount_biborne_lunch + code);
                        } else {
                            AppLocal.ticketBorne.setLabel_discount(SummaryOrdercontroller.this.label_discount_code_promo + code);
                        }
                        SummaryOrdercontroller.this.loadPanier();
                    }
                    SummaryOrdercontroller.this.mLazyModalPromocode.destroyEvents();
                    SummaryOrdercontroller.this.mActionEventPromoCode = null;
                    SummaryOrdercontroller.this.parent_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        PromoCodeController mController = (PromoCodeController)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalPromocode == null) {
                this.mLazyModalPromocode = new LazyModal(StageStyle.UNDECORATED, this.scene, this.promo_code_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.95), height_popUp));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.parent_pane.setEffect((Effect)blur);
            this.mLazyModalPromocode.setEventHiddenModal(this.mActionEventPromoCode);
            this.mLazyModalPromocode.load(true, AppLocal.ticketBorne.getType());
            this.mLazyModalPromocode.getModalStage().setX(AppVarUtils.getScreenDimension().getWidth() * 0.025);
            this.mLazyModalPromocode.getModalStage().setY(AppVarUtils.getScreenDimension().getHeight() * 0.025);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setInfoOrder() {
        try {
            this.linesSoldOut.clear();
            boolean checkStock = this.mTicketService.soldOutExist(this.linesSoldOut, AppLocal.ticketBorne);
            if (checkStock) {
                Object message = "Nous somme d\u00e9sol\u00e9, ";
                for (TicketLineInfo ticketLineInfo : this.linesSoldOut) {
                    message = (String)message + ticketLineInfo.getNameProduct() + " ";
                }
                message = (String)message + "en rupture";
                this.loadPopUpMessageSoldOut((String)message);
                this.deleteSoldOut();
            } else {
                for (TicketLineInfo line : AppLocal.ticketBorne.getLines()) {
                    if (line.isNext()) continue;
                    Double ht = (line.getPrice() - line.getDiscount()) / (1.0 + line.getTaxRate());
                    line.setHtAmount(ht * line.getMultiply());
                    line.setTaxAmount((line.getPrice() - line.getDiscount() - ht) * line.getMultiply());
                }
                AppLocal.ticketBorne.setActiveCash(this.m_App.getActiveCashIndex());
                AppLocal.ticketBorne.setDate(new Date());
                AppUser user = this.m_App.login("123888", false);
                AppLocal.ticketBorne.setUser(new UserInfo(user.getId(), user.getName(), user.getCounter()));
                AppLocal.ticketBorne.setAddress(-1);
                String order_id = AppLocal.ticketBorne.getId();
                String keenio_base = this.getKeenio();
                AppLocal.ticketBorne.setKeenio_base(keenio_base);
                AppLocal.ticketBorne.setOrder_id_base(order_id);
                if (AppLocal.ADD_NAME_CUSTOMER_AFTER_ORDER_BORNE) {
                    this.loadPopUpNameClient();
                } else {
                    this.loadCheckoutPayments();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setTexts() {
        this.btn_update.setText(AppLocal.getIntString("Button.update"));
        this.button_valid.setText(AppLocal.getIntString("Button.valid"));
        this.label_total.setText(AppLocal.getIntString("Label.total"));
        this.add_promobtn.setText(AppLocal.getIntString("Text.add.promotion"));
    }

    public void loadPopUpBipper() {
        try {
            this.mActionEventBipper = new EventHiddenModal(){
                Object[] results;

                @Override
                public void onHidden() {
                    if (((Boolean)this.results[0]).booleanValue()) {
                        AppLocal.ticketBorne.setBipper((int)((Integer)this.results[1]));
                        SummaryOrdercontroller.this.setCustomerPhone();
                    }
                    SummaryOrdercontroller.this.mLazyModalBipper.destroyEvents();
                    SummaryOrdercontroller.this.mActionEventBipper = null;
                    SummaryOrdercontroller.this.parent_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        BipperBorneController mController = (BipperBorneController)mBuilder.getController();
                        this.results = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalBipper == null) {
                this.mLazyModalBipper = new LazyModal(StageStyle.UNDECORATED, this.scene, this.bipper_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.7), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.55)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.parent_pane.setEffect((Effect)blur);
            this.mLazyModalBipper.setEventHiddenModal(this.mActionEventBipper);
            this.mLazyModalBipper.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadPopUpPhoneCustomer() {
        try {
            this.mActionEventPhoneCustomer = new EventHiddenModal(){
                Object[] results;

                @Override
                public void onHidden() {
                    if (((Boolean)this.results[0]).booleanValue()) {
                        String phone = (String)this.results[1];
                        System.out.println("+++++++++++ phone : " + phone);
                        CustomerInfo mCustomerInfo = new CustomerInfo();
                        mCustomerInfo.setName("");
                        mCustomerInfo.setPhone(phone);
                        AppLocal.ticketBorne.setCustomer(mCustomerInfo);
                    }
                    SummaryOrdercontroller.this.setInfoOrder();
                    SummaryOrdercontroller.this.mLazyModalPhoneCustomer.destroyEvents();
                    SummaryOrdercontroller.this.mActionEventPhoneCustomer = null;
                    SummaryOrdercontroller.this.parent_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        PhoneCustomercontroller mController = (PhoneCustomercontroller)mBuilder.getController();
                        this.results = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalPhoneCustomer == null) {
                this.mLazyModalPhoneCustomer = new LazyModal(StageStyle.UNDECORATED, this.scene, this.phone_customer_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.7), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.4)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.parent_pane.setEffect((Effect)blur);
            this.mLazyModalPhoneCustomer.setEventHiddenModal(this.mActionEventPhoneCustomer);
            this.mLazyModalPhoneCustomer.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setCustomerPhone() {
        if (AppLocal.CALL_CUSTOMER_BY_SMS && (AppLocal.currentCustomerLoyalty == null || AppLocal.currentCustomerLoyalty.getPhone() == null || AppLocal.currentCustomerLoyalty.getPhone().isEmpty())) {
            this.loadPopUpPhoneCustomer();
        } else {
            this.setInfoOrder();
        }
    }

    private void setImagePromo() {
        if (this.imagePromo == null) {
            this.imagePromo = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/offer.png"));
        }
    }

    private String getKeenio() {
        String keenio = null;
        if (AppLocal.dlItems != null) {
            try {
                keenio = AppLocal.dlItems.getUserKeenIo();
                if (keenio == null) {
                    keenio = "-";
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
        }
        return keenio;
    }

    public void loadPopUpNameClient() {
        try {
            this.mActionEventNameClientBorne = new EventHiddenModal(){
                Object[] results;

                @Override
                public void onHidden() {
                    if (((Boolean)this.results[0]).booleanValue()) {
                        AppLocal.ticketBorne.setName_customer((String)this.results[1]);
                        SummaryOrdercontroller.this.loadCheckoutPayments();
                    }
                    SummaryOrdercontroller.this.mLazyModalNameClientBorne.destroyEvents();
                    SummaryOrdercontroller.this.mActionEventNameClientBorne = null;
                    SummaryOrdercontroller.this.main_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        AddNameClientBorne mController = (AddNameClientBorne)mBuilder.getController();
                        this.results = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalNameClientBorne == null) {
                this.mLazyModalNameClientBorne = new LazyModal(StageStyle.UNDECORATED, this.scene, this.addNameClientBorne_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.89), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.7)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.main_pane.setEffect((Effect)blur);
            this.mLazyModalNameClientBorne.setEventHiddenModal(this.mActionEventNameClientBorne);
            this.mLazyModalNameClientBorne.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadCheckoutPayments() {
        double total = NumericUtils.round(AppLocal.ticketBorne.getTotal());
        if (total == 0.0) {
            if (AppLocal.MODULE_AVOMARK && AppLocal.currentAvomarkClient != null) {
                this.validOrder();
            } else {
                this.showMessageComptoir();
            }
        } else if (AppLocal.ticketBorne.isValidCaisse(AppLocal.ticketBorne.getLines()) || AppLocal.CUSTOMER_LOYALTY && AppLocal.currentCustomerLoyalty != null && AppLocal.currentCustomerLoyalty.getUsed_points() > 0.0) {
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++ AppLocal.ticketBorne.getLines() value VALID CAISSE" + AppLocal.ticketBorne.isValidCaisse(AppLocal.ticketBorne.getLines()));
            this.paymentCounter();
        } else if (AppLocal.PAYMENT_ONLY_BY_CB) {
            this.paymentCB();
        } else if (AppLocal.PAYMENT_BORNE) {
            this.showPayment();
        } else {
            this.paymentCounter();
        }
    }

    public void validateOrder() {
        boolean condition = AppLocal.MODULE_AVOMARK && AppLocal.currentAvomarkClient != null;
        this.discount_avomark = 0.0;
        if (condition) {
            try {
                this.avomarkConfirmLoyaltyEventHandler = new EventHiddenModal(){
                    boolean canceled;
                    double avomark_discount;

                    @Override
                    public void onHidden() {
                        if (!this.canceled) {
                            System.out.println("*********use loyalty");
                            SummaryOrdercontroller.this.cashBack_used = true;
                            SummaryOrdercontroller.this.setDiscountAvomark(this.avomark_discount);
                        } else {
                            SummaryOrdercontroller.this.cashBack_used = false;
                            if (AppLocal.ticketBorne.getLabel_discount() != null && AppLocal.ticketBorne.getLabel_discount().equals(SummaryOrdercontroller.this.label_reduction_avomark)) {
                                SummaryOrdercontroller.this.setDiscountAvomark(this.avomark_discount);
                            }
                        }
                        SummaryOrdercontroller.this.avomarkConfirmLoyaltyModal.destroyEvents();
                        SummaryOrdercontroller.this.avomarkConfirmLoyaltyEventHandler = null;
                        SummaryOrdercontroller.this.main_pane.setEffect(null);
                        SummaryOrdercontroller.this.loadPanier();
                    }

                    @Override
                    public void onHidden(AppLoaderBuilder mBuilder) {
                        if (mBuilder != null && mBuilder.getController() != null) {
                            AvomarkConfirmLoyaltyController mController = (AvomarkConfirmLoyaltyController)mBuilder.getController();
                            this.canceled = mController.getLoyaltyAmountToBeUsed() == null;
                            Double loyaltyAmount = mController.getLoyaltyAmountToBeUsed();
                            this.avomark_discount = this.canceled || loyaltyAmount == null ? 0.0 : loyaltyAmount;
                            System.out.println("**************avomark_discount :" + this.avomark_discount);
                        }
                        this.onHidden();
                    }
                };
                if (this.avomarkConfirmLoyaltyModal == null) {
                    this.avomarkConfirmLoyaltyModal = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fx/templates/borne/confirm_avomark_loyalty.fxml", new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.85), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.5)));
                }
                BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
                ColorAdjust colorAdjust = new ColorAdjust();
                colorAdjust.setBrightness(-0.5);
                colorAdjust.setInput((Effect)blur);
                this.main_pane.setEffect((Effect)colorAdjust);
                this.avomarkConfirmLoyaltyModal.setEventHiddenModal(this.avomarkConfirmLoyaltyEventHandler);
                this.avomarkConfirmLoyaltyModal.load(new Object[0]);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            this.loadPanier();
        }
    }

    public void validOrder() {
        TicketService ticketService = TicketService.getInstance();
        ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
        ticketService.encaisserOrderCB(AppLocal.ticketBorne, m_aPaymentInfo, null, AppLocal.currentCustomerLoyalty);
        this.showMessage();
    }

    private void showMessage() {
        try {
            System.out.println("***messageScene" + this.messageScene);
            System.out.println("***mMessageCBController" + this.mMessageCBController);
            if (this.mMessageCBController == null || this.messageScene == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/payment_message_cb.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mMessageCBController = (MessageCBController)loader.getController();
                this.messageScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.messageScene.getStylesheets().add((Object)"/styles/styles.css");
                this.messageScene.getStylesheets().add((Object)"/styles/app.css");
                this.mMessageCBController.initialize(this.m_App);
            }
            this.mMessageCBController.loadInfoOrder();
            if (AppLocal.MODULE_AVOMARK) {
                this.mMessageCBController.setImageBackground();
            }
            this.m_App.getFxPanel().setScene(this.messageScene);
        }
        catch (BasicException | IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void createAndSendAvomarkSale() {
        String card = AppLocal.currentAvomarkClient.getCards().get(0);
        JSONObject sale = this.mAvomarkService.createSaleAvomark(AppLocal.ticketBorne);
        try {
            this.mAvomarkService.createAvomarkSale(card, sale);
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setDiscountAvomark(double avomark_discount) {
        if (this.cashBack_used) {
            this.discount_avomark = avomark_discount >= AppLocal.ticketBorne.getTotal() ? AppLocal.ticketBorne.getTotal() : avomark_discount;
            AppLocal.ticketBorne.setLabel_discount(this.label_reduction_avomark);
        } else {
            AppLocal.ticketBorne.setLabel_discount(null);
        }
        AppLocal.ticketBorne.setTypeDiscount("somme");
        AppLocal.ticketBorne.setDiscount(this.discount_avomark);
    }

    public JSONObject addDiscountInfo(TicketInfo ticket) {
        JSONObject discountJson = new JSONObject();
        discountJson.put((Object)"amount", (Object)ticket.getDiscount());
        discountJson.put((Object)"quantity", (Object)1.0);
        JSONObject operationJson = new JSONObject();
        operationJson.put((Object)"id", (Object)2);
        discountJson.put((Object)"operation", (Object)operationJson);
        return discountJson;
    }

    private void paymentCounter() {
        if (AppLocal.ADD_EASEL_NUMBER && AppLocal.ticketBorne.getType() != null && AppLocal.ticketBorne.getType().equalsIgnoreCase("Sur Place")) {
            this.loadPopUpEaselNumber("counter_payment");
        } else {
            this.showMessageComptoir();
        }
    }

    public void loadPopUpEaselNumber(final String postAction) {
        try {
            this.mActionEventEaselNumber = new EventHiddenModal(){
                Object[] results;

                @Override
                public void onHidden() {
                    if (((Boolean)this.results[0]).booleanValue()) {
                        AppLocal.ticketBorne.setEasel_number((int)((Integer)this.results[1]));
                        switch (postAction) {
                            case "cb_payment": {
                                SummaryOrdercontroller.this.showPaymentCB();
                                break;
                            }
                            case "counter_payment": {
                                SummaryOrdercontroller.this.showMessageComptoir();
                            }
                        }
                    }
                    SummaryOrdercontroller.this.mLazyModalEaselNumber.destroyEvents();
                    SummaryOrdercontroller.this.mActionEventEaselNumber = null;
                    SummaryOrdercontroller.this.main_pane.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        EaselNumberController mController = (EaselNumberController)mBuilder.getController();
                        this.results = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalEaselNumber == null) {
                this.mLazyModalEaselNumber = new LazyModal(StageStyle.UNDECORATED, this.scene, this.easel_number_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.7), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.55)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.main_pane.setEffect((Effect)blur);
            this.mLazyModalEaselNumber.setEventHiddenModal(this.mActionEventEaselNumber);
            this.mLazyModalEaselNumber.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

