/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.PaneOption;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.components.views.ButtonBoxOption;
import com.openbravo.controllers.borne.AbstractController;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.OptionItem;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import com.openbravo.service.Pair;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class SubSupplementController
extends AbstractController
implements RootController {
    private Stage stage;
    private Object[] result;
    private List<SupplementItemInfo> supplements;
    private List<OptionItemOrder> listChoiceSupplement;
    private String text_color_borne_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
    private String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    private HashMap<Integer, SoftReference> refOptions;
    private double height_popUp;
    private double width_popUp = AppVarUtils.getScreenDimension().getWidth() * 0.9;
    private double HEIGHT_VIEW;
    private double WIDTH_VIEW;
    private int parent_supplement_id;
    private List<OptionItemOrder> supplements_to_delete;
    private int page_option;
    private SupplementItemInfo parentSupplement;
    private int index_group_sub_supplement;
    private Image imageNext;
    private Image imagebPrevious;
    private int max_items;
    private boolean update_option;
    private GroupSubSupplementInfo groupSubSupplementInfo;
    private ItemService mItemService;
    private final String KEY_INDEX = "KEY_INDEX";
    private final String KEY_STEP = "KEY_STEP";
    private final String KEY_NAME_GROUP_SUB_OPTION = "KEY_NAME_GROUP_SUB_OPTION";
    private HashMap<Integer, Button> groupSubOptionButtons;
    private String parent_supplement_global_id;
    @FXML
    GridPane pane_multiple_supplement;
    @FXML
    GridPane list_g_sub_options;
    @FXML
    GridPane pane_footer;
    @FXML
    GridPane pane_parent;
    @FXML
    GridPane pane_main;
    @FXML
    Label title_group;
    @FXML
    Label info_groupe;
    @FXML
    Label label_background;
    @FXML
    Button button_next;
    @FXML
    Button button_cancel;
    @FXML
    Button button_valid;
    @FXML
    StackPane stackPane_group_sub_options;
    private Function<Pair<PaneOption, GridPane>, Integer> showAllergens;
    private Function<Pair<MouseEvent, Double>, Boolean> detectAllergensBtnClick;
    private EventHandler mEventHandlerNext = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                SubSupplementController.this.nextPageOption();
            }
        }
    };
    private EventHandler mEventHandlerPrevious = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                SubSupplementController.this.previousPageOption();
            }
        }
    };
    private EventHandler mEventHandlerIncreaseOption = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxOption mButtonSource = (ButtonBoxOption)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getOptionItem() != null && mButtonSource.getButtonOption() != null) {
                SubSupplementController.this.update_option = true;
                SubSupplementController.this.chooseOption(mButtonSource.getOptionItem(), mButtonSource.getButtonOption());
            }
        }
    };
    private EventHandler mEventHandlerDecreaseOption = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxOption mButtonSource = (ButtonBoxOption)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getOptionItem() != null && mButtonSource.getButtonOption() != null) {
                SubSupplementController.this.update_option = true;
                SubSupplementController.this.decreaseNumberOption(mButtonSource.getOptionItem(), mButtonSource.getButtonOption());
            }
        }
    };
    private EventHandler mEventHandlerGroupeSubOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                try {
                    if (SubSupplementController.this.checkGroupSubOption()) {
                        int index;
                        SubSupplementController.this.index_group_sub_supplement = index = ((Integer)mButtonSource.getProperties().get((Object)"KEY_INDEX")).intValue();
                        if (SubSupplementController.this.index_group_sub_supplement < SubSupplementController.this.parentSupplement.getGroupsSubSupplement().size()) {
                            SubSupplementController.this.loadPaneSubSupplement(SubSupplementController.this.parentSupplement.getGroupsSubSupplement().get(SubSupplementController.this.index_group_sub_supplement));
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    };

    public Object[] getResult() {
        return this.result;
    }

    private void loadPaneSubSupplement(GroupSubSupplementInfo groupSubSupplementInfo) {
        this.deselectBtnGroupSubOption();
        groupSubSupplementInfo.setOption_free_tmp(0);
        this.selectButton(this.groupSubOptionButtons.get(groupSubSupplementInfo.getId()));
        this.groupSubSupplementInfo = groupSubSupplementInfo;
        this.showFooterButtons(groupSubSupplementInfo);
        this.info_groupe.setText(this.mItemService.getInfoGroupSupplement(groupSubSupplementInfo));
        this.title_group.setText(groupSubSupplementInfo.getDisplayedTitle().toUpperCase());
        this.pane_multiple_supplement.getChildren().clear();
        this.buttonItems.clear();
        int size = groupSubSupplementInfo.getSupplements().size();
        double perecent_width_image = 0.7;
        if (size <= 4) {
            perecent_width_image = 0.6;
            this.MAX_LINE_OPTION = 2;
            this.MAX_COLUMN_OPTION = 2;
        } else if (size <= 6) {
            this.MAX_LINE_OPTION = 2;
            this.MAX_COLUMN_OPTION = 3;
        } else if (size <= 9) {
            this.MAX_LINE_OPTION = 3;
            this.MAX_COLUMN_OPTION = 3;
        } else if (size <= 12) {
            this.MAX_LINE_OPTION = 4;
            this.MAX_COLUMN_OPTION = 4;
        } else {
            this.MAX_LINE_OPTION = 4;
            this.MAX_COLUMN_OPTION = 5;
        }
        int index = 0;
        double width_option = this.WIDTH_VIEW / (double)this.MAX_COLUMN_OPTION;
        double height_option = this.HEIGHT_VIEW / (double)this.MAX_LINE_OPTION;
        boolean add_switch_button = groupSubSupplementInfo.getSupplements().size() > this.max_items;
        boolean add_previous_button = false;
        boolean add_next_button = false;
        for (SupplementItemInfo supplement : groupSubSupplementInfo.getSupplements()) {
            boolean bl = add_previous_button = index != 0 && this.buttonItems.size() % this.max_items == 0;
            if (add_switch_button && add_previous_button) {
                if (this.imagebPrevious == null) {
                    this.imagebPrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/arrowLeft.png"));
                }
                Button button_previous = new Button();
                button_previous.setPrefHeight(height_option);
                button_previous.setPrefWidth(width_option);
                button_previous.getStyleClass().add((Object)"bg_transparent");
                button_previous.setOnAction(this.mEventHandlerPrevious);
                this.setImage(button_previous, this.imagebPrevious, height_option, width_option);
                this.buttonItems.add(button_previous);
            }
            OptionItem mOptionItem = new OptionItem(supplement, this.refOptions);
            PaneOption btnItemOption = new PaneOption().option(supplement).optionItem(mOptionItem).heightPane(height_option).widthPane(width_option).sub_supplement(true).perecent_width_image(perecent_width_image).buildOption();
            if (btnItemOption.getProperties().get((Object)"increaseQtt") != null) {
                Button increaseQtt = (Button)btnItemOption.getProperties().get((Object)"increaseQtt");
                increaseQtt.setOnAction(this.mEventHandlerIncreaseOption);
            }
            if (btnItemOption.getProperties().get((Object)"decreaseQtt") != null) {
                Button decreaseQtt = (Button)btnItemOption.getProperties().get((Object)"decreaseQtt");
                decreaseQtt.setOnAction(this.mEventHandlerDecreaseOption);
            }
            btnItemOption.getProperties().put((Object)"name", (Object)supplement.getDisplayedName().toUpperCase());
            OptionItemOrder item = this.existOption(supplement);
            int quantity = 0;
            if (item == null) {
                this.deselectOption(btnItemOption);
                btnItemOption.getProperties().put((Object)"price", (Object)supplement.getPrice_order());
            } else {
                quantity = item.getNumberOption();
                btnItemOption.getProperties().put((Object)"price", (Object)item.getPrice());
                this.selectOption(btnItemOption, false);
            }
            btnItemOption.getProperties().put((Object)"quantity", (Object)quantity);
            btnItemOption.setOnMouseClicked(event -> this.clickSubSupplement((MouseEvent)event, width_option));
            this.buttonItems.add(btnItemOption);
            boolean bl2 = add_next_button = index != groupSubSupplementInfo.getSupplements().size() - 1 && (this.buttonItems.size() + 1) % this.max_items == 0;
            if (add_switch_button && add_next_button) {
                if (this.imageNext == null) {
                    this.imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/arrowRight.png"));
                }
                Button button_next = new Button();
                button_next.setPrefHeight(height_option);
                button_next.setPrefWidth(width_option);
                button_next.getStyleClass().add((Object)"bg_transparent");
                button_next.setOnAction(this.mEventHandlerNext);
                this.setImage(button_next, this.imageNext, height_option, width_option);
                this.buttonItems.add(button_next);
            }
            ++index;
        }
        this.reloadPriceOptions(this.isOptionFreeable(groupSubSupplementInfo));
        this.showItems(this.buttonItems, height_option, width_option);
    }

    private void initializer() {
        this.WIDTH_VIEW = this.width_popUp * 0.9;
        this.index_group_sub_supplement = 0;
        this.parent_supplement_id = this.parentSupplement.getiD();
        this.parent_supplement_global_id = this.parentSupplement.getId_global();
        this.supplements_to_delete = new ArrayList<OptionItemOrder>();
        this.result = new Object[3];
        this.result[0] = null;
        this.result[1] = false;
        this.result[2] = this.supplements_to_delete;
        this.color_backgound = "#FFFFFF";
        this.max_items = 20;
        this.buttonItems = new ArrayList();
        this.mItemService = ItemService.getInstance();
        this.label_background.setStyle("-fx-background-color: " + this.color_hex + ";");
        this.groupSubOptionButtons = new HashMap();
        this.pane_parent.getChildren().clear();
        if (this.parentSupplement.getGroupsSubSupplement() == null || this.parentSupplement.getGroupsSubSupplement().size() == 1) {
            this.height_popUp = AppVarUtils.getScreenDimension().getHeight() * 0.7;
            this.pane_main.setPrefHeight(this.height_popUp);
            this.pane_parent.add((Node)this.pane_main, 0, 0);
        } else {
            this.height_popUp = AppVarUtils.getScreenDimension().getHeight() * 0.8;
            this.pane_main.setPrefHeight(this.height_popUp * 0.92);
            this.pane_parent.add((Node)this.stackPane_group_sub_options, 0, 0);
            this.pane_parent.add((Node)this.pane_main, 0, 1);
            this.addGroupeSubOptions(this.parentSupplement.getGroupsSubSupplement(), this.WIDTH_VIEW / 6.0);
        }
        this.HEIGHT_VIEW = this.pane_main.getPrefHeight() * 0.62;
        this.loadPaneSubSupplement(this.parentSupplement.getGroupsSubSupplement().get(this.index_group_sub_supplement));
        this.setTexts();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.supplements = (List)object;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        if (objects != null) {
            this.parentSupplement = (SupplementItemInfo)objects[0];
            this.refOptions = (HashMap)objects[1];
            this.listChoiceSupplement = (List)objects[2];
            this.showAllergens = (Function)objects[3];
            this.detectAllergensBtnClick = (Function)objects[4];
        }
        this.initializer();
    }

    public void checkAndValid() {
        if (this.groupSubSupplementInfo.isHas_limit_options()) {
            boolean validMin = true;
            boolean validMax = true;
            int min_option = 0;
            int number = this.sizeOptions(this.groupSubSupplementInfo);
            if (number < (min_option = this.groupSubSupplementInfo.getMin_options())) {
                validMin = false;
            }
            if (number > this.groupSubSupplementInfo.getMax_options()) {
                validMax = false;
            }
            if (validMin && validMax) {
                this.valid();
            } else if (!validMin) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "merci de s\u00e9lectionner le nombre minimum " + min_option + " des options.", 1500, NPosition.TOP_RIGHT);
            }
        } else {
            this.valid();
        }
    }

    public void valid() {
        ++this.index_group_sub_supplement;
        if (this.index_group_sub_supplement < this.parentSupplement.getGroupsSubSupplement().size()) {
            this.loadPaneSubSupplement(this.parentSupplement.getGroupsSubSupplement().get(this.index_group_sub_supplement));
        } else {
            this.result[0] = this.listChoiceSupplement;
            this.result[1] = true;
            this.result[2] = this.supplements_to_delete;
            this.stage.close();
        }
    }

    private void clickSubSupplement(MouseEvent event, double widthOption) {
        PaneOption paneOption = (PaneOption)((Object)event.getSource());
        if (paneOption == null) {
            return;
        }
        boolean hasAllergens = paneOption.getProperties().get((Object)"allergens") != null;
        boolean allergensBtnClicked = false;
        if (hasAllergens) {
            allergensBtnClicked = this.detectAllergensBtnClick.apply(Pair.create(event, widthOption));
        }
        if (allergensBtnClicked) {
            this.showAllergens.apply(Pair.create(paneOption, this.pane_parent));
        } else if (paneOption.getOptionItem() != null) {
            if (!this.update_option) {
                SupplementItemInfo option = (SupplementItemInfo)paneOption.getOptionItem().clone();
                this.chooseOption(option, paneOption);
            }
            this.update_option = false;
        }
    }

    private void chooseOption(SupplementItemInfo option, Button button_option) {
        OptionItemOrder exist_option = this.existOption(option);
        int number_free = 0;
        boolean free = false;
        System.out.println("+++++++++++ option.getPrice_order() : " + option.getPrice_order());
        if (exist_option == null) {
            if (this.isOptionFreeable(this.groupSubSupplementInfo) && option.getPrice_order() > 0.0) {
                option.setPrice_order(0.0);
                this.decrementOptionFree(this.groupSubSupplementInfo, 1);
                button_option.getProperties().replace((Object)"price", (Object)0.0);
                number_free = 1;
                free = true;
            }
            this.listChoiceSupplement.add(new OptionItemOrder(-1, -1, null, null, 1, -1, number_free, option, this.parent_supplement_id, this.groupSubSupplementInfo.getId(), null, null, null, null, this.parent_supplement_global_id));
            Object name = option.getDisplayedName().toUpperCase();
            if (free) {
                name = (String)name + "\n Offert";
            }
            button_option.getProperties().replace((Object)"name", name);
            button_option.getProperties().replace((Object)"quantity", (Object)1);
            if (option.getPrice_order() != 0.0) {
                name = (String)name + "\n" + Formats.CURRENCY.formatValue(option.getPrice_order());
            }
            this.selectOption(button_option, false);
            this.setDisableButtonValid();
            if (this.listChoiceSupplement.size() > 0 && this.groupSubSupplementInfo.isHas_limit_options() && this.groupSubSupplementInfo.getMax_options() == this.sizeOptions(this.groupSubSupplementInfo)) {
                this.checkAndValid();
            } else {
                this.reloadPriceOptions(this.isOptionFreeable(this.groupSubSupplementInfo));
            }
        } else if (exist_option.getNumberOption() < this.groupSubSupplementInfo.getNumber_click()) {
            int numberFree = exist_option.getNumber_free();
            if (this.isOptionFreeable(this.groupSubSupplementInfo) && option.getPrice_order() > 0.0) {
                exist_option.setNumber_free(++numberFree);
                this.decrementOptionFree(this.groupSubSupplementInfo, 1);
                free = true;
            }
            exist_option.setNumberOption(exist_option.getNumberOption() + 1);
            double price = option.getPrice_order() * (double)(exist_option.getNumberOption() - numberFree);
            exist_option.setPrice(option.getPrice_order(), exist_option.getNumberOption() - numberFree);
            button_option.getProperties().replace((Object)"price", (Object)price);
            Object name = option.getDisplayedName().toUpperCase();
            if (free) {
                name = (String)name + "\n Offert";
            }
            button_option.getProperties().replace((Object)"name", name);
            button_option.getProperties().replace((Object)"quantity", (Object)exist_option.getNumberOption());
            this.setDisableButtonValid();
            if (this.listChoiceSupplement.size() > 0 && this.groupSubSupplementInfo.isHas_limit_options() && this.groupSubSupplementInfo.getMax_options() == this.sizeOptions(this.groupSubSupplementInfo)) {
                this.checkAndValid();
            } else {
                this.reloadPriceOptions(this.isOptionFreeable(this.groupSubSupplementInfo));
            }
        }
    }

    private OptionItemOrder existOption(SupplementItemInfo option) {
        OptionItemOrder option_order = null;
        for (OptionItemOrder chosen_option : this.listChoiceSupplement) {
            if (option.getiD() != chosen_option.getSupplement()) continue;
            option_order = chosen_option;
            break;
        }
        return option_order;
    }

    private void showItems(List<Button> items, double height_button, double width_button) {
        this.rangeSubOption(items, height_button, width_button, this.HEIGHT_VIEW, this.WIDTH_VIEW);
        this.pane_multiple_supplement.getChildren().clear();
        if (this.number_page_item > 0) {
            this.page_option = 0;
            this.pane_multiple_supplement.add((Node)this.pane_items[this.page_option], 0, 0);
        }
    }

    public void previousPageOption() {
        if (this.page_option > 0) {
            --this.page_option;
            this.pane_multiple_supplement.getChildren().clear();
            this.pane_multiple_supplement.add((Node)this.pane_items[this.page_option], 0, 0);
        }
    }

    public void nextPageOption() {
        if (this.page_option < this.number_page_item - 1) {
            ++this.page_option;
            this.pane_multiple_supplement.getChildren().clear();
            this.pane_multiple_supplement.add((Node)this.pane_items[this.page_option], 0, 0);
        }
    }

    public void next() {
        this.checkAndValid();
    }

    private void decreaseNumberOption(SupplementItemInfo option, Button button_option) {
        OptionItemOrder exist_option = this.existOption(option);
        if (exist_option.getNumberOption() == 1) {
            this.deleteOption(option, button_option);
        } else {
            int number_free = exist_option.getNumber_free();
            exist_option.setNumberOption(exist_option.getNumberOption() - 1);
            if (number_free > 0) {
                this.incrementOptionFree(this.groupSubSupplementInfo, 1);
                exist_option.setNumber_free(--number_free);
                try {
                    this.calculFreeAfterDelete(this.groupSubSupplementInfo);
                }
                catch (Exception ex) {
                    LogToFile.log("sever", ex.getMessage(), ex);
                }
            }
            double price = option.getPrice_order() * (double)(exist_option.getNumberOption() - exist_option.getNumber_free());
            exist_option.setPrice(option.getPrice_order(), exist_option.getNumberOption() - exist_option.getNumber_free());
            button_option.getProperties().replace((Object)"price", (Object)price);
            Object name = option.getDisplayedName().toUpperCase();
            if (price == 0.0 && exist_option.getNumber_free() > 0) {
                name = (String)name + "\n Offert";
            }
            button_option.getProperties().replace((Object)"name", name);
            button_option.getProperties().replace((Object)"quantity", (Object)exist_option.getNumberOption());
            this.reloadPriceOptions(this.isOptionFreeable(this.groupSubSupplementInfo));
        }
        this.setDisableButtonValid();
    }

    private void deleteOption(SupplementItemInfo option, Button button_option) {
        OptionItemOrder old_option = this.existOption(option);
        this.supplements_to_delete.add((OptionItemOrder)old_option.clone());
        if (old_option.getNumber_free() > 0) {
            int number_free_to_recuperate = old_option.getNumber_free();
            this.incrementOptionFree(this.groupSubSupplementInfo, number_free_to_recuperate);
            this.listChoiceSupplement.remove(old_option);
            try {
                this.calculFreeAfterDelete(this.groupSubSupplementInfo);
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        } else {
            this.listChoiceSupplement.remove(old_option);
        }
        button_option.getProperties().replace((Object)"price", (Object)option.getPrice_order());
        String name = option.getDisplayedName().toUpperCase();
        button_option.getProperties().replace((Object)"name", (Object)name);
        this.deselectOption(button_option);
        this.reloadPriceOptions(this.isOptionFreeable(this.groupSubSupplementInfo));
    }

    private int sizeOptions(GroupSubSupplementInfo mGroupSubSupplementInfo) {
        int size = 0;
        try {
            System.out.println("++++++++ listChoiceSupplement size : " + this.listChoiceSupplement.size());
            for (OptionItemOrder optionItem : this.listChoiceSupplement) {
                for (SupplementItemInfo supplement : mGroupSubSupplementInfo.getSupplements()) {
                    if (optionItem.getSupplement() != supplement.getiD()) continue;
                    size += optionItem.getNumberOption();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return size;
    }

    private boolean isOptionFreeable(GroupSubSupplementInfo groupSubSupplementInfo) {
        System.out.println("groupSubSupplementInfo.getOption_free() : " + groupSubSupplementInfo.getOption_free());
        System.out.println("groupSubSupplementInfo.getOption_free_tmp() : " + groupSubSupplementInfo.getOption_free_tmp());
        return groupSubSupplementInfo.getOption_free() > groupSubSupplementInfo.getOption_free_tmp();
    }

    private void decrementOptionFree(GroupSubSupplementInfo groupSubSupplementInfo, int number_free) {
        groupSubSupplementInfo.setOption_free_tmp(groupSubSupplementInfo.getOption_free_tmp() + number_free);
    }

    private void incrementOptionFree(GroupSubSupplementInfo groupSubSupplementInfo, int number_free) {
        groupSubSupplementInfo.setOption_free_tmp(groupSubSupplementInfo.getOption_free_tmp() - number_free);
    }

    private void calculFreeAfterDelete(GroupSubSupplementInfo groupSubSupplementInfo) throws BasicException {
        if (this.isOptionFreeable(groupSubSupplementInfo)) {
            for (OptionItemOrder supplement : this.listChoiceSupplement) {
                if (!this.isOptionFreeable(groupSubSupplementInfo) || supplement.getGroupSubSupplementInfo_ID() != groupSubSupplementInfo.getId() || supplement.getNumber_free() >= supplement.getNumberOption() || !(supplement.getPrice() > 0.0)) continue;
                int free_possible = groupSubSupplementInfo.getOption_free() - groupSubSupplementInfo.getOption_free_tmp();
                int free = free_possible > supplement.getNumberOption() - supplement.getNumber_free() ? supplement.getNumberOption() - supplement.getNumber_free() : free_possible;
                double price_option = supplement.getPrice() - supplement.getPrice() / (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setNumber_free(supplement.getNumber_free() + free);
                double price = price_option * (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setPrice(price_option, supplement.getNumberOption() - supplement.getNumber_free());
                this.decrementOptionFree(groupSubSupplementInfo, free);
            }
        }
    }

    private void createPaneGroupSubOption(Button btnGroup, String name_groupe, int step) {
        GridPane paneName = new GridPane();
        paneName.setAlignment(Pos.CENTER);
        paneName.setPrefHeight(btnGroup.getPrefHeight());
        paneName.setPrefWidth(btnGroup.getPrefWidth());
        GridPane paneStep = new GridPane();
        paneStep.setAlignment(Pos.CENTER);
        Label label_step = new Label();
        label_step.setText(String.valueOf(step));
        label_step.setAlignment(Pos.CENTER);
        paneStep.setPrefHeight(paneName.getPrefHeight() * 0.5);
        paneStep.setPrefWidth(paneName.getPrefWidth() * 0.5);
        label_step.setPrefHeight(paneStep.getPrefHeight());
        label_step.setPrefWidth(paneStep.getPrefHeight());
        label_step.setStyle("-fx-background-color : " + this.color_hex + ";");
        paneStep.add((Node)label_step, 0, 0);
        Label name_groupe_option = new Label();
        name_groupe_option.setWrapText(true);
        name_groupe_option.setText(name_groupe.toUpperCase());
        name_groupe_option.setStyle("-fx-font-family : " + AppLocal.FONT_FAMILY_OPTIONS + ";");
        name_groupe_option.setAlignment(Pos.CENTER);
        name_groupe_option.setPrefHeight(paneName.getPrefHeight() * 0.4);
        name_groupe_option.setPrefWidth(paneName.getPrefWidth());
        paneName.add((Node)paneStep, 0, 0);
        paneName.add((Node)name_groupe_option, 0, 1);
        btnGroup.getProperties().put((Object)"KEY_STEP", (Object)label_step);
        btnGroup.getProperties().put((Object)"KEY_NAME_GROUP_SUB_OPTION", (Object)name_groupe_option);
        btnGroup.setStyle("-fx-background-color : transparent;");
        btnGroup.setGraphic((Node)paneName);
    }

    private void addGroupeSubOptions(List<GroupSubSupplementInfo> groupsSubOptions, double width) {
        double height = this.height_popUp * 0.08;
        int step = 1;
        int indexGroupe = 0;
        int column = 0;
        for (GroupSubSupplementInfo groupSubOption : groupsSubOptions) {
            Button btnGroupSuboption = new Button();
            btnGroupSuboption.setPrefHeight(height);
            btnGroupSuboption.setPrefWidth(width);
            try {
                this.createPaneGroupSubOption(btnGroupSuboption, groupSubOption.getName_group(), step);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            this.groupSubOptionButtons.put(groupSubOption.getId(), btnGroupSuboption);
            btnGroupSuboption.getProperties().put((Object)"KEY_INDEX", (Object)indexGroupe);
            btnGroupSuboption.setOnAction(this.mEventHandlerGroupeSubOptionAction);
            this.list_g_sub_options.add((Node)btnGroupSuboption, column++, 0);
            ++indexGroupe;
            ++step;
        }
    }

    private void setTexts() {
        this.button_cancel.setText(AppLocal.getIntString("Button.cancel"));
        this.button_valid.setText(AppLocal.getIntString("Button.valid"));
        this.button_next.setText(AppLocal.getIntString("Button.no.thanks"));
    }

    private boolean checkGroupSubOption() {
        if (this.groupSubSupplementInfo.isHas_limit_options()) {
            boolean validMin = true;
            boolean validMax = true;
            int min_option = 0;
            int number = this.sizeOptions(this.groupSubSupplementInfo);
            if (number < (min_option = this.groupSubSupplementInfo.getMin_options())) {
                validMin = false;
            }
            if (number > this.groupSubSupplementInfo.getMax_options()) {
                validMax = false;
            }
            return validMin && validMax;
        }
        return true;
    }

    private void showFooterButtons(GroupSubSupplementInfo groupSubSupplementInfo) {
        this.pane_footer.getChildren().clear();
        this.pane_footer.add((Node)this.button_cancel, 0, 0);
        if (!(groupSubSupplementInfo.isHas_limit_options() && groupSubSupplementInfo.getMin_options() > 0 || this.sizeOptions(groupSubSupplementInfo) != 0)) {
            this.pane_footer.add((Node)this.button_next, 1, 0);
        } else {
            boolean disable = !this.checkGroupSubOption();
            this.button_valid.setDisable(disable);
            this.pane_footer.add((Node)this.button_valid, 1, 0);
        }
    }

    private void deselectBtnGroupSubOption() {
        for (Button btnGOption : this.groupSubOptionButtons.values()) {
            this.deselectButton(btnGOption);
        }
    }

    private void deselectButton(Button btn) {
        if (btn != null) {
            if (btn.getProperties().get((Object)"KEY_STEP") != null) {
                ((Label)btn.getProperties().get((Object)"KEY_STEP")).setStyle("-fx-text-fill: white; -fx-background-color :  " + this.color_hex + ";");
            }
            if (btn.getProperties().get((Object)"KEY_NAME_GROUP_SUB_OPTION") != null) {
                ((Label)btn.getProperties().get((Object)"KEY_NAME_GROUP_SUB_OPTION")).setStyle("-fx-text-fill: " + this.color_hex + ";");
            }
        }
    }

    private void selectButton(Button btn) {
        if (btn != null) {
            if (btn.getProperties().get((Object)"KEY_STEP") != null) {
                ((Label)btn.getProperties().get((Object)"KEY_STEP")).setStyle("-fx-text-fill: black; -fx-background-color :  " + this.color_hex + ";");
            }
            if (btn.getProperties().get((Object)"KEY_NAME_GROUP_SUB_OPTION") != null) {
                ((Label)btn.getProperties().get((Object)"KEY_NAME_GROUP_SUB_OPTION")).setStyle("-fx-text-fill: black;");
            }
        }
    }

    public void cancel() {
        this.result[1] = false;
        this.stage.close();
    }

    private void setDisableButtonValid() {
        if (!this.groupSubSupplementInfo.isHas_limit_options() || this.groupSubSupplementInfo.getMin_options() <= 0) {
            int number = this.sizeOptions(this.groupSubSupplementInfo);
            this.pane_footer.getChildren().clear();
            if (number > 0) {
                this.pane_footer.add((Node)this.button_cancel, 0, 0);
                this.pane_footer.add((Node)this.button_valid, 1, 0);
            } else {
                this.pane_footer.add((Node)this.button_cancel, 0, 0);
                this.pane_footer.add((Node)this.button_next, 1, 0);
            }
        }
        boolean disable = !this.checkGroupSubOption();
        this.button_valid.setDisable(disable);
    }
}

