/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.PanePromotionProduct;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.components.views.ButtonBoxAdditional;
import com.openbravo.controllers.borne.AbstractController;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.PromotionInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import fr.protactile.procaisse.dao.entities.TagInfo;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;

public class PromotionProductsController
extends AbstractController
implements RootController {
    private Stage stage;
    private Object[] result;
    private String text_color_borne_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
    private String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    private double height_popUp;
    private double width_popUp;
    private List<ItemOrderInfo> listChoiceIngredient;
    private List<OptionItemOrder> listChoiceSupplement;
    private List<ProductTicket> listProducts;
    private double WIDTH_VIEW;
    private double HEIGHT_VIEW;
    private int page_items;
    private List<Double> image_height;
    private List<Double> image_width;
    private int MAX_LINE;
    private int MAX_COLUMN;
    private List<ProductInfoExt> items;
    private double height_paneProduct;
    private double width_paneProduct;
    private HashMap<Integer, ImageView> imagesViewProducts;
    private int number_page_items;
    private GridPane[] panes_items;
    @FXML
    GridPane pane_preview;
    @FXML
    Button btn_previous;
    @FXML
    GridPane list_items;
    @FXML
    GridPane pane_next;
    @FXML
    Button btn_next;
    @FXML
    Label title;
    @FXML
    Button btn_cancel;
    @FXML
    Label label_background;
    @FXML
    ImageView image_background;
    @FXML
    ImageView image_background_gift;
    @FXML
    Label description;
    @FXML
    ImageView image_logo;
    @FXML
    GridPane pane_parent;
    List<Node> paneItems;
    private double percent_height = 1.0;
    private double percent_width = 1.0;
    private int size_text;
    private ItemService mItemService;
    private int selected_items;
    private int buttons_of_line;
    private double max_lines;
    private int max_products;
    private int index_product;
    private final String SIZE_IMAGE_128 = "_128px";
    private TagInfo mTagInfo;
    protected HashMap<Integer, SoftReference> refTags;
    private int current_hour;
    private int size;
    private PromotionInfo promotion;
    private String image_background_promotion = "/com/openbravo/images/background_promotion.png";
    private String image_background_promotion_gift = "/com/openbravo/images/background_promotion_gif.gif";
    private EventHandler mEventHandlerItemAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxAdditional mButtonSource = (ButtonBoxAdditional)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getmProductInfoExt() != null) {
                try {
                    PromotionProductsController.this.chooseItem(mButtonSource.getmProductInfoExt());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    };
    private EventHandler mEventHandlerNextProducts = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                PromotionProductsController.this.nextPageItems();
            }
        }
    };
    private EventHandler mEventHandlerPreviousItems = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                PromotionProductsController.this.lastPaneItems();
            }
        }
    };

    public Object[] getResult() {
        return this.result;
    }

    private void initializer() throws URISyntaxException, BasicException {
        this.width_popUp = AppVarUtils.getScreenDimension().getWidth() * 0.95;
        this.height_popUp = AppVarUtils.getScreenDimension().getHeight() * 0.95;
        this.setImageBackground();
        this.setImageBackgroundGift();
        this.setImageLogo();
        this.listChoiceIngredient = new ArrayList<ItemOrderInfo>();
        this.listChoiceSupplement = new ArrayList<OptionItemOrder>();
        this.listProducts = new ArrayList<ProductTicket>();
        this.m_FilerUtils = FilerUtils.getInstance();
        this.result = new Object[2];
        this.result[0] = false;
        this.result[1] = null;
        this.imagesViewProducts = new HashMap();
        this.paneItems = new ArrayList<Node>();
        this.image_height = new ArrayList<Double>();
        this.image_width = new ArrayList<Double>();
        Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/down_arrow.gif").toURI().toString(), 40.0, 30.0, false, false);
        Image imagebPrevious = new Image(this.getClass().getResource("/com/openbravo/images/up_arrow.gif").toURI().toString(), 40.0, 30.0, false, false);
        this.color_backgound = "#FFFFFF";
        this.MAX_LINE = AppLocal.type_borne.equals("horizontal") ? 2 : 3;
        this.MAX_COLUMN = 3;
        super.init();
        this.title.setText(this.promotion.getDisplayedName().toUpperCase());
        this.description.setText(this.promotion.getDisplayedDescription());
        this.title.setTextAlignment(TextAlignment.CENTER);
        this.size = 0;
        this.current_hour = new Date().getHours();
        for (ProductInfoExt product : this.items) {
            if (product.isHas_display_time() && (this.current_hour < product.getFirst_period() || this.current_hour >= product.getEnd_period())) continue;
            ++this.size;
        }
        if (this.size == 1) {
            this.MAX_LINE = 1;
            this.MAX_COLUMN = 1;
            this.percent_height = 0.8;
            this.percent_width = 0.8;
            this.size_text = 20;
        } else if (this.size <= 4) {
            this.MAX_LINE = 2;
            this.MAX_COLUMN = 2;
            this.size_text = 18;
        } else {
            this.MAX_LINE = 4;
            this.MAX_COLUMN = 3;
            this.size_text = this.size <= 6 ? 14 : 12;
        }
        this.WIDTH_VIEW = this.width_popUp * 0.9;
        this.HEIGHT_VIEW = this.height_popUp * 0.8 * 0.97 * 0.95;
        this.mItemService = ItemService.getInstance();
        this.loadItems();
        this.pane_parent.setStyle("-fx-background-color : " + this.color_hex + ";");
        this.setTexts();
    }

    @Override
    public void init(Stage mStage) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void init(Stage mStage, Object object) {
        try {
            this.stage = mStage;
            if (object != null) {
                this.promotion = (PromotionInfo)object;
                this.items = this.promotion != null ? this.promotion.getProducts() : null;
            }
            this.initializer();
        }
        catch (BasicException | URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        try {
            this.stage = mStage;
            if (objects != null) {
                this.promotion = (PromotionInfo)objects[0];
                this.items = this.promotion != null ? this.promotion.getProducts() : null;
                this.dlSales = (DataLogicSales)objects[1];
                this.dlItems = (DataLogicItems)objects[2];
                this.refProducts = (HashMap)objects[3];
                this.mTagInfo = (TagInfo)objects[4];
                this.refTags = (HashMap)objects[5];
            }
            this.initializer();
        }
        catch (BasicException | URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void valider() {
        if (this.size == 1 && this.selected_items != 0) {
            try {
                ProductInfoExt product = (ProductInfoExt)this.items.get(0).clone();
                this.result[1] = product;
                this.loadInfoProduct(product, false, this.listChoiceSupplement);
                this.result[0] = true;
                this.stage.close();
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            this.result[0] = false;
            this.stage.close();
        }
    }

    public void loadItems() throws BasicException {
        Pos postion_price = (Pos)this.price_positions.get(this.price_position);
        this.paneItems.clear();
        this.width_paneProduct = this.WIDTH_VIEW / (double)this.MAX_COLUMN;
        this.height_paneProduct = this.HEIGHT_VIEW / (double)this.MAX_LINE;
        this.image_height.clear();
        this.image_width.clear();
        this.imagesViewProducts.clear();
        this.width_paneProduct *= this.percent_width;
        this.height_paneProduct *= this.percent_height;
        this.loadImagesProducts(this.items);
        double height_items = this.HEIGHT_VIEW;
        this.buttons_of_line = (int)(this.WIDTH_VIEW / this.width_paneProduct);
        this.buttons_of_line = this.buttons_of_line > this.MAX_COLUMN ? this.MAX_COLUMN : this.buttons_of_line;
        this.max_lines = (int)Math.round(height_items / this.height_paneProduct);
        this.max_products = (int)this.max_lines * this.buttons_of_line;
        this.index_product = 0;
        if (this.size == 2) {
            Label first_label = new Label();
            first_label.setPrefHeight(this.height_paneProduct);
            first_label.setPrefWidth(this.width_paneProduct);
            this.paneItems.add((Node)first_label);
        }
        this.selected_items = 0;
        int number_products = this.size;
        boolean add_switch_button = number_products > this.max_products;
        for (ProductInfoExt product : this.items) {
            PanePromotionProduct paneProduct;
            if (product.isHas_display_time() && (this.current_hour < product.getFirst_period() || this.current_hour >= product.getEnd_period())) continue;
            if (product.isMany_size() && (product.getListSizes() == null || product.getListSizes().isEmpty())) {
                product.setListSizes(this.dlItems.getProductSizes(product.getID(), true));
                this.mItemService.setSizes(product);
            }
            if (product.getPrices() == null || product.getPrices().isEmpty()) {
                product.setPrices(this.mItemService.getProductPrices(product.getID(), true));
            }
            this.addPreviousButton(add_switch_button, this.height_paneProduct, this.width_paneProduct);
            ImageView imageProduct = this.imagesViewProducts.get(product.getID()) != null ? this.imagesViewProducts.get(product.getID()) : null;
            this.mItemService.setPriceOfFirstSize(product, AppLocal.ticketBorne.getType());
            Image imageTag = null;
            if (product.getmTagInfo() != null && this.mTagInfo != null && !Objects.equals(this.mTagInfo.getId(), product.getmTagInfo().getId())) {
                imageTag = this.getImageTag(product.getmTagInfo(), this.refTags);
            }
            if ((paneProduct = new PanePromotionProduct().product(product).height_product(this.height_paneProduct).width_product(this.width_paneProduct).price_position(postion_price).image_product(imageProduct).image_tag(imageTag).build()).getProperties().get((Object)"button") != null) {
                ((Button)paneProduct.getProperties().get((Object)"button")).setOnAction(this.mEventHandlerItemAction);
            }
            this.paneItems.add((Node)paneProduct);
            this.addNextButton(add_switch_button, this.height_paneProduct, this.width_paneProduct, number_products);
            ++this.index_product;
        }
        if (this.size == 2) {
            Label last_label = new Label();
            last_label.setPrefHeight(this.height_paneProduct);
            last_label.setPrefWidth(this.width_paneProduct);
            this.paneItems.add((Node)last_label);
        }
        this.showItems();
    }

    public void cancel() {
        this.stage.close();
    }

    public void chooseItem(ProductInfoExt product) throws BasicException, URISyntaxException {
        ProductInfoExt chosen_product = (ProductInfoExt)product.clone();
        this.result[0] = true;
        this.result[1] = chosen_product;
        this.stage.close();
    }

    private double getMinHeightAdditionnal() {
        return this.HEIGHT_VIEW / (double)this.MAX_LINE;
    }

    private void loadImagesProducts(List<ProductInfoExt> products) {
        double percent_height_image = AppLocal.HIDE_NAME_PRODUCTS ? 0.6 : 0.5;
        double heightImage = this.height_paneProduct * percent_height_image;
        double widthImage = this.width_paneProduct;
        for (ProductInfoExt product : products) {
            Image imageProduct = this.getImageProduct(product, "_512px");
            ImageView imageView = new ImageView();
            imageView.setImage(imageProduct);
            if (!AppLocal.type_borne.equals("horizontal")) {
                imageView.setFitHeight(heightImage);
            } else {
                imageView.setFitWidth(widthImage);
            }
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
            imageView.setCache(true);
            this.image_height.add(imageView.getBoundsInLocal().getHeight());
            this.image_width.add(imageView.getBoundsInLocal().getWidth());
            this.imagesViewProducts.put(product.getID(), imageView);
        }
        if (AppLocal.type_borne != null) {
            if (AppLocal.type_borne.equals("horizontal")) {
                if (this.image_width.size() > 0) {
                    this.width_paneProduct = this.getMax(this.image_width);
                }
            } else if (this.image_height.size() > 0) {
                this.height_paneProduct = this.getMax(this.image_height) / percent_height_image;
                this.height_paneProduct = this.height_paneProduct < this.getMinHeightAdditionnal() ? this.getMinHeightAdditionnal() : this.height_paneProduct;
            }
        }
    }

    public void lastPaneItems() {
        if (this.page_items > 0) {
            --this.page_items;
            this.list_items.getChildren().clear();
            this.list_items.add((Node)this.panes_items[this.page_items], 0, 0);
        }
    }

    public void nextPageItems() {
        if (this.page_items < this.number_page_items - 1) {
            ++this.page_items;
            this.list_items.getChildren().clear();
            this.list_items.add((Node)this.panes_items[this.page_items], 0, 0);
        }
    }

    private void showItems() {
        this.rangItems();
        this.list_items.getChildren().clear();
        if (this.number_page_items > 0) {
            this.page_items = 0;
            this.list_items.add((Node)this.panes_items[this.page_items], 0, 0);
        }
    }

    private void rangItems() {
        this.number_page_items = (int)Math.ceil((double)this.paneItems.size() / (this.max_lines * (double)this.buttons_of_line));
        this.panes_items = new GridPane[this.number_page_items];
        for (int i = 0; i < this.number_page_items; ++i) {
            this.panes_items[i] = new GridPane();
            this.panes_items[i].setVgap(20.0);
            this.panes_items[i].setHgap(20.0);
            this.panes_items[i].setAlignment(Pos.CENTER);
            this.panes_items[i].setStyle("-fx-background-color: transparent;");
        }
        int index_item = 0;
        int column_item = 0;
        int row_item = 0;
        GridPane pane_line_items = this.getPaneLineItem();
        int step = 0;
        for (Node itemAdditional : this.paneItems) {
            pane_line_items.add(itemAdditional, column_item, 0);
            if (column_item < this.buttons_of_line - 1 && (this.size != 3 || step != 0)) {
                ++column_item;
            } else {
                this.panes_items[index_item].add((Node)pane_line_items, 0, row_item);
                if ((double)row_item < this.max_lines - 1.0) {
                    ++row_item;
                    column_item = 0;
                    pane_line_items = this.getPaneLineItem();
                } else {
                    ++index_item;
                    row_item = 0;
                    column_item = 0;
                    pane_line_items = this.getPaneLineItem();
                }
            }
            ++step;
        }
        if (pane_line_items.getChildren().size() > 0) {
            this.panes_items[index_item].add((Node)pane_line_items, 0, row_item);
        }
    }

    @Override
    protected GridPane getPaneLineItem() {
        GridPane pane_line_items = new GridPane();
        pane_line_items.setVgap(10.0);
        pane_line_items.setHgap(10.0);
        pane_line_items.setAlignment(Pos.CENTER);
        pane_line_items.setStyle("-fx-background-color: transparent;");
        return pane_line_items;
    }

    private void addPreviousButton(boolean add_switch_button, double height, double width) {
        boolean add_previous_button;
        boolean bl = add_previous_button = this.index_product != 0 && this.paneItems.size() % this.max_products == 0;
        if (add_switch_button && add_previous_button) {
            Button button_previous = this.getButtonPrevious(width, height);
            button_previous.setOnAction(this.mEventHandlerPreviousItems);
            this.paneItems.add((Node)button_previous);
        }
    }

    private void addNextButton(boolean add_switch_button, double height, double width, double number_products) {
        boolean add_next_button;
        boolean bl = add_next_button = (double)this.index_product != number_products - 1.0 && (this.paneItems.size() + 1) % this.max_products == 0;
        if (add_switch_button && add_next_button) {
            Button button_next = this.getButtonNext(width, height);
            button_next.setOnAction(this.mEventHandlerNextProducts);
            this.paneItems.add((Node)button_next);
        }
    }

    private void setImageBackground() {
        try {
            Image image = new Image(this.getClass().getResource(this.image_background_promotion).toURI().toString());
            if (image != null) {
                this.image_background.setImage(image);
                this.image_background.setFitHeight(this.height_popUp * 0.8);
                this.image_background.setFitWidth(this.width_popUp * 0.9);
                this.image_background.setPreserveRatio(false);
                this.image_background.setSmooth(false);
                this.image_background.setCache(false);
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PromotionProductsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setImageBackgroundGift() {
        try {
            Image image = new Image(this.getClass().getResource(this.image_background_promotion_gift).toURI().toString());
            if (image != null) {
                this.image_background_gift.setImage(image);
                this.image_background_gift.setFitHeight(this.height_popUp * 0.8);
                this.image_background_gift.setFitWidth(this.width_popUp * 0.9);
                this.image_background_gift.setPreserveRatio(false);
                this.image_background_gift.setSmooth(false);
                this.image_background_gift.setCache(false);
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PromotionProductsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setImageLogo() {
        try {
            File imageFile;
            Image image = null;
            if (AppLocal.LOGO_BORNE != null && !AppLocal.LOGO_BORNE.isEmpty() && (imageFile = new File(new File(System.getProperty("user.home")), "images/logos/" + AppLocal.LOGO_BORNE)).exists()) {
                image = new Image(imageFile.toURI().toString());
            }
            if (image != null) {
                this.image_logo.setImage(image);
                this.image_logo.setFitHeight(this.width_popUp * 0.2);
                this.image_logo.setFitWidth(this.width_popUp * 0.2);
                this.image_logo.setPreserveRatio(false);
                this.image_logo.setSmooth(false);
                this.image_logo.setCache(false);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PromotionProductsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setTexts() {
        this.btn_cancel.setText(AppLocal.getIntString("Button.no.thanks"));
    }
}

