/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.biborne.utils.BarcodeScannerListener;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import fr.protactile.procaisse.dao.entities.PromoCode;
import fr.protactile.procaisse.services.PromoCodeService;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PromoCodeController
implements RootController {
    @FXML
    GridPane center_pane;
    @FXML
    GridPane keyborad_pane;
    @FXML
    GridPane keyborad;
    @FXML
    GridPane logo_pane;
    @FXML
    GridPane pane_phone;
    @FXML
    GridPane pane_digits;
    @FXML
    GridPane pane_close;
    @FXML
    GridPane field_codepane;
    @FXML
    GridPane pane_valid;
    @FXML
    GridPane pane_footer;
    @FXML
    GridPane massege_error_pane;
    @FXML
    FlowPane main_pane;
    @FXML
    Label field_code;
    @FXML
    Button btn_valid;
    @FXML
    Button btn_1;
    @FXML
    Button btn_cancel;
    @FXML
    ImageView logoicone;
    @FXML
    Label errorMessage;
    private Object[] result;
    private String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    private String styleGender;
    private Stage stage;
    private boolean popup_borne;
    private PromoCodeService mPromoCodeService;
    private String ESPECE = "esp\u00e8ce";
    private String SOMME = "somme";
    private String typeOrder;
    private Image image_fr;
    private Image image_en;
    private Image image_es;

    public void initializer() throws URISyntaxException {
        this.result = new Object[5];
        this.result[0] = false;
        this.setCss();
        double height_pane = this.popup_borne ? AppVarUtils.getScreenDimension().getHeight() * 0.9 * 0.9 : AppVarUtils.getScreenDimension().getHeight() * 0.6;
        double width_pane = this.popup_borne ? AppVarUtils.getScreenDimension().getWidth() * 0.95 : AppVarUtils.getScreenDimension().getWidth() * 0.5 * 0.9;
        this.center_pane.setPrefHeight(height_pane);
        this.center_pane.setPrefWidth(width_pane);
        if (this.popup_borne) {
            this.logo_pane.setPrefHeight(height_pane * 0.12);
            this.field_codepane.setPrefHeight(height_pane * 0.05);
            this.keyborad.setPrefHeight(height_pane * 0.19);
            this.pane_valid.setPrefHeight(height_pane * 0.04);
            this.field_code.setPrefWidth(width_pane * 0.55);
            this.btn_valid.setPrefWidth(width_pane * 0.45);
            this.massege_error_pane.setPrefHeight(height_pane * 0.03);
            this.errorMessage.getStyleClass().add((Object)"bg-white");
        } else {
            this.logo_pane.setPrefHeight(height_pane * 0.15);
            this.field_codepane.setPrefHeight(height_pane * 0.1);
            this.keyborad.setPrefHeight(height_pane * 0.4);
            this.pane_valid.setPrefHeight(height_pane * 0.1);
            this.field_code.setPrefWidth(width_pane * 0.9);
            this.btn_valid.setPrefWidth(width_pane * 0.9);
            this.massege_error_pane.setPrefHeight(height_pane * 0.05);
            this.errorMessage.getStyleClass().add((Object)"bg_transparent");
        }
        this.errorMessage.setVisible(false);
        double height_logo = this.logo_pane.getPrefHeight() * 0.9;
        Image img_logo = new Image(this.getClass().getResource("/com/openbravo/images/" + AppLocal.getIntString("Image.promo.code")).toURI().toString());
        if (img_logo != null) {
            this.logoicone.setImage(img_logo);
            this.logoicone.setFitHeight(height_logo);
            this.logoicone.setPreserveRatio(true);
            this.logoicone.setSmooth(true);
            this.logoicone.setCache(true);
        }
        this.center_pane.getChildren().clear();
        int row = 0;
        if (!this.popup_borne) {
            this.center_pane.add((Node)this.pane_close, 0, row++);
        }
        this.center_pane.add((Node)this.logo_pane, 0, row++);
        this.center_pane.add((Node)this.massege_error_pane, 0, row++);
        this.center_pane.add((Node)this.field_codepane, 0, row++);
        this.center_pane.add((Node)this.keyborad, 0, row++);
        this.center_pane.add((Node)this.pane_valid, 0, row++);
        if (this.popup_borne) {
            this.center_pane.add((Node)this.pane_footer, 0, row++);
        }
        this.mPromoCodeService = PromoCodeService.getInstance();
        this.setTexts();
        BarcodeScannerListener.attach(this.stage, barcode -> {
            this.errorMessage.setVisible(false);
            this.field_code.setText(barcode);
            this.valid();
        });
    }

    public void closePopUp() {
        this.stage.close();
    }

    public Object[] getResult() {
        return this.result;
    }

    @Override
    public void init(Stage mStage) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PromoCodeController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object object) {
        try {
            this.stage = mStage;
            this.popup_borne = (Boolean)object;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PromoCodeController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        try {
            this.stage = mStage;
            this.popup_borne = (Boolean)objects[0];
            this.typeOrder = (String)objects[1];
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PromoCodeController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void select7() {
        this.writeNumber("7");
        this.errorMessage.setVisible(false);
    }

    public void select8() {
        this.writeNumber("8");
        this.errorMessage.setVisible(false);
    }

    public void select9() {
        this.writeNumber("9");
        this.errorMessage.setVisible(false);
    }

    public void select6() {
        this.writeNumber("6");
        this.errorMessage.setVisible(false);
    }

    public void select5() {
        this.writeNumber("5");
        this.errorMessage.setVisible(false);
    }

    public void select4() {
        this.writeNumber("4");
        this.errorMessage.setVisible(false);
    }

    public void select3() {
        this.writeNumber("3");
        this.errorMessage.setVisible(false);
    }

    public void select2() {
        this.writeNumber("2");
        this.errorMessage.setVisible(false);
    }

    public void select1() {
        this.writeNumber("1");
        this.errorMessage.setVisible(false);
    }

    public void select0() {
        this.writeNumber("0");
        this.errorMessage.setVisible(false);
    }

    public void selectA() {
        this.writeNumber("A");
        this.errorMessage.setVisible(false);
    }

    public void selectZ() {
        this.writeNumber("Z");
        this.errorMessage.setVisible(false);
    }

    public void selectE() {
        this.writeNumber("E");
        this.errorMessage.setVisible(false);
    }

    public void selectR() {
        this.writeNumber("R");
        this.errorMessage.setVisible(false);
    }

    public void selectT() {
        this.writeNumber("T");
        this.errorMessage.setVisible(false);
    }

    public void selectY() {
        this.writeNumber("Y");
        this.errorMessage.setVisible(false);
    }

    public void selectU() {
        this.writeNumber("U");
        this.errorMessage.setVisible(false);
    }

    public void selectI() {
        this.writeNumber("I");
        this.errorMessage.setVisible(false);
    }

    public void selectO() {
        this.writeNumber("O");
        this.errorMessage.setVisible(false);
    }

    public void selectP() {
        this.writeNumber("P");
        this.errorMessage.setVisible(false);
    }

    public void selectQ() {
        this.writeNumber("Q");
        this.errorMessage.setVisible(false);
    }

    public void selectS() {
        this.writeNumber("S");
        this.errorMessage.setVisible(false);
    }

    public void selectD() {
        this.writeNumber("D");
        this.errorMessage.setVisible(false);
    }

    public void selectF() {
        this.writeNumber("F");
        this.errorMessage.setVisible(false);
    }

    public void selectG() {
        this.writeNumber("G");
        this.errorMessage.setVisible(false);
    }

    public void selectH() {
        this.writeNumber("H");
        this.errorMessage.setVisible(false);
    }

    public void selectJ() {
        this.writeNumber("J");
        this.errorMessage.setVisible(false);
    }

    public void selectK() {
        this.writeNumber("K");
        this.errorMessage.setVisible(false);
    }

    public void selectL() {
        this.writeNumber("L");
        this.errorMessage.setVisible(false);
    }

    public void selectM() {
        this.writeNumber("M");
        this.errorMessage.setVisible(false);
    }

    public void selectW() {
        this.writeNumber("W");
        this.errorMessage.setVisible(false);
    }

    public void selectX() {
        this.writeNumber("X");
        this.errorMessage.setVisible(false);
    }

    public void selectC() {
        this.writeNumber("C");
        this.errorMessage.setVisible(false);
    }

    public void selectV() {
        this.writeNumber("V");
        this.errorMessage.setVisible(false);
    }

    public void selectB() {
        this.writeNumber("B");
        this.errorMessage.setVisible(false);
    }

    public void selectN() {
        this.writeNumber("N");
        this.errorMessage.setVisible(false);
    }

    public void writeNumber(String number) {
        this.field_code.setText(this.field_code.getText() + number);
    }

    public void selectBack() {
        if (this.field_code.getText().length() >= 1) {
            this.field_code.setText(this.field_code.getText().substring(0, this.field_code.getText().length() - 1));
            this.errorMessage.setVisible(false);
        }
    }

    public void selectPoint() {
        if (this.field_code.getText().length() >= 1) {
            this.errorMessage.setVisible(false);
            this.field_code.setText(this.field_code.getText() + ".");
        }
    }

    private void setCss() {
        if (this.popup_borne) {
            this.main_pane.getStyleClass().add((Object)"bg-white");
            this.main_pane.getStyleClass().add((Object)"bg_radius_4");
            this.main_pane.getStyleClass().add((Object)"border_radius_3");
            this.main_pane.getStyleClass().add((Object)"border_width_8");
            this.main_pane.setStyle("-fx-border-color: " + this.color_hex + ";");
            this.field_code.getStyleClass().add((Object)"text-size-20");
            this.field_code.setStyle("-fx-border-color: " + this.color_hex + ";");
            this.field_code.getStyleClass().add((Object)"border_radius_1");
            this.btn_valid.setStyle("-fx-background-color: " + this.color_hex + "; -fx-background-radius: 1em;");
        } else {
            this.btn_valid.getStyleClass().add((Object)"bg_caribbean_green");
            this.field_code.getStyleClass().add((Object)"text-size-13");
            this.field_code.getStyleClass().add((Object)"border_black");
        }
    }

    public void valid() {
        String promo_code = this.field_code.getText();
        if (promo_code != null && !promo_code.isEmpty()) {
            PromoCode mPromoCode = this.mPromoCodeService.downloadPromoCodeByCode(promo_code);
            if (mPromoCode != null) {
                Date now = new Date();
                if (mPromoCode.getDate_start() != null && mPromoCode.getDate_end() != null && now.after(mPromoCode.getDate_start()) && now.before(mPromoCode.getDate_end())) {
                    if (this.isValidType(mPromoCode)) {
                        this.result[0] = true;
                        this.result[1] = mPromoCode.getAmount();
                        this.result[2] = mPromoCode.getType() != null && mPromoCode.getType().equals(this.ESPECE) ? this.SOMME : mPromoCode.getType();
                        this.result[3] = promo_code;
                        this.result[4] = mPromoCode.getSource();
                        this.closePopUp();
                    } else {
                        this.errorMessage.setText(AppLocal.getIntString("Message.promo.code.invalid"));
                        this.errorMessage.setVisible(true);
                    }
                } else if (!this.popup_borne) {
                    this.errorMessage.setText(AppLocal.getIntString("Message.promo.code.expired"));
                    this.errorMessage.setVisible(true);
                } else {
                    this.errorMessage.setText(AppLocal.getIntString("Message.promo.code.expired"));
                    this.errorMessage.setVisible(true);
                }
            } else {
                this.errorMessage.setText(AppLocal.getIntString("Message.promo.code.invalid"));
                this.errorMessage.setVisible(true);
            }
        }
    }

    private boolean isValidType(PromoCode mPromoCode) {
        if (this.typeOrder != null) {
            switch (this.typeOrder) {
                case "Sur Place": {
                    return mPromoCode.isAt_spot();
                }
                case "A Emporter": {
                    return mPromoCode.isTake_away();
                }
                case "En Livraison": {
                    return mPromoCode.isDelivery();
                }
                case "Drive": {
                    return mPromoCode.isDrive();
                }
            }
        }
        return false;
    }

    private void setTexts() {
        this.btn_cancel.setText(AppLocal.getIntString("Button.cancel"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid"));
    }
}

