/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.SwitchButtonCustomised;
import com.openbravo.controllers.borne.AbstractController;
import com.openbravo.controllers.borne.CatalogueController;
import com.openbravo.controllers.borne.SummaryOrdercontroller;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.events.CustomListItemsLater;
import com.openbravo.models.HBoxItemsLater;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ClotureService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;

public class ProductsLaterController
extends AbstractController {
    @FXML
    ListView list_detail;
    @FXML
    GridPane main_pane;
    @FXML
    GridPane pane_switch;
    @FXML
    Label label_background;
    @FXML
    ImageView background;
    @FXML
    Button button_valid;
    @FXML
    Label title_1;
    @FXML
    Label title_2;
    @FXML
    Label label_later;
    @FXML
    Label label_now;
    private JRootApp m_App;
    private CatalogueController catalogueController;
    private String color_hex;
    private double heightImage = AppVarUtils.getScreenDimension().getHeight();
    private Image image_background;
    private String bg_color_button_validation;
    private SummaryOrdercontroller mSummaryOrdercontroller;
    private Scene orderScene;
    private ClotureService clotureService;
    private SwitchButtonCustomised switchButton;
    private List<HBoxItemsLater> listComponents;
    private boolean canceled_cb_payment;
    private EventHandler mEventHandlerClickSwitch = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            SwitchButtonCustomised mSwitchButton = null;
            if (event.getSource() instanceof SwitchButtonCustomised) {
                mSwitchButton = (SwitchButtonCustomised)((Object)event.getSource());
            } else if (event.getSource() instanceof Button) {
                Button button = (Button)event.getSource();
                mSwitchButton = (SwitchButtonCustomised)button.getParent();
            }
            if (mSwitchButton != null) {
                if (mSwitchButton.isRightSelected()) {
                    mSwitchButton.setLeftTrue();
                    ProductsLaterController.this.setItemsLater();
                } else {
                    mSwitchButton.setRightTrue();
                    ProductsLaterController.this.setItemsNow();
                }
            }
        }
    };

    public void initialize(JRootApp app, CatalogueController catalogueController, ClotureService clotureService) throws BasicException {
        this.m_App = app;
        this.clotureService = clotureService;
        this.catalogueController = catalogueController;
        new ArrayList();
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.main_pane.setStyle("-fx-background-color: transparent;");
        this.refProducts = new HashMap();
        this.m_FilerUtils = FilerUtils.getInstance();
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlItems = (DataLogicItems)this.m_App.getBean("com.openbravo.dao.DataLogicItems");
        this.list_detail.setCellFactory((Callback)new Callback<ListView<HBoxItemsLater>, ListCell<HBoxItemsLater>>(){

            public CustomListItemsLater call(ListView<HBoxItemsLater> listView) {
                return new CustomListItemsLater();
            }
        });
        this.bg_color_button_validation = ColorUtils.getColor(AppLocal.BG_COLOR_BUTTON_VALIDATION);
        this.button_valid.setStyle("-fx-background-color: " + this.bg_color_button_validation + ";-fx-border-color: " + this.bg_color_button_validation + ";");
        double width_switch = 60.0;
        this.switchButton = new SwitchButtonCustomised(width_switch, width_switch * 0.5, "#0CA858");
        this.switchButton.setOnMouseClicked(this.mEventHandlerClickSwitch);
        this.switchButton.getButton().setOnMouseClicked(this.mEventHandlerClickSwitch);
        this.pane_switch.add((Node)this.switchButton, 0, 0);
    }

    public void valid() {
        try {
            if (this.mSummaryOrdercontroller == null || this.orderScene == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/summary_page.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mSummaryOrdercontroller = (SummaryOrdercontroller)loader.getController();
                this.orderScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.orderScene.getStylesheets().add((Object)"/styles/styles.css");
                this.orderScene.getStylesheets().add((Object)"/styles/app.css");
                this.mSummaryOrdercontroller.initialize(this.m_App, this.catalogueController, this.orderScene);
                this.clotureService.addPropertyChangeListener(this.mSummaryOrdercontroller);
            }
            this.mSummaryOrdercontroller.loadInfoPromoAndBasket(this.canceled_cb_payment);
            this.m_App.getFxPanel().setScene(this.orderScene);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadPanier() {
        if (AppLocal.ticketBorne != null) {
            this.list_detail.getItems().clear();
            this.listComponents = new ArrayList<HBoxItemsLater>();
            for (TicketLineInfo line : AppLocal.ticketBorne.getLines()) {
                if (!line.isNext() && line.isProduct_later()) {
                    HBoxItemsLater componentLine = new HBoxItemsLater(line);
                    this.listComponents.add(componentLine);
                    continue;
                }
                for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                    if (!optionItemOrder.isOption_later()) continue;
                    HBoxItemsLater componentLine = new HBoxItemsLater(optionItemOrder);
                    this.listComponents.add(componentLine);
                }
            }
            ObservableList observableList = FXCollections.observableArrayList();
            observableList.setAll(this.listComponents);
            this.list_detail.setItems(observableList);
        }
    }

    private void setImageBackGround() {
        if (this.image_background == null) {
            this.image_background = this.getImage(AppLocal.BACKGROUND_ITEMS_LATER);
        }
        if (this.image_background != null) {
            this.background.setImage(this.image_background);
            this.background.setFitHeight(this.heightImage);
            this.background.setPreserveRatio(true);
            this.background.setSmooth(true);
            this.background.setCache(true);
        } else {
            this.label_background.setStyle("-fx-background-color: " + this.color_hex + ";");
        }
    }

    private Image getImage(String path) {
        File image_path;
        Image img_logo = null;
        if (path != null && !path.isEmpty() && (image_path = new File(new File(System.getProperty("user.home")), "images/logos/" + path)).exists()) {
            img_logo = new Image(image_path.toURI().toString());
        }
        return img_logo;
    }

    public void loadInfoBasket(boolean canceled_cb_payment) {
        this.canceled_cb_payment = canceled_cb_payment;
        this.switchButton.setRightTrue();
        this.setTexts();
        this.loadPanier();
        this.main_pane.requestFocus();
        this.setImageBackGround();
    }

    private void setTexts() {
        this.button_valid.setText(AppLocal.getIntString("Button.valid"));
        this.title_1.setText("MAINTENANT \n OU PLUS TARD ?");
        this.title_2.setText("Souhaitez-vous recevoir vos produits maintenant ou apr\u00e8s votre repas ?");
        this.label_later.setText("\u23f3 Apr\u00e8s le repas");
        this.label_now.setText("Maintenant");
    }

    private void setItemLater(HBoxItemsLater hBoxItemsLater) {
        if (hBoxItemsLater.getLine() != null) {
            hBoxItemsLater.getLine().setTime_served("later");
        }
        if (hBoxItemsLater.getOptionItemOrder() != null) {
            hBoxItemsLater.getOptionItemOrder().setTime_served("later");
        }
        hBoxItemsLater.selectLater();
    }

    private void setItemNow(HBoxItemsLater hBoxItemsLater) {
        if (hBoxItemsLater.getLine() != null) {
            hBoxItemsLater.getLine().setTime_served("now");
        }
        if (hBoxItemsLater.getOptionItemOrder() != null) {
            hBoxItemsLater.getOptionItemOrder().setTime_served("now");
        }
        hBoxItemsLater.selectNow();
    }

    private void setItemsLater() {
        for (HBoxItemsLater hBoxItemsLater : this.listComponents) {
            this.setItemLater(hBoxItemsLater);
        }
    }

    private void setItemsNow() {
        for (HBoxItemsLater hBoxItemsLater : this.listComponents) {
            this.setItemNow(hBoxItemsLater);
        }
    }
}

