/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.service.Pair;
import fr.protactile.procaisse.dao.entities.NutritionalInfoProduct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ProductNutritionalValueController {
    private final NutritionalInfoProduct mNutritionalInfoProduct;
    private final Map<Integer, VBox> widgets;
    @FXML
    private final StackPane paneImageProduct;
    private final GridPane valuesPane;
    private final double paneWidth;

    public ProductNutritionalValueController(NutritionalInfoProduct nutritionalInfo, StackPane pane, double paneWidth) {
        this.mNutritionalInfoProduct = nutritionalInfo;
        this.paneImageProduct = pane;
        this.paneWidth = paneWidth;
        this.widgets = new HashMap<Integer, VBox>();
        this.valuesPane = new GridPane();
        this.valuesPane.setVisible(false);
        this.valuesPane.setManaged(false);
        this.setPaneProperties();
        this.initializeWidgets();
        this.paintValues();
    }

    private void setPaneProperties() {
        this.valuesPane.setAlignment(Pos.CENTER);
        this.valuesPane.setPrefHeight(this.paneImageProduct.getPrefHeight());
        this.valuesPane.setPrefWidth(this.paneWidth);
        this.valuesPane.setMinWidth(this.paneWidth);
    }

    public void toggleView() {
        if (this.isDisplayed()) {
            this.hideValues();
        } else {
            this.showValues();
        }
    }

    public boolean isDisplayed() {
        return this.valuesPane.isVisible();
    }

    public void hideValues() {
        this.valuesPane.setVisible(false);
        this.valuesPane.setManaged(false);
    }

    public void showValues() {
        this.valuesPane.setVisible(true);
        this.valuesPane.setManaged(true);
    }

    private void paintValues() {
        List keys = this.widgets.keySet().stream().map(Integer::intValue).collect(Collectors.toList());
        if (keys.size() == 4) {
            double width = this.paneWidth * 0.45;
            this.valuesPane.add((Node)this.getBlankBox(width, width), 0, 0);
            this.valuesPane.add((Node)this.widgets.get(keys.get(0)), 1, 0);
            this.valuesPane.add((Node)this.getBlankBox(width, width), 2, 0);
            VBox w1 = this.widgets.get(keys.get(1));
            w1.setTranslateX(-100.0);
            this.valuesPane.add((Node)w1, 0, 1);
            this.valuesPane.add((Node)this.getBlankBox(width, width), 1, 1);
            VBox w2 = this.widgets.get(keys.get(2));
            w2.setTranslateX(100.0);
            this.valuesPane.add((Node)w2, 2, 1);
            this.valuesPane.add((Node)this.getBlankBox(width, width), 0, 2);
            this.valuesPane.add((Node)this.widgets.get(keys.get(3)), 1, 2);
            this.valuesPane.add((Node)this.getBlankBox(width, width), 2, 2);
        } else {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                int row = key <= 2 ? 0 : 1;
                int column = key <= 2 ? key : key - 3;
                this.valuesPane.add((Node)this.widgets.get(key), column, row);
            }
        }
        this.paneImageProduct.getChildren().add((Object)this.valuesPane);
    }

    private VBox getCirclePane(String path, String name, Double value, Pos pos, String key, double width, double height, String bgColor, String textColor) {
        VBox pane = new VBox();
        pane.setStyle("-fx-background-color: transparent; -fx-background-border: transparent; -fx-border-color: transparent; -fx-effect: dropshadow(three-pass-box, rgba(50,50,50,0.8), 10, 0, 0, 0);");
        pane.setPrefSize(width, height);
        pane.setAlignment(pos);
        VBox vbox = new VBox();
        vbox.setStyle("-fx-background-color: " + bgColor + "; -fx-background-radius: 50em; -fx-border-color: transparent;");
        vbox.setAlignment(Pos.CENTER);
        vbox.setMinWidth(145.0);
        vbox.setMaxWidth(145.0);
        vbox.setMinHeight(145.0);
        vbox.setMaxHeight(145.0);
        vbox.getChildren().add((Object)this.getImageViewByName(name, path));
        Label valueLabel = new Label(value.toString().concat(key));
        valueLabel.setAlignment(Pos.CENTER);
        valueLabel.setStyle("-fx-font-size: 16pt; -fx-text-fill: " + textColor + "; -fx-font-weight: bold; -fx-background-color: transparent; -fx-background-border: transparent; -fx-border-color: transparent;");
        vbox.getChildren().add((Object)valueLabel);
        Label nameLabel = new Label(name);
        nameLabel.setWrapText(true);
        nameLabel.setPrefWidth(100.0);
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setStyle("-fx-font-size: 14pt; -fx-text-fill: " + textColor + "; -fx-font-weight: normal; -fx-background-color: transparent; -fx-background-border: transparent; -fx-border-color: transparent;");
        vbox.getChildren().add((Object)nameLabel);
        pane.getChildren().add((Object)vbox);
        return pane;
    }

    private ImageView getImageViewByName(String name, String path) {
        String nutrientKey;
        ImageView view = null;
        switch (name) {
            case "Fibres": {
                String string = "fiber_g";
                break;
            }
            case "Prot\u00e9ines": {
                String string = "protein_g";
                break;
            }
            case "Calories": {
                String string = "energy_kcal";
                break;
            }
            case "Mati\u00e8res grasses": {
                String string = "fat_g";
                break;
            }
            case "Glucides": {
                String string = "carbs_g";
                break;
            }
            case "Sel": {
                String string = "salt_g";
                break;
            }
            default: {
                String string = nutrientKey = null;
            }
        }
        if (nutrientKey != null) {
            Image imageNutri = new Image(this.getClass().getResourceAsStream(path));
            view = new ImageView(imageNutri);
            view.setPreserveRatio(true);
            view.setFitHeight(40.0);
            view.setFitWidth(40.0);
            view.setSmooth(true);
            view.setCache(true);
        }
        return view;
    }

    private void initializeWidgets() {
        int[] nArray;
        double width = this.paneWidth * 0.5;
        double height = this.valuesPane.getPrefHeight() * 0.4;
        List<Pair<String, Double>> availableValues = this.mNutritionalInfoProduct.getAvailableValues();
        switch (availableValues.size()) {
            case 1: {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 1;
                break;
            }
            case 2: {
                int[] nArray3 = new int[2];
                nArray3[0] = 0;
                nArray = nArray3;
                nArray3[1] = 2;
                break;
            }
            case 3: {
                int[] nArray4 = new int[3];
                nArray4[0] = 1;
                nArray4[1] = 3;
                nArray = nArray4;
                nArray4[2] = 5;
                break;
            }
            case 4: {
                int[] nArray5 = new int[4];
                nArray5[0] = 0;
                nArray5[1] = 2;
                nArray5[2] = 3;
                nArray = nArray5;
                nArray5[3] = 5;
                break;
            }
            case 5: {
                int[] nArray6 = new int[5];
                nArray6[0] = 0;
                nArray6[1] = 1;
                nArray6[2] = 2;
                nArray6[3] = 3;
                nArray = nArray6;
                nArray6[4] = 5;
                break;
            }
            default: {
                int[] nArray7 = new int[6];
                nArray7[0] = 0;
                nArray7[1] = 1;
                nArray7[2] = 2;
                nArray7[3] = 3;
                nArray7[4] = 4;
                nArray = nArray7;
                nArray7[5] = 5;
            }
        }
        int[] indexes = nArray;
        List<Pos> positions = switch (availableValues.size()) {
            case 1 -> List.of(Pos.TOP_CENTER);
            case 2 -> List.of(Pos.TOP_CENTER, Pos.TOP_CENTER);
            case 3 -> List.of(Pos.TOP_CENTER, Pos.CENTER, Pos.CENTER);
            case 4 -> List.of(Pos.CENTER, Pos.CENTER, Pos.CENTER, Pos.CENTER);
            case 5 -> List.of(Pos.CENTER, Pos.TOP_CENTER, Pos.CENTER, Pos.CENTER, Pos.CENTER);
            default -> List.of(Pos.CENTER, Pos.TOP_CENTER, Pos.CENTER, Pos.CENTER, Pos.BOTTOM_CENTER, Pos.CENTER);
        };
        for (int i = 0; i < availableValues.size(); ++i) {
            String[] properties = this.getValueProperties(availableValues.get(i).getFirst());
            this.widgets.put(indexes[i], this.getCirclePane(properties[3], properties[4], availableValues.get(i).getSecond(), positions.get(i), properties[2], width, availableValues.size() == 1 || availableValues.size() == 2 ? height * 2.0 : height, properties[0], properties[1]));
        }
    }

    public VBox getBlankBox(double width, double height) {
        VBox box = new VBox();
        box.setPrefSize(width, height);
        box.setStyle("-fx-background-color: transparent;");
        return box;
    }

    public String[] getValueProperties(String valueKey) {
        String[] stringArray;
        switch (valueKey) {
            case "fat": {
                String[] stringArray2 = new String[5];
                stringArray2[0] = "#0CA858";
                stringArray2[1] = "white";
                stringArray2[2] = " g";
                stringArray2[3] = "/images/grasses.png";
                stringArray = stringArray2;
                stringArray2[4] = "Mati\u00e8res grasses";
                break;
            }
            case "energy": {
                String[] stringArray3 = new String[5];
                stringArray3[0] = "#FF8C00";
                stringArray3[1] = "white";
                stringArray3[2] = " kcal";
                stringArray3[3] = "/images/calories.png";
                stringArray = stringArray3;
                stringArray3[4] = "Calories";
                break;
            }
            case "fiber": {
                String[] stringArray4 = new String[5];
                stringArray4[0] = "#C0CA33";
                stringArray4[1] = "white";
                stringArray4[2] = " g";
                stringArray4[3] = "/images/fibers.png";
                stringArray = stringArray4;
                stringArray4[4] = "Fibres";
                break;
            }
            case "carb": {
                String[] stringArray5 = new String[5];
                stringArray5[0] = "#499AB7";
                stringArray5[1] = "white";
                stringArray5[2] = " g";
                stringArray5[3] = "/images/carb.png";
                stringArray = stringArray5;
                stringArray5[4] = "Glucides";
                break;
            }
            case "protein": {
                String[] stringArray6 = new String[5];
                stringArray6[0] = "#FF5839";
                stringArray6[1] = "white";
                stringArray6[2] = " g";
                stringArray6[3] = "/images/proteins.png";
                stringArray = stringArray6;
                stringArray6[4] = "Prot\u00e9ines";
                break;
            }
            case "salt": {
                String[] stringArray7 = new String[5];
                stringArray7[0] = "white";
                stringArray7[1] = "black";
                stringArray7[2] = " g";
                stringArray7[3] = "/images/salt.png";
                stringArray = stringArray7;
                stringArray7[4] = "Sel";
                break;
            }
            default: {
                stringArray = null;
            }
        }
        return stringArray;
    }
}

