/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.service.Pair;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ProductAllergensController {
    private final String[] allergens;
    private final int numberByRow = 9;
    private final String lightBgColor;
    private final StackPane paneImageProduct;
    private final double size;
    private final double paneWidth;
    private GridPane paneAllergens;

    public ProductAllergensController(String[] allergens, StackPane paneImageProduct, double paneWidth) {
        this.paneImageProduct = paneImageProduct;
        this.paneWidth = paneWidth;
        this.allergens = allergens;
        this.lightBgColor = ColorUtils.getColorLight(AppLocal.color_borne, 0.1);
        this.size = paneWidth / 9.0 * 0.8;
        this.paneAllergens = new GridPane();
        this.paintValues();
    }

    private void paintValues() {
        System.out.println("allergens.length : " + this.allergens.length);
        int numberOfRow = (int)Math.ceil((double)this.allergens.length / 9.0);
        System.out.println("numberOfRow : " + numberOfRow);
        for (int i = 0; i < numberOfRow; ++i) {
            HBox box = new HBox();
            box.setAlignment(Pos.CENTER);
            box.setMinWidth(this.paneWidth);
            box.setMaxWidth(this.paneWidth);
            box.setSpacing(25.0);
            int startIndex = i * 9;
            int endIndex = (i + 1) * 9;
            int trueEndIndex = Math.min(endIndex, this.allergens.length);
            for (int j = startIndex; j < trueEndIndex; ++j) {
                box.getChildren().add((Object)this.getCirclePane(this.allergens[j]));
            }
            this.paneAllergens.add((Node)box, 0, i);
        }
        this.paneImageProduct.getChildren().add((Object)this.paneAllergens);
    }

    public boolean isDisplayed() {
        return this.paneAllergens.isVisible();
    }

    public void hideAllergens() {
        this.paneAllergens.setVisible(false);
        this.paneAllergens.setManaged(false);
    }

    public void showAllergens() {
        this.paneAllergens.setVisible(true);
        this.paneAllergens.setManaged(true);
    }

    private VBox getCirclePane(String key) {
        Pair<String, String> nameAndPath = this.getNameAndPathByAllergenKey(key);
        VBox pane = new VBox();
        pane.setStyle("-fx-background-color: " + this.lightBgColor + "; -fx-background-border: transparent; -fx-border-color: transparent; -fx-background-radius: 50em;");
        pane.setMinSize(this.size, this.size);
        pane.setMaxSize(this.size, this.size);
        pane.setAlignment(Pos.CENTER);
        ImageView view = new ImageView(new Image(this.getClass().getResourceAsStream(nameAndPath.getSecond())));
        view.setPreserveRatio(true);
        double imageSize = this.size * 0.35;
        view.setFitHeight(imageSize);
        view.setFitWidth(imageSize);
        view.setSmooth(true);
        view.setCache(true);
        pane.getChildren().add((Object)view);
        Label nameLabel = new Label(nameAndPath.getFirst());
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setWrapText(true);
        nameLabel.setStyle("-fx-font-size: 8pt; -fx-text-fill: #5E5351; -fx-font-weight: bold; -fx-background-color: transparent; -fx-background-border: transparent; -fx-border-color: transparent;");
        pane.getChildren().add((Object)nameLabel);
        return pane;
    }

    public Pair<String, String> getNameAndPathByAllergenKey(String key) {
        return switch (key) {
            case "gluten" -> Pair.create("Gluten", "/images/gluten.png");
            case "arachides" -> Pair.create("Arachides", "/images/arachides.png");
            case "celeri" -> Pair.create("Celeri", "/images/celeri.png");
            case "moutarde" -> Pair.create("Moutarde", "/images/moutarde.png");
            case "grainesSesame" -> Pair.create("Graines Sesame", "/images/grainesSesame.png");
            case "anhydrideSulfureux" -> Pair.create("Anhydride Sulfureux", "/images/anhydrideSulfureux.png");
            case "fruitsCoques" -> Pair.create("Fruits Coques", "/images/fruitsCoques.png");
            case "lait" -> Pair.create("Lait", "/images/lait.png");
            case "soja" -> Pair.create("Soja", "/images/soja.png");
            case "crustaces" -> Pair.create("Crustaces", "/images/crustaces.png");
            case "oeufs" -> Pair.create("Oeufs", "/images/oeufs.png");
            case "poisson" -> Pair.create("Poisson", "/images/poisson.png");
            case "lupin" -> Pair.create("Lupin", "/images/lupin.png");
            case "mollusques" -> Pair.create("Mollusques", "/images/mollusques.png");
            default -> null;
        };
    }
}

