/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.PaneAdditional;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.components.views.ButtonBoxAdditional;
import com.openbravo.components.views.ButtonBoxAdditionalQtt;
import com.openbravo.controllers.borne.AbstractController;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import fr.protactile.procaisse.dao.entities.TagInfo;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class ProductAdditionalController
extends AbstractController
implements RootController {
    private Stage stage;
    private Object[] result;
    private String text_color_borne_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
    private String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    private double height_popUp;
    private double width_popUp;
    private List<ItemOrderInfo> listChoiceIngredient;
    private List<OptionItemOrder> listChoiceSupplement;
    private List<ProductTicket> listProducts;
    private double WIDTH_VIEW_ADDITIONAL;
    private double HEIGHT_VIEW_ADDITIONAL;
    private int page_additional;
    private boolean product_additionnel;
    private List<Double> image_additionnal_height;
    private List<Double> image_additionnal_width;
    private int MAX_LINE_ADDITIONNAL;
    private int MAX_COLUMN_ADDITIONNAL;
    private List<ProductInfoExt> itemsAdditionnals;
    private List<ProductInfoExt> listChoiceAdditionnals;
    private double height_paneProduct;
    private double width_paneProduct;
    private HashMap<Integer, ImageView> imagesViewProducts;
    private int number_page_additional;
    private GridPane[] panes_additionals;
    private boolean global_additional_sales;
    @FXML
    GridPane pane_preview_additional;
    @FXML
    Button btn_additional_previous;
    @FXML
    GridPane list_additional;
    @FXML
    GridPane pane_next_additional;
    @FXML
    Button btn_additional_next;
    @FXML
    Label title;
    @FXML
    Button btn_valid_additional;
    @FXML
    GridPane pane_footer;
    @FXML
    Button btn_retour;
    List<Node> paneAdditionnals;
    private double percent_height = 1.0;
    private double percent_width = 1.0;
    private int size_text;
    private ItemService mItemService;
    private int selected_items;
    private int buttons_of_line;
    private double max_lines;
    private int max_products;
    private int index_product;
    private int index_line;
    private final String SIZE_IMAGE_128 = "_128px";
    private TagInfo mTagInfo;
    protected HashMap<Integer, SoftReference> refTags;
    private int current_hour;
    private int size;
    private EventHandler mEventHandlerAddtionalIncreaseAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxAdditionalQtt mButtonSource = (ButtonBoxAdditionalQtt)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getmProductInfoExt() != null && mButtonSource.getPaneProduct() != null && mButtonSource.getLabelQtt() != null && mButtonSource.getBtnProdcut() != null) {
                try {
                    ProductAdditionalController.this.addAdditionnal(mButtonSource.getmProductInfoExt(), mButtonSource.getPaneProduct(), mButtonSource.getBtnProdcut(), mButtonSource.getLabelQtt());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    };
    private EventHandler mEventHandlerAddtionalDecreaseAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxAdditionalQtt mButtonSource = (ButtonBoxAdditionalQtt)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getmProductInfoExt() != null && mButtonSource.getPaneProduct() != null && mButtonSource.getLabelQtt() != null && mButtonSource.getBtnProdcut() != null) {
                ProductAdditionalController.this.decreaseAdditionnal(mButtonSource.getmProductInfoExt(), mButtonSource.getPaneProduct(), mButtonSource.getBtnProdcut(), mButtonSource.getLabelQtt());
            }
        }
    };
    private EventHandler mEventHandlerAddtionalAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxAdditional mButtonSource = (ButtonBoxAdditional)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getmProductInfoExt() != null && mButtonSource.getPaneProduct() != null && mButtonSource.getLabelQtt() != null) {
                try {
                    ProductAdditionalController.this.chooseAdditionnal(mButtonSource.getmProductInfoExt(), mButtonSource.getPaneProduct(), mButtonSource, mButtonSource.getLabelQtt());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    };
    private EventHandler mEventHandlerNextProducts = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                ProductAdditionalController.this.nextPageAdditionnal();
            }
        }
    };
    private EventHandler mEventHandlerPreviousItems = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                ProductAdditionalController.this.lastPaneAdditionnal();
            }
        }
    };

    public Object[] getResult() {
        return this.result;
    }

    private void initializer() throws URISyntaxException, BasicException {
        this.listChoiceIngredient = new ArrayList<ItemOrderInfo>();
        this.listChoiceSupplement = new ArrayList<OptionItemOrder>();
        this.listProducts = new ArrayList<ProductTicket>();
        this.m_FilerUtils = FilerUtils.getInstance();
        this.result = new Object[2];
        this.result[0] = false;
        this.result[1] = null;
        this.imagesViewProducts = new HashMap();
        this.paneAdditionnals = new ArrayList<Node>();
        this.image_additionnal_height = new ArrayList<Double>();
        this.image_additionnal_width = new ArrayList<Double>();
        Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/down_arrow.gif").toURI().toString(), 40.0, 30.0, false, false);
        Image imagebPrevious = new Image(this.getClass().getResource("/com/openbravo/images/up_arrow.gif").toURI().toString(), 40.0, 30.0, false, false);
        this.btn_additional_previous.setGraphic((Node)new ImageView(imagebPrevious));
        this.btn_additional_next.setGraphic((Node)new ImageView(imageNext));
        this.color_backgound = "#FFFFFF";
        this.MAX_LINE_ADDITIONNAL = AppLocal.type_borne.equals("horizontal") ? 2 : 3;
        this.MAX_COLUMN_ADDITIONNAL = 3;
        super.init();
        String title_additional = AppLocal.getIntString("Label.accompaniement");
        this.title.setText(this.global_additional_sales ? AppLocal.getIntString("Label.dessert") : title_additional.toUpperCase());
        this.size = 0;
        this.current_hour = new Date().getHours();
        for (ProductInfoExt product : this.itemsAdditionnals) {
            if (product.isHas_display_time() && (this.current_hour < product.getFirst_period() || this.current_hour >= product.getEnd_period())) continue;
            ++this.size;
        }
        if (this.size == 1) {
            this.btn_valid_additional.setText(AppLocal.getIntString("Button.add"));
            this.MAX_LINE_ADDITIONNAL = 1;
            this.MAX_COLUMN_ADDITIONNAL = 1;
            this.percent_height = 0.8;
            this.percent_width = 0.8;
            this.size_text = 20;
        } else if (this.size <= 4) {
            this.MAX_LINE_ADDITIONNAL = 2;
            this.MAX_COLUMN_ADDITIONNAL = 2;
            this.size_text = 18;
        } else {
            this.size_text = this.size <= 6 ? 14 : 12;
        }
        if (this.size <= 4) {
            this.width_popUp = AppVarUtils.getScreenDimension().getWidth() * 0.8;
            this.height_popUp = AppVarUtils.getScreenDimension().getHeight() * 0.7;
        } else {
            this.width_popUp = AppVarUtils.getScreenDimension().getWidth() * 0.9;
            this.height_popUp = AppVarUtils.getScreenDimension().getHeight() * 0.9;
        }
        this.WIDTH_VIEW_ADDITIONAL = this.width_popUp * 0.9;
        this.HEIGHT_VIEW_ADDITIONAL = this.height_popUp * 0.9 * 0.9 * 0.9;
        this.mItemService = ItemService.getInstance();
        this.loadAdditionnals();
        this.setTexts();
    }

    @Override
    public void init(Stage mStage) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProductAdditionalController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BasicException ex) {
            Logger.getLogger(ProductAdditionalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object object) {
        try {
            this.stage = mStage;
            if (object != null) {
                this.itemsAdditionnals = (List)object;
            }
            this.initializer();
        }
        catch (BasicException | URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        try {
            this.stage = mStage;
            if (objects != null) {
                this.global_additional_sales = (Boolean)objects[0];
                this.itemsAdditionnals = (List)objects[1];
                this.dlSales = (DataLogicSales)objects[2];
                this.dlItems = (DataLogicItems)objects[3];
                this.refProducts = (HashMap)objects[4];
                this.listChoiceAdditionnals = (List)objects[5];
                this.index_line = (Integer)objects[6];
                this.mTagInfo = (TagInfo)objects[7];
                this.refTags = (HashMap)objects[8];
            }
            this.initializer();
        }
        catch (BasicException | URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void valider() {
        if (this.size == 1 && this.selected_items != 0) {
            try {
                ProductInfoExt product = (ProductInfoExt)this.itemsAdditionnals.get(0).clone();
                this.result[1] = product;
                this.loadInfoProduct(product, false, this.listChoiceSupplement);
                this.result[0] = true;
                this.stage.close();
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            this.result[0] = false;
            this.stage.close();
        }
    }

    public void loadAdditionnals() throws BasicException {
        Pos postion_price = (Pos)this.price_positions.get(this.price_position);
        this.paneAdditionnals.clear();
        this.width_paneProduct = this.WIDTH_VIEW_ADDITIONAL / (double)this.MAX_COLUMN_ADDITIONNAL;
        this.height_paneProduct = this.HEIGHT_VIEW_ADDITIONAL / (double)this.MAX_LINE_ADDITIONNAL;
        this.image_additionnal_height.clear();
        this.image_additionnal_width.clear();
        this.imagesViewProducts.clear();
        this.width_paneProduct *= this.percent_width;
        this.height_paneProduct *= this.percent_height;
        this.loadImagesProducts(this.itemsAdditionnals);
        double height_items = this.HEIGHT_VIEW_ADDITIONAL;
        this.buttons_of_line = (int)(this.WIDTH_VIEW_ADDITIONAL / this.width_paneProduct);
        this.buttons_of_line = this.buttons_of_line > this.MAX_COLUMN_ADDITIONNAL ? this.MAX_COLUMN_ADDITIONNAL : this.buttons_of_line;
        this.max_lines = (int)Math.round(height_items / this.height_paneProduct);
        this.max_products = (int)this.max_lines * this.buttons_of_line;
        this.index_product = 0;
        if (this.size == 2) {
            Label first_label = new Label();
            first_label.setPrefHeight(this.height_paneProduct);
            first_label.setPrefWidth(this.width_paneProduct);
            this.paneAdditionnals.add((Node)first_label);
        }
        this.selected_items = 0;
        int number_products = this.size;
        boolean add_switch_button = number_products > this.max_products;
        for (ProductInfoExt product : this.itemsAdditionnals) {
            if (product.isHas_display_time() && (this.current_hour < product.getFirst_period() || this.current_hour >= product.getEnd_period())) continue;
            if (product.isMany_size() && (product.getListSizes() == null || product.getListSizes().isEmpty())) {
                product.setListSizes(this.dlItems.getProductSizes(product.getID(), true));
                this.mItemService.setSizes(product);
            }
            if (product.getPrices() == null || product.getPrices().isEmpty()) {
                product.setPrices(this.mItemService.getProductPrices(product.getID(), true));
            }
            this.addPreviousButton(add_switch_button, this.height_paneProduct, this.width_paneProduct);
            ImageView imageProduct = this.imagesViewProducts.get(product.getID()) != null ? this.imagesViewProducts.get(product.getID()) : null;
            int indice = this.indice_line_additional(product.getID(), this.index_line);
            this.mItemService.setPriceOfFirstSize(product, AppLocal.ticketBorne.getType());
            Image imageTag = null;
            System.out.println("++++++++++++ product.getmTagInfo() : " + product.getmTagInfo());
            System.out.println("++++++++++++ mTagInfo : " + this.mTagInfo);
            if (product.getmTagInfo() != null && this.mTagInfo != null && !Objects.equals(this.mTagInfo.getId(), product.getmTagInfo().getId())) {
                System.out.println("++++++++ product.getmTagInfo() 2 getLogo_tag : " + product.getmTagInfo().getLogo_tag());
                imageTag = this.getImageTag(product.getmTagInfo(), this.refTags);
            }
            System.out.println("+++++++++ imageTag : " + imageTag);
            PaneAdditional paneProduct = new PaneAdditional().product(product).height_additionnal(this.height_paneProduct).width_additionnal(this.width_paneProduct).price_position(postion_price).image_product(imageProduct).indice_line_additional(indice).image_tag(imageTag).build();
            if (paneProduct.getProperties().get((Object)"increaseQtt") != null) {
                ((Button)paneProduct.getProperties().get((Object)"increaseQtt")).setOnAction(this.mEventHandlerAddtionalIncreaseAction);
            }
            if (paneProduct.getProperties().get((Object)"decreaseQtt") != null) {
                ((Button)paneProduct.getProperties().get((Object)"decreaseQtt")).setOnAction(this.mEventHandlerAddtionalDecreaseAction);
            }
            if (paneProduct.getProperties().get((Object)"button") != null) {
                ((Button)paneProduct.getProperties().get((Object)"button")).setOnAction(this.mEventHandlerAddtionalAction);
            }
            if (this.existAdditionnal(product.getID()) != -1) {
                this.select(paneProduct);
                ++this.selected_items;
            } else {
                this.deselect(paneProduct);
            }
            this.paneAdditionnals.add((Node)paneProduct);
            this.addNextButton(add_switch_button, this.height_paneProduct, this.width_paneProduct, number_products);
            ++this.index_product;
        }
        if (this.size == 2) {
            Label last_label = new Label();
            last_label.setPrefHeight(this.height_paneProduct);
            last_label.setPrefWidth(this.width_paneProduct);
            this.paneAdditionnals.add((Node)last_label);
        }
        this.showAdditionals();
        this.pane_footer.getChildren().clear();
        if (this.selected_items > 0) {
            this.pane_footer.add((Node)this.btn_valid_additional, 0, 0);
        } else {
            this.pane_footer.add((Node)this.btn_retour, 0, 0);
        }
    }

    public void cancel() {
        this.stage.close();
    }

    private double getWidth_additionnals() {
        return AppVarUtils.getScreenDimension().getWidth() - 4.0 - (double)(5 * this.MAX_COLUMN_ADDITIONNAL);
    }

    private double getHeight_additionnals() {
        return AppVarUtils.getScreenDimension().getHeight() * 0.75 * 0.9;
    }

    public void addAdditionnal(ProductInfoExt product, GridPane paneProduct, Button btnProdcut, Label labelQtt) throws BasicException, URISyntaxException {
        if (this.existAdditionnal(product.getID()) == -1) {
            this.chooseAdditionnal(product, paneProduct, btnProdcut, labelQtt);
        } else {
            int indice_line_additional = this.indice_line_additional(product.getID(), this.index_line);
            if (indice_line_additional != -1) {
                AppLocal.ticketBorne.getLine(indice_line_additional).setMultiply(AppLocal.ticketBorne.getLine(indice_line_additional).getMultiply() + 1.0);
                labelQtt.setText(this.printMultiplity(AppLocal.ticketBorne.getLine(indice_line_additional).getMultiply()));
            }
        }
    }

    public void decreaseAdditionnal(ProductInfoExt product, GridPane paneProduct, Button btnProdcut, Label labelQtt) {
        int indice_line_additional;
        if (this.existAdditionnal(product.getID()) != -1 && (indice_line_additional = this.indice_line_additional(product.getID(), this.index_line)) != -1) {
            double unit = AppLocal.ticketBorne.getLine(indice_line_additional).getMultiply();
            if (unit == 1.0) {
                this.deselect(paneProduct);
                if (this.global_additional_sales) {
                    this.listChoiceAdditionnals.remove(this.existAdditionnal(product.getID()));
                }
                labelQtt.setText("");
                this.removeLine_additional(product);
            } else {
                AppLocal.ticketBorne.getLine(indice_line_additional).setMultiply(AppLocal.ticketBorne.getLine(indice_line_additional).getMultiply() - 1.0);
                labelQtt.setText(this.printMultiplity(AppLocal.ticketBorne.getLine(indice_line_additional).getMultiply()));
            }
        }
    }

    public int existAdditionnal(int product) {
        if (this.global_additional_sales) {
            int found = -1;
            int i = 0;
            for (ProductInfoExt item : this.listChoiceAdditionnals) {
                if (item.getID() == product) {
                    found = i;
                }
                ++i;
            }
            return found;
        }
        return this.indice_line_additional(product, this.index_line);
    }

    private void removeLine_additional(ProductInfoExt product) {
        int indice_line_additional = this.indice_line_additional(product.getID(), this.index_line);
        if (indice_line_additional != -1) {
            TicketLineInfo line = AppLocal.ticketBorne.getLine(indice_line_additional);
            AppLocal.ticketBorne.getLines().remove(line);
        }
    }

    public void chooseAdditionnal(ProductInfoExt product, GridPane paneProduct, Button btnProdcut, Label labelQtt) throws BasicException, URISyntaxException {
        ProductInfoExt chosen_product = (ProductInfoExt)product.clone();
        if (this.existAdditionnal(chosen_product.getID()) == -1) {
            this.select(paneProduct);
            labelQtt.setText("1");
            this.loadInfoProduct(chosen_product, false, this.listChoiceSupplement);
            if (chosen_product.getIngredients().size() > 0 || chosen_product.getSupplements().size() > 0) {
                this.loadAdditionelOptions(chosen_product);
            } else {
                ProductSizeInfo mProductSizeInfo = null;
                if (product.isMany_size() && product.getListSizes().size() > 0 && product.getListSizes().get(0) != null) {
                    mProductSizeInfo = product.getListSizes().get(0);
                }
                if (this.global_additional_sales) {
                    this.listChoiceAdditionnals.add(chosen_product);
                }
                this.addTicketLine(chosen_product, chosen_product.getPriceSell(), this.listChoiceSupplement, this.listChoiceIngredient, this.listProducts, this.global_additional_sales, mProductSizeInfo, null, 1, !this.global_additional_sales, false, this.index_line);
                this.pane_footer.getChildren().clear();
                this.pane_footer.add((Node)this.btn_valid_additional, 0, 0);
            }
        } else {
            this.deselect(paneProduct);
            if (this.global_additional_sales) {
                this.listChoiceAdditionnals.remove(this.existAdditionnal(chosen_product.getID()));
            }
            labelQtt.setText("");
            this.removeLine_additional(chosen_product);
        }
    }

    private double getMinHeightAdditionnal() {
        return this.HEIGHT_VIEW_ADDITIONAL / (double)this.MAX_LINE_ADDITIONNAL;
    }

    private void select(GridPane paneProduct) {
        if (paneProduct.getProperties().get((Object)"paneInfoProduct") != null) {
            GridPane paneInfoProduct = (GridPane)paneProduct.getProperties().get((Object)"paneInfoProduct");
            paneInfoProduct.setStyle("-fx-background-radius: 2em; -fx-background-color: " + this.color_hex + ";");
        }
        if (paneProduct.getProperties().get((Object)"button") != null) {
            Button btnProduct = (Button)paneProduct.getProperties().get((Object)"button");
            btnProduct.setStyle("-fx-background-color: transparent;-fx-text-fill: #ffffff;");
        }
        if (paneProduct.getProperties().get((Object)"name") != null) {
            Label nameProduct = (Label)paneProduct.getProperties().get((Object)"name");
            nameProduct.setStyle("-fx-font-size: " + this.size_text + "pt; -fx-text-fill: " + this.text_color_borne_hex + ";");
        }
        if (paneProduct.getProperties().get((Object)"priceProduct") != null) {
            Label priceProduct = (Label)paneProduct.getProperties().get((Object)"priceProduct");
            priceProduct.setStyle("-fx-font-size: 14pt; -fx-text-fill: " + this.text_color_borne_hex + "; -fx-border-color: " + this.color_hex + "; -fx-background-color: " + this.color_hex + ";");
        }
        if (paneProduct.getProperties().get((Object)"footer") != null) {
            GridPane paneFooter = (GridPane)paneProduct.getProperties().get((Object)"footer");
            paneFooter.getChildren().clear();
            int index = 0;
            if (paneProduct.getProperties().get((Object)"decreaseQtt") != null) {
                Button decreaseQtt = (Button)paneProduct.getProperties().get((Object)"decreaseQtt");
                paneFooter.add((Node)decreaseQtt, index++, 0);
            }
            if (paneProduct.getProperties().get((Object)"labelQtt") != null) {
                Label labelQtt = (Label)paneProduct.getProperties().get((Object)"labelQtt");
                paneFooter.add((Node)labelQtt, index++, 0);
            }
            if (paneProduct.getProperties().get((Object)"increaseQtt") != null) {
                Button increaseQtt = (Button)paneProduct.getProperties().get((Object)"increaseQtt");
                paneFooter.add((Node)increaseQtt, index++, 0);
            }
        }
    }

    private void deselect(GridPane paneProduct) {
        if (paneProduct.getProperties().get((Object)"paneInfoProduct") != null) {
            GridPane paneInfoProduct = (GridPane)paneProduct.getProperties().get((Object)"paneInfoProduct");
            paneInfoProduct.setStyle("-fx-background-color: transparent;");
        }
        if (paneProduct.getProperties().get((Object)"priceProduct") != null) {
            Label priceProduct = (Label)paneProduct.getProperties().get((Object)"priceProduct");
            priceProduct.setStyle("-fx-font-size: 14pt; -fx-text-fill: #ffffff; -fx-border-color: " + this.color_hex + "; -fx-background-color: " + this.color_hex + ";");
        }
        if (paneProduct.getProperties().get((Object)"button") != null) {
            Button btnProduct = (Button)paneProduct.getProperties().get((Object)"button");
            btnProduct.setStyle("-fx-background-color: transparent;-fx-text-fill: #000000;");
        }
        if (paneProduct.getProperties().get((Object)"name") != null) {
            Label nameProduct = (Label)paneProduct.getProperties().get((Object)"name");
            nameProduct.setStyle("-fx-font-size: " + this.size_text + "pt; -fx-text-fill: #000000;");
        }
        if (paneProduct.getProperties().get((Object)"footer") != null) {
            GridPane paneFooter = (GridPane)paneProduct.getProperties().get((Object)"footer");
            paneFooter.getChildren().clear();
        }
    }

    private void loadImagesProducts(List<ProductInfoExt> products) {
        double percent_height_image = AppLocal.HIDE_NAME_PRODUCTS ? 0.7 : 0.6;
        double heightImage = this.height_paneProduct * percent_height_image;
        double widthImage = this.width_paneProduct;
        for (ProductInfoExt product : products) {
            Image imageProduct = this.getImageProduct(product, "_512px");
            ImageView imageView = new ImageView();
            imageView.setImage(imageProduct);
            if (AppLocal.type_borne.equals("horizontal")) {
                imageView.setFitHeight(heightImage);
            } else {
                imageView.setFitWidth(widthImage);
            }
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
            imageView.setCache(true);
            this.image_additionnal_height.add(imageView.getBoundsInLocal().getHeight());
            this.image_additionnal_width.add(imageView.getBoundsInLocal().getWidth());
            this.imagesViewProducts.put(product.getID(), imageView);
        }
        if (AppLocal.type_borne != null) {
            if (AppLocal.type_borne.equals("horizontal")) {
                if (this.image_additionnal_width.size() > 0) {
                    this.width_paneProduct = this.getMax(this.image_additionnal_width);
                }
            } else if (this.image_additionnal_height.size() > 0) {
                this.height_paneProduct = this.getMax(this.image_additionnal_height) / percent_height_image;
                this.height_paneProduct = this.height_paneProduct < this.getMinHeightAdditionnal() ? this.getMinHeightAdditionnal() : this.height_paneProduct;
            }
        }
    }

    public void lastPaneAdditionnal() {
        if (this.page_additional > 0) {
            --this.page_additional;
            this.list_additional.getChildren().clear();
            this.list_additional.add((Node)this.panes_additionals[this.page_additional], 0, 0);
        }
    }

    public void nextPageAdditionnal() {
        if (this.page_additional < this.number_page_additional - 1) {
            ++this.page_additional;
            this.list_additional.getChildren().clear();
            this.list_additional.add((Node)this.panes_additionals[this.page_additional], 0, 0);
        }
    }

    private void showAdditionals() {
        this.rangAdditionals();
        this.pane_preview_additional.getChildren().clear();
        this.list_additional.getChildren().clear();
        this.pane_next_additional.getChildren().clear();
        if (this.number_page_additional > 0) {
            this.page_additional = 0;
            this.list_additional.add((Node)this.panes_additionals[this.page_additional], 0, 0);
        }
    }

    private void rangAdditionals() {
        this.number_page_additional = (int)Math.ceil((double)this.paneAdditionnals.size() / (this.max_lines * (double)this.buttons_of_line));
        System.out.println("++++++++++++++++ number_page_additional : " + this.number_page_additional);
        this.panes_additionals = new GridPane[this.number_page_additional];
        for (int i = 0; i < this.number_page_additional; ++i) {
            this.panes_additionals[i] = new GridPane();
            this.panes_additionals[i].setVgap(10.0);
            this.panes_additionals[i].setHgap(10.0);
            this.panes_additionals[i].setAlignment(Pos.CENTER);
            this.panes_additionals[i].setStyle("-fx-background-color: transparent;");
        }
        int index_item = 0;
        int column_item = 0;
        int row_item = 0;
        GridPane pane_line_items = this.getPaneLineItem();
        int step = 0;
        for (Node itemAdditional : this.paneAdditionnals) {
            pane_line_items.add(itemAdditional, column_item, 0);
            if (column_item < this.buttons_of_line - 1 && (this.size != 3 || step != 0)) {
                ++column_item;
            } else {
                this.panes_additionals[index_item].add((Node)pane_line_items, 0, row_item);
                if ((double)row_item < this.max_lines - 1.0) {
                    ++row_item;
                    column_item = 0;
                    pane_line_items = this.getPaneLineItem();
                } else {
                    ++index_item;
                    row_item = 0;
                    column_item = 0;
                    pane_line_items = this.getPaneLineItem();
                }
            }
            ++step;
        }
        if (pane_line_items.getChildren().size() > 0) {
            this.panes_additionals[index_item].add((Node)pane_line_items, 0, row_item);
        }
    }

    public void returnToCatalog() {
        this.result[0] = false;
        this.reset();
        this.stage.close();
    }

    private void loadAdditionelOptions(ProductInfoExt chosen_product) {
        this.result[0] = true;
        this.result[1] = chosen_product;
        this.reset();
        this.stage.close();
    }

    private int indice_line_additional(int id_additional, int index_line_parent) {
        return this.global_additional_sales ? super.indice_line_dessert(id_additional) : super.indice_line_additional_sale(id_additional, index_line_parent);
    }

    private void reset() {
        this.panes_additionals = null;
    }

    private void addPreviousButton(boolean add_switch_button, double height, double width) {
        boolean add_previous_button;
        boolean bl = add_previous_button = this.index_product != 0 && this.paneAdditionnals.size() % this.max_products == 0;
        if (add_switch_button && add_previous_button) {
            Button button_previous = this.getButtonPrevious(width, height);
            button_previous.setOnAction(this.mEventHandlerPreviousItems);
            this.paneAdditionnals.add((Node)button_previous);
        }
    }

    private void addNextButton(boolean add_switch_button, double height, double width, double number_products) {
        boolean add_next_button;
        boolean bl = add_next_button = (double)this.index_product != number_products - 1.0 && (this.paneAdditionnals.size() + 1) % this.max_products == 0;
        if (add_switch_button && add_next_button) {
            Button button_next = this.getButtonNext(width, height);
            button_next.setOnAction(this.mEventHandlerNextProducts);
            this.paneAdditionnals.add((Node)button_next);
        }
    }

    private void setTexts() {
        this.btn_retour.setText(AppLocal.getIntString("Button.no.thanks"));
        this.btn_valid_additional.setText(AppLocal.getIntString("Button.valid"));
    }
}

