/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.controllers.borne.Tagscontroller;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.services.TagsService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class PopUpCancelOrderBornecontroller
implements RootController {
    private JRootApp m_App;
    private Scene catalogScene;
    @FXML
    Button btn_sp;
    @FXML
    Button btn_emp;
    @FXML
    ImageView logo;
    @FXML
    GridPane center_pane;
    @FXML
    GridPane pane_type;
    @FXML
    FlowPane main_pane;
    @FXML
    VBox tags_pane;
    @FXML
    Button btn_no;
    @FXML
    Button btn_yes;
    @FXML
    Rectangle blankBox;
    @FXML
    VBox blankBoxVBox;
    @FXML
    Label message;
    private String fond_color_hex;
    private boolean cancel_order;
    private boolean authManager;
    private Stage stage;
    private List<Pos> blankBoxPositions;
    private int blankBoxPositionIndex = 0;
    private TagInfo tagInfo;
    private TagsService tagsService;
    private List<TagInfo> tags;
    private FilerUtils filerUtils;

    public void initializer() {
        String color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.fond_color_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
        this.message.setText(AppLocal.getIntString("Label.message.cancel.order"));
        this.btn_yes.setText(AppLocal.getIntString("Button.yes").toUpperCase());
        this.btn_no.setText(AppLocal.getIntString("Button.no").toUpperCase());
        this.blankBoxPositions = new ArrayList<Pos>(){
            {
                this.add(Pos.TOP_RIGHT);
                this.add(Pos.BOTTOM_RIGHT);
                this.add(Pos.BOTTOM_LEFT);
                this.add(Pos.TOP_LEFT);
                this.add(Pos.TOP_RIGHT);
            }
        };
        this.tagsService = TagsService.getInstance();
        this.filerUtils = FilerUtils.getInstance();
        this.loadTags();
    }

    public void agree() {
        this.cancel_order = true;
        this.stage.close();
    }

    public void disagree() {
        this.cancel_order = false;
        this.stage.close();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.initializer();
    }

    public boolean isCancel_order() {
        return this.cancel_order;
    }

    public boolean authAsManager() {
        return this.authManager;
    }

    public void moveBlankBox() {
        if (this.blankBoxPositionIndex == this.blankBoxPositions.size() - 1) {
            this.authManager = true;
            this.disagree();
        } else {
            ++this.blankBoxPositionIndex;
            this.blankBoxVBox.setAlignment(this.blankBoxPositions.get(this.blankBoxPositionIndex));
        }
    }

    public void chooseTag(TagInfo ti) {
        this.tagInfo = ti;
        this.cancel_order = false;
        this.stage.close();
    }

    public TagInfo getSelectedTag() {
        return this.tagInfo;
    }

    public void loadTags() {
        boolean canShowTags = false;
        if (AppLocal.SHOW_TAGS_IN_BORNE && !AppLocal.HIDE_TAGS_IN_CATALOG) {
            this.tags = this.tagsService.getActiveTags();
            boolean bl = canShowTags = this.tags != null && !this.tags.isEmpty();
        }
        if (canShowTags) {
            this.showTags();
        }
    }

    private void showTags() {
        if (this.tags != null) {
            int totalTags = this.tags.size();
            int nbTagPerRow = 3;
            int nbRows = (int)Math.ceil((double)totalTags / (double)nbTagPerRow);
            double tagBtnSize = 200.0;
            for (int i = 0; i < nbRows; ++i) {
                HBox hb = new HBox();
                hb.setStyle("-fx-background-color: transparent;");
                hb.setAlignment(Pos.CENTER);
                hb.setSpacing(30.0);
                int end = Math.min((i + 1) * nbTagPerRow, totalTags);
                for (int j = i * nbTagPerRow; j < end; ++j) {
                    hb.getChildren().add((Object)this.getTagButton(this.tags.get(j), tagBtnSize));
                }
                this.tags_pane.getChildren().add((Object)hb);
            }
            this.tags_pane.setVisible(true);
            this.tags_pane.setManaged(true);
        }
    }

    private Button getTagButton(TagInfo ti, double tagBtnSize) {
        Button buttonTag = new Button();
        buttonTag.setPrefHeight(tagBtnSize);
        buttonTag.setPrefWidth(tagBtnSize);
        buttonTag.setMaxSize(tagBtnSize, tagBtnSize);
        buttonTag.setMinSize(tagBtnSize, tagBtnSize);
        buttonTag.setStyle("-fx-border-radius: 50%; -fx-background-radius: 50%; -fx-background-color: transparent; -fx-border-color: transparent; -fx-text-fill: black; -fx-font-size: 22pt;");
        if (ti.getLogo_tag() != null && !ti.getLogo_tag().isEmpty()) {
            Image tagImage;
            File image = this.filerUtils.getFileFullPath("images/tags/" + ti.getLogo_tag());
            if (image.exists() && (tagImage = new Image(image.toURI().toString())).getException() == null) {
                ImageView imageView = new ImageView(tagImage);
                imageView.setFitHeight(buttonTag.getPrefHeight() * 0.9);
                imageView.setFitWidth(buttonTag.getPrefWidth() * 0.9);
                imageView.setPreserveRatio(false);
                imageView.setSmooth(false);
                if (ti.isClosed()) {
                    buttonTag.setGraphic((Node)Tagscontroller.getClosedTagStack(imageView, "15"));
                } else {
                    buttonTag.setGraphic((Node)imageView);
                }
            }
        } else {
            buttonTag.setWrapText(true);
            buttonTag.setText(ti.toString());
        }
        if (!ti.isClosed()) {
            buttonTag.setOnAction(e -> this.chooseTag(ti));
        }
        return buttonTag;
    }
}

