/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.TrackPayement;
import com.openbravo.cashlogy.services.CashLogyServices;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.borne.CatalogueController;
import com.openbravo.controllers.borne.EaselNumberController;
import com.openbravo.controllers.borne.MessageComptoirController;
import com.openbravo.controllers.borne.PaymentCBController;
import com.openbravo.controllers.borne.SummaryOrdercontroller;
import com.openbravo.controllers.selfCheckout.PaymentOrderSelfCheckout;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.tpeCB.PaymentByCardFacade;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;

public class PaymentOrdercontroller {
    private JRootApp m_App;
    @FXML
    ImageView logo;
    @FXML
    Button btn_cb;
    @FXML
    Button btn_comptoir;
    @FXML
    Button btn_cash;
    @FXML
    FlowPane parent_parent;
    @FXML
    GridPane pane_type;
    @FXML
    Button btn_cancel;
    @FXML
    Label title_payment;
    @FXML
    Button btn_valid;
    @FXML
    ImageView background;
    private String color_hex;
    private Scene catalogScene;
    private CatalogueController catalogueController;
    private SummaryOrdercontroller summaryOrdercontroller;
    private String fond_color_hex;
    Dimension dim = AppVarUtils.getScreenDimension();
    private PaymentCBController mPaymentCBController;
    private Scene paymentCBScene;
    private MessageComptoirController mMessageComptoirController;
    private Scene paymentComptoirScene;
    private TicketService mTicketService;
    private String easel_number_fxml = "/fx/templates/borne/popUp_easel_number.fxml";
    private LazyModal mLazyModalEaselNumber = null;
    private EventHiddenModal mActionEventEaselNumber = null;
    private Scene scene;
    private String bg_color_button_validation;
    private String bg_color_type_payment;
    private FilerUtils m_FilerUtils = null;
    private Image img_logo_fr;
    private Image img_logo_en;
    private Image img_logo_es;
    private Image img_logo_ar;
    private final String CB_PAYMENT = "cb_payment";
    private final String COUNTER_PAYMENT = "counter_payment";
    @FXML
    GridPane center_pane;
    private Image image_message_cashlogy;
    private Image image_background_message;
    private TrackPayement trackPayment;
    private Timer m_timer;

    public void initialize(JRootApp app, CatalogueController catalogueController, Scene paymentOrderScene) throws BasicException {
        this.m_App = app;
        this.scene = paymentOrderScene;
        this.catalogueController = catalogueController;
        this.catalogScene = catalogueController.getScene();
        this.mTicketService = TicketService.getInstance();
        this.mTicketService.setMPopUpTicketDateError(this.catalogScene);
        this.fond_color_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.bg_color_button_validation = ColorUtils.getColor(AppLocal.BG_COLOR_BUTTON_VALIDATION);
        this.bg_color_type_payment = ColorUtils.getColor(AppLocal.BG_COLOR_TYPE_PAYMENT);
        this.parent_parent.setStyle("-fx-background-color: " + this.bg_color_type_payment + ";");
        this.btn_cb.setStyle("-fx-background-color: transparent; -fx-text-fill: #ffffff;");
        this.btn_comptoir.setStyle("-fx-background-color: transparent; -fx-text-fill: #ffffff;");
        this.btn_cash.setStyle("-fx-background-color: transparent; -fx-text-fill: #ffffff;");
        this.title_payment.setStyle("-fx-text-fill: " + this.fond_color_hex + ";");
        this.btn_cancel.setStyle("-fx-text-fill: " + this.fond_color_hex + ";");
        this.m_FilerUtils = FilerUtils.getInstance();
        this.addIconToButton();
        this.btn_valid.setStyle("-fx-background-color: " + this.bg_color_button_validation + ";-fx-border-color: " + this.bg_color_button_validation + ";");
        this.image_message_cashlogy = null;
        this.image_background_message = null;
        this.pane_type.getChildren().clear();
        double pane_type_height = this.pane_type.getPrefHeight();
        boolean hide_btn_comptoire = AppLocal.HIDE_BUTTON_COMPTOIRE;
        System.out.println("*hide_btn_comptoirehide_btn_comptoire " + hide_btn_comptoire);
        if (AppLocal.CASHLOGY_ENABLED) {
            if (hide_btn_comptoire) {
                this.pane_type.add((Node)this.btn_cb, 0, 0);
                this.pane_type.add((Node)this.btn_cash, 1, 0);
                this.btn_cb.setPrefHeight(pane_type_height * 0.5);
                this.btn_cash.setPrefHeight(pane_type_height * 0.5);
            } else {
                this.pane_type.add((Node)this.btn_cb, 0, 0);
                this.pane_type.add((Node)this.btn_comptoir, 1, 0);
                this.pane_type.add((Node)this.btn_cash, 2, 0);
                this.btn_cb.setPrefHeight(pane_type_height * 0.33);
                this.btn_comptoir.setPrefHeight(pane_type_height * 0.33);
                this.btn_cash.setPrefHeight(pane_type_height * 0.33);
            }
        } else if (hide_btn_comptoire) {
            this.pane_type.add((Node)this.btn_cb, 0, 0);
            this.btn_cb.setPrefHeight(pane_type_height * 0.5);
        } else {
            this.pane_type.add((Node)this.btn_cb, 0, 0);
            this.pane_type.add((Node)this.btn_comptoir, 1, 0);
            this.btn_comptoir.setPrefHeight(pane_type_height * 0.5);
            this.btn_cb.setPrefHeight(pane_type_height * 0.5);
        }
    }

    public void chooseCB() {
        AppLocal.ticketBorne.setModePayment("CB");
        this.selected(this.btn_cb);
        this.deselected(this.btn_comptoir);
        this.deselected(this.btn_cash);
    }

    public void chooseCash() {
        AppLocal.ticketBorne.setModePayment("Espece");
        this.selected(this.btn_cash);
        this.deselected(this.btn_comptoir);
        this.deselected(this.btn_cb);
    }

    public void next() {
        if (AppLocal.ticketBorne.getModePayment() != null) {
            if (AppLocal.ticketBorne.getModePayment().equals("CB")) {
                int resultPing;
                PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
                if (facade.isTransactionSuccessed(resultPing = facade.doPing()) || AppLocal.CMI_TPE_PAYMENT) {
                    if (AppLocal.ADD_EASEL_NUMBER && AppLocal.ticketBorne.getType() != null && AppLocal.ticketBorne.getType().equalsIgnoreCase("Sur Place")) {
                        this.loadPopUpEaselNumber("cb_payment");
                    } else {
                        this.showPaymentCB();
                    }
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.device.payment.not.connected"), 4000, NPosition.CENTER);
                }
            } else if (AppLocal.ticketBorne.getModePayment().equals("Espece")) {
                if (AppLocal.CASHLOGY_ENABLED) {
                    try {
                        this.loadMessageAndDoPaymentCashlogy();
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(PaymentOrderSelfCheckout.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else if (AppLocal.ADD_EASEL_NUMBER && AppLocal.ticketBorne.getType() != null && AppLocal.ticketBorne.getType().equalsIgnoreCase("Sur Place")) {
                this.loadPopUpEaselNumber("counter_payment");
            } else {
                this.showMessageComptoir();
            }
        }
    }

    private void showPaymentCB() {
        if (this.mTicketService.isValidPeriodWithoutAlert()) {
            try {
                if (this.mPaymentCBController == null || this.paymentCBScene == null) {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/payment_cb.fxml"));
                    Parent rootNode = (Parent)loader.load();
                    this.mPaymentCBController = (PaymentCBController)loader.getController();
                    this.paymentCBScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                    this.paymentCBScene.getStylesheets().add((Object)"/styles/styles.css");
                    this.paymentCBScene.getStylesheets().add((Object)"/styles/app.css");
                    this.mPaymentCBController.initialize(this.m_App);
                }
                this.mPaymentCBController.setImage();
                this.m_App.getFxPanel().setScene(this.paymentCBScene);
                Platform.runLater(() -> this.mPaymentCBController.doPayementEndShowMessage(this.catalogueController));
            }
            catch (BasicException | IOException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void showMessageComptoir() {
        try {
            if (this.mMessageComptoirController == null || this.paymentComptoirScene == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/payment_message_comptoir.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mMessageComptoirController = (MessageComptoirController)loader.getController();
                this.paymentComptoirScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.paymentComptoirScene.getStylesheets().add((Object)"/styles/styles.css");
                this.paymentComptoirScene.getStylesheets().add((Object)"/styles/app.css");
                this.mMessageComptoirController.initialize(this.m_App);
            }
            this.mMessageComptoirController.setImageBackground();
            this.mMessageComptoirController.printOrderAndRestart();
            this.m_App.getFxPanel().setScene(this.paymentComptoirScene);
        }
        catch (BasicException | IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void chooseComptoir() {
        AppLocal.ticketBorne.setModePayment("Au Comptoir");
        this.selected(this.btn_comptoir);
        this.deselected(this.btn_cb);
        this.deselected(this.btn_cash);
    }

    public void deselected(Button btn) {
        if (btn.getProperties().containsKey((Object)"paneBackGround")) {
            GridPane paneBackGround = (GridPane)btn.getProperties().get((Object)"paneBackGround");
            paneBackGround.setStyle("-fx-background-color : transparent; -fx-border-radius: 1em; -fx-border-width: 2;");
        }
    }

    public void selected(Button btn) {
        if (btn.getProperties().containsKey((Object)"paneBackGround")) {
            GridPane paneBackGround = (GridPane)btn.getProperties().get((Object)"paneBackGround");
            paneBackGround.setStyle("-fx-border-color: #ffffff;; -fx-border-radius: 1em; -fx-border-width: 2;");
        }
    }

    private void addIconToButton() {
        try {
            double height_pane_button = this.dim.getHeight() * 0.15;
            System.out.println("++++++++++++height pane button : " + height_pane_button);
            ImageView imageCB = this.getImage("cb");
            ImageView imageComptoir = this.getImage("comptoir");
            ImageView imageCash = this.getImage("cash");
            double height = imageCB.getBoundsInLocal().getHeight() * 1.25 + 30.0;
            height = height_pane_button > height ? height_pane_button : height;
            this.buildButton(imageCB, AppLocal.getIntString("Button.bluecard"), this.btn_cb, height);
            this.buildButton(imageComptoir, AppLocal.getIntString("Button.atcounter"), this.btn_comptoir, height);
            this.buildButton(imageCash, AppLocal.getIntString("Button.cash"), this.btn_cash, height);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private ImageView getImage(String name_image) {
        ImageView image_back = null;
        try {
            double widthImage = this.dim.getWidth() * 0.25 * 0.8;
            Image img_logo = null;
            switch (name_image) {
                case "cb": {
                    File image_path;
                    String path_cb = AppLocal.ICON_CB;
                    if (path_cb != null && !path_cb.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path_cb)) != null && image_path.exists()) {
                        img_logo = new Image(image_path.toURI().toString());
                    }
                    if (img_logo != null) break;
                    img_logo = new Image(this.getClass().getResource("/com/openbravo/images/Cartebancaire.png").toURI().toString());
                    break;
                }
                case "comptoir": {
                    File image_path;
                    String path_counter = AppLocal.ICON_COUNTER;
                    if (path_counter != null && !path_counter.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path_counter)) != null && image_path.exists()) {
                        img_logo = new Image(image_path.toURI().toString());
                    }
                    if (img_logo != null) break;
                    img_logo = new Image(this.getClass().getResource("/com/openbravo/images/comptoire.png").toURI().toString());
                    break;
                }
                case "cash": {
                    img_logo = new Image(this.getClass().getResource("/com/openbravo/images/cash_image_borne.png").toURI().toString());
                }
            }
            if (img_logo != null) {
                image_back = new ImageView();
                image_back.setImage(img_logo);
                image_back.setFitWidth(widthImage);
                image_back.setPreserveRatio(true);
                image_back.setSmooth(true);
                image_back.setCache(true);
            }
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return image_back;
    }

    public void cancelPayment() {
        if (AppLocal.ticketBorne.getLabel_discount() != null && AppLocal.ticketBorne.getLabel_discount().equals("R\u00e9duction Avomark ")) {
            AppLocal.ticketBorne.setDiscount(0.0);
            AppLocal.ticketBorne.setLabel_discount(null);
        }
        AppLocal.ticketBorne.setDiscount(0.0);
        AppLocal.ticketBorne.setLabel_discount(null);
        if (this.m_App != null && this.m_App.getFxPanel() != null) {
            this.m_App.getFxPanel().setScene(this.catalogScene);
        }
    }

    private void buildButton(ImageView imageView, String name_button, Button button_type_payment, double height) {
        double width = this.dim.getWidth() * 0.25;
        System.out.println("+++++++++++ height button : " + height);
        GridPane pane = new GridPane();
        Label icon = new Label();
        Label title_button = new Label(name_button);
        pane.setPrefHeight(384.0);
        pane.setPrefWidth(width - 30.0);
        pane.setAlignment(Pos.CENTER);
        icon.setAlignment(Pos.CENTER);
        title_button.setAlignment(Pos.CENTER);
        title_button.setStyle("-fx-text-fill: #ffffff;");
        title_button.getStyleClass().add((Object)"text-size-18");
        title_button.setWrapText(true);
        icon.setPrefHeight(pane.getPrefHeight() * 0.8);
        icon.setPrefWidth(pane.getPrefWidth());
        System.out.println("++++++++++++++ height icon : " + icon.getPrefHeight());
        title_button.setPrefHeight(pane.getPrefHeight() * 0.2);
        title_button.setPrefWidth(pane.getPrefWidth());
        imageView.setStyle("-fx-border-color: #FC6666;");
        if (name_button.equals(AppLocal.getIntString("Button.cash"))) {
            imageView.setFitWidth(icon.getPrefHeight() * 0.7);
            imageView.setFitWidth(icon.getPrefWidth() * 0.7);
        }
        icon.setGraphic((Node)imageView);
        pane.add((Node)icon, 0, 0);
        pane.add((Node)title_button, 0, 1);
        GridPane paneBackGround = new GridPane();
        paneBackGround.setAlignment(Pos.CENTER);
        paneBackGround.setPrefHeight(height);
        paneBackGround.setPrefWidth(width);
        pane.setStyle("-fx-background-color : transparent; -fx-background-radius: 1em;");
        paneBackGround.setStyle("-fx-background-color : #transparent; -fx-background-radius: 1em;");
        paneBackGround.add((Node)pane, 0, 0);
        System.out.println("+++++++++++++ pane height : " + pane.getPrefHeight());
        System.out.println("++++++++++++ paneGround height : " + paneBackGround.getPrefHeight());
        button_type_payment.setGraphic((Node)paneBackGround);
        button_type_payment.setPrefHeight(height);
        button_type_payment.setMinHeight(height);
        button_type_payment.setMinWidth(width);
        button_type_payment.getProperties().put((Object)"paneBackGround", (Object)paneBackGround);
        button_type_payment.getProperties().put((Object)"title", (Object)title_button);
    }

    public void startPayment() {
        AppLocal.START_PAYMENT_BORNE = true;
        this.deselected(this.btn_cb);
        this.deselected(this.btn_comptoir);
        this.deselected(this.btn_cash);
        this.setTexts();
        if (this.btn_cb.getProperties().get((Object)"title") != null) {
            Label title_cb = (Label)this.btn_cb.getProperties().get((Object)"title");
            title_cb.setText(AppLocal.getIntString("Button.bluecard"));
        }
        if (this.btn_comptoir.getProperties().get((Object)"title") != null) {
            Label title_comptoir = (Label)this.btn_comptoir.getProperties().get((Object)"title");
            title_comptoir.setText(AppLocal.getIntString("Button.atcounter"));
        }
        this.setImage();
    }

    private void setTexts() {
        this.btn_cancel.setText(AppLocal.getIntString("Button.cancel"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid"));
        this.title_payment.setText(AppLocal.getIntString("Label.modepayement"));
    }

    public void loadPopUpEaselNumber(final String postAction) {
        try {
            this.mActionEventEaselNumber = new EventHiddenModal(){
                Object[] results;

                @Override
                public void onHidden() {
                    if (((Boolean)this.results[0]).booleanValue()) {
                        AppLocal.ticketBorne.setEasel_number((int)((Integer)this.results[1]));
                        switch (postAction) {
                            case "cb_payment": {
                                PaymentOrdercontroller.this.showPaymentCB();
                                break;
                            }
                            case "counter_payment": {
                                PaymentOrdercontroller.this.showMessageComptoir();
                            }
                        }
                    }
                    PaymentOrdercontroller.this.mLazyModalEaselNumber.destroyEvents();
                    PaymentOrdercontroller.this.mActionEventEaselNumber = null;
                    PaymentOrdercontroller.this.parent_parent.setEffect(null);
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        EaselNumberController mController = (EaselNumberController)mBuilder.getController();
                        this.results = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalEaselNumber == null) {
                this.mLazyModalEaselNumber = new LazyModal(StageStyle.UNDECORATED, this.scene, this.easel_number_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.7), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.55)));
            }
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.parent_parent.setEffect((Effect)blur);
            this.mLazyModalEaselNumber.setEventHiddenModal(this.mActionEventEaselNumber);
            this.mLazyModalEaselNumber.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setImage() {
        try {
            double heightImage = AppVarUtils.getScreenDimension().getHeight();
            Image img_logo = null;
            if (AppLocal.APP_LANGUAGE != null) {
                switch (AppLocal.APP_LANGUAGE) {
                    case "fr": {
                        File image_path;
                        if (this.img_logo_fr == null && AppLocal.BACKGROUND_TYPE_PAYMENT_FR != null && !AppLocal.BACKGROUND_TYPE_PAYMENT_FR.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + AppLocal.BACKGROUND_TYPE_PAYMENT_FR)) != null && image_path.exists()) {
                            this.img_logo_fr = new Image(image_path.toURI().toString());
                        }
                        img_logo = this.img_logo_fr;
                        break;
                    }
                    case "es": {
                        File image_path;
                        if (this.img_logo_es == null && AppLocal.BACKGROUND_TYPE_PAYMENT_ES != null && !AppLocal.BACKGROUND_TYPE_PAYMENT_ES.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + AppLocal.BACKGROUND_TYPE_PAYMENT_ES)) != null && image_path.exists()) {
                            this.img_logo_es = new Image(image_path.toURI().toString());
                        }
                        img_logo = this.img_logo_es;
                        break;
                    }
                    case "en": {
                        File image_path;
                        if (this.img_logo_en == null && AppLocal.BACKGROUND_TYPE_PAYMENT_EN != null && !AppLocal.BACKGROUND_TYPE_PAYMENT_EN.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + AppLocal.BACKGROUND_TYPE_PAYMENT_EN)) != null && image_path.exists()) {
                            this.img_logo_en = new Image(image_path.toURI().toString());
                        }
                        img_logo = this.img_logo_en;
                        break;
                    }
                    case "ar": {
                        File image_path;
                        if (this.img_logo_ar == null && AppLocal.BACKGROUND_TYPE_PAYMENT_AR != null && !AppLocal.BACKGROUND_TYPE_PAYMENT_AR.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + AppLocal.BACKGROUND_TYPE_PAYMENT_AR)) != null && image_path.exists()) {
                            this.img_logo_ar = new Image(image_path.toURI().toString());
                        }
                        img_logo = this.img_logo_ar;
                    }
                }
            }
            if (img_logo != null) {
                this.background.setImage(img_logo);
                this.background.setFitHeight(heightImage);
                this.background.setPreserveRatio(true);
                this.background.setSmooth(true);
                this.background.setCache(true);
                this.title_payment.setText("");
            } else {
                this.background.setImage(null);
                this.title_payment.setText(AppLocal.getIntString("Label.modepayement"));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadMessageAndDoPaymentCashlogy() throws URISyntaxException {
        System.out.println("**********loadMessageAndDoPaymentCashlogy ****************");
        this.center_pane.getChildren().clear();
        this.image_message_cashlogy = new Image(this.getClass().getResource("/com/openbravo/images/messageCashlogy.png").toURI().toString());
        this.background.setImage(this.image_message_cashlogy);
        Label labeltotal = new Label("Total : " + AppLocal.ticketBorne.printTotal());
        labeltotal.setStyle("-fx-font-family: 'Arial'; -fx-font-weight: bold; -fx-font-size: 40px; -fx-text-fill: white;");
        labeltotal.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.6);
        labeltotal.setPrefWidth(AppVarUtils.getScreenDimension().getWidth());
        labeltotal.setAlignment(Pos.BOTTOM_CENTER);
        this.center_pane.add((Node)labeltotal, 0, 1);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                PaymentOrdercontroller.this.doCashlogyPayment();
            }
        };
        scheduler.schedule(task, 2L, TimeUnit.SECONDS);
        scheduler.shutdown();
    }

    public void doCashlogyPayment() {
        try {
            TicketInfo tickinfo = (TicketInfo)AppLocal.ticketBorne.clone();
            double total = NumericUtils.round(tickinfo.getTotal());
            this.trackPayment = new TrackPayement(total);
            if (total > 0.0) {
                ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
                m_aPaymentInfo.add(new PaymentInfo("Cashlogy", this.trackPayment.getTotal(), 0.0));
                CashLogyServices mCashLogyServices = new CashLogyServices();
                String respense = mCashLogyServices.encaisserCommandeSelfcheckout(tickinfo.getNumberOrder(), NumericUtils.round(tickinfo.getTotal()), AppLocal.dlItems.getUserKeenIo());
                HashMap<String, Integer> encaisseHash = mCashLogyServices.Descreption(respense, tickinfo);
                Set<String> keySet = encaisseHash.keySet();
                if (!keySet.isEmpty()) {
                    String descreption = keySet.iterator().next();
                    Integer number_type = encaisseHash.get(descreption);
                    switch (number_type) {
                        case 1: {
                            this.encaisserOrder(tickinfo, m_aPaymentInfo);
                            this.ShowMessageCashLogy(descreption, false);
                            break;
                        }
                        case 2: {
                            System.out.println("+++++++++++++++++++CANCEL  ORDER CONTROLLER");
                            this.ShowMessageCashLogy(descreption, true);
                            break;
                        }
                        case 3: {
                            this.encaisserOrder(tickinfo, m_aPaymentInfo);
                            this.ShowMessageCashLogy(descreption, false);
                            break;
                        }
                        case 4: {
                            this.ShowMessageCashLogy(descreption, true);
                            break;
                        }
                        case 5: {
                            this.ShowMessageCashLogy(descreption, true);
                            break;
                        }
                        case 6: {
                            this.ShowMessageCashLogy(descreption, true);
                            break;
                        }
                        case 7: {
                            this.encaisserOrder(tickinfo, m_aPaymentInfo);
                            this.ShowMessageCashLogy(descreption, false);
                        }
                        case 8: {
                            this.ShowMessageCashLogy(descreption, true);
                            break;
                        }
                        case 9: {
                            this.encaisserOrder(tickinfo, m_aPaymentInfo);
                            this.ShowMessageCashLogy(descreption, false);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void ShowMessageCashLogy(String messageText, boolean reload_payments) {
        Platform.runLater(() -> {
            try {
                this.center_pane.setAlignment(Pos.CENTER);
                Label message = new Label(messageText);
                message.setPrefHeight(this.center_pane.getPrefHeight() * 0.5);
                message.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.9);
                message.setWrapText(true);
                message.setStyle("-fx-font-family: 'Arial'; -fx-font-weight: bold; -fx-font-size: 40px; -fx-text-fill: white;");
                message.setAlignment(Pos.CENTER);
                StackPane messagePane = new StackPane();
                messagePane.setAlignment(Pos.CENTER);
                DropShadow dropShadow = new DropShadow();
                dropShadow.setColor(Color.BLACK);
                dropShadow.setOffsetX(5.0);
                dropShadow.setOffsetY(5.0);
                dropShadow.setRadius(15.0);
                messagePane.setEffect((Effect)dropShadow);
                messagePane.getChildren().add((Object)message);
                this.center_pane.getChildren().clear();
                this.center_pane.getChildren().add((Object)messagePane);
                this.setImageBackGroundMessage();
                if (reload_payments) {
                    this.reload();
                } else {
                    this.loodHomePage();
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        });
    }

    private void setImageBackGroundMessage() throws URISyntaxException {
        double heightImage = AppVarUtils.getScreenDimension().getHeight();
        System.out.println("++++++++++++setImageBackGroundMessage ++++++++++++");
        if (this.image_background_message == null) {
            this.image_background_message = new Image(this.getClass().getResource("/com/openbravo/images/message_background.jpg").toURI().toString());
            this.background.setImage(this.image_background_message);
            this.background.setFitHeight(heightImage);
            this.background.setPreserveRatio(true);
            this.background.setSmooth(true);
            this.background.setCache(true);
        }
    }

    public void encaisserOrder(final TicketInfo ticket, final List<PaymentInfo> payments) {
        if (this.mTicketService.isValidPeriod() && ticket.getLinesCount() > 0) {
            try {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean add_ticket;
                            boolean send_to_kitchen = ticket.getNum_order_kitchen() == 0 || ticket.getNum_order_kitchen() == -1;
                            ArrayList<Integer> ids_tickets_borne = new ArrayList<Integer>();
                            ArrayList<Integer> ids_tickets_kitchen = new ArrayList<Integer>();
                            if (ticket.getId_shared_order() != 0) {
                                ids_tickets_borne.add(ticket.getId_shared_order());
                            }
                            if (ticket.getId_order_kitchen() != 0 && ticket.getId_order_kitchen() != -1) {
                                ids_tickets_kitchen.add(ticket.getId_order_kitchen());
                            }
                            if (add_ticket = PaymentOrdercontroller.this.mTicketService.validOrder(false, ticket, null, send_to_kitchen, ids_tickets_borne, null, true, payments, null, null, "paid", false, false, ids_tickets_kitchen)) {
                                TicketInfo ticketToSend = (TicketInfo)ticket.clone();
                                PaymentOrdercontroller.this.mTicketService.sendAndPrintOrder(ticketToSend, false, true, send_to_kitchen, true, false, null, true, null, "borne", true, null, true, false, false, "print paper", null);
                            }
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void loodHomePage() {
        this.m_timer = new Timer();
        this.m_timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        System.gc();
                        System.runFinalization();
                        PaymentOrdercontroller.this.m_App.showBorneWithoutCashlogy();
                        try {
                            PaymentOrdercontroller.this.m_App.mMainController.reStartPlayer();
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                });
            }
        }, 3000L);
    }

    public void reload() {
        this.m_timer = new Timer();
        this.m_timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PaymentOrdercontroller.this.catalogueController.showPayment();
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                });
            }
        }, 2000L);
    }
}

