/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.borne.CatalogueController;
import com.openbravo.controllers.borne.MessageCBController;
import com.openbravo.controllers.selfCheckout.SelfCheckoutController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.tpeCB.NepTag;
import fr.protactile.procaisse.tpeCB.PaymentByCardFacade;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import fr.protactile.procaisse.tpeCmi.TPECmi;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.Executors;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;

public class PaymentCBController {
    @FXML
    GridPane main_pane;
    @FXML
    ImageView background;
    @FXML
    Label text_message;
    private JRootApp m_App;
    private String color_hex;
    private String fond_color_hex;
    private Timer m_timer;
    private MessageCBController mMessageCBController;
    private Scene paymentScene;
    private String holder_ticket;
    private String lastTransactionId;
    private Image img_logo_ar;
    private FilerUtils m_FilerUtils = null;
    private Map<String, Image> mapBackgrounds = new HashMap<String, Image>();
    private Map<String, Image> mapResourceBackgrounds = new HashMap<String, Image>();
    private TicketService mTicketService;
    private TPECmi mTPECmi;

    public void initialize(JRootApp m_App) throws BasicException {
        this.m_App = m_App;
        this.mTicketService = TicketService.getInstance();
        this.fond_color_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.main_pane.setStyle("-fx-background-color: " + this.color_hex + ";");
        this.m_FilerUtils = FilerUtils.getInstance();
        this.mTPECmi = TPECmi.getInstance();
    }

    public void doPayementEndShowMessage(CatalogueController catalogueController) {
        TicketService ticketService = TicketService.getInstance();
        double total = NumericUtils.round(AppLocal.ticketBorne.getTotal());
        PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
        boolean payment_valid = false;
        boolean payment_cancled = false;
        Object message_cmi = null;
        if (AppLocal.NEPTING_AUTOMATE) {
            String[] results = facade.debitAutomate_Reservation(total);
            if (results != null && results.length > 0 && results[0] != null && results[0].equals("1")) {
                payment_valid = true;
                this.holder_ticket = results.length > 1 ? results[1] : null;
                ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
                m_aPaymentInfo.add(new PaymentInfo("CB", total, total));
                ticketService.saveTicketCBBorne(AppLocal.ticketBorne, m_aPaymentInfo);
                this.showMessage();
                String ref_to_close = results.length > 2 ? results[2] : null;
                String[] results_cloture = facade.debitAutomate_Cloture(total, ref_to_close);
                if (results_cloture != null && results_cloture.length > 0 && results_cloture[0] != null && results_cloture[0].equals("1")) {
                    this.holder_ticket = results_cloture.length > 1 ? results_cloture[1] : null;
                    AppLocal.ticketBorne.setHolder(this.holder_ticket);
                    ticketService.postSaveTicketCBBorne(AppLocal.ticketBorne, this.holder_ticket, AppLocal.currentCustomerLoyalty);
                } else {
                    AppLocal.ticketBorne.setHolder(this.holder_ticket);
                    ticketService.postSaveTicketCBBorne(AppLocal.ticketBorne, this.holder_ticket, AppLocal.currentCustomerLoyalty);
                    if (results_cloture != null && results_cloture.length > 2 && results_cloture[2] != null && NepTag.TIMEOUT_EXTENDEDRESULTS.contains(results_cloture[2])) {
                        facade.debitAutomate_ClotureNTry(total, ref_to_close);
                    }
                }
            }
        } else if (AppLocal.CMI_TPE_PAYMENT) {
            Object[] results = null;
            try {
                results = this.mTPECmi.dopaymentTPECmi(AppLocal.ticketBorne);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            if (results != null && results.length == 7) {
                boolean success = (Boolean)results[0];
                String message = String.valueOf(results[1]);
                final String ticket_cmi = String.valueOf(results[2]);
                String session_id = String.valueOf(results[3]);
                String ecr_stan = String.valueOf(results[4]);
                String eft_stan = String.valueOf(results[5]);
                String last4_digits = String.valueOf(results[6]);
                AppLocal.ticketBorne.setSession_id(session_id);
                AppLocal.ticketBorne.setEft_stan(eft_stan);
                AppLocal.ticketBorne.setTag_erc_stan(ecr_stan);
                AppLocal.ticketBorne.setLast_digit(last4_digits);
                AppLocal.ticketBorne.setEcrDateTime(AppLocal.CURRENT_ECR_DATE_TIME);
                if (success) {
                    payment_valid = true;
                    ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
                    m_aPaymentInfo.add(new PaymentInfo("CB", total, total));
                    this.mTicketService.encaisserOrderCB(AppLocal.ticketBorne, m_aPaymentInfo, "", AppLocal.currentCustomerLoyalty);
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, message, 1500, NPosition.BOTTOM_RIGHT);
                    if (ticket_cmi != null && !ticket_cmi.isEmpty()) {
                        final PrinterHelper printer = new PrinterHelper();
                        Executors.newSingleThreadExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                PaymentCBController.this.mTicketService.printCmiTicketPayment(printer, ticket_cmi, true);
                            }
                        });
                    }
                } else {
                    payment_cancled = true;
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, message, 1500, NPosition.BOTTOM_RIGHT);
                }
                this.showMessage();
            }
        } else {
            PaymentResult paymentResult = ticketService.paymentTPE(total, AppLocal.ticketBorne, this.lastTransactionId);
            if (paymentResult != null) {
                System.out.println("+++++++ holder_ticket 1 " + this.holder_ticket);
                if (paymentResult.isValid()) {
                    this.lastTransactionId = null;
                    payment_valid = true;
                    ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
                    if (paymentResult.getType_card() == null || paymentResult.getType_card().isEmpty()) {
                        String namePayment = AppLocal.MODULE_MEV || AppLocal.VERSION_CANADA || AppLocal.MODULE_TVA_GLOBAL ? "carte credit" : "CB";
                        paymentResult.setType_card(namePayment);
                    }
                    PaymentInfo payment = new PaymentInfo(paymentResult.getType_card(), total, total);
                    payment.setIdPaymentExterne(paymentResult.getId_payment());
                    m_aPaymentInfo.add(payment);
                    ticketService.encaisserOrderCB(AppLocal.ticketBorne, m_aPaymentInfo, paymentResult.getHolder_ticket(), AppLocal.currentCustomerLoyalty);
                    this.showMessage();
                } else {
                    this.lastTransactionId = paymentResult.getLast_transaction_id();
                }
            }
        }
        if (!payment_valid) {
            if (!payment_cancled) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Erreur de paiement, merci de r\u00e9essayer.", 4000, NPosition.CENTER);
            }
            catalogueController.validOrder(true);
        }
    }

    public void setImage() {
        try {
            String pathResourceBackground;
            double heightImage = 0.0;
            Image image_background = null;
            String pathBackground = this.getBackGround();
            if (pathBackground != null && !pathBackground.isEmpty() && (image_background = this.mapBackgrounds.get(pathBackground)) == null) {
                File image = null;
                image = this.m_FilerUtils.getFileFullPath("images/logos/" + pathBackground);
                if (image != null && image.exists()) {
                    image_background = new Image(image.toURI().toString());
                    this.mapBackgrounds.put(pathBackground, image_background);
                }
                heightImage = AppVarUtils.getScreenDimension().getHeight();
            }
            if (image_background == null && (pathResourceBackground = this.getResourceBackground()) != null && !pathResourceBackground.isEmpty() && (image_background = this.mapResourceBackgrounds.get(pathResourceBackground)) == null) {
                image_background = new Image(this.getClass().getResource("/com/openbravo/images/" + pathResourceBackground).toURI().toString());
                this.mapResourceBackgrounds.put(pathBackground, image_background);
                heightImage = AppVarUtils.getScreenDimension().getHeight() * 0.7;
            }
            if (image_background != null) {
                this.background.setImage(image_background);
                this.background.setFitHeight(heightImage);
                this.background.setPreserveRatio(true);
                this.background.setSmooth(true);
                this.background.setCache(true);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void showMessage() {
        System.out.println("show message");
        try {
            if (this.mMessageCBController == null || this.paymentScene == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/payment_message_cb.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mMessageCBController = (MessageCBController)loader.getController();
                this.paymentScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.paymentScene.getStylesheets().add((Object)"/styles/styles.css");
                this.paymentScene.getStylesheets().add((Object)"/styles/app.css");
                this.mMessageCBController.initialize(this.m_App);
            }
            this.mMessageCBController.setImageBackground();
            this.mMessageCBController.loadInfoOrder();
            this.m_App.getFxPanel().setScene(this.paymentScene);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private String getBackGround() {
        String path = null;
        if (AppLocal.APP_LANGUAGE != null) {
            switch (AppLocal.APP_LANGUAGE) {
                case "fr": {
                    if (AppLocal.IMAGE_INSERT_CARD_FR == null || AppLocal.IMAGE_INSERT_CARD_FR.isEmpty()) break;
                    path = AppLocal.IMAGE_INSERT_CARD_FR;
                    break;
                }
                case "en": {
                    if (AppLocal.IMAGE_INSERT_CARD_EN == null || AppLocal.IMAGE_INSERT_CARD_EN.isEmpty()) break;
                    path = AppLocal.IMAGE_INSERT_CARD_EN;
                    break;
                }
                case "ar": {
                    if (AppLocal.IMAGE_INSERT_CARD_AR == null || AppLocal.IMAGE_INSERT_CARD_AR.isEmpty()) break;
                    path = AppLocal.IMAGE_INSERT_CARD_AR;
                    break;
                }
                case "es": {
                    if (AppLocal.IMAGE_INSERT_CARD_ES == null || AppLocal.IMAGE_INSERT_CARD_ES.isEmpty()) break;
                    path = AppLocal.IMAGE_INSERT_CARD_ES;
                    break;
                }
                default: {
                    if (AppLocal.IMAGE_INSERT_CARD == null || AppLocal.IMAGE_INSERT_CARD.isEmpty()) break;
                    path = AppLocal.IMAGE_INSERT_CARD;
                }
            }
        }
        if (path == null && AppLocal.IMAGE_INSERT_CARD != null && !AppLocal.IMAGE_INSERT_CARD.isEmpty()) {
            path = AppLocal.IMAGE_INSERT_CARD;
        }
        return path;
    }

    private String getResourceBackground() {
        String path = AppLocal.getIntString("Image.payment.tpe");
        return path;
    }

    private void showMessageSelfCheckout() {
        try {
            if (this.mMessageCBController == null || this.paymentScene == null) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fx/templates/borne/payment_message_cb.fxml"));
                Parent rootNode = (Parent)loader.load();
                this.mMessageCBController = (MessageCBController)loader.getController();
                this.paymentScene = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                this.paymentScene.getStylesheets().add((Object)"/styles/styles.css");
                this.paymentScene.getStylesheets().add((Object)"/styles/app.css");
                this.mMessageCBController.initialize(this.m_App);
            }
            this.mMessageCBController.loadInfoOrderSelfCheckout();
            this.m_App.getFxPanel().setScene(this.paymentScene);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void doPayementEndShowMessageSelfCheckout(SelfCheckoutController mSelfCheckoutController) {
        TicketService ticketService = TicketService.getInstance();
        double total = NumericUtils.round(AppLocal.ticketBorne.getTotal());
        PaymentByCardFacade facade = PaymentByCardFacade.getInstance(this.m_App);
        boolean payment_valid = false;
        if (AppLocal.NEPTING_AUTOMATE) {
            String[] results = facade.debitAutomate_Reservation(total);
            if (results != null && results.length > 0 && results[0] != null && results[0].equals("1")) {
                payment_valid = true;
                this.holder_ticket = results.length > 1 ? results[1] : null;
                ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
                m_aPaymentInfo.add(new PaymentInfo("CB", total, total));
                ticketService.saveTicketCBBorne(AppLocal.ticketBorne, m_aPaymentInfo);
                this.showMessageSelfCheckout();
                String ref_to_close = results.length > 2 ? results[2] : null;
                String[] results_cloture = facade.debitAutomate_Cloture(total, ref_to_close);
                if (results_cloture != null && results_cloture.length > 0 && results_cloture[0] != null && results_cloture[0].equals("1")) {
                    this.holder_ticket = results_cloture.length > 1 ? results_cloture[1] : null;
                    ticketService.postSaveTicketCBBorne(AppLocal.ticketBorne, this.holder_ticket, AppLocal.currentCustomerLoyalty);
                } else {
                    ticketService.postSaveTicketCBBorne(AppLocal.ticketBorne, this.holder_ticket, AppLocal.currentCustomerLoyalty);
                    if (results_cloture != null && results_cloture.length > 2 && results_cloture[2] != null && NepTag.TIMEOUT_EXTENDEDRESULTS.contains(results_cloture[2])) {
                        facade.debitAutomate_ClotureNTry(total, ref_to_close);
                    }
                }
            }
        } else {
            PaymentResult paymentResult = ticketService.paymentTPE(total, AppLocal.ticketBorne, this.lastTransactionId);
            if (paymentResult != null) {
                String holder_ticket = paymentResult.getHolder_ticket();
                System.out.println("+++++++ holder_ticket 1 " + holder_ticket);
                if (paymentResult.isValid()) {
                    payment_valid = true;
                    if (paymentResult.getType_card() == null || paymentResult.getType_card().isEmpty()) {
                        String namePayment = AppLocal.MODULE_MEV || AppLocal.VERSION_CANADA || AppLocal.MODULE_TVA_GLOBAL ? "carte credit" : "CB";
                        paymentResult.setType_card(namePayment);
                    }
                    ArrayList<PaymentInfo> m_aPaymentInfo = new ArrayList<PaymentInfo>();
                    m_aPaymentInfo.add(new PaymentInfo(paymentResult.getType_card(), total, total));
                    ticketService.encaisserOrderCB(AppLocal.ticketBorne, m_aPaymentInfo, holder_ticket, AppLocal.currentCustomerLoyalty);
                    this.showMessageSelfCheckout();
                }
            }
        }
        if (!payment_valid) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Erreur de paiement, merci de r\u00e9essayer.", 4000, NPosition.CENTER);
            mSelfCheckoutController.validOrder();
        }
    }
}

