/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.controllers.borne.AbstractController;
import com.openbravo.controllers.borne.ProductAllergensController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.service.Pair;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class OptionAllergensController
extends AbstractController
implements RootController {
    private Stage stage;
    private Object[] result;
    @FXML
    FlowPane mainPane;
    @FXML
    Label labelImageOption;
    @FXML
    Label optionNameLabel;
    @FXML
    GridPane allergensPane;
    private String displayName;
    private ImageView imageOption;
    private String[] allergens;
    private final int numberByRow = 4;
    private String lightBgColor;
    private final double size = 140.0;
    private int mainPaneHeight;
    private int mainPaneWidth;

    public Object[] getResult() {
        return this.result;
    }

    private void initializer() throws URISyntaxException {
        this.lightBgColor = ColorUtils.getColorLight(AppLocal.color_borne, 0.1);
        this.setMainPaneSize();
        this.setProductView();
    }

    @Override
    public void init(Stage mStage) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProductAllergensController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object object) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProductAllergensController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        try {
            this.stage = mStage;
            if (objects != null) {
                this.displayName = (String)objects[0];
                this.imageOption = (ImageView)objects[1];
                this.allergens = (String[])objects[2];
            }
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(ProductAllergensController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void close() {
        System.out.println("++ close");
        this.stage.close();
    }

    private void setProductView() {
        this.optionNameLabel.setText(this.displayName);
        if (this.imageOption != null) {
            this.setImagePorduct();
        }
        this.paintValues();
    }

    private void setImagePorduct() {
        double labelImageProductSizeRatio = this.allergens.length <= 4 ? 0.4 : (this.allergens.length <= 12 ? 0.3 : 0.18);
        this.labelImageOption.setPrefHeight((double)this.mainPaneHeight * labelImageProductSizeRatio);
        double imageSize = (double)this.mainPaneHeight * (labelImageProductSizeRatio * 0.9);
        ImageView view = this.copyImageView(this.imageOption);
        this.createImageView(view, imageSize, imageSize);
        this.labelImageOption.setGraphic((Node)view);
    }

    private void createImageView(ImageView image_view, double heightImage, double widthImage) {
        if (AppLocal.type_borne.equals("horizontal")) {
            image_view.setFitHeight(heightImage);
        } else {
            image_view.setFitWidth(widthImage);
        }
        image_view.setPreserveRatio(true);
        image_view.setSmooth(true);
        image_view.setCache(true);
    }

    private void paintValues() {
        int numberOfRow = (int)Math.ceil((double)this.allergens.length / 4.0);
        for (int i = 0; i < numberOfRow; ++i) {
            int startIndex = i * 4;
            int endIndex = (i + 1) * 4;
            int trueEndIndex = Math.min(endIndex, this.allergens.length);
            for (int j = startIndex; j < trueEndIndex; ++j) {
                int col = j % 4;
                this.allergensPane.add((Node)this.getCirclePane(this.allergens[j]), col, i);
            }
        }
    }

    private VBox getCirclePane(String key) {
        Pair<String, String> nameAndPath = this.getNameAndPathByAllergenKey(key);
        VBox pane = new VBox();
        pane.setStyle("-fx-background-color: transparent; -fx-background-border: transparent; -fx-border-color: transparent;");
        pane.setPrefSize(140.0, 140.0);
        pane.setAlignment(Pos.CENTER);
        VBox vbox = new VBox();
        vbox.setStyle("-fx-background-color: " + this.lightBgColor + "; -fx-background-radius: 50em; -fx-border-color: transparent;");
        vbox.setAlignment(Pos.CENTER);
        double circleSize = 70.0;
        vbox.setPrefWidth(circleSize);
        vbox.setMaxWidth(circleSize);
        vbox.setPrefHeight(circleSize);
        vbox.setMaxHeight(circleSize);
        ImageView view = new ImageView(new Image(this.getClass().getResourceAsStream(nameAndPath.getSecond())));
        view.setPreserveRatio(true);
        double imageSize = circleSize * 0.7;
        view.setFitHeight(imageSize);
        view.setFitWidth(imageSize);
        view.setSmooth(true);
        view.setCache(true);
        vbox.getChildren().add((Object)view);
        Label nameLabel = new Label(nameAndPath.getFirst());
        nameLabel.setWrapText(true);
        nameLabel.setPrefWidth(100.0);
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setStyle("-fx-font-size: 13pt; -fx-text-fill: black; -fx-font-weight: bold; -fx-background-color: transparent; -fx-background-border: transparent; -fx-border-color: transparent;");
        pane.getChildren().add((Object)vbox);
        pane.getChildren().add((Object)nameLabel);
        return pane;
    }

    public Pair<String, String> getNameAndPathByAllergenKey(String key) {
        return switch (key) {
            case "gluten" -> Pair.create("Gluten", "/images/gluten.png");
            case "arachides" -> Pair.create("Arachides", "/images/arachides.png");
            case "celeri" -> Pair.create("Celeri", "/images/celeri.png");
            case "moutarde" -> Pair.create("Moutarde", "/images/moutarde.png");
            case "grainesSesame" -> Pair.create("Graines Sesame", "/images/grainesSesame.png");
            case "anhydrideSulfureux" -> Pair.create("Anhydride Sulfureux", "/images/anhydrideSulfureux.png");
            case "fruitsCoques" -> Pair.create("Fruits Coques", "/images/fruitsCoques.png");
            case "lait" -> Pair.create("Lait", "/images/lait.png");
            case "soja" -> Pair.create("Soja", "/images/soja.png");
            case "crustaces" -> Pair.create("Crustaces", "/images/crustaces.png");
            case "oeufs" -> Pair.create("Oeufs", "/images/oeufs.png");
            case "poisson" -> Pair.create("Poisson", "/images/poisson.png");
            case "lupin" -> Pair.create("Lupin", "/images/lupin.png");
            case "mollusques" -> Pair.create("Mollusques", "/images/mollusques.png");
            default -> null;
        };
    }

    public ImageView copyImageView(ImageView original) {
        ImageView copy = new ImageView(original.getImage());
        copy.setFitWidth(original.getFitWidth());
        copy.setFitHeight(original.getFitHeight());
        copy.setPreserveRatio(original.isPreserveRatio());
        copy.setSmooth(original.isSmooth());
        copy.setViewport(original.getViewport());
        copy.setClip(original.getClip());
        return copy;
    }

    private void setMainPaneSize() {
        double mainPaneHeightRatio = this.allergens.length <= 4 ? 0.4 : (this.allergens.length <= 8 ? 0.5 : 0.7);
        this.mainPaneWidth = (int)(AppVarUtils.getScreenDimension().getWidth() * 0.8);
        this.mainPaneHeight = (int)(AppVarUtils.getScreenDimension().getHeight() * mainPaneHeightRatio);
        this.mainPane.setPrefWidth((double)this.mainPaneWidth);
        this.mainPane.setPrefHeight((double)this.mainPaneHeight);
    }

    public void consumeClick(MouseEvent event) {
        System.out.println("++ consumed");
        event.consume();
    }
}

