/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.TicketService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;

public class MessageComptoirController {
    @FXML
    GridPane main_pane;
    @FXML
    ImageView background;
    private String color_hex;
    private DataLogicSales dlSales;
    private Timer m_timer;
    private FilerUtils m_FilerUtils = null;
    private TicketService ticketService;
    private Map<String, Image> mapBackgrounds = new HashMap<String, Image>();
    private Map<String, Image> mapResourceBackgrounds = new HashMap<String, Image>();
    public final SimpleDateFormat timeFormatter = new SimpleDateFormat("HHmmss");
    private JRootApp m_App;

    public void initialize(JRootApp m_App) throws BasicException {
        this.m_App = m_App;
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.main_pane.setStyle("-fx-background-color: " + this.color_hex + ";");
        this.m_FilerUtils = FilerUtils.getInstance();
        this.dlSales = (DataLogicSales)m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.ticketService = TicketService.getInstance();
    }

    private void printTicketCaisse(TicketInfo ticket) {
        this.ticketService.saveOrderBorne(ticket);
    }

    public void setImageBackground() {
        try {
            String pathResourceBackground;
            double heightImage = 0.0;
            Image image_background = null;
            String pathBackground = this.getBackGround();
            if (pathBackground != null && !pathBackground.isEmpty() && (image_background = this.mapBackgrounds.get(pathBackground)) == null) {
                File image = null;
                image = this.m_FilerUtils.getFileFullPath("images/logos/" + pathBackground);
                if (image != null && image.exists()) {
                    image_background = new Image(image.toURI().toString());
                    this.mapBackgrounds.put(pathBackground, image_background);
                }
                heightImage = AppVarUtils.getScreenDimension().getHeight();
            }
            if (image_background == null && (pathResourceBackground = this.getResourceBackground()) != null && !pathResourceBackground.isEmpty() && (image_background = this.mapResourceBackgrounds.get(pathResourceBackground)) == null) {
                image_background = new Image(this.getClass().getResource("/com/openbravo/images/" + pathResourceBackground).toURI().toString());
                this.mapResourceBackgrounds.put(pathBackground, image_background);
                heightImage = AppVarUtils.getScreenDimension().getHeight() * 0.7;
            }
            if (image_background != null) {
                this.background.setImage(image_background);
                this.background.setFitHeight(heightImage);
                this.background.setPreserveRatio(true);
                this.background.setSmooth(true);
                this.background.setCache(true);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void printOrderAndRestart() {
        String num_order_borne = this.timeFormatter.format(new Date()) + AppLocal.name_borne;
        AppLocal.ticketBorne.setNum_order_borne(num_order_borne);
        TicketInfo ticketToSend = (TicketInfo)AppLocal.ticketBorne.clone();
        this.printTicketCaisse(ticketToSend);
        this.m_timer = new Timer("Message Comptoir Timer (MessageComptoirController)- " + System.currentTimeMillis());
        this.m_timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        System.gc();
                        System.runFinalization();
                        MessageComptoirController.this.m_App.mMainController.reStartPlayer();
                        MessageComptoirController.this.m_App.showBorneWithoutCashlogy();
                    }
                });
            }
        }, 5000L);
        AppLocal.START_PAYMENT_BORNE = true;
    }

    private String getBackGround() {
        String path = null;
        if (AppLocal.APP_LANGUAGE != null) {
            switch (AppLocal.APP_LANGUAGE) {
                case "fr": {
                    if (AppLocal.IMAGE_VALID_ORDER_COUNTER_FR == null || AppLocal.IMAGE_VALID_ORDER_COUNTER_FR.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_COUNTER_FR;
                    break;
                }
                case "en": {
                    if (AppLocal.IMAGE_VALID_ORDER_COUNTER_EN == null || AppLocal.IMAGE_VALID_ORDER_COUNTER_EN.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_COUNTER_EN;
                    break;
                }
                case "ar": {
                    if (AppLocal.IMAGE_VALID_ORDER_COUNTER_AR == null || AppLocal.IMAGE_VALID_ORDER_COUNTER_AR.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_COUNTER_AR;
                    break;
                }
                case "es": {
                    if (AppLocal.IMAGE_VALID_ORDER_COUNTER_ES == null || AppLocal.IMAGE_VALID_ORDER_COUNTER_ES.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_COUNTER_ES;
                    break;
                }
                default: {
                    if (AppLocal.IMAGE_VALID_ORDER_COUNTER == null || AppLocal.IMAGE_VALID_ORDER_COUNTER.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_COUNTER;
                }
            }
        }
        if (path == null && AppLocal.IMAGE_VALID_ORDER_COUNTER != null && !AppLocal.IMAGE_VALID_ORDER_COUNTER.isEmpty()) {
            path = AppLocal.IMAGE_VALID_ORDER_COUNTER;
        }
        return path;
    }

    private String getResourceBackground() {
        String path = AppLocal.getIntString("Image.payment.caisse");
        return path;
    }

    public void printOrderAndRestartSelfCheckout() {
        String num_order_borne = this.timeFormatter.format(new Date()) + AppLocal.name_borne;
        AppLocal.ticketBorne.setNum_order_borne(num_order_borne);
        TicketInfo ticketToSend = (TicketInfo)AppLocal.ticketBorne.clone();
        this.printTicketCaisse(ticketToSend);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MessageComptoirController.this.m_App.showSelfcheckoutWithoutCashlogy();
            }
        };
        scheduler.schedule(task, 6L, TimeUnit.SECONDS);
        scheduler.shutdown();
        AppLocal.START_PAYMENT_BORNE = true;
    }
}

