/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;

public class MessageCBController {
    @FXML
    GridPane main_pane;
    @FXML
    Label num_order;
    @FXML
    Label text_message;
    @FXML
    ImageView background;
    @FXML
    GridPane pane_num_order;
    private String color_hex;
    private String color_text_number_order_cb;
    private Timer m_timer;
    private JRootApp m_App;
    private FilerUtils m_FilerUtils = null;
    private Map<String, Image> mapBackgrounds = new HashMap<String, Image>();
    private Map<String, Image> mapResourceBackgrounds = new HashMap<String, Image>();

    public void initialize(JRootApp m_App) throws BasicException {
        this.m_App = m_App;
        this.color_text_number_order_cb = ColorUtils.getColor(AppLocal.COLOR_TEXT_NUMBER_ORDER_CB);
        this.color_hex = ColorUtils.getColor(AppLocal.color_borne);
        this.main_pane.setStyle("-fx-background-color: " + this.color_hex + ";");
        int size_text = AppLocal.type_borne.equals("horizontal") ? 20 : AppLocal.SIZE_TEXT_NUMBER_ORDER_CB;
        System.out.println("size_text initialize : " + size_text);
        this.num_order.setStyle("-fx-text-fill: " + this.color_text_number_order_cb + "; -fx-font-size: " + size_text + "pt");
        this.m_FilerUtils = FilerUtils.getInstance();
    }

    public void setImageBackground() {
        try {
            double heightImage = 0.0;
            Image image_background = null;
            String pathBackground = this.getBackGround();
            if (pathBackground != null && !pathBackground.isEmpty() && (image_background = this.mapBackgrounds.get(pathBackground)) == null) {
                File image = null;
                image = this.m_FilerUtils.getFileFullPath("images/logos/" + pathBackground);
                if (image != null && image.exists()) {
                    image_background = new Image(image.toURI().toString());
                    this.mapBackgrounds.put(pathBackground, image_background);
                }
                heightImage = AppVarUtils.getScreenDimension().getHeight();
            }
            if (image_background != null) {
                this.pane_num_order.setAlignment(Pos.TOP_CENTER);
                this.pane_num_order.setPrefWidth(AppVarUtils.getScreenDimension().getWidth());
                this.pane_num_order.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.36);
                this.num_order.setPrefHeight(this.pane_num_order.getPrefHeight() * 0.32);
                this.num_order.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.3);
                this.num_order.setAlignment(Pos.CENTER);
            } else {
                String pathResourceBackground = this.getResourceBackground();
                if (pathResourceBackground != null && !pathResourceBackground.isEmpty() && (image_background = this.mapResourceBackgrounds.get(pathResourceBackground)) == null) {
                    image_background = new Image(this.getClass().getResource("/com/openbravo/images/" + pathResourceBackground).toURI().toString());
                    this.mapResourceBackgrounds.put(pathBackground, image_background);
                    heightImage = AppVarUtils.getScreenDimension().getHeight() * 0.8;
                }
                this.pane_num_order.setPrefWidth(AppVarUtils.getScreenDimension().getWidth());
                this.pane_num_order.setAlignment(Pos.CENTER_RIGHT);
                this.pane_num_order.setPrefHeight(AppVarUtils.getScreenDimension().getHeight());
                this.num_order.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.32);
                this.num_order.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.57);
                System.out.println("num_order width : " + this.num_order.getPrefWidth());
                this.num_order.setAlignment(Pos.TOP_LEFT);
            }
            if (image_background != null) {
                this.background.setImage(image_background);
                this.background.setFitHeight(heightImage);
                this.background.setPreserveRatio(true);
                this.background.setSmooth(true);
                this.background.setCache(true);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadInfoOrderSelfCheckout() {
        String orderNum;
        String string = orderNum = AppLocal.ticketBorne.getCaisse() != null ? AppLocal.ticketBorne.getCaisse() + AppLocal.ticketBorne.getNumero_order() : String.valueOf(AppLocal.ticketBorne.getNumero_order());
        if (AppLocal.ticketBorne.getNum_order_kitchen() != -1) {
            orderNum = AppLocal.ADD_HOUR_TO_NUMBER_ORDER ? AppLocal.ticketBorne.getNumberOrderWithHour(AppLocal.ticketBorne.getNum_order_kitchen()) : String.valueOf(AppLocal.ticketBorne.getNum_order_kitchen());
        }
        this.num_order.setText(orderNum);
        this.m_timer = new Timer();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MessageCBController.this.m_App.showSelfcheckoutWithoutCashlogy();
            }
        };
        scheduler.schedule(task, 6L, TimeUnit.SECONDS);
        scheduler.shutdown();
        AppLocal.START_PAYMENT_BORNE = true;
    }

    public void loadInfoOrder() {
        String orderNum;
        String string = orderNum = AppLocal.ticketBorne.getCaisse() != null ? AppLocal.ticketBorne.getCaisse() + AppLocal.ticketBorne.getNumero_order() : String.valueOf(AppLocal.ticketBorne.getNumero_order());
        if (AppLocal.ticketBorne.getNum_order_kitchen() != -1) {
            orderNum = AppLocal.ADD_HOUR_TO_NUMBER_ORDER ? AppLocal.ticketBorne.getNumberOrderWithHour(AppLocal.ticketBorne.getNum_order_kitchen()) : String.valueOf(AppLocal.ticketBorne.getNum_order_kitchen());
        }
        this.num_order.setText(orderNum);
        this.m_timer = new Timer();
        this.m_timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        System.gc();
                        System.runFinalization();
                        MessageCBController.this.m_App.mMainController.reStartPlayer();
                        MessageCBController.this.m_App.showBorneWithoutCashlogy();
                    }
                });
            }
        }, 10000L);
    }

    private String getBackGround() {
        String path = null;
        if (AppLocal.APP_LANGUAGE != null) {
            switch (AppLocal.APP_LANGUAGE) {
                case "fr": {
                    if (AppLocal.IMAGE_VALID_ORDER_CB_FR == null || AppLocal.IMAGE_VALID_ORDER_CB_FR.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_CB_FR;
                    break;
                }
                case "en": {
                    if (AppLocal.IMAGE_VALID_ORDER_CB_EN == null || AppLocal.IMAGE_VALID_ORDER_CB_EN.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_CB_EN;
                    break;
                }
                case "ar": {
                    if (AppLocal.IMAGE_VALID_ORDER_CB_AR == null || AppLocal.IMAGE_VALID_ORDER_CB_AR.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_CB_AR;
                    break;
                }
                case "es": {
                    if (AppLocal.IMAGE_VALID_ORDER_CB_ES == null || AppLocal.IMAGE_VALID_ORDER_CB_ES.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_CB_ES;
                    break;
                }
                default: {
                    if (AppLocal.IMAGE_VALID_ORDER_CB == null || AppLocal.IMAGE_VALID_ORDER_CB.isEmpty()) break;
                    path = AppLocal.IMAGE_VALID_ORDER_CB;
                }
            }
        }
        if (path == null && AppLocal.IMAGE_VALID_ORDER_CB != null && !AppLocal.IMAGE_VALID_ORDER_CB.isEmpty()) {
            path = AppLocal.IMAGE_VALID_ORDER_CB;
        }
        return path;
    }

    private String getResourceBackground() {
        String path = AppLocal.getIntString("Image.num.order.cb");
        return path;
    }
}

