/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.Pair;
import com.openbravo.service.SynchroService;
import com.openbravo.service.TicketService;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.GrandTotalPeriode;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javafx.animation.Interpolator;
import javafx.animation.PauseTransition;
import javafx.animation.RotateTransition;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.apache.commons.collections4.map.LinkedMap;

public class ManagerBorneSettingsController
implements RootController {
    private Stage stage;
    private Rectangle2D screenBounds;
    @FXML
    FlowPane settings_main_pane;
    @FXML
    FlowPane list_main_pane;
    @FXML
    FlowPane list_inner_pane;
    @FXML
    FlowPane confirmation_pane;
    @FXML
    FlowPane reason_pane;
    @FXML
    Button local_payment_btn;
    @FXML
    Button shutdown_btn;
    @FXML
    Button onseat_btn;
    @FXML
    Button remote_sync_btn;
    @FXML
    Button confirm_print;
    @FXML
    Button cancel_print;
    @FXML
    Button relaunch_btn;
    @FXML
    Button restart_btn;
    @FXML
    Button print_current_ticket_btn;
    @FXML
    Button print_current_z_btn;
    @FXML
    Button previous_tickets_date_btn;
    @FXML
    Button next_tickets_date_btn;
    @FXML
    Button not_confirm;
    @FXML
    Button yes_confirm;
    @FXML
    Button maintenance_btn;
    @FXML
    StackPane close_img_pane;
    @FXML
    StackPane tickets_img_pane;
    @FXML
    StackPane print_z_img_pane;
    @FXML
    StackPane local_payment_img_pane;
    @FXML
    StackPane shutdown_img_pane;
    @FXML
    StackPane onseat_img_pane;
    @FXML
    StackPane remote_sync_img_pane;
    @FXML
    StackPane relaunch_img_pane;
    @FXML
    StackPane restart_img_pane;
    @FXML
    StackPane maintenance_img_pane;
    @FXML
    Label info;
    @FXML
    Label sync_label;
    @FXML
    Label confirmation_label;
    @FXML
    Label ticketsPeriodDayLabel;
    @FXML
    HBox local_payment_toggler;
    @FXML
    HBox onseat_toggler;
    @FXML
    HBox header_box;
    @FXML
    HBox tickets_filter_box;
    @FXML
    HBox z_filter_box;
    @FXML
    HBox confirm_buttons_box;
    @FXML
    HBox maintenance_toggler;
    @FXML
    ScrollPane list_pane;
    @FXML
    ImageView sync_succeded_img;
    @FXML
    ImageView sync_pending_img;
    @FXML
    ImageView sync_failed_img;
    @FXML
    ComboBox zMonthsBox;
    @FXML
    ComboBox zTypesBox;
    @FXML
    ComboBox zYearsBox;
    @FXML
    ComboBox ticketsMonthsBox;
    @FXML
    ComboBox ticketsYearsBox;
    @FXML
    TextArea print_reason_field;
    private String terminal_light_color_hex;
    private String terminal_color_hex;
    private AppConfig config;
    private boolean lock = false;
    private boolean printing = false;
    private TicketService ticketService;
    private SynchroService synchroService;
    private List<FlowPane> panes;
    private TicketInfo currentTicket;
    private GrandTotalPeriode currentGTP;
    private List<TicketInfo> tickets;
    private SimpleDateFormat dateFormat;
    private Date ticketsFilterDate;
    private int zPeriodMonth;
    private int zPeriodYear;
    private int ticketsPeriodDay;
    private int ticketsPeriodMonth;
    private int ticketsPeriodYear;
    private String zPeriodType;
    private List<GrandTotalPeriode> gtps;
    private LinkedMap<String, Integer> months;
    private List<String> types;
    private List<Integer> years;
    private Label emptyList;
    private Integer action;
    private final String mainColor = "24,238,17";
    private Date dateEnd;
    private Date dateStart;

    public void initializer() {
        this.setStagePosition();
        this.config = AppConfig.getInstance();
        this.dateFormat = new SimpleDateFormat("dd-MM-yy HH:mm");
        this.panes = new ArrayList(){
            {
                this.add(ManagerBorneSettingsController.this.settings_main_pane);
                this.add(ManagerBorneSettingsController.this.list_main_pane);
                this.add(ManagerBorneSettingsController.this.confirmation_pane);
                this.add(ManagerBorneSettingsController.this.reason_pane);
            }
        };
        this.terminal_color_hex = ColorUtils.getColor("24,238,17");
        this.terminal_light_color_hex = ColorUtils.getColorLight("24,238,17", 0.1);
        this.tickets_img_pane.setStyle(this.getCircularPanesStyle(false));
        this.print_z_img_pane.setStyle(this.getCircularPanesStyle(false));
        this.local_payment_img_pane.setStyle(this.getCircularPanesStyle(false));
        this.onseat_img_pane.setStyle(this.getCircularPanesStyle(false));
        this.remote_sync_img_pane.setStyle(this.getCircularPanesStyle(false));
        this.relaunch_img_pane.setStyle(this.getCircularPanesStyle(false));
        this.restart_img_pane.setStyle(this.getCircularPanesStyle(false));
        this.shutdown_img_pane.setStyle(this.getCircularPanesStyle(true));
        this.close_img_pane.setStyle(this.getCloseButtonPaneStyle());
        this.maintenance_img_pane.setStyle(this.getCircularPanesStyle(false));
        this.print_current_ticket_btn.setStyle(this.getPrintButtonStyle());
        this.print_current_z_btn.setStyle(this.getPrintButtonStyle());
        this.local_payment_btn.setOnAction(e -> this.toggleButton(this.local_payment_toggler));
        this.onseat_btn.setOnAction(e -> this.toggleButton(this.onseat_toggler));
        this.maintenance_btn.setOnAction(e -> this.toggleButton(this.maintenance_toggler));
        this.shutdown_btn.setOnAction(e -> this.triggerAction(1));
        this.restart_btn.setOnAction(e -> this.triggerAction(2));
        this.relaunch_btn.setOnAction(e -> this.triggerAction(3));
        this.yes_confirm.setOnAction(e -> this.confirmAction());
        this.not_confirm.setOnAction(e -> this.cancelAction());
        this.confirm_print.setOnAction(e -> this.confirmPrint());
        this.cancel_print.setOnAction(e -> this.cancelPrint());
        this.next_tickets_date_btn.setOnAction(e -> this.setTicketsList(1));
        this.previous_tickets_date_btn.setOnAction(e -> this.setTicketsList(-1));
        this.ticketService = TicketService.getInstance();
        this.synchroService = SynchroService.getInstance();
        this.initTogglers();
        this.initEmptyLabel();
        this.disableScrollBars();
        this.initZFilter();
        this.initTicketsFilter();
        this.initConfirmStyle();
        this.checkSyncAvailability();
    }

    public void close() {
        if (this.lock) {
            return;
        }
        this.config.save();
        AppLocal.BORNE_IN_MAINTENANCE = this.maintenance_toggler.getAlignment().equals((Object)Pos.CENTER_RIGHT);
        AppLocal.ONLY_TAKE_AWAY_BORNE = this.onseat_toggler.getAlignment().equals((Object)Pos.CENTER_LEFT);
        AppLocal.PAYMENT_BORNE = this.local_payment_toggler.getAlignment().equals((Object)Pos.CENTER_RIGHT);
        this.stage.close();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.initializer();
    }

    private void setStagePosition() {
        this.screenBounds = AppLocal.MACHINE_SCREENMODE.equals("fullscreen") ? Screen.getPrimary().getBounds() : Screen.getPrimary().getVisualBounds();
        this.stage.show();
        this.stage.setX((this.screenBounds.getWidth() - this.stage.getWidth()) / 2.0);
        this.stage.setY(this.screenBounds.getHeight() - this.stage.getHeight());
    }

    private void initTogglers() {
        this.setTogglerStatus(this.local_payment_toggler, this.getTogglerPosition(AppLocal.PAYMENT_BORNE));
        this.setTogglerStatus(this.onseat_toggler, this.getTogglerPosition(!AppLocal.ONLY_TAKE_AWAY_BORNE));
        this.setTogglerStatus(this.maintenance_toggler, this.getTogglerPosition(AppLocal.BORNE_IN_MAINTENANCE));
    }

    public void toggleButton(HBox toggler) {
        if (this.lock) {
            return;
        }
        if (toggler.getAlignment() == Pos.CENTER_LEFT) {
            this.setTogglerStatus(toggler, Pos.CENTER_RIGHT);
            this.setSettings(toggler.getId(), true);
        } else if (toggler.getAlignment() == Pos.CENTER_RIGHT) {
            this.setTogglerStatus(toggler, Pos.CENTER_LEFT);
            this.setSettings(toggler.getId(), false);
        }
    }

    public void setTogglerStatus(HBox toggler, Pos position) {
        toggler.setAlignment(position);
        if (position == Pos.CENTER_LEFT) {
            toggler.setStyle("-fx-border-color: transparent; -fx-padding: 0 3 0 3; -fx-background-radius: 50px; -fx-border-radius: 50px; -fx-background-color: lightgray;");
        } else if (position == Pos.CENTER_RIGHT) {
            toggler.setStyle("-fx-border-color: transparent; -fx-padding: 0 3 0 3; -fx-background-radius: 50px; -fx-border-radius: 50px; -fx-background-color: " + this.terminal_color_hex + ";");
        }
    }

    public void setSettings(String togglerId, boolean checked) {
        if (togglerId.equals(this.onseat_toggler.getId())) {
            this.config.setProperty("only.take.away.borne", this.getStringProperty(!checked));
        }
        if (togglerId.equals(this.local_payment_toggler.getId())) {
            this.config.setProperty("payment.borne", this.getStringProperty(checked));
        }
        if (togglerId.equals(this.maintenance_toggler.getId())) {
            this.config.setProperty("borne.in.maintenance", this.getStringProperty(checked));
        }
    }

    public String getStringProperty(boolean checked) {
        return checked ? "yes" : "no";
    }

    public Pos getTogglerPosition(boolean checked) {
        return checked ? Pos.CENTER_RIGHT : Pos.CENTER_LEFT;
    }

    public void shutdown() {
        this.config.save();
        ManagerBorneSettingsController.executeShutdownCmd("-s");
    }

    public void relaunch() {
        this.config.save();
        this.synchroService.relaunchSoftware();
    }

    public void restart() {
        this.config.save();
        ManagerBorneSettingsController.executeShutdownCmd("-r");
    }

    public void synchronize() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        System.out.println("+++++++++ synchronizing...");
        this.sync_pending_img.setVisible(true);
        this.sync_label.setText("Synchronisation...");
        final RotateTransition rotate = new RotateTransition();
        rotate.setNode((Node)this.sync_pending_img);
        rotate.setByAngle(360.0);
        rotate.setCycleCount(-1);
        rotate.setDuration(Duration.seconds((double)2.0));
        rotate.setInterpolator(Interpolator.LINEAR);
        rotate.play();
        Task<Void> task = new Task<Void>(){

            protected Void call() throws BasicException, IOException, SQLException {
                ManagerBorneSettingsController.this.synchroService.synchronize(true, true, true);
                return null;
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    rotate.stop();
                    ManagerBorneSettingsController.this.sync_pending_img.setVisible(false);
                    ManagerBorneSettingsController.this.sync_succeded_img.setVisible(true);
                    ManagerBorneSettingsController.this.sync_succeded_img.setManaged(true);
                    ManagerBorneSettingsController.this.sync_label.setText("Synchronisation effectu\u00e9e !");
                });
                PauseTransition pause = new PauseTransition(Duration.seconds((double)3.0));
                pause.setOnFinished(e -> ManagerBorneSettingsController.this.onSyncFinished());
                pause.play();
            }

            protected void failed() {
                Platform.runLater(() -> {
                    rotate.stop();
                    ManagerBorneSettingsController.this.sync_pending_img.setVisible(false);
                    ManagerBorneSettingsController.this.sync_failed_img.setVisible(true);
                    ManagerBorneSettingsController.this.sync_failed_img.setManaged(true);
                    ManagerBorneSettingsController.this.sync_label.setText("\u00c9chec de synchronisation !");
                });
                PauseTransition pause = new PauseTransition(Duration.seconds((double)3.0));
                pause.setOnFinished(e -> ManagerBorneSettingsController.this.onSyncFinished());
                pause.play();
            }
        };
        new Thread((Runnable)task).start();
    }

    public void onSyncFinished() {
        Platform.runLater(() -> {
            this.sync_succeded_img.setVisible(false);
            this.sync_succeded_img.setManaged(false);
            this.sync_failed_img.setVisible(false);
            this.sync_failed_img.setManaged(false);
            this.sync_label.setText("Synchroniser");
            this.lock = false;
        });
    }

    public void printTickets() {
        if (this.lock) {
            return;
        }
        this.print_current_z_btn.setVisible(false);
        this.print_current_z_btn.setManaged(false);
        this.z_filter_box.setVisible(false);
        this.z_filter_box.setManaged(false);
        this.print_current_ticket_btn.setVisible(true);
        this.print_current_ticket_btn.setManaged(true);
        this.tickets_filter_box.setVisible(true);
        this.tickets_filter_box.setManaged(true);
        this.showListPane(true);
    }

    public void setTicketsList(Integer day) {
        if (day == null) {
            this.ticketsFilterDate.setDate(this.ticketsPeriodDay);
            this.ticketsFilterDate.setMonth(this.ticketsPeriodMonth - 1);
            this.ticketsFilterDate.setYear(this.ticketsPeriodYear - 1900);
        } else {
            DateUtils.addDays(this.ticketsFilterDate, day);
            this.ticketsPeriodDay = this.ticketsFilterDate.getDate();
            this.ticketsPeriodMonth = this.ticketsFilterDate.getMonth() + 1;
            this.ticketsPeriodYear = this.ticketsFilterDate.getYear() + 1900;
        }
        this.list_inner_pane.getChildren().clear();
        this.refreshDateFilterView();
        System.out.println("++++ loading tickets for : " + this.ticketsFilterDate.toString());
        try {
            this.tickets = Objects.requireNonNullElse(AppLocal.dlSales.getTicketsByPeriode("j", this.ticketsFilterDate), new ArrayList());
        }
        catch (BasicException be) {
            LogToFile.log("severe", be.getMessage(), be);
            this.tickets = new ArrayList<TicketInfo>();
        }
        this.refreshListPaneView(true);
    }

    public void setGTPList() {
        this.list_inner_pane.getChildren().clear();
        System.out.println("++++ loading clotures for month: " + this.zPeriodMonth + ", year: " + this.zPeriodYear);
        try {
            this.gtps = Objects.requireNonNullElse(AppLocal.dlItems.loadGrandTotalPeriodByDate(this.zPeriodMonth, this.zPeriodYear, this.zPeriodType), new ArrayList());
        }
        catch (BasicException be) {
            LogToFile.log("severe", be.getMessage(), be);
            this.gtps = new ArrayList<GrandTotalPeriode>();
        }
        this.refreshListPaneView(false);
    }

    public void refreshListPaneView(boolean fromTickets) {
        this.list_inner_pane.getChildren().clear();
        if (fromTickets) {
            if (this.tickets.isEmpty()) {
                this.emptyList.setText("Aucun ticket.");
                this.list_inner_pane.setAlignment(Pos.CENTER);
                this.list_inner_pane.getChildren().add((Object)this.emptyList);
            } else {
                this.list_inner_pane.setAlignment(Pos.TOP_CENTER);
                for (TicketInfo ticketInfo : this.tickets) {
                    this.list_inner_pane.getChildren().add((Object)this.getViewBox(ticketInfo));
                }
            }
        } else if (this.gtps.isEmpty()) {
            this.emptyList.setText("Aucune cloture.");
            this.list_inner_pane.setAlignment(Pos.CENTER);
            this.list_inner_pane.getChildren().add((Object)this.emptyList);
        } else {
            this.list_inner_pane.setAlignment(Pos.TOP_CENTER);
            for (GrandTotalPeriode gtp : this.gtps) {
                this.list_inner_pane.getChildren().add((Object)this.getViewBox(gtp));
            }
        }
    }

    public HBox getViewBox(TicketInfo ticketInfo) {
        HBox hBox = new HBox();
        hBox.setId(ticketInfo.getId());
        double width = this.list_inner_pane.getWidth();
        String bg = "whitesmoke";
        if (this.currentTicket != null && ticketInfo.getId().equals(this.currentTicket.getId())) {
            bg = this.terminal_light_color_hex;
        }
        hBox.setPrefWidth(width);
        hBox.setStyle("-fx-background-color: " + bg + "; -fx-border-radius: 20px; -fx-border-color: transparent; -fx-background-radius: 20px; -fx-padding: 10px;");
        Pane pane = new Pane();
        Pane pane1 = new Pane();
        pane.setPrefWidth(width * 0.06);
        pane1.setPrefWidth(width * 0.06);
        Pair<VBox, VBox> boxes = this.getInfoBoxes(ticketInfo, width * 0.325);
        hBox.getChildren().add(0, (Object)this.getImageView(width));
        hBox.getChildren().add(1, (Object)pane);
        hBox.getChildren().add(2, (Object)((Node)boxes.getFirst()));
        hBox.getChildren().add(3, (Object)pane1);
        hBox.getChildren().add(4, (Object)((Node)boxes.getSecond()));
        hBox.setOnMouseClicked(e -> this.selectTicket(ticketInfo));
        hBox.setAlignment(Pos.CENTER_LEFT);
        return hBox;
    }

    public HBox getViewBox(GrandTotalPeriode gtp) {
        HBox hBox = new HBox();
        hBox.setId(gtp.getId());
        double width = this.list_inner_pane.getWidth();
        String bg = "whitesmoke";
        if (this.currentGTP != null && gtp.getId().equals(this.currentGTP.getId())) {
            bg = this.terminal_light_color_hex;
        }
        hBox.setPrefWidth(width);
        hBox.setStyle("-fx-background-color: " + bg + "; -fx-border-radius: 20px; -fx-border-color: transparent; -fx-background-radius: 20px; -fx-padding: 10px;");
        Pane pane = new Pane();
        Pane pane1 = new Pane();
        pane.setPrefWidth(width * 0.06);
        pane1.setPrefWidth(width * 0.06);
        Pair<VBox, VBox> boxes = this.getInfoBoxes(gtp, width * 0.325);
        hBox.getChildren().add(0, (Object)this.getImageView(width));
        hBox.getChildren().add(1, (Object)pane);
        hBox.getChildren().add(2, (Object)((Node)boxes.getFirst()));
        hBox.getChildren().add(3, (Object)pane1);
        hBox.getChildren().add(4, (Object)((Node)boxes.getSecond()));
        hBox.setOnMouseClicked(e -> this.selectGTP(gtp));
        hBox.setAlignment(Pos.CENTER_LEFT);
        return hBox;
    }

    public void selectTicket(TicketInfo ticketInfo) {
        this.currentTicket = this.currentTicket != null && this.currentTicket.getId().equals(ticketInfo.getId()) ? null : ticketInfo;
        this.refreshListPaneView(true);
    }

    public void selectGTP(GrandTotalPeriode gtp) {
        this.currentGTP = this.currentGTP != null && this.currentGTP.getId().equals(gtp.getId()) ? null : gtp;
        this.refreshListPaneView(false);
    }

    public void printZBorne() {
        if (this.lock) {
            return;
        }
        this.print_current_ticket_btn.setVisible(false);
        this.print_current_ticket_btn.setManaged(false);
        this.tickets_filter_box.setVisible(false);
        this.tickets_filter_box.setManaged(false);
        this.print_current_z_btn.setVisible(true);
        this.print_current_z_btn.setManaged(true);
        this.z_filter_box.setVisible(true);
        this.z_filter_box.setManaged(true);
        this.showListPane(false);
    }

    public void printCurrentTicket() {
        if (this.printing || this.currentTicket == null) {
            return;
        }
        try {
            EnteteInfo entetTicket = AppLocal.dlSales.getEnteteByTicket(this.currentTicket.getId(), this.currentTicket.isPaid());
            if (entetTicket.IsTicketRestituted()) {
                this.header_box.setVisible(false);
                this.header_box.setManaged(false);
                this.showPane(this.reason_pane);
            } else {
                this.printCurrentTicket(null);
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void printCurrentTicket(String reason) {
        System.out.println("++++ printing ticket: " + this.currentTicket.toString());
        this.printing = true;
        try {
            this.currentTicket.setCustomer(AppLocal.dlSales.loadCustomerExt(this.currentTicket.getCustomerId()));
            List<TicketLineInfo> lines = AppLocal.dlSales.loadLines(this.currentTicket.getId());
            this.currentTicket.setLines(lines);
            this.currentTicket.setPayments(AppLocal.dlSales.findPaymetsByIdTicket(this.currentTicket.getId()));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        try {
            EnteteInfo entetTicket = AppLocal.dlSales.getEnteteByTicket(this.currentTicket.getId(), this.currentTicket.isPaid());
            this.ticketService.printPaidTicketCaisse(this.currentTicket, entetTicket, reason);
            if (reason != null) {
                this.print_reason_field.setText("");
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        this.printing = false;
    }

    public void printCurrentZ() {
        if (this.printing || this.currentGTP == null) {
            return;
        }
        this.printing = true;
        Date date = DateUtils.getDateFromString(this.currentGTP.getId());
        this.setTime(date);
        this.ticketService.printZBorne(this.currentGTP);
        System.out.println("++++ printing z for : " + this.currentGTP.displayPeriodeName());
        this.printing = false;
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
        System.out.println("++++++++++ dateEnd setTime ********************* : " + this.dateEnd);
        System.out.println("++++++++++ dateStart  setTime********************* : " + this.dateStart);
    }

    private void showListPane(boolean fromTickets) {
        if (fromTickets) {
            this.setTicketsList(null);
        } else {
            this.setGTPList();
        }
        this.refreshListPaneView(fromTickets);
        this.showPane(this.list_main_pane);
    }

    public void showSettingsMainPane() {
        this.currentTicket = null;
        this.currentGTP = null;
        this.action = null;
        this.showPane(this.settings_main_pane);
    }

    public void showPane(FlowPane pane) {
        for (FlowPane p : this.panes) {
            if (p.getId().equals(pane.getId())) continue;
            p.setVisible(false);
            p.setManaged(false);
        }
        pane.setVisible(true);
        pane.setManaged(true);
    }

    private String getPrintButtonStyle() {
        return "-fx-border-color: transparent; -fx-padding: 20px; -fx-background-radius: 20px; -fx-border-radius: 20px; -fx-graphic-text-gap: 10px; -fx-text-fill: white; -fx-background-color: " + this.terminal_color_hex + ";";
    }

    private String getCircularPanesStyle(boolean isShutdown) {
        String color = isShutdown ? ColorUtils.getColorLight("255,0,0", 0.1) : this.terminal_light_color_hex;
        return "-fx-background-color: " + color + "; -fx-background-radius: 50%; -fx-border-radius: 50%; -fx-border-color: transparent; -fx-padding: 20px; -fx-alignment: center; ";
    }

    private String getCloseButtonPaneStyle() {
        String color = ColorUtils.getColorLight("255,0,0", 0.1);
        return "-fx-background-color: " + color + ";-fx-background-radius: 50%;  -fx-border-color: transparent; -fx-border-radius: 50%; -fx-padding: 10; -fx-alignment: center;";
    }

    public static void executeShutdownCmd(String option) {
        try {
            ProcessBuilder builder = new ProcessBuilder("shutdown", option, "-t", "3");
            builder.start();
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private ImageView getImageView(double width) {
        Image image = new Image("/images/onseat.png");
        ImageView imageView = new ImageView(image);
        imageView.setFitWidth(width * 0.15);
        imageView.setPreserveRatio(true);
        return imageView;
    }

    private void disableScrollBars() {
        this.list_pane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.list_pane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
    }

    public Pair<VBox, VBox> getInfoBoxes(TicketInfo ticketInfo, double boxesWidth) {
        VBox leftVBox = new VBox();
        VBox rightVBox = new VBox();
        int fontSize = 22;
        leftVBox.setStyle("-fx-background-color: transparent; -fx-border-color: transparent;");
        rightVBox.setStyle("-fx-background-color: transparent; -fx-border-color: transparent;");
        leftVBox.setPrefWidth(boxesWidth);
        rightVBox.setPrefWidth(boxesWidth);
        Pane pane = new Pane();
        Pane pane1 = new Pane();
        Pane pane2 = new Pane();
        Pane pane3 = new Pane();
        Pane pane4 = new Pane();
        pane.setPrefHeight(10.0);
        pane1.setPrefHeight(10.0);
        pane2.setPrefHeight(10.0);
        pane3.setPrefHeight(10.0);
        pane4.setPrefHeight(10.0);
        Label num = new Label("N\u00b0" + ticketInfo.getNumberOrder(false, true));
        num.setStyle("-fx-font-size: " + fontSize + "px;");
        Label type = new Label(ticketInfo.getType());
        type.setStyle("-fx-font-size: " + fontSize + "px; -fx-text-fill: gray;");
        Label date = new Label(this.dateFormat.format(ticketInfo.getDatePaid()));
        date.setStyle("-fx-font-size: " + fontSize + "px; -fx-text-fill: gray;");
        leftVBox.getChildren().add(0, (Object)num);
        leftVBox.getChildren().add(1, (Object)pane1);
        leftVBox.getChildren().add(2, (Object)type);
        leftVBox.getChildren().add(3, (Object)pane2);
        leftVBox.getChildren().add(4, (Object)date);
        HBox hb1 = new HBox();
        hb1.setAlignment(Pos.CENTER_RIGHT);
        Label totalLabel = new Label("Total ");
        Label totalContent = new Label(Formats.CURRENCY.formatValue(ticketInfo.getTotalOrder()));
        totalLabel.setStyle("-fx-font-weight: normal; -fx-font-size: " + fontSize + "px;");
        totalContent.setStyle("-fx-font-weight: bold; -fx-font-size: " + fontSize + "px;");
        hb1.getChildren().add(0, (Object)totalLabel);
        hb1.getChildren().add(1, (Object)totalContent);
        HBox hb2 = new HBox();
        hb2.setAlignment(Pos.CENTER_RIGHT);
        Label serverLabel = new Label("Serveur ");
        Label serverContent = new Label(ticketInfo.getNameUser());
        serverLabel.setStyle("-fx-font-weight: normal; -fx-font-size: " + fontSize + "px;");
        serverContent.setStyle("-fx-font-weight: bold; -fx-font-size: " + fontSize + "px;");
        hb2.getChildren().add(0, (Object)serverLabel);
        hb2.getChildren().add(1, (Object)serverContent);
        rightVBox.getChildren().add(0, (Object)hb1);
        rightVBox.getChildren().add(1, (Object)pane3);
        rightVBox.getChildren().add(2, (Object)hb2);
        leftVBox.setAlignment(Pos.CENTER_LEFT);
        rightVBox.setAlignment(Pos.CENTER_RIGHT);
        return Pair.create(leftVBox, rightVBox);
    }

    public Pair<VBox, VBox> getInfoBoxes(GrandTotalPeriode gtp, double boxesWidth) {
        VBox leftVBox = new VBox();
        VBox rightVBox = new VBox();
        int fontSize = 21;
        leftVBox.setStyle("-fx-background-color: transparent; -fx-border-color: transparent;");
        rightVBox.setStyle("-fx-background-color: transparent; -fx-border-color: transparent;");
        leftVBox.setPrefWidth(boxesWidth);
        rightVBox.setPrefWidth(boxesWidth);
        Pane pane = new Pane();
        Pane pane1 = new Pane();
        Pane pane2 = new Pane();
        Pane pane3 = new Pane();
        Pane pane4 = new Pane();
        pane.setPrefHeight(10.0);
        pane1.setPrefHeight(10.0);
        pane2.setPrefHeight(10.0);
        pane3.setPrefHeight(10.0);
        pane4.setPrefHeight(10.0);
        Label num = new Label("ID " + gtp.getId());
        num.setStyle("-fx-font-size: " + fontSize + "px;");
        Label type = new Label(gtp.displayTypePeriode());
        type.setStyle("-fx-font-size: " + fontSize + "px; -fx-text-fill: gray;");
        Label date = new Label(this.dateFormat.format(gtp.getTimestampGDH()));
        date.setStyle("-fx-font-size: " + fontSize + "px; -fx-text-fill: gray;");
        leftVBox.getChildren().add(0, (Object)num);
        leftVBox.getChildren().add(1, (Object)pane1);
        leftVBox.getChildren().add(2, (Object)type);
        leftVBox.getChildren().add(3, (Object)pane2);
        leftVBox.getChildren().add(4, (Object)date);
        HBox hb1 = new HBox();
        hb1.setAlignment(Pos.CENTER_RIGHT);
        Label totalLabel = new Label("Cumul p\u00e9riode ");
        Label totalContent = new Label(Formats.CURRENCY.formatValue(gtp.getCumul()));
        totalLabel.setStyle("-fx-font-weight: normal; -fx-font-size: " + fontSize + "px;");
        totalContent.setStyle("-fx-font-weight: bold; -fx-font-size: " + fontSize + "px;");
        hb1.getChildren().add(0, (Object)totalLabel);
        hb1.getChildren().add(1, (Object)totalContent);
        HBox hb2 = new HBox();
        hb2.setAlignment(Pos.CENTER_RIGHT);
        Label serverLabel = new Label("P\u00e9riode cloture ");
        Label serverContent = new Label(gtp.displayPeriodeName());
        serverLabel.setStyle("-fx-font-weight: normal; -fx-font-size: " + fontSize + "px;");
        serverContent.setStyle("-fx-font-weight: bold; -fx-font-size: " + fontSize + "px;");
        hb2.getChildren().add(0, (Object)serverLabel);
        hb2.getChildren().add(1, (Object)serverContent);
        rightVBox.getChildren().add(0, (Object)hb1);
        rightVBox.getChildren().add(1, (Object)pane3);
        rightVBox.getChildren().add(2, (Object)hb2);
        leftVBox.setAlignment(Pos.CENTER_LEFT);
        rightVBox.setAlignment(Pos.CENTER_RIGHT);
        return Pair.create(leftVBox, rightVBox);
    }

    private void initZFilter() {
        this.initTypesCombo();
        this.initZMonthsCombo();
        this.initZYearsCombo();
        this.setGTPList();
    }

    private void initTypesCombo() {
        this.types = new ArrayList<String>(){
            {
                this.add("Journalier");
                this.add("Mensuel");
                this.add("Annuel");
            }
        };
        this.zTypesBox.getItems().addAll(this.types);
        this.zTypesBox.setValue((Object)"Journalier");
        this.zTypesBox.setButtonCell(new ListCell(){

            protected void updateItem(Object o, boolean bln) {
                String type = (String)o;
                super.updateItem((Object)type, bln);
                this.setText(type);
                this.setStyle("-fx-background-color: white; -fx-text-fill: #2672B2;");
            }
        });
        this.zTypesBox.setOnAction(event -> {
            this.zPeriodType = (String)this.zTypesBox.getValue();
            this.setGTPList();
        });
        this.zPeriodType = "Journalier";
    }

    private void initZMonthsCombo() {
        this.months = new LinkedMap<String, Integer>(){
            {
                this.put("Janvier", 1);
                this.put("F\u00e9vrier", 2);
                this.put("Mars", 3);
                this.put("Avril", 4);
                this.put("Mai", 5);
                this.put("Juin", 6);
                this.put("Juillet", 7);
                this.put("Ao\u00fbt", 8);
                this.put("Septembre", 9);
                this.put("Octobre", 10);
                this.put("Novembre", 11);
                this.put("D\u00e9cembre", 12);
            }
        };
        this.zMonthsBox.getItems().addAll((Collection)this.months.keySet());
        this.zMonthsBox.setValue((Object)this.months.keySet().stream().filter(key -> (Integer)this.months.get(key) - 1 == new Date().getMonth()).findFirst().get());
        this.zMonthsBox.setButtonCell(new ListCell(){

            protected void updateItem(Object o, boolean bln) {
                String type = (String)o;
                super.updateItem((Object)type, bln);
                this.setText(type);
                this.setStyle("-fx-background-color: white; -fx-text-fill: #2672B2;");
            }
        });
        this.zMonthsBox.setOnAction(event -> {
            String selected = (String)this.zMonthsBox.getValue();
            this.zPeriodMonth = (Integer)this.months.get((Object)selected);
            this.setGTPList();
        });
        this.zPeriodMonth = new Date().getMonth() + 1;
    }

    private void initZYearsCombo() {
        this.years = new ArrayList<Integer>();
        for (int i = 2017; i <= 1900 + new Date().getYear(); ++i) {
            this.years.add(i);
        }
        this.zYearsBox.getItems().addAll(this.years);
        this.zYearsBox.setValue((Object)this.years.get(this.years.size() - 1));
        this.zYearsBox.setButtonCell(new ListCell(){

            protected void updateItem(Object o, boolean bln) {
                Integer type = (Integer)o;
                super.updateItem((Object)type, bln);
                this.setText(String.valueOf(type));
                this.setStyle("-fx-background-color: white; -fx-text-fill: #2672B2;");
            }
        });
        this.zYearsBox.setOnAction(event -> {
            this.zPeriodYear = (Integer)this.zYearsBox.getValue();
            this.setGTPList();
        });
        this.zPeriodYear = 1900 + new Date().getYear();
    }

    private void initEmptyLabel() {
        this.emptyList = new Label();
        this.emptyList.setStyle("-fx-background-color: transparent; -fx-font-size: 22pt; -fx-font-weight: bold;");
    }

    private void triggerAction(int act) {
        if (this.lock) {
            return;
        }
        this.action = act;
        String message = switch (act) {
            case 1 -> "Voulez-vous \u00e9teindre la borne ?";
            case 2 -> "Voulez-vous r\u00e9demarrer la borne ?";
            default -> "Voulez-vous relancer le logiciel ?";
        };
        this.confirmation_label.setText(message);
        this.header_box.setVisible(false);
        this.header_box.setManaged(false);
        this.showPane(this.confirmation_pane);
    }

    private void confirmAction() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        this.confirmation_label.setText(this.getProcessMessage());
        this.confirm_buttons_box.setVisible(false);
        this.confirm_buttons_box.setManaged(false);
        new Thread(() -> {
            switch (this.action) {
                case 1: {
                    this.shutdown();
                    break;
                }
                case 2: {
                    this.restart();
                    break;
                }
                default: {
                    this.relaunch();
                }
            }
        }).start();
    }

    private void cancelAction() {
        this.header_box.setManaged(true);
        this.header_box.setVisible(true);
        this.showSettingsMainPane();
    }

    private void initConfirmStyle() {
        this.yes_confirm.setStyle("-fx-border-color: transparent; -fx-padding: 30px; -fx-background-radius: 50px; -fx-border-radius: 50px; ; -fx-text-fill: white; -fx-background-color: " + this.terminal_color_hex + ";");
        this.confirm_print.setStyle("-fx-border-color: transparent; -fx-padding: 30px; -fx-background-radius: 50px; -fx-border-radius: 50px; ; -fx-text-fill: white; -fx-background-color: " + this.terminal_color_hex + ";");
    }

    private String getProcessMessage() {
        return switch (this.action) {
            case 1 -> "Extinction en cours...";
            case 2 -> "R\u00e9demarrage en cours...";
            default -> "Relancement en cours...";
        };
    }

    private void initTicketsFilter() {
        this.ticketsFilterDate = new Date();
        this.ticketsPeriodDay = this.ticketsFilterDate.getDate();
        this.initTicketsMonthsCombo();
        this.initTicketsYearsCombo();
        this.setTicketsList(null);
    }

    private void initTicketsMonthsCombo() {
        this.ticketsMonthsBox.getItems().addAll((Collection)this.months.keySet());
        this.ticketsMonthsBox.setValue((Object)this.months.keySet().stream().filter(key -> (Integer)this.months.get(key) - 1 == new Date().getMonth()).findFirst().get());
        this.ticketsMonthsBox.setButtonCell(new ListCell(){

            protected void updateItem(Object o, boolean bln) {
                String type = (String)o;
                super.updateItem((Object)type, bln);
                this.setText(type);
                this.setStyle("-fx-background-color: white; -fx-text-fill: #2672B2;");
            }
        });
        this.ticketsMonthsBox.setOnAction(event -> {
            String selected = (String)this.ticketsMonthsBox.getValue();
            this.ticketsPeriodMonth = (Integer)this.months.get((Object)selected);
            int maxDays = YearMonth.of(this.ticketsPeriodYear, this.ticketsPeriodMonth).lengthOfMonth();
            if (this.ticketsPeriodDay > maxDays) {
                this.ticketsPeriodDay = maxDays;
            }
            this.setTicketsList(null);
        });
        this.ticketsPeriodMonth = new Date().getMonth() + 1;
    }

    private void initTicketsYearsCombo() {
        this.ticketsYearsBox.getItems().addAll(this.years);
        this.ticketsYearsBox.setValue((Object)this.years.get(this.years.size() - 1));
        this.ticketsYearsBox.setButtonCell(new ListCell(){

            protected void updateItem(Object o, boolean bln) {
                Integer type = (Integer)o;
                super.updateItem((Object)type, bln);
                this.setText(String.valueOf(type));
                this.setStyle("-fx-background-color: white; -fx-text-fill: #2672B2;");
            }
        });
        this.ticketsYearsBox.setOnAction(event -> {
            this.ticketsPeriodYear = (Integer)this.ticketsYearsBox.getValue();
            this.setTicketsList(null);
        });
        this.ticketsPeriodYear = 1900 + new Date().getYear();
    }

    private void refreshDateFilterView() {
        this.ticketsPeriodDayLabel.setText(String.valueOf(this.ticketsPeriodDay));
        this.ticketsMonthsBox.setValue((Object)this.months.keySet().stream().filter(key -> (Integer)this.months.get(key) == this.ticketsPeriodMonth).findFirst().get());
        this.ticketsYearsBox.setValue((Object)this.years.stream().filter(year -> year == this.ticketsPeriodYear).findFirst().get());
    }

    private void checkSyncAvailability() {
        if ("Esclave".equalsIgnoreCase(AppLocal.modelCaisse)) {
            this.remote_sync_btn.setVisible(true);
            this.remote_sync_btn.setManaged(true);
        }
    }

    public static void remoteDisablePayment() {
        AppConfig instance = AppConfig.getInstance();
        instance.setProperty("payment.borne", "no");
        instance.save();
    }

    public static void remoteDisableOnseat() {
        AppConfig instance = AppConfig.getInstance();
        instance.setProperty("only.take.away.borne", "yes");
        instance.save();
    }

    public static void remoteSetInMaintenance() {
        AppConfig instance = AppConfig.getInstance();
        instance.setProperty("payment.borne", "yes");
        instance.save();
    }

    private void confirmPrint() {
        String reason = this.print_reason_field.getText().trim();
        if (reason.isBlank()) {
            return;
        }
        this.printCurrentTicket(reason);
        this.header_box.setVisible(true);
        this.header_box.setManaged(true);
        this.showPane(this.list_main_pane);
    }

    private void cancelPrint() {
        this.header_box.setVisible(true);
        this.header_box.setManaged(true);
        this.showPane(this.list_main_pane);
        this.printing = false;
    }
}

