/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.service.Pair;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class ManagerBorneAuthController
implements RootController {
    private Stage stage;
    private boolean authenticated = false;
    private boolean unlocked = false;
    @FXML
    Label title;
    @FXML
    Label subtitle;
    @FXML
    Label error;
    @FXML
    FlowPane main_pane;
    @FXML
    GridPane buttons_pane;
    @FXML
    GridPane digits_pane;
    @FXML
    Button btn_back;
    @FXML
    Button btn_access;
    @FXML
    Label label_1;
    @FXML
    Label label_2;
    @FXML
    Label label_3;
    @FXML
    Label label_4;
    @FXML
    Button btn_1;
    @FXML
    Button btn_2;
    @FXML
    Button btn_3;
    @FXML
    Button btn_4;
    @FXML
    Button btn_5;
    @FXML
    Button btn_6;
    @FXML
    Button btn_7;
    @FXML
    Button btn_8;
    @FXML
    Button btn_9;
    @FXML
    Button btn_0;
    private String terminal_color_hex;
    private List<Integer> code;
    private static final int validCodeSize = 4;
    private List<Label> digitsLabels;
    private static LocalDate today;
    private static String borneManagerCode;
    private final String mainColor = "24,238,17";

    public void initializer() {
        this.terminal_color_hex = ColorUtils.getColor("24,238,17");
        this.btn_1.setOnAction(event -> this.insertDigit(this.btn_1, 1));
        this.btn_2.setOnAction(event -> this.insertDigit(this.btn_2, 2));
        this.btn_3.setOnAction(event -> this.insertDigit(this.btn_3, 3));
        this.btn_4.setOnAction(event -> this.insertDigit(this.btn_4, 4));
        this.btn_5.setOnAction(event -> this.insertDigit(this.btn_5, 5));
        this.btn_6.setOnAction(event -> this.insertDigit(this.btn_6, 6));
        this.btn_7.setOnAction(event -> this.insertDigit(this.btn_7, 7));
        this.btn_8.setOnAction(event -> this.insertDigit(this.btn_8, 8));
        this.btn_9.setOnAction(event -> this.insertDigit(this.btn_9, 9));
        this.btn_0.setOnAction(event -> this.insertDigit(this.btn_0, 0));
        this.code = new ArrayList<Integer>();
        this.digitsLabels = new ArrayList(){
            {
                this.add(ManagerBorneAuthController.this.label_1);
                this.add(ManagerBorneAuthController.this.label_2);
                this.add(ManagerBorneAuthController.this.label_3);
                this.add(ManagerBorneAuthController.this.label_4);
            }
        };
    }

    public void goBack() {
        this.authenticated = false;
        this.stage.close();
    }

    public void access() {
        if (this.unlocked) {
            this.authenticated = true;
            this.stage.close();
        }
    }

    public boolean authenticate(String password) {
        if (ManagerBorneAuthController.getBorneManagerDailyCode().equals(password) || ManagerBorneAuthController.get4DigitsFromDailyCode().equals(password)) {
            this.unlocked = true;
            this.error.setText("");
            this.label_4.setStyle("-fx-font-size: 30pt; -fx-font-weight: bold; -fx-background-color: white; -fx-border-color: transparent; -fx-border-width: 2px; -fx-border-radius: 15px; -fx-background-radius: 15px;");
            this.btn_access.setStyle("-fx-text-fill: white; -fx-background-color: " + this.terminal_color_hex + "; -fx-border-radius: 15px; -fx-background-radius: 15px;");
            return true;
        }
        this.error.setText("Code incorrect, acc\u00e8s r\u00e9fus\u00e9. Veuillez r\u00e9essayer.");
        this.label_4.setStyle("-fx-font-size: 30pt; -fx-font-weight: bold; -fx-background-color: white; -fx-border-color: red; -fx-border-width: 2px; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-text-fill: red;");
        return false;
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.initializer();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @FXML
    public void insertDigit(Button btn, Integer value) {
        if (this.code.size() == 4) {
            return;
        }
        this.code.add(value);
        if (this.code.size() == 4) {
            boolean validCreds = this.authenticate(this.code.stream().reduce("", (last, current) -> String.valueOf(last) + String.valueOf(current), String::concat));
            if (!validCreds) {
                this.removeLastDigit();
            } else {
                this.reloadDigits();
            }
        } else {
            this.reloadDigits();
        }
    }

    public void removeLastDigit() {
        if (this.unlocked) {
            this.unlocked = false;
            this.btn_access.setStyle("-fx-text-fill: gray; -fx-background-color: lightgray; -fx-border-radius: 15px; -fx-background-radius: 15px;");
        }
        if (!this.code.isEmpty()) {
            this.code.remove(this.code.size() - 1);
            this.reloadDigits();
        }
    }

    public void reloadDigits() {
        int maxIndex = this.code.size() - 1;
        for (int i = 0; i < 4; ++i) {
            if (i <= maxIndex) {
                this.digitsLabels.get(i).setText("\u2022");
                continue;
            }
            if (i - 1 == maxIndex) {
                this.digitsLabels.get(i).setText("|");
                continue;
            }
            this.digitsLabels.get(i).setText("-");
        }
    }

    public static String getBorneManagerDailyCode() {
        if (today == null || borneManagerCode == null || !LocalDate.now().isEqual(today)) {
            today = LocalDate.now();
            ManagerBorneAuthController.generateManagerDailyCode();
        }
        System.out.println("+++++++ day: " + today.toString() + ", borne manager code: " + borneManagerCode);
        return borneManagerCode;
    }

    private static void generateManagerDailyCode() {
        String code;
        int seed = today.getDayOfMonth() % 2 == 0 ? 42 : 5;
        Random random = new Random(seed);
        int day = today.getDayOfMonth();
        int month = today.getMonthValue();
        int year = today.getYear();
        Pair<Integer, Integer> pair = ManagerBorneAuthController.getFranchiseIdAndSiret();
        int franchiseId = pair.getFirst();
        int siret = pair.getSecond();
        int[] values = new int[]{3 * day * franchiseId, 5 * month + franchiseId, 8 * siret + franchiseId, 13 * day + month + year, 21 * franchiseId + day + siret, 34 * month + 1 - day, 55 * day * month + year, 89 * day * siret};
        borneManagerCode = code = random.ints(4L, 0, values.length).mapToObj(index -> Character.valueOf(String.valueOf(values[index]).charAt(0))).reduce("", (previous, current) -> previous + current, String::concat);
    }

    private static Pair<Integer, Integer> getFranchiseIdAndSiret() {
        int franchiseId = 52;
        int processedSiret = 77;
        try {
            franchiseId = Integer.parseInt(Objects.requireNonNullElse(AppLocal.FRANCHISE_ID, String.valueOf(franchiseId)));
            String siret = Objects.requireNonNullElse(AppLocal.marqueNFC.getSiret(), String.valueOf(processedSiret));
            processedSiret = Integer.parseInt("" + siret.charAt(0) + siret.charAt(siret.length() - 1) + siret.charAt(siret.length() - 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Pair.create(franchiseId, processedSiret);
    }

    public static String get4DigitsFromDailyCode() {
        String dailyCode = AppVarUtils.generatorDailyCode();
        return dailyCode.length() >= 4 ? dailyCode.substring(0, 4) : dailyCode;
    }
}

