/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.PaneOption;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.components.views.ButtonBoxOption;
import com.openbravo.components.views.ButtonBoxProductSize;
import com.openbravo.controllers.borne.AbstractController;
import com.openbravo.controllers.borne.CatalogueController;
import com.openbravo.controllers.borne.ProductAllergensController;
import com.openbravo.controllers.borne.ProductNutritionalValueController;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import fr.protactile.procaisse.cache.CacheFinder;
import fr.protactile.procaisse.cache.SharedMemoryCache;
import fr.protactile.procaisse.dao.entities.Allergene;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class DetailProductController
extends AbstractController
implements RootController {
    private Stage stage;
    private Object[] result;
    private String text_color_borne_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
    private String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    private final double height_popUp = AppVarUtils.getScreenDimension().getHeight() * 0.9;
    private final double width_popUp = AppVarUtils.getScreenDimension().getWidth() * 0.9;
    private int page_ingredient;
    private boolean update_option;
    private ProductInfoExt product;
    private double percent_height_product = 0.5;
    private double percent_height_description = 0.1;
    private double percent_height_price = 0.1;
    private double percent_height_size = 0.15;
    private double percent_height_ingredients = 0.15;
    private double percent_height_quantity = 0.1;
    private double percent_width_name = 0.6;
    private double percent_width_price = 0.4;
    private double percent_height_name_product = 0.1;
    private double percent_height_info_product = 0.2;
    private double percent_height_options;
    private List<ProductSizeInfo> listSizes;
    private ProductSizeInfo mProductSizeInfo;
    private List<ItemOrderInfo> listChoiceIngredient;
    private List<OptionItemOrder> listChoiceSupplement;
    private Image image_ingredient;
    private Image image_product;
    private int quantity;
    protected GridPane[] panes_ingredients;
    protected int number_page_ingredient;
    protected int MAX_LINE_INGREDIENT = 1;
    protected int MAX_COLUMN_INGREDIENT = 4;
    private Image imageNext;
    private Image imagebPrevious;
    private List<Button> buttonsSizes;
    private double WIDTH_VIEW_OPTIONS;
    private double HEIGHT_VIEW_OPTIONS;
    private CarteOrderInfo currentCarte;
    private boolean isProductItem;
    private ProductInfoExt currentProductItem;
    private int page_option;
    private HashMap<Integer, Button> buttonOptions;
    private boolean options_free_grouped;
    private int optionFreeGrouped;
    private DataLogicItems dlItems;
    private SharedMemoryCache mSharedMemoryCache;
    private boolean load_options;
    private ItemService mItemService;
    private Image image_background_product;
    private String sizeImageoption = null;
    private Scene scene;
    @FXML
    GridPane pane_main;
    @FXML
    GridPane pane_parent;
    @FXML
    GridPane pane_sizes;
    @FXML
    Label price_product;
    @FXML
    Label description_product;
    @FXML
    ImageView image_view_product;
    @FXML
    GridPane pane_product;
    @FXML
    Label label_image_product;
    @FXML
    GridPane pane_ingredients;
    @FXML
    GridPane pane_quantity;
    @FXML
    Button btn_increaseQtt;
    @FXML
    Button btn_decreaseQtt;
    @FXML
    Label label_quantity;
    @FXML
    GridPane pane_list_ingredients;
    @FXML
    Label label_title_ingredients;
    @FXML
    GridPane pane_previous;
    @FXML
    GridPane pane_next;
    @FXML
    Button button_previous_ingredient;
    @FXML
    Button button_next_ingredient;
    @FXML
    GridPane pane_info_product;
    @FXML
    Label name_product;
    @FXML
    GridPane pane_list_sizes;
    @FXML
    Label label_title_sizes;
    @FXML
    GridPane pane_options;
    @FXML
    GridPane pane_items_options;
    @FXML
    Label options_name_product;
    @FXML
    Label options_price_product;
    @FXML
    Label name_group_options;
    @FXML
    Label info_group_option;
    @FXML
    Button button_retour;
    @FXML
    Button button_next;
    @FXML
    Button button_cancel;
    @FXML
    Button button_valid;
    @FXML
    GridPane pane_footer;
    @FXML
    GridPane pane_previous_options;
    @FXML
    Button button_previous_options;
    @FXML
    GridPane pane_next_options;
    @FXML
    Button button_next_options;
    @FXML
    StackPane pane_image_product;
    @FXML
    ImageView image_view_background;
    @FXML
    Label label_image_background;
    @FXML
    Label infos_promotion;
    @FXML
    GridPane paneNameProduct;
    @FXML
    VBox allergens_container;
    @FXML
    HBox allergens_nv_btns_container;
    @FXML
    Button button_nv;
    private final String SIZE_IMAGE_512 = "_512px";
    private final String SIZE_IMAGE_256 = "_256px";
    private final String SIZE_IMAGE_128 = "_128px";
    private final String SIZE_IMAGE_64 = "_64px";
    private ProductNutritionalValueController nvController;
    private ProductAllergensController allergensController;
    private EventHandler mEventHandlerProductSizeAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxProductSize mButtonSource = (ButtonBoxProductSize)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getProductSize() != null) {
                DetailProductController.this.chooseSize(mButtonSource.getProductSize(), mButtonSource);
            }
        }
    };
    private EventHandler mEventHandlerIngredientAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            PaneOption mButtonSource = (PaneOption)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getOptionItem() != null) {
                DetailProductController.this.chooseIngredient(mButtonSource.getOptionItem(), mButtonSource);
            }
        }
    };
    private EventHandler mEventHandlerPrevious = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                DetailProductController.this.previousPageIngredient();
            }
        }
    };
    private EventHandler mEventHandlerNext = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                DetailProductController.this.nextPageIngredient();
            }
        }
    };
    private EventHandler mEventHandlerIncreaseOption = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxOption mButtonSource = (ButtonBoxOption)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getmSupplementProduct() != null && mButtonSource.getOptionItem() != null && mButtonSource.getButtonOption() != null) {
                DetailProductController.this.update_option = true;
                DetailProductController.this.increaseNumberOption(mButtonSource.getOptionItem(), mButtonSource.getButtonOption(), mButtonSource.getmSupplementProduct());
            }
        }
    };
    private EventHandler mEventHandlerDecreaseOption = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxOption mButtonSource = (ButtonBoxOption)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getmSupplementProduct() != null && mButtonSource.getOptionItem() != null && mButtonSource.getButtonOption() != null) {
                DetailProductController.this.update_option = true;
                DetailProductController.this.decreaseNumberOption(mButtonSource.getOptionItem(), mButtonSource.getButtonOption(), mButtonSource.getmSupplementProduct());
            }
        }
    };
    private EventHandler mEventHandlerNextOption = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                DetailProductController.this.nextPageOption();
            }
        }
    };
    private EventHandler mEventHandlerPreviousOption = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                DetailProductController.this.previousPageOption();
            }
        }
    };
    private EventHandler mEventHandlerOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            PaneOption mButtonSource = (PaneOption)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getmSupplementProduct() != null && mButtonSource.getOptionItem() != null) {
                if (!DetailProductController.this.update_option) {
                    DetailProductController.this.chooseOption(mButtonSource.getOptionItem(), mButtonSource, mButtonSource.getmSupplementProduct());
                }
                DetailProductController.this.update_option = false;
            }
        }
    };
    private EventHandler mEventHandlerNextItems = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                DetailProductController.this.nextPageOption();
            }
        }
    };
    private EventHandler mEventHandlerPreviousItems = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                DetailProductController.this.previousPageOption();
            }
        }
    };
    private EventHandler mEventHandlerNextIngredients = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                DetailProductController.this.nextPageIngredient();
            }
        }
    };
    private EventHandler mEventHandlerPreviousIngredients = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null) {
                DetailProductController.this.previousPageIngredient();
            }
        }
    };

    public Object[] getResult() {
        return this.result;
    }

    private void initializer() throws URISyntaxException {
        this.stage.setY(AppVarUtils.getScreenDimension().getHeight() * 0.05);
        this.stage.setX(AppVarUtils.getScreenDimension().getWidth() * 0.05);
        this.quantity = 1;
        this.buttonsSizes = new ArrayList<Button>();
        this.listChoiceIngredient = new ArrayList<ItemOrderInfo>();
        this.listChoiceSupplement = new ArrayList<OptionItemOrder>();
        this.m_FilerUtils = FilerUtils.getInstance();
        this.result = new Object[7];
        this.result[0] = this.product;
        this.result[1] = 1;
        this.result[2] = null;
        this.result[3] = this.listChoiceIngredient;
        this.result[4] = false;
        this.result[5] = this.listChoiceSupplement;
        this.result[6] = true;
        this.buttonItems = new ArrayList();
        this.buttonOptions = new HashMap();
        this.image_ingredient_selected = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/ingredient_selected.png"));
        this.image_ingredient = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/image_ingredient.png"));
        this.btn_increaseQtt.setStyle("-fx-text-fill: #ffffff; -fx-background-color:" + this.color_hex + "; -fx-font-size: 40px; -fx-font-weight: bold;");
        this.label_quantity.setStyle("-fx-text-fill: #000000; -fx-background-color: #ffffff;-fx-border-color: lightgray; -fx-font-size: 30px;");
        this.btn_decreaseQtt.setStyle("-fx-text-fill: #ffffff; -fx-background-color: " + this.color_hex + "; -fx-font-size: 40px; -fx-font-weight: bold;");
        this.label_title_ingredients.setStyle("-fx-text-fill: " + this.color_hex + ";");
        this.label_title_sizes.setStyle("-fx-text-fill: " + this.color_hex + ";");
        Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/right_arrow.gif").toURI().toString(), 40.0, 30.0, false, false);
        Image imagebPrevious = new Image(this.getClass().getResource("/com/openbravo/images/left_arrow.gif").toURI().toString(), 40.0, 30.0, false, false);
        this.button_previous_ingredient.setGraphic((Node)new ImageView(imagebPrevious));
        this.button_next_ingredient.setGraphic((Node)new ImageView(imageNext));
        this.button_previous_options.setGraphic((Node)new ImageView(imagebPrevious));
        this.button_next_options.setGraphic((Node)new ImageView(imageNext));
        this.WIDTH_VIEW_OPTIONS = this.width_popUp * 0.8;
        this.options_free_grouped = this.product.isOptions_free_grouped();
        this.optionFreeGrouped = this.product.getOption_free();
        this.mSharedMemoryCache = SharedMemoryCache.getInstance();
        this.color_backgound = "transparent";
        this.mItemService = ItemService.getInstance();
        boolean bl = this.load_options = !(this.product.getSupplements() == null || this.product.getSupplements().size() != 1 || this.product.getCartes() != null && (!this.product.getCartes().isEmpty() || this.product.getIngredients() != null && !this.product.getIngredients().isEmpty() && !AppLocal.HIDE_INGREDIENTS_BORNE || this.product.isMany_size() && this.product.getListSizes() != null && !this.product.getListSizes().isEmpty()));
        if (this.product.getSupplements() != null && this.product.getSupplements().size() == 1) {
            SupplementProduct groupOption = this.product.getSupplements().get(0);
            for (SupplementItemInfo item : groupOption.getItems()) {
                if (item.getGroupsSubSupplement() == null || item.getGroupsSubSupplement().isEmpty()) continue;
                this.load_options = false;
                break;
            }
        }
        if (this.load_options) {
            this.reloadInfoSupplement(this.product);
        } else {
            this.loadSizes();
        }
        this.calculPercentSizes();
        this.loadPaneDetailProduct();
        this.loadInfoProduct();
        this.setTexts();
    }

    @Override
    public void init(Stage mStage) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(DetailProductController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object object) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(DetailProductController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        try {
            this.stage = mStage;
            if (objects != null) {
                this.product = (ProductInfoExt)objects[0];
                this.refIngredient = (HashMap)objects[1];
                this.image_product = (Image)objects[2];
                this.refOptions = (HashMap)objects[3];
                this.dlItems = (DataLogicItems)objects[4];
                this.isProductItem = (Boolean)objects[5];
                this.currentCarte = (CarteOrderInfo)objects[6];
                this.image_background_product = (Image)objects[7];
                this.currentProductItem = this.isProductItem ? this.product : null;
                this.scene = (Scene)objects[8];
            }
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(DetailProductController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void valider() {
        if (!this.product.isMany_size() || this.product.getListSizes().isEmpty() || this.mProductSizeInfo != null) {
            boolean validMin = true;
            boolean validMax = true;
            int min_option = 0;
            if (this.load_options && this.product.getSupplements() != null && !this.product.getSupplements().isEmpty() && this.product.getSupplements().get(0).getHas_options().booleanValue()) {
                int number = this.listChoiceSupplement.size();
                if (number < (min_option = this.product.getSupplements().get(0).getMin_options())) {
                    validMin = false;
                }
                if (number > this.product.getSupplements().get(0).getMax_options()) {
                    validMax = false;
                }
            }
            if (validMin && validMax) {
                this.validProduct();
            } else if (!validMin) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "merci de s\u00e9lectionner le nombre minimum " + min_option + " des options.", 1500, NPosition.TOP_RIGHT);
            }
        }
    }

    public void cancel() {
        this.reset();
        this.stage.close();
    }

    private void loadSizes() {
        if (this.product.isMany_size() && this.product.getListSizes() != null && !this.product.getListSizes().isEmpty()) {
            this.listSizes = this.product.getListSizes();
        }
    }

    private void calculPercentSizes() {
        if (AppLocal.HIDE_NAME_PRODUCTS) {
            this.percent_width_price = 1.0;
        } else if (this.product.getDescription() == null || this.product.getDescription().isEmpty()) {
            this.percent_width_price = 1.0;
            this.percent_width_name = 1.0;
        } else {
            this.percent_width_name = 0.6;
            this.percent_width_price = 0.4;
        }
        if (!this.load_options) {
            if ((this.product.getDescription() == null || this.product.getDescription().isEmpty()) && AppLocal.HIDE_NAME_PRODUCTS) {
                this.percent_height_product += 0.1;
                this.percent_height_info_product = 0.1;
            }
            if (this.listSizes == null || this.listSizes.isEmpty()) {
                if (this.product.getIngredients() == null || this.product.getIngredients().isEmpty() || AppLocal.HIDE_INGREDIENTS_BORNE) {
                    this.percent_height_product += 0.1;
                } else {
                    this.percent_height_product += 0.05;
                    this.percent_height_ingredients += 0.05;
                }
            }
            if (this.product.getIngredients() == null || this.product.getIngredients().isEmpty() || AppLocal.HIDE_INGREDIENTS_BORNE) {
                if (this.listSizes == null || this.listSizes.isEmpty()) {
                    this.percent_height_product += 0.1;
                } else {
                    this.percent_height_product += 0.05;
                    this.percent_height_size += 0.05;
                }
            }
        }
    }

    private void createPaneSize() {
        ButtonBoxProductSize less_size = null;
        double min_price = 0.0;
        int index = 0;
        int column = 0;
        int row = 0;
        double widthPanel = this.width_popUp * 0.25;
        double height = this.height_popUp * this.percent_height_size * 0.9 * 0.5;
        for (ProductSizeInfo productSize : this.listSizes) {
            Object size_text;
            double price_to_show = productSize.getPrice();
            if (this.product.isDifferent_price()) {
                switch (AppLocal.ticketBorne.getType()) {
                    case "Sur Place": {
                        price_to_show = productSize.getPrice_sp();
                        break;
                    }
                    case "A Emporter": {
                        price_to_show = productSize.getPrice_emp();
                        break;
                    }
                    default: {
                        price_to_show = productSize.getPrice();
                    }
                }
            }
            System.out.println("productSize.getLabel_size() : " + productSize.getLabel_size());
            Object object = size_text = productSize.getLabel_size().equals("junior") ? "Junior" : productSize.getLabel_size();
            if (productSize.getDescription() != null && !productSize.getDescription().isEmpty()) {
                size_text = (String)size_text + "\n" + productSize.getDescription();
            }
            ButtonBoxProductSize btnSize = new ButtonBoxProductSize(productSize, widthPanel, height, (String)size_text);
            btnSize.setStyle("-fx-text-fill: " + this.color_hex + "; -fx-border-color : " + this.color_hex + "; -fx-background-color: #ffffff; -fx-font-size: 30px; -fx-font-weight: bold;");
            btnSize.setOnAction(this.mEventHandlerProductSizeAction);
            if (index == 0) {
                min_price = price_to_show;
                less_size = btnSize;
            } else if (price_to_show < min_price) {
                min_price = price_to_show;
                less_size = btnSize;
            }
            this.buttonsSizes.add(btnSize);
            this.pane_list_sizes.add((Node)btnSize, column, row);
            if (column == 3) {
                column = 0;
                row = 1;
            } else {
                ++column;
            }
            ++index;
        }
        if (less_size != null) {
            this.chooseSize(less_size.getProductSize(), less_size);
        }
    }

    private void chooseSize(ProductSizeInfo sizeProduct, Button buttonSize) {
        double price_to_send = this.mItemService.getPriceBorne(sizeProduct, this.product);
        this.product.setPriceSell(price_to_send);
        this.price_product.setText(this.printPrice(price_to_send));
        this.mProductSizeInfo = sizeProduct;
        for (Button otherbuttonSize : this.buttonsSizes) {
            this.deselectButtonSize(otherbuttonSize);
        }
        this.selectButtonSize(buttonSize);
    }

    private String printPrice(double price) {
        System.out.println("+++++++ printPrice price : " + price);
        return this.product.isUse_points() ? this.product.printPriceSell() : Formats.CURRENCY.formatValue(price);
    }

    private void createPaneIngredients() {
        int max_ingredient = 4;
        this.height_option = this.height_popUp * this.percent_height_ingredients * 0.8;
        this.width_option = this.width_popUp * 0.8 / (double)max_ingredient;
        this.loadImagesOptions(this.product.getIngredients(), true, false, false, "_256px");
        this.max_items = max_ingredient;
        this.index_item = 0;
        int number_items = this.product.getIngredients().size();
        boolean add_switch_button = number_items > this.max_items;
        ArrayList<Button> btnIngredients = new ArrayList<Button>();
        for (SupplementItemInfo ingredient : this.product.getIngredients()) {
            this.addPreviousButtonItems(add_switch_button, this.height_option, this.width_option, btnIngredients, this.mEventHandlerPreviousIngredients);
            ImageView imageOption = this.imagesViewCatalogOptions.get(ingredient.getiD()) != null ? (ImageView)this.imagesViewCatalogOptions.get(ingredient.getiD()) : null;
            PaneOption btnIngredient = new PaneOption().option(ingredient).imageOption(imageOption).isIngredient(true).heightPane(this.height_option).widthPane(this.width_option).buildIngredient();
            btnIngredient.getStyleClass().add((Object)"padding-1");
            btnIngredient.setWrapText(true);
            btnIngredient.setStyle("-fx-background-color: transparent;");
            this.deselectButtonIngredient(ingredient, btnIngredient);
            btnIngredient.setOnAction(this.mEventHandlerIngredientAction);
            btnIngredients.add(btnIngredient);
            this.addNextButtonItems(add_switch_button, this.height_option, this.width_option, number_items, btnIngredients, this.mEventHandlerNextIngredients);
            ++this.index_item;
        }
        this.showIngredients(btnIngredients);
    }

    public void chooseIngredient(SupplementItemInfo ingredient, Button btnIngredient) {
        if (this.existIngredient(ingredient) == -1) {
            int id_carte = this.currentCarte != null ? this.currentCarte.getId() : -1;
            int id_product_item = this.currentProductItem != null ? this.currentProductItem.getID() : -1;
            String name_carte = this.currentCarte != null ? this.currentCarte.getName() : null;
            String name_product_item = this.currentProductItem != null ? this.currentProductItem.getName() : null;
            int index_carte = this.currentCarte != null ? this.currentCarte.getIndex_carte() : -1;
            String ref_product = this.currentProductItem != null ? this.currentProductItem.getRef_web() : null;
            String ref_carte = this.currentCarte != null ? this.currentCarte.getRef_web() : null;
            String id_global_product = this.currentProductItem != null ? this.currentProductItem.getId_global() : null;
            String id_global_carte = this.currentCarte != null ? this.currentCarte.getId_global() : null;
            this.listChoiceIngredient.add(new ItemOrderInfo(ingredient, id_carte, id_product_item, name_product_item, name_carte, index_carte, ref_product, ref_carte, id_global_product, id_global_carte));
            this.selectButtonIngredient(ingredient, btnIngredient);
        } else {
            this.deselectButtonIngredient(ingredient, btnIngredient);
            this.listChoiceIngredient.remove(this.existIngredient(ingredient));
        }
    }

    public int existIngredient(SupplementItemInfo ingredient) {
        int found = -1;
        int i = 0;
        int id_carte = -1;
        int id_product_item = -1;
        int index_carte = -1;
        for (ItemOrderInfo itemOrderInfo : this.listChoiceIngredient) {
            if (itemOrderInfo.getIdCarte() == id_carte && itemOrderInfo.getIdProduct() == id_product_item && ingredient.getiD() == itemOrderInfo.getSupplement() && itemOrderInfo.getIndex_carte() == index_carte) {
                found = i;
            }
            ++i;
        }
        return found;
    }

    private void loadInfoProduct() {
        boolean promo_exist;
        String description;
        if (!AppLocal.HIDE_NAME_PRODUCTS) {
            this.name_product.setText(this.product.getDisplayedName().toUpperCase());
        }
        if (this.product.isMany_size() && this.product.getListSizes() != null && !this.product.getListSizes().isEmpty()) {
            this.createPaneSize();
        } else {
            this.price_product.setText(this.printPrice(this.product.getPriceSell()));
        }
        if (this.product.getIngredients() != null && !this.product.getIngredients().isEmpty() && !AppLocal.HIDE_INGREDIENTS_BORNE) {
            this.createPaneIngredients();
        }
        if ((description = this.product.getDisplayedDescription()) != null && !description.isEmpty()) {
            this.description_product.setText(description.toUpperCase());
        }
        boolean bl = promo_exist = description != null && !description.isEmpty();
        if (this.image_product != null) {
            this.setImagePorduct(promo_exist);
        }
        if (this.load_options) {
            this.loadPaneOptions(this.product.getSupplements().get(0));
        }
        this.label_quantity.setText(String.valueOf(this.quantity));
    }

    private void setImagePorduct(boolean promo_exist) {
        double heightImage = promo_exist ? this.height_popUp * this.percent_height_product * 0.7 : this.height_popUp * this.percent_height_product * 0.6;
        double widthImage = this.width_popUp * 0.8;
        this.createImageView(this.image_view_product, this.image_product, heightImage, widthImage);
        if (this.product.isLabeled()) {
            this.createImageView(this.image_view_background, this.image_background_product, heightImage, widthImage * 0.7);
        }
    }

    private void loadPaneDetailProduct() {
        this.pane_product.getChildren().clear();
        this.pane_info_product.getChildren().clear();
        this.paneNameProduct.getChildren().clear();
        int index = 0;
        this.name_product.setPrefHeight(this.height_popUp * this.percent_height_name_product);
        this.name_product.setPrefWidth(this.width_popUp * 0.9 * this.percent_width_name);
        this.price_product.setPrefWidth(this.width_popUp * 0.9 * this.percent_width_price);
        this.description_product.setPrefHeight(this.height_popUp * this.percent_height_description);
        this.price_product.setPrefHeight(this.height_popUp * this.percent_height_price);
        this.pane_info_product.setPrefHeight(this.height_popUp * this.percent_height_info_product);
        this.paneNameProduct.setPrefHeight(this.height_popUp * this.percent_height_price);
        int rowInfoProduct = 0;
        if (this.product.getDescription() != null && !this.product.getDescription().isEmpty()) {
            this.pane_info_product.add((Node)this.description_product, 0, rowInfoProduct++);
        }
        if (!AppLocal.HIDE_NAME_PRODUCTS) {
            this.paneNameProduct.add((Node)this.name_product, 0, 0);
            if (!this.isProductItem) {
                this.paneNameProduct.add((Node)this.price_product, 1, 0);
            }
        } else if (!this.isProductItem) {
            this.paneNameProduct.add((Node)this.price_product, 0, 0);
        }
        this.pane_info_product.add((Node)this.paneNameProduct, 0, rowInfoProduct);
        this.label_image_background.setPrefHeight(this.height_popUp * this.percent_height_product);
        this.label_image_product.setPrefHeight(this.height_popUp * this.percent_height_product);
        this.pane_image_product.setPrefHeight(this.height_popUp * this.percent_height_product);
        if (this.product.getPromotions() != null && !this.product.getPromotions().isEmpty()) {
            this.infos_promotion.setPrefHeight(this.height_popUp * 0.1);
            this.infos_promotion.setText("Ce produit fait partie d'une promotion  1 achet\u00e9e 1 offerte");
            this.pane_product.add((Node)this.infos_promotion, 0, index++);
        }
        AppLocal.show_allergens = true;
        this.pane_product.add((Node)this.pane_image_product, 0, index++);
        this.pane_product.add((Node)this.pane_info_product, 0, index++);
        AppLocal.show_nutri_values = true;
        if (AppLocal.show_nutri_values && this.product.canShowNutritionalValues()) {
            this.allergens_nv_btns_container.setManaged(true);
            this.allergens_nv_btns_container.setVisible(true);
            this.pane_product.add((Node)this.allergens_nv_btns_container, 0, index++);
            this.nvController = new ProductNutritionalValueController(this.product.getNutriValues(), this.pane_image_product, this.pane_parent.getWidth() * 0.92);
            this.button_nv.setManaged(true);
            this.button_nv.setVisible(true);
        }
        if (AppLocal.show_allergens && this.product.canShowAllergens()) {
            this.allergensController = new ProductAllergensController(DetailProductController.extractAllergenNames(this.product.getAllergenes()), this.pane_image_product, this.pane_parent.getWidth() * 0.9);
        }
        if (!this.load_options) {
            if (this.product.isMany_size() && this.product.getListSizes() != null && !this.product.getListSizes().isEmpty()) {
                this.pane_sizes.setPrefHeight(this.height_popUp * this.percent_height_size);
                this.pane_product.add((Node)this.pane_sizes, 0, index++);
            }
            if (this.product.getIngredients() != null && !this.product.getIngredients().isEmpty() && !AppLocal.HIDE_INGREDIENTS_BORNE) {
                this.pane_ingredients.setPrefHeight(this.height_popUp * this.percent_height_ingredients);
                this.pane_product.add((Node)this.pane_ingredients, 0, index++);
            }
            this.pane_quantity.setPrefHeight(this.height_popUp * this.percent_height_quantity);
            if (!this.isProductItem && this.product.getSupplements().isEmpty() && this.product.getCartes().isEmpty()) {
                this.pane_product.add((Node)this.pane_quantity, 0, index++);
            }
        } else {
            this.percent_height_options = 1.0 - this.percent_height_info_product - this.percent_height_product;
            this.HEIGHT_VIEW_OPTIONS = this.height_popUp * this.percent_height_options * 0.95;
            this.pane_options.setPrefHeight(this.height_popUp * this.percent_height_options);
            this.pane_product.add((Node)this.pane_options, 0, index++);
        }
    }

    public void increaseQuantity() {
        boolean higher_price;
        int quantity_tmp = this.quantity + 1;
        boolean bl = higher_price = this.product.isUse_points() && (AppLocal.currentCustomerLoyalty == null || AppLocal.currentCustomerLoyalty != null && AppLocal.currentCustomerLoyalty.getPoints() < this.product.getPrice_point() * (double)quantity_tmp);
        if (!higher_price) {
            ++this.quantity;
            this.label_quantity.setText(String.valueOf(this.quantity));
        }
    }

    public void decreaseQuantity() {
        if (this.quantity > 1) {
            --this.quantity;
            this.label_quantity.setText(String.valueOf(this.quantity));
        }
    }

    private void showIngredients(List<Button> items) {
        this.rangeIngredient(items);
        this.pane_previous.getChildren().clear();
        this.pane_list_ingredients.getChildren().clear();
        this.pane_next.getChildren().clear();
        if (this.number_page_ingredient > 0) {
            this.page_ingredient = 0;
            this.pane_list_ingredients.add((Node)this.panes_ingredients[this.page_ingredient], 0, 0);
        }
    }

    public void previousPageIngredient() {
        if (this.page_ingredient > 0) {
            --this.page_ingredient;
            this.pane_list_ingredients.getChildren().clear();
            this.pane_list_ingredients.add((Node)this.panes_ingredients[this.page_ingredient], 0, 0);
        }
    }

    public void nextPageIngredient() {
        if (this.page_ingredient < this.number_page_ingredient - 1) {
            ++this.page_ingredient;
            this.pane_list_ingredients.getChildren().clear();
            this.pane_list_ingredients.add((Node)this.panes_ingredients[this.page_ingredient], 0, 0);
        }
    }

    private void rangeIngredient(List<Button> items) {
        double max_lines = 1.0;
        this.number_page_ingredient = (int)Math.ceil((double)items.size() / (max_lines * (double)this.MAX_COLUMN_INGREDIENT));
        this.panes_ingredients = new GridPane[this.number_page_ingredient];
        for (int i = 0; i < this.number_page_ingredient; ++i) {
            this.panes_ingredients[i] = new GridPane();
            this.panes_ingredients[i].setVgap(2.0);
            this.panes_ingredients[i].setHgap(2.0);
            this.panes_ingredients[i].setAlignment(Pos.CENTER);
            this.panes_ingredients[i].setStyle("-fx-background-color: transparent;");
        }
        int index_item = 0;
        int column_item = 0;
        int row_item = 0;
        for (Button buttonItem : items) {
            this.panes_ingredients[index_item].add((Node)buttonItem, column_item, row_item);
            if (column_item < this.MAX_COLUMN_INGREDIENT - 1) {
                ++column_item;
                continue;
            }
            ++index_item;
            row_item = 0;
            column_item = 0;
        }
    }

    private void deselectButtonSize(Button button) {
        button.setStyle("-fx-text-fill: " + this.color_hex + "; -fx-border-color : " + this.color_hex + "; -fx-background-color: #ffffff; -fx-font-size: 30px; -fx-font-weight: bold;");
    }

    private void selectButtonSize(Button button) {
        button.setStyle("-fx-text-fill: #000000; -fx-border-color : " + this.color_hex + "; -fx-background-color: " + this.color_hex + "; -fx-font-size: 30px; -fx-font-weight: bold;");
    }

    private void loadPaneOptions(SupplementProduct group_option) {
        this.info_group_option.setText(this.mItemService.getInfoGroupSupplement(group_option));
        this.loadInfoProductOptions(group_option);
        this.loadGroupOption(group_option);
    }

    private void loadGroupOption(SupplementProduct group_option) {
        this.loadInfoProductOptions(group_option);
        this.loadItemsOptions(group_option);
    }

    private void loadInfoProductOptions(SupplementProduct group_option) {
    }

    private void loadItemsOptions(SupplementProduct group_option) {
        this.pane_items_options.getChildren().clear();
        this.buttonOptions.clear();
        this.buttonItems.clear();
        int size = group_option.getItems().size();
        if (size <= 4) {
            this.MAX_LINE_OPTION = 2;
            this.MAX_COLUMN_OPTION = 2;
            this.sizeImageoption = "_256px";
        } else if (size <= 6) {
            this.MAX_LINE_OPTION = 2;
            this.MAX_COLUMN_OPTION = 3;
            this.sizeImageoption = "_256px";
        } else {
            this.MAX_LINE_OPTION = 2;
            this.MAX_COLUMN_OPTION = 4;
            this.sizeImageoption = "_128px";
        }
        boolean index = false;
        this.width_option = this.WIDTH_VIEW_OPTIONS / (double)this.MAX_COLUMN_OPTION;
        this.height_option = this.HEIGHT_VIEW_OPTIONS / (double)this.MAX_LINE_OPTION;
        this.loadImagesOptions(group_option.getItems(), false, false, true, this.sizeImageoption);
        this.initNumberLinesItems(this.HEIGHT_VIEW_OPTIONS, this.WIDTH_VIEW_OPTIONS);
        this.index_item = 0;
        System.out.println("+++++++++++++ max_items : " + this.max_items);
        int number_items = group_option.getItems().size();
        boolean add_switch_button = number_items > this.max_items;
        for (SupplementItemInfo supplement : group_option.getItems()) {
            this.addPreviousButtonItems(add_switch_button, this.height_option, this.width_option, this.buttonItems, this.mEventHandlerPreviousItems);
            ImageView imageOption = this.imagesViewCatalogOptions.get(supplement.getiD()) != null ? (ImageView)this.imagesViewCatalogOptions.get(supplement.getiD()) : null;
            PaneOption btnItemOption = new PaneOption().groupeOption(group_option).option(supplement).imageOption(imageOption).isIngredient(false).heightPane(this.height_option).widthPane(this.width_option).image_option_heights(this.image_option_heights).image_option_width(this.image_option_width).buildOption();
            if (btnItemOption.getProperties().get((Object)"increaseQtt") != null) {
                Button increaseQtt = (Button)btnItemOption.getProperties().get((Object)"increaseQtt");
                increaseQtt.setOnAction(this.mEventHandlerIncreaseOption);
            }
            if (btnItemOption.getProperties().get((Object)"decreaseQtt") != null) {
                Button decreaseQtt = (Button)btnItemOption.getProperties().get((Object)"decreaseQtt");
                decreaseQtt.setOnAction(this.mEventHandlerDecreaseOption);
            }
            btnItemOption.getProperties().put((Object)"name", (Object)supplement.getName().toUpperCase());
            Object name_option = "";
            int quantity = 0;
            if (this.existOption(supplement) != -1) {
                OptionItemOrder item = this.listChoiceSupplement.get(this.existOption(supplement));
                if (item != null) {
                    quantity = item.getNumberOption();
                    name_option = (String)name_option + supplement.getDisplayedName().toUpperCase();
                    btnItemOption.getProperties().put((Object)"price", (Object)item.getPrice());
                    if (supplement.getPrice_order() > 0.0 && item.getPrice() <= 0.0) {
                        name_option = (String)name_option + "\n Offert";
                    }
                }
                this.selectOption(btnItemOption, !supplement.getGroupsSubSupplement().isEmpty());
                this.buttonOptions.put(supplement.getiD(), btnItemOption);
            } else {
                name_option = supplement.getDisplayedName().toUpperCase();
                btnItemOption.getProperties().put((Object)"price", (Object)supplement.getPrice_order());
                this.deselectOption(btnItemOption);
            }
            btnItemOption.getProperties().put((Object)"name", name_option);
            btnItemOption.getProperties().put((Object)"quantity", (Object)quantity);
            btnItemOption.setOnAction(this.mEventHandlerOptionAction);
            this.buttonItems.add(btnItemOption);
            this.addNextButtonItems(add_switch_button, this.height_option, this.width_option, number_items, this.buttonItems, this.mEventHandlerNextItems);
            ++this.index_item;
        }
        this.reloadPriceOptions(group_option);
        this.showItems(this.buttonItems, this.height_option, this.width_option);
    }

    public int existOption(SupplementItemInfo optionItem) {
        int id_carte = this.currentCarte != null ? this.currentCarte.getId() : -1;
        int id_product_item = this.currentProductItem != null ? this.currentProductItem.getID() : -1;
        int index_carte = this.currentCarte != null ? this.currentCarte.getIndex_carte() : -1;
        int found = -1;
        int i = 0;
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (optionItemOrder.getIdCarte() == id_carte && optionItemOrder.getIdProduct() == id_product_item && optionItem.getiD() == optionItemOrder.getSupplement() && optionItemOrder.getIndex_carte() == index_carte && optionItemOrder.getParent_supplement_id() == 0) {
                found = i;
            }
            ++i;
        }
        return found;
    }

    public void previousPageOption() {
        if (this.page_option > 0) {
            --this.page_option;
            this.pane_items_options.getChildren().clear();
            this.pane_items_options.add((Node)this.pane_items[this.page_option], 0, 0);
        }
    }

    public void nextPageOption() {
        if (this.page_option < this.number_page_item - 1) {
            ++this.page_option;
            this.pane_items_options.getChildren().clear();
            this.pane_items_options.add((Node)this.pane_items[this.page_option], 0, 0);
        }
    }

    private void showItems(List<Button> items, double height_button, double width_button) {
        this.rangeSubOption(items, height_button, width_button, this.HEIGHT_VIEW_OPTIONS, this.WIDTH_VIEW_OPTIONS);
        this.pane_items_options.getChildren().clear();
        this.pane_previous_options.getChildren().clear();
        this.pane_next_options.getChildren().clear();
        if (this.number_page_item > 0) {
            this.page_option = 0;
            this.pane_items_options.add((Node)this.pane_items[this.page_option], 0, 0);
        }
    }

    private void increaseNumberOption(SupplementItemInfo optionItem, Button btnOption, SupplementProduct option) {
        int index;
        int number_option;
        boolean free = false;
        boolean next_option = false;
        if ((optionItem.getGroupsSubSupplement() == null || optionItem.getGroupsSubSupplement().isEmpty()) && (number_option = this.listChoiceSupplement.get(index = this.existOption(optionItem)).getNumberOption()) < option.getNumber_click()) {
            OptionItemOrder lastOption = this.lastOption(option.getiD());
            boolean same_option = false;
            boolean delete_last_option = false;
            if (lastOption.getSupplement() == this.listChoiceSupplement.get(index).getSupplement()) {
                same_option = true;
            }
            if (this.listChoiceSupplement.size() > 0 && option.getHas_options().booleanValue() && option.getMax_options() == this.sizeOptions(option)) {
                delete_last_option = true;
            }
            if (!same_option && delete_last_option) {
                this.deleteLastOption(option);
            }
            if (!same_option || !delete_last_option) {
                int numberFree = this.listChoiceSupplement.get(index).getNumber_free();
                if (this.isOptionFreeable(option) && optionItem.getPrice_order() > 0.0) {
                    this.listChoiceSupplement.get(index).setNumber_free(++numberFree);
                    this.decrementOptionFree(option, 1);
                }
                this.listChoiceSupplement.get(index).setNumberOption(++number_option);
                double price = optionItem.getPrice_order() * (double)(number_option - numberFree);
                this.listChoiceSupplement.get(index).setPrice(optionItem.getPrice_order(), number_option - numberFree);
                btnOption.getProperties().replace((Object)"price", (Object)price);
                Object name = optionItem.getDisplayedName().toUpperCase();
                if (free) {
                    name = (String)name + "\n Offert";
                }
                btnOption.getProperties().replace((Object)"name", name);
                btnOption.getProperties().replace((Object)"quantity", (Object)number_option);
                if (this.listChoiceSupplement.size() > 0 && option.getHas_options().booleanValue() && option.getMax_options() == this.sizeOptions(option)) {
                    next_option = true;
                }
            }
            if (next_option) {
                try {
                    this.nextOption();
                }
                catch (Exception ex) {
                    Logger.getLogger(CatalogueController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.price_product.setText(this.printPrice(this.getProductPrice()));
            if (!next_option) {
                this.reloadPriceOptions(option);
            }
        }
    }

    private void decreaseNumberOption(SupplementItemInfo optionItem, Button btnOption, SupplementProduct option) {
        int index = this.existOption(optionItem);
        int number_option = this.listChoiceSupplement.get(index).getNumberOption();
        if (number_option == 1) {
            this.deleteOption(optionItem, option, btnOption);
        } else {
            this.listChoiceSupplement.get(index).setNumberOption(--number_option);
            int number_free = this.listChoiceSupplement.get(index).getNumber_free();
            if (number_free > 0) {
                this.incrementOptionFree(option, 1);
                this.listChoiceSupplement.get(index).setNumber_free(--number_free);
                try {
                    this.calculFreeAfterDelete(option);
                }
                catch (Exception ex) {
                    LogToFile.log("sever", ex.getMessage(), ex);
                }
            }
            double price = optionItem.getPrice_order() * (double)(this.listChoiceSupplement.get(index).getNumberOption() - this.listChoiceSupplement.get(index).getNumber_free());
            this.listChoiceSupplement.get(index).setPrice(optionItem.getPrice_order(), this.listChoiceSupplement.get(index).getNumberOption() - this.listChoiceSupplement.get(index).getNumber_free());
            btnOption.getProperties().replace((Object)"price", (Object)price);
            Object name = optionItem.getDisplayedName().toUpperCase();
            if (price == 0.0) {
                name = (String)name + "\n Offert";
            }
            btnOption.getProperties().replace((Object)"name", name);
            btnOption.getProperties().replace((Object)"quantity", (Object)number_option);
            System.out.println("++ price : " + price);
        }
        this.price_product.setText(this.printPrice(this.getProductPrice()));
        this.reloadPriceOptions(option);
    }

    private OptionItemOrder lastOption(int group_option) {
        OptionItemOrder optionItem = null;
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (optionItemOrder.getId_groupe_option() != group_option) continue;
            optionItem = optionItemOrder;
        }
        return optionItem;
    }

    private void deleteLastOption(SupplementProduct option) {
        try {
            OptionItemOrder itemToDelete = this.lastOption(option.getiD());
            if (itemToDelete != null) {
                SupplementItemInfo supplementItemInfo;
                Button button_option = this.buttonOptions.get(itemToDelete.getSupplement());
                if (button_option != null) {
                    this.deselectOption(button_option);
                }
                if ((supplementItemInfo = CacheFinder.findOptionById(this.mSharedMemoryCache, this.dlItems, itemToDelete.getSupplement())) != null) {
                    supplementItemInfo.setPrice_order(supplementItemInfo.getPriceOption(this.mProductSizeInfo != null ? this.mProductSizeInfo.getName() : null, AppLocal.ticketBorne.getType()));
                    String nameOption = supplementItemInfo.getName().toUpperCase();
                    this.buttonOptions.get(itemToDelete.getSupplement()).getProperties().replace((Object)"price", (Object)supplementItemInfo.getPrice_order());
                    this.buttonOptions.get(itemToDelete.getSupplement()).getProperties().replace((Object)"name", (Object)nameOption);
                    this.deleteSubOptions(supplementItemInfo);
                }
                this.buttonOptions.remove(itemToDelete.getSupplement());
                if (itemToDelete.getNumber_free() > 0) {
                    this.incrementOptionFree(option, itemToDelete.getNumber_free());
                    this.listChoiceSupplement.remove(itemToDelete);
                    this.calculFreeAfterDelete(option);
                } else {
                    this.listChoiceSupplement.remove(itemToDelete);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    private List<OptionItemOrder> getChosenSubOptions(int parent_supplement_id) {
        ArrayList<OptionItemOrder> listChosenOptionsMultiple = new ArrayList<OptionItemOrder>();
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (parent_supplement_id != optionItemOrder.getParent_supplement_id()) continue;
            listChosenOptionsMultiple.add((OptionItemOrder)optionItemOrder.clone());
        }
        return listChosenOptionsMultiple;
    }

    private void deleteSubOptions(SupplementItemInfo supplement) {
        this.deleteOption(this.getChosenSubOptions(supplement.getiD()), supplement.getiD());
    }

    private void deleteOption(List<OptionItemOrder> supplements_to_delete, int parent_supplement_id) {
        for (OptionItemOrder option : supplements_to_delete) {
            OptionItemOrder option_to_delete = this.getSubOption(parent_supplement_id, option.getSupplement());
            if (option_to_delete == null) continue;
            this.listChoiceSupplement.remove(option_to_delete);
        }
    }

    private OptionItemOrder getSubOption(int parent_supplement_id, int sub_supplement_id) {
        OptionItemOrder option = null;
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (sub_supplement_id != optionItemOrder.getSupplement() || parent_supplement_id != optionItemOrder.getParent_supplement_id()) continue;
            option = optionItemOrder;
            break;
        }
        return option;
    }

    private void incrementOptionFree(SupplementProduct groupOption, int number_free) {
        if (this.options_free_grouped) {
            this.optionFreeGrouped += number_free;
        } else {
            groupOption.setOption_free_tmp(groupOption.getOption_free_tmp() - number_free);
        }
    }

    private void decrementOptionFree(SupplementProduct groupOption, int number_free) {
        if (this.options_free_grouped) {
            this.optionFreeGrouped -= number_free;
        } else {
            groupOption.setOption_free_tmp(groupOption.getOption_free_tmp() + number_free);
        }
    }

    private void calculFreeAfterDelete(SupplementProduct option) throws BasicException {
        if (this.isOptionFreeable(option)) {
            for (OptionItemOrder supplement : this.listChoiceSupplement) {
                if (!this.isOptionFreeable(option) || (!this.options_free_grouped || !this.isFree(supplement)) && supplement.getId_groupe_option() != option.getiD() || supplement.getNumber_free() >= supplement.getNumberOption() || !(supplement.getPrice() > 0.0)) continue;
                int free_possible = this.options_free_grouped ? this.optionFreeGrouped : option.getOption_free() - option.getOption_free_tmp();
                int free = free_possible > supplement.getNumberOption() - supplement.getNumber_free() ? supplement.getNumberOption() - supplement.getNumber_free() : free_possible;
                double price_option = supplement.getPrice() - supplement.getPrice() / (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setNumber_free(supplement.getNumber_free() + free);
                double price = price_option * (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setPrice(price_option, supplement.getNumberOption() - supplement.getNumber_free());
                Button btnOption = this.buttonOptions.get(supplement.getSupplement());
                if (btnOption != null) {
                    String name_option = supplement.getNumberOption() + " X " + supplement.getNameSupplement().toUpperCase();
                    if (supplement.getPrice() == 0.0) {
                        name_option = name_option + "\n Offert";
                    }
                    btnOption.getProperties().replace((Object)"price", (Object)price);
                    btnOption.getProperties().put((Object)"name", (Object)name_option);
                }
                this.decrementOptionFree(option, free);
            }
        }
    }

    private boolean isOptionFreeable(SupplementProduct groupeOption) {
        if (!this.options_free_grouped) {
            return groupeOption.getOption_free() > groupeOption.getOption_free_tmp();
        }
        return groupeOption.isFree_able() && this.optionFreeGrouped > 0;
    }

    private void deleteOption(SupplementItemInfo optionItem, SupplementProduct option, Button btnOption) {
        if (this.listChoiceSupplement.get(this.existOption(optionItem)).getNumber_free() > 0) {
            int number_free_to_recuperate = this.listChoiceSupplement.get(this.existOption(optionItem)).getNumber_free();
            this.incrementOptionFree(option, number_free_to_recuperate);
            this.listChoiceSupplement.remove(this.existOption(optionItem));
            try {
                this.calculFreeAfterDelete(option);
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        } else {
            this.listChoiceSupplement.remove(this.existOption(optionItem));
        }
        this.buttonOptions.remove(optionItem.getiD());
        String nameOption = optionItem.getDisplayedName().toUpperCase();
        btnOption.getProperties().replace((Object)"price", (Object)optionItem.getPrice_order());
        this.deselectOption(btnOption);
        btnOption.getProperties().replace((Object)"name", (Object)nameOption);
        this.deleteSubOptions(optionItem);
    }

    private void printName() {
        Object infoProduct = "";
        String prefix = "-";
        for (OptionItemOrder option : this.listChoiceSupplement) {
            if (option.getIdProduct() != -1 || option.getParent_supplement_id() != 0) continue;
            infoProduct = (String)infoProduct + this.addNameOption(option, prefix);
            List<OptionItemOrder> sub_supplements = this.getChosenSubOptions(option.getSupplement());
            if (sub_supplements.isEmpty()) continue;
            int index = 0;
            infoProduct = (String)infoProduct + "(";
            for (OptionItemOrder sub_supplement : sub_supplements) {
                prefix = index == 0 ? "" : "-";
                infoProduct = (String)infoProduct + this.addNameOption(sub_supplement, prefix);
                ++index;
            }
            infoProduct = (String)infoProduct + ")";
            prefix = "-";
        }
    }

    private String addNameOption(OptionItemOrder option, String prefix) {
        String nameOption = prefix + (Serializable)(option.getNumberOption() != 1 ? Integer.valueOf(option.getNumberOption()) : "");
        nameOption = option.getPrice() == 0.0 ? nameOption + option.getNameSupplement() + " " : nameOption + option.getNameSupplement() + "+" + option.printPrice() + " ";
        return nameOption;
    }

    private void reloadPriceOptions(SupplementProduct option) {
        super.reloadPriceOptions(this.isOptionFreeable(option));
    }

    private double getProductPrice() {
        double price = 0.0;
        if (this.product != null) {
            price = this.product.getPriceSell();
        }
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            price += optionItemOrder.getPrice().doubleValue();
        }
        double unit = 1.0;
        return price * unit;
    }

    private boolean isFree(OptionItemOrder supplement) throws BasicException {
        for (SupplementProduct option : this.product.getSupplements()) {
            if (option.getiD() != supplement.getId_groupe_option()) continue;
            return option.isFree_able();
        }
        return false;
    }

    public void chooseOption(SupplementItemInfo optionItem, Button btnOption, SupplementProduct option) {
        if (this.existOption(optionItem) == -1) {
            this.addOption(optionItem, btnOption, option);
        } else {
            this.deleteOption(optionItem, option, btnOption);
            this.price_product.setText(this.printPrice(this.getProductPrice()));
            this.reloadPriceOptions(option);
        }
    }

    private void addOption(SupplementItemInfo optionItem, Button btnOption, SupplementProduct option) {
        String id_global_carte;
        boolean free = false;
        boolean next_option = false;
        int id_carte = this.currentCarte != null ? this.currentCarte.getId() : -1;
        int id_product_item = this.currentProductItem != null ? this.currentProductItem.getID() : -1;
        String name_carte = this.currentCarte != null ? this.currentCarte.getName() : null;
        String name_product_item = this.currentProductItem != null ? this.currentProductItem.getName() : null;
        int index_carte = this.currentCarte != null ? this.currentCarte.getIndex_carte() : -1;
        String ref_product = this.currentProductItem != null ? this.currentProductItem.getRef_web() : null;
        String ref_carte = this.currentCarte != null ? this.currentCarte.getRef_web() : null;
        String id_global_product = this.currentProductItem != null ? this.currentProductItem.getId_global() : null;
        String string = id_global_carte = this.currentCarte != null ? this.currentCarte.getId_global() : null;
        if (this.listChoiceSupplement.size() > 0 && option.getHas_options().booleanValue() && option.getMax_options() == this.sizeOptions(option)) {
            this.deleteLastOption(option);
        }
        this.buttonOptions.put(optionItem.getiD(), btnOption);
        optionItem.setPrint_black_background(option.isPrint_black_background());
        if (this.isOptionFreeable(option) && optionItem.getPrice_order() > 0.0) {
            this.listChoiceSupplement.add(new OptionItemOrder(id_carte, id_product_item, name_product_item, name_carte, 1, option.getIsBold(), 0.0, index_carte, 1, option.isSeparate(), false, optionItem.getRef_web(), option.getiD(), option.getPrinter(), option.getShift_option(), option.isDisplay_screen_sorti(), ColorUtils.getColor(option.getColor()), optionItem, option.isNo_printable(), ref_product, ref_carte, option.getName(), false, id_global_product, id_global_carte));
            this.decrementOptionFree(option, 1);
            btnOption.getProperties().replace((Object)"price", (Object)0.0);
            free = true;
        } else {
            this.listChoiceSupplement.add(new OptionItemOrder(id_carte, id_product_item, name_product_item, name_carte, 1, option.getIsBold(), optionItem.getPrice_order(), index_carte, 0, option.isSeparate(), false, optionItem.getRef_web(), option.getiD(), option.getPrinter(), option.getShift_option(), option.isDisplay_screen_sorti(), ColorUtils.getColor(option.getColor()), optionItem, option.isNo_printable(), ref_product, ref_carte, option.getName(), false, id_global_product, id_global_carte));
        }
        this.selectOption(btnOption, !optionItem.getGroupsSubSupplement().isEmpty());
        Object name = optionItem.getDisplayedName().toUpperCase();
        if (free) {
            name = (String)name + "\n Offert";
        }
        btnOption.getProperties().replace((Object)"name", name);
        btnOption.getProperties().replace((Object)"quantity", (Object)1);
        if (this.listChoiceSupplement.size() > 0 && option.getHas_options().booleanValue() && option.getMax_options() == this.sizeOptions(option)) {
            next_option = true;
        }
        if ((optionItem.getGroupsSubSupplement() == null || optionItem.getGroupsSubSupplement().isEmpty()) && next_option) {
            try {
                this.nextOption();
            }
            catch (Exception ex) {
                Logger.getLogger(CatalogueController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.price_product.setText(this.printPrice(this.getProductPrice()));
        if (!next_option) {
            this.reloadPriceOptions(option);
        }
    }

    private int sizeOptions(SupplementProduct option) {
        int id_carte = this.currentCarte != null ? this.currentCarte.getId() : -1;
        int id_product_item = this.currentProductItem != null ? this.currentProductItem.getID() : -1;
        int index_carte = this.currentCarte != null ? this.currentCarte.getIndex_carte() : -1;
        int size = 0;
        try {
            for (OptionItemOrder optionItem : this.listChoiceSupplement) {
                for (SupplementItemInfo supplement : option.getItems()) {
                    if (optionItem.getIdCarte() != id_carte || optionItem.getIdProduct() != id_product_item || optionItem.getSupplement() != supplement.getiD() || optionItem.getIndex_carte() != index_carte) continue;
                    size += optionItem.getNumberOption();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return size;
    }

    private void nextOption() {
        this.result[6] = false;
        this.validProduct();
    }

    private void validProduct() {
        this.result[6] = !this.load_options;
        this.result[0] = this.product;
        this.result[1] = this.quantity;
        this.result[2] = this.mProductSizeInfo;
        this.result[3] = this.listChoiceIngredient;
        this.result[4] = true;
        this.result[5] = this.listChoiceSupplement;
        this.reset();
        this.stage.close();
    }

    public void validOptions() {
        this.result[6] = false;
        this.validProduct();
    }

    private void reloadInfoSupplement(ProductInfoExt product) {
        if (product.getSupplements() != null) {
            for (SupplementProduct supplement : product.getSupplements()) {
                supplement.reloadInfoSize(this.mProductSizeInfo != null ? this.mProductSizeInfo.getName() : null);
                for (SupplementItemInfo item : supplement.getItems()) {
                    item.setPrice_order(item.getPriceOption(this.mProductSizeInfo != null ? this.mProductSizeInfo.getName() : null, AppLocal.ticketBorne.getType()));
                    for (GroupSubSupplementInfo group_sub_item : item.getGroupsSubSupplement()) {
                        for (SupplementItemInfo sub_item : group_sub_item.getSupplements()) {
                            sub_item.setPrice_order(sub_item.getPriceOption(this.mProductSizeInfo != null ? this.mProductSizeInfo.getName() : null, AppLocal.ticketBorne.getType()));
                        }
                    }
                }
            }
        }
    }

    private void createImageView(ImageView image_view, Image image, double heightImage, double widthImage) {
        image_view.setImage(image);
        if (AppLocal.type_borne.equals("horizontal")) {
            image_view.setFitHeight(heightImage);
        } else {
            image_view.setFitWidth(widthImage);
        }
        image_view.setPreserveRatio(true);
        image_view.setSmooth(true);
        image_view.setCache(true);
    }

    public void reset() {
        this.panes_ingredients = null;
        this.pane_items = null;
    }

    private void addPreviousButtonItems(boolean add_switch_button, double height, double width, List<Button> buttons, EventHandler mEventHandlerPreviousItems) {
        boolean add_previous_button;
        boolean bl = add_previous_button = this.index_item != 0 && buttons.size() % this.max_items == 0;
        if (add_switch_button && add_previous_button) {
            Button button_previous = this.getButtonPrevious(width, height);
            button_previous.setOnAction(mEventHandlerPreviousItems);
            buttons.add(button_previous);
        }
    }

    private void addNextButtonItems(boolean add_switch_button, double height, double width, double number_items, List<Button> buttons, EventHandler mEventHandlerNextItems) {
        boolean add_next_button;
        boolean bl = add_next_button = (double)this.index_item != number_items - 1.0 && (buttons.size() + 1) % this.max_items == 0;
        if (add_switch_button && add_next_button) {
            Button button_next = this.getButtonNext(width, height);
            button_next.setOnAction(mEventHandlerNextItems);
            buttons.add(button_next);
        }
    }

    private void setTexts() {
        this.label_title_sizes.setText(AppLocal.getIntString("Label.sizes"));
        this.label_title_ingredients.setText(AppLocal.getIntString("Label.ingredients"));
        this.button_cancel.setText(AppLocal.getIntString("Button.cancel"));
        this.button_valid.setText(AppLocal.getIntString("Button.valid"));
    }

    public void showNutritionalValues() {
        this.nvController.toggleView();
        if (this.allergensController != null) {
            if (this.nvController.isDisplayed()) {
                this.allergensController.hideAllergens();
            } else {
                this.allergensController.showAllergens();
            }
        }
    }

    public static String[] extractAllergenNames(List<Allergene> allergensItems) {
        return (String[])allergensItems.stream().map(Allergene::getName).toArray(String[]::new);
    }
}

