/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.borne.ManagerBorneAuthController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;

public class BorneMaintenanceController
implements PropertyChangeListener {
    private JRootApp m_App;
    private Scene scene;
    @FXML
    ImageView logo;
    @FXML
    FlowPane parent_pane;
    @FXML
    StackPane stack_pane;
    private boolean managerAuthenticated;
    private LazyModal managerAuthLazyModal = null;
    private LazyModal managerSettingsLazyModal = null;
    private EventHiddenModal managerAuthActionEvent = null;
    private EventHiddenModal managerSettingsActionEvent = null;
    private List<Pos> blankBoxPositions;
    private int blankBoxPositionIndex = 0;
    private int clickCount = 0;
    @FXML
    VBox blankBoxVBox;

    public void initialize(JRootApp app, Scene scene) throws BasicException {
        this.m_App = app;
        this.scene = scene;
        File imageFile = new File(new File(System.getProperty("user.home")), "images/logos/" + AppLocal.LOGO_BORNE);
        if (imageFile.exists()) {
            this.logo.setImage(new Image(imageFile.toURI().toString()));
            this.logo.setFitHeight(this.stack_pane.getPrefWidth() * 0.17);
            this.logo.setFitWidth(this.stack_pane.getPrefWidth() * 0.17);
            this.logo.setPreserveRatio(false);
            this.logo.setSmooth(false);
            this.logo.setCache(false);
        }
        this.blankBoxVBox.setOnMouseClicked(event -> {
            double x = event.getX();
            double y = event.getY();
            if (x <= 100.0 && y <= 100.0) {
                ++this.clickCount;
                if (this.clickCount == 5) {
                    this.clickCount = 0;
                    this.m_App.showCaisse();
                }
            }
        });
        this.blankBoxPositions = new ArrayList<Pos>(){
            {
                this.add(Pos.TOP_RIGHT);
                this.add(Pos.BOTTOM_RIGHT);
                this.add(Pos.BOTTOM_LEFT);
                this.add(Pos.TOP_LEFT);
                this.add(Pos.TOP_RIGHT);
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void loadManagerAuthPopUp() {
        try {
            this.managerAuthActionEvent = new EventHiddenModal(){

                @Override
                public void onHidden() {
                    BorneMaintenanceController.this.managerAuthLazyModal.destroyEvents();
                    BorneMaintenanceController.this.managerAuthActionEvent = null;
                    if (BorneMaintenanceController.this.managerAuthenticated) {
                        BorneMaintenanceController.this.loadSettingsModal();
                    } else {
                        BorneMaintenanceController.this.parent_pane.setEffect(null);
                    }
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        ManagerBorneAuthController authController = (ManagerBorneAuthController)mBuilder.getController();
                        BorneMaintenanceController.this.managerAuthenticated = authController.isAuthenticated();
                    }
                    this.onHidden();
                }
            };
            if (this.managerAuthLazyModal == null) {
                this.managerAuthLazyModal = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fx/templates/borne/ManagerAuthTemplate.fxml", new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.9), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.6)));
            }
            if (this.parent_pane.getEffect() == null) {
                this.parent_pane.setEffect((Effect)new BoxBlur(6.0, 6.0, 4));
            }
            this.managerAuthLazyModal.setEventHiddenModal(this.managerAuthActionEvent);
            this.managerAuthLazyModal.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadSettingsModal() {
        try {
            this.managerSettingsActionEvent = new EventHiddenModal(){

                @Override
                public void onHidden() {
                    BorneMaintenanceController.this.managerAuthenticated = false;
                    BorneMaintenanceController.this.managerSettingsLazyModal.destroyEvents();
                    BorneMaintenanceController.this.managerSettingsActionEvent = null;
                    BorneMaintenanceController.this.parent_pane.setEffect(null);
                    if (!AppLocal.BORNE_IN_MAINTENANCE) {
                        BorneMaintenanceController.this.m_App.showBorne(true);
                    }
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    this.onHidden();
                }
            };
            if (this.managerSettingsLazyModal == null) {
                this.managerSettingsLazyModal = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fx/templates/borne/ManagerSettingsTemplate.fxml", new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.9), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.8)));
            }
            if (this.parent_pane.getEffect() == null) {
                this.parent_pane.setEffect((Effect)new BoxBlur(6.0, 6.0, 4));
            }
            this.managerSettingsLazyModal.setEventHiddenModal(this.managerSettingsActionEvent);
            this.managerSettingsLazyModal.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void moveBlankBox() {
        if (this.blankBoxPositionIndex == this.blankBoxPositions.size() - 1) {
            this.blankBoxPositionIndex = 0;
            this.clickCount = 0;
            this.loadManagerAuthPopUp();
        } else {
            ++this.blankBoxPositionIndex;
            this.blankBoxVBox.setAlignment(this.blankBoxPositions.get(this.blankBoxPositionIndex));
        }
    }
}

