/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.stage.Stage;

public class AvomarkController
implements RootController {
    private Stage stage;
    private Object[] result;
    @FXML
    private ImageView background;
    @FXML
    private Button btn_next;
    @FXML
    private Button use_code_btn;
    private TextField jTextFieldBarCodeScanner;
    @FXML
    private GridPane main_pane;
    private boolean userUseCode = false;
    @FXML
    ImageView header_logo;
    private EventHandler mEventHandlerBarCodeKeyReleased = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                AvomarkController.this.isBarCodeUpdated(AvomarkController.this.jTextFieldBarCodeScanner.getText().trim());
                AvomarkController.this.jTextFieldBarCodeScanner.requestFocus();
            }
        }
    };

    public void initializer() {
        try {
            this.result = new Object[1];
            this.jTextFieldBarCodeScanner = new TextField();
            this.initBarCodeScanner();
            this.jTextFieldBarCodeScanner.setManaged(false);
            this.main_pane.getChildren().clear();
            RowConstraints row1 = new RowConstraints();
            row1.setPercentHeight(58.0);
            RowConstraints row2 = new RowConstraints();
            row2.setPercentHeight(14.0);
            RowConstraints row3 = new RowConstraints();
            row3.setPercentHeight(14.0);
            this.main_pane.getRowConstraints().addAll((Object[])new RowConstraints[]{row1, row2, row3});
            GridPane ScanGrid = new GridPane();
            ScanGrid.setAlignment(Pos.CENTER);
            GridPane.setFillWidth((Node)ScanGrid, (Boolean)true);
            GridPane.setFillHeight((Node)ScanGrid, (Boolean)true);
            ScanGrid.setPrefHeight(this.main_pane.getPrefHeight() * 0.6);
            ScanGrid.prefWidth(this.main_pane.getPrefWidth() * 0.7);
            GridPane ScanGrid_buttom = new GridPane();
            ScanGrid_buttom.setPrefHeight(this.main_pane.getPrefHeight() * 0.2);
            ScanGrid_buttom.prefWidth(this.main_pane.getPrefWidth() * 0.6);
            ScanGrid.add((Node)this.jTextFieldBarCodeScanner, 0, 0);
            GridPane.setHalignment((Node)this.btn_next, (HPos)HPos.CENTER);
            GridPane.setHalignment((Node)this.use_code_btn, (HPos)HPos.CENTER);
            this.jTextFieldBarCodeScanner.setOnKeyReleased(this.mEventHandlerBarCodeKeyReleased);
            Image imagebackScan = new Image(this.getClass().getResourceAsStream("/images/avomark_borne_bg_1.png"));
            this.background.setImage(imagebackScan);
            this.main_pane.add((Node)ScanGrid, 0, 0);
            this.main_pane.add((Node)this.use_code_btn, 0, 1);
            this.main_pane.add((Node)this.btn_next, 0, 2);
            this.main_pane.add((Node)ScanGrid_buttom, 0, 3);
            this.setLogo();
        }
        catch (Exception ex) {
            Logger.getLogger(AvomarkController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.initializer();
    }

    public Object[] getResult() {
        return this.result;
    }

    public void next() {
        this.stage.close();
    }

    private void initBarCodeScanner() {
        this.jTextFieldBarCodeScanner.setVisible(true);
        this.jTextFieldBarCodeScanner.requestFocus();
        this.jTextFieldBarCodeScanner.setText("");
        System.setProperty("javafx.scene.input.keyboard", "US");
        this.jTextFieldBarCodeScanner.getProperties().put((Object)"javafx.scene.input.keyboard", (Object)"US");
        this.jTextFieldBarCodeScanner.getProperties().put((Object)"vkType", (Object)4);
    }

    private void isBarCodeUpdated(String codeBar) {
        String cleanedBarCode = codeBar.replaceAll("[^a-zA-Z0-9]", "").trim();
        if (cleanedBarCode.startsWith("*")) {
            cleanedBarCode = cleanedBarCode.substring(1);
        }
        if (cleanedBarCode.endsWith("*")) {
            cleanedBarCode = cleanedBarCode.substring(0, cleanedBarCode.length() - 1);
        }
        System.out.println("**************** Scanned BAR CODE Cleaned: " + cleanedBarCode);
        if (cleanedBarCode.matches("\\d{15}")) {
            System.out.println("************** Bar Code is valid: " + cleanedBarCode);
            this.result[0] = cleanedBarCode;
            this.next();
        } else {
            System.out.println("************** Invalid Bar Code format");
            this.jTextFieldBarCodeScanner.setText("");
        }
    }

    public void useCode() {
        this.userUseCode = true;
        this.stage.close();
    }

    public boolean wantToUseCode() {
        return this.userUseCode;
    }

    public void setLogo() {
        File image;
        Image image_logo = null;
        if (AppLocal.LOGO_BORNE != null && !AppLocal.LOGO_BORNE.isEmpty() && (image = new File(new File(System.getProperty("user.home")), "images/logos/" + AppLocal.LOGO_BORNE)).exists()) {
            image_logo = new Image(image.toURI().toString());
        }
        if (image_logo != null) {
            this.header_logo = new ImageView(image_logo);
            this.header_logo.setFitHeight(200.0);
            this.header_logo.setFitWidth(200.0);
        }
    }
}

