/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.procaisse.avomark.AvomarkClient;
import com.procaisse.avomark.AvomarkService;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class AvomarkConfirmLoyaltyController
implements RootController {
    private Stage stage;
    @FXML
    Label user_cagnote_label;
    @FXML
    Label error;
    @FXML
    Label availableAmount;
    @FXML
    Label blankBox1;
    @FXML
    Label blankBox2;
    @FXML
    Label titleMessage;
    @FXML
    Button close_btn;
    @FXML
    FlowPane main_pane;
    @FXML
    StackPane cagnote_stack_pane;
    @FXML
    FlowPane confirm_step_1_pane;
    @FXML
    FlowPane confirm_step_2_pane;
    @FXML
    TextField amountToUse;
    @FXML
    HBox buttons_pane;
    @FXML
    Button btn_1;
    @FXML
    Button btn_2;
    @FXML
    Button btn_3;
    @FXML
    Button btn_4;
    @FXML
    Button btn_5;
    @FXML
    Button btn_6;
    @FXML
    Button btn_7;
    @FXML
    Button btn_8;
    @FXML
    Button btn_9;
    @FXML
    Button btn_0;
    @FXML
    Button btn_dot;
    @FXML
    Button btn_validate;
    @FXML
    Button btn_cancel;
    private AvomarkService mAvomarkService;
    private boolean isCashier;
    private String amount = "";
    private Double finalLoyaltyAmount = null;
    double cagnote = 12.0;

    public void initialize() {
        this.isCashier = AppLocal.MODE_DISPLAY.equals("Caisse");
        AvomarkClient mAvomarkClient = AppLocal.currentAvomarkClient;
        this.mAvomarkService = AvomarkService.getInstance();
        Map<String, Double> userBalance = this.mAvomarkService.getUsernameAndBalance(mAvomarkClient);
        for (Map.Entry<String, Double> entry : userBalance.entrySet()) {
            this.cagnote = entry.getValue();
        }
        this.user_cagnote_label.setText(Formats.CURRENCY.formatValue(this.cagnote));
        this.availableAmount.setText(Formats.CURRENCY.formatValue(this.cagnote));
        if (this.isCashier) {
            this.blankBox1.setVisible(false);
            this.blankBox1.setManaged(false);
            this.blankBox2.setVisible(false);
            this.blankBox2.setManaged(false);
            this.buttons_pane.setPrefHeight(this.main_pane.getHeight() * 0.09);
            this.amountToUse.setPrefHeight(60.0);
            this.confirm_step_2_pane.setVgap(5.0);
            this.availableAmount.setStyle("-fx-font-size: 20pt; -fx-text-fill: black;");
            this.titleMessage.setStyle("-fx-font-size: 15pt; -fx-text-fill: black;");
            this.amountToUse.setStyle("-fx-font-size: 15pt; -fx-font-weight: bold; -fx-background-color: white; -fx-text-fill: black; -fx-border-color: orange; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-border-width: 2px;");
            this.btn_validate.setStyle("-fx-text-fill: white; -fx-font-size: 14pt; -fx-background-color: green; -fx-border-radius: 15px; -fx-background-radius: 15px;");
            this.btn_validate.setText("VALIDER");
            this.btn_cancel.setStyle("-fx-background-color: white; -fx-font-size: 14pt; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-border-color: gray;");
            this.btn_cancel.setText("ANNULER");
        } else {
            this.buttons_pane.setPrefHeight(this.main_pane.getHeight() * 0.15);
            this.amountToUse.setPrefHeight(80.0);
            this.confirm_step_2_pane.setVgap(20.0);
            this.availableAmount.setStyle("-fx-font-size: 30pt; -fx-text-fill: black;");
            this.titleMessage.setStyle("-fx-font-size: 23pt; -fx-text-fill: black;");
            this.amountToUse.setStyle("-fx-font-size: 25pt; -fx-font-weight: bold; -fx-background-color: white; -fx-text-fill: black; -fx-border-color: orange; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-border-width: 2px;");
            this.btn_validate.setStyle("-fx-text-fill: white; -fx-font-size: 17pt; -fx-background-color: green; -fx-border-radius: 15px; -fx-background-radius: 15px;");
            this.btn_validate.setText("J'UTILISE MA CAGNOTE");
            this.btn_cancel.setStyle("-fx-background-color: white; -fx-font-size: 17pt; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-border-color: gray;");
            this.btn_cancel.setText("PAS MAINTENANT");
        }
        this.btn_0.setOnAction(event -> this.insertValue(this.btn_1, "0"));
        this.btn_1.setOnAction(event -> this.insertValue(this.btn_1, "1"));
        this.btn_2.setOnAction(event -> this.insertValue(this.btn_2, "2"));
        this.btn_3.setOnAction(event -> this.insertValue(this.btn_3, "3"));
        this.btn_4.setOnAction(event -> this.insertValue(this.btn_4, "4"));
        this.btn_5.setOnAction(event -> this.insertValue(this.btn_5, "5"));
        this.btn_6.setOnAction(event -> this.insertValue(this.btn_6, "6"));
        this.btn_7.setOnAction(event -> this.insertValue(this.btn_7, "7"));
        this.btn_8.setOnAction(event -> this.insertValue(this.btn_8, "8"));
        this.btn_9.setOnAction(event -> this.insertValue(this.btn_9, "9"));
        this.btn_dot.setOnAction(event -> this.insertValue(this.btn_dot, "."));
        this.fitSize();
    }

    public void continueWithoutLoyalty() {
        this.finalLoyaltyAmount = null;
        this.stage.close();
    }

    public void continueWithLoyalty() {
        this.confirm_step_1_pane.setManaged(false);
        this.confirm_step_1_pane.setVisible(false);
        this.confirm_step_2_pane.setManaged(true);
        this.confirm_step_2_pane.setVisible(true);
    }

    public Double getLoyaltyAmountToBeUsed() {
        return this.finalLoyaltyAmount;
    }

    public void close() {
        this.finalLoyaltyAmount = null;
        this.stage.close();
    }

    public void validateAmount() {
        if (this.amount.isEmpty()) {
            this.error.setText("Veuillez saisir un montant.");
            return;
        }
        this.finalLoyaltyAmount = Double.valueOf(this.amount);
        if (this.finalLoyaltyAmount == 0.0) {
            this.finalLoyaltyAmount = null;
        }
        this.stage.close();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initialize();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initialize();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.initialize();
    }

    private void fitSize() {
        if (AppLocal.modeCaisse == null || AppLocal.modeCaisse.equals("Caisse")) {
            this.cagnote_stack_pane.setVisible(false);
            this.cagnote_stack_pane.setManaged(false);
            this.close_btn.setVisible(false);
            this.close_btn.setManaged(false);
        }
    }

    @FXML
    public void insertValue(Button btn, String value) {
        this.error.setText("");
        if (this.amount.length() == 6) {
            return;
        }
        if (this.amount.length() == 0 && value.equals(".")) {
            return;
        }
        if (this.amount.contains(".") && value.equals(".")) {
            return;
        }
        if (Double.parseDouble(this.amount.concat(value)) <= this.cagnote) {
            this.amount = this.amount.concat(value);
            this.amountToUse.setText(this.amount);
            System.out.println(this.amount);
        } else {
            this.error.setText("Vous ne pouvez d\u00e9passer le montant disponible.");
        }
    }

    public void removeLastDigit() {
        this.error.setText("");
        if (!this.amountToUse.getText().isEmpty()) {
            int length = this.amount.length();
            this.amount = this.amount.substring(0, length - 1);
            this.amountToUse.setText(this.amount);
        }
    }
}

