/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.avomark.AvomarkClient;
import com.procaisse.avomark.AvomarkService;
import com.procaisse.avomark.CardAvomark;
import java.io.File;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class AvomarkCodeController
implements RootController {
    private Stage stage;
    @FXML
    Label error;
    @FXML
    Label header;
    @FXML
    Label title;
    @FXML
    ImageView header_logo;
    @FXML
    TextField user_code;
    @FXML
    FlowPane main_pane;
    @FXML
    FlowPane buttons_pane;
    @FXML
    Button btn_1;
    @FXML
    Button btn_2;
    @FXML
    Button btn_3;
    @FXML
    Button btn_4;
    @FXML
    Button btn_5;
    @FXML
    Button btn_6;
    @FXML
    Button btn_7;
    @FXML
    Button btn_8;
    @FXML
    Button btn_9;
    @FXML
    Button btn_0;
    @FXML
    Button btn_A;
    @FXML
    Button btn_B;
    @FXML
    Button btn_C;
    @FXML
    Button btn_D;
    @FXML
    Button btn_E;
    @FXML
    Button btn_F;
    @FXML
    Button btn_G;
    @FXML
    Button btn_H;
    @FXML
    Button btn_I;
    @FXML
    Button btn_J;
    @FXML
    Button btn_K;
    @FXML
    Button btn_L;
    @FXML
    Button btn_M;
    @FXML
    Button btn_N;
    @FXML
    Button btn_O;
    @FXML
    Button btn_P;
    @FXML
    Button btn_Q;
    @FXML
    Button btn_R;
    @FXML
    Button btn_S;
    @FXML
    Button btn_T;
    @FXML
    Button btn_U;
    @FXML
    Button btn_V;
    @FXML
    Button btn_W;
    @FXML
    Button btn_X;
    @FXML
    Button btn_Y;
    @FXML
    Button btn_Z;
    @FXML
    StackPane stack_pane;
    private String code = "-";
    private boolean authenticated = false;
    private Object[] result;
    private AvomarkService mAvomarkService;
    private final String color = ColorUtils.getColor(AppLocal.color_borne);
    String style = "-fx-font-weight: Normal; -fx-font-size: 20pt; -fx-text-fill: ";
    private TextField user_card_scan;
    @FXML
    private Button btn_authenticate;
    @FXML
    private Button btn_cancel;
    private EventHandler mEventHandlerBarCodeKeyReleased = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                AvomarkCodeController.this.error.setText("");
                AvomarkCodeController.this.isBarCodeUpdated(AvomarkCodeController.this.user_card_scan.getText().trim());
                AvomarkCodeController.this.user_card_scan.requestFocus();
            }
        }
    };

    public void initializer() {
        Platform.runLater(() -> this.fitSize());
        this.result = new Object[1];
        this.mAvomarkService = AvomarkService.getInstance();
        this.error.setText("");
        this.btn_1.setOnAction(event -> this.insertValue(this.btn_1, "1"));
        this.btn_2.setOnAction(event -> this.insertValue(this.btn_2, "2"));
        this.btn_3.setOnAction(event -> this.insertValue(this.btn_3, "3"));
        this.btn_4.setOnAction(event -> this.insertValue(this.btn_4, "4"));
        this.btn_5.setOnAction(event -> this.insertValue(this.btn_5, "5"));
        this.btn_6.setOnAction(event -> this.insertValue(this.btn_6, "6"));
        this.btn_7.setOnAction(event -> this.insertValue(this.btn_7, "7"));
        this.btn_8.setOnAction(event -> this.insertValue(this.btn_8, "8"));
        this.btn_9.setOnAction(event -> this.insertValue(this.btn_9, "9"));
        this.btn_0.setOnAction(event -> this.insertValue(this.btn_0, "0"));
        this.btn_A.setOnAction(event -> this.insertValue(this.btn_A, "A"));
        this.btn_B.setOnAction(event -> this.insertValue(this.btn_B, "B"));
        this.btn_C.setOnAction(event -> this.insertValue(this.btn_C, "C"));
        this.btn_D.setOnAction(event -> this.insertValue(this.btn_D, "D"));
        this.btn_E.setOnAction(event -> this.insertValue(this.btn_E, "E"));
        this.btn_F.setOnAction(event -> this.insertValue(this.btn_F, "F"));
        this.btn_G.setOnAction(event -> this.insertValue(this.btn_G, "G"));
        this.btn_H.setOnAction(event -> this.insertValue(this.btn_H, "H"));
        this.btn_I.setOnAction(event -> this.insertValue(this.btn_I, "I"));
        this.btn_J.setOnAction(event -> this.insertValue(this.btn_J, "J"));
        this.btn_K.setOnAction(event -> this.insertValue(this.btn_K, "K"));
        this.btn_L.setOnAction(event -> this.insertValue(this.btn_L, "L"));
        this.btn_M.setOnAction(event -> this.insertValue(this.btn_M, "M"));
        this.btn_N.setOnAction(event -> this.insertValue(this.btn_N, "N"));
        this.btn_O.setOnAction(event -> this.insertValue(this.btn_O, "O"));
        this.btn_P.setOnAction(event -> this.insertValue(this.btn_P, "P"));
        this.btn_Q.setOnAction(event -> this.insertValue(this.btn_Q, "Q"));
        this.btn_R.setOnAction(event -> this.insertValue(this.btn_R, "R"));
        this.btn_S.setOnAction(event -> this.insertValue(this.btn_S, "S"));
        this.btn_T.setOnAction(event -> this.insertValue(this.btn_T, "T"));
        this.btn_U.setOnAction(event -> this.insertValue(this.btn_U, "U"));
        this.btn_V.setOnAction(event -> this.insertValue(this.btn_V, "V"));
        this.btn_W.setOnAction(event -> this.insertValue(this.btn_W, "W"));
        this.btn_X.setOnAction(event -> this.insertValue(this.btn_X, "X"));
        this.btn_Y.setOnAction(event -> this.insertValue(this.btn_Y, "Y"));
        this.btn_Z.setOnAction(event -> this.insertValue(this.btn_Z, "Z"));
        this.user_code.setStyle("-fx-font-size: 25pt; -fx-font-weight: bold; -fx-background-color: white; -fx-text-fill: black; -fx-border-color: " + this.color + "; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-border-width: 2px;");
        this.main_pane.setStyle("-fx-background-color: whitesmoke; -fx-border-color: " + this.color + "; -fx-border-width: 2px;");
        this.user_card_scan = new TextField();
        this.initBarCodeScanner();
        this.user_card_scan.setManaged(false);
        this.user_card_scan.setOnKeyReleased(this.mEventHandlerBarCodeKeyReleased);
        this.buttons_pane.getChildren().clear();
        this.buttons_pane.getChildren().add((Object)this.btn_authenticate);
        this.buttons_pane.getChildren().add((Object)this.btn_cancel);
        this.buttons_pane.getChildren().add((Object)this.user_card_scan);
        this.main_pane.setOnMouseClicked(event -> this.user_card_scan.requestFocus());
    }

    public void cancel() {
        this.authenticated = false;
        this.result[0] = null;
        this.stage.close();
    }

    public void authenticate() {
        if (this.code.length() == 0 || "-".equals(this.code)) {
            return;
        }
        AvomarkClient mAvomarkClient = this.getAvomarkClient(this.code);
        boolean bl = this.authenticated = mAvomarkClient != null;
        if (this.authenticated) {
            System.out.println("********mAvomarkClient : " + mAvomarkClient.toString());
            this.result[0] = mAvomarkClient;
            this.stage.close();
        } else {
            this.error.setText("Code de fid\u00e9lit\u00e9 invalide");
            this.error.setStyle(this.style + "red;");
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.initializer();
    }

    public Object[] getResult() {
        return this.result;
    }

    @FXML
    public void insertValue(Button btn, String value) {
        this.error.setText("");
        if ("-".equals(this.code)) {
            this.code = "";
        }
        if (this.code.length() == 15) {
            return;
        }
        this.code = this.code.concat(value);
        this.user_code.setText(this.code);
    }

    public void removeLastDigit() {
        this.error.setText("");
        if (!this.user_code.getText().isEmpty()) {
            int length = this.code.length();
            this.code = this.code.substring(0, length - 1);
            this.user_code.setText(this.code);
        }
    }

    private void fitSize() {
        if (AppLocal.modeCaisse == null || AppLocal.modeCaisse.equals("Caisse")) {
            this.header.setVisible(false);
            this.header.setManaged(false);
            this.main_pane.setTranslateY(0.0);
            this.main_pane.maxHeightProperty().unbind();
            this.main_pane.setMaxHeight(this.stack_pane.getHeight());
            this.main_pane.prefHeightProperty().unbind();
            this.main_pane.setPrefHeight(this.stack_pane.getHeight());
        } else {
            this.setLogo();
        }
    }

    public void setLogo() {
        File image;
        Image image_logo = null;
        if (AppLocal.LOGO_BORNE != null && !AppLocal.LOGO_BORNE.isEmpty() && (image = new File(new File(System.getProperty("user.home")), "images/logos/" + AppLocal.LOGO_BORNE)).exists()) {
            image_logo = new Image(image.toURI().toString());
        }
        if (image_logo != null) {
            this.header_logo = new ImageView(image_logo);
            this.header_logo.setFitHeight(200.0);
            this.header_logo.setFitWidth(200.0);
        }
    }

    public AvomarkClient getAvomarkClient(String code) {
        AvomarkClient mAvomarkClient = null;
        try {
            HashMap<String, Object> customerData;
            if (this.mAvomarkService == null) {
                this.mAvomarkService = AvomarkService.getInstance();
            }
            if ((customerData = this.mAvomarkService.getIDClientByCode(code)) != null && !customerData.isEmpty()) {
                long idcustomer = (Long)customerData.get("id_customer");
                String card = (String)customerData.get("card");
                if (idcustomer != 0L) {
                    System.out.println("************here ");
                    this.error.setText("Chargement des d\u00e9tails du client...");
                    this.error.setStyle(this.style + "green;");
                    if (card != null && !card.isEmpty()) {
                        CardAvomark mCardAvomark = this.mAvomarkService.getCardAvomark(card);
                        mAvomarkClient = this.mAvomarkService.getClientById(idcustomer);
                        mAvomarkClient.setmCardAvomark(mCardAvomark);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return mAvomarkClient;
    }

    private void initBarCodeScanner() {
        this.user_card_scan.setVisible(true);
        this.user_card_scan.setText("");
        System.setProperty("javafx.scene.input.keyboard", "US");
        this.user_card_scan.getProperties().put((Object)"javafx.scene.input.keyboard", (Object)"US");
        this.user_card_scan.getProperties().put((Object)"vkType", (Object)4);
        Platform.runLater(() -> this.user_card_scan.requestFocus());
    }

    private void isBarCodeUpdated(String codeBar) {
        String cleanedBarCode = codeBar.replaceAll("[^a-zA-Z0-9]", "").trim();
        if (cleanedBarCode.startsWith("*")) {
            cleanedBarCode = cleanedBarCode.substring(1);
        }
        if (cleanedBarCode.endsWith("*")) {
            cleanedBarCode = cleanedBarCode.substring(0, cleanedBarCode.length() - 1);
        }
        System.out.println("**************** Scanned BAR CODE Cleaned: " + cleanedBarCode);
        if (cleanedBarCode.matches("\\d{15}")) {
            System.out.println("************** Bar Code is valid: " + cleanedBarCode);
            this.result[0] = this.getAvomarkClientByCard(cleanedBarCode);
            this.stage.close();
        } else {
            System.out.println("************** Invalid Bar Code format");
            this.user_card_scan.setText("");
            this.error.setText("Code de fid\u00e9lit\u00e9 invalide, veuillez rescanner. ");
            this.error.setStyle(this.style + "red;");
        }
    }

    public AvomarkClient getAvomarkClientByCard(String cardNumber) {
        if (this.mAvomarkService == null) {
            this.mAvomarkService = AvomarkService.getInstance();
        }
        return this.mAvomarkService.getAvomarkClient(cardNumber);
    }
}

