/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers.borne;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.borne.IOptionItem;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.IngredientItem;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItem;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.ImagesUtils;
import fr.protactile.procaisse.dao.entities.TagInfo;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;

public class AbstractController {
    protected String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    protected String text_color_borne_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
    protected int price_position;
    protected HashMap<Integer, Pos> price_positions;
    protected List<Button> buttonItems;
    protected String color_backgound = "#FFFFFF";
    protected GridPane[] pane_items;
    protected int number_page_item;
    protected int MAX_LINE_OPTION;
    protected int MAX_COLUMN_OPTION;
    protected DataLogicSales dlSales;
    protected DataLogicItems dlItems;
    protected HashMap<Integer, SoftReference> refProducts;
    protected HashMap<Integer, SoftReference> refProductsOrigins;
    protected FilerUtils m_FilerUtils = null;
    protected HashMap<Integer, SoftReference> refPlats;
    protected HashMap<Integer, SoftReference> refPlatsOrigins;
    protected Image image_ingredient_selected;
    protected HashMap<Integer, SoftReference> refOptions;
    protected ImagesUtils mImagesUtils;
    protected int buttons_of_line_options;
    protected double max_lines_options;
    protected Image imagePreviousItems;
    protected Image imageNextItems;
    protected int max_items;
    protected double height_option;
    protected double width_option;
    protected HashMap<Integer, ImageView> imagesViewCatalogOptions;
    protected int index_item;
    protected List<Double> image_option_heights;
    protected List<Double> image_goption_heights;
    protected List<Double> image_option_width;
    protected HashMap<Integer, SoftReference> refIngredient;
    protected Image imagePreviousItemProducts;
    protected Image imageNextItemProducts;
    private String BLACK_COLOR = "Noir";
    protected final String SIZE_IMAGE_512 = "_512px";
    private final String SIZE_IMAGE_256 = "_256px";
    private final String SIZE_IMAGE_128 = "_128px";
    private final String SIZE_IMAGE_64 = "_64px";
    protected final String DISCOUNT_TEXT_FILL_COLOR = "blue";
    protected HashMap<Integer, SoftReference> refTags;
    protected FilerUtils mFilerUtils;
    protected HashMap<Integer, SoftReference> refProductsMoment;
    protected HashMap<Integer, SoftReference> refCategoriesMoment;

    protected void init() {
        this.price_position = AppLocal.POSITION_PRICE == null || AppLocal.POSITION_PRICE.isEmpty() ? 2 : Integer.parseInt(AppLocal.POSITION_PRICE);
        this.price_positions = new HashMap();
        this.price_positions.put(0, Pos.BOTTOM_LEFT);
        this.price_positions.put(1, Pos.BOTTOM_CENTER);
        this.price_positions.put(2, Pos.BOTTOM_RIGHT);
    }

    protected void deselectOption(Button btnOption) {
        btnOption.setStyle("-fx-background-color:  transparent; -fx-text-fill: #000000;");
        if (btnOption.getProperties().get((Object)"paneMain") != null) {
            ((GridPane)btnOption.getProperties().get((Object)"paneMain")).setStyle("-fx-background-color: white; ; -fx-background-radius: 1em");
        }
        if (btnOption.getProperties().get((Object)"label") != null) {
            ((Label)btnOption.getProperties().get((Object)"label")).setStyle("-fx-font-size: 11pt; -fx-font-family : " + AppLocal.FONT_FAMILY_OPTIONS + "; -fx-text-fill: #000000;");
        }
        if (btnOption.getProperties().get((Object)"footer_pane") != null) {
            GridPane footer_pane = (GridPane)btnOption.getProperties().get((Object)"footer_pane");
            footer_pane.getChildren().clear();
        }
    }

    protected void selectOption(Button btnOption, boolean has_supplements) {
        btnOption.setStyle("-fx-background-color:  transparent; -fx-text-fill: " + this.text_color_borne_hex + ";");
        if (btnOption.getProperties().get((Object)"paneMain") != null) {
            ((GridPane)btnOption.getProperties().get((Object)"paneMain")).setStyle("-fx-background-color: " + this.color_hex + "; -fx-background-radius: 1em");
        }
        if (btnOption.getProperties().get((Object)"label") != null) {
            ((Label)btnOption.getProperties().get((Object)"label")).setStyle("-fx-font-size: 11pt; -fx-font-family : " + AppLocal.FONT_FAMILY_OPTIONS + "; -fx-text-fill: " + this.text_color_borne_hex + ";");
        }
        if (btnOption.getProperties().get((Object)"footer_pane") != null && btnOption.getProperties().get((Object)"increaseQtt") != null && btnOption.getProperties().get((Object)"decreaseQtt") != null && btnOption.getProperties().get((Object)"labelQtt") != null) {
            GridPane footer_pane = (GridPane)btnOption.getProperties().get((Object)"footer_pane");
            Button increaseQtt = (Button)btnOption.getProperties().get((Object)"increaseQtt");
            Button decreaseQtt = (Button)btnOption.getProperties().get((Object)"decreaseQtt");
            Label labelQtt = (Label)btnOption.getProperties().get((Object)"labelQtt");
            footer_pane.getChildren().clear();
            footer_pane.add((Node)decreaseQtt, 0, 0);
            footer_pane.add((Node)labelQtt, 1, 0);
            footer_pane.add((Node)increaseQtt, 2, 0);
        }
    }

    protected void rangeOption(List<Button> items, double height_button, double width_button, double height_bloc_option, double width_bloc_option) {
        this.number_page_item = (int)Math.ceil((double)items.size() / (this.max_lines_options * (double)this.buttons_of_line_options));
        this.pane_items = new GridPane[this.number_page_item];
        for (int i = 0; i < this.number_page_item; ++i) {
            this.pane_items[i] = new GridPane();
            this.pane_items[i].setVgap(10.0);
            this.pane_items[i].setHgap(10.0);
            this.pane_items[i].setAlignment(Pos.CENTER);
            this.pane_items[i].setStyle("-fx-background-color: " + this.color_backgound + ";");
        }
        int index_item = 0;
        int column_item = 0;
        int row_item = 0;
        for (Button buttonItem : items) {
            this.pane_items[index_item].add((Node)buttonItem, column_item, row_item);
            if (column_item < this.buttons_of_line_options - 1) {
                ++column_item;
                continue;
            }
            if ((double)row_item < this.max_lines_options - 1.0) {
                ++row_item;
                column_item = 0;
                continue;
            }
            ++index_item;
            row_item = 0;
            column_item = 0;
        }
    }

    protected void rangeSubOption(List<Button> items, double height_button, double width_button, double height_bloc_option, double width_bloc_option) {
        double height_items = height_bloc_option;
        int buttons_of_line = (int)(width_bloc_option / width_button);
        buttons_of_line = buttons_of_line > this.MAX_COLUMN_OPTION ? this.MAX_COLUMN_OPTION : buttons_of_line;
        double max_lines = (int)Math.round(height_items / height_button);
        System.out.println("++++++++++ max_lines_options : " + max_lines);
        System.out.println("++++++++++ buttons_of_line_options : " + buttons_of_line);
        this.number_page_item = (int)Math.ceil((double)items.size() / (max_lines * (double)buttons_of_line));
        System.out.println("++++++++++ number_page_item : " + this.number_page_item);
        this.pane_items = new GridPane[this.number_page_item];
        for (int i = 0; i < this.number_page_item; ++i) {
            this.pane_items[i] = new GridPane();
            this.pane_items[i].setVgap(2.0);
            this.pane_items[i].setHgap(2.0);
            this.pane_items[i].setAlignment(Pos.CENTER);
            this.pane_items[i].setStyle("-fx-background-color: " + this.color_backgound + ";");
        }
        int index_item = 0;
        int column_item = 0;
        int row_item = 0;
        GridPane pane_line_items = this.getPaneLineItem();
        for (Button buttonItem : items) {
            pane_line_items.add((Node)buttonItem, column_item, 0);
            if (column_item < buttons_of_line - 1) {
                ++column_item;
                continue;
            }
            this.pane_items[index_item].add((Node)pane_line_items, 0, row_item);
            if ((double)row_item < max_lines - 1.0) {
                ++row_item;
                column_item = 0;
                pane_line_items = this.getPaneLineItem();
                continue;
            }
            ++index_item;
            row_item = 0;
            column_item = 0;
            pane_line_items = this.getPaneLineItem();
        }
        if (pane_line_items.getChildren().size() > 0) {
            this.pane_items[index_item].add((Node)pane_line_items, 0, row_item);
        }
    }

    protected GridPane getPaneLineItem() {
        GridPane pane_line_items = new GridPane();
        pane_line_items.setVgap(2.0);
        pane_line_items.setHgap(2.0);
        pane_line_items.setAlignment(Pos.CENTER);
        pane_line_items.setStyle("-fx-background-color: " + this.color_backgound + ";");
        return pane_line_items;
    }

    private String getNewName(String name_option) {
        CharSequence[] name_texts = name_option.replace(" ", ",").split(",");
        if (name_texts.length > 0) {
            String concat = name_texts[0].concat("s");
            name_texts[0] = concat;
        }
        String name = String.join((CharSequence)" ", name_texts);
        return name;
    }

    protected double getMax(List<Double> heights) {
        if (heights.size() > 0) {
            double max = heights.get(0);
            for (Double image_height : heights) {
                if (!(max < image_height)) continue;
                max = image_height;
            }
            return max;
        }
        return 0.0;
    }

    protected void reloadPriceOptions(boolean isOptionFreeable) {
        if (isOptionFreeable) {
            this.buttonItems.forEach(buttonItem -> {
                if (buttonItem.getProperties().get((Object)"name") != null) {
                    String name = (String)buttonItem.getProperties().get((Object)"name");
                    Integer number_option = (Integer)buttonItem.getProperties().get((Object)"quantity");
                    if (buttonItem.getProperties().get((Object)"label") != null) {
                        ((Label)buttonItem.getProperties().get((Object)"label")).setText(name.toUpperCase());
                    } else {
                        buttonItem.setText(name.toUpperCase());
                    }
                    if (buttonItem.getProperties().get((Object)"labelQtt") != null) {
                        ((Label)buttonItem.getProperties().get((Object)"labelQtt")).setText(String.valueOf(number_option));
                    }
                    if (buttonItem.getProperties().get((Object)"panePrice") != null) {
                        ((GridPane)buttonItem.getProperties().get((Object)"panePrice")).getChildren().clear();
                    }
                }
            });
        } else {
            this.buttonItems.forEach(buttonItem -> {
                if (buttonItem.getProperties().get((Object)"name") != null && buttonItem.getProperties().get((Object)"price") != null) {
                    double price = (Double)buttonItem.getProperties().get((Object)"price");
                    Object name = (String)buttonItem.getProperties().get((Object)"name");
                    Integer number_option = (Integer)buttonItem.getProperties().get((Object)"quantity");
                    if (price != 0.0) {
                        if (buttonItem.getProperties().get((Object)"panePrice") != null && buttonItem.getProperties().get((Object)"labelPrice") != null) {
                            GridPane panePrice = (GridPane)buttonItem.getProperties().get((Object)"panePrice");
                            Label labelPrice = (Label)buttonItem.getProperties().get((Object)"labelPrice");
                            panePrice.getChildren().clear();
                            panePrice.add((Node)labelPrice, 0, 0);
                        }
                        name = (String)name + "\n+" + Formats.CURRENCY.formatValue(price);
                    } else if (buttonItem.getProperties().get((Object)"panePrice") != null) {
                        ((GridPane)buttonItem.getProperties().get((Object)"panePrice")).getChildren().clear();
                    }
                    if (buttonItem.getProperties().get((Object)"label") != null) {
                        ((Label)buttonItem.getProperties().get((Object)"label")).setText(((String)name).toUpperCase());
                    } else {
                        buttonItem.setText(((String)name).toUpperCase());
                    }
                    if (buttonItem.getProperties().get((Object)"labelQtt") != null) {
                        ((Label)buttonItem.getProperties().get((Object)"labelQtt")).setText(String.valueOf(number_option));
                    }
                }
            });
        }
    }

    protected int indice_line_dessert(int id_dessert) {
        int found = -1;
        int index = 0;
        for (TicketLineInfo line : AppLocal.ticketBorne.getLines()) {
            if (line.getId_dessert() == id_dessert) {
                found = index;
                break;
            }
            ++index;
        }
        return found;
    }

    protected String printMultiplity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    protected void loadInfoProduct(ProductInfoExt product, boolean calculOptionFree, List<OptionItemOrder> listChoiceSupplement) throws BasicException {
        if (product.getIngredients() == null || product.getIngredients().isEmpty()) {
            List<SupplementItemInfo> ingredients = this.dlSales.getIngredientsByProductsPop(product.getID());
            product.setIngredients(ingredients);
        }
        if (product.getSupplements() == null || product.getSupplements().isEmpty()) {
            List<SupplementProduct> supplementsDB = this.dlItems.getSupplementsByProduct(product.getID(), true, false, true);
            ArrayList supplements = new ArrayList();
            for (SupplementProduct supplement : supplementsDB) {
                List<SupplementItemInfo> optionsItem = this.dlItems.getSuppelementsItemBorne(supplement.getiD(), supplement.isOrder_name());
                for (SupplementItemInfo supplementItemInfo : optionsItem) {
                    supplementItemInfo.setDisplay_free(supplement.isDisplay_free());
                }
                if (optionsItem.size() <= 0) continue;
                if (calculOptionFree) {
                    for (OptionItemOrder optionItemOrder : listChoiceSupplement) {
                        if (supplement.getiD() != optionItemOrder.getId_groupe_option()) continue;
                        supplement.setOption_free_tmp(supplement.getOption_free_tmp() + optionItemOrder.getNumber_free());
                    }
                }
                supplement.setItems(optionsItem);
                supplements.add(supplement);
            }
            product.setSupplements(supplements);
        }
        if (product.isMenu() && (product.getCartes() == null || product.getCartes().isEmpty())) {
            List<CarteOrderInfo> platsDB = this.dlSales.getCartesByItem(product.getID());
            for (CarteOrderInfo carteOrderInfo : platsDB) {
                carteOrderInfo.setItems(this.dlSales.getProductsByPlat(carteOrderInfo.getId(), true));
            }
            ArrayList<CarteOrderInfo> plats = new ArrayList<CarteOrderInfo>();
            for (CarteOrderInfo carteDB : platsDB) {
                for (int i = 0; i < carteDB.getNumber_carte(); ++i) {
                    CarteOrderInfo carte = (CarteOrderInfo)carteDB.clone();
                    carte.setIndex_carte(i + 1);
                    if (carteDB.getNumber_carte() > 1) {
                        carte.setName(carteDB.getDisplayedName() + " " + (i + 1));
                    }
                    if (carte.getItems().size() <= 0) continue;
                    plats.add(carte);
                }
            }
            product.setCartes(plats);
        }
        if (product.getSub_products() != null && !product.getSub_products().isEmpty()) {
            ArrayList<ProductInfoExt> subProducts = new ArrayList<ProductInfoExt>();
            for (ProductInfoExt productInfoExt : product.getSub_products()) {
                if (productInfoExt.getIngredients() == null || productInfoExt.getIngredients().isEmpty()) {
                    List<SupplementItemInfo> ingredients = this.dlSales.getIngredientsByProductsPop(productInfoExt.getID());
                    productInfoExt.setIngredients(ingredients);
                }
                ProductInfoExt new_sub_product = (ProductInfoExt)productInfoExt.clone();
                new_sub_product.setIndex_sub_product(1);
                subProducts.add(new_sub_product);
            }
            product.setSub_products(subProducts);
        }
        if (product.getAllergenes() == null || product.getAllergenes().isEmpty()) {
            product.setAllergenes(this.dlSales.getProductAllergenesById(product.getID()));
        }
        if (product.getNutriValues() == null) {
            product.setNutriValues(this.dlSales.getProductNutriValuesById(product.getID()));
        }
    }

    private Image getImageProduct(int id_product, String path, HashMap<Integer, SoftReference> refItems, String resized_path) {
        Image image_product = null;
        File image = null;
        if (refItems.containsKey(id_product) && refItems.get(id_product) != null) {
            image_product = (Image)refItems.get(id_product).get();
        }
        if (image_product == null) {
            if (resized_path != null) {
                image = this.m_FilerUtils.getFileFullPath("images/products/" + resized_path);
            }
            if (!(image != null && image.exists() || path == null)) {
                image = this.m_FilerUtils.getFileFullPath("images/products/" + path);
            }
            if (image != null && image.exists()) {
                image_product = new Image(image.toURI().toString());
            }
            if (image_product == null) {
                image_product = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/default_image_item.png"));
            }
            if (image_product != null) {
                if (!refItems.containsKey(id_product)) {
                    refItems.put(id_product, new SoftReference<Image>(image_product));
                } else if (refItems.get(id_product) == null) {
                    refItems.replace(id_product, new SoftReference<Image>(image_product));
                }
            }
        }
        return image_product;
    }

    protected Image getImageProduct(ProductInfoExt product, String size) {
        return this.getImageProduct(product, size, this.refProducts);
    }

    protected Image getImageProductMoment(ProductInfoExt product) {
        return this.getImageProductMoment(product, this.refProductsMoment);
    }

    protected Image getImageItemPlat(ProductInfoExt product, String size) {
        String resized_path = null;
        String imageProductPath = product.getImageProduct();
        if (imageProductPath != null && !imageProductPath.isEmpty()) {
            String name = imageProductPath.replaceFirst("[.][^.]+$", "");
            String ext = imageProductPath.substring(imageProductPath.lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageProduct(product.getID(), imageProductPath, this.refPlats, resized_path);
    }

    protected Image getImageItemPlat(int id_product, String path, String size) {
        String resized_path = null;
        if (path != null && !path.isEmpty()) {
            String name = path.replaceFirst("[.][^.]+$", "");
            String ext = path.substring(path.lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageProduct(id_product, path, this.refPlats, resized_path);
    }

    protected void addTicketLine(ProductInfoExt product, double price, List<OptionItemOrder> listChoiceSupplement, List<ItemOrderInfo> listChoiceIngredient, List<ProductTicket> listProducts, boolean dessert, ProductSizeInfo mProductSizeInfo, String time_served, int quantity_product, boolean additional_sale, boolean promo_product, int index_line_parent) throws BasicException {
        this.sortOptions(product, listChoiceSupplement);
        TaxInfo tax = this.dlSales.getTaxById(product.getTaxCategoryID());
        String label_size_product = mProductSizeInfo != null ? mProductSizeInfo.getLabel_size() : null;
        String name_size_product = mProductSizeInfo != null ? mProductSizeInfo.getName() : null;
        String alias_size = mProductSizeInfo != null ? mProductSizeInfo.getDescription() : null;
        TicketLineInfo line = new TicketLineInfo(product, quantity_product, price, tax, listChoiceIngredient, listChoiceSupplement, product.isMenu(), tax.getRate(), listProducts, label_size_product, name_size_product, 0.0, null, false, null, null, time_served, -1);
        line.setPrice_product(product.getPriceSell());
        if (dessert) {
            line.setId_dessert(product.getID());
        }
        if (additional_sale) {
            line.setId_additional_sale(product.getID());
            line.setIndex_line_parent(index_line_parent);
        }
        line.setPromo_basket(promo_product);
        if (product.isUse_points()) {
            line.setPoints_loyalty(product.getPrice_point());
            line.setType_discount("somme");
            line.setDiscount(line.getPriceProduct());
            line.setLabelDiscount("Carte de fid\u00e9lit\u00e9");
        }
        line.setImage_product(this.getImageProduct(product, "_256px"));
        int index_last_line = AppLocal.ticketBorne.getLinesCount() > 0 ? AppLocal.ticketBorne.getLinesCount() - 1 : -1;
        int index_line = index_last_line >= 0 ? AppLocal.ticketBorne.getLine(index_last_line).getIndex_line() : 0;
        line.setIndex_line(++index_line);
        line.setValid_caisse(product.isValid_caisse());
        line.setAlias_size(alias_size);
        AppLocal.ticketBorne.addLine(line);
    }

    protected void sortOptions(ProductInfoExt oProduct, List<OptionItemOrder> listSupplements) {
        ArrayList<OptionItemOrder> optionsLine = new ArrayList<OptionItemOrder>();
        ArrayList<OptionItemOrder> optionsItems = new ArrayList<OptionItemOrder>();
        ArrayList<OptionItemOrder> subSupplements = new ArrayList<OptionItemOrder>();
        for (OptionItemOrder supplement : listSupplements) {
            if (supplement.getParent_supplement_id() == 0) continue;
            subSupplements.add((OptionItemOrder)supplement.clone());
        }
        for (OptionItemOrder optionItemOrder : listSupplements) {
            if (optionItemOrder.getIdProduct() == -1) continue;
            optionsItems.add(optionItemOrder);
        }
        List<SupplementProduct> allOptions = oProduct.getSupplements();
        int j = 0;
        for (SupplementProduct option : allOptions) {
            for (OptionItemOrder supplement : listSupplements) {
                if (option.getiD() != supplement.getId_groupe_option() || supplement.getIdProduct() != -1 || supplement.getParent_supplement_id() != 0) continue;
                supplement.setOrder_option(j);
                ++j;
                optionsLine.add(supplement);
                for (OptionItemOrder subSupplement : subSupplements) {
                    if (subSupplement.getParent_supplement_id() != supplement.getSupplement()) continue;
                    subSupplement.setOrder_option(j);
                    ++j;
                    optionsLine.add(subSupplement);
                }
            }
        }
        for (OptionItemOrder optionItemOrder : optionsLine) {
            optionItemOrder.setOrder_option(j);
            ++j;
        }
        listSupplements.clear();
        listSupplements.addAll(optionsLine);
        listSupplements.addAll(optionsItems);
    }

    protected int indice_line_additional_sale(int id_additional_sale, int index_line_parent) {
        int found = -1;
        int index = 0;
        for (TicketLineInfo line : AppLocal.ticketBorne.getLines()) {
            if (line.getId_additional_sale() == id_additional_sale && line.getIndex_line_parent() == index_line_parent) {
                found = index;
                break;
            }
            ++index;
        }
        return found;
    }

    protected void deselectButtonIngredient(SupplementItemInfo ingredient, Button btnIngredient) {
        btnIngredient.getStyleClass().add((Object)"cell_borne");
        if (btnIngredient.getProperties().get((Object)"label") != null) {
            ((Label)btnIngredient.getProperties().get((Object)"label")).getStyleClass().add((Object)"text-black");
        }
        if (btnIngredient.getStyleClass().contains((Object)"text-white")) {
            btnIngredient.getStyleClass().remove((Object)"text-white");
        }
        if (btnIngredient.getProperties().get((Object)"image_select_ingredient") != null) {
            ((ImageView)btnIngredient.getProperties().get((Object)"image_select_ingredient")).setImage(null);
        }
    }

    protected void selectButtonIngredient(SupplementItemInfo ingredient, Button btnIngredient) {
        if (btnIngredient.getProperties().get((Object)"image_select_ingredient") != null) {
            ((ImageView)btnIngredient.getProperties().get((Object)"image_select_ingredient")).setImage(this.image_ingredient_selected);
            if (AppLocal.type_borne.equals("horizontal")) {
                ((ImageView)btnIngredient.getProperties().get((Object)"image_select_ingredient")).setFitHeight(btnIngredient.getPrefHeight() * 0.6 * 0.8);
            } else {
                ((ImageView)btnIngredient.getProperties().get((Object)"image_select_ingredient")).setFitWidth(btnIngredient.getPrefWidth() * 0.6);
            }
            ((ImageView)btnIngredient.getProperties().get((Object)"image_select_ingredient")).setPreserveRatio(true);
            ((ImageView)btnIngredient.getProperties().get((Object)"image_select_ingredient")).setSmooth(true);
            ((ImageView)btnIngredient.getProperties().get((Object)"image_select_ingredient")).setCache(true);
        }
    }

    protected Image getImageOption(SupplementItemInfo option, String size) {
        String resized_path = null;
        if (option.getPath() != null && !option.getPath().isEmpty()) {
            String name = option.getPath().replaceFirst("[.][^.]+$", "");
            String ext = option.getPath().substring(option.getPath().lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageOption(option.getiD(), option.getPath(), resized_path);
    }

    protected Image getImageOptionItemOrder(int idOption, String path, String size) {
        String resized_path = null;
        if (path != null && !path.isEmpty()) {
            String name = path.replaceFirst("[.][^.]+$", "");
            String ext = path.substring(path.lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageOption(idOption, path, resized_path);
    }

    protected Image getImageOption(int id_option, String path, String resized_path) {
        Image image_option = null;
        if (this.refOptions.containsKey(id_option) && this.refOptions.get(id_option) != null) {
            image_option = (Image)this.refOptions.get(id_option).get();
        }
        if (image_option == null) {
            File image = null;
            if (resized_path != null) {
                image = this.m_FilerUtils.getFileFullPath("images/supplements" + resized_path);
            }
            if (!(image != null && image.exists() || path == null)) {
                image = this.m_FilerUtils.getFileFullPath("images/supplements/" + path);
            }
            if (image != null && image.exists()) {
                image_option = new Image(image.toURI().toString());
            }
            if (image_option == null) {
                image_option = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/default_image_item.png"));
            }
            if (image_option != null) {
                if (!this.refOptions.containsKey(id_option)) {
                    this.refOptions.put(id_option, new SoftReference<Image>(image_option));
                } else if (this.refOptions.get(id_option) == null) {
                    this.refOptions.replace(id_option, new SoftReference<Image>(image_option));
                }
            }
        }
        return image_option;
    }

    protected void setImage(Button button, Image imageButton, double heightButton, double widthButton) {
        double heightImage = heightButton * 0.7;
        double widthImage = widthButton * 0.7;
        ImageView imageView = new ImageView();
        imageView.setImage(imageButton);
        if (AppLocal.type_borne.equals("horizontal")) {
            imageView.setFitHeight(heightImage);
        } else {
            imageView.setFitWidth(widthImage);
        }
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setCache(true);
        button.setGraphic((Node)imageView);
    }

    protected Button getButtonPrevious(double width, double height, boolean products_button) {
        Button button_previous = new Button();
        button_previous.setPrefHeight(height);
        button_previous.setPrefWidth(width);
        button_previous.getStyleClass().add((Object)"bg_transparent");
        String path = AppLocal.ICON_PREVIOUS;
        if (products_button) {
            File image_path;
            if (path != null && !path.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path)) != null && image_path.exists()) {
                this.imagePreviousItemProducts = new Image(image_path.toURI().toString());
            }
            if (this.imagePreviousItemProducts == null) {
                if (AppLocal.COLOR_FLESHE_PRODUCTS != null && AppLocal.COLOR_FLESHE_PRODUCTS.equals(this.BLACK_COLOR)) {
                    if (this.imagePreviousItemProducts == null) {
                        this.imagePreviousItemProducts = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/left_arrow_items.png"));
                    }
                } else if (this.imagePreviousItemProducts == null) {
                    this.imagePreviousItemProducts = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/left_arrow_items_white.png"));
                }
            }
            this.setImage(button_previous, this.imagePreviousItemProducts, height * 0.8, width * 0.8);
        } else {
            File image_path;
            if (path != null && !path.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path)) != null && image_path.exists()) {
                this.imagePreviousItems = new Image(image_path.toURI().toString());
            }
            if (this.imagePreviousItems == null) {
                this.imagePreviousItems = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/left_arrow_items.png"));
            }
            this.setImage(button_previous, this.imagePreviousItems, height * 0.8, width * 0.8);
        }
        return button_previous;
    }

    protected Button getButtonNext(double width, double height, boolean products_button) {
        Button button_next = new Button();
        button_next.setPrefHeight(height);
        button_next.setPrefWidth(width);
        button_next.getStyleClass().add((Object)"bg_transparent");
        String path = AppLocal.ICON_NEXT;
        System.out.println("path +++++++++++++ path : " + path);
        if (products_button) {
            File image_path;
            if (path != null && !path.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path)) != null && image_path.exists()) {
                this.imageNextItemProducts = new Image(image_path.toURI().toString());
            }
            if (this.imageNextItemProducts == null) {
                if (AppLocal.COLOR_FLESHE_PRODUCTS != null && AppLocal.COLOR_FLESHE_PRODUCTS.equals(this.BLACK_COLOR)) {
                    if (this.imageNextItemProducts == null) {
                        this.imageNextItemProducts = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/right_arrow_items.png"));
                    }
                } else if (this.imageNextItemProducts == null) {
                    this.imageNextItemProducts = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/right_arrow_items_white.png"));
                }
            }
            this.setImage(button_next, this.imageNextItemProducts, height * 0.8, width * 0.8);
        } else {
            File image_path;
            if (path != null && !path.isEmpty() && (image_path = this.m_FilerUtils.getFileFullPath("images/logos/" + path)) != null && image_path.exists()) {
                this.imageNextItems = new Image(image_path.toURI().toString());
            }
            if (this.imageNextItems == null) {
                this.imageNextItems = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/right_arrow_items.png"));
            }
            this.setImage(button_next, this.imageNextItems, height * 0.8, width * 0.8);
        }
        return button_next;
    }

    protected void loadImagesOptions(List<SupplementItemInfo> supplements, boolean isIngredient, boolean recalcul_sizes, boolean fixHeight, String sizeImage) {
        if (this.image_option_width == null) {
            this.image_option_width = new ArrayList<Double>();
        } else {
            this.image_option_heights.clear();
        }
        if (this.image_option_heights == null) {
            this.image_option_heights = new ArrayList<Double>();
        } else {
            this.image_option_width.clear();
        }
        if (this.imagesViewCatalogOptions == null) {
            this.imagesViewCatalogOptions = new HashMap();
        } else {
            this.imagesViewCatalogOptions.clear();
        }
        double heightImage = this.height_option * 0.6;
        double widthImage = this.width_option * 0.7;
        for (SupplementItemInfo supplement : supplements) {
            IOptionItem mOptionItem = isIngredient ? new IngredientItem(supplement, this.refIngredient) : new OptionItem(supplement, this.refOptions);
            widthImage = supplement.getPath() != null && !supplement.getPath().isEmpty() ? this.width_option * 0.7 : this.width_option * 0.57;
            Image imageOption = mOptionItem.getImage(sizeImage);
            ImageView imageView = new ImageView();
            imageView.setImage(imageOption);
            if (fixHeight) {
                imageView.setFitHeight(heightImage);
            } else if (AppLocal.type_borne.equals("horizontal")) {
                imageView.setFitHeight(heightImage);
            } else {
                imageView.setFitWidth(widthImage);
            }
            imageView.setPreserveRatio(true);
            imageView.setSmooth(true);
            imageView.setCache(true);
            this.image_option_heights.add(imageView.getBoundsInLocal().getHeight());
            this.image_option_width.add(imageView.getBoundsInLocal().getWidth());
            this.imagesViewCatalogOptions.put(supplement.getiD(), imageView);
        }
        if (recalcul_sizes && AppLocal.type_borne != null) {
            if (AppLocal.type_borne.equals("horizontal")) {
                if (this.image_option_width.size() > 0) {
                    this.width_option = this.getMax(this.image_option_width) / 0.7;
                    this.width_option = this.width_option < this.getMinWidthOption() ? this.getMinWidthOption() : this.width_option;
                }
            } else if (this.image_option_heights.size() > 0) {
                this.height_option = this.getMax(this.image_option_heights) / 0.7;
                this.height_option = this.height_option < this.getMinHeightOption() ? this.getMinHeightOption() : this.height_option;
            }
        }
    }

    protected double getMinWidthOption() {
        return this.getWidth_itemsOptions() / (double)this.MAX_COLUMN_OPTION;
    }

    protected double getMinHeightOption() {
        return this.getHeight_itemsOptions() / (double)this.MAX_LINE_OPTION;
    }

    protected double getHeight_itemsOptions() {
        return AppVarUtils.getScreenDimension().getHeight() * 0.7 * 0.9;
    }

    protected double getWidth_itemsOptions() {
        return AppVarUtils.getScreenDimension().getWidth();
    }

    protected void initNumberLinesItems(double height_bloc_option, double width_bloc_option) {
        double height_items = height_bloc_option;
        this.buttons_of_line_options = (int)(width_bloc_option / this.width_option);
        this.buttons_of_line_options = this.buttons_of_line_options > this.MAX_COLUMN_OPTION ? this.MAX_COLUMN_OPTION : this.buttons_of_line_options;
        this.max_lines_options = (int)Math.round(height_items / this.height_option);
        this.max_items = (int)this.max_lines_options * this.buttons_of_line_options;
    }

    protected Button getButtonPrevious(double width, double height) {
        return this.getButtonPrevious(width, height, false);
    }

    protected Button getButtonNext(double width, double height) {
        return this.getButtonNext(width, height, false);
    }

    protected void addTicketLine(ProductInfoExt product, double price, List<OptionItemOrder> listChoiceSupplement, List<ItemOrderInfo> listChoiceIngredient, List<ProductTicket> listProducts, boolean dessert, ProductSizeInfo mProductSizeInfo, String time_served, int quantity_product, boolean additional_sale, boolean promo_product) throws BasicException {
        this.addTicketLine(product, price, listChoiceSupplement, listChoiceIngredient, listProducts, dessert, mProductSizeInfo, time_served, quantity_product, additional_sale, promo_product, 0);
    }

    protected Image getImageProduct(ProductInfoExt product, String size, HashMap<Integer, SoftReference> refProducts) {
        String resized_path = null;
        String imageProductPath = product.getImageProduct();
        if (imageProductPath != null && !imageProductPath.isEmpty()) {
            String name = imageProductPath.replaceFirst("[.][^.]+$", "");
            String ext = imageProductPath.substring(imageProductPath.lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageProduct(product.getID(), imageProductPath, refProducts, resized_path);
    }

    protected Image getImageProductMoment(ProductInfoExt product, HashMap<Integer, SoftReference> refProducts) {
        String imageProductMomentPath;
        Image image_product = null;
        File image = null;
        String string = imageProductMomentPath = product.getImageProductMoment() != null ? product.getImageProductMoment().getPath() : null;
        if (imageProductMomentPath != null && !imageProductMomentPath.isEmpty()) {
            if (refProducts.containsKey(product.getID()) && refProducts.get(product.getID()) != null) {
                image_product = (Image)refProducts.get(product.getID()).get();
            }
            if (image_product == null) {
                image = this.m_FilerUtils.getFileFullPath("images/products/" + imageProductMomentPath);
                if (image != null && image.exists()) {
                    image_product = new Image(image.toURI().toString());
                }
                if (image_product != null) {
                    if (!refProducts.containsKey(product.getID())) {
                        refProducts.put(product.getID(), new SoftReference<Image>(image_product));
                    } else if (refProducts.get(product.getID()) == null) {
                        refProducts.replace(product.getID(), new SoftReference<Image>(image_product));
                    }
                }
            }
        }
        return image_product;
    }

    protected Image getImageCategorieMoment(CategoryInfo category, HashMap<Integer, SoftReference> refCategories) {
        Image imgCategory = null;
        File image = null;
        System.out.println("++++++++++++++++++++++++category.getPath_category_moment" + category.getPath_category_moment());
        if (category.getPath_category_moment() != null && !category.getPath_category_moment().isEmpty()) {
            if (refCategories.containsKey(category.getID()) && refCategories.get(category.getID()) != null) {
                imgCategory = (Image)refCategories.get(category.getID()).get();
            }
            if (imgCategory == null) {
                image = this.m_FilerUtils.getFileFullPath("images/catagories/" + category.getPath_category_moment());
                if (image != null && image.exists()) {
                    imgCategory = new Image(image.toURI().toString());
                }
                if (imgCategory != null) {
                    if (!refCategories.containsKey(category.getID())) {
                        refCategories.put(category.getID(), new SoftReference<Image>(imgCategory));
                    } else if (refCategories.get(category.getID()) == null) {
                        refCategories.replace(category.getID(), new SoftReference<Image>(imgCategory));
                    }
                }
            }
        }
        return imgCategory;
    }

    protected Image getImageItemPlat(ProductInfoExt product, String size, HashMap<Integer, SoftReference> refPlats) {
        String resized_path = null;
        String imageProductPath = product.getImageProduct();
        if (imageProductPath != null && !imageProductPath.isEmpty()) {
            String name = imageProductPath.replaceFirst("[.][^.]+$", "");
            String ext = imageProductPath.substring(imageProductPath.lastIndexOf(".") + 1);
            resized_path = name + size + "." + ext;
        }
        return this.getImageProduct(product.getID(), imageProductPath, refPlats, resized_path);
    }

    protected Image getImageProduct(ProductInfoExt product, HashMap<Integer, SoftReference> refProductsOrigins) {
        return this.getImageProduct(product.getID(), product.getImageProduct(), refProductsOrigins, null);
    }

    protected Image getImageItemPlat(ProductInfoExt product, HashMap<Integer, SoftReference> refPlatsOrigins) {
        return this.getImageProduct(product.getID(), product.getImageProduct(), refPlatsOrigins, null);
    }

    protected Image getImageTag(TagInfo tag, HashMap<Integer, SoftReference> refTags) {
        return this.getImageTag(tag.getId(), tag.getLogo_tag(), refTags);
    }

    private Image getImageTag(int id_tag, String path, HashMap<Integer, SoftReference> refItems) {
        Image image_product = null;
        File image = null;
        if (refItems.containsKey(id_tag) && refItems.get(id_tag) != null) {
            image_product = (Image)refItems.get(id_tag).get();
        }
        if (image_product == null) {
            if (!(image != null && image.exists() || path == null)) {
                image = this.m_FilerUtils.getFileFullPath("images/tags/" + path);
            }
            if (image != null && image.exists()) {
                image_product = new Image(image.toURI().toString());
            }
            if (image_product != null) {
                if (!refItems.containsKey(id_tag)) {
                    refItems.put(id_tag, new SoftReference<Image>(image_product));
                } else if (refItems.get(id_tag) == null) {
                    refItems.replace(id_tag, new SoftReference<Image>(image_product));
                }
            }
        }
        return image_product;
    }
}

