/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.CloseCaisseController;
import com.openbravo.controllers.PopUpCancelOrders;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.events.CustomListRecapXGlobal;
import com.openbravo.events.EventMouseChartLine;
import com.openbravo.format.Formats;
import com.openbravo.models.HBoxRecapXGlobal;
import com.openbravo.models.LineChartModel;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.JPrincipalApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.EquipmentTurnover;
import com.openbravo.pos.ticket.FinancialReportInfo;
import com.openbravo.pos.ticket.HourInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.MoneyMouvement;
import fr.protactile.procaisse.dao.entities.PertEntity;
import fr.protactile.procaisse.dao.entities.PertInfo;
import fr.protactile.procaisse.services.MoneyMouvementServices;
import fr.protactile.procaisse.services.PertEntityServices;
import fr.protactile.procaisse.services.PertInfoServices;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.apache.commons.io.FileUtils;

public class XGlobalController {
    @FXML
    GridPane main_pane;
    @FXML
    Label label_loading;
    @FXML
    Label closecaisseImage;
    @FXML
    GridPane recap_pane;
    @FXML
    ListView list_recap;
    @FXML
    GridPane stats_pane;
    @FXML
    GridPane right_pane;
    @FXML
    GridPane left_pane;
    @FXML
    GridPane calendar_pane;
    @FXML
    GridPane sales_progress_pane;
    @FXML
    GridPane total_label;
    @FXML
    GridPane panedetails;
    @FXML
    GridPane close_caissePane;
    @FXML
    GridPane paneprint;
    @FXML
    Button btn_next_date;
    @FXML
    Button print;
    @FXML
    Button orders_btn;
    @FXML
    Button btn_previous_date;
    @FXML
    Button closecaisse;
    @FXML
    Button perte_marchandise;
    @FXML
    Button money_in;
    @FXML
    Button money_out;
    @FXML
    Label jdate;
    @FXML
    GridPane sales_stats_pane;
    @FXML
    GridPane pane_border;
    @FXML
    Label label_progress_turnover;
    @FXML
    Label text_progress_turnover;
    @FXML
    Label label_number_Order;
    @FXML
    Label text_number_order;
    @FXML
    Label somme;
    @FXML
    Label closecaisseTotal;
    @FXML
    Label closecaisseText;
    @FXML
    GridPane total_pane;
    private Stage mStage;
    private TicketService mTicketService;
    private Date dateEnd;
    private Date dateStart;
    private LinkedHashMap<String, Object> map_infos;
    private List<HBoxRecapXGlobal> listRecapLine;
    private List<HBoxRecapXGlobal> listCategory;
    private Date date;
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    private Map<String, Long> m_keysLineChart = new LinkedHashMap<String, Long>();
    private Object[] result;
    private AppView m_App;
    private Scene scene;
    private String close_caisse = "/fxml/close_caisse.fxml";
    private LazyModal mLazyModalCloseCaisse = null;
    private EventHiddenModal mActionEventCloseCaisse = null;
    private String popUp_canel_orders = "/fxml/popUp_cancel_orders.fxml";
    private LazyModal mLazyModalCancelOrders = null;
    private EventHiddenModal mActionEventCancelOrders = null;
    private String popUp_shared_orders = "/fxml/popUp_shared_orders.fxml";
    private LazyModal mLazyModalSharedOrders = null;
    private EventHiddenModal mActionEventSharedOrders = null;
    private CaisseInfo mCaisseInfo;
    private DataLogicSales dlSales;
    private Label label_open_caisse = new Label();
    private List<CategoryInfo> categories;
    private DataLogicItems dlItems;
    private FilerUtils m_FilerUtils = null;
    private ListView list_Categ = new ListView();
    double capert = 0.0;
    private HashMap<Label, Integer> nbperteList = new HashMap();
    private Label montantperte = new Label(AppLocal.getIntString("Text.amount.loss") + " : " + System.lineSeparator() + Formats.CURRENCY.formatValue(this.capert));
    private GridPane gridvalidCase = new GridPane();
    private HashMap<Integer, GridPane> gridnotSelected = new HashMap();
    private boolean isvalidCase;
    private boolean ismoneyin;
    private Label focusedTextField = new Label();
    double width = AppVarUtils.getScreenDimension().getWidth() * 0.5 * 0.8 - 70.0;
    private PertInfoServices mPertInfoServices;
    private PertEntityServices mPertEntityServices;
    private MoneyMouvementServices mMoneyMouvementServices;
    private HashMap<ProductInfoExt, Integer> pertes_category = new HashMap();
    private HashMap<PertEntity, Boolean> pertes_deleted = new HashMap();
    private HashMap<MoneyMouvement, Boolean> money_deleted = new HashMap();
    private String user = "";
    double heightmin = 0.0;
    TextArea labelTextAria = new TextArea();
    GridPane GridMarchandise = new GridPane();

    public void initializer(AppView m_App, Scene scene) {
        try {
            this.mPertInfoServices = PertInfoServices.getInstance();
            this.mPertEntityServices = PertEntityServices.getInstance();
            this.mMoneyMouvementServices = MoneyMouvementServices.getInstance();
            this.initCSS();
            this.money_in.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    XGlobalController.this.moneyMouvement("entrer");
                }
            });
            this.money_out.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    XGlobalController.this.moneyMouvement("sortie");
                }
            });
            this.heightmin = this.main_pane.getPrefHeight() * 0.1;
            this.m_FilerUtils = FilerUtils.getInstance();
            this.dlItems = AppLocal.dlItems;
            this.categories = this.dlItems.getCategories(false, false, true);
            this.m_App = m_App;
            this.scene = scene;
            this.mTicketService = TicketService.getInstance();
            this.dateEnd = new Date();
            System.out.println("+++++++++++++++++++initializer()" + this.dateEnd);
            this.dateStart = new Date();
            com.openbravo.pos.util.DateUtils.setDateStart(this.dateStart);
            this.list_recap.setCellFactory((Callback)new Callback<ListView<HBoxRecapXGlobal>, ListCell<HBoxRecapXGlobal>>(){

                public CustomListRecapXGlobal call(ListView<HBoxRecapXGlobal> listView) {
                    return new CustomListRecapXGlobal();
                }
            });
            this.list_Categ.setCellFactory((Callback)new Callback<ListView<HBoxRecapXGlobal>, ListCell<HBoxRecapXGlobal>>(){

                public CustomListRecapXGlobal call(ListView<HBoxRecapXGlobal> listView) {
                    return new CustomListRecapXGlobal();
                }
            });
            Image imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/right_btn.png"));
            ImageView imageright = new ImageView(imageNext);
            imageright.setFitHeight(this.btn_next_date.getPrefHeight());
            imageright.setFitWidth(this.btn_next_date.getPrefWidth());
            this.btn_next_date.setGraphic((Node)imageright);
            Image imagebPrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/left_btn.png"));
            ImageView imageleft = new ImageView(imagebPrevious);
            imageleft.setFitHeight(this.btn_previous_date.getPrefHeight());
            imageleft.setFitWidth(this.btn_previous_date.getPrefWidth());
            this.btn_previous_date.setGraphic((Node)imageleft);
            this.dlSales = (DataLogicSales)m_App.getBean("com.openbravo.dao.DataLogicSales");
            this.user = m_App.getAppUserView().getUser().getUserInfo().getName();
            this.setTexts();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void getInfos() {
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.label_loading, 0, 0);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                XGlobalController.this.map_infos = XGlobalController.this.mTicketService.getXGlobal(XGlobalController.this.dateStart, XGlobalController.this.dateEnd);
                System.out.println("+++++++++++++++++++" + XGlobalController.this.dateEnd);
                System.out.println("++++++++ map_infos : " + XGlobalController.this.map_infos);
                if (XGlobalController.this.map_infos != null) {
                    XGlobalController.this.loadInfos();
                }
            }
        });
    }

    public void print() {
        try {
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            PrinterHelper printer = new PrinterHelper();
            Decreaser decreaser = new Decreaser(AppLocal.dlSales, com.openbravo.pos.util.DateUtils.SDF_YYYYMMDD.format(this.dateEnd), "Rapport de fermeture", null, new Integer(com.openbravo.pos.util.DateUtils.SDF_YYYYMMDD.format(this.dateEnd)));
            System.out.println("++++ map_infos : " + this.map_infos);
            if (this.map_infos != null) {
                printer.printCloseCaisseGlobal(this.map_infos, marqueNF, this.dateStart, this.dateEnd, decreaser, AppLocal.NUMBER_PRINT_Z);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void closePopUp() {
        this.mStage.close();
    }

    private void loadInfos() {
        Platform.runLater(() -> {
            this.loadRecap();
            this.initLineChart();
            this.setTurnoverProgress();
            this.recap_pane.setStyle("-fx-background-color: #D0DFEC;");
            this.main_pane.getChildren().clear();
            this.main_pane.add((Node)this.stats_pane, 0, 0);
            this.main_pane.add((Node)this.recap_pane, 1, 0);
        });
    }

    public void loadRecap() {
        try {
            List money_mouvements;
            this.list_recap.getItems().clear();
            if (this.listRecapLine == null) {
                this.listRecapLine = new ArrayList<HBoxRecapXGlobal>();
            } else {
                this.listRecapLine.clear();
            }
            int nbOrder = this.map_infos.get("nbOrders") != null ? (Integer)this.map_infos.get("nbOrders") : 0;
            double caNet = this.map_infos.get("turnover") != null ? (Double)this.map_infos.get("turnover") : 0.0;
            List payments = this.map_infos.get("payments") != null ? (List)this.map_infos.get("payments") : null;
            List users = this.map_infos.get("users") != null ? (List)this.map_infos.get("users") : null;
            List dataTypeOrdersBeforeSort = this.map_infos.get("typeOrders") != null ? (List)this.map_infos.get("typeOrders") : null;
            ArrayList<RankTypeOrder> dataTypePlatformOrders = this.map_infos.get("typePlatformOrders") != null ? (ArrayList<RankTypeOrder>)this.map_infos.get("typePlatformOrders") : null;
            List equipments = this.map_infos.get("equipments") != null ? (List)this.map_infos.get("equipments") : null;
            List taxes = this.map_infos.get("taxes") != null ? (List)this.map_infos.get("taxes") : null;
            boolean nbCB = false;
            boolean nbTResto = false;
            double totalDiscount = this.map_infos.get("totalDiscount") != null ? (Double)this.map_infos.get("totalDiscount") : 0.0;
            double totalDiscountOnLines = this.map_infos.get("totalDiscountLines") != null ? (Double)this.map_infos.get("totalDiscountLines") : 0.0;
            List not_available = this.map_infos.get("not_available") != null ? (List)this.map_infos.get("not_available") : null;
            double total_ht = 0.0;
            double turnoverCanceled = this.map_infos.get("turnover_canceled") != null ? Double.valueOf((Double)this.map_infos.get("turnover_canceled")) : null;
            List canceledOrders = this.map_infos.get("canceled_order") != null ? (List)this.map_infos.get("canceled_order") : null;
            List discountOrders = this.map_infos.get("discount_order") != null ? (List)this.map_infos.get("discount_order") : null;
            List pertesEntity = this.map_infos.get("Pertes") != null ? (List)this.map_infos.get("Pertes") : null;
            List list = money_mouvements = this.map_infos.get("money_mouvement") != null ? (List)this.map_infos.get("money_mouvement") : null;
            if (taxes != null) {
                for (Object taxe_1 : taxes) {
                    total_ht += ((TaxeLine)taxe_1).getHt();
                }
            }
            ArrayList<RankTypeOrder> dataTypeOrders = new ArrayList<RankTypeOrder>();
            for (RankTypeOrder type : dataTypeOrdersBeforeSort) {
                if (type != null && (type.getName().equalsIgnoreCase("Uber Eats") || type.getName().equalsIgnoreCase("Just Eat") || type.getName().equalsIgnoreCase("Delivero") || type.getName().equalsIgnoreCase("Deliveroo") || type.getName().equalsIgnoreCase("Smood"))) {
                    if (dataTypePlatformOrders == null) {
                        dataTypePlatformOrders = new ArrayList<RankTypeOrder>();
                    }
                    int found = -1;
                    for (RankTypeOrder platformOrder : dataTypePlatformOrders) {
                        if (!type.getName().equals(platformOrder.getName()) && (!type.getName().equalsIgnoreCase("Delivero") || !platformOrder.getName().equalsIgnoreCase("Deliveroo"))) continue;
                        platformOrder.setCa(platformOrder.getCa() + type.getCa());
                        found = 1;
                        break;
                    }
                    if (found != -1) continue;
                    if (type.getName().equalsIgnoreCase("Delivero")) {
                        type.setName("Deliveroo");
                    }
                    dataTypePlatformOrders.add(type);
                    continue;
                }
                dataTypeOrders.add(type);
            }
            this.somme.setText(Formats.CURRENCY.formatValue(caNet) + " TTC");
            this.closecaisseTotal.setText(Formats.CURRENCY.formatValue(caNet) + " TTC");
            this.label_number_Order.setText(String.valueOf(nbOrder));
            this.label_open_caisse = new Label();
            CaisseInfo mCaisseInfo = AppLocal.dlSales.getCaisse(AppLocal.token);
            if (mCaisseInfo != null) {
                StringBuilder info_open_caisse = new StringBuilder();
                info_open_caisse.append(AppLocal.getIntString("Text.cash.register.opened"));
                info_open_caisse.append("\n");
                info_open_caisse.append("A ");
                info_open_caisse.append(this.timeFormatter.format(mCaisseInfo.getDateOpen()));
                if (mCaisseInfo.getUser_open() != null) {
                    info_open_caisse.append(" " + AppLocal.getIntString("Text.by") + " ");
                    info_open_caisse.append(mCaisseInfo.getUser_open().getName());
                }
                this.label_open_caisse.setText(info_open_caisse.toString());
            }
            GridPane gridpaneOpenCaisse = new GridPane();
            gridpaneOpenCaisse.setPrefHeight(this.main_pane.getPrefHeight() * 0.1);
            gridpaneOpenCaisse.setPrefWidth(this.main_pane.getPrefWidth() * 0.8 * 0.5 - 40.0);
            this.label_open_caisse.setPrefWidth(gridpaneOpenCaisse.getPrefWidth());
            this.label_open_caisse.setPrefHeight(gridpaneOpenCaisse.getPrefHeight());
            gridpaneOpenCaisse.setAlignment(Pos.CENTER);
            this.label_open_caisse.setAlignment(Pos.CENTER);
            gridpaneOpenCaisse.add((Node)this.label_open_caisse, 0, 0);
            this.label_open_caisse.getStyleClass().add((Object)"text-size18-Consolas_black");
            this.addGrid(gridpaneOpenCaisse, "");
            GridPane gridpaneEquipements = new GridPane();
            FlowPane flowEquipe = new FlowPane();
            flowEquipe.setVgap(10.0);
            flowEquipe.setHgap(10.0);
            flowEquipe.setAlignment(Pos.CENTER);
            if (equipments != null || not_available != null && !not_available.isEmpty()) {
                int nbequipement = equipments != null && not_available != null ? equipments.size() + not_available.size() : equipments.size();
                int nbligne = nbequipement / 2;
                gridpaneEquipements.setPrefHeight((this.main_pane.getPrefHeight() * 0.1 + 50.0) * (double)nbligne);
                gridpaneEquipements.setPrefWidth(this.main_pane.getPrefWidth() * 0.5 * 0.8);
                gridpaneEquipements.setPadding(new Insets(5.0, 0.0, 0.0, 5.0));
                flowEquipe.setPrefWidth(this.main_pane.getPrefWidth() * 0.5 * 0.8);
                flowEquipe.setPrefHeight((this.main_pane.getPrefHeight() * 0.1 + 50.0) * (double)nbligne);
                flowEquipe.setAlignment(Pos.CENTER);
                flowEquipe.setHgap(5.0);
                Image imageborne = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/borne_image.png"));
                ImageView imageviewBorne = new ImageView(imageborne);
                Image imageCaisse = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/caisse_image.png"));
                ImageView imageviewCaisse = new ImageView(imageCaisse);
                gridpaneEquipements.setAlignment(Pos.CENTER);
                for (EquipmentTurnover equipment : equipments) {
                    GridPane gridEquipement = new GridPane();
                    if (equipment != null) {
                        gridEquipement.setPrefHeight(this.main_pane.getPrefHeight() * 0.1);
                        gridEquipement.setPrefWidth(this.main_pane.getPrefWidth() * 0.5 * 0.8 * 0.4);
                        gridEquipement.setVgap(5.0);
                        gridEquipement.setAlignment(Pos.CENTER);
                        Label labelImage = new Label();
                        labelImage.setPrefHeight(gridEquipement.getPrefHeight() * 0.5);
                        labelImage.setPrefWidth(gridEquipement.getPrefWidth());
                        labelImage.setAlignment(Pos.CENTER);
                        Label nameEquipement = new Label(equipment.getName());
                        nameEquipement.setPrefHeight(gridEquipement.getPrefHeight() * 0.25);
                        nameEquipement.setPrefWidth(gridEquipement.getPrefWidth());
                        nameEquipement.setAlignment(Pos.CENTER);
                        nameEquipement.getStyleClass().add((Object)"Segoe_UI_75_bold");
                        Label labeltotl = new Label(Formats.CURRENCY.formatValue(equipment.getTurnover()));
                        labeltotl.getStyleClass().add((Object)"text-size18-Consolas");
                        labeltotl.setPrefHeight(gridEquipement.getPrefHeight() * 0.25);
                        labeltotl.setPrefWidth(gridEquipement.getPrefWidth());
                        labeltotl.setAlignment(Pos.CENTER);
                        String type = equipment.getType();
                        if (type != null) {
                            if (equipment.getType().equalsIgnoreCase("borne")) {
                                labelImage.setGraphic((Node)imageviewBorne);
                                gridEquipement.add((Node)labelImage, 0, 0);
                                gridEquipement.add((Node)nameEquipement, 0, 1);
                                gridEquipement.add((Node)labeltotl, 0, 2);
                            }
                            if (equipment.getType().equalsIgnoreCase("caisse")) {
                                labelImage.setGraphic((Node)imageviewCaisse);
                                gridEquipement.add((Node)labelImage, 0, 0);
                                gridEquipement.add((Node)nameEquipement, 0, 1);
                                gridEquipement.add((Node)labeltotl, 0, 2);
                            }
                        }
                    }
                    flowEquipe.getChildren().add((Object)gridEquipement);
                }
                if (not_available != null) {
                    for (String equipmentNoAvailable : not_available) {
                        GridPane gridEquipementNon = new GridPane();
                        gridEquipementNon.setPrefHeight(this.main_pane.getPrefHeight() * 0.1);
                        gridEquipementNon.setPrefWidth(this.main_pane.getPrefWidth() * 0.5 * 0.8 * 0.4);
                        gridEquipementNon.setAlignment(Pos.CENTER);
                        gridEquipementNon.setVgap(5.0);
                        Image imageNotDisponible = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/not_available.png"));
                        String imageViewNotDisponible = new ImageView(imageNotDisponible);
                        Label imageLabel = new Label();
                        imageLabel.setPrefWidth(gridEquipementNon.getPrefWidth());
                        imageLabel.setPrefHeight(gridEquipementNon.getPrefHeight() * 0.4);
                        imageLabel.setGraphic((Node)imageViewNotDisponible);
                        imageLabel.setAlignment(Pos.CENTER);
                        Label NamenotAvailable = new Label(equipmentNoAvailable);
                        NamenotAvailable.setPrefWidth(gridEquipementNon.getPrefWidth());
                        NamenotAvailable.setPrefHeight(gridEquipementNon.getPrefHeight() * 0.2);
                        NamenotAvailable.setAlignment(Pos.CENTER);
                        Label notAvailable = new Label(AppLocal.getIntString("Text.equipment.unavailable"));
                        notAvailable.setWrapText(true);
                        notAvailable.setPrefWidth(gridEquipementNon.getPrefWidth());
                        notAvailable.setPrefHeight(gridEquipementNon.getPrefHeight() * 0.4);
                        notAvailable.setAlignment(Pos.CENTER);
                        notAvailable.getStyleClass().add((Object)"text-size18-Consolas");
                        notAvailable.setWrapText(true);
                        gridEquipementNon.add((Node)imageLabel, 0, 0);
                        gridEquipementNon.add((Node)NamenotAvailable, 0, 1);
                        gridEquipementNon.add((Node)notAvailable, 0, 2);
                        flowEquipe.getChildren().add((Object)gridEquipementNon);
                    }
                }
                gridpaneEquipements.getChildren().add((Object)flowEquipe);
                this.addGridWithTitle(gridpaneEquipements, AppLocal.getIntString("Text.turnover.by.equipment"));
            }
            GridPane gridpanePayments = new GridPane();
            FlowPane flowpayments = new FlowPane();
            int nbpayments = 0;
            int nbligne = nbpayments / 2;
            if (payments != null) {
                nbpayments = payments.size();
                flowpayments.setPrefWidth(this.width);
                flowpayments.setPrefHeight(this.main_pane.getPrefHeight() * 0.1 * (double)nbligne);
                flowpayments.setHgap(5.0);
                flowpayments.setVgap(20.0);
                flowpayments.setAlignment(Pos.CENTER);
                gridpanePayments.setPrefHeight((this.main_pane.getPrefHeight() * 0.1 + 20.0) * (double)nbligne);
                gridpanePayments.setPrefWidth(this.width);
                gridpanePayments.setAlignment(Pos.CENTER);
                for (PaymentLine paymentLine : payments) {
                    if (!paymentLine.getM_PaymentType().equals("Avoir")) {
                        switch (paymentLine.getM_PaymentType()) {
                            case "Espece": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/new_cash.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "CB": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/new_cb.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "Carte Ticket Resto": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/carte_tr.jpg", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "Ticket Resto": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/resto_ticketnew.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "Debit": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/debit-card.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "Cashdro": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/cashdro.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "cashGlory": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/new_cash.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "Cr\u00e9dit Employ\u00e9": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/debit-card.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "cheque": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/chequevaquance1.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "Twint": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/twint_1.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "Ch\u00e8que vacances": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/chequevaquance1.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                                break;
                            }
                            case "Virement bancaire": {
                                flowpayments.getChildren().add((Object)this.addPaymentGrid(paymentLine.getM_PaymentType(), "/com/openbravo/images/bank_transfer.jpg", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                            }
                        }
                        continue;
                    }
                    if (paymentLine.getM_PaymentValue() > 0.0) {
                        flowpayments.getChildren().add((Object)this.addPaymentGrid("Avoir Encaiss\u00e9", "/com/openbravo/images/avoir_encaisse.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                        continue;
                    }
                    flowpayments.getChildren().add((Object)this.addPaymentGrid("Avoir D\u00e9caiss\u00e9 ", "/com/openbravo/images/avoir-decaisse.png", Formats.CURRENCY.formatValue(paymentLine.getM_PaymentValue())));
                }
                gridpanePayments.getChildren().add((Object)flowpayments);
                this.addGridWithTitle(gridpanePayments, AppLocal.getIntString("Text.turnover.by.type.payment"));
            }
            GridPane gridpaneCommande = new GridPane();
            FlowPane flowpTypeorders = new FlowPane();
            int nbpordrstype = 0;
            int nbligne_order = nbpordrstype / 2;
            if (dataTypeOrders != null || dataTypePlatformOrders != null) {
                if (dataTypeOrders != null) {
                    nbpordrstype = dataTypeOrders.size();
                }
                if (dataTypePlatformOrders != null) {
                    nbpordrstype += dataTypePlatformOrders.size();
                }
                flowpTypeorders.setPrefWidth(this.width);
                flowpTypeorders.setPrefHeight(this.main_pane.getPrefHeight() * 0.07 * (double)nbligne_order);
                flowpTypeorders.setHgap(10.0);
                flowpTypeorders.setAlignment(Pos.CENTER);
                gridpaneCommande.setPrefHeight(this.main_pane.getPrefHeight() * 0.1 * (double)nbligne_order);
                gridpaneCommande.setPrefWidth(this.width);
                gridpaneCommande.setAlignment(Pos.CENTER);
                for (RankTypeOrder type : dataTypeOrders) {
                    if (type == null) continue;
                    switch (type.getName()) {
                        case "Sur Place": {
                            flowpTypeorders.getChildren().add((Object)this.addTypeOrderGrid(type.getName(), "/com/openbravo/images/surplace_1.png", Formats.CURRENCY.formatValue(type.getCa())));
                            break;
                        }
                        case "A Emporter": {
                            flowpTypeorders.getChildren().add((Object)this.addTypeOrderGrid(type.getName(), "/com/openbravo/images/emporter_1.png", Formats.CURRENCY.formatValue(type.getCa())));
                            break;
                        }
                        case "En Livraison": {
                            flowpTypeorders.getChildren().add((Object)this.addTypeOrderGrid(type.getName(), "/com/openbravo/images/laivraison.png", Formats.CURRENCY.formatValue(type.getCa())));
                            break;
                        }
                        case "Drive": {
                            flowpTypeorders.getChildren().add((Object)this.addTypeOrderGrid(type.getName(), "/com/openbravo/images/laivraison.png", Formats.CURRENCY.formatValue(type.getCa())));
                        }
                    }
                }
                for (RankTypeOrder type : dataTypePlatformOrders) {
                    if (type == null) continue;
                    switch (type.getName()) {
                        case "Just Eat": {
                            flowpTypeorders.getChildren().add((Object)this.addTypeOrderGrid(type.getName(), "/com/openbravo/images/jsuteat.png", Formats.CURRENCY.formatValue(type.getCa())));
                            break;
                        }
                        case "Uber Eats": {
                            flowpTypeorders.getChildren().add((Object)this.addTypeOrderGrid(type.getName(), "/com/openbravo/images/uber-eats.png", Formats.CURRENCY.formatValue(type.getCa())));
                            break;
                        }
                        case "Deliveroo": {
                            flowpTypeorders.getChildren().add((Object)this.addTypeOrderGrid(type.getName(), "/com/openbravo/images/deliveroo_bleu.png", Formats.CURRENCY.formatValue(type.getCa())));
                            break;
                        }
                        case "Smood": {
                            flowpTypeorders.getChildren().add((Object)this.addTypeOrderGrid(type.getName(), "/com/openbravo/images/deliveroo_bleu.png", Formats.CURRENCY.formatValue(type.getCa())));
                        }
                    }
                }
                gridpaneCommande.getChildren().add((Object)flowpTypeorders);
                this.addGridWithTitle(gridpaneCommande, AppLocal.getIntString("Text.turnover.by.type.order"));
            }
            GridPane gridCaissiers = new GridPane();
            gridCaissiers.setPrefWidth(this.width);
            FlowPane flowcaissier = new FlowPane();
            int nbcassier = 0;
            int nblignecassier = 0;
            if (users != null) {
                nbcassier = users.size();
                nblignecassier = nbcassier / 3;
                flowcaissier.setPrefWidth(this.width);
                flowcaissier.setPrefHeight((this.main_pane.getPrefHeight() * 0.05 + 20.0) * (double)nblignecassier);
                flowcaissier.setHgap(15.0);
                flowcaissier.setVgap(5.0);
                flowcaissier.setAlignment(Pos.CENTER);
                gridCaissiers.setPrefHeight((this.main_pane.getPrefHeight() * 0.05 + 15.0) * (double)nblignecassier);
                gridCaissiers.setPrefWidth(this.width);
                gridCaissiers.setAlignment(Pos.CENTER);
                gridCaissiers.setPadding(new Insets(5.0, 50.0, 0.0, 0.0));
                for (UserCaisseInfo user : users) {
                    GridPane gridCaissier = new GridPane();
                    gridCaissier.setPrefHeight(this.main_pane.getPrefHeight() * 0.05);
                    gridCaissier.setPrefWidth(this.width * 0.7);
                    gridCaissier.setHgap(5.0);
                    Label labelNameCaissier = new Label(user.getName() + ":  ");
                    Label totLabelCaissier = new Label(user.printTotal());
                    labelNameCaissier.setAlignment(Pos.CENTER);
                    totLabelCaissier.setAlignment(Pos.TOP_LEFT);
                    labelNameCaissier.getStyleClass().add((Object)"Segoe_UI_75_bold");
                    labelNameCaissier.setPrefWidth(gridCaissier.getPrefWidth() * 0.5);
                    totLabelCaissier.setPrefWidth(gridCaissier.getPrefWidth() * 0.5);
                    totLabelCaissier.getStyleClass().add((Object)"text-size16-Consolas_wight");
                    gridCaissier.add((Node)labelNameCaissier, 0, 0);
                    gridCaissier.add((Node)totLabelCaissier, 1, 0);
                    flowcaissier.getChildren().add((Object)gridCaissier);
                }
                gridCaissiers.getChildren().add((Object)flowcaissier);
                this.addGridWithTitle(gridCaissiers, AppLocal.getIntString("Text.turnover.by.cashier"));
            }
            GridPane gridInfoTotal = new GridPane();
            gridInfoTotal.setPrefHeight(this.main_pane.getPrefHeight() * 0.1);
            gridInfoTotal.setPrefWidth(this.width);
            gridInfoTotal.setAlignment(Pos.CENTER);
            gridInfoTotal.setHgap(30.0);
            FlowPane infos = new FlowPane();
            infos.setPrefWidth(this.width);
            infos.setPrefHeight(this.main_pane.getPrefHeight() * 0.2);
            infos.setHgap(70.0);
            infos.setAlignment(Pos.CENTER);
            gridInfoTotal.setPadding(new Insets(5.0, 50.0, 0.0, 0.0));
            GridPane annulation = new GridPane();
            annulation.setPrefWidth(this.width);
            annulation.setHgap(5.0);
            annulation.setVgap(10.0);
            annulation.setAlignment(Pos.CENTER);
            GridPane totalAnnulation = new GridPane();
            totalAnnulation.setPrefWidth(this.width);
            totalAnnulation.setPrefHeight(this.heightmin * 0.7);
            totalAnnulation.setHgap(7.0);
            totalAnnulation.setAlignment(Pos.CENTER);
            Label totLabelannulation = new Label(Formats.CURRENCY.formatValue(turnoverCanceled));
            totLabelannulation.getStyleClass().add((Object)"text_red_red");
            totLabelannulation.getStyleClass().add((Object)"text-size16-Consolas_wight");
            totLabelannulation.setPrefWidth(this.width * 0.5);
            totLabelannulation.setPrefHeight(this.heightmin * 0.7);
            Label labelannulation = new Label(AppLocal.getIntString("Text.cancel") + " : ");
            labelannulation.getStyleClass().add((Object)"text_red_red");
            labelannulation.getStyleClass().add((Object)"Segoe_UI_75_bold_16");
            labelannulation.setPrefWidth(this.width * 0.5);
            labelannulation.setPrefHeight(this.heightmin * 0.7);
            labelannulation.setAlignment(Pos.CENTER_RIGHT);
            totLabelannulation.setAlignment(Pos.CENTER_LEFT);
            totalAnnulation.add((Node)labelannulation, 0, 0);
            totalAnnulation.add((Node)totLabelannulation, 1, 0);
            GridPane gridTitle = new GridPane();
            gridTitle.setAlignment(Pos.CENTER);
            gridTitle.setPrefHeight(this.heightmin * 0.7);
            gridTitle.setPrefWidth(this.width);
            gridTitle.setHgap(5.0);
            Label titleDetais = new Label("N\u00baTicket");
            titleDetais.setPrefWidth(this.width * 0.24);
            titleDetais.setPrefHeight(this.heightmin * 0.7);
            titleDetais.getStyleClass().add((Object)"text-size16-Consolas_wight_12");
            Label titleTotalCancled = new Label("Total");
            titleTotalCancled.setPrefWidth(this.width * 0.24);
            titleTotalCancled.setPrefHeight(this.heightmin * 0.7);
            titleTotalCancled.getStyleClass().add((Object)"text-size16-Consolas_wight_12");
            Label titleCasLabel = new Label(AppLocal.getIntString("Label.cashier"));
            titleCasLabel.setPrefWidth(this.width * 0.24);
            titleCasLabel.setPrefHeight(this.heightmin * 0.7);
            titleCasLabel.getStyleClass().add((Object)"text-size16-Consolas_wight_12");
            Label causeLabel = new Label(AppLocal.getIntString("Text.reason"));
            causeLabel.setPrefWidth(this.width * 0.24);
            causeLabel.setPrefHeight(this.heightmin * 0.7);
            causeLabel.getStyleClass().add((Object)"text-size16-Consolas_wight_12");
            gridTitle.add((Node)titleDetais, 0, 0);
            gridTitle.add((Node)titleTotalCancled, 1, 0);
            gridTitle.add((Node)causeLabel, 2, 0);
            gridTitle.add((Node)titleCasLabel, 3, 0);
            gridTitle.setAlignment(Pos.TOP_LEFT);
            FlowPane flowDetails = new FlowPane();
            flowDetails.setPrefHeight(this.width);
            flowDetails.setHgap(5.0);
            flowDetails.setVgap(2.0);
            flowDetails.setAlignment(Pos.CENTER);
            int nbcancledTickets = 0;
            if (canceledOrders != null) {
                for (TicketInfo canceledOrder : canceledOrders) {
                    nbcancledTickets = canceledOrders.size();
                    flowDetails.setPrefHeight(this.heightmin * 0.7 * (double)nbcancledTickets);
                    if (canceledOrder == null) continue;
                    annulation.setPrefWidth(this.heightmin * 0.7 * (double)(nbcancledTickets + 2));
                    String numerTicket = canceledOrder.getNumberOrder();
                    String totalCanceled = Formats.CURRENCY.formatValue(canceledOrder.getTotalOrder());
                    String casier = canceledOrder.getUser().getName();
                    GridPane gridDetailsReduction = new GridPane();
                    gridDetailsReduction.setPrefWidth(this.width);
                    gridDetailsReduction.setPrefHeight(this.heightmin * 0.7);
                    gridDetailsReduction.setAlignment(Pos.CENTER);
                    gridDetailsReduction.setHgap(5.0);
                    Label labelnumerTicket = new Label(numerTicket);
                    labelnumerTicket.setPrefHeight(this.heightmin * 0.7 * 0.8);
                    labelnumerTicket.setPrefWidth(this.width * 0.24);
                    Label labelcasier = new Label(casier);
                    labelcasier.setPrefWidth(this.width * 0.24);
                    labelcasier.setPrefHeight(this.heightmin * 0.7 * 0.8);
                    labelcasier.setWrapText(true);
                    Label causeCancel = new Label(canceledOrder.getReason_cancel());
                    causeCancel.setPrefWidth(this.width * 0.24);
                    causeCancel.setPrefHeight(this.heightmin * 0.7 * 0.8);
                    causeCancel.setWrapText(true);
                    Label labeltotalCanceled = new Label(totalCanceled);
                    labeltotalCanceled.setPrefHeight(this.heightmin * 0.7 * 0.8);
                    labeltotalCanceled.setPrefWidth(this.width * 0.24);
                    labeltotalCanceled.getStyleClass().add((Object)"font");
                    gridDetailsReduction.add((Node)labelnumerTicket, 0, 0);
                    gridDetailsReduction.add((Node)labeltotalCanceled, 1, 0);
                    gridDetailsReduction.add((Node)causeCancel, 2, 0);
                    gridDetailsReduction.add((Node)labelcasier, 3, 0);
                    flowDetails.getChildren().add((Object)gridDetailsReduction);
                }
            }
            if (turnoverCanceled == 0.0) {
                annulation.getChildren().clear();
                annulation.setPrefHeight(this.heightmin * 0.7);
                annulation.add((Node)totalAnnulation, 0, 0);
            } else {
                annulation.getChildren().clear();
                annulation.add((Node)totalAnnulation, 0, 0);
                annulation.add((Node)gridTitle, 0, 1);
                annulation.add((Node)flowDetails, 0, 2);
            }
            this.addGrid(annulation, "");
            GridPane reduction = new GridPane();
            reduction.setPrefWidth(this.width);
            reduction.setHgap(5.0);
            reduction.setVgap(10.0);
            reduction.setAlignment(Pos.CENTER);
            GridPane totalReduction = new GridPane();
            totalReduction.setPrefWidth(this.width);
            totalReduction.setPrefHeight(this.heightmin * 0.7);
            totalReduction.setHgap(5.0);
            totalReduction.setAlignment(Pos.CENTER);
            Label totLabelReduction = new Label(Formats.CURRENCY.formatValue(totalDiscount + totalDiscountOnLines));
            totLabelReduction.getStyleClass().add((Object)"text_red_red");
            totLabelReduction.getStyleClass().add((Object)"text-size16-Consolas_wight");
            totLabelReduction.setPrefWidth(this.width * 0.5);
            totLabelReduction.setPrefHeight(this.heightmin * 0.7);
            Label labelreduction = new Label(AppLocal.getIntString("Text.discount") + " : ");
            labelreduction.getStyleClass().add((Object)"text_red_red");
            labelreduction.getStyleClass().add((Object)"Segoe_UI_75_bold_16");
            labelreduction.setPrefWidth(this.width * 0.5);
            labelreduction.setPrefHeight(this.heightmin * 0.7);
            labelreduction.setAlignment(Pos.CENTER_RIGHT);
            totLabelReduction.setAlignment(Pos.CENTER_LEFT);
            totalReduction.add((Node)labelreduction, 0, 0);
            totalReduction.add((Node)totLabelReduction, 1, 0);
            GridPane gridTitleReduction = new GridPane();
            gridTitleReduction.setAlignment(Pos.CENTER);
            gridTitleReduction.setPrefHeight(this.heightmin * 0.7);
            gridTitleReduction.setPrefWidth(this.width);
            gridTitleReduction.setHgap(5.0);
            Label titleDetaisReduction = new Label("N\u00baTicket");
            titleDetaisReduction.getStyleClass().add((Object)"text-size16-Consolas_wight_12");
            titleDetaisReduction.setPrefWidth(this.width * 0.24);
            titleDetaisReduction.setPrefHeight(this.heightmin * 0.7);
            Label titleTotalReduction = new Label("Total");
            titleTotalReduction.getStyleClass().add((Object)"text-size16-Consolas_wight_12");
            titleTotalReduction.setWrapText(true);
            titleTotalReduction.setPrefWidth(this.width * 0.24);
            titleTotalReduction.setPrefHeight(this.heightmin * 0.7);
            Label titleCasLabelReduction = new Label(AppLocal.getIntString("Label.cashier"));
            titleCasLabelReduction.getStyleClass().add((Object)"text-size16-Consolas_wight_12");
            titleCasLabelReduction.setPrefWidth(this.width * 0.24);
            titleCasLabelReduction.setPrefHeight(this.heightmin * 0.7);
            Label typeReduction = new Label("Type");
            typeReduction.getStyleClass().add((Object)"text-size16-Consolas_wight_12");
            typeReduction.setPrefWidth(this.width * 0.24);
            typeReduction.setPrefHeight(this.heightmin * 0.7);
            gridTitleReduction.add((Node)titleDetaisReduction, 0, 0);
            gridTitleReduction.add((Node)titleTotalReduction, 1, 0);
            gridTitleReduction.add((Node)typeReduction, 2, 0);
            gridTitleReduction.add((Node)titleCasLabelReduction, 3, 0);
            gridTitleReduction.setAlignment(Pos.TOP_LEFT);
            FlowPane flowDetailsReduction = new FlowPane();
            flowDetailsReduction.setPrefHeight(this.width);
            flowDetailsReduction.setHgap(5.0);
            flowDetailsReduction.setVgap(2.0);
            flowDetailsReduction.setAlignment(Pos.TOP_LEFT);
            int nbDiscountsTickets = 0;
            if (discountOrders != null) {
                for (TicketInfo discountOrder : discountOrders) {
                    nbDiscountsTickets = discountOrders.size();
                    flowDetailsReduction.setPrefHeight(this.heightmin * 0.7 * (double)nbDiscountsTickets);
                    if (discountOrder == null) continue;
                    reduction.setPrefWidth(this.heightmin * 0.7 * (double)(nbDiscountsTickets + 2));
                    String numerTicket = discountOrder.getNumberOrder();
                    String totalreduction = Formats.CURRENCY.formatValue(-Math.abs(discountOrder.getDiscountOrderAndLines()));
                    String casier = discountOrder.getUser().getName();
                    GridPane gridDetailsReduction = new GridPane();
                    gridDetailsReduction.setAlignment(Pos.CENTER);
                    gridDetailsReduction.setPrefWidth(this.width);
                    gridDetailsReduction.setPrefHeight(this.heightmin * 0.7);
                    gridDetailsReduction.setAlignment(Pos.CENTER);
                    gridDetailsReduction.setHgap(2.0);
                    Label labelnumerTicket = new Label(numerTicket);
                    labelnumerTicket.setPrefHeight(this.heightmin * 0.7 * 0.8);
                    labelnumerTicket.setPrefWidth(this.width * 0.24);
                    Label labelcasier = new Label(casier);
                    labelcasier.setPrefWidth(this.width * 0.24);
                    labelcasier.setPrefHeight(this.heightmin * 0.7 * 0.8);
                    labelcasier.setWrapText(true);
                    Label labeltotalDiscount = new Label(totalreduction);
                    labeltotalDiscount.getStyleClass().add((Object)"font");
                    labeltotalDiscount.setPrefHeight(this.heightmin * 0.7 * 0.8);
                    labeltotalDiscount.setPrefWidth(this.width * 0.24);
                    Label labelTypeDiscount = new Label(discountOrder.getTypeDiscount());
                    labelTypeDiscount.setPrefHeight(this.heightmin * 0.7 * 0.8);
                    labelTypeDiscount.setPrefWidth(this.width * 0.24);
                    gridDetailsReduction.add((Node)labelnumerTicket, 0, 0);
                    gridDetailsReduction.add((Node)labeltotalDiscount, 1, 0);
                    gridDetailsReduction.add((Node)labelTypeDiscount, 2, 0);
                    gridDetailsReduction.add((Node)labelcasier, 3, 0);
                    flowDetailsReduction.getChildren().add((Object)gridDetailsReduction);
                }
            }
            if (totalDiscount + totalDiscountOnLines == 0.0) {
                reduction.getChildren().clear();
                reduction.setPrefHeight(this.heightmin * 0.7);
                reduction.add((Node)totalReduction, 0, 0);
            } else {
                reduction.getChildren().clear();
                reduction.add((Node)totalReduction, 0, 0);
                reduction.add((Node)gridTitleReduction, 0, 1);
                reduction.add((Node)flowDetailsReduction, 0, 2);
            }
            this.addGrid(reduction, "");
            this.loadPerteBox(pertesEntity, this.GridMarchandise);
            ArrayList<MoneyMouvement> entrerArgentList = new ArrayList<MoneyMouvement>();
            ArrayList<MoneyMouvement> SortieArgentList = new ArrayList<MoneyMouvement>();
            for (MoneyMouvement money_mouvement : money_mouvements) {
                if (money_mouvement.getType().equals("entrer")) {
                    entrerArgentList.add(money_mouvement);
                    continue;
                }
                if (!money_mouvement.getType().equals("sortie")) continue;
                SortieArgentList.add(money_mouvement);
            }
            this.loadMoneyRecap(entrerArgentList, "entrer");
            this.loadMoneyRecap(SortieArgentList, "sortie");
            ObservableList observableList = FXCollections.observableArrayList();
            observableList.setAll(this.listRecapLine);
            this.list_recap.setItems(observableList);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void addGrid(GridPane gridPane, String title) {
        this.addLine(gridPane, title, false);
    }

    private void addCategoriespane(GridPane gridPane) {
        this.addLineCat(gridPane);
    }

    private void addGridWithTitle(GridPane gridPane, String title) {
        this.addLine(gridPane, title, true);
    }

    private void addLine(GridPane gridPane, String title, boolean hastitle) {
        HBoxRecapXGlobal componentLine = new HBoxRecapXGlobal(gridPane, title, hastitle);
        this.listRecapLine.add(componentLine);
    }

    private void addLineCat(GridPane gridPane) {
        HBoxRecapXGlobal componentLine = new HBoxRecapXGlobal(gridPane);
        this.listCategory.add(componentLine);
    }

    private void blankLine() {
        this.addLine(new GridPane(), "", false);
    }

    private void addProduct(GridPane gridPane) {
        HBoxRecapXGlobal componentLine = new HBoxRecapXGlobal(gridPane);
        this.listRecapLine.add(componentLine);
    }

    public void next() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText(AppLocal.getIntString("Label.today"));
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText(AppLocal.getIntString("Label.yesterday"));
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        try {
            this.getInfos();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void previous() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, -1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText(AppLocal.getIntString("Label.today"));
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText(AppLocal.getIntString("Label.yesterday"));
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        try {
            this.getInfos();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
        System.out.println("++++++++++ dateEnd setTime ********************* : " + this.dateEnd);
        System.out.println("++++++++++ dateStart  setTime********************* : " + this.dateStart);
    }

    private void initLineChart() {
        try {
            System.out.println("+++++++++++++++++++initLineChart()" + this.dateEnd);
            ArrayList salesByView = new ArrayList();
            salesByView = this.map_infos.get("statisticByHour") != null ? (List)this.map_infos.get("statisticByHour") : null;
            Map<String, LineChartModel> m_series_sales = this.sanitizeDataLineChart(salesByView);
            this.sales_stats_pane.getChildren().clear();
            CategoryAxis xAxis = new CategoryAxis();
            NumberAxis yAxis = new NumberAxis();
            xAxis.setLabel(this.getLabelByView());
            LineChart lineChart = new LineChart((Axis)xAxis, (Axis)yAxis);
            XYChart.Series series_turnover = new XYChart.Series();
            for (Map.Entry<String, LineChartModel> entry : m_series_sales.entrySet()) {
                String key = entry.getKey();
                LineChartModel m = entry.getValue();
                series_turnover.getData().add((Object)new XYChart.Data((Object)key, (Object)m.getTurnover()));
            }
            lineChart.setLegendVisible(false);
            lineChart.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.55);
            lineChart.getData().add((Object)series_turnover);
            this.sales_stats_pane.getChildren().setAll((Object[])new Node[]{lineChart});
            String rgbColor = String.format("%d, %d, %d", 118, 221, 251);
            String styleLine = "-fx-stroke: rgba(" + rgbColor + ", 1.0);";
            String symbolStyle = "-fx-background-color: rgba(" + rgbColor + ", 1.0), whitesmoke;";
            series_turnover.getNode().lookup(".chart-series-line").setStyle(styleLine);
            for (XYChart.Data data : series_turnover.getData()) {
                Node node = data.getNode().lookup(".chart-line-symbol");
                node.setStyle(symbolStyle);
                EventMouseChartLine m_event = new EventMouseChartLine(node, (String)data.getXValue(), (Number)data.getYValue(), Formats.CURRENCY.formatValue(data.getYValue()));
                node.setOnMouseEntered((EventHandler)m_event);
                node.setOnMouseClicked((EventHandler)m_event);
                node.setOnMouseExited((EventHandler)m_event);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    private Map<String, LineChartModel> sanitizeDataLineChart(List m_data) {
        LinkedHashMap<String, LineChartModel> m_series_sales = new LinkedHashMap<String, LineChartModel>();
        Calendar calendar = Calendar.getInstance();
        Calendar m_calendar = Calendar.getInstance();
        for (Map.Entry<String, Long> entry : this.m_keysLineChart.entrySet()) {
            String key = entry.getKey();
            Long time = entry.getValue();
            calendar.setTimeInMillis(time);
            m_series_sales.put(key, new LineChartModel());
            for (HourInfo next : m_data) {
                m_calendar.clear();
                m_calendar.setTimeInMillis(time);
                m_calendar.set(11, next.getHour());
                m_series_sales.replace(com.openbravo.pos.util.DateUtils.formatHour(m_calendar.getTime()), new LineChartModel(next.getTurnover(), next.getOrders()));
            }
        }
        return m_series_sales;
    }

    private String getLabelByView() {
        System.out.println("++++++++++++++++++++++++++++labeldateEnd" + this.dateEnd);
        String label = com.openbravo.pos.util.DateUtils.formatDay(this.dateStart, "dd") + " " + com.openbravo.pos.util.DateUtils.formatMonth(this.dateStart) + " " + com.openbravo.pos.util.DateUtils.formatYear(this.dateStart);
        return label;
    }

    private void setTurnoverProgress() {
        double turnoverProgress;
        double turnoverCurrentHour = 0.0;
        int currentHour = new Date().getHours();
        List salesHour = this.map_infos.get("statisticByHour") != null ? (List)this.map_infos.get("statisticByHour") : null;
        System.out.println("+++++++++ currentHour : " + currentHour);
        for (HourInfo mHourInfo : salesHour) {
            System.out.println("++++++ mHourInfo : " + mHourInfo);
            if (mHourInfo.getHour() != currentHour) continue;
            turnoverCurrentHour = mHourInfo.getTurnover();
            break;
        }
        double turnoverLastWeekSameHour = this.map_infos.get("turnoverLasWeekSameHour") != null ? (Double)this.map_infos.get("turnoverLasWeekSameHour") : 0.0;
        double d = turnoverProgress = turnoverLastWeekSameHour > 0.0 ? NumericUtils.round(NumericUtils.round((turnoverCurrentHour - turnoverLastWeekSameHour) / turnoverLastWeekSameHour) * 100.0) : NumericUtils.round(turnoverCurrentHour);
        if (turnoverProgress >= 0.0) {
            this.label_progress_turnover.setText("+" + turnoverProgress + "%");
            this.label_progress_turnover.setStyle("-fx-text-fill: #55AC3F; -fx-font-size: 14pt;");
        } else {
            this.label_progress_turnover.setText(turnoverProgress + "%");
            this.label_progress_turnover.setStyle("-fx-text-fill: red; -fx-font-size: 14pt;");
        }
    }

    public void showSharedOrders() {
    }

    public void load() {
        try {
            this.date = DateUtils.getToday();
            Calendar calToday = Calendar.getInstance();
            if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
                calToday.setTime(this.date);
                calToday.add(6, -1);
                this.date = calToday.getTime();
            }
            this.jdate.setText(AppLocal.getIntString("Label.today"));
            this.setTime(this.date);
            CaisseInfo mCaisseInfo = AppLocal.dlSales.getCaisse(AppLocal.token);
            if (mCaisseInfo != null) {
                StringBuilder info_open_caisse = new StringBuilder();
                info_open_caisse.append("caisse ouverte");
                info_open_caisse.append("\n");
                info_open_caisse.append("A ");
                info_open_caisse.append(this.timeFormatter.format(mCaisseInfo.getDateOpen()));
                if (mCaisseInfo.getUser_open() != null) {
                    info_open_caisse.append(" par ");
                    info_open_caisse.append(mCaisseInfo.getUser_open().getName());
                }
            }
            com.openbravo.pos.util.DateUtils.fillHours(this.m_keysLineChart, this.dateStart);
            this.text_progress_turnover.setText(AppLocal.getIntString("Text.last.week"));
            this.getInfos();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void closeTheCaisse() {
        try {
            this.mCaisseInfo = this.dlSales.getCaisse(AppLocal.token);
            int orderPending = this.dlSales.getNbOrderPending(this.mCaisseInfo.getDateOpen());
            if (orderPending > 0) {
                this.cancelOrders();
            } else {
                this.confirmCloseCaisse();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void cancelOrders() {
        try {
            this.mActionEventCancelOrders = new EventHiddenModal(){
                boolean result;

                @Override
                public void onHidden() {
                    if (this.result) {
                        try {
                            XGlobalController.this.confirmCloseCaisse();
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                    XGlobalController.this.mLazyModalCancelOrders.destroyEvents();
                    XGlobalController.this.mActionEventCancelOrders = null;
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        PopUpCancelOrders mController = (PopUpCancelOrders)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalCancelOrders == null) {
                this.mLazyModalCancelOrders = new LazyModal(StageStyle.UNDECORATED, this.scene, this.popUp_canel_orders, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.7)));
            }
            this.mLazyModalCancelOrders.setEventHiddenModal(this.mActionEventCancelOrders);
            this.mLazyModalCancelOrders.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void confirmCloseCaisse() throws BasicException, IOException, SQLException {
        System.out.println("+++++++++++++++ confirmCloseCaisse ******************** : ");
        Date dateStart = this.mCaisseInfo.getDateOpen();
        Date dateEnd = new Date();
        final FinancialReportInfo financialReportInfo = this.mTicketService.getRapportCashFund(dateStart, dateEnd, this.mCaisseInfo.getFondCaisse());
        try {
            this.mActionEventCloseCaisse = new EventHiddenModal(){
                Object[] result;

                @Override
                public void onHidden() {
                    if (((Boolean)this.result[1]).booleanValue()) {
                        XGlobalController.this.mTicketService.closeCaisse(financialReportInfo, this.result, XGlobalController.this.mCaisseInfo);
                        JPrincipalApp.principaleApp.afterClose();
                    }
                    XGlobalController.this.mLazyModalCloseCaisse.destroyEvents();
                    XGlobalController.this.mActionEventCloseCaisse = null;
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        CloseCaisseController mController = (CloseCaisseController)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalCloseCaisse == null) {
                this.mLazyModalCloseCaisse = new LazyModal(StageStyle.UNDECORATED, this.scene, this.close_caisse, new Dimension((int)AppVarUtils.getScreenDimension().getWidth(), (int)AppVarUtils.getScreenDimension().getHeight()));
            }
            this.mLazyModalCloseCaisse.setEventHiddenModal(this.mActionEventCloseCaisse);
            this.mLazyModalCloseCaisse.load(financialReportInfo.getTurnover(), financialReportInfo.getPayments(), financialReportInfo.getValueCourses(), true);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadSharedOrders(Date dateStart, Date dateEnd) {
        try {
            this.mActionEventSharedOrders = new EventHiddenModal(){

                @Override
                public void onHidden() {
                    XGlobalController.this.mLazyModalSharedOrders.destroyEvents();
                    XGlobalController.this.mActionEventSharedOrders = null;
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    this.onHidden();
                }
            };
            if (this.mLazyModalSharedOrders == null) {
                this.mLazyModalSharedOrders = new LazyModal(StageStyle.UNDECORATED, this.scene, this.popUp_shared_orders, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.6), (int)(AppVarUtils.getScreenDimension().getHeight() * 0.7)));
            }
            this.mLazyModalSharedOrders.setEventHiddenModal(this.mActionEventSharedOrders);
            this.mLazyModalSharedOrders.load(dateStart, dateEnd);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void initCSS() {
        this.list_Categ.setStyle("list-no-scrollbar-no-border-cat");
        this.close_caissePane.setOnMouseClicked(event -> this.closeTheCaisse());
        this.label_open_caisse.getStyleClass().add((Object)"Segoe_UI_758_18");
        this.jdate.getStyleClass().add((Object)"label_text_wight_fondblack");
        this.calendar_pane.getStyleClass().add((Object)"bg_323F51");
        this.total_label.setAlignment(Pos.CENTER);
        this.total_label.getStyleClass().add((Object)"bg_323F51");
        this.pane_border.getStyleClass().add((Object)"label_text_size");
        this.label_number_Order.getStyleClass().add((Object)"nb_order_label");
        this.text_number_order.setText(AppLocal.getIntString("Text.orders"));
        this.btn_previous_date.getStyleClass().add((Object)"bg_323F51");
        this.btn_next_date.getStyleClass().add((Object)"bg_323F51");
        Image imagecloseCaisse = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/closeimage.png"));
        this.closecaisseImage.setGraphic((Node)new ImageView(imagecloseCaisse));
        Image printImage = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/print.png"));
        this.print.setGraphic((Node)new ImageView(printImage));
    }

    public GridPane addPaymentGrid(String type, String url, String amount) {
        GridPane gridPayment = new GridPane();
        gridPayment.setPrefHeight(this.main_pane.getPrefHeight() * 0.05);
        gridPayment.setPrefWidth(this.width * 0.45);
        gridPayment.setVgap(5.0);
        gridPayment.setAlignment(Pos.CENTER);
        gridPayment.setHgap(5.0);
        Image paymentImage = new Image(this.getClass().getResourceAsStream(url));
        ImageView imagePayment = new ImageView(paymentImage);
        Label imagePaymentLabel = new Label();
        imagePaymentLabel.setPrefHeight(gridPayment.getPrefHeight());
        imagePaymentLabel.setPrefWidth(gridPayment.getPrefWidth() * 0.15);
        imagePayment.setFitWidth(imagePaymentLabel.getPrefWidth());
        imagePayment.setFitHeight(imagePaymentLabel.getPrefHeight() * 0.6);
        imagePaymentLabel.setGraphic((Node)imagePayment);
        imagePaymentLabel.setAlignment(Pos.CENTER);
        Label labelType = new Label(type + ":");
        labelType.setWrapText(true);
        labelType.getStyleClass().add((Object)"Segoe_UI_75_bold");
        labelType.setPrefWidth(gridPayment.getPrefWidth() * 0.4);
        labelType.setAlignment(Pos.CENTER);
        labelType.setWrapText(true);
        Label labelAmount = new Label(amount);
        labelAmount.setPrefWidth(gridPayment.getPrefWidth() * 0.45);
        labelAmount.setAlignment(Pos.TOP_LEFT);
        labelAmount.getStyleClass().add((Object)"text-size16-Consolas_wight");
        gridPayment.add((Node)imagePaymentLabel, 0, 0);
        gridPayment.add((Node)labelType, 1, 0);
        gridPayment.add((Node)labelAmount, 2, 0);
        return gridPayment;
    }

    public GridPane addTypeOrderGrid(String type, String url, String amount) {
        GridPane gridTypeOrder = new GridPane();
        gridTypeOrder.setPrefHeight(this.main_pane.getPrefHeight() * 0.1);
        gridTypeOrder.setPrefWidth(this.width * 0.45);
        gridTypeOrder.setVgap(5.0);
        gridTypeOrder.setAlignment(Pos.CENTER);
        gridTypeOrder.setHgap(10.0);
        Image paymentImage = new Image(this.getClass().getResourceAsStream(url));
        ImageView imageOrderType = new ImageView(paymentImage);
        GridPane typeOrder = new GridPane();
        typeOrder.setPrefHeight(gridTypeOrder.getPrefHeight());
        typeOrder.setAlignment(Pos.CENTER);
        typeOrder.setPrefWidth(gridTypeOrder.getPrefWidth() * 0.7);
        Label labelType = new Label(type + ":");
        labelType.setWrapText(true);
        labelType.setAlignment(Pos.TOP_LEFT);
        labelType.getStyleClass().add((Object)"Segoe_UI_75_bold");
        labelType.setPrefWidth(typeOrder.getPrefWidth());
        labelType.setPrefHeight(typeOrder.getPrefHeight() * 0.5);
        Label labelAmount = new Label(amount);
        labelType.setPrefWidth(typeOrder.getPrefWidth());
        labelType.setPrefHeight(typeOrder.getPrefHeight() * 0.5);
        labelType.setWrapText(true);
        labelAmount.setPrefWidth(typeOrder.getPrefWidth());
        labelAmount.setPrefHeight(typeOrder.getPrefHeight() * 0.5);
        labelAmount.setAlignment(Pos.TOP_LEFT);
        labelAmount.getStyleClass().add((Object)"text-size16-Consolas_wight");
        typeOrder.add((Node)labelType, 0, 0);
        typeOrder.add((Node)labelAmount, 0, 1);
        gridTypeOrder.add((Node)imageOrderType, 0, 0);
        gridTypeOrder.add((Node)typeOrder, 1, 0);
        return gridTypeOrder;
    }

    public void perteMarchandise() throws IOException {
        this.recap_pane.getChildren().clear();
        this.list_recap.getItems().clear();
        if (this.listCategory == null) {
            this.listCategory = new ArrayList<HBoxRecapXGlobal>();
        } else {
            this.listCategory.clear();
        }
        if (this.listRecapLine == null) {
            this.listRecapLine = new ArrayList<HBoxRecapXGlobal>();
        } else {
            this.listRecapLine.clear();
        }
        GridPane productsPane = new GridPane();
        this.gridvalidCase.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.5 * 0.8);
        this.gridvalidCase.setPrefHeight(this.recap_pane.getPrefHeight() * 0.1);
        this.gridvalidCase.setAlignment(Pos.CENTER);
        this.gridvalidCase.setHgap(20.0);
        this.gridvalidCase.getStyleClass().add((Object)"bg_D0DFEC");
        Button raisonbtn = new Button(AppLocal.getIntString("Text.reason"));
        Button validcase = new Button(AppLocal.getIntString("Button.valid"));
        raisonbtn.setPrefHeight(this.gridvalidCase.getPrefHeight() * 0.7);
        validcase.setPrefHeight(this.gridvalidCase.getPrefHeight() * 0.7);
        raisonbtn.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.3);
        validcase.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.3);
        raisonbtn.setStyle("-fx-text-fill:   #4F5A6D;-fx-background-color: #D3D2D2;-fx-border-color: #000066;");
        raisonbtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                boolean empty = false;
                for (Map.Entry<ProductInfoExt, Integer> set : XGlobalController.this.pertes_category.entrySet()) {
                    if (set.getValue() <= 0) continue;
                    empty = true;
                    break;
                }
                if (empty) {
                    XGlobalController.this.loadRaisonPane("perte");
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Text.fill.in.loss"), 4000, NPosition.CENTER);
                }
            }
        });
        validcase.getStyleClass().add((Object)"btn_validecase");
        validcase.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                XGlobalController.this.validerCase();
            }
        });
        this.montantperte.getStyleClass().add((Object)"Segoe_UI_75_bold");
        this.gridvalidCase.add((Node)raisonbtn, 0, 0);
        this.gridvalidCase.add((Node)validcase, 1, 0);
        productsPane.setPrefHeight(this.main_pane.getPrefHeight());
        productsPane.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.5 * 0.68);
        productsPane.setAlignment(Pos.CENTER);
        GridPane categoriePanes = new GridPane();
        categoriePanes.setPrefHeight(this.main_pane.getPrefHeight());
        categoriePanes.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.5 * 0.3);
        categoriePanes.setAlignment(Pos.CENTER);
        this.list_Categ.setPrefHeight(categoriePanes.getPrefHeight() * 0.9);
        this.list_Categ.setPrefWidth(categoriePanes.getPrefWidth() * 0.98);
        GridPane existPane = new GridPane();
        existPane.setPrefWidth(productsPane.getPrefWidth());
        existPane.setPrefHeight(productsPane.getPrefHeight() * 0.05);
        existPane.setAlignment(Pos.TOP_RIGHT);
        existPane.getStyleClass().add((Object)"bg_gray_F5F5F5");
        Button exiButton = new Button();
        exiButton.setPrefHeight(existPane.getPrefHeight());
        exiButton.setPrefWidth(existPane.getPrefWidth() * 0.07);
        Image exitImage = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/delete_icon.png"));
        ImageView imageviewExit = new ImageView(exitImage);
        imageviewExit.setFitHeight(exiButton.getPrefHeight() * 0.9);
        imageviewExit.setFitWidth(exiButton.getPrefWidth());
        exiButton.setGraphic((Node)imageviewExit);
        exiButton.getStyleClass().add((Object)"bg_gray_F5F5F5");
        exiButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                XGlobalController.this.exitFromRecap();
            }
        });
        existPane.add((Node)exiButton, 0, 0);
        GridPane gridlist = new GridPane();
        gridlist.setPrefHeight(productsPane.getPrefHeight() * 0.85);
        gridlist.setPrefWidth(productsPane.getPrefWidth());
        gridlist.setAlignment(Pos.CENTER);
        gridlist.add((Node)this.list_recap, 0, 0);
        productsPane.add((Node)existPane, 0, 0);
        productsPane.add((Node)gridlist, 0, 1);
        productsPane.add((Node)this.gridvalidCase, 0, 2);
        GridPane gridCatMenu = new GridPane();
        gridCatMenu.setAlignment(Pos.CENTER);
        FlowPane flowCategories = new FlowPane();
        flowCategories.setAlignment(Pos.CENTER);
        Image imagecat = null;
        this.list_Categ.getStyleClass().add((Object)"list-no-scrollbar-no-border-cat");
        for (CategoryInfo category : this.categories) {
            gridCatMenu.setPrefHeight(categoriePanes.getPrefHeight() * 0.9);
            gridCatMenu.setPrefWidth(categoriePanes.getPrefWidth() * 0.71);
            flowCategories.setPrefHeight(gridCatMenu.getPrefHeight());
            flowCategories.setPrefWidth(gridCatMenu.getPrefWidth());
            flowCategories.setVgap(5.0);
            if (category == null) continue;
            GridPane gridcat = new GridPane();
            gridcat.setPrefHeight(this.main_pane.getPrefHeight() * 0.07);
            gridcat.setPrefWidth(gridCatMenu.getPrefWidth());
            gridcat.setAlignment(Pos.CENTER);
            gridcat.setHgap(5.0);
            Label NameCategory = new Label(category.getName());
            NameCategory.setPrefHeight(gridcat.getPrefHeight());
            NameCategory.setPrefWidth(gridcat.getPrefWidth() * 0.6);
            NameCategory.setAlignment(Pos.CENTER);
            NameCategory.getStyleClass().add((Object)"Segoe_UI_75_bold");
            NameCategory.setWrapText(true);
            String path_category = category.getPath();
            Label labelimgcat = new Label();
            labelimgcat.setPrefHeight(gridcat.getPrefHeight() * 0.7);
            labelimgcat.setPrefWidth(gridcat.getPrefWidth() * 0.3);
            labelimgcat.setAlignment(Pos.CENTER);
            if (path_category != null) {
                File directory = this.m_FilerUtils.getFileFullPath("images/catagories");
                FileUtils.forceMkdir((File)directory);
                String url = directory.getPath();
                File dest = new File(url + "/" + path_category);
                imagecat = dest.exists() ? new Image((InputStream)new FileInputStream(dest)) : new Image(this.getClass().getResourceAsStream("/com/openbravo/images/cat_img.png"));
            } else {
                imagecat = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/cat_img.png"));
            }
            ImageView imageviewCategory = new ImageView(imagecat);
            imageviewCategory.setFitHeight(labelimgcat.getPrefHeight());
            imageviewCategory.setFitWidth(labelimgcat.getPrefWidth());
            labelimgcat.setGraphic((Node)imageviewCategory);
            gridcat.add((Node)labelimgcat, 0, 0);
            gridcat.add((Node)NameCategory, 1, 0);
            this.gridnotSelected.put(category.getID(), gridcat);
            gridcat.setOnMouseClicked(event -> {
                try {
                    this.getPrductsList(category);
                }
                catch (Exception ex) {
                    Logger.getLogger(XGlobalController.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            flowCategories.getChildren().add((Object)gridcat);
        }
        gridCatMenu.getChildren().add((Object)flowCategories);
        this.addCategoriespane(gridCatMenu);
        ObservableList observableList = FXCollections.observableArrayList();
        observableList.setAll(this.listCategory);
        this.list_Categ.setItems(observableList);
        this.montantperte.setPrefHeight(categoriePanes.getPrefHeight() * 0.1);
        this.montantperte.setPrefWidth(categoriePanes.getPrefWidth());
        this.montantperte.getStyleClass().add((Object)"Segoe_UI_75_bold");
        this.montantperte.getStyleClass().add((Object)"bg_D0DFEC");
        this.montantperte.setAlignment(Pos.CENTER);
        categoriePanes.add((Node)this.list_Categ, 0, 0);
        categoriePanes.add((Node)this.montantperte, 0, 1);
        this.recap_pane.add((Node)categoriePanes, 0, 0);
        this.recap_pane.add((Node)productsPane, 1, 0);
    }

    public void getPrductsList(CategoryInfo categoryInfo) throws IOException {
        GridPane paneCategory = this.gridnotSelected.get(categoryInfo.getID());
        paneCategory.setStyle(" -fx-border-radius: 50%;    -fx-border-color : #000;-fx-border-color: #000066;");
        for (Integer key : this.gridnotSelected.keySet()) {
            if (key.intValue() == categoryInfo.getID()) continue;
            this.gridnotSelected.get(key).setStyle("");
        }
        Image image_product = null;
        if (this.listRecapLine == null) {
            this.listRecapLine = new ArrayList<HBoxRecapXGlobal>();
        } else {
            this.listRecapLine.clear();
        }
        try {
            List<ProductInfoExt> products = this.dlItems.getProducts(categoryInfo.getID(), false, false, false, false);
            FlowPane flowPane = new FlowPane();
            flowPane.setAlignment(Pos.CENTER);
            GridPane gridProducts = new GridPane();
            gridProducts.setPrefWidth(this.main_pane.getPrefWidth() * 0.5 * 0.6);
            gridProducts.setPrefHeight(this.main_pane.getPrefHeight() * 0.8);
            flowPane.setPrefWidth(gridProducts.getPrefWidth());
            gridProducts.setAlignment(Pos.CENTER);
            for (final ProductInfoExt product : products) {
                flowPane.setPrefHeight(gridProducts.getPrefHeight());
                GridPane productPane = new GridPane();
                productPane.setPrefHeight(gridProducts.getPrefHeight() * 0.1);
                productPane.setPrefWidth(gridProducts.getPrefWidth());
                Label nameProduct = new Label(product.getName());
                nameProduct.setWrapText(true);
                nameProduct.getStyleClass().add((Object)"Segoe_UI_75_bold");
                nameProduct.setPrefWidth(productPane.getPrefWidth() * 0.5);
                nameProduct.setPrefHeight(productPane.getPrefHeight());
                nameProduct.setAlignment(Pos.CENTER);
                Label imageLabel = new Label();
                imageLabel.setPrefHeight(productPane.getPrefHeight());
                imageLabel.setPrefWidth(productPane.getPrefWidth() * 0.2);
                String path_product = product.getImageProduct();
                if (path_product != null) {
                    File directory = this.m_FilerUtils.getFileFullPath("images/products");
                    FileUtils.forceMkdir((File)directory);
                    String url = directory.getPath();
                    File dest = new File(url + "/" + path_product);
                    image_product = dest.exists() ? new Image((InputStream)new FileInputStream(dest)) : new Image(this.getClass().getResourceAsStream("/com/openbravo/images/product_img.png"));
                } else {
                    image_product = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/product_img.png"));
                }
                ImageView imageviewProduct = new ImageView(image_product);
                imageviewProduct.setFitHeight(imageLabel.getPrefHeight() * 0.9);
                imageviewProduct.setFitWidth(imageLabel.getPrefWidth() * 0.9);
                imageLabel.setGraphic((Node)imageviewProduct);
                imageLabel.setAlignment(Pos.CENTER);
                GridPane gridbuttons = new GridPane();
                gridbuttons.setPrefWidth(productPane.getPrefWidth() * 0.3);
                gridbuttons.setPrefHeight(productPane.getPrefHeight());
                gridbuttons.setHgap(15.0);
                gridbuttons.setAlignment(Pos.CENTER);
                Button add_perte = new Button();
                Button delete_perte = new Button();
                add_perte.setPrefHeight(gridbuttons.getPrefHeight() * 0.5);
                add_perte.setPrefWidth(gridbuttons.getPrefWidth() * 0.33);
                add_perte.setGraphic((Node)new ImageView(new Image(this.getClass().getResourceAsStream("/com/openbravo/images/plus.png"))));
                add_perte.getStyleClass().add((Object)"bg_gray_F5F5F5");
                delete_perte.setPrefHeight(gridbuttons.getPrefHeight() * 0.5);
                delete_perte.getStyleClass().add((Object)"bg_gray_F5F5F5");
                delete_perte.setPrefWidth(gridbuttons.getPrefWidth() * 0.33);
                final Label quantite = new Label("0");
                quantite.setPrefHeight(gridbuttons.getPrefHeight() * 0.5);
                quantite.getStyleClass().add((Object)"Segoe_UI_75_bold");
                quantite.setPrefWidth(gridbuttons.getPrefWidth() * 0.33);
                quantite.setAlignment(Pos.CENTER);
                delete_perte.setGraphic((Node)new ImageView(new Image(this.getClass().getResourceAsStream("/com/openbravo/images/minus.png"))));
                this.pertes_category.put(product, 0);
                add_perte.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        int quantite_perte = 0;
                        XGlobalController.this.capert -= product.getPriceSell();
                        XGlobalController.this.pertes_category.remove(product);
                        XGlobalController.this.pertes_category.put(product, Integer.parseInt(quantite.getText()) + ++quantite_perte);
                        quantite.setText(String.valueOf(Integer.parseInt(quantite.getText()) + quantite_perte));
                        XGlobalController.this.montantperte.setText(AppLocal.getIntString("Text.amount.loss") + " : " + Formats.CURRENCY.formatValue(XGlobalController.this.capert));
                    }
                });
                delete_perte.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        if (Integer.parseInt(quantite.getText()) == 0) {
                            quantite.setText("0");
                        } else {
                            XGlobalController.this.capert += product.getPriceSell();
                            quantite.setText(String.valueOf(Integer.parseInt(quantite.getText()) - 1));
                            if (Integer.parseInt(quantite.getText()) > 0) {
                                XGlobalController.this.pertes_category.remove(product);
                                XGlobalController.this.pertes_category.put(product, Integer.parseInt(quantite.getText()));
                            } else {
                                XGlobalController.this.pertes_category.remove(product);
                            }
                            XGlobalController.this.montantperte.setText(AppLocal.getIntString("Text.amount.loss") + " : " + Formats.CURRENCY.formatValue(XGlobalController.this.capert));
                        }
                    }
                });
                gridbuttons.add((Node)add_perte, 0, 0);
                gridbuttons.add((Node)quantite, 1, 0);
                gridbuttons.add((Node)delete_perte, 2, 0);
                productPane.add((Node)imageLabel, 0, 0);
                productPane.add((Node)nameProduct, 1, 0);
                productPane.add((Node)gridbuttons, 2, 0);
                flowPane.getChildren().add((Object)productPane);
            }
            gridProducts.getChildren().add((Object)flowPane);
            this.addProduct(gridProducts);
            ObservableList observableList = FXCollections.observableArrayList();
            observableList.setAll(this.listRecapLine);
            this.list_recap.setItems(observableList);
        }
        catch (BasicException ex) {
            Logger.getLogger(XGlobalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exitFromRecap() {
        this.recap_pane.getChildren().clear();
        this.recap_pane.setStyle("-fx-background-color: #D0DFEC;");
        this.panedetails.getChildren().clear();
        this.panedetails.add((Node)this.list_recap, 0, 0);
        this.paneprint.getChildren().clear();
        this.paneprint.add((Node)this.print, 0, 0);
        this.recap_pane.add((Node)this.panedetails, 0, 0);
        this.recap_pane.add((Node)this.paneprint, 0, 1);
        this.getInfos();
    }

    public void validerCase() {
        String raison = this.labelTextAria.getText();
        if (raison == null || raison.equals("")) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Text.reason.amount.loss"), 4000, NPosition.CENTER);
        }
    }

    public void moneyMouvement(final String type) {
        try {
            this.recap_pane.getChildren().clear();
            this.recap_pane.setStyle("-fx-background-color: #D0DFEC;");
            this.recap_pane.setAlignment(Pos.CENTER);
            GridPane gridLabel = new GridPane();
            gridLabel.setPrefHeight(this.recap_pane.getPrefHeight() * 0.25);
            gridLabel.setPrefWidth(this.recap_pane.getPrefWidth() * 0.8);
            gridLabel.setAlignment(Pos.CENTER);
            gridLabel.setVgap(10.0);
            Label labelTitle = new Label("");
            labelTitle.setPrefHeight(gridLabel.getPrefHeight() * 0.4);
            labelTitle.setPrefWidth(gridLabel.getPrefWidth());
            labelTitle.setAlignment(Pos.CENTER);
            if (type.equals("entrer")) {
                this.focusedTextField.setText("");
                labelTitle.setStyle("-fx-font-size: 13pt;-fx-text-fill: green ;-fx-font-weight: bold;-fx-font-family: Segoe UI Bold 86");
                labelTitle.setText(AppLocal.getIntString("Text.amount.in"));
            } else if (type.equals("sortie")) {
                this.focusedTextField.setText("");
                labelTitle.setStyle("-fx-font-size: 13pt;-fx-text-fill: red ;-fx-font-weight: bold;-fx-font-family: Segoe UI Bold 86");
                labelTitle.setText(AppLocal.getIntString("Text.amount.out"));
            }
            this.focusedTextField.setPrefHeight(gridLabel.getPrefHeight() * 0.5);
            this.focusedTextField.setPrefWidth(gridLabel.getPrefWidth());
            this.focusedTextField.setStyle("-fx-font-size: 16pt;-fx-text-fill: white;-fx-background-color: #5A8DEE;");
            this.focusedTextField.setAlignment(Pos.CENTER);
            gridLabel.add((Node)labelTitle, 0, 0);
            gridLabel.add((Node)this.focusedTextField, 0, 1);
            GridPane keyBoardPane = new GridPane();
            keyBoardPane.setPrefWidth(this.recap_pane.getPrefWidth() * 0.8);
            keyBoardPane.setPrefHeight(this.recap_pane.getPrefHeight() * 0.55);
            keyBoardPane.setAlignment(Pos.CENTER);
            keyBoardPane.setHgap(10.0);
            keyBoardPane.setVgap(10.0);
            keyBoardPane.getStyleClass().add((Object)"bg_D0DFEC");
            Button btn1 = this.ButtonNumber(this.focusedTextField, "1", keyBoardPane);
            Button btn2 = this.ButtonNumber(this.focusedTextField, "2", keyBoardPane);
            Button btn3 = this.ButtonNumber(this.focusedTextField, "3", keyBoardPane);
            Button btn4 = this.ButtonNumber(this.focusedTextField, "4", keyBoardPane);
            Button btn5 = this.ButtonNumber(this.focusedTextField, "5", keyBoardPane);
            Button btn6 = this.ButtonNumber(this.focusedTextField, "6", keyBoardPane);
            Button btn7 = this.ButtonNumber(this.focusedTextField, "7", keyBoardPane);
            Button btn8 = this.ButtonNumber(this.focusedTextField, "8", keyBoardPane);
            Button btn9 = this.ButtonNumber(this.focusedTextField, "9", keyBoardPane);
            Button btn0 = this.ButtonNumber(this.focusedTextField, "0", keyBoardPane);
            Image image17 = new Image(this.getClass().getResource("/com/openbravo/images/deletenumb.PNG").toURI().toString());
            Button btnc = new Button();
            btnc.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    XGlobalController.this.selectBack();
                }
            });
            btnc.setPrefHeight(keyBoardPane.getPrefHeight() * 0.21);
            btnc.setPrefWidth(keyBoardPane.getPrefWidth() * 0.25);
            btnc.getStyleClass().add((Object)"btn_closekey");
            btnc.getStyleClass().add((Object)"text_keybeard_closecaisse");
            ImageView imagebtnc = new ImageView(image17);
            imagebtnc.setFitHeight(keyBoardPane.getPrefHeight() * 0.15);
            imagebtnc.setFitWidth(keyBoardPane.getPrefWidth() * 0.18);
            btnc.setGraphic((Node)imagebtnc);
            Button btnpoint = new Button(".");
            btnpoint.setPrefHeight(keyBoardPane.getPrefHeight() * 0.21);
            btnpoint.setPrefWidth(keyBoardPane.getPrefWidth() * 0.25);
            btnpoint.getStyleClass().add((Object)"btn_closekey");
            btnpoint.getStyleClass().add((Object)"text_keybeard_closecaisse");
            btnpoint.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    XGlobalController.this.selectPoint();
                }
            });
            keyBoardPane.add((Node)btn7, 0, 0);
            keyBoardPane.add((Node)btn8, 0, 1);
            keyBoardPane.add((Node)btn9, 0, 2);
            keyBoardPane.add((Node)btn4, 1, 0);
            keyBoardPane.add((Node)btn5, 1, 1);
            keyBoardPane.add((Node)btn6, 1, 2);
            keyBoardPane.add((Node)btn1, 2, 0);
            keyBoardPane.add((Node)btn2, 2, 1);
            keyBoardPane.add((Node)btn3, 2, 2);
            keyBoardPane.add((Node)btn0, 3, 0);
            keyBoardPane.add((Node)btnpoint, 3, 1);
            keyBoardPane.add((Node)btnc, 3, 2);
            GridPane validPane = new GridPane();
            validPane.setPrefWidth(this.recap_pane.getPrefWidth() * 0.8);
            validPane.setPrefHeight(this.recap_pane.getPrefHeight() * 0.1);
            validPane.setAlignment(Pos.CENTER);
            validPane.setHgap(10.0);
            Button btncancel = new Button(AppLocal.getIntString("Button.cancel"));
            btncancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    XGlobalController.this.exitFromRecap();
                }
            });
            btncancel.setPrefWidth(validPane.getPrefWidth() * 0.33);
            btncancel.setPrefHeight(validPane.getPrefHeight() * 0.8);
            btncancel.getStyleClass().add((Object)"bgred_FF5B5C");
            Button valid = new Button(AppLocal.getIntString("Button.valid"));
            valid.setPrefWidth(validPane.getPrefWidth() * 0.33);
            valid.setPrefHeight(validPane.getPrefHeight() * 0.8);
            valid.getStyleClass().add((Object)"bg_sea_green");
            valid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    if (XGlobalController.this.focusedTextField.getText() != null && !XGlobalController.this.focusedTextField.getText().isEmpty() && XGlobalController.this.focusedTextField.getText().charAt(0) != '.' && XGlobalController.this.focusedTextField.getText().charAt(0) != ' ') {
                        XGlobalController.this.loadRaisonPane(type);
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Text.amount.valid"), 4000, NPosition.CENTER);
                    }
                }
            });
            validPane.add((Node)btncancel, 0, 0);
            validPane.add((Node)valid, 1, 0);
            this.recap_pane.add((Node)gridLabel, 0, 0);
            this.recap_pane.add((Node)keyBoardPane, 0, 1);
            this.recap_pane.add((Node)validPane, 0, 2);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(XGlobalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Button ButtonNumber(final Label labelText, final String number, GridPane keyBoardPane) {
        Button btn = new Button(String.valueOf(number));
        btn.setPrefHeight(keyBoardPane.getPrefHeight() * 0.21);
        btn.setPrefWidth(keyBoardPane.getPrefWidth() * 0.25);
        btn.getStyleClass().add((Object)"btn_closekey");
        btn.getStyleClass().add((Object)"text_keybeard_closecaisse");
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                XGlobalController.this.select(number, labelText);
            }
        });
        return btn;
    }

    public void select(String number, Label focusedTextField) {
        this.writeNumber(number, focusedTextField);
    }

    public void writeNumber(String number, Label focusedTextField) {
        focusedTextField.setText(focusedTextField.getText() + number);
    }

    public void selectPoint() {
        if (this.focusedTextField.getText().length() >= 1) {
            this.focusedTextField.setText(this.focusedTextField.getText() + ".");
        }
    }

    public void selectBack() {
        String txt = this.focusedTextField.getText();
        if (txt != null && !txt.isEmpty()) {
            this.focusedTextField.setText(txt.substring(0, txt.length() - 1));
        }
    }

    public void getPertes(HashMap<ProductInfoExt, Integer> pertes_category, String raison) {
        double total = 0.0;
        Date date_creation = new Date();
        for (Map.Entry<ProductInfoExt, Integer> set : pertes_category.entrySet()) {
            if (set.getValue() <= 0) continue;
            try {
                total += (double)set.getValue().intValue() * set.getKey().getPriceSell();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        PertEntity mPertEntity = new PertEntity();
        mPertEntity.setCaissier(this.user);
        mPertEntity.setCreated_at(date_creation);
        mPertEntity.setRaison(raison);
        mPertEntity.setTotal(total);
        this.mPertEntityServices.addPerteEntity(mPertEntity);
        for (Map.Entry<ProductInfoExt, Integer> set : pertes_category.entrySet()) {
            if (set.getValue() <= 0) continue;
            try {
                total += (double)set.getValue().intValue() * set.getKey().getPriceSell();
                PertInfo perte = new PertInfo();
                perte.setName_product(set.getKey().getName());
                perte.setNb_items(set.getValue());
                int categoryid = set.getKey().getCategoryid();
                CategoryInfo category = this.dlItems.getCategoryInfo(String.valueOf(categoryid));
                perte.setName_category(category.getName());
                perte.setCreated_at(date_creation);
                perte.setTotal((double)set.getValue().intValue() * set.getKey().getPriceSell());
                perte.setPerteEntity(mPertEntity);
                this.mPertInfoServices.addPerte(perte);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void loadRaisonPane(final String displayType) {
        this.recap_pane.getChildren().clear();
        this.recap_pane.setAlignment(Pos.CENTER);
        GridPane gridLabel = new GridPane();
        gridLabel.setPrefHeight(this.recap_pane.getPrefHeight() * 0.25);
        gridLabel.setPrefWidth(this.recap_pane.getPrefWidth() * 0.8);
        gridLabel.setAlignment(Pos.CENTER);
        gridLabel.setVgap(10.0);
        this.recap_pane.setStyle("-fx-background-color: #F5F5F5;");
        gridLabel.setStyle("-fx-background-color: #F5F5F5;");
        Label labelTitle = new Label("");
        labelTitle.setStyle("-fx-font-size: 10pt;-fx-text-fill: green ;-fx-font-weight: bold;-fx-font-family: Segoe UI Bold 86");
        switch (displayType) {
            case "entrer": {
                labelTitle.setText(AppLocal.getIntString("Text.reason.amount.in"));
                break;
            }
            case "sortie": {
                labelTitle.setText(AppLocal.getIntString("Text.reason.amount.out"));
                break;
            }
            case "perte": {
                labelTitle.setText(AppLocal.getIntString("Text.reason.amount.loss"));
            }
        }
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPrefHeight(this.recap_pane.getPrefHeight() * 0.2);
        labelTitle.setPrefWidth(this.width);
        this.labelTextAria.setText("");
        this.labelTextAria.setStyle("-fx-font-size: 16pt;-fx-text-fill: black;-fx-background-color: #5A8DEE;");
        this.labelTextAria.setPrefHeight(this.width * 0.8);
        this.labelTextAria.setWrapText(true);
        labelTitle.setPrefHeight(this.recap_pane.getPrefHeight() * 0.15);
        gridLabel.add((Node)labelTitle, 0, 0);
        gridLabel.add((Node)this.labelTextAria, 0, 1);
        GridPane validPane = new GridPane();
        validPane.setPrefWidth(this.recap_pane.getPrefWidth() * 0.8);
        validPane.setPrefHeight(this.recap_pane.getPrefHeight() * 0.5);
        validPane.setAlignment(Pos.BOTTOM_CENTER);
        validPane.setHgap(15.0);
        Button btncancel = new Button(AppLocal.getIntString("Button.cancel"));
        btncancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                XGlobalController.this.exitFromRecap();
            }
        });
        btncancel.setPrefWidth(validPane.getPrefWidth() * 0.33);
        btncancel.setPrefHeight(validPane.getPrefHeight() * 0.15);
        btncancel.getStyleClass().add((Object)"bgred_FF5B5C");
        btncancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                XGlobalController.this.exitFromRecap();
            }
        });
        Button valid = new Button(AppLocal.getIntString("Button.valid"));
        valid.setPrefWidth(validPane.getPrefWidth() * 0.33);
        valid.setPrefHeight(validPane.getPrefHeight() * 0.15);
        valid.getStyleClass().add((Object)"bg_sea_green");
        valid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (XGlobalController.this.labelTextAria.getText() != null && !XGlobalController.this.labelTextAria.getText().equals("")) {
                    if (!displayType.equals("perte")) {
                        Date date_creation = new Date();
                        MoneyMouvement mv = new MoneyMouvement();
                        mv.setCaissier(XGlobalController.this.user);
                        mv.setCreated_at(date_creation);
                        mv.setRaison(XGlobalController.this.labelTextAria.getText());
                        mv.setTotal(Double.parseDouble(XGlobalController.this.focusedTextField.getText()));
                        mv.setType(displayType);
                        XGlobalController.this.mMoneyMouvementServices.addMoneyMouvement(mv);
                        XGlobalController.this.exitFromRecap();
                    } else {
                        XGlobalController.this.getPertes(XGlobalController.this.pertes_category, XGlobalController.this.labelTextAria.getText());
                        XGlobalController.this.pertes_category = new HashMap();
                        XGlobalController.this.exitFromRecap();
                    }
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Text.reason.valid"), 4000, NPosition.CENTER);
                }
            }
        });
        validPane.add((Node)btncancel, 0, 0);
        validPane.add((Node)valid, 1, 0);
        this.recap_pane.add((Node)gridLabel, 0, 0);
        this.recap_pane.add((Node)validPane, 0, 1);
    }

    public void loadPerteBox(List<PertEntity> pertesEntity, GridPane GridMarchandise) {
        GridMarchandise.getChildren().clear();
        GridMarchandise.setPrefWidth(this.width);
        GridMarchandise.setHgap(5.0);
        GridMarchandise.setVgap(15.0);
        GridMarchandise.setAlignment(Pos.CENTER);
        GridPane totalPerte = new GridPane();
        totalPerte.setPrefWidth(this.width);
        totalPerte.setPrefHeight(this.heightmin * 0.7);
        totalPerte.setHgap(5.0);
        totalPerte.setAlignment(Pos.CENTER);
        Label totLabelPerte = new Label(Formats.CURRENCY.formatValue(0));
        totLabelPerte.getStyleClass().add((Object)"text_red_red");
        totLabelPerte.getStyleClass().add((Object)"text-size16-Consolas_wight");
        totLabelPerte.setPrefWidth(this.width * 0.5);
        totLabelPerte.setPrefHeight(this.heightmin * 0.7);
        Label labelperte = new Label(AppLocal.getIntString("Text.amount.loss") + " : ");
        labelperte.getStyleClass().add((Object)"text_red_red");
        labelperte.getStyleClass().add((Object)"Segoe_UI_75_bold_16");
        labelperte.setPrefWidth(this.width * 0.5);
        labelperte.setPrefHeight(this.heightmin * 0.7);
        labelperte.setAlignment(Pos.CENTER_RIGHT);
        totLabelPerte.setAlignment(Pos.CENTER_LEFT);
        totalPerte.add((Node)labelperte, 0, 0);
        totalPerte.add((Node)totLabelPerte, 1, 0);
        if (pertesEntity != null && !pertesEntity.isEmpty()) {
            FlowPane flowPertes = new FlowPane();
            flowPertes.setPrefWidth(this.width);
            double total = 0.0;
            for (final PertEntity pertEntity : pertesEntity) {
                System.out.println("+++++++++++++++++++++ pertesEntity" + pertEntity.getId());
                int heightEntity = pertEntity.getPertInfoCollection().size();
                GridMarchandise.setPrefHeight(flowPertes.getPrefHeight() + this.heightmin * 0.7);
                GridPane perte = new GridPane();
                perte.getStyleClass().add((Object)"bg_gray_F5F5F5");
                perte.setPrefHeight(this.heightmin * 0.7 * 0.9 * (double)(heightEntity + 2));
                flowPertes.setPrefHeight(perte.getPrefHeight() * (double)pertesEntity.size());
                flowPertes.setVgap(15.0);
                perte.setPrefWidth(this.width);
                FlowPane mperteFlow = new FlowPane();
                mperteFlow.setPrefHeight(this.heightmin * 0.7 * 0.9 * (double)heightEntity);
                mperteFlow.setPrefWidth(this.width * 0.9);
                Label raisnPerte = new Label("Raison :  " + pertEntity.getRaison());
                raisnPerte.getStyleClass().add((Object)"text-size20bold");
                raisnPerte.setPrefWidth(this.width * 0.9);
                Label dateperte = new Label("Date de Perte :  " + pertEntity.getCreated_at());
                dateperte.getStyleClass().add((Object)"text-size20bold");
                dateperte.setPrefWidth(this.width * 0.9);
                for (PertInfo mpertInfo : this.mPertInfoServices.getPerteInfosByEntity(pertEntity.getId())) {
                    total += mpertInfo.getTotal();
                    GridPane mpertInfoPane = new GridPane();
                    mpertInfoPane.setHgap(5.0);
                    mpertInfoPane.setPrefHeight(this.heightmin * 0.7 * 0.9);
                    mpertInfoPane.setPrefWidth(mperteFlow.getPrefWidth());
                    Label nbpertInfo = new Label(String.valueOf(mpertInfo.getNb_items()) + " X");
                    nbpertInfo.setPrefHeight(this.heightmin * 0.7 * 0.9);
                    nbpertInfo.setPrefWidth(mperteFlow.getPrefWidth() * 0.05);
                    nbpertInfo.getStyleClass().add((Object)"text-size20bold");
                    Label name_product = new Label(mpertInfo.getName_product());
                    name_product.setWrapText(true);
                    name_product.setPrefHeight(this.heightmin * 0.7 * 0.9);
                    name_product.setPrefWidth(mperteFlow.getPrefWidth() * 0.35);
                    name_product.getStyleClass().add((Object)"text-size20bold");
                    Label name_Categorie = new Label(mpertInfo.getName_category());
                    name_product.setWrapText(true);
                    name_Categorie.setPrefWidth(mperteFlow.getPrefWidth() * 0.35);
                    name_Categorie.setWrapText(true);
                    name_Categorie.getStyleClass().add((Object)"text-size20bold");
                    name_Categorie.setPrefHeight(this.heightmin * 0.7 * 0.9);
                    Label totalpertInfo = new Label(Formats.CURRENCY.formatValue(mpertInfo.getTotal()));
                    totalpertInfo.setPrefHeight(this.heightmin * 0.7 * 0.9);
                    totalpertInfo.setPrefWidth(mperteFlow.getPrefWidth() * 0.2);
                    totalpertInfo.getStyleClass().add((Object)"font");
                    mpertInfoPane.add((Node)nbpertInfo, 0, 0);
                    mpertInfoPane.add((Node)name_product, 1, 0);
                    mpertInfoPane.add((Node)name_Categorie, 2, 0);
                    mpertInfoPane.add((Node)totalpertInfo, 3, 0);
                    mperteFlow.getChildren().add((Object)mpertInfoPane);
                }
                Button exiButton = new Button();
                exiButton.setPrefWidth(this.width * 0.1);
                exiButton.setPrefHeight(perte.getPrefHeight());
                Image exitImage = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/delete_icon.png"));
                ImageView imageviewExit = new ImageView(exitImage);
                imageviewExit.setFitHeight(20.0);
                imageviewExit.setFitWidth(exiButton.getPrefWidth() * 0.5);
                exiButton.setGraphic((Node)imageviewExit);
                exiButton.getStyleClass().add((Object)"bg_gray_F5F5F5");
                this.pertes_deleted.put(pertEntity, false);
                exiButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        XGlobalController.this.pertes_deleted.put(pertEntity, true);
                        for (Map.Entry<PertEntity, Boolean> set : XGlobalController.this.pertes_deleted.entrySet()) {
                            if (!set.getValue().booleanValue()) continue;
                            pertEntity.setDeleted(true);
                            XGlobalController.this.mPertEntityServices.updatePerteEntity(pertEntity);
                        }
                        XGlobalController.this.getInfos();
                        XGlobalController.this.pertes_deleted = new HashMap();
                    }
                });
                GridPane.setRowSpan((Node)exiButton, (Integer)3);
                perte.add((Node)mperteFlow, 0, 0);
                perte.add((Node)exiButton, 1, 0);
                perte.add((Node)dateperte, 0, 1);
                perte.add((Node)raisnPerte, 0, 2);
                flowPertes.getChildren().add((Object)perte);
            }
            totLabelPerte.setText(Formats.CURRENCY.formatValue(-total));
            GridMarchandise.add((Node)totalPerte, 0, 0);
            GridMarchandise.add((Node)flowPertes, 0, 1);
            this.addGridWithTitle(GridMarchandise, AppLocal.getIntString("Text.merchandise.loss"));
        }
    }

    public void loadMoneyRecap(List<MoneyMouvement> listMoney, String type) {
        GridPane GridMoney = new GridPane();
        GridMoney.getChildren().clear();
        GridMoney.setPrefWidth(this.width);
        GridMoney.setHgap(5.0);
        GridMoney.setVgap(15.0);
        GridMoney.setAlignment(Pos.CENTER);
        GridPane totalMoney = new GridPane();
        totalMoney.setPrefWidth(this.width);
        totalMoney.setPrefHeight(this.heightmin);
        totalMoney.setHgap(5.0);
        totalMoney.setAlignment(Pos.CENTER);
        Label totLabelMoney = new Label(Formats.CURRENCY.formatValue(0));
        if (type.equals("sortie")) {
            totLabelMoney.getStyleClass().add((Object)"text_red_red");
        } else {
            totLabelMoney.getStyleClass().add((Object)"text_green1");
        }
        totLabelMoney.getStyleClass().add((Object)"text-size16-Consolas_wight");
        totLabelMoney.setPrefWidth(this.width * 0.5);
        totLabelMoney.setPrefHeight(this.heightmin);
        Label labelmoney = new Label();
        if (type.equals("sortie")) {
            labelmoney.getStyleClass().add((Object)"text_red_red");
        } else {
            labelmoney.getStyleClass().add((Object)"text_green1");
        }
        if (type.equals("entrer")) {
            labelmoney.setText(AppLocal.getIntString("Text.total.in") + " : ");
        } else {
            labelmoney.setText(AppLocal.getIntString("Text.total.out") + " : ");
        }
        labelmoney.getStyleClass().add((Object)"Segoe_UI_75_bold_16");
        labelmoney.setPrefWidth(this.width * 0.5);
        labelmoney.setPrefHeight(this.heightmin);
        labelmoney.setAlignment(Pos.CENTER_RIGHT);
        totLabelMoney.setAlignment(Pos.CENTER_LEFT);
        totalMoney.add((Node)labelmoney, 0, 0);
        totalMoney.add((Node)totLabelMoney, 1, 0);
        if (listMoney != null && !listMoney.isEmpty()) {
            FlowPane flowMoney = new FlowPane();
            flowMoney.setPrefWidth(this.width);
            flowMoney.setVgap(10.0);
            flowMoney.setAlignment(Pos.CENTER);
            double total = 0.0;
            for (final MoneyMouvement money : listMoney) {
                total += money.getTotal();
                double heightmoney = this.heightmin;
                flowMoney.setPrefHeight(heightmoney * (double)listMoney.size());
                GridMoney.setPrefHeight(flowMoney.getPrefHeight());
                GridPane gridMoneyEntity = new GridPane();
                gridMoneyEntity.setPrefWidth(this.width);
                gridMoneyEntity.setPrefHeight(heightmoney);
                gridMoneyEntity.setHgap(5.0);
                gridMoneyEntity.setAlignment(Pos.CENTER);
                Label totalArgent = new Label(Formats.CURRENCY.formatValue(money.getTotal()));
                totalArgent.setPrefWidth(gridMoneyEntity.getPrefWidth() * 0.2);
                totalArgent.getStyleClass().add((Object)"font");
                Label raisonlabel = new Label(money.getRaison());
                raisonlabel.setWrapText(true);
                raisonlabel.setPrefWidth(gridMoneyEntity.getPrefWidth() * 0.3);
                raisonlabel.setPrefHeight(heightmoney);
                raisonlabel.setAlignment(Pos.CENTER);
                raisonlabel.getStyleClass().add((Object)"text-size20bold");
                Label dateMouvement = new Label("" + money.getCreated_at());
                dateMouvement.setPrefWidth(gridMoneyEntity.getPrefWidth() * 0.35);
                dateMouvement.setPrefHeight(heightmoney);
                dateMouvement.getStyleClass().add((Object)"text-size20bold");
                dateMouvement.setWrapText(true);
                dateMouvement.setAlignment(Pos.CENTER);
                Label caissierLabel = new Label(money.getCaissier());
                caissierLabel.setPrefWidth(gridMoneyEntity.getPrefWidth() * 0.15);
                caissierLabel.getStyleClass().add((Object)"text-size20bold");
                caissierLabel.setPrefHeight(heightmoney);
                caissierLabel.setAlignment(Pos.CENTER);
                caissierLabel.setWrapText(true);
                Button exiButton = new Button();
                exiButton.setPrefWidth(gridMoneyEntity.getPrefWidth() * 0.1);
                exiButton.setPrefHeight(gridMoneyEntity.getHeight());
                Image exitImage = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/delete_icon.png"));
                ImageView imageviewExit = new ImageView(exitImage);
                imageviewExit.setFitHeight(20.0);
                imageviewExit.setFitWidth(exiButton.getPrefWidth() * 0.5);
                exiButton.setGraphic((Node)imageviewExit);
                exiButton.getStyleClass().add((Object)"bg_gray_F5F5F5");
                this.money_deleted.put(money, false);
                exiButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        XGlobalController.this.money_deleted.put(money, true);
                        for (Map.Entry<MoneyMouvement, Boolean> set : XGlobalController.this.money_deleted.entrySet()) {
                            if (!set.getValue().booleanValue()) continue;
                            money.setDeleted(true);
                            XGlobalController.this.mMoneyMouvementServices.updateMoneyMouvement(money);
                        }
                        XGlobalController.this.getInfos();
                        XGlobalController.this.money_deleted = new HashMap();
                    }
                });
                gridMoneyEntity.add((Node)totalArgent, 0, 0);
                gridMoneyEntity.add((Node)raisonlabel, 1, 0);
                gridMoneyEntity.add((Node)dateMouvement, 2, 0);
                gridMoneyEntity.add((Node)caissierLabel, 3, 0);
                gridMoneyEntity.add((Node)exiButton, 4, 0);
                flowMoney.getChildren().add((Object)gridMoneyEntity);
            }
            if (type.equals("entrer")) {
                totLabelMoney.setText(Formats.CURRENCY.formatValue(total));
            } else if (type.equals("sortie")) {
                totLabelMoney.setText(Formats.CURRENCY.formatValue(-total));
            }
            GridMoney.add((Node)totalMoney, 0, 0);
            GridMoney.add((Node)flowMoney, 0, 1);
            if (type.equals("entrer")) {
                this.addGrid(GridMoney, "");
            } else if (type.equals("sortie")) {
                this.addGrid(GridMoney, "");
            }
        }
    }

    private void setTexts() {
        this.label_loading.setText(AppLocal.getIntString("Text.loading"));
        this.perte_marchandise.setText(AppLocal.getIntString("Text.merchandise.loss"));
        this.money_in.setText(AppLocal.getIntString("Text.input.money"));
        this.money_out.setText(AppLocal.getIntString("Text.output.money"));
        this.print.setText(AppLocal.getIntString("Button.print"));
        this.closecaisseText.setText(AppLocal.getIntString("Text.close.caisse"));
    }
}

