/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.HBoxCell;
import com.openbravo.components.OrderCell;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.events.CustomBasketListCell;
import com.openbravo.events.CustomOrderListCell;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.TicketService;
import com.openbravo.service.UberService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.json.JSONObject;

public class UberOrderController
implements RootController {
    @FXML
    Label delais;
    @FXML
    Label num_order;
    @FXML
    Label name_customer;
    @FXML
    ListView listView_orders;
    @FXML
    ListView listView_items;
    @FXML
    GridPane pane_parent;
    @FXML
    GridPane pane_main;
    @FXML
    GridPane pane_message_load;
    @FXML
    GridPane pane_orders;
    @FXML
    GridPane pane_detail_order;
    @FXML
    GridPane pane_total;
    @FXML
    Label total_order;
    @FXML
    Label label_message;
    @FXML
    Label label_estimated_time;
    @FXML
    Button btn_accept;
    @FXML
    Button btn_refuse;
    @FXML
    Label label_order_tracking;
    private UberService mUberService;
    private Stage mStage;
    private String id_order;
    private LinkedHashMap<String, TicketInfo> orders;
    private List<OrderCell> m_listOrders;
    private ObservableList observableListOrder;
    private List<HBoxCell> m_listItems;
    private ObservableList observableListItems;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private TicketInfo currentOrder;
    private TicketService mTicketService;
    private double height_detail_order;
    private ImageView imageNew;
    private boolean accept_in_progress;

    public void initializer() {
        try {
            this.pane_parent.requestFocus();
            this.mUberService = UberService.getInstance();
            this.listView_items.setCellFactory(listView -> new CustomBasketListCell());
            this.listView_orders.setCellFactory(listView -> new CustomOrderListCell());
            this.observableListOrder = FXCollections.observableArrayList();
            this.m_listOrders = new ArrayList<OrderCell>();
            this.observableListItems = FXCollections.observableArrayList();
            this.m_listItems = new ArrayList<HBoxCell>();
            this.pane_main.getChildren().clear();
            this.label_message.setText(AppLocal.getIntString("Text.loading"));
            this.pane_main.add((Node)this.pane_message_load, 0, 0);
            this.height_detail_order = AppVarUtils.getScreenDimension().getHeight() * 0.8 * 0.84;
            this.pane_detail_order.getChildren().clear();
            this.pane_detail_order.add((Node)this.listView_items, 0, 0);
            this.imageNew = new ImageView(new Image(this.getClass().getResource("/com/openbravo/images/new.png").toURI().toString(), 25.0, 25.0, false, false));
            this.setTexts();
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void getOrders(JSONObject order) {
        this.orders = this.mUberService.getOrdersDetail();
        for (String key : this.orders.keySet()) {
            System.out.println("order_id key: " + key);
        }
        if (order != null) {
            String order_id = order.getString("id");
            System.out.println("order_id : " + order_id);
            if (!this.orders.containsKey(order_id)) {
                TicketInfo ticket = TicketInfoBuilder.create(null).objectOrder(order).buildOrder().toTicketInfo();
                this.orders.put(order_id, ticket);
            }
        }
        this.loadOrders();
    }

    private void loadOrders() {
        if (this.orders.isEmpty()) {
            this.pane_main.getChildren().clear();
            this.label_message.setText(AppLocal.getIntString("Text.no.orders"));
            this.pane_main.add((Node)this.pane_message_load, 0, 0);
            this.mUberService.sentInfoOrders(this.orders.size(), null);
        } else {
            String first_order = "";
            boolean index_first_order = false;
            if (this.listView_orders.getItems().isEmpty()) {
                this.listView_orders.getItems().clear();
            }
            if (!this.m_listOrders.isEmpty()) {
                this.m_listOrders.clear();
            }
            if (!this.observableListOrder.isEmpty()) {
                this.observableListOrder.clear();
            }
            for (String order_id : this.orders.keySet()) {
                if (first_order != null && first_order.isEmpty()) {
                    first_order = order_id;
                }
                TicketInfo order = this.orders.get(order_id);
                final OrderCell order_line = new OrderCell().orderId(order_id).order(order).build();
                order_line.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        UberOrderController.this.id_order = order_line.getOrderId();
                        UberOrderController.this.loadInfoOrder(order_line.getOrder());
                    }
                });
                this.m_listOrders.add(order_line);
            }
            this.observableListOrder.setAll(this.m_listOrders);
            this.listView_orders.setItems(this.observableListOrder);
            if (first_order != null && !first_order.isEmpty()) {
                this.id_order = first_order;
                this.loadInfoOrder(this.orders.get(this.id_order));
                this.listView_orders.getSelectionModel().selectFirst();
            } else {
                this.initOrder();
            }
            this.pane_main.getChildren().clear();
            this.pane_main.add((Node)this.pane_orders, 0, 0);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.mStage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.mStage = mStage;
        this.id_order = (String)object;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.mStage = mStage;
        this.initializer();
    }

    public void exit() {
        this.mStage.close();
    }

    private void loadInfoOrder(TicketInfo order) {
        this.currentOrder = order;
        Date date_order = order.getDate();
        Date date_ready = order.getDelivered();
        if (date_ready != null) {
            long diff = date_ready.getTime() - date_order.getTime();
            String delais_order = String.valueOf(diff / 60000L) + "min";
            this.delais.setText(delais_order);
        } else {
            this.delais.setText("");
        }
        this.num_order.setText("N\u00b0" + order.getNumero_platform_order());
        this.name_customer.setText(order.getName_customer());
        this.loadItems(order);
    }

    private void loadItems(TicketInfo order) {
        double total = order.getTotal() + order.getTotal_fee_ubereat() + order.getTax_ubereat();
        double height_lines = 0.0;
        double widthline = AppVarUtils.getScreenDimension().getWidth() * 0.8 * 0.29;
        if (this.listView_items.getItems().isEmpty()) {
            this.listView_items.getItems().clear();
        }
        if (!this.m_listItems.isEmpty()) {
            this.m_listItems.clear();
        }
        if (!this.observableListItems.isEmpty()) {
            this.observableListItems.clear();
        }
        for (TicketLineInfo item : order.getLines()) {
            HBoxCell item_line = new HBoxCell().item(item).widthline(widthline).buildLine();
            height_lines += item_line.getHeight();
            this.m_listItems.add(item_line);
        }
        if (order.getComment() != null && !order.getComment().isEmpty()) {
            HBoxCell comment_line = new HBoxCell().widthline(widthline).buildNote(order.getComment());
            height_lines += comment_line.getHeight();
            this.m_listItems.add(comment_line);
        }
        if (order.getDiscount() > 0.0) {
            String text_discount = "";
            if (order.getLabel_discount() != null && !order.getLabel_discount().isEmpty()) {
                StringBuilder label_discount = new StringBuilder();
                label_discount.append(order.getLabel_discount());
                label_discount.append(" ");
                label_discount.append("-");
                label_discount.append((int)order.getDiscount());
                label_discount.append(" ");
                label_discount.append("pourcentage".equals(order.getTypeDiscount()) ? "%" : Formats.getCurrency());
                text_discount = label_discount.toString();
            }
            HBoxCell componentOrderDiscount = new HBoxCell().widthline(widthline).total(order.getDiscount()).buildLineDiscount(text_discount);
            this.m_listItems.add(componentOrderDiscount);
        }
        if (order.getTax_ubereat() != 0.0) {
            HBoxCell item_tax_uber = new HBoxCell().widthline(widthline).total(order.getTax_ubereat()).buildLineTotal("TVA Uber Eat");
            height_lines += item_tax_uber.getHeight();
            this.m_listItems.add(item_tax_uber);
        }
        HBoxCell item_total_fee_uber = new HBoxCell().widthline(widthline).total(order.getTotal_fee_ubereat()).buildLineTotal("Service Uber Eat");
        height_lines += item_total_fee_uber.getHeight();
        this.m_listItems.add(item_total_fee_uber);
        if (height_lines + 50.0 >= this.height_detail_order) {
            this.listView_items.setPrefHeight(this.height_detail_order * 0.85);
            this.pane_detail_order.getChildren().clear();
            this.pane_detail_order.add((Node)this.listView_items, 0, 0);
            this.pane_detail_order.add((Node)this.pane_total, 0, 1);
            this.total_order.setText(Formats.CURRENCY.formatValue(total));
        } else {
            this.listView_items.setPrefHeight(this.height_detail_order);
            HBoxCell item_total_order = new HBoxCell().widthline(widthline).total(total).buildLineTotal("Total");
            this.m_listItems.add(item_total_order);
            this.pane_detail_order.getChildren().clear();
            this.pane_detail_order.add((Node)this.listView_items, 0, 0);
        }
        this.observableListItems.setAll(this.m_listItems);
        this.listView_items.setItems(this.observableListItems);
    }

    public void addNewOrder(JSONObject order) {
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.pane_orders, 0, 0);
        TicketInfo ticket = TicketInfoBuilder.create(null).objectOrder(order).buildOrder().toTicketInfo();
        String order_id = order.getString("id");
        this.orders.put(order_id, ticket);
        final OrderCell order_line = new OrderCell().orderId(order_id).order(ticket).imageNew(this.imageNew).build();
        order_line.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (order_line.getLabelNew() != null) {
                    order_line.getLabelNew().setGraphic(null);
                }
                UberOrderController.this.id_order = order_line.getOrderId();
                UberOrderController.this.loadInfoOrder(order_line.getOrder());
            }
        });
        this.m_listOrders.add(0, order_line);
        this.observableListOrder.add(0, (Object)order_line);
        if (this.orders.size() == 1) {
            this.id_order = order_id;
            this.loadInfoOrder(this.orders.get(this.id_order));
            this.listView_orders.getSelectionModel().selectFirst();
            this.listView_orders.setItems(this.observableListOrder);
        }
    }

    public void acceptOrder() {
        if (this.mTicketService == null) {
            this.mTicketService = TicketService.getInstance();
        }
        if (this.id_order != null && !this.accept_in_progress) {
            try {
                this.accept_in_progress = true;
                TicketInfo ticket = (TicketInfo)this.currentOrder.clone();
                System.out.println("++++++ ticket.getId_online_order() : " + ticket.getId_online_order());
                String oldTicket = this.mTicketService.getTicketByIdPlatform(ticket.getId_online_order());
                System.out.println("+++++++ oldTicket : " + oldTicket);
                if (oldTicket != null) {
                    new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, AppLocal.getIntString("Message.order.already.accepted"), 4000, NPosition.BOTTOM_RIGHT);
                    if (this.currentOrder.getPlatform_current_state() == null || this.currentOrder.getPlatform_current_state().equals("CREATED")) {
                        boolean bl = this.mUberService.acceptOrder(this.id_order, 0);
                    }
                    this.orders = this.mUberService.getOrdersDetail();
                    this.loadOrders();
                    this.mUberService.sentInfoOrders(this.orders.size(), null);
                    this.accept_in_progress = false;
                    if (this.orders.isEmpty()) {
                        this.mStage.close();
                    }
                } else {
                    boolean accept_order;
                    TicketInfo ticket_to_print = (TicketInfo)this.currentOrder.clone();
                    System.out.println("currentOrder.getPlatform_current_state() : " + this.currentOrder.getPlatform_current_state());
                    boolean bl = accept_order = this.currentOrder.getPlatform_current_state() != null && this.currentOrder.getPlatform_current_state().equalsIgnoreCase("ACCEPTED");
                    if (!accept_order) {
                        accept_order = this.mUberService.acceptOrder(this.id_order, 0);
                    }
                    System.out.println("+++++++++ accept_order : " + accept_order);
                    if (accept_order) {
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, AppLocal.getIntString("Message.accepted.order"), 4000, NPosition.BOTTOM_RIGHT);
                        System.out.println("+++++++++++++++ ticket delivered : " + ticket.getDelivered());
                        this.encaisserOrder(ticket);
                        this.orders = this.mUberService.getOrdersDetail();
                        this.loadOrders();
                        this.mUberService.sentInfoOrders(this.orders.size(), null);
                        this.accept_in_progress = false;
                        if (this.orders.isEmpty()) {
                            this.mStage.close();
                        }
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "erreur acceptation", 4000, NPosition.BOTTOM_RIGHT);
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error"), 4000, NPosition.BOTTOM_RIGHT);
            }
            this.accept_in_progress = false;
        }
    }

    public void denyOrder() {
        if (this.id_order != null) {
            try {
                this.mUberService.denyOrder(this.id_order, 0);
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, AppLocal.getIntString("Message.rejected.order"), 4000, NPosition.BOTTOM_RIGHT);
                this.orders = this.mUberService.getOrdersDetail();
                this.loadOrders();
                this.mUberService.sentInfoOrders(this.orders.size(), null);
                if (this.orders.isEmpty()) {
                    this.mStage.close();
                }
            }
            catch (IOException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error"), 4000, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    private void initOrder() {
        if (this.listView_items.getItems().isEmpty()) {
            this.listView_items.getItems().clear();
        }
        if (!this.m_listItems.isEmpty()) {
            this.m_listItems.clear();
        }
        if (!this.observableListItems.isEmpty()) {
            this.observableListItems.clear();
        }
        this.delais.setText("");
        this.num_order.setText("");
        this.name_customer.setText("");
    }

    private void encaisserOrder(TicketInfo ticket) {
        if (this.mTicketService == null) {
            this.mTicketService = TicketService.getInstance();
        }
        this.mTicketService.orderAttente(false, ticket, false, true, true, false, true, AppLocal.PRINT_TICKET_UBER_EATS);
    }

    public boolean isOnline() {
        return this.mUberService.isOnline();
    }

    public void changeStatusStore() {
        try {
            this.mUberService.changeStatusStore();
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error"), 4000, NPosition.BOTTOM_RIGHT);
        }
    }

    private void setTexts() {
        this.label_order_tracking.setText(AppLocal.getIntString("Text.order.tracking"));
        this.label_estimated_time.setText(AppLocal.getIntString("Text.estimated.time"));
        this.label_message.setText(AppLocal.getIntString("Text.loading"));
        this.btn_accept.setText(AppLocal.getIntString("Button.accept"));
        this.btn_refuse.setText(AppLocal.getIntString("Button.refuse"));
    }
}

