/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.SwitchButton;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.util.List;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;

public class TvaController {
    @FXML
    GridPane pane_tvas;
    private List<TaxInfo> taxesInfo;
    private DataLogicSales dlSales;
    private double height;
    private double width;
    private EventHandler mEventHandlerClickSwitchButton = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            Button button = (Button)event.getSource();
            SwitchButton mSwitchButton = (SwitchButton)((Object)button.getProperties().get((Object)"TAXID"));
            TvaController.this.setEnableTAX(mSwitchButton);
        }
    };
    private EventHandler mEventHandlerClickSwitch = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            SwitchButton mSwitchButton = (SwitchButton)((Object)event.getSource());
            TvaController.this.setEnableTAX(mSwitchButton);
        }
    };

    public void init(AppView m_App) {
        try {
            this.height = AppVarUtils.getScreenDimension().getHeight() * 0.9;
            this.width = AppVarUtils.getScreenDimension().getWidth() * 0.6;
            this.dlSales = (DataLogicSales)m_App.getBean("com.openbravo.dao.DataLogicSales");
            this.taxesInfo = this.dlSales.getAllTax();
            System.out.println("taxesInfo : " + this.taxesInfo);
            this.loadTva();
            AppLocal.UPDATE_STATUS_TVA = true;
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadTva() {
        int row = 0;
        for (TaxInfo taxInfo : this.taxesInfo) {
            GridPane paneTVA = new GridPane();
            paneTVA.setPrefHeight(this.height * 0.07);
            paneTVA.setPrefWidth(this.width);
            Label nameTVA = new Label();
            nameTVA.setText(taxInfo.getName());
            nameTVA.setPrefWidth(paneTVA.getPrefWidth() * 0.4);
            nameTVA.setPrefHeight(paneTVA.getPrefHeight());
            paneTVA.add((Node)nameTVA, 0, 0);
            double width_switch = 70.0;
            SwitchButton mSwitchButton = new SwitchButton(width_switch, width_switch * 0.5);
            mSwitchButton.setOnMouseClicked(this.mEventHandlerClickSwitch);
            mSwitchButton.getProperties().put((Object)"TAXID", (Object)taxInfo.getId());
            mSwitchButton.getButton().setOnMouseClicked(this.mEventHandlerClickSwitchButton);
            mSwitchButton.getButton().getProperties().put((Object)"mSwitchButton", (Object)mSwitchButton);
            if (taxInfo.isEnabled()) {
                mSwitchButton.setOn();
            } else {
                mSwitchButton.setOff();
            }
            paneTVA.add((Node)mSwitchButton, 1, 0);
            this.pane_tvas.add((Node)paneTVA, 0, row++);
        }
    }

    private void setEnableTAX(SwitchButton mSwitchButton) {
        if (mSwitchButton != null) {
            String taxID = (String)mSwitchButton.getProperties().get((Object)"TAXID");
            if (mSwitchButton.isState()) {
                mSwitchButton.setOff();
            } else {
                mSwitchButton.setOn();
            }
            try {
                this.dlSales.setEnableTAX(taxID, mSwitchButton.isState());
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

