/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.data.loader.LocalRes;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import fr.protactile.procaisse.dao.entities.BorneInfo;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.services.BorneService;
import fr.protactile.procaisse.services.TagsService;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import org.apache.commons.io.FileUtils;

public class TagsController {
    @FXML
    GridPane pane_main;
    @FXML
    GridPane pane_preview_tag;
    @FXML
    GridPane list_tags;
    @FXML
    GridPane pane_next_tag;
    @FXML
    Button btn_tag_previous;
    @FXML
    Button btn_tag_next;
    @FXML
    Button button_items;
    @FXML
    Button button_images;
    @FXML
    Button button_global;
    @FXML
    Button button_params;
    private int page_tag;
    private GridPane[] pane_tags;
    private int number_page_tag;
    private int number_line;
    private int number_column;
    private AppView app;
    private DataLogicSystem dlSystem;
    private List<TagInfo> tags;
    private List<GridPane> listPaneTags;
    int row = -1;
    private static double widthPane = 700.0;
    private double width_pane;
    private TagsService mTagsService;
    private Image imageDelete;
    private Image imageUpdate;
    private Image imageCamera;
    private static File m_fCurrentDirectory = null;
    private int MAX_SIZE_FILE = 0x200000;
    private FilerUtils m_FilerUtils = null;
    private ItemService mItemService;
    private BorneService mBorneService;
    private ImagesUtils imageUtils = new ImagesUtils();
    private EventHandler mEventHandlerDeleteScreen = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"tag") != null) {
                TagInfo mTagInfo = (TagInfo)mButtonSource.getProperties().get((Object)"tag");
                TagsController.this.deleteTag(mTagInfo);
            }
        }
    };
    private EventHandler mEventHandlerUpdateScreen = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"tag") != null && mButtonSource.getProperties().get((Object)"name") != null && mButtonSource.getProperties().get((Object)"number") != null) {
                TagInfo mTagInfo = (TagInfo)mButtonSource.getProperties().get((Object)"tag");
                TextField number = (TextField)mButtonSource.getProperties().get((Object)"number");
                TextField name = (TextField)mButtonSource.getProperties().get((Object)"name");
                CheckBox enabledCheckBox = (CheckBox)mButtonSource.getProperties().get((Object)"enabledCheckBox");
                CheckBox closedCheckBox = (CheckBox)mButtonSource.getProperties().get((Object)"closedCheckBox");
                mTagInfo.setName(name.getText());
                mTagInfo.setNumber(Integer.parseInt(number.getText().isEmpty() ? "0" : number.getText()));
                mTagInfo.setEnabled(enabledCheckBox.isSelected());
                mTagInfo.setClosed(!closedCheckBox.isSelected());
                TagsController.this.updateTag(mTagInfo);
                TagsController.this.broadcastTagStatusChange(mTagInfo);
            }
        }
    };
    private EventHandler mEventHandlerEditLogo = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"tag") != null && mButtonSource.getProperties().get((Object)"labelImage") != null) {
                TagInfo mTagInfo = (TagInfo)mButtonSource.getProperties().get((Object)"tag");
                Label labelImage = (Label)mButtonSource.getProperties().get((Object)"labelImage");
                int idTemp = mButtonSource.getProperties().get((Object)"idTemp") != null ? (Integer)mButtonSource.getProperties().get((Object)"idTemp") : 0;
                TagsController.this.addImage(mTagInfo, labelImage, "logo", idTemp);
                System.out.println("++++++ mTagInfo  getLogo_tag : " + mTagInfo.getLogo_tag());
            }
        }
    };
    private EventHandler mEventHandlerEditBackground = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"tag") != null && mButtonSource.getProperties().get((Object)"labelImage") != null) {
                TagInfo mTagInfo = (TagInfo)mButtonSource.getProperties().get((Object)"tag");
                Label labelImage = (Label)mButtonSource.getProperties().get((Object)"labelImage");
                int idTemp = mButtonSource.getProperties().get((Object)"idTemp") != null ? (Integer)mButtonSource.getProperties().get((Object)"idTemp") : 0;
                TagsController.this.addImage(mTagInfo, labelImage, "background", idTemp);
                System.out.println("++++++ mTagInfo  getBackground_catalog : " + mTagInfo.getBackground_catalog());
            }
        }
    };

    public void init() throws BasicException, URISyntaxException {
        this.mTagsService = TagsService.getInstance();
        this.tags = new ArrayList<TagInfo>();
        this.listPaneTags = new ArrayList<GridPane>();
        this.number_line = 2;
        this.number_column = 2;
        Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/btn_next.png").toURI().toString(), 40.0, 30.0, false, false);
        Image imagebPrevious = new Image(this.getClass().getResource("/com/openbravo/images/btn_previous.png").toURI().toString(), 40.0, 30.0, false, false);
        this.imageDelete = new Image(this.getClass().getResource("/com/openbravo/images/sale_delete.png").toURI().toString(), 30.0, 30.0, false, false);
        this.imageUpdate = new Image(this.getClass().getResource("/com/openbravo/images/filesave.png").toURI().toString(), 30.0, 30.0, false, false);
        this.imageCamera = new Image(this.getClass().getResource("/com/openbravo/images/camera.png").toURI().toString(), 30.0, 30.0, false, false);
        this.btn_tag_previous.setGraphic((Node)new ImageView(imagebPrevious));
        this.btn_tag_next.setGraphic((Node)new ImageView(imageNext));
        this.width_pane = AppVarUtils.getScreenDimension().getWidth() * 0.33;
        this.m_FilerUtils = FilerUtils.getInstance();
        this.mItemService = ItemService.getInstance();
        this.mBorneService = BorneService.getInstance();
    }

    private double heightPane() {
        return (AppVarUtils.getScreenDimension().getHeight() - 55.0) * 0.8 * 0.9 * 0.5;
    }

    private void loadTags() {
        this.listPaneTags.clear();
        this.tags = this.mTagsService.getAllTags();
        if (this.tags != null) {
            for (TagInfo tag : this.tags) {
                GridPane paneTag = new GridPane();
                paneTag.setAlignment(Pos.CENTER);
                paneTag.setVgap(5.0);
                paneTag.setHgap(5.0);
                paneTag.getStyleClass().add((Object)"bg_gray_dfe8e8");
                paneTag.setPrefWidth(this.width_pane);
                paneTag.setPrefHeight(this.heightPane());
                TextField textName = new TextField();
                textName.setAlignment(Pos.CENTER);
                textName.setText(tag.getName());
                TextField textNumber = new TextField();
                textNumber.getProperties().put((Object)"vkType", (Object)1);
                textNumber.setAlignment(Pos.CENTER);
                textNumber.setText(String.valueOf(tag.getNumber()));
                GridPane paneButtons = new GridPane();
                paneButtons.setAlignment(Pos.CENTER_RIGHT);
                paneTag.add((Node)paneButtons, 0, 0);
                paneTag.add((Node)textNumber, 0, 1);
                paneTag.add((Node)textName, 0, 2);
                GridPane paneImages = new GridPane();
                paneImages.setPrefHeight(paneTag.getPrefHeight() * 0.45);
                paneImages.setPrefWidth(paneTag.getPrefWidth() * 0.8);
                GridPane paneLogo = new GridPane();
                paneLogo.setPrefHeight(paneImages.getPrefHeight());
                paneLogo.setPrefWidth(paneImages.getPrefWidth() * 0.5);
                Label labelLogo = new Label("Logo");
                labelLogo.setAlignment(Pos.CENTER);
                labelLogo.setPrefHeight(paneLogo.getPrefHeight());
                labelLogo.setPrefWidth(paneLogo.getPrefWidth() * 0.7);
                GridPane paneEditLogo = new GridPane();
                paneEditLogo.setAlignment(Pos.TOP_CENTER);
                paneEditLogo.setPrefHeight(paneLogo.getPrefHeight());
                paneEditLogo.setPrefWidth(paneLogo.getPrefWidth() * 0.3);
                Button buttonEditLogo = new Button();
                buttonEditLogo.getStyleClass().add((Object)"bg_transparent");
                buttonEditLogo.setGraphic((Node)new ImageView(this.imageCamera));
                buttonEditLogo.setPrefHeight(paneEditLogo.getPrefHeight() * 0.4);
                buttonEditLogo.setPrefWidth(paneEditLogo.getPrefWidth());
                paneEditLogo.add((Node)buttonEditLogo, 0, 0);
                paneLogo.add((Node)labelLogo, 0, 0);
                paneLogo.add((Node)paneEditLogo, 1, 0);
                GridPane paneBackground = new GridPane();
                paneBackground.setPrefHeight(paneImages.getPrefHeight());
                paneBackground.setPrefWidth(paneImages.getPrefWidth() * 0.5);
                Label labelBackground = new Label("Catalog");
                labelBackground.setAlignment(Pos.CENTER);
                labelBackground.setPrefHeight(paneBackground.getPrefHeight());
                labelBackground.setPrefWidth(paneBackground.getPrefWidth() * 0.7);
                GridPane paneEditBackground = new GridPane();
                paneEditBackground.setAlignment(Pos.TOP_CENTER);
                paneEditBackground.setPrefHeight(paneBackground.getPrefHeight());
                paneEditBackground.setPrefWidth(paneBackground.getPrefWidth() * 0.3);
                Button buttonEditBackground = new Button();
                buttonEditBackground.getStyleClass().add((Object)"bg_transparent");
                buttonEditBackground.setGraphic((Node)new ImageView(this.imageCamera));
                buttonEditBackground.setPrefHeight(paneEditBackground.getPrefHeight() * 0.4);
                buttonEditBackground.setPrefWidth(paneEditBackground.getPrefWidth());
                paneEditBackground.add((Node)buttonEditBackground, 0, 0);
                paneBackground.add((Node)labelBackground, 0, 0);
                paneBackground.add((Node)paneEditBackground, 1, 0);
                paneImages.add((Node)paneLogo, 0, 0);
                paneImages.add((Node)paneBackground, 1, 0);
                paneTag.add((Node)paneImages, 0, 3);
                Button buttonUpdate = new Button();
                Button buttonDelete = new Button();
                CheckBox enabledCheckBox = new CheckBox();
                enabledCheckBox.setText(tag.isEnabled() ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
                enabledCheckBox.setSelected(tag.isEnabled());
                CheckBox closedCheckBox = new CheckBox();
                closedCheckBox.setText(tag.isClosed() ? "Ferm\u00e9" : "Ouvert");
                closedCheckBox.setSelected(!tag.isClosed());
                paneButtons.setHgap(15.0);
                paneButtons.setVgap(5.0);
                paneButtons.add((Node)closedCheckBox, 0, 0);
                paneButtons.add((Node)enabledCheckBox, 1, 0);
                paneButtons.add((Node)buttonUpdate, 2, 0);
                paneButtons.add((Node)buttonDelete, 3, 0);
                enabledCheckBox.getStyleClass().add((Object)"bg_transparent");
                closedCheckBox.getStyleClass().add((Object)"bg_transparent");
                buttonUpdate.getStyleClass().add((Object)"bg_transparent");
                buttonDelete.getStyleClass().add((Object)"bg_transparent");
                buttonDelete.setGraphic((Node)new ImageView(this.imageDelete));
                buttonUpdate.setGraphic((Node)new ImageView(this.imageUpdate));
                paneButtons.setPrefWidth(paneTag.getPrefWidth() * 0.8);
                paneButtons.setPrefHeight(paneTag.getPrefHeight() * 0.15);
                textName.setPrefWidth(paneTag.getPrefWidth() * 0.8);
                textName.setPrefHeight(paneTag.getPrefHeight() * 0.2);
                textNumber.setPrefWidth(paneTag.getPrefWidth() * 0.8);
                textNumber.setPrefHeight(paneTag.getPrefHeight() * 0.2);
                if (tag.getLogo_tag() != null && !tag.getLogo_tag().isEmpty()) {
                    this.showImage(labelLogo, tag.getLogo_tag());
                }
                if (tag.getBackground_catalog() != null && !tag.getBackground_catalog().isEmpty()) {
                    this.showImage(labelBackground, tag.getBackground_catalog());
                }
                buttonUpdate.getProperties().put((Object)"tag", (Object)tag);
                buttonUpdate.getProperties().put((Object)"name", (Object)textName);
                buttonUpdate.getProperties().put((Object)"number", (Object)textNumber);
                buttonUpdate.getProperties().put((Object)"enabledCheckBox", (Object)enabledCheckBox);
                buttonUpdate.getProperties().put((Object)"closedCheckBox", (Object)closedCheckBox);
                buttonDelete.getProperties().put((Object)"tag", (Object)tag);
                buttonEditBackground.getProperties().put((Object)"tag", (Object)tag);
                buttonEditBackground.getProperties().put((Object)"labelImage", (Object)labelBackground);
                buttonEditLogo.getProperties().put((Object)"tag", (Object)tag);
                buttonEditLogo.getProperties().put((Object)"labelImage", (Object)labelLogo);
                buttonUpdate.setOnAction(this.mEventHandlerUpdateScreen);
                buttonDelete.setOnAction(this.mEventHandlerDeleteScreen);
                buttonEditLogo.setOnAction(this.mEventHandlerEditLogo);
                buttonEditBackground.setOnAction(this.mEventHandlerEditBackground);
                enabledCheckBox.setOnAction(e -> enabledCheckBox.setText(enabledCheckBox.isSelected() ? "Activ\u00e9" : "D\u00e9sactiv\u00e9"));
                closedCheckBox.setOnAction(e -> closedCheckBox.setText(closedCheckBox.isSelected() ? "Ouvert" : "Ferm\u00e9"));
                this.listPaneTags.add(paneTag);
            }
        }
        final GridPane paneTag = new GridPane();
        final TagInfo mTagInfo = new TagInfo();
        int idTemp = this.getID(this.tags);
        paneTag.setAlignment(Pos.CENTER);
        paneTag.setVgap(5.0);
        paneTag.setHgap(5.0);
        paneTag.getStyleClass().add((Object)"bg-e6eded");
        paneTag.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.33);
        paneTag.setPrefHeight(this.heightPane());
        final TextField nameTag = new TextField();
        Button btnAdd = new Button("Ajouter");
        final Button btnValid = new Button("Valider");
        nameTag.setAlignment(Pos.CENTER);
        nameTag.setPromptText("nom tag");
        nameTag.setPrefWidth(paneTag.getPrefWidth() * 0.8);
        nameTag.setPrefHeight(paneTag.getPrefHeight() * 0.2);
        final TextField numberTag = new TextField();
        numberTag.getProperties().put((Object)"vkType", (Object)1);
        numberTag.setAlignment(Pos.CENTER);
        numberTag.setPromptText("numero tag");
        numberTag.setPrefWidth(paneTag.getPrefWidth() * 0.8);
        numberTag.setPrefHeight(paneTag.getPrefHeight() * 0.2);
        btnValid.setPrefWidth(paneTag.getPrefWidth() * 0.8);
        btnValid.setPrefHeight(paneTag.getPrefHeight() * 0.15);
        btnAdd.setPrefWidth(paneTag.getPrefWidth() * 0.8);
        btnAdd.setPrefHeight(paneTag.getPrefHeight() * 0.3);
        btnAdd.getStyleClass().add((Object)"bg-70c0c1");
        btnValid.getStyleClass().add((Object)"bg-70c0c1");
        final GridPane paneImages = new GridPane();
        paneImages.setPrefHeight(paneTag.getPrefHeight() * 0.45);
        paneImages.setPrefWidth(paneTag.getPrefWidth() * 0.8);
        GridPane paneLogo = new GridPane();
        paneLogo.setPrefHeight(paneImages.getPrefHeight());
        paneLogo.setPrefWidth(paneImages.getPrefWidth() * 0.5);
        Label labelLogo = new Label("Logo");
        labelLogo.setAlignment(Pos.CENTER);
        labelLogo.setPrefHeight(paneLogo.getPrefHeight());
        labelLogo.setPrefWidth(paneLogo.getPrefWidth() * 0.7);
        GridPane paneEditLogo = new GridPane();
        paneEditLogo.setAlignment(Pos.TOP_CENTER);
        paneEditLogo.setPrefHeight(paneLogo.getPrefHeight());
        paneEditLogo.setPrefWidth(paneLogo.getPrefWidth() * 0.3);
        Button buttonEditLogo = new Button();
        buttonEditLogo.getStyleClass().add((Object)"bg_transparent");
        buttonEditLogo.setGraphic((Node)new ImageView(this.imageCamera));
        buttonEditLogo.setPrefHeight(paneEditLogo.getPrefHeight() * 0.4);
        buttonEditLogo.setPrefWidth(paneEditLogo.getPrefWidth());
        paneEditLogo.add((Node)buttonEditLogo, 0, 0);
        paneLogo.add((Node)labelLogo, 0, 0);
        paneLogo.add((Node)paneEditLogo, 1, 0);
        GridPane paneBackground = new GridPane();
        paneBackground.setPrefHeight(paneImages.getPrefHeight());
        paneBackground.setPrefWidth(paneImages.getPrefWidth() * 0.5);
        Label labelBackground = new Label("Catalog");
        labelBackground.setAlignment(Pos.CENTER);
        labelBackground.setPrefHeight(paneBackground.getPrefHeight());
        labelBackground.setPrefWidth(paneBackground.getPrefWidth() * 0.7);
        GridPane paneEditBackground = new GridPane();
        paneEditBackground.setAlignment(Pos.TOP_CENTER);
        paneEditBackground.setPrefHeight(paneBackground.getPrefHeight());
        paneEditBackground.setPrefWidth(paneBackground.getPrefWidth() * 0.3);
        Button buttonEditBackground = new Button();
        buttonEditBackground.getStyleClass().add((Object)"bg_transparent");
        buttonEditBackground.setGraphic((Node)new ImageView(this.imageCamera));
        buttonEditBackground.setPrefHeight(paneEditBackground.getPrefHeight() * 0.4);
        buttonEditBackground.setPrefWidth(paneEditBackground.getPrefWidth());
        paneEditBackground.add((Node)buttonEditBackground, 0, 0);
        paneBackground.add((Node)labelBackground, 0, 0);
        paneBackground.add((Node)paneEditBackground, 1, 0);
        paneImages.add((Node)paneLogo, 0, 0);
        paneImages.add((Node)paneBackground, 1, 0);
        buttonEditBackground.getProperties().put((Object)"tag", (Object)mTagInfo);
        buttonEditBackground.getProperties().put((Object)"labelImage", (Object)labelBackground);
        buttonEditBackground.getProperties().put((Object)"idTemp", (Object)idTemp);
        buttonEditLogo.getProperties().put((Object)"tag", (Object)mTagInfo);
        buttonEditLogo.getProperties().put((Object)"labelImage", (Object)labelLogo);
        buttonEditLogo.getProperties().put((Object)"idTemp", (Object)idTemp);
        buttonEditLogo.setOnAction(this.mEventHandlerEditLogo);
        buttonEditBackground.setOnAction(this.mEventHandlerEditBackground);
        btnAdd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                paneTag.getChildren().clear();
                paneTag.add((Node)numberTag, 0, 0);
                paneTag.add((Node)nameTag, 0, 1);
                paneTag.add((Node)paneImages, 0, 2);
                paneTag.add((Node)btnValid, 0, 3);
            }
        });
        btnValid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                mTagInfo.setName(nameTag.getText());
                mTagInfo.setNumber(Integer.parseInt(numberTag.getText().isEmpty() ? "0" : numberTag.getText()));
                TagsController.this.addTag(mTagInfo);
            }
        });
        paneTag.add((Node)btnAdd, 0, 0);
        this.listPaneTags.add(paneTag);
        this.showTags(this.listPaneTags);
    }

    private void addTag(TagInfo mTagInfo) {
        this.mTagsService.addTag(mTagInfo);
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.mItemService.synchroniseTag(mTagInfo);
        }
        this.loadTags();
    }

    private void deleteTag(TagInfo mTagInfo) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Vous voulez vraiment supprimer ce tag ?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
        alert.showAndWait();
        if (alert.getResult() == ButtonType.YES) {
            try {
                this.mTagsService.deleteTag(mTagInfo);
                this.loadTags();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Tag supprim\u00e9", 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    private void showTags(List<GridPane> items) {
        this.number_page_tag = (int)Math.ceil((double)items.size() / (double)(this.number_line * this.number_column));
        this.pane_tags = new GridPane[this.number_page_tag];
        for (int i = 0; i < this.number_page_tag; ++i) {
            this.pane_tags[i] = new GridPane();
            this.pane_tags[i].setVgap(5.0);
            this.pane_tags[i].setHgap(5.0);
            this.pane_tags[i].setAlignment(Pos.CENTER);
            this.pane_tags[i].getStyleClass().add((Object)"bg-white");
        }
        int index_tag = 0;
        int column_tag = 0;
        int row_tag = 0;
        for (GridPane paneItem : items) {
            this.pane_tags[index_tag].add((Node)paneItem, column_tag, row_tag);
            if (column_tag < this.number_column - 1) {
                ++column_tag;
                continue;
            }
            if (row_tag < this.number_line - 1) {
                ++row_tag;
                column_tag = 0;
                continue;
            }
            ++index_tag;
            row_tag = 0;
            column_tag = 0;
        }
        this.pane_main.getChildren().clear();
        this.list_tags.getChildren().clear();
        if (this.number_page_tag > 0) {
            this.page_tag = 0;
            this.list_tags.add((Node)this.pane_tags[this.page_tag], 0, 0);
            if (this.number_page_tag <= 1) {
                this.pane_main.add((Node)this.list_tags, 0, 0);
            } else {
                this.pane_preview_tag.getChildren().clear();
                this.pane_next_tag.getChildren().clear();
                this.pane_next_tag.add((Node)this.btn_tag_next, 0, 0);
                this.pane_preview_tag.getChildren().clear();
                this.pane_main.add((Node)this.pane_preview_tag, 0, 0);
                this.pane_main.add((Node)this.list_tags, 0, 1);
                this.pane_main.add((Node)this.pane_next_tag, 0, 2);
            }
        }
    }

    public void lastPaneBorne() {
        if (this.page_tag > 0) {
            --this.page_tag;
            this.list_tags.getChildren().clear();
            this.list_tags.add((Node)this.pane_tags[this.page_tag], 0, 0);
            this.pane_next_tag.getChildren().clear();
            this.pane_next_tag.add((Node)this.btn_tag_next, 0, 0);
            if (this.page_tag == 0) {
                this.pane_preview_tag.getChildren().clear();
            } else {
                this.pane_preview_tag.getChildren().clear();
                this.pane_preview_tag.add((Node)this.btn_tag_previous, 0, 0);
            }
        }
    }

    public void nextPageBorne() {
        if (this.page_tag < this.number_page_tag - 1) {
            ++this.page_tag;
            this.list_tags.getChildren().clear();
            this.list_tags.add((Node)this.pane_tags[this.page_tag], 0, 0);
            this.pane_preview_tag.getChildren().clear();
            this.pane_preview_tag.add((Node)this.btn_tag_previous, 0, 0);
            if (this.page_tag == this.number_page_tag - 1) {
                this.pane_next_tag.getChildren().clear();
            } else {
                this.pane_next_tag.getChildren().clear();
                this.pane_next_tag.add((Node)this.btn_tag_next, 0, 0);
            }
        }
    }

    public void reload() {
        this.loadTags();
    }

    private void updateTag(TagInfo mTagInfo) {
        try {
            this.mTagsService.updateTag(mTagInfo);
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.mItemService.synchroniseTag(mTagInfo);
            }
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Tag modifi\u00e9", 1500, NPosition.BOTTOM_RIGHT);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    public void addResizedImageTag(File file) throws IOException {
        if (file != null && file.exists()) {
            for (String size : ItemService.tagslistsizes) {
                String taille = size.substring(1, size.length() - 2);
                this.imageUtils.resizeImage(file, taille);
            }
        }
    }

    private void addImage(TagInfo tag, Label lableImage, String typeImage, int idTemp) {
        Platform.runLater(() -> {
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(LocalRes.getIntString("label.imagefiles"), new String[]{"*.png", "*.gif", "*.jpg", "*.jpeg", "*.bmp"});
            fc.getExtensionFilters().add((Object)extFilter);
            System.out.println("+++++++++= m_fCurrentDirectory : " + m_fCurrentDirectory);
            fc.setInitialDirectory(m_fCurrentDirectory);
            File file = fc.showOpenDialog(null);
            if (file != null) {
                if (file.length() <= (long)this.MAX_SIZE_FILE) {
                    try {
                        Object name_image = typeImage != null && typeImage.equals("logo") ? "logo_" : "backgound_";
                        System.out.println("tag.getId() : " + tag.getId());
                        name_image = (String)name_image + (tag.getId() != null ? String.valueOf(tag.getId()) : String.valueOf(idTemp));
                        String path = file.getAbsolutePath().toString();
                        String name = file.getName();
                        String ext = name.substring(name.lastIndexOf(".") + 1);
                        name_image = (String)name_image + "." + ext;
                        if (path != null) {
                            System.out.println("+++++++++++ path : " + path);
                            System.out.println("++++++++ name_image : " + (String)name_image);
                            File directory = new File(new File(System.getProperty("user.home")), "images/tags");
                            FileUtils.forceMkdir((File)directory);
                            String url = directory.getPath();
                            File dest = new File(url + "/" + (String)name_image);
                            if (!dest.exists()) {
                                dest.createNewFile();
                            }
                            FileUtils.copyFile((File)new File(path), (File)dest);
                            m_fCurrentDirectory = file.getParentFile();
                            if (typeImage != null && typeImage.equals("logo")) {
                                tag.setLogo_tag((String)name_image);
                            } else {
                                tag.setBackground_catalog((String)name_image);
                            }
                            this.showImage(lableImage, (String)name_image);
                            this.addResizedImageTag(dest);
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Votre fichier est trop lourd (> 500KO).", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
        });
    }

    private void showImage(Label labelImage, String name_image) {
        Image image_tag;
        File image = this.m_FilerUtils.getFileFullPath("images/tags/" + name_image);
        if (image.exists() && (image_tag = new Image(image.toURI().toString())) != null && image_tag.getException() == null) {
            ImageView imageView = new ImageView(image_tag);
            imageView.setFitHeight(labelImage.getPrefHeight() * 0.8);
            imageView.setFitWidth(labelImage.getPrefWidth() * 0.8);
            imageView.setPreserveRatio(false);
            imageView.setSmooth(false);
            labelImage.setText("");
            labelImage.setGraphic((Node)imageView);
        }
    }

    private int getID(List<TagInfo> tags) {
        return tags != null && tags.size() > 0 ? tags.get(tags.size() - 1).getId() + 1 : 1;
    }

    private void broadcastTagStatusChange(final TagInfo tag) {
        final List<BorneInfo> bis = this.mBorneService.getBornes();
        if (bis != null && !bis.isEmpty()) {
            new Thread(){

                @Override
                public void run() {
                    for (BorneInfo bi : bis) {
                        try {
                            System.out.println("+++++ broadcasting_change, borne: " + bi.getName_borne() + ", isEnabled: " + tag.isEnabled());
                            TagsController.this.mBorneService.toggleTag(bi, tag);
                        }
                        catch (Exception ex) {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue avec " + bi.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                }
            }.start();
        }
    }
}

