/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.TableInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.LogToFile;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class TableController
implements RootController {
    private Stage stage;
    @FXML
    TextField num_table;
    @FXML
    TextField num_couvert;
    @FXML
    Label label_num_table;
    @FXML
    Label label_covered;
    @FXML
    Button btn_valid;
    private Object[] result;
    private DataLogicSales dlSales;
    private AppView mAppView;
    private TextField focusedTextField;

    public void Valider() {
        try {
            if (this.num_table.getText().isEmpty() || this.num_couvert.getText().isEmpty()) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.empty.fields"), 1500, NPosition.TOP_RIGHT);
            } else if (!(this.num_table.getText().isEmpty() || this.num_couvert.getText().isEmpty() || this.num_couvert.getText().length() <= 10 && this.num_table.getText().length() <= 10)) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Text.max.digits"), 1500, NPosition.TOP_RIGHT);
            } else {
                TableInfo table = this.dlSales.getTableByNum(Integer.parseInt(this.num_table.getText()));
                if (table != null) {
                    this.checkAvailability(table);
                    if (table.isAvailable()) {
                        this.result[0] = table;
                        this.result[1] = Integer.parseInt(this.num_couvert.getText());
                        this.result[2] = true;
                        this.stage.close();
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Text.table.reserved"), 1500, NPosition.TOP_RIGHT);
                    }
                } else {
                    TableInfo tableDB = new TableInfo(-1, Integer.parseInt(this.num_table.getText()), "table", Integer.parseInt(this.num_couvert.getText()), 0, 0, true, -1);
                    TableInfo tableResult = this.dlSales.addTablle(tableDB);
                    if (tableResult != null) {
                        this.result[0] = tableResult;
                        this.result[1] = Integer.parseInt(this.num_couvert.getText());
                        this.result[2] = true;
                        this.stage.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void closePopUp() {
        this.stage.close();
    }

    private void fillFocusedTextField(String mData) {
        if (this.focusedTextField != null) {
            this.focusedTextField.setText(this.focusedTextField.getText() + mData);
        }
    }

    public void select0() {
        this.fillFocusedTextField("0");
    }

    public void select1() {
        this.fillFocusedTextField("1");
    }

    public void select2() {
        this.fillFocusedTextField("2");
    }

    public void select3() {
        this.fillFocusedTextField("3");
    }

    public void select4() {
        this.fillFocusedTextField("4");
    }

    public void select5() {
        this.fillFocusedTextField("5");
    }

    public void select6() {
        this.fillFocusedTextField("6");
    }

    public void select7() {
        this.fillFocusedTextField("7");
    }

    public void select8() {
        this.fillFocusedTextField("8");
    }

    public void select9() {
        this.fillFocusedTextField("9");
    }

    public void selectBack() {
        if (this.focusedTextField != null && this.focusedTextField.getText().length() >= 1) {
            this.focusedTextField.setText(this.focusedTextField.getText().substring(0, this.focusedTextField.getText().length() - 1));
        }
    }

    public Object[] getResult() {
        return this.result;
    }

    private void checkAvailability(TableInfo table) throws BasicException {
        TicketInfo ticketTmp = this.dlSales.checktable(table.getId());
        if (ticketTmp != null) {
            table.setAvailable(false);
        } else {
            table.setAvailable(true);
        }
    }

    private void initializer() {
        this.dlSales = (DataLogicSales)this.mAppView.getBean("com.openbravo.dao.DataLogicSales");
        this.result = new Object[3];
        this.result[0] = null;
        this.result[1] = 0;
        this.result[2] = false;
        this.focusedTextField = this.num_table;
        this.num_table.setEditable(false);
        this.num_couvert.setEditable(false);
        this.num_table.getProperties().put((Object)"vkType", (Object)4);
        this.num_couvert.getProperties().put((Object)"vkType", (Object)4);
        this.num_table.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TableController.this.focusedTextField = TableController.this.num_table;
            }
        });
        this.num_couvert.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TableController.this.focusedTextField = TableController.this.num_couvert;
            }
        });
        this.setTexts();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        if (object instanceof AppView) {
            this.mAppView = (AppView)object;
        }
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        for (Object object : objects) {
            if (!(object instanceof AppView)) continue;
            this.mAppView = (AppView)object;
        }
        this.initializer();
    }

    private void setTexts() {
        this.label_num_table.setText(AppLocal.getIntString("Label.num.table"));
        this.label_covered.setText(AppLocal.getIntString("Label.covered"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid"));
    }
}

