/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.StockDetailHistoryInfo;
import com.openbravo.pos.ticket.StockHistoryDetailView;
import com.openbravo.pos.ticket.StockHistoryInfo;
import com.openbravo.pos.ticket.StockHistoryView;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;

public class StockHistoryController {
    @FXML
    DatePicker datepicker;
    @FXML
    Button typeHistory;
    @FXML
    TableView tableView;
    @FXML
    TableColumn product;
    @FXML
    TableColumn commande;
    @FXML
    TableColumn sortie;
    @FXML
    TableColumn entree;
    @FXML
    TableColumn casse;
    @FXML
    TableColumn stock;
    @FXML
    TableView table_detail;
    @FXML
    TableColumn product_detail;
    @FXML
    TableColumn user_detail;
    @FXML
    TableColumn date_detail;
    @FXML
    TableColumn heure_detail;
    @FXML
    TableColumn stock_detail;
    @FXML
    TableColumn operation_detail;
    @FXML
    GridPane pane_table;
    private AppView m_App;
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    private Date dateSearch;
    private boolean firstTime;
    private List<StockHistoryInfo> stockHistory;
    private List<StockDetailHistoryInfo> stockDetailHistory;
    private boolean history;
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;

    public void initialize(AppView app, Scene scene) throws BasicException {
        this.m_App = app;
        this.history = true;
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlItems = (DataLogicItems)this.m_App.getBean("com.openbravo.dao.DataLogicItems");
        this.datepicker.setValue((Object)LocalDate.now());
        this.product_detail.setCellValueFactory((Callback)new PropertyValueFactory("product"));
        this.user_detail.setCellValueFactory((Callback)new PropertyValueFactory("user"));
        this.date_detail.setCellValueFactory((Callback)new PropertyValueFactory("date"));
        this.heure_detail.setCellValueFactory((Callback)new PropertyValueFactory("heure"));
        this.stock_detail.setCellValueFactory((Callback)new PropertyValueFactory("stock"));
        this.operation_detail.setCellValueFactory((Callback)new PropertyValueFactory("operation"));
        this.product.setCellValueFactory((Callback)new PropertyValueFactory("product"));
        this.commande.setCellValueFactory((Callback)new PropertyValueFactory("commande"));
        this.sortie.setCellValueFactory((Callback)new PropertyValueFactory("sortie"));
        this.entree.setCellValueFactory((Callback)new PropertyValueFactory("entree"));
        this.casse.setCellValueFactory((Callback)new PropertyValueFactory("casse"));
        this.stock.setCellValueFactory((Callback)new PropertyValueFactory("stock"));
        this.firstTime = true;
        this.datepicker.getEditor().getProperties().put((Object)"vkType", (Object)4);
        this.datepicker.setOnAction(new EventHandler(){

            public void handle(Event t) {
                if (!StockHistoryController.this.firstTime) {
                    StockHistoryController.this.dateSearch = StockHistoryController.this.getDate((LocalDate)StockHistoryController.this.datepicker.getValue());
                    try {
                        StockHistoryController.this.load();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        });
        this.dateSearch = new Date();
        this.typeHistory.setText("Detail");
        this.load();
        this.firstTime = false;
    }

    public Date getDate(LocalDate localDate) {
        Instant instant = Instant.from(localDate.atStartOfDay(ZoneId.systemDefault()));
        Date date = Date.from(instant);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getTime();
    }

    private void loadHistory() throws BasicException {
        this.stockHistory = this.dlSales.getStockHistory(this.dateSearch);
        ArrayList<StockHistoryView> items = new ArrayList<StockHistoryView>();
        for (StockHistoryInfo stock : this.stockHistory) {
            items.add(new StockHistoryView(stock.getNameProduct(), this.printQuantity(stock.getQuantityCommande()), this.printQuantity(stock.getQuantitySortie()), this.printQuantity(stock.getQuantityEntree()), this.printQuantity(stock.getQuantityCasse()), this.printQuantity(stock.getStock())));
        }
        ObservableList data = FXCollections.observableArrayList(items);
        this.tableView.setItems(data);
        this.showHistory();
    }

    private void loadDetailHistory() throws BasicException {
        this.stockDetailHistory = this.dlItems.getStockDetailHistory(this.dateSearch);
        ArrayList<StockHistoryDetailView> itemsDetail = new ArrayList<StockHistoryDetailView>();
        for (StockDetailHistoryInfo stockDetail : this.stockDetailHistory) {
            itemsDetail.add(new StockHistoryDetailView(stockDetail.getNameProduct(), stockDetail.getUser(), this.dateFormatter.format(stockDetail.getDateHistorique()), this.timeFormatter.format(stockDetail.getDateHistorique()), this.printQuantity(stockDetail.getQuantity()), stockDetail.getOperation()));
        }
        ObservableList data = FXCollections.observableArrayList(itemsDetail);
        this.table_detail.setItems(data);
        this.showDetailHistory();
    }

    public void load() throws BasicException {
        if (this.history) {
            this.loadHistory();
        } else {
            this.loadDetailHistory();
        }
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    public void showHistory() {
        this.pane_table.getChildren().clear();
        this.pane_table.add((Node)this.tableView, 0, 0);
        this.typeHistory.setText("Detail");
    }

    public void showDetailHistory() {
        this.pane_table.getChildren().clear();
        this.pane_table.add((Node)this.table_detail, 0, 0);
        this.typeHistory.setText("Historique");
    }

    public void changeType() {
        this.history = !this.history;
        try {
            this.load();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

