/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.ButtonCategory;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.BarCodeController;
import com.openbravo.controllers.PopUpRapportStock;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.BarCodeValidator;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class StockController {
    @FXML
    Label name_product;
    @FXML
    ComboBox typeOperation;
    @FXML
    Label stock;
    @FXML
    TextField quantity;
    @FXML
    DatePicker datepicker;
    @FXML
    GridPane bloc_variable;
    @FXML
    GridPane pane_product;
    @FXML
    GridPane pane_categories;
    @FXML
    Button btn_bar;
    @FXML
    TextField jTextFieldBarCodeScanner;
    private boolean isFirstBarCode = false;
    private AppView m_App;
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    protected List<CategoryInfo> categories;
    private HashMap<Integer, ButtonCategory> btnsCategory;
    private Image imageNext;
    private Image imagePrevious;
    private int widthProduct;
    private int heightProduct;
    private int supportProduct;
    private int supportCategory;
    private int pageProduct;
    private int indexProduct;
    private int column;
    private int row;
    private static final int numberColumnProduct = 5;
    private static final int numberRowProduct = 4;
    private GridPane[] panesProduct;
    private int numberPage;
    private int columnCategory;
    private ProductInfoExt currentProduct;
    private Button currentBtnProduct;
    private HashMap<Integer, Double> listQuantity;
    private HashMap<Integer, Button> listBtns;
    private int widthCategory;
    private int heightCategory;
    private GridPane[] panesCategory;
    private int pageCategory;
    private int indexCategory;
    private int rowCategory;
    private static final int numberColumnCategory = 4;
    private static final int numberRowCategory = 4;
    private int numberPageCategory;
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    private Scene scene;

    public void initialize(AppView app, Scene scene) throws BasicException, URISyntaxException {
        this.m_App = app;
        this.scene = scene;
        this.imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1rightarrow.png"));
        this.imagePrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1leftarrow.png"));
        Image imageBarre = new Image(this.getClass().getResource("/com/openbravo/images/barre.png").toURI().toString(), 30.0, 30.0, false, false);
        this.btn_bar.setGraphic((Node)new ImageView(imageBarre));
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlItems = (DataLogicItems)this.m_App.getBean("com.openbravo.dao.DataLogicItems");
        this.dlSales.setDlItems(this.dlItems);
        this.initBarCodeScanner();
        this.jTextFieldBarCodeScanner.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                StockController.this.isBarCodeUpdated(StockController.this.jTextFieldBarCodeScanner.getText().toString());
                StockController.this.jTextFieldBarCodeScanner.requestFocus();
            }
        });
        this.btn_bar.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 1) {
                    StockController.this.focusTextBar();
                }
                if (event.getClickCount() == 2) {
                    StockController.this.loadPopUpBar();
                }
            }
        });
        this.initializer();
    }

    private void focusTextBar() {
        this.jTextFieldBarCodeScanner.requestFocus();
    }

    private void loadPopUpBar() {
        try {
            EventHiddenModal mAction = new EventHiddenModal(){
                Object[] result;

                @Override
                public void onHidden() {
                    if (((Boolean)this.result[1]).booleanValue()) {
                        String code = (String)this.result[0];
                        StockController.this.isBarCodeUpdated(code, true);
                    }
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        BarCodeController mController = (BarCodeController)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/popUp_barcode.fxml", new Dimension(400, 400), mAction);
            mLazy.load(new Object[0]);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void isBarCodeUpdated(String codeBar) {
        block8: {
            long lastInit = new Date().getTime();
            if (!this.isFirstBarCode) {
                this.isFirstBarCode = true;
            }
            if (BarCodeValidator.isValidBarcode(codeBar)) {
                try {
                    ProductInfoExt p = this.dlSales.getProductInfoByCode(codeBar);
                    if (p == null) break block8;
                    this.jTextFieldBarCodeScanner.setText("");
                    this.isFirstBarCode = false;
                    CategoryInfo category = null;
                    for (CategoryInfo category1 : this.categories) {
                        if (p.getCategoryid() != category1.getID()) continue;
                        category = category1;
                        break;
                    }
                    if (category != null) {
                        this.loadCatgory(category, this.btnsCategory.get(category.getID()).getBouton());
                        this.loadItem(p, this.listBtns.get(p.getID()));
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else if (this.jTextFieldBarCodeScanner.getText().length() > 18) {
                this.jTextFieldBarCodeScanner.setText("");
                this.isFirstBarCode = false;
            }
        }
    }

    public void isBarCodeUpdated(String codeBar, boolean fromPopUp) {
        this.jTextFieldBarCodeScanner.setText("");
        this.isFirstBarCode = false;
        try {
            ProductInfoExt p = this.dlSales.getProductInfoByCode(codeBar);
            if (p != null) {
                CategoryInfo category = null;
                for (CategoryInfo category1 : this.categories) {
                    if (p.getCategoryid() != category1.getID()) continue;
                    category = category1;
                    break;
                }
                if (category != null) {
                    this.loadCatgory(category, this.btnsCategory.get(category.getID()).getBouton());
                    this.loadItem(p, this.listBtns.get(p.getID()));
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void initBarCodeScanner() {
        this.jTextFieldBarCodeScanner.setVisible(true);
        this.jTextFieldBarCodeScanner.requestFocus();
        this.jTextFieldBarCodeScanner.setText("");
        this.jTextFieldBarCodeScanner.getProperties().put((Object)"vkType", (Object)4);
        this.isFirstBarCode = false;
    }

    public void initializer() {
        this.currentProduct = null;
        this.currentBtnProduct = null;
        this.listQuantity = new HashMap();
        this.listBtns = new HashMap();
        this.datepicker.setValue((Object)LocalDate.now());
        this.btnsCategory = new HashMap();
        try {
            this.categories = "venteDetail".equals(AppLocal.licence) ? this.dlSales.getStorableCategories() : this.dlSales.getStorableCategoriesByProduct();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.loadCategories();
    }

    public void reloadCatalog() throws BasicException {
        this.categories = "venteDetail".equals(AppLocal.licence) ? this.dlSales.getRootCategories() : this.dlSales.getStorableCategories();
        this.loadCategories();
    }

    public void loadCategories() {
        this.widthCategory = (int)(AppVarUtils.getScreenDimension().getWidth() * 0.6) / 4;
        this.heightCategory = (int)(AppVarUtils.getScreenDimension().getHeight() * 0.4) / 4;
        this.supportCategory = 16;
        this.pane_categories.getChildren().clear();
        this.pane_product.getChildren().clear();
        this.btnsCategory.clear();
        int sizeCategory = this.categories.size();
        int numberPageCategoryTmp = (int)Math.ceil((double)sizeCategory / (double)this.supportCategory);
        this.numberPageCategory = (int)Math.ceil((double)(sizeCategory += numberPageCategoryTmp) / (double)this.supportCategory);
        this.panesCategory = new GridPane[this.numberPageCategory];
        this.indexCategory = 0;
        this.rowCategory = 0;
        this.columnCategory = 0;
        for (int i = 0; i < this.numberPageCategory; ++i) {
            this.panesCategory[i] = new GridPane();
            this.panesCategory[i].setHgap(5.0);
            this.panesCategory[i].setVgap(5.0);
        }
        for (final CategoryInfo category : this.categories) {
            final Button btnCategory = new Button(category.getName());
            btnCategory.setPrefWidth((double)this.widthCategory);
            btnCategory.setPrefHeight((double)this.heightCategory);
            btnCategory.setWrapText(true);
            String color_hex = "#f5a623";
            if (category.getColor() != null) {
                color_hex = ColorUtils.getColor(category.getColor());
            }
            btnCategory.setStyle("-fx-background-color: " + color_hex + ";");
            this.btnsCategory.put(category.getID(), new ButtonCategory(btnCategory, color_hex));
            btnCategory.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    try {
                        StockController.this.loadCatgory(category, btnCategory);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
            this.panesCategory[this.indexCategory].add((Node)btnCategory, this.columnCategory, this.rowCategory);
            this.nextStep_Category(sizeCategory);
        }
        if (this.indexCategory < this.numberPageCategory) {
            while (this.rowCategory < 4 && this.columnCategory < 4) {
                Button btnProduct = new Button();
                btnProduct.setPrefWidth((double)this.widthCategory);
                btnProduct.setPrefHeight((double)this.heightCategory);
                btnProduct.getStyleClass().add((Object)"btn_product_empty");
                this.panesCategory[this.indexCategory].add((Node)btnProduct, this.columnCategory, this.rowCategory);
                if (this.columnCategory < 3) {
                    ++this.columnCategory;
                    if (this.columnCategory != 3 || this.rowCategory != 3 || sizeCategory <= this.supportCategory) continue;
                    this.addBtnNextPreviousCatgory();
                    ++this.columnCategory;
                    continue;
                }
                ++this.rowCategory;
                this.columnCategory = 0;
            }
        }
        this.pageCategory = 0;
        if (this.categories.size() > 0) {
            this.pane_categories.add((Node)this.panesCategory[this.pageCategory], 0, 0);
        }
    }

    private void loadCatgory(CategoryInfo category, Button btnCategory) throws BasicException {
        this.loadProduct(category);
        for (ButtonCategory btn : this.btnsCategory.values()) {
            btn.getBouton().setStyle("-fx-background-color: " + btn.getColor() + ";");
        }
        btnCategory.setStyle("-fx-background-color: #6597d1;");
    }

    public void loadProduct(CategoryInfo category) throws BasicException {
        this.init();
        this.bloc_variable.setVisible(false);
        this.currentProduct = null;
        this.widthProduct = (int)(AppVarUtils.getScreenDimension().getWidth() * 0.6) / 5;
        this.heightProduct = (int)(AppVarUtils.getScreenDimension().getHeight() * 0.4) / 4;
        this.supportProduct = 20;
        this.pane_product.getChildren().clear();
        this.listBtns.clear();
        List<Object> products = new ArrayList();
        products = "venteDetail".equals(AppLocal.licence) || category.isRaw_material() ? this.dlItems.getProducts(category.getID(), false, false, false, true) : this.dlSales.getStorableProducts(category.getID());
        int sizeProducts = products.size();
        int numberPageProductTmp = (int)Math.ceil((double)sizeProducts / (double)this.supportCategory);
        this.numberPage = (int)Math.ceil((double)(sizeProducts += numberPageProductTmp) / (double)this.supportProduct);
        this.panesProduct = new GridPane[this.numberPage];
        this.indexProduct = 0;
        this.row = 0;
        this.column = 0;
        for (int i = 0; i < this.numberPage; ++i) {
            this.panesProduct[i] = new GridPane();
            this.panesProduct[i].setHgap(5.0);
            this.panesProduct[i].setVgap(5.0);
        }
        for (final ProductInfoExt productInfoExt : products) {
            final Button btnProduct = new Button();
            String color = "#f5a623";
            if (productInfoExt.getColor() != null) {
                color = ColorUtils.getColor(productInfoExt.getColor());
            }
            btnProduct.setStyle("-fx-background-color: " + color + ";");
            btnProduct.setPrefWidth((double)this.widthProduct);
            btnProduct.setPrefHeight((double)this.heightProduct);
            String name = productInfoExt.getName();
            String operation = (String)this.typeOperation.getSelectionModel().getSelectedItem();
            GridPane paneName = new GridPane();
            GridPane paneStock = new GridPane();
            paneName.setPrefHeight(btnProduct.getPrefHeight());
            paneName.setPrefWidth(btnProduct.getPrefWidth());
            paneStock.setPrefHeight(paneName.getPrefHeight());
            paneStock.setPrefWidth(paneName.getPrefWidth());
            Label nameProduct = new Label(name);
            nameProduct.setAlignment(Pos.CENTER);
            nameProduct.getStyleClass().add((Object)"text-white");
            nameProduct.setStyle("-fx-background-color: " + color + ";");
            nameProduct.setWrapText(true);
            Label m_labelStockQty = new Label(Formats.INT.formatValue(productInfoExt.getQuantity()));
            m_labelStockQty.getStyleClass().add((Object)"m-badge-stock");
            if (productInfoExt.getQuantity() <= productInfoExt.getMin_store()) {
                m_labelStockQty.getStyleClass().add((Object)"bg_red");
            } else {
                m_labelStockQty.getStyleClass().add((Object)"bg_57606f");
            }
            boolean found = false;
            if (operation != null && this.listQuantity.size() > 0 && this.listQuantity.containsKey(productInfoExt.getID())) {
                found = true;
            }
            if (found) {
                Label labelQuantity = new Label();
                labelQuantity.setWrapText(true);
                if ("Sortie".equals(operation) || "Casse".equals(operation)) {
                    labelQuantity.setText("(-" + this.printQuantity(this.listQuantity.get(productInfoExt.getID())) + ")");
                } else {
                    labelQuantity.setText("(" + this.printQuantity(this.listQuantity.get(productInfoExt.getID())) + ")");
                }
                labelQuantity.setAlignment(Pos.CENTER);
                paneStock.setPrefHeight(paneName.getPrefHeight() * 0.7);
                paneStock.setPrefWidth(paneName.getPrefWidth());
                nameProduct.setPrefHeight(paneStock.getPrefHeight());
                nameProduct.setPrefWidth(paneStock.getPrefWidth() * 0.5);
                m_labelStockQty.setPrefWidth(paneStock.getPrefWidth() * 0.5);
                paneStock.add((Node)nameProduct, 0, 0);
                paneName.add((Node)m_labelStockQty, 1, 0);
                labelQuantity.getStyleClass().add((Object)"m-badge-stock-qty");
                labelQuantity.setPrefHeight(paneName.getPrefHeight() * 0.3);
                paneName.add((Node)paneStock, 0, 0);
                paneName.add((Node)labelQuantity, 0, 1);
            } else {
                paneStock.setPrefHeight(paneName.getPrefHeight() * 0.7);
                paneStock.setPrefWidth(paneName.getPrefWidth());
                nameProduct.setPrefHeight(paneStock.getPrefHeight());
                nameProduct.setPrefWidth(paneStock.getPrefWidth() * 0.5);
                m_labelStockQty.setPrefWidth(paneStock.getPrefWidth() * 0.5);
                paneStock.add((Node)nameProduct, 0, 0);
                paneName.add((Node)m_labelStockQty, 1, 0);
                paneName.add((Node)paneStock, 0, 0);
            }
            btnProduct.setGraphic((Node)paneName);
            this.listBtns.put(productInfoExt.getID(), btnProduct);
            btnProduct.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    StockController.this.loadItem(productInfoExt, btnProduct);
                }
            });
            this.panesProduct[this.indexProduct].add((Node)btnProduct, this.column, this.row);
            this.nextStep_Product(sizeProducts);
        }
        if (this.indexProduct < this.numberPage) {
            while (this.row < 4 && this.column < 5) {
                Button btnProduct = new Button();
                btnProduct.setPrefWidth((double)this.widthProduct);
                btnProduct.setPrefHeight((double)this.heightProduct);
                btnProduct.getStyleClass().add((Object)"btn_product_empty");
                this.panesProduct[this.indexProduct].add((Node)btnProduct, this.column, this.row);
                if (this.column < 4) {
                    ++this.column;
                    if (this.column != 4 || this.row != 3 || sizeProducts <= this.supportProduct) continue;
                    this.addBtnNextPrevious();
                    ++this.column;
                    continue;
                }
                ++this.row;
                this.column = 0;
            }
        }
        this.pageProduct = 0;
        this.pane_product.add((Node)this.panesProduct[this.pageProduct], 0, 0);
    }

    private void loadItem(ProductInfoExt product, Button btnProduct) {
        this.currentBtnProduct = btnProduct;
        this.currentProduct = product;
        this.bloc_variable.setVisible(true);
        this.name_product.setText(product.getName());
        this.stock.setText(String.valueOf(product.getQuantity()));
        boolean found = false;
        if (this.listQuantity.size() > 0 && this.listQuantity.containsKey(product.getID())) {
            found = true;
        }
        if (found) {
            this.quantity.setText(this.printQuantity(this.listQuantity.get(product.getID())));
        } else {
            this.quantity.setText("");
        }
    }

    public void save() {
        String operation = (String)this.typeOperation.getSelectionModel().getSelectedItem();
        double valQuanity = Double.parseDouble(this.quantity.getText().isEmpty() ? "0.0" : this.quantity.getText());
        if (operation != null) {
            if (("Sortie".equals(operation) || "Casse".equals(operation)) && valQuanity > this.currentProduct.getQuantity()) {
                NotifyWindow notifyWindow = new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, "la quantit\u00e9 ne doit d\u00e9passer le stock.", 1500, NPosition.BOTTOM_RIGHT);
            } else {
                this.listQuantity.put(this.currentProduct.getID(), valQuanity);
                String name = this.currentProduct.getName();
                GridPane paneName = new GridPane();
                GridPane paneStock = new GridPane();
                paneName.setPrefHeight(this.currentBtnProduct.getPrefHeight());
                paneName.setPrefWidth(this.currentBtnProduct.getPrefWidth());
                paneStock.setPrefHeight(paneName.getPrefHeight() * 0.7);
                paneStock.setPrefWidth(paneName.getPrefWidth());
                Label nameProduct = new Label(name);
                nameProduct.getStyleClass().add((Object)"text-white");
                Label labelQuantity = new Label();
                Label m_labelStockQty = new Label(this.printQuantity(this.currentProduct.getQuantity()));
                m_labelStockQty.getStyleClass().add((Object)"m-badge-stock");
                if ("Sortie".equals(operation) || "Casse".equals(operation)) {
                    labelQuantity.setText("(-" + this.printQuantity(valQuanity) + ")");
                } else {
                    labelQuantity.setText("(" + this.printQuantity(valQuanity) + ")");
                }
                nameProduct.setAlignment(Pos.CENTER);
                labelQuantity.setAlignment(Pos.CENTER);
                String color = "#f5a623";
                if (this.currentProduct.getColor() != null) {
                    color = ColorUtils.getColor(this.currentProduct.getColor());
                }
                nameProduct.setStyle("-fx-background-color: " + color + ";");
                nameProduct.setWrapText(true);
                labelQuantity.setWrapText(true);
                labelQuantity.getStyleClass().add((Object)"m-badge-stock-qty");
                nameProduct.setPrefHeight(paneStock.getPrefHeight());
                nameProduct.setPrefWidth(paneStock.getPrefWidth() * 0.7);
                labelQuantity.setPrefHeight(paneName.getPrefHeight() * 0.3);
                m_labelStockQty.setPrefWidth(paneStock.getPrefWidth() * 0.3);
                paneStock.add((Node)nameProduct, 0, 0);
                paneStock.add((Node)m_labelStockQty, 1, 0);
                paneName.add((Node)paneStock, 0, 0);
                paneName.add((Node)labelQuantity, 0, 1);
                this.currentBtnProduct.setGraphic((Node)paneName);
                this.loadItem(this.currentProduct, this.currentBtnProduct);
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de pr\u00e9ciser le type d'op\u00e9ration.", 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    private void init() {
        this.name_product.setText("");
        this.stock.setText("");
        this.quantity.setText("");
    }

    public void valider() {
        try {
            String operation = (String)this.typeOperation.getSelectionModel().getSelectedItem();
            Date dateOperation = this.getDateOperation((LocalDate)this.datepicker.getValue());
            if (operation == null || dateOperation == null || this.listQuantity.isEmpty()) {
                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Aucune produit a \u00e9t\u00e9 modifi\u00e9 !.", 1500, NPosition.BOTTOM_RIGHT);
            } else {
                String fxmlFile = "/fxml/popUp_rapportStock.fxml";
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
                Parent rootNode = (Parent)loader.load();
                final PopUpRapportStock controller = (PopUpRapportStock)loader.getController();
                Scene scenePop = new Scene(rootNode, 500.0, 500.0);
                scenePop.getStylesheets().add((Object)"/styles/styles.css");
                final Stage modalStage = new Stage();
                modalStage.setScene(scenePop);
                modalStage.initOwner(this.scene.getWindow());
                modalStage.initModality(Modality.APPLICATION_MODAL);
                modalStage.initStyle(StageStyle.UTILITY);
                modalStage.setAlwaysOnTop(true);
                controller.init(modalStage, this.listQuantity, this.dlSales, dateOperation, operation);
                modalStage.show();
                AppLocal.listPopUp.add(modalStage);
                modalStage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        AppLocal.listPopUp.remove(modalStage);
                        Object[] result = controller.getResult();
                        if (((Boolean)result[3]).booleanValue()) {
                            Date date = (Date)result[0];
                            String type_operation = (String)result[1];
                            HashMap quantities = (HashMap)result[2];
                            StockController.this.changeQuantity(type_operation, date, quantities);
                            StockController.this.init();
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    public void changeQuantity(String operation, Date date_operation, HashMap<Integer, Double> quantities) {
        try {
            switch (operation) {
                case "Sortie": {
                    for (Integer idProduct : quantities.keySet()) {
                        this.dlSales.decreaseStock(idProduct, quantities.get(idProduct), "sortie", date_operation, this.m_App.getAppUserView().getUser().getId());
                    }
                    break;
                }
                case "Casse": {
                    for (Integer idProduct : quantities.keySet()) {
                        this.dlSales.decreaseStock(idProduct, quantities.get(idProduct), "casse", date_operation, this.m_App.getAppUserView().getUser().getId());
                    }
                    break;
                }
                default: {
                    for (Integer idProduct : quantities.keySet()) {
                        this.dlSales.increaseStock(idProduct, quantities.get(idProduct), date_operation, this.m_App.getAppUserView().getUser().getId());
                    }
                }
            }
            quantities.clear();
            this.listQuantity.clear();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les modifications de stock ont \u00e9t\u00e9 sauvegard\u00e9s avec succ\u00e8s.", 1500, NPosition.CENTER);
            this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JPanelStockHistory");
            AppLocal.view_back = "com.openbravo.pos.sales.panelStock";
            AppLocal.view_current = "com.openbravo.pos.sales.JPanelStockHistory";
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
        }
    }

    public Date getDateOperation(LocalDate localDate) {
        Instant instant = Instant.from(localDate.atStartOfDay(ZoneId.systemDefault()));
        Date date = Date.from(instant);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Date dateTmp = new Date();
        cal.set(11, dateTmp.getHours());
        cal.set(12, dateTmp.getMinutes());
        return cal.getTime();
    }

    private void nextStep_Product(int sizeProducts) {
        if (this.column == 4 && this.row == 3) {
            ++this.indexProduct;
            this.row = 0;
            this.column = 0;
        } else if (this.column < 4) {
            ++this.column;
            if (this.column == 4 && this.row == 3 && sizeProducts > this.supportProduct) {
                this.addBtnNextPrevious();
                ++this.indexProduct;
                this.row = 0;
                this.column = 0;
            }
        } else {
            ++this.row;
            this.column = 0;
        }
    }

    private void addBtnNextPrevious() {
        GridPane paneBtn = new GridPane();
        paneBtn.setPrefHeight((double)this.heightProduct);
        paneBtn.setPrefWidth((double)this.widthProduct);
        Button btnNext = new Button();
        Button btnPrevious = new Button();
        btnNext.getStyleClass().add((Object)"btn_product_empty");
        btnPrevious.getStyleClass().add((Object)"btn_product_empty");
        btnNext.setGraphic((Node)new ImageView(this.imageNext));
        btnNext.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (StockController.this.pageProduct < StockController.this.numberPage - 1) {
                    ++StockController.this.pageProduct;
                    StockController.this.pane_product.getChildren().clear();
                    StockController.this.pane_product.add((Node)StockController.this.panesProduct[StockController.this.pageProduct], 0, 0);
                }
            }
        });
        btnPrevious.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (StockController.this.pageProduct > 0) {
                    --StockController.this.pageProduct;
                    StockController.this.pane_product.getChildren().clear();
                    StockController.this.pane_product.add((Node)StockController.this.panesProduct[StockController.this.pageProduct], 0, 0);
                }
            }
        });
        btnPrevious.setGraphic((Node)new ImageView(this.imagePrevious));
        btnNext.setPrefWidth(paneBtn.getPrefWidth() / 2.0);
        btnPrevious.setPrefWidth(paneBtn.getPrefWidth() / 2.0);
        btnNext.setPrefHeight(paneBtn.getPrefHeight());
        btnPrevious.setPrefHeight(paneBtn.getPrefHeight());
        paneBtn.add((Node)btnPrevious, 0, 0);
        paneBtn.add((Node)btnNext, 1, 0);
        this.panesProduct[this.indexProduct].add((Node)paneBtn, this.column, this.row);
    }

    private void nextStep_Category(int sizeCategory) {
        if (this.columnCategory == 3 && this.rowCategory == 3) {
            ++this.indexCategory;
            this.rowCategory = 0;
            this.columnCategory = 0;
        } else if (this.columnCategory < 3) {
            ++this.columnCategory;
            if (this.columnCategory == 3 && this.rowCategory == 3 && sizeCategory > this.supportCategory) {
                this.addBtnNextPreviousCatgory();
                ++this.indexCategory;
                this.rowCategory = 0;
                this.columnCategory = 0;
            }
        } else {
            ++this.rowCategory;
            this.columnCategory = 0;
        }
    }

    private void addBtnNextPreviousCatgory() {
        GridPane paneBtn = new GridPane();
        paneBtn.setPrefHeight((double)this.heightCategory);
        paneBtn.setPrefWidth((double)this.widthCategory);
        Button btnNext = new Button();
        Button btnPrevious = new Button();
        btnNext.getStyleClass().add((Object)"btn_product_empty");
        btnPrevious.getStyleClass().add((Object)"btn_product_empty");
        btnNext.setGraphic((Node)new ImageView(this.imageNext));
        btnNext.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (StockController.this.pageCategory < StockController.this.numberPageCategory - 1) {
                    ++StockController.this.pageCategory;
                    StockController.this.pane_categories.getChildren().clear();
                    StockController.this.pane_categories.add((Node)StockController.this.panesCategory[StockController.this.pageCategory], 0, 0);
                }
            }
        });
        btnPrevious.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (StockController.this.pageCategory > 0) {
                    --StockController.this.pageCategory;
                    StockController.this.pane_categories.getChildren().clear();
                    StockController.this.pane_categories.add((Node)StockController.this.panesCategory[StockController.this.pageCategory], 0, 0);
                }
            }
        });
        btnPrevious.setGraphic((Node)new ImageView(this.imagePrevious));
        btnNext.setPrefWidth(paneBtn.getPrefWidth() / 2.0);
        btnPrevious.setPrefWidth(paneBtn.getPrefWidth() / 2.0);
        btnNext.setPrefHeight(paneBtn.getPrefHeight());
        btnPrevious.setPrefHeight(paneBtn.getPrefHeight());
        paneBtn.add((Node)btnPrevious, 0, 0);
        paneBtn.add((Node)btnNext, 1, 0);
        this.panesCategory[this.indexCategory].add((Node)paneBtn, this.columnCategory, this.rowCategory);
    }
}

