/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.AppConstants;
import com.openbravo.basic.BasicException;
import com.openbravo.components.DoughnutChart;
import com.openbravo.controllers.IAppController;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.events.ClickTooltip;
import com.openbravo.events.EventMouseChartLine;
import com.openbravo.format.Formats;
import com.openbravo.models.LineChartModel;
import com.openbravo.models.ProfitMargin;
import com.openbravo.models.RankCategory;
import com.openbravo.models.RankProduct;
import com.openbravo.models.RankTypeOrder;
import com.openbravo.models.RankUser;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.DayDateInfo;
import com.openbravo.pos.ticket.HourInfo;
import com.openbravo.pos.ticket.IntegerDateInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.procaisse.items.export.ExportItemsExcel;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class StatsController
implements IAppController {
    final String WORK_DONE_LABEL_FORMAT = "%.0f";
    private int periode = 5;
    private int incrementPeriode = 1;
    private boolean isVersion_RetailSale = false;
    private AppView m_App;
    private Scene m_scene;
    protected DataLogicStats dlStats;
    protected DataLogicSales dlSales;
    protected DataLogicSystem dlSystem;
    @FXML
    private ContextMenu actionMenuFilterDate;
    @FXML
    private Button btnFilterDate;
    @FXML
    private DatePicker datePickerFilter;
    @FXML
    private TabPane tabber;
    @FXML
    private StackPane paneDonuChart;
    @FXML
    private StackPane paneLineChart;
    @FXML
    private StackPane paneBarChartShift;
    @FXML
    private ScrollPane paneRoot;
    @FXML
    private Label turnoverLabel;
    @FXML
    private Label oldTurnoverLabel;
    @FXML
    private Label totalOrdersLabel;
    @FXML
    private Label pmValueLabel;
    @FXML
    private Label pmPercentLabel;
    @FXML
    private TableView tableViewCategories;
    @FXML
    private TableColumn ctg_ctvCategoryName;
    @FXML
    private TableColumn ctg_ctvQuantity;
    @FXML
    private TableColumn ctg_ctvTurnover;
    @FXML
    private TableColumn ctg_ctvPercentAtSpot;
    @FXML
    private TableColumn ctg_ctvPercentTakeAway;
    @FXML
    private TableColumn ctg_ctvPercentDelivery;
    @FXML
    private TableView tableViewProduits;
    @FXML
    private TableColumn pdt_ctvProduitName;
    @FXML
    private TableColumn pdt_ctvCategoryName;
    @FXML
    private TableColumn pdt_ctvQuantity;
    @FXML
    private TableColumn pdt_ctvTurnover;
    @FXML
    private TableColumn pdt_ctvPercentAtSpot;
    @FXML
    private TableColumn pdt_ctvPercentTakeAway;
    @FXML
    private TableColumn pdt_ctvPercentDelivery;
    @FXML
    private TableView tableViewCategoriesOption;
    @FXML
    private TableColumn ctgOpt_ctvCategoryName;
    @FXML
    private TableColumn ctgOpt_ctvQuantity;
    @FXML
    private TableColumn ctgOpt_ctvTurnover;
    @FXML
    private TableColumn ctgOpt_ctvPercentAtSpot;
    @FXML
    private TableColumn ctgOpt_ctvPercentTakeAway;
    @FXML
    private TableColumn ctgOpt_ctvPercentDelivery;
    @FXML
    private TableView tableViewItemOption;
    @FXML
    private TableColumn opt_ctvOptionName;
    @FXML
    private TableColumn opt_ctvCategoryName;
    @FXML
    private TableColumn opt_ctvQuantity;
    @FXML
    private TableColumn opt_ctvTurnover;
    @FXML
    private TableColumn opt_ctvPercentAtSpot;
    @FXML
    private TableColumn opt_ctvPercentTakeAway;
    @FXML
    private TableColumn opt_ctvPercentDelivery;
    @FXML
    private TableView tableViewUsers;
    @FXML
    private TableColumn us_tvName;
    @FXML
    private TableColumn us_tvTurnover;
    @FXML
    private TableColumn us_tvPercentAtSpot;
    @FXML
    private TableColumn us_tvPercentTakeAway;
    @FXML
    private TableColumn us_tvPercentDelivery;
    @FXML
    private TableView tableViewTypeOrder;
    @FXML
    private TableColumn to_ctvTypeOrderName;
    @FXML
    private TableColumn to_ctvTypeOrderCount;
    @FXML
    private TableColumn to_ctvTypeOrderCa;
    @FXML
    private TableColumn to_ctvTypeOrderTotal;
    @FXML
    private StackPane apPartsUsers;
    @FXML
    private StackPane apTopCategorieOptions;
    @FXML
    private StackPane apTopCategoriesContent;
    @FXML
    private ComboBox comboBoxOptions;
    @FXML
    private ComboBox comboBoxItems;
    @FXML
    private TableColumn ctg_ctvPercentUber;
    @FXML
    private TableColumn ctg_ctvPercentDelivero;
    @FXML
    private TableColumn pdt_ctvPercentUber;
    @FXML
    private TableColumn pdt_ctvPercentDelivero;
    @FXML
    private TableColumn ctgOpt_ctvPercentUber;
    @FXML
    private TableColumn ctgOpt_ctvPercentDelivero;
    @FXML
    private TableColumn opt_ctvPercentUber;
    @FXML
    private TableColumn opt_ctvPercentDelivero;
    @FXML
    private TableColumn us_tvPercentUber;
    @FXML
    private TableColumn us_tvPercentDelivero;
    @FXML
    private TableColumn us_tvPercentJustEat;
    @FXML
    private TableColumn opt_ctvPercentJustEat;
    @FXML
    private TableColumn ctgOpt_ctvPercentJustEat;
    @FXML
    private TableColumn pdt_ctvPercentJustEat;
    @FXML
    private TableColumn ctg_ctvPercentJustEat;
    @FXML
    private TableColumn us_tvPercentDrive;
    @FXML
    private TableColumn opt_ctvPercentDrive;
    @FXML
    private TableColumn ctgOpt_ctvPercentDrive;
    @FXML
    private TableColumn pdt_ctvPercentDrive;
    @FXML
    private TableColumn ctg_ctvPercentDrive;
    @FXML
    private TableColumn us_tvPercentSmood;
    @FXML
    private TableColumn opt_ctvPercentSmood;
    @FXML
    private TableColumn ctgOpt_ctvPercentSmood;
    @FXML
    private TableColumn pdt_ctvPercentSmood;
    @FXML
    private TableColumn ctg_ctvPercentSmood;
    private final String COMBOBOX_PLACEHOLDER = "Filtrer par cat\u00e9gorie";
    final IntegerProperty vValueProperty = new SimpleIntegerProperty(0);
    final int steps = 5;
    private String default_view = "day";
    private Date date_start = Calendar.getInstance().getTime();
    private Date date_end = Calendar.getInstance().getTime();
    private Calendar calendar_helper = Calendar.getInstance();
    private Map<String, String> paymentTypes = new LinkedHashMap<String, String>();
    private Map<String, Long> m_keysLineChart = new LinkedHashMap<String, Long>();
    private Stage m_loader;
    private boolean is_needToUpdateView = true;
    private boolean is_tabCA_loaded = false;
    private boolean is_tabProducts_loaded = false;
    private boolean is_tabOptions_loaded = false;
    private boolean is_tabCaissier_loaded = false;
    private String TEXT_TAB_CA = "CA";
    private String TEXT_TAB_PRODUCT = "Produit";
    private String TEXT_TAB_OPTION = "Option";
    private String TEXT_TAB_CAISSIER = "Caissier";
    private String SHIFT_1 = "00h-06h";
    private String SHIFT_2 = "06h-14h";
    private String SHIFT_3 = "14h-19h";
    private String SHIFT_4 = "19h-00h";
    private List<RankProduct> items;

    @Override
    public void initialize(AppView app, Scene scene) throws BasicException {
        this.m_App = app;
        this.m_scene = scene;
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.dao.DataLogicSystem");
        this.dlStats = (DataLogicStats)this.m_App.getBean("com.openbravo.dao.DataLogicStats");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        if (AppLocal.licence != null && AppLocal.licence.equals("venteDetail")) {
            this.isVersion_RetailSale = true;
        }
        this.actionMenuFilterDate.setAutoHide(false);
        this.datePickerFilter.setShowWeekNumbers(false);
        this.datePickerFilter.setValue((Object)LocalDate.now());
        this.setButtonFilterText("Jour");
        this.paneRoot.vvalueProperty().bind((ObservableValue)this.vValueProperty);
        this.paymentTypes.put(AppConstants.PAYMENT_MODE.CASH.getName(), "cash");
        this.paymentTypes.put("CB", "CB");
        this.paymentTypes.put("Ch\u00e8que", "cheque");
        if (!this.isVersion_RetailSale) {
            this.paymentTypes.put("TR", AppConstants.PAYMENT_MODE.TICKET_RESTO.getName());
        }
        this.paymentTypes.put("Avoir", "Avoir");
        this.paymentTypes.put("Cashdro", "Cashdro");
        this.paymentTypes.put("Debit", "Debit");
        this.paymentTypes.put("Cr\u00e9dit Employ\u00e9", "Cr\u00e9dit Employ\u00e9");
        this.paymentTypes.put("Carte Fid\u00e9lit\u00e9", "Carte Fid\u00e9lit\u00e9");
        this.paymentTypes.put("Cash Glory", "cashGlory");
        this.paymentTypes.put("Virement", "Virement");
        this.paymentTypes.put("Twint", "Twint");
        this.paymentTypes.put("Cheque vacances", "Ch\u00e8que vacances");
        this.paneRoot.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.turnoverLabel.setMaxWidth(Double.MAX_VALUE);
        this.turnoverLabel.setTextAlignment(TextAlignment.CENTER);
        this.pmValueLabel.setMaxWidth(Double.MAX_VALUE);
        this.pmValueLabel.setTextAlignment(TextAlignment.CENTER);
        this.pmPercentLabel.setMaxWidth(Double.MAX_VALUE);
        this.pmPercentLabel.setTextAlignment(TextAlignment.CENTER);
        this.ctg_ctvCategoryName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.ctg_ctvQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.ctg_ctvTurnover.setCellValueFactory((Callback)new PropertyValueFactory("turnover"));
        if (!this.isVersion_RetailSale) {
            this.ctg_ctvPercentAtSpot.setCellValueFactory((Callback)new PropertyValueFactory("s_percentAtSpot"));
            this.ctg_ctvPercentTakeAway.setCellValueFactory((Callback)new PropertyValueFactory("s_percentTakeAway"));
            this.ctg_ctvPercentDelivery.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivery"));
            if (AppLocal.MODULE_PLATFORM) {
                this.ctg_ctvPercentUber.setCellValueFactory((Callback)new PropertyValueFactory("s_percentUber"));
                this.ctg_ctvPercentDelivero.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivero"));
                this.ctg_ctvPercentJustEat.setCellValueFactory((Callback)new PropertyValueFactory("s_percentJustEat"));
                this.ctg_ctvPercentSmood.setCellValueFactory((Callback)new PropertyValueFactory("s_percentSmood"));
            }
            if (AppLocal.MODULE_DRIVE) {
                this.ctg_ctvPercentDrive.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDrive"));
            }
        }
        this.tableViewCategories.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.pdt_ctvProduitName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.pdt_ctvCategoryName.setCellValueFactory((Callback)new PropertyValueFactory("category"));
        this.pdt_ctvQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.pdt_ctvTurnover.setCellValueFactory((Callback)new PropertyValueFactory("turnover"));
        if (!this.isVersion_RetailSale) {
            this.pdt_ctvPercentAtSpot.setCellValueFactory((Callback)new PropertyValueFactory("s_percentAtSpot"));
            this.pdt_ctvPercentTakeAway.setCellValueFactory((Callback)new PropertyValueFactory("s_percentTakeAway"));
            this.pdt_ctvPercentDelivery.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivery"));
            if (AppLocal.MODULE_PLATFORM) {
                this.pdt_ctvPercentUber.setCellValueFactory((Callback)new PropertyValueFactory("s_percentUber"));
                this.pdt_ctvPercentDelivero.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivero"));
                this.pdt_ctvPercentJustEat.setCellValueFactory((Callback)new PropertyValueFactory("s_percentJustEat"));
                this.pdt_ctvPercentSmood.setCellValueFactory((Callback)new PropertyValueFactory("s_percentSmood"));
            }
            if (AppLocal.MODULE_DRIVE) {
                this.pdt_ctvPercentDrive.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDrive"));
            }
        }
        this.tableViewProduits.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        if (!this.isVersion_RetailSale) {
            this.ctgOpt_ctvCategoryName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            this.ctgOpt_ctvQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
            this.ctgOpt_ctvTurnover.setCellValueFactory((Callback)new PropertyValueFactory("turnover"));
            this.ctgOpt_ctvPercentAtSpot.setCellValueFactory((Callback)new PropertyValueFactory("s_percentAtSpot"));
            this.ctgOpt_ctvPercentTakeAway.setCellValueFactory((Callback)new PropertyValueFactory("s_percentTakeAway"));
            this.ctgOpt_ctvPercentDelivery.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivery"));
            if (AppLocal.MODULE_PLATFORM) {
                this.ctgOpt_ctvPercentUber.setCellValueFactory((Callback)new PropertyValueFactory("s_percentUber"));
                this.ctgOpt_ctvPercentDelivero.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivero"));
                this.ctgOpt_ctvPercentJustEat.setCellValueFactory((Callback)new PropertyValueFactory("s_percentJustEat"));
                this.ctgOpt_ctvPercentSmood.setCellValueFactory((Callback)new PropertyValueFactory("s_percentSmood"));
            }
            if (AppLocal.MODULE_DRIVE) {
                this.ctgOpt_ctvPercentDrive.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDrive"));
            }
            this.tableViewCategoriesOption.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        }
        if (!this.isVersion_RetailSale) {
            this.opt_ctvOptionName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            this.opt_ctvCategoryName.setCellValueFactory((Callback)new PropertyValueFactory("category"));
            this.opt_ctvQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
            this.opt_ctvTurnover.setCellValueFactory((Callback)new PropertyValueFactory("turnover"));
            this.opt_ctvPercentAtSpot.setCellValueFactory((Callback)new PropertyValueFactory("s_percentAtSpot"));
            this.opt_ctvPercentTakeAway.setCellValueFactory((Callback)new PropertyValueFactory("s_percentTakeAway"));
            this.opt_ctvPercentDelivery.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivery"));
            if (AppLocal.MODULE_PLATFORM) {
                this.opt_ctvPercentUber.setCellValueFactory((Callback)new PropertyValueFactory("s_percentUber"));
                this.opt_ctvPercentDelivero.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivero"));
                this.opt_ctvPercentJustEat.setCellValueFactory((Callback)new PropertyValueFactory("s_percentJustEat"));
                this.opt_ctvPercentSmood.setCellValueFactory((Callback)new PropertyValueFactory("s_percentSmood"));
            }
            if (AppLocal.MODULE_DRIVE) {
                this.opt_ctvPercentDrive.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDrive"));
            }
            this.tableViewItemOption.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        }
        this.us_tvName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.us_tvTurnover.setCellValueFactory((Callback)new PropertyValueFactory("s_turnover"));
        if (!this.isVersion_RetailSale) {
            this.us_tvPercentAtSpot.setCellValueFactory((Callback)new PropertyValueFactory("s_percentAtSpot"));
            this.us_tvPercentTakeAway.setCellValueFactory((Callback)new PropertyValueFactory("s_percentTakeAway"));
            this.us_tvPercentDelivery.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivery"));
            if (AppLocal.MODULE_PLATFORM) {
                this.us_tvPercentUber.setCellValueFactory((Callback)new PropertyValueFactory("s_percentUber"));
                this.us_tvPercentDelivero.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDelivero"));
                this.us_tvPercentJustEat.setCellValueFactory((Callback)new PropertyValueFactory("s_percentJustEat"));
                this.us_tvPercentSmood.setCellValueFactory((Callback)new PropertyValueFactory("s_percentSmood"));
            }
            if (AppLocal.MODULE_DRIVE) {
                this.us_tvPercentDrive.setCellValueFactory((Callback)new PropertyValueFactory("s_percentDrive"));
            }
        }
        this.tableViewUsers.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        if (!this.isVersion_RetailSale) {
            this.to_ctvTypeOrderName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            this.to_ctvTypeOrderCount.setCellValueFactory((Callback)new PropertyValueFactory("scount_percent"));
            this.to_ctvTypeOrderCa.setCellValueFactory((Callback)new PropertyValueFactory("sca_percent"));
            this.to_ctvTypeOrderTotal.setCellValueFactory((Callback)new PropertyValueFactory("count"));
            this.tableViewTypeOrder.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        }
        if (!this.isVersion_RetailSale) {
            this.comboBoxOptions.setPromptText("Filtrer par cat\u00e9gorie");
            this.comboBoxOptions.valueProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                    try {
                        String cName = null;
                        if (newValue != null) {
                            cName = (String)newValue;
                        }
                        if (cName != null && cName.equals("Filtrer par cat\u00e9gorie")) {
                            cName = null;
                        }
                        List<RankProduct> m_resultOptions = StatsController.this.dlStats.getRankOptions(StatsController.this.date_start, StatsController.this.date_end, cName);
                        StatsController.this.items = m_resultOptions;
                        StatsController.this.initRankOptions(m_resultOptions);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
        this.comboBoxItems.setPromptText("Filtrer par cat\u00e9gorie");
        this.comboBoxItems.valueProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                try {
                    String cName = null;
                    if (newValue != null) {
                        cName = (String)newValue;
                    }
                    if (cName != null && cName.equals("Filtrer par cat\u00e9gorie")) {
                        cName = null;
                    }
                    List<RankProduct> m_resultProducts = StatsController.this.dlStats.getRankItems(StatsController.this.date_start, StatsController.this.date_end, cName);
                    StatsController.this.initRankProducts(m_resultProducts);
                    StatsController.this.items = m_resultProducts;
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
        this.tabber.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> ov, Tab oldTab, Tab newTab) {
                StatsController.this.loadTabActive(newTab.getText());
            }
        });
        this.defineDates();
        this.initializeData();
    }

    @Override
    public void initalizeAction() {
        this.btnFilterDate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Button me = (Button)event.getSource();
                Bounds boundsInScene = StatsController.this.btnFilterDate.localToScene(StatsController.this.btnFilterDate.getBoundsInLocal());
                double x = boundsInScene.getMaxX();
                double y = boundsInScene.getMinY();
                if (!StatsController.this.actionMenuFilterDate.isShowing()) {
                    StatsController.this.actionMenuFilterDate.show((Node)me, Side.BOTTOM, -50.0, 5.0);
                } else {
                    StatsController.this.actionMenuFilterDate.hide();
                }
            }
        });
        this.datePickerFilter.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StatsController.this.defineDates();
                StatsController.this.initializeData();
                if (!StatsController.this.datePickerFilter.isShowing()) {
                    StatsController.this.datePickerFilter.show();
                } else {
                    StatsController.this.datePickerFilter.hide();
                }
            }
        });
    }

    private void defineDates() {
        LocalDate datePickerValue = (LocalDate)this.datePickerFilter.getValue();
        Date dateCurrent = DateUtils.asDate(datePickerValue);
        this.m_keysLineChart.clear();
        this.is_needToUpdateView = true;
        this.is_tabCA_loaded = false;
        this.is_tabProducts_loaded = false;
        this.is_tabOptions_loaded = false;
        this.is_tabCaissier_loaded = false;
        switch (this.default_view) {
            case "week": {
                this.calendar_helper.setTime(dateCurrent);
                int dayOfWeek = this.calendar_helper.get(7) - this.calendar_helper.getFirstDayOfWeek();
                this.calendar_helper.add(5, -dayOfWeek);
                this.date_start = this.calendar_helper.getTime();
                DateUtils.setDateWeek(this.date_start, this.date_end);
                DateUtils.fillDaysOfWeek(this.m_keysLineChart, this.date_start, this.date_end);
                break;
            }
            case "month": {
                this.calendar_helper.setTime(dateCurrent);
                this.calendar_helper.set(5, this.calendar_helper.getActualMinimum(5));
                this.date_start = this.calendar_helper.getTime();
                this.date_end = new Date();
                DateUtils.setDateMonths(this.date_start, this.date_end);
                DateUtils.fillDaysOfMonth(this.m_keysLineChart, this.date_start, this.date_end);
                break;
            }
            case "year": {
                this.calendar_helper.setTime(dateCurrent);
                this.calendar_helper.set(6, 1);
                this.date_start = this.calendar_helper.getTime();
                this.date_end = new Date();
                DateUtils.setDateYears(this.date_start, this.date_end);
                DateUtils.fillMonthsOfYear(this.m_keysLineChart, this.date_start, this.date_end);
                break;
            }
            default: {
                this.date_start = (Date)dateCurrent.clone();
                this.date_end = (Date)dateCurrent.clone();
                DateUtils.setDateHours(this.date_start, this.date_end);
                DateUtils.fillHours(this.m_keysLineChart, this.date_start);
            }
        }
    }

    private void openLoader() {
        if (this.m_loader == null) {
            this.m_loader = new Stage();
            this.m_loader.initModality(Modality.APPLICATION_MODAL);
            this.m_loader.setWidth(this.m_scene.getWidth());
            this.m_loader.setHeight(this.m_scene.getHeight());
            this.m_loader.initOwner(this.m_scene.getWindow());
            try {
                Parent root_loader = (Parent)FXMLLoader.load((URL)this.getClass().getResource("/fx/templates/loader/popup_loader.fxml"));
                Scene scene_loader = new Scene(root_loader);
                scene_loader.getStylesheets().add((Object)"/styles/styles.css");
                scene_loader.getStylesheets().add((Object)"/styles/helpers.css");
                scene_loader.getStylesheets().add((Object)"/styles/app.css");
                scene_loader.setFill((Paint)Color.TRANSPARENT);
                this.m_loader.setScene(scene_loader);
                this.m_loader.setTitle("Chargement ...");
                this.m_loader.setAlwaysOnTop(true);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (this.m_loader != null && this.m_loader.getScene() != null) {
            this.m_loader.show();
        }
    }

    private void closeLoader() {
        if (this.m_loader != null) {
            this.m_loader.hide();
        }
    }

    private void loadTabActive(String tab_name) {
        if (tab_name.equals(this.TEXT_TAB_CA)) {
            this.initTabCA();
        } else if (tab_name.equals(this.TEXT_TAB_PRODUCT)) {
            this.initTabProduct();
        } else if (tab_name.equals(this.TEXT_TAB_OPTION)) {
            this.initTabOption();
        } else if (tab_name.equals(this.TEXT_TAB_CAISSIER)) {
            this.initTabCaissier();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initTabCA() {
        if (this.is_needToUpdateView && !this.is_tabCA_loaded) {
            try {
                BigDecimal turnover = this.dlStats.getTotalPaymentBetween(this.date_start, this.date_end);
                this.calendar_helper.setTime(this.date_start);
                this.calendar_helper.add(this.periode, -this.incrementPeriode);
                BigDecimal oldTurnover = this.dlStats.getTotalPaymentBetween(this.calendar_helper.getTime(), this.date_start);
                this.turnoverLabel.setText(Formats.CURRENCY.formatValue(turnover));
                if (!AppLocal.isVersionRetailSale().booleanValue()) {
                    this.oldTurnoverLabel.setText(oldTurnover.compareTo(BigDecimal.ZERO) > 0 ? NumericUtils.round(turnover.subtract(oldTurnover).divide(oldTurnover, 3).doubleValue() * 100.0) + "%" : NumericUtils.round(turnover.doubleValue()) + "%");
                    if (oldTurnover.compareTo(turnover) < 0) {
                        this.oldTurnoverLabel.setText("+" + this.oldTurnoverLabel.getText());
                        this.oldTurnoverLabel.setStyle("-fx-text-fill: green;");
                    } else {
                        this.oldTurnoverLabel.setStyle("-fx-text-fill: red;");
                    }
                    ClickTooltip ev = new ClickTooltip((Node)this.oldTurnoverLabel, "", 0, "Taux de variation par rapport " + (this.default_view.equals("day") ? "\u00e0 hier" : (this.default_view.equals("week") ? "\u00e0 la semaine pr\u00e9cidente" : (this.default_view.equals("month") ? "au mois pr\u00e9cident" : (this.default_view.equals("year") ? "\u00e0 l'ann\u00e9e pr\u00e9cidente" : "\u00e0 la p\u00e9riode pr\u00e9cidente")))));
                    this.oldTurnoverLabel.setOnMouseEntered((EventHandler)ev);
                    this.oldTurnoverLabel.setOnMouseClicked((EventHandler)ev);
                    this.oldTurnoverLabel.setOnMouseExited((EventHandler)ev);
                }
                ProfitMargin m_pm = this.dlStats.geProfitMarginByDate(this.date_start, this.date_end);
                this.pmValueLabel.setText(Formats.CURRENCY.formatValue(m_pm.getValueMargin()));
                Double m_percent = NumericUtils.getPercent(turnover.doubleValue(), m_pm.getValueMargin());
                Integer v_percent = m_percent.intValue();
                this.pmPercentLabel.setText(NumericUtils.formatToStringPercent(v_percent));
                HashMap<String, BigDecimal> m_valuesPaymentType = new HashMap<String, BigDecimal>();
                for (Map.Entry<String, String> entry : this.paymentTypes.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    BigDecimal turnoverTypePayment = this.dlStats.getTurnoverByDatePaymentType(this.date_start, this.date_end, value);
                    m_valuesPaymentType.put(key, turnoverTypePayment);
                }
                this.initDonuChart(m_valuesPaymentType);
                List<Object> salesByView = new ArrayList();
                switch (this.default_view) {
                    case "week": {
                        salesByView = this.dlStats.loadSatisticByWeek(this.date_start, this.date_end, false);
                        break;
                    }
                    case "month": {
                        salesByView = this.dlStats.loadSatisticByMonth(this.date_start, this.date_end, false);
                        break;
                    }
                    case "year": {
                        salesByView = this.dlStats.loadSatisticByYear(this.date_start, this.date_end, false);
                        break;
                    }
                    default: {
                        salesByView = this.dlStats.loadSatisticByHour(this.date_start, this.date_end, false);
                    }
                }
                this.initLineChart(this.sanitizeDataLineChart(salesByView));
                this.totalOrdersLabel.setText("0 Commandes");
                if (!this.isVersion_RetailSale) {
                    List<RankTypeOrder> list = this.dlStats.loadSatisticOrderByType(this.date_start, this.date_end, false);
                    if (list.size() > 0) {
                        this.totalOrdersLabel.setText(list.get(0).getTotal() + " Commandes");
                    }
                    this.initRankTypeOrder(list);
                } else {
                    Integer n = this.dlStats.getCountOrderByDate(this.date_start, this.date_end);
                    if (n > 0) {
                        this.totalOrdersLabel.setText(String.valueOf(n) + " Commandes");
                    }
                }
                if (!AppLocal.isVersionRetailSale().booleanValue()) {
                    void var8_16;
                    HashMap hashMap = new HashMap();
                    if (this.default_view == "day") {
                        Map<String, Double> map = this.dlStats.loadSatisticShiftByDay(this.date_start, this.date_end);
                    }
                    this.initBarChartShift((Map<String, Double>)var8_16);
                }
                this.is_tabCA_loaded = true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void initTabProduct() {
        if (this.is_needToUpdateView && !this.is_tabProducts_loaded) {
            try {
                List<RankCategory> m_resultCategories = this.dlStats.getRankCategories(this.date_start, this.date_end, false);
                this.initRankCategories(m_resultCategories);
                this.initPieChartCategories(m_resultCategories);
                List<RankProduct> m_resultProducts = this.dlStats.getRankItems(this.date_start, this.date_end, null);
                this.items = m_resultProducts;
                this.initRankProducts(m_resultProducts);
                this.is_tabProducts_loaded = true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void initTabOption() {
        if (this.is_needToUpdateView && !this.is_tabOptions_loaded) {
            try {
                if (!this.isVersion_RetailSale) {
                    List<RankCategory> m_resultCategoriesOption = this.dlStats.getRankCategoriesOption(this.date_start, this.date_end);
                    this.initRankCategoriesOption(m_resultCategoriesOption);
                    this.initPieChartCategoriesOption(m_resultCategoriesOption);
                    List<RankProduct> m_resultOptions = this.dlStats.getRankOptions(this.date_start, this.date_end, null);
                    this.items = m_resultOptions;
                    this.initRankOptions(m_resultOptions);
                }
                this.is_tabOptions_loaded = true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void initTabCaissier() {
        if (this.is_needToUpdateView && !this.is_tabCaissier_loaded) {
            try {
                List<RankUser> m_resultUsers = this.dlStats.getRankUsers(this.date_start, this.date_end);
                this.initRankUsers(m_resultUsers);
                this.initPieChartUsers(m_resultUsers);
                this.is_tabCaissier_loaded = true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void doSetDateOnView() {
        this.loadTabActive(((Tab)this.tabber.getSelectionModel().getSelectedItem()).getText());
    }

    private void initializeData() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        StatsController.this.doSetDateOnView();
                    }
                });
                return null;
            }
        };
        Platform.runLater((Runnable)new Runnable(){
            final /* synthetic */ Task val$task;
            {
                this.val$task = task;
            }

            @Override
            public void run() {
                new Thread((Runnable)this.val$task).start();
            }
        });
    }

    private Map<String, LineChartModel> sanitizeDataLineChart(List m_data) {
        LinkedHashMap<String, LineChartModel> m_series_sales = new LinkedHashMap<String, LineChartModel>();
        Calendar calendar = Calendar.getInstance();
        Calendar m_calendar = Calendar.getInstance();
        block10: for (Map.Entry<String, Long> entry : this.m_keysLineChart.entrySet()) {
            String key = entry.getKey();
            Long time = entry.getValue();
            calendar.setTimeInMillis(time);
            m_series_sales.put(key, new LineChartModel());
            switch (this.default_view) {
                case "week": {
                    for (Object next : m_data) {
                        m_calendar.clear();
                        m_calendar.setTime(((DayDateInfo)next).getHour());
                        m_series_sales.replace(DateUtils.formatDay(m_calendar.getTime(), "EEEE"), new LineChartModel(((DayDateInfo)next).getTurnover(), ((DayDateInfo)next).getOrders()));
                    }
                    continue block10;
                }
                case "month": {
                    for (Object next : m_data) {
                        m_calendar.clear();
                        m_calendar.setTimeInMillis(time);
                        m_calendar.set(5, ((IntegerDateInfo)next).getValue());
                        m_series_sales.replace(DateUtils.formatDay(m_calendar.getTime(), "dd"), new LineChartModel(((IntegerDateInfo)next).getTurnover(), ((IntegerDateInfo)next).getOrders()));
                    }
                    continue block10;
                }
                case "year": {
                    for (Object next : m_data) {
                        m_calendar.clear();
                        m_calendar.setTimeInMillis(time);
                        m_calendar.set(2, ((IntegerDateInfo)next).getValue() - 1);
                        m_series_sales.replace(DateUtils.formatMonth(m_calendar.getTime()), new LineChartModel(((IntegerDateInfo)next).getTurnover(), ((IntegerDateInfo)next).getOrders()));
                    }
                    continue block10;
                }
                default: {
                    for (Object next : m_data) {
                        m_calendar.clear();
                        m_calendar.setTimeInMillis(time);
                        m_calendar.set(11, ((HourInfo)next).getHour());
                        m_series_sales.replace(DateUtils.formatHour(m_calendar.getTime()), new LineChartModel(((HourInfo)next).getTurnover(), ((HourInfo)next).getOrders()));
                    }
                    continue block10;
                }
            }
        }
        return m_series_sales;
    }

    private void initLineChart(Map<String, LineChartModel> m_series_sales) {
        Node node;
        this.paneLineChart.getChildren().clear();
        CategoryAxis xAxis = new CategoryAxis();
        NumberAxis yAxis = new NumberAxis();
        xAxis.setLabel(this.getLabelByView());
        LineChart lineChart = new LineChart((Axis)xAxis, (Axis)yAxis);
        XYChart.Series series_turnover = new XYChart.Series();
        XYChart.Series series_orders = new XYChart.Series();
        for (Map.Entry<String, LineChartModel> entry : m_series_sales.entrySet()) {
            String key = entry.getKey();
            LineChartModel m = entry.getValue();
            series_turnover.getData().add((Object)new XYChart.Data((Object)key, (Object)m.getTurnover()));
            series_orders.getData().add((Object)new XYChart.Data((Object)key, (Object)m.getTotal()));
        }
        lineChart.setLegendVisible(false);
        lineChart.setPrefWidth(this.paneLineChart.getPrefWidth());
        lineChart.getData().add((Object)series_turnover);
        lineChart.getData().add((Object)series_orders);
        this.paneLineChart.getChildren().setAll((Object[])new Node[]{lineChart});
        String rgbColor = String.format("%d, %d, %d", 118, 221, 251);
        String styleLine = "-fx-stroke: rgba(" + rgbColor + ", 1.0);";
        String symbolStyle = "-fx-background-color: rgba(" + rgbColor + ", 1.0), whitesmoke;";
        series_turnover.getNode().lookup(".chart-series-line").setStyle(styleLine);
        for (XYChart.Data data : series_turnover.getData()) {
            node = data.getNode().lookup(".chart-line-symbol");
            node.setStyle(symbolStyle);
            EventMouseChartLine m_event = new EventMouseChartLine(node, (String)data.getXValue(), (Number)data.getYValue(), Formats.CURRENCY.formatValue(data.getYValue()));
            node.setOnMouseEntered((EventHandler)m_event);
            node.setOnMouseClicked((EventHandler)m_event);
            node.setOnMouseExited((EventHandler)m_event);
        }
        for (XYChart.Data data : series_orders.getData()) {
            node = data.getNode().lookup(".chart-line-symbol");
            String m_title = String.valueOf((Integer)data.getYValue());
            EventMouseChartLine m_event = new EventMouseChartLine(node, (String)data.getXValue(), (Number)data.getYValue(), m_title);
            node.setOnMouseEntered((EventHandler)m_event);
            node.setOnMouseClicked((EventHandler)m_event);
            node.setOnMouseExited((EventHandler)m_event);
        }
    }

    private void initBarChartShift(Map<String, Double> m_series_shift) {
        if (this.paneBarChartShift != null) {
            this.paneBarChartShift.getChildren().clear();
            if (this.default_view == "day") {
                CategoryAxis xAxis = new CategoryAxis();
                NumberAxis yAxis = new NumberAxis();
                BarChart bc = new BarChart((Axis)xAxis, (Axis)yAxis);
                bc.setTitle("Chiffre d'affaire par shift");
                xAxis.setLabel("Shift");
                yAxis.setLabel("CA");
                XYChart.Series series = new XYChart.Series();
                series.setName("CA");
                for (Map.Entry<String, Double> entry : m_series_shift.entrySet()) {
                    String key = entry.getKey();
                    Double value = entry.getValue();
                    final XYChart.Data mData = new XYChart.Data((Object)key, (Object)value);
                    mData.nodeProperty().addListener((ChangeListener)new ChangeListener<Node>(){

                        public void changed(ObservableValue<? extends Node> ov, Node oldNode, Node node) {
                            if (node != null) {
                                StatsController.this.displayLabelForBarLineData((XYChart.Data<String, Number>)mData);
                            }
                        }
                    });
                    series.getData().add((Object)mData);
                }
                bc.getData().addAll((Object[])new XYChart.Series[]{series});
                this.paneBarChartShift.getChildren().setAll((Object[])new Node[]{bc});
            } else {
                Label mLabel = new Label("Les statistique par shift sont disponible que par jour :(");
                this.paneBarChartShift.getChildren().add((Object)mLabel);
            }
        }
    }

    private ObservableList<PieChart.Data> createDataDonuChart(Map<String, BigDecimal> data) {
        ArrayList<PieChart.Data> arrays = new ArrayList<PieChart.Data>();
        for (Map.Entry<String, BigDecimal> entry : data.entrySet()) {
            String key = entry.getKey();
            BigDecimal value = entry.getValue();
            arrays.add(new PieChart.Data(key, value.doubleValue()));
        }
        return FXCollections.observableArrayList(arrays);
    }

    private void initDonuChart(Map<String, BigDecimal> data) {
        ObservableList<PieChart.Data> pieChartData = this.createDataDonuChart(data);
        DoughnutChart chart = new DoughnutChart(pieChartData, true);
        this.paneDonuChart.getChildren().clear();
        this.paneDonuChart.getChildren().add((Object)chart);
        StackPane.setAlignment((Node)chart, (Pos)Pos.CENTER);
    }

    private void initRankCategories(List<RankCategory> rows) {
        ObservableList data = FXCollections.observableArrayList(rows);
        this.tableViewCategories.getItems().clear();
        this.tableViewCategories.setItems(data);
        ArrayList<String> categories_names = new ArrayList<String>();
        if (rows.size() > 0) {
            categories_names.add("Filtrer par cat\u00e9gorie");
        }
        for (RankCategory next : rows) {
            categories_names.add(next.getName());
        }
        this.comboBoxItems.getItems().clear();
        this.comboBoxItems.getItems().addAll(categories_names);
    }

    private void initRankProducts(List<RankProduct> rows) {
        ObservableList data = FXCollections.observableArrayList(rows);
        this.tableViewProduits.getItems().clear();
        this.tableViewProduits.setItems(data);
    }

    private void initRankCategoriesOption(List<RankCategory> rows) {
        ObservableList data = FXCollections.observableArrayList(rows);
        this.tableViewCategoriesOption.getItems().clear();
        this.tableViewCategoriesOption.setItems(data);
        ArrayList<String> categories_names = new ArrayList<String>();
        if (rows.size() > 0) {
            categories_names.add("Filtrer par cat\u00e9gorie");
        }
        for (RankCategory next : rows) {
            categories_names.add(next.getName());
        }
        this.comboBoxOptions.getItems().clear();
        this.comboBoxOptions.getItems().addAll(categories_names);
    }

    private void initRankOptions(List<RankProduct> rows) {
        ObservableList data = FXCollections.observableArrayList(rows);
        this.tableViewItemOption.getItems().clear();
        this.tableViewItemOption.setItems(data);
    }

    private void initRankUsers(List<RankUser> rows) {
        ObservableList data = FXCollections.observableArrayList(rows);
        this.tableViewUsers.getItems().clear();
        this.tableViewUsers.setItems(data);
    }

    private void initRankTypeOrder(List<RankTypeOrder> rows) {
        ObservableList data = FXCollections.observableArrayList(rows);
        this.tableViewTypeOrder.getItems().clear();
        this.tableViewTypeOrder.setItems(data);
        this.hideHbarTableView(this.tableViewTypeOrder);
        this.hideVbarTableView(this.tableViewTypeOrder);
    }

    private void initPieChartUsers(List<RankUser> rows) {
        this.apPartsUsers.getChildren().clear();
        this.apPartsUsers.applyCss();
        this.apPartsUsers.layout();
        LinkedHashMap<String, BigDecimal> data = new LinkedHashMap<String, BigDecimal>();
        for (RankUser next : rows) {
            String turnover = next.getTurnover().replace(",", ".");
            data.put(next.getName(), new BigDecimal(turnover));
        }
        if (data.size() > 0) {
            ObservableList<PieChart.Data> pieChartData = this.createDataDonuChart(data);
            DoughnutChart chart = new DoughnutChart(pieChartData);
            chart.setPrefSize(this.apPartsUsers.getPrefWidth(), this.apPartsUsers.getPrefHeight());
            this.apPartsUsers.getChildren().add((Object)chart);
            StackPane.setAlignment((Node)chart, (Pos)Pos.CENTER);
        }
    }

    private void initPieChartCategoriesOption(List<RankCategory> rows) {
        this.apTopCategorieOptions.getChildren().clear();
        LinkedHashMap<String, BigDecimal> data = new LinkedHashMap<String, BigDecimal>();
        for (RankCategory next : rows) {
            data.put(next.getName(), new BigDecimal(next.getQuantity()));
        }
        if (data.size() > 0) {
            ObservableList<PieChart.Data> pieChartData = this.createDataDonuChart(data);
            DoughnutChart chart = new DoughnutChart(pieChartData);
            chart.setLegendVisible(true);
            chart.setPrefSize(this.apTopCategorieOptions.getPrefWidth(), this.apTopCategorieOptions.getPrefHeight());
            this.apTopCategorieOptions.getChildren().add((Object)chart);
            StackPane.setAlignment((Node)chart, (Pos)Pos.CENTER);
        }
    }

    private void initPieChartCategories(List<RankCategory> rows) {
        this.apTopCategoriesContent.getChildren().clear();
        LinkedHashMap<String, BigDecimal> data = new LinkedHashMap<String, BigDecimal>();
        for (RankCategory next : rows) {
            data.put(next.getName(), new BigDecimal(next.getQuantity()));
        }
        if (data.size() > 0) {
            ObservableList<PieChart.Data> pieChartData = this.createDataDonuChart(data);
            DoughnutChart chart = new DoughnutChart(pieChartData);
            chart.setLegendVisible(true);
            this.apTopCategoriesContent.getChildren().add((Object)chart);
            StackPane.setAlignment((Node)chart, (Pos)Pos.CENTER);
        }
    }

    private void setButtonFilterText(String text) {
        this.btnFilterDate.setText(text);
    }

    private void updateFilterView(String newValue) {
        switch (newValue) {
            case "Semaine": {
                this.default_view = "week";
                this.periode = 5;
                this.incrementPeriode = 7;
                break;
            }
            case "Mois": {
                this.default_view = "month";
                this.periode = 2;
                this.incrementPeriode = 1;
                break;
            }
            case "Ann\u00e9e": {
                this.default_view = "year";
                this.periode = 1;
                this.incrementPeriode = 1;
                break;
            }
            default: {
                this.default_view = "day";
                this.periode = 5;
                this.incrementPeriode = 1;
            }
        }
    }

    private String getLabelByView() {
        return switch (this.default_view) {
            case "week" -> "P\u00e9riode : " + DateUtils.formatDay(this.date_start, "dd") + " " + DateUtils.formatMonth(this.date_start) + " " + DateUtils.formatYear(this.date_start) + " - " + DateUtils.formatDay(this.date_end, "dd") + " " + DateUtils.formatMonth(this.date_end) + " " + DateUtils.formatYear(this.date_end);
            case "month" -> "Mois : " + DateUtils.formatMonth(this.date_start) + " " + DateUtils.formatYear(this.date_start);
            case "year" -> "Ann\u00e9e : " + DateUtils.formatYear(this.date_start);
            default -> DateUtils.formatDay(this.date_end, "dd") + " " + DateUtils.formatMonth(this.date_end) + " " + DateUtils.formatYear(this.date_end);
        };
    }

    public void handleFilterType(ActionEvent event) {
        RadioMenuItem m_radio = (RadioMenuItem)event.getSource();
        if (m_radio != null) {
            this.setButtonFilterText(m_radio.getText());
            this.updateFilterView(m_radio.getText());
            this.defineDates();
            this.initializeData();
        }
    }

    private void hideHbarTableView(TableView tableView) {
        try {
            ScrollBar scrollBarH = (ScrollBar)tableView.lookup(".scroll-bar:hotizontal");
            if (scrollBarH != null) {
                scrollBarH.setVisible(false);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void hideVbarTableView(TableView tableView) {
        try {
            ScrollBar scrollBarV = (ScrollBar)tableView.lookup(".scroll-bar:vertical");
            if (scrollBarV != null) {
                scrollBarV.setVisible(false);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void initializer() {
        this.defineDates();
        this.initializeData();
    }

    public static void showTooltip(Stage owner, Control control, String tooltipText, ImageView tooltipGraphic) {
        Point2D p = control.localToScene(0.0, 0.0);
        Tooltip customTooltip = new Tooltip();
        customTooltip.setText(tooltipText);
        control.setTooltip(customTooltip);
        customTooltip.setAutoHide(true);
        customTooltip.show((Window)owner, p.getX() + control.getScene().getX() + control.getScene().getWindow().getX(), p.getY() + control.getScene().getY() + control.getScene().getWindow().getY());
    }

    private void displayLabelForBarLineData(XYChart.Data<String, Number> data) {
        Node node = data.getNode();
        final Text dataText = new Text(Formats.CURRENCY.formatValue(data.getYValue()));
        node.parentProperty().addListener((ChangeListener)new ChangeListener<Parent>(){

            public void changed(ObservableValue<? extends Parent> ov, Parent oldParent, Parent parent) {
                Group parentGroup = (Group)parent;
                parentGroup.getChildren().add((Object)dataText);
            }
        });
        node.boundsInParentProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds oldBounds, Bounds bounds) {
                dataText.setLayoutX((double)Math.round(bounds.getMinX() + bounds.getWidth() / 2.0 - dataText.prefWidth(-1.0) / 2.0));
                dataText.setLayoutY((double)Math.round(bounds.getMinY() - dataText.prefHeight(-1.0) * 0.5));
            }
        });
    }

    public void exportOptions() {
        this.exportItems("options");
    }

    public void exportProducts() {
        System.out.println("+++++++ items : " + this.items);
        this.exportItems("produits");
    }

    public void exportItems(String type_items) {
        System.out.println("++++++++ type_items : " + type_items);
        if (this.items != null) {
            try {
                Object fileName = type_items;
                if (this.default_view != null) {
                    switch (this.default_view) {
                        case "week": {
                            fileName = (String)fileName + " (" + DateUtils.formatDate(this.date_start) + ")";
                            break;
                        }
                        case "month": {
                            fileName = (String)fileName + " (" + DateUtils.formatMonth(this.date_start) + " " + DateUtils.formatYear(this.date_start) + ")";
                            break;
                        }
                        case "year": {
                            fileName = (String)fileName + " (" + DateUtils.formatYear(this.date_start) + ")";
                            break;
                        }
                        default: {
                            fileName = (String)fileName + " (" + DateUtils.formatDate(this.date_start) + ")";
                            break;
                        }
                    }
                } else {
                    fileName = (String)fileName + " (" + DateUtils.formatDate(this.date_start) + ")";
                }
                MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
                ExportItemsExcel mExportItemsExcel = new ExportItemsExcel();
                mExportItemsExcel.setComponentParent(null);
                fileName = (String)fileName + ".xlsx";
                mExportItemsExcel.setFileName((String)fileName);
                String $result = mExportItemsExcel.export(this.items, type_items, this.date_start, this.date_end, marqueNF);
                if ($result != null && !$result.equals("canceled")) {
                    try {
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les donn\u00e9es on \u00e9t\u00e9 export\u00e9 avec succ\u00e8s !", 1500, NPosition.BOTTOM_RIGHT);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

