/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.SwitchButton;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.service.OrderOnLineService;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.json.JSONObject;

public class SettingOnlineOrder
implements RootController {
    private Stage stage;
    @FXML
    GridPane pane_types;
    @FXML
    GridPane pane_auto_accept;
    private SwitchButton check_At_Spot;
    private SwitchButton check_Take_Away;
    private SwitchButton check_Delivery;
    private double width_sw = 55.0;
    private OrderOnLineService mOrderOnLineService;
    private SwitchButton check_auto_accept;
    private EventHandler mvEventStatusAutoAccept = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (SettingOnlineOrder.this.check_auto_accept.isState()) {
                SettingOnlineOrder.this.check_auto_accept.setOff();
            } else {
                SettingOnlineOrder.this.check_auto_accept.setOn();
            }
        }
    };

    public void initializer() throws URISyntaxException {
        double height_pane = AppVarUtils.getScreenDimension().getHeight() * 0.5;
        double width_pane = AppVarUtils.getScreenDimension().getWidth() * 0.5 * 0.9;
        this.check_At_Spot = new SwitchButton(this.width_sw, this.width_sw * 0.48);
        this.check_Take_Away = new SwitchButton(this.width_sw, this.width_sw * 0.48);
        this.check_Delivery = new SwitchButton(this.width_sw, this.width_sw * 0.48);
        this.check_auto_accept = new SwitchButton(this.width_sw, this.width_sw * 0.48);
        this.pane_types.setHgap(5.0);
        GridPane atSpot_Pane = new GridPane();
        GridPane take_Away_Pane = new GridPane();
        GridPane delivery_Pane = new GridPane();
        atSpot_Pane.setPrefHeight(height_pane * 0.25);
        atSpot_Pane.setPrefWidth(width_pane * 0.3);
        take_Away_Pane.setPrefHeight(height_pane * 0.25);
        take_Away_Pane.setPrefWidth(width_pane * 0.3);
        double with_label = width_pane * 0.2;
        Label atSpot_Label = new Label("Sur Place");
        atSpot_Label.setPrefWidth(with_label);
        Label take_Away_Label = new Label("Emporter");
        take_Away_Label.setPrefWidth(with_label);
        Label delivery_Label = new Label("Livraison");
        delivery_Label.setPrefWidth(with_label);
        atSpot_Pane.add((Node)this.check_At_Spot, 0, 0);
        atSpot_Pane.add((Node)atSpot_Label, 1, 0);
        take_Away_Pane.add((Node)this.check_Take_Away, 0, 0);
        take_Away_Pane.add((Node)take_Away_Label, 1, 0);
        delivery_Pane.setPrefHeight(height_pane * 0.25);
        delivery_Pane.setPrefWidth(width_pane * 0.3);
        delivery_Pane.add((Node)this.check_Delivery, 0, 0);
        delivery_Pane.add((Node)delivery_Label, 1, 0);
        this.pane_types.add((Node)atSpot_Pane, 0, 0);
        this.pane_types.add((Node)take_Away_Pane, 1, 0);
        this.pane_types.add((Node)delivery_Pane, 2, 0);
        this.check_At_Spot.setOnMouseClicked(this.mvEventStatusOnlineOrder(this.check_At_Spot));
        this.check_Take_Away.setOnMouseClicked(this.mvEventStatusOnlineOrder(this.check_Take_Away));
        this.check_Delivery.setOnMouseClicked(this.mvEventStatusOnlineOrder(this.check_Delivery));
        this.mOrderOnLineService = OrderOnLineService.getInstance(null);
        this.getOrdersTypes();
        Label auto_accept_label = new Label("Accepter les commandes pay\u00e9e en ligne automatiquement");
        auto_accept_label.setPrefWidth(width_pane * 0.7);
        this.pane_auto_accept.add((Node)this.check_auto_accept, 0, 0);
        this.pane_auto_accept.add((Node)auto_accept_label, 1, 0);
        this.check_auto_accept.setOnMouseClicked(this.mvEventStatusAutoAccept);
        if (AppLocal.AUTO_ACCEPT_ONLINE_ORDER) {
            this.check_auto_accept.setOn();
        } else {
            this.check_auto_accept.setOn();
        }
    }

    @Override
    public void init(Stage mStage) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SettingOnlineOrder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object object) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SettingOnlineOrder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        try {
            this.stage = mStage;
            this.initializer();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SettingOnlineOrder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void closePopUp() {
        this.stage.close();
    }

    public EventHandler mvEventStatusOnlineOrder(final SwitchButton btn) {
        EventHandler<MouseEvent> mvEventActiveOnlineOrder = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (btn.isState()) {
                    btn.setOff();
                } else {
                    btn.setOn();
                }
            }
        };
        return mvEventActiveOnlineOrder;
    }

    private void getOrdersTypes() {
        JSONObject data = this.mOrderOnLineService.getOrdersTypes();
        if (data != null) {
            if (!data.isNull("at_spot")) {
                boolean at_spot = data.getBoolean("at_spot");
                if (at_spot) {
                    this.check_At_Spot.setOn();
                } else {
                    this.check_At_Spot.setOff();
                }
            } else {
                this.check_At_Spot.setOff();
            }
            if (!data.isNull("take_away")) {
                boolean take_away = data.getBoolean("take_away");
                if (take_away) {
                    this.check_Take_Away.setOn();
                } else {
                    this.check_Take_Away.setOff();
                }
            } else {
                this.check_Take_Away.setOff();
            }
            if (!data.isNull("delivery")) {
                boolean delivery = data.getBoolean("delivery");
                if (delivery) {
                    this.check_Delivery.setOn();
                } else {
                    this.check_Delivery.setOff();
                }
            } else {
                this.check_Delivery.setOff();
            }
        } else {
            this.check_At_Spot.setOff();
            this.check_Take_Away.setOff();
            this.check_Delivery.setOff();
        }
    }

    public void valid() {
        this.mOrderOnLineService.setOrdersTypes(this.check_At_Spot.isState(), this.check_Take_Away.isState(), this.check_Delivery.isState());
        this.saveParams();
        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "les param\u00e8tres sont upload\u00e9.", 4000, NPosition.BOTTOM_RIGHT);
    }

    private void saveParams() {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig appConfig = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        appConfig.setProperty("auto.accept.online.order", this.check_auto_accept.isState() ? "yes" : "no");
        appConfig.save();
        AppLocal.AUTO_ACCEPT_ONLINE_ORDER = appConfig.getBooleanProperty("auto.accept.online.order");
    }
}

