/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.glory.fcc.service.BrueBoxServiceCallbackHandler;
import com.glory.fcc.service.BrueBoxServiceStub;
import com.glory.fcc.service.EventHandleClass;
import com.glory.fcc.service.FCCClient;
import com.glory.fcc.service.IUserInterface;
import com.openbravo.basic.BasicException;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.glory.POSSimple.Collect;
import fr.protactile.glory.POSSimple.Recovery;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.JOptionPane;
import org.jdom.Element;

public class SettingGloryController
implements IUserInterface {
    private AppView app;
    Scene scene;
    SettingGloryController me;
    @FXML
    private ImageView glory_billet;
    @FXML
    private ImageView glory_coin;
    @FXML
    private ImageView coin_verro;
    @FXML
    private ImageView note_verro;
    @FXML
    private TextField text_0_01;
    @FXML
    private TextField text_0_02;
    @FXML
    private TextField text_0_05;
    @FXML
    private TextField text_0_10;
    @FXML
    private TextField text_0_20;
    @FXML
    private TextField text_0_50;
    @FXML
    private TextField text_1;
    @FXML
    private TextField text_2;
    @FXML
    private TextField cofb;
    @FXML
    private Label label_0_01;
    @FXML
    private Label label_0_02;
    @FXML
    private Label label_0_05;
    @FXML
    private Label label_0_10;
    @FXML
    private Label label_0_20;
    @FXML
    private Label label_0_50;
    @FXML
    private Label label_1;
    @FXML
    private Label label_2;
    @FXML
    private Label cofbLabel;
    @FXML
    private Label label_5;
    @FXML
    private Label label_10;
    @FXML
    private Label label_20;
    @FXML
    private Label label_cst;
    @FXML
    private TextField text_5;
    @FXML
    private TextField text_10;
    @FXML
    private TextField text_20;
    @FXML
    private TextField cst;
    @FXML
    private TextField txtfond;
    @FXML
    private TextField texttotal;
    @FXML
    private Button resetButton;
    @FXML
    private Button replenishEntranceButton;
    @FXML
    private Button rebootButton;
    @FXML
    private Button stopButton;
    @FXML
    private Button lockRCButton;
    @FXML
    private Button lockRBButton;
    @FXML
    private Button collectExitButton;
    @FXML
    private Button collectCofbButton;
    @FXML
    private Button print_btn;
    @FXML
    private Label guidance;
    @FXML
    private Label statusBillet;
    @FXML
    private Label statusCoin;
    @FXML
    private ContextMenu actionMenuReplenishFromEntrance;
    @FXML
    private ContextMenu actionMenuCollectCofb;
    @FXML
    private ContextMenu actionMenuCollectExit;
    @FXML
    private MenuItem cancelRepFromCst;
    @FXML
    private MenuItem startRepFromCst;
    @FXML
    private MenuItem endRepFromCst;
    @FXML
    private MenuItem cancelRepFromEntrance;
    @FXML
    private MenuItem startRepFromEntrance;
    @FXML
    private MenuItem endRepFromEntrance;
    public boolean isClosed = false;
    @FXML
    GridPane historique;
    @FXML
    Tab historyTab;
    FCCClient fcc;
    Recovery frmRecovery2;
    private Color[] bkColors = new Color[]{Color.RED, Color.YELLOW, Color.GREEN, Color.AQUA, Color.CORNFLOWERBLUE};
    TextField[] txtNoteValueObjArray;
    TextField[] txtCoinValueObjArray;
    Label[] txtCoinLabelObjArray;
    Label[] txtNoteLabelObjArray;
    Label[] txtStatus;
    boolean RBWUNLocked = false;
    boolean RCWUNLocked = false;
    Image image_lock;
    Image image_unlock;
    private boolean repFC_state = false;
    Thread eventListener;
    private BrueBoxServiceStub.RequireVerifyInfosType gobjVerify;
    private boolean initial_state = true;
    private boolean modeCashGlory;
    private String gloryIp;
    private String gloryLogin;
    private BrueBoxServiceStub.InventoryResponseType inventory;

    public FCCClient getFccInstance() {
        if (this.fcc == null) {
            this.fcc = new FCCClient(this.gloryIp);
        }
        return this.fcc;
    }

    public void init(AppView app, Scene scene) throws BasicException, URISyntaxException {
        this.app = app;
        this.scene = scene;
        this.image_lock = new Image(this.getClass().getResource("/com/openbravo/images/lock.png").toURI().toString());
        this.image_unlock = new Image(this.getClass().getResource("/com/openbravo/images/unlock.png").toURI().toString());
        this.loadImage();
        this.gloryIp = app.getProperties().getProperty("module.glory.ip");
        this.gloryLogin = app.getProperties().getProperty("module.glory.login");
        String gloryPassword = app.getProperties().getProperty("module.glory.password");
        this.frmRecovery2 = new Recovery(this);
        this.txtNoteValueObjArray = new TextField[]{this.text_5, this.text_10, this.text_20, this.cst};
        this.txtCoinValueObjArray = new TextField[]{this.text_0_01, this.text_0_02, this.text_0_05, this.text_0_10, this.text_0_20, this.text_0_50, this.text_1, this.text_2, this.cofb};
        this.txtCoinLabelObjArray = new Label[]{this.label_0_01, this.label_0_02, this.label_0_05, this.label_0_10, this.label_0_20, this.label_0_50, this.label_1, this.label_2, this.cofbLabel};
        this.txtNoteLabelObjArray = new Label[]{this.label_5, this.label_10, this.label_20, this.label_cst};
        this.eventListener = new Thread(new EventHandleClass(this));
        this.txtStatus = new Label[]{this.statusBillet, this.statusCoin};
        this.me = this;
        this.actionMenuReplenishFromEntrance.setStyle("-fx-min-width:" + this.replenishEntranceButton.getMinWidth() + ";");
        this.replenishEntranceButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Button me = (Button)event.getSource();
                if (!SettingGloryController.this.actionMenuReplenishFromEntrance.isShowing()) {
                    SettingGloryController.this.actionMenuReplenishFromEntrance.show((Node)me, Side.BOTTOM, 0.0, 0.0);
                } else {
                    SettingGloryController.this.actionMenuReplenishFromEntrance.hide();
                }
            }
        });
        this.actionMenuCollectExit.setStyle("-fx-min-width:" + this.collectExitButton.getMinWidth() + ";");
        this.collectExitButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Button me = (Button)event.getSource();
                if (!SettingGloryController.this.actionMenuCollectExit.isShowing()) {
                    SettingGloryController.this.actionMenuCollectExit.show((Node)me, Side.BOTTOM, 0.0, 0.0);
                } else {
                    SettingGloryController.this.actionMenuCollectExit.hide();
                }
            }
        });
        this.actionMenuCollectCofb.setStyle("-fx-min-width:" + this.collectCofbButton.getMinWidth() + ";");
        this.collectCofbButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Button me = (Button)event.getSource();
                if (!SettingGloryController.this.actionMenuCollectCofb.isShowing()) {
                    SettingGloryController.this.actionMenuCollectCofb.show((Node)me, Side.BOTTOM, 0.0, 0.0);
                } else {
                    SettingGloryController.this.actionMenuCollectCofb.hide();
                }
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SettingGloryController.this.initialise();
                Image imagePrint = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/printer.png"));
                SettingGloryController.this.print_btn.setGraphic((Node)new ImageView(imagePrint));
            }
        });
    }

    public void initialise() {
        this.setGuidance("V\u00e9rification du contr\u00f4leur de p\u00e9riph\u00e9rique...", -1);
        this.isClosed = false;
        this.exclusionProcessing(false, null);
        this.getFccInstance().getStatusAsync(new BrueBoxServiceCallbackHandler(){

            @Override
            public void receiveErrorgetStatus(Exception ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Connexion au Monnayeur a \u00e9chou\u00e9.", 4000, NPosition.BOTTOM_RIGHT);
                super.receiveErrorgetStatus(ex);
                SettingGloryController.this.setGuidance("Le contr\u00f4leur de p\u00e9riph\u00e9rique ne peut pas \u00eatre atteint. R\u00e9essayer...", -1);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (!SettingGloryController.this.isClosed) {
                    SettingGloryController.this.getFccInstance().getStatusAsync(this);
                }
            }

            @Override
            public void receiveResultgetStatus(BrueBoxServiceStub.StatusResponse result) {
                SettingGloryController.this.setGuidance(SettingGloryController.this.getStatusString(result.getStatusResponse().getStatus().getCode().intValue()), result.getStatusResponse().getStatus().getCode().intValue());
                if (result.getStatusResponse().getResult().intValue() == 0) {
                    if (result.getStatusResponse().getStatus().getCode().intValue() > 1 && result.getStatusResponse().getStatus().getCode().intValue() != 8) {
                        SettingGloryController.this.getFccInstance().resetOperationAsync(new BrueBoxServiceCallbackHandler(){});
                        SettingGloryController.this.getFccInstance().getStatusAsync(this);
                    } else if (result.getStatusResponse().getStatus().getCode().intValue() != 1) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (!SettingGloryController.this.isClosed) {
                            SettingGloryController.this.getFccInstance().getStatusAsync(this);
                        }
                    } else {
                        SettingGloryController.this.gobjVerify = result.getStatusResponse().getRequireVerifyInfos();
                        SettingGloryController.this.getFccInstance().updateInventory(new InventoryUpdatedEvent());
                        SettingGloryController.this.exclusionProcessing(false, null);
                        SettingGloryController.this.setStatus(1, SettingGloryController.this.getDevicePositionIDString("" + result.getStatusResponse().getStatus().getDevStatus()[0].getSt()));
                        SettingGloryController.this.setStatus(2, SettingGloryController.this.getDevicePositionIDString("" + result.getStatusResponse().getStatus().getDevStatus()[1].getSt()));
                    }
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    if (!SettingGloryController.this.isClosed) {
                        SettingGloryController.this.getFccInstance().getStatusAsync(this);
                    }
                }
            }
        });
        int jikkiMode = 1;
        this.getFccInstance().registerEvent(jikkiMode, new BrueBoxServiceCallbackHandler(){

            @Override
            public void receiveResultregisterEventOperation(BrueBoxServiceStub.RegisterEventResponse result) {
                BrueBoxServiceStub.RegisterEventResponseType response = result.getRegisterEventResponse();
                if (response.getResult().intValue() == 0) {
                    SettingGloryController.this.eventListener.start();
                }
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView wb = new WebView();
                WebEngine pp = wb.getEngine();
                SettingGloryController.this.historyTab.setContent((Node)wb);
                pp.load("http://" + SettingGloryController.this.gloryIp + "/GlyTool/");
            }
        });
    }

    public void loadImage() {
        try {
            Image image_logo = new Image(this.getClass().getResource("/com/openbravo/images/glory_billet.png").toURI().toString());
            this.glory_billet.setImage(image_logo);
            this.glory_coin.setImage(new Image(this.getClass().getResource("/com/openbravo/images/glory_coin.png").toURI().toString()));
            this.coin_verro.setImage(this.image_unlock);
            this.note_verro.setImage(this.image_unlock);
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void setGuidance(final String msg, int status) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SettingGloryController.this.guidance.setText(msg);
                if (msg.contains("pret")) {
                    SettingGloryController.this.exclusionProcessing(false, null);
                }
            }
        });
    }

    @Override
    public void setDeposit(String amount) {
    }

    @Override
    public void setStatus(final int devid, final String msg) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SettingGloryController.this.txtStatus[devid - 1].setText(msg);
                if (SettingGloryController.this.RBWUNLocked && msg.equalsIgnoreCase("StatusChange STATUS_IDLE")) {
                    SettingGloryController.this.note_verro.setImage(SettingGloryController.this.image_unlock);
                    SettingGloryController.this.RBWUNLocked = false;
                }
                if (SettingGloryController.this.RCWUNLocked && msg.equalsIgnoreCase("StatusChange STATUS_IDLE")) {
                    SettingGloryController.this.coin_verro.setImage(SettingGloryController.this.image_unlock);
                    SettingGloryController.this.RCWUNLocked = false;
                }
            }
        });
    }

    @Override
    public void showRecoveryScreen(String errCode, String text) {
        this.frmRecovery2.getLblErrorCode().setText(errCode);
        System.out.println(text);
        this.frmRecovery2.getWebBrowser1().setText("<html><image src='" + text + "' /></html>");
        this.frmRecovery2.setVisible(true);
    }

    @Override
    public void setWarningLabel(int proc, String devid, String fv) {
    }

    @Override
    public void startRepFC() {
        try {
            block6: {
                BrueBoxServiceStub.StartReplenishmentFromCassetteResponseType res;
                block7: {
                    int retry = 0;
                    while (true) {
                        this.repFC_state = false;
                        res = this.getFccInstance().startRepFCOperation();
                        if (res.getResult().intValue() == 0) {
                            this.setGuidance("IF Processing Replenishment", -1);
                            break block6;
                        }
                        if (res.getResult().intValue() != 11) break block7;
                        if (retry >= 3) break;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        ++retry;
                    }
                    JOptionPane.showMessageDialog(null, "Start Replenishment From Cassette failed. " + res.getResult().intValue(), "", 0);
                    break block6;
                }
                JOptionPane.showMessageDialog(null, "Start Replenishment From Cassette failed. " + res.getResult().intValue(), "", 0);
            }
            this.exclusionProcessing(false, null);
        }
        catch (RemoteException e1) {
            JOptionPane.showMessageDialog(null, e1.toString(), "", 0);
        }
    }

    @Override
    public boolean getRepFCState() {
        return this.repFC_state;
    }

    @Override
    public void setEventInventory(Element node) {
        BrueBoxServiceStub.InventoryResponseType inv = new BrueBoxServiceStub.InventoryResponseType();
        inv.setId(node.getChild("Id").getText());
        inv.setSeqNo(node.getChild("SeqNo").getText());
        inv.setUser(node.getChild("User").getText());
        List nodeListCash = node.getChildren("Cash");
        int nodeCashCnt = 0;
        BrueBoxServiceStub.CashType[] cashCashArray = new BrueBoxServiceStub.CashType[nodeListCash.size()];
        for (Element nodeCash : nodeListCash) {
            BrueBoxServiceStub.CashType cash = new BrueBoxServiceStub.CashType();
            cash.setType(BigInteger.valueOf(Long.parseLong(nodeCash.getAttributeValue("type"))));
            List nodeListDenomi = nodeCash.getChildren("Denomination");
            int nodeDenomiCnt = 0;
            BrueBoxServiceStub.DenominationType[] cashDenomiArray = new BrueBoxServiceStub.DenominationType[nodeListDenomi.size()];
            for (Element nodeDenomi : nodeListDenomi) {
                BrueBoxServiceStub.DenominationType cashDenomi = new BrueBoxServiceStub.DenominationType();
                cashDenomi.setCc(nodeDenomi.getAttributeValue("cc"));
                cashDenomi.setFv(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("fv"))));
                cashDenomi.setRev(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("rev"))));
                cashDenomi.setDevid(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("devid"))));
                cashDenomi.setPiece(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Piece").getText())));
                cashDenomi.setStatus(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Status").getText())));
                cashDenomiArray[nodeDenomiCnt] = cashDenomi;
                ++nodeDenomiCnt;
            }
            cash.setDenomination(cashDenomiArray);
            cashCashArray[nodeCashCnt] = cash;
            ++nodeCashCnt;
        }
        inv.setCash(cashCashArray);
        List nodeListUnits = node.getChildren("CashUnits");
        int nodeUnitsCnt = 0;
        BrueBoxServiceStub.CashUnitsType[] cashUnitsArray = new BrueBoxServiceStub.CashUnitsType[nodeListUnits.size()];
        for (Element nodeUnits : nodeListUnits) {
            BrueBoxServiceStub.CashUnitsType cashUnits = new BrueBoxServiceStub.CashUnitsType();
            cashUnits.setDevid(BigInteger.valueOf(Long.parseLong(nodeUnits.getAttributeValue("devid"))));
            List nodeListUnit = nodeUnits.getChildren("CashUnit");
            int nodeUnitCnt = 0;
            BrueBoxServiceStub.CashUnitType[] cashUnitArray = new BrueBoxServiceStub.CashUnitType[nodeListUnit.size()];
            for (Element nodeUnit : nodeListUnit) {
                BrueBoxServiceStub.CashUnitType cashUnit = new BrueBoxServiceStub.CashUnitType();
                cashUnit.setUnitno(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("unitno"))));
                cashUnit.setSt(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("st"))));
                cashUnit.setNf(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("nf"))));
                cashUnit.setNe(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("ne"))));
                cashUnit.setMax(BigInteger.valueOf(Long.parseLong(nodeUnit.getAttributeValue("max"))));
                List nodeListDenomi = nodeUnit.getChildren("Denomination");
                int nodeDenomiCnt = 0;
                BrueBoxServiceStub.DenominationType[] cashDenomiArray = new BrueBoxServiceStub.DenominationType[nodeListDenomi.size()];
                for (Element nodeDenomi : nodeListDenomi) {
                    BrueBoxServiceStub.DenominationType cashDenomi = new BrueBoxServiceStub.DenominationType();
                    cashDenomi.setCc(nodeDenomi.getAttributeValue("cc"));
                    cashDenomi.setFv(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("fv"))));
                    cashDenomi.setRev(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("rev"))));
                    cashDenomi.setDevid(BigInteger.valueOf(Long.parseLong(nodeDenomi.getAttributeValue("devid"))));
                    cashDenomi.setPiece(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Piece").getText())));
                    cashDenomi.setStatus(BigInteger.valueOf(Long.parseLong(nodeDenomi.getChild("Status").getText())));
                    cashDenomiArray[nodeDenomiCnt] = cashDenomi;
                    ++nodeDenomiCnt;
                }
                cashUnit.setDenomination(cashDenomiArray);
                cashUnitArray[nodeUnitCnt] = cashUnit;
                ++nodeUnitCnt;
            }
            cashUnits.setCashUnit(cashUnitArray);
            cashUnitsArray[nodeUnitsCnt] = cashUnits;
            ++nodeUnitsCnt;
        }
        inv.setCashUnits(cashUnitsArray);
        this.setInventory(inv);
    }

    @Override
    public void setInventory(final BrueBoxServiceStub.InventoryResponseType inv) {
        this.inventory = inv;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int j;
                BrueBoxServiceStub.DenominationType[] denominations;
                int i;
                int k = 0;
                int coinId = 0;
                int noteId = 0;
                int colNoteSum = 0;
                double sommeCst = 0.0;
                double fondCaisseNote = 0.0;
                double fondCaisseCoin = 0.0;
                double sommeCoinCst = 0.0;
                int colCoinSum = 0;
                block0: for (i = 0; i < inv.getCash().length; ++i) {
                    if (inv.getCash()[i].getType().intValue() != 4) continue;
                    denominations = inv.getCash()[i].getDenomination();
                    SettingGloryController.this.sortDenomination(denominations);
                    if (denominations.length <= 1) continue;
                    for (j = 0; j < denominations.length; ++j) {
                        double fValue;
                        if (denominations[j].getDevid().intValue() == 1) {
                            if (noteId >= SettingGloryController.this.txtNoteValueObjArray.length) continue block0;
                            fValue = denominations[j].getFv().doubleValue();
                            SettingGloryController.this.txtNoteLabelObjArray[noteId].setText(Formats.CURRENCY.formatValue(fValue /= 100.0));
                            SettingGloryController.this.txtNoteLabelObjArray[noteId].setVisible(true);
                            SettingGloryController.this.txtNoteValueObjArray[noteId].setText(denominations[j].getPiece().toString());
                            SettingGloryController.this.txtNoteValueObjArray[noteId].setVisible(true);
                            SettingGloryController.this.txtNoteValueObjArray[noteId].setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)SettingGloryController.this.bkColors[denominations[j].getStatus().intValue()], CornerRadii.EMPTY, Insets.EMPTY)}));
                            fondCaisseNote += Double.valueOf(SettingGloryController.this.txtNoteValueObjArray[noteId].getText()) * fValue;
                            ++noteId;
                            continue;
                        }
                        if (denominations[j].getDevid().intValue() != 2) continue;
                        if (coinId >= SettingGloryController.this.txtCoinValueObjArray.length) continue block0;
                        fValue = denominations[j].getFv().doubleValue();
                        SettingGloryController.this.txtCoinLabelObjArray[coinId].setText(Formats.CURRENCY.formatValue(fValue /= 100.0));
                        SettingGloryController.this.txtCoinLabelObjArray[coinId].setVisible(true);
                        SettingGloryController.this.txtCoinValueObjArray[coinId].setText(denominations[j].getPiece().toString());
                        SettingGloryController.this.txtCoinValueObjArray[coinId].setVisible(true);
                        SettingGloryController.this.txtCoinValueObjArray[coinId].setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)SettingGloryController.this.bkColors[denominations[j].getStatus().intValue()], CornerRadii.EMPTY, Insets.EMPTY)}));
                        fondCaisseCoin += Double.valueOf(denominations[j].getPiece().toString()) * fValue;
                        ++coinId;
                    }
                }
                BrueBoxServiceStub.CashUnitsType[] cashUnits = inv.getCashUnits();
                if (cashUnits != null) {
                    for (i = 0; i < cashUnits.length; ++i) {
                        BrueBoxServiceStub.CashUnitType[] cashUnit = cashUnits[i].getCashUnit();
                        if (cashUnits[i].getDevid().intValue() == 1) {
                            for (j = 0; j < cashUnit.length; ++j) {
                                int unitno = cashUnit[j].getUnitno().intValue();
                                if (unitno != 4056 && unitno != 4057 && unitno != 4058 && unitno != 4059 && unitno != 4060) continue;
                                denominations = cashUnit[j].getDenomination();
                                for (k = 0; k < denominations.length; ++k) {
                                    colNoteSum += denominations[k].getPiece().intValue();
                                    sommeCst += (double)denominations[k].getPiece().intValue() * denominations[k].getFv().doubleValue() / 100.0;
                                }
                            }
                            SettingGloryController.this.txtNoteValueObjArray[SettingGloryController.this.txtNoteValueObjArray.length - 1].setText(Formats.CURRENCY.formatValue(sommeCst));
                            SettingGloryController.this.txtNoteValueObjArray[SettingGloryController.this.txtNoteValueObjArray.length - 1].setVisible(true);
                            continue;
                        }
                        if (cashUnits[i].getDevid().intValue() != 2) continue;
                        for (j = 0; j < cashUnit.length; ++j) {
                            int unitno = cashUnit[j].getUnitno().intValue();
                            if (unitno != 4084 || (denominations = cashUnit[j].getDenomination()) == null) continue;
                            for (k = 0; k < denominations.length; ++k) {
                                colCoinSum += denominations[k].getPiece().intValue();
                                sommeCoinCst += (double)denominations[k].getPiece().intValue() * denominations[k].getFv().doubleValue() / 100.0;
                            }
                        }
                        SettingGloryController.this.txtCoinLabelObjArray[SettingGloryController.this.txtCoinLabelObjArray.length - 1].setText("La cassette pi\u00e8ce");
                        SettingGloryController.this.txtCoinLabelObjArray[SettingGloryController.this.txtCoinLabelObjArray.length - 1].setVisible(true);
                        SettingGloryController.this.txtCoinValueObjArray[SettingGloryController.this.txtCoinValueObjArray.length - 1].setText(Formats.CURRENCY.formatValue(sommeCoinCst));
                        SettingGloryController.this.txtCoinValueObjArray[SettingGloryController.this.txtCoinValueObjArray.length - 1].setVisible(true);
                        if (!SettingGloryController.this.txtCoinValueObjArray[SettingGloryController.this.txtCoinLabelObjArray.length - 2].getText().isEmpty() && SettingGloryController.this.txtCoinLabelObjArray[SettingGloryController.this.txtCoinLabelObjArray.length - 2].getText() != "MIX") continue;
                        colCoinSum = 0;
                        for (j = 0; j < cashUnit.length; ++j) {
                            int unitno = cashUnit[j].getUnitno().intValue();
                            if (unitno != 4165 || (denominations = cashUnit[j].getDenomination()) == null) continue;
                            for (k = 0; k < denominations.length; ++k) {
                                colCoinSum += denominations[k].getPiece().intValue();
                            }
                        }
                        SettingGloryController.this.txtCoinLabelObjArray[SettingGloryController.this.txtCoinLabelObjArray.length - 2].setText("MIX");
                        SettingGloryController.this.txtCoinLabelObjArray[SettingGloryController.this.txtCoinLabelObjArray.length - 2].setVisible(true);
                        SettingGloryController.this.txtCoinValueObjArray[SettingGloryController.this.txtCoinValueObjArray.length - 2].setText(Integer.toString(colCoinSum));
                        SettingGloryController.this.txtCoinValueObjArray[SettingGloryController.this.txtCoinValueObjArray.length - 2].setVisible(true);
                    }
                }
                SettingGloryController.this.txtfond.setText(Formats.CURRENCY.formatValue(fondCaisseCoin + fondCaisseNote));
                SettingGloryController.this.texttotal.setText(Formats.CURRENCY.formatValue(fondCaisseCoin + fondCaisseNote + (sommeCoinCst + sommeCst)));
            }
        });
    }

    public Recovery getFrmRecovery2() {
        return this.frmRecovery2;
    }

    public void setFrmRecovery2(Recovery frmRecovery2) {
        this.frmRecovery2 = frmRecovery2;
    }

    @Override
    public String getGuidance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void setVerifyInfo(BrueBoxServiceStub.RequireVerifyInfosType objVerify) {
        BrueBoxServiceStub.RequireVerifyMixStackerType[] objVerifyMix;
        BrueBoxServiceStub.RequireVerifyCollectionContainerType[] objVerifyContainer;
        String val;
        String devid;
        int i;
        int j = 0;
        this.setWarningLabel(3, String.valueOf(1), "");
        this.setWarningLabel(3, String.valueOf(2), "");
        this.setWarningLabel(4, String.valueOf(1), "");
        this.setWarningLabel(4, String.valueOf(2), "");
        this.setWarningLabel(6, String.valueOf(2), "");
        BrueBoxServiceStub.RequireVerifyDenominationType[] objVerifyDenomi = objVerify.getRequireVerifyDenominationInfos().getRequireVerifyDenomination();
        if (objVerifyDenomi != null) {
            for (i = 0; i <= objVerifyDenomi.length - 1; ++i) {
                devid = objVerifyDenomi[i].getDevid().toString();
                val = objVerifyDenomi[i].getVal().toString();
                BrueBoxServiceStub.CashType objCash = objVerifyDenomi[i].getCash();
                if (Integer.parseInt(val) != 1 || objCash == null) continue;
                BrueBoxServiceStub.DenominationType[] objDenomi = objCash.getDenomination();
                for (j = 0; j <= objDenomi.length - 1; ++j) {
                    String fv = objDenomi[j].getFv().toString();
                    this.setWarningLabel(1, devid, fv);
                }
            }
        }
        if ((objVerifyContainer = objVerify.getRequireVerifyCollectionContainerInfos().getRequireVerifyCollectionContainer()) != null) {
            for (i = 0; i <= objVerifyContainer.length - 1; ++i) {
                devid = objVerifyContainer[i].getDevid().toString();
                val = objVerifyContainer[i].getVal().toString();
                if (Integer.parseInt(val) != 1) continue;
                this.setWarningLabel(2, devid, "");
            }
        }
        if ((objVerifyMix = objVerify.getRequireVerifyMixStackerInfos().getRequireVerifyMixStacker()) != null) {
            for (i = 0; i <= objVerifyMix.length - 1; ++i) {
                devid = objVerifyMix[i].getDevid().toString();
                val = objVerifyMix[i].getVal().toString();
                if (Integer.parseInt(val) != 1) continue;
                this.setWarningLabel(5, devid, "");
            }
        }
    }

    public void sortDenomination(BrueBoxServiceStub.DenominationType[] denominations) {
        Arrays.sort(denominations, (s1, s2) -> s1.getFv().intValue() - s2.getFv().intValue());
    }

    public void stop() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Etes vous sur de vouloir Red\u00e9marer le Monnayeur ?!", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        DialogPane root = alert.getDialogPane();
        Stage dialogStage = new Stage(StageStyle.UTILITY);
        root.getButtonTypes().forEach(buttonType -> {
            ButtonBase button = (ButtonBase)root.lookupButton(buttonType);
            button.setOnAction(evt -> {
                root.setUserData(buttonType);
                dialogStage.close();
            });
        });
        root.getScene().setRoot((Parent)new Group());
        root.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        Scene scene = new Scene((Parent)root);
        dialogStage.setScene(scene);
        dialogStage.initModality(Modality.APPLICATION_MODAL);
        dialogStage.setAlwaysOnTop(true);
        dialogStage.setResizable(false);
        dialogStage.showAndWait();
        Optional<ButtonType> result = Optional.ofNullable((ButtonType)root.getUserData());
        if (result.get() == ButtonType.OK) {
            try {
                BrueBoxServiceStub.PowerControlResponseType res = this.getFccInstance().powerControlOperation(0);
                if (res.getResult().intValue() == 0) {
                    JOptionPane.showMessageDialog(null, "Le Monnayeur va s'arr\u00eater.", "", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "Echec de l'arr\u00eat.", "", 0);
                }
            }
            catch (RemoteException e1) {
                JOptionPane.showMessageDialog(null, e1.toString(), "", 0);
            }
        }
    }

    public void reboot() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Etes vous sur de vouloir Red\u00e9marer le Monnayeur ?!", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        DialogPane root = alert.getDialogPane();
        Stage dialogStage = new Stage(StageStyle.UTILITY);
        root.getButtonTypes().forEach(buttonType -> {
            ButtonBase button = (ButtonBase)root.lookupButton(buttonType);
            button.setOnAction(evt -> {
                root.setUserData(buttonType);
                dialogStage.close();
            });
        });
        root.getScene().setRoot((Parent)new Group());
        root.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        Scene scene = new Scene((Parent)root);
        dialogStage.setScene(scene);
        dialogStage.initModality(Modality.APPLICATION_MODAL);
        dialogStage.setAlwaysOnTop(true);
        dialogStage.setResizable(false);
        dialogStage.showAndWait();
        Optional<ButtonType> result = Optional.ofNullable((ButtonType)root.getUserData());
        if (result.get() == ButtonType.OK) {
            try {
                BrueBoxServiceStub.PowerControlResponseType res = this.getFccInstance().powerControlOperation(1);
                if (res.getResult().intValue() == 0) {
                    JOptionPane.showMessageDialog(null, "Red\u00e9marage en cours .", "", 1);
                    Thread.sleep(15000L);
                    this.getAsyncStatus();
                } else {
                    JOptionPane.showMessageDialog(null, "Echec de l'op\u00e9ration .", "", 0);
                }
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void doEndListeningGlory() {
        System.out.println("good bye glory");
        this.isClosed = true;
        if (this.eventListener != null) {
            this.eventListener.interrupt();
            this.eventListener = null;
        }
    }

    @Override
    public void reset() {
        this.setGuidance("R\u00e9initialisation en cours ...", -1);
        this.getFccInstance().resetOperationAsync(new BrueBoxServiceCallbackHandler(){

            @Override
            public void receiveResultresetOperation(BrueBoxServiceStub.ResetResponse result) {
                SettingGloryController.this.setGuidance(SettingGloryController.this.getStatusString(result.getResetResponse().getStatus().getCode().intValue()), result.getResetResponse().getStatus().getCode().intValue());
            }

            @Override
            public void receiveErrorresetOperation(Exception e) {
                SettingGloryController.this.getFccInstance().getStatusAsync(this);
            }
        });
    }

    public void getAsyncStatus() {
        this.getFccInstance().getStatusAsync(new BrueBoxServiceCallbackHandler(){

            @Override
            public void receiveErrorgetStatus(Exception ex) {
                ex.printStackTrace();
                super.receiveErrorgetStatus(ex);
                SettingGloryController.this.setGuidance("Device controller cannot be reached. Retrying...", -1);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                SettingGloryController.this.getFccInstance().getStatusAsync(this);
            }

            @Override
            public void receiveResultgetStatus(BrueBoxServiceStub.StatusResponse result) {
                SettingGloryController.this.setGuidance(SettingGloryController.this.getStatusString(result.getStatusResponse().getStatus().getCode().intValue()), result.getStatusResponse().getStatus().getCode().intValue());
                System.out.println("Result:" + result.getStatusResponse().getResult().intValue());
                if (result.getStatusResponse().getResult().intValue() == 0) {
                    if (result.getStatusResponse().getStatus().getCode().intValue() > 1 && result.getStatusResponse().getStatus().getCode().intValue() != 8) {
                        System.out.println("Try Reset");
                        SettingGloryController.this.getFccInstance().resetOperationAsync(new BrueBoxServiceCallbackHandler(){});
                        SettingGloryController.this.getFccInstance().getStatusAsync(this);
                    } else if (result.getStatusResponse().getStatus().getCode().intValue() != 1) {
                        System.out.println("Get Status again.");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        SettingGloryController.this.getFccInstance().getStatusAsync(this);
                    } else {
                        SettingGloryController.this.gobjVerify = result.getStatusResponse().getRequireVerifyInfos();
                        SettingGloryController.this.getFccInstance().updateInventory(new InventoryUpdatedEvent());
                    }
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    SettingGloryController.this.getFccInstance().getStatusAsync(this);
                }
            }
        });
    }

    public void lockUnlockRBW() {
        if (this.RBWUNLocked) {
            this.getFccInstance().lockUnitOperationAsync(new BrueBoxServiceCallbackHandler(){

                @Override
                public void receiveErrorlockUnitOperation(Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
                }

                @Override
                public void receiveResultlockUnitOperation(BrueBoxServiceStub.LockUnitResponse result) {
                    if (result.getLockUnitResponse().getResult().intValue() != 0) {
                        JOptionPane.showMessageDialog(null, "LockUnit failed. " + result.getLockUnitResponse().getResult().intValue(), "", 0);
                    } else {
                        SettingGloryController.this.clearInput();
                        SettingGloryController.this.RBWUNLocked = !SettingGloryController.this.RBWUNLocked;
                        SettingGloryController.this.setLockUnlockRbwButtonStyle();
                    }
                }
            });
        } else {
            this.getFccInstance().unlockUnitOperationAsync(new BrueBoxServiceCallbackHandler(){

                @Override
                public void receiveErrorunLockUnitOperation(Exception ex) {
                    SettingGloryController.this.repFC_state = false;
                    JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
                }

                @Override
                public void receiveResultunLockUnitOperation(BrueBoxServiceStub.UnLockUnitResponse result) {
                    if (result.getUnLockUnitResponse().getResult().intValue() != 0) {
                        SettingGloryController.this.repFC_state = false;
                        JOptionPane.showMessageDialog(null, "UnlockUnit failed. " + result.getUnLockUnitResponse().getResult());
                    } else {
                        System.out.println("UnlockUnit success");
                        SettingGloryController.this.RBWUNLocked = !SettingGloryController.this.RBWUNLocked;
                        SettingGloryController.this.setLockUnlockRbwButtonStyle();
                    }
                }
            });
        }
        this.getAsyncStatus();
    }

    public void lockUnlockRCW() {
        block9: {
            System.out.println("_________lockUnlockRCW");
            if (this.RCWUNLocked) {
                try {
                    BrueBoxServiceStub.LockUnitResponseType res = this.getFccInstance().lockUnitOperation(2);
                    if (res.getResult().intValue() != 0) {
                        JOptionPane.showMessageDialog(null, "LockUnit failed. " + res.getResult().intValue(), "", 0);
                        this.getAsyncStatus();
                        break block9;
                    }
                    this.RCWUNLocked = !this.RCWUNLocked;
                }
                catch (RemoteException e1) {
                    LogToFile.log("sever", e1.getMessage(), e1);
                }
            } else {
                try {
                    BrueBoxServiceStub.UnLockUnitResponseType res = this.getFccInstance().unLockUnitOperation(2);
                    if (res.getResult().intValue() != 0) {
                        JOptionPane.showMessageDialog(null, "UnlockUnit failed. " + res.getResult().intValue(), "", 0);
                        this.getAsyncStatus();
                    } else {
                        this.RCWUNLocked = !this.RCWUNLocked;
                    }
                }
                catch (RemoteException e1) {
                    LogToFile.log("sever", e1.getMessage(), e1);
                }
            }
        }
        this.setLockUnlockRcwButtonStyle();
    }

    public void setLockUnlockRbwButtonStyle() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SettingGloryController.this.RBWUNLocked) {
                    SettingGloryController.this.note_verro.setImage(SettingGloryController.this.image_lock);
                } else {
                    SettingGloryController.this.note_verro.setImage(SettingGloryController.this.image_unlock);
                }
            }
        });
    }

    public void setLockUnlockRcwButtonStyle() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SettingGloryController.this.RCWUNLocked) {
                    SettingGloryController.this.coin_verro.setImage(SettingGloryController.this.image_lock);
                } else {
                    SettingGloryController.this.coin_verro.setImage(SettingGloryController.this.image_unlock);
                }
            }
        });
    }

    public String getDevicePositionIDString(String strID) {
        String strRet = "";
        this.getFccInstance();
        strRet = FCCClient.DEVICES_STATUS.get(Integer.valueOf(strID));
        return strRet;
    }

    public void clearCurrencies() {
        int j;
        for (j = 0; j < this.txtNoteLabelObjArray.length; ++j) {
            this.txtNoteLabelObjArray[j].setVisible(false);
            this.txtNoteValueObjArray[j].setVisible(false);
        }
        for (j = 0; j < this.txtCoinLabelObjArray.length; ++j) {
            this.txtCoinLabelObjArray[j].setVisible(false);
            this.txtCoinValueObjArray[j].setVisible(false);
        }
    }

    public void repFromEntrance() {
        this.exclusionProcessing(true, this.replenishEntranceButton);
        this.endRepFromEntrance.setDisable(false);
        this.cancelRepFromEntrance.setDisable(false);
        this.clearCurrencies();
        this.setGuidance("Recharger le monnayeur \u00e0 partir de l'entr\u00e9e... ", -1);
        try {
            BrueBoxServiceStub.StartReplenishmentFromEntranceResponseType res = this.getFccInstance().startRepFEOperation();
            if (res.getResult().intValue() != 0) {
                JOptionPane.showMessageDialog(null, "Echec de la r\u00e9approvisionnement \u00e0 partir de l'entr\u00e9e." + res.getResult().intValue());
                this.exclusionProcessing(false, null);
                this.endRepFromEntrance.setDisable(true);
                this.cancelRepFromEntrance.setDisable(true);
                this.clearInput();
                this.setGuidance("", -1);
            }
        }
        catch (RemoteException e1) {
            JOptionPane.showMessageDialog(null, e1.toString(), "Error", 0);
        }
    }

    public void endRepFromCst() {
        Object str = "";
        try {
            BrueBoxServiceStub.EndReplenishmentFromCassetteResponseType res = this.getFccInstance().endRepFCOperation();
            if (res.getResult().intValue() != 0 && res.getResult().intValue() != 32 && res.getResult().intValue() != 33 && res.getResult().intValue() != 34) {
                this.togleStartAndEND(true);
                JOptionPane.showMessageDialog(null, "End Replenishment From Cassette failed. " + res.getResult().intValue(), "", 0);
            } else {
                this.togleStartAndEND(false);
                if (res.getResult().intValue() == 32 || res.getResult().intValue() == 33 || res.getResult().intValue() == 34) {
                    this.togleStartAndEND(true);
                    JOptionPane.showMessageDialog(null, "End Replenishment From Cassette failed. " + res.getResult().intValue(), "", 0);
                }
                if (res.getCash().getDenomination() != null) {
                    for (int i = 0; i < res.getCash().getDenomination().length; ++i) {
                        if (res.getCash().getDenomination()[i].getDevid().intValue() == 1) {
                            str = (String)str + "RBW ";
                        } else if (res.getCash().getDenomination()[i].getDevid().intValue() == 2) {
                            str = (String)str + "RCW ";
                        }
                        str = (String)str + decimalFormat.format(res.getCash().getDenomination()[i].getFv().doubleValue() / 100.0) + ":" + res.getCash().getDenomination()[i].getPiece().intValue() + "\n";
                    }
                    JOptionPane.showMessageDialog(null, str);
                }
                this.setGuidance("", -1);
                this.repFC_state = false;
            }
            this.exclusionProcessing(false, null);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
        }
    }

    public void endRepFromEntrance() {
        Object str = "";
        try {
            BrueBoxServiceStub.EndReplenishmentFromEntranceResponseType res = this.getFccInstance().endRepFEOperation();
            if (res.getResult().intValue() != 0) {
                JOptionPane.showMessageDialog(null, "End Replenishment failed. " + res.getResult().intValue(), "", 0);
            } else {
                if (res.getCash().getDenomination() != null) {
                    double total = 0.0;
                    for (int i = 0; i < res.getCash().getDenomination().length; ++i) {
                        if (res.getCash().getDenomination()[i].getDevid().intValue() == 1) {
                            str = (String)str + "Nombre de billets de ";
                        } else if (res.getCash().getDenomination()[i].getDevid().intValue() == 2) {
                            str = (String)str + "Nombre de pi\u00e8ces de ";
                        }
                        total += res.getCash().getDenomination()[i].getFv().doubleValue() * (double)res.getCash().getDenomination()[i].getPiece().intValue() / 100.0;
                        str = (String)str + decimalFormat.format(res.getCash().getDenomination()[i].getFv().doubleValue() / 100.0) + "\u20ac   :  " + res.getCash().getDenomination()[i].getPiece().intValue() + "\n";
                    }
                    str = (String)str + "Total : " + Formats.CURRENCY.formatValue(total);
                    JOptionPane.showMessageDialog(null, str);
                }
                this.clearInput();
                this.setGuidance("", -1);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
        }
    }

    private void togleStartAndEND(boolean enabled) {
        this.startRepFromCst.setDisable(!enabled);
        this.endRepFromCst.setDisable(enabled);
        this.cancelRepFromCst.setDisable(enabled);
    }

    public void cancelRepFromCst() {
        this.repFC_state = false;
        this.getFccInstance().lockUnitOperationAsync(new BrueBoxServiceCallbackHandler(){

            @Override
            public void receiveErrorlockUnitOperation(Exception ex) {
                JOptionPane.showMessageDialog(null, ex.toString(), "Error", 0);
            }

            @Override
            public void receiveResultlockUnitOperation(BrueBoxServiceStub.LockUnitResponse result) {
                if (result.getLockUnitResponse().getResult().intValue() != 0) {
                    JOptionPane.showMessageDialog(null, "LockUnit failed. " + result.getLockUnitResponse().getResult().intValue(), "", 0);
                    return;
                }
                SettingGloryController.this.clearInput();
            }
        });
    }

    public void cancelRepFromEntrance() {
        try {
            BrueBoxServiceStub.ReplenishmentFromEntranceCancelResponseType res = this.getFccInstance().cancelRepFEOperation();
            if (res.getResult().intValue() == 0 || res.getResult().intValue() == 10) {
                this.clearInput();
                this.setGuidance("", -1);
            } else {
                JOptionPane.showMessageDialog(null, "Cancel Replenishment failed. " + res.getResult().intValue(), "", 0);
            }
        }
        catch (RemoteException e1) {
            JOptionPane.showMessageDialog(null, e1.toString(), "", 0);
        }
    }

    private void exclusionProcessing(boolean enabled, Button b) {
        this.resetButton.setDisable(enabled);
        this.rebootButton.setDisable(enabled);
        this.stopButton.setDisable(enabled);
        this.lockRCButton.setDisable(enabled);
        this.lockRBButton.setDisable(enabled);
        this.collectExitButton.setDisable(enabled);
        this.collectCofbButton.setDisable(enabled);
        if (b != null) {
            b.setDisable(!enabled);
        }
    }

    private void clearInput() {
        this.getFccInstance().addSequenceNumber();
        this.exclusionProcessing(false, null);
        this.repFC_state = false;
    }

    public void collectAllCoin() {
        try {
            this.exclusionProcessing(true, null);
            this.getFccInstance().collectAll(0, new BrueBoxServiceCallbackHandler(){

                @Override
                public void receiveErrorcollectOperation(Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
                }

                @Override
                public void receiveResultcollectOperation(BrueBoxServiceStub.CollectResponse result) {
                    if (result.getCollectResponse().getResult().intValue() != 0 && result.getCollectResponse().getResult().intValue() != 12) {
                        JOptionPane.showMessageDialog(null, "Collect All failed. " + result.getCollectResponse().getResult().intValue());
                        return;
                    }
                    SettingGloryController.this.clearInput();
                }
            });
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
        }
    }

    public void collectSurPlusCoin() {
        try {
            this.exclusionProcessing(true, null);
            ArrayList<Collect> collectList = new ArrayList<Collect>();
            for (int j = 0; j < this.txtCoinLabelObjArray.length - 1; ++j) {
                int nbNotes = Integer.parseInt(this.txtCoinValueObjArray[j].getText()) - 60;
                System.out.println("_____ nbcoins_" + nbNotes);
                if (nbNotes <= 0) continue;
                Collect collect = new Collect();
                String fv = "" + (int)(Double.valueOf(this.txtCoinLabelObjArray[j].getText().replace("\u20ac", "").replace(",", ".")) * 100.0);
                System.out.println("______________________txtCoinLabelObjArray : " + this.txtCoinLabelObjArray[j].getText());
                System.out.println("_____________________________FV : " + fv);
                collect.setFv(fv);
                collect.setPiece(60);
                collectList.add(collect);
            }
            this.getFccInstance().collectSurplus(collectList, 0, new BrueBoxServiceCallbackHandler(){

                @Override
                public void receiveErrorcollectOperation(Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
                }

                @Override
                public void receiveResultcollectOperation(BrueBoxServiceStub.CollectResponse result) {
                    if (result.getCollectResponse().getResult().intValue() != 0 && result.getCollectResponse().getResult().intValue() != 12) {
                        JOptionPane.showMessageDialog(null, "Collect Surplus failed. " + result.getCollectResponse().getResult().intValue());
                        return;
                    }
                    SettingGloryController.this.clearInput();
                }
            });
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void collectCofbAll() {
        try {
            this.exclusionProcessing(true, null);
            this.getFccInstance().collectAll(0, new BrueBoxServiceCallbackHandler(){

                @Override
                public void receiveErrorcollectOperation(Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
                }

                @Override
                public void receiveResultcollectOperation(BrueBoxServiceStub.CollectResponse result) {
                    if (result.getCollectResponse().getResult().intValue() != 0 && result.getCollectResponse().getResult().intValue() != 12) {
                        JOptionPane.showMessageDialog(null, "Collect All failed. " + result.getCollectResponse().getResult().intValue());
                        return;
                    }
                    SettingGloryController.this.clearInput();
                }
            });
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
        }
    }

    public void collectCofbSurPlus() {
        try {
            this.exclusionProcessing(true, null);
            ArrayList<Collect> collectList = new ArrayList<Collect>();
            for (int j = 0; j < this.txtNoteLabelObjArray.length - 1; ++j) {
                int nbNotes = Integer.parseInt(this.txtNoteValueObjArray[j].getText()) - 20;
                if (nbNotes <= 0) continue;
                Collect collect = new Collect();
                collect.setFv("" + (int)(Double.valueOf(this.txtNoteLabelObjArray[j].getText().replace("\u20ac", "").replace(",", ".")) * 100.0));
                collect.setPiece(20);
                collectList.add(collect);
            }
            this.getFccInstance().collectSurplus(collectList, 0, new BrueBoxServiceCallbackHandler(){

                @Override
                public void receiveErrorcollectOperation(Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
                }

                @Override
                public void receiveResultcollectOperation(BrueBoxServiceStub.CollectResponse result) {
                    if (result.getCollectResponse().getResult().intValue() != 0 && result.getCollectResponse().getResult().intValue() != 12) {
                        JOptionPane.showMessageDialog(null, "Collect Surplus failed. " + result.getCollectResponse().getResult().intValue());
                        return;
                    }
                    SettingGloryController.this.clearInput();
                }
            });
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "", 0);
        }
    }

    @Override
    public void setReplenishCounting(final List<Element> denomination) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrueBoxServiceStub.DenominationType[] denominations = SettingGloryController.this.getFccInstance().getCashDenomiArrayFromNodeListDenomi(denomination);
                int noteId = 0;
                int coinId = 0;
                SettingGloryController.this.sortDenomination(denominations);
                for (int j = 0; j < denominations.length; ++j) {
                    double fValue;
                    System.out.println("____denominations[j].getFv().doubleValue() " + denominations[j].getFv().doubleValue());
                    if (denominations[j].getDevid().intValue() == 1) {
                        if (noteId >= SettingGloryController.this.txtNoteValueObjArray.length) break;
                        fValue = denominations[j].getFv().doubleValue();
                        SettingGloryController.this.txtNoteLabelObjArray[noteId].setText(Formats.CURRENCY.formatValue(fValue /= 100.0));
                        SettingGloryController.this.txtNoteLabelObjArray[noteId].setVisible(true);
                        SettingGloryController.this.txtNoteValueObjArray[noteId].setText(denominations[j].getPiece().toString());
                        SettingGloryController.this.txtNoteValueObjArray[noteId].setVisible(true);
                        ++noteId;
                        continue;
                    }
                    if (denominations[j].getDevid().intValue() != 2) continue;
                    if (coinId >= SettingGloryController.this.txtCoinValueObjArray.length) break;
                    fValue = denominations[j].getFv().doubleValue();
                    SettingGloryController.this.txtCoinLabelObjArray[coinId].setText(Formats.CURRENCY.formatValue(fValue /= 100.0));
                    SettingGloryController.this.txtCoinLabelObjArray[coinId].setVisible(true);
                    SettingGloryController.this.txtCoinValueObjArray[coinId].setText(denominations[j].getPiece().toString());
                    SettingGloryController.this.txtCoinValueObjArray[coinId].setVisible(true);
                    ++coinId;
                }
            }
        });
    }

    public void printCurrentInventory() {
        if (this.inventory != null) {
            new PrinterHelper().printInventory(this.inventory, false);
        }
    }

    class InventoryUpdatedEvent
    extends BrueBoxServiceCallbackHandler {
        InventoryUpdatedEvent() {
        }

        @Override
        public void receiveResultinventoryOperation(BrueBoxServiceStub.InventoryResponse result) {
            BrueBoxServiceStub.InventoryResponseType response = result.getInventoryResponse();
            if (response.getResult().intValue() == 0) {
                if (SettingGloryController.this.initial_state) {
                    SettingGloryController.this.initial_state = false;
                    SettingGloryController.this.clearInput();
                }
                System.out.println("clsBrueBoxService_InventoryOperationCompleted");
                SettingGloryController.this.setInventory(response);
                if (SettingGloryController.this.gobjVerify != null) {
                    SettingGloryController.this.setVerifyInfo(SettingGloryController.this.gobjVerify);
                    SettingGloryController.this.gobjVerify = null;
                }
            } else if (SettingGloryController.this.initial_state) {
                SettingGloryController.this.getFccInstance().updateInventory(this);
            }
        }
    }
}

