/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.services.CustomerService;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class SearcherCustomerController {
    @FXML
    TextField name_customer;
    @FXML
    Label label_name;
    @FXML
    TextField phone;
    @FXML
    TextField nom_client;
    @FXML
    GridPane main_pane;
    @FXML
    FlowPane pane_message;
    @FXML
    ScrollPane scroll_client;
    @FXML
    FlowPane button_clients;
    @FXML
    BorderPane new_client_pane;
    @FXML
    TextField new_client;
    @FXML
    TextField addresslv;
    @FXML
    TextField zipCodelv;
    @FXML
    TextField citylv;
    @FXML
    TextField codeEntreelv;
    @FXML
    TextField interphonelv;
    @FXML
    TextField batimentlv;
    @FXML
    Button btn_geo;
    @FXML
    Button btn_geo_new;
    @FXML
    TextField escalierlv;
    @FXML
    TextField etagelv;
    @FXML
    TextField appartementlv;
    @FXML
    TextField societelv;
    @FXML
    TextField address;
    @FXML
    TextField zipCode;
    @FXML
    TextField city;
    @FXML
    TextField codeEntree;
    @FXML
    TextField interphone;
    @FXML
    TextField batiment;
    @FXML
    TextField escalier;
    @FXML
    TextField etage;
    @FXML
    TextField appartement;
    @FXML
    TextField societe;
    @FXML
    FlowPane pane_name_fx;
    @FXML
    Label label_name_customer;
    @FXML
    Button btn_filter_name_client;
    @FXML
    TextField prefix_phone_text;
    @FXML
    Label label_search_by_num;
    @FXML
    Label label_search_by_name;
    @FXML
    Label label_message;
    @FXML
    Label label_prefix_phone;
    @FXML
    Button btn_valid;
    @FXML
    Button btn_add_client;
    private AppView m_App;
    private int filter_number;
    private List<CustomerInfo> listCustomersFilter;
    private boolean showEspaceClient;
    private CustomerService mCustomerService = CustomerService.getInstance();

    public void init(AppView app, Scene scene) {
        this.m_App = app;
        this.showEspaceClient = false;
        this.filter_number = AppLocal.FILTER_NUMBER != null && !AppLocal.FILTER_NUMBER.isEmpty() ? Integer.parseInt(AppLocal.FILTER_NUMBER) : 4;
        Image imagegeoFilter = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/filter_icon.png"));
        this.btn_filter_name_client.setGraphic((Node)new ImageView(imagegeoFilter));
        this.listCustomersFilter = new ArrayList<CustomerInfo>();
        this.nom_client.getProperties().put((Object)"vkType", (Object)5);
        this.nom_client.getProperties().put((Object)"vkSize", (Object)2);
        this.new_client.getProperties().put((Object)"vkSize", (Object)2);
        this.phone.getProperties().put((Object)"vkSize", (Object)2);
        this.new_client.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    SearcherCustomerController.this.btn_geo_new.fire();
                }
            }
        });
        this.phone.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    if (SearcherCustomerController.this.phone.getText().length() == 10) {
                        SearcherCustomerController.this.new_client.requestFocus();
                    }
                } else {
                    if (SearcherCustomerController.this.phone.getText().length() > 10) {
                        String s = SearcherCustomerController.this.phone.getText().substring(0, 10);
                        SearcherCustomerController.this.phone.setText(s);
                        SearcherCustomerController.this.phone.positionCaret(SearcherCustomerController.this.phone.getText().length());
                    }
                    SearcherCustomerController.this.searchByPhone();
                }
            }
        });
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.pane_message, 0, 0);
        this.setTexts();
    }

    public void searchByPhone() {
        if (!this.showEspaceClient) {
            this.listCustomersFilter.clear();
            try {
                if (this.phone != null && !this.phone.getText().isEmpty() && this.phone.getText().length() >= this.filter_number) {
                    this.listCustomersFilter = this.mCustomerService.filterByPhoneOrName(this.phone.getText(), this.nom_client.getText());
                    if (this.listCustomersFilter.size() > 0) {
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.scroll_client, 0, 0);
                        this.loadClient();
                    } else if (this.phone.getText().length() == 10) {
                        this.showEspaceClient = true;
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.new_client_pane, 0, 0);
                    } else {
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.pane_message, 0, 0);
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void searchByNom() {
        block6: {
            if (!this.showEspaceClient) {
                this.listCustomersFilter.clear();
                if (!this.nom_client.getText().isEmpty()) {
                    try {
                        this.listCustomersFilter = this.mCustomerService.filterByPhoneOrName(this.phone.getText(), this.nom_client.getText());
                        if (this.listCustomersFilter.size() > 0) {
                            this.main_pane.getChildren().clear();
                            this.main_pane.add((Node)this.scroll_client, 0, 0);
                            this.loadClient();
                            break block6;
                        }
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.pane_message, 0, 0);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                } else {
                    this.main_pane.getChildren().clear();
                    this.main_pane.add((Node)this.pane_message, 0, 0);
                }
            }
        }
    }

    public void loadClient() {
        this.button_clients.getChildren().clear();
        for (final CustomerInfo customer : this.listCustomersFilter) {
            FlowPane pane_client = new FlowPane();
            pane_client.setVgap(2.0);
            pane_client.setHgap(2.0);
            pane_client.setPrefWidth(200.0);
            pane_client.getStyleClass().add((Object)"btn_client");
            pane_client.setPrefHeight(150.0);
            Button btnCustomer = new Button();
            btnCustomer.getStyleClass().add((Object)"btn_client");
            btnCustomer.getStyleClass().add((Object)"text-size-20");
            btnCustomer.setWrapText(true);
            String textCustomer = customer.getName() + "\n" + customer.printPhone();
            btnCustomer.setText(textCustomer);
            btnCustomer.setPrefHeight(150.0);
            btnCustomer.setPrefWidth(200.0);
            pane_client.getChildren().add((Object)btnCustomer);
            btnCustomer.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    SearcherCustomerController.this.main_pane.requestFocus();
                    AppLocal.chooseCustomer = true;
                    AppLocal.Client_ID = customer.getId();
                    AppLocal.customer_to_change = null;
                    SearcherCustomerController.this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JCaissePanel");
                    AppLocal.view_back = AppLocal.view_current;
                    AppLocal.view_current = "com.openbravo.pos.sales.JCaissePanel";
                    SearcherCustomerController.this.initialize();
                }
            });
            this.button_clients.getChildren().add((Object)pane_client);
        }
    }

    public void phone7() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "7");
            this.searchByPhone();
        }
    }

    public void phone8() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "8");
            this.searchByPhone();
        }
    }

    public void phone9() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "9");
            this.searchByPhone();
        }
    }

    public void phone6() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "6");
            this.searchByPhone();
        }
    }

    public void phone5() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "5");
            this.searchByPhone();
        }
    }

    public void phone4() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "4");
            this.searchByPhone();
        }
    }

    public void phone3() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "3");
            this.searchByPhone();
        }
    }

    public void phone2() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "2");
            this.searchByPhone();
        }
    }

    public void phone1() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "1");
            this.searchByPhone();
        }
    }

    public void phone0() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "0");
            this.searchByPhone();
        }
    }

    public void phoneClear() {
        if (this.phone.getText().length() >= 1) {
            this.phone.setText(this.phone.getText().substring(0, this.phone.getText().length() - 1));
            this.searchByPhone();
        }
    }

    public void filterClientName() {
        this.searchByNom();
    }

    public void loadEspaceClient() {
        this.showEspaceClient = true;
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.new_client_pane, 0, 0);
    }

    public void addClient() {
        if (this.new_client.getText().isEmpty()) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de remplir les champs necessaires.", 1500, NPosition.CENTER);
        } else if (this.phone.getText().length() == 10) {
            CustomerInfo customer = new CustomerInfo();
            customer.setName(this.new_client.getText());
            customer.setPhone(this.phone.getText());
            customer.setDiscount(0.0);
            customer.setType("customer");
            customer.setPrefix_phone(this.prefix_phone_text.getText());
            try {
                CustomerInfo customerResult = this.mCustomerService.save(customer);
                AppLocal.Client_ID = customerResult.getId();
                AppLocal.CUSTOMER_NAME = null;
                AppLocal.chooseCustomer = true;
                AppLocal.customer_to_change = null;
                this.main_pane.requestFocus();
                this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JCaissePanel");
                AppLocal.view_back = AppLocal.view_current;
                AppLocal.view_current = "com.openbravo.pos.sales.JCaissePanel";
                this.initialize();
            }
            catch (Exception ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le num\u00e9ro t\u00e9l\u00e9phone do\u00eet contenir 10 chiffres.", 1500, NPosition.CENTER);
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            AppLocal.chooseCustomer = true;
            AppLocal.customer_to_change = null;
            AppLocal.CUSTOMER_NAME = this.new_client.getText();
            AppLocal.Client_ID = null;
            this.main_pane.requestFocus();
            this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JCaissePanel");
            AppLocal.view_back = "com.openbravo.pos.customers.panelSearchCustomer";
            AppLocal.view_current = "com.openbravo.pos.sales.JCaissePanel";
            this.initialize();
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le num\u00e9ro t\u00e9l\u00e9phone do\u00eet contenir 10 chiffres.", 1500, NPosition.CENTER);
        }
    }

    public void initialize() {
        this.showEspaceClient = false;
        this.nom_client.setText("");
        this.phone.setText("");
        this.new_client.setText("");
        this.nom_client.setText("");
        this.prefix_phone_text.setText(AppLocal.PREFIX_PHONE);
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.pane_message, 0, 0);
    }

    public void hideEspaceClient() {
        this.nom_client.setText("");
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.pane_message, 0, 0);
        this.showEspaceClient = false;
        AppLocal.customer_to_change = null;
    }

    private void setTexts() {
        this.label_search_by_num.setText(AppLocal.getIntString("Button.search.by.num"));
        this.label_search_by_name.setText(AppLocal.getIntString("Button.search.by.name"));
        this.label_message.setText(AppLocal.getIntString("Label.customer.not.found"));
        this.label_name_customer.setText(AppLocal.getIntString("Label.customer.name"));
        this.label_prefix_phone.setText(AppLocal.getIntString("Label.prefix.phone"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid.customer"));
        this.btn_add_client.setText(AppLocal.getIntString("Button.add.customer"));
    }
}

