/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.LocalScreen;
import fr.protactile.procaisse.services.LocalScreenService;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;

public class ScreensController {
    @FXML
    GridPane pane_main;
    @FXML
    GridPane pane_preview_borne;
    @FXML
    GridPane list_bornes;
    @FXML
    GridPane pane_next_borne;
    @FXML
    Button btn_borne_previous;
    @FXML
    Button btn_borne_next;
    @FXML
    Button button_items;
    @FXML
    Button button_images;
    @FXML
    Button button_global;
    @FXML
    Button button_params;
    private int page_borne;
    private GridPane[] pane_bornes;
    private int number_page_borne;
    private int number_line;
    private int number_column;
    private AppView app;
    private DataLogicSystem dlSystem;
    private List<LocalScreen> screens;
    private List<GridPane> listPaneScreens;
    int row = -1;
    private static double widthPane = 700.0;
    private double height_paneScreen;
    private boolean USER_IS_SUPER_ADMIN;
    private double width_pane;
    private boolean changeStatusPayment = false;
    private LocalScreenService mLocalScreenService;
    private Image imageDelete;
    private Image imageUpdate;
    private EventHandler mEventHandlerDeleteScreen = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"screen") != null) {
                LocalScreen localScreen = (LocalScreen)mButtonSource.getProperties().get((Object)"screen");
                ScreensController.this.deleteScreen(localScreen);
            }
        }
    };
    private EventHandler mEventHandlerUpdateScreen = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"screen") != null && mButtonSource.getProperties().get((Object)"name") != null && mButtonSource.getProperties().get((Object)"number") != null) {
                LocalScreen localScreen = (LocalScreen)mButtonSource.getProperties().get((Object)"screen");
                TextField number = (TextField)mButtonSource.getProperties().get((Object)"number");
                TextField name = (TextField)mButtonSource.getProperties().get((Object)"name");
                localScreen.setName(name.getText());
                localScreen.setNumber(Integer.parseInt(number.getText().isEmpty() ? "0" : number.getText()));
                ScreensController.this.updateScreen(localScreen);
            }
        }
    };

    public void init() throws BasicException, URISyntaxException {
        this.mLocalScreenService = LocalScreenService.getInstance();
        this.screens = new ArrayList<LocalScreen>();
        this.listPaneScreens = new ArrayList<GridPane>();
        this.number_line = 3;
        this.number_column = 3;
        this.height_paneScreen = (AppVarUtils.getScreenDimension().getHeight() - 100.0) * 0.72 / (double)this.number_line;
        Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/btn_next.png").toURI().toString(), 40.0, 30.0, false, false);
        Image imagebPrevious = new Image(this.getClass().getResource("/com/openbravo/images/btn_previous.png").toURI().toString(), 40.0, 30.0, false, false);
        this.imageDelete = new Image(this.getClass().getResource("/com/openbravo/images/sale_delete.png").toURI().toString(), 30.0, 30.0, false, false);
        this.imageUpdate = new Image(this.getClass().getResource("/com/openbravo/images/filesave.png").toURI().toString(), 30.0, 30.0, false, false);
        this.btn_borne_previous.setGraphic((Node)new ImageView(imagebPrevious));
        this.btn_borne_next.setGraphic((Node)new ImageView(imageNext));
        this.width_pane = AppVarUtils.getScreenDimension().getWidth() * 0.25;
    }

    private double heightPane() {
        return (AppVarUtils.getScreenDimension().getHeight() - 55.0) * 0.8 * 0.9 * 0.3;
    }

    private void loadScreens() {
        this.listPaneScreens.clear();
        this.screens = this.mLocalScreenService.getScreens();
        if (this.screens != null) {
            for (LocalScreen screen : this.screens) {
                GridPane paneScreen = new GridPane();
                paneScreen.setAlignment(Pos.CENTER);
                paneScreen.setVgap(5.0);
                paneScreen.setHgap(5.0);
                paneScreen.getStyleClass().add((Object)"bg_gray_dfe8e8");
                paneScreen.setPrefWidth(this.width_pane);
                paneScreen.setPrefHeight(this.heightPane());
                TextField textName = new TextField();
                textName.setAlignment(Pos.CENTER);
                textName.setText(screen.getName());
                TextField textNumber = new TextField();
                textNumber.getProperties().put((Object)"vkType", (Object)1);
                textNumber.setAlignment(Pos.CENTER);
                textNumber.setText(String.valueOf(screen.getNumber()));
                GridPane paneButtons = new GridPane();
                paneButtons.setAlignment(Pos.CENTER_RIGHT);
                paneScreen.add((Node)paneButtons, 0, 0);
                paneScreen.add((Node)textNumber, 0, 1);
                paneScreen.add((Node)textName, 0, 2);
                Button buttonUpdate = new Button();
                Button buttonDelete = new Button();
                paneButtons.setHgap(5.0);
                paneButtons.setVgap(5.0);
                paneButtons.add((Node)buttonUpdate, 0, 0);
                paneButtons.add((Node)buttonDelete, 1, 0);
                buttonUpdate.getStyleClass().add((Object)"bg_transparent");
                buttonDelete.getStyleClass().add((Object)"bg_transparent");
                buttonDelete.setGraphic((Node)new ImageView(this.imageDelete));
                buttonUpdate.setGraphic((Node)new ImageView(this.imageUpdate));
                paneButtons.setPrefWidth(paneScreen.getPrefWidth() * 0.8);
                paneButtons.setPrefHeight(paneScreen.getPrefHeight() * 0.2);
                textName.setPrefWidth(paneScreen.getPrefWidth() * 0.8);
                textName.setPrefHeight(paneScreen.getPrefHeight() * 0.3);
                textNumber.setPrefWidth(paneScreen.getPrefWidth() * 0.8);
                textNumber.setPrefHeight(paneScreen.getPrefHeight() * 0.3);
                buttonUpdate.getProperties().put((Object)"screen", (Object)screen);
                buttonUpdate.getProperties().put((Object)"name", (Object)textName);
                buttonUpdate.getProperties().put((Object)"number", (Object)textNumber);
                buttonDelete.getProperties().put((Object)"screen", (Object)screen);
                buttonUpdate.setOnAction(this.mEventHandlerUpdateScreen);
                buttonDelete.setOnAction(this.mEventHandlerDeleteScreen);
                this.listPaneScreens.add(paneScreen);
            }
        }
        final GridPane paneScreen = new GridPane();
        paneScreen.setAlignment(Pos.CENTER);
        paneScreen.setVgap(5.0);
        paneScreen.setHgap(5.0);
        paneScreen.getStyleClass().add((Object)"bg-e6eded");
        paneScreen.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.2);
        paneScreen.setPrefHeight(this.heightPane());
        final TextField nameScreen = new TextField();
        Button btnAdd = new Button("Ajouter");
        final Button btnValid = new Button("Valider");
        nameScreen.setAlignment(Pos.CENTER);
        nameScreen.setPromptText("nom ecran");
        nameScreen.setPrefWidth(paneScreen.getPrefWidth() * 0.8);
        nameScreen.setPrefHeight(paneScreen.getPrefHeight() * 0.3);
        final TextField numberScreen = new TextField();
        numberScreen.getProperties().put((Object)"vkType", (Object)1);
        numberScreen.setAlignment(Pos.CENTER);
        numberScreen.setPromptText("numero ecran");
        numberScreen.setPrefWidth(paneScreen.getPrefWidth() * 0.8);
        numberScreen.setPrefHeight(paneScreen.getPrefHeight() * 0.3);
        btnValid.setPrefWidth(paneScreen.getPrefWidth() * 0.8);
        btnValid.setPrefHeight(paneScreen.getPrefHeight() * 0.3);
        btnAdd.setPrefWidth(paneScreen.getPrefWidth() * 0.8);
        btnAdd.setPrefHeight(paneScreen.getPrefHeight() * 0.3);
        btnAdd.getStyleClass().add((Object)"bg-70c0c1");
        btnValid.getStyleClass().add((Object)"bg-70c0c1");
        btnAdd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                paneScreen.add((Node)numberScreen, 0, 0);
                paneScreen.add((Node)nameScreen, 0, 1);
                paneScreen.add((Node)btnValid, 0, 2);
            }
        });
        btnValid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LocalScreen localScreen = new LocalScreen();
                localScreen.setName(nameScreen.getText());
                localScreen.setNumber(Integer.parseInt(numberScreen.getText().isEmpty() ? "0" : numberScreen.getText()));
                ScreensController.this.addScreen(localScreen);
            }
        });
        paneScreen.add((Node)btnAdd, 0, 0);
        this.listPaneScreens.add(paneScreen);
        this.showScreens(this.listPaneScreens);
    }

    private void addScreen(LocalScreen localScreen) {
        this.mLocalScreenService.addScreen(localScreen);
        this.loadScreens();
    }

    private void deleteScreen(LocalScreen screen) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Vous voulez vraiment supprimer cet ecran ?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
        alert.showAndWait();
        if (alert.getResult() == ButtonType.YES) {
            try {
                this.mLocalScreenService.deleteScreen(screen);
                this.loadScreens();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Ecran supprim\u00e9", 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    private void showScreens(List<GridPane> items) {
        this.number_page_borne = (int)Math.ceil((double)items.size() / (double)(this.number_line * this.number_column));
        this.pane_bornes = new GridPane[this.number_page_borne];
        for (int i = 0; i < this.number_page_borne; ++i) {
            this.pane_bornes[i] = new GridPane();
            this.pane_bornes[i].setVgap(5.0);
            this.pane_bornes[i].setHgap(5.0);
            this.pane_bornes[i].setAlignment(Pos.CENTER);
            this.pane_bornes[i].getStyleClass().add((Object)"bg-white");
        }
        int index_borne = 0;
        int column_borne = 0;
        int row_borne = 0;
        for (GridPane paneItem : items) {
            this.pane_bornes[index_borne].add((Node)paneItem, column_borne, row_borne);
            if (column_borne < this.number_column - 1) {
                ++column_borne;
                continue;
            }
            if (row_borne < this.number_line - 1) {
                ++row_borne;
                column_borne = 0;
                continue;
            }
            ++index_borne;
            row_borne = 0;
            column_borne = 0;
        }
        this.pane_main.getChildren().clear();
        this.list_bornes.getChildren().clear();
        if (this.number_page_borne > 0) {
            this.page_borne = 0;
            this.list_bornes.add((Node)this.pane_bornes[this.page_borne], 0, 0);
            if (this.number_page_borne <= 1) {
                this.pane_main.add((Node)this.list_bornes, 0, 0);
            } else {
                this.pane_preview_borne.getChildren().clear();
                this.pane_next_borne.getChildren().clear();
                this.pane_next_borne.add((Node)this.btn_borne_next, 0, 0);
                this.pane_preview_borne.getChildren().clear();
                this.pane_main.add((Node)this.pane_preview_borne, 0, 0);
                this.pane_main.add((Node)this.list_bornes, 0, 1);
                this.pane_main.add((Node)this.pane_next_borne, 0, 2);
            }
        }
    }

    public void lastPaneBorne() {
        if (this.page_borne > 0) {
            --this.page_borne;
            this.list_bornes.getChildren().clear();
            this.list_bornes.add((Node)this.pane_bornes[this.page_borne], 0, 0);
            this.pane_next_borne.getChildren().clear();
            this.pane_next_borne.add((Node)this.btn_borne_next, 0, 0);
            if (this.page_borne == 0) {
                this.pane_preview_borne.getChildren().clear();
            } else {
                this.pane_preview_borne.getChildren().clear();
                this.pane_preview_borne.add((Node)this.btn_borne_previous, 0, 0);
            }
        }
    }

    public void nextPageBorne() {
        if (this.page_borne < this.number_page_borne - 1) {
            ++this.page_borne;
            this.list_bornes.getChildren().clear();
            this.list_bornes.add((Node)this.pane_bornes[this.page_borne], 0, 0);
            this.pane_preview_borne.getChildren().clear();
            this.pane_preview_borne.add((Node)this.btn_borne_previous, 0, 0);
            if (this.page_borne == this.number_page_borne - 1) {
                this.pane_next_borne.getChildren().clear();
            } else {
                this.pane_next_borne.getChildren().clear();
                this.pane_next_borne.add((Node)this.btn_borne_next, 0, 0);
            }
        }
    }

    public void reload() {
        this.loadScreens();
    }

    private void updateScreen(LocalScreen localScreen) {
        try {
            this.mLocalScreenService.updateScreen(localScreen);
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Ecran modifi\u00e9", 1500, NPosition.BOTTOM_RIGHT);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
        }
    }
}

