/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.HBoxCell;
import com.openbravo.components.OrderCell;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.events.CustomBasketListCell;
import com.openbravo.events.CustomOrderListCell;
import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.RusHourService;
import com.openbravo.service.TicketService;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.json.JSONObject;

public class RusHourOrderController
implements RootController {
    @FXML
    Label delais;
    @FXML
    Label num_order;
    @FXML
    Label name_customer;
    @FXML
    ListView listView_orders;
    @FXML
    ListView listView_items;
    @FXML
    GridPane pane_parent;
    @FXML
    GridPane pane_main;
    @FXML
    GridPane pane_message_load;
    @FXML
    GridPane pane_orders;
    @FXML
    GridPane pane_detail_order;
    @FXML
    GridPane pane_total;
    @FXML
    Label total_order;
    @FXML
    Label label_message;
    @FXML
    Label type_order_1;
    @FXML
    Label type_order_2;
    private RusHourService mRusHourService;
    private Stage mStage;
    private String id_order;
    private LinkedHashMap<String, TicketInfo> orders;
    private List<OrderCell> m_listOrders;
    private ObservableList observableListOrder;
    private List<HBoxCell> m_listItems;
    private ObservableList observableListItems;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private TicketInfo currentOrder;
    private TicketService mTicketService;
    private double height_detail_order;
    private ImageView imageNew;
    private JSONObject orderRusHour;

    public void initializer() {
        try {
            this.pane_parent.requestFocus();
            this.mRusHourService = RusHourService.getInstance();
            this.listView_items.setCellFactory(listView -> new CustomBasketListCell());
            this.listView_orders.setCellFactory(listView -> new CustomOrderListCell());
            this.observableListOrder = FXCollections.observableArrayList();
            this.m_listOrders = new ArrayList<OrderCell>();
            this.observableListItems = FXCollections.observableArrayList();
            this.m_listItems = new ArrayList<HBoxCell>();
            this.pane_main.getChildren().clear();
            this.label_message.setText("Chargement en cours ...");
            this.pane_main.add((Node)this.pane_message_load, 0, 0);
            this.height_detail_order = AppVarUtils.getScreenDimension().getHeight() * 0.8 * 0.84;
            this.pane_detail_order.getChildren().clear();
            this.pane_detail_order.add((Node)this.listView_items, 0, 0);
            this.imageNew = new ImageView(new Image(this.getClass().getResource("/com/openbravo/images/new.png").toURI().toString(), 25.0, 25.0, false, false));
            this.orders = new LinkedHashMap();
            this.getOrders();
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void getOrders() {
        System.out.println("+++++++++++++++++ start get orders uber eat");
        if (this.orderRusHour != null) {
            TicketInfo mTicketInfo = TicketInfoBuilder.create(null).objectOrder(this.orderRusHour).buildOrderRushour().toTicketInfo();
            this.orders.put(this.orderRusHour.getString("id"), mTicketInfo);
        }
        this.loadOrders();
        System.out.println("+++++++++++++++++ end get orders uber eat");
    }

    private void loadOrders() {
        System.out.println("++++++++++++ orders.isEmpty() : " + this.orders.isEmpty());
        if (this.orders.isEmpty()) {
            this.pane_main.getChildren().clear();
            this.label_message.setText("Aucune commande");
            this.pane_main.add((Node)this.pane_message_load, 0, 0);
            this.mRusHourService.sentInfoOrders(this.orders.size(), null);
        } else {
            String first_order = "";
            boolean index_first_order = false;
            if (this.listView_orders.getItems().isEmpty()) {
                this.listView_orders.getItems().clear();
            }
            if (!this.m_listOrders.isEmpty()) {
                this.m_listOrders.clear();
            }
            if (!this.observableListOrder.isEmpty()) {
                this.observableListOrder.clear();
            }
            for (String order_id : this.orders.keySet()) {
                if (first_order != null && first_order.isEmpty()) {
                    first_order = order_id;
                }
                TicketInfo order = this.orders.get(order_id);
                final OrderCell order_line = new OrderCell().orderId(order_id).order(order).build();
                order_line.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        RusHourOrderController.this.id_order = order_line.getOrderId();
                        RusHourOrderController.this.loadInfoOrder(order_line.getOrder());
                    }
                });
                this.m_listOrders.add(order_line);
            }
            this.observableListOrder.setAll(this.m_listOrders);
            this.listView_orders.setItems(this.observableListOrder);
            if (first_order != null && !first_order.isEmpty()) {
                this.id_order = first_order;
                this.loadInfoOrder(this.orders.get(this.id_order));
                this.listView_orders.getSelectionModel().selectFirst();
            } else {
                this.initOrder();
            }
            this.pane_main.getChildren().clear();
            this.pane_main.add((Node)this.pane_orders, 0, 0);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.mStage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.mStage = mStage;
        this.orderRusHour = (JSONObject)object;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.mStage = mStage;
        if (objects != null && objects.length > 0) {
            this.orderRusHour = (JSONObject)objects[0];
        }
        this.initializer();
    }

    public void exit() {
        this.mStage.close();
    }

    private void loadInfoOrder(TicketInfo order) {
        this.currentOrder = order;
        Date date_order = order.getDate();
        Date date_ready = order.getDelivered();
        if (date_ready != null) {
            long diff = date_ready.getTime() - date_order.getTime();
            String delais_order = String.valueOf(diff / 60000L) + "min";
            this.delais.setText(delais_order);
        } else {
            this.delais.setText("");
        }
        this.num_order.setText("N\u00b0" + order.getNumero_platform_order());
        this.name_customer.setText(order.getName_customer());
        this.loadItems(order);
        switch (order.getType()) {
            case "Uber Eats": {
                this.type_order_1.setText("Uber");
                this.type_order_2.setText("Eats");
                break;
            }
            case "Just Eat": {
                this.type_order_1.setText("Just");
                this.type_order_2.setText("Eat");
                break;
            }
            case "Delivero": {
                this.type_order_1.setText("Delivero");
                this.type_order_2.setText("");
                break;
            }
            case "Deliveroo": {
                this.type_order_1.setText("Deliveroo");
                this.type_order_2.setText("");
                break;
            }
            default: {
                this.type_order_1.setText("Rush");
                this.type_order_2.setText("Hour");
            }
        }
    }

    private void loadItems(TicketInfo order) {
        double total = order.getTotal() + order.getTotal_fee_ubereat() + order.getTax_ubereat();
        double height_lines = 0.0;
        double widthline = AppVarUtils.getScreenDimension().getWidth() * 0.8 * 0.29;
        if (this.listView_items.getItems().isEmpty()) {
            this.listView_items.getItems().clear();
        }
        if (!this.m_listItems.isEmpty()) {
            this.m_listItems.clear();
        }
        if (!this.observableListItems.isEmpty()) {
            this.observableListItems.clear();
        }
        for (TicketLineInfo item : order.getLines()) {
            HBoxCell item_line = new HBoxCell().item(item).widthline(widthline).buildLine();
            height_lines += item_line.getHeight();
            this.m_listItems.add(item_line);
        }
        if (order.getComment() != null && !order.getComment().isEmpty()) {
            HBoxCell comment_line = new HBoxCell().widthline(widthline).buildNote(order.getComment());
            height_lines += comment_line.getHeight();
            this.m_listItems.add(comment_line);
        }
        if (height_lines + 50.0 >= this.height_detail_order) {
            this.listView_items.setPrefHeight(this.height_detail_order * 0.85);
            this.pane_detail_order.getChildren().clear();
            this.pane_detail_order.add((Node)this.listView_items, 0, 0);
            this.pane_detail_order.add((Node)this.pane_total, 0, 1);
            this.total_order.setText(Formats.CURRENCY.formatValue(total));
        } else {
            this.listView_items.setPrefHeight(this.height_detail_order);
            HBoxCell item_total_order = new HBoxCell().widthline(widthline).total(total).buildLineTotal("Total");
            this.m_listItems.add(item_total_order);
            this.pane_detail_order.getChildren().clear();
            this.pane_detail_order.add((Node)this.listView_items, 0, 0);
        }
        this.observableListItems.setAll(this.m_listItems);
        this.listView_items.setItems(this.observableListItems);
    }

    public void addNewOrder(JSONObject order) {
        System.out.println("++++++++++++++ add new order");
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.pane_orders, 0, 0);
        TicketInfo ticket = TicketInfoBuilder.create(null).objectOrder(order).buildOrderRushour().toTicketInfo();
        String order_id = order.getString("id");
        this.orders.put(order_id, ticket);
        final OrderCell order_line = new OrderCell().orderId(order_id).order(ticket).imageNew(this.imageNew).build();
        order_line.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (order_line.getLabelNew() != null) {
                    order_line.getLabelNew().setGraphic(null);
                }
                RusHourOrderController.this.id_order = order_line.getOrderId();
                RusHourOrderController.this.loadInfoOrder(order_line.getOrder());
            }
        });
        this.m_listOrders.add(0, order_line);
        this.observableListOrder.add(0, (Object)order_line);
        if (this.orders.size() == 1) {
            this.id_order = order_id;
            this.loadInfoOrder(this.orders.get(this.id_order));
            this.listView_orders.getSelectionModel().selectFirst();
            this.listView_orders.setItems(this.observableListOrder);
        }
    }

    private void initOrder() {
        if (this.listView_items.getItems().isEmpty()) {
            this.listView_items.getItems().clear();
        }
        if (!this.m_listItems.isEmpty()) {
            this.m_listItems.clear();
        }
        if (!this.observableListItems.isEmpty()) {
            this.observableListItems.clear();
        }
        this.delais.setText("");
        this.num_order.setText("");
        this.name_customer.setText("");
    }

    private void encaisserOrder(TicketInfo ticket) {
        if (this.mTicketService == null) {
            this.mTicketService = TicketService.getInstance();
        }
        this.mTicketService.orderAttente(false, ticket, false, true, true, false, true, true);
    }

    public void validOrder() {
        TicketInfo ticket = (TicketInfo)this.currentOrder.clone();
        System.out.println("+++++++++++++++ ticket delivered : " + ticket.getDelivered());
        this.encaisserOrder(ticket);
        this.orders.clear();
        this.mRusHourService.sentInfoOrders(this.orders.size(), null);
        this.mStage.close();
    }
}

